;;;***************************************************************
;;;an acl2 library of floating point arithmetic

;;;david m. russinoff
;;;advanced micro devices, inc.
;;;february, 1998
;;;***************************************************************

(in-package "ACL2")

(include-book "log")
(include-book "float")

(local (defun nat-induct (k)
  (if (and (integerp k) (>= k 0))
      (if (= k 0)
	  0
	(nat-induct (1- k)))
    0)))

;integerp-expt was here

(local (defthm ahack1
    (implies (and (integerp m)
		  (integerp x)
		  (integerp k)
		  (>= m 0))
	     (integerp (+ x (* -1 (expt 2 m)) (* k (expt 2 m)))))
  :rule-classes ()))

(local (defthm ahack2
    (implies (and (integerp m)
		  (integerp x)
		  (integerp k)
		  (>= x 0)
		  (>= k 0)
		  (>= m 0))
	     (>= (+ x (* k (expt 2 m)))
                 0))
  :rule-classes ()))

(local (defthm ahack3
    (implies (and (integerp m)
		  (integerp x)
		  (integerp k)
		  (>= x 0)
		  (>= k 1)
		  (>= m 0))
	     (>= (+ x (* -1 (expt 2 m)) (* k (expt 2 m)))
                 0))
  :rule-classes ()
  :hints (("goal" :in-theory (disable a14)
		  :use ((:instance ahack2 (k (1- k))))))))

(defthm bit+*k
    (implies (and (integerp x)
		  (integerp n)
		  (integerp m)
		  (>= x 0)
		  (> m n)
		  (>= n 0)
		  (integerp k)
		  (>= k 0))
	     (equal (bitn (+ x (* k (expt 2 m))) n)
		    (bitn x n)))
  :rule-classes ()
  :hints (("goal" :induct (nat-induct k))
	  ("subgoal *1/2" :use ((:instance bit+-b (x (+ x (* (1- k) (expt 2 m)))))))
;;	  ("subgoal *1/2.2" :use (ahack1))  ;; RBK:
	  ("subgoal *1/2'''" :use (ahack3))))  ;; RBK:

(in-theory (disable mod
                    ))

(in-theory (enable bit-mod))




;rephrase and rename bitn-shift
(defthm bitn-n+k
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (>= n 0)
		  (integerp k)
		  (>= k 0))
	     (= (bitn (* x (expt 2 k)) (+ n k))
		(bitn x n)))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bitn-def)
		  :use ((:instance expo+ (m k))))))

(local (defthm mod-n+1-1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (< (/ (mod a (expt 2 (1+ n))) (expt 2 n))
		2))
  :rule-classes ()
  :hints (("goal" ;; :in-theory (disable *-weakly-monotonic)  ;; RBK: f-c and lin
		  :use ((:instance mod<n (m a) (n (expt 2  (1+ n))))

			(:instance *-weakly-monotonic 
				   (x (expt 2 n)) 
				   (y 2)
				   (y+ (/ (mod a (expt 2 (1+ n))) (expt 2 n)))))))))

(local (defthm mod-n+1-2
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (< (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n)))
		2))
  :rule-classes ()
  :hints (("goal" :use (mod-n+1-1)))))

(local (defthm mod-n+1-3
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (<= 0 (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod>=0 (m a) (n (expt 2 (1+ n))))
)))))

(local (defthm mod-n+1-4
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (or (= (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n))) 0)
		 (= (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n))) 1)))
  :rule-classes ()
  :hints (("goal" :use (mod-n+1-2
			mod-n+1-3)))))

(local (defthm mod-n+1-5
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (= (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n)))
		(mod (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n))) 2)))
  :rule-classes ()
  :hints (("goal" :use (mod-n+1-4)))))

(local (defthm mod-n+1-6
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (= (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n)))
		(bitn (mod a (expt 2 (1+ n))) n)))
  :rule-classes ()
  :hints (("goal" :use (mod-n+1-5
			(:instance mod>=0 (m a) (n (expt 2 (1+ n))))
			(:instance bitn-def (x (mod a (expt 2 (1+ n)))) (k n)))))))

(local (defthm mod-n+1-7
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (= (fl (/ (mod a (expt 2 (1+ n))) (expt 2 n)))
		(bitn a n)))
  :rule-classes ()
  :hints (("goal" :in-theory (disable bit-mod)
           :use (mod-n+1-6
			(:instance bit-mod (x a) (n (1+ n)) (k n))
                        )))))

(local (defthm mod-n+1-8
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (> n 0))
	     (= (mod (mod a (expt 2 (1+ n))) (expt 2 n))
		(mod a (expt 2 n))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-mod (x a) (a (1+ n)) (b n)))))))

(defthm mod-n+1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (> n 0))
	     (= (mod a (expt 2 (1+ n)))
		(+ (* (bitn a n) (expt 2 n))
		   (mod a (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :use (mod-n+1-8
			mod-n+1-7
			(:instance mod>=0 (m a) (n (expt 2 (1+ n))))
			(:instance mod-fl (m (mod a (expt 2 (1+ n)))) (n (expt 2 n)))))))

(defthm mod-n-n+1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (> n 0))
	     (iff (= (mod a (expt 2 (1+ n))) 0)
		  (and (= (mod a (expt 2 n)) 0)
		       (= (bitn a n) 0))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-n+1)
			(:instance mod>=0 (m a) (n (expt 2 n)))
			(:instance bitn-0-1 (x a))))))


(defthm bitn-0-logxor-+
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0))
	     (= (bitn (+ a b) 0)
		(bitn (logxor a b) 0)))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bitn-def)
		  :use ((:instance mod012 (x a))
			(:instance mod012 (x b))
			(:instance bitn-logxor (x a) (y b) (n 0))
			(:instance mod+mod (n 2))
			(:instance mod+mod (n 2) (a (mod b 2)) (b a))))))

(local (defthm mod-expo-1
         (implies (and (integerp x)
                       (> x 0))
                  (= (fl (/ x (expt 2 (expo x))))
                     1))
         :rule-classes ()
         :hints (("goal" ;; :in-theory (disable  *-weakly-monotonic)  ;; RBK: f-c and lin
                  :use (expo-upper-bound
			expo-lower-bound
			(:instance *-weakly-monotonic
				   (x (expt 2 (expo x)))
				   (y 2)
				   (y+ (* x (expt 2 (- (expo x))))))
			(:instance fl-unique (x (/ x (expt 2 (expo x)))) (n 1))
			(:instance expo-monotone (x 1) (y x)))))))


(defthm mod-expo
    (implies (and (integerp x)
		  (> x 0))
	     (= (mod x (expt 2 (expo x)))
		(- x (expt 2 (expo x)))))
  :rule-classes ()
  :hints (("goal" :use (mod-expo-1
			(:instance mod-fl (m x) (n (expt 2 (expo x))))
			(:instance expo-monotone (x 1) (y x))))))

;moved local-defthm to basic

#|
(defthm expt>=1
  (implies (and (integerp n)
                (>= n 0))
           (and (integerp (expt 2 n))
                (>= (expt 2 n) 1)))
  :rule-classes ()
  :hints (("goal" :use ((:instance expt-pos (x n))
			integerp-expt-type))))
|#

(local (include-book "arith"))

(local-defthm mod-comp1-1
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (integerp m)
		  (>= m n)
		  (< x (expt 2 m))
                  (< x (expt 2 n)) ;new
                  )
	     (= (comp1 x m)
		(+ (comp1 x n) (* (expt 2 n) (1- (expt 2 (- m n)))))))
  :rule-classes ()
  :hints (("goal"  :in-theory (enable comp1)
           :use ((:instance expo+ (m (- m n)))))))

(local-defthm mod-comp1-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (integerp m)
		  (>= m n)
		  (< x (expt 2 m))
                  (< x (expt 2 n)) ;new
                  )
	     (= (mod (comp1 x m) (expt 2 n))
		(mod (+ (comp1 x n) (* (expt 2 n) (1- (expt 2 (- m n))))) (expt 2 n))))
  :rule-classes ()
  :hints (("goal" :use (mod-comp1-1))))

(local-defthm mod-comp1-3
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (integerp m)
		  (>= m n)
		  (< x (expt 2 m)))
	     (= (mod (comp1 x m) (expt 2 n))
		(mod (comp1 (mod x (expt 2 n)) m) (expt 2 n))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable comp1)
           :use ((:instance mod-minus-mod (a (1- (expt 2 m))) (b x) (n (expt 2 n)))
			(:instance expt-monotone)
			(:instance comp1-bnds (n m))
			(:instance mod+-thm (m (comp1 x n)) (n (expt 2 n)) (a (1- (expt 2 (- m n)))))))))

(local (include-book "integerp"))

(local-defthm mod-comp1-4
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (integerp m)
		  (>= m n)
		  (< x (expt 2 n)))
	     (= (mod (comp1 x m) (expt 2 n))
		(mod (comp1 x n) (expt 2 n))))
  :rule-classes ()
  :hints (("goal" :use (mod-comp1-2
			(:instance expt-monotone)
			(:instance comp1-bnds (n m))
			(:instance mod+-thm (m (comp1 x n)) (n (expt 2 n)) (a (1- (expt 2 (- m n)))))))))

(local-defthm mod-comp1-5
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (integerp m)
		  (>= m n)
		  (< x (expt 2 m)))
	     (= (mod (comp1 x m) (expt 2 n))
		(mod (comp1 (mod x (expt 2 n)) n) (expt 2 n))))
  :rule-classes ()
  :hints (("goal" :use (mod-comp1-3
			(:instance mod-comp1-4 (x (mod x (expt 2 n))))
			(:instance mod<n (m x) (n (expt 2 n)))
			(:instance mod>=0 (m x) (n (expt 2 n)))))))

(defthm comp1-mod
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (integerp m)
		  (>= m n)
		  (< x (expt 2 m)))
	     (= (mod (comp1 x m) (expt 2 n))
		(comp1 (mod x (expt 2 n)) n)))
  :rule-classes ()
  :hints (("goal" :in-theory (enable comp1)
           :use (mod-comp1-5
			(:instance mod< (m (comp1 (mod x (expt 2 n)) n)) (n (expt 2 n)))
			(:instance mod<n (m x) (n (expt 2 n)))
			(:instance mod>=0 (m x) (n (expt 2 n)))))))


(local-defthm logxor-rewrite
    (implies (and (integerp n) (>= n 1)
		  (integerp x) (>= x 0) (< x (expt 2 n))
		  (integerp y) (>= y 0) (< y (expt 2 n)))
	     (= (logxor x y)
		(logior (logand x (comp1 y n))
			(logand y (comp1 x n)))))
  :rule-classes ())

(local-defthm mod-logxor-1
    (implies (and (integerp n) (>= n 1)
		  (integerp m) (>= m n)
		  (integerp x) (>= x 0) (< x (expt 2 m))
		  (integerp y) (>= y 0) (< y (expt 2 m)))
	     (= (mod (logxor x y) (expt 2 n))
		(logior (mod (logand x (comp1 y m)) (expt 2 n))
			(mod (logand y (comp1 x m)) (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance logxor-rewrite (n m))
			(:instance or-dist-d 
				   (x (logand x (comp1 y m)))
				   (y (logand y (comp1 x m))))
			(:instance logand-nat (i x) (j (comp1 y m)))
			(:instance logand-nat (i y) (j (comp1 x m)))))))

(defthm mod-logand
    (implies (and (integerp x) (>= x 0)
		  (integerp y) (>= y 0)
		  (integerp n) (> n 0))
	     (= (mod (logand x y) (expt 2 n))
		(logand (mod x (expt 2 n)) (mod y (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :use (and-dist-c
			(:instance and-dist-d (x (mod x (expt 2 n))))
			(:instance mod>=0 (m x) (n (expt 2 n)))
			(:instance mod<n (m x) (n (expt 2 n)))))))

(local-defthm mod-logxor-2
    (implies (and (integerp n) (>= n 1)
		  (integerp m) (>= m n)
		  (integerp x) (>= x 0) (< x (expt 2 m))
		  (integerp y) (>= y 0) (< y (expt 2 m)))
	     (= (mod (logxor x y) (expt 2 n))
		(logior (logand (mod x (expt 2 n))
				(mod (comp1 y m) (expt 2 n)))
			(logand (mod y (expt 2 n))
				(mod (comp1 x m) (expt 2 n))))))
  :rule-classes ()
  :hints (("goal" :use (mod-logxor-1
			(:instance mod-logand (y (comp1 y m)))
			(:instance mod-logand (x y) (y (comp1 x m)))))))

(local-defthm mod-logxor-3
    (implies (and (integerp n) (>= n 1)
		  (integerp m) (>= m n)
		  (integerp x) (>= x 0) (< x (expt 2 m))
		  (integerp y) (>= y 0) (< y (expt 2 m)))
	     (= (mod (logxor x y) (expt 2 n))
		(logior (logand (mod x (expt 2 n))
				(comp1 (mod y (expt 2 n)) n))
			(logand (mod y (expt 2 n))
				(comp1 (mod x (expt 2 n)) n)))))
  :rule-classes ()
  :hints (("goal" :in-theory (disable comp1)
		  :use (mod-logxor-2
			(:instance comp1-mod)
			(:instance comp1-mod (x y))))))

(local-defthm mod-logxor-4
    (implies (and (integerp n) (>= n 1)
		  (integerp m) (>= m n)
		  (integerp x) (>= x 0) (< x (expt 2 m))
		  (integerp y) (>= y 0) (< y (expt 2 m)))
	     (= (mod (logxor x y) (expt 2 n))
		(logxor (mod x (expt 2 n))
			(mod y (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :in-theory (disable comp1)
		  :use (mod-logxor-3
			(:instance logxor-rewrite (x (mod x (expt 2 n))) (y (mod y (expt 2 n))))
			(:instance mod>=0 (m x) (n (expt 2 n)))
			(:instance mod>=0 (m y) (n (expt 2 n)))
			(:instance mod<n (m x) (n (expt 2 n)))
			(:instance mod<n (m y) (n (expt 2 n)))))))

(defthm mod-logxor
    (implies (and (integerp n) (>= n 1)
		  (integerp x) (>= x 0)
		  (integerp y) (>= y 0))
	     (= (mod (logxor x y) (expt 2 n))
		(logxor (mod x (expt 2 n))
			(mod y (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-logxor-4 (m (max n (max (1+ (expo x)) (1+ (expo y))))))
			(:instance expo>= (n (max n (max (1+ (expo x)) (1+ (expo y))))))
			(:instance expo>= (n (max n (max (1+ (expo x)) (1+ (expo y))))) (x y))))))






(local-defthm bits-mod-0-1
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (>= m 0)
		  (integerp n)
		  (>= n 0))
	     (iff (= (mod x (expt 2 (+ m n 1))) 0)
		  (and (= (mod (fl (/ x (expt 2 n))) (expt 2 (1+ m))) 0)
		       (= (mod x (expt 2 n)) 0))))
  :rule-classes ()
  :hints (("goal" :use ((:instance fl-mod-5 (m x) (n (expt 2 n)) (p (expt 2 (1+ m))))))))

(defthm bits-mod-0
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (>= m 0)
		  (integerp n)
		  (>= n 0))
	     (iff (= (mod x (expt 2 (+ m n 1))) 0)
		  (and (= (bits x (+ m n) n) 0)
		       (= (mod x (expt 2 n)) 0))))
  :rule-classes ()
  :hints (("goal"  :use (bits-mod-0-1		 
			(:instance bit-bits-a (k n) (i (+ m n)) (j n))))))

(defthm bits-bitn
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0))
	     (iff (= (bits x n 0) 0)
		  (and (= (bitn x n) 0)
		       (= (bits x (1- n) 0) 0))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bitn-def (k n))
			(:instance fl-mod-5 (m x) (n (expt 2 n)) (p 2))))))

(local-defthm bits-bits-thm-1
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp r)
		  (>= r 0)
		  (integerp n)
		  (> n r)
		  (integerp m)
		  (> m n))
	     (= (bits x (1- m) r)
		(fl (/ (+ (mod (mod x (expt 2 m)) (expt 2 n))
			  (* (expt 2 n) (fl (/ (mod x (expt 2 m)) (expt 2 n)))))
		       (expt 2 r)))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bits)
		  :use ((:instance mod-fl (m (mod x (expt 2 m))) (n (expt 2 n)))
			(:instance mod>=0 (m x) (n (expt 2 m)))
			(:instance mod<n (m x) (n (expt 2 m)))))))

(local-defthm bits-bits-thm-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp r)
		  (>= r 0)
		  (integerp n)
		  (> n r)
		  (integerp m)
		  (> m n))
	     (= (bits x (1- m) r)
		(fl (/ (+ (mod x (expt 2 n))
			  (* (expt 2 n) (fl (/ (mod x (expt 2 m)) (expt 2 n)))))
		       (expt 2 r)))))
  :rule-classes ()
  :hints (("goal" :use (bits-bits-thm-1
			(:instance mod-mod (a m) (b n))))))

(local-defthm bits-bits-thm-3
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp r)
		  (>= r 0)
		  (integerp n)
		  (> n r)
		  (integerp m)
		  (> m n))
	     (= (bits x (1- m) r)
		(fl (+ (/ (mod x (expt 2 n)) (expt 2 r))
		       (* (expt 2 (- n r)) (fl (/ (mod x (expt 2 m)) (expt 2 n))))))))
  :rule-classes ()
  :hints (("goal" :use (bits-bits-thm-2
			(:instance expt- (a n) (b r)))
                  :in-theory (disable A10 FL+INT-REWRITE))))  ;; RBK:

(local-defthm bits-bits-thm-4
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp r)
		  (>= r 0)
		  (integerp n)
		  (> n r)
		  (integerp m)
		  (> m n))
	     (integerp (* (expt 2 (+ n (* -1 r)))
                                (fl (* (/ (expt 2 n))
                                       (mod x (* 2 (expt 2 (+ -1 m)))))))))
  :rule-classes ()
  :hints (("goal" :in-theory (disable expt-2-integerp)
		  :use ((:instance expt-2-integerp (i (- n r)))))))

(local-defthm bits-bits-thm-5
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp r)
		  (>= r 0)
		  (integerp n)
		  (> n r)
		  (integerp m)
		  (> m n))
	     (= (bits x (1- m) r)
		(+ (fl (/ (mod x (expt 2 n)) (expt 2 r)))
		   (* (expt 2 (- n r)) (fl (/ (mod x (expt 2 m)) (expt 2 n)))))))
  :rule-classes ()
  :hints (("goal" :in-theory (disable fl+int-rewrite a10)
		  :use (bits-bits-thm-4
			bits-bits-thm-3
			(:instance fl+int-rewrite
				   (x (/ (mod x (expt 2 n)) (expt 2 r)))
				   (n (* (expt 2 (- n r)) (fl (/ (mod x (expt 2 m)) (expt 2 n))))))))))

(defthm bits-bits-thm
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp r)
		  (>= r 0)
		  (integerp n)
		  (> n r)
		  (integerp m)
		  (> m n))
	     (= (bits x (1- m) r)
		(+ (bits x (1- n) r)
		   (* (expt 2 (- n r)) (bits x (1- m) n)))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bits)
		  :use (bits-bits-thm-5))))

(local-defthm bits+bitn-0
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0))
	     (= (bits x n 0)
		(+ (* (bitn x n) (expt 2 n))
		   (bits x (1- n) 0))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-n+1 (a x))))))

(local-defthm hack5
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp k)
		  (>= k 0)
		  (integerp r)
		  (>= r 0))
	     (equal (* x (/ (expt 2 k)) (/ (expt 2 r)))
		    (* x (/ (expt 2 (+ k r)))))))

(defthm bitn-fl
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp k)
		  (>= k 0)
		  (integerp r)
		  (>= r 0))
	     (= (bitn (fl (/ x (expt 2 r))) k)
		(bitn x (+ k r))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bitn-def (x (fl (/ x (expt 2 r)))))
			(:instance bitn-def (k (+ k r)))
			(:instance n<=fl-linear (n 0) (x (* x (expt 2 (- r)))))
			(:instance fl/int-rewrite (x (/ x (expt 2 r))) (n (expt 2 k)))))))

(defthm bits+bitn
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (>= m 0)
		  (integerp n)
		  (> n m))
	     (= (bits x n m)
		(+ (* (bitn x n) (expt 2 (- n m)))
		   (bits x (1- n) m))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-bits-a (i n) (j m) (k m))
			(:instance bits+bitn-0 (x (fl (/ x (expt 2 m)))) (n (- n m)))
			(:instance n<=fl-linear (n 0) (x (* x (expt 2 (- m)))))
			(:instance bit-bits-a (i (1- n)) (j m) (k m))
			(:instance bitn-fl (r m) (k (- n m)))))))
(local (include-book "logand"))
(defthm logand-2**n-1
  (implies (and (< i (expt 2 n))
                (<= 0 i)
                (case-split (integerp i))
                )
           (equal (logand i (1- (expt 2 n)))
                  i))
  :rule-classes ())



(local-defthm bitn+bits-1
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n m))
	     (= (+ (* (expt 2 (1+ m)) (bits x n (1+ m)))
		   (* (expt 2 m) (bitn x m)))
		(- (bits x n 0)
		   (bits x (1- m) 0))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bits-bits-thm (m (1+ n)) (r 0) (n (1+ m)))
			(:instance bits+bitn (n m) (m 0))))))

(local-defthm bitn+bits-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n m))
	     (= (* (expt 2 m)
		   (+ (* 2 (bits x n (1+ m)))
		      (bitn x m)))
		(- (bits x n 0)
		   (bits x (1- m) 0))))
  :rule-classes ()
  :hints (("goal" :use (bitn+bits-1
			(:instance expo+ (n 1))))))

(local-defthm bitn+bits-3
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n m))
	     (= (* (expt 2 m)
		   (+ (* 2 (bits x n (1+ m)))
		      (bitn x m)))
		(* (expt 2 m)
		   (bits x n m))))
  :rule-classes ()
  :hints (("goal" :use (bitn+bits-2
			(:instance bits-bits-thm (r 0) (m (1+ n)) (n m))))))

(local-defthm bitn+bits-4
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n m))
	     (= (* (expt 2 (- m))
		   (expt 2 m)
		   (+ (* 2 (bits x n (1+ m)))
		      (bitn x m)))
		(* (expt 2 (- m))
		   (expt 2 m)
		   (bits x n m))))
  :rule-classes ()
  :hints (("goal" :use (bitn+bits-3))))

(defthm bitn+bits
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n m))
	     (= (bits x n m)
		(+ (bitn x m)
		   (* 2 (bits x n (1+ m))))))
  :rule-classes ()
  :hints (("goal" :use (bitn+bits-4
			(:instance expo+ (n (- m)))))))

;moved expo-rnd and rnd-pos to rnd


(in-theory (disable bits))

(defthm bits+2**k-2
    (implies (and (integerp m)
		  (>= m 0)
		  (integerp n)
		  (>= n m)
		  (integerp k)
		  (>= k 0)
		  (<= k m)
		  (integerp y)
		  (>= y 0)
		  (integerp x)
		  (>= x 0)
		  (< x (expt 2 k)))
	     (= (bits (+ x (* y (expt 2 k))) n m)
		(bits y (- n k) (- m k))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-bits-a
				   (x (+ x (* y (expt 2 k))))
				   (i n)
				   (j m))
			(:instance fl-unique (x (/ (+ x (* y (expt 2 k))) (expt 2 k))) (n y))))))

(defthm bit+*k-2
    (implies (and (integerp x)
		  (integerp n)
		  (integerp m)
		  (< x (expt 2 m))
		  (>= x 0)
		  (<= m n)
		  (>= m 0)
		  (integerp k)
		  (>= k 0))
	     (equal (bitn (+ x (* k (expt 2 m))) n)
		    (bitn k (- n m))))
  :rule-classes ()
  :hints (("goal" :use ((:instance fl-unique (x (/ (+ x (* k (expt 2 m))) (expt 2 m))) (n k))
			(:instance bitn-fl 
				   (x (+ x (* k (expt 2 m))))
				   (r m)
				   (k (- n m)))))))



;moved away-minus, near-minus, inf-minus, minf-minus, flip, rnd-flip

;removed rnd-shift to rnd.lisp

;moved sticky-sticky stuff to sticky

;duplicate from trunc (may mess things below add up)
(defthm expt-inverse
    (implies (integerp n)
	     (equal (/ (expt 2 n))
		    (expt 2 (- n)))))

(local
(defthm bit-expo-c-1
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (<= (1- (expt 2 (- n k))) (/ x (expt 2 k))))
  :rule-classes ()
  :hints (("goal" :use ((:instance expo+ (m (- n k)) (n k))
			(:instance *-weakly-monotonic
				   (y (- (expt 2 n) (expt 2 k)))
				   (y+ x)
				   (x (/ (expt 2 k)))))))))


(local
(defthm bit-expo-c-2
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (< x (expt 2 n)))
	     (< (/ x (expt 2 k)) (expt 2 (- n k))))
  :rule-classes ()
  :hints (("goal" ;; :in-theory (disable *-strongly-monotonic)  ;; RBK: f-c and lin
		  :use ((:instance expo+ (m (- n k)) (n (- k)))
			(:instance *-strongly-monotonic
				   (y x)
				   (y+ (expt 2 n))
				   (x (/ (expt 2 k)))))))))

(local
(defthm bit-expo-c-3
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (< k n)
		  (< x (expt 2 n))
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (= (fl (/ x (expt 2 k)))
		(1- (expt 2 (- n k)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-expo-c-1)
			(:instance bit-expo-c-2)
			(:instance fl-unique (x (/ x (expt 2 k))) (n (1- (expt 2 (- n k))))))))))

(local
(defthm bit-expo-c-4
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (< k n)
		  (< x (expt 2 n))
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (= (fl (/ x (expt 2 k)))
		(1+ (* 2 (1- (expt 2 (1- (- n k))))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-expo-c-3))))))

(local
(defthm bit-expo-c-5
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (< k n)
		  (< x (expt 2 n))
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (= (mod (fl (/ x (expt 2 k))) 2)
		(mod 1 2)))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-expo-c-4)
			(:instance mod+-thm (m 1) (n 2) (a (1- (expt 2 (1- (- n k)))))))))))

(local
(defthm bit-expo-c-6
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (< k n)
		  (< x (expt 2 n))
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (= (mod (fl (/ x (expt 2 k))) 2)
		1))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-expo-c-5)
			(:instance mod< (m 1) (n 2)))))))

(defthm bit-expo-c
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= n 0)
		  (>= k 0)
		  (< k n)
		  (< x (expt 2 n))
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (equal (bitn x k) 1))
  :rule-classes ()
  :hints (("goal" :use ((:instance bitn-def)
			(:instance bit-expo-c-6)))))



(defthm bit-expo-d
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= k 0)
		  (< k n)
		  (< x (expt 2 n))
		  (<= (- (expt 2 n) (expt 2 k)) x))
	     (equal (bitn x k) 1))
  :rule-classes ()
  :hints (("goal" :use ((:instance bit-expo-c)
			(:instance expt-monotone (n k) (m n))))))

