(in-package "ACL2")

(include-book "merge4")

(defun setbits (x i j y)
  (cat (cat (ash x (- (1+ i)))
	    y
	    (1+ (- i j)))
       (bits x (1- j) 0)
       j))

(defmacro setbitn (x n y)
  `(setbits ,x ,n ,n ,y))

(in-theory (disable floor))

(defthm ash-rewrite
    (implies (integerp n)
	     (equal (ash n i)
		    (fl (* n (expt 2 i)))))
  :hints (("Goal" :in-theory (enable fl))))

(in-theory (disable ash))

(local (defthm natp-setbits-1
    (implies (and (natp x)
		  (natp i))
	     (natp (FL (* 1/2 X (EXPT 2 (* -1 I))))))
  :hints (("Goal" :in-theory (enable natp)))))

(defthm natp-
    (implies (and (natp x)
		  (natp y)
		  (>= x y))
	     (natp (+ x (* -1 y))))
  :hints (("Goal" :in-theory (enable natp))))

(in-theory (disable cat))

(defthm bits-setbits-1
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= j i)
		  (< k j)
		  (<= l k))
	     (equal (bits (setbits x i j y) k l)
		    (bits x k l))))

(local (defthm bits-setbits-2-1
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= k i)
		  (<= l k)
		  (<= j l)
		  (< 0 j))
	     (equal (bits (setbits x i j y) k l)
		    (bits y (- k j) (- l j))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp-bits)))))

(defthm bits-neg-1
    (implies (natp x)
	     (equal (bits x -1 0) 0))
  :hints (("Goal" :in-theory (enable bits))))

(defthm bits-
    (implies (and (natp x)
		  (natp i)
		  (natp j)
		  (< i j))
	     (equal (bits x i j) 0))
  :hints (("Goal" :in-theory (enable bits)
		  :use ((:instance expt-weak-monotone (n (1+ (- i j))) (m 0))
			(:instance rem-bnd-1 (m x) (n (expt 2 (1+ i))))
			(:instance *-strongly-monotonic (x (expt 2 (- j))) (y (rem x (expt 2 (1+ i)))) (y+ (expt 2 (1+ i))))
			(:instance expt+ (m (- j)) (n (1+ i)))))))

(local(defthm bits-setbits-2-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp k)
		  (natp l)
		  (<= k i)
		  (<= l k))
	     (equal (bits (setbits x i 0 y) k l)
		    (bits y k l)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp-bits)))))

(defthm bits-setbits-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= k i)
		  (<= l k)
		  (<= j l))
	     (equal (bits (setbits x i j y) k l)
		    (bits y (- k j) (- l j))))
  :hints (("Goal" :in-theory (disable setbits)
		  :use (bits-setbits-2-1
			bits-setbits-2-2))))

(local (defthm bits-setbits-3-1
    (implies (and (natp x)
		  (bvecp y (1+ (- i j)))
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= l k)
		  (< i l)
		  (<= j i)
		  (< 0 j))
	     (equal (bits (setbits x i j y) k l)
		    (bits x k l)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bvecp-bits)
		  :use ((:instance bits-shift-1 (k (1+ i)) (i (- k (1+ i))) (j (- l (1+ i)))))))))

(local (defthm bits-setbits-3-2
    (implies (and (natp x)
		  (bvecp y (1+ i))
		  (natp i)
		  (natp k)
		  (natp l)
		  (<= l k)
		  (< i l))
	     (equal (bits (setbits x i 0 y) k l)
		    (bits x k l)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bvecp-bits)
		  :use ((:instance bits-shift-1 (k (1+ i)) (i (- k (1+ i))) (j (- l (1+ i)))))))))

(defthm bits-setbits-3
    (implies (and (natp x)
		  (bvecp y (1+ (- i j)))
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= l k)
		  (< i l)
		  (<= j i))
	     (equal (bits (setbits x i j y) k l)
		    (bits x k l)))
  :hints (("Goal" :in-theory (disable setbits)
		  :use (bits-setbits-3-1
			bits-setbits-3-2))))

(defthm bvecp-shift
    (implies (and (bvecp x n)
		  (natp n)
		  (natp k)
		  (>= n k))
	     (bvecp (fl (/ x (expt 2 k))) (- n k)))
  :hints (("Goal" :in-theory (enable bvecp natp))))

(in-theory (disable bvecp-shift))

(local (defthm bvecp-setbits-1
    (implies (and (bvecp x n)
		  (natp n)
		  (bvecp y (1+ (- i j)))
		  (natp i)
		  (natp j)
		  (< i n)
		  (<= j i)
		  (> j 0))
	     (bvecp (setbits x i j y) n))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bvecp-shift (k (1+ i))))))))

(local (defthm bvecp-setbits-2
    (implies (and (bvecp x n)
		  (natp n)
		  (bvecp y (1+ i))
		  (natp i)
		  (< i n))
	     (bvecp (setbits x i 0 y) n))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bvecp-shift (k (1+ i)))
			(:instance cat (x y) (y 0) (n 0)))))))

(defthm bvecp-setbits
    (implies (and (bvecp x n)
		  (natp n)
		  (bvecp y (1+ (- i j)))
		  (natp i)
		  (natp j)
		  (< i n)
		  (<= j i))
	     (bvecp (setbits x i j y) n))
  :hints (("Goal" :use (bvecp-setbits-1
			bvecp-setbits-2))))

(local (in-theory (enable bits-shift-2)))

(defthm bitn-setbits-1
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (<= j i)
		  (< k j))
	     (equal (bitn (setbits x i j y) k)
		    (bitn x k))))

(defthm natp-setbits
    (implies (and (natp x)
		  (natp i)
		  (natp j)
		  (natp y))
	     (natp (setbits x i j y)))
  :hints (("Goal" :in-theory (enable cat))))

(in-theory (disable setbits bits-n-n-rewrite))

(defthm bitn-setbits-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (<= k i)
		  (<= j k))
	     (equal (bitn (setbits x i j y) k)
		    (bitn y (- k j))))
  :hints (("Goal" :use ((:instance bits-n-n-rewrite (x (setbits x i j y)) (n k))))
	  ("Goal'''" :in-theory (enable bits-n-n-rewrite))))

(defthm bitn-setbits-3
    (implies (and (natp x)
		  (bvecp y (1+ (- i j)))
		  (natp i)
		  (natp j)
		  (natp k)
		  (< i k)
		  (<= j i))
	     (equal (bitn (setbits x i j y) k)
		    (bitn x k)))
  :hints (("Goal" :use ((:instance bits-n-n-rewrite (x (setbits x i j y)) (n k))))
	  ("Goal'''" :in-theory (enable bits-n-n-rewrite))))

(local (defthm setbits-rewrite-1-1
    (implies (and (bvecp x n)
		  (natp n)
		  (natp i)
		  (natp j)
		  (< i (1- n))
		  (<= j i)
		  (bvecp y (1+ (- i j))))
	     (equal (setbits x i j y)
		    (cat (cat (bits x (1- n) (1+ i))
			      y
			      (1+ (- i j)))
			 (bits x (1- j) 0)
			 j)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp setbits)
		  :use ((:instance bvecp-shift (k (1+ i)))
			(:instance bits-shift-1 (i (- n (+ i 2))) (j 0) (k (1+ i))))))))

(local (defthm setbits-rewrite-1-2
    (implies (and (bvecp x n)
		  (natp n)
		  (natp i)
		  (>= i (1- n)))
	     (equal (FL (* 1/2 X (EXPT 2 (* -1 I))))
		    0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bvecp)
		  :use ((:instance expt-weak-monotone (n (- n (1+ i))) (m 0))
			(:instance fl-unique (x (* 1/2 X (EXPT 2 (* -1 I)))) (n 0))
			(:instance *-strongly-monotonic (x (expt 2 (- (1+ i)))) (y x) (y+ (expt 2 n)))
			(:instance expt+ (m (- (1+ i)))))))))

(local (defthm setbits-rewrite-1-3
    (implies (and (bvecp x n)
		  (natp n)
		  (> n 0)
		  (natp i)
		  (natp j)
		  (>= i (1- n))
		  (<= j i)
		  (bvecp y (1+ (- i j))))
	     (equal (setbits x i j y)
		    (cat (cat (bits x (1- n) (1+ i))
			      y
			      (1+ (- i j)))
			 (bits x (1- j) 0)
			 j)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bvecp setbits)
		  :use (setbits-rewrite-1-2)))))

(defthm setbits-rewrite-1
    (implies (and (bvecp x n)
		  (natp n)
		  (> n 0)
		  (natp i)
		  (natp j)
		  (<= j i)
		  (bvecp y (1+ (- i j))))
	     (equal (setbits x i j y)
		    (cat (cat (bits x (1- n) (1+ i))
			      y
			      (1+ (- i j)))
			 (bits x (1- j) 0)
			 j)))
  :hints (("Goal" :use (setbits-rewrite-1-1
			setbits-rewrite-1-3))))

(defthm setbits-rewrite-2
    (implies (and (bvecp x (1+ i))
		  (natp i)
		  (natp j)
		  (<= j i)
		  (bvecp y (1+ (- i j))))
	     (equal (setbits x i j y)
		    (cat y
			 (bits x (1- j) 0)
			 j))))

(defthm bvecp-expo
    (implies (natp x)
	     (bvecp x (1+ (expo x))))
  :hints (("Goal" :in-theory (enable natp bvecp )
		  :use (expo-upper-bound))))

(in-theory (disable bvecp-expo))

(defthm bits-setbits-4
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (<= k i)
		  (<= j k)
		  (< l j)
		  (bvecp y (1+ (- i j))))
	     (equal (bits (setbits x i j y) k l)
		    (cat (bits y (- k j) 0)
			 (bits x (1- j) l)
			 (- j l))))
  :hints (("Goal" :use (bvecp-expo
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ k))
				   (n j)
				   (r l))))
	  ("Goal'''" :in-theory (enable cat))))  ;; RBK:

(defthm bits-setbits-5
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (< i k)
		  (<= l i)
		  (<= j l)
		  (bvecp y (1+ (- i j))))
	     (equal (bits (setbits x i j y) k l)
		    (cat (bits x k (1+ i))
			 (bits y (- i j) (- l j))
			 (1+ (- i l)))))
  :hints (("Goal" :use (bvecp-expo
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ k))
				   (n (1+ i))
				   (r l))))
	  ("Goal'''" :in-theory (enable cat)
           :expand ((expt 2 (+ 1 i (* -1 l)))))))  ;; RBK:

(defthm bits-setbits-6
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (< i k)
		  (<= j i)
		  (< l j)
		  (bvecp y (1+ (- i j))))
	     (equal (bits (setbits x i j y) k l)
		    (cat (cat (bits x k (1+ i))
			      y
			      (1+ (- i j)))
			 (bits x (1- j) l)
			 (- j l))))
  :hints (("Goal" :use (bvecp-expo
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ k))
				   (n (1+ i))
				   (r l))
			(:instance bits-plus-bits
				   (x (setbits x i j y))
				   (m (1+ i))
				   (n j)
				   (r l))))
	  ("Goal'''" :in-theory (enable cat)
           :expand ((expt 2 (+ 1 i (* -1 l)))))))  ;; RBK:

(defthm bits-cat-3
    (implies (and (natp n)
		  (natp j)
		  (natp i)
		  (>= i n)
		  (> n j)
		  (natp x)
		  (bvecp y n))
	     (equal (bits (cat x y n) i j)
		    (cat (bits x (- i n) 0)
			 (bits y (1- n) j)
			 (- n j))))
  :hints (("Goal" :use ((:instance bits-plus-bits (x (cat x y n)) (m (1+ i)) (r j))))
	  ("Goal'''" :in-theory (enable cat))))  ;; RBK:

(defthm natp>=0
    (implies (natp x)
	     (>= x 0)))
