/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StreamTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BinaryStreamTranslator
extends StreamTranslator {
    protected BinaryStreamTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getStream(sQLParamController, structuredMem, structuredMem2);
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = null;
        if (this.isNull(sQLParamController, structuredMem)) {
            return 0;
        }
        byArray = this.getBytes(sQLParamController, structuredMem);
        return byArray[0];
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = this.getBinaryStream(sQLParamController, structuredMem, sQLParamController.getReplyData());
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = new byte[4096];
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                if (n >= 4096) {
                    n = inputStream.read(byArray);
                    continue;
                }
                break;
            }
        }
        catch (StreamIOException streamIOException) {
            throw streamIOException.getSqlException();
        }
        catch (IOException iOException) {
            throw new JDBCDriverException(iOException.getMessage(), sQLParamController);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = this.getBytes(sQLParamController, structuredMem);
        if (byArray == null) {
            byArray = null;
        }
        return byArray;
    }

    public Object transByteForInput(byte by) throws SQLException {
        byte[] byArray = new byte[]{by};
        return this.transBytesForInput(byArray);
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        return new Putval(byArray);
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        return this.transStreamForInput(inputStream, n);
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof InputStream) {
            object2 = this.transBinaryStreamForInput((InputStream)object, -1);
        }
        return object2;
    }
}

