/*
Copyright (C) 2010 Christian Kothe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "channelmaps.h"

static float map_stereo_ang[] = {-27,27};
static float map_stereo_xsf[] = {-1,1};
static float map_stereo_ysf[] = {1,1};
channel_id map_stereo_id[] = {ci_front_left,ci_front_right,ci_lfe};

static float map_stereo_lf[21][21] = {
   {0.89443f,0.88524f,0.87458f,0.86193f,0.84742f,0.83047f,0.81079f,0.78857f,0.76362f,0.73631f,0.70763f,0.67665f,0.64566f,0.61552f,0.58534f,0.55766f,0.53151f,0.50762f,0.48547f,0.46573f,0.44721f},
   {0.89755f,0.87472f,0.86612f,0.85527f,0.84283f,0.82769f,0.80772f,0.78219f,0.75429f,0.72489f,0.69458f,0.66356f,0.63344f,0.60389f,0.57501f,0.54892f,0.52695f,0.50759f,0.49065f,0.47592f,0.44112f},
   {0.90095f,0.88263f,0.86463f,0.85404f,0.84112f,0.81939f,0.79647f,0.77027f,0.74204f,0.71371f,0.68556f,0.65692f,0.62867f,0.60011f,0.57242f,0.54621f,0.52095f,0.50185f,0.48478f,0.46223f,0.4341f},
   {0.90493f,0.89124f,0.87451f,0.85436f,0.83602f,0.81484f,0.78982f,0.7639f,0.73649f,0.708f,0.67884f,0.64889f,0.61965f,0.5909f,0.56273f,0.53649f,0.51235f,0.49068f,0.46842f,0.44689f,0.42579f},
   {0.90935f,0.89967f,0.88515f,0.86118f,0.83546f,0.81421f,0.78928f,0.76394f,0.73562f,0.70473f,0.67234f,0.63865f,0.60548f,0.57409f,0.5446f,0.51768f,0.49394f,0.47308f,0.45005f,0.43044f,0.41628f},
   {0.91439f,0.90835f,0.8916f,0.87077f,0.84576f,0.81654f,0.79414f,0.76796f,0.738f,0.70338f,0.66454f,0.62424f,0.58439f,0.54783f,0.51607f,0.48945f,0.46806f,0.44967f,0.43169f,0.41295f,0.40509f},
   {0.91999f,0.91639f,0.90136f,0.88119f,0.85747f,0.82956f,0.79891f,0.77322f,0.74276f,0.70354f,0.65538f,0.60316f,0.55904f,0.52739f,0.50105f,0.46894f,0.43968f,0.41993f,0.40718f,0.39424f,0.39222f},
   {0.92644f,0.9241f,0.9116f,0.89398f,0.87092f,0.84203f,0.80896f,0.77654f,0.74815f,0.70562f,0.64332f,0.58646f,0.55102f,0.52708f,0.49359f,0.45559f,0.41942f,0.38954f,0.37761f,0.37267f,0.37675f},
   {0.93328f,0.93254f,0.92229f,0.90504f,0.88134f,0.85208f,0.81768f,0.7839f,0.74647f,0.70855f,0.63549f,0.58487f,0.56076f,0.52616f,0.49005f,0.44864f,0.40794f,0.36999f,0.34436f,0.34665f,0.35949f},
   {0.94079f,0.94125f,0.93189f,0.91311f,0.88749f,0.85631f,0.8194f,0.78057f,0.74338f,0.70163f,0.63671f,0.60162f,0.56723f,0.53186f,0.49174f,0.44781f,0.40347f,0.35901f,0.32088f,0.31729f,0.33938f},
   {0.94868f,0.94932f,0.94007f,0.9189f,0.88975f,0.85124f,0.80805f,0.75887f,0.71167f,0.67363f,0.64218f,0.61199f,0.5782f,0.54f,0.49837f,0.4526f,0.40118f,0.3514f,0.3043f,0.28639f,0.31623f},
   {0.95692f,0.95638f,0.94428f,0.91841f,0.8832f,0.83951f,0.7853f,0.73414f,0.69534f,0.66315f,0.63602f,0.61218f,0.58072f,0.54574f,0.50443f,0.45716f,0.40639f,0.35175f,0.29649f,0.26018f,0.29081f},
   {0.96498f,0.96276f,0.94676f,0.91627f,0.8745f,0.82172f,0.76172f,0.71817f,0.68426f,0.66051f,0.62994f,0.60192f,0.58139f,0.54844f,0.5103f,0.46277f,0.40965f,0.35109f,0.28981f,0.23919f,0.26285f},
   {0.97256f,0.96914f,0.94756f,0.91234f,0.86412f,0.80293f,0.74426f,0.70593f,0.68146f,0.65506f,0.62468f,0.59559f,0.57167f,0.55047f,0.51487f,0.46757f,0.41278f,0.35109f,0.2847f,0.21785f,0.23325f},
   {0.97977f,0.97551f,0.94873f,0.90549f,0.85129f,0.78757f,0.73384f,0.70417f,0.67727f,0.64923f,0.62014f,0.59112f,0.56478f,0.54094f,0.51536f,0.47061f,0.4185f,0.35479f,0.27753f,0.19394f,0.20077f},
   {0.9859f,0.97906f,0.94933f,0.90364f,0.84461f,0.7748f,0.73864f,0.70505f,0.6742f,0.64447f,0.61554f,0.5866f,0.55834f,0.53048f,0.50205f,0.47467f,0.41886f,0.35115f,0.27107f,0.18027f,0.16808f},
   {0.99106f,0.97904f,0.95594f,0.90263f,0.84046f,0.79665f,0.74764f,0.70961f,0.67426f,0.64169f,0.61091f,0.58092f,0.55049f,0.51961f,0.4893f,0.45375f,0.41836f,0.34667f,0.24954f,0.17965f,0.13422f},
   {0.99504f,0.97686f,0.94808f,0.90616f,0.87005f,0.82768f,0.77496f,0.72517f,0.68125f,0.64279f,0.60765f,0.5735f,0.53901f,0.50302f,0.46667f,0.42437f,0.38174f,0.33637f,0.26284f,0.18498f,0.10039f},
   {0.99787f,0.97282f,0.93896f,0.92728f,0.91154f,0.86712f,0.82157f,0.76586f,0.70571f,0.65384f,0.60893f,0.56563f,0.52269f,0.47746f,0.42876f,0.38009f,0.31978f,0.29601f,0.27766f,0.19432f,0.066244f},
   {0.99945f,0.96755f,0.9602f,0.94951f,0.93442f,0.91368f,0.87956f,0.82681f,0.76608f,0.70193f,0.63578f,0.56816f,0.50585f,0.44097f,0.37308f,0.31653f,0.27698f,0.24634f,0.22321f,0.20651f,0.033221f},
   {1.000000f,0.99854f,0.99377f,0.9845f,0.96987f,0.94832f,0.91914f,0.87965f,0.83195f,0.77384f,0.70711f,0.63203f,0.55339f,0.47409f,0.39234f,0.31565f,0.24192f,0.17365f,0.10973f,0.052336f,7.8496e-017f}};

static float map_stereo_rf[21][21] = {
   {0.44721f,0.46513f,0.48487f,0.50702f,0.53092f,0.55707f,0.58534f,0.61495f,0.64566f,0.67665f,0.70658f,0.73631f,0.76362f,0.78812f,0.81079f,0.83007f,0.84705f,0.86158f,0.87425f,0.88493f,0.89443f},
   {0.44091f,0.47587f,0.49021f,0.50752f,0.52648f,0.54843f,0.57451f,0.6034f,0.63295f,0.66338f,0.69439f,0.72464f,0.75386f,0.78179f,0.80734f,0.82734f,0.84251f,0.85523f,0.86585f,0.87468f,0.89745f},
   {0.43392f,0.46211f,0.48471f,0.50144f,0.52081f,0.54578f,0.57199f,0.59968f,0.62825f,0.65666f,0.68541f,0.71353f,0.74165f,0.76989f,0.79612f,0.81907f,0.84102f,0.85378f,0.86458f,0.88258f,0.90087f},
   {0.42556f,0.4465f,0.46827f,0.49061f,0.51198f,0.53606f,0.56263f,0.59061f,0.61925f,0.64863f,0.67871f,0.70782f,0.73615f,0.76373f,0.78979f,0.81451f,0.83582f,0.85431f,0.87445f,0.89102f,0.90482f},
   {0.41603f,0.43027f,0.44962f,0.47284f,0.49384f,0.51738f,0.54427f,0.57368f,0.6051f,0.63829f,0.67221f,0.7044f,0.7353f,0.76362f,0.78911f,0.81401f,0.83539f,0.86106f,0.88491f,0.8996f,0.90924f},
   {0.40482f,0.41257f,0.43125f,0.44919f,0.46765f,0.48935f,0.51575f,0.54739f,0.58411f,0.62399f,0.66441f,0.70314f,0.73778f,0.76766f,0.79398f,0.81646f,0.84558f,0.8705f,0.89137f,0.90817f,0.91428f},
   {0.39194f,0.39388f,0.40671f,0.41966f,0.43944f,0.46877f,0.50098f,0.52725f,0.55873f,0.60277f,0.65524f,0.70322f,0.74248f,0.77305f,0.79885f,0.8294f,0.85732f,0.88113f,0.90115f,0.91624f,0.91987f},
   {0.37644f,0.37227f,0.37711f,0.38933f,0.41907f,0.45539f,0.49353f,0.52703f,0.55093f,0.58615f,0.64317f,0.70533f,0.74803f,0.77648f,0.8089f,0.84182f,0.8707f,0.89389f,0.9114f,0.92394f,0.92631f},
   {0.35915f,0.34622f,0.34393f,0.36975f,0.40779f,0.44861f,0.48988f,0.52622f,0.56072f,0.58475f,0.63541f,0.70834f,0.74642f,0.78388f,0.81756f,0.85205f,0.88119f,0.90487f,0.92211f,0.93239f,0.93315f},
   {0.339f,0.31682f,0.32073f,0.35905f,0.40342f,0.44785f,0.4917f,0.53187f,0.56716f,0.60159f,0.63667f,0.70158f,0.7434f,0.78057f,0.81937f,0.85635f,0.88742f,0.91312f,0.93183f,0.94111f,0.94065f},
   {0.31623f,0.28631f,0.30427f,0.3514f,0.40119f,0.45261f,0.49838f,0.54f,0.5782f,0.61199f,0.64217f,0.67362f,0.71167f,0.75889f,0.80807f,0.85125f,0.88977f,0.91889f,0.94006f,0.9493f,0.94868f},
   {0.29034f,0.25984f,0.29645f,0.35181f,0.40636f,0.45739f,0.5045f,0.54571f,0.58075f,0.61218f,0.63603f,0.66314f,0.69534f,0.73428f,0.78552f,0.83978f,0.8833f,0.91845f,0.94425f,0.95628f,0.95678f},
   {0.26232f,0.23897f,0.28988f,0.35116f,0.40968f,0.46304f,0.51041f,0.54855f,0.58139f,0.60193f,0.62996f,0.66062f,0.68426f,0.71834f,0.76187f,0.82209f,0.87469f,0.91637f,0.94679f,0.96269f,0.96484f},
   {0.23266f,0.21746f,0.28484f,0.3513f,0.41299f,0.46772f,0.51511f,0.55049f,0.57186f,0.59573f,0.6247f,0.65513f,0.68168f,0.70596f,0.74457f,0.80329f,0.86436f,0.91252f,0.94764f,0.96907f,0.97242f},
   {0.20011f,0.19377f,0.27774f,0.3551f,0.41877f,0.47085f,0.51539f,0.54113f,0.56487f,0.59129f,0.62017f,0.64943f,0.67749f,0.70442f,0.73389f,0.78798f,0.85164f,0.90576f,0.94884f,0.97545f,0.97964f},
   {0.16735f,0.18021f,0.2713f,0.35149f,0.41919f,0.47472f,0.50234f,0.53073f,0.5586f,0.58686f,0.61556f,0.64474f,0.6745f,0.70534f,0.73902f,0.77487f,0.84502f,0.90392f,0.94947f,0.97903f,0.98577f},
   {0.13341f,0.17975f,0.24983f,0.34704f,0.41842f,0.45412f,0.48964f,0.5198f,0.5508f,0.58122f,0.61094f,0.6419f,0.6745f,0.71002f,0.74813f,0.79718f,0.84054f,0.90295f,0.9561f,0.97906f,0.99095f},
   {0.099504f,0.18519f,0.2632f,0.33642f,0.38219f,0.42465f,0.46712f,0.50346f,0.53941f,0.57392f,0.60769f,0.64324f,0.68168f,0.72574f,0.77558f,0.82818f,0.87048f,0.90621f,0.94829f,0.97694f,0.99495f},
   {0.065281f,0.19467f,0.27771f,0.29655f,0.32038f,0.38061f,0.42917f,0.47786f,0.52322f,0.56623f,0.609f,0.6545f,0.70642f,0.76654f,0.82216f,0.8676f,0.91195f,0.92761f,0.93899f,0.97296f,0.9978f},
   {0.032183f,0.20655f,0.22377f,0.24703f,0.27778f,0.31734f,0.37412f,0.44199f,0.50657f,0.5692f,0.63593f,0.70292f,0.7669f,0.82752f,0.88018f,0.91412f,0.93482f,0.94983f,0.96045f,0.96758f,0.99942f},
   {7.8496e-017f,0.054079f,0.11147f,0.17537f,0.24362f,0.3173f,0.39394f,0.47562f,0.55484f,0.63338f,0.70711f,0.77494f,0.83292f,0.88048f,0.91982f,0.94888f,0.9703f,0.98481f,0.99396f,0.99863f,1.000000f}};

static float map_3stereo_ang[] = {-27,0,27};
static float map_3stereo_xsf[] = {-1,0,1};
static float map_3stereo_ysf[] = {1,1,1};
channel_id map_3stereo_id[] = {ci_front_left,ci_front_center,ci_front_right,ci_lfe};

static float map_3stereo_lf[21][21] = {
   {0.89443f,0.88524f,0.87458f,0.86193f,0.84742f,0.83047f,0.81079f,0.78857f,0.76362f,0.73631f,0.70763f,0.67665f,0.64566f,0.61552f,0.58534f,0.55766f,0.53151f,0.50762f,0.48547f,0.46573f,0.44721f},
   {0.89755f,0.87472f,0.86612f,0.85527f,0.84283f,0.82769f,0.80772f,0.78219f,0.75429f,0.72489f,0.69458f,0.66356f,0.63344f,0.60389f,0.57501f,0.54892f,0.52695f,0.50759f,0.49065f,0.47592f,0.44112f},
   {0.90095f,0.88263f,0.86463f,0.85404f,0.84112f,0.81939f,0.79647f,0.77027f,0.74204f,0.71371f,0.68556f,0.65692f,0.62867f,0.60011f,0.57242f,0.54621f,0.52095f,0.50185f,0.48478f,0.46223f,0.4341f},
   {0.90493f,0.89124f,0.87451f,0.85436f,0.83602f,0.81484f,0.78982f,0.7639f,0.73649f,0.708f,0.67884f,0.64889f,0.61965f,0.5909f,0.56273f,0.53649f,0.51235f,0.49068f,0.46842f,0.44689f,0.42579f},
   {0.90935f,0.89967f,0.88515f,0.86118f,0.83546f,0.81421f,0.78928f,0.76394f,0.73562f,0.70473f,0.67234f,0.63865f,0.60548f,0.57409f,0.5446f,0.51768f,0.49394f,0.47308f,0.45005f,0.43044f,0.41628f},
   {0.91439f,0.90835f,0.8916f,0.87077f,0.84576f,0.81518f,0.79369f,0.76796f,0.738f,0.70338f,0.66454f,0.62424f,0.58439f,0.54783f,0.51565f,0.4881f,0.46806f,0.44967f,0.43169f,0.41295f,0.40509f},
   {0.91999f,0.91639f,0.90136f,0.88119f,0.85355f,0.8186f,0.78112f,0.76071f,0.73829f,0.70353f,0.65538f,0.60316f,0.55465f,0.51501f,0.48328f,0.45812f,0.43585f,0.41993f,0.40718f,0.39424f,0.39222f},
   {0.92644f,0.9241f,0.9116f,0.89f,0.85377f,0.81069f,0.76541f,0.7303f,0.7187f,0.69523f,0.64332f,0.57619f,0.52176f,0.48087f,0.45029f,0.42447f,0.40245f,0.38564f,0.37761f,0.37267f,0.37675f},
   {0.93328f,0.93254f,0.92093f,0.88634f,0.84024f,0.79035f,0.73915f,0.70069f,0.66895f,0.6652f,0.62331f,0.54173f,0.48327f,0.44319f,0.41176f,0.3872f,0.36711f,0.3515f,0.34305f,0.34665f,0.35949f},
   {0.94079f,0.94125f,0.92008f,0.87107f,0.81395f,0.7575f,0.70837f,0.66767f,0.63574f,0.60719f,0.59167f,0.50719f,0.45964f,0.41911f,0.38086f,0.34928f,0.33027f,0.31726f,0.30924f,0.31729f,0.33938f},
   {0.94868f,0.94932f,0.9126f,0.85036f,0.78307f,0.72405f,0.67715f,0.63551f,0.59982f,0.57195f,0.54754f,0.51032f,0.46636f,0.41664f,0.36748f,0.32545f,0.29456f,0.28293f,0.27687f,0.28639f,0.31623f},
   {0.95692f,0.95187f,0.89454f,0.81737f,0.74837f,0.69462f,0.64771f,0.60983f,0.58191f,0.55959f,0.5322f,0.50861f,0.46733f,0.4214f,0.36688f,0.31239f,0.27177f,0.25115f,0.24711f,0.25581f,0.29081f},
   {0.96498f,0.95059f,0.87624f,0.78828f,0.7202f,0.66666f,0.62184f,0.59103f,0.56775f,0.54605f,0.51575f,0.48743f,0.46487f,0.42131f,0.37046f,0.30776f,0.25551f,0.22343f,0.21973f,0.22723f,0.26285f},
   {0.97256f,0.95078f,0.85739f,0.7628f,0.69489f,0.64157f,0.60083f,0.57487f,0.55358f,0.52906f,0.49872f,0.46963f,0.44379f,0.41939f,0.37144f,0.30618f,0.24378f,0.20193f,0.195f,0.19978f,0.23325f},
   {0.97977f,0.95292f,0.84165f,0.73647f,0.66998f,0.61976f,0.58405f,0.56013f,0.5361f,0.50957f,0.48088f,0.45142f,0.42358f,0.39691f,0.36556f,0.3028f,0.23733f,0.18612f,0.17099f,0.17167f,0.20077f},
   {0.9859f,0.9429f,0.82529f,0.71935f,0.65073f,0.60004f,0.57026f,0.54247f,0.51553f,0.48797f,0.45981f,0.4301f,0.39967f,0.36796f,0.33369f,0.2999f,0.22511f,0.16724f,0.14764f,0.14455f,0.16808f},
   {0.99106f,0.92029f,0.82792f,0.70355f,0.63405f,0.59419f,0.55582f,0.52345f,0.4933f,0.4638f,0.43247f,0.40308f,0.36959f,0.33341f,0.29749f,0.25133f,0.21195f,0.14799f,0.12217f,0.12145f,0.13422f},
   {0.99504f,0.89296f,0.7903f,0.69419f,0.64012f,0.59235f,0.54648f,0.50481f,0.46838f,0.43448f,0.39875f,0.3652f,0.32622f,0.28267f,0.23822f,0.18912f,0.15212f,0.12446f,0.10578f,0.10172f,0.10039f},
   {0.99787f,0.86251f,0.75271f,0.71164f,0.66604f,0.59703f,0.5415f,0.48914f,0.43949f,0.39493f,0.34939f,0.30672f,0.25639f,0.20073f,0.14885f,0.11031f,0.074927f,0.081099f,0.091522f,0.084744f,0.066244f},
   {0.99945f,0.83163f,0.7944f,0.74743f,0.68883f,0.61889f,0.53808f,0.46304f,0.39791f,0.3335f,0.26339f,0.19986f,0.13786f,0.07777f,0.032427f,0.022634f,0.032465f,0.045267f,0.058324f,0.070706f,0.033221f},
   {1.000000f,0.94446f,0.8823f,0.80914f,0.72626f,0.63102f,0.52519f,0.40402f,0.27711f,0.14046f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,7.8496e-017f}};

static float map_3stereo_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.001914f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.0155f,0.025167f,0.017695f,0.0063155f,1.0116e-005f,0.000000f,0.000000f,0.0062031f,0.017508f,0.025125f,0.015305f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0056317f,0.024256f,0.044322f,0.061583f,0.065405f,0.041656f,0.014688f,0.000000f,0.014527f,0.041389f,0.065342f,0.061236f,0.044002f,0.024003f,0.005504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0019274f,0.02644f,0.05812f,0.08731f,0.11105f,0.11767f,0.10963f,0.061306f,0.017226f,0.061006f,0.10958f,0.11735f,0.11066f,0.086884f,0.057744f,0.026151f,0.0018503f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016697f,0.059451f,0.104f,0.13974f,0.15702f,0.15962f,0.15223f,0.13355f,0.063692f,0.13353f,0.15211f,0.15945f,0.15675f,0.13934f,0.10352f,0.059047f,0.016456f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.038851f,0.096919f,0.15087f,0.17987f,0.18511f,0.17445f,0.15817f,0.14379f,0.13384f,0.14378f,0.15816f,0.17444f,0.18509f,0.17981f,0.15076f,0.096821f,0.038797f,0.000000f,0.000000f},
   {0.000000f,0.0063777f,0.070344f,0.14288f,0.19068f,0.2049f,0.19453f,0.1758f,0.16036f,0.14645f,0.14681f,0.14646f,0.16036f,0.1758f,0.19453f,0.20473f,0.19031f,0.14227f,0.06984f,0.0061903f,0.000000f},
   {0.000000f,0.017224f,0.099719f,0.18101f,0.21822f,0.2193f,0.19777f,0.17979f,0.16475f,0.16187f,0.16149f,0.16187f,0.16477f,0.1798f,0.19777f,0.21922f,0.21792f,0.18045f,0.099116f,0.016918f,0.000000f},
   {0.000000f,0.02596f,0.12753f,0.21148f,0.23925f,0.22819f,0.20284f,0.18535f,0.18085f,0.17814f,0.17812f,0.17814f,0.18084f,0.18536f,0.20284f,0.22818f,0.23901f,0.21095f,0.12685f,0.025562f,0.000000f},
   {0.000000f,0.03194f,0.15144f,0.23904f,0.2564f,0.23733f,0.21182f,0.20371f,0.19964f,0.19751f,0.19694f,0.1975f,0.19963f,0.20369f,0.21184f,0.23733f,0.25621f,0.23853f,0.15068f,0.031485f,0.000000f},
   {0.000000f,0.051138f,0.17541f,0.26062f,0.27419f,0.24713f,0.23812f,0.22985f,0.2244f,0.22133f,0.22022f,0.22132f,0.22439f,0.22984f,0.2381f,0.24715f,0.274f,0.26009f,0.17455f,0.050511f,0.000000f},
   {0.000000f,0.08308f,0.18105f,0.28155f,0.29188f,0.28632f,0.27128f,0.26327f,0.25585f,0.25151f,0.25234f,0.2515f,0.25584f,0.26325f,0.27127f,0.28627f,0.29189f,0.28098f,0.18013f,0.082312f,0.000000f},
   {0.000000f,0.11865f,0.22314f,0.29977f,0.32517f,0.33282f,0.32312f,0.31164f,0.30095f,0.2946f,0.29542f,0.29459f,0.30094f,0.31163f,0.32308f,0.33259f,0.32473f,0.29967f,0.22211f,0.11774f,0.000000f},
   {0.000000f,0.15601f,0.26339f,0.30497f,0.3472f,0.38198f,0.39609f,0.39135f,0.3765f,0.36616f,0.36703f,0.36615f,0.37649f,0.39123f,0.39574f,0.3814f,0.34627f,0.30393f,0.26322f,0.15497f,0.000000f},
   {0.000000f,0.19222f,0.23448f,0.28578f,0.34732f,0.4169f,0.48293f,0.51439f,0.52067f,0.52104f,0.52661f,0.52086f,0.52026f,0.51365f,0.48176f,0.41543f,0.34579f,0.28436f,0.23319f,0.19202f,0.000000f},
   {0.000000f,0.076479f,0.15764f,0.24801f,0.34452f,0.44874f,0.55712f,0.67263f,0.78467f,0.89574f,1.000000f,0.89382f,0.78261f,0.67046f,0.55485f,0.4464f,0.34213f,0.24558f,0.15519f,0.074014f,0.000000f}};

static float map_3stereo_rf[21][21] = {
   {0.44721f,0.46513f,0.48487f,0.50702f,0.53092f,0.55707f,0.58534f,0.61495f,0.64566f,0.67665f,0.70658f,0.73631f,0.76362f,0.78812f,0.81079f,0.83007f,0.84705f,0.86158f,0.87425f,0.88493f,0.89443f},
   {0.44091f,0.47587f,0.49021f,0.50752f,0.52648f,0.54843f,0.57451f,0.6034f,0.63295f,0.66338f,0.69439f,0.72464f,0.75386f,0.78179f,0.80734f,0.82734f,0.84251f,0.85523f,0.86585f,0.87468f,0.89745f},
   {0.43392f,0.46211f,0.48471f,0.50144f,0.52081f,0.54578f,0.57199f,0.59968f,0.62825f,0.65666f,0.68541f,0.71353f,0.74165f,0.76989f,0.79612f,0.81907f,0.84102f,0.85378f,0.86458f,0.88258f,0.90087f},
   {0.42556f,0.4465f,0.46827f,0.49061f,0.51198f,0.53606f,0.56263f,0.59061f,0.61925f,0.64863f,0.67871f,0.70782f,0.73615f,0.76373f,0.78979f,0.81451f,0.83582f,0.85431f,0.87445f,0.89102f,0.90482f},
   {0.41603f,0.43027f,0.44962f,0.47284f,0.49384f,0.51738f,0.54427f,0.57368f,0.6051f,0.63829f,0.67221f,0.7044f,0.7353f,0.76362f,0.78911f,0.81401f,0.83539f,0.86106f,0.88491f,0.8996f,0.90924f},
   {0.40482f,0.41257f,0.43125f,0.44919f,0.46765f,0.48799f,0.5153f,0.54739f,0.58411f,0.62399f,0.66441f,0.70314f,0.73778f,0.76766f,0.79356f,0.81511f,0.84558f,0.8705f,0.89137f,0.90817f,0.91428f},
   {0.39194f,0.39388f,0.40671f,0.41966f,0.43552f,0.45781f,0.48319f,0.51474f,0.55427f,0.60276f,0.65524f,0.70322f,0.73809f,0.76067f,0.78108f,0.81857f,0.85349f,0.88113f,0.90115f,0.91624f,0.91987f},
   {0.37644f,0.37227f,0.37711f,0.38534f,0.40191f,0.42405f,0.44998f,0.48078f,0.52148f,0.57577f,0.64317f,0.69506f,0.71877f,0.73028f,0.7656f,0.81071f,0.85373f,0.89f,0.9114f,0.92394f,0.92631f},
   {0.35915f,0.34622f,0.34257f,0.35105f,0.36669f,0.38687f,0.41135f,0.44301f,0.4832f,0.5414f,0.62323f,0.6652f,0.66894f,0.70091f,0.73933f,0.79062f,0.84036f,0.88638f,0.9208f,0.93239f,0.93315f},
   {0.339f,0.31682f,0.30893f,0.31701f,0.32988f,0.34904f,0.38067f,0.41902f,0.45952f,0.50715f,0.59164f,0.60716f,0.63586f,0.66782f,0.70855f,0.75782f,0.81423f,0.87136f,0.9202f,0.94111f,0.94065f},
   {0.31623f,0.28631f,0.2768f,0.28287f,0.29451f,0.32542f,0.36748f,0.41665f,0.46636f,0.51031f,0.54754f,0.57195f,0.59984f,0.63554f,0.6772f,0.72411f,0.78316f,0.85044f,0.91263f,0.9493f,0.94868f},
   {0.29034f,0.25533f,0.24671f,0.25078f,0.27153f,0.3125f,0.36697f,0.4214f,0.46737f,0.50862f,0.53222f,0.55958f,0.58195f,0.60999f,0.64797f,0.69502f,0.74875f,0.81785f,0.89487f,0.9519f,0.95678f},
   {0.26232f,0.22679f,0.21937f,0.22317f,0.25538f,0.30797f,0.37058f,0.42141f,0.4649f,0.48746f,0.51577f,0.54618f,0.56776f,0.59121f,0.62202f,0.66708f,0.72062f,0.7888f,0.8767f,0.95072f,0.96484f},
   {0.23266f,0.1991f,0.19467f,0.20176f,0.24384f,0.30636f,0.37168f,0.41943f,0.44398f,0.46977f,0.49875f,0.52917f,0.5538f,0.57489f,0.60114f,0.64195f,0.69535f,0.76336f,0.85794f,0.95099f,0.97242f},
   {0.20011f,0.17119f,0.17065f,0.18608f,0.23747f,0.30303f,0.36561f,0.39709f,0.4237f,0.45162f,0.48091f,0.50979f,0.53634f,0.56039f,0.5841f,0.62016f,0.67047f,0.73709f,0.8423f,0.95319f,0.97964f},
   {0.16735f,0.14405f,0.14727f,0.1672f,0.22531f,0.29997f,0.33396f,0.36822f,0.39992f,0.43035f,0.45985f,0.48824f,0.51583f,0.54282f,0.57066f,0.60011f,0.65128f,0.72001f,0.82604f,0.94331f,0.98577f},
   {0.13341f,0.121f,0.12181f,0.14796f,0.21203f,0.25166f,0.29782f,0.33365f,0.36991f,0.4034f,0.43252f,0.46407f,0.4936f,0.52389f,0.55631f,0.59475f,0.63415f,0.70427f,0.82873f,0.92086f,0.99095f},
   {0.099504f,0.1013f,0.10541f,0.12445f,0.15226f,0.18931f,0.23864f,0.2831f,0.32663f,0.36561f,0.39881f,0.43494f,0.46889f,0.50538f,0.54712f,0.59303f,0.64086f,0.69432f,0.79124f,0.89368f,0.99495f},
   {0.065281f,0.084354f,0.091461f,0.080905f,0.074866f,0.11051f,0.14909f,0.20114f,0.25699f,0.30731f,0.34947f,0.39559f,0.44023f,0.48995f,0.54236f,0.59795f,0.6671f,0.7127f,0.75287f,0.86338f,0.9978f},
   {0.032183f,0.070629f,0.057967f,0.044948f,0.032184f,0.022549f,0.032636f,0.078282f,0.13841f,0.20077f,0.26356f,0.33461f,0.39907f,0.46431f,0.53952f,0.62043f,0.69031f,0.74875f,0.79556f,0.83182f,0.99942f},
   {7.8496e-017f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.14292f,0.27953f,0.40639f,0.52748f,0.63323f,0.72837f,0.81116f,0.88423f,0.94629f,1.000000f}};

static float map_5stereo_ang[] = {-45,-22,0,22,45};
static float map_5stereo_xsf[] = {-1,-0.5,0,0.5,1};
static float map_5stereo_ysf[] = {1,1,1,1,1};
channel_id map_5stereo_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_lfe};

static float map_5stereo_lf[21][21] = {
   {0.89443f,0.88524f,0.87458f,0.86193f,0.84742f,0.83047f,0.81079f,0.78857f,0.76362f,0.73631f,0.70763f,0.67665f,0.64566f,0.61552f,0.58534f,0.55766f,0.53151f,0.50762f,0.48547f,0.46573f,0.44721f},
   {0.89755f,0.87472f,0.86612f,0.85527f,0.84283f,0.82769f,0.80772f,0.78219f,0.75429f,0.72489f,0.69458f,0.66356f,0.63344f,0.60389f,0.57501f,0.54892f,0.52695f,0.50759f,0.49065f,0.47592f,0.44112f},
   {0.90095f,0.88263f,0.86463f,0.85404f,0.84112f,0.81939f,0.79647f,0.77027f,0.74204f,0.71371f,0.68556f,0.65692f,0.62867f,0.60011f,0.57242f,0.54621f,0.52095f,0.50185f,0.48478f,0.46223f,0.4341f},
   {0.90493f,0.89124f,0.87451f,0.85436f,0.83602f,0.81484f,0.78982f,0.7639f,0.73649f,0.708f,0.67884f,0.64889f,0.61965f,0.5909f,0.56273f,0.53649f,0.51235f,0.49068f,0.46842f,0.44689f,0.42579f},
   {0.90935f,0.89967f,0.88515f,0.86118f,0.83546f,0.81421f,0.78928f,0.76394f,0.73562f,0.70473f,0.67234f,0.63865f,0.60548f,0.57409f,0.5446f,0.51768f,0.49394f,0.47308f,0.45005f,0.43044f,0.41628f},
   {0.91439f,0.90835f,0.8916f,0.87077f,0.84576f,0.81245f,0.7928f,0.76796f,0.738f,0.70338f,0.66454f,0.62424f,0.58439f,0.54783f,0.51565f,0.4881f,0.46806f,0.44967f,0.43169f,0.41295f,0.40509f},
   {0.91999f,0.91639f,0.90136f,0.88119f,0.84571f,0.79668f,0.7467f,0.73569f,0.72936f,0.70351f,0.65538f,0.60316f,0.55465f,0.51501f,0.48328f,0.45812f,0.43585f,0.41993f,0.40718f,0.39424f,0.39222f},
   {0.92644f,0.9241f,0.9116f,0.88204f,0.81948f,0.75913f,0.7093f,0.67664f,0.6742f,0.67446f,0.64332f,0.57619f,0.52176f,0.48087f,0.45029f,0.42447f,0.40245f,0.38564f,0.37761f,0.37267f,0.37675f},
   {0.93328f,0.93254f,0.9182f,0.84895f,0.77794f,0.72451f,0.67899f,0.646f,0.61886f,0.61788f,0.61109f,0.54173f,0.48019f,0.44035f,0.41133f,0.3872f,0.36711f,0.3515f,0.34305f,0.34665f,0.35949f},
   {0.94079f,0.94125f,0.89647f,0.80366f,0.73973f,0.69128f,0.64924f,0.61419f,0.58696f,0.56267f,0.5568f,0.48093f,0.42253f,0.38874f,0.36567f,0.34643f,0.33027f,0.31726f,0.30924f,0.31729f,0.33938f},
   {0.94868f,0.94932f,0.85855f,0.76783f,0.70797f,0.6585f,0.61853f,0.58249f,0.55175f,0.52825f,0.50768f,0.4666f,0.41827f,0.3636f,0.31986f,0.30433f,0.29263f,0.28293f,0.27687f,0.28639f,0.31623f},
   {0.95692f,0.94285f,0.81295f,0.72936f,0.67316f,0.62838f,0.58857f,0.55635f,0.53314f,0.51506f,0.48848f,0.4641f,0.41854f,0.36792f,0.30775f,0.26456f,0.25758f,0.25115f,0.24711f,0.25581f,0.29081f},
   {0.96498f,0.92623f,0.77825f,0.69811f,0.64339f,0.59922f,0.56168f,0.53635f,0.51766f,0.49513f,0.46765f,0.43865f,0.41479f,0.36661f,0.31029f,0.24396f,0.2244f,0.2212f,0.21973f,0.22723f,0.26285f},
   {0.97256f,0.91407f,0.74704f,0.66907f,0.61557f,0.57221f,0.53916f,0.51851f,0.49738f,0.47393f,0.44568f,0.41615f,0.38911f,0.36305f,0.30976f,0.23681f,0.19525f,0.19457f,0.195f,0.19978f,0.23325f},
   {0.97977f,0.90775f,0.72015f,0.63895f,0.58796f,0.54758f,0.51964f,0.49723f,0.47331f,0.44904f,0.42223f,0.39228f,0.36342f,0.33524f,0.30117f,0.23059f,0.17434f,0.17166f,0.17099f,0.17167f,0.20077f},
   {0.9859f,0.87057f,0.69253f,0.61473f,0.5638f,0.5249f,0.49694f,0.47075f,0.44562f,0.42048f,0.39423f,0.36386f,0.33224f,0.29859f,0.26151f,0.22478f,0.15504f,0.1498f,0.14764f,0.14455f,0.16808f},
   {0.99106f,0.80597f,0.67879f,0.59077f,0.54157f,0.50615f,0.47152f,0.44064f,0.41413f,0.3874f,0.35733f,0.32787f,0.29278f,0.25408f,0.21547f,0.16499f,0.13688f,0.12892f,0.12217f,0.12145f,0.13422f},
   {0.99504f,0.74543f,0.63485f,0.56981f,0.52611f,0.48531f,0.44536f,0.40751f,0.37576f,0.34528f,0.31078f,0.27718f,0.23605f,0.18894f,0.14089f,0.10295f,0.10266f,0.10793f,0.10578f,0.10172f,0.10039f},
   {0.99787f,0.69017f,0.59589f,0.55331f,0.50604f,0.45667f,0.40929f,0.36672f,0.3241f,0.28428f,0.24009f,0.19737f,0.14365f,0.086107f,0.056905f,0.062385f,0.065046f,0.078632f,0.091522f,0.084744f,0.066244f},
   {0.99945f,0.64208f,0.58925f,0.53016f,0.46426f,0.39194f,0.32374f,0.27699f,0.23034f,0.17491f,0.10657f,0.049487f,0.013026f,0.010495f,0.013088f,0.020503f,0.032465f,0.045267f,0.058324f,0.070706f,0.033221f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,7.8496e-017f}};

static float map_5stereo_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_5stereo_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_5stereo_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_5stereo_rf[21][21] = {
   {0.44721f,0.46513f,0.48487f,0.50702f,0.53092f,0.55707f,0.58534f,0.61495f,0.64566f,0.67665f,0.70658f,0.73631f,0.76362f,0.78812f,0.81079f,0.83007f,0.84705f,0.86158f,0.87425f,0.88493f,0.89443f},
   {0.44091f,0.47587f,0.49021f,0.50752f,0.52648f,0.54843f,0.57451f,0.6034f,0.63295f,0.66338f,0.69439f,0.72464f,0.75386f,0.78179f,0.80734f,0.82734f,0.84251f,0.85523f,0.86585f,0.87468f,0.89745f},
   {0.43392f,0.46211f,0.48471f,0.50144f,0.52081f,0.54578f,0.57199f,0.59968f,0.62825f,0.65666f,0.68541f,0.71353f,0.74165f,0.76989f,0.79612f,0.81907f,0.84102f,0.85378f,0.86458f,0.88258f,0.90087f},
   {0.42556f,0.4465f,0.46827f,0.49061f,0.51198f,0.53606f,0.56263f,0.59061f,0.61925f,0.64863f,0.67871f,0.70782f,0.73615f,0.76373f,0.78979f,0.81451f,0.83582f,0.85431f,0.87445f,0.89102f,0.90482f},
   {0.41603f,0.43027f,0.44962f,0.47284f,0.49384f,0.51738f,0.54427f,0.57368f,0.6051f,0.63829f,0.67221f,0.7044f,0.7353f,0.76362f,0.78911f,0.81401f,0.83539f,0.86106f,0.88491f,0.8996f,0.90924f},
   {0.40482f,0.41257f,0.43125f,0.44919f,0.46765f,0.48799f,0.5153f,0.54739f,0.58411f,0.62399f,0.66441f,0.70314f,0.73778f,0.76766f,0.79269f,0.81235f,0.84558f,0.8705f,0.89137f,0.90817f,0.91428f},
   {0.39194f,0.39388f,0.40671f,0.41966f,0.43552f,0.45781f,0.48319f,0.51474f,0.55427f,0.60276f,0.65524f,0.70322f,0.72923f,0.73577f,0.74653f,0.79678f,0.84573f,0.88113f,0.90115f,0.91624f,0.91987f},
   {0.37644f,0.37227f,0.37711f,0.38534f,0.40191f,0.42405f,0.44998f,0.48078f,0.52148f,0.57577f,0.64317f,0.67439f,0.67427f,0.67648f,0.70945f,0.75919f,0.81959f,0.88212f,0.9114f,0.92394f,0.92631f},
   {0.35915f,0.34622f,0.34257f,0.35105f,0.36669f,0.38687f,0.41089f,0.4401f,0.48011f,0.5414f,0.611f,0.6178f,0.61871f,0.64608f,0.67901f,0.72469f,0.77805f,0.84918f,0.91813f,0.93239f,0.93315f},
   {0.339f,0.31682f,0.30893f,0.31701f,0.32988f,0.34612f,0.36531f,0.38841f,0.42221f,0.48085f,0.55674f,0.56251f,0.58695f,0.61421f,0.64927f,0.69144f,0.73987f,0.80398f,0.89674f,0.94111f,0.94065f},
   {0.31623f,0.28631f,0.2768f,0.28287f,0.29257f,0.30426f,0.31977f,0.36346f,0.41814f,0.46648f,0.50757f,0.52811f,0.55161f,0.58235f,0.61839f,0.65835f,0.70781f,0.76766f,0.85835f,0.9493f,0.94868f},
   {0.29034f,0.25533f,0.24671f,0.25078f,0.25715f,0.26439f,0.30769f,0.36779f,0.41847f,0.46397f,0.48838f,0.51493f,0.53305f,0.55637f,0.5887f,0.62862f,0.67335f,0.72964f,0.81334f,0.94301f,0.95678f},
   {0.26232f,0.22679f,0.21937f,0.22086f,0.22399f,0.24396f,0.31026f,0.36659f,0.41466f,0.43856f,0.46754f,0.49513f,0.51753f,0.53639f,0.56171f,0.59947f,0.64361f,0.69839f,0.7787f,0.92656f,0.96484f},
   {0.23266f,0.1991f,0.19467f,0.19425f,0.19496f,0.23683f,0.30986f,0.36292f,0.38916f,0.41616f,0.44556f,0.4739f,0.49749f,0.51838f,0.53932f,0.57241f,0.61582f,0.66942f,0.74748f,0.91454f,0.97242f},
   {0.20011f,0.17119f,0.17065f,0.1714f,0.17417f,0.23067f,0.30103f,0.33526f,0.36339f,0.39235f,0.4221f,0.4491f,0.47339f,0.49735f,0.51951f,0.5478f,0.58825f,0.63932f,0.72063f,0.90831f,0.97964f},
   {0.16735f,0.14405f,0.14727f,0.14951f,0.15491f,0.22462f,0.2616f,0.29868f,0.33231f,0.36396f,0.39409f,0.42057f,0.44576f,0.47095f,0.49718f,0.52476f,0.56413f,0.61513f,0.6931f,0.87142f,0.98577f},
   {0.13341f,0.121f,0.12181f,0.12862f,0.1368f,0.16508f,0.21559f,0.25412f,0.2929f,0.328f,0.35717f,0.38746f,0.41422f,0.44087f,0.47184f,0.50652f,0.54141f,0.59121f,0.67941f,0.80686f,0.99095f},
   {0.099504f,0.1013f,0.10541f,0.10788f,0.10237f,0.10273f,0.14105f,0.18916f,0.23623f,0.2774f,0.31059f,0.34549f,0.37607f,0.40782f,0.44579f,0.48575f,0.5266f,0.5696f,0.63552f,0.74632f,0.99495f},
   {0.065281f,0.084354f,0.091461f,0.078331f,0.064744f,0.062131f,0.056625f,0.086144f,0.14401f,0.19771f,0.23987f,0.28465f,0.32453f,0.36721f,0.40981f,0.45726f,0.50676f,0.55399f,0.59562f,0.69107f,0.9978f},
   {0.032183f,0.070629f,0.057967f,0.044948f,0.032184f,0.020306f,0.01291f,0.010374f,0.012904f,0.049943f,0.10632f,0.1756f,0.23105f,0.27778f,0.32471f,0.39294f,0.46531f,0.5312f,0.59027f,0.64172f,0.99942f},
   {7.8496e-017f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_4point1_ang[] = {-27,27,-105,105};
static float map_4point1_xsf[] = {-1,1,-1,1};
static float map_4point1_ysf[] = {1,1,-1,-1};
channel_id map_4point1_id[] = {ci_front_left,ci_front_right,ci_back_left,ci_back_right,ci_lfe};

static float map_4point1_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.054079f,0.13605f,0.11031f,0.083738f,0.058746f,0.03616f,0.022585f,0.018356f,0.012179f,0.0043961f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.11103f,0.16562f,0.18635f,0.15778f,0.12791f,0.12403f,0.10709f,0.090176f,0.070512f,0.049741f,0.027549f,0.011727f,0.0013628f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17535f,0.20208f,0.21809f,0.22862f,0.21842f,0.20197f,0.18341f,0.15706f,0.13031f,0.10103f,0.068601f,0.041975f,0.018696f,0.0039144f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24362f,0.24543f,0.25563f,0.27972f,0.28786f,0.26979f,0.24789f,0.21805f,0.18569f,0.14921f,0.10871f,0.073541f,0.041097f,0.017152f,0.0038597f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3173f,0.29703f,0.31848f,0.33006f,0.33185f,0.32708f,0.30247f,0.27305f,0.23691f,0.19431f,0.14844f,0.10174f,0.061737f,0.03134f,0.011327f,0.0027159f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.39394f,0.36121f,0.3753f,0.38051f,0.37698f,0.36547f,0.34958f,0.3221f,0.28469f,0.23727f,0.18262f,0.12638f,0.083376f,0.055926f,0.035607f,0.011267f,0.0038302f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.47562f,0.43164f,0.43211f,0.42875f,0.41905f,0.40425f,0.38486f,0.3601f,0.3262f,0.27779f,0.21259f,0.15374f,0.11534f,0.092532f,0.055768f,0.031114f,0.016973f,0.0038919f,0.000000f,0.000000f,0.000000f},
   {0.55484f,0.49969f,0.48676f,0.47535f,0.45999f,0.4406f,0.41747f,0.39084f,0.3589f,0.31565f,0.24497f,0.18988f,0.16127f,0.11527f,0.083186f,0.061436f,0.040831f,0.018492f,0.0013084f,0.000000f,0.000000f},
   {0.63203f,0.56664f,0.53922f,0.51913f,0.49762f,0.47305f,0.44521f,0.41467f,0.38246f,0.34456f,0.28169f,0.24152f,0.1898f,0.15351f,0.12607f,0.10138f,0.073199f,0.041753f,0.011636f,0.000000f,0.000000f},
   {0.70711f,0.63601f,0.5915f,0.56154f,0.5324f,0.49872f,0.46317f,0.42387f,0.38431f,0.34937f,0.31849f,0.28164f,0.24488f,0.21244f,0.18245f,0.14826f,0.10854f,0.068473f,0.027433f,0.000000f,0.000000f},
   {0.77384f,0.7028f,0.64182f,0.59999f,0.5611f,0.52035f,0.47318f,0.42773f,0.39037f,0.35676f,0.34937f,0.34453f,0.31539f,0.27747f,0.23686f,0.19392f,0.14881f,0.1006f,0.049384f,0.0043772f,0.000000f},
   {0.83292f,0.76642f,0.69548f,0.63988f,0.59007f,0.53795f,0.48146f,0.43778f,0.40135f,0.39034f,0.38431f,0.3824f,0.35884f,0.32588f,0.28429f,0.2365f,0.18525f,0.12989f,0.070085f,0.011962f,0.000000f},
   {0.88048f,0.82659f,0.75196f,0.68173f,0.61966f,0.55557f,0.49389f,0.45152f,0.43774f,0.42776f,0.42387f,0.41451f,0.39065f,0.36002f,0.32174f,0.27262f,0.21753f,0.15652f,0.089694f,0.018075f,0.000000f},
   {0.91982f,0.87898f,0.80369f,0.72266f,0.64727f,0.57793f,0.51602f,0.49394f,0.48142f,0.47314f,0.46315f,0.44506f,0.41722f,0.38449f,0.34948f,0.30197f,0.24734f,0.18313f,0.10655f,0.022264f,0.000000f},
   {0.94888f,0.91176f,0.84521f,0.76937f,0.68766f,0.60203f,0.57788f,0.55561f,0.53794f,0.52028f,0.49868f,0.47276f,0.44023f,0.40381f,0.36503f,0.32695f,0.26927f,0.20135f,0.12342f,0.035717f,0.000000f},
   {0.9703f,0.92966f,0.89031f,0.80673f,0.72356f,0.6876f,0.64713f,0.61943f,0.5899f,0.56088f,0.53232f,0.49722f,0.45953f,0.41857f,0.37646f,0.33123f,0.28771f,0.21775f,0.12737f,0.058204f,0.000000f},
   {0.98481f,0.94077f,0.8973f,0.84179f,0.80663f,0.76916f,0.72238f,0.68134f,0.63953f,0.59955f,0.56144f,0.51865f,0.47475f,0.42817f,0.38012f,0.32941f,0.27908f,0.22844f,0.15705f,0.083257f,0.000000f},
   {0.99396f,0.94647f,0.89932f,0.89719f,0.89008f,0.84488f,0.80323f,0.75136f,0.69482f,0.64113f,0.59135f,0.53856f,0.48604f,0.43137f,0.37452f,0.3177f,0.25473f,0.21738f,0.18614f,0.10958f,0.000000f},
   {0.99855f,0.94808f,0.94637f,0.94057f,0.92934f,0.91132f,0.87838f,0.82589f,0.76558f,0.70182f,0.63578f,0.56555f,0.49868f,0.43048f,0.35999f,0.29603f,0.24451f,0.20108f,0.16489f,0.1358f,0.000000f},
   {1.000000f,0.99854f,0.99377f,0.9845f,0.96987f,0.94832f,0.91914f,0.87965f,0.83195f,0.77384f,0.70711f,0.63203f,0.55339f,0.47409f,0.39234f,0.31565f,0.24192f,0.17365f,0.10973f,0.052336f,0.000000f}};

static float map_4point1_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043772f,0.011962f,0.018075f,0.022264f,0.035717f,0.058204f,0.083257f,0.10958f,0.13592f,0.052336f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013084f,0.011636f,0.027472f,0.049384f,0.070085f,0.089694f,0.10655f,0.12342f,0.12737f,0.15705f,0.18623f,0.16489f,0.10973f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0038919f,0.018492f,0.041753f,0.068513f,0.1006f,0.12983f,0.15652f,0.18313f,0.20135f,0.21775f,0.22851f,0.21738f,0.20108f,0.17363f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.016973f,0.040831f,0.073199f,0.10859f,0.14876f,0.1852f,0.21753f,0.24734f,0.26927f,0.28776f,0.27908f,0.25473f,0.24451f,0.24192f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.002725f,0.011267f,0.031114f,0.061436f,0.10138f,0.14831f,0.19392f,0.2365f,0.27257f,0.30197f,0.327f,0.33123f,0.32934f,0.31761f,0.29589f,0.31565f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0039191f,0.011379f,0.035584f,0.055812f,0.083146f,0.12603f,0.18248f,0.23686f,0.28429f,0.32174f,0.34952f,0.36503f,0.37646f,0.38012f,0.37444f,0.35999f,0.39234f},
   {0.000000f,0.000000f,0.000000f,0.0039822f,0.017152f,0.03134f,0.055926f,0.09249f,0.11527f,0.15351f,0.21247f,0.27743f,0.32588f,0.36005f,0.38449f,0.40381f,0.41852f,0.42817f,0.43128f,0.43048f,0.47409f},
   {0.000000f,0.000000f,0.0013628f,0.018696f,0.041097f,0.061737f,0.083376f,0.11538f,0.16121f,0.18976f,0.24491f,0.31539f,0.35887f,0.39065f,0.41717f,0.44023f,0.45953f,0.47475f,0.48597f,0.49857f,0.55339f},
   {0.000000f,0.000000f,0.011806f,0.042039f,0.073541f,0.10174f,0.12638f,0.15373f,0.18988f,0.24145f,0.28167f,0.34454f,0.38236f,0.41451f,0.445f,0.47276f,0.49722f,0.51865f,0.53856f,0.56555f,0.63203f},
   {0.000000f,8.5322e-019f,0.027472f,0.068532f,0.10862f,0.14835f,0.18253f,0.21252f,0.24491f,0.28164f,0.31849f,0.34939f,0.38433f,0.42389f,0.46318f,0.49872f,0.53237f,0.56148f,0.59141f,0.63586f,0.70711f},
   {0.000000f,0.0045097f,0.049741f,0.10103f,0.14921f,0.19436f,0.23726f,0.27779f,0.31563f,0.34453f,0.34938f,0.35677f,0.39034f,0.42771f,0.47314f,0.52028f,0.56081f,0.59955f,0.64113f,0.70182f,0.77384f},
   {0.000000f,0.012179f,0.070512f,0.13031f,0.18569f,0.23696f,0.28468f,0.3262f,0.35886f,0.38246f,0.38432f,0.39033f,0.40136f,0.43778f,0.48142f,0.53794f,0.58984f,0.63945f,0.69482f,0.76558f,0.83195f},
   {0.000000f,0.018356f,0.090176f,0.15706f,0.21803f,0.27305f,0.32214f,0.36006f,0.39088f,0.41462f,0.42388f,0.42773f,0.43778f,0.45153f,0.49394f,0.55555f,0.61943f,0.68134f,0.75136f,0.82586f,0.87965f},
   {0.000000f,0.022585f,0.10709f,0.1837f,0.24789f,0.30247f,0.34954f,0.38486f,0.41747f,0.44521f,0.46317f,0.47313f,0.48141f,0.49393f,0.51604f,0.57793f,0.64713f,0.7226f,0.80323f,0.87839f,0.91914f},
   {0.000000f,0.03616f,0.12403f,0.20197f,0.26986f,0.32703f,0.36552f,0.40423f,0.4406f,0.47305f,0.49872f,0.5204f,0.538f,0.55557f,0.57793f,0.60205f,0.6876f,0.76916f,0.84488f,0.91132f,0.94832f},
   {0.000000f,0.058746f,0.12802f,0.21842f,0.2878f,0.33185f,0.37704f,0.41905f,0.45997f,0.4976f,0.53237f,0.5611f,0.59007f,0.61958f,0.64727f,0.6877f,0.7236f,0.80663f,0.89008f,0.92934f,0.96987f},
   {0.000000f,0.083896f,0.15778f,0.22854f,0.27982f,0.33006f,0.38081f,0.42882f,0.47533f,0.51919f,0.56149f,0.59999f,0.63988f,0.68173f,0.72294f,0.76935f,0.80673f,0.84179f,0.89719f,0.94057f,0.9845f},
   {0.000000f,0.11031f,0.18625f,0.21822f,0.25563f,0.31848f,0.3753f,0.43211f,0.48676f,0.5393f,0.59144f,0.64182f,0.69546f,0.75192f,0.80366f,0.84518f,0.89031f,0.8973f,0.8993f,0.94637f,0.99377f},
   {0.000000f,0.13592f,0.16581f,0.20208f,0.24559f,0.29703f,0.36121f,0.43162f,0.49969f,0.56664f,0.63593f,0.7028f,0.76638f,0.82659f,0.87898f,0.91171f,0.92966f,0.94077f,0.94647f,0.94806f,0.99846f},
   {7.8496e-017f,0.054079f,0.11147f,0.17537f,0.24362f,0.3173f,0.39394f,0.47562f,0.55484f,0.63338f,0.70711f,0.77494f,0.83292f,0.88048f,0.91982f,0.94888f,0.9703f,0.98481f,0.99396f,0.99863f,1.000000f}};

static float map_4point1_ls[21][21] = {
   {1.000000f,0.99863f,0.99396f,0.98481f,0.9703f,0.94888f,0.91914f,0.88048f,0.83195f,0.77384f,0.70834f,0.63338f,0.55484f,0.47562f,0.39394f,0.3173f,0.24362f,0.17537f,0.11147f,0.054079f,-7.8496e-017f},
   {0.99854f,0.94804f,0.94647f,0.94043f,0.92966f,0.91177f,0.87898f,0.82659f,0.76643f,0.70248f,0.63602f,0.56664f,0.49969f,0.43164f,0.36121f,0.29703f,0.24559f,0.20208f,0.16581f,0.13592f,0.000000f},
   {0.99373f,0.94619f,0.89929f,0.8973f,0.89f,0.84522f,0.80369f,0.75196f,0.69549f,0.64182f,0.59149f,0.53909f,0.48676f,0.43211f,0.3753f,0.31848f,0.25563f,0.21817f,0.18628f,0.11031f,0.000000f},
   {0.98443f,0.94057f,0.89693f,0.84178f,0.80673f,0.76938f,0.72295f,0.68173f,0.63988f,0.59999f,0.56152f,0.51902f,0.47535f,0.42864f,0.38061f,0.33006f,0.27965f,0.22857f,0.15778f,0.083896f,0.000000f},
   {0.96987f,0.92924f,0.89008f,0.8064f,0.72353f,0.68753f,0.64727f,0.61961f,0.59007f,0.5611f,0.53236f,0.49762f,0.45999f,0.41905f,0.37687f,0.33185f,0.28785f,0.21842f,0.12802f,0.058746f,0.000000f},
   {0.94832f,0.91132f,0.84488f,0.76916f,0.6876f,0.60199f,0.57793f,0.55557f,0.53786f,0.52026f,0.49866f,0.47305f,0.4406f,0.40425f,0.36538f,0.32707f,0.2697f,0.20197f,0.12403f,0.03616f,0.000000f},
   {0.91914f,0.87839f,0.80323f,0.72262f,0.64697f,0.57779f,0.51599f,0.49381f,0.48147f,0.4732f,0.46311f,0.44521f,0.41747f,0.38486f,0.34957f,0.30247f,0.24789f,0.18361f,0.10709f,0.022585f,0.000000f},
   {0.87965f,0.82586f,0.75136f,0.68116f,0.61943f,0.55563f,0.49394f,0.45149f,0.43778f,0.42773f,0.42381f,0.41464f,0.39077f,0.36007f,0.32202f,0.27305f,0.21805f,0.15706f,0.090176f,0.018356f,0.000000f},
   {0.83195f,0.76558f,0.69482f,0.63955f,0.58992f,0.53794f,0.48142f,0.43767f,0.40132f,0.39038f,0.38425f,0.38246f,0.35885f,0.3262f,0.2847f,0.23683f,0.18569f,0.13031f,0.070512f,0.012179f,0.000000f},
   {0.77494f,0.70182f,0.64105f,0.59937f,0.5609f,0.52028f,0.47314f,0.42777f,0.39034f,0.35673f,0.34932f,0.34449f,0.31565f,0.27779f,0.23728f,0.19424f,0.14921f,0.10103f,0.049741f,0.0045097f,0.000000f},
   {0.70711f,0.63577f,0.59134f,0.56143f,0.53234f,0.49869f,0.46315f,0.42387f,0.38431f,0.34937f,0.3185f,0.28163f,0.2449f,0.21252f,0.18253f,0.14834f,0.1086f,0.068513f,0.027472f,-8.5322e-019f,0.000000f},
   {0.63338f,0.56555f,0.53856f,0.51865f,0.49722f,0.47263f,0.44507f,0.41451f,0.38241f,0.34452f,0.2816f,0.24145f,0.18988f,0.15379f,0.12638f,0.10174f,0.073541f,0.042039f,0.011806f,0.000000f,0.000000f},
   {0.55339f,0.49871f,0.48607f,0.47475f,0.45953f,0.44013f,0.41724f,0.39065f,0.35885f,0.31539f,0.24485f,0.1898f,0.16119f,0.11535f,0.083376f,0.061737f,0.041097f,0.018696f,0.0013628f,0.000000f,0.000000f},
   {0.47409f,0.43048f,0.43138f,0.42817f,0.41859f,0.40381f,0.38442f,0.36003f,0.32583f,0.27748f,0.21245f,0.15351f,0.11527f,0.092466f,0.055926f,0.03134f,0.017152f,0.0039822f,0.000000f,0.000000f,0.000000f},
   {0.39234f,0.35999f,0.37455f,0.38033f,0.37646f,0.36503f,0.34948f,0.32174f,0.28429f,0.23686f,0.18246f,0.12608f,0.083197f,0.055812f,0.03557f,0.011379f,0.0039191f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.31565f,0.29607f,0.31773f,0.32943f,0.33124f,0.32696f,0.30198f,0.27263f,0.2365f,0.19392f,0.14828f,0.10138f,0.061436f,0.031114f,0.011267f,0.002725f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24192f,0.24451f,0.25473f,0.27908f,0.28772f,0.26927f,0.24734f,0.21753f,0.18526f,0.14882f,0.10856f,0.073199f,0.040831f,0.01704f,0.0038302f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17365f,0.20108f,0.21738f,0.22846f,0.21775f,0.20135f,0.18335f,0.15652f,0.12991f,0.1006f,0.068474f,0.041753f,0.018492f,0.0038919f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.10973f,0.16489f,0.18616f,0.15705f,0.12737f,0.12342f,0.10655f,0.089694f,0.070085f,0.049384f,0.027446f,0.011636f,0.0013628f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.052332f,0.13583f,0.10958f,0.083257f,0.058204f,0.035717f,0.022438f,0.018227f,0.011962f,0.0043772f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_4point1_rs[21][21] = {
   {-7.8496e-017f,0.052336f,0.10973f,0.17365f,0.24192f,0.31565f,0.39394f,0.47409f,0.55484f,0.63338f,0.70587f,0.77384f,0.83195f,0.87965f,0.91914f,0.94832f,0.96987f,0.9845f,0.99377f,0.99854f,1.000000f},
   {0.000000f,0.13583f,0.16489f,0.20208f,0.24451f,0.29589f,0.35999f,0.43048f,0.49857f,0.56633f,0.63558f,0.70182f,0.76558f,0.82586f,0.87839f,0.91132f,0.92934f,0.94057f,0.94637f,0.94804f,0.99863f},
   {0.000000f,0.11031f,0.18615f,0.21738f,0.25552f,0.31761f,0.37444f,0.43128f,0.48597f,0.53856f,0.59121f,0.64167f,0.69482f,0.75136f,0.80323f,0.84488f,0.89008f,0.89725f,0.89927f,0.94647f,0.99396f},
   {0.000000f,0.083257f,0.15778f,0.22845f,0.27908f,0.32934f,0.38061f,0.42817f,0.47475f,0.51865f,0.56131f,0.59998f,0.63948f,0.6818f,0.72306f,0.76916f,0.80688f,0.84174f,0.8973f,0.94077f,0.98473f},
   {0.000000f,0.058746f,0.12737f,0.2183f,0.28772f,0.33167f,0.37646f,0.41852f,0.45953f,0.49722f,0.53221f,0.56083f,0.58986f,0.61943f,0.64753f,0.6876f,0.72348f,0.80673f,0.89031f,0.92966f,0.9703f},
   {0.000000f,0.035717f,0.12342f,0.20135f,0.26927f,0.32696f,0.36503f,0.40381f,0.44057f,0.47309f,0.49858f,0.52028f,0.53794f,0.55557f,0.57829f,0.60191f,0.688f,0.76938f,0.84522f,0.91177f,0.94888f},
   {0.000000f,0.022264f,0.10655f,0.18361f,0.24774f,0.30233f,0.34948f,0.3848f,0.41719f,0.44502f,0.46308f,0.47314f,0.48142f,0.49394f,0.51592f,0.57793f,0.64727f,0.72306f,0.80369f,0.87898f,0.91982f},
   {0.000000f,0.018075f,0.089694f,0.15698f,0.21753f,0.27257f,0.32174f,0.36002f,0.39065f,0.41451f,0.4238f,0.42773f,0.43804f,0.45143f,0.49424f,0.55557f,0.61961f,0.68173f,0.75196f,0.82659f,0.88048f},
   {0.000000f,0.011962f,0.070085f,0.12983f,0.1852f,0.2365f,0.28429f,0.32614f,0.35884f,0.38237f,0.38425f,0.39034f,0.40127f,0.43778f,0.48142f,0.53827f,0.59007f,0.63988f,0.69549f,0.76643f,0.83292f},
   {0.000000f,0.0043772f,0.049741f,0.10103f,0.14876f,0.19392f,0.23686f,0.27743f,0.31539f,0.34452f,0.34932f,0.35669f,0.39034f,0.42773f,0.47315f,0.52061f,0.5611f,0.59999f,0.64182f,0.7028f,0.77494f},
   {0.000000f,-8.5322e-019f,0.027447f,0.068465f,0.10853f,0.14825f,0.18244f,0.21244f,0.24485f,0.28161f,0.31849f,0.34932f,0.38425f,0.42381f,0.46314f,0.49869f,0.53239f,0.56152f,0.59147f,0.63596f,0.70711f},
   {0.000000f,0.000000f,0.011636f,0.041753f,0.073199f,0.1017f,0.12603f,0.15351f,0.18976f,0.24145f,0.28164f,0.34451f,0.38246f,0.41464f,0.44521f,0.47305f,0.49762f,0.51919f,0.5393f,0.56664f,0.63338f},
   {0.000000f,0.000000f,0.0013084f,0.018492f,0.040831f,0.061737f,0.083146f,0.11527f,0.16121f,0.18988f,0.2449f,0.31565f,0.35887f,0.39092f,0.41747f,0.4406f,0.45999f,0.47535f,0.48676f,0.49969f,0.55484f},
   {0.000000f,0.000000f,0.000000f,0.0038919f,0.016973f,0.031114f,0.056058f,0.092505f,0.11557f,0.15374f,0.21251f,0.27779f,0.3262f,0.36008f,0.38486f,0.40425f,0.41905f,0.42882f,0.43211f,0.43164f,0.47562f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.011267f,0.0356f,0.055926f,0.083376f,0.12638f,0.18252f,0.23728f,0.2847f,0.32214f,0.34955f,0.36552f,0.37704f,0.38081f,0.3753f,0.36121f,0.39394f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027341f,0.011405f,0.03134f,0.061737f,0.10174f,0.14834f,0.19436f,0.23696f,0.27305f,0.30247f,0.32704f,0.33185f,0.33006f,0.31848f,0.29703f,0.3173f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039191f,0.017152f,0.041097f,0.073541f,0.10862f,0.14921f,0.18569f,0.21805f,0.24789f,0.26986f,0.28782f,0.27982f,0.25563f,0.24559f,0.24362f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039822f,0.018696f,0.042039f,0.068554f,0.10103f,0.13031f,0.15706f,0.1837f,0.20197f,0.21842f,0.22858f,0.21822f,0.20208f,0.17537f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013628f,0.011806f,0.027511f,0.049741f,0.070512f,0.090176f,0.10709f,0.12403f,0.12802f,0.15778f,0.1863f,0.16581f,0.11147f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-8.5322e-019f,0.0045097f,0.012179f,0.018356f,0.022585f,0.03616f,0.058746f,0.083896f,0.11031f,0.136f,0.054075f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-7.8496e-017f}};

static float map_5point1_ang[] = {-27,0,27,-105,105};
static float map_5point1_xsf[] = {-1,0,1,-1,1};
static float map_5point1_ysf[] = {1,1,1,-1,-1};
channel_id map_5point1_id[] = {ci_front_left,ci_front_center,ci_front_right,ci_back_left,ci_back_right,ci_lfe};

static float map_5point1_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.054079f,0.13605f,0.11031f,0.083738f,0.058746f,0.03616f,0.022585f,0.018356f,0.012179f,0.0043961f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.11103f,0.16562f,0.18635f,0.15778f,0.12791f,0.12403f,0.10709f,0.090176f,0.070512f,0.049741f,0.027549f,0.011727f,0.0013628f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17535f,0.20208f,0.21809f,0.22862f,0.21842f,0.20197f,0.18341f,0.15706f,0.13031f,0.10103f,0.068601f,0.041975f,0.018696f,0.0039144f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24362f,0.24543f,0.25563f,0.27972f,0.28786f,0.26979f,0.24789f,0.21805f,0.18569f,0.14921f,0.10871f,0.073541f,0.041097f,0.017152f,0.0038597f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3173f,0.29703f,0.31848f,0.33006f,0.33185f,0.32571f,0.30203f,0.27305f,0.23691f,0.19431f,0.14844f,0.10174f,0.061737f,0.03134f,0.010908f,0.0013625f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.39394f,0.36121f,0.3753f,0.38051f,0.37306f,0.35451f,0.33178f,0.30958f,0.28023f,0.23726f,0.18262f,0.12638f,0.07899f,0.043546f,0.017841f,0.00044495f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.47562f,0.43164f,0.43211f,0.42477f,0.4019f,0.37291f,0.34131f,0.31385f,0.29675f,0.2674f,0.21259f,0.14347f,0.086077f,0.046322f,0.012467f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55484f,0.49969f,0.48539f,0.45665f,0.41889f,0.37886f,0.33895f,0.30764f,0.28138f,0.2723f,0.23279f,0.14674f,0.083778f,0.032293f,0.0048976f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.63203f,0.56664f,0.52742f,0.47709f,0.42408f,0.37424f,0.33419f,0.30176f,0.27482f,0.25011f,0.23665f,0.1471f,0.082204f,0.040759f,0.015195f,0.0028496f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.70711f,0.63601f,0.56403f,0.49301f,0.42572f,0.37154f,0.33227f,0.30051f,0.27246f,0.24769f,0.22385f,0.17996f,0.13303f,0.089089f,0.051572f,0.021112f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.77384f,0.69829f,0.59208f,0.49896f,0.42627f,0.37547f,0.33559f,0.30342f,0.27695f,0.2532f,0.24555f,0.24096f,0.202f,0.15312f,0.099312f,0.049149f,0.01419f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83292f,0.75424f,0.62497f,0.51188f,0.43577f,0.38288f,0.34157f,0.31064f,0.28485f,0.27588f,0.27011f,0.26791f,0.24233f,0.19874f,0.14444f,0.081488f,0.031102f,0.0022352f,0.000000f,0.000000f,0.000000f},
   {0.88048f,0.80823f,0.66178f,0.53219f,0.45043f,0.39421f,0.35046f,0.32046f,0.30985f,0.30176f,0.29791f,0.28855f,0.26277f,0.22895f,0.1783f,0.11122f,0.048526f,0.0073556f,0.000000f,0.000000f,0.000000f},
   {0.91982f,0.8564f,0.6966f,0.55364f,0.46596f,0.41011f,0.36623f,0.3499f,0.34025f,0.33348f,0.32389f,0.30536f,0.27602f,0.24046f,0.19967f,0.13416f,0.066173f,0.014462f,0.000000f,0.000000f,0.000000f},
   {0.94888f,0.8756f,0.72118f,0.58509f,0.49378f,0.42727f,0.40951f,0.39303f,0.37927f,0.36377f,0.34295f,0.31626f,0.28156f,0.24129f,0.19667f,0.15218f,0.075526f,0.017441f,0.000000f,0.000000f,0.000000f},
   {0.9703f,0.87092f,0.76228f,0.60765f,0.51716f,0.48514f,0.45531f,0.43328f,0.40894f,0.38299f,0.35389f,0.31939f,0.27862f,0.23237f,0.18465f,0.12881f,0.081296f,0.019071f,0.000000f,0.000000f,0.000000f},
   {0.98481f,0.85688f,0.73952f,0.62982f,0.5767f,0.53382f,0.4939f,0.46098f,0.42667f,0.39124f,0.35254f,0.31034f,0.26195f,0.20782f,0.15167f,0.09417f,0.04946f,0.016531f,0.000000f,0.000000f,0.000000f},
   {0.99396f,0.83616f,0.71307f,0.68155f,0.64457f,0.57478f,0.52315f,0.47464f,0.42859f,0.38222f,0.33181f,0.27965f,0.21975f,0.15464f,0.094607f,0.047925f,0.0098814f,0.0024671f,0.000000f,0.000000f,0.000000f},
   {0.99855f,0.81216f,0.78057f,0.73849f,0.68375f,0.61653f,0.5369f,0.46213f,0.39741f,0.33339f,0.26339f,0.19725f,0.13069f,0.067274f,0.019339f,0.0021311f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.94446f,0.8823f,0.80914f,0.72626f,0.63102f,0.52519f,0.40402f,0.27711f,0.14046f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_5point1_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.001914f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.0155f,0.025167f,0.017695f,0.0063155f,1.0116e-005f,0.000000f,0.000000f,0.0062031f,0.017508f,0.025125f,0.015305f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0056317f,0.024256f,0.044322f,0.061583f,0.065405f,0.041656f,0.014688f,4.0817e-019f,0.014527f,0.041389f,0.065342f,0.061236f,0.044002f,0.024003f,0.005504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0019274f,0.02644f,0.05812f,0.08731f,0.11105f,0.11767f,0.10963f,0.061306f,0.017226f,0.061006f,0.10958f,0.11735f,0.11066f,0.086884f,0.057744f,0.026151f,0.0018503f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016697f,0.059451f,0.104f,0.13974f,0.15702f,0.15962f,0.15223f,0.13355f,0.063692f,0.13353f,0.15211f,0.15945f,0.15675f,0.13934f,0.10352f,0.059047f,0.016456f,0.000000f,0.000000f},
   {0.000000f,1.2068e-018f,0.038851f,0.096919f,0.15087f,0.17987f,0.18511f,0.17445f,0.15817f,0.14379f,0.13384f,0.14378f,0.15816f,0.17444f,0.18509f,0.17981f,0.15076f,0.096821f,0.038797f,0.000000f,0.000000f},
   {0.000000f,0.0063777f,0.070344f,0.14288f,0.19068f,0.2049f,0.19453f,0.1758f,0.16036f,0.14645f,0.14681f,0.14646f,0.16036f,0.1758f,0.19453f,0.20473f,0.19031f,0.14227f,0.06984f,0.0061903f,0.000000f},
   {0.000000f,0.017224f,0.099719f,0.18101f,0.21822f,0.2193f,0.19777f,0.17979f,0.16475f,0.16187f,0.16149f,0.16187f,0.16477f,0.1798f,0.19777f,0.21922f,0.21792f,0.18045f,0.099116f,0.016918f,0.000000f},
   {0.000000f,0.02596f,0.12753f,0.21148f,0.23925f,0.22819f,0.20284f,0.18535f,0.18085f,0.17814f,0.17812f,0.17814f,0.18084f,0.18536f,0.20284f,0.22818f,0.23901f,0.21095f,0.12685f,0.025562f,0.000000f},
   {0.000000f,0.03194f,0.15144f,0.23904f,0.2564f,0.23733f,0.21182f,0.20371f,0.19964f,0.19751f,0.19694f,0.1975f,0.19963f,0.20369f,0.21184f,0.23733f,0.25621f,0.23853f,0.15068f,0.031485f,0.000000f},
   {0.000000f,0.051138f,0.17541f,0.26062f,0.27419f,0.24713f,0.23812f,0.22985f,0.2244f,0.22133f,0.22022f,0.22132f,0.22439f,0.22984f,0.2381f,0.24715f,0.274f,0.26009f,0.17455f,0.050511f,0.000000f},
   {0.000000f,0.08308f,0.18105f,0.28155f,0.29188f,0.28632f,0.27128f,0.26327f,0.25585f,0.25151f,0.25234f,0.2515f,0.25584f,0.26325f,0.27127f,0.28627f,0.29189f,0.28098f,0.18013f,0.082312f,0.000000f},
   {0.000000f,0.11865f,0.22314f,0.29977f,0.32517f,0.33282f,0.32312f,0.31164f,0.30095f,0.2946f,0.29542f,0.29459f,0.30094f,0.31163f,0.32308f,0.33259f,0.32473f,0.29967f,0.22211f,0.11774f,0.000000f},
   {0.000000f,0.15601f,0.26339f,0.30497f,0.3472f,0.38198f,0.39609f,0.39135f,0.3765f,0.36616f,0.36703f,0.36615f,0.37649f,0.39123f,0.39574f,0.3814f,0.34627f,0.30393f,0.26322f,0.15497f,0.000000f},
   {0.000000f,0.19222f,0.23448f,0.28578f,0.34732f,0.4169f,0.48293f,0.51439f,0.52067f,0.52104f,0.52661f,0.52086f,0.52026f,0.51365f,0.48176f,0.41543f,0.34579f,0.28436f,0.23319f,0.19202f,0.000000f},
   {1.1102e-016f,0.076479f,0.15764f,0.24801f,0.34452f,0.44874f,0.55712f,0.67263f,0.78467f,0.89574f,1.000000f,0.89382f,0.78261f,0.67046f,0.55485f,0.4464f,0.34213f,0.24558f,0.15519f,0.074014f,0.000000f}};

static float map_5point1_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043772f,0.011962f,0.018075f,0.022264f,0.035717f,0.058204f,0.083257f,0.10958f,0.13592f,0.052336f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013084f,0.011636f,0.027472f,0.049384f,0.070085f,0.089694f,0.10655f,0.12342f,0.12737f,0.15705f,0.18623f,0.16489f,0.10973f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0038919f,0.018492f,0.041753f,0.068513f,0.1006f,0.12983f,0.15652f,0.18313f,0.20135f,0.21775f,0.22851f,0.21738f,0.20108f,0.17363f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.016973f,0.040831f,0.073199f,0.10859f,0.14876f,0.1852f,0.21753f,0.24734f,0.26927f,0.28776f,0.27908f,0.25473f,0.24451f,0.24192f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013625f,0.010822f,0.031114f,0.061436f,0.10138f,0.14831f,0.19392f,0.2365f,0.27257f,0.30156f,0.32564f,0.33123f,0.32934f,0.31761f,0.29589f,0.31565f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00041878f,0.017789f,0.0433f,0.07868f,0.12602f,0.18248f,0.23686f,0.2799f,0.30936f,0.33175f,0.35421f,0.37263f,0.38012f,0.37444f,0.35999f,0.39234f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.01238f,0.046242f,0.085813f,0.14312f,0.21247f,0.26716f,0.29661f,0.31385f,0.34119f,0.3727f,0.40155f,0.42428f,0.43128f,0.43048f,0.47409f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0048489f,0.032179f,0.083684f,0.14641f,0.23272f,0.27225f,0.28139f,0.30767f,0.33894f,0.3788f,0.4187f,0.45626f,0.48466f,0.49857f,0.55339f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0029287f,0.015357f,0.040874f,0.082238f,0.14702f,0.23663f,0.25012f,0.27481f,0.30176f,0.33418f,0.37423f,0.42403f,0.4769f,0.52692f,0.56555f,0.63203f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.021156f,0.051639f,0.089163f,0.13307f,0.17997f,0.22386f,0.24772f,0.27249f,0.30054f,0.33231f,0.37158f,0.42577f,0.49302f,0.56398f,0.63586f,0.70711f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.01438f,0.049473f,0.099723f,0.15348f,0.20226f,0.24098f,0.24557f,0.25321f,0.27695f,0.30342f,0.33559f,0.37551f,0.42626f,0.49895f,0.59175f,0.69745f,0.77384f},
   {0.000000f,0.000000f,0.000000f,0.0023122f,0.031384f,0.081894f,0.14485f,0.19907f,0.24237f,0.268f,0.27012f,0.27589f,0.28486f,0.31064f,0.34157f,0.38293f,0.43576f,0.51188f,0.62473f,0.75361f,0.83195f},
   {0.000000f,0.000000f,0.000000f,0.0075151f,0.048878f,0.11169f,0.17871f,0.229f,0.263f,0.28867f,0.29793f,0.30177f,0.3099f,0.32047f,0.3505f,0.39422f,0.45043f,0.53218f,0.66167f,0.80779f,0.87965f},
   {0.000000f,0.000000f,0.000000f,0.014677f,0.066587f,0.13466f,0.19976f,0.24081f,0.2763f,0.30555f,0.32392f,0.33349f,0.34026f,0.3499f,0.36625f,0.41012f,0.46596f,0.55393f,0.69668f,0.85613f,0.91914f},
   {0.000000f,0.000000f,0.000000f,0.017689f,0.075976f,0.15229f,0.19715f,0.24172f,0.28192f,0.31654f,0.343f,0.3639f,0.37933f,0.39305f,0.40957f,0.42729f,0.49385f,0.58524f,0.72145f,0.8756f,0.94832f},
   {0.000000f,0.000000f,0.000000f,0.019339f,0.081415f,0.12939f,0.18521f,0.2329f,0.27908f,0.31978f,0.35395f,0.38326f,0.40917f,0.43346f,0.45546f,0.48528f,0.5172f,0.60794f,0.76272f,0.87113f,0.96987f},
   {0.000000f,0.000000f,0.000000f,0.016574f,0.049892f,0.094728f,0.15233f,0.20846f,0.26255f,0.31088f,0.35261f,0.39169f,0.42708f,0.46137f,0.49449f,0.53421f,0.57711f,0.6299f,0.74014f,0.85731f,0.9845f},
   {0.000000f,0.000000f,0.000000f,0.0025743f,0.010122f,0.048381f,0.095227f,0.15539f,0.22053f,0.28038f,0.33191f,0.38291f,0.42927f,0.47532f,0.52386f,0.57553f,0.64546f,0.68239f,0.71318f,0.83679f,0.99377f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022432f,0.019725f,0.067908f,0.13152f,0.19821f,0.26356f,0.3345f,0.39855f,0.46338f,0.53833f,0.61802f,0.68515f,0.7397f,0.78158f,0.8123f,0.99846f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.14292f,0.27953f,0.40639f,0.52748f,0.63323f,0.72837f,0.81116f,0.88423f,0.94629f,1.000000f}};

static float map_5point1_ls[21][21] = {
   {1.000000f,0.99863f,0.99396f,0.98481f,0.9703f,0.94888f,0.91914f,0.88048f,0.83195f,0.77384f,0.70834f,0.63338f,0.55484f,0.47562f,0.39394f,0.3173f,0.24362f,0.17537f,0.11147f,0.054079f,-7.8496e-017f},
   {0.99854f,0.94804f,0.94647f,0.94043f,0.92966f,0.91177f,0.87898f,0.82659f,0.76643f,0.70248f,0.63602f,0.56664f,0.49969f,0.43164f,0.36121f,0.29703f,0.24559f,0.20208f,0.16581f,0.13592f,0.000000f},
   {0.99373f,0.94619f,0.89929f,0.8973f,0.89f,0.84522f,0.80369f,0.75196f,0.69549f,0.64182f,0.59149f,0.53909f,0.48676f,0.43211f,0.3753f,0.31848f,0.25563f,0.21817f,0.18628f,0.11031f,0.000000f},
   {0.98443f,0.94057f,0.89693f,0.84178f,0.80673f,0.76938f,0.72295f,0.68173f,0.63988f,0.59999f,0.56152f,0.51902f,0.47535f,0.42864f,0.38061f,0.33006f,0.27965f,0.22857f,0.15778f,0.083896f,0.000000f},
   {0.96987f,0.92924f,0.89008f,0.8064f,0.72353f,0.68753f,0.64727f,0.61961f,0.59007f,0.5611f,0.53236f,0.49762f,0.45999f,0.41905f,0.37687f,0.33185f,0.28785f,0.21842f,0.12802f,0.058746f,0.000000f},
   {0.94832f,0.91132f,0.84488f,0.76916f,0.6876f,0.60199f,0.57793f,0.55557f,0.53786f,0.52026f,0.49866f,0.47305f,0.4406f,0.40425f,0.36538f,0.32707f,0.2697f,0.20197f,0.12403f,0.03616f,0.000000f},
   {0.91914f,0.87839f,0.80323f,0.72262f,0.64697f,0.57779f,0.51599f,0.49381f,0.48147f,0.4732f,0.46311f,0.44521f,0.41747f,0.38486f,0.34957f,0.30247f,0.24789f,0.18361f,0.10709f,0.022585f,0.000000f},
   {0.87965f,0.82586f,0.75136f,0.68116f,0.61943f,0.55563f,0.49394f,0.45149f,0.43778f,0.42773f,0.42381f,0.41464f,0.39077f,0.36007f,0.32202f,0.27305f,0.21805f,0.15706f,0.090176f,0.018356f,0.000000f},
   {0.83195f,0.76558f,0.69482f,0.63955f,0.58992f,0.53794f,0.48142f,0.43767f,0.40132f,0.39038f,0.38425f,0.38246f,0.35885f,0.3262f,0.2847f,0.23683f,0.18569f,0.13031f,0.070512f,0.012179f,0.000000f},
   {0.77494f,0.70182f,0.64105f,0.59937f,0.5609f,0.52028f,0.47314f,0.42777f,0.39034f,0.35673f,0.34932f,0.34449f,0.31565f,0.27779f,0.23728f,0.19424f,0.14921f,0.10103f,0.049741f,0.0045097f,0.000000f},
   {0.70711f,0.63577f,0.59134f,0.56143f,0.53234f,0.49869f,0.46315f,0.42387f,0.38431f,0.34937f,0.3185f,0.28163f,0.2449f,0.21252f,0.18253f,0.14834f,0.1086f,0.068513f,0.027472f,-8.5322e-019f,0.000000f},
   {0.63338f,0.56555f,0.53856f,0.51865f,0.49722f,0.47263f,0.44507f,0.41451f,0.38241f,0.34452f,0.2816f,0.24145f,0.18988f,0.15379f,0.12638f,0.10174f,0.073541f,0.042039f,0.011806f,0.000000f,0.000000f},
   {0.55339f,0.49871f,0.48607f,0.47475f,0.45953f,0.44013f,0.41724f,0.39065f,0.35885f,0.31539f,0.24485f,0.1898f,0.16119f,0.11535f,0.083376f,0.061737f,0.041097f,0.018696f,0.0013628f,0.000000f,0.000000f},
   {0.47409f,0.43048f,0.43138f,0.42817f,0.41859f,0.40381f,0.38442f,0.36003f,0.32583f,0.27748f,0.21245f,0.15351f,0.11527f,0.092466f,0.055926f,0.03134f,0.017152f,0.0039822f,0.000000f,0.000000f,0.000000f},
   {0.39234f,0.35999f,0.37455f,0.38033f,0.37646f,0.36503f,0.34948f,0.32174f,0.28429f,0.23686f,0.18246f,0.12608f,0.083197f,0.055812f,0.03557f,0.011379f,0.0039191f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.31565f,0.29607f,0.31773f,0.32943f,0.33124f,0.32696f,0.30198f,0.27263f,0.2365f,0.19392f,0.14828f,0.10138f,0.061436f,0.031114f,0.011267f,0.002725f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24192f,0.24451f,0.25473f,0.27908f,0.28772f,0.26927f,0.24734f,0.21753f,0.18526f,0.14882f,0.10856f,0.073199f,0.040831f,0.01704f,0.0038302f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17365f,0.20108f,0.21738f,0.22846f,0.21775f,0.20135f,0.18335f,0.15652f,0.12991f,0.1006f,0.068474f,0.041753f,0.018492f,0.0038919f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.10973f,0.16489f,0.18616f,0.15705f,0.12737f,0.12342f,0.10655f,0.089694f,0.070085f,0.049384f,0.027446f,0.011636f,0.0013628f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.052332f,0.13583f,0.10958f,0.083257f,0.058204f,0.035717f,0.022438f,0.018227f,0.011962f,0.0043772f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_5point1_rs[21][21] = {
   {-7.8496e-017f,0.052336f,0.10973f,0.17365f,0.24192f,0.31565f,0.39394f,0.47409f,0.55484f,0.63338f,0.70587f,0.77384f,0.83195f,0.87965f,0.91914f,0.94832f,0.96987f,0.9845f,0.99377f,0.99854f,1.000000f},
   {0.000000f,0.13583f,0.16489f,0.20208f,0.24451f,0.29589f,0.35999f,0.43048f,0.49857f,0.56633f,0.63558f,0.70182f,0.76558f,0.82586f,0.87839f,0.91132f,0.92934f,0.94057f,0.94637f,0.94804f,0.99863f},
   {0.000000f,0.11031f,0.18615f,0.21738f,0.25552f,0.31761f,0.37444f,0.43128f,0.48597f,0.53856f,0.59121f,0.64167f,0.69482f,0.75136f,0.80323f,0.84488f,0.89008f,0.89725f,0.89927f,0.94647f,0.99396f},
   {0.000000f,0.083257f,0.15778f,0.22845f,0.27908f,0.32934f,0.38061f,0.42817f,0.47475f,0.51865f,0.56131f,0.59998f,0.63948f,0.6818f,0.72306f,0.76916f,0.80688f,0.84174f,0.8973f,0.94077f,0.98473f},
   {0.000000f,0.058746f,0.12737f,0.2183f,0.28772f,0.33167f,0.37646f,0.41852f,0.45953f,0.49722f,0.53221f,0.56083f,0.58986f,0.61943f,0.64753f,0.6876f,0.72348f,0.80673f,0.89031f,0.92966f,0.9703f},
   {0.000000f,0.035717f,0.12342f,0.20135f,0.26927f,0.32696f,0.36503f,0.40381f,0.44057f,0.47309f,0.49858f,0.52028f,0.53794f,0.55557f,0.57829f,0.60191f,0.688f,0.76938f,0.84522f,0.91177f,0.94888f},
   {0.000000f,0.022264f,0.10655f,0.18361f,0.24774f,0.30233f,0.34948f,0.3848f,0.41719f,0.44502f,0.46308f,0.47314f,0.48142f,0.49394f,0.51592f,0.57793f,0.64727f,0.72306f,0.80369f,0.87898f,0.91982f},
   {0.000000f,0.018075f,0.089694f,0.15698f,0.21753f,0.27257f,0.32174f,0.36002f,0.39065f,0.41451f,0.4238f,0.42773f,0.43804f,0.45143f,0.49424f,0.55557f,0.61961f,0.68173f,0.75196f,0.82659f,0.88048f},
   {0.000000f,0.011962f,0.070085f,0.12983f,0.1852f,0.2365f,0.28429f,0.32614f,0.35884f,0.38237f,0.38425f,0.39034f,0.40127f,0.43778f,0.48142f,0.53827f,0.59007f,0.63988f,0.69549f,0.76643f,0.83292f},
   {0.000000f,0.0043772f,0.049741f,0.10103f,0.14876f,0.19392f,0.23686f,0.27743f,0.31539f,0.34452f,0.34932f,0.35669f,0.39034f,0.42773f,0.47315f,0.52061f,0.5611f,0.59999f,0.64182f,0.7028f,0.77494f},
   {0.000000f,-8.5322e-019f,0.027447f,0.068465f,0.10853f,0.14825f,0.18244f,0.21244f,0.24485f,0.28161f,0.31849f,0.34932f,0.38425f,0.42381f,0.46314f,0.49869f,0.53239f,0.56152f,0.59147f,0.63596f,0.70711f},
   {0.000000f,0.000000f,0.011636f,0.041753f,0.073199f,0.1017f,0.12603f,0.15351f,0.18976f,0.24145f,0.28164f,0.34451f,0.38246f,0.41464f,0.44521f,0.47305f,0.49762f,0.51919f,0.5393f,0.56664f,0.63338f},
   {0.000000f,0.000000f,0.0013084f,0.018492f,0.040831f,0.061737f,0.083146f,0.11527f,0.16121f,0.18988f,0.2449f,0.31565f,0.35887f,0.39092f,0.41747f,0.4406f,0.45999f,0.47535f,0.48676f,0.49969f,0.55484f},
   {0.000000f,0.000000f,0.000000f,0.0038919f,0.016973f,0.031114f,0.056058f,0.092505f,0.11557f,0.15374f,0.21251f,0.27779f,0.3262f,0.36008f,0.38486f,0.40425f,0.41905f,0.42882f,0.43211f,0.43164f,0.47562f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.011267f,0.0356f,0.055926f,0.083376f,0.12638f,0.18252f,0.23728f,0.2847f,0.32214f,0.34955f,0.36552f,0.37704f,0.38081f,0.3753f,0.36121f,0.39394f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027341f,0.011405f,0.03134f,0.061737f,0.10174f,0.14834f,0.19436f,0.23696f,0.27305f,0.30247f,0.32704f,0.33185f,0.33006f,0.31848f,0.29703f,0.3173f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039191f,0.017152f,0.041097f,0.073541f,0.10862f,0.14921f,0.18569f,0.21805f,0.24789f,0.26986f,0.28782f,0.27982f,0.25563f,0.24559f,0.24362f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039822f,0.018696f,0.042039f,0.068554f,0.10103f,0.13031f,0.15706f,0.1837f,0.20197f,0.21842f,0.22858f,0.21822f,0.20208f,0.17537f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013628f,0.011806f,0.027511f,0.049741f,0.070512f,0.090176f,0.10709f,0.12403f,0.12802f,0.15778f,0.1863f,0.16581f,0.11147f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-8.5322e-019f,0.0045097f,0.012179f,0.018356f,0.022585f,0.03616f,0.058746f,0.083896f,0.11031f,0.136f,0.054075f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-7.8496e-017f}};

static float map_6point1_ang[] = {-27,0,27,-100,100,180};
static float map_6point1_xsf[] = {-1,0,1,-1,1,0};
static float map_6point1_ysf[] = {1,1,1,0,0,-1};
channel_id map_6point1_id[] = {ci_front_left,ci_front_center,ci_front_right,ci_side_center_left,ci_side_center_right,ci_back_center,ci_lfe};

static float map_6point1_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0025743f,0.016552f,0.019339f,0.017689f,0.014677f,0.0075151f,0.0023122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.010122f,0.049892f,0.081385f,0.075976f,0.066587f,0.048878f,0.031384f,0.01438f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0022432f,0.048381f,0.094728f,0.12939f,0.15091f,0.13421f,0.11169f,0.081894f,0.049473f,0.021188f,0.0029287f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019725f,0.095227f,0.15233f,0.18129f,0.18619f,0.18195f,0.1662f,0.14038f,0.099716f,0.051668f,0.015357f,0.0004627f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.067908f,0.15539f,0.20448f,0.21574f,0.21038f,0.19727f,0.18275f,0.16961f,0.14309f,0.089211f,0.030602f,0.0029125f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13152f,0.21916f,0.24385f,0.23799f,0.22019f,0.19777f,0.1798f,0.16484f,0.15891f,0.12092f,0.0391f,0.0061765f,0.0028379f,0.00043186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19821f,0.26858f,0.26884f,0.24624f,0.21773f,0.19453f,0.1758f,0.16036f,0.14653f,0.13495f,0.052607f,0.038854f,0.030373f,0.015188f,0.0028496f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.26351f,0.30441f,0.28405f,0.24723f,0.21577f,0.19296f,0.17452f,0.15823f,0.14384f,0.13114f,0.13492f,0.12086f,0.089089f,0.051572f,0.021112f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.14292f,0.32999f,0.33317f,0.29065f,0.24843f,0.21902f,0.19594f,0.17746f,0.1625f,0.14962f,0.14386f,0.14651f,0.15886f,0.14285f,0.099312f,0.049149f,0.01419f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.27953f,0.38637f,0.35876f,0.29909f,0.25487f,0.22426f,0.20041f,0.18277f,0.16832f,0.16249f,0.15824f,0.16036f,0.16482f,0.16948f,0.14005f,0.081488f,0.031102f,0.0022352f,0.000000f,0.000000f,0.000000f},
   {0.40639f,0.44503f,0.38515f,0.31183f,0.26428f,0.23169f,0.20647f,0.18936f,0.18276f,0.17745f,0.17453f,0.1758f,0.17979f,0.18273f,0.16592f,0.11122f,0.048526f,0.0073556f,0.000000f,0.000000f,0.000000f},
   {0.52748f,0.51574f,0.41678f,0.32546f,0.27415f,0.24175f,0.21641f,0.20646f,0.2004f,0.19593f,0.19298f,0.19453f,0.19777f,0.19716f,0.18189f,0.13374f,0.066173f,0.014462f,0.000000f,0.000000f,0.000000f},
   {0.63323f,0.58186f,0.4515f,0.34992f,0.2914f,0.25248f,0.24174f,0.23169f,0.22425f,0.219f,0.21579f,0.21773f,0.22013f,0.21018f,0.18585f,0.15082f,0.075526f,0.017441f,0.000000f,0.000000f,0.000000f},
   {0.72837f,0.62641f,0.51744f,0.37803f,0.31074f,0.29139f,0.27414f,0.26427f,0.25485f,0.24842f,0.24726f,0.24619f,0.23779f,0.2154f,0.18082f,0.12881f,0.081296f,0.019071f,0.000000f,0.000000f,0.000000f},
   {0.81116f,0.6558f,0.5246f,0.41789f,0.37802f,0.34991f,0.32545f,0.31182f,0.29908f,0.29063f,0.28406f,0.26859f,0.24346f,0.20392f,0.15167f,0.09417f,0.04946f,0.016531f,0.000000f,0.000000f,0.000000f},
   {0.88423f,0.67127f,0.52691f,0.5245f,0.51721f,0.45136f,0.41661f,0.38495f,0.35851f,0.33283f,0.30436f,0.26801f,0.21844f,0.15464f,0.094607f,0.047925f,0.0098814f,0.0024671f,0.000000f,0.000000f,0.000000f},
   {0.94622f,0.67633f,0.67099f,0.65523f,0.62554f,0.58081f,0.51465f,0.44406f,0.38544f,0.32902f,0.26339f,0.19725f,0.13069f,0.067274f,0.019339f,0.0021311f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.94446f,0.8823f,0.80914f,0.72626f,0.63102f,0.52519f,0.40402f,0.27711f,0.14046f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_6point1_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.001914f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.0155f,0.025167f,0.017695f,0.0063155f,1.0116e-005f,0.000000f,0.000000f,0.0062031f,0.017508f,0.025125f,0.015305f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0056317f,0.024256f,0.044322f,0.061583f,0.065405f,0.041656f,0.014688f,4.0817e-019f,0.014527f,0.041389f,0.065342f,0.061236f,0.044002f,0.024003f,0.005504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0019274f,0.02644f,0.05812f,0.08731f,0.11105f,0.11767f,0.10963f,0.061306f,0.017226f,0.061006f,0.10958f,0.11735f,0.11066f,0.086884f,0.057744f,0.026151f,0.0018503f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016697f,0.059451f,0.104f,0.13974f,0.15702f,0.15962f,0.15223f,0.13355f,0.063692f,0.13353f,0.15211f,0.15945f,0.15675f,0.13934f,0.10352f,0.059047f,0.016456f,0.000000f,0.000000f},
   {0.000000f,1.2068e-018f,0.038851f,0.096919f,0.15087f,0.17987f,0.18511f,0.17445f,0.15817f,0.14379f,0.13384f,0.14378f,0.15816f,0.17444f,0.18509f,0.17981f,0.15076f,0.096821f,0.038797f,0.000000f,0.000000f},
   {0.000000f,0.0063777f,0.070344f,0.14288f,0.19068f,0.2049f,0.19453f,0.1758f,0.16036f,0.14645f,0.14681f,0.14646f,0.16036f,0.1758f,0.19453f,0.20473f,0.19031f,0.14227f,0.06984f,0.0061903f,0.000000f},
   {0.000000f,0.017224f,0.099719f,0.18101f,0.21822f,0.2193f,0.19777f,0.17979f,0.16475f,0.16187f,0.16149f,0.16187f,0.16477f,0.1798f,0.19777f,0.21922f,0.21792f,0.18045f,0.099116f,0.016918f,0.000000f},
   {0.000000f,0.02596f,0.12753f,0.21148f,0.23925f,0.22819f,0.20284f,0.18535f,0.18085f,0.17814f,0.17812f,0.17814f,0.18084f,0.18536f,0.20284f,0.22818f,0.23901f,0.21095f,0.12685f,0.025562f,0.000000f},
   {0.000000f,0.03194f,0.15144f,0.23904f,0.2564f,0.23733f,0.21182f,0.20371f,0.19964f,0.19751f,0.19694f,0.1975f,0.19963f,0.20369f,0.21184f,0.23733f,0.25621f,0.23853f,0.15068f,0.031485f,0.000000f},
   {0.000000f,0.051138f,0.17541f,0.26062f,0.27419f,0.24713f,0.23812f,0.22985f,0.2244f,0.22133f,0.22022f,0.22132f,0.22439f,0.22984f,0.2381f,0.24715f,0.274f,0.26009f,0.17455f,0.050511f,0.000000f},
   {0.000000f,0.08308f,0.18105f,0.28155f,0.29188f,0.28632f,0.27128f,0.26327f,0.25585f,0.25151f,0.25234f,0.2515f,0.25584f,0.26325f,0.27127f,0.28627f,0.29189f,0.28098f,0.18013f,0.082312f,0.000000f},
   {0.000000f,0.11865f,0.22314f,0.29977f,0.32517f,0.33282f,0.32312f,0.31164f,0.30095f,0.2946f,0.29542f,0.29459f,0.30094f,0.31163f,0.32308f,0.33259f,0.32473f,0.29967f,0.22211f,0.11774f,0.000000f},
   {0.000000f,0.15601f,0.26339f,0.30497f,0.3472f,0.38198f,0.39609f,0.39135f,0.3765f,0.36616f,0.36703f,0.36615f,0.37649f,0.39123f,0.39574f,0.3814f,0.34627f,0.30393f,0.26322f,0.15497f,0.000000f},
   {0.000000f,0.19222f,0.23448f,0.28578f,0.34732f,0.4169f,0.48293f,0.51439f,0.52067f,0.52104f,0.52661f,0.52086f,0.52026f,0.51365f,0.48176f,0.41543f,0.34579f,0.28436f,0.23319f,0.19202f,0.000000f},
   {1.1102e-016f,0.076479f,0.15764f,0.24801f,0.34452f,0.44874f,0.55712f,0.67263f,0.78467f,0.89574f,1.000000f,0.89382f,0.78261f,0.67046f,0.55485f,0.4464f,0.34213f,0.24558f,0.15519f,0.074014f,0.000000f}};

static float map_6point1_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022352f,0.0073556f,0.014462f,0.017441f,0.019071f,0.016531f,0.0024671f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01419f,0.031102f,0.048526f,0.066173f,0.075526f,0.081297f,0.04946f,0.0098814f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028496f,0.021112f,0.049149f,0.081488f,0.11122f,0.13374f,0.15081f,0.12881f,0.09417f,0.047925f,0.0021311f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00043186f,0.015188f,0.051545f,0.099312f,0.14005f,0.16592f,0.1819f,0.18585f,0.18082f,0.15167f,0.094607f,0.019339f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028379f,0.030373f,0.089057f,0.14285f,0.16948f,0.18273f,0.19716f,0.21018f,0.2154f,0.20392f,0.15464f,0.067274f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0004627f,0.0029125f,0.0061679f,0.038854f,0.12083f,0.15886f,0.16483f,0.17979f,0.19777f,0.22013f,0.23779f,0.24346f,0.21844f,0.13069f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0029287f,0.015357f,0.030602f,0.0391f,0.052555f,0.13491f,0.14652f,0.16036f,0.1758f,0.19453f,0.21773f,0.24619f,0.26859f,0.26801f,0.19725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.021156f,0.051639f,0.089163f,0.1209f,0.13493f,0.13114f,0.14385f,0.15824f,0.17453f,0.19297f,0.21578f,0.24725f,0.28402f,0.30431f,0.2633f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.01438f,0.049473f,0.099716f,0.14309f,0.15891f,0.1465f,0.14385f,0.14961f,0.16249f,0.17745f,0.19593f,0.219f,0.24842f,0.29063f,0.33283f,0.32902f,0.14046f},
   {0.000000f,0.000000f,0.000000f,0.0023122f,0.031384f,0.081894f,0.14038f,0.16961f,0.16482f,0.16036f,0.15824f,0.1625f,0.16831f,0.18276f,0.2004f,0.22425f,0.25485f,0.29908f,0.35851f,0.38544f,0.27711f},
   {0.000000f,0.000000f,0.000000f,0.0075151f,0.048878f,0.11169f,0.1662f,0.18272f,0.1798f,0.1758f,0.17453f,0.17746f,0.18277f,0.18935f,0.20646f,0.23169f,0.26427f,0.31182f,0.38495f,0.44406f,0.40402f},
   {0.000000f,0.000000f,0.000000f,0.014677f,0.066587f,0.13421f,0.18194f,0.19727f,0.19777f,0.19453f,0.19297f,0.19594f,0.20041f,0.20647f,0.2164f,0.24174f,0.27414f,0.32545f,0.41661f,0.51465f,0.52519f},
   {0.000000f,0.000000f,0.000000f,0.017689f,0.075976f,0.15092f,0.18619f,0.21038f,0.22019f,0.21773f,0.21578f,0.21902f,0.22426f,0.23169f,0.24175f,0.25247f,0.29139f,0.34991f,0.45136f,0.58081f,0.63102f},
   {0.000000f,0.000000f,0.000000f,0.019339f,0.081415f,0.12939f,0.18129f,0.21574f,0.23799f,0.24624f,0.24725f,0.24843f,0.25487f,0.26428f,0.27415f,0.2914f,0.31073f,0.37802f,0.51721f,0.62554f,0.72626f},
   {0.000000f,0.000000f,0.000000f,0.016574f,0.049892f,0.094728f,0.15233f,0.20448f,0.24385f,0.26884f,0.28405f,0.29065f,0.29909f,0.31183f,0.32546f,0.34992f,0.37803f,0.41787f,0.5245f,0.65523f,0.80914f},
   {0.000000f,0.000000f,0.000000f,0.0025743f,0.010122f,0.048381f,0.095227f,0.15539f,0.21916f,0.26858f,0.3044f,0.33317f,0.35876f,0.38515f,0.41678f,0.4515f,0.51744f,0.5246f,0.52688f,0.67099f,0.8823f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022432f,0.019725f,0.067908f,0.13152f,0.19821f,0.26356f,0.32999f,0.38637f,0.44503f,0.51574f,0.58186f,0.62641f,0.6558f,0.67127f,0.6763f,0.94439f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.14292f,0.27953f,0.40639f,0.52748f,0.63323f,0.72837f,0.81116f,0.88423f,0.94629f,1.000000f}};

static float map_6point1_lsm[21][21] = {
   {0.70711f,0.66913f,0.62524f,0.57358f,0.51504f,0.44776f,0.37137f,0.28736f,0.19595f,0.09932f,0.0017453f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.74431f,0.67052f,0.63067f,0.58131f,0.52602f,0.46257f,0.39662f,0.34064f,0.29043f,0.23885f,0.18653f,0.14016f,0.092998f,0.048018f,0.013948f,0.0015862f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78118f,0.70817f,0.63603f,0.59409f,0.54607f,0.49466f,0.44615f,0.39987f,0.3534f,0.30593f,0.25428f,0.20602f,0.1569f,0.10988f,0.067336f,0.03421f,0.0071573f,0.0017445f,1.8971e-005f,0.000000f,0.000000f},
   {0.82009f,0.7491f,0.67504f,0.59533f,0.54885f,0.50805f,0.46863f,0.43198f,0.3925f,0.3484f,0.29792f,0.24908f,0.19887f,0.14971f,0.10724f,0.066983f,0.034974f,0.011749f,0.000000f,0.000000f,0.000000f},
   {0.85806f,0.78908f,0.71292f,0.59185f,0.51167f,0.47976f,0.45026f,0.42613f,0.39843f,0.36635f,0.32582f,0.27812f,0.2264f,0.17681f,0.13329f,0.091492f,0.057623f,0.013674f,0.000000f,0.000000f,0.000000f},
   {0.89493f,0.82759f,0.70113f,0.58024f,0.49236f,0.42569f,0.40827f,0.39203f,0.37751f,0.3594f,0.33252f,0.2937f,0.24301f,0.19308f,0.14677f,0.10873f,0.053405f,0.012508f,0.000000f,0.000000f,0.000000f},
   {0.92849f,0.84684f,0.69067f,0.55271f,0.46468f,0.40867f,0.36488f,0.3485f,0.33949f,0.33308f,0.32163f,0.29457f,0.2509f,0.20107f,0.15394f,0.095531f,0.047084f,0.010226f,0.000000f,0.000000f,0.000000f},
   {0.95832f,0.82839f,0.66354f,0.53162f,0.45013f,0.39368f,0.3497f,0.31927f,0.30903f,0.30128f,0.29789f,0.28393f,0.24451f,0.19473f,0.13488f,0.078979f,0.034562f,0.005314f,0.000000f,0.000000f,0.000000f},
   {0.98061f,0.79322f,0.63001f,0.51243f,0.43605f,0.38298f,0.34135f,0.30979f,0.2838f,0.27526f,0.27009f,0.26562f,0.22628f,0.16159f,0.10558f,0.05762f,0.022192f,0.001635f,0.000000f,0.000000f,0.000000f},
   {0.99506f,0.75369f,0.60114f,0.49963f,0.42717f,0.37619f,0.33605f,0.30362f,0.27677f,0.25226f,0.24553f,0.23722f,0.17367f,0.11587f,0.07052f,0.034753f,0.010168f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.71295f,0.58231f,0.49634f,0.42725f,0.37287f,0.33346f,0.30159f,0.27344f,0.24858f,0.22384f,0.15914f,0.10274f,0.063092f,0.036535f,0.01499f,0.0013716f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.66033f,0.55567f,0.48451f,0.42558f,0.37493f,0.33506f,0.30245f,0.27526f,0.25008f,0.23921f,0.17075f,0.088654f,0.036166f,0.010859f,0.0020709f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78261f,0.61267f,0.53096f,0.47309f,0.42398f,0.37972f,0.33948f,0.30798f,0.28134f,0.27269f,0.24365f,0.17958f,0.11398f,0.043395f,0.0065303f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67046f,0.56122f,0.50057f,0.45582f,0.41557f,0.37846f,0.34285f,0.31459f,0.29944f,0.27681f,0.23747f,0.18093f,0.11935f,0.065362f,0.017508f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55485f,0.49543f,0.46264f,0.43028f,0.39912f,0.36952f,0.34049f,0.32017f,0.29681f,0.26475f,0.22159f,0.16749f,0.11097f,0.061236f,0.025146f,0.00059225f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.4464f,0.41694f,0.41528f,0.39917f,0.37733f,0.35383f,0.33184f,0.30683f,0.27684f,0.23948f,0.19477f,0.14135f,0.086884f,0.044002f,0.015305f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34213f,0.34579f,0.35326f,0.3597f,0.34941f,0.3274f,0.303f,0.27332f,0.23991f,0.20034f,0.15216f,0.10352f,0.057744f,0.024003f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24558f,0.28436f,0.30568f,0.3114f,0.29446f,0.27242f,0.24876f,0.21615f,0.18203f,0.14227f,0.096837f,0.059047f,0.026151f,0.005504f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15519f,0.23319f,0.26327f,0.22211f,0.18013f,0.17455f,0.15068f,0.12685f,0.099116f,0.06984f,0.038815f,0.016456f,0.0018503f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.074009f,0.19209f,0.15497f,0.11774f,0.082312f,0.050511f,0.031485f,0.025562f,0.016918f,0.0061903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_6point1_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.09932f,0.19595f,0.28569f,0.37137f,0.4462f,0.51354f,0.57215f,0.62388f,0.66783f,0.70711f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0015069f,0.013675f,0.04757f,0.092412f,0.13947f,0.18623f,0.23884f,0.28947f,0.33956f,0.3954f,0.46121f,0.52464f,0.58106f,0.62943f,0.67037f,0.74314f},
   {0.000000f,0.000000f,0.000000f,0.0017445f,0.0069872f,0.033888f,0.066897f,0.10935f,0.15631f,0.20597f,0.25403f,0.30519f,0.35262f,0.39905f,0.44526f,0.4937f,0.54585f,0.59298f,0.63586f,0.70784f,0.78043f},
   {0.000000f,0.000000f,0.000000f,0.011689f,0.034974f,0.066588f,0.10724f,0.1497f,0.1983f,0.24897f,0.29771f,0.34778f,0.39193f,0.43144f,0.46866f,0.50751f,0.54828f,0.59521f,0.67489f,0.74808f,0.81909f},
   {0.000000f,0.000000f,0.000000f,0.013485f,0.057506f,0.09108f,0.13328f,0.17632f,0.22589f,0.2776f,0.32564f,0.36597f,0.39813f,0.42588f,0.45006f,0.48004f,0.51166f,0.59204f,0.71215f,0.78873f,0.85717f},
   {0.000000f,0.000000f,0.000000f,0.012333f,0.053405f,0.10859f,0.14672f,0.19262f,0.24254f,0.2933f,0.33243f,0.35959f,0.37779f,0.39201f,0.40827f,0.42573f,0.49232f,0.58002f,0.70065f,0.82687f,0.89415f},
   {0.000000f,0.000000f,0.000000f,0.010226f,0.046792f,0.09516f,0.15378f,0.20065f,0.25051f,0.2943f,0.3216f,0.33307f,0.33948f,0.34884f,0.36492f,0.40905f,0.46512f,0.55322f,0.69045f,0.84644f,0.92784f},
   {0.000000f,0.000000f,0.000000f,0.0052012f,0.034313f,0.078646f,0.13483f,0.19459f,0.24448f,0.28376f,0.29792f,0.30128f,0.30903f,0.3193f,0.34969f,0.39367f,0.45013f,0.53213f,0.66357f,0.82833f,0.95782f},
   {0.000000f,0.000000f,0.000000f,0.0015805f,0.021993f,0.05762f,0.10524f,0.16123f,0.22617f,0.2655f,0.27011f,0.27526f,0.28382f,0.31008f,0.34135f,0.38297f,0.43605f,0.51242f,0.63017f,0.79346f,0.98027f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.010034f,0.034753f,0.070224f,0.11554f,0.17334f,0.23718f,0.24556f,0.25229f,0.27677f,0.30362f,0.33605f,0.37619f,0.42717f,0.50011f,0.60174f,0.7542f,0.99488f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0013625f,0.014928f,0.036467f,0.062995f,0.10266f,0.15909f,0.22385f,0.24859f,0.27345f,0.3016f,0.33348f,0.37289f,0.42727f,0.49639f,0.58242f,0.71313f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.002015f,0.01075f,0.036165f,0.08878f,0.17076f,0.23925f,0.2501f,0.27526f,0.30245f,0.33506f,0.37529f,0.42563f,0.4847f,0.55608f,0.6612f,0.89574f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0066209f,0.043663f,0.11403f,0.17987f,0.2437f,0.27272f,0.28136f,0.30799f,0.33949f,0.3801f,0.42413f,0.47338f,0.53148f,0.61367f,0.78467f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017695f,0.065451f,0.11973f,0.18126f,0.23753f,0.27698f,0.29973f,0.31462f,0.34319f,0.37861f,0.41582f,0.45622f,0.50122f,0.56241f,0.67263f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062925f,0.0252f,0.061583f,0.11138f,0.16787f,0.22165f,0.26504f,0.29704f,0.32036f,0.34055f,0.36977f,0.39947f,0.43083f,0.46342f,0.49688f,0.55712f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.0155f,0.044322f,0.08731f,0.14181f,0.19485f,0.23988f,0.27721f,0.30717f,0.33223f,0.35391f,0.37781f,0.3998f,0.41619f,0.41848f,0.44874f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.024256f,0.05812f,0.104f,0.15226f,0.20085f,0.24041f,0.27381f,0.30349f,0.32791f,0.34951f,0.36044f,0.35436f,0.34732f,0.34452f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0056317f,0.02644f,0.059451f,0.09695f,0.14288f,0.18265f,0.2168f,0.24942f,0.27312f,0.29522f,0.31155f,0.30679f,0.28578f,0.24801f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019274f,0.016697f,0.038906f,0.070344f,0.099719f,0.12753f,0.15144f,0.17541f,0.18105f,0.22314f,0.26347f,0.23448f,0.15764f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.2068e-018f,0.0063777f,0.017224f,0.02596f,0.03194f,0.051138f,0.08308f,0.11865f,0.15601f,0.19233f,0.076473f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f}};

static float map_6point1_cs[21][21] = {
   {0.70711f,0.74314f,0.78043f,0.81915f,0.85717f,0.89415f,0.92849f,0.95782f,0.98061f,0.99506f,0.999998f,0.99506f,0.98061f,0.95832f,0.92849f,0.89493f,0.85806f,0.82015f,0.78152f,0.74431f,0.70711f},
   {0.66783f,0.67021f,0.70784f,0.74866f,0.78873f,0.82837f,0.86012f,0.8759f,0.88587f,0.89408f,0.89916f,0.89385f,0.88622f,0.87641f,0.86079f,0.82918f,0.78964f,0.7491f,0.70894f,0.67037f,0.66913f},
   {0.62417f,0.62995f,0.63575f,0.67663f,0.71956f,0.73454f,0.75734f,0.77291f,0.78464f,0.79125f,0.79739f,0.79171f,0.78498f,0.77342f,0.75801f,0.73534f,0.72008f,0.67767f,0.63591f,0.63067f,0.62524f},
   {0.5721f,0.58106f,0.5934f,0.60681f,0.62701f,0.64661f,0.66073f,0.67632f,0.68458f,0.69003f,0.69701f,0.69043f,0.68486f,0.67696f,0.66115f,0.64722f,0.6278f,0.60693f,0.59409f,0.58237f,0.57353f},
   {0.51354f,0.52507f,0.54585f,0.56206f,0.56907f,0.58364f,0.59298f,0.60244f,0.6042f,0.60125f,0.60184f,0.60129f,0.60434f,0.60269f,0.59353f,0.58386f,0.56913f,0.56253f,0.54693f,0.52602f,0.51504f},
   {0.4462f,0.46121f,0.4937f,0.51984f,0.53345f,0.53229f,0.54046f,0.54229f,0.5388f,0.53032f,0.52524f,0.53015f,0.53867f,0.54244f,0.54089f,0.5323f,0.53405f,0.52056f,0.49466f,0.46257f,0.44776f},
   {0.37137f,0.3954f,0.44526f,0.47914f,0.49706f,0.50302f,0.49345f,0.48927f,0.4812f,0.47361f,0.46973f,0.4736f,0.4812f,0.48919f,0.49341f,0.50317f,0.49734f,0.47957f,0.44615f,0.39662f,0.37299f},
   {0.28569f,0.33956f,0.39905f,0.43688f,0.46019f,0.47066f,0.46616f,0.44842f,0.43721f,0.42793f,0.42483f,0.42793f,0.43736f,0.44835f,0.46652f,0.471f,0.46069f,0.4373f,0.39987f,0.34064f,0.28736f},
   {0.19595f,0.28947f,0.35262f,0.39351f,0.42012f,0.43541f,0.43852f,0.429f,0.4003f,0.39016f,0.38518f,0.39016f,0.4002f,0.42896f,0.43875f,0.43588f,0.42062f,0.39413f,0.3534f,0.29043f,0.19766f},
   {0.09932f,0.23884f,0.30544f,0.34801f,0.376f,0.39434f,0.40329f,0.40229f,0.38759f,0.35582f,0.35016f,0.35573f,0.38763f,0.40246f,0.40359f,0.39481f,0.37652f,0.3484f,0.30593f,0.23972f,0.10106f},
   {-6.1232e-017f,0.18616f,0.25397f,0.29765f,0.32695f,0.34731f,0.358f,0.36085f,0.35551f,0.3409f,0.3193f,0.34085f,0.35548f,0.36084f,0.35803f,0.34735f,0.32701f,0.29772f,0.25404f,0.18625f,-6.1232e-017f},
   {0.000000f,0.13947f,0.20597f,0.24897f,0.2776f,0.29548f,0.30504f,0.30524f,0.29297f,0.2743f,0.25444f,0.27429f,0.29326f,0.30557f,0.30543f,0.29577f,0.27812f,0.24955f,0.20661f,0.14016f,0.000000f},
   {0.000000f,0.092412f,0.15631f,0.1983f,0.22589f,0.24271f,0.25081f,0.24649f,0.2305f,0.20098f,0.18809f,0.20115f,0.23052f,0.24687f,0.25123f,0.24301f,0.2264f,0.19887f,0.1569f,0.092998f,0.000000f},
   {0.000000f,0.04757f,0.10935f,0.1497f,0.17632f,0.19262f,0.2008f,0.19456f,0.16341f,0.13718f,0.12599f,0.13735f,0.1636f,0.1946f,0.20107f,0.19308f,0.17681f,0.15022f,0.10988f,0.048018f,0.000000f},
   {0.000000f,0.013675f,0.066897f,0.1073f,0.13328f,0.14672f,0.15375f,0.13483f,0.10556f,0.081083f,0.072929f,0.08126f,0.10589f,0.13521f,0.15379f,0.14716f,0.13374f,0.10771f,0.067336f,0.013948f,0.000000f},
   {0.000000f,0.0015069f,0.033888f,0.066588f,0.091112f,0.10856f,0.095217f,0.078646f,0.05762f,0.036824f,0.029865f,0.036998f,0.057908f,0.078979f,0.095531f,0.1086f,0.091492f,0.066983f,0.03421f,0.0015862f,0.000000f},
   {0.000000f,0.000000f,0.0069872f,0.034974f,0.057485f,0.053405f,0.046792f,0.034313f,0.021993f,0.010034f,0.002725f,0.010168f,0.022192f,0.034562f,0.047084f,0.053723f,0.057517f,0.035279f,0.0071573f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0017445f,0.011689f,0.013485f,0.012333f,0.010226f,0.0052012f,0.0015805f,0.000000f,0.000000f,0.000000f,0.001635f,0.005314f,0.010378f,0.012508f,0.013674f,0.011704f,0.0018203f,0.000000f,0.000000f},
   {0.000000f,0.000000f,-6.6557e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-6.6557e-019f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_ang[] = {-27,0,27,-95,95,-142,142};
static float map_7point1_xsf[] = {-1,0,1,-1,1,-1,1};
static float map_7point1_ysf[] = {1,1,1,0,0,-1,-1};
channel_id map_7point1_id[] = {ci_front_left,ci_front_center,ci_front_right,ci_side_center_left,ci_side_center_right,ci_back_left,ci_back_right,ci_lfe};

static float map_7point1_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,9.4126e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0025743f,0.016552f,0.019339f,0.017689f,0.014677f,0.0075151f,0.0023122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.010122f,0.049892f,0.081385f,0.075976f,0.066587f,0.048878f,0.031384f,0.01438f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0022432f,0.048381f,0.094728f,0.12939f,0.15091f,0.13421f,0.11169f,0.081894f,0.049473f,0.021188f,0.0029287f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019725f,0.095227f,0.15233f,0.18129f,0.18619f,0.18195f,0.1662f,0.14038f,0.099716f,0.051668f,0.015357f,0.0004627f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.067908f,0.15539f,0.20448f,0.21574f,0.21038f,0.19727f,0.18275f,0.16961f,0.14309f,0.089211f,0.030602f,0.0029125f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13152f,0.21916f,0.24385f,0.23799f,0.22019f,0.19777f,0.1798f,0.16484f,0.15891f,0.12092f,0.0391f,0.0061765f,0.0028379f,0.00043186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19821f,0.26858f,0.26884f,0.24624f,0.21773f,0.19453f,0.1758f,0.16036f,0.14653f,0.13495f,0.052607f,0.038854f,0.030373f,0.015188f,0.0028496f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {8.6596e-017f,0.26351f,0.30441f,0.28405f,0.24723f,0.21577f,0.19296f,0.17452f,0.15823f,0.14384f,0.13114f,0.13492f,0.12086f,0.089089f,0.051572f,0.021112f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.14292f,0.32999f,0.33317f,0.29065f,0.24843f,0.21902f,0.19594f,0.17746f,0.1625f,0.14962f,0.14386f,0.14651f,0.15886f,0.14285f,0.099312f,0.049149f,0.01419f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.27953f,0.38637f,0.35876f,0.29909f,0.25487f,0.22426f,0.20041f,0.18277f,0.16832f,0.16249f,0.15824f,0.16036f,0.16482f,0.16948f,0.14005f,0.081488f,0.031102f,0.0022352f,0.000000f,0.000000f,0.000000f},
   {0.40639f,0.44503f,0.38515f,0.31183f,0.26428f,0.23169f,0.20647f,0.18936f,0.18276f,0.17745f,0.17453f,0.1758f,0.17979f,0.18273f,0.16592f,0.11122f,0.048526f,0.0073556f,0.000000f,0.000000f,0.000000f},
   {0.52748f,0.51574f,0.41678f,0.32546f,0.27415f,0.24175f,0.21641f,0.20646f,0.2004f,0.19593f,0.19298f,0.19453f,0.19777f,0.19716f,0.18189f,0.13374f,0.066173f,0.014462f,0.000000f,0.000000f,0.000000f},
   {0.63323f,0.58186f,0.4515f,0.34992f,0.2914f,0.25248f,0.24174f,0.23169f,0.22425f,0.219f,0.21579f,0.21773f,0.22013f,0.21018f,0.18585f,0.15082f,0.075526f,0.017441f,0.000000f,0.000000f,0.000000f},
   {0.72837f,0.62641f,0.51744f,0.37803f,0.31074f,0.29139f,0.27414f,0.26427f,0.25485f,0.24842f,0.24726f,0.24619f,0.23779f,0.2154f,0.18082f,0.12881f,0.081296f,0.019071f,0.000000f,0.000000f,0.000000f},
   {0.81116f,0.6558f,0.5246f,0.41789f,0.37802f,0.34991f,0.32545f,0.31182f,0.29908f,0.29063f,0.28406f,0.26859f,0.24346f,0.20392f,0.15167f,0.09417f,0.04946f,0.016531f,0.000000f,0.000000f,0.000000f},
   {0.88423f,0.67127f,0.52691f,0.5245f,0.51721f,0.45136f,0.41661f,0.38495f,0.35851f,0.33283f,0.30436f,0.26801f,0.21844f,0.15464f,0.094607f,0.047925f,0.0098814f,0.0024671f,0.000000f,0.000000f,0.000000f},
   {0.94622f,0.67633f,0.67099f,0.65523f,0.62554f,0.58081f,0.51465f,0.44406f,0.38544f,0.32902f,0.26339f,0.19725f,0.13069f,0.067274f,0.019339f,0.0021311f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.94446f,0.8823f,0.80914f,0.72626f,0.63102f,0.52519f,0.40402f,0.27711f,0.14046f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.001914f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.0155f,0.025167f,0.017695f,0.0063155f,1.0116e-005f,0.000000f,0.000000f,0.0062031f,0.017508f,0.025125f,0.015305f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0056317f,0.024256f,0.044322f,0.061583f,0.065405f,0.041656f,0.014688f,4.0817e-019f,0.014527f,0.041389f,0.065342f,0.061236f,0.044002f,0.024003f,0.005504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0019274f,0.02644f,0.05812f,0.08731f,0.11105f,0.11767f,0.10963f,0.061306f,0.017226f,0.061006f,0.10958f,0.11735f,0.11066f,0.086884f,0.057744f,0.026151f,0.0018503f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016697f,0.059451f,0.104f,0.13974f,0.15702f,0.15962f,0.15223f,0.13355f,0.063692f,0.13353f,0.15211f,0.15945f,0.15675f,0.13934f,0.10352f,0.059047f,0.016456f,0.000000f,0.000000f},
   {0.000000f,1.2068e-018f,0.038851f,0.096919f,0.15087f,0.17987f,0.18511f,0.17445f,0.15817f,0.14379f,0.13384f,0.14378f,0.15816f,0.17444f,0.18509f,0.17981f,0.15076f,0.096821f,0.038797f,0.000000f,0.000000f},
   {0.000000f,0.0063777f,0.070344f,0.14288f,0.19068f,0.2049f,0.19453f,0.1758f,0.16036f,0.14645f,0.14681f,0.14646f,0.16036f,0.1758f,0.19453f,0.20473f,0.19031f,0.14227f,0.06984f,0.0061903f,0.000000f},
   {0.000000f,0.017224f,0.099719f,0.18101f,0.21822f,0.2193f,0.19777f,0.17979f,0.16475f,0.16187f,0.16149f,0.16187f,0.16477f,0.1798f,0.19777f,0.21922f,0.21792f,0.18045f,0.099116f,0.016918f,0.000000f},
   {0.000000f,0.02596f,0.12753f,0.21148f,0.23925f,0.22819f,0.20284f,0.18535f,0.18085f,0.17814f,0.17812f,0.17814f,0.18084f,0.18536f,0.20284f,0.22818f,0.23901f,0.21095f,0.12685f,0.025562f,0.000000f},
   {0.000000f,0.03194f,0.15144f,0.23904f,0.2564f,0.23733f,0.21182f,0.20371f,0.19964f,0.19751f,0.19694f,0.1975f,0.19963f,0.20369f,0.21184f,0.23733f,0.25621f,0.23853f,0.15068f,0.031485f,0.000000f},
   {0.000000f,0.051138f,0.17541f,0.26062f,0.27419f,0.24713f,0.23812f,0.22985f,0.2244f,0.22133f,0.22022f,0.22132f,0.22439f,0.22984f,0.2381f,0.24715f,0.274f,0.26009f,0.17455f,0.050511f,0.000000f},
   {0.000000f,0.08308f,0.18105f,0.28155f,0.29188f,0.28632f,0.27128f,0.26327f,0.25585f,0.25151f,0.25234f,0.2515f,0.25584f,0.26325f,0.27127f,0.28627f,0.29189f,0.28098f,0.18013f,0.082312f,0.000000f},
   {0.000000f,0.11865f,0.22314f,0.29977f,0.32517f,0.33282f,0.32312f,0.31164f,0.30095f,0.2946f,0.29542f,0.29459f,0.30094f,0.31163f,0.32308f,0.33259f,0.32473f,0.29967f,0.22211f,0.11774f,0.000000f},
   {0.000000f,0.15601f,0.26339f,0.30497f,0.3472f,0.38198f,0.39609f,0.39135f,0.3765f,0.36616f,0.36703f,0.36615f,0.37649f,0.39123f,0.39574f,0.3814f,0.34627f,0.30393f,0.26322f,0.15497f,0.000000f},
   {0.000000f,0.19222f,0.23448f,0.28578f,0.34732f,0.4169f,0.48293f,0.51439f,0.52067f,0.52104f,0.52661f,0.52086f,0.52026f,0.51365f,0.48176f,0.41543f,0.34579f,0.28436f,0.23319f,0.19202f,0.000000f},
   {1.1102e-016f,0.076479f,0.15764f,0.24801f,0.34452f,0.44874f,0.55712f,0.67263f,0.78467f,0.89574f,1.000000f,0.89382f,0.78261f,0.67046f,0.55485f,0.4464f,0.34213f,0.24558f,0.15519f,0.074014f,0.000000f}};

static float map_7point1_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022352f,0.0073556f,0.014462f,0.017441f,0.019071f,0.016531f,0.0024671f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01419f,0.031102f,0.048526f,0.066173f,0.075526f,0.081297f,0.04946f,0.0098814f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028496f,0.021112f,0.049149f,0.081488f,0.11122f,0.13374f,0.15081f,0.12881f,0.09417f,0.047925f,0.0021311f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00043186f,0.015188f,0.051545f,0.099312f,0.14005f,0.16592f,0.1819f,0.18585f,0.18082f,0.15167f,0.094607f,0.019339f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028379f,0.030373f,0.089057f,0.14285f,0.16948f,0.18273f,0.19716f,0.21018f,0.2154f,0.20392f,0.15464f,0.067274f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0004627f,0.0029125f,0.0061679f,0.038854f,0.12083f,0.15886f,0.16483f,0.17979f,0.19777f,0.22013f,0.23779f,0.24346f,0.21844f,0.13069f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0029287f,0.015357f,0.030602f,0.0391f,0.052555f,0.13491f,0.14652f,0.16036f,0.1758f,0.19453f,0.21773f,0.24619f,0.26859f,0.26801f,0.19725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.021156f,0.051639f,0.089163f,0.1209f,0.13493f,0.13114f,0.14385f,0.15824f,0.17453f,0.19297f,0.21578f,0.24725f,0.28402f,0.30431f,0.2633f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.01438f,0.049473f,0.099716f,0.14309f,0.15891f,0.1465f,0.14385f,0.14961f,0.16249f,0.17745f,0.19593f,0.219f,0.24842f,0.29063f,0.33283f,0.32902f,0.14046f},
   {0.000000f,0.000000f,0.000000f,0.0023122f,0.031384f,0.081894f,0.14038f,0.16961f,0.16482f,0.16036f,0.15824f,0.1625f,0.16831f,0.18276f,0.2004f,0.22425f,0.25485f,0.29908f,0.35851f,0.38544f,0.27711f},
   {0.000000f,0.000000f,0.000000f,0.0075151f,0.048878f,0.11169f,0.1662f,0.18272f,0.1798f,0.1758f,0.17453f,0.17746f,0.18277f,0.18935f,0.20646f,0.23169f,0.26427f,0.31182f,0.38495f,0.44406f,0.40402f},
   {0.000000f,0.000000f,0.000000f,0.014677f,0.066587f,0.13421f,0.18194f,0.19727f,0.19777f,0.19453f,0.19297f,0.19594f,0.20041f,0.20647f,0.2164f,0.24174f,0.27414f,0.32545f,0.41661f,0.51465f,0.52519f},
   {0.000000f,0.000000f,0.000000f,0.017689f,0.075976f,0.15092f,0.18619f,0.21038f,0.22019f,0.21773f,0.21578f,0.21902f,0.22426f,0.23169f,0.24175f,0.25247f,0.29139f,0.34991f,0.45136f,0.58081f,0.63102f},
   {0.000000f,0.000000f,0.000000f,0.019339f,0.081415f,0.12939f,0.18129f,0.21574f,0.23799f,0.24624f,0.24725f,0.24843f,0.25487f,0.26428f,0.27415f,0.2914f,0.31073f,0.37802f,0.51721f,0.62554f,0.72626f},
   {0.000000f,0.000000f,0.000000f,0.016574f,0.049892f,0.094728f,0.15233f,0.20448f,0.24385f,0.26884f,0.28405f,0.29065f,0.29909f,0.31183f,0.32546f,0.34992f,0.37803f,0.41787f,0.5245f,0.65523f,0.80914f},
   {0.000000f,0.000000f,0.000000f,0.0025743f,0.010122f,0.048381f,0.095227f,0.15539f,0.21916f,0.26858f,0.3044f,0.33317f,0.35876f,0.38515f,0.41678f,0.4515f,0.51744f,0.5246f,0.52688f,0.67099f,0.8823f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022432f,0.019725f,0.067908f,0.13152f,0.19821f,0.26356f,0.32999f,0.38637f,0.44503f,0.51574f,0.58186f,0.62641f,0.6558f,0.67127f,0.6763f,0.94439f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.14292f,0.27953f,0.40639f,0.52748f,0.63323f,0.72837f,0.81116f,0.88423f,0.94629f,1.000000f}};

static float map_7point1_lsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.076479f,0.1924f,0.15601f,0.11842f,0.08308f,0.051138f,0.03194f,0.02596f,0.017224f,0.006217f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15701f,0.23422f,0.26354f,0.22314f,0.18089f,0.17541f,0.15144f,0.12753f,0.099719f,0.070344f,0.038959f,0.016585f,0.0019274f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24799f,0.28578f,0.30478f,0.2999f,0.28155f,0.26062f,0.23875f,0.21148f,0.18101f,0.14288f,0.097017f,0.059361f,0.02644f,0.0055357f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34452f,0.34709f,0.3472f,0.32503f,0.29199f,0.2741f,0.2564f,0.23925f,0.21822f,0.19068f,0.15101f,0.104f,0.05812f,0.024256f,0.0054585f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44874f,0.4169f,0.38198f,0.33282f,0.28632f,0.24721f,0.23733f,0.22819f,0.21923f,0.20483f,0.17996f,0.13974f,0.08731f,0.044322f,0.015426f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55712f,0.48293f,0.39609f,0.32283f,0.2712f,0.23804f,0.21189f,0.20278f,0.19777f,0.19453f,0.18519f,0.15702f,0.11105f,0.061583f,0.025231f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67263f,0.51439f,0.39135f,0.31154f,0.26327f,0.22985f,0.20371f,0.18541f,0.17979f,0.1758f,0.17449f,0.15962f,0.11761f,0.06551f,0.017632f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78467f,0.52067f,0.3765f,0.30095f,0.25585f,0.2244f,0.19964f,0.1808f,0.16481f,0.16036f,0.15821f,0.15223f,0.10975f,0.041656f,0.0063155f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.52104f,0.36605f,0.29451f,0.25151f,0.22133f,0.19751f,0.17814f,0.16187f,0.14649f,0.14382f,0.13363f,0.061306f,0.014688f,1.0116e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.52679f,0.36715f,0.29551f,0.25242f,0.22029f,0.19701f,0.17818f,0.16155f,0.14686f,0.1311f,0.063705f,0.017218f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.52086f,0.36615f,0.29459f,0.2515f,0.22126f,0.1975f,0.17814f,0.16187f,0.14649f,0.14382f,0.13358f,0.061006f,0.014527f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78261f,0.52026f,0.37649f,0.30094f,0.25584f,0.22432f,0.19963f,0.18084f,0.1648f,0.16036f,0.1582f,0.15211f,0.10961f,0.041389f,0.0062031f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67046f,0.51365f,0.39123f,0.31163f,0.26325f,0.22984f,0.20363f,0.1854f,0.17974f,0.1758f,0.17448f,0.15945f,0.11735f,0.065362f,0.017508f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55485f,0.48176f,0.39574f,0.32282f,0.27127f,0.2381f,0.21189f,0.20284f,0.19777f,0.19453f,0.18513f,0.15675f,0.11066f,0.061236f,0.025146f,0.00059225f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.4464f,0.41543f,0.3814f,0.33259f,0.28621f,0.2472f,0.23726f,0.22818f,0.21922f,0.20473f,0.17984f,0.13934f,0.086884f,0.044002f,0.015305f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34213f,0.34579f,0.34627f,0.32473f,0.29192f,0.274f,0.25621f,0.23901f,0.21792f,0.19031f,0.1508f,0.10352f,0.057744f,0.024003f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24558f,0.28436f,0.30393f,0.29971f,0.28098f,0.26009f,0.23836f,0.21095f,0.18045f,0.14227f,0.096837f,0.059047f,0.026151f,0.005504f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15519f,0.23319f,0.26327f,0.22211f,0.18013f,0.17455f,0.15068f,0.12685f,0.099116f,0.06984f,0.038815f,0.016456f,0.0018503f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.074009f,0.19209f,0.15497f,0.11774f,0.082312f,0.050511f,0.031485f,0.025562f,0.016918f,0.0061903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0061903f,0.016918f,0.025562f,0.031485f,0.050511f,0.082312f,0.11774f,0.15497f,0.19222f,0.074014f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0018503f,0.016456f,0.038851f,0.06984f,0.099116f,0.12685f,0.15068f,0.17455f,0.18013f,0.22211f,0.26337f,0.23319f,0.15519f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.005504f,0.026151f,0.059047f,0.096892f,0.14227f,0.18045f,0.21095f,0.23853f,0.26009f,0.28098f,0.29979f,0.30393f,0.28436f,0.24556f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0054168f,0.024003f,0.057744f,0.10352f,0.15084f,0.19031f,0.21792f,0.23901f,0.25621f,0.274f,0.29198f,0.32473f,0.34627f,0.34579f,0.34213f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.015305f,0.044002f,0.086884f,0.13934f,0.17988f,0.20473f,0.21922f,0.22818f,0.23733f,0.24725f,0.28627f,0.33259f,0.3814f,0.41543f,0.4464f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.025157f,0.061236f,0.11066f,0.15675f,0.18518f,0.19453f,0.19777f,0.20284f,0.21193f,0.2381f,0.27127f,0.32308f,0.39574f,0.48176f,0.55485f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017508f,0.065396f,0.11735f,0.15945f,0.17454f,0.1758f,0.1798f,0.18544f,0.20369f,0.22984f,0.26325f,0.31163f,0.39123f,0.51365f,0.67046f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0062031f,0.041389f,0.10962f,0.15211f,0.15825f,0.16036f,0.16483f,0.18084f,0.19963f,0.22439f,0.25584f,0.30094f,0.37649f,0.52026f,0.78261f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014527f,0.061006f,0.13359f,0.14386f,0.14652f,0.16187f,0.17814f,0.1975f,0.22132f,0.2515f,0.29459f,0.36615f,0.52086f,0.89382f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-4.0817e-019f,0.017202f,0.06369f,0.13113f,0.14689f,0.16158f,0.17821f,0.19705f,0.22033f,0.25247f,0.29557f,0.36722f,0.52689f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.0116e-005f,0.014688f,0.061306f,0.13361f,0.14385f,0.14651f,0.16187f,0.17814f,0.19751f,0.22133f,0.25151f,0.2946f,0.36616f,0.52104f,0.89574f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0063155f,0.041656f,0.10967f,0.15223f,0.15823f,0.16036f,0.16482f,0.18085f,0.19964f,0.2244f,0.25585f,0.30095f,0.3765f,0.52067f,0.78467f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017695f,0.065451f,0.11767f,0.15962f,0.17452f,0.1758f,0.17979f,0.18543f,0.20371f,0.22985f,0.26327f,0.31164f,0.39135f,0.51439f,0.67263f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062925f,0.0252f,0.061583f,0.11105f,0.15702f,0.18518f,0.19453f,0.19777f,0.20284f,0.21192f,0.23812f,0.27128f,0.32312f,0.39609f,0.48293f,0.55712f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.0155f,0.044322f,0.08731f,0.13974f,0.17992f,0.2049f,0.2193f,0.22819f,0.23733f,0.24724f,0.28632f,0.33282f,0.38198f,0.4169f,0.44874f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.024256f,0.05812f,0.104f,0.15089f,0.19068f,0.21822f,0.23925f,0.2564f,0.27419f,0.292f,0.32517f,0.3472f,0.34732f,0.34452f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0056317f,0.02644f,0.059451f,0.09695f,0.14288f,0.18101f,0.21148f,0.23904f,0.26062f,0.28155f,0.29985f,0.30497f,0.28578f,0.24801f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019274f,0.016697f,0.038906f,0.070344f,0.099719f,0.12753f,0.15144f,0.17541f,0.18105f,0.22314f,0.26347f,0.23448f,0.15764f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.2068e-018f,0.0063777f,0.017224f,0.02596f,0.03194f,0.051138f,0.08308f,0.11865f,0.15601f,0.19233f,0.076473f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f}};

static float map_7point1_ls[21][21] = {
   {1.000000f,0.99863f,0.99396f,0.98481f,0.9703f,0.94888f,0.91914f,0.88048f,0.83195f,0.77384f,0.70834f,0.63338f,0.55484f,0.47562f,0.39394f,0.3173f,0.24362f,0.17537f,0.11147f,0.054079f,-7.8496e-017f},
   {0.94446f,0.81199f,0.83616f,0.85669f,0.87092f,0.87561f,0.8564f,0.80823f,0.75425f,0.69808f,0.63602f,0.56664f,0.49969f,0.43164f,0.36121f,0.29703f,0.24559f,0.20208f,0.16581f,0.13592f,0.000000f},
   {0.88271f,0.78057f,0.71294f,0.73952f,0.76209f,0.72118f,0.69661f,0.66179f,0.62498f,0.59208f,0.56394f,0.52736f,0.48539f,0.43211f,0.3753f,0.31848f,0.25563f,0.21817f,0.18628f,0.11031f,0.000000f},
   {0.80907f,0.73849f,0.68142f,0.62971f,0.60765f,0.58509f,0.55402f,0.53219f,0.51188f,0.49896f,0.49292f,0.47704f,0.45666f,0.42472f,0.38061f,0.33006f,0.27965f,0.22857f,0.15778f,0.083896f,0.000000f},
   {0.72626f,0.68381f,0.64457f,0.57657f,0.51706f,0.49372f,0.46596f,0.45043f,0.43577f,0.42627f,0.42558f,0.42408f,0.4189f,0.4019f,0.37301f,0.33185f,0.28785f,0.21842f,0.12802f,0.058746f,0.000000f},
   {0.63102f,0.61653f,0.57478f,0.53382f,0.48514f,0.42718f,0.41011f,0.39421f,0.38285f,0.37543f,0.37141f,0.37424f,0.37886f,0.37291f,0.35447f,0.32571f,0.2697f,0.20197f,0.12403f,0.03616f,0.000000f},
   {0.52519f,0.53691f,0.52315f,0.49422f,0.4552f,0.40947f,0.36615f,0.35043f,0.34158f,0.3356f,0.33216f,0.33419f,0.33895f,0.34131f,0.33172f,0.30203f,0.24789f,0.18361f,0.10709f,0.022585f,0.000000f},
   {0.40402f,0.46214f,0.47464f,0.46087f,0.43328f,0.39304f,0.3499f,0.32038f,0.31064f,0.30342f,0.30041f,0.30177f,0.30761f,0.31375f,0.30955f,0.27305f,0.21805f,0.15706f,0.090176f,0.018356f,0.000000f},
   {0.27711f,0.39741f,0.42859f,0.42667f,0.40895f,0.37927f,0.34025f,0.30982f,0.28478f,0.27695f,0.27237f,0.27482f,0.28125f,0.29675f,0.28023f,0.23683f,0.18569f,0.13031f,0.070512f,0.012179f,0.000000f},
   {0.14292f,0.33339f,0.38221f,0.39113f,0.38299f,0.36377f,0.33348f,0.30176f,0.27588f,0.25314f,0.24761f,0.25f,0.2723f,0.2674f,0.23727f,0.19424f,0.14921f,0.10103f,0.049741f,0.0045097f,0.000000f},
   {0.000000f,0.26327f,0.33172f,0.35247f,0.35385f,0.34292f,0.32385f,0.29788f,0.27007f,0.24552f,0.22579f,0.23659f,0.23272f,0.21252f,0.18253f,0.14834f,0.1086f,0.068513f,0.027472f,-8.5322e-019f,0.000000f},
   {0.000000f,0.19725f,0.27965f,0.31034f,0.31939f,0.31618f,0.30536f,0.28855f,0.26792f,0.24094f,0.1799f,0.14699f,0.14674f,0.14347f,0.12638f,0.10174f,0.073541f,0.042039f,0.011806f,0.000000f,0.000000f},
   {0.000000f,0.13069f,0.21975f,0.26195f,0.27862f,0.28151f,0.27602f,0.26277f,0.24232f,0.202f,0.13299f,0.082204f,0.083689f,0.086082f,0.07899f,0.061737f,0.041097f,0.018696f,0.0013628f,0.000000f,0.000000f},
   {0.000000f,0.067274f,0.15464f,0.20782f,0.23238f,0.24129f,0.24043f,0.22893f,0.19873f,0.15312f,0.089072f,0.040759f,0.032293f,0.046248f,0.043546f,0.03134f,0.017152f,0.0039822f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019339f,0.094607f,0.15196f,0.18465f,0.19667f,0.19966f,0.1783f,0.14444f,0.099312f,0.051555f,0.015195f,0.0048976f,0.012512f,0.017789f,0.01096f,0.0039191f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0021311f,0.047925f,0.09417f,0.12885f,0.15216f,0.13421f,0.11122f,0.081488f,0.049149f,0.021112f,0.0028496f,0.000000f,0.000000f,0.00044495f,0.0013625f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0098814f,0.04946f,0.081296f,0.075526f,0.066173f,0.048526f,0.031102f,0.01419f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0024671f,0.016531f,0.019071f,0.017441f,0.014677f,0.0073556f,0.0022352f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_rs[21][21] = {
   {-7.8496e-017f,0.052336f,0.10973f,0.17365f,0.24192f,0.31565f,0.39394f,0.47409f,0.55484f,0.63338f,0.70587f,0.77384f,0.83195f,0.87965f,0.91914f,0.94832f,0.96987f,0.9845f,0.99377f,0.99854f,1.000000f},
   {0.000000f,0.13583f,0.16489f,0.20208f,0.24451f,0.29589f,0.35999f,0.43048f,0.49857f,0.56633f,0.63558f,0.69745f,0.75361f,0.80779f,0.85613f,0.8756f,0.87113f,0.85731f,0.83679f,0.81212f,0.94629f},
   {0.000000f,0.11031f,0.18615f,0.21738f,0.25552f,0.31761f,0.37444f,0.43128f,0.48466f,0.52692f,0.56374f,0.59228f,0.62473f,0.66167f,0.69668f,0.72145f,0.76272f,0.7402f,0.71303f,0.78158f,0.88423f},
   {0.000000f,0.083257f,0.15778f,0.22845f,0.27908f,0.32934f,0.38061f,0.42428f,0.45626f,0.4769f,0.4928f,0.49938f,0.51188f,0.53264f,0.55439f,0.58524f,0.6082f,0.62975f,0.68239f,0.7397f,0.8111f},
   {0.000000f,0.058746f,0.12737f,0.2183f,0.28772f,0.33167f,0.37263f,0.40155f,0.4187f,0.42403f,0.42555f,0.42626f,0.43576f,0.45043f,0.46637f,0.49385f,0.51702f,0.57711f,0.64546f,0.68515f,0.72837f},
   {0.000000f,0.035717f,0.12342f,0.20135f,0.26927f,0.3256f,0.35421f,0.3727f,0.37913f,0.37456f,0.37139f,0.37551f,0.38293f,0.39422f,0.41047f,0.42708f,0.48557f,0.53421f,0.57553f,0.61802f,0.63323f},
   {0.000000f,0.022264f,0.10655f,0.18361f,0.24774f,0.30191f,0.3317f,0.3415f,0.33894f,0.33418f,0.33214f,0.33559f,0.34157f,0.3505f,0.36607f,0.40957f,0.45546f,0.49461f,0.52386f,0.53833f,0.52748f},
   {0.000000f,0.018075f,0.089694f,0.15698f,0.21753f,0.27257f,0.30936f,0.31378f,0.30767f,0.30176f,0.30039f,0.30342f,0.31091f,0.32031f,0.3502f,0.39305f,0.43346f,0.46137f,0.47532f,0.46338f,0.40639f},
   {0.000000f,0.011962f,0.070085f,0.12983f,0.1852f,0.2365f,0.2799f,0.29688f,0.28132f,0.27481f,0.27235f,0.27695f,0.28472f,0.3099f,0.34026f,0.3796f,0.40917f,0.42708f,0.42927f,0.39855f,0.27953f},
   {0.000000f,0.0043772f,0.049741f,0.10103f,0.14876f,0.19392f,0.23686f,0.26716f,0.27225f,0.25006f,0.24759f,0.25308f,0.27589f,0.30177f,0.33349f,0.36411f,0.38326f,0.39169f,0.38291f,0.3345f,0.14292f},
   {0.000000f,-8.5322e-019f,0.027447f,0.068465f,0.10853f,0.14825f,0.18244f,0.21244f,0.23269f,0.23658f,0.22577f,0.24545f,0.27f,0.29779f,0.3238f,0.34289f,0.35387f,0.35252f,0.3318f,0.26339f,-8.6596e-017f},
   {0.000000f,0.000000f,0.011636f,0.041753f,0.073199f,0.1017f,0.12602f,0.14312f,0.14641f,0.14698f,0.17992f,0.24091f,0.268f,0.28867f,0.30555f,0.31654f,0.31978f,0.31088f,0.28038f,0.19821f,0.000000f},
   {0.000000f,0.000000f,0.0013084f,0.018492f,0.040831f,0.061737f,0.07868f,0.085813f,0.08366f,0.082238f,0.13301f,0.20226f,0.24232f,0.26304f,0.2763f,0.28192f,0.27908f,0.26255f,0.22053f,0.13152f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0038919f,0.016973f,0.031114f,0.043546f,0.046224f,0.032368f,0.040874f,0.089105f,0.15348f,0.19907f,0.22896f,0.24081f,0.24172f,0.2329f,0.20846f,0.15539f,0.067908f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.010822f,0.017781f,0.01238f,0.0048489f,0.015357f,0.051582f,0.099723f,0.14485f,0.17871f,0.1997f,0.19715f,0.18521f,0.15233f,0.095227f,0.019725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013625f,0.00044495f,0.000000f,0.000000f,0.0029287f,0.021123f,0.049473f,0.081894f,0.11169f,0.13466f,0.15222f,0.12939f,0.094728f,0.048381f,0.0022432f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01438f,0.031384f,0.048878f,0.066587f,0.075976f,0.081342f,0.049892f,0.010122f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0023122f,0.0075151f,0.014677f,0.017689f,0.019339f,0.016553f,0.0025743f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.4126e-019f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_panorama_ang[] = {-45,-26,0,26,45,-95,95};
static float map_7point1_panorama_xsf[] = {-1,-0.5,0,0.5,1,-1,1};
static float map_7point1_panorama_ysf[] = {1,1,1,1,1,0,0};
channel_id map_7point1_panorama_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_side_center_left,ci_side_center_right,ci_lfe};

static float map_7point1_panorama_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0025743f,0.016552f,0.019339f,0.017689f,0.014677f,0.0075151f,0.0023122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.010122f,0.049892f,0.081385f,0.075976f,0.066587f,0.048878f,0.031384f,0.01438f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0022432f,0.048381f,0.094728f,0.12939f,0.14819f,0.13332f,0.11169f,0.081894f,0.049473f,0.021188f,0.0029287f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019725f,0.095227f,0.15233f,0.17345f,0.16427f,0.14754f,0.14117f,0.13145f,0.099702f,0.051668f,0.015357f,0.0004627f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.067908f,0.15539f,0.19651f,0.18146f,0.15882f,0.14116f,0.1291f,0.12511f,0.12232f,0.089211f,0.030602f,0.0029125f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13152f,0.21644f,0.20646f,0.17568f,0.15435f,0.13761f,0.1251f,0.11476f,0.11158f,0.1087f,0.0391f,0.0030968f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19821f,0.24497f,0.20143f,0.17202f,0.15152f,0.1354f,0.12233f,0.11157f,0.10201f,0.10008f,0.02634f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.26351f,0.25036f,0.20151f,0.17212f,0.15022f,0.13434f,0.1215f,0.11016f,0.10014f,0.091286f,0.091196f,0.072765f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.14292f,0.32097f,0.25158f,0.20264f,0.17322f,0.15277f,0.1368f,0.12398f,0.11372f,0.10509f,0.10014f,0.10199f,0.11007f,0.089378f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.27953f,0.36201f,0.26077f,0.20891f,0.17806f,0.15683f,0.14026f,0.12809f,0.11822f,0.11157f,0.11015f,0.11158f,0.11474f,0.11478f,0.079886f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.40639f,0.40831f,0.2748f,0.2181f,0.18495f,0.16233f,0.1448f,0.133f,0.12656f,0.12233f,0.12149f,0.12232f,0.12511f,0.12639f,0.10424f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.52748f,0.47057f,0.29527f,0.22794f,0.19213f,0.16957f,0.152f,0.14356f,0.13761f,0.1354f,0.13433f,0.13538f,0.13762f,0.13549f,0.1175f,0.061535f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.63323f,0.50954f,0.31873f,0.2453f,0.20447f,0.17733f,0.16842f,0.15997f,0.15435f,0.15152f,0.15021f,0.15149f,0.1527f,0.14081f,0.11367f,0.0757f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.72837f,0.51209f,0.3683f,0.26525f,0.21826f,0.20334f,0.18984f,0.18146f,0.17568f,0.17202f,0.17211f,0.17098f,0.16098f,0.13607f,0.098801f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.81116f,0.50827f,0.36916f,0.29352f,0.264f,0.24288f,0.22433f,0.21451f,0.20646f,0.20143f,0.19609f,0.18058f,0.15329f,0.1102f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.88423f,0.49893f,0.37009f,0.36617f,0.35721f,0.311f,0.2844f,0.26253f,0.24312f,0.22219f,0.19506f,0.15866f,0.1057f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.94622f,0.48678f,0.46584f,0.43796f,0.40098f,0.35386f,0.3003f,0.25801f,0.21787f,0.17042f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_panorama_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_panorama_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_panorama_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_7point1_panorama_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022352f,0.0073556f,0.014462f,0.017441f,0.019071f,0.016531f,0.0024671f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01419f,0.031102f,0.048526f,0.066173f,0.075526f,0.081297f,0.04946f,0.0098814f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028496f,0.021112f,0.049149f,0.081488f,0.11122f,0.13287f,0.14806f,0.12881f,0.09417f,0.047925f,0.0021311f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00043186f,0.015188f,0.051545f,0.099312f,0.1312f,0.14102f,0.14734f,0.16405f,0.17306f,0.15167f,0.094607f,0.019339f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028379f,0.030373f,0.089057f,0.12218f,0.12498f,0.12893f,0.14102f,0.15866f,0.18126f,0.19604f,0.15464f,0.067274f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0030797f,0.038854f,0.1086f,0.11146f,0.1146f,0.12497f,0.13745f,0.1542f,0.17549f,0.20626f,0.21577f,0.13069f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.026252f,0.10001f,0.10187f,0.11145f,0.12219f,0.13525f,0.15135f,0.17183f,0.20121f,0.24456f,0.19725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.072685f,0.091096f,0.091174f,0.10001f,0.11002f,0.12134f,0.13416f,0.15002f,0.1719f,0.20125f,0.25003f,0.2633f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040435f,0.089481f,0.11f,0.10185f,0.10001f,0.10496f,0.11359f,0.12384f,0.13666f,0.15261f,0.17302f,0.20242f,0.25131f,0.32012f,0.14046f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.080064f,0.11479f,0.11458f,0.11146f,0.11002f,0.11145f,0.11808f,0.12794f,0.14009f,0.15665f,0.17785f,0.20867f,0.2605f,0.36128f,0.27711f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.10437f,0.12621f,0.12498f,0.12218f,0.12134f,0.12219f,0.12645f,0.13284f,0.14464f,0.16215f,0.18474f,0.21787f,0.27448f,0.4076f,0.40402f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.061843f,0.11735f,0.13544f,0.13747f,0.13526f,0.13417f,0.13525f,0.13745f,0.14343f,0.15182f,0.16938f,0.19191f,0.22768f,0.29494f,0.46977f,0.52519f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.075569f,0.11383f,0.14084f,0.15258f,0.15134f,0.15002f,0.15135f,0.1542f,0.15983f,0.16828f,0.17712f,0.20424f,0.24502f,0.31841f,0.50892f,0.63102f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.099066f,0.13621f,0.16098f,0.17084f,0.1719f,0.17183f,0.17549f,0.18126f,0.18968f,0.20316f,0.21799f,0.26496f,0.36789f,0.51154f,0.72626f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.11053f,0.15345f,0.18063f,0.19584f,0.20121f,0.20626f,0.21427f,0.22413f,0.24264f,0.26377f,0.29316f,0.36878f,0.50788f,0.80914f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10618f,0.15898f,0.19481f,0.22223f,0.24306f,0.26241f,0.28423f,0.31081f,0.3571f,0.36589f,0.36964f,0.49868f,0.8823f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.17097f,0.21836f,0.25849f,0.30093f,0.35437f,0.4014f,0.43825f,0.46598f,0.4862f,0.94439f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_7point1_panorama_lsm[21][21] = {
   {0.94868f,0.93979f,0.92892f,0.91532f,0.89884f,0.87853f,0.8537f,0.82424f,0.78969f,0.75039f,0.70789f,0.661f,0.61351f,0.56712f,0.52077f,0.47859f,0.43917f,0.40362f,0.37114f,0.3426f,0.31623f},
   {0.95693f,0.9317f,0.92102f,0.90712f,0.89078f,0.87044f,0.84289f,0.80644f,0.76604f,0.7236f,0.6804f,0.6349f,0.58948f,0.54466f,0.5005f,0.45761f,0.41877f,0.38353f,0.35198f,0.32412f,0.29116f},
   {0.96462f,0.94132f,0.91583f,0.90277f,0.88622f,0.85514f,0.82266f,0.78517f,0.74448f,0.70104f,0.65656f,0.61f,0.56482f,0.52016f,0.47676f,0.43469f,0.3955f,0.36119f,0.33046f,0.29747f,0.26416f},
   {0.97225f,0.95137f,0.92571f,0.88489f,0.85653f,0.82795f,0.79498f,0.76363f,0.7255f,0.68186f,0.63534f,0.58672f,0.54045f,0.49615f,0.45375f,0.41386f,0.37593f,0.34027f,0.30135f,0.26734f,0.23466f},
   {0.97919f,0.96065f,0.93214f,0.86186f,0.79292f,0.76789f,0.74051f,0.71861f,0.68961f,0.65516f,0.61525f,0.56724f,0.52048f,0.47677f,0.43635f,0.3979f,0.36272f,0.31873f,0.26998f,0.23483f,0.20369f},
   {0.98542f,0.9679f,0.90436f,0.82956f,0.75592f,0.68671f,0.67103f,0.65339f,0.63609f,0.61413f,0.58511f,0.54827f,0.50188f,0.45794f,0.41794f,0.38255f,0.33991f,0.29475f,0.24755f,0.20075f,0.17085f},
   {0.99064f,0.96121f,0.8708f,0.78204f,0.71032f,0.65588f,0.60348f,0.58332f,0.56997f,0.56033f,0.54752f,0.52193f,0.48158f,0.43707f,0.39772f,0.3559f,0.31427f,0.27011f,0.22117f,0.16891f,0.13721f},
   {0.99488f,0.92575f,0.82128f,0.73741f,0.67683f,0.6254f,0.57563f,0.53395f,0.51827f,0.50648f,0.50219f,0.48925f,0.45417f,0.4102f,0.3672f,0.32497f,0.28356f,0.24085f,0.19578f,0.14463f,0.10174f},
   {0.99776f,0.87364f,0.76373f,0.693f,0.64179f,0.59802f,0.55526f,0.51595f,0.47518f,0.46214f,0.45532f,0.45265f,0.41787f,0.36979f,0.32799f,0.28872f,0.25065f,0.21145f,0.16933f,0.12196f,0.067462f},
   {0.99947f,0.81537f,0.71032f,0.65167f,0.60836f,0.57105f,0.53463f,0.49872f,0.46215f,0.42238f,0.41393f,0.40752f,0.35964f,0.31638f,0.28082f,0.24757f,0.21469f,0.18028f,0.14225f,0.098254f,0.033277f},
   {1.000000f,0.75555f,0.6647f,0.61519f,0.57784f,0.54265f,0.51083f,0.47959f,0.44672f,0.41273f,0.37739f,0.32488f,0.28151f,0.25128f,0.22873f,0.20406f,0.1757f,0.14641f,0.11309f,0.073649f,0.000000f},
   {0.89382f,0.68791f,0.61547f,0.57441f,0.54227f,0.51265f,0.48344f,0.45315f,0.42036f,0.38304f,0.34573f,0.31179f,0.24651f,0.20178f,0.17713f,0.16064f,0.14079f,0.11665f,0.088097f,0.053513f,0.000000f},
   {0.78261f,0.6272f,0.56968f,0.53556f,0.50734f,0.48031f,0.4527f,0.42322f,0.38924f,0.35404f,0.31186f,0.27072f,0.23694f,0.17604f,0.13906f,0.12194f,0.10696f,0.087506f,0.063482f,0.033993f,0.000000f},
   {0.67046f,0.56634f,0.52262f,0.49572f,0.47144f,0.44729f,0.42138f,0.39319f,0.35982f,0.32059f,0.2768f,0.23458f,0.19582f,0.16167f,0.11528f,0.089805f,0.077988f,0.062177f,0.042135f,0.016712f,0.000000f},
   {0.55485f,0.49618f,0.47283f,0.45393f,0.43496f,0.41386f,0.3911f,0.36252f,0.32632f,0.28454f,0.24104f,0.19635f,0.15537f,0.12066f,0.094028f,0.06429f,0.055517f,0.042187f,0.024487f,0.0046307f,0.000000f},
   {0.4464f,0.41696f,0.41883f,0.4103f,0.39691f,0.3813f,0.35486f,0.32441f,0.28801f,0.24544f,0.20142f,0.15414f,0.1089f,0.075057f,0.053667f,0.046121f,0.035614f,0.02474f,0.011873f,0.00051164f,0.000000f},
   {0.34213f,0.34579f,0.35357f,0.36379f,0.3589f,0.33617f,0.31041f,0.27805f,0.24238f,0.20111f,0.15264f,0.10696f,0.065501f,0.036389f,0.022645f,0.019781f,0.021189f,0.012384f,0.0023573f,0.000000f,0.000000f},
   {0.24558f,0.28436f,0.30572f,0.31215f,0.29544f,0.27331f,0.24946f,0.21641f,0.18207f,0.14227f,0.096837f,0.059047f,0.026683f,0.0072615f,0.0034858f,0.004216f,0.0046111f,0.0039179f,0.0005892f,0.000000f,0.000000f},
   {0.15519f,0.23319f,0.26327f,0.22211f,0.18013f,0.17455f,0.15068f,0.12685f,0.099116f,0.06984f,0.038815f,0.016456f,0.0018503f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.074009f,0.19209f,0.15497f,0.11774f,0.082312f,0.050511f,0.031485f,0.025562f,0.016918f,0.0061903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_panorama_rsm[21][21] = {
   {0.31623f,0.34174f,0.37027f,0.40274f,0.43828f,0.47769f,0.52077f,0.56623f,0.61351f,0.661f,0.70632f,0.75039f,0.78969f,0.82364f,0.8537f,0.87804f,0.8984f,0.91493f,0.92858f,0.93948f,0.94868f},
   {0.29033f,0.32401f,0.35116f,0.38332f,0.41793f,0.45677f,0.49966f,0.54385f,0.5887f,0.63465f,0.68013f,0.72323f,0.76542f,0.80587f,0.84237f,0.86998f,0.89037f,0.90708f,0.92068f,0.93165f,0.95667f},
   {0.26357f,0.29714f,0.33033f,0.36043f,0.39519f,0.43391f,0.476f,0.51943f,0.56412f,0.60952f,0.65633f,0.70077f,0.74391f,0.78464f,0.82217f,0.8547f,0.8861f,0.90245f,0.91577f,0.94127f,0.96448f},
   {0.23387f,0.26656f,0.30106f,0.34015f,0.37537f,0.41319f,0.45358f,0.49568f,0.53983f,0.58627f,0.63514f,0.68158f,0.72503f,0.76355f,0.79513f,0.82772f,0.85651f,0.88483f,0.92575f,0.95113f,0.97206f},
   {0.20293f,0.23442f,0.26927f,0.31844f,0.36261f,0.3976f,0.43594f,0.47622f,0.51995f,0.56672f,0.61506f,0.6548f,0.68936f,0.71846f,0.74071f,0.76806f,0.79292f,0.86211f,0.93207f,0.96059f,0.97904f},
   {0.17012f,0.20003f,0.24691f,0.29416f,0.33947f,0.38245f,0.41757f,0.45745f,0.50162f,0.54808f,0.58502f,0.61408f,0.63615f,0.65342f,0.67134f,0.68672f,0.75631f,0.82977f,0.9045f,0.96781f,0.9853f},
   {0.13651f,0.16829f,0.22059f,0.26993f,0.31401f,0.35564f,0.39763f,0.43683f,0.48118f,0.52165f,0.54749f,0.56033f,0.56997f,0.58346f,0.60347f,0.65615f,0.71071f,0.78267f,0.87115f,0.96137f,0.99054f},
   {0.10107f,0.14409f,0.19526f,0.24062f,0.28307f,0.32452f,0.36689f,0.41011f,0.45394f,0.48907f,0.50222f,0.50647f,0.51844f,0.53393f,0.57589f,0.62556f,0.67709f,0.73799f,0.82182f,0.92616f,0.99481f},
   {0.066833f,0.12148f,0.16885f,0.21098f,0.2502f,0.28838f,0.32758f,0.36957f,0.41781f,0.45253f,0.45534f,0.46213f,0.47515f,0.51608f,0.55535f,0.59835f,0.64207f,0.69341f,0.76436f,0.87429f,0.99772f},
   {0.032685f,0.097839f,0.14205f,0.18011f,0.21427f,0.24724f,0.28043f,0.31601f,0.3593f,0.40753f,0.41395f,0.42235f,0.46216f,0.49878f,0.53476f,0.57137f,0.60866f,0.65226f,0.71105f,0.81621f,0.99945f},
   {0.000000f,0.073611f,0.11305f,0.14636f,0.17565f,0.20399f,0.22866f,0.25121f,0.28147f,0.32487f,0.37741f,0.41271f,0.44671f,0.47959f,0.51086f,0.54269f,0.57791f,0.61529f,0.66484f,0.75577f,1.000000f},
   {0.000000f,0.053223f,0.087771f,0.1163f,0.14044f,0.16049f,0.1768f,0.20162f,0.2465f,0.31181f,0.34577f,0.38304f,0.42051f,0.45334f,0.48368f,0.51308f,0.54266f,0.57492f,0.61617f,0.68897f,0.89574f},
   {0.000000f,0.033762f,0.063207f,0.087205f,0.10665f,0.12181f,0.13887f,0.17604f,0.23697f,0.27083f,0.3119f,0.35422f,0.38927f,0.4235f,0.45299f,0.48077f,0.50778f,0.53612f,0.57043f,0.62834f,0.78467f},
   {0.000000f,0.016548f,0.04191f,0.061926f,0.077723f,0.089535f,0.11535f,0.16173f,0.1961f,0.23477f,0.27686f,0.32086f,0.36017f,0.39325f,0.42181f,0.4477f,0.47193f,0.49633f,0.52343f,0.56761f,0.67263f},
   {0.000000f,0.0045383f,0.024315f,0.042013f,0.055294f,0.064099f,0.094062f,0.1208f,0.15562f,0.19662f,0.24111f,0.28489f,0.32669f,0.36289f,0.39117f,0.41432f,0.4355f,0.4546f,0.47371f,0.49764f,0.55712f},
   {0.000000f,0.00048584f,0.011756f,0.024581f,0.035454f,0.046115f,0.053729f,0.075228f,0.1092f,0.15451f,0.20151f,0.24587f,0.28846f,0.32487f,0.35534f,0.38139f,0.39751f,0.41103f,0.41979f,0.41851f,0.44874f},
   {0.000000f,0.000000f,0.0023004f,0.012271f,0.021176f,0.019653f,0.022655f,0.036546f,0.065804f,0.1074f,0.15274f,0.20163f,0.24291f,0.27859f,0.31096f,0.33676f,0.35902f,0.36458f,0.35468f,0.34732f,0.34452f},
   {0.000000f,0.000000f,0.00056441f,0.0039128f,0.0045454f,0.0041551f,0.0034332f,0.0073512f,0.026953f,0.059451f,0.09695f,0.14288f,0.18269f,0.21706f,0.25013f,0.27403f,0.29622f,0.31231f,0.30683f,0.28578f,0.24801f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019274f,0.016697f,0.038906f,0.070344f,0.099719f,0.12753f,0.15144f,0.17541f,0.18105f,0.22314f,0.26347f,0.23448f,0.15764f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.2068e-018f,0.0063777f,0.017224f,0.02596f,0.03194f,0.051138f,0.08308f,0.11865f,0.15601f,0.19233f,0.076473f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f}};

static float map_7point1_tricenter_ang[] = {-45,-26,0,26,45,-110,110};
static float map_7point1_tricenter_xsf[] = {-1,-0.5,0,0.5,1,-1,1};
static float map_7point1_tricenter_ysf[] = {1,1,1,1,1,-1,-1};
channel_id map_7point1_tricenter_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_back_left,ci_back_right,ci_lfe};

static float map_7point1_tricenter_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.054079f,0.13605f,0.11031f,0.083738f,0.058746f,0.03616f,0.022585f,0.018356f,0.012179f,0.0043961f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.11103f,0.16562f,0.18635f,0.15778f,0.12791f,0.12403f,0.10709f,0.090176f,0.070512f,0.049741f,0.027549f,0.011727f,0.0013628f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17535f,0.20208f,0.21809f,0.22862f,0.21842f,0.20197f,0.18341f,0.15706f,0.13031f,0.10103f,0.068601f,0.041975f,0.018696f,0.0039144f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24362f,0.24543f,0.25563f,0.27972f,0.28786f,0.26979f,0.24789f,0.21805f,0.18569f,0.14921f,0.10871f,0.073541f,0.041097f,0.017152f,0.0038597f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3173f,0.29703f,0.31848f,0.33006f,0.33185f,0.32299f,0.30114f,0.27305f,0.23691f,0.19431f,0.14844f,0.10174f,0.061737f,0.03134f,0.010908f,0.0013625f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.39394f,0.36121f,0.3753f,0.38051f,0.36522f,0.33259f,0.29737f,0.28456f,0.2713f,0.23725f,0.18262f,0.12638f,0.07899f,0.043546f,0.017841f,0.00044495f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.47562f,0.43164f,0.43211f,0.4168f,0.36762f,0.32134f,0.2852f,0.2602f,0.25225f,0.24663f,0.21259f,0.14347f,0.086077f,0.046322f,0.012467f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55484f,0.49969f,0.48267f,0.41926f,0.35659f,0.31303f,0.27878f,0.25294f,0.23129f,0.22497f,0.22057f,0.14674f,0.080699f,0.029455f,0.0044657f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.63203f,0.56664f,0.5038f,0.40968f,0.34986f,0.30802f,0.27506f,0.24829f,0.22604f,0.20559f,0.20178f,0.12083f,0.045091f,0.010386f,7.153e-006f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.70711f,0.63601f,0.50998f,0.41047f,0.35061f,0.30599f,0.27365f,0.24749f,0.22439f,0.20399f,0.18399f,0.13624f,0.08494f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.77384f,0.68927f,0.51049f,0.41094f,0.35106f,0.30923f,0.27645f,0.24994f,0.22817f,0.20867f,0.20183f,0.19645f,0.15321f,0.099648f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83292f,0.72988f,0.52698f,0.42171f,0.35896f,0.31545f,0.28142f,0.25596f,0.23475f,0.22496f,0.22202f,0.21914f,0.19225f,0.14404f,0.084273f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.88048f,0.77152f,0.55143f,0.43846f,0.3711f,0.32485f,0.28879f,0.2641f,0.25366f,0.24663f,0.24487f,0.23507f,0.20809f,0.17261f,0.11662f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.91982f,0.81123f,0.5751f,0.45612f,0.38394f,0.33794f,0.30183f,0.28699f,0.27746f,0.27295f,0.26524f,0.24622f,0.21586f,0.17879f,0.13529f,0.061954f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.94888f,0.80328f,0.58841f,0.48047f,0.40685f,0.35213f,0.33619f,0.32131f,0.30936f,0.29628f,0.27737f,0.25002f,0.21413f,0.17193f,0.12449f,0.077062f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.9703f,0.7566f,0.61315f,0.49487f,0.42468f,0.39709f,0.37101f,0.35047f,0.32977f,0.30659f,0.27874f,0.24418f,0.20181f,0.15304f,0.10263f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.98481f,0.70934f,0.58407f,0.50544f,0.46268f,0.42679f,0.39279f,0.36368f,0.33405f,0.30203f,0.26456f,0.22233f,0.17178f,0.11409f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.99396f,0.66382f,0.55625f,0.52322f,0.48458f,0.43442f,0.39095f,0.35222f,0.3132f,0.27157f,0.22251f,0.1703f,0.10701f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.99855f,0.62261f,0.57542f,0.52122f,0.45918f,0.38957f,0.32256f,0.27607f,0.22983f,0.1748f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_tricenter_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_tricenter_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_tricenter_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_7point1_tricenter_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043772f,0.011962f,0.018075f,0.022264f,0.035717f,0.058204f,0.083257f,0.10958f,0.13592f,0.052336f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013084f,0.011636f,0.027472f,0.049384f,0.070085f,0.089694f,0.10655f,0.12342f,0.12737f,0.15705f,0.18623f,0.16489f,0.10973f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0038919f,0.018492f,0.041753f,0.068513f,0.1006f,0.12983f,0.15652f,0.18313f,0.20135f,0.21775f,0.22851f,0.21738f,0.20108f,0.17363f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.016973f,0.040831f,0.073199f,0.10859f,0.14876f,0.1852f,0.21753f,0.24734f,0.26927f,0.28776f,0.27908f,0.25473f,0.24451f,0.24192f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013625f,0.010822f,0.031114f,0.061436f,0.10138f,0.14831f,0.19392f,0.2365f,0.27257f,0.30069f,0.32289f,0.33123f,0.32934f,0.31761f,0.29589f,0.31565f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00041878f,0.017789f,0.0433f,0.07868f,0.12602f,0.18248f,0.23686f,0.27104f,0.28445f,0.2972f,0.33242f,0.36488f,0.38012f,0.37444f,0.35999f,0.39234f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.01238f,0.046242f,0.085813f,0.14312f,0.21247f,0.24649f,0.25211f,0.26005f,0.28505f,0.32118f,0.36741f,0.4164f,0.43128f,0.43048f,0.47409f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043862f,0.029266f,0.080596f,0.14641f,0.2205f,0.22485f,0.23115f,0.25285f,0.27862f,0.31286f,0.35639f,0.41906f,0.48199f,0.49857f,0.55339f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010272f,0.044927f,0.12071f,0.20174f,0.20547f,0.22591f,0.24815f,0.2749f,0.30785f,0.34967f,0.40951f,0.50346f,0.56555f,0.63203f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.084849f,0.13613f,0.1839f,0.20388f,0.22427f,0.24735f,0.2735f,0.30582f,0.35042f,0.41025f,0.5097f,0.63586f,0.70711f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040442f,0.099867f,0.15335f,0.19633f,0.20173f,0.20856f,0.22805f,0.2498f,0.27632f,0.30912f,0.35086f,0.41073f,0.51022f,0.68855f,0.77384f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.084529f,0.14424f,0.19214f,0.2191f,0.2219f,0.22484f,0.23463f,0.25582f,0.28126f,0.31533f,0.35876f,0.42148f,0.52673f,0.72945f,0.83195f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.11688f,0.17249f,0.20818f,0.23505f,0.24475f,0.2465f,0.25358f,0.26396f,0.28868f,0.32468f,0.3709f,0.43824f,0.55121f,0.77133f,0.87965f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.062288f,0.13517f,0.17899f,0.21599f,0.24628f,0.26511f,0.2728f,0.2773f,0.28686f,0.30166f,0.33776f,0.38374f,0.45616f,0.57501f,0.81125f,0.91914f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.076941f,0.12479f,0.17218f,0.21432f,0.25015f,0.27724f,0.29623f,0.30926f,0.32119f,0.33609f,0.35194f,0.4067f,0.48036f,0.58851f,0.80371f,0.94832f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.10298f,0.15337f,0.20208f,0.24438f,0.2786f,0.30666f,0.32979f,0.35044f,0.37098f,0.39705f,0.42446f,0.49488f,0.61339f,0.75713f,0.96987f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.11452f,0.17215f,0.22266f,0.26439f,0.30224f,0.33426f,0.36381f,0.39316f,0.42692f,0.46285f,0.50519f,0.58442f,0.70995f,0.9845f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10754f,0.17079f,0.22232f,0.27197f,0.31358f,0.35258f,0.39132f,0.43484f,0.48512f,0.52368f,0.55594f,0.66449f,0.99377f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.17548f,0.23053f,0.27684f,0.32351f,0.39053f,0.46015f,0.52214f,0.5763f,0.6222f,0.99846f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_7point1_tricenter_ls[21][21] = {
   {1.000000f,0.99863f,0.99396f,0.98481f,0.9703f,0.94888f,0.91914f,0.88048f,0.83195f,0.77384f,0.70834f,0.63338f,0.55484f,0.47562f,0.39394f,0.3173f,0.24362f,0.17537f,0.11147f,0.054079f,-7.8496e-017f},
   {0.99854f,0.94804f,0.94647f,0.94043f,0.92966f,0.91177f,0.87898f,0.82659f,0.76643f,0.70248f,0.63602f,0.56664f,0.49969f,0.43164f,0.36121f,0.29703f,0.24559f,0.20208f,0.16581f,0.13592f,0.000000f},
   {0.99373f,0.94619f,0.89929f,0.8973f,0.89f,0.84522f,0.80369f,0.75196f,0.69549f,0.64182f,0.59149f,0.53909f,0.48676f,0.43211f,0.3753f,0.31848f,0.25563f,0.21817f,0.18628f,0.11031f,0.000000f},
   {0.98443f,0.94057f,0.89693f,0.84178f,0.80673f,0.76938f,0.72295f,0.68173f,0.63988f,0.59999f,0.56152f,0.51902f,0.47535f,0.42864f,0.38061f,0.33006f,0.27965f,0.22857f,0.15778f,0.083896f,0.000000f},
   {0.96987f,0.92924f,0.89008f,0.8064f,0.72353f,0.68753f,0.64727f,0.61961f,0.59007f,0.5611f,0.53236f,0.49762f,0.45999f,0.41905f,0.37687f,0.33185f,0.28785f,0.21842f,0.12802f,0.058746f,0.000000f},
   {0.94832f,0.91132f,0.84488f,0.76916f,0.6876f,0.60199f,0.57793f,0.55557f,0.53786f,0.52026f,0.49866f,0.47305f,0.4406f,0.40425f,0.36538f,0.32707f,0.2697f,0.20197f,0.12403f,0.03616f,0.000000f},
   {0.91914f,0.87839f,0.80323f,0.72262f,0.64697f,0.57779f,0.51599f,0.49381f,0.48147f,0.4732f,0.46311f,0.44521f,0.41747f,0.38486f,0.34957f,0.30247f,0.24789f,0.18361f,0.10709f,0.022585f,0.000000f},
   {0.87965f,0.82586f,0.75136f,0.68116f,0.61943f,0.55563f,0.49394f,0.45149f,0.43778f,0.42773f,0.42381f,0.41464f,0.39077f,0.36007f,0.32202f,0.27305f,0.21805f,0.15706f,0.090176f,0.018356f,0.000000f},
   {0.83195f,0.76558f,0.69482f,0.63955f,0.58992f,0.53794f,0.48142f,0.43767f,0.40132f,0.39038f,0.38425f,0.38246f,0.35885f,0.3262f,0.2847f,0.23683f,0.18569f,0.13031f,0.070512f,0.012179f,0.000000f},
   {0.77494f,0.70182f,0.64105f,0.59937f,0.5609f,0.52028f,0.47314f,0.42777f,0.39034f,0.35673f,0.34932f,0.34449f,0.31565f,0.27779f,0.23728f,0.19424f,0.14921f,0.10103f,0.049741f,0.0045097f,0.000000f},
   {0.70711f,0.63577f,0.59134f,0.56143f,0.53234f,0.49869f,0.46315f,0.42387f,0.38431f,0.34937f,0.3185f,0.28163f,0.2449f,0.21252f,0.18253f,0.14834f,0.1086f,0.068513f,0.027472f,-8.5322e-019f,0.000000f},
   {0.63338f,0.56555f,0.53856f,0.51865f,0.49722f,0.47263f,0.44507f,0.41451f,0.38241f,0.34452f,0.2816f,0.24145f,0.18988f,0.15379f,0.12638f,0.10174f,0.073541f,0.042039f,0.011806f,0.000000f,0.000000f},
   {0.55339f,0.49871f,0.48607f,0.47475f,0.45953f,0.44013f,0.41724f,0.39065f,0.35885f,0.31539f,0.24485f,0.1898f,0.16119f,0.11535f,0.083376f,0.061737f,0.041097f,0.018696f,0.0013628f,0.000000f,0.000000f},
   {0.47409f,0.43048f,0.43138f,0.42817f,0.41859f,0.40381f,0.38442f,0.36003f,0.32583f,0.27748f,0.21245f,0.15351f,0.11527f,0.092466f,0.055926f,0.03134f,0.017152f,0.0039822f,0.000000f,0.000000f,0.000000f},
   {0.39234f,0.35999f,0.37455f,0.38033f,0.37646f,0.36503f,0.34948f,0.32174f,0.28429f,0.23686f,0.18246f,0.12608f,0.083197f,0.055812f,0.03557f,0.011379f,0.0039191f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.31565f,0.29607f,0.31773f,0.32943f,0.33124f,0.32696f,0.30198f,0.27263f,0.2365f,0.19392f,0.14828f,0.10138f,0.061436f,0.031114f,0.011267f,0.002725f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24192f,0.24451f,0.25473f,0.27908f,0.28772f,0.26927f,0.24734f,0.21753f,0.18526f,0.14882f,0.10856f,0.073199f,0.040831f,0.01704f,0.0038302f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17365f,0.20108f,0.21738f,0.22846f,0.21775f,0.20135f,0.18335f,0.15652f,0.12991f,0.1006f,0.068474f,0.041753f,0.018492f,0.0038919f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.10973f,0.16489f,0.18616f,0.15705f,0.12737f,0.12342f,0.10655f,0.089694f,0.070085f,0.049384f,0.027446f,0.011636f,0.0013628f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.052332f,0.13583f,0.10958f,0.083257f,0.058204f,0.035717f,0.022438f,0.018227f,0.011962f,0.0043772f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_7point1_tricenter_rs[21][21] = {
   {-7.8496e-017f,0.052336f,0.10973f,0.17365f,0.24192f,0.31565f,0.39394f,0.47409f,0.55484f,0.63338f,0.70587f,0.77384f,0.83195f,0.87965f,0.91914f,0.94832f,0.96987f,0.9845f,0.99377f,0.99854f,1.000000f},
   {0.000000f,0.13583f,0.16489f,0.20208f,0.24451f,0.29589f,0.35999f,0.43048f,0.49857f,0.56633f,0.63558f,0.70182f,0.76558f,0.82586f,0.87839f,0.91132f,0.92934f,0.94057f,0.94637f,0.94804f,0.99863f},
   {0.000000f,0.11031f,0.18615f,0.21738f,0.25552f,0.31761f,0.37444f,0.43128f,0.48597f,0.53856f,0.59121f,0.64167f,0.69482f,0.75136f,0.80323f,0.84488f,0.89008f,0.89725f,0.89927f,0.94647f,0.99396f},
   {0.000000f,0.083257f,0.15778f,0.22845f,0.27908f,0.32934f,0.38061f,0.42817f,0.47475f,0.51865f,0.56131f,0.59998f,0.63948f,0.6818f,0.72306f,0.76916f,0.80688f,0.84174f,0.8973f,0.94077f,0.98473f},
   {0.000000f,0.058746f,0.12737f,0.2183f,0.28772f,0.33167f,0.37646f,0.41852f,0.45953f,0.49722f,0.53221f,0.56083f,0.58986f,0.61943f,0.64753f,0.6876f,0.72348f,0.80673f,0.89031f,0.92966f,0.9703f},
   {0.000000f,0.035717f,0.12342f,0.20135f,0.26927f,0.32696f,0.36503f,0.40381f,0.44057f,0.47309f,0.49858f,0.52028f,0.53794f,0.55557f,0.57829f,0.60191f,0.688f,0.76938f,0.84522f,0.91177f,0.94888f},
   {0.000000f,0.022264f,0.10655f,0.18361f,0.24774f,0.30233f,0.34948f,0.3848f,0.41719f,0.44502f,0.46308f,0.47314f,0.48142f,0.49394f,0.51592f,0.57793f,0.64727f,0.72306f,0.80369f,0.87898f,0.91982f},
   {0.000000f,0.018075f,0.089694f,0.15698f,0.21753f,0.27257f,0.32174f,0.36002f,0.39065f,0.41451f,0.4238f,0.42773f,0.43804f,0.45143f,0.49424f,0.55557f,0.61961f,0.68173f,0.75196f,0.82659f,0.88048f},
   {0.000000f,0.011962f,0.070085f,0.12983f,0.1852f,0.2365f,0.28429f,0.32614f,0.35884f,0.38237f,0.38425f,0.39034f,0.40127f,0.43778f,0.48142f,0.53827f,0.59007f,0.63988f,0.69549f,0.76643f,0.83292f},
   {0.000000f,0.0043772f,0.049741f,0.10103f,0.14876f,0.19392f,0.23686f,0.27743f,0.31539f,0.34452f,0.34932f,0.35669f,0.39034f,0.42773f,0.47315f,0.52061f,0.5611f,0.59999f,0.64182f,0.7028f,0.77494f},
   {0.000000f,-8.5322e-019f,0.027447f,0.068465f,0.10853f,0.14825f,0.18244f,0.21244f,0.24485f,0.28161f,0.31849f,0.34932f,0.38425f,0.42381f,0.46314f,0.49869f,0.53239f,0.56152f,0.59147f,0.63596f,0.70711f},
   {0.000000f,0.000000f,0.011636f,0.041753f,0.073199f,0.1017f,0.12603f,0.15351f,0.18976f,0.24145f,0.28164f,0.34451f,0.38246f,0.41464f,0.44521f,0.47305f,0.49762f,0.51919f,0.5393f,0.56664f,0.63338f},
   {0.000000f,0.000000f,0.0013084f,0.018492f,0.040831f,0.061737f,0.083146f,0.11527f,0.16121f,0.18988f,0.2449f,0.31565f,0.35887f,0.39092f,0.41747f,0.4406f,0.45999f,0.47535f,0.48676f,0.49969f,0.55484f},
   {0.000000f,0.000000f,0.000000f,0.0038919f,0.016973f,0.031114f,0.056058f,0.092505f,0.11557f,0.15374f,0.21251f,0.27779f,0.3262f,0.36008f,0.38486f,0.40425f,0.41905f,0.42882f,0.43211f,0.43164f,0.47562f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.011267f,0.0356f,0.055926f,0.083376f,0.12638f,0.18252f,0.23728f,0.2847f,0.32214f,0.34955f,0.36552f,0.37704f,0.38081f,0.3753f,0.36121f,0.39394f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027341f,0.011405f,0.03134f,0.061737f,0.10174f,0.14834f,0.19436f,0.23696f,0.27305f,0.30247f,0.32704f,0.33185f,0.33006f,0.31848f,0.29703f,0.3173f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039191f,0.017152f,0.041097f,0.073541f,0.10862f,0.14921f,0.18569f,0.21805f,0.24789f,0.26986f,0.28782f,0.27982f,0.25563f,0.24559f,0.24362f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039822f,0.018696f,0.042039f,0.068554f,0.10103f,0.13031f,0.15706f,0.1837f,0.20197f,0.21842f,0.22858f,0.21822f,0.20208f,0.17537f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013628f,0.011806f,0.027511f,0.049741f,0.070512f,0.090176f,0.10709f,0.12403f,0.12802f,0.15778f,0.1863f,0.16581f,0.11147f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-8.5322e-019f,0.0045097f,0.012179f,0.018356f,0.022585f,0.03616f,0.058746f,0.083896f,0.11031f,0.136f,0.054075f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-7.8496e-017f}};

static float map_8point1_ang[] = {-45,0,45,-90,90,-135,180,135};
static float map_8point1_xsf[] = {-1,0,1,-1,1,-1,0,1};
static float map_8point1_ysf[] = {1,1,1,0,0,-1,-1,-1};
channel_id map_8point1_id[] = {ci_front_left,ci_front_center,ci_front_right,ci_side_center_left,ci_side_center_right,ci_back_left,ci_back_center,ci_back_right,ci_lfe};

static float map_8point1_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,9.4126e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0025743f,0.016552f,0.019339f,0.017689f,0.014677f,0.0075151f,0.0023122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.010122f,0.049892f,0.081385f,0.075976f,0.066587f,0.048878f,0.031384f,0.01438f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0022432f,0.048381f,0.094728f,0.12939f,0.15091f,0.13421f,0.11169f,0.081894f,0.049473f,0.021188f,0.0029287f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019725f,0.095227f,0.15233f,0.18129f,0.18619f,0.18195f,0.1662f,0.14038f,0.099716f,0.051668f,0.015357f,0.0004627f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.067908f,0.15539f,0.20448f,0.21574f,0.21038f,0.19727f,0.18275f,0.16961f,0.14309f,0.089211f,0.030602f,0.0029125f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13152f,0.21916f,0.24385f,0.23799f,0.22019f,0.19777f,0.1798f,0.16484f,0.15891f,0.12092f,0.0391f,0.0061765f,0.0028379f,0.00043186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19821f,0.26858f,0.26884f,0.24624f,0.21773f,0.19453f,0.1758f,0.16036f,0.14653f,0.13495f,0.052607f,0.038854f,0.030373f,0.015188f,0.0028496f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {8.6596e-017f,0.26351f,0.30441f,0.28405f,0.24723f,0.21577f,0.19296f,0.17452f,0.15823f,0.14384f,0.13114f,0.13492f,0.12086f,0.089089f,0.051572f,0.021112f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.14292f,0.32999f,0.33317f,0.29065f,0.24843f,0.21902f,0.19594f,0.17746f,0.1625f,0.14962f,0.14386f,0.14651f,0.15886f,0.14285f,0.099312f,0.049149f,0.01419f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.27953f,0.38637f,0.35876f,0.29909f,0.25487f,0.22426f,0.20041f,0.18277f,0.16832f,0.16249f,0.15824f,0.16036f,0.16482f,0.16948f,0.14005f,0.081488f,0.031102f,0.0022352f,0.000000f,0.000000f,0.000000f},
   {0.40639f,0.44503f,0.38515f,0.31183f,0.26428f,0.23169f,0.20647f,0.18936f,0.18276f,0.17745f,0.17453f,0.1758f,0.17979f,0.18273f,0.16592f,0.11122f,0.048526f,0.0073556f,0.000000f,0.000000f,0.000000f},
   {0.52748f,0.51574f,0.41678f,0.32546f,0.27415f,0.24175f,0.21641f,0.20646f,0.2004f,0.19593f,0.19298f,0.19453f,0.19777f,0.19716f,0.18189f,0.13374f,0.066173f,0.014462f,0.000000f,0.000000f,0.000000f},
   {0.63323f,0.58186f,0.4515f,0.34992f,0.2914f,0.25248f,0.24174f,0.23169f,0.22425f,0.219f,0.21579f,0.21773f,0.22013f,0.21018f,0.18585f,0.15082f,0.075526f,0.017441f,0.000000f,0.000000f,0.000000f},
   {0.72837f,0.62641f,0.51744f,0.37803f,0.31074f,0.29139f,0.27414f,0.26427f,0.25485f,0.24842f,0.24726f,0.24619f,0.23779f,0.2154f,0.18082f,0.12881f,0.081296f,0.019071f,0.000000f,0.000000f,0.000000f},
   {0.81116f,0.6558f,0.5246f,0.41789f,0.37802f,0.34991f,0.32545f,0.31182f,0.29908f,0.29063f,0.28406f,0.26859f,0.24346f,0.20392f,0.15167f,0.09417f,0.04946f,0.016531f,0.000000f,0.000000f,0.000000f},
   {0.88423f,0.67127f,0.52691f,0.5245f,0.51721f,0.45136f,0.41661f,0.38495f,0.35851f,0.33283f,0.30436f,0.26801f,0.21844f,0.15464f,0.094607f,0.047925f,0.0098814f,0.0024671f,0.000000f,0.000000f,0.000000f},
   {0.94622f,0.67633f,0.67099f,0.65523f,0.62554f,0.58081f,0.51465f,0.44406f,0.38544f,0.32902f,0.26339f,0.19725f,0.13069f,0.067274f,0.019339f,0.0021311f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.94446f,0.8823f,0.80914f,0.72626f,0.63102f,0.52519f,0.40402f,0.27711f,0.14046f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_8point1_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.001914f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.0155f,0.025167f,0.017695f,0.0063155f,1.0116e-005f,0.000000f,0.000000f,0.0062031f,0.017508f,0.025125f,0.015305f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0056317f,0.024256f,0.044322f,0.061583f,0.065405f,0.041656f,0.014688f,4.0817e-019f,0.014527f,0.041389f,0.065342f,0.061236f,0.044002f,0.024003f,0.005504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0019274f,0.02644f,0.05812f,0.08731f,0.11105f,0.11767f,0.10963f,0.061306f,0.017226f,0.061006f,0.10958f,0.11735f,0.11066f,0.086884f,0.057744f,0.026151f,0.0018503f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016697f,0.059451f,0.104f,0.13974f,0.15702f,0.15962f,0.15223f,0.13355f,0.063692f,0.13353f,0.15211f,0.15945f,0.15675f,0.13934f,0.10352f,0.059047f,0.016456f,0.000000f,0.000000f},
   {0.000000f,1.2068e-018f,0.038851f,0.096919f,0.15087f,0.17987f,0.18511f,0.17445f,0.15817f,0.14379f,0.13384f,0.14378f,0.15816f,0.17444f,0.18509f,0.17981f,0.15076f,0.096821f,0.038797f,0.000000f,0.000000f},
   {0.000000f,0.0063777f,0.070344f,0.14288f,0.19068f,0.2049f,0.19453f,0.1758f,0.16036f,0.14645f,0.14681f,0.14646f,0.16036f,0.1758f,0.19453f,0.20473f,0.19031f,0.14227f,0.06984f,0.0061903f,0.000000f},
   {0.000000f,0.017224f,0.099719f,0.18101f,0.21822f,0.2193f,0.19777f,0.17979f,0.16475f,0.16187f,0.16149f,0.16187f,0.16477f,0.1798f,0.19777f,0.21922f,0.21792f,0.18045f,0.099116f,0.016918f,0.000000f},
   {0.000000f,0.02596f,0.12753f,0.21148f,0.23925f,0.22819f,0.20284f,0.18535f,0.18085f,0.17814f,0.17812f,0.17814f,0.18084f,0.18536f,0.20284f,0.22818f,0.23901f,0.21095f,0.12685f,0.025562f,0.000000f},
   {0.000000f,0.03194f,0.15144f,0.23904f,0.2564f,0.23733f,0.21182f,0.20371f,0.19964f,0.19751f,0.19694f,0.1975f,0.19963f,0.20369f,0.21184f,0.23733f,0.25621f,0.23853f,0.15068f,0.031485f,0.000000f},
   {0.000000f,0.051138f,0.17541f,0.26062f,0.27419f,0.24713f,0.23812f,0.22985f,0.2244f,0.22133f,0.22022f,0.22132f,0.22439f,0.22984f,0.2381f,0.24715f,0.274f,0.26009f,0.17455f,0.050511f,0.000000f},
   {0.000000f,0.08308f,0.18105f,0.28155f,0.29188f,0.28632f,0.27128f,0.26327f,0.25585f,0.25151f,0.25234f,0.2515f,0.25584f,0.26325f,0.27127f,0.28627f,0.29189f,0.28098f,0.18013f,0.082312f,0.000000f},
   {0.000000f,0.11865f,0.22314f,0.29977f,0.32517f,0.33282f,0.32312f,0.31164f,0.30095f,0.2946f,0.29542f,0.29459f,0.30094f,0.31163f,0.32308f,0.33259f,0.32473f,0.29967f,0.22211f,0.11774f,0.000000f},
   {0.000000f,0.15601f,0.26339f,0.30497f,0.3472f,0.38198f,0.39609f,0.39135f,0.3765f,0.36616f,0.36703f,0.36615f,0.37649f,0.39123f,0.39574f,0.3814f,0.34627f,0.30393f,0.26322f,0.15497f,0.000000f},
   {0.000000f,0.19222f,0.23448f,0.28578f,0.34732f,0.4169f,0.48293f,0.51439f,0.52067f,0.52104f,0.52661f,0.52086f,0.52026f,0.51365f,0.48176f,0.41543f,0.34579f,0.28436f,0.23319f,0.19202f,0.000000f},
   {1.1102e-016f,0.076479f,0.15764f,0.24801f,0.34452f,0.44874f,0.55712f,0.67263f,0.78467f,0.89574f,1.000000f,0.89382f,0.78261f,0.67046f,0.55485f,0.4464f,0.34213f,0.24558f,0.15519f,0.074014f,0.000000f}};

static float map_8point1_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022352f,0.0073556f,0.014462f,0.017441f,0.019071f,0.016531f,0.0024671f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01419f,0.031102f,0.048526f,0.066173f,0.075526f,0.081297f,0.04946f,0.0098814f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028496f,0.021112f,0.049149f,0.081488f,0.11122f,0.13374f,0.15081f,0.12881f,0.09417f,0.047925f,0.0021311f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00043186f,0.015188f,0.051545f,0.099312f,0.14005f,0.16592f,0.1819f,0.18585f,0.18082f,0.15167f,0.094607f,0.019339f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028379f,0.030373f,0.089057f,0.14285f,0.16948f,0.18273f,0.19716f,0.21018f,0.2154f,0.20392f,0.15464f,0.067274f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0004627f,0.0029125f,0.0061679f,0.038854f,0.12083f,0.15886f,0.16483f,0.17979f,0.19777f,0.22013f,0.23779f,0.24346f,0.21844f,0.13069f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0029287f,0.015357f,0.030602f,0.0391f,0.052555f,0.13491f,0.14652f,0.16036f,0.1758f,0.19453f,0.21773f,0.24619f,0.26859f,0.26801f,0.19725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.021156f,0.051639f,0.089163f,0.1209f,0.13493f,0.13114f,0.14385f,0.15824f,0.17453f,0.19297f,0.21578f,0.24725f,0.28402f,0.30431f,0.2633f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.01438f,0.049473f,0.099716f,0.14309f,0.15891f,0.1465f,0.14385f,0.14961f,0.16249f,0.17745f,0.19593f,0.219f,0.24842f,0.29063f,0.33283f,0.32902f,0.14046f},
   {0.000000f,0.000000f,0.000000f,0.0023122f,0.031384f,0.081894f,0.14038f,0.16961f,0.16482f,0.16036f,0.15824f,0.1625f,0.16831f,0.18276f,0.2004f,0.22425f,0.25485f,0.29908f,0.35851f,0.38544f,0.27711f},
   {0.000000f,0.000000f,0.000000f,0.0075151f,0.048878f,0.11169f,0.1662f,0.18272f,0.1798f,0.1758f,0.17453f,0.17746f,0.18277f,0.18935f,0.20646f,0.23169f,0.26427f,0.31182f,0.38495f,0.44406f,0.40402f},
   {0.000000f,0.000000f,0.000000f,0.014677f,0.066587f,0.13421f,0.18194f,0.19727f,0.19777f,0.19453f,0.19297f,0.19594f,0.20041f,0.20647f,0.2164f,0.24174f,0.27414f,0.32545f,0.41661f,0.51465f,0.52519f},
   {0.000000f,0.000000f,0.000000f,0.017689f,0.075976f,0.15092f,0.18619f,0.21038f,0.22019f,0.21773f,0.21578f,0.21902f,0.22426f,0.23169f,0.24175f,0.25247f,0.29139f,0.34991f,0.45136f,0.58081f,0.63102f},
   {0.000000f,0.000000f,0.000000f,0.019339f,0.081415f,0.12939f,0.18129f,0.21574f,0.23799f,0.24624f,0.24725f,0.24843f,0.25487f,0.26428f,0.27415f,0.2914f,0.31073f,0.37802f,0.51721f,0.62554f,0.72626f},
   {0.000000f,0.000000f,0.000000f,0.016574f,0.049892f,0.094728f,0.15233f,0.20448f,0.24385f,0.26884f,0.28405f,0.29065f,0.29909f,0.31183f,0.32546f,0.34992f,0.37803f,0.41787f,0.5245f,0.65523f,0.80914f},
   {0.000000f,0.000000f,0.000000f,0.0025743f,0.010122f,0.048381f,0.095227f,0.15539f,0.21916f,0.26858f,0.3044f,0.33317f,0.35876f,0.38515f,0.41678f,0.4515f,0.51744f,0.5246f,0.52688f,0.67099f,0.8823f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022432f,0.019725f,0.067908f,0.13152f,0.19821f,0.26356f,0.32999f,0.38637f,0.44503f,0.51574f,0.58186f,0.62641f,0.6558f,0.67127f,0.6763f,0.94439f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.14292f,0.27953f,0.40639f,0.52748f,0.63323f,0.72837f,0.81116f,0.88423f,0.94629f,1.000000f}};

static float map_8point1_lsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.076479f,0.1924f,0.15601f,0.11842f,0.08308f,0.051138f,0.03194f,0.02596f,0.017224f,0.006217f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15701f,0.23422f,0.26354f,0.22314f,0.18089f,0.17541f,0.15144f,0.12753f,0.099719f,0.070344f,0.038959f,0.016585f,0.0019274f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24799f,0.28578f,0.30478f,0.2999f,0.28155f,0.26062f,0.23875f,0.21148f,0.18101f,0.14288f,0.097017f,0.059361f,0.02644f,0.0055357f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34452f,0.34709f,0.3472f,0.32503f,0.29199f,0.2741f,0.2564f,0.23925f,0.21822f,0.19068f,0.15101f,0.104f,0.05812f,0.024256f,0.0054585f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44874f,0.4169f,0.38198f,0.33282f,0.28632f,0.24721f,0.23733f,0.22819f,0.21923f,0.20483f,0.17996f,0.13974f,0.08731f,0.044322f,0.015426f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55712f,0.48293f,0.39609f,0.32283f,0.2712f,0.23804f,0.21189f,0.20278f,0.19777f,0.19453f,0.18519f,0.15702f,0.11105f,0.061583f,0.025231f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67263f,0.51439f,0.39135f,0.31154f,0.26327f,0.22985f,0.20371f,0.18541f,0.17979f,0.1758f,0.17449f,0.15962f,0.11761f,0.06551f,0.017632f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78467f,0.52067f,0.3765f,0.30095f,0.25585f,0.2244f,0.19964f,0.1808f,0.16481f,0.16036f,0.15821f,0.15223f,0.10975f,0.041656f,0.0063155f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.52104f,0.36605f,0.29451f,0.25151f,0.22133f,0.19751f,0.17814f,0.16187f,0.14649f,0.14382f,0.13363f,0.061306f,0.014688f,1.0116e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.52679f,0.36715f,0.29551f,0.25242f,0.22029f,0.19701f,0.17818f,0.16155f,0.14686f,0.1311f,0.063705f,0.017218f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.52086f,0.36615f,0.29459f,0.2515f,0.22126f,0.1975f,0.17814f,0.16187f,0.14649f,0.14382f,0.13358f,0.061006f,0.014527f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78261f,0.52026f,0.37649f,0.30094f,0.25584f,0.22432f,0.19963f,0.18084f,0.1648f,0.16036f,0.1582f,0.15211f,0.10961f,0.041389f,0.0062031f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67046f,0.51365f,0.39123f,0.31163f,0.26325f,0.22984f,0.20363f,0.1854f,0.17974f,0.1758f,0.17448f,0.15945f,0.11735f,0.065362f,0.017508f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55485f,0.48176f,0.39574f,0.32282f,0.27127f,0.2381f,0.21189f,0.20284f,0.19777f,0.19453f,0.18513f,0.15675f,0.11066f,0.061236f,0.025146f,0.00059225f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.4464f,0.41543f,0.3814f,0.33259f,0.28621f,0.2472f,0.23726f,0.22818f,0.21922f,0.20473f,0.17984f,0.13934f,0.086884f,0.044002f,0.015305f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34213f,0.34579f,0.34627f,0.32473f,0.29192f,0.274f,0.25621f,0.23901f,0.21792f,0.19031f,0.1508f,0.10352f,0.057744f,0.024003f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24558f,0.28436f,0.30393f,0.29971f,0.28098f,0.26009f,0.23836f,0.21095f,0.18045f,0.14227f,0.096837f,0.059047f,0.026151f,0.005504f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15519f,0.23319f,0.26327f,0.22211f,0.18013f,0.17455f,0.15068f,0.12685f,0.099116f,0.06984f,0.038815f,0.016456f,0.0018503f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.074009f,0.19209f,0.15497f,0.11774f,0.082312f,0.050511f,0.031485f,0.025562f,0.016918f,0.0061903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_8point1_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0061903f,0.016918f,0.025562f,0.031485f,0.050511f,0.082312f,0.11774f,0.15497f,0.19222f,0.074014f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0018503f,0.016456f,0.038851f,0.06984f,0.099116f,0.12685f,0.15068f,0.17455f,0.18013f,0.22211f,0.26337f,0.23319f,0.15519f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.005504f,0.026151f,0.059047f,0.096892f,0.14227f,0.18045f,0.21095f,0.23853f,0.26009f,0.28098f,0.29979f,0.30393f,0.28436f,0.24556f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0054168f,0.024003f,0.057744f,0.10352f,0.15084f,0.19031f,0.21792f,0.23901f,0.25621f,0.274f,0.29198f,0.32473f,0.34627f,0.34579f,0.34213f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.015305f,0.044002f,0.086884f,0.13934f,0.17988f,0.20473f,0.21922f,0.22818f,0.23733f,0.24725f,0.28627f,0.33259f,0.3814f,0.41543f,0.4464f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.025157f,0.061236f,0.11066f,0.15675f,0.18518f,0.19453f,0.19777f,0.20284f,0.21193f,0.2381f,0.27127f,0.32308f,0.39574f,0.48176f,0.55485f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017508f,0.065396f,0.11735f,0.15945f,0.17454f,0.1758f,0.1798f,0.18544f,0.20369f,0.22984f,0.26325f,0.31163f,0.39123f,0.51365f,0.67046f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0062031f,0.041389f,0.10962f,0.15211f,0.15825f,0.16036f,0.16483f,0.18084f,0.19963f,0.22439f,0.25584f,0.30094f,0.37649f,0.52026f,0.78261f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014527f,0.061006f,0.13359f,0.14386f,0.14652f,0.16187f,0.17814f,0.1975f,0.22132f,0.2515f,0.29459f,0.36615f,0.52086f,0.89382f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-4.0817e-019f,0.017202f,0.06369f,0.13113f,0.14689f,0.16158f,0.17821f,0.19705f,0.22033f,0.25247f,0.29557f,0.36722f,0.52689f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.0116e-005f,0.014688f,0.061306f,0.13361f,0.14385f,0.14651f,0.16187f,0.17814f,0.19751f,0.22133f,0.25151f,0.2946f,0.36616f,0.52104f,0.89574f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0063155f,0.041656f,0.10967f,0.15223f,0.15823f,0.16036f,0.16482f,0.18085f,0.19964f,0.2244f,0.25585f,0.30095f,0.3765f,0.52067f,0.78467f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017695f,0.065451f,0.11767f,0.15962f,0.17452f,0.1758f,0.17979f,0.18543f,0.20371f,0.22985f,0.26327f,0.31164f,0.39135f,0.51439f,0.67263f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062925f,0.0252f,0.061583f,0.11105f,0.15702f,0.18518f,0.19453f,0.19777f,0.20284f,0.21192f,0.23812f,0.27128f,0.32312f,0.39609f,0.48293f,0.55712f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.0155f,0.044322f,0.08731f,0.13974f,0.17992f,0.2049f,0.2193f,0.22819f,0.23733f,0.24724f,0.28632f,0.33282f,0.38198f,0.4169f,0.44874f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.024256f,0.05812f,0.104f,0.15089f,0.19068f,0.21822f,0.23925f,0.2564f,0.27419f,0.292f,0.32517f,0.3472f,0.34732f,0.34452f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0056317f,0.02644f,0.059451f,0.09695f,0.14288f,0.18101f,0.21148f,0.23904f,0.26062f,0.28155f,0.29985f,0.30497f,0.28578f,0.24801f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019274f,0.016697f,0.038906f,0.070344f,0.099719f,0.12753f,0.15144f,0.17541f,0.18105f,0.22314f,0.26347f,0.23448f,0.15764f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.2068e-018f,0.0063777f,0.017224f,0.02596f,0.03194f,0.051138f,0.08308f,0.11865f,0.15601f,0.19233f,0.076473f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f}};

static float map_8point1_ls[21][21] = {
   {1.000000f,0.94629f,0.88423f,0.81116f,0.72837f,0.63323f,0.52519f,0.40639f,0.27711f,0.14046f,0.0024683f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.94446f,0.67616f,0.67127f,0.65461f,0.62641f,0.58186f,0.51574f,0.44503f,0.38637f,0.32899f,0.2638f,0.19821f,0.13152f,0.067908f,0.019725f,0.0022432f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.88271f,0.67026f,0.52679f,0.5246f,0.51645f,0.4515f,0.41678f,0.38515f,0.35876f,0.33317f,0.30452f,0.26791f,0.21916f,0.15539f,0.095227f,0.048381f,0.010122f,0.0024671f,2.6829e-005f,0.000000f,0.000000f},
   {0.80907f,0.65523f,0.52363f,0.4178f,0.37803f,0.34992f,0.32507f,0.31183f,0.29909f,0.29065f,0.28411f,0.2683f,0.24385f,0.2039f,0.15167f,0.094728f,0.04946f,0.016615f,0.000000f,0.000000f,0.000000f},
   {0.72626f,0.62507f,0.51721f,0.37734f,0.31067f,0.29085f,0.27415f,0.26428f,0.25487f,0.24843f,0.24722f,0.24624f,0.23799f,0.21574f,0.18079f,0.12939f,0.081491f,0.019339f,0.000000f,0.000000f,0.000000f},
   {0.63102f,0.58081f,0.45136f,0.34991f,0.29139f,0.25242f,0.24175f,0.23169f,0.22384f,0.2186f,0.21576f,0.21773f,0.22019f,0.21038f,0.18574f,0.15105f,0.075526f,0.017689f,0.000000f,0.000000f,0.000000f},
   {0.52519f,0.51465f,0.41661f,0.32507f,0.27363f,0.2413f,0.21636f,0.20608f,0.20041f,0.19594f,0.19295f,0.19453f,0.19777f,0.19727f,0.18201f,0.13421f,0.066587f,0.014462f,0.000000f,0.000000f,0.000000f},
   {0.40402f,0.44406f,0.38495f,0.31124f,0.26427f,0.23169f,0.20646f,0.18931f,0.18277f,0.17746f,0.17451f,0.1758f,0.17946f,0.18275f,0.16582f,0.11169f,0.048878f,0.0075151f,0.000000f,0.000000f,0.000000f},
   {0.27711f,0.38544f,0.35851f,0.29908f,0.25485f,0.22425f,0.2004f,0.18242f,0.16828f,0.1625f,0.15822f,0.16036f,0.16481f,0.16961f,0.14038f,0.081488f,0.031384f,0.0023122f,0.000000f,0.000000f,0.000000f},
   {0.14292f,0.32902f,0.33247f,0.29009f,0.24842f,0.219f,0.19593f,0.17745f,0.16249f,0.14958f,0.14384f,0.1465f,0.15891f,0.14309f,0.099716f,0.049149f,0.01438f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.26327f,0.30428f,0.28401f,0.24725f,0.21578f,0.19298f,0.17453f,0.15824f,0.14385f,0.13114f,0.13496f,0.12094f,0.089225f,0.051669f,0.021199f,0.0019397f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19725f,0.26801f,0.26859f,0.24619f,0.21732f,0.19453f,0.1758f,0.16036f,0.1465f,0.1349f,0.052571f,0.0391f,0.030602f,0.015357f,0.0029287f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13069f,0.21844f,0.24346f,0.23779f,0.21977f,0.19777f,0.17979f,0.16482f,0.15886f,0.12084f,0.038854f,0.0061765f,0.0028379f,0.0004627f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.067274f,0.15464f,0.20392f,0.2154f,0.21018f,0.19689f,0.1827f,0.16928f,0.14285f,0.089072f,0.030373f,0.0028379f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019339f,0.094607f,0.15196f,0.18082f,0.18585f,0.18188f,0.16592f,0.14005f,0.099312f,0.051555f,0.015188f,0.00043186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0021311f,0.047925f,0.09417f,0.12885f,0.1508f,0.13377f,0.11122f,0.081488f,0.049149f,0.021112f,0.0028496f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0098814f,0.04946f,0.081296f,0.075526f,0.066173f,0.048526f,0.031102f,0.01419f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0024671f,0.016531f,0.019071f,0.017441f,0.014677f,0.0073556f,0.0022352f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_8point1_cs[21][21] = {
   {-1.1102e-016f,0.074014f,0.15519f,0.24558f,0.34213f,0.4464f,0.55712f,0.67046f,0.78467f,0.89574f,0.99825f,0.89574f,0.78467f,0.67263f,0.55712f,0.44874f,0.34452f,0.24801f,0.15764f,0.076479f,-1.1102e-016f},
   {0.000000f,0.19209f,0.23319f,0.28578f,0.34579f,0.41543f,0.48176f,0.51365f,0.52026f,0.52197f,0.5264f,0.52104f,0.52067f,0.51439f,0.48293f,0.4169f,0.34732f,0.28578f,0.23448f,0.19222f,0.000000f},
   {0.000000f,0.15601f,0.26325f,0.30393f,0.34738f,0.3814f,0.39574f,0.39123f,0.37649f,0.36615f,0.36688f,0.36692f,0.3765f,0.39135f,0.39609f,0.38198f,0.3472f,0.30504f,0.2634f,0.15601f,0.000000f},
   {0.000000f,0.11774f,0.22314f,0.2997f,0.32473f,0.33259f,0.32378f,0.31163f,0.30094f,0.29459f,0.2953f,0.29521f,0.30095f,0.31229f,0.32378f,0.33282f,0.32553f,0.29976f,0.22314f,0.11865f,0.000000f},
   {0.000000f,0.08308f,0.18013f,0.28176f,0.29188f,0.28689f,0.27127f,0.26325f,0.25584f,0.2515f,0.25223f,0.25151f,0.25585f,0.26327f,0.27185f,0.28632f,0.29183f,0.28155f,0.18105f,0.08308f,0.000000f},
   {0.000000f,0.050511f,0.17455f,0.26009f,0.274f,0.24714f,0.2381f,0.22984f,0.22487f,0.22179f,0.22013f,0.22133f,0.2244f,0.22985f,0.23862f,0.24701f,0.2746f,0.26062f,0.17541f,0.051138f,0.000000f},
   {0.000000f,0.031485f,0.15068f,0.23921f,0.25678f,0.23783f,0.21184f,0.20413f,0.19963f,0.1975f,0.19686f,0.19751f,0.19964f,0.20371f,0.21172f,0.23733f,0.2564f,0.23921f,0.15144f,0.03194f,0.000000f},
   {0.000000f,0.025562f,0.12685f,0.2116f,0.23901f,0.22818f,0.20284f,0.18536f,0.18084f,0.17814f,0.17805f,0.17814f,0.18123f,0.18526f,0.20327f,0.22819f,0.23925f,0.21148f,0.12753f,0.02596f,0.000000f},
   {0.000000f,0.016918f,0.099116f,0.18045f,0.21792f,0.21922f,0.19777f,0.18017f,0.16476f,0.16187f,0.16143f,0.16187f,0.16467f,0.17979f,0.19777f,0.21969f,0.21822f,0.18101f,0.099719f,0.017224f,0.000000f},
   {0.000000f,0.0061903f,0.070344f,0.14288f,0.19031f,0.20473f,0.19453f,0.1758f,0.16036f,0.14646f,0.14675f,0.14638f,0.16036f,0.1758f,0.19453f,0.20519f,0.19068f,0.14288f,0.070344f,0.0063777f,0.000000f},
   {0.000000f,-1.2068e-018f,0.038815f,0.096824f,0.15076f,0.17981f,0.18508f,0.17444f,0.15816f,0.14378f,0.13385f,0.14372f,0.15809f,0.17436f,0.18506f,0.17981f,0.15084f,0.096892f,0.038851f,-1.2068e-018f,0.000000f},
   {0.000000f,0.000000f,0.016456f,0.059047f,0.10352f,0.1398f,0.15675f,0.15945f,0.15211f,0.13355f,0.063641f,0.13353f,0.15223f,0.15962f,0.15702f,0.13974f,0.104f,0.059451f,0.016697f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0018503f,0.026151f,0.057744f,0.08731f,0.11066f,0.11735f,0.1096f,0.061006f,0.017178f,0.061306f,0.10962f,0.11772f,0.11105f,0.08731f,0.05812f,0.02644f,0.0019274f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.005504f,0.024003f,0.044002f,0.061583f,0.06537f,0.041656f,0.014527f,-8.1634e-019f,0.014688f,0.041656f,0.065404f,0.061583f,0.044322f,0.024256f,0.0056317f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0054168f,0.015305f,0.025146f,0.017508f,0.0062031f,-4.5501e-019f,0.000000f,1.0116e-005f,0.0063155f,0.017695f,0.025157f,0.0155f,0.0055425f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062925f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_8point1_rs[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.14046f,0.27711f,0.40402f,0.52519f,0.63102f,0.72626f,0.80914f,0.8823f,0.94446f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0021311f,0.019339f,0.067274f,0.13069f,0.19725f,0.26337f,0.32902f,0.38544f,0.44406f,0.51465f,0.58081f,0.62554f,0.65523f,0.67099f,0.6762f,0.94629f},
   {0.000000f,0.000000f,0.000000f,0.0024671f,0.0098814f,0.047925f,0.094607f,0.15464f,0.21844f,0.26801f,0.30431f,0.33283f,0.35851f,0.38495f,0.41661f,0.45136f,0.51721f,0.5245f,0.52678f,0.67127f,0.88423f},
   {0.000000f,0.000000f,0.000000f,0.016531f,0.04946f,0.09417f,0.15167f,0.20392f,0.24346f,0.26859f,0.28399f,0.29063f,0.29908f,0.31182f,0.32545f,0.34991f,0.37802f,0.41779f,0.5246f,0.6558f,0.8111f},
   {0.000000f,0.000000f,0.000000f,0.019071f,0.081326f,0.12881f,0.18082f,0.2154f,0.23779f,0.24619f,0.2472f,0.24842f,0.25485f,0.26427f,0.27414f,0.29139f,0.31067f,0.37803f,0.51744f,0.62641f,0.72837f},
   {0.000000f,0.000000f,0.000000f,0.017441f,0.075526f,0.15084f,0.18585f,0.21018f,0.22013f,0.21773f,0.21574f,0.219f,0.22425f,0.23169f,0.24174f,0.25242f,0.2914f,0.34992f,0.4515f,0.58186f,0.63323f},
   {0.000000f,0.000000f,0.000000f,0.014462f,0.066173f,0.13374f,0.1819f,0.19716f,0.19777f,0.19453f,0.19293f,0.19593f,0.2004f,0.20646f,0.21636f,0.24175f,0.27415f,0.32546f,0.41678f,0.51574f,0.52748f},
   {0.000000f,0.000000f,0.000000f,0.0073556f,0.048526f,0.11122f,0.16592f,0.18271f,0.17979f,0.1758f,0.17449f,0.17745f,0.18276f,0.18931f,0.20647f,0.23169f,0.26428f,0.31183f,0.38515f,0.44503f,0.40639f},
   {0.000000f,0.000000f,0.000000f,0.0022352f,0.031102f,0.081488f,0.14005f,0.16948f,0.16481f,0.16036f,0.15821f,0.16249f,0.16828f,0.18277f,0.20041f,0.22426f,0.25487f,0.29909f,0.35876f,0.38637f,0.27953f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.01419f,0.049149f,0.099312f,0.14285f,0.15886f,0.1465f,0.14382f,0.14958f,0.1625f,0.17746f,0.19594f,0.21902f,0.24843f,0.29065f,0.33317f,0.32999f,0.14292f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.021112f,0.051572f,0.089089f,0.12085f,0.13491f,0.13112f,0.14383f,0.15821f,0.1745f,0.19294f,0.21575f,0.24721f,0.28401f,0.30433f,0.26339f,-8.6596e-017f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028496f,0.015188f,0.030373f,0.038854f,0.05254f,0.13492f,0.14649f,0.16036f,0.1758f,0.19453f,0.21773f,0.24624f,0.26884f,0.26858f,0.19821f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00043186f,0.0028379f,0.0061594f,0.0391f,0.12087f,0.15891f,0.16481f,0.1798f,0.19777f,0.22019f,0.23799f,0.24385f,0.21916f,0.13152f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0029125f,0.030602f,0.089105f,0.14309f,0.16961f,0.18271f,0.19727f,0.21038f,0.21574f,0.20448f,0.15539f,0.067908f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0004627f,0.015357f,0.051582f,0.099716f,0.14038f,0.1662f,0.18192f,0.18619f,0.18129f,0.15233f,0.095227f,0.019725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0029287f,0.021123f,0.049473f,0.081894f,0.11169f,0.13421f,0.15086f,0.12939f,0.094728f,0.048381f,0.0022432f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01438f,0.031384f,0.048878f,0.066587f,0.075976f,0.081342f,0.049892f,0.010122f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0023122f,0.0075151f,0.014677f,0.017689f,0.019339f,0.016553f,0.0025743f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.4126e-019f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_densepanorama_ang[] = {-45,-26,0,26,45,-63,63,-95,95};
static float map_9point1_densepanorama_xsf[] = {-1,-0.5,0,0.5,1,-1,1,-1,1};
static float map_9point1_densepanorama_ysf[] = {1,1,1,1,1,0.5,0.5,0,0};
channel_id map_9point1_densepanorama_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_side_front_left,ci_side_front_right,ci_side_center_left,ci_side_center_right,ci_lfe};

static float map_9point1_densepanorama_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.005581f,0.003291f,1.7252e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0081504f,0.042808f,0.072882f,0.060953f,0.042164f,0.017887f,0.0013668f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0027588f,0.054743f,0.091228f,0.091909f,0.082995f,0.079348f,0.071132f,0.040421f,0.0039453f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.040396f,0.10257f,0.10193f,0.089276f,0.079333f,0.072621f,0.070291f,0.068709f,0.03606f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0060181f,0.10346f,0.11606f,0.098677f,0.086748f,0.077297f,0.070277f,0.064552f,0.062673f,0.06051f,0.0017892f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.047382f,0.13537f,0.11322f,0.096621f,0.085123f,0.076125f,0.068709f,0.062673f,0.057379f,0.05627f,0.000000f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10632f,0.1408f,0.11333f,0.0968f,0.08448f,0.075551f,0.068329f,0.061952f,0.05632f,0.051341f,0.056303f,0.060536f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.16195f,0.14064f,0.1132f,0.096622f,0.085107f,0.076104f,0.068709f,0.062673f,0.060449f,0.05632f,0.057346f,0.062673f,0.068709f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.194f,0.14507f,0.11609f,0.098677f,0.086764f,0.077297f,0.071771f,0.068005f,0.062673f,0.061952f,0.062673f,0.064514f,0.070277f,0.071028f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.22178f,0.15206f,0.12055f,0.10193f,0.090467f,0.081765f,0.076506f,0.071744f,0.068709f,0.068329f,0.068709f,0.070291f,0.072578f,0.079333f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25576f,0.16273f,0.12661f,0.10766f,0.096098f,0.087435f,0.081735f,0.077297f,0.076125f,0.075551f,0.076104f,0.077297f,0.079348f,0.082947f,0.06067f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {3.1398e-016f,0.28205f,0.17804f,0.13801f,0.11623f,0.10201f,0.096063f,0.090425f,0.086748f,0.085123f,0.08448f,0.085107f,0.086764f,0.089301f,0.091873f,0.072927f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24261f,0.28709f,0.20797f,0.15099f,0.12555f,0.11619f,0.10762f,0.10193f,0.098677f,0.096621f,0.0968f,0.096622f,0.098677f,0.10193f,0.091044f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.46196f,0.29071f,0.21045f,0.16884f,0.15094f,0.13799f,0.12656f,0.12057f,0.11606f,0.11322f,0.11333f,0.1132f,0.11609f,0.10231f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.66287f,0.29364f,0.21289f,0.21045f,0.20789f,0.17806f,0.16273f,0.15206f,0.14511f,0.14066f,0.1408f,0.1352f,0.10303f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.8397f,0.29675f,0.29354f,0.29061f,0.28698f,0.28196f,0.25543f,0.22155f,0.19371f,0.16153f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_densepanorama_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_densepanorama_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_densepanorama_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_9point1_densepanorama_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031891f,0.0054514f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013174f,0.017687f,0.041859f,0.06067f,0.072899f,0.042466f,0.0079947f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003925f,0.040182f,0.071028f,0.079333f,0.082923f,0.091873f,0.091044f,0.054336f,0.0026644f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.036005f,0.068709f,0.070277f,0.072557f,0.079348f,0.089301f,0.10193f,0.10231f,0.040017f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017407f,0.060499f,0.062673f,0.064496f,0.070291f,0.077297f,0.086764f,0.098677f,0.11609f,0.10303f,0.005855f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.000000f,0.056286f,0.057329f,0.062673f,0.068709f,0.076104f,0.085107f,0.096622f,0.1132f,0.1352f,0.046879f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.06051f,0.056286f,0.051311f,0.056286f,0.061915f,0.068289f,0.075506f,0.08443f,0.096742f,0.11326f,0.14072f,0.10645f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040421f,0.068709f,0.062673f,0.057312f,0.056287f,0.060432f,0.062673f,0.068709f,0.076125f,0.085123f,0.096621f,0.11322f,0.14066f,0.16153f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.071132f,0.070291f,0.064476f,0.062673f,0.061916f,0.062673f,0.067986f,0.071744f,0.077297f,0.086748f,0.098677f,0.11606f,0.14511f,0.19371f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.079348f,0.072536f,0.070277f,0.068709f,0.068289f,0.068709f,0.071771f,0.076484f,0.081735f,0.090425f,0.10193f,0.12057f,0.15206f,0.22155f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.060953f,0.082898f,0.079333f,0.077297f,0.076125f,0.075507f,0.076104f,0.077297f,0.081765f,0.087411f,0.096063f,0.10762f,0.12656f,0.16273f,0.25543f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.072826f,0.091909f,0.089276f,0.086748f,0.085123f,0.08443f,0.085107f,0.086764f,0.090467f,0.096098f,0.10198f,0.11619f,0.13799f,0.17806f,0.28196f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.091228f,0.10193f,0.098677f,0.096621f,0.096743f,0.096622f,0.098677f,0.10193f,0.10766f,0.11623f,0.12551f,0.15094f,0.20789f,0.28698f,0.23903f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.10257f,0.11606f,0.11322f,0.11326f,0.1132f,0.11609f,0.12055f,0.12661f,0.13801f,0.15099f,0.16879f,0.21045f,0.29061f,0.4584f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10346f,0.13537f,0.14072f,0.14064f,0.14507f,0.15206f,0.16273f,0.17804f,0.20797f,0.21045f,0.21283f,0.29354f,0.65936f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.16195f,0.194f,0.22178f,0.25576f,0.28205f,0.28709f,0.29071f,0.29364f,0.29667f,0.83624f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_9point1_densepanorama_lsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040704f,0.026172f,0.030577f,0.027969f,0.023206f,0.011882f,0.003656f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016004f,0.078886f,0.11885f,0.11126f,0.10005f,0.077277f,0.049623f,0.022737f,0.0030466f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0035468f,0.076496f,0.13684f,0.13679f,0.11897f,0.11432f,0.10984f,0.10114f,0.076046f,0.033501f,0.0046306f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.031188f,0.14617f,0.15418f,0.1299f,0.11431f,0.10197f,0.097664f,0.095287f,0.093649f,0.075427f,0.024282f,0.00073159f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10737f,0.1817f,0.1484f,0.12564f,0.10986f,0.097669f,0.089224f,0.086605f,0.08469f,0.083965f,0.048387f,0.004605f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19838f,0.17849f,0.14282f,0.12164f,0.1068f,0.095276f,0.0866f,0.07931f,0.077259f,0.076129f,0.058978f,0.0048965f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23832f,0.17313f,0.13935f,0.11911f,0.10488f,0.093632f,0.084699f,0.077251f,0.070498f,0.069208f,0.041647f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.24833f,0.17308f,0.13931f,0.11899f,0.10385f,0.092873f,0.083996f,0.076156f,0.069233f,0.063102f,0.05511f,0.019286f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.22597f,0.25121f,0.17526f,0.1413f,0.12102f,0.1069f,0.095882f,0.087318f,0.080638f,0.070515f,0.069221f,0.070532f,0.07488f,0.032609f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44198f,0.26542f,0.18277f,0.14664f,0.1254f,0.11069f,0.099453f,0.088959f,0.07933f,0.077251f,0.076144f,0.077259f,0.079348f,0.070283f,0.013958f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.64256f,0.2947f,0.1939f,0.15413f,0.13115f,0.11353f,0.099577f,0.089246f,0.0866f,0.084699f,0.083982f,0.08469f,0.086605f,0.085004f,0.039295f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83403f,0.33937f,0.20938f,0.16007f,0.13344f,0.11606f,0.102f,0.097669f,0.095276f,0.093632f,0.092858f,0.093649f,0.095287f,0.088683f,0.054552f,0.0013532f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.35937f,0.22225f,0.16947f,0.13938f,0.11899f,0.11431f,0.10986f,0.1068f,0.10488f,0.10383f,0.10487f,0.10415f,0.081353f,0.034375f,0.0043588f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.7669f,0.35542f,0.25327f,0.18049f,0.14646f,0.13768f,0.1299f,0.12564f,0.12164f,0.11911f,0.11897f,0.11747f,0.098408f,0.05387f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55102f,0.34365f,0.25072f,0.19696f,0.17861f,0.1657f,0.15445f,0.1484f,0.14282f,0.13935f,0.13074f,0.10642f,0.058689f,0.012407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34893f,0.32425f,0.24834f,0.24599f,0.23588f,0.21001f,0.1922f,0.1745f,0.1548f,0.12874f,0.085642f,0.036985f,0.0041976f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.16741f,0.30017f,0.27214f,0.23269f,0.17995f,0.11341f,0.070758f,0.057469f,0.038068f,0.013988f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_densepanorama_rsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0036134f,0.011794f,0.023088f,0.027832f,0.030429f,0.026399f,0.0040112f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031126f,0.022632f,0.049467f,0.077089f,0.099949f,0.11118f,0.11911f,0.078648f,0.015871f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045869f,0.033596f,0.075931f,0.10117f,0.10998f,0.11448f,0.11916f,0.13692f,0.13673f,0.076245f,0.0034849f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00071455f,0.024189f,0.075553f,0.093753f,0.095409f,0.097805f,0.10214f,0.11445f,0.13006f,0.15434f,0.14595f,0.030939f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045638f,0.04826f,0.084116f,0.084794f,0.086729f,0.089374f,0.097788f,0.10998f,0.12579f,0.14861f,0.18178f,0.10702f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0049397f,0.058905f,0.076265f,0.077358f,0.079443f,0.086706f,0.095393f,0.10693f,0.1218f,0.14297f,0.17876f,0.19813f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041705f,0.069332f,0.070616f,0.077346f,0.084808f,0.093775f,0.10503f,0.11926f,0.13955f,0.17338f,0.23845f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.128e-019f,0.019251f,0.055118f,0.063203f,0.069332f,0.076265f,0.084116f,0.093006f,0.104f,0.11916f,0.13951f,0.17333f,0.24869f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,2.262e-005f,0.032844f,0.075002f,0.070621f,0.069332f,0.070599f,0.080737f,0.087417f,0.095981f,0.10702f,0.12116f,0.14146f,0.17546f,0.2515f,0.22461f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014122f,0.070466f,0.079449f,0.077358f,0.076265f,0.077346f,0.079424f,0.089097f,0.099575f,0.11084f,0.12555f,0.14685f,0.18296f,0.26573f,0.44064f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.039567f,0.085048f,0.086729f,0.084794f,0.084116f,0.084808f,0.086706f,0.089352f,0.099732f,0.11371f,0.13131f,0.1543f,0.19413f,0.29503f,0.64125f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0014071f,0.054512f,0.088881f,0.095409f,0.093753f,0.093007f,0.093775f,0.095393f,0.097788f,0.10212f,0.11625f,0.13365f,0.16031f,0.20963f,0.33985f,0.83276f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043373f,0.034659f,0.08163f,0.10433f,0.105f,0.104f,0.10503f,0.10693f,0.10998f,0.11445f,0.11914f,0.1396f,0.16971f,0.22252f,0.35981f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.054219f,0.098665f,0.11764f,0.11916f,0.11926f,0.1218f,0.12579f,0.13006f,0.13785f,0.14663f,0.18077f,0.25367f,0.35599f,0.77038f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012593f,0.059121f,0.10673f,0.13084f,0.13955f,0.14297f,0.14861f,0.15464f,0.1659f,0.17883f,0.19719f,0.25106f,0.3443f,0.55456f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043097f,0.037335f,0.085557f,0.12916f,0.1552f,0.17483f,0.19253f,0.21041f,0.2363f,0.24639f,0.24863f,0.32498f,0.3525f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.6987e-018f,0.014261f,0.038514f,0.058048f,0.071419f,0.11435f,0.18086f,0.23352f,0.27289f,0.30018f,0.171f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.4828e-016f}};

static float map_9point1_densepanorama_lsm[21][21] = {
   {0.94868f,0.93979f,0.92892f,0.91532f,0.89884f,0.87853f,0.8537f,0.82424f,0.78969f,0.75039f,0.70789f,0.661f,0.61351f,0.56712f,0.52077f,0.47859f,0.43917f,0.40362f,0.37114f,0.3426f,0.31623f},
   {0.95693f,0.9317f,0.92102f,0.90712f,0.89078f,0.87044f,0.84289f,0.80644f,0.76604f,0.7236f,0.6804f,0.6349f,0.58948f,0.54466f,0.5005f,0.45761f,0.41877f,0.38353f,0.35198f,0.32412f,0.29116f},
   {0.96462f,0.94132f,0.91583f,0.90277f,0.88622f,0.85514f,0.82266f,0.78517f,0.74448f,0.70104f,0.65656f,0.61f,0.56482f,0.52016f,0.47676f,0.43469f,0.3955f,0.36119f,0.33046f,0.29747f,0.26416f},
   {0.97225f,0.95137f,0.92389f,0.87318f,0.84285f,0.81544f,0.78461f,0.75832f,0.72386f,0.68186f,0.63534f,0.58672f,0.54045f,0.49615f,0.45375f,0.41386f,0.37593f,0.34027f,0.30135f,0.26734f,0.23466f},
   {0.97919f,0.96065f,0.92499f,0.82658f,0.7398f,0.71817f,0.6958f,0.68405f,0.66742f,0.64499f,0.61389f,0.56724f,0.52048f,0.47677f,0.43635f,0.3979f,0.36272f,0.31873f,0.26998f,0.23483f,0.20369f},
   {0.98542f,0.96631f,0.87015f,0.7684f,0.69483f,0.63359f,0.61998f,0.60434f,0.59091f,0.58013f,0.57013f,0.5462f,0.50188f,0.45794f,0.41794f,0.38255f,0.33991f,0.29475f,0.24755f,0.20075f,0.17085f},
   {0.99064f,0.94726f,0.80545f,0.71318f,0.65231f,0.60483f,0.55794f,0.53972f,0.52742f,0.51851f,0.51381f,0.51107f,0.48125f,0.43707f,0.39772f,0.3559f,0.31427f,0.27011f,0.22117f,0.16891f,0.13721f},
   {0.99488f,0.87774f,0.74012f,0.67115f,0.62073f,0.57635f,0.53201f,0.49411f,0.4796f,0.46866f,0.4647f,0.46761f,0.45211f,0.4102f,0.3672f,0.32497f,0.28356f,0.24085f,0.19578f,0.14463f,0.10174f},
   {0.99776f,0.78496f,0.68403f,0.62923f,0.58748f,0.55033f,0.51271f,0.47728f,0.43977f,0.42764f,0.42133f,0.42629f,0.41568f,0.36979f,0.32799f,0.28872f,0.25065f,0.21145f,0.16933f,0.12196f,0.067462f},
   {0.99947f,0.7089f,0.63301f,0.58945f,0.55517f,0.52422f,0.49282f,0.4609f,0.42766f,0.3909f,0.38302f,0.38889f,0.35964f,0.31638f,0.28082f,0.24757f,0.21469f,0.18028f,0.14225f,0.098254f,0.033277f},
   {1.000000f,0.64466f,0.58741f,0.55298f,0.52471f,0.49628f,0.46936f,0.44208f,0.41272f,0.38181f,0.34922f,0.30028f,0.27293f,0.25128f,0.22873f,0.20406f,0.1757f,0.14641f,0.11309f,0.073649f,0.000000f},
   {0.79277f,0.57573f,0.53721f,0.51131f,0.48822f,0.46492f,0.44062f,0.41416f,0.38435f,0.35155f,0.31482f,0.28029f,0.21307f,0.18725f,0.17713f,0.16064f,0.14079f,0.11665f,0.088097f,0.053513f,0.000000f},
   {0.58496f,0.50869f,0.48806f,0.47008f,0.45133f,0.43088f,0.40829f,0.3835f,0.35382f,0.31954f,0.27786f,0.23622f,0.2015f,0.14466f,0.13286f,0.12194f,0.10696f,0.087506f,0.063482f,0.033993f,0.000000f},
   {0.3831f,0.43474f,0.43604f,0.42689f,0.41288f,0.39659f,0.37692f,0.35334f,0.32115f,0.28278f,0.2393f,0.19676f,0.15715f,0.12371f,0.097767f,0.089805f,0.077988f,0.062177f,0.042135f,0.016712f,0.000000f},
   {0.18186f,0.34462f,0.37934f,0.38246f,0.37538f,0.36204f,0.34555f,0.3189f,0.28377f,0.24273f,0.19958f,0.15453f,0.11283f,0.081069f,0.0697f,0.063697f,0.055517f,0.042187f,0.024487f,0.0046307f,0.000000f},
   {0.000000f,0.25649f,0.31959f,0.33464f,0.33468f,0.32816f,0.30382f,0.27536f,0.24032f,0.19861f,0.15506f,0.10731f,0.062396f,0.038748f,0.038363f,0.044194f,0.035614f,0.02474f,0.011873f,0.00051164f,0.000000f},
   {0.000000f,0.1871f,0.24049f,0.2832f,0.2935f,0.27469f,0.2524f,0.22195f,0.18807f,0.14793f,0.099514f,0.054506f,0.021573f,0.012386f,0.017228f,0.019781f,0.021189f,0.012384f,0.0023573f,0.000000f,0.000000f},
   {0.000000f,0.13094f,0.19377f,0.2242f,0.21568f,0.19932f,0.18049f,0.15015f,0.1183f,0.08005f,0.038463f,0.011549f,0.00053156f,0.0017575f,0.0034858f,0.004216f,0.0046111f,0.0039179f,0.0005892f,0.000000f,0.000000f},
   {0.000000f,0.088435f,0.15238f,0.11227f,0.074803f,0.080771f,0.064857f,0.048933f,0.030007f,0.012387f,0.00062972f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.05808f,0.033499f,0.013912f,0.0020664f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_densepanorama_rsm[21][21] = {
   {0.31623f,0.34174f,0.37027f,0.40274f,0.43828f,0.47769f,0.52077f,0.56623f,0.61351f,0.661f,0.70632f,0.75039f,0.78969f,0.82364f,0.8537f,0.87804f,0.8984f,0.91493f,0.92858f,0.93948f,0.94868f},
   {0.29033f,0.32401f,0.35116f,0.38332f,0.41793f,0.45677f,0.49966f,0.54385f,0.5887f,0.63465f,0.68013f,0.72323f,0.76542f,0.80587f,0.84237f,0.86998f,0.89037f,0.90708f,0.92068f,0.93165f,0.95667f},
   {0.26357f,0.29714f,0.33033f,0.36043f,0.39519f,0.43391f,0.476f,0.51943f,0.56412f,0.60952f,0.65633f,0.70077f,0.74391f,0.78464f,0.82217f,0.8547f,0.8861f,0.90245f,0.91577f,0.94127f,0.96448f},
   {0.23387f,0.26656f,0.30106f,0.34015f,0.37537f,0.41319f,0.45358f,0.49568f,0.53983f,0.58627f,0.63514f,0.68158f,0.72338f,0.7582f,0.7847f,0.81515f,0.84276f,0.8729f,0.92391f,0.95113f,0.97206f},
   {0.20293f,0.23442f,0.26927f,0.31844f,0.36261f,0.3976f,0.43594f,0.47622f,0.51995f,0.56672f,0.61364f,0.64458f,0.66708f,0.68378f,0.69581f,0.71813f,0.73942f,0.8267f,0.92485f,0.96059f,0.97904f},
   {0.17012f,0.20003f,0.24691f,0.29416f,0.33947f,0.38245f,0.41757f,0.45745f,0.50162f,0.54599f,0.56988f,0.57995f,0.59073f,0.60407f,0.61997f,0.63325f,0.69486f,0.76836f,0.87016f,0.9662f,0.9853f},
   {0.13651f,0.16829f,0.22059f,0.26993f,0.31401f,0.35564f,0.39763f,0.43683f,0.48085f,0.51074f,0.51356f,0.51825f,0.52715f,0.53957f,0.55763f,0.60478f,0.65234f,0.7134f,0.80555f,0.94735f,0.99054f},
   {0.10107f,0.14409f,0.19526f,0.24062f,0.28307f,0.32452f,0.36689f,0.41011f,0.45187f,0.46736f,0.46447f,0.46842f,0.47952f,0.49382f,0.532f,0.5762f,0.62064f,0.6713f,0.74022f,0.87796f,0.99481f},
   {0.066833f,0.12148f,0.16885f,0.21098f,0.2502f,0.28838f,0.32758f,0.36957f,0.41557f,0.42607f,0.42112f,0.42741f,0.4395f,0.47717f,0.51254f,0.55036f,0.58741f,0.62925f,0.68414f,0.78527f,0.99772f},
   {0.032685f,0.097839f,0.14205f,0.18011f,0.21427f,0.24724f,0.28043f,0.31601f,0.3593f,0.38877f,0.38284f,0.39066f,0.42745f,0.46072f,0.49267f,0.52424f,0.55513f,0.58963f,0.63325f,0.70919f,0.99945f},
   {0.000000f,0.073611f,0.11305f,0.14636f,0.17565f,0.20399f,0.22866f,0.25121f,0.27286f,0.30017f,0.34904f,0.3816f,0.41249f,0.44184f,0.46912f,0.49602f,0.52444f,0.55269f,0.58706f,0.64416f,1.000000f},
   {0.000000f,0.053223f,0.087771f,0.1163f,0.14044f,0.16049f,0.17679f,0.18693f,0.21286f,0.28012f,0.31466f,0.35136f,0.38428f,0.4141f,0.4406f,0.46504f,0.48828f,0.51142f,0.53741f,0.57609f,0.79404f},
   {0.000000f,0.033762f,0.063207f,0.087205f,0.10665f,0.12181f,0.13255f,0.14446f,0.20132f,0.23611f,0.27768f,0.31951f,0.35363f,0.38352f,0.4083f,0.43103f,0.45143f,0.47022f,0.48832f,0.50907f,0.58627f},
   {0.000000f,0.016548f,0.04191f,0.061926f,0.077723f,0.089535f,0.097654f,0.12359f,0.15718f,0.19671f,0.23911f,0.2828f,0.32125f,0.35315f,0.37705f,0.39668f,0.413f,0.42708f,0.4363f,0.43519f,0.38445f},
   {0.000000f,0.0045383f,0.024315f,0.042013f,0.055294f,0.063469f,0.069663f,0.080957f,0.1128f,0.15455f,0.19937f,0.24281f,0.28387f,0.319f,0.34535f,0.36215f,0.37553f,0.38267f,0.37962f,0.34513f,0.18322f},
   {0.000000f,0.00048584f,0.011756f,0.024581f,0.035454f,0.044176f,0.038229f,0.038658f,0.062405f,0.10738f,0.15484f,0.19874f,0.24047f,0.27551f,0.30398f,0.32792f,0.33487f,0.33487f,0.31994f,0.25706f,-2.2204e-016f},
   {0.000000f,0.000000f,0.0023004f,0.012271f,0.021176f,0.019653f,0.017112f,0.01229f,0.021586f,0.054618f,0.099262f,0.14811f,0.18825f,0.22214f,0.25259f,0.27489f,0.29322f,0.28346f,0.24086f,0.1876f,0.000000f},
   {0.000000f,0.000000f,0.00056441f,0.0039128f,0.0045454f,0.0041551f,0.0034332f,0.0017195f,0.00051362f,0.011632f,0.038283f,0.080258f,0.11853f,0.15037f,0.18073f,0.19958f,0.21596f,0.22382f,0.19415f,0.13136f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062082f,0.01248f,0.030154f,0.049131f,0.065091f,0.081035f,0.075079f,0.1126f,0.15189f,0.088781f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0021284f,0.014056f,0.033725f,0.05778f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_wrap_ang[] = {-45,-26,0,26,45,-95,95,-142,142};
static float map_9point1_wrap_xsf[] = {-1,-0.5,0,0.5,1,-1,1,-1,1};
static float map_9point1_wrap_ysf[] = {1,1,1,1,1,0,0,-1,-1};
channel_id map_9point1_wrap_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_side_center_left,ci_side_center_right,ci_back_left,ci_back_right,ci_lfe};

static float map_9point1_wrap_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,9.4126e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0025743f,0.016552f,0.019339f,0.017689f,0.014677f,0.0075151f,0.0023122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.010122f,0.049892f,0.081385f,0.075976f,0.066587f,0.048878f,0.031384f,0.01438f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0022432f,0.048381f,0.094728f,0.12939f,0.14819f,0.13332f,0.11169f,0.081894f,0.049473f,0.021188f,0.0029287f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019725f,0.095227f,0.15233f,0.17345f,0.16427f,0.14754f,0.14117f,0.13145f,0.099702f,0.051668f,0.015357f,0.0004627f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.067908f,0.15539f,0.19651f,0.18146f,0.15882f,0.14116f,0.1291f,0.12511f,0.12232f,0.089211f,0.030602f,0.0029125f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13152f,0.21644f,0.20646f,0.17568f,0.15435f,0.13761f,0.1251f,0.11476f,0.11158f,0.1087f,0.0391f,0.0030968f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19821f,0.24497f,0.20143f,0.17202f,0.15152f,0.1354f,0.12233f,0.11157f,0.10201f,0.10008f,0.02634f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {8.6596e-017f,0.26351f,0.25036f,0.20151f,0.17212f,0.15022f,0.13434f,0.1215f,0.11016f,0.10014f,0.091286f,0.091196f,0.072765f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.14292f,0.32097f,0.25158f,0.20264f,0.17322f,0.15277f,0.1368f,0.12398f,0.11372f,0.10509f,0.10014f,0.10199f,0.11007f,0.089378f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.27953f,0.36201f,0.26077f,0.20891f,0.17806f,0.15683f,0.14026f,0.12809f,0.11822f,0.11157f,0.11015f,0.11158f,0.11474f,0.11478f,0.079886f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.40639f,0.40831f,0.2748f,0.2181f,0.18495f,0.16233f,0.1448f,0.133f,0.12656f,0.12233f,0.12149f,0.12232f,0.12511f,0.12639f,0.10424f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.52748f,0.47057f,0.29527f,0.22794f,0.19213f,0.16957f,0.152f,0.14356f,0.13761f,0.1354f,0.13433f,0.13538f,0.13762f,0.13549f,0.1175f,0.061535f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.63323f,0.50954f,0.31873f,0.2453f,0.20447f,0.17733f,0.16842f,0.15997f,0.15435f,0.15152f,0.15021f,0.15149f,0.1527f,0.14081f,0.11367f,0.0757f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.72837f,0.51209f,0.3683f,0.26525f,0.21826f,0.20334f,0.18984f,0.18146f,0.17568f,0.17202f,0.17211f,0.17098f,0.16098f,0.13607f,0.098801f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.81116f,0.50827f,0.36916f,0.29352f,0.264f,0.24288f,0.22433f,0.21451f,0.20646f,0.20143f,0.19609f,0.18058f,0.15329f,0.1102f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.88423f,0.49893f,0.37009f,0.36617f,0.35721f,0.311f,0.2844f,0.26253f,0.24312f,0.22219f,0.19506f,0.15866f,0.1057f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.94622f,0.48678f,0.46584f,0.43796f,0.40098f,0.35386f,0.3003f,0.25801f,0.21787f,0.17042f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_wrap_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_wrap_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_wrap_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_9point1_wrap_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0022352f,0.0073556f,0.014462f,0.017441f,0.019071f,0.016531f,0.0024671f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01419f,0.031102f,0.048526f,0.066173f,0.075526f,0.081297f,0.04946f,0.0098814f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028496f,0.021112f,0.049149f,0.081488f,0.11122f,0.13287f,0.14806f,0.12881f,0.09417f,0.047925f,0.0021311f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00043186f,0.015188f,0.051545f,0.099312f,0.1312f,0.14102f,0.14734f,0.16405f,0.17306f,0.15167f,0.094607f,0.019339f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0028379f,0.030373f,0.089057f,0.12218f,0.12498f,0.12893f,0.14102f,0.15866f,0.18126f,0.19604f,0.15464f,0.067274f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0030797f,0.038854f,0.1086f,0.11146f,0.1146f,0.12497f,0.13745f,0.1542f,0.17549f,0.20626f,0.21577f,0.13069f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.026252f,0.10001f,0.10187f,0.11145f,0.12219f,0.13525f,0.15135f,0.17183f,0.20121f,0.24456f,0.19725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.072685f,0.091096f,0.091174f,0.10001f,0.11002f,0.12134f,0.13416f,0.15002f,0.1719f,0.20125f,0.25003f,0.2633f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040435f,0.089481f,0.11f,0.10185f,0.10001f,0.10496f,0.11359f,0.12384f,0.13666f,0.15261f,0.17302f,0.20242f,0.25131f,0.32012f,0.14046f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.080064f,0.11479f,0.11458f,0.11146f,0.11002f,0.11145f,0.11808f,0.12794f,0.14009f,0.15665f,0.17785f,0.20867f,0.2605f,0.36128f,0.27711f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.10437f,0.12621f,0.12498f,0.12218f,0.12134f,0.12219f,0.12645f,0.13284f,0.14464f,0.16215f,0.18474f,0.21787f,0.27448f,0.4076f,0.40402f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.061843f,0.11735f,0.13544f,0.13747f,0.13526f,0.13417f,0.13525f,0.13745f,0.14343f,0.15182f,0.16938f,0.19191f,0.22768f,0.29494f,0.46977f,0.52519f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.075569f,0.11383f,0.14084f,0.15258f,0.15134f,0.15002f,0.15135f,0.1542f,0.15983f,0.16828f,0.17712f,0.20424f,0.24502f,0.31841f,0.50892f,0.63102f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.099066f,0.13621f,0.16098f,0.17084f,0.1719f,0.17183f,0.17549f,0.18126f,0.18968f,0.20316f,0.21799f,0.26496f,0.36789f,0.51154f,0.72626f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.11053f,0.15345f,0.18063f,0.19584f,0.20121f,0.20626f,0.21427f,0.22413f,0.24264f,0.26377f,0.29316f,0.36878f,0.50788f,0.80914f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10618f,0.15898f,0.19481f,0.22223f,0.24306f,0.26241f,0.28423f,0.31081f,0.3571f,0.36589f,0.36964f,0.49868f,0.8823f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.17097f,0.21836f,0.25849f,0.30093f,0.35437f,0.4014f,0.43825f,0.46598f,0.4862f,0.94439f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_9point1_wrap_lsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.076479f,0.1924f,0.15601f,0.11842f,0.08308f,0.051138f,0.03194f,0.02596f,0.017224f,0.006217f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15701f,0.23422f,0.26354f,0.22314f,0.18089f,0.17541f,0.15144f,0.12753f,0.099719f,0.070344f,0.038959f,0.016585f,0.0019274f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24799f,0.28578f,0.30478f,0.2999f,0.28155f,0.26062f,0.23875f,0.21148f,0.18101f,0.14288f,0.097017f,0.059361f,0.02644f,0.0055357f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34452f,0.34709f,0.3472f,0.32503f,0.29199f,0.2741f,0.2564f,0.23925f,0.21822f,0.19068f,0.15101f,0.104f,0.05812f,0.024256f,0.0054585f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44874f,0.4169f,0.38198f,0.33282f,0.28632f,0.24721f,0.23733f,0.22819f,0.21923f,0.20483f,0.17996f,0.13974f,0.08731f,0.044322f,0.015426f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55712f,0.48293f,0.39609f,0.32283f,0.2712f,0.23804f,0.21189f,0.20278f,0.19777f,0.19453f,0.18519f,0.15702f,0.11105f,0.061583f,0.025231f,0.00062925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67263f,0.51439f,0.39135f,0.31154f,0.26327f,0.22985f,0.20371f,0.18541f,0.17979f,0.1758f,0.17449f,0.15962f,0.11761f,0.06551f,0.017632f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78467f,0.52067f,0.3765f,0.30095f,0.25585f,0.2244f,0.19964f,0.1808f,0.16481f,0.16036f,0.15821f,0.15223f,0.10975f,0.041656f,0.0063155f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.52104f,0.36605f,0.29451f,0.25151f,0.22133f,0.19751f,0.17814f,0.16187f,0.14649f,0.14382f,0.13363f,0.061306f,0.014688f,1.0116e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.52679f,0.36715f,0.29551f,0.25242f,0.22029f,0.19701f,0.17818f,0.16155f,0.14686f,0.1311f,0.063705f,0.017218f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.89382f,0.52086f,0.36615f,0.29459f,0.2515f,0.22126f,0.1975f,0.17814f,0.16187f,0.14649f,0.14382f,0.13358f,0.061006f,0.014527f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.78261f,0.52026f,0.37649f,0.30094f,0.25584f,0.22432f,0.19963f,0.18084f,0.1648f,0.16036f,0.1582f,0.15211f,0.10961f,0.041389f,0.0062031f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.67046f,0.51365f,0.39123f,0.31163f,0.26325f,0.22984f,0.20363f,0.1854f,0.17974f,0.1758f,0.17448f,0.15945f,0.11735f,0.065362f,0.017508f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55485f,0.48176f,0.39574f,0.32282f,0.27127f,0.2381f,0.21189f,0.20284f,0.19777f,0.19453f,0.18513f,0.15675f,0.11066f,0.061236f,0.025146f,0.00059225f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.4464f,0.41543f,0.3814f,0.33259f,0.28621f,0.2472f,0.23726f,0.22818f,0.21922f,0.20473f,0.17984f,0.13934f,0.086884f,0.044002f,0.015305f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34213f,0.34579f,0.34627f,0.32473f,0.29192f,0.274f,0.25621f,0.23901f,0.21792f,0.19031f,0.1508f,0.10352f,0.057744f,0.024003f,0.0054168f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24558f,0.28436f,0.30393f,0.29971f,0.28098f,0.26009f,0.23836f,0.21095f,0.18045f,0.14227f,0.096837f,0.059047f,0.026151f,0.005504f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.15519f,0.23319f,0.26327f,0.22211f,0.18013f,0.17455f,0.15068f,0.12685f,0.099116f,0.06984f,0.038815f,0.016456f,0.0018503f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.074009f,0.19209f,0.15497f,0.11774f,0.082312f,0.050511f,0.031485f,0.025562f,0.016918f,0.0061903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_wrap_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0061903f,0.016918f,0.025562f,0.031485f,0.050511f,0.082312f,0.11774f,0.15497f,0.19222f,0.074014f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0018503f,0.016456f,0.038851f,0.06984f,0.099116f,0.12685f,0.15068f,0.17455f,0.18013f,0.22211f,0.26337f,0.23319f,0.15519f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.005504f,0.026151f,0.059047f,0.096892f,0.14227f,0.18045f,0.21095f,0.23853f,0.26009f,0.28098f,0.29979f,0.30393f,0.28436f,0.24556f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0054168f,0.024003f,0.057744f,0.10352f,0.15084f,0.19031f,0.21792f,0.23901f,0.25621f,0.274f,0.29198f,0.32473f,0.34627f,0.34579f,0.34213f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.015305f,0.044002f,0.086884f,0.13934f,0.17988f,0.20473f,0.21922f,0.22818f,0.23733f,0.24725f,0.28627f,0.33259f,0.3814f,0.41543f,0.4464f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00059225f,0.025157f,0.061236f,0.11066f,0.15675f,0.18518f,0.19453f,0.19777f,0.20284f,0.21193f,0.2381f,0.27127f,0.32308f,0.39574f,0.48176f,0.55485f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017508f,0.065396f,0.11735f,0.15945f,0.17454f,0.1758f,0.1798f,0.18544f,0.20369f,0.22984f,0.26325f,0.31163f,0.39123f,0.51365f,0.67046f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0062031f,0.041389f,0.10962f,0.15211f,0.15825f,0.16036f,0.16483f,0.18084f,0.19963f,0.22439f,0.25584f,0.30094f,0.37649f,0.52026f,0.78261f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014527f,0.061006f,0.13359f,0.14386f,0.14652f,0.16187f,0.17814f,0.1975f,0.22132f,0.2515f,0.29459f,0.36615f,0.52086f,0.89382f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-4.0817e-019f,0.017202f,0.06369f,0.13113f,0.14689f,0.16158f,0.17821f,0.19705f,0.22033f,0.25247f,0.29557f,0.36722f,0.52689f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.0116e-005f,0.014688f,0.061306f,0.13361f,0.14385f,0.14651f,0.16187f,0.17814f,0.19751f,0.22133f,0.25151f,0.2946f,0.36616f,0.52104f,0.89574f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0063155f,0.041656f,0.10967f,0.15223f,0.15823f,0.16036f,0.16482f,0.18085f,0.19964f,0.2244f,0.25585f,0.30095f,0.3765f,0.52067f,0.78467f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017695f,0.065451f,0.11767f,0.15962f,0.17452f,0.1758f,0.17979f,0.18543f,0.20371f,0.22985f,0.26327f,0.31164f,0.39135f,0.51439f,0.67263f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062925f,0.0252f,0.061583f,0.11105f,0.15702f,0.18518f,0.19453f,0.19777f,0.20284f,0.21192f,0.23812f,0.27128f,0.32312f,0.39609f,0.48293f,0.55712f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019397f,0.0155f,0.044322f,0.08731f,0.13974f,0.17992f,0.2049f,0.2193f,0.22819f,0.23733f,0.24724f,0.28632f,0.33282f,0.38198f,0.4169f,0.44874f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0055425f,0.024256f,0.05812f,0.104f,0.15089f,0.19068f,0.21822f,0.23925f,0.2564f,0.27419f,0.292f,0.32517f,0.3472f,0.34732f,0.34452f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0056317f,0.02644f,0.059451f,0.09695f,0.14288f,0.18101f,0.21148f,0.23904f,0.26062f,0.28155f,0.29985f,0.30497f,0.28578f,0.24801f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019274f,0.016697f,0.038906f,0.070344f,0.099719f,0.12753f,0.15144f,0.17541f,0.18105f,0.22314f,0.26347f,0.23448f,0.15764f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.2068e-018f,0.0063777f,0.017224f,0.02596f,0.03194f,0.051138f,0.08308f,0.11865f,0.15601f,0.19233f,0.076473f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f}};

static float map_9point1_wrap_ls[21][21] = {
   {1.000000f,0.99863f,0.99396f,0.98481f,0.9703f,0.94888f,0.91914f,0.88048f,0.83195f,0.77384f,0.70834f,0.63338f,0.55484f,0.47562f,0.39394f,0.3173f,0.24362f,0.17537f,0.11147f,0.054079f,-7.8496e-017f},
   {0.94446f,0.81199f,0.83616f,0.85669f,0.87092f,0.87561f,0.8564f,0.80823f,0.75425f,0.69808f,0.63602f,0.56664f,0.49969f,0.43164f,0.36121f,0.29703f,0.24559f,0.20208f,0.16581f,0.13592f,0.000000f},
   {0.88271f,0.78057f,0.71294f,0.73952f,0.76209f,0.72118f,0.69661f,0.66179f,0.62498f,0.59208f,0.56394f,0.52736f,0.48539f,0.43211f,0.3753f,0.31848f,0.25563f,0.21817f,0.18628f,0.11031f,0.000000f},
   {0.80907f,0.73849f,0.68142f,0.62971f,0.60765f,0.58509f,0.55402f,0.53219f,0.51188f,0.49896f,0.49292f,0.47704f,0.45666f,0.42472f,0.38061f,0.33006f,0.27965f,0.22857f,0.15778f,0.083896f,0.000000f},
   {0.72626f,0.68381f,0.64457f,0.57657f,0.51706f,0.49372f,0.46596f,0.45043f,0.43577f,0.42627f,0.42558f,0.42408f,0.4189f,0.4019f,0.37301f,0.33185f,0.28785f,0.21842f,0.12802f,0.058746f,0.000000f},
   {0.63102f,0.61653f,0.57478f,0.53382f,0.48514f,0.42718f,0.41011f,0.39421f,0.38285f,0.37543f,0.37141f,0.37424f,0.37886f,0.37291f,0.35447f,0.32571f,0.2697f,0.20197f,0.12403f,0.03616f,0.000000f},
   {0.52519f,0.53691f,0.52315f,0.49422f,0.4552f,0.40947f,0.36615f,0.35043f,0.34158f,0.3356f,0.33216f,0.33419f,0.33895f,0.34131f,0.33172f,0.30203f,0.24789f,0.18361f,0.10709f,0.022585f,0.000000f},
   {0.40402f,0.46214f,0.47464f,0.46087f,0.43328f,0.39304f,0.3499f,0.32038f,0.31064f,0.30342f,0.30041f,0.30177f,0.30761f,0.31375f,0.30955f,0.27305f,0.21805f,0.15706f,0.090176f,0.018356f,0.000000f},
   {0.27711f,0.39741f,0.42859f,0.42667f,0.40895f,0.37927f,0.34025f,0.30982f,0.28478f,0.27695f,0.27237f,0.27482f,0.28125f,0.29675f,0.28023f,0.23683f,0.18569f,0.13031f,0.070512f,0.012179f,0.000000f},
   {0.14292f,0.33339f,0.38221f,0.39113f,0.38299f,0.36377f,0.33348f,0.30176f,0.27588f,0.25314f,0.24761f,0.25f,0.2723f,0.2674f,0.23727f,0.19424f,0.14921f,0.10103f,0.049741f,0.0045097f,0.000000f},
   {0.000000f,0.26327f,0.33172f,0.35247f,0.35385f,0.34292f,0.32385f,0.29788f,0.27007f,0.24552f,0.22579f,0.23659f,0.23272f,0.21252f,0.18253f,0.14834f,0.1086f,0.068513f,0.027472f,-8.5322e-019f,0.000000f},
   {0.000000f,0.19725f,0.27965f,0.31034f,0.31939f,0.31618f,0.30536f,0.28855f,0.26792f,0.24094f,0.1799f,0.14699f,0.14674f,0.14347f,0.12638f,0.10174f,0.073541f,0.042039f,0.011806f,0.000000f,0.000000f},
   {0.000000f,0.13069f,0.21975f,0.26195f,0.27862f,0.28151f,0.27602f,0.26277f,0.24232f,0.202f,0.13299f,0.082204f,0.083689f,0.086082f,0.07899f,0.061737f,0.041097f,0.018696f,0.0013628f,0.000000f,0.000000f},
   {0.000000f,0.067274f,0.15464f,0.20782f,0.23238f,0.24129f,0.24043f,0.22893f,0.19873f,0.15312f,0.089072f,0.040759f,0.032293f,0.046248f,0.043546f,0.03134f,0.017152f,0.0039822f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.019339f,0.094607f,0.15196f,0.18465f,0.19667f,0.19966f,0.1783f,0.14444f,0.099312f,0.051555f,0.015195f,0.0048976f,0.012512f,0.017789f,0.01096f,0.0039191f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0021311f,0.047925f,0.09417f,0.12885f,0.15216f,0.13421f,0.11122f,0.081488f,0.049149f,0.021112f,0.0028496f,0.000000f,0.000000f,0.00044495f,0.0013625f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0098814f,0.04946f,0.081296f,0.075526f,0.066173f,0.048526f,0.031102f,0.01419f,0.0019269f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0024671f,0.016531f,0.019071f,0.017441f,0.014677f,0.0073556f,0.0022352f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_9point1_wrap_rs[21][21] = {
   {-7.8496e-017f,0.052336f,0.10973f,0.17365f,0.24192f,0.31565f,0.39394f,0.47409f,0.55484f,0.63338f,0.70587f,0.77384f,0.83195f,0.87965f,0.91914f,0.94832f,0.96987f,0.9845f,0.99377f,0.99854f,1.000000f},
   {0.000000f,0.13583f,0.16489f,0.20208f,0.24451f,0.29589f,0.35999f,0.43048f,0.49857f,0.56633f,0.63558f,0.69745f,0.75361f,0.80779f,0.85613f,0.8756f,0.87113f,0.85731f,0.83679f,0.81212f,0.94629f},
   {0.000000f,0.11031f,0.18615f,0.21738f,0.25552f,0.31761f,0.37444f,0.43128f,0.48466f,0.52692f,0.56374f,0.59228f,0.62473f,0.66167f,0.69668f,0.72145f,0.76272f,0.7402f,0.71303f,0.78158f,0.88423f},
   {0.000000f,0.083257f,0.15778f,0.22845f,0.27908f,0.32934f,0.38061f,0.42428f,0.45626f,0.4769f,0.4928f,0.49938f,0.51188f,0.53264f,0.55439f,0.58524f,0.6082f,0.62975f,0.68239f,0.7397f,0.8111f},
   {0.000000f,0.058746f,0.12737f,0.2183f,0.28772f,0.33167f,0.37263f,0.40155f,0.4187f,0.42403f,0.42555f,0.42626f,0.43576f,0.45043f,0.46637f,0.49385f,0.51702f,0.57711f,0.64546f,0.68515f,0.72837f},
   {0.000000f,0.035717f,0.12342f,0.20135f,0.26927f,0.3256f,0.35421f,0.3727f,0.37913f,0.37456f,0.37139f,0.37551f,0.38293f,0.39422f,0.41047f,0.42708f,0.48557f,0.53421f,0.57553f,0.61802f,0.63323f},
   {0.000000f,0.022264f,0.10655f,0.18361f,0.24774f,0.30191f,0.3317f,0.3415f,0.33894f,0.33418f,0.33214f,0.33559f,0.34157f,0.3505f,0.36607f,0.40957f,0.45546f,0.49461f,0.52386f,0.53833f,0.52748f},
   {0.000000f,0.018075f,0.089694f,0.15698f,0.21753f,0.27257f,0.30936f,0.31378f,0.30767f,0.30176f,0.30039f,0.30342f,0.31091f,0.32031f,0.3502f,0.39305f,0.43346f,0.46137f,0.47532f,0.46338f,0.40639f},
   {0.000000f,0.011962f,0.070085f,0.12983f,0.1852f,0.2365f,0.2799f,0.29688f,0.28132f,0.27481f,0.27235f,0.27695f,0.28472f,0.3099f,0.34026f,0.3796f,0.40917f,0.42708f,0.42927f,0.39855f,0.27953f},
   {0.000000f,0.0043772f,0.049741f,0.10103f,0.14876f,0.19392f,0.23686f,0.26716f,0.27225f,0.25006f,0.24759f,0.25308f,0.27589f,0.30177f,0.33349f,0.36411f,0.38326f,0.39169f,0.38291f,0.3345f,0.14292f},
   {0.000000f,-8.5322e-019f,0.027447f,0.068465f,0.10853f,0.14825f,0.18244f,0.21244f,0.23269f,0.23658f,0.22577f,0.24545f,0.27f,0.29779f,0.3238f,0.34289f,0.35387f,0.35252f,0.3318f,0.26339f,-8.6596e-017f},
   {0.000000f,0.000000f,0.011636f,0.041753f,0.073199f,0.1017f,0.12602f,0.14312f,0.14641f,0.14698f,0.17992f,0.24091f,0.268f,0.28867f,0.30555f,0.31654f,0.31978f,0.31088f,0.28038f,0.19821f,0.000000f},
   {0.000000f,0.000000f,0.0013084f,0.018492f,0.040831f,0.061737f,0.07868f,0.085813f,0.08366f,0.082238f,0.13301f,0.20226f,0.24232f,0.26304f,0.2763f,0.28192f,0.27908f,0.26255f,0.22053f,0.13152f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0038919f,0.016973f,0.031114f,0.043546f,0.046224f,0.032368f,0.040874f,0.089105f,0.15348f,0.19907f,0.22896f,0.24081f,0.24172f,0.2329f,0.20846f,0.15539f,0.067908f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.010822f,0.017781f,0.01238f,0.0048489f,0.015357f,0.051582f,0.099723f,0.14485f,0.17871f,0.1997f,0.19715f,0.18521f,0.15233f,0.095227f,0.019725f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013625f,0.00044495f,0.000000f,0.000000f,0.0029287f,0.021123f,0.049473f,0.081894f,0.11169f,0.13466f,0.15222f,0.12939f,0.094728f,0.048381f,0.0022432f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0019269f,0.01438f,0.031384f,0.048878f,0.066587f,0.075976f,0.081342f,0.049892f,0.010122f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0023122f,0.0075151f,0.014677f,0.017689f,0.019339f,0.016553f,0.0025743f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.4126e-019f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_ang[] = {-45,-26,0,26,45,-63,63,-90,90,-116,116};
static float map_11point1_densewrap_xsf[] = {-1,-0.5,0,0.5,1,-1,1,-1,1,-1,1};
static float map_11point1_densewrap_ysf[] = {1,1,1,1,1,0.5,0.5,0,0,-0.5,-0.5};
channel_id map_11point1_densewrap_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_side_front_left,ci_side_front_right,ci_side_center_left,ci_side_center_right,ci_side_back_left,ci_side_back_right,ci_lfe};

static float map_11point1_densewrap_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.005581f,0.003291f,1.7252e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0081504f,0.042808f,0.072882f,0.060953f,0.042164f,0.017887f,0.0013668f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0027588f,0.054743f,0.091228f,0.091909f,0.082995f,0.079348f,0.071132f,0.040421f,0.0039453f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.040396f,0.10257f,0.10193f,0.089276f,0.079333f,0.072621f,0.070291f,0.068709f,0.03606f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0060181f,0.10346f,0.11606f,0.098677f,0.086748f,0.077297f,0.070277f,0.064552f,0.062673f,0.06051f,0.0017892f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.047382f,0.13537f,0.11322f,0.096621f,0.085123f,0.076125f,0.068709f,0.062673f,0.057379f,0.05627f,0.000000f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10632f,0.1408f,0.11333f,0.0968f,0.08448f,0.075551f,0.068329f,0.061952f,0.05632f,0.051341f,0.056303f,0.060536f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.16195f,0.14064f,0.1132f,0.096622f,0.085107f,0.076104f,0.068709f,0.062673f,0.060449f,0.05632f,0.057346f,0.062673f,0.068709f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.194f,0.14507f,0.11609f,0.098677f,0.086764f,0.077297f,0.071771f,0.068005f,0.062673f,0.061952f,0.062673f,0.064514f,0.070277f,0.071028f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.22178f,0.15206f,0.12055f,0.10193f,0.090467f,0.081765f,0.076506f,0.071744f,0.068709f,0.068329f,0.068709f,0.070291f,0.072578f,0.079333f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25576f,0.16273f,0.12661f,0.10766f,0.096098f,0.087435f,0.081735f,0.077297f,0.076125f,0.075551f,0.076104f,0.077297f,0.079348f,0.082947f,0.06067f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {3.1398e-016f,0.28205f,0.17804f,0.13801f,0.11623f,0.10201f,0.096063f,0.090425f,0.086748f,0.085123f,0.08448f,0.085107f,0.086764f,0.089301f,0.091873f,0.072927f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24261f,0.28709f,0.20797f,0.15099f,0.12555f,0.11619f,0.10762f,0.10193f,0.098677f,0.096621f,0.0968f,0.096622f,0.098677f,0.10193f,0.091044f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.46196f,0.29071f,0.21045f,0.16884f,0.15094f,0.13799f,0.12656f,0.12057f,0.11606f,0.11322f,0.11333f,0.1132f,0.11609f,0.10231f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.66287f,0.29364f,0.21289f,0.21045f,0.20789f,0.17806f,0.16273f,0.15206f,0.14511f,0.14066f,0.1408f,0.1352f,0.10303f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.8397f,0.29675f,0.29354f,0.29061f,0.28698f,0.28196f,0.25543f,0.22155f,0.19371f,0.16153f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_11point1_densewrap_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031891f,0.0054514f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013174f,0.017687f,0.041859f,0.06067f,0.072899f,0.042466f,0.0079947f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003925f,0.040182f,0.071028f,0.079333f,0.082923f,0.091873f,0.091044f,0.054336f,0.0026644f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.036005f,0.068709f,0.070277f,0.072557f,0.079348f,0.089301f,0.10193f,0.10231f,0.040017f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017407f,0.060499f,0.062673f,0.064496f,0.070291f,0.077297f,0.086764f,0.098677f,0.11609f,0.10303f,0.005855f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.000000f,0.056286f,0.057329f,0.062673f,0.068709f,0.076104f,0.085107f,0.096622f,0.1132f,0.1352f,0.046879f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.06051f,0.056286f,0.051311f,0.056286f,0.061915f,0.068289f,0.075506f,0.08443f,0.096742f,0.11326f,0.14072f,0.10645f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040421f,0.068709f,0.062673f,0.057312f,0.056287f,0.060432f,0.062673f,0.068709f,0.076125f,0.085123f,0.096621f,0.11322f,0.14066f,0.16153f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.071132f,0.070291f,0.064476f,0.062673f,0.061916f,0.062673f,0.067986f,0.071744f,0.077297f,0.086748f,0.098677f,0.11606f,0.14511f,0.19371f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.079348f,0.072536f,0.070277f,0.068709f,0.068289f,0.068709f,0.071771f,0.076484f,0.081735f,0.090425f,0.10193f,0.12057f,0.15206f,0.22155f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.060953f,0.082898f,0.079333f,0.077297f,0.076125f,0.075507f,0.076104f,0.077297f,0.081765f,0.087411f,0.096063f,0.10762f,0.12656f,0.16273f,0.25543f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.072826f,0.091909f,0.089276f,0.086748f,0.085123f,0.08443f,0.085107f,0.086764f,0.090467f,0.096098f,0.10198f,0.11619f,0.13799f,0.17806f,0.28196f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.091228f,0.10193f,0.098677f,0.096621f,0.096743f,0.096622f,0.098677f,0.10193f,0.10766f,0.11623f,0.12551f,0.15094f,0.20789f,0.28698f,0.23903f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.10257f,0.11606f,0.11322f,0.11326f,0.1132f,0.11609f,0.12055f,0.12661f,0.13801f,0.15099f,0.16879f,0.21045f,0.29061f,0.4584f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10346f,0.13537f,0.14072f,0.14064f,0.14507f,0.15206f,0.16273f,0.17804f,0.20797f,0.21045f,0.21283f,0.29354f,0.65936f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.16195f,0.194f,0.22178f,0.25576f,0.28205f,0.28709f,0.29071f,0.29364f,0.29667f,0.83624f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_11point1_densewrap_lsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,1.4883e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040704f,0.026172f,0.030577f,0.027969f,0.023206f,0.011882f,0.003656f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016004f,0.078886f,0.11885f,0.11126f,0.10005f,0.077277f,0.049623f,0.022737f,0.0030466f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0035468f,0.076496f,0.13684f,0.13679f,0.11897f,0.11432f,0.10984f,0.10114f,0.076046f,0.033501f,0.0046306f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.031188f,0.14617f,0.15418f,0.1299f,0.11431f,0.10197f,0.097664f,0.095287f,0.093649f,0.075427f,0.024282f,0.00073159f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10737f,0.1817f,0.1484f,0.12564f,0.10986f,0.097669f,0.089224f,0.086605f,0.08469f,0.083965f,0.048387f,0.004605f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19838f,0.17849f,0.14282f,0.12164f,0.1068f,0.095276f,0.0866f,0.07931f,0.077259f,0.076129f,0.058978f,0.0048965f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23832f,0.17313f,0.13935f,0.11911f,0.10488f,0.093632f,0.084699f,0.077251f,0.070498f,0.069208f,0.041647f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.3692e-016f,0.24833f,0.17308f,0.13931f,0.11899f,0.10385f,0.092873f,0.083996f,0.076156f,0.069233f,0.063102f,0.05511f,0.019286f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.22597f,0.25121f,0.17526f,0.1413f,0.12102f,0.1069f,0.095882f,0.087318f,0.080638f,0.070515f,0.069221f,0.070532f,0.07488f,0.032609f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44198f,0.26542f,0.18277f,0.14664f,0.1254f,0.11069f,0.099453f,0.088959f,0.07933f,0.077251f,0.076144f,0.077259f,0.079348f,0.070283f,0.013958f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.64256f,0.2947f,0.1939f,0.15413f,0.13115f,0.11353f,0.099577f,0.089246f,0.0866f,0.084699f,0.083982f,0.08469f,0.086605f,0.085004f,0.039295f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83403f,0.33937f,0.20938f,0.16007f,0.13344f,0.11606f,0.102f,0.097669f,0.095276f,0.093632f,0.092858f,0.093649f,0.095287f,0.088683f,0.054552f,0.0013532f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.35937f,0.22225f,0.16947f,0.13938f,0.11899f,0.11431f,0.10986f,0.1068f,0.10488f,0.10383f,0.10487f,0.10415f,0.081353f,0.034375f,0.0043588f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.7669f,0.35542f,0.25327f,0.18049f,0.14646f,0.13768f,0.1299f,0.12564f,0.12164f,0.11911f,0.11897f,0.11747f,0.098408f,0.05387f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55102f,0.34365f,0.25072f,0.19696f,0.17861f,0.1657f,0.15445f,0.1484f,0.14282f,0.13935f,0.13074f,0.10642f,0.058689f,0.012407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34893f,0.32425f,0.24834f,0.24599f,0.23588f,0.21001f,0.1922f,0.1745f,0.1548f,0.12874f,0.085642f,0.036985f,0.0041976f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.16741f,0.30017f,0.27214f,0.23269f,0.17995f,0.11341f,0.070758f,0.057469f,0.038068f,0.013988f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_rsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0036134f,0.011794f,0.023088f,0.027832f,0.030429f,0.026399f,0.0040112f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031126f,0.022632f,0.049467f,0.077089f,0.099949f,0.11118f,0.11911f,0.078648f,0.015871f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045869f,0.033596f,0.075931f,0.10117f,0.10998f,0.11448f,0.11916f,0.13692f,0.13673f,0.076245f,0.0034849f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00071455f,0.024189f,0.075553f,0.093753f,0.095409f,0.097805f,0.10214f,0.11445f,0.13006f,0.15434f,0.14595f,0.030939f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045638f,0.04826f,0.084116f,0.084794f,0.086729f,0.089374f,0.097788f,0.10998f,0.12579f,0.14861f,0.18178f,0.10702f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0049397f,0.058905f,0.076265f,0.077358f,0.079443f,0.086706f,0.095393f,0.10693f,0.1218f,0.14297f,0.17876f,0.19813f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041705f,0.069332f,0.070616f,0.077346f,0.084808f,0.093775f,0.10503f,0.11926f,0.13955f,0.17338f,0.23845f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.128e-019f,0.019251f,0.055118f,0.063203f,0.069332f,0.076265f,0.084116f,0.093006f,0.104f,0.11916f,0.13951f,0.17333f,0.24869f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,2.262e-005f,0.032844f,0.075002f,0.070621f,0.069332f,0.070599f,0.080737f,0.087417f,0.095981f,0.10702f,0.12116f,0.14146f,0.17546f,0.2515f,0.22461f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014122f,0.070466f,0.079449f,0.077358f,0.076265f,0.077346f,0.079424f,0.089097f,0.099575f,0.11084f,0.12555f,0.14685f,0.18296f,0.26573f,0.44064f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.039567f,0.085048f,0.086729f,0.084794f,0.084116f,0.084808f,0.086706f,0.089352f,0.099732f,0.11371f,0.13131f,0.1543f,0.19413f,0.29503f,0.64125f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0014071f,0.054512f,0.088881f,0.095409f,0.093753f,0.093007f,0.093775f,0.095393f,0.097788f,0.10212f,0.11625f,0.13365f,0.16031f,0.20963f,0.33985f,0.83276f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043373f,0.034659f,0.08163f,0.10433f,0.105f,0.104f,0.10503f,0.10693f,0.10998f,0.11445f,0.11914f,0.1396f,0.16971f,0.22252f,0.35981f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.054219f,0.098665f,0.11764f,0.11916f,0.11926f,0.1218f,0.12579f,0.13006f,0.13785f,0.14663f,0.18077f,0.25367f,0.35599f,0.77038f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012593f,0.059121f,0.10673f,0.13084f,0.13955f,0.14297f,0.14861f,0.15464f,0.1659f,0.17883f,0.19719f,0.25106f,0.3443f,0.55456f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043097f,0.037335f,0.085557f,0.12916f,0.1552f,0.17483f,0.19253f,0.21041f,0.2363f,0.24639f,0.24863f,0.32498f,0.3525f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.6987e-018f,0.014261f,0.038514f,0.058048f,0.071419f,0.11435f,0.18086f,0.23352f,0.27289f,0.30018f,0.171f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.4828e-016f}};

static float map_11point1_densewrap_lsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.057837f,0.033725f,0.014056f,0.0021284f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.088781f,0.15197f,0.1126f,0.075079f,0.081035f,0.065091f,0.049131f,0.030154f,0.01248f,0.00065038f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13136f,0.19047f,0.19972f,0.18761f,0.17365f,0.15926f,0.13948f,0.11522f,0.080258f,0.038352f,0.011632f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.1876f,0.22622f,0.20877f,0.17308f,0.16259f,0.15331f,0.14824f,0.14136f,0.12698f,0.096228f,0.051224f,0.013903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25386f,0.24792f,0.19549f,0.16259f,0.14063f,0.13492f,0.12979f,0.12612f,0.12377f,0.11836f,0.09054f,0.040513f,0.0077516f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.18322f,0.31647f,0.23665f,0.18234f,0.15331f,0.13491f,0.12054f,0.11534f,0.11241f,0.11063f,0.10978f,0.10408f,0.067907f,0.021737f,0.00081869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.38445f,0.33396f,0.22305f,0.17613f,0.14823f,0.12977f,0.11534f,0.10547f,0.10221f,0.099919f,0.099291f,0.099924f,0.076689f,0.027385f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.58627f,0.31272f,0.21469f,0.17128f,0.14518f,0.12698f,0.11241f,0.1022f,0.093751f,0.091147f,0.090023f,0.091143f,0.07194f,0.010076f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.79404f,0.30169f,0.2101f,0.16888f,0.14394f,0.12647f,0.11263f,0.10109f,0.091143f,0.083334f,0.081839f,0.083344f,0.027665f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.30431f,0.2121f,0.17071f,0.14582f,0.12726f,0.11381f,0.10293f,0.093322f,0.084838f,0.074566f,0.014386f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.79277f,0.30166f,0.21008f,0.16887f,0.14393f,0.12645f,0.11261f,0.10108f,0.091147f,0.083312f,0.081796f,0.083334f,0.02757f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.58496f,0.31272f,0.21465f,0.17129f,0.14517f,0.12697f,0.11241f,0.10221f,0.093725f,0.091143f,0.089976f,0.091147f,0.071938f,0.010015f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3831f,0.33384f,0.22305f,0.17611f,0.14824f,0.12979f,0.11534f,0.10544f,0.1022f,0.099924f,0.099238f,0.099919f,0.076598f,0.027407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.18186f,0.31619f,0.23666f,0.18235f,0.15331f,0.13492f,0.1205f,0.11534f,0.11241f,0.11064f,0.10973f,0.10402f,0.06778f,0.021645f,0.00081784f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25335f,0.24781f,0.1955f,0.16259f,0.14059f,0.13491f,0.12977f,0.12612f,0.12378f,0.11834f,0.090417f,0.040382f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.1871f,0.22597f,0.20873f,0.17303f,0.16259f,0.15331f,0.14823f,0.14133f,0.12691f,0.096247f,0.051065f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13094f,0.19014f,0.19982f,0.18747f,0.17352f,0.15913f,0.13934f,0.11502f,0.08005f,0.038463f,0.011549f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.088435f,0.15238f,0.11227f,0.074803f,0.080771f,0.064857f,0.048933f,0.030007f,0.012387f,0.00062972f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.05808f,0.033499f,0.013912f,0.0020664f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0020664f,0.013912f,0.033499f,0.058195f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062972f,0.012387f,0.030007f,0.048933f,0.064857f,0.080771f,0.074803f,0.11227f,0.15246f,0.088435f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.011549f,0.038509f,0.08005f,0.11502f,0.13934f,0.15913f,0.17352f,0.18747f,0.19989f,0.19014f,0.13094f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013816f,0.051065f,0.096286f,0.12691f,0.14133f,0.14823f,0.15331f,0.16259f,0.17308f,0.20873f,0.22597f,0.1871f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0076928f,0.040382f,0.090417f,0.11837f,0.12378f,0.12612f,0.12977f,0.13491f,0.14063f,0.16259f,0.1955f,0.24781f,0.25335f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00081784f,0.021645f,0.06778f,0.10402f,0.10977f,0.11064f,0.11241f,0.11534f,0.12054f,0.13492f,0.15331f,0.18235f,0.23666f,0.31619f,0.18186f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027451f,0.076598f,0.099919f,0.099281f,0.099924f,0.1022f,0.10547f,0.11534f,0.12979f,0.14824f,0.17611f,0.22305f,0.33384f,0.3831f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010015f,0.071952f,0.091147f,0.090014f,0.091143f,0.093752f,0.10221f,0.11241f,0.12697f,0.14517f,0.17129f,0.21465f,0.31272f,0.58496f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.02757f,0.083335f,0.081831f,0.083335f,0.091147f,0.10108f,0.11261f,0.12645f,0.14393f,0.16887f,0.21008f,0.30166f,0.79277f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014385f,0.074587f,0.084862f,0.093348f,0.10296f,0.11384f,0.12729f,0.14586f,0.17076f,0.21215f,0.30439f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027665f,0.083335f,0.08182f,0.083335f,0.091143f,0.10109f,0.11263f,0.12647f,0.14394f,0.16888f,0.2101f,0.30169f,0.79404f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010076f,0.071837f,0.091143f,0.090002f,0.091147f,0.093752f,0.1022f,0.11241f,0.12698f,0.14518f,0.17128f,0.21469f,0.31272f,0.58627f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027311f,0.076689f,0.099924f,0.099267f,0.099919f,0.10221f,0.10547f,0.11534f,0.12977f,0.14823f,0.17613f,0.22305f,0.33396f,0.38445f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080127f,0.021737f,0.067907f,0.10408f,0.10976f,0.11063f,0.11241f,0.11534f,0.12054f,0.13491f,0.15331f,0.18234f,0.23665f,0.31647f,0.18322f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0077516f,0.040513f,0.09054f,0.11831f,0.12377f,0.12612f,0.12979f,0.13492f,0.14063f,0.16259f,0.19549f,0.24792f,0.25386f,-2.2204e-016f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.22e-018f,0.013903f,0.051224f,0.096055f,0.12698f,0.14136f,0.14824f,0.15331f,0.16259f,0.17308f,0.20877f,0.22622f,0.1876f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.011632f,0.038283f,0.080258f,0.11522f,0.13948f,0.15926f,0.17365f,0.18761f,0.19965f,0.19047f,0.13136f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062082f,0.01248f,0.030154f,0.049131f,0.065091f,0.081035f,0.075079f,0.1126f,0.15189f,0.088781f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0021284f,0.014056f,0.033725f,0.05778f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_lsb[21][21] = {
   {1.1859f,1.2049f,1.2221f,1.2365f,1.2463f,1.25f,1.2457f,1.2315f,1.2059f,1.168f,1.119f,1.0566f,0.98636f,0.91121f,0.82991f,0.75053f,0.67162f,0.59645f,0.52432f,0.45813f,0.39456f},
   {1.1627f,1.0921f,1.1253f,1.1542f,1.1748f,1.184f,1.1757f,1.143f,1.101f,1.0549f,1.0052f,0.94385f,0.88061f,0.81643f,0.74864f,0.66953f,0.59013f,0.5199f,0.45894f,0.40675f,0.33195f},
   {1.1345f,1.0508f,0.98171f,1.025f,1.0641f,1.0338f,1.0225f,0.99916f,0.97056f,0.93339f,0.89139f,0.83635f,0.78469f,0.73009f,0.67212f,0.61005f,0.54532f,0.48947f,0.44032f,0.35834f,0.26202f},
   {1.0991f,0.99539f,0.93363f,0.88673f,0.87596f,0.86582f,0.84603f,0.83303f,0.80854f,0.78862f,0.77938f,0.75481f,0.72284f,0.68f,0.63167f,0.5811f,0.52714f,0.47047f,0.39384f,0.30564f,0.18259f},
   {1.055f,0.92369f,0.87871f,0.81546f,0.76376f,0.75115f,0.72949f,0.71102f,0.68821f,0.67365f,0.67301f,0.67115f,0.66327f,0.63663f,0.59709f,0.55413f,0.50889f,0.44178f,0.34334f,0.25134f,0.095899f},
   {1.000000f,0.83591f,0.78647f,0.75537f,0.71687f,0.66409f,0.6465f,0.62204f,0.60461f,0.59334f,0.58736f,0.59237f,0.60009f,0.59098f,0.56249f,0.52623f,0.47673f,0.40808f,0.31875f,0.19708f,0.000000f},
   {0.83276f,0.73136f,0.71535f,0.69879f,0.67128f,0.6337f,0.57729f,0.55287f,0.53919f,0.53022f,0.52528f,0.52905f,0.53707f,0.54111f,0.52612f,0.49125f,0.44046f,0.37302f,0.28147f,0.15452f,0.000000f},
   {0.64125f,0.62972f,0.64726f,0.6474f,0.63283f,0.60244f,0.55242f,0.50512f,0.49012f,0.4792f,0.47507f,0.47793f,0.48774f,0.49764f,0.49034f,0.45063f,0.39696f,0.32989f,0.24613f,0.13109f,0.000000f},
   {0.44064f,0.54301f,0.58208f,0.59439f,0.58983f,0.57111f,0.53563f,0.4895f,0.449f,0.43718f,0.43073f,0.43546f,0.44615f,0.46976f,0.44537f,0.40308f,0.35042f,0.28649f,0.20741f,0.10548f,0.000000f},
   {0.22461f,0.46059f,0.5171f,0.53939f,0.54356f,0.53498f,0.51318f,0.47728f,0.4363f,0.39911f,0.39157f,0.39658f,0.43062f,0.42265f,0.3891f,0.3474f,0.29803f,0.23913f,0.16635f,0.07466f,0.000000f},
   {0.000000f,0.37491f,0.44793f,0.48022f,0.49255f,0.49144f,0.47954f,0.45833f,0.42655f,0.38828f,0.35707f,0.37405f,0.36841f,0.34862f,0.3211f,0.28535f,0.23875f,0.1856f,0.12032f,0.041971f,0.000000f},
   {0.000000f,0.29404f,0.37997f,0.41974f,0.43776f,0.44156f,0.4356f,0.42009f,0.39508f,0.3512f,0.28456f,0.26238f,0.26053f,0.26295f,0.24712f,0.21941f,0.18369f,0.13776f,0.081442f,0.018729f,0.000000f},
   {0.000000f,0.20513f,0.30628f,0.35399f,0.37726f,0.38516f,0.38253f,0.3674f,0.33923f,0.2768f,0.21042f,0.17293f,0.17637f,0.18429f,0.17894f,0.15782f,0.12851f,0.090137f,0.044099f,0.0023788f,0.000000f},
   {0.000000f,0.10702f,0.22934f,0.28548f,0.31406f,0.32616f,0.32695f,0.31229f,0.26914f,0.20707f,0.14104f,0.10001f,0.09644f,0.12292f,0.1223f,0.10514f,0.080892f,0.049952f,0.015968f,0.000000f,0.000000f},
   {0.000000f,0.030939f,0.14915f,0.21889f,0.25331f,0.26639f,0.26955f,0.24102f,0.19708f,0.1414f,0.081769f,0.04018f,0.039392f,0.060989f,0.074445f,0.06227f,0.04532f,0.021639f,0.0010905f,0.000000f,0.000000f},
   {0.000000f,0.0034849f,0.076245f,0.14627f,0.18729f,0.21103f,0.18815f,0.15968f,0.12215f,0.077493f,0.033596f,0.0051272f,0.0070705f,0.016667f,0.025139f,0.031985f,0.016921f,0.0032217f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.015871f,0.078648f,0.12649f,0.11765f,0.10373f,0.077089f,0.049467f,0.022632f,0.0031126f,0.000000f,0.000000f,0.000000f,0.0013009f,0.0022061f,0.0024313f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040112f,0.026399f,0.030429f,0.027832f,0.023088f,0.011794f,0.0036134f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_11point1_densewrap_rsb[21][21] = {
   {0.39528f,0.45681f,0.52303f,0.5952f,0.67043f,0.74939f,0.83048f,0.91024f,0.98682f,1.057f,1.1171f,1.1683f,1.2061f,1.2313f,1.2457f,1.25f,1.2464f,1.2367f,1.2224f,1.2053f,1.1856f},
   {0.33058f,0.40718f,0.45818f,0.52008f,0.58928f,0.66875f,0.74761f,0.81551f,0.87989f,0.94409f,1.0051f,1.0545f,1.1006f,1.1428f,1.1756f,1.1839f,1.1749f,1.1545f,1.1257f,1.0916f,1.1633f},
   {0.26115f,0.35842f,0.44063f,0.48883f,0.54542f,0.60952f,0.67161f,0.72963f,0.7843f,0.83594f,0.89143f,0.93364f,0.97024f,0.99897f,1.0225f,1.0338f,1.0643f,1.0254f,0.98114f,1.0512f,1.135f},
   {0.18334f,0.30498f,0.39398f,0.47073f,0.52673f,0.58068f,0.63196f,0.67962f,0.72234f,0.75459f,0.77925f,0.78892f,0.80854f,0.83344f,0.84641f,0.86582f,0.87633f,0.88628f,0.9341f,0.99597f,1.0988f},
   {0.096659f,0.25132f,0.34275f,0.44182f,0.50908f,0.55418f,0.59678f,0.6364f,0.66294f,0.6709f,0.67291f,0.67361f,0.68817f,0.7108f,0.72984f,0.75115f,0.76343f,0.81572f,0.87916f,0.92428f,1.0546f},
   {0.000000f,0.19635f,0.31808f,0.4075f,0.47641f,0.52638f,0.56225f,0.59065f,0.60029f,0.59259f,0.58727f,0.59329f,0.60455f,0.62204f,0.64676f,0.66381f,0.71718f,0.75559f,0.78694f,0.83674f,1.000000f},
   {0.000000f,0.15428f,0.28088f,0.37331f,0.44047f,0.49127f,0.52623f,0.54126f,0.53704f,0.52904f,0.5252f,0.53004f,0.53902f,0.55281f,0.57709f,0.63371f,0.67137f,0.69903f,0.71575f,0.7319f,0.83403f},
   {0.000000f,0.13086f,0.24559f,0.32994f,0.39652f,0.45039f,0.49013f,0.49768f,0.4877f,0.47777f,0.475f,0.47917f,0.4903f,0.50496f,0.55263f,0.60235f,0.63292f,0.64765f,0.64765f,0.63022f,0.64256f},
   {0.000000f,0.10504f,0.20691f,0.28618f,0.35012f,0.40283f,0.44506f,0.46986f,0.44618f,0.43543f,0.43067f,0.43704f,0.44885f,0.48946f,0.53558f,0.57138f,0.5899f,0.59455f,0.58249f,0.54359f,0.44198f},
   {0.000000f,0.074469f,0.16639f,0.23921f,0.29774f,0.34717f,0.38878f,0.4225f,0.43045f,0.39661f,0.39151f,0.39898f,0.43628f,0.47713f,0.51317f,0.53523f,0.54366f,0.53967f,0.51742f,0.46108f,0.22597f},
   {0.000000f,0.042125f,0.1205f,0.18577f,0.2389f,0.28548f,0.32122f,0.34872f,0.36849f,0.37407f,0.35697f,0.38813f,0.42638f,0.45809f,0.4793f,0.49116f,0.49224f,0.47985f,0.44747f,0.37426f,-1.3692e-016f},
   {0.000000f,0.01853f,0.081227f,0.13749f,0.18332f,0.21944f,0.2469f,0.26266f,0.26034f,0.26234f,0.28446f,0.35101f,0.39508f,0.42016f,0.43565f,0.44175f,0.43799f,0.42001f,0.38031f,0.29451f,0.000000f},
   {0.000000f,0.0024135f,0.044054f,0.089831f,0.12819f,0.15787f,0.17874f,0.18409f,0.17643f,0.17282f,0.21028f,0.27697f,0.33901f,0.36755f,0.38265f,0.38536f,0.37752f,0.35433f,0.30655f,0.20552f,0.000000f},
   {0.000000f,0.000000f,0.016013f,0.049808f,0.080755f,0.10486f,0.12234f,0.12304f,0.0965f,0.10005f,0.14085f,0.20722f,0.2693f,0.31205f,0.32713f,0.32642f,0.31428f,0.28576f,0.2296f,0.10737f,0.000000f},
   {0.000000f,0.000000f,0.0011106f,0.021725f,0.045206f,0.062127f,0.074563f,0.060842f,0.039245f,0.040165f,0.081549f,0.14161f,0.19728f,0.24121f,0.26928f,0.26662f,0.25356f,0.21909f,0.14945f,0.031188f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0032548f,0.016837f,0.032077f,0.02508f,0.016671f,0.0069915f,0.0051514f,0.033399f,0.077667f,0.12235f,0.15984f,0.18836f,0.21072f,0.18755f,0.1465f,0.076496f,0.0035468f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0024605f,0.0021549f,0.0012606f,0.000000f,0.000000f,0.000000f,0.0030466f,0.022737f,0.049623f,0.077277f,0.10395f,0.11788f,0.12614f,0.078886f,0.016004f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003656f,0.011882f,0.023206f,0.027969f,0.030577f,0.026172f,0.0040704f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.4883e-018f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_ang[] = {-45,-26,0,26,45,-63,63,-90,90,-116,116,-135,135};
static float map_13point1_totalwrap_xsf[] = {-1,-0.5,0,0.5,1,-1,1,-1,1,-1,1,-1,1};
static float map_13point1_totalwrap_ysf[] = {1,1,1,1,1,0.5,0.5,0,0,-0.5,-0.5,-1,-1};
channel_id map_13point1_totalwrap_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_side_front_left,ci_side_front_right,ci_side_center_left,ci_side_center_right,ci_side_back_left,ci_side_back_right,ci_back_left,ci_back_right,ci_lfe};

static float map_13point1_totalwrap_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.005581f,0.003291f,1.7252e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0081504f,0.042808f,0.072882f,0.060953f,0.042164f,0.017887f,0.0013668f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0027588f,0.054743f,0.091228f,0.091909f,0.082995f,0.079348f,0.071132f,0.040421f,0.0039453f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.040396f,0.10257f,0.10193f,0.089276f,0.079333f,0.072621f,0.070291f,0.068709f,0.03606f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0060181f,0.10346f,0.11606f,0.098677f,0.086748f,0.077297f,0.070277f,0.064552f,0.062673f,0.06051f,0.0017892f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.047382f,0.13537f,0.11322f,0.096621f,0.085123f,0.076125f,0.068709f,0.062673f,0.057379f,0.05627f,0.000000f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10632f,0.1408f,0.11333f,0.0968f,0.08448f,0.075551f,0.068329f,0.061952f,0.05632f,0.051341f,0.056303f,0.060536f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.16195f,0.14064f,0.1132f,0.096622f,0.085107f,0.076104f,0.068709f,0.062673f,0.060449f,0.05632f,0.057346f,0.062673f,0.068709f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.194f,0.14507f,0.11609f,0.098677f,0.086764f,0.077297f,0.071771f,0.068005f,0.062673f,0.061952f,0.062673f,0.064514f,0.070277f,0.071028f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.22178f,0.15206f,0.12055f,0.10193f,0.090467f,0.081765f,0.076506f,0.071744f,0.068709f,0.068329f,0.068709f,0.070291f,0.072578f,0.079333f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25576f,0.16273f,0.12661f,0.10766f,0.096098f,0.087435f,0.081735f,0.077297f,0.076125f,0.075551f,0.076104f,0.077297f,0.079348f,0.082947f,0.06067f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {3.1398e-016f,0.28205f,0.17804f,0.13801f,0.11623f,0.10201f,0.096063f,0.090425f,0.086748f,0.085123f,0.08448f,0.085107f,0.086764f,0.089301f,0.091873f,0.072927f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24261f,0.28709f,0.20797f,0.15099f,0.12555f,0.11619f,0.10762f,0.10193f,0.098677f,0.096621f,0.0968f,0.096622f,0.098677f,0.10193f,0.091044f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.46196f,0.29071f,0.21045f,0.16884f,0.15094f,0.13799f,0.12656f,0.12057f,0.11606f,0.11322f,0.11333f,0.1132f,0.11609f,0.10231f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.66287f,0.29364f,0.21289f,0.21045f,0.20789f,0.17806f,0.16273f,0.15206f,0.14511f,0.14066f,0.1408f,0.1352f,0.10303f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.8397f,0.29675f,0.29354f,0.29061f,0.28698f,0.28196f,0.25543f,0.22155f,0.19371f,0.16153f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_13point1_totalwrap_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031891f,0.0054514f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013174f,0.017687f,0.041859f,0.06067f,0.072899f,0.042466f,0.0079947f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003925f,0.040182f,0.071028f,0.079333f,0.082923f,0.091873f,0.091044f,0.054336f,0.0026644f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.036005f,0.068709f,0.070277f,0.072557f,0.079348f,0.089301f,0.10193f,0.10231f,0.040017f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017407f,0.060499f,0.062673f,0.064496f,0.070291f,0.077297f,0.086764f,0.098677f,0.11609f,0.10303f,0.005855f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.000000f,0.056286f,0.057329f,0.062673f,0.068709f,0.076104f,0.085107f,0.096622f,0.1132f,0.1352f,0.046879f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.06051f,0.056286f,0.051311f,0.056286f,0.061915f,0.068289f,0.075506f,0.08443f,0.096742f,0.11326f,0.14072f,0.10645f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040421f,0.068709f,0.062673f,0.057312f,0.056287f,0.060432f,0.062673f,0.068709f,0.076125f,0.085123f,0.096621f,0.11322f,0.14066f,0.16153f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.071132f,0.070291f,0.064476f,0.062673f,0.061916f,0.062673f,0.067986f,0.071744f,0.077297f,0.086748f,0.098677f,0.11606f,0.14511f,0.19371f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.079348f,0.072536f,0.070277f,0.068709f,0.068289f,0.068709f,0.071771f,0.076484f,0.081735f,0.090425f,0.10193f,0.12057f,0.15206f,0.22155f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.060953f,0.082898f,0.079333f,0.077297f,0.076125f,0.075507f,0.076104f,0.077297f,0.081765f,0.087411f,0.096063f,0.10762f,0.12656f,0.16273f,0.25543f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.072826f,0.091909f,0.089276f,0.086748f,0.085123f,0.08443f,0.085107f,0.086764f,0.090467f,0.096098f,0.10198f,0.11619f,0.13799f,0.17806f,0.28196f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.091228f,0.10193f,0.098677f,0.096621f,0.096743f,0.096622f,0.098677f,0.10193f,0.10766f,0.11623f,0.12551f,0.15094f,0.20789f,0.28698f,0.23903f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.10257f,0.11606f,0.11322f,0.11326f,0.1132f,0.11609f,0.12055f,0.12661f,0.13801f,0.15099f,0.16879f,0.21045f,0.29061f,0.4584f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10346f,0.13537f,0.14072f,0.14064f,0.14507f,0.15206f,0.16273f,0.17804f,0.20797f,0.21045f,0.21283f,0.29354f,0.65936f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.16195f,0.194f,0.22178f,0.25576f,0.28205f,0.28709f,0.29071f,0.29364f,0.29667f,0.83624f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_13point1_totalwrap_lsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,1.4883e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040704f,0.026172f,0.030577f,0.027969f,0.023206f,0.011882f,0.003656f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016004f,0.078886f,0.11885f,0.11126f,0.10005f,0.077277f,0.049623f,0.022737f,0.0030466f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0035468f,0.076496f,0.13684f,0.13679f,0.11897f,0.11432f,0.10984f,0.10114f,0.076046f,0.033501f,0.0046306f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.031188f,0.14617f,0.15418f,0.1299f,0.11431f,0.10197f,0.097664f,0.095287f,0.093649f,0.075427f,0.024282f,0.00073159f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10737f,0.1817f,0.1484f,0.12564f,0.10986f,0.097669f,0.089224f,0.086605f,0.08469f,0.083965f,0.048387f,0.004605f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19838f,0.17849f,0.14282f,0.12164f,0.1068f,0.095276f,0.0866f,0.07931f,0.077259f,0.076129f,0.058978f,0.0048965f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23832f,0.17313f,0.13935f,0.11911f,0.10488f,0.093632f,0.084699f,0.077251f,0.070498f,0.069208f,0.041647f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.3692e-016f,0.24833f,0.17308f,0.13931f,0.11899f,0.10385f,0.092873f,0.083996f,0.076156f,0.069233f,0.063102f,0.05511f,0.019286f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.22597f,0.25121f,0.17526f,0.1413f,0.12102f,0.1069f,0.095882f,0.087318f,0.080638f,0.070515f,0.069221f,0.070532f,0.07488f,0.032609f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44198f,0.26542f,0.18277f,0.14664f,0.1254f,0.11069f,0.099453f,0.088959f,0.07933f,0.077251f,0.076144f,0.077259f,0.079348f,0.070283f,0.013958f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.64256f,0.2947f,0.1939f,0.15413f,0.13115f,0.11353f,0.099577f,0.089246f,0.0866f,0.084699f,0.083982f,0.08469f,0.086605f,0.085004f,0.039295f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83403f,0.33937f,0.20938f,0.16007f,0.13344f,0.11606f,0.102f,0.097669f,0.095276f,0.093632f,0.092858f,0.093649f,0.095287f,0.088683f,0.054552f,0.0013532f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.35937f,0.22225f,0.16947f,0.13938f,0.11899f,0.11431f,0.10986f,0.1068f,0.10488f,0.10383f,0.10487f,0.10415f,0.081353f,0.034375f,0.0043588f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.7669f,0.35542f,0.25327f,0.18049f,0.14646f,0.13768f,0.1299f,0.12564f,0.12164f,0.11911f,0.11897f,0.11747f,0.098408f,0.05387f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55102f,0.34365f,0.25072f,0.19696f,0.17861f,0.1657f,0.15445f,0.1484f,0.14282f,0.13935f,0.13074f,0.10642f,0.058689f,0.012407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34893f,0.32425f,0.24834f,0.24599f,0.23588f,0.21001f,0.1922f,0.1745f,0.1548f,0.12874f,0.085642f,0.036985f,0.0041976f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.16741f,0.30017f,0.27214f,0.23269f,0.17995f,0.11341f,0.070758f,0.057469f,0.038068f,0.013988f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_rsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0036134f,0.011794f,0.023088f,0.027832f,0.030429f,0.026399f,0.0040112f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031126f,0.022632f,0.049467f,0.077089f,0.099949f,0.11118f,0.11911f,0.078648f,0.015871f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045869f,0.033596f,0.075931f,0.10117f,0.10998f,0.11448f,0.11916f,0.13692f,0.13673f,0.076245f,0.0034849f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00071455f,0.024189f,0.075553f,0.093753f,0.095409f,0.097805f,0.10214f,0.11445f,0.13006f,0.15434f,0.14595f,0.030939f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045638f,0.04826f,0.084116f,0.084794f,0.086729f,0.089374f,0.097788f,0.10998f,0.12579f,0.14861f,0.18178f,0.10702f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0049397f,0.058905f,0.076265f,0.077358f,0.079443f,0.086706f,0.095393f,0.10693f,0.1218f,0.14297f,0.17876f,0.19813f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041705f,0.069332f,0.070616f,0.077346f,0.084808f,0.093775f,0.10503f,0.11926f,0.13955f,0.17338f,0.23845f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.128e-019f,0.019251f,0.055118f,0.063203f,0.069332f,0.076265f,0.084116f,0.093006f,0.104f,0.11916f,0.13951f,0.17333f,0.24869f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,2.262e-005f,0.032844f,0.075002f,0.070621f,0.069332f,0.070599f,0.080737f,0.087417f,0.095981f,0.10702f,0.12116f,0.14146f,0.17546f,0.2515f,0.22461f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014122f,0.070466f,0.079449f,0.077358f,0.076265f,0.077346f,0.079424f,0.089097f,0.099575f,0.11084f,0.12555f,0.14685f,0.18296f,0.26573f,0.44064f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.039567f,0.085048f,0.086729f,0.084794f,0.084116f,0.084808f,0.086706f,0.089352f,0.099732f,0.11371f,0.13131f,0.1543f,0.19413f,0.29503f,0.64125f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0014071f,0.054512f,0.088881f,0.095409f,0.093753f,0.093007f,0.093775f,0.095393f,0.097788f,0.10212f,0.11625f,0.13365f,0.16031f,0.20963f,0.33985f,0.83276f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043373f,0.034659f,0.08163f,0.10433f,0.105f,0.104f,0.10503f,0.10693f,0.10998f,0.11445f,0.11914f,0.1396f,0.16971f,0.22252f,0.35981f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.054219f,0.098665f,0.11764f,0.11916f,0.11926f,0.1218f,0.12579f,0.13006f,0.13785f,0.14663f,0.18077f,0.25367f,0.35599f,0.77038f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012593f,0.059121f,0.10673f,0.13084f,0.13955f,0.14297f,0.14861f,0.15464f,0.1659f,0.17883f,0.19719f,0.25106f,0.3443f,0.55456f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043097f,0.037335f,0.085557f,0.12916f,0.1552f,0.17483f,0.19253f,0.21041f,0.2363f,0.24639f,0.24863f,0.32498f,0.3525f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.6987e-018f,0.014261f,0.038514f,0.058048f,0.071419f,0.11435f,0.18086f,0.23352f,0.27289f,0.30018f,0.171f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.4828e-016f}};

static float map_13point1_totalwrap_lsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.057837f,0.033725f,0.014056f,0.0021284f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.088781f,0.15197f,0.1126f,0.075079f,0.081035f,0.065091f,0.049131f,0.030154f,0.01248f,0.00065038f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13136f,0.19047f,0.19972f,0.18761f,0.17365f,0.15926f,0.13948f,0.11522f,0.080258f,0.038352f,0.011632f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.1876f,0.22622f,0.20877f,0.17308f,0.16259f,0.15331f,0.14824f,0.14136f,0.12698f,0.096228f,0.051224f,0.013903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25386f,0.24792f,0.19549f,0.16259f,0.14063f,0.13492f,0.12979f,0.12612f,0.12377f,0.11836f,0.09054f,0.040513f,0.0077516f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.18322f,0.31647f,0.23665f,0.18234f,0.15331f,0.13491f,0.12054f,0.11534f,0.11241f,0.11063f,0.10978f,0.10408f,0.067907f,0.021737f,0.00081869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.38445f,0.33396f,0.22305f,0.17613f,0.14823f,0.12977f,0.11534f,0.10547f,0.10221f,0.099919f,0.099291f,0.099924f,0.076689f,0.027385f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.58627f,0.31272f,0.21469f,0.17128f,0.14518f,0.12698f,0.11241f,0.1022f,0.093751f,0.091147f,0.090023f,0.091143f,0.07194f,0.010076f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.79404f,0.30169f,0.2101f,0.16888f,0.14394f,0.12647f,0.11263f,0.10109f,0.091143f,0.083334f,0.081839f,0.083344f,0.027665f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.30431f,0.2121f,0.17071f,0.14582f,0.12726f,0.11381f,0.10293f,0.093322f,0.084838f,0.074566f,0.014386f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.79277f,0.30166f,0.21008f,0.16887f,0.14393f,0.12645f,0.11261f,0.10108f,0.091147f,0.083312f,0.081796f,0.083334f,0.02757f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.58496f,0.31272f,0.21465f,0.17129f,0.14517f,0.12697f,0.11241f,0.10221f,0.093725f,0.091143f,0.089976f,0.091147f,0.071938f,0.010015f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3831f,0.33384f,0.22305f,0.17611f,0.14824f,0.12979f,0.11534f,0.10544f,0.1022f,0.099924f,0.099238f,0.099919f,0.076598f,0.027407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.18186f,0.31619f,0.23666f,0.18235f,0.15331f,0.13492f,0.1205f,0.11534f,0.11241f,0.11064f,0.10973f,0.10402f,0.06778f,0.021645f,0.00081784f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25335f,0.24781f,0.1955f,0.16259f,0.14059f,0.13491f,0.12977f,0.12612f,0.12378f,0.11834f,0.090417f,0.040382f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.1871f,0.22597f,0.20873f,0.17303f,0.16259f,0.15331f,0.14823f,0.14133f,0.12691f,0.096247f,0.051065f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13094f,0.19014f,0.19982f,0.18747f,0.17352f,0.15913f,0.13934f,0.11502f,0.08005f,0.038463f,0.011549f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.088435f,0.15238f,0.11227f,0.074803f,0.080771f,0.064857f,0.048933f,0.030007f,0.012387f,0.00062972f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.05808f,0.033499f,0.013912f,0.0020664f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0020664f,0.013912f,0.033499f,0.058195f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062972f,0.012387f,0.030007f,0.048933f,0.064857f,0.080771f,0.074803f,0.11227f,0.15246f,0.088435f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.011549f,0.038509f,0.08005f,0.11502f,0.13934f,0.15913f,0.17352f,0.18747f,0.19989f,0.19014f,0.13094f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013816f,0.051065f,0.096286f,0.12691f,0.14133f,0.14823f,0.15331f,0.16259f,0.17308f,0.20873f,0.22597f,0.1871f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0076928f,0.040382f,0.090417f,0.11837f,0.12378f,0.12612f,0.12977f,0.13491f,0.14063f,0.16259f,0.1955f,0.24781f,0.25335f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00081784f,0.021645f,0.06778f,0.10402f,0.10977f,0.11064f,0.11241f,0.11534f,0.12054f,0.13492f,0.15331f,0.18235f,0.23666f,0.31619f,0.18186f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027451f,0.076598f,0.099919f,0.099281f,0.099924f,0.1022f,0.10547f,0.11534f,0.12979f,0.14824f,0.17611f,0.22305f,0.33384f,0.3831f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010015f,0.071952f,0.091147f,0.090014f,0.091143f,0.093752f,0.10221f,0.11241f,0.12697f,0.14517f,0.17129f,0.21465f,0.31272f,0.58496f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.02757f,0.083335f,0.081831f,0.083335f,0.091147f,0.10108f,0.11261f,0.12645f,0.14393f,0.16887f,0.21008f,0.30166f,0.79277f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014385f,0.074587f,0.084862f,0.093348f,0.10296f,0.11384f,0.12729f,0.14586f,0.17076f,0.21215f,0.30439f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027665f,0.083335f,0.08182f,0.083335f,0.091143f,0.10109f,0.11263f,0.12647f,0.14394f,0.16888f,0.2101f,0.30169f,0.79404f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010076f,0.071837f,0.091143f,0.090002f,0.091147f,0.093752f,0.1022f,0.11241f,0.12698f,0.14518f,0.17128f,0.21469f,0.31272f,0.58627f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027311f,0.076689f,0.099924f,0.099267f,0.099919f,0.10221f,0.10547f,0.11534f,0.12977f,0.14823f,0.17613f,0.22305f,0.33396f,0.38445f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080127f,0.021737f,0.067907f,0.10408f,0.10976f,0.11063f,0.11241f,0.11534f,0.12054f,0.13491f,0.15331f,0.18234f,0.23665f,0.31647f,0.18322f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0077516f,0.040513f,0.09054f,0.11831f,0.12377f,0.12612f,0.12979f,0.13492f,0.14063f,0.16259f,0.19549f,0.24792f,0.25386f,-2.2204e-016f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.22e-018f,0.013903f,0.051224f,0.096055f,0.12698f,0.14136f,0.14824f,0.15331f,0.16259f,0.17308f,0.20877f,0.22622f,0.1876f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.011632f,0.038283f,0.080258f,0.11522f,0.13948f,0.15926f,0.17365f,0.18761f,0.19965f,0.19047f,0.13136f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062082f,0.01248f,0.030154f,0.049131f,0.065091f,0.081035f,0.075079f,0.1126f,0.15189f,0.088781f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0021284f,0.014056f,0.033725f,0.05778f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_lsb[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17101f,0.3002f,0.27289f,0.23302f,0.18086f,0.11435f,0.071419f,0.058048f,0.038514f,0.013902f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3511f,0.3244f,0.24861f,0.24639f,0.23594f,0.21041f,0.19253f,0.17483f,0.1552f,0.12916f,0.08561f,0.037085f,0.0043097f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55452f,0.3443f,0.25064f,0.19717f,0.17883f,0.1659f,0.15438f,0.14861f,0.14297f,0.13955f,0.13083f,0.10653f,0.059121f,0.012378f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.77038f,0.35549f,0.25367f,0.18047f,0.14661f,0.13765f,0.13006f,0.12579f,0.1218f,0.11926f,0.11904f,0.11764f,0.098665f,0.054219f,0.012206f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.35981f,0.22252f,0.16971f,0.1396f,0.11912f,0.11445f,0.10998f,0.10677f,0.10488f,0.10389f,0.105f,0.10433f,0.08163f,0.034493f,0.0043086f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83276f,0.33985f,0.20963f,0.16005f,0.13346f,0.11608f,0.10211f,0.097647f,0.095393f,0.093775f,0.092909f,0.093753f,0.095409f,0.088881f,0.054543f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.64125f,0.29503f,0.19413f,0.15408f,0.13131f,0.11371f,0.099732f,0.089343f,0.086706f,0.084808f,0.084028f,0.084794f,0.086604f,0.085015f,0.039425f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44064f,0.26573f,0.18296f,0.14685f,0.12555f,0.11084f,0.099575f,0.088972f,0.079416f,0.077346f,0.076185f,0.077358f,0.079366f,0.070466f,0.014122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.22461f,0.2515f,0.17521f,0.14126f,0.12116f,0.10702f,0.095981f,0.087417f,0.080737f,0.070592f,0.06926f,0.070547f,0.075002f,0.032844f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.24865f,0.1733f,0.13949f,0.11914f,0.10398f,0.09299f,0.084101f,0.076252f,0.06932f,0.063198f,0.055167f,0.019305f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23845f,0.17338f,0.13955f,0.11926f,0.10488f,0.093775f,0.084808f,0.077346f,0.070615f,0.069326f,0.041681f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19813f,0.17876f,0.14297f,0.1218f,0.10677f,0.095393f,0.086706f,0.079442f,0.077358f,0.076259f,0.058905f,0.0049261f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10702f,0.18178f,0.14861f,0.12579f,0.10998f,0.097647f,0.089373f,0.086604f,0.084794f,0.084109f,0.04826f,0.0045638f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.030939f,0.14595f,0.15412f,0.13006f,0.11445f,0.10214f,0.097805f,0.095409f,0.093753f,0.075568f,0.024189f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0034849f,0.076245f,0.13673f,0.13678f,0.11916f,0.11432f,0.10998f,0.10117f,0.075931f,0.033596f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.015871f,0.078648f,0.11911f,0.11118f,0.099949f,0.077089f,0.049467f,0.022632f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040112f,0.026399f,0.030429f,0.027832f,0.023088f,0.011794f,0.0036134f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_rsb[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013988f,0.038068f,0.057469f,0.070758f,0.11341f,0.17995f,0.23269f,0.27214f,0.30022f,0.16743f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0041976f,0.036985f,0.085724f,0.12874f,0.1548f,0.1745f,0.1922f,0.21001f,0.23588f,0.24599f,0.24837f,0.32425f,0.34893f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012407f,0.058689f,0.10642f,0.13076f,0.13935f,0.14282f,0.1484f,0.15445f,0.1657f,0.17861f,0.19698f,0.25072f,0.34365f,0.55098f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012211f,0.05387f,0.098408f,0.11747f,0.11899f,0.11911f,0.12164f,0.12564f,0.1299f,0.13768f,0.14648f,0.18049f,0.25327f,0.35542f,0.7669f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043588f,0.034375f,0.081353f,0.10415f,0.10487f,0.10385f,0.10488f,0.1068f,0.10986f,0.11431f,0.11901f,0.13938f,0.16947f,0.22225f,0.35937f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.054576f,0.088683f,0.095287f,0.093649f,0.092871f,0.093632f,0.095276f,0.097669f,0.10201f,0.11606f,0.13344f,0.16007f,0.20938f,0.33937f,0.83403f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.039295f,0.084981f,0.086605f,0.08469f,0.083994f,0.084699f,0.0866f,0.089259f,0.099577f,0.11353f,0.13115f,0.15413f,0.1939f,0.2947f,0.64256f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.070283f,0.079341f,0.077259f,0.076154f,0.077251f,0.079341f,0.088959f,0.099453f,0.11069f,0.1254f,0.14664f,0.18277f,0.26542f,0.44198f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.07488f,0.070525f,0.069231f,0.070525f,0.080638f,0.087318f,0.095882f,0.1069f,0.12102f,0.1413f,0.17526f,0.25121f,0.22597f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.019304f,0.055126f,0.063107f,0.069231f,0.076154f,0.083994f,0.092871f,0.10385f,0.11899f,0.13931f,0.17308f,0.24833f,-1.3692e-016f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041554f,0.069226f,0.070525f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.17313f,0.23832f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0048829f,0.058978f,0.076149f,0.077259f,0.079341f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.17849f,0.19838f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.004605f,0.048387f,0.083988f,0.08469f,0.086605f,0.089259f,0.097669f,0.10986f,0.12564f,0.1484f,0.1817f,0.10737f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.024282f,0.075363f,0.093649f,0.095287f,0.097664f,0.10201f,0.11431f,0.1299f,0.15418f,0.14617f,0.031188f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.033399f,0.076046f,0.10114f,0.10984f,0.11432f,0.11901f,0.13679f,0.13684f,0.076496f,0.0035468f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0030466f,0.022737f,0.049623f,0.077277f,0.10005f,0.11126f,0.11884f,0.078886f,0.016004f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003656f,0.011882f,0.023206f,0.027969f,0.030577f,0.026172f,0.0040704f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.4883e-018f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_ls[21][21] = {
   {1.000000f,0.99863f,0.99396f,0.98481f,0.9703f,0.94888f,0.91914f,0.88048f,0.83195f,0.77384f,0.70834f,0.63338f,0.55484f,0.47562f,0.39394f,0.3173f,0.24362f,0.17537f,0.11147f,0.054079f,-7.8496e-017f},
   {0.8363f,0.62244f,0.66382f,0.70947f,0.7566f,0.80329f,0.81123f,0.77152f,0.72989f,0.68929f,0.63602f,0.56664f,0.49969f,0.43164f,0.36121f,0.29703f,0.24559f,0.20208f,0.16581f,0.13592f,0.000000f},
   {0.66065f,0.57579f,0.55614f,0.58407f,0.61318f,0.58842f,0.57511f,0.55144f,0.52699f,0.51049f,0.50982f,0.50391f,0.48267f,0.43211f,0.3753f,0.31848f,0.25563f,0.21817f,0.18628f,0.11031f,0.000000f},
   {0.45837f,0.52122f,0.52335f,0.50536f,0.49487f,0.48047f,0.45645f,0.43846f,0.42171f,0.41094f,0.41034f,0.40976f,0.41927f,0.41689f,0.38061f,0.33006f,0.27965f,0.22857f,0.15778f,0.083896f,0.000000f},
   {0.23903f,0.45956f,0.48458f,0.46274f,0.42459f,0.40691f,0.38394f,0.3711f,0.35896f,0.35106f,0.3505f,0.34986f,0.35659f,0.36762f,0.36529f,0.33185f,0.28785f,0.21842f,0.12802f,0.058746f,0.000000f},
   {0.000000f,0.38957f,0.43442f,0.42679f,0.39709f,0.35204f,0.33794f,0.32485f,0.31551f,0.30928f,0.30589f,0.30802f,0.31303f,0.32135f,0.33266f,0.32299f,0.2697f,0.20197f,0.12403f,0.03616f,0.000000f},
   {0.000000f,0.32257f,0.39095f,0.39305f,0.37103f,0.33625f,0.30175f,0.28885f,0.28142f,0.27645f,0.27356f,0.27506f,0.27878f,0.2852f,0.29725f,0.30114f,0.24789f,0.18361f,0.10709f,0.022585f,0.000000f},
   {0.000000f,0.27608f,0.35222f,0.3637f,0.35047f,0.32132f,0.28699f,0.26403f,0.25596f,0.24994f,0.24741f,0.24829f,0.25299f,0.26009f,0.28462f,0.27305f,0.21805f,0.15706f,0.090176f,0.018356f,0.000000f},
   {0.000000f,0.22983f,0.3132f,0.33406f,0.32977f,0.30936f,0.27746f,0.25371f,0.2347f,0.22818f,0.22432f,0.22604f,0.23119f,0.25225f,0.2713f,0.23683f,0.18569f,0.13031f,0.070512f,0.012179f,0.000000f},
   {0.000000f,0.1748f,0.27173f,0.30205f,0.30659f,0.29628f,0.27295f,0.24664f,0.22496f,0.20862f,0.20393f,0.2055f,0.22497f,0.24663f,0.23725f,0.19424f,0.14921f,0.10103f,0.049741f,0.0045097f,0.000000f},
   {0.000000f,0.10645f,0.22243f,0.2645f,0.27871f,0.27734f,0.2652f,0.24483f,0.22198f,0.2018f,0.18593f,0.20175f,0.22052f,0.21252f,0.18253f,0.14834f,0.1086f,0.068513f,0.027472f,-8.5322e-019f,0.000000f},
   {0.000000f,0.046879f,0.1703f,0.22233f,0.24418f,0.25003f,0.24622f,0.23507f,0.21914f,0.1964f,0.13618f,0.12075f,0.14674f,0.14347f,0.12638f,0.10174f,0.073541f,0.042039f,0.011806f,0.000000f,0.000000f},
   {0.000000f,0.005855f,0.10701f,0.17178f,0.20181f,0.21417f,0.21587f,0.20809f,0.19221f,0.15321f,0.084892f,0.045091f,0.080618f,0.086082f,0.07899f,0.061737f,0.041097f,0.018696f,0.0013628f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.040017f,0.11409f,0.15305f,0.17193f,0.17885f,0.17256f,0.14411f,0.09965f,0.036025f,0.010386f,0.029455f,0.046248f,0.043546f,0.03134f,0.017152f,0.0039822f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0026644f,0.054553f,0.10263f,0.12449f,0.13524f,0.11662f,0.084273f,0.040182f,0.003925f,7.153e-006f,0.0044657f,0.012512f,0.017789f,0.01096f,0.0039191f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0079947f,0.042595f,0.077006f,0.062112f,0.041859f,0.017687f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.00044495f,0.0013625f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0062247f,0.0054514f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_13point1_totalwrap_rs[21][21] = {
   {-7.8496e-017f,0.052336f,0.10973f,0.17365f,0.24192f,0.31565f,0.39394f,0.47409f,0.55484f,0.63338f,0.70587f,0.77384f,0.83195f,0.87965f,0.91914f,0.94832f,0.96987f,0.9845f,0.99377f,0.99854f,1.000000f},
   {0.000000f,0.13583f,0.16489f,0.20208f,0.24451f,0.29589f,0.35999f,0.43048f,0.49857f,0.56633f,0.63558f,0.68855f,0.72945f,0.77133f,0.81125f,0.80371f,0.75713f,0.70995f,0.66449f,0.62205f,0.83976f},
   {0.000000f,0.11031f,0.18615f,0.21738f,0.25552f,0.31761f,0.37444f,0.43128f,0.48199f,0.50346f,0.50942f,0.51076f,0.52673f,0.55121f,0.57501f,0.58851f,0.61339f,0.58448f,0.55581f,0.5763f,0.66287f},
   {0.000000f,0.083257f,0.15778f,0.22845f,0.27908f,0.32934f,0.38061f,0.4164f,0.41906f,0.40951f,0.41002f,0.41117f,0.42148f,0.4387f,0.45663f,0.48036f,0.49514f,0.50506f,0.52368f,0.52214f,0.46192f},
   {0.000000f,0.058746f,0.12737f,0.2183f,0.28772f,0.33167f,0.36488f,0.36741f,0.35639f,0.34967f,0.35023f,0.35086f,0.35876f,0.3709f,0.38414f,0.4067f,0.4243f,0.46285f,0.48512f,0.46015f,0.24261f},
   {0.000000f,0.035717f,0.12342f,0.20135f,0.26927f,0.32283f,0.33242f,0.32118f,0.3132f,0.30818f,0.30565f,0.30912f,0.31533f,0.32468f,0.33811f,0.35174f,0.39734f,0.42692f,0.43484f,0.39053f,0.000000f},
   {0.000000f,0.022264f,0.10655f,0.18361f,0.24774f,0.30104f,0.29712f,0.28536f,0.27862f,0.2749f,0.27335f,0.27632f,0.28126f,0.28868f,0.3015f,0.33609f,0.37098f,0.39328f,0.39132f,0.32351f,0.000000f},
   {0.000000f,0.018075f,0.089694f,0.15698f,0.21753f,0.27257f,0.28445f,0.25998f,0.25285f,0.24815f,0.24722f,0.2498f,0.25609f,0.26381f,0.28717f,0.32119f,0.35044f,0.36381f,0.35258f,0.27684f,0.000000f},
   {0.000000f,0.011962f,0.070085f,0.12983f,0.1852f,0.2365f,0.27104f,0.25238f,0.2311f,0.22591f,0.22415f,0.22805f,0.2345f,0.25358f,0.2773f,0.30954f,0.32979f,0.33426f,0.31358f,0.23053f,0.000000f},
   {0.000000f,0.0043772f,0.049741f,0.10103f,0.14876f,0.19392f,0.23686f,0.24649f,0.22485f,0.20542f,0.20377f,0.20844f,0.22484f,0.2465f,0.2728f,0.29644f,0.30666f,0.30224f,0.27197f,0.17548f,0.000000f},
   {0.000000f,-8.5322e-019f,0.027447f,0.068465f,0.10853f,0.14825f,0.18244f,0.21244f,0.22045f,0.20168f,0.18582f,0.20163f,0.22179f,0.24462f,0.26501f,0.27715f,0.27854f,0.26434f,0.22224f,0.1062f,0.000000f},
   {0.000000f,0.000000f,0.011636f,0.041753f,0.073199f,0.1017f,0.12602f,0.14312f,0.14641f,0.1207f,0.1361f,0.19627f,0.2191f,0.23505f,0.24628f,0.25015f,0.24438f,0.22266f,0.17079f,0.047382f,0.000000f},
   {0.000000f,0.000000f,0.0013084f,0.018492f,0.040831f,0.061737f,0.07868f,0.085813f,0.080572f,0.044927f,0.084809f,0.15335f,0.1921f,0.20822f,0.21599f,0.21432f,0.20208f,0.17215f,0.10754f,0.0060181f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0038919f,0.016973f,0.031114f,0.043546f,0.046224f,0.029455f,0.010272f,0.03594f,0.099867f,0.14424f,0.17246f,0.17899f,0.17218f,0.15337f,0.11452f,0.040396f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0038302f,0.010822f,0.017781f,0.01238f,0.0043862f,-3.2171e-019f,0.0039004f,0.040442f,0.084529f,0.11688f,0.13513f,0.12479f,0.10298f,0.054743f,0.0027588f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013625f,0.00044495f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.017887f,0.042164f,0.062288f,0.076885f,0.042808f,0.0081504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.005581f,0.0061507f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_ang[] = {-45,-26,0,26,45,-63,63,-90,90,-116,116,-135,-153,180,153,135};
static float map_16point1_xsf[] = {-1,-0.5,0,0.5,1,-1,1,-1,1,-1,1,-1,-0.5,0,0.5,1};
static float map_16point1_ysf[] = {1,1,1,1,1,0.5,0.5,0,0,-0.5,-0.5,-1,-1,-1,-1,-1};
channel_id map_16point1_id[] = {ci_front_left,ci_front_center_left,ci_front_center,ci_front_center_right,ci_front_right,ci_side_front_left,ci_side_front_right,ci_side_center_left,ci_side_center_right,ci_side_back_left,ci_side_back_right,ci_back_left,ci_back_center_left,ci_back_center,ci_back_center_right,ci_back_right,ci_lfe};

static float map_16point1_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.005581f,0.003291f,1.7252e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0081504f,0.042808f,0.072882f,0.060953f,0.042164f,0.017887f,0.0013668f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0027588f,0.054743f,0.091228f,0.091909f,0.082995f,0.079348f,0.071132f,0.040421f,0.0039453f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.040396f,0.10257f,0.10193f,0.089276f,0.079333f,0.072621f,0.070291f,0.068709f,0.03606f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0060181f,0.10346f,0.11606f,0.098677f,0.086748f,0.077297f,0.070277f,0.064552f,0.062673f,0.06051f,0.0017892f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.047382f,0.13537f,0.11322f,0.096621f,0.085123f,0.076125f,0.068709f,0.062673f,0.057379f,0.05627f,0.000000f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10632f,0.1408f,0.11333f,0.0968f,0.08448f,0.075551f,0.068329f,0.061952f,0.05632f,0.051341f,0.056303f,0.060536f,0.036045f,0.0039474f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.16195f,0.14064f,0.1132f,0.096622f,0.085107f,0.076104f,0.068709f,0.062673f,0.060449f,0.05632f,0.057346f,0.062673f,0.068709f,0.040182f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.194f,0.14507f,0.11609f,0.098677f,0.086764f,0.077297f,0.071771f,0.068005f,0.062673f,0.061952f,0.062673f,0.064514f,0.070277f,0.071028f,0.017687f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.22178f,0.15206f,0.12055f,0.10193f,0.090467f,0.081765f,0.076506f,0.071744f,0.068709f,0.068329f,0.068709f,0.070291f,0.072578f,0.079333f,0.041859f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25576f,0.16273f,0.12661f,0.10766f,0.096098f,0.087435f,0.081735f,0.077297f,0.076125f,0.075551f,0.076104f,0.077297f,0.079348f,0.082947f,0.06067f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f},
   {3.1398e-016f,0.28205f,0.17804f,0.13801f,0.11623f,0.10201f,0.096063f,0.090425f,0.086748f,0.085123f,0.08448f,0.085107f,0.086764f,0.089301f,0.091873f,0.072927f,0.0054514f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24261f,0.28709f,0.20797f,0.15099f,0.12555f,0.11619f,0.10762f,0.10193f,0.098677f,0.096621f,0.0968f,0.096622f,0.098677f,0.10193f,0.091044f,0.042466f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.46196f,0.29071f,0.21045f,0.16884f,0.15094f,0.13799f,0.12656f,0.12057f,0.11606f,0.11322f,0.11333f,0.1132f,0.11609f,0.10231f,0.054336f,0.0079947f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.66287f,0.29364f,0.21289f,0.21045f,0.20789f,0.17806f,0.16273f,0.15206f,0.14511f,0.14066f,0.1408f,0.1352f,0.10303f,0.040017f,0.0026644f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.8397f,0.29675f,0.29354f,0.29061f,0.28698f,0.28196f,0.25543f,0.22155f,0.19371f,0.16153f,0.10657f,0.046879f,0.005855f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.8363f,0.65936f,0.4584f,0.23903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_lcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043086f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.034659f,0.054439f,0.039567f,0.014122f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012593f,0.054219f,0.08163f,0.088881f,0.085013f,0.070466f,0.032844f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0043097f,0.059121f,0.098665f,0.10433f,0.095409f,0.086729f,0.079418f,0.075002f,0.019323f,0.000000f,0.0049397f,0.0045638f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.037335f,0.10673f,0.11764f,0.105f,0.093753f,0.084794f,0.077358f,0.070593f,0.05521f,0.041727f,0.058905f,0.04826f,0.024189f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,2.6987e-018f,0.0855f,0.13077f,0.11909f,0.10393f,0.092946f,0.084061f,0.076215f,0.069287f,0.063193f,0.069321f,0.076253f,0.084102f,0.07556f,0.033596f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.014261f,0.12916f,0.13955f,0.11926f,0.10503f,0.093775f,0.084808f,0.077346f,0.070604f,0.069321f,0.070582f,0.077358f,0.084794f,0.093753f,0.075931f,0.022632f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038514f,0.1552f,0.14297f,0.1218f,0.10693f,0.095393f,0.086706f,0.07943f,0.080737f,0.076253f,0.077346f,0.079405f,0.086729f,0.095409f,0.10117f,0.049467f,0.0036134f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.058048f,0.17483f,0.14861f,0.12579f,0.10998f,0.097788f,0.089359f,0.089097f,0.087417f,0.084102f,0.084808f,0.086706f,0.08933f,0.097805f,0.10998f,0.077089f,0.011794f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.071419f,0.19253f,0.15464f,0.13006f,0.11445f,0.10212f,0.099732f,0.099575f,0.095981f,0.092991f,0.093775f,0.095393f,0.097788f,0.10209f,0.11448f,0.099949f,0.023088f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11435f,0.21041f,0.1659f,0.13785f,0.11915f,0.11625f,0.11371f,0.11084f,0.10702f,0.10398f,0.10503f,0.10693f,0.10998f,0.11445f,0.11911f,0.11118f,0.027832f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.18086f,0.2363f,0.17883f,0.14664f,0.1396f,0.13365f,0.13131f,0.12555f,0.12116f,0.11915f,0.11926f,0.1218f,0.12579f,0.13006f,0.13692f,0.11911f,0.030429f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23352f,0.24639f,0.19721f,0.18077f,0.16971f,0.16031f,0.1543f,0.14685f,0.14146f,0.13949f,0.13955f,0.14297f,0.14861f,0.15434f,0.13673f,0.078648f,0.026399f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27289f,0.24865f,0.25106f,0.25367f,0.22252f,0.20963f,0.19413f,0.18296f,0.17546f,0.1733f,0.17338f,0.17876f,0.18178f,0.14595f,0.076245f,0.015871f,0.0040112f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.30021f,0.32498f,0.3443f,0.35599f,0.35981f,0.33985f,0.29503f,0.26573f,0.2515f,0.24865f,0.23845f,0.19813f,0.10702f,0.030939f,0.0034849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {2.4828e-016f,0.17101f,0.3525f,0.55456f,0.77038f,1.000000f,0.83276f,0.64125f,0.44064f,0.22461f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,-6.1001e-019f,0.0077516f,0.021737f,0.027281f,0.010076f,0.000000f,0.000000f,0.000000f,0.010015f,0.027391f,0.021645f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013903f,0.040513f,0.067907f,0.076689f,0.07181f,0.027665f,0.000000f,0.02757f,0.071899f,0.076598f,0.06778f,0.040382f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011632f,0.051224f,0.09054f,0.10408f,0.099924f,0.091143f,0.083276f,0.01435f,0.083264f,0.091147f,0.099919f,0.10402f,0.090417f,0.051065f,0.011549f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00059126f,0.038282f,0.096055f,0.11827f,0.1097f,0.09921f,0.089951f,0.081773f,0.077286f,0.08175f,0.089925f,0.099183f,0.10967f,0.11828f,0.096188f,0.038438f,0.00060016f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.01248f,0.080258f,0.12698f,0.12377f,0.11063f,0.099919f,0.091147f,0.083264f,0.08478f,0.083287f,0.091143f,0.099924f,0.11064f,0.12378f,0.12691f,0.08005f,0.012387f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030154f,0.11522f,0.14136f,0.12612f,0.11241f,0.10221f,0.093672f,0.091143f,0.093258f,0.091147f,0.093698f,0.1022f,0.11241f,0.12612f,0.14133f,0.11502f,0.030007f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.049131f,0.13948f,0.14824f,0.12979f,0.11534f,0.10538f,0.1022f,0.10109f,0.10286f,0.10108f,0.10221f,0.10541f,0.11534f,0.12977f,0.14823f,0.13934f,0.048933f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.065091f,0.15926f,0.15331f,0.13492f,0.12044f,0.11534f,0.11241f,0.11263f,0.11373f,0.11261f,0.11241f,0.11534f,0.12047f,0.13491f,0.15331f,0.15913f,0.064857f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.081035f,0.17365f,0.16259f,0.14051f,0.13491f,0.12977f,0.12698f,0.12647f,0.12717f,0.12645f,0.12697f,0.12979f,0.13492f,0.14055f,0.16259f,0.17352f,0.080771f,0.000000f,0.000000f},
   {0.000000f,0.0021284f,0.075079f,0.18761f,0.17293f,0.16259f,0.15331f,0.14823f,0.14518f,0.14394f,0.14572f,0.14393f,0.14517f,0.14824f,0.15331f,0.16259f,0.17298f,0.18747f,0.074803f,0.0020664f,0.000000f},
   {0.000000f,0.014056f,0.1126f,0.19956f,0.20877f,0.19549f,0.18234f,0.17613f,0.17128f,0.16888f,0.17059f,0.16887f,0.17129f,0.17611f,0.18235f,0.1955f,0.20873f,0.19976f,0.11227f,0.013912f,0.000000f},
   {0.000000f,0.033725f,0.15181f,0.19047f,0.22622f,0.24792f,0.23665f,0.22305f,0.21469f,0.2101f,0.21195f,0.21008f,0.21465f,0.22305f,0.23666f,0.24781f,0.22597f,0.19014f,0.15229f,0.033499f,0.000000f},
   {0.000000f,0.057662f,0.088781f,0.13136f,0.1876f,0.25386f,0.31647f,0.33396f,0.31272f,0.30169f,0.3041f,0.30166f,0.31272f,0.33384f,0.31619f,0.25335f,0.1871f,0.13094f,0.088435f,0.057961f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.1102e-016f,0.18322f,0.38445f,0.58627f,0.79404f,1.000000f,0.79277f,0.58496f,0.3831f,0.18186f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_rcf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.0043301f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.039295f,0.054543f,0.034375f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.070283f,0.084996f,0.088683f,0.081353f,0.05387f,0.012407f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.004605f,0.0048829f,0.000000f,0.019285f,0.07488f,0.079354f,0.086605f,0.095287f,0.10415f,0.098408f,0.058689f,0.0041976f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.024282f,0.048387f,0.058978f,0.041588f,0.055116f,0.070537f,0.077259f,0.08469f,0.093649f,0.10487f,0.11747f,0.10642f,0.036985f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0030669f,0.03345f,0.075417f,0.084016f,0.076175f,0.06925f,0.063133f,0.069255f,0.07618f,0.084023f,0.092903f,0.10388f,0.11903f,0.13076f,0.085668f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022737f,0.076046f,0.093649f,0.08469f,0.077259f,0.070537f,0.069255f,0.070537f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.12874f,0.013988f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.003656f,0.049623f,0.10114f,0.095287f,0.086605f,0.079355f,0.077251f,0.07618f,0.080638f,0.079354f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.1548f,0.038068f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011882f,0.077277f,0.10984f,0.097664f,0.089274f,0.0866f,0.084699f,0.084022f,0.087318f,0.088959f,0.089273f,0.097669f,0.10986f,0.12564f,0.1484f,0.1745f,0.057469f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023206f,0.10005f,0.11432f,0.10203f,0.097669f,0.095276f,0.093632f,0.092902f,0.095882f,0.099453f,0.099577f,0.10203f,0.11431f,0.1299f,0.15445f,0.1922f,0.070758f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027969f,0.11126f,0.11903f,0.11431f,0.10986f,0.1068f,0.10488f,0.10388f,0.1069f,0.11069f,0.11353f,0.11606f,0.11903f,0.13768f,0.1657f,0.21001f,0.11341f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030577f,0.1189f,0.13679f,0.1299f,0.12564f,0.12164f,0.11911f,0.11903f,0.12102f,0.1254f,0.13115f,0.13344f,0.13938f,0.1465f,0.17861f,0.23588f,0.17995f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026205f,0.078886f,0.13684f,0.15418f,0.1484f,0.14282f,0.13935f,0.13935f,0.1413f,0.14664f,0.15413f,0.16007f,0.16947f,0.18049f,0.19702f,0.24599f,0.23269f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040704f,0.016004f,0.076496f,0.14617f,0.1817f,0.17849f,0.17313f,0.17314f,0.17526f,0.18277f,0.1939f,0.20938f,0.22225f,0.25327f,0.25072f,0.24841f,0.27214f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0035468f,0.031188f,0.10737f,0.19838f,0.23832f,0.24841f,0.25121f,0.26542f,0.2947f,0.33937f,0.35937f,0.35542f,0.34365f,0.32425f,0.30027f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22597f,0.44198f,0.64256f,0.83403f,1.000000f,0.7669f,0.55102f,0.34893f,0.16743f,0.000000f}};

static float map_16point1_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031891f,0.0054514f,0.0062247f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013174f,0.017687f,0.041859f,0.06067f,0.072899f,0.042466f,0.0079947f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003925f,0.040182f,0.071028f,0.079333f,0.082923f,0.091873f,0.091044f,0.054336f,0.0026644f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.036005f,0.068709f,0.070277f,0.072557f,0.079348f,0.089301f,0.10193f,0.10231f,0.040017f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017407f,0.060499f,0.062673f,0.064496f,0.070291f,0.077297f,0.086764f,0.098677f,0.11609f,0.10303f,0.005855f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.000000f,0.056286f,0.057329f,0.062673f,0.068709f,0.076104f,0.085107f,0.096622f,0.1132f,0.1352f,0.046879f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039229f,0.03598f,0.06051f,0.056286f,0.051311f,0.056286f,0.061915f,0.068289f,0.075506f,0.08443f,0.096742f,0.11326f,0.14072f,0.10645f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.040421f,0.068709f,0.062673f,0.057312f,0.056287f,0.060432f,0.062673f,0.068709f,0.076125f,0.085123f,0.096621f,0.11322f,0.14066f,0.16153f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017887f,0.071132f,0.070291f,0.064476f,0.062673f,0.061916f,0.062673f,0.067986f,0.071744f,0.077297f,0.086748f,0.098677f,0.11606f,0.14511f,0.19371f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,8.626e-019f,0.042164f,0.079348f,0.072536f,0.070277f,0.068709f,0.068289f,0.068709f,0.071771f,0.076484f,0.081735f,0.090425f,0.10193f,0.12057f,0.15206f,0.22155f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.060953f,0.082898f,0.079333f,0.077297f,0.076125f,0.075507f,0.076104f,0.077297f,0.081765f,0.087411f,0.096063f,0.10762f,0.12656f,0.16273f,0.25543f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.005581f,0.072826f,0.091909f,0.089276f,0.086748f,0.085123f,0.08443f,0.085107f,0.086764f,0.090467f,0.096098f,0.10198f,0.11619f,0.13799f,0.17806f,0.28196f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.006186f,0.042808f,0.091228f,0.10193f,0.098677f,0.096621f,0.096743f,0.096622f,0.098677f,0.10193f,0.10766f,0.11623f,0.12551f,0.15094f,0.20789f,0.28698f,0.23903f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0081504f,0.054743f,0.10257f,0.11606f,0.11322f,0.11326f,0.1132f,0.11609f,0.12055f,0.12661f,0.13801f,0.15099f,0.16879f,0.21045f,0.29061f,0.4584f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0027588f,0.040396f,0.10346f,0.13537f,0.14072f,0.14064f,0.14507f,0.15206f,0.16273f,0.17804f,0.20797f,0.21045f,0.21283f,0.29354f,0.65936f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0060181f,0.047382f,0.10632f,0.16195f,0.194f,0.22178f,0.25576f,0.28205f,0.28709f,0.29071f,0.29364f,0.29667f,0.83624f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,1.5699e-016f,0.24261f,0.46196f,0.66287f,0.83976f,1.000000f}};

static float map_16point1_lsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,1.4883e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040704f,0.026172f,0.030577f,0.027969f,0.023206f,0.011882f,0.003656f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.016004f,0.078886f,0.11885f,0.11126f,0.10005f,0.077277f,0.049623f,0.022737f,0.0030466f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0035468f,0.076496f,0.13684f,0.13679f,0.11897f,0.11432f,0.10984f,0.10114f,0.076046f,0.033501f,0.0046306f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.031188f,0.14617f,0.15418f,0.1299f,0.11431f,0.10197f,0.097664f,0.095287f,0.093649f,0.075427f,0.024282f,0.00073159f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10737f,0.1817f,0.1484f,0.12564f,0.10986f,0.097669f,0.089224f,0.086605f,0.08469f,0.083965f,0.048387f,0.004605f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19838f,0.17849f,0.14282f,0.12164f,0.1068f,0.095276f,0.0866f,0.07931f,0.077259f,0.076129f,0.058978f,0.0048965f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23832f,0.17313f,0.13935f,0.11911f,0.10488f,0.093632f,0.084699f,0.077251f,0.070498f,0.069208f,0.041647f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.3692e-016f,0.24833f,0.17308f,0.13931f,0.11899f,0.10385f,0.092873f,0.083996f,0.076156f,0.069233f,0.063102f,0.05511f,0.019286f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.22597f,0.25121f,0.17526f,0.1413f,0.12102f,0.1069f,0.095882f,0.087318f,0.080638f,0.070515f,0.069221f,0.070532f,0.07488f,0.032609f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44198f,0.26542f,0.18277f,0.14664f,0.1254f,0.11069f,0.099453f,0.088959f,0.07933f,0.077251f,0.076144f,0.077259f,0.079348f,0.070283f,0.013958f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.64256f,0.2947f,0.1939f,0.15413f,0.13115f,0.11353f,0.099577f,0.089246f,0.0866f,0.084699f,0.083982f,0.08469f,0.086605f,0.085004f,0.039295f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83403f,0.33937f,0.20938f,0.16007f,0.13344f,0.11606f,0.102f,0.097669f,0.095276f,0.093632f,0.092858f,0.093649f,0.095287f,0.088683f,0.054552f,0.0013532f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.35937f,0.22225f,0.16947f,0.13938f,0.11899f,0.11431f,0.10986f,0.1068f,0.10488f,0.10383f,0.10487f,0.10415f,0.081353f,0.034375f,0.0043588f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.7669f,0.35542f,0.25327f,0.18049f,0.14646f,0.13768f,0.1299f,0.12564f,0.12164f,0.11911f,0.11897f,0.11747f,0.098408f,0.05387f,0.012211f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55102f,0.34365f,0.25072f,0.19696f,0.17861f,0.1657f,0.15445f,0.1484f,0.14282f,0.13935f,0.13074f,0.10642f,0.058689f,0.012407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.34893f,0.32425f,0.24834f,0.24599f,0.23588f,0.21001f,0.1922f,0.1745f,0.1548f,0.12874f,0.085642f,0.036985f,0.0041976f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.16741f,0.30017f,0.27214f,0.23269f,0.17995f,0.11341f,0.070758f,0.057469f,0.038068f,0.013988f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_rsf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0036134f,0.011794f,0.023088f,0.027832f,0.030429f,0.026399f,0.0040112f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0031126f,0.022632f,0.049467f,0.077089f,0.099949f,0.11118f,0.11911f,0.078648f,0.015871f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045869f,0.033596f,0.075931f,0.10117f,0.10998f,0.11448f,0.11916f,0.13692f,0.13673f,0.076245f,0.0034849f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00071455f,0.024189f,0.075553f,0.093753f,0.095409f,0.097805f,0.10214f,0.11445f,0.13006f,0.15434f,0.14595f,0.030939f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045638f,0.04826f,0.084116f,0.084794f,0.086729f,0.089374f,0.097788f,0.10998f,0.12579f,0.14861f,0.18178f,0.10702f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0049397f,0.058905f,0.076265f,0.077358f,0.079443f,0.086706f,0.095393f,0.10693f,0.1218f,0.14297f,0.17876f,0.19813f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041705f,0.069332f,0.070616f,0.077346f,0.084808f,0.093775f,0.10503f,0.11926f,0.13955f,0.17338f,0.23845f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.128e-019f,0.019251f,0.055118f,0.063203f,0.069332f,0.076265f,0.084116f,0.093006f,0.104f,0.11916f,0.13951f,0.17333f,0.24869f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,2.262e-005f,0.032844f,0.075002f,0.070621f,0.069332f,0.070599f,0.080737f,0.087417f,0.095981f,0.10702f,0.12116f,0.14146f,0.17546f,0.2515f,0.22461f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014122f,0.070466f,0.079449f,0.077358f,0.076265f,0.077346f,0.079424f,0.089097f,0.099575f,0.11084f,0.12555f,0.14685f,0.18296f,0.26573f,0.44064f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.039567f,0.085048f,0.086729f,0.084794f,0.084116f,0.084808f,0.086706f,0.089352f,0.099732f,0.11371f,0.13131f,0.1543f,0.19413f,0.29503f,0.64125f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0014071f,0.054512f,0.088881f,0.095409f,0.093753f,0.093007f,0.093775f,0.095393f,0.097788f,0.10212f,0.11625f,0.13365f,0.16031f,0.20963f,0.33985f,0.83276f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043373f,0.034659f,0.08163f,0.10433f,0.105f,0.104f,0.10503f,0.10693f,0.10998f,0.11445f,0.11914f,0.1396f,0.16971f,0.22252f,0.35981f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012393f,0.054219f,0.098665f,0.11764f,0.11916f,0.11926f,0.1218f,0.12579f,0.13006f,0.13785f,0.14663f,0.18077f,0.25367f,0.35599f,0.77038f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012593f,0.059121f,0.10673f,0.13084f,0.13955f,0.14297f,0.14861f,0.15464f,0.1659f,0.17883f,0.19719f,0.25106f,0.3443f,0.55456f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043097f,0.037335f,0.085557f,0.12916f,0.1552f,0.17483f,0.19253f,0.21041f,0.2363f,0.24639f,0.24863f,0.32498f,0.3525f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.6987e-018f,0.014261f,0.038514f,0.058048f,0.071419f,0.11435f,0.18086f,0.23352f,0.27289f,0.30018f,0.171f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-2.4828e-016f}};

static float map_16point1_lsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.057837f,0.033725f,0.014056f,0.0021284f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.088781f,0.15197f,0.1126f,0.075079f,0.081035f,0.065091f,0.049131f,0.030154f,0.01248f,0.00065038f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13136f,0.19047f,0.19972f,0.18761f,0.17365f,0.15926f,0.13948f,0.11522f,0.080258f,0.038352f,0.011632f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.1876f,0.22622f,0.20877f,0.17308f,0.16259f,0.15331f,0.14824f,0.14136f,0.12698f,0.096228f,0.051224f,0.013903f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25386f,0.24792f,0.19549f,0.16259f,0.14063f,0.13492f,0.12979f,0.12612f,0.12377f,0.11836f,0.09054f,0.040513f,0.0077516f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.18322f,0.31647f,0.23665f,0.18234f,0.15331f,0.13491f,0.12054f,0.11534f,0.11241f,0.11063f,0.10978f,0.10408f,0.067907f,0.021737f,0.00081869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.38445f,0.33396f,0.22305f,0.17613f,0.14823f,0.12977f,0.11534f,0.10547f,0.10221f,0.099919f,0.099291f,0.099924f,0.076689f,0.027385f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.58627f,0.31272f,0.21469f,0.17128f,0.14518f,0.12698f,0.11241f,0.1022f,0.093751f,0.091147f,0.090023f,0.091143f,0.07194f,0.010076f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.79404f,0.30169f,0.2101f,0.16888f,0.14394f,0.12647f,0.11263f,0.10109f,0.091143f,0.083334f,0.081839f,0.083344f,0.027665f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.30431f,0.2121f,0.17071f,0.14582f,0.12726f,0.11381f,0.10293f,0.093322f,0.084838f,0.074566f,0.014386f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.79277f,0.30166f,0.21008f,0.16887f,0.14393f,0.12645f,0.11261f,0.10108f,0.091147f,0.083312f,0.081796f,0.083334f,0.02757f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.58496f,0.31272f,0.21465f,0.17129f,0.14517f,0.12697f,0.11241f,0.10221f,0.093725f,0.091143f,0.089976f,0.091147f,0.071938f,0.010015f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3831f,0.33384f,0.22305f,0.17611f,0.14824f,0.12979f,0.11534f,0.10544f,0.1022f,0.099924f,0.099238f,0.099919f,0.076598f,0.027407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.18186f,0.31619f,0.23666f,0.18235f,0.15331f,0.13492f,0.1205f,0.11534f,0.11241f,0.11064f,0.10973f,0.10402f,0.06778f,0.021645f,0.00081784f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25335f,0.24781f,0.1955f,0.16259f,0.14059f,0.13491f,0.12977f,0.12612f,0.12378f,0.11834f,0.090417f,0.040382f,0.0076928f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.1871f,0.22597f,0.20873f,0.17303f,0.16259f,0.15331f,0.14823f,0.14133f,0.12691f,0.096247f,0.051065f,0.013816f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.13094f,0.19014f,0.19982f,0.18747f,0.17352f,0.15913f,0.13934f,0.11502f,0.08005f,0.038463f,0.011549f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.088435f,0.15238f,0.11227f,0.074803f,0.080771f,0.064857f,0.048933f,0.030007f,0.012387f,0.00062972f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.05808f,0.033499f,0.013912f,0.0020664f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_rsm[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0020664f,0.013912f,0.033499f,0.058195f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062972f,0.012387f,0.030007f,0.048933f,0.064857f,0.080771f,0.074803f,0.11227f,0.15246f,0.088435f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.011549f,0.038509f,0.08005f,0.11502f,0.13934f,0.15913f,0.17352f,0.18747f,0.19989f,0.19014f,0.13094f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013816f,0.051065f,0.096286f,0.12691f,0.14133f,0.14823f,0.15331f,0.16259f,0.17308f,0.20873f,0.22597f,0.1871f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0076928f,0.040382f,0.090417f,0.11837f,0.12378f,0.12612f,0.12977f,0.13491f,0.14063f,0.16259f,0.1955f,0.24781f,0.25335f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00081784f,0.021645f,0.06778f,0.10402f,0.10977f,0.11064f,0.11241f,0.11534f,0.12054f,0.13492f,0.15331f,0.18235f,0.23666f,0.31619f,0.18186f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027451f,0.076598f,0.099919f,0.099281f,0.099924f,0.1022f,0.10547f,0.11534f,0.12979f,0.14824f,0.17611f,0.22305f,0.33384f,0.3831f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010015f,0.071952f,0.091147f,0.090014f,0.091143f,0.093752f,0.10221f,0.11241f,0.12697f,0.14517f,0.17129f,0.21465f,0.31272f,0.58496f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.02757f,0.083335f,0.081831f,0.083335f,0.091147f,0.10108f,0.11261f,0.12645f,0.14393f,0.16887f,0.21008f,0.30166f,0.79277f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.014385f,0.074587f,0.084862f,0.093348f,0.10296f,0.11384f,0.12729f,0.14586f,0.17076f,0.21215f,0.30439f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027665f,0.083335f,0.08182f,0.083335f,0.091143f,0.10109f,0.11263f,0.12647f,0.14394f,0.16888f,0.2101f,0.30169f,0.79404f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.010076f,0.071837f,0.091143f,0.090002f,0.091147f,0.093752f,0.1022f,0.11241f,0.12698f,0.14518f,0.17128f,0.21469f,0.31272f,0.58627f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.027311f,0.076689f,0.099924f,0.099267f,0.099919f,0.10221f,0.10547f,0.11534f,0.12977f,0.14823f,0.17613f,0.22305f,0.33396f,0.38445f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080127f,0.021737f,0.067907f,0.10408f,0.10976f,0.11063f,0.11241f,0.11534f,0.12054f,0.13491f,0.15331f,0.18234f,0.23665f,0.31647f,0.18322f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0077516f,0.040513f,0.09054f,0.11831f,0.12377f,0.12612f,0.12979f,0.13492f,0.14063f,0.16259f,0.19549f,0.24792f,0.25386f,-2.2204e-016f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.22e-018f,0.013903f,0.051224f,0.096055f,0.12698f,0.14136f,0.14824f,0.15331f,0.16259f,0.17308f,0.20877f,0.22622f,0.1876f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.011632f,0.038283f,0.080258f,0.11522f,0.13948f,0.15926f,0.17365f,0.18761f,0.19965f,0.19047f,0.13136f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00062082f,0.01248f,0.030154f,0.049131f,0.065091f,0.081035f,0.075079f,0.1126f,0.15189f,0.088781f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0021284f,0.014056f,0.033725f,0.05778f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_lsb[21][21] = {
   {2.4828e-016f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17101f,0.3002f,0.27289f,0.23302f,0.18086f,0.11435f,0.071419f,0.058048f,0.038514f,0.013902f,2.6987e-018f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.3511f,0.3244f,0.24861f,0.24639f,0.23594f,0.21041f,0.19253f,0.17483f,0.1552f,0.12916f,0.08561f,0.037085f,0.0043097f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.55452f,0.3443f,0.25064f,0.19717f,0.17883f,0.1659f,0.15438f,0.14861f,0.14297f,0.13955f,0.13083f,0.10653f,0.059121f,0.012378f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.77038f,0.35549f,0.25367f,0.18047f,0.14661f,0.13765f,0.13006f,0.12579f,0.1218f,0.11926f,0.11904f,0.11764f,0.098665f,0.054219f,0.012206f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.35981f,0.22252f,0.16971f,0.1396f,0.11912f,0.11445f,0.10998f,0.10677f,0.10488f,0.10389f,0.105f,0.10433f,0.08163f,0.034493f,0.0043086f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83276f,0.33985f,0.20963f,0.16005f,0.13346f,0.11608f,0.10211f,0.097647f,0.095393f,0.093775f,0.092909f,0.093753f,0.095409f,0.088881f,0.054543f,0.0014071f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.64125f,0.29503f,0.19413f,0.15408f,0.13131f,0.11371f,0.099732f,0.089343f,0.086706f,0.084808f,0.084028f,0.084794f,0.086604f,0.085015f,0.039425f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.44064f,0.26573f,0.18296f,0.14685f,0.12555f,0.11084f,0.099575f,0.088972f,0.079416f,0.077346f,0.076185f,0.077358f,0.079366f,0.070466f,0.014122f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.22461f,0.2515f,0.17521f,0.14126f,0.12116f,0.10702f,0.095981f,0.087417f,0.080737f,0.070592f,0.06926f,0.070547f,0.075002f,0.032844f,2.262e-005f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.24865f,0.1733f,0.13949f,0.11914f,0.10398f,0.09299f,0.084101f,0.076252f,0.06932f,0.063198f,0.055167f,0.019305f,9.128e-019f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.23845f,0.17338f,0.13955f,0.11926f,0.10488f,0.093775f,0.084808f,0.077346f,0.070615f,0.069326f,0.041681f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19813f,0.17876f,0.14297f,0.1218f,0.10677f,0.095393f,0.086706f,0.079442f,0.077358f,0.076259f,0.058905f,0.0049261f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10702f,0.18178f,0.14861f,0.12579f,0.10998f,0.097647f,0.089373f,0.086604f,0.084794f,0.084109f,0.04826f,0.0045638f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.030939f,0.14595f,0.15412f,0.13006f,0.11445f,0.10214f,0.097805f,0.095409f,0.093753f,0.075568f,0.024189f,0.00071455f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0034849f,0.076245f,0.13673f,0.13678f,0.11916f,0.11432f,0.10998f,0.10117f,0.075931f,0.033596f,0.0045869f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.015871f,0.078648f,0.11911f,0.11118f,0.099949f,0.077089f,0.049467f,0.022632f,0.0031126f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0040112f,0.026399f,0.030429f,0.027832f,0.023088f,0.011794f,0.0036134f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_rsb[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013988f,0.038068f,0.057469f,0.070758f,0.11341f,0.17995f,0.23269f,0.27214f,0.30022f,0.16743f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0041976f,0.036985f,0.085724f,0.12874f,0.1548f,0.1745f,0.1922f,0.21001f,0.23588f,0.24599f,0.24837f,0.32425f,0.34893f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012407f,0.058689f,0.10642f,0.13076f,0.13935f,0.14282f,0.1484f,0.15445f,0.1657f,0.17861f,0.19698f,0.25072f,0.34365f,0.55098f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.012211f,0.05387f,0.098408f,0.11747f,0.11899f,0.11911f,0.12164f,0.12564f,0.1299f,0.13768f,0.14648f,0.18049f,0.25327f,0.35542f,0.7669f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043588f,0.034375f,0.081353f,0.10415f,0.10487f,0.10385f,0.10488f,0.1068f,0.10986f,0.11431f,0.11901f,0.13938f,0.16947f,0.22225f,0.35937f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013532f,0.054576f,0.088683f,0.095287f,0.093649f,0.092871f,0.093632f,0.095276f,0.097669f,0.10201f,0.11606f,0.13344f,0.16007f,0.20938f,0.33937f,0.83403f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.039295f,0.084981f,0.086605f,0.08469f,0.083994f,0.084699f,0.0866f,0.089259f,0.099577f,0.11353f,0.13115f,0.15413f,0.1939f,0.2947f,0.64256f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.013958f,0.070283f,0.079341f,0.077259f,0.076154f,0.077251f,0.079341f,0.088959f,0.099453f,0.11069f,0.1254f,0.14664f,0.18277f,0.26542f,0.44198f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.032609f,0.07488f,0.070525f,0.069231f,0.070525f,0.080638f,0.087318f,0.095882f,0.1069f,0.12102f,0.1413f,0.17526f,0.25121f,0.22597f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.019304f,0.055126f,0.063107f,0.069231f,0.076154f,0.083994f,0.092871f,0.10385f,0.11899f,0.13931f,0.17308f,0.24833f,-1.3692e-016f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041554f,0.069226f,0.070525f,0.077251f,0.084699f,0.093632f,0.10488f,0.11911f,0.13935f,0.17313f,0.23832f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0048829f,0.058978f,0.076149f,0.077259f,0.079341f,0.0866f,0.095276f,0.1068f,0.12164f,0.14282f,0.17849f,0.19838f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.004605f,0.048387f,0.083988f,0.08469f,0.086605f,0.089259f,0.097669f,0.10986f,0.12564f,0.1484f,0.1817f,0.10737f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00073159f,0.024282f,0.075363f,0.093649f,0.095287f,0.097664f,0.10201f,0.11431f,0.1299f,0.15418f,0.14617f,0.031188f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0046306f,0.033399f,0.076046f,0.10114f,0.10984f,0.11432f,0.11901f,0.13679f,0.13684f,0.076496f,0.0035468f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0030466f,0.022737f,0.049623f,0.077277f,0.10005f,0.11126f,0.11884f,0.078886f,0.016004f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003656f,0.011882f,0.023206f,0.027969f,0.030577f,0.026172f,0.0040704f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-1.4883e-018f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_ls[21][21] = {
   {1.000000f,0.83976f,0.66287f,0.46196f,0.24261f,-7.8496e-016f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.8363f,0.2965f,0.29364f,0.2912f,0.28709f,0.28205f,0.25576f,0.22178f,0.194f,0.1623f,0.10667f,0.047382f,0.0060181f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.66065f,0.2941f,0.21271f,0.21045f,0.20831f,0.17804f,0.16273f,0.15206f,0.14507f,0.14064f,0.14088f,0.13561f,0.10346f,0.040396f,0.0027588f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.45837f,0.29061f,0.21085f,0.1687f,0.15099f,0.13801f,0.12686f,0.12055f,0.11609f,0.1132f,0.11339f,0.11341f,0.11606f,0.10278f,0.054743f,0.0081504f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.23903f,0.28746f,0.20789f,0.15123f,0.12544f,0.11643f,0.10766f,0.10193f,0.098677f,0.096622f,0.096854f,0.096621f,0.098677f,0.10193f,0.091409f,0.042808f,0.0062213f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.28196f,0.17806f,0.13799f,0.11619f,0.10192f,0.096098f,0.090467f,0.086913f,0.085253f,0.084527f,0.085123f,0.086748f,0.089276f,0.092069f,0.073051f,0.005581f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.25543f,0.16273f,0.12682f,0.1078f,0.096222f,0.087361f,0.081901f,0.077297f,0.076104f,0.075593f,0.076125f,0.077297f,0.079333f,0.083018f,0.060953f,0.003291f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.22155f,0.15206f,0.12078f,0.10193f,0.090425f,0.081735f,0.076441f,0.071771f,0.068709f,0.068368f,0.068709f,0.070398f,0.07264f,0.079485f,0.042164f,-4.313e-018f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.19371f,0.14511f,0.11606f,0.098677f,0.086748f,0.077297f,0.071865f,0.067948f,0.062673f,0.061987f,0.062673f,0.064569f,0.070291f,0.071132f,0.017887f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.16153f,0.1409f,0.11341f,0.096621f,0.085123f,0.076125f,0.068709f,0.062673f,0.060398f,0.056351f,0.057395f,0.062673f,0.068709f,0.040421f,0.0013668f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.10645f,0.14068f,0.11323f,0.096714f,0.084405f,0.075484f,0.068269f,0.061897f,0.05627f,0.05131f,0.056318f,0.060545f,0.036079f,0.0039229f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.046879f,0.1352f,0.1132f,0.096622f,0.085253f,0.076104f,0.068709f,0.062673f,0.057295f,0.056286f,0.000000f,0.0017892f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.005855f,0.10303f,0.11609f,0.098677f,0.086913f,0.077297f,0.070291f,0.064457f,0.062673f,0.060517f,0.0017407f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.040017f,0.10231f,0.10193f,0.089301f,0.079485f,0.072514f,0.070398f,0.068709f,0.036025f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0026644f,0.054553f,0.091044f,0.091873f,0.082874f,0.079333f,0.071028f,0.040182f,0.003925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0079947f,0.042595f,0.07287f,0.060829f,0.041859f,0.017687f,0.0013174f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0062247f,0.0054514f,0.0031891f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_lcs[21][21] = {
   {0.000000f,0.16743f,0.34893f,0.55102f,0.7669f,1.000000f,0.8304f,0.64256f,0.43815f,0.22209f,0.0039027f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.3003f,0.32425f,0.34246f,0.35542f,0.35937f,0.33937f,0.2947f,0.26542f,0.25007f,0.24823f,0.23832f,0.19838f,0.10737f,0.031188f,0.0035468f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.27153f,0.24847f,0.25072f,0.25221f,0.22225f,0.20938f,0.1939f,0.18277f,0.17526f,0.17301f,0.17239f,0.17849f,0.1817f,0.14617f,0.076496f,0.016004f,0.0039009f,4.242e-005f,0.000000f,0.000000f},
   {0.000000f,0.23269f,0.24505f,0.19707f,0.18049f,0.16947f,0.1594f,0.15413f,0.14664f,0.1413f,0.13925f,0.13875f,0.14282f,0.14776f,0.15349f,0.13684f,0.078203f,0.026271f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.17979f,0.23588f,0.17782f,0.14654f,0.13879f,0.13344f,0.13115f,0.1254f,0.12102f,0.11894f,0.11911f,0.12164f,0.12564f,0.12932f,0.13679f,0.11897f,0.030577f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.11341f,0.21001f,0.1657f,0.13768f,0.11906f,0.11606f,0.11353f,0.11021f,0.10642f,0.1038f,0.10488f,0.1068f,0.10986f,0.1138f,0.11891f,0.11067f,0.027969f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.070758f,0.1922f,0.15376f,0.12932f,0.1138f,0.10205f,0.099158f,0.099453f,0.095882f,0.092833f,0.093632f,0.095276f,0.097669f,0.10193f,0.11432f,0.10005f,0.022867f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.057469f,0.1745f,0.14776f,0.12564f,0.10986f,0.097669f,0.089296f,0.088959f,0.087318f,0.083959f,0.084699f,0.086215f,0.089185f,0.097246f,0.10984f,0.077277f,0.011882f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.038068f,0.1548f,0.14282f,0.12164f,0.1068f,0.095276f,0.086215f,0.079374f,0.080638f,0.076123f,0.077251f,0.079276f,0.086605f,0.095287f,0.10068f,0.049623f,0.003656f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.013988f,0.1285f,0.13875f,0.11911f,0.10488f,0.093632f,0.084699f,0.077251f,0.070555f,0.069203f,0.070467f,0.077259f,0.08469f,0.093649f,0.075581f,0.022737f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.08571f,0.13081f,0.1191f,0.10394f,0.092957f,0.084072f,0.076225f,0.069295f,0.063149f,0.069202f,0.076123f,0.083959f,0.075464f,0.033519f,0.003067f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.036985f,0.10642f,0.11747f,0.10441f,0.093649f,0.08469f,0.077259f,0.070572f,0.055109f,0.041636f,0.058978f,0.048387f,0.024282f,0.0046306f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.0041976f,0.058689f,0.098408f,0.10378f,0.095287f,0.086605f,0.079393f,0.07488f,0.019285f,0.000000f,0.00491f,0.0044871f,0.00073159f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.012407f,0.05387f,0.081353f,0.08843f,0.085024f,0.070118f,0.032609f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.012211f,0.034375f,0.054592f,0.039295f,0.013958f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0043588f,0.0013532f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_cs[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.18575f,0.3831f,0.58872f,0.79642f,0.99651f,0.79404f,0.58627f,0.38445f,0.18322f,5.5511e-016f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.05802f,0.088435f,0.13215f,0.1871f,0.25335f,0.31619f,0.33384f,0.31272f,0.30281f,0.30399f,0.30169f,0.31272f,0.33396f,0.31647f,0.25386f,0.1876f,0.13136f,0.088781f,0.057662f,0.000000f},
   {0.000000f,0.034146f,0.1523f,0.19014f,0.22703f,0.24781f,0.23666f,0.22305f,0.21465f,0.21008f,0.21187f,0.21084f,0.21469f,0.22305f,0.23665f,0.24792f,0.22622f,0.19063f,0.15181f,0.033725f,0.000000f},
   {0.000000f,0.013912f,0.11322f,0.19976f,0.20873f,0.1955f,0.18301f,0.17611f,0.17129f,0.16887f,0.17053f,0.16948f,0.17128f,0.17676f,0.18302f,0.19549f,0.20944f,0.19952f,0.1126f,0.014056f,0.000000f},
   {0.000000f,0.0022437f,0.074803f,0.18827f,0.17294f,0.16318f,0.15331f,0.14824f,0.14517f,0.14393f,0.14566f,0.14394f,0.14518f,0.14823f,0.15388f,0.16259f,0.17286f,0.18761f,0.075079f,0.0021284f,0.000000f},
   {0.000000f,0.000000f,0.080771f,0.17352f,0.16259f,0.14051f,0.13492f,0.12979f,0.12745f,0.12694f,0.12712f,0.12647f,0.12698f,0.12977f,0.13542f,0.14045f,0.16318f,0.17365f,0.081035f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.064857f,0.15982f,0.15388f,0.13542f,0.12044f,0.11576f,0.11241f,0.11261f,0.11369f,0.11263f,0.11241f,0.11534f,0.12039f,0.13492f,0.15331f,0.15958f,0.065091f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.048933f,0.13997f,0.14823f,0.12977f,0.11534f,0.10538f,0.10221f,0.10108f,0.10282f,0.10109f,0.10259f,0.10534f,0.11576f,0.12979f,0.14824f,0.13948f,0.049131f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.030007f,0.11502f,0.14133f,0.12612f,0.11241f,0.10259f,0.093673f,0.091147f,0.093222f,0.091143f,0.093633f,0.10221f,0.11241f,0.12658f,0.14136f,0.11522f,0.030154f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.012652f,0.080647f,0.12691f,0.12378f,0.11064f,0.099924f,0.091143f,0.083265f,0.084748f,0.08323f,0.091147f,0.099919f,0.11063f,0.12424f,0.12698f,0.080258f,0.01248f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.00060016f,0.038416f,0.096151f,0.11825f,0.10964f,0.099156f,0.089902f,0.081729f,0.077299f,0.081705f,0.089875f,0.099127f,0.1096f,0.11815f,0.095997f,0.038235f,0.00059126f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011549f,0.051065f,0.090883f,0.10402f,0.099919f,0.091147f,0.083276f,0.01435f,0.08323f,0.091143f,0.099924f,0.10408f,0.09054f,0.051224f,0.011632f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.013816f,0.040757f,0.06778f,0.076598f,0.071913f,0.02757f,0.000000f,0.027665f,0.071785f,0.076798f,0.067907f,0.040513f,0.013903f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0076928f,0.021908f,0.027406f,0.010191f,0.000000f,0.000000f,0.000000f,0.010076f,0.027281f,0.021737f,0.0077516f,3.0501e-018f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00080041f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00078385f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_rcs[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.22461f,0.44064f,0.64125f,0.83276f,1.000000f,0.77038f,0.55456f,0.3525f,0.17101f,-2.4828e-016f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0034849f,0.030939f,0.10702f,0.19813f,0.23845f,0.24861f,0.2515f,0.26573f,0.29503f,0.33985f,0.35981f,0.35599f,0.3443f,0.32498f,0.30021f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0040112f,0.015871f,0.076245f,0.14595f,0.18178f,0.17876f,0.17338f,0.17327f,0.17546f,0.18296f,0.19413f,0.20963f,0.22252f,0.25367f,0.25106f,0.24861f,0.27289f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.026399f,0.078648f,0.13673f,0.15434f,0.14861f,0.14297f,0.13955f,0.13946f,0.14146f,0.14685f,0.1543f,0.16031f,0.16971f,0.18077f,0.19717f,0.24639f,0.23352f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.030429f,0.11915f,0.13692f,0.13006f,0.12579f,0.1218f,0.11926f,0.11913f,0.12116f,0.12555f,0.13131f,0.13365f,0.1396f,0.14662f,0.17883f,0.2363f,0.18086f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.027832f,0.11118f,0.11915f,0.11445f,0.10998f,0.10693f,0.10503f,0.10396f,0.10702f,0.11084f,0.11371f,0.11625f,0.11913f,0.13785f,0.1659f,0.21041f,0.11435f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.023088f,0.099949f,0.11448f,0.10212f,0.097788f,0.095393f,0.093775f,0.092976f,0.095981f,0.099575f,0.099732f,0.10211f,0.11445f,0.13006f,0.15464f,0.19253f,0.071419f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.011794f,0.077089f,0.10998f,0.097805f,0.089359f,0.086706f,0.084808f,0.084088f,0.087417f,0.089097f,0.089344f,0.097788f,0.10998f,0.12579f,0.14861f,0.17483f,0.058048f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.0036134f,0.049467f,0.10117f,0.095409f,0.086729f,0.07943f,0.077346f,0.07624f,0.080737f,0.079417f,0.086706f,0.095393f,0.10693f,0.1218f,0.14297f,0.1552f,0.038514f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.022632f,0.075931f,0.093753f,0.084794f,0.077358f,0.070604f,0.069309f,0.070593f,0.077346f,0.084808f,0.093775f,0.10503f,0.11926f,0.13955f,0.12916f,0.014261f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0031126f,0.033596f,0.07556f,0.084102f,0.076253f,0.069321f,0.063182f,0.069321f,0.076253f,0.084102f,0.092991f,0.10398f,0.11915f,0.13081f,0.0855f,-2.6987e-018f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0045869f,0.024189f,0.04826f,0.058905f,0.041715f,0.055102f,0.070593f,0.077358f,0.084794f,0.093753f,0.105f,0.11764f,0.10673f,0.037335f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.00071455f,0.0045638f,0.0049261f,0.000000f,0.019214f,0.075002f,0.079417f,0.086729f,0.095409f,0.10433f,0.098665f,0.059121f,0.0043097f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,-9.128e-019f,0.032844f,0.070466f,0.085012f,0.088881f,0.08163f,0.054219f,0.012593f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,2.262e-005f,0.014122f,0.039567f,0.054455f,0.034659f,0.012393f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0014071f,0.0043086f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_16point1_rs[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.23903f,0.4584f,0.65936f,0.8363f,1.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.005855f,0.046879f,0.10657f,0.16153f,0.19371f,0.22155f,0.25543f,0.28196f,0.28698f,0.29061f,0.29354f,0.29658f,0.83976f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0026644f,0.040017f,0.10303f,0.1352f,0.14072f,0.14066f,0.14511f,0.15206f,0.16273f,0.17806f,0.20789f,0.21045f,0.21277f,0.29364f,0.66287f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0079947f,0.054336f,0.10231f,0.11609f,0.1132f,0.11326f,0.11322f,0.11606f,0.12057f,0.12656f,0.13799f,0.15094f,0.16875f,0.21045f,0.29071f,0.46192f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0062247f,0.042466f,0.091044f,0.10193f,0.098677f,0.096622f,0.096743f,0.096621f,0.098677f,0.10193f,0.10762f,0.11619f,0.12548f,0.15099f,0.20797f,0.28709f,0.24261f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0054514f,0.072927f,0.091873f,0.089301f,0.086764f,0.085107f,0.08443f,0.085123f,0.086748f,0.090425f,0.096063f,0.10195f,0.11623f,0.13801f,0.17804f,0.28205f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.0031891f,0.06067f,0.082922f,0.079348f,0.077297f,0.076104f,0.075506f,0.076125f,0.077297f,0.081735f,0.087387f,0.096098f,0.10766f,0.12661f,0.16273f,0.25576f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.041859f,0.079333f,0.072557f,0.070291f,0.068709f,0.068289f,0.068709f,0.071744f,0.076463f,0.081765f,0.090467f,0.10193f,0.12055f,0.15206f,0.22178f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.017687f,0.071028f,0.070277f,0.064495f,0.062673f,0.061915f,0.062673f,0.067967f,0.071771f,0.077297f,0.086764f,0.098677f,0.11609f,0.14507f,0.194f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013174f,0.040182f,0.068709f,0.062673f,0.057329f,0.056287f,0.060415f,0.062673f,0.068709f,0.076104f,0.085107f,0.096622f,0.1132f,0.14064f,0.16195f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039474f,0.036045f,0.060518f,0.056287f,0.051326f,0.056287f,0.061915f,0.068289f,0.075506f,0.08443f,0.096743f,0.11326f,0.14072f,0.1062f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017407f,0.000000f,0.056303f,0.057329f,0.062673f,0.068709f,0.076125f,0.085123f,0.096621f,0.11322f,0.13537f,0.047382f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0017892f,0.06051f,0.062673f,0.064495f,0.070277f,0.077297f,0.086748f,0.098677f,0.11606f,0.10346f,0.0060181f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.03594f,0.068709f,0.070291f,0.072557f,0.079333f,0.089276f,0.10193f,0.10257f,0.040396f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0039004f,0.040421f,0.071132f,0.079348f,0.082922f,0.091909f,0.091228f,0.054743f,0.0027588f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0013668f,0.017887f,0.042164f,0.060953f,0.072797f,0.042808f,0.0081504f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.003291f,0.005581f,0.0061507f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_legacy_ang[] = {-27,0,27,-105,105};
static float map_legacy_xsf[] = {-1,0,1,-1,1};
static float map_legacy_ysf[] = {1,1,1,-1,-1};
channel_id map_legacy_id[] = {ci_front_left,ci_front_center,ci_front_right,ci_back_left,ci_back_right,ci_lfe};

static float map_legacy_lf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.052559f,0.04973f,0.046444f,0.042638f,0.038255f,0.03325f,0.027609f,0.021357f,0.014571f,0.0073897f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.11043f,0.10453f,0.097663f,0.089681f,0.080466f,0.069928f,0.058038f,0.044859f,0.030571f,0.015481f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.17379f,0.16464f,0.15393f,0.14141f,0.1269f,0.11024f,0.091419f,0.070553f,0.047977f,0.024228f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.24254f,0.23009f,0.21535f,0.19799f,0.1777f,0.1543f,0.12778f,0.098374f,0.066667f,0.03352f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.31623f,0.30059f,0.28179f,0.25935f,0.23285f,0.20203f,0.16696f,0.1281f,0.086387f,0.043173f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.39392f,0.37542f,0.35271f,0.3251f,0.292f,0.25309f,0.20858f,0.15929f,0.10674f,0.05293f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.4741f,0.45334f,0.42712f,0.39444f,0.35446f,0.30682f,0.25196f,0.19128f,0.12717f,0.062479f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.5547f,0.53253f,0.50345f,0.46602f,0.41906f,0.36214f,0.29609f,0.22322f,0.14704f,0.071497f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.63324f,0.61069f,0.57963f,0.538f,0.48415f,0.41759f,0.33971f,0.25408f,0.1657f,0.079698f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.70711f,0.68525f,0.6532f,0.60812f,0.54772f,0.4714f,0.38139f,0.28284f,0.18257f,0.086874f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.77396f,0.75372f,0.72165f,0.67398f,0.60758f,0.52174f,0.41971f,0.30863f,0.19725f,0.092925f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.83205f,0.81408f,0.78279f,0.73335f,0.66169f,0.56695f,0.45356f,0.33085f,0.20953f,0.097849f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.88047f,0.86507f,0.83508f,0.78458f,0.70851f,0.6058f,0.48218f,0.34921f,0.21943f,0.10172f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.91915f,0.90626f,0.87779f,0.82678f,0.74715f,0.63768f,0.50535f,0.36378f,0.22711f,0.10467f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.94868f,0.93803f,0.91103f,0.85983f,0.77748f,0.66259f,0.52322f,0.37484f,0.23285f,0.10684f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.97014f,0.96128f,0.93553f,0.88433f,0.8f,0.68101f,0.53632f,0.38284f,0.23694f,0.10837f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.98478f,0.97723f,0.95242f,0.9013f,0.81561f,0.69373f,0.54531f,0.38828f,0.2397f,0.10939f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.99388f,0.98718f,0.963f,0.91194f,0.82541f,0.70171f,0.55092f,0.39165f,0.2414f,0.11001f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.99862f,0.99237f,0.96853f,0.91751f,0.83055f,0.70589f,0.55385f,0.39341f,0.24228f,0.11034f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {1.000000f,0.99388f,0.97014f,0.91915f,0.83205f,0.70711f,0.5547f,0.39392f,0.24254f,0.11043f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_legacy_cf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.0055256f,0.011611f,0.018273f,0.025503f,0.03325f,0.041414f,0.049832f,0.058284f,0.066507f,0.074227f,0.066507f,0.058284f,0.049832f,0.041414f,0.03325f,0.025503f,0.018273f,0.011611f,0.0055256f,0.000000f},
   {0.000000f,0.011615f,0.024416f,0.038435f,0.053644f,0.069928f,0.087057f,0.10467f,0.12228f,0.13933f,0.15523f,0.13933f,0.12228f,0.10467f,0.087057f,0.069928f,0.053644f,0.038435f,0.024416f,0.011615f,0.000000f},
   {0.000000f,0.018294f,0.038482f,0.060606f,0.084599f,0.11024f,0.13713f,0.16462f,0.19191f,0.21805f,0.24214f,0.21805f,0.19191f,0.16462f,0.13713f,0.11024f,0.084599f,0.060606f,0.038482f,0.018294f,0.000000f},
   {0.000000f,0.025565f,0.053838f,0.084853f,0.11847f,0.1543f,0.19166f,0.22954f,0.26667f,0.30168f,0.33333f,0.30168f,0.26667f,0.22954f,0.19166f,0.1543f,0.11847f,0.084853f,0.053838f,0.025565f,0.000000f},
   {0.000000f,0.033398f,0.070447f,0.11115f,0.15523f,0.20203f,0.25044f,0.29889f,0.34555f,0.38856f,0.4264f,0.38856f,0.34555f,0.29889f,0.25044f,0.20203f,0.15523f,0.11115f,0.070447f,0.033398f,0.000000f},
   {0.000000f,0.041713f,0.088178f,0.13933f,0.19467f,0.25309f,0.31287f,0.37167f,0.42694f,0.47637f,0.51832f,0.47637f,0.42694f,0.37167f,0.31287f,0.25309f,0.19467f,0.13933f,0.088178f,0.041713f,0.000000f},
   {0.000000f,0.050371f,0.10678f,0.16904f,0.23631f,0.30682f,0.37793f,0.44633f,0.50867f,0.56231f,0.60584f,0.56231f,0.50867f,0.44633f,0.37793f,0.30682f,0.23631f,0.16904f,0.10678f,0.050371f,0.000000f},
   {0.000000f,0.05917f,0.12586f,0.19972f,0.27937f,0.36214f,0.44414f,0.52085f,0.58817f,0.64347f,0.68599f,0.64347f,0.58817f,0.52085f,0.44414f,0.36214f,0.27937f,0.19972f,0.12586f,0.05917f,0.000000f},
   {0.000000f,0.067855f,0.14491f,0.23057f,0.32277f,0.41759f,0.50957f,0.59285f,0.66281f,0.71728f,0.7566f,0.71728f,0.66281f,0.59285f,0.50957f,0.41759f,0.32277f,0.23057f,0.14491f,0.067855f,0.000000f},
   {0.000000f,0.076139f,0.1633f,0.26062f,0.36515f,0.4714f,0.57208f,0.65997f,0.7303f,0.78187f,0.8165f,0.78187f,0.7303f,0.65997f,0.57208f,0.4714f,0.36515f,0.26062f,0.1633f,0.076139f,0.000000f},
   {0.000000f,0.083747f,0.18041f,0.28885f,0.40505f,0.52174f,0.62957f,0.72015f,0.78899f,0.83633f,0.86558f,0.83633f,0.78899f,0.72015f,0.62957f,0.52174f,0.40505f,0.28885f,0.18041f,0.083747f,0.000000f},
   {0.000000f,0.090453f,0.1957f,0.31429f,0.44113f,0.56695f,0.68034f,0.77198f,0.83812f,0.88064f,0.90453f,0.88064f,0.83812f,0.77198f,0.68034f,0.56695f,0.44113f,0.31429f,0.1957f,0.090453f,0.000000f},
   {0.000000f,0.096118f,0.20877f,0.33625f,0.47234f,0.6058f,0.72328f,0.81483f,0.87771f,0.9155f,0.93455f,0.9155f,0.87771f,0.81483f,0.72328f,0.6058f,0.47234f,0.33625f,0.20877f,0.096118f,0.000000f},
   {0.000000f,0.1007f,0.21945f,0.35433f,0.4981f,0.63768f,0.75802f,0.84881f,0.90844f,0.94203f,0.95702f,0.94203f,0.90844f,0.84881f,0.75802f,0.63768f,0.4981f,0.35433f,0.21945f,0.1007f,0.000000f},
   {0.000000f,0.10423f,0.22776f,0.3685f,0.51832f,0.66259f,0.78484f,0.87462f,0.93138f,0.96153f,0.97333f,0.96153f,0.93138f,0.87462f,0.78484f,0.66259f,0.51832f,0.3685f,0.22776f,0.10423f,0.000000f},
   {0.000000f,0.10681f,0.23388f,0.379f,0.53333f,0.68101f,0.80448f,0.89329f,0.94776f,0.97529f,0.98473f,0.97529f,0.94776f,0.89329f,0.80448f,0.68101f,0.53333f,0.379f,0.23388f,0.10681f,0.000000f},
   {0.000000f,0.10858f,0.23811f,0.38627f,0.54374f,0.69373f,0.81797f,0.90598f,0.95879f,0.98449f,0.9923f,0.98449f,0.95879f,0.90598f,0.81797f,0.69373f,0.54374f,0.38627f,0.23811f,0.10858f,0.000000f},
   {0.000000f,0.10969f,0.24075f,0.39083f,0.55028f,0.70171f,0.82638f,0.91386f,0.9656f,0.99013f,0.99693f,0.99013f,0.9656f,0.91386f,0.82638f,0.70171f,0.55028f,0.39083f,0.24075f,0.10969f,0.000000f},
   {0.000000f,0.11026f,0.24213f,0.39322f,0.5537f,0.70589f,0.83077f,0.91795f,0.96912f,0.99304f,0.99931f,0.99304f,0.96912f,0.91795f,0.83077f,0.70589f,0.5537f,0.39322f,0.24213f,0.11026f,0.000000f},
   {0.000000f,0.11043f,0.24254f,0.39392f,0.5547f,0.70711f,0.83205f,0.91915f,0.97014f,0.99388f,1.000000f,0.99388f,0.97014f,0.91915f,0.83205f,0.70711f,0.5547f,0.39392f,0.24254f,0.11043f,0.000000f}};

static float map_legacy_rf[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.0073897f,0.014571f,0.021357f,0.027609f,0.03325f,0.038255f,0.042638f,0.046444f,0.04973f,0.052559f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.015481f,0.030571f,0.044859f,0.058038f,0.069928f,0.080466f,0.089681f,0.097663f,0.10453f,0.11043f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.024228f,0.047977f,0.070553f,0.091419f,0.11024f,0.1269f,0.14141f,0.15393f,0.16464f,0.17379f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.03352f,0.066667f,0.098374f,0.12778f,0.1543f,0.1777f,0.19799f,0.21535f,0.23009f,0.24254f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.043173f,0.086387f,0.1281f,0.16696f,0.20203f,0.23285f,0.25935f,0.28179f,0.30059f,0.31623f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.05293f,0.10674f,0.15929f,0.20858f,0.25309f,0.292f,0.3251f,0.35271f,0.37542f,0.39392f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.062479f,0.12717f,0.19128f,0.25196f,0.30682f,0.35446f,0.39444f,0.42712f,0.45334f,0.4741f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.071497f,0.14704f,0.22322f,0.29609f,0.36214f,0.41906f,0.46602f,0.50345f,0.53253f,0.5547f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.079698f,0.1657f,0.25408f,0.33971f,0.41759f,0.48415f,0.538f,0.57963f,0.61069f,0.63324f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.086874f,0.18257f,0.28284f,0.38139f,0.4714f,0.54772f,0.60812f,0.6532f,0.68525f,0.70711f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.092925f,0.19725f,0.30863f,0.41971f,0.52174f,0.60758f,0.67398f,0.72165f,0.75372f,0.77396f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.097849f,0.20953f,0.33085f,0.45356f,0.56695f,0.66169f,0.73335f,0.78279f,0.81408f,0.83205f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.10172f,0.21943f,0.34921f,0.48218f,0.6058f,0.70851f,0.78458f,0.83508f,0.86507f,0.88047f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.10467f,0.22711f,0.36378f,0.50535f,0.63768f,0.74715f,0.82678f,0.87779f,0.90626f,0.91915f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.10684f,0.23285f,0.37484f,0.52322f,0.66259f,0.77748f,0.85983f,0.91103f,0.93803f,0.94868f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.10837f,0.23694f,0.38284f,0.53632f,0.68101f,0.8f,0.88433f,0.93553f,0.96128f,0.97014f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.10939f,0.2397f,0.38828f,0.54531f,0.69373f,0.81561f,0.9013f,0.95242f,0.97723f,0.98478f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.11001f,0.2414f,0.39165f,0.55092f,0.70171f,0.82541f,0.91194f,0.963f,0.98718f,0.99388f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.11034f,0.24228f,0.39341f,0.55385f,0.70589f,0.83055f,0.91751f,0.96853f,0.99237f,0.99862f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.11043f,0.24254f,0.39392f,0.5547f,0.70711f,0.83205f,0.91915f,0.97014f,0.99388f,1.000000f}};

static float map_legacy_ls[21][21] = {
   {1.000000f,0.99862f,0.99388f,0.98478f,0.97014f,0.94868f,0.91915f,0.88047f,0.83205f,0.77396f,0.70711f,0.63324f,0.5547f,0.4741f,0.39392f,0.31623f,0.24254f,0.17379f,0.11043f,0.052559f,0.000000f},
   {0.99862f,0.99737f,0.99274f,0.98372f,0.96912f,0.94763f,0.91801f,0.87918f,0.83055f,0.77222f,0.70516f,0.63182f,0.5537f,0.4734f,0.39343f,0.31588f,0.24228f,0.1736f,0.1103f,0.052493f,0.000000f},
   {0.99388f,0.99308f,0.98883f,0.98008f,0.9656f,0.94403f,0.9141f,0.87474f,0.82541f,0.76631f,0.69854f,0.62698f,0.55028f,0.47102f,0.39176f,0.31468f,0.2414f,0.17296f,0.10987f,0.052267f,0.000000f},
   {0.98478f,0.98482f,0.98129f,0.97306f,0.95879f,0.93708f,0.90658f,0.86623f,0.81561f,0.7551f,0.68606f,0.61781f,0.54374f,0.46643f,0.38853f,0.31236f,0.2397f,0.17172f,0.10903f,0.051833f,0.000000f},
   {0.97014f,0.97149f,0.96909f,0.96167f,0.94776f,0.92582f,0.89443f,0.85257f,0.8f,0.73744f,0.66667f,0.60336f,0.53333f,0.45908f,0.38333f,0.30861f,0.23694f,0.16971f,0.10768f,0.051131f,0.000000f},
   {0.94868f,0.95185f,0.95103f,0.94477f,0.93138f,0.90914f,0.87652f,0.83262f,0.77748f,0.71236f,0.6396f,0.58284f,0.51832f,0.44833f,0.37565f,0.30305f,0.23285f,0.16672f,0.10567f,0.050098f,0.000000f},
   {0.91915f,0.92464f,0.92587f,0.92113f,0.90844f,0.88583f,0.85169f,0.80528f,0.74715f,0.67926f,0.60471f,0.55576f,0.4981f,0.43361f,0.36501f,0.29528f,0.22711f,0.16255f,0.10287f,0.048665f,0.000000f},
   {0.88047f,0.88868f,0.89238f,0.8895f,0.87771f,0.85472f,0.81886f,0.76969f,0.70851f,0.63818f,0.56257f,0.52214f,0.47234f,0.41445f,0.35094f,0.28491f,0.21943f,0.15697f,0.099153f,0.046773f,0.000000f},
   {0.83205f,0.84317f,0.84958f,0.84882f,0.83812f,0.81482f,0.77724f,0.72546f,0.66169f,0.58985f,0.5145f,0.4826f,0.44113f,0.39063f,0.3331f,0.27161f,0.20953f,0.14979f,0.094398f,0.044378f,0.000000f},
   {0.77396f,0.78787f,0.79699f,0.79846f,0.78899f,0.76558f,0.72661f,0.67284f,0.60758f,0.53574f,0.46236f,0.43834f,0.40505f,0.3623f,0.3114f,0.25519f,0.19725f,0.1409f,0.088554f,0.041467f,0.000000f},
   {0.70711f,0.72332f,0.73485f,0.73843f,0.7303f,0.70711f,0.66742f,0.61283f,0.54772f,0.47781f,0.40825f,0.39094f,0.36515f,0.32998f,0.28604f,0.2357f,0.18257f,0.13031f,0.08165f,0.038069f,0.000000f},
   {0.63324f,0.65094f,0.66425f,0.6696f,0.66281f,0.64032f,0.60095f,0.54712f,0.48415f,0.41816f,0.3541f,0.34213f,0.32277f,0.2946f,0.25755f,0.21344f,0.1657f,0.11816f,0.073805f,0.03426f,0.000000f},
   {0.5547f,0.57287f,0.5871f,0.59367f,0.58817f,0.56695f,0.52915f,0.47789f,0.41906f,0.35878f,0.30151f,0.29355f,0.27937f,0.25733f,0.22678f,0.18898f,0.14704f,0.10476f,0.065233f,0.030151f,0.000000f},
   {0.4741f,0.49168f,0.50587f,0.513f,0.50867f,0.4893f,0.45437f,0.40741f,0.35446f,0.30126f,0.25161f,0.24648f,0.23631f,0.21938f,0.19473f,0.1631f,0.12717f,0.090529f,0.056207f,0.025878f,0.000000f},
   {0.39392f,0.40998f,0.42322f,0.43026f,0.42694f,0.40994f,0.37901f,0.33779f,0.292f,0.24672f,0.20508f,0.20186f,0.19467f,0.18189f,0.16243f,0.13665f,0.10674f,0.075928f,0.047024f,0.021578f,0.000000f},
   {0.31623f,0.33005f,0.34164f,0.34803f,0.34555f,0.33129f,0.30521f,0.27072f,0.23285f,0.19587f,0.16222f,0.16026f,0.15523f,0.14577f,0.13081f,0.11043f,0.086387f,0.061417f,0.037959f,0.017371f,0.000000f},
   {0.24254f,0.25367f,0.26312f,0.26846f,0.26667f,0.25538f,0.23464f,0.20737f,0.1777f,0.149f,0.12309f,0.12191f,0.11847f,0.11166f,0.10056f,0.085126f,0.066667f,0.047375f,0.029235f,0.013351f,0.000000f},
   {0.17379f,0.18203f,0.18908f,0.19313f,0.19191f,0.18364f,0.1684f,0.14846f,0.1269f,0.10617f,0.087556f,0.086867f,0.084599f,0.07994f,0.072173f,0.061212f,0.047977f,0.034083f,0.021009f,0.0095807f,0.000000f},
   {0.11043f,0.11578f,0.12038f,0.12304f,0.12228f,0.11695f,0.10712f,0.094287f,0.080466f,0.067231f,0.055385f,0.055007f,0.053644f,0.05077f,0.04591f,0.038984f,0.030571f,0.021713f,0.013375f,0.0060937f,0.000000f},
   {0.052559f,0.055132f,0.057347f,0.058638f,0.058284f,0.055728f,0.051012f,0.044862f,0.038255f,0.03194f,0.026298f,0.026133f,0.025503f,0.024157f,0.021862f,0.018576f,0.014571f,0.010348f,0.0063719f,0.0029017f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_legacy_rs[21][21] = {
   {0.000000f,0.052559f,0.11043f,0.17379f,0.24254f,0.31623f,0.39392f,0.4741f,0.5547f,0.63324f,0.70711f,0.77396f,0.83205f,0.88047f,0.91915f,0.94868f,0.97014f,0.98478f,0.99388f,0.99862f,1.000000f},
   {0.000000f,0.052493f,0.1103f,0.1736f,0.24228f,0.31588f,0.39343f,0.4734f,0.5537f,0.63182f,0.70516f,0.77222f,0.83055f,0.87918f,0.91801f,0.94763f,0.96912f,0.98372f,0.99274f,0.99737f,0.99862f},
   {0.000000f,0.052267f,0.10987f,0.17296f,0.2414f,0.31468f,0.39176f,0.47102f,0.55028f,0.62698f,0.69854f,0.76631f,0.82541f,0.87474f,0.9141f,0.94403f,0.9656f,0.98008f,0.98883f,0.99308f,0.99388f},
   {0.000000f,0.051833f,0.10903f,0.17172f,0.2397f,0.31236f,0.38853f,0.46643f,0.54374f,0.61781f,0.68606f,0.7551f,0.81561f,0.86623f,0.90658f,0.93708f,0.95879f,0.97306f,0.98129f,0.98482f,0.98478f},
   {0.000000f,0.051131f,0.10768f,0.16971f,0.23694f,0.30861f,0.38333f,0.45908f,0.53333f,0.60336f,0.66667f,0.73744f,0.8f,0.85257f,0.89443f,0.92582f,0.94776f,0.96167f,0.96909f,0.97149f,0.97014f},
   {0.000000f,0.050098f,0.10567f,0.16672f,0.23285f,0.30305f,0.37565f,0.44833f,0.51832f,0.58284f,0.6396f,0.71236f,0.77748f,0.83262f,0.87652f,0.90914f,0.93138f,0.94477f,0.95103f,0.95185f,0.94868f},
   {0.000000f,0.048665f,0.10287f,0.16255f,0.22711f,0.29528f,0.36501f,0.43361f,0.4981f,0.55576f,0.60471f,0.67926f,0.74715f,0.80528f,0.85169f,0.88583f,0.90844f,0.92113f,0.92587f,0.92464f,0.91915f},
   {0.000000f,0.046773f,0.099153f,0.15697f,0.21943f,0.28491f,0.35094f,0.41445f,0.47234f,0.52214f,0.56257f,0.63818f,0.70851f,0.76969f,0.81886f,0.85472f,0.87771f,0.8895f,0.89238f,0.88868f,0.88047f},
   {0.000000f,0.044378f,0.094398f,0.14979f,0.20953f,0.27161f,0.3331f,0.39063f,0.44113f,0.4826f,0.5145f,0.58985f,0.66169f,0.72546f,0.77724f,0.81482f,0.83812f,0.84882f,0.84958f,0.84317f,0.83205f},
   {0.000000f,0.041467f,0.088554f,0.1409f,0.19725f,0.25519f,0.3114f,0.3623f,0.40505f,0.43834f,0.46236f,0.53574f,0.60758f,0.67284f,0.72661f,0.76558f,0.78899f,0.79846f,0.79699f,0.78787f,0.77396f},
   {0.000000f,0.038069f,0.08165f,0.13031f,0.18257f,0.2357f,0.28604f,0.32998f,0.36515f,0.39094f,0.40825f,0.47781f,0.54772f,0.61283f,0.66742f,0.70711f,0.7303f,0.73843f,0.73485f,0.72332f,0.70711f},
   {0.000000f,0.03426f,0.073805f,0.11816f,0.1657f,0.21344f,0.25755f,0.2946f,0.32277f,0.34213f,0.3541f,0.41816f,0.48415f,0.54712f,0.60095f,0.64032f,0.66281f,0.6696f,0.66425f,0.65094f,0.63324f},
   {0.000000f,0.030151f,0.065233f,0.10476f,0.14704f,0.18898f,0.22678f,0.25733f,0.27937f,0.29355f,0.30151f,0.35878f,0.41906f,0.47789f,0.52915f,0.56695f,0.58817f,0.59367f,0.5871f,0.57287f,0.5547f},
   {0.000000f,0.025878f,0.056207f,0.090529f,0.12717f,0.1631f,0.19473f,0.21938f,0.23631f,0.24648f,0.25161f,0.30126f,0.35446f,0.40741f,0.45437f,0.4893f,0.50867f,0.513f,0.50587f,0.49168f,0.4741f},
   {0.000000f,0.021578f,0.047024f,0.075928f,0.10674f,0.13665f,0.16243f,0.18189f,0.19467f,0.20186f,0.20508f,0.24672f,0.292f,0.33779f,0.37901f,0.40994f,0.42694f,0.43026f,0.42322f,0.40998f,0.39392f},
   {0.000000f,0.017371f,0.037959f,0.061417f,0.086387f,0.11043f,0.13081f,0.14577f,0.15523f,0.16026f,0.16222f,0.19587f,0.23285f,0.27072f,0.30521f,0.33129f,0.34555f,0.34803f,0.34164f,0.33005f,0.31623f},
   {0.000000f,0.013351f,0.029235f,0.047375f,0.066667f,0.085126f,0.10056f,0.11166f,0.11847f,0.12191f,0.12309f,0.149f,0.1777f,0.20737f,0.23464f,0.25538f,0.26667f,0.26846f,0.26312f,0.25367f,0.24254f},
   {0.000000f,0.0095807f,0.021009f,0.034083f,0.047977f,0.061212f,0.072173f,0.07994f,0.084599f,0.086867f,0.087556f,0.10617f,0.1269f,0.14846f,0.1684f,0.18364f,0.19191f,0.19313f,0.18908f,0.18203f,0.17379f},
   {0.000000f,0.0060937f,0.013375f,0.021713f,0.030571f,0.038984f,0.04591f,0.05077f,0.053644f,0.055007f,0.055385f,0.067231f,0.080466f,0.094287f,0.10712f,0.11695f,0.12228f,0.12304f,0.12038f,0.11578f,0.11043f},
   {0.000000f,0.0029017f,0.0063719f,0.010348f,0.014571f,0.018576f,0.021862f,0.024157f,0.025503f,0.026133f,0.026298f,0.03194f,0.038255f,0.044862f,0.051012f,0.055728f,0.058284f,0.058638f,0.057347f,0.055132f,0.052559f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

static float map_lfe_lfe[21][21] = {
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f},
   {0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f,0.000000f}};

std::map<unsigned,alloc_lut> chn_alloc;
std::map<unsigned,std::vector<float> > chn_angle;
std::map<unsigned,std::vector<float> > chn_xsf;
std::map<unsigned,std::vector<float> > chn_ysf;
std::map<unsigned,std::vector<channel_id> > chn_id;

static bool init_maps() {
    chn_angle[cs_stereo] = std::vector<float>(&map_stereo_ang[0],&map_stereo_ang[sizeof(map_stereo_ang)/sizeof(map_stereo_ang[0])]);
    chn_xsf[cs_stereo] = std::vector<float>(&map_stereo_xsf[0],&map_stereo_xsf[sizeof(map_stereo_xsf)/sizeof(map_stereo_xsf[0])]);
    chn_ysf[cs_stereo] = std::vector<float>(&map_stereo_ysf[0],&map_stereo_ysf[sizeof(map_stereo_ysf)/sizeof(map_stereo_ysf[0])]);
    chn_id[cs_stereo] = std::vector<channel_id>(&map_stereo_id[0],&map_stereo_id[sizeof(map_stereo_id)/sizeof(map_stereo_id[0])]);
    chn_alloc[cs_stereo].push_back(std::vector<const float*>(&map_stereo_lf[0],&map_stereo_lf[21]));
    chn_alloc[cs_stereo].push_back(std::vector<const float*>(&map_stereo_rf[0],&map_stereo_rf[21]));
    chn_alloc[cs_stereo].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_3stereo] = std::vector<float>(&map_3stereo_ang[0],&map_3stereo_ang[sizeof(map_3stereo_ang)/sizeof(map_3stereo_ang[0])]);
    chn_xsf[cs_3stereo] = std::vector<float>(&map_3stereo_xsf[0],&map_3stereo_xsf[sizeof(map_3stereo_xsf)/sizeof(map_3stereo_xsf[0])]);
    chn_ysf[cs_3stereo] = std::vector<float>(&map_3stereo_ysf[0],&map_3stereo_ysf[sizeof(map_3stereo_ysf)/sizeof(map_3stereo_ysf[0])]);
    chn_id[cs_3stereo] = std::vector<channel_id>(&map_3stereo_id[0],&map_3stereo_id[sizeof(map_3stereo_id)/sizeof(map_3stereo_id[0])]);
    chn_alloc[cs_3stereo].push_back(std::vector<const float*>(&map_3stereo_lf[0],&map_3stereo_lf[21]));
    chn_alloc[cs_3stereo].push_back(std::vector<const float*>(&map_3stereo_cf[0],&map_3stereo_cf[21]));
    chn_alloc[cs_3stereo].push_back(std::vector<const float*>(&map_3stereo_rf[0],&map_3stereo_rf[21]));
    chn_alloc[cs_3stereo].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
/*    chn_angle[cs_5stereo] = std::vector<float>(&map_5stereo_ang[0],&map_5stereo_ang[sizeof(map_5stereo_ang)/sizeof(map_5stereo_ang[0])]);
    chn_xsf[cs_5stereo] = std::vector<float>(&map_5stereo_xsf[0],&map_5stereo_xsf[sizeof(map_5stereo_xsf)/sizeof(map_5stereo_xsf[0])]);
    chn_ysf[cs_5stereo] = std::vector<float>(&map_5stereo_ysf[0],&map_5stereo_ysf[sizeof(map_5stereo_ysf)/sizeof(map_5stereo_ysf[0])]);
    chn_id[cs_5stereo] = std::vector<channel_id>(&map_5stereo_id[0],&map_5stereo_id[sizeof(map_5stereo_id)/sizeof(map_5stereo_id[0])]);
    chn_alloc[cs_5stereo].push_back(std::vector<const float*>(&map_5stereo_lf[0],&map_5stereo_lf[21]));
    chn_alloc[cs_5stereo].push_back(std::vector<const float*>(&map_5stereo_lcf[0],&map_5stereo_lcf[21]));
    chn_alloc[cs_5stereo].push_back(std::vector<const float*>(&map_5stereo_cf[0],&map_5stereo_cf[21]));
    chn_alloc[cs_5stereo].push_back(std::vector<const float*>(&map_5stereo_rcf[0],&map_5stereo_rcf[21]));
    chn_alloc[cs_5stereo].push_back(std::vector<const float*>(&map_5stereo_rf[0],&map_5stereo_rf[21]));
    chn_alloc[cs_5stereo].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));*/
    chn_angle[cs_4point1] = std::vector<float>(&map_4point1_ang[0],&map_4point1_ang[sizeof(map_4point1_ang)/sizeof(map_4point1_ang[0])]);
    chn_xsf[cs_4point1] = std::vector<float>(&map_4point1_xsf[0],&map_4point1_xsf[sizeof(map_4point1_xsf)/sizeof(map_4point1_xsf[0])]);
    chn_ysf[cs_4point1] = std::vector<float>(&map_4point1_ysf[0],&map_4point1_ysf[sizeof(map_4point1_ysf)/sizeof(map_4point1_ysf[0])]);
    chn_id[cs_4point1] = std::vector<channel_id>(&map_4point1_id[0],&map_4point1_id[sizeof(map_4point1_id)/sizeof(map_4point1_id[0])]);
    chn_alloc[cs_4point1].push_back(std::vector<const float*>(&map_4point1_lf[0],&map_4point1_lf[21]));
    chn_alloc[cs_4point1].push_back(std::vector<const float*>(&map_4point1_rf[0],&map_4point1_rf[21]));
    chn_alloc[cs_4point1].push_back(std::vector<const float*>(&map_4point1_ls[0],&map_4point1_ls[21]));
    chn_alloc[cs_4point1].push_back(std::vector<const float*>(&map_4point1_rs[0],&map_4point1_rs[21]));
    chn_alloc[cs_4point1].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_5point1] = std::vector<float>(&map_5point1_ang[0],&map_5point1_ang[sizeof(map_5point1_ang)/sizeof(map_5point1_ang[0])]);
    chn_xsf[cs_5point1] = std::vector<float>(&map_5point1_xsf[0],&map_5point1_xsf[sizeof(map_5point1_xsf)/sizeof(map_5point1_xsf[0])]);
    chn_ysf[cs_5point1] = std::vector<float>(&map_5point1_ysf[0],&map_5point1_ysf[sizeof(map_5point1_ysf)/sizeof(map_5point1_ysf[0])]);
    chn_id[cs_5point1] = std::vector<channel_id>(&map_5point1_id[0],&map_5point1_id[sizeof(map_5point1_id)/sizeof(map_5point1_id[0])]);
    chn_alloc[cs_5point1].push_back(std::vector<const float*>(&map_5point1_lf[0],&map_5point1_lf[21]));
    chn_alloc[cs_5point1].push_back(std::vector<const float*>(&map_5point1_cf[0],&map_5point1_cf[21]));
    chn_alloc[cs_5point1].push_back(std::vector<const float*>(&map_5point1_rf[0],&map_5point1_rf[21]));
    chn_alloc[cs_5point1].push_back(std::vector<const float*>(&map_5point1_ls[0],&map_5point1_ls[21]));
    chn_alloc[cs_5point1].push_back(std::vector<const float*>(&map_5point1_rs[0],&map_5point1_rs[21]));
    chn_alloc[cs_5point1].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_6point1] = std::vector<float>(&map_6point1_ang[0],&map_6point1_ang[sizeof(map_6point1_ang)/sizeof(map_6point1_ang[0])]);
    chn_xsf[cs_6point1] = std::vector<float>(&map_6point1_xsf[0],&map_6point1_xsf[sizeof(map_6point1_xsf)/sizeof(map_6point1_xsf[0])]);
    chn_ysf[cs_6point1] = std::vector<float>(&map_6point1_ysf[0],&map_6point1_ysf[sizeof(map_6point1_ysf)/sizeof(map_6point1_ysf[0])]);
    chn_id[cs_6point1] = std::vector<channel_id>(&map_6point1_id[0],&map_6point1_id[sizeof(map_6point1_id)/sizeof(map_6point1_id[0])]);
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_6point1_lf[0],&map_6point1_lf[21]));
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_6point1_cf[0],&map_6point1_cf[21]));
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_6point1_rf[0],&map_6point1_rf[21]));
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_6point1_lsm[0],&map_6point1_lsm[21]));
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_6point1_rsm[0],&map_6point1_rsm[21]));
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_6point1_cs[0],&map_6point1_cs[21]));
    chn_alloc[cs_6point1].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_7point1] = std::vector<float>(&map_7point1_ang[0],&map_7point1_ang[sizeof(map_7point1_ang)/sizeof(map_7point1_ang[0])]);
    chn_xsf[cs_7point1] = std::vector<float>(&map_7point1_xsf[0],&map_7point1_xsf[sizeof(map_7point1_xsf)/sizeof(map_7point1_xsf[0])]);
    chn_ysf[cs_7point1] = std::vector<float>(&map_7point1_ysf[0],&map_7point1_ysf[sizeof(map_7point1_ysf)/sizeof(map_7point1_ysf[0])]);
    chn_id[cs_7point1] = std::vector<channel_id>(&map_7point1_id[0],&map_7point1_id[sizeof(map_7point1_id)/sizeof(map_7point1_id[0])]);
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_lf[0],&map_7point1_lf[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_cf[0],&map_7point1_cf[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_rf[0],&map_7point1_rf[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_lsm[0],&map_7point1_lsm[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_rsm[0],&map_7point1_rsm[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_ls[0],&map_7point1_ls[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_7point1_rs[0],&map_7point1_rs[21]));
    chn_alloc[cs_7point1].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
/*    chn_angle[cs_7point1_panorama] = std::vector<float>(&map_7point1_panorama_ang[0],&map_7point1_panorama_ang[sizeof(map_7point1_panorama_ang)/sizeof(map_7point1_panorama_ang[0])]);
    chn_xsf[cs_7point1_panorama] = std::vector<float>(&map_7point1_panorama_xsf[0],&map_7point1_panorama_xsf[sizeof(map_7point1_panorama_xsf)/sizeof(map_7point1_panorama_xsf[0])]);
    chn_ysf[cs_7point1_panorama] = std::vector<float>(&map_7point1_panorama_ysf[0],&map_7point1_panorama_ysf[sizeof(map_7point1_panorama_ysf)/sizeof(map_7point1_panorama_ysf[0])]);
    chn_id[cs_7point1_panorama] = std::vector<channel_id>(&map_7point1_panorama_id[0],&map_7point1_panorama_id[sizeof(map_7point1_panorama_id)/sizeof(map_7point1_panorama_id[0])]);
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_lf[0],&map_7point1_panorama_lf[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_lcf[0],&map_7point1_panorama_lcf[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_cf[0],&map_7point1_panorama_cf[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_rcf[0],&map_7point1_panorama_rcf[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_rf[0],&map_7point1_panorama_rf[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_lsm[0],&map_7point1_panorama_lsm[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_7point1_panorama_rsm[0],&map_7point1_panorama_rsm[21]));
    chn_alloc[cs_7point1_panorama].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_7point1_tricenter] = std::vector<float>(&map_7point1_tricenter_ang[0],&map_7point1_tricenter_ang[sizeof(map_7point1_tricenter_ang)/sizeof(map_7point1_tricenter_ang[0])]);
    chn_xsf[cs_7point1_tricenter] = std::vector<float>(&map_7point1_tricenter_xsf[0],&map_7point1_tricenter_xsf[sizeof(map_7point1_tricenter_xsf)/sizeof(map_7point1_tricenter_xsf[0])]);
    chn_ysf[cs_7point1_tricenter] = std::vector<float>(&map_7point1_tricenter_ysf[0],&map_7point1_tricenter_ysf[sizeof(map_7point1_tricenter_ysf)/sizeof(map_7point1_tricenter_ysf[0])]);
    chn_id[cs_7point1_tricenter] = std::vector<channel_id>(&map_7point1_tricenter_id[0],&map_7point1_tricenter_id[sizeof(map_7point1_tricenter_id)/sizeof(map_7point1_tricenter_id[0])]);
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_lf[0],&map_7point1_tricenter_lf[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_lcf[0],&map_7point1_tricenter_lcf[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_cf[0],&map_7point1_tricenter_cf[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_rcf[0],&map_7point1_tricenter_rcf[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_rf[0],&map_7point1_tricenter_rf[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_ls[0],&map_7point1_tricenter_ls[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_7point1_tricenter_rs[0],&map_7point1_tricenter_rs[21]));
    chn_alloc[cs_7point1_tricenter].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_8point1] = std::vector<float>(&map_8point1_ang[0],&map_8point1_ang[sizeof(map_8point1_ang)/sizeof(map_8point1_ang[0])]);
    chn_xsf[cs_8point1] = std::vector<float>(&map_8point1_xsf[0],&map_8point1_xsf[sizeof(map_8point1_xsf)/sizeof(map_8point1_xsf[0])]);
    chn_ysf[cs_8point1] = std::vector<float>(&map_8point1_ysf[0],&map_8point1_ysf[sizeof(map_8point1_ysf)/sizeof(map_8point1_ysf[0])]);
    chn_id[cs_8point1] = std::vector<channel_id>(&map_8point1_id[0],&map_8point1_id[sizeof(map_8point1_id)/sizeof(map_8point1_id[0])]);
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_lf[0],&map_8point1_lf[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_cf[0],&map_8point1_cf[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_rf[0],&map_8point1_rf[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_lsm[0],&map_8point1_lsm[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_rsm[0],&map_8point1_rsm[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_ls[0],&map_8point1_ls[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_cs[0],&map_8point1_cs[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_8point1_rs[0],&map_8point1_rs[21]));
    chn_alloc[cs_8point1].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_9point1_densepanorama] = std::vector<float>(&map_9point1_densepanorama_ang[0],&map_9point1_densepanorama_ang[sizeof(map_9point1_densepanorama_ang)/sizeof(map_9point1_densepanorama_ang[0])]);
    chn_xsf[cs_9point1_densepanorama] = std::vector<float>(&map_9point1_densepanorama_xsf[0],&map_9point1_densepanorama_xsf[sizeof(map_9point1_densepanorama_xsf)/sizeof(map_9point1_densepanorama_xsf[0])]);
    chn_ysf[cs_9point1_densepanorama] = std::vector<float>(&map_9point1_densepanorama_ysf[0],&map_9point1_densepanorama_ysf[sizeof(map_9point1_densepanorama_ysf)/sizeof(map_9point1_densepanorama_ysf[0])]);
    chn_id[cs_9point1_densepanorama] = std::vector<channel_id>(&map_9point1_densepanorama_id[0],&map_9point1_densepanorama_id[sizeof(map_9point1_densepanorama_id)/sizeof(map_9point1_densepanorama_id[0])]);
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_lf[0],&map_9point1_densepanorama_lf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_lcf[0],&map_9point1_densepanorama_lcf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_cf[0],&map_9point1_densepanorama_cf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_rcf[0],&map_9point1_densepanorama_rcf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_rf[0],&map_9point1_densepanorama_rf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_lsf[0],&map_9point1_densepanorama_lsf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_rsf[0],&map_9point1_densepanorama_rsf[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_lsm[0],&map_9point1_densepanorama_lsm[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_9point1_densepanorama_rsm[0],&map_9point1_densepanorama_rsm[21]));
    chn_alloc[cs_9point1_densepanorama].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_9point1_wrap] = std::vector<float>(&map_9point1_wrap_ang[0],&map_9point1_wrap_ang[sizeof(map_9point1_wrap_ang)/sizeof(map_9point1_wrap_ang[0])]);
    chn_xsf[cs_9point1_wrap] = std::vector<float>(&map_9point1_wrap_xsf[0],&map_9point1_wrap_xsf[sizeof(map_9point1_wrap_xsf)/sizeof(map_9point1_wrap_xsf[0])]);
    chn_ysf[cs_9point1_wrap] = std::vector<float>(&map_9point1_wrap_ysf[0],&map_9point1_wrap_ysf[sizeof(map_9point1_wrap_ysf)/sizeof(map_9point1_wrap_ysf[0])]);
    chn_id[cs_9point1_wrap] = std::vector<channel_id>(&map_9point1_wrap_id[0],&map_9point1_wrap_id[sizeof(map_9point1_wrap_id)/sizeof(map_9point1_wrap_id[0])]);
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_lf[0],&map_9point1_wrap_lf[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_lcf[0],&map_9point1_wrap_lcf[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_cf[0],&map_9point1_wrap_cf[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_rcf[0],&map_9point1_wrap_rcf[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_rf[0],&map_9point1_wrap_rf[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_lsm[0],&map_9point1_wrap_lsm[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_rsm[0],&map_9point1_wrap_rsm[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_ls[0],&map_9point1_wrap_ls[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_9point1_wrap_rs[0],&map_9point1_wrap_rs[21]));
    chn_alloc[cs_9point1_wrap].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_11point1_densewrap] = std::vector<float>(&map_11point1_densewrap_ang[0],&map_11point1_densewrap_ang[sizeof(map_11point1_densewrap_ang)/sizeof(map_11point1_densewrap_ang[0])]);
    chn_xsf[cs_11point1_densewrap] = std::vector<float>(&map_11point1_densewrap_xsf[0],&map_11point1_densewrap_xsf[sizeof(map_11point1_densewrap_xsf)/sizeof(map_11point1_densewrap_xsf[0])]);
    chn_ysf[cs_11point1_densewrap] = std::vector<float>(&map_11point1_densewrap_ysf[0],&map_11point1_densewrap_ysf[sizeof(map_11point1_densewrap_ysf)/sizeof(map_11point1_densewrap_ysf[0])]);
    chn_id[cs_11point1_densewrap] = std::vector<channel_id>(&map_11point1_densewrap_id[0],&map_11point1_densewrap_id[sizeof(map_11point1_densewrap_id)/sizeof(map_11point1_densewrap_id[0])]);
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_lf[0],&map_11point1_densewrap_lf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_lcf[0],&map_11point1_densewrap_lcf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_cf[0],&map_11point1_densewrap_cf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_rcf[0],&map_11point1_densewrap_rcf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_rf[0],&map_11point1_densewrap_rf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_lsf[0],&map_11point1_densewrap_lsf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_rsf[0],&map_11point1_densewrap_rsf[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_lsm[0],&map_11point1_densewrap_lsm[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_rsm[0],&map_11point1_densewrap_rsm[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_lsb[0],&map_11point1_densewrap_lsb[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_11point1_densewrap_rsb[0],&map_11point1_densewrap_rsb[21]));
    chn_alloc[cs_11point1_densewrap].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_13point1_totalwrap] = std::vector<float>(&map_13point1_totalwrap_ang[0],&map_13point1_totalwrap_ang[sizeof(map_13point1_totalwrap_ang)/sizeof(map_13point1_totalwrap_ang[0])]);
    chn_xsf[cs_13point1_totalwrap] = std::vector<float>(&map_13point1_totalwrap_xsf[0],&map_13point1_totalwrap_xsf[sizeof(map_13point1_totalwrap_xsf)/sizeof(map_13point1_totalwrap_xsf[0])]);
    chn_ysf[cs_13point1_totalwrap] = std::vector<float>(&map_13point1_totalwrap_ysf[0],&map_13point1_totalwrap_ysf[sizeof(map_13point1_totalwrap_ysf)/sizeof(map_13point1_totalwrap_ysf[0])]);
    chn_id[cs_13point1_totalwrap] = std::vector<channel_id>(&map_13point1_totalwrap_id[0],&map_13point1_totalwrap_id[sizeof(map_13point1_totalwrap_id)/sizeof(map_13point1_totalwrap_id[0])]);
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_lf[0],&map_13point1_totalwrap_lf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_lcf[0],&map_13point1_totalwrap_lcf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_cf[0],&map_13point1_totalwrap_cf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_rcf[0],&map_13point1_totalwrap_rcf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_rf[0],&map_13point1_totalwrap_rf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_lsf[0],&map_13point1_totalwrap_lsf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_rsf[0],&map_13point1_totalwrap_rsf[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_lsm[0],&map_13point1_totalwrap_lsm[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_rsm[0],&map_13point1_totalwrap_rsm[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_lsb[0],&map_13point1_totalwrap_lsb[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_rsb[0],&map_13point1_totalwrap_rsb[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_ls[0],&map_13point1_totalwrap_ls[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_13point1_totalwrap_rs[0],&map_13point1_totalwrap_rs[21]));
    chn_alloc[cs_13point1_totalwrap].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_16point1] = std::vector<float>(&map_16point1_ang[0],&map_16point1_ang[sizeof(map_16point1_ang)/sizeof(map_16point1_ang[0])]);
    chn_xsf[cs_16point1] = std::vector<float>(&map_16point1_xsf[0],&map_16point1_xsf[sizeof(map_16point1_xsf)/sizeof(map_16point1_xsf[0])]);
    chn_ysf[cs_16point1] = std::vector<float>(&map_16point1_ysf[0],&map_16point1_ysf[sizeof(map_16point1_ysf)/sizeof(map_16point1_ysf[0])]);
    chn_id[cs_16point1] = std::vector<channel_id>(&map_16point1_id[0],&map_16point1_id[sizeof(map_16point1_id)/sizeof(map_16point1_id[0])]);
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_lf[0],&map_16point1_lf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_lcf[0],&map_16point1_lcf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_cf[0],&map_16point1_cf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rcf[0],&map_16point1_rcf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rf[0],&map_16point1_rf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_lsf[0],&map_16point1_lsf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rsf[0],&map_16point1_rsf[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_lsm[0],&map_16point1_lsm[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rsm[0],&map_16point1_rsm[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_lsb[0],&map_16point1_lsb[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rsb[0],&map_16point1_rsb[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_ls[0],&map_16point1_ls[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_lcs[0],&map_16point1_lcs[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_cs[0],&map_16point1_cs[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rcs[0],&map_16point1_rcs[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_16point1_rs[0],&map_16point1_rs[21]));
    chn_alloc[cs_16point1].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));
    chn_angle[cs_legacy] = std::vector<float>(&map_legacy_ang[0],&map_legacy_ang[sizeof(map_legacy_ang)/sizeof(map_legacy_ang[0])]);
    chn_xsf[cs_legacy] = std::vector<float>(&map_legacy_xsf[0],&map_legacy_xsf[sizeof(map_legacy_xsf)/sizeof(map_legacy_xsf[0])]);
    chn_ysf[cs_legacy] = std::vector<float>(&map_legacy_ysf[0],&map_legacy_ysf[sizeof(map_legacy_ysf)/sizeof(map_legacy_ysf[0])]);
    chn_id[cs_legacy] = std::vector<channel_id>(&map_legacy_id[0],&map_legacy_id[sizeof(map_legacy_id)/sizeof(map_legacy_id[0])]);
    chn_alloc[cs_legacy].push_back(std::vector<const float*>(&map_legacy_lf[0],&map_legacy_lf[21]));
    chn_alloc[cs_legacy].push_back(std::vector<const float*>(&map_legacy_cf[0],&map_legacy_cf[21]));
    chn_alloc[cs_legacy].push_back(std::vector<const float*>(&map_legacy_rf[0],&map_legacy_rf[21]));
    chn_alloc[cs_legacy].push_back(std::vector<const float*>(&map_legacy_ls[0],&map_legacy_ls[21]));
    chn_alloc[cs_legacy].push_back(std::vector<const float*>(&map_legacy_rs[0],&map_legacy_rs[21]));
    chn_alloc[cs_legacy].push_back(std::vector<const float*>(&map_lfe_lfe[0],&map_lfe_lfe[21]));*/
    return true;
}

namespace { bool success = init_maps(); };

