/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Filters;

import deadbeef.Filters.Filter;
import deadbeef.Filters.MitchellFilter;
import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.Palette;

public class FilterOp {
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private byte[] a;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private Filter filter = new MitchellFilter();

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int[] filter(Bitmap src, Palette pal, int w, int h) {
        this.dstWidth = w;
        this.dstHeight = h;
        this.srcWidth = src.getWidth();
        this.srcHeight = src.getHeight();
        this.r = pal.getR();
        this.g = pal.getG();
        this.b = pal.getB();
        this.a = pal.getAlpha();
        float xscale = (float)(this.dstWidth - 1) / (float)(this.srcWidth - 1);
        float yscale = (float)(this.dstHeight - 1) / (float)(this.srcHeight - 1);
        this.horizontalSubsamplingData = this.createSubSampling(this.srcWidth, this.dstWidth, xscale);
        this.verticalSubsamplingData = this.createSubSampling(this.srcHeight, this.dstHeight, yscale);
        int[] workPixels = new int[this.srcHeight * this.dstWidth];
        this.filterHorizontally(src.getImg(), workPixels);
        int[] outPixels = new int[this.dstHeight * this.dstWidth];
        this.filterVertically(workPixels, outPixels);
        return outPixels;
    }

    private SubSamplingData createSubSampling(int srcSize, int dstSize, float scale) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        int[] arrN = new int[dstSize];
        float fwidth = this.filter.getRadius();
        if (scale < 1.0f) {
            float width = fwidth / scale;
            numContributors = (int)(width * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / (double)fwidth));
            int i = 0;
            while (i < dstSize) {
                arrN[i] = 0;
                int subindex = i * numContributors;
                float center = (float)i / scale;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                int j = left;
                while (j <= right) {
                    float weight = this.filter.value((center - (float)j) * fNormFac);
                    if (weight != 0.0f) {
                        int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                        int k = arrN[i];
                        int n2 = i;
                        arrN[n2] = arrN[n2] + 1;
                        if (n < 0 || n >= srcSize) {
                            weight = 0.0f;
                        }
                        arrPixel[subindex + k] = n;
                        arrWeight[subindex + k] = weight;
                    }
                    ++j;
                }
                int max = arrN[i];
                float tot = 0.0f;
                int k = 0;
                while (k < max) {
                    tot += arrWeight[subindex + k];
                    ++k;
                }
                if (tot != 0.0f) {
                    k = 0;
                    while (k < max) {
                        int n = subindex + k;
                        arrWeight[n] = arrWeight[n] / tot;
                        ++k;
                    }
                }
                ++i;
            }
        } else {
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            int i = 0;
            while (i < dstSize) {
                arrN[i] = 0;
                int subindex = i * numContributors;
                float center = (float)i / scale;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                int j = left;
                while (j <= right) {
                    float weight = this.filter.value(center - (float)j);
                    if (weight != 0.0f) {
                        int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                        int k = arrN[i];
                        int n3 = i;
                        arrN[n3] = arrN[n3] + 1;
                        if (n < 0 || n >= srcSize) {
                            weight = 0.0f;
                        }
                        arrPixel[subindex + k] = n;
                        arrWeight[subindex + k] = weight;
                    }
                    ++j;
                }
                int max = arrN[i];
                float tot = 0.0f;
                int k = 0;
                while (k < max) {
                    tot += arrWeight[subindex + k];
                    ++k;
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot != 0.0f) {
                    k = 0;
                    while (k < max) {
                        int n = subindex + k;
                        arrWeight[n] = arrWeight[n] / tot;
                        ++k;
                    }
                }
                ++i;
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors);
    }

    private void filterVertically(int[] src, int[] trg) {
        int x = 0;
        while (x < this.dstWidth) {
            int y = this.dstHeight - 1;
            while (y >= 0) {
                int yTimesNumContributors = y * this.verticalSubsamplingData.matrixWidth;
                int max = this.verticalSubsamplingData.numSamples[y];
                int ofsY = this.dstWidth * y;
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                float alpha = 0.0f;
                int index = yTimesNumContributors;
                int j = max - 1;
                while (j >= 0) {
                    int color = src[x + this.dstWidth * this.verticalSubsamplingData.pixelPos[index]];
                    float w = this.verticalSubsamplingData.weight[index];
                    alpha += (float)(color >> 24 & 0xFF) * w;
                    red += (float)(color >> 16 & 0xFF) * w;
                    green += (float)(color >> 8 & 0xFF) * w;
                    blue += (float)(color & 0xFF) * w;
                    ++index;
                    --j;
                }
                int ri = (int)red;
                if (ri < 0) {
                    ri = 0;
                } else if (ri > 255) {
                    ri = 255;
                }
                int gi = (int)green;
                if (gi < 0) {
                    gi = 0;
                } else if (gi > 255) {
                    gi = 255;
                }
                int bi = (int)blue;
                if (bi < 0) {
                    bi = 0;
                } else if (bi > 255) {
                    bi = 255;
                }
                int ai = (int)alpha;
                if (ai < 0) {
                    ai = 0;
                } else if (ai > 255) {
                    ai = 255;
                }
                trg[x + ofsY] = ai << 24 | ri << 16 | gi << 8 | bi;
                --y;
            }
            ++x;
        }
    }

    private void filterHorizontally(byte[] src, int[] trg) {
        int k = 0;
        while (k < this.srcHeight) {
            int destOfsY = this.dstWidth * k;
            int srcOfsY = this.srcWidth * k;
            int i = this.dstWidth - 1;
            while (i >= 0) {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                float alpha = 0.0f;
                int max = this.horizontalSubsamplingData.numSamples[i];
                int index = i * this.horizontalSubsamplingData.matrixWidth;
                int j = max - 1;
                while (j >= 0) {
                    int ofsX = this.horizontalSubsamplingData.pixelPos[index];
                    int palIdx = src[srcOfsY + ofsX] & 0xFF;
                    float w = this.horizontalSubsamplingData.weight[index];
                    red += (float)(this.r[palIdx] & 0xFF) * w;
                    green += (float)(this.g[palIdx] & 0xFF) * w;
                    blue += (float)(this.b[palIdx] & 0xFF) * w;
                    alpha += (float)(this.a[palIdx] & 0xFF) * w;
                    ++index;
                    --j;
                }
                int ri = (int)red;
                if (ri < 0) {
                    ri = 0;
                } else if (ri > 255) {
                    ri = 255;
                }
                int gi = (int)green;
                if (gi < 0) {
                    gi = 0;
                } else if (gi > 255) {
                    gi = 255;
                }
                int bi = (int)blue;
                if (bi < 0) {
                    bi = 0;
                } else if (bi > 255) {
                    bi = 255;
                }
                int ai = (int)alpha;
                if (ai < 0) {
                    ai = 0;
                } else if (ai > 255) {
                    ai = 255;
                }
                trg[i + destOfsY] = ai << 24 | ri << 16 | gi << 8 | bi;
                --i;
            }
            ++k;
        }
    }

    private class SubSamplingData {
        private final int[] numSamples;
        private final int[] pixelPos;
        private final float[] weight;
        private final int matrixWidth;

        private SubSamplingData(int[] s, int[] p, float[] w, int num) {
            this.numSamples = s;
            this.pixelPos = p;
            this.weight = w;
            this.matrixWidth = num;
        }
    }
}

