#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#define ULID_LEN 16
#define ULID_TIME_LEN 6
#define ULID_RAND_LEN 10
#define RESULT_LEN 26

SV* encode_ulid(SV *strsv)
{
	unsigned long len;
	char *str = SvPVbyte(strsv, len);
	if (len != ULID_LEN) croak("invalid string length in encode_ulid: %d", len);

	char base32[] = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
	char result[RESULT_LEN];

	// This part will be replaced with a pregenerated base32 encoding for
	// ULIDs, which runs significantly faster. See gen/gen_streamlined_ulid.pl
	// script for details.

	// autogenerated:
	result[0] = base32[((str[0] & 0xe0)>>5)];
	result[1] = base32[((str[0] & 0x1f))];
	result[2] = base32[((str[1] & 0xf8)>>3)];
	result[3] = base32[((str[1] & 0x07)<<2) + ((str[2] & 0xc0)>>6)];
	result[4] = base32[((str[2] & 0x3e)>>1)];
	result[5] = base32[((str[2] & 0x01)<<4) + ((str[3] & 0xf0)>>4)];
	result[6] = base32[((str[3] & 0x0f)<<1) + ((str[4] & 0x80)>>7)];
	result[7] = base32[((str[4] & 0x7c)>>2)];
	result[8] = base32[((str[4] & 0x03)<<3) + ((str[5] & 0xe0)>>5)];
	result[9] = base32[((str[5] & 0x1f))];
	
	result[10] = base32[((str[6] & 0xf8)>>3)];
	result[11] = base32[((str[6] & 0x07)<<2) + ((str[7] & 0xc0)>>6)];
	result[12] = base32[((str[7] & 0x3e)>>1)];
	result[13] = base32[((str[7] & 0x01)<<4) + ((str[8] & 0xf0)>>4)];
	result[14] = base32[((str[8] & 0x0f)<<1) + ((str[9] & 0x80)>>7)];
	result[15] = base32[((str[9] & 0x7c)>>2)];
	result[16] = base32[((str[9] & 0x03)<<3) + ((str[10] & 0xe0)>>5)];
	result[17] = base32[((str[10] & 0x1f))];
	result[18] = base32[((str[11] & 0xf8)>>3)];
	result[19] = base32[((str[11] & 0x07)<<2) + ((str[12] & 0xc0)>>6)];
	result[20] = base32[((str[12] & 0x3e)>>1)];
	result[21] = base32[((str[12] & 0x01)<<4) + ((str[13] & 0xf0)>>4)];
	result[22] = base32[((str[13] & 0x0f)<<1) + ((str[14] & 0x80)>>7)];
	result[23] = base32[((str[14] & 0x7c)>>2)];
	result[24] = base32[((str[14] & 0x03)<<3) + ((str[15] & 0xe0)>>5)];
	result[25] = base32[((str[15] & 0x1f))];
	

	return newSVpv(result, RESULT_LEN);
}

SV* build_binary_ulid (double time, SV *randomnesssv)
{
	unsigned long len;
	char *randomness = SvPVbyte(randomnesssv, len);
	if (len == 0) croak("no randomness was fetched for build_binary_ulid");

	char result[ULID_LEN] = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
	int i, j;

	unsigned long long microtime = time * 1000;

	// network byte order
	for (i = ULID_TIME_LEN - 1; i >= 0; --i) {
		result[i] = (char) (microtime & 0xff);
		microtime = microtime >> 8;
	}

	for (i = ULID_LEN - len, j = 0; i < ULID_LEN; ++i) {
		result[i] = randomness[j++];
	}

	return newSVpv(result, ULID_LEN);
}

// proper XS Code starts here

MODULE = Data::ULID::XS		PACKAGE = Data::ULID::XS

PROTOTYPES: DISABLE

SV*
ulid(...)
	CODE:
		dSP;

		PUSHMARK(SP);

		if (items == 0) {
			int count = call_pv("Data::ULID::XS::binary_ulid", G_SCALAR);

			SPAGAIN;

			if (count != 1) {
				croak("Calling Data::ULID::XS::binary_ulid went wrong in Data::ULID::XS::ulid");
			}

			RETVAL = encode_ulid(POPs);
		}
		else {
			EXTEND(SP, 1);
			PUSHs(ST(0));
			PUTBACK;

			int count = call_pv("Data::ULID::ulid", G_SCALAR);

			SPAGAIN;

			if (count != 1) {
				croak("Calling Data::ULID::ulid went wrong in Data::ULID::XS::ulid");
			}

			SV *ret = POPs;
			SvREFCNT_inc(ret);
			RETVAL = ret;
		}

		PUTBACK;
	OUTPUT:
		RETVAL

SV*
binary_ulid(...)
	CODE:
		dSP;

		PUSHMARK(SP);

		if (items == 0) {
			SV *tmp = newSViv(10);

			EXTEND(SP, 2);
			PUSHs(get_sv("Data::ULID::XS::RNG", 0));
			PUSHs(tmp);
			PUTBACK;

			int count = call_method("bytes", G_SCALAR);
			SvREFCNT_dec(tmp);

			SPAGAIN;

			if (count != 1) {
				croak("Calling method bytes on Crypt::PRNG::* went wrong in Data::ULID::XS::binary_ulid");
			}

			SV **svp = hv_fetchs(PL_modglobal, "Time::NVtime", 0);
			if (!SvIOK(*svp)) croak("Time::NVtime isn't a function pointer");
			NV (*nvtime)() = INT2PTR(NV(*)(), SvIV(*svp));

			RETVAL = build_binary_ulid((*nvtime)(), POPs);
		}
		else {
			EXTEND(SP, 1);
			PUSHs(ST(0));
			PUTBACK;

			int count = call_pv("Data::ULID::binary_ulid", G_SCALAR);

			SPAGAIN;

			if (count != 1) {
				croak("Calling Data::ULID::binary_ulid went wrong in Data::ULID::XS::binary_ulid");
			}

			SV *ret = POPs;
			SvREFCNT_inc(ret);
			RETVAL = ret;
		}

		PUTBACK;
	OUTPUT:
		RETVAL

