# Generated by default/object.tt
package Paws::Chime::SipRuleTargetApplication;
  use Moose;
  has AwsRegion => (is => 'ro', isa => 'Str');
  has Priority => (is => 'ro', isa => 'Int');
  has SipMediaApplicationId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::SipRuleTargetApplication

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::SipRuleTargetApplication object:

  $service_obj->Method(Att1 => { AwsRegion => $value, ..., SipMediaApplicationId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::SipRuleTargetApplication object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsRegion

=head1 DESCRIPTION

Target SIP media application and other details, such as priority and
AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS
Region can be provided.

=head1 ATTRIBUTES


=head2 AwsRegion => Str

The AWS Region of the target application.


=head2 Priority => Int

Priority of the SIP media application in the target list.


=head2 SipMediaApplicationId => Str

The SIP media application ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

