use lib '.';
use strict;
use warnings;

use inc::Module::Install;

# Definition.
abstract 'Wikibase data types struct conversions.';
author 'Michal Josef Spacek <skim@cpan.org>';
author_requires 'English' => 0;
author_requires 'File::Object' => 0.05;
author_requires 'Test::More' => 0;
author_requires 'Test::NoWarnings' => 0;
author_requires 'Test::Pod' => 0;
author_requires 'Test::Pod::Coverage' => 0;
license 'bsd';
name 'Wikibase-Datatype-Struct';
perl_version 5.010;
readme_from 'Struct.pm';
recursive_author_tests('xt');
requires 'English' => 0;
requires 'Error::Pure' => 0.15;
requires 'Exporter' => 0;
requires 'List::MoreUtils' => 0;
requires 'Readonly' => 0;
requires 'URI' => 0;
requires 'Wikibase::Datatype::Form' => 0;
requires 'Wikibase::Datatype::Item' => 0;
requires 'Wikibase::Datatype::Lexeme' => 0;
requires 'Wikibase::Datatype::Mediainfo' => 0;
requires 'Wikibase::Datatype::MediainfoSnak' => 0;
requires 'Wikibase::Datatype::MediainfoStatement' => 0;
requires 'Wikibase::Datatype::Property' => 0;
requires 'Wikibase::Datatype::Reference' => 0;
requires 'Wikibase::Datatype::Sense' => 0;
requires 'Wikibase::Datatype::Sitelink' => 0;
requires 'Wikibase::Datatype::Snak' => 0.32;
requires 'Wikibase::Datatype::Statement' => 0;
requires 'Wikibase::Datatype::Value' => 0.29;
requires 'Wikibase::Datatype::Value::Globecoordinate' => 0;
requires 'Wikibase::Datatype::Value::Item' => 0;
requires 'Wikibase::Datatype::Value::Lexeme' => 0;
requires 'Wikibase::Datatype::Value::Monolingual' => 0;
requires 'Wikibase::Datatype::Value::Property' => 0;
requires 'Wikibase::Datatype::Value::Quantity' => 0;
requires 'Wikibase::Datatype::Value::Sense' => 0.29;
requires 'Wikibase::Datatype::Value::String' => 0;
requires 'Wikibase::Datatype::Value::Time' => 0;
resources 'bugtracker' => 'https://github.com/michal-josef-spacek/Wikibase-Datatype-Struct/issues',
resources 'homepage' => 'https://github.com/michal-josef-spacek/Wikibase-Datatype-Struct';
resources 'repository' => 'git://github.com/michal-josef-spacek/Wikibase-Datatype-Struct';
test_requires 'English' => 0;
test_requires 'Error::Pure::Utils' => 0;
test_requires 'Test::More' => 0;
test_requires 'Test::NoWarnings' => 0;
test_requires 'Test::Shared::Fixture::Wikibase::Datatype::Lexeme::Wikidata::DogCzechNoun' => 0.19;
test_requires 'Test::Shared::Fixture::Wikibase::Datatype::Property::Wikidata::InstanceOf' => 0.17;
test_requires 'Unicode::UTF8' => 0;
test_requires 'Wikibase::Datatype::Item' => 0;
test_requires 'Wikibase::Datatype::Lexeme' => 0.25;
test_requires 'Wikibase::Datatype::Mediainfo' => 0;
test_requires 'Wikibase::Datatype::MediainfoSnak' => 0;
test_requires 'Wikibase::Datatype::MediainfoStatement' => 0;
test_requires 'Wikibase::Datatype::Property' => 0.25;
test_requires 'Wikibase::Datatype::Reference' => 0;
test_requires 'Wikibase::Datatype::Sitelink' => 0;
test_requires 'Wikibase::Datatype::Snak' => 0.32;
test_requires 'Wikibase::Datatype::Statement' => 0;
test_requires 'Wikibase::Datatype::Value::Globecoordinate' => 0;
test_requires 'Wikibase::Datatype::Value::Item' => 0;
test_requires 'Wikibase::Datatype::Value::Lexeme' => 0;
test_requires 'Wikibase::Datatype::Value::Monolingual' => 0;
test_requires 'Wikibase::Datatype::Value::Property' => 0;
test_requires 'Wikibase::Datatype::Value::Quantity' => 0;
test_requires 'Wikibase::Datatype::Value::Sense' => 0.29;
test_requires 'Wikibase::Datatype::Value::String' => 0;
test_requires 'Wikibase::Datatype::Value::Time' => 0;
tests_recursive;
version '0.13';

# Run.
WriteAll();
