#!/usr/bin/perl -w
# based on compl.bin
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 216) * 6 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer3, "frame is layer III");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->sample, 48000, "sample rate");
	ok($frame->mono, "frame is mono");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__

T  
0`iF
$bn
Fx;u`SB C*$Ɔ.K
(CCK:ps69I4
kv\۳&u&Mp} ~Z8Kh&"/4,(آm H\ |p|
mn6pnѪ$h3fhߟ:ƍ0T 	邁)$H0X 0,@|<Mڃ<DI "N+5Uad!\[eI=҅9XN/}FƯi+TD1 Lh@
A2jAa
aN9n8*
8K48L:@PhJp %(|x
-fxF	xFT
 	'od10P fq ӣ9fEau	ife-RS6ws*u5l
i)r@*7:%!(arZ/V8`tr^>ZR`3|@ 	T 8܆00R@0)s;S:8E@ x𐱻P.?T	p	邁.H5cTB:^RRUߥٯ   xs(S`S!+Йr )b-Fps˽Fn=˜ȮVOke:'0o0/0^=7Z2/IݒvBRà\?"+*yHCHT	"/0P
}uϛcmo5kGSWi8XP'%:c+GgfەO	ocWdGbfR祧J&M[G-8.9g1 0b03@>;#PdǀBTF\hƕSPPGuxMEA>XN.JO0լjT&
$A;`P5y4 aRU`\ -#I'2HE@+'+~y.g1]maw9S.yveOnB   !|%@`K&	!"5-ձʪJRI(ȸE~	j]x[i2W5g5g`Lf-T, 	"F`0P,aniNY ìdVCy&]$#Է+4iͱ&Tjg&¯qҹ]3  4 @81
fQ8dʊt[8D3\A&Ԫz4}TBdPebPO  CLa @T1
D%$;`$P#T d/bClekU*(Ξ.g4g Yu
-˪欥,g{|~=08ɀ	QN&4sDmdӮr
H.D$/:8JH#YRFmȕN+?[,{.l5al&*J2b-WH@T6	;`0P}ڐPLX}
@sRU D-BdФ>1dy*  5 J4qɀV `6.,ZCr`:ǳi,az.WN]SjuZ!, (FD :C0&0@ 0@J8M)# 0Q90啱bO,
ST>	%
Aa%$P2	hBԇ;^xheO?Xh   =0 A0 Z0 ',*n2KÑιɠ\,#}o6s^=ȝ	2d;`*ј !'@5200C0# w:1
bS.@C xFCM$	ՈҀusԂTE 
4E-0Pmmekzu%˽e<,  . @vсDɀ1h9 fCTm-ڕ'}bQs]Vۑ'kPH%{*hYHIxm@$841 uG`J	h]vˇbAt!TI 
)$9 <Hje'i.Y@Fj@5Bmj6Ppe!"ZLN=cBazn u@[EꃮCU9Y	:A|9Rn&$vhR5k(@,ݬR"&^-KBu%IR\ǈ%xI  dTO 	A1`0P%jaE6V 4
`К%rXO)PwymR	~hE[5RjOX$i<(S0Ah0P0(@`;NM4$9@6lsp*,4śaBd*5i}$Zu,8Q#`־y;Gf`` nkTW
 +ā8`$P \Ǧ(1e}
:)oi&^kEHCe(&*I2JFk
ڧ8P϶ PLSD¸$O=CxИ1 F1K(Ń\Hihޔ&Kv.(R*N]R)p#mU(  %E|00:
F`f'T]	(";!<HuŰ@`Q6 ,"{_nk+j9wv H @7&@f(	F@Fa	#HFW:t*ClZp<,@^Ekӗ{$`9.3-+9*A00<0 @|9QJc$L	IuÞҤ؆Tg 
,-od> H64,gPZ7ɡT&BI-̌y%p Ly5&uDbf`
f\p.e]&VO#n.hm_WOEfŃa 
U :D0Aj0P0(@`;NM4,9@P0	(.]C	e6ҤNI~Tl 	邁2!m쬐CoKRTvz*P rϊA
~@ٷFYrĬF2Ǵ{%[diZSŬj
eYBh  $ELgPf/Ha`gKp஧L\ǰX8EI'Nk%sr:K<Tt		"-! Pb  , 2
)1Pylgʖ^*jL
-~'g]_GZLn 	 <0Z0@S <:co7/#L$	Uz-4
(]FP̆-u[[F&Rڰ 
 T|
`%	oe$@aq Xi8E0.i}l<-ր GlX VaIWO:S:OmrKa9&!1#B0f04?UNKP\ȀT-Gj@8\y]Ve1k./kfe,ZddY"VZp S( ,M8TĀ	B6q0aBF1@ہf*z.>8^.PrTZm],y=(8Tk(нk  %\
7,fI&)ba\&`x'V%Iԝ0t,tPEaMk2V:3-C~׳ݚ  "8v10Y@0- u0D0 '8P*TĈ 	p邁F$H
j*(!wzzeUyu%2١R_c(;u
o0>n`|`5E_@F&fsaKzKCIjޗ+[Ԣ&Rd􈬱T   OR Z{3&!0	 ]0Ec4E1JO&8 PTTď 	)oa$9am/ܯ˥5?}b+َhS  "D
Q|	:рb cS.ŝ:4POBȴhs0e4Onn]pIi@ -j
6Qv"Hܤ&Ik,bLdqp\[TĖ 	"A(!q줐3aш:TǥQ  e!
"!J]3_H
4@%,.ik>
H36SBgQ$McW&!`: L^4]=csk,yt
u`6AY@.jץ*R]=C$ã4
TĠ 
T%ā=`0P1C0he088SJ2N&'Pl#a=*MHR.7q8D%ؙ7w
$Y2\"vNbڄ`>`Hr̦xf2,[N6
L`4"PVHZrӥt!PQ.JPU6\7j  8̠0TĤ
(+	ā' H0@0 a0400~A* qC-zljEC
Li5A{6:J(ۢ P@621M0yAN0? 9wC\G3rC	Fb.FKf
Vu[&)ZA.Su-AM
ZM+	 :чA0 `L8
Q2&	TĬ
DPZ - J䅕Ij	pZ	 b^b-'j\gش{(a=I P	iI	9(Q9(ϙ#b/C\qV:
R]ڣ><zŻ[z;[LEnkb 	D:A1&<0]0-\<M<$ zSP2j7ITı 
 3	d<!PY XO^رE{E*
 C-ڥ4j00N,0*<
ӓ>pXBgBQC^'EkT FT-r*CWtj>(;V,1]0A&0C 9`?3E2&Ln8qU?jPVD2J1V?tuTĶ	X	A-am쌘wăgBǱG )8})qxhT`P<j6.TOI;I+T,Y=W.>kU*8{1gB0{10?9f[@3bI|.'TZzE[Q,.RޭЙ󢷱kIo5fYZ-Xz4 T 		邁$<Pq`0`&` me6!FK)mZ(dg)4)r+vUoζ4g1RiD7myɄX h
QO`]$U;KSX\Uv
z	l_E"f
B `& FfAT 
(3a-0PBQ#Q-аҚ6UڕnKCcܠa{^Y\.BO  H Bb91t	"g˵N$ɉPCMa3nUY}-Bri>DY4AlhKTр	H#!H3z}ݳil]Z[N A#ď@cLTPՁ.նB  
|uF(I
"F fpkFjVNB<ARb(PXp]؅e~)\%ldG9얕0B0'-0@7Cl|ZICT݀
2 H\p,EбW1OέaSe`b4/pyA%iP P 9ʝ1tJ0{0>@9&Y83AJ "5Z 	.JŝbgU3(ۯ[U{DgܾP  

\4LPG`&Lκ1?-:!S̊T
'āI`PZ*.Pk1z7OB͔Vcrk@&a19ǨyQkweȣ8,ZE?~J1W0:*	PlaH-iMYBH T 0q0¨0S%0,@0_0@882D].-~})Υ,F0T
`+odL`<Pع`~vC{A\w J]AV  n&m9",xvª滗T"Yp].U_׻o܈7l'N(ހ "T k%b``~`K`. {lLc8lyPH6x8\T 		킁H!-ۍߵI-GzX9Tcd3ߧ PY,PTS D
 q=[GKWk=s]1?{?B|o; ʒLk" IL0*|Ai7.quȤΫT
l킁F!qYGsι] 
!!1\a9sP  m\-Rf	("
gğ],P$ L^V'C
*!8,ǵCO_?]Gv~  JV,0'4`iĲyI{~]Ʒ~IT(IW1õcx,g8վ]5W;QX9 ӣ1C0e0G@:iL3
B!T]\ĥeͅLlLB*^^Z<
CI!Fp ,`P ҉]
|8t<EH$ ` SӢ&uXT(邉[P&p`aKZ[Y؏j|MX   O	قQ\y h H(aDm̤H$}cXn4.58P(fqhP
!VtA tM ΊLl)YQowlַzT 
h%oDc <I\ҿo^#߽ܵH7Qip/,S{F/oW  4\Z0{0<20" :7s*pdN&F%, ZaqXcVަ0y]NGjL
gػ'aCRf2pA 0@Ήܑ^w?
~:cUT
N!%}.F 'wf}W[G< HDr錮	!1њP8ʛ.Q@6DVSE8znYSw/P 6 1~	LpFb'C
,,T
9fa`QT"elU}Nu,7..؃SݬO!K9k0F0S1V	I
w?a94f_/؂4ﷴ+HF;X C vTbƁp` `Zxpe@ QS=>:hT 
V A<I3FªjPh* (}cnV0_2G  "@ 1)qiʠ	Y:3p>A9
4lfkzUd~:Ωan5v a~Å Bx]7-@4v@$y9A3T 
T킁Q!!+`
XH
K=m9yrJe+9h+ 5V0AA00O0& "Un9-@88ӅKl)ţSm:Xsbx=L%hjw)bb|`4C\,o%hϏg<ܻo8M]k{9fmT 
"c$P~'fb>6Md{cO>0N>
LirpNA!Qc4%JghuԥϳEqFҦWoKIop.g_0gZNi * _mx7I 1 |p>5(厱i*T 
$%	āS`0PD{bʐYZ*lg!7D584Tܫ00= 0@h8N),AI(E>I֋\_O:mY,ϖS+P%ZXjO) p2	סيA_ihJl 펨2d{$ՖE^j꽎T	!	dP I8ɵa ]6p(I	xXe	 ,)`
	 `!S@Y0p{HumC)o7eW%˿JuK7, <;8"	( 0 >.dn<5`@֧	Ç01i:2K@TX邉e$PEU
n.^̑Q(s< @p p6bV4ʱb.,DT]\QX(=4<ɩ~G ¿tps`*<	PAW	M !E|_Nڒ:O@ny 7SeT AU`P
v;ofe6; 0 e0.209F:ˑϫwӽse2SB:\
dЬVG 5l = P0tB}x~I+)Hfeq_KWmT 
I^`g%#m:9>vy @ ;0u O00	 X*Y(3ypFw+y;=ֻy.V车,岧w?OmU{l  u`T0 ,HKLHؔ^	΍sWS8t3<LK{T ^`AQ'ʸ_6q筽ԨowȠ `  <!0
B0E`"%.L9_\Z,}c(4>*v~s%|Gڑ7}'y΍~h*S;tG毮^xM`&`.X`  H*l]̻L JtN>7&!漙7OT
d"IW $IcdJpM4E+6r<A00(E0>$
bacZuEM$PsYz tYaq?ʛS"b^yN)R N l pJ&\**>~;
TǫSMT
IO`QFI~￟
?kcK8ǺO;kx ߤgɉza H S	O4"T6p`N@ tz`-aK7<tz0}cĤx1 -DR  %Xcق;bjtP+󼉶ײUT
bIlAocGo<rzqT[S7Х1AU0.Z094PXClλk<Uu.yMRE>_'w#o1Qj=}X?(Ê
x9FP3pB#88Вj^D4w`;H@T 
"IT Iu+
?V^LcTۃ/kZ7uaJQ.4 H^قi>ɯeqŹCP"TrC(0랴= eNi*E^Mm]&̀ (8WRL51;B0V0*@;M4\ÀZ:sV
RLmT
AY
`bV֠ʛ^^"."宴L8Y2@0A0> 8cR32`JY4P&@]j )CcƆڇi:Ӊ:_vҵ)44ּ$
( CS|dI"D`Χe]0}?v|T
` AI=3'*_LU:u @4?b1gf0/0 N2e!
*F;tuq0#T$ris4YE6^cF?WΣմfu|xO|<K EUP8c
_]KѷR^mde6msT 
`A8 <Hl(tc].[@

y.6"$5:aS͆ԛ+MaL]D"뎵&0h: 6[z$A'r
U@?G09 ? E WF$	P-M7`4$$9^T 
킁Z <I{hI ֪ɶɩas!

1i0D00 0	@j0?0 " ы=[OlwE7kVn}PU:}zVv-yjżN |3x!ͭ@L|1WQ\w2^(0\'Eڧ*UQ-S JT 		Ai`QֲX 0iy4 Z1BؐT vR(!$6˞#
9H0IC]:ᯛBY+{8~
Lvpx+|(  $lΙ@L
D sV`y&
O<ԐiSOT 
3 <HHQ+M
ZE؇J9!IִWքF!O64@0߁]0d>GH5bS/I4+c,j'֓y8rL#0GIY=v[-G<8kSgFt  BPcL .`3 :%Pݩ{ĜSpV2w<T
EMU`P=ĹQzN[w\j^p	6K5+w4Ny0A0Y <أ|U4&
"
U=z`,kuvKyx)AT V 23yD0b^05z`$0ZR:C	"&<rT)	SPP:T I[-ì6 z9rQozJ8>9	5P#x5cEV00hA>Sd51NRQeLȴ *
+mUا9,SIGEv?rX ~݌a]f / PD # 
 :,fF!/ѥJTzT WMu*g:GkCT} P 4rґ530>0\ <֣|?4(M4c@H]5rǗ{f9.+*,(ihzصVUKCGx  )@0i0)E04A00|0	I4h"MAg<MD 1:T
 ``<Piˎ2-aThTC]+O絩~WBں2@x9B|pSbkE`!Buu=U8՟tϯݵVCG;`mO`/NSε
qu4 }PBJtX
8ĆVPHItQĆ	PST
Y`	p}ƭ)*e՜%ѥE:[E>0z-x02.00@4L|`qR#^U2sU>cX|Z1i4]u
I t=oS'X֔iP (oH,
q0RO tfY#͹'T 4I-HQ{,a;mqVHۅB  6PXѪIXClaEu&h{iqvtb_s:H'tPr/ 43C&h2P 'FA+gTSAPT40eKrSןaT(_`Ps<&:}:Rك	iA9#\v
^ɕ) `	P/

\q"Uf*/C(%rF)cb
,bPrlOTŦHhf F H M$b*H8S,!PT
PR`0P09joiDcnqUnLts{r+&E  @1F8B0i B^608ijY|"+C ΈސfJM%NK1uJs#֥X]O1H1>c:0o 0)@9ATR -1Y\*@4n
T
b ƎS.Liqbp
-Jb0:@0S70=dq[)%R(kv㳨@2=qN˦B3P  2E+! 	X[@-Vd!qXZc sT	f!Rd  ,Q,D+F$^cK
:g07R:I0-(*'/<+g]ڳkYbnnLyUW!NLlկ]y?k$_-M4@
NӍ CW<2:Ne;m[ԍwecQмKd{T
"T`$P5M}e**QO,ԓAg40|;B0m@`0&'9#@GZ-M+@1c3DT8 qm:<"Ef'8g }rL*CFE-L| &gTH B]	D%D1@/HZt lchNrX]
[V5T
If	`Pjyy0\X݅(a^50\<_D009 V=(͠6` j`KgNB?
 pο!nG;6;:
NY3YH+2SzCh
#.(H
n&83~ҥJmk#ZT 	"Ib`AQc-h|rpQCD5?j_[`n٥`TM1)JQ@Qr!i<HL5]rƙJEBQA	ǰۈĢX(rdpxXaE QnqeE N!< f00O| h[N1af{t]T 
AE <H{Z[*\n#Pi	зxswVPӚ HYq٨#pq(
p31~akQ3"%Z,M)}eP+`õQ`<W4Y ESi=`뮼f`^ 	r¨X	5Z4Aj/TPImA<QPQN
iat
1+ kML<]k1R<: K13B0m>YU5(&Q0<2궩ȦlO@,Ϗk1Tc|ġD)r/[$Â?  Hx + X*
,]0X@{_T 
[PauIu!qi%E!toUblEaaB+zL  1<'500N&:jSa`3CsHV$o2	%AdI -T`6MYN8vWR#(q1	;1\0i<cq4 )	1   GӗA3.|M\T
SaPj&yuyn9^fcl^L   1_P71#0dM=;zo4s @x~dn2E_|bfb8cd}(-bƽ"W31|N?	$7э(`ƍ!0^"u@ШdD?T
XS!v)AãoEu0lx$1I1V;:1u0}@?365apr`UKygN) 8/>1 ֗4s2TM
Bn$"D L1{)
1- 
 E3hr¥wBm.4\Pԙ
"T
`	D`P֚&V,Vr)(Q
kXzu$9 T@0N!79U0B010[007̣Mj@χK"B|܊{_ӥzs  a v`
b`RM|<vA!#\eA<J0]*T 
Q`<Pmi%js
V14  )$^"nI )@:x0qJ0,I2=1
*8hIl,~s<BXUM}^.Iagw1i!ET
 @F`0҉Pg/׈ cm~}cv37T
e`I՗w=]m-nܴ?f#;\AOh0E6 k0A0" i=50EXj4K-ދwOQ).k'|I=My?ԆK/iiZʺV| 4 v \1zX0Le!/aj^md? T	#	ā`PKIp 0(xREL)㋒  084N)0!@0H3t
d1dRZ1(QF	n,ơu	=bk6
*PJ^xV}fiS\\9x 
BH4p\@Ϟ
q
KCD]1CQ
T 킁e`$Q\c塈FhΉ<u038};1u!0\@:]23!p1Rl4@Ol~FΟ]X:;R5ׄ/O~ȦL_;}e}x l61()HD|#
rC4 E+iTCT
"M`I<aѕ,p6r
>Â^E!Nl= aZ2ɩ虇@0Έ>blӴ`P⢌iݯ\ϨLpí`^ΫaB,+V1"V
 晏2H T-S:R4<#zQ(ִqT 
1aP=ezZB,yj<"PՓ8
yp*DNf5Q4̢C Dh6"{b,,J9IMz*r#hB
%o,$We&*!0XORWILhh +,t*DIZ::T 4킉iPL&8eSԖ.*1(JIm}5谛I"ŏ  @03h;3l0A8|h,LV P"d3@](4 H!fm[*:NEgʸadLzj% 9:Px̸$$^4P:(G\ZpT
K`PTrE\:(N$+A@ۃ@h A 0`34C^08(D,\U/cv9ǝcjKNXAMrz8cNe1(:Ho0 0\D0|1V0
1 R=j{*['
L׶IT
/KP긐$c.E[֖©0S2{۸60>Fu94")1aYQ䩓].Ņ5gzjI3gUѩa-UCKPecŉ-&@v2p #Ia֥ 	ZN&u7jT XIPjHYh"J&țJ+6-l+r0d/1*{8ou0@<Ec,3Aqr$0N7=\|~^_i5#^y]}i_T   4N  8~FiAqEY<cT 
	^P&;[ˇ/jnzO2e{ѷ  !  aPmX`n0 BhŋA42G]k5=$gym.O]uݑt%bȴfs~k[я4Wȯ  8&|Dݖ5xed׆Gli.T
V`Pu.
yS!zDBhTTIo\G0YB1+9Є0=l+3Q5HY%ևVWqrͽj4yӀ`P4XeE.? h's`*p 8@1.
(DZ<]$pۯj
T
킉U`/PViB:.XM&LV^	)a/tpFaz|gi&LXccFo9Վ8⋓5H$*$L#,̜O	lb\e+Dd<o ?|珘W!RVh!ӈHCiAD3tRT$KIW`$PKm6R1baUc`u5 @0d '1]:r1Dw=0p`s<10Pˤ>
mHZ-J^)fMfF-j4ObW40dXD$֌L21&vI}V-{A@`F2T
;a<P2qkuZ^,fU
K5;C
0Zk1Gx;1T>CL10 =M0PƚKQ@)6X]qsYVPhuC
H`:֎R5 3)Q㦼ko6@_HI.q1T
f`P9xگnnz`]Dgp"	[ဖLQHHB-0H ,Ke*ơ2B6:{ [
YT L6AªT4)0* )@ S@Ccq	é4C%-1A

,AKo풟Mk}w/?T 
4	UDP0w/NUO.PkԹkoyu Qz֫bkK aeT|6GFشs)X8bze
j8PXmfJ0 a
d> FݮFCFs2!,Ua0{T 
;<PIN)IP7xieHh=l H, F 0@0A71?0:i0 0;Y52G.Z?a$LYԘkblˇS˝>3**hM`$,,*Da2ד58 0A(0D3[1>;=u1%0 0  GxsCST<l`Q"DC	8ڹ31{.2˴؅*  aK )#1AaA4ῦHcR]cWAċ&䑽
g߮unwMɞsH 4nva41( yp*<`	X3JT
,邁R`PR褺w'vKkGܽZ@Mj V@00-?2'%2l
8JI1 Ϥ,` LZ0
uu+wD@Dxb|TJ7
3%CCTZ"͊SWDC/1\@@ Pވ o T L!DJPWcJ6HF\TNx-Mbn0=03D0s0X6ה!FIºCjaCy ֊7=QsP۩2A &P8. X,ElFBtVkј&<Nax_,H&0T 
)ā]!!Yrg:jmzmdT5U)L
+{
6c@Ks0	0@"
%0T
PgSY
1(<q`1Sm{1rL38qj`#K%&IT    pH49\ @AcmbV`i48s:KT
	^`PPbс
,r#~0K@{Q[huN  .@4 ;T+( ReVAI2#!r	)4H-OѡmJ\^OZ   SX(
	cl3Ԉݙ3 嵀4 ۯ{T 
B^``P;~mOjuhkeՋEU$
h  0006[040*5(7U2C 8zeU˧R,ɡL9E@j6$8t@Z  9T 07A0Q
0QH5˥0A0>>PpdMXx54;T
Ra-$sXPT`J=aV\}ʟZ=TQm j L`J9M߱R"!R1	LPyea@V5H
Q⚽ﻧvG  @t$`kHV^,~	a*ya2f܂T
-	o$BaIlҴ%(P<V 2EYSD!bYAA@0x!Qwr-$ST\0M
F)CIk% A[V͂hq<à0|,EwY$ApTYhXzTL)dV!qJvxpE1(bZt8)M( 	^ |l|eI1$o'@njV&
FӅE0"LtYQr_H`o ( @"L
4
T
L ` ( 4! \P"9<QT 

/DeP S7ee9
;^}+ӣg"E)0 0j0I{5&7/0	V07: o B%	p P(Or.REV-wUu )!a挥j  %@
T&<0s0q@@
%h{n<LT
8aP뭊 :DZ\-$OQrec   0& Cafi^hLa_` T`QZ`- p` XcȠ 5)u,2][CՅHzi9-Þ;è`=#G0% 0"A040/)1YS0P pj0+՘keYAT 
"Wa!<PY&h: ԐJ]}#QAI 0@=0" 0`]2H5o0s40/@0X0@?0!;  m1ԔxMbWB܂W1tI2V9wʞO 
: )0 i02 J 
 X­
UL-T PR!`P$iAQERldzN%BZ^ipSr8VuH  C(TLĖyPp  40&s@oj'^`zi&"41<Y.PХnXUxyТZxpchVg=s-a%.`d ,`0*` 4` $
:G6	ҌTT  	8a`P̹HJaUOR<K
`,`8a2r1a``J`1 ` duq+r[?$TmLqK $&sJ/FiK_< {فɟnQ\pXTl2X$DT 	lPj&Xǥ,<U]+vp"U{(07 
 1kHeF9y1E0d@02z0@c0@A9$2IEL7;{BhP]BM
jhbZ +*Q<62iW  vJ .BSИȾh0		6T 
}"9P)%JV,7Oי]j010=ū3`0u0*0 7
 EcysJbF*=`7IVʊ!uW0e~[y0L20@L  JKC'	*9	ǟT H"WmR_]౽ eރTa!0|X=HQ(10U1|27'j40B080@N0 	-`!t2~JyJa/rebRR)yS:  X0bN@,eIb K8óÐ TJ\"@88LT
"Rq57}ʹ.St֏ufPtrS07  i
ʟ>SƙSb 
m=	@ t;Qq
ߨ@r:b±g=$Ϋbk&GljO j+( ` . 1zP 0+
x&;	FhCoeT
teϼPk@ʄcER.xC5}zX	S>  mJL9jрف
d!	⊦ pXJ?WX 2u3W{0eutښ̾kvB>P7L`@FFh)aVkmÝEΒT	\amȐpb]{]yD;Q?{TPR`L]p1ȰL1@S8rƽ0@06 -0@R`æ8,H=n6ɥ?O*:(zckuR  6n 0"0@g0? 06B.;3t1[0A0.0<' ,T Bk!q䐓0D̒ph"Qݰ%c@EFk+  J%pgKA9~1ِ =>L=y^c<
Z&4-Z1}~C:<  p  0 p-LBd HpLMbT 4'$EP	oS<9g)nϻLaiƃg  p	$V @` ,L
qV3b3L0xJް".4^V.K܏e%PUN5^+ν_   0+ fh.Ҵ
L;|L0
qٹT 
4B]uWFMJXnN}dEEC"=UG٩j  ڑ  @I0 0A302B3fZ7L-c0 D0]h?E-Dq6EWK?jgx    
( i#M$@`T 
#
wD]u zGJ[s*RY`qw&h0qFb4VA  @  1  3
0Y@AL@#Pe!ca%Rs])`˂nW  : y` f@0a*l^Vk`6`n`
.` `T
`'o$`eh&b
- Qfb!!VS?J~ޮv  H\PENWh&  xC_Csth7j	_qe¨٧  P ` 3ᐻЃ^h_Lhh
"@ð	HT
#
/D]"1d	ڄrlUBt0OQ9AXRԛ  Us )8 هx8x49@=!iZT
Ct`)/A[w$X`:gO@ ; @  @HW7K"|x8;`T
/$^!Z!`-V{
C.xHVD9L<֒gꊽˀ&Dl9^0}X 4	@.UPy|L
Tt)L=B#4g]VI~  uT   BC/s	A  	#(#3t T 
t+DIl*rbXZ6IN}@uJ@&g  * 0 1|9>ːC;HP 4`\ո(:7|@\,f9!8u>ww? ap`!0a*jc cWeU
`0`U`8`Mt/iÔT
+$K!萗t<hĜOSZR3ikKBV?   @mRlÃ:T
\`#	0Ux	U6I\u8懔(:}z%^]  =@&>`[(j%*``EH`V`π>0T 
\#}$Llbv4 i%mM
*,!C>;  : 00#
Lf4WBPƝ. |«t+4`A&s1Zݝo}hկ 7( :da
}g`
f~`%Ҙ6@LuT
).$gaa萘a۱ҁHs^ciF;j{6jST=~a@%dM<P
 N `MSfzu	b3TЗ=c?Qf6>U  IU jI&`i6a 
`W`O`
2 T 
3
$KϤ LRMnDb zMsP*AO?l   w N
dT9	p&`rPk&Z&h9f0X    +Zr>\RaIy -R A$ɡ$Z`b(hGv`ňR`?v`@sveTT)
.Da!Lzed>|djTI(Đk?G[1y0 150PD1Ʋ˔q#E:u9XC䘌KTJ'`D3Q,x 0 Sh@bpUC҃[YH.	h T
x'
Ia񯼘C 8s  @.f%LhisMkd~&x$R}۩WO  .U P
bDFRiM`avma\`0`QJp7ѯtwUzuUj!WXU*"Oe@>8QZ *iL^!i$9q	T  /}`aQpT٭z&a6nS_0&3s!hmLgыչ#,   QV$8-zDS@"M3G 
 #   +s.XXzhxlwg^Wz<   W 
aFFfhFBa(;
pT 
#Q导Yt'"pqL:gLɣshҦ   H ze[7ɀ`0*@01-0o0& W0@*0 0@ X[aq \f [Z_`O'  TX+ȴ\sT 
)
-DTaI䐂GfX
bt#ixѱnӥRI1r(   ]$:aO欏RfmCO} 7
`
@
JP)7],`Əkܧ]Ň3
3pƱ|U
q>! T
81Y᱿091v-ede,Azz,}XJt(rҔơ)aA0 50A01^o8؊0 0"$2o2a.JDvd>+b!@꘵%>Yik.A,޸   s'u4-ƙ
fy
C P T 
1}F $  	Ai}
"J7}   W@`.	us
6c1
0V -i+ pAhRup5Ia@c.Հ  P62$iF	!z9\Q( df0@|^1nxT 
|;|`c>R_8})n[vf  6 

0+̆ STyySÍ
M2@8L /Zl!@+LQ2lNp*R=_gmUUW  h վؐcpwa	R`Mdd4af`IH`  `TT'$5q` & iO@6LWr0)@}*  খȞ 	3
p@sHy\1p@p
4;ARZ@*)K5-z{qwC+ 3 Ζ&/&#FnF3e	h
T 
d5OaqߘئpK`kYbO,ݮh>AA>߿?o   L\Pp0 `"dq`>`6hc/i	$ @ PH8vfҗ$E9֪83뾸  LjfVvf !PimTY/T l+
-jؘ߰`\`P[5d3^;wEGGVVߗ  
o !'($AaF6!a"eRGf+ ``-.Wz̻Jܢʔ0ʒ ee4jۯ   
W}[# t '& [0)t Lh J 
[T+dNA!

}Mw+E䴢3}   f}XP9``]^`M$`v(`jb6J`5``M s[(R)zOkW]/   jK/,N   |3	0P4L T 
;
9aK- ";yGy-#Ln-gwv} !u6`q $9 DI>d)Z	viQɼt4Q@3M
.O^/3iog  Pl!&`+/ \ KH@ǘ#JfT
--{$X!qϤؑ1/Ɗ,S	C*;gw?O\	8M  p T. qPTjƩd٬ qgӭ^<󆾯Ipf_^a:)MVo  L<LP
@ &Ljތe T
/
DP᥯䘐:@d 
jXz"ktu߯Y@ qM  0 (@PLN`ƌ@N@2\YS*rH
*6( >U-cw2)&Zwt}Pp   FR +L615f0* W0	#c3u32cT
H-
$c0O!  @u?^&PZƔ}߷i@
E < PF &F8MF:`A&P`$DaDd*S\lAĂ"PͿҞY   m@"\ 6 Q: 		p$:IT
-$bwyp98@q⠡u9^	@p   % K/z* `   p   3$c
CM\(S#
R?2pBc SԵc1#,Lw_FKo (
2 FF		0#'zF` 10@T  /
JDT!4ȪJO[xtTEQIGwӟ(P   
h >Ek#C @`@ ]qIAA/ DPLHp(M疇>$)[8h1E0   3;c   8s T T89YsD&rPT 
/
Fd,+ 0Bq8D+LN?-"	P؆?WGI  8 )l3000Cn14C0K0@]3S665R[,}Ġ}
 9`4(00
<0060D6EY0@09 5ǃGT 1
e!4.HwWS0q}W}jm	Z   N1,`  `4` ` DŐFD $351P
aY2CO
4ǹ*`%%00 0@00.@\0|K1a0 }cr'/T K\$t{}FLNP	ӁYƯ}j."  qP2A@ h& f8U&
SOU$ K-&ZB>)G$;{?%@8AZ@)1@KY1恙ZAТ^= <@T
DEfS0diW)OiDW)?  irV[ ! 逖A&٫i>I-;z$Wp
{	0b},[>}=}ྪ 5@L` `` :``A`b;`rّdLXbPT
7P%XjYu\xp 3K?ci  @ Bʀ&@0 0@<0+ 0&1\6U=41Y0 08	 IץOw &orC=GHn!y`  `"` H`7`u aynj#!,`*T
`7eDat  Ǉ%USf"hSYًGvi   wCCT H\
0d#)ƄO4<dH5<%V9+APvʛw--}Y J Pa  XL(+F# @)T 
7
Yᄯؔ|X5Ц%X&\-ϯM
  @G@ILBɘ a FA+O B@e0@& \)t6tnj'si=_  p}HDհf `*f `f4a08<F(
F XT,;fa؀ r3~YOww_m_*2qR̏0kP # ; 0A`1M1\P(kphq:,5jJb[zCobJWV   	 )Cqi0peS:A
;az!l.#h^^ -T
;{^ / 4  h>9qϫ[(@"sJh
`8`ac?d4՘0y2(] ŃFH	 ' .a$' lUԝGˣOFKd 
ޥprQi&Gb(f?0&8g;(?(f ) T 
=C_|0jڵmZK+"%Ki
  6 =,*̦
l)B%:4(c
8VX	s `` KV
ܡv1j]GOL 5R@K %}k@t T <= \^|؀6 X tlzH
"&$z5^^WwN9ti  k_`f!``!LpLi8LVp?L  Uw]A{\c-'wmhwL>@  FUf5ĲC!PL
0(!Ma@z#L@T 
=AwTnL @  =H\NBp<U~kiW   ̲Jc2 A31
ݱ"*qقHi 
 @@ '[)E|z_    q$~?0 -`BaAnjb	4aET
=!se!|`G` h`>` 1܍A4TJ&jRwF  zS7 :@0 80@0Xr4EV1%Bs0+@d0  (W >f$*by8J  	 9@?'90 0<I15DƉ0t@0 ;0T 
?
se!-@A $ c    |/G9WY !J)_i[A"4,p@@(E8ġ`zX :L>@8 H <[bJT>k&   z65"L	
0L5p0T 
x?M"|,|،  @LplTnHrf `]iv	( 
0P0hS4=0s$ Iq
oJu&sN>
p @e?aڃ] `樢ifEx6f	@T 
tC
YaH-
N r_l揳SQownWep  KvTUP\" *j1р  9逊sfKB"rMzRp ?)v
]P
 hd m8T
Ec^0p@SׁҾmLx `=gZe2Qg@@!F#A񎽘*xSA,  4` @Y[]*O+v%˫fFLo.@ | D;. xS I\.`;ǯ4T 
|Ida0<`h"  
>Ĳ۵u5˗o
  >[(v 3X|L2Ʉ@, x %5,
9P7S*Io?fv%  
iy ' `0200(0@S0"0QB%15G0T 
|G<!Aw0p0 -   
*LrzYƩáfW% ݗ,w%pmEsL
Ad3m$ Əs	HLSD@|X!JGMc~a@	@ ߇ 
V%`cT PM
cV	|㤘j7 @
@/btT|> MFh`	d@L"4(C|Ĵ4ILt0$ lL ( }\@?{޿v D  .@&0AL0@0(>1\v513@0F j0T
K _"0|500@0 
,E]   < 0g.`$`J`2 `Xb%ap` `Tb`( 0``
   	܋£ 2  {F I@&0&0@W D`%` b\hAT Q
`O
"pbE` `=J`  0`.`[WI@kg ?[1nIB r!H$` !
 ){8&X\B,@3Lp
L &?UR>k{%& h    +"`&'T
@S7L
a|&" [/@ .[}?  `|u;}Ր[0P$0i0 0wA14ƃ040@0P0 8C ֯x	,oz~pIwdj^椐     @Z/C
^T<S Lb04u$ h
 %0
5wM?j!vtXs,91K*`` Z`0`$d/bE4`B`% ` @`+~`B4KS|tVJO >
uʘ;DU1l    L	0)%VBTDQ
 _!|0U 0 0E0W"M܈nQOlWb*F"}AVҶpf  H xE<
8ƻ@ԅ+t8- l( ܏ѷ* yL2Nc  `%LJa
;kT 
UV! u@Bۘւ 
RT ))XK(w#	  a=9rMAm  Y0 Qf сR/HM#0$@Nb7O`W# =})8
 00 `GBC	C֌+LT 
[L @! 2u;νwu Wd~"~v_#
  |tU DA ǜ`\m<d  < ǧb{E˵r(t4$` Z`#` aah`J`d\`1T
_Yb,  `P` " Mv-{G8L} 61_UĲM?yR@0 A0@d0\}0i+0M2o3Ɵ0`0:0Ďo /);Sl֥.MRA9 .?`d0
4I'Z
T 
h_
 ?}   $*t~拎3k,ӓ
 dA+C5h B& b>F:`^ c|)~x5&Dd0b
 0D`

  /խiS? )2٣/L@
	0`)LT 
c Tb} 5@- +PPL p@ %
Nx^o>}y\12`` ` J``=>`h<N`>`À`4 d`>`` 
 %[J߅2/uHpp @0`
`-l`>cicq``T
ama` = `% `(b`& Aߊ[g* 6CZd_w6x `
 60͘B08@O0e0 0A "`8nf~^~R" $0@O00%Ai01:T0 0Ai0T 0c
 J  :A0300 a5cR[ 4ZN3
s_0*  F ` +N)
C h8 %gPXvtw[?P)2ß{{ԭy@$p<5L\ W%D{T	e	c
! ,h\
! kۆ#t}E 7{6s=zqWL v $	#qX p) 8D eܣnnf?G(iB4婕,;ܵHڤ-9 Q: |1邐qz&T 
o
 Xa Ʉـ&( BûK|OeD 13Eަ>,!%  `(:`*aVakA|c`P`#`  # D an[?1zW!$v  <H>b1r.r᧦a" !H*с T
s9! LKl3
$)  @VFrm ȫ'6wJXL-,x	!Bۈ#1@8-QB4@   j_^?   {1sdF6]ߺ(`  L L LKT s
 ^ #M,@
p
L P@ !-xX  >U
o% 1 `&9/tdS(4FF>`BFPk'_7UQ]0 X,.|ɲcÅtTu
 Ap 
  YH3*   9TgpUNRA	1p,_PY	Ʌ(/ @	&Nm*^|   ;NPΒ=( 4 3pA:0ʘ0T
uY( E@  bg&\Wb)
   X (  'mOA0K$"0@=NOYWg?OÀ #
Fs5U1rL @0gAQopT 
y C! }  %L`@ kOwWܤh *j` },,vWg5_]=o%	`D2l^8/	 P 2k_m 7x_0X<nk s`(0?S0ST	܁ 	h(()5؏89#0-C /3N;0  `޲5^Pф59H/QҘdUy)F;
(c   |ĄHA?ް2n"018ThAg(Iai), ` Ɠ%8  55)?~?tLq   h i0WidAġ;9-  W= 8!_zmO 	Dŀ ))q?MU?D FhL!@LST
ćA_"0(ͶĜ0C'cQ\<I}|%R F   uοK 0 0*0 0"1H4UA00*
 ض +H   F	\[-K_V|!T 
H@AKb(3 f0>h>XC1s >0+{H}K|

 =W[,h7?;y `f`&&kKyGpraf+`<f p` !pOWA
?j)   l$T@B 1?O;0 BT 0Ab0 (S
 	0S4<&<2S0H  h
KP y9O~o*ilڠ @d0ї&.Q y0 (of 윹(5u@ YtàTA9( ``Ea	d!^`
`	`vl`h# VH	x э~)sj\  a9k"WVUѩ$  $? }e.)a $H L	T A_"t(<!a  0	6 A0S7"S$čG  	T_;Qxd@d`FfBHiEG/:d4
W`bF# &+:m" y3 S!c ``(T 
hAWp)r`F!>g8
|{pj8nnU!x X 0Dx@1üP4鍼& 0;@ X
  @'Ao%z?mXK  MΖM=~?vv`T 
IVdiZF#!`@%a^'\df-(`0`
%L[+  H̔T1_9+0(
Af`
f¤gv llZF
` , ߇ `  ~0[ r<T 
pAVph @ >P2OӐN5gR0m# ## eiUf`mh  ;9MMշ}5h7 `@0B oTDB aA p*T̀\l  ͵l#YO:HT 
 A`bhb!
$AQ8YiRх Zi,@ wxa,iad]S 003q0
S;$@:LfE0S0( v\   3L?{FV̷oh`ghT
A[bhQ" E-;@d8o2=ax0D6!F% X`ek  =pPxܑ/%2-}_QHԬ8A`@
2yHIA$e0@8'4=D@
 >fbM`ֈ}Uѭ֑@   `T 
PAZbh  xd#6kQm|O`py@.

`r!ˋ &J *`2 ֻn43zH007 )+0.0  0:KT<4묠 jrrsDUn}^WY$N!PT 
ԻAI4h	a$u0+  r]1@ @@$ @%(  $vcRݿp)B4 0	1B ?a7'Ǹ9P@cAI'.~  a7kUR*NΆͽA2(.q(T 
AV$<hApuLhz8@`p("Ef wv}  ?4'ӑx֭kf]Sd˄ J D	0SW@r&E@`p (1"
5 7q/Kк:HP p  `$T
IIth ϖyŘ6`` 4* 
5h .Chx;}_ c0B	 `@pYhX }Ĕ_t@`,:!H
\  xxlTSV%eU;PZ)!`f@T 
pA^h cΑHͦ`< b$k . T@9aJ# 
h YȘs6z+R^Z0
_@2 ڱ7H-P0J P2L_pց  57yّIUԶmvDL84k T 
!Aaci`GP= kǬVvr¸h `TfĦ.& wwq =$tVZ~H@	0   .	Kg 
ē0`H	uP0->ËP 	z!k7Z	ޭh
X0&@P>T 
HIRciB<u
@[T'z00@&	@ ?q!h	 [] dS}(;6]7%p^ `0D1RA ;+%QBD
 n El@Lg,8+p o-"y^VŢ@ApT 
IW#h 0
@%ܵ 9 @[SB@`W]fiD  M')zRLp	6020
Az@3 @`
k 0x Z<Ie[@ x˫Y FwSeiTZ鲓KUotCfT 
%APcq\-.@@P0  y<K
Y1	`.`, 
 9hIzߐ~WZj7""T  B(ȘCX 9$E0 @O\ _\Q-WeMֻZI(T 
ˉW$<pk003 s
7 1v,b@F`_0_ ϭ P~"%^4Fݺ!Rh&@n,< [* ^z<Q1p
 ɡ> l	    "JML"@T 
ˁ_4sp
al(V8<i!n( xC'(Q2m1TU4E) Wj0KDH^Ft"Hν[ߤQ<]feZA,JN, cRRT 
ˉ] cpU=ove8YV
c祓z5.vjA6ez 65@Y 'nVvu)*FfkWuILad A˧__kTxkRJdFTwCB-Sp2IOZgRUmT
ˁ= d4 pTb#gio^"<fhGmoפ$^%A 10`]F.'yn9^EdWuu'K'
fƕﷸL`_lp^ (7d?o$J1T 	Y  * ݱZ_Ⲷp0b]WR"I"WZmvw~Եj
fJ\_ )RoJW3cR3t$oZi$lhUZ
B 5DdqX4Ri)'oee3oT 	U  4  ݰ}.uEg9@ƑS^]ju<	KM[d)I`ӌ@D4ӫbNjXDXWֵjh͖w{V޽Dh9KԃDuhT_  9  ]?Z`E	dcsփ-78fho~4(0)ޥ}խ()ӉLG^WgQfUse&`ZK(/:Dh%``\'SoF^+1TS  9  ].&Wb®,(I[)WAhe[~qWCv}u/RdN#;-8(|L8޻Mٵsc4NlP
A~`@1~q[3 Zd2T]  ) ݱG$01+^]XGˆ]e.k~޾0~B
8RZڮM'b	)og5N0؁}_jNy#CU+A{Pp
 TTqғ{:4e2pETyW   ]P
