use Test::More tests => 151;
use warnings;
use strict;
use Graphics::TIFF ':all';
BEGIN { use_ok('Graphics::TIFF') }

#########################

ok( TIFFLIB_VERSION > 20120921, "TIFFLIB_VERSION" );

is( TIFFTAG_SUBFILETYPE,   254, "TIFFTAG_SUBFILETYPE" );
is( FILETYPE_REDUCEDIMAGE, 0x1, "FILETYPE_REDUCEDIMAGE" );
is( FILETYPE_PAGE,         0x2, "FILETYPE_PAGE" );
is( FILETYPE_MASK,         0x4, "FILETYPE_MASK" );

is( TIFFTAG_OSUBFILETYPE,   255, "TIFFTAG_OSUBFILETYPE" );
is( OFILETYPE_IMAGE,        1,   "OFILETYPE_IMAGE" );
is( OFILETYPE_REDUCEDIMAGE, 2,   "OFILETYPE_REDUCEDIMAGE" );
is( OFILETYPE_PAGE,         3,   "OFILETYPE_PAGE" );

is( TIFFTAG_IMAGEWIDTH,  256, "TIFFTAG_IMAGEWIDTH" );
is( TIFFTAG_IMAGELENGTH, 257, "TIFFTAG_IMAGELENGTH" );

is( TIFFTAG_BITSPERSAMPLE,     258,   'TIFFTAG_BITSPERSAMPLE' );
is( TIFFTAG_COMPRESSION,       259,   'TIFFTAG_COMPRESSION' );
is( COMPRESSION_NONE,          1,     'COMPRESSION_NONE' );
is( COMPRESSION_CCITTRLE,      2,     'COMPRESSION_CCITTRLE' );
is( COMPRESSION_CCITTFAX3,     3,     'COMPRESSION_CCITTFAX3' );
is( COMPRESSION_CCITT_T4,      3,     'COMPRESSION_CCITT_T4' );
is( COMPRESSION_CCITTFAX4,     4,     'COMPRESSION_CCITTFAX4' );
is( COMPRESSION_CCITT_T6,      4,     'COMPRESSION_CCITT_T6' );
is( COMPRESSION_LZW,           5,     'COMPRESSION_LZW' );
is( COMPRESSION_OJPEG,         6,     'COMPRESSION_OJPEG' );
is( COMPRESSION_JPEG,          7,     'COMPRESSION_JPEG' );
is( COMPRESSION_T85,           9,     'COMPRESSION_T85' );
is( COMPRESSION_T43,           10,    'COMPRESSION_T43' );
is( COMPRESSION_NEXT,          32766, 'COMPRESSION_NEXT' );
is( COMPRESSION_CCITTRLEW,     32771, 'COMPRESSION_CCITTRLEW' );
is( COMPRESSION_PACKBITS,      32773, 'COMPRESSION_PACKBITS' );
is( COMPRESSION_THUNDERSCAN,   32809, 'COMPRESSION_THUNDERSCAN' );
is( COMPRESSION_IT8CTPAD,      32895, 'COMPRESSION_IT8CTPAD' );
is( COMPRESSION_IT8LW,         32896, 'COMPRESSION_IT8LW' );
is( COMPRESSION_IT8MP,         32897, 'COMPRESSION_IT8MP' );
is( COMPRESSION_IT8BL,         32898, 'COMPRESSION_IT8BL' );
is( COMPRESSION_PIXARFILM,     32908, 'COMPRESSION_PIXARFILM' );
is( COMPRESSION_PIXARLOG,      32909, 'COMPRESSION_PIXARLOG' );
is( COMPRESSION_DEFLATE,       32946, 'COMPRESSION_DEFLATE' );
is( COMPRESSION_ADOBE_DEFLATE, 8,     'COMPRESSION_ADOBE_DEFLATE' );
is( COMPRESSION_DCS,           32947, 'COMPRESSION_DCS' );
is( COMPRESSION_JBIG,          34661, 'COMPRESSION_JBIG' );
is( COMPRESSION_SGILOG,        34676, 'COMPRESSION_SGILOG' );
is( COMPRESSION_SGILOG24,      34677, 'COMPRESSION_SGILOG24' );
is( COMPRESSION_JP2000,        34712, 'COMPRESSION_JP2000' );
is( COMPRESSION_LZMA,          34925, 'COMPRESSION_LZMA' );

is( TIFFTAG_PHOTOMETRIC,    262,   'TIFFTAG_PHOTOMETRIC' );
is( PHOTOMETRIC_MINISWHITE, 0,     'PHOTOMETRIC_MINISWHITE' );
is( PHOTOMETRIC_MINISBLACK, 1,     'PHOTOMETRIC_MINISBLACK' );
is( PHOTOMETRIC_RGB,        2,     'PHOTOMETRIC_RGB' );
is( PHOTOMETRIC_PALETTE,    3,     'PHOTOMETRIC_PALETTE' );
is( PHOTOMETRIC_MASK,       4,     'PHOTOMETRIC_MASK' );
is( PHOTOMETRIC_SEPARATED,  5,     'PHOTOMETRIC_SEPARATED' );
is( PHOTOMETRIC_YCBCR,      6,     'PHOTOMETRIC_YCBCR' );
is( PHOTOMETRIC_CIELAB,     8,     'PHOTOMETRIC_CIELAB' );
is( PHOTOMETRIC_ICCLAB,     9,     'PHOTOMETRIC_ICCLAB' );
is( PHOTOMETRIC_ITULAB,     10,    'PHOTOMETRIC_ITULAB' );
is( PHOTOMETRIC_LOGL,       32844, 'PHOTOMETRIC_LOGL' );
is( PHOTOMETRIC_LOGLUV,     32845, 'PHOTOMETRIC_LOGLUV' );

is( TIFFTAG_FILLORDER, 266, "TIFFTAG_FILLORDER" );
is( FILLORDER_MSB2LSB, 1,   "FILLORDER_MSB2LSB" );
is( FILLORDER_LSB2MSB, 2,   "FILLORDER_LSB2MSB" );

is( TIFFTAG_DOCUMENTNAME,     269, 'TIFFTAG_DOCUMENTNAME' );
is( TIFFTAG_IMAGEDESCRIPTION, 270, 'TIFFTAG_IMAGEDESCRIPTION' );
is( TIFFTAG_STRIPOFFSETS,     273, 'TIFFTAG_STRIPOFFSETS' );

is( TIFFTAG_ORIENTATION,  274, 'TIFFTAG_ORIENTATION' );
is( ORIENTATION_TOPLEFT,  1,   'ORIENTATION_TOPLEFT' );
is( ORIENTATION_TOPRIGHT, 2,   'ORIENTATION_TOPRIGHT' );
is( ORIENTATION_BOTRIGHT, 3,   'ORIENTATION_BOTRIGHT' );
is( ORIENTATION_BOTLEFT,  4,   'ORIENTATION_BOTLEFT' );
is( ORIENTATION_LEFTTOP,  5,   'ORIENTATION_LEFTTOP' );
is( ORIENTATION_RIGHTTOP, 6,   'ORIENTATION_RIGHTTOP' );
is( ORIENTATION_RIGHTBOT, 7,   'ORIENTATION_RIGHTBOT' );
is( ORIENTATION_LEFTBOT,  8,   'ORIENTATION_LEFTBOT' );

is( TIFFTAG_SAMPLESPERPIXEL, 277, 'TIFFTAG_SAMPLESPERPIXEL' );
is( TIFFTAG_ROWSPERSTRIP,    278, "TIFFTAG_ROWSPERSTRIP" );
is( TIFFTAG_STRIPBYTECOUNTS, 279, "TIFFTAG_STRIPBYTECOUNTS" );

is( TIFFTAG_XRESOLUTION, 282, "TIFFTAG_XRESOLUTION" );
is( TIFFTAG_YRESOLUTION, 283, "TIFFTAG_YRESOLUTION" );

is( TIFFTAG_PLANARCONFIG,  284, "TIFFTAG_PLANARCONFIG" );
is( PLANARCONFIG_CONTIG,   1,   "PLANARCONFIG_CONTIG" );
is( PLANARCONFIG_SEPARATE, 2,   "PLANARCONFIG_SEPARATE" );

is( TIFFTAG_GROUP3OPTIONS,  292, 'TIFFTAG_GROUP3OPTIONS' );
is( TIFFTAG_T4OPTIONS,      292, 'TIFFTAG_T4OPTIONS' );
is( GROUP3OPT_2DENCODING,   0x1, 'GROUP3OPT_2DENCODING' );
is( GROUP3OPT_UNCOMPRESSED, 0x2, 'GROUP3OPT_UNCOMPRESSED' );
is( GROUP3OPT_FILLBITS,     0x4, 'GROUP3OPT_FILLBITS' );

is( TIFFTAG_GROUP4OPTIONS,  293, 'TIFFTAG_GROUP4OPTIONS' );
is( TIFFTAG_T6OPTIONS,      293, 'TIFFTAG_T6OPTIONS' );
is( GROUP4OPT_UNCOMPRESSED, 0x2, 'GROUP4OPT_UNCOMPRESSED' );

is( TIFFTAG_RESOLUTIONUNIT, 296, 'TIFFTAG_RESOLUTIONUNIT' );
is( RESUNIT_NONE,           1,   'RESUNIT_NONE' );
is( RESUNIT_INCH,           2,   'RESUNIT_INCH' );
is( RESUNIT_CENTIMETER,     3,   'RESUNIT_CENTIMETER' );

is( TIFFTAG_PAGENUMBER, 297, "TIFFTAG_PAGENUMBER" );

is( TIFFTAG_TRANSFERFUNCTION, 301, 'TIFFTAG_TRANSFERFUNCTION' );

is( TIFFTAG_SOFTWARE, 305, 'TIFFTAG_SOFTWARE' );
is( TIFFTAG_DATETIME, 306, 'TIFFTAG_DATETIME' );

is( TIFFTAG_ARTIST, 315, 'TIFFTAG_ARTIST' );

is( TIFFTAG_PREDICTOR,       317, 'TIFFTAG_PREDICTOR' );
is( PREDICTOR_NONE,          1,   'PREDICTOR_NONE' );
is( PREDICTOR_HORIZONTAL,    2,   'PREDICTOR_HORIZONTAL' );
is( PREDICTOR_FLOATINGPOINT, 3,   'PREDICTOR_FLOATINGPOINT' );

is( TIFFTAG_WHITEPOINT,            318, 'TIFFTAG_WHITEPOINT' );
is( TIFFTAG_PRIMARYCHROMATICITIES, 319, 'TIFFTAG_PRIMARYCHROMATICITIES' );
is( TIFFTAG_COLORMAP,              320, 'TIFFTAG_COLORMAP' );

is( TIFFTAG_TILEWIDTH,  322, 'TIFFTAG_TILEWIDTH' );
is( TIFFTAG_TILELENGTH, 323, 'TIFFTAG_TILELENGTH' );

is( TIFFTAG_INKSET,  332, 'TIFFTAG_INKSET' );
is( INKSET_CMYK,     1,   'INKSET_CMYK' );
is( INKSET_MULTIINK, 2,   'INKSET_MULTIINK' );

is( TIFFTAG_EXTRASAMPLES,    338, 'TIFFTAG_EXTRASAMPLES' );
is( EXTRASAMPLE_UNSPECIFIED, 0,   'EXTRASAMPLES_UNSPECIFIED' );
is( EXTRASAMPLE_ASSOCALPHA,  1,   'EXTRASAMPLES_ASSOCALPHA' );
is( EXTRASAMPLE_UNASSALPHA,  2,   'EXTRASAMPLES_UNASSALPHA' );

is( TIFFTAG_SAMPLEFORMAT,       339, 'TIFFTAG_SAMPLEFORMAT' );
is( SAMPLEFORMAT_UINT,          1,   'SAMPLEFORMAT_UINT' );
is( SAMPLEFORMAT_INT,           2,   'SAMPLEFORMAT_INT' );
is( SAMPLEFORMAT_IEEEFP,        3,   'SAMPLEFORMAT_IEEEFP' );
is( SAMPLEFORMAT_VOID,          4,   'SAMPLEFORMAT_VOID' );
is( SAMPLEFORMAT_COMPLEXINT,    5,   'SAMPLEFORMAT_COMPLEXINT' );
is( SAMPLEFORMAT_COMPLEXIEEEFP, 6,   'SAMPLEFORMAT_COMPLEXIEEEFP' );

is( TIFFTAG_INDEXED,    346, 'TIFFTAG_INDEXED' );
is( TIFFTAG_JPEGTABLES, 347, 'TIFFTAG_JPEGTABLES' );

is( TIFFTAG_JPEGPROC,  512, 'TIFFTAG_JPEGPROC' );
is( JPEGPROC_BASELINE, 1,   'JPEGPROC_BASELINE' );
is( JPEGPROC_LOSSLESS, 14,  'JPEGPROC_LOSSLESS' );

is( TIFFTAG_JPEGIFOFFSET,    513, 'TIFFTAG_JPEGIFOFFSET' );
is( TIFFTAG_JPEGIFBYTECOUNT, 514, 'TIFFTAG_JPEGIFBYTECOUNT' );

is( TIFFTAG_JPEGLOSSLESSPREDICTORS, 517, 'TIFFTAG_JPEGLOSSLESSPREDICTORS' );
is( TIFFTAG_JPEGPOINTTRANSFORM,     518, 'TIFFTAG_JPEGPOINTTRANSFORM' );
is( TIFFTAG_JPEGQTABLES,            519, 'TIFFTAG_JPEGQTABLES' );
is( TIFFTAG_JPEGDCTABLES,           520, 'TIFFTAG_JPEGDCTABLES' );
is( TIFFTAG_JPEGACTABLES,           521, 'TIFFTAG_JPEGACTABLES' );

is( TIFFTAG_YCBCRSUBSAMPLING, 530, 'TIFFTAG_YCBCRSUBSAMPLING' );

is( TIFFTAG_REFERENCEBLACKWHITE, 532, 'TIFFTAG_REFERENCEBLACKWHITE' );

is( TIFFTAG_OPIIMAGEID, 32781, 'TIFFTAG_OPIIMAGEID' );

is( TIFFTAG_COPYRIGHT, 33432, 'TIFFTAG_COPYRIGHT' );

is( TIFFTAG_EXIFIFD, 34665, "TIFFTAG_EXIFIFD" );

is( TIFFTAG_ICCPROFILE, 34675, 'TIFFTAG_ICCPROFILE' );

is( TIFFTAG_JPEGQUALITY, 65537, 'TIFFTAG_JPEGQUALITY' );

is( TIFFTAG_JPEGCOLORMODE, 65538,  'TIFFTAG_JPEGCOLORMODE' );
is( JPEGCOLORMODE_RAW,     0x0000, 'JPEGCOLORMODE_RAW' );
is( JPEGCOLORMODE_RGB,     0x0001, 'JPEGCOLORMODE_RGB' );

is( TIFFTAG_JPEGTABLESMODE, 65539,  'TIFFTAG_JPEGTABLESMODE' );
is( JPEGTABLESMODE_QUANT,   0x0001, 'JPEGTABLESMODE_QUANT' );
is( JPEGTABLESMODE_HUFF,    0x0002, 'JPEGTABLESMODE_HUFF' );

is( TIFFTAG_ZIPQUALITY, 65557, 'TIFFTAG_ZIPQUALITY' );

is( TIFFPRINT_STRIPS,       1,     "TIFFPRINT_STRIPS" );
is( TIFFPRINT_CURVES,       2,     "TIFFPRINT_CURVES" );
is( TIFFPRINT_COLORMAP,     4,     "TIFFPRINT_COLORMAP" );
is( TIFFPRINT_JPEGQTABLES,  0x100, "TIFFPRINT_JPEGQTABLES" );
is( TIFFPRINT_JPEGACTABLES, 0x200, "TIFFPRINT_JPEGACTABLES" );
is( TIFFPRINT_JPEGDCTABLES, 0x200, "TIFFPRINT_JPEGDCTABLES" );
