#!/usr/bin/perl

use strict;
BEGIN {
	$|  = 1;
	$^W = 1;
}

use lib "t/lib";
use SQLiteTest qw/requires_sqlite/;
use Test::More;
use DBD::SQLcipher;

BEGIN { requires_sqlite('3.10.0'); }

use Test::NoWarnings;

plan tests => 13;

ok !DBD::SQLcipher::strlike("foo_bar", "FOO1BAR");
ok !DBD::SQLcipher::strlike("foo_bar", "FOO_BAR");
ok DBD::SQLcipher::strlike("foo\\_bar", "FOO1BAR", "\\");
ok !DBD::SQLcipher::strlike("foo\\_bar", "FOO_BAR", "\\");
ok DBD::SQLcipher::strlike("foo!_bar", "FOO1BAR", "!");
ok !DBD::SQLcipher::strlike("foo!_bar", "FOO_BAR", "!");
ok !DBD::SQLcipher::strlike("%foobar", "1FOOBAR");
ok !DBD::SQLcipher::strlike("%foobar", "%FOOBAR");
ok DBD::SQLcipher::strlike("\\%foobar", "1FOOBAR", "\\");
ok !DBD::SQLcipher::strlike("\\%foobar", "%FOOBAR", "\\");
ok DBD::SQLcipher::strlike("!%foobar", "1FOOBAR", "!");
ok !DBD::SQLcipher::strlike("!%foobar", "%FOOBAR", "!");
