package Net::Amazon::EMR::InstanceGroup;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;
use Net::Amazon::EMR::Configuration;
use Net::Amazon::EMR::InstanceGroupStatus;
use Net::Amazon::EMR::EbsBlockDevice;

has 'BidPrice' => ( is => 'ro', 
                    isa => 'Str' );

has 'Configurations' => ( is => 'ro', 
                          isa => 'Net::Amazon::EMR::Type::ArrayRefofConfiguration',
                          coerce => 1,
                      );

has 'EbsBlockDevices' => ( is => 'ro', 
                          isa => 'Net::Amazon::EMR::Type::ArrayRefofEbsBlockDevice',
                          coerce => 1,
                       );

has 'EbsOptimized' => ( is => 'ro', 
                        isa => 'Net::Amazon::EMR::Type::Bool',
                        coerce => 1,
                    );


has 'Id' => ( is => 'ro', 
              isa => 'Str' );


subtype 'Net::Amazon::EMR::Type::InstanceGroup::Type' => as 'Str' => where { m/^(?:MASTER | CORE | TASK)$/x };

has 'InstanceGroupType' => ( is => 'ro',
                             isa => 'Net::Amazon::EMR::Type::InstanceGroup::Type',
                         );


has 'InstanceType' => ( is => 'ro', 
                        isa => 'Str' );

subtype 'Net::Amazon::EMR::Type::InstanceGroup::Market' => as 'Str' => where { m/^(?:ON_DEMAND | SPOT)$/x };

has 'Market' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::InstanceGroup::Market',
              );

has 'Name' => ( is => 'ro', 
                isa => 'Str' );



has 'RequestedInstanceCount' => ( is => 'ro', 
                                  isa => 'Int' );


has 'RunningInstanceCount' => ( is => 'ro', 
                                isa => 'Int' );


has 'Status' => ( is => 'ro', 
                  isa => 'Net::Amazon::EMR::Type::InstanceGroupStatus',
                  coerce => 1,
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceGroup

=head1 DESCRIPTION

Implements the InstanceGroup data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceGroup.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
