# Generated by default/object.tt
package Paws::CloudFront::FunctionSummary;
  use Moose;
  has FunctionConfig => (is => 'ro', isa => 'Paws::CloudFront::FunctionConfig', required => 1);
  has FunctionMetadata => (is => 'ro', isa => 'Paws::CloudFront::FunctionMetadata', required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::FunctionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::FunctionSummary object:

  $service_obj->Method(Att1 => { FunctionConfig => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::FunctionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->FunctionConfig

=head1 DESCRIPTION

Contains configuration information and metadata about a CloudFront
function.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FunctionConfig => L<Paws::CloudFront::FunctionConfig>

Contains configuration information about a CloudFront function.


=head2 B<REQUIRED> FunctionMetadata => L<Paws::CloudFront::FunctionMetadata>

Contains metadata about a CloudFront function.


=head2 B<REQUIRED> Name => Str

The name of the CloudFront function.


=head2 Status => Str

The status of the CloudFront function.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

