
package Paws::SSM::TerminateSession;
  use Moose;
  has SessionId => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'TerminateSession');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SSM::TerminateSessionResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::TerminateSession - Arguments for method TerminateSession on L<Paws::SSM>

=head1 DESCRIPTION

This class represents the parameters used for calling the method TerminateSession on the
L<Amazon Simple Systems Manager (SSM)|Paws::SSM> service. Use the attributes of this class
as arguments to method TerminateSession.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to TerminateSession.

=head1 SYNOPSIS

    my $ssm = Paws->service('SSM');
    my $TerminateSessionResponse = $ssm->TerminateSession(
      SessionId => 'MySessionId',

    );

    # Results:
    my $SessionId = $TerminateSessionResponse->SessionId;

    # Returns a L<Paws::SSM::TerminateSessionResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/ssm/TerminateSession>

=head1 ATTRIBUTES


=head2 B<REQUIRED> SessionId => Str

The ID of the session to terminate.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method TerminateSession in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

