# Generated by default/object.tt
package Paws::EMRContainers::Endpoint;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CertificateArn => (is => 'ro', isa => 'Str', request_name => 'certificateArn', traits => ['NameInRequest']);
  has ConfigurationOverrides => (is => 'ro', isa => 'Paws::EMRContainers::ConfigurationOverrides', request_name => 'configurationOverrides', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has ExecutionRoleArn => (is => 'ro', isa => 'Str', request_name => 'executionRoleArn', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has ReleaseLabel => (is => 'ro', isa => 'Str', request_name => 'releaseLabel', traits => ['NameInRequest']);
  has SecurityGroup => (is => 'ro', isa => 'Str', request_name => 'securityGroup', traits => ['NameInRequest']);
  has ServerUrl => (is => 'ro', isa => 'Str', request_name => 'serverUrl', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'subnetIds', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::EMRContainers::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);
  has VirtualClusterId => (is => 'ro', isa => 'Str', request_name => 'virtualClusterId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMRContainers::Endpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMRContainers::Endpoint object:

  $service_obj->Method(Att1 => { Arn => $value, ..., VirtualClusterId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMRContainers::Endpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

This entity represents the endpoint that is managed by Amazon EMR on
EKS.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the endpoint.


=head2 CertificateArn => Str

The certificate ARN of the endpoint.


=head2 ConfigurationOverrides => L<Paws::EMRContainers::ConfigurationOverrides>

The configuration settings that are used to override existing
configurations for endpoints.


=head2 CreatedAt => Str

The date and time when the endpoint was created.


=head2 ExecutionRoleArn => Str

The execution role ARN of the endpoint.


=head2 Id => Str

The ID of the endpoint.


=head2 Name => Str

The name of the endpoint.


=head2 ReleaseLabel => Str

The EMR release version to be used for the endpoint.


=head2 SecurityGroup => Str

The security group configuration of the endpoint.


=head2 ServerUrl => Str

The server URL of the endpoint.


=head2 State => Str

The state of the endpoint.


=head2 SubnetIds => ArrayRef[Str|Undef]

The subnet IDs of the endpoint.


=head2 Tags => L<Paws::EMRContainers::TagMap>

The tags of the endpoint.


=head2 Type => Str

The type of the endpoint.


=head2 VirtualClusterId => Str

The ID of the endpoint's virtual cluster.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMRContainers>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

