
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "ExtUtils::MakeMaker" => "6.30",
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Generate HTML content from Markdown files",
  "dist_author" => [
    "Michal Wojciechowski <odyniec\@cpan.org>"
  ],
  "dist_name" => "Dancer-Plugin-Preprocess-Markdown",
  "dist_version" => "0.020",
  "license" => "perl",
  "module_name" => "Dancer::Plugin::Preprocess::Markdown",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Cwd" => 0,
    "Dancer" => 0,
    "Dancer::Plugin" => 0,
    "File::Spec::Functions" => 0,
    "Text::Markdown" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "script_files" => [],
  "test_requires" => {}
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  my $tr = delete $module_build_args{test_requires};
  my $br = $module_build_args{build_requires};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
