#!/usr/bin/perl

package eBay::API::XML::DataType::PaginationResultType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PaginationResultType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PaginationResultType

=head1 DESCRIPTION

Shows the pagination of data returned by requests.
Pagination of returned data is not needed in and not
supported for every call. See the documentation for
individual calls to determine whether pagination is
supported, required, or desirable.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PaginationResultType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'TotalNumberOfEntries', 'xs:int', '', '', '' ]
	, [ 'TotalNumberOfPages', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setTotalNumberOfEntries()

Indicates the total number of entries that
could be returned by repeated requests. For
GetOrders, not applicable to eBay.com (for
GetOrders, applicable to Half.com). Returned with a
value of 0 if no entries are available.

#    Argument: 'xs:int'

=cut

sub setTotalNumberOfEntries {
  my $self = shift;
  $self->{'TotalNumberOfEntries'} = shift
}

=head2 getTotalNumberOfEntries()

  Calls: GetCategoryListings
         GetItemsAwaitingFeedback
         GetLiveAuctionBidders
         GetMemberMessages
         GetSellerPayments
         GetWantItNowSearchResults
  Returned: Always

  Calls: GetFeedback
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetLiveAuctionBidders
         GetPopularKeywords
         GetVeROReportStatus
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           BestOfferList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           ActiveList
           ScheduledList
           SoldList
           DeletedFromSoldList
           UnsoldList
           DeletedFromUnsoldList

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetSearchResults
  Returned: Always
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse


  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:int'

=cut

sub getTotalNumberOfEntries {
  my $self = shift;
  return $self->{'TotalNumberOfEntries'};
}


=head2 setTotalNumberOfPages()

Indicates the total number of pages of data
that could be returned by repeated requests. For
GetOrders, not applicable to eBay.com (for
GetOrders, applicable to Half.com). Returned with a
value of 0 if no pages are available.

#    Argument: 'xs:int'

=cut

sub setTotalNumberOfPages {
  my $self = shift;
  $self->{'TotalNumberOfPages'} = shift
}

=head2 getTotalNumberOfPages()

  Calls: GetAccount
         GetCategoryListings
         GetItemsAwaitingFeedback
         GetMemberMessages
         GetSellerPayments
         GetWantItNowSearchResults
  Returned: Always

  Calls: GetFeedback
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetLiveAuctionBidders
         GetPopularKeywords
         GetVeROReportStatus
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           BestOfferList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           DeletedFromSoldList
           UnsoldList
           DeletedFromUnsoldList
           BidList

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetSearchResults
  Returned: Always
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse


  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetUserDisputes
  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none

#    Returns: 'xs:int'

=cut

sub getTotalNumberOfPages {
  my $self = shift;
  return $self->{'TotalNumberOfPages'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
