# This test is ill conceived.  
# The file it creates may not recognisably have an en-dash
# It works without using the File::Rename unicode_strings option
# RMB 2021-08-01

use Test::More;
BEGIN {
    plan skip_all => 'Need perl v5.16.0 for \N' if $] < 5.016;
}
plan tests => 2;

require_ok('File::Rename');

unshift @INC, 't' if -d 't';
require 'testlib.pl';

my $dir = do { require File::Temp; File::Temp::tempdir(); };
chdir $dir or die;

my $test = "A \x{2013} B.txt";  # en dash
my $xxx = 'A XXX B.txt';
create_file($test);

SKIP: {
    skip "Can't create filename with en-dash", 1 unless -e $test;

    our $found;
    our $print;
    our $warn;
    local $SIG{__WARN__} = sub { $warn .= $_[0] };

    test_rename_files( sub { s/\N{EN DASH}+/XXX/ }, $test);
    ok( (-e $xxx and !-e $test and $found),
        "rename with \\N{EN DASH}");
    diag_rename();
}
 
