# Generated by default/object.tt
package Paws::Macie2::Member;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has AdministratorAccountId => (is => 'ro', isa => 'Str', request_name => 'administratorAccountId', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has Email => (is => 'ro', isa => 'Str', request_name => 'email', traits => ['NameInRequest']);
  has InvitedAt => (is => 'ro', isa => 'Str', request_name => 'invitedAt', traits => ['NameInRequest']);
  has MasterAccountId => (is => 'ro', isa => 'Str', request_name => 'masterAccountId', traits => ['NameInRequest']);
  has RelationshipStatus => (is => 'ro', isa => 'Str', request_name => 'relationshipStatus', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::Macie2::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has UpdatedAt => (is => 'ro', isa => 'Str', request_name => 'updatedAt', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Member

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Member object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Member object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Provides information about an account that's associated with an Amazon
Macie administrator account.

=head1 ATTRIBUTES


=head2 AccountId => Str

The Amazon Web Services account ID for the account.


=head2 AdministratorAccountId => Str

The Amazon Web Services account ID for the administrator account.


=head2 Arn => Str

The Amazon Resource Name (ARN) of the account.


=head2 Email => Str

The email address for the account.


=head2 InvitedAt => Str

The date and time, in UTC and extended ISO 8601 format, when an Amazon
Macie membership invitation was last sent to the account. This value is
null if a Macie invitation hasn't been sent to the account.


=head2 MasterAccountId => Str

(Deprecated) The Amazon Web Services account ID for the administrator
account. This property has been replaced by the administratorAccountId
property and is retained only for backward compatibility.


=head2 RelationshipStatus => Str

The current status of the relationship between the account and the
administrator account.


=head2 Tags => L<Paws::Macie2::TagMap>

A map of key-value pairs that identifies the tags (keys and values)
that are associated with the account in Amazon Macie.


=head2 UpdatedAt => Str

The date and time, in UTC and extended ISO 8601 format, of the most
recent change to the status of the relationship between the account and
the administrator account.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

