#!/usr/bin/perl -w

my @ciphers =
(
	'Blowfish',
	'Blowfish_PP',
	'Camellia',
	'Camellia_PP',
	'CAST5',
	'CAST5_PP',
	'DES',
	'DES_EDE3',
	'DES_EEE3',
	'DES_PP',
	'IDEA',
	'NULL',
	'RC6',
	'Rijndael',
	'Rijndael_PP',
	'Skip32',
	'Twofish',
	'Twofish2',
	'XTEA',
	'XTEA_PP',
);

my @padstyles = qw(standard zeroes oneandzeroes rijndael_compat space null);

use Test::More tests => 3*20*6 + 1;

BEGIN { use_ok (Crypt::ECB, qw(encrypt decrypt)) }

my $text = "This is just some dummy text!\n";
my $xkey = "This is an at least 56 Byte long test key!!! It really is.";

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };

	SKIP: {	skip "$cipher not installed", 3*@padstyles if $@;

		my $ks = $ecb->keysize || 56;
		my $key = substr($xkey, 0, $ks);
		$ecb->key($key);

		foreach my $padstyle (@padstyles)
		{
			$ecb->padding($padstyle);

			my $enc1 = $ecb->encrypt($text);
			my $enc2 = encrypt($key, $cipher, $text, $padstyle);
			ok($enc1 eq $enc2,	"$cipher, $padstyle padding: encryption function style");

			my $dec1 = $ecb->decrypt($enc1);
			my $dec2 = decrypt($key, $cipher, $enc2, $padstyle);
			ok($dec1 eq $text,	"$cipher, $padstyle padding: decryption OO style");
			ok($dec2 eq $text,	"$cipher, $padstyle padding: decryption function style");
		}
	}
}

#done_testing( 3*@ciphers*@padstyles + 1 );
