#!/usr/bin/perl
#
# @(#)$Id: esqlcc.pl,v 2015.1 2015/08/21 22:54:47 jleffler Exp $ 
#
# DBD::Informix for Perl Version 5
#
# Surrogate C Compiler for Informix ESQL/C versions 4.10.UC1 upwards
#
# Copyright 1996-98 Jonathan Leffler
# Copyright 2002-03 IBM
# Copyright 2004-07 Jonathan Leffler
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.
#
# NB: Uses esqlsed script
#
# Key job 1: do not pass library-related arguments to C compiler if not
# linking, controlled by the presence of '-c' in the compiler options.
# ESQL/C scripts were bad about that - 5.x, 7.x, some CSDK versions.
# Key job 2: run esqlsed on C files generated by ESQL/C because some of
# the code is not good - again, more of a problem in older versions of
# ESQL/C.

# Workaround $DBD_INFORMIX_DEBUG_ESQLCC=yes for any non-numeric value.
# Bug found by Piotr Poloczek <poloczekp@interia.pl> on 2007-08-24.
BEGIN
{
$ENV{DBD_INFORMIX_DEBUG_ESQLCC} = 0 unless defined $ENV{DBD_INFORMIX_DEBUG_ESQLCC};
}

use strict;
use warnings;
use constant debug => ($ENV{DBD_INFORMIX_DEBUG_ESQLCC} =~ m/^\d+$/) ? $ENV{DBD_INFORMIX_DEBUG_ESQLCC} : 1;

{ printf STDERR "$0: Num args = %d\n", scalar(@ARGV) if debug; }

my @ARGS = ();
my $libs = 1;

sub firstline
{
	my ($file) = @_;
	my ($line) = `sed 1q $file`;
	chomp $line;
	$line;
}

# Cannot use for $arg (@ARGV) because of '-[Ll] name' processing!
for (my $i = 0; $i < @ARGV; $i++)
{
	my $arg = $ARGV[$i];
	if ($arg =~ /^[^-].*\.c$/o)
	{
		# C file
		# Use $^X rather than perl to avoid problems with
		# inappropriate versions of perl in system directories
		# (Roderick Schertler <roderick@argon.org> 1999-07-25).
		system "$^X -i ./esqlsed $arg"
			if (-w $arg && &firstline($arg) eq "#include <sqlhdr.h>");
		push @ARGS, $arg;
	}
	elsif ($arg =~ /^-c$/o)
	{
		# -c option (no linking)
		$libs = 0;
		push @ARGS, $arg;
	}
	elsif ($arg =~ /^[^-].*\.[ao]$/o)
	{
		# Object file or archive library specified by name
		push @ARGS, $arg if ($libs);
	}
	elsif ($arg =~ /^-[lL].+/o)
	{
		# -lname or -Ldirectory -- not wanted if no libraries
		push @ARGS, $arg if ($libs);
	}
	elsif ($arg =~ /^-[lL]$/o)
	{
		# -l name or -L directory -- not wanted if no libraries
		push @ARGS, $arg if ($libs);
		$arg = $ARGV[++$i];
		push @ARGS, $arg if ($libs);
	}
	else
	{
		# Copy argument to new argument list
		push @ARGS, $arg;
	}
}

# Generalization of DBD_INFORMIX_ESQLLD_NO_G_OPTION...
if ($ENV{DBD_INFORMIX_ESQLCC_REMOVE_OPTIONS_REGEX})
{
	my($env) = $ENV{DBD_INFORMIX_ESQLCC_REMOVE_OPTIONS_REGEX};
	print STDERR "# DBD_INFORMIX_ESQLCC_REMOVE_OPTIONS_REGEX set.\n";
	print STDERR "# Removing options that match regex m%$env%\n";
	print STDERR "# Before: @ARGS\n" if debug;
	@ARGS = grep { !m%$env%o } @ARGS;
	print STDERR "# After: @ARGS\n" if debug;
}

# JL 2005-07-25: AIX 5.2 (64-bit), CSDK 2.90.FCx.
# Perl is built without -qlanglvl=ansi; CSDK is built to use it!
warn "You might need to set DBD_INFORMIX_ESQLCC_REMOVE_OPTIONS_REGEX because of -qlanglvl=ansi"
	if (grep { m%^-qlanglvl=ansi$% } @ARGS);

# Sort out the real compiler.
# Note that if $ENV{ESQLCC} contains, for example, 'cc -G', then we
# need to split this into two words for the exec to work correctly.
my $cmd = $ENV{ESQLCC};
   $cmd = 'cc' unless ($cmd);
my @cmd = split /\s+/, $cmd;

print STDERR "@cmd @ARGS\n" if debug;
if (debug > 1)
{
	print "$0: command\n";
	foreach my $c (@cmd) { print "<<$c>>\n"; }
	print "$0: arguments\n";
	foreach my $c (@ARGS) { print "<<$c>>\n"; }
}
exec @cmd, @ARGS;
