/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.DatabaseURL;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.persist.HsqlProperties;

public class jdbcDriver
implements Driver {
    public Connection connect(String string, Properties properties) throws SQLException {
        return jdbcDriver.getConnection(string, properties);
    }

    public static Connection getConnection(String string, Properties properties) throws SQLException {
        HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, true);
        if (hsqlProperties == null) {
            throw new SQLException(Trace.getMessage(62));
        }
        if (hsqlProperties.isEmpty()) {
            return null;
        }
        hsqlProperties.addProperties(properties);
        return new jdbcConnection(hsqlProperties);
    }

    public boolean acceptsURL(String string) {
        return string != null && string.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length());
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        String[] stringArray = new String[]{"true", "false"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[6];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.value = properties.getProperty("user");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.value = properties.getProperty("password");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
        driverPropertyInfo.value = properties.getProperty("get_column_name", "true");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("ifexists", null);
        driverPropertyInfo.value = properties.getProperty("ifexists");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("default_schema", null);
        driverPropertyInfo.value = properties.getProperty("default_schema");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("shutdown", null);
        driverPropertyInfo.value = properties.getProperty("shutdown");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 8;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new jdbcDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

