use Test::More;
use Modern::Perl '2010';
use lib 'lib';

BEGIN
{
	use_ok('Moo');
	use_ok('Data::Printer');
	use_ok('Function::Parameters');
	use_ok('WebService::Pixabay');
	use_ok('LWP::Online', 'online');
	use_ok('Modern::Perl', '2009');

	#TODO change this to latest version on the malformed
	# JSON error is gone!
	use_ok('WebService::Client', 0.0502);
}

my $true = 1;
my $false = 0;
my $AUTHOR_TESTING = $false;

SKIP:
{
	skip "installation testing", 1 unless $AUTHOR_TESTING == $true;

	ok(my $pix =
		WebService::Pixabay->new(
			api_key => $ENV{PIXABAY_KEY}
		));

	SKIP:
	{	skip "No internet connection", 1 unless online();

		ok(my $img_search = $pix->image_search, " image_search method");
		ok(my $vid_search = $pix->video_search, "video_search method");
		ok($img_search->show_data_structure, "image_search data structure presentation");
		ok($vid_search->show_data_structure, "video_search data structure presentation");
		ok(my $img1 = $pix->image_search(q => 'water')->show_data_structure,
		   "custom image_search of water and show the struct");
	    ok(my $vid1 = $pix->video_search(q => 'fire')->show_data_structure, 		   "custom video_search of fire and show the struct");
	}
};

done_testing;
