###############################################################
#
# File "html_alias.pl" containing aliases for use with 
#
#   use charnames ":html";
#
# Each section in table below is grouped and sorted not by alias
# name but rather so one can visually locate a desired character.
# 
# To view table sorted by key, see unused DATA section below.
#
###############################################################

use utf8;
use strict;
use warnings qw[ FATAL all ];

# "return" is to quiet perl -wc

return (

# Number aliases: these are \p{Other_Number}
      "sup1" => "SUPERSCRIPT ONE",                            # ¹ U+00B9
      "sup2" => "SUPERSCRIPT TWO",                            # ² U+00B2
      "sup3" => "SUPERSCRIPT THREE",                          # ³ U+00B3
    "frac12" => "VULGAR FRACTION ONE HALF",                   # ½ U+00BD
    "frac14" => "VULGAR FRACTION ONE QUARTER",                # ¼ U+00BC
    "frac34" => "VULGAR FRACTION THREE QUARTERS",             # ¾ U+00BE

# Currency sign aliases: \p{Currency_Symbol}

    "curren" => "CURRENCY SIGN",                              # ¤ U+00A4
      "cent" => "CENT SIGN",                                  # ¢ U+00A2
     "pound" => "POUND SIGN",                                 # £ U+00A3
       "yen" => "YEN SIGN",                                   # ¥ U+00A5
      "euro" => "EURO SIGN",                                  # € U+20AC

# Latin letter aliases in NFC and grouped by first letter
#
#   NOTE: some like BLACK LETTER blah and the trademark
#         symbol are only Latin in NFKD form.

      "ordf" => "FEMININE ORDINAL INDICATOR",                 # ª U+00AA
    "Oacute" => "LATIN CAPITAL LETTER O WITH ACUTE",          # Ó U+00D3
    "Aacute" => "LATIN CAPITAL LETTER A WITH ACUTE",          # Á U+00C1
    "aacute" => "LATIN SMALL LETTER A WITH ACUTE",            # á U+00E1
    "Agrave" => "LATIN CAPITAL LETTER A WITH GRAVE",          # À U+00C0
    "agrave" => "LATIN SMALL LETTER A WITH GRAVE",            # à U+00E0
     "Acirc" => "LATIN CAPITAL LETTER A WITH CIRCUMFLEX",     # Â U+00C2
     "acirc" => "LATIN SMALL LETTER A WITH CIRCUMFLEX",       # â U+00E2
     "Aring" => "LATIN CAPITAL LETTER A WITH RING ABOVE",     # Å U+00C5
     "aring" => "LATIN SMALL LETTER A WITH RING ABOVE",       # å U+00E5
      "Auml" => "LATIN CAPITAL LETTER A WITH DIAERESIS",      # Ä U+00C4
      "auml" => "LATIN SMALL LETTER A WITH DIAERESIS",        # ä U+00E4
    "Atilde" => "LATIN CAPITAL LETTER A WITH TILDE",          # Ã U+00C3
    "atilde" => "LATIN SMALL LETTER A WITH TILDE",            # ã U+00E3
     "AElig" => "LATIN CAPITAL LETTER AE",                    # Æ U+00C6
     "aelig" => "LATIN SMALL LETTER AE",                      # æ U+00E6

    "Ccedil" => "LATIN CAPITAL LETTER C WITH CEDILLA",        # Ç U+00C7
    "ccedil" => "LATIN SMALL LETTER C WITH CEDILLA",          # ç U+00E7

       "ETH" => "LATIN CAPITAL LETTER ETH",                   # Ð U+00D0
       "eth" => "LATIN SMALL LETTER ETH",                     # ð U+00F0

    "Eacute" => "LATIN CAPITAL LETTER E WITH ACUTE",          # É U+00C9
    "eacute" => "LATIN SMALL LETTER E WITH ACUTE",            # é U+00E9
    "Egrave" => "LATIN CAPITAL LETTER E WITH GRAVE",          # È U+00C8
    "egrave" => "LATIN SMALL LETTER E WITH GRAVE",            # è U+00E8
     "Ecirc" => "LATIN CAPITAL LETTER E WITH CIRCUMFLEX",     # Ê U+00CA
     "ecirc" => "LATIN SMALL LETTER E WITH CIRCUMFLEX",       # ê U+00EA
      "Euml" => "LATIN CAPITAL LETTER E WITH DIAERESIS",      # Ë U+00CB
      "euml" => "LATIN SMALL LETTER E WITH DIAERESIS",        # ë U+00EB

      "fnof" => "LATIN SMALL LETTER F WITH HOOK",             # ƒ U+0192

     "image" => "BLACK-LETTER CAPITAL I",                     # ℑ U+2111
    "Iacute" => "LATIN CAPITAL LETTER I WITH ACUTE",          # Í U+00CD
    "iacute" => "LATIN SMALL LETTER I WITH ACUTE",            # í U+00ED
    "Igrave" => "LATIN CAPITAL LETTER I WITH GRAVE",          # Ì U+00CC
    "igrave" => "LATIN SMALL LETTER I WITH GRAVE",            # ì U+00EC
     "Icirc" => "LATIN CAPITAL LETTER I WITH CIRCUMFLEX",     # Î U+00CE
     "icirc" => "LATIN SMALL LETTER I WITH CIRCUMFLEX",       # î U+00EE
      "Iuml" => "LATIN CAPITAL LETTER I WITH DIAERESIS",      # Ï U+00CF
      "iuml" => "LATIN SMALL LETTER I WITH DIAERESIS",        # ï U+00EF

    "Ntilde" => "LATIN CAPITAL LETTER N WITH TILDE",          # Ñ U+00D1
    "ntilde" => "LATIN SMALL LETTER N WITH TILDE",            # ñ U+00F1

      "ordm" => "MASCULINE ORDINAL INDICATOR",                # º U+00BA
    "oacute" => "LATIN SMALL LETTER O WITH ACUTE",            # ó U+00F3
    "Ograve" => "LATIN CAPITAL LETTER O WITH GRAVE",          # Ò U+00D2
    "ograve" => "LATIN SMALL LETTER O WITH GRAVE",            # ò U+00F2
     "Ocirc" => "LATIN CAPITAL LETTER O WITH CIRCUMFLEX",     # Ô U+00D4
     "ocirc" => "LATIN SMALL LETTER O WITH CIRCUMFLEX",       # ô U+00F4
      "Ouml" => "LATIN CAPITAL LETTER O WITH DIAERESIS",      # Ö U+00D6
      "ouml" => "LATIN SMALL LETTER O WITH DIAERESIS",        # ö U+00F6
    "Otilde" => "LATIN CAPITAL LETTER O WITH TILDE",          # Õ U+00D5
    "otilde" => "LATIN SMALL LETTER O WITH TILDE",            # õ U+00F5
    "Oslash" => "LATIN CAPITAL LETTER O WITH STROKE",         # Ø U+00D8
    "oslash" => "LATIN SMALL LETTER O WITH STROKE",           # ø U+00F8
     "OElig" => "LATIN CAPITAL LIGATURE OE",                  # Œ U+0152
     "oelig" => "LATIN SMALL LIGATURE OE",                    # œ U+0153

      "real" => "BLACK-LETTER CAPITAL R",                     # ℜ U+211C

    "Scaron" => "LATIN CAPITAL LETTER S WITH CARON",          # Š U+0160
    "scaron" => "LATIN SMALL LETTER S WITH CARON",            # š U+0161
     "szlig" => "LATIN SMALL LETTER SHARP S",                 # ß U+00DF

     "trade" => "TRADE MARK SIGN",                            # ™ U+2122

    "Uacute" => "LATIN CAPITAL LETTER U WITH ACUTE",          # Ú U+00DA
    "uacute" => "LATIN SMALL LETTER U WITH ACUTE",            # ú U+00FA
    "Ugrave" => "LATIN CAPITAL LETTER U WITH GRAVE",          # Ù U+00D9
    "ugrave" => "LATIN SMALL LETTER U WITH GRAVE",            # ù U+00F9
     "Ucirc" => "LATIN CAPITAL LETTER U WITH CIRCUMFLEX",     # Û U+00DB
     "ucirc" => "LATIN SMALL LETTER U WITH CIRCUMFLEX",       # û U+00FB
      "Uuml" => "LATIN CAPITAL LETTER U WITH DIAERESIS",      # Ü U+00DC
      "uuml" => "LATIN SMALL LETTER U WITH DIAERESIS",        # ü U+00FC

    "Yacute" => "LATIN CAPITAL LETTER Y WITH ACUTE",          # Ý U+00DD
    "yacute" => "LATIN SMALL LETTER Y WITH ACUTE",            # ý U+00FD
      "Yuml" => "LATIN CAPITAL LETTER Y WITH DIAERESIS",      # Ÿ U+0178
      "yuml" => "LATIN SMALL LETTER Y WITH DIAERESIS",        # ÿ U+00FF

     "THORN" => "LATIN CAPITAL LETTER THORN",                 # Þ U+00DE
     "thorn" => "LATIN SMALL LETTER THORN",                   # þ U+00FE

# This is *not* the same as the HEBREW LETTER ALEF (aleph),
# although it is a \p{Other_Letter} not a \p{Symbol}.
   "alefsym" => "ALEF SYMBOL",                                # ℵ U+2135

# Greek letter aliases, or things that sort with them

     "Alpha" => "GREEK CAPITAL LETTER ALPHA",                 # Α U+0391
     "alpha" => "GREEK SMALL LETTER ALPHA",                   # α U+03B1
      "Beta" => "GREEK CAPITAL LETTER BETA",                  # Β U+0392
      "beta" => "GREEK SMALL LETTER BETA",                    # β U+03B2
     "Gamma" => "GREEK CAPITAL LETTER GAMMA",                 # Γ U+0393
     "gamma" => "GREEK SMALL LETTER GAMMA",                   # γ U+03B3
     "Delta" => "GREEK CAPITAL LETTER DELTA",                 # Δ U+0394
     "delta" => "GREEK SMALL LETTER DELTA",                   # δ U+03B4
   "Epsilon" => "GREEK CAPITAL LETTER EPSILON",               # Ε U+0395
   "epsilon" => "GREEK SMALL LETTER EPSILON",                 # ε U+03B5
      "Zeta" => "GREEK CAPITAL LETTER ZETA",                  # Ζ U+0396
      "zeta" => "GREEK SMALL LETTER ZETA",                    # ζ U+03B6
       "Eta" => "GREEK CAPITAL LETTER ETA",                   # Η U+0397
       "eta" => "GREEK SMALL LETTER ETA",                     # η U+03B7
     "Theta" => "GREEK CAPITAL LETTER THETA",                 # Θ U+0398
  "thetasym" => "GREEK THETA SYMBOL",                         # ϑ U+03D1
     "theta" => "GREEK SMALL LETTER THETA",                   # θ U+03B8
      "Iota" => "GREEK CAPITAL LETTER IOTA",                  # Ι U+0399
      "iota" => "GREEK SMALL LETTER IOTA",                    # ι U+03B9
     "Kappa" => "GREEK CAPITAL LETTER KAPPA",                 # Κ U+039A
     "kappa" => "GREEK SMALL LETTER KAPPA",                   # κ U+03BA
    "Lambda" => "GREEK CAPITAL LETTER LAMDA",                 # Λ U+039B
    "lambda" => "GREEK SMALL LETTER LAMDA",                   # λ U+03BB
        "Mu" => "GREEK CAPITAL LETTER MU",                    # Μ U+039C
     "micro" => "MICRO SIGN",                                 # µ U+00B5
        "mu" => "GREEK SMALL LETTER MU",                      # μ U+03BC
        "Nu" => "GREEK CAPITAL LETTER NU",                    # Ν U+039D
        "nu" => "GREEK SMALL LETTER NU",                      # ν U+03BD
        "Xi" => "GREEK CAPITAL LETTER XI",                    # Ξ U+039E
        "xi" => "GREEK SMALL LETTER XI",                      # ξ U+03BE
   "Omicron" => "GREEK CAPITAL LETTER OMICRON",               # Ο U+039F
   "omicron" => "GREEK SMALL LETTER OMICRON",                 # ο U+03BF
        "Pi" => "GREEK CAPITAL LETTER PI",                    # Π U+03A0
       "piv" => "GREEK PI SYMBOL",                            # ϖ U+03D6
        "pi" => "GREEK SMALL LETTER PI",                      # π U+03C0
       "Rho" => "GREEK CAPITAL LETTER RHO",                   # Ρ U+03A1
       "rho" => "GREEK SMALL LETTER RHO",                     # ρ U+03C1
     "sigma" => "GREEK SMALL LETTER SIGMA",                   # σ U+03C3
    "sigmaf" => "GREEK SMALL LETTER FINAL SIGMA",             # ς U+03C2
       "Tau" => "GREEK CAPITAL LETTER TAU",                   # Τ U+03A4
       "tau" => "GREEK SMALL LETTER TAU",                     # τ U+03C4
     "upsih" => "GREEK UPSILON WITH HOOK SYMBOL",             # ϒ U+03D2
   "Upsilon" => "GREEK CAPITAL LETTER UPSILON",               # Υ U+03A5
   "upsilon" => "GREEK SMALL LETTER UPSILON",                 # υ U+03C5
       "Phi" => "GREEK CAPITAL LETTER PHI",                   # Φ U+03A6
       "phi" => "GREEK SMALL LETTER PHI",                     # φ U+03C6
       "Chi" => "GREEK CAPITAL LETTER CHI",                   # Χ U+03A7
       "chi" => "GREEK SMALL LETTER CHI",                     # χ U+03C7
       "Psi" => "GREEK CAPITAL LETTER PSI",                   # Ψ U+03A8
       "psi" => "GREEK SMALL LETTER PSI",                     # ψ U+03C8
     "Omega" => "GREEK CAPITAL LETTER OMEGA",                 # Ω U+03A9
     "omega" => "GREEK SMALL LETTER OMEGA",                   # ω U+03C9

# \p{Format} characters

       "zwj" => "ZERO WIDTH JOINER",                          # ‍ U+200D
      "zwnj" => "ZERO WIDTH NON-JOINER",                      # ‌ U+200C
       "rlm" => "RIGHT-TO-LEFT MARK",                         # ‏ U+200F
       "lrm" => "LEFT-TO-RIGHT MARK",                         # ‎ U+200E

# Various punctuation and symbols in UCA order.  
# None of these is a combining Mark.

     "oline" => "OVERLINE",                                   # ‾ U+203E
      "ensp" => "EN SPACE",                                   #   U+2002
      "nbsp" => "NO-BREAK SPACE",                             #   U+00A0
     "cedil" => "CEDILLA",                                    # ¸ U+00B8
       "uml" => "DIAERESIS",                                  # ¨ U+00A8
     "acute" => "ACUTE ACCENT",                               # ´ U+00B4
     "tilde" => "SMALL TILDE",                                # ˜ U+02DC
      "emsp" => "EM SPACE",                                   #   U+2003
      "macr" => "MACRON",                                     # ¯ U+00AF
    "thinsp" => "THIN SPACE",                                 #   U+2009
       "shy" => "SOFT HYPHEN",                                # ­ U+00AD
     "ndash" => "EN DASH",                                    # – U+2013
     "mdash" => "EM DASH",                                    # — U+2014
     "iexcl" => "INVERTED EXCLAMATION MARK",                  # ¡ U+00A1
    "iquest" => "INVERTED QUESTION MARK",                     # ¿ U+00BF
    "hellip" => "HORIZONTAL ELLIPSIS",                        # … U+2026
    "middot" => "MIDDLE DOT",                                 # · U+00B7
      "apos" => "APOSTROPHE",                                 # ' U+0027
     "lsquo" => "LEFT SINGLE QUOTATION MARK",                 # ‘ U+2018
     "rsquo" => "RIGHT SINGLE QUOTATION MARK",                # ’ U+2019
     "sbquo" => "SINGLE LOW-9 QUOTATION MARK",                # ‚ U+201A
    "lsaquo" => "SINGLE LEFT-POINTING ANGLE QUOTATION MARK",  # ‹ U+2039
    "rsaquo" => "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK", # › U+203A
      "quot" => "QUOTATION MARK",                             # " U+0022
     "ldquo" => "LEFT DOUBLE QUOTATION MARK",                 # “ U+201C
     "rdquo" => "RIGHT DOUBLE QUOTATION MARK",                # ” U+201D
     "bdquo" => "DOUBLE LOW-9 QUOTATION MARK",                # „ U+201E
     "laquo" => "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",  # « U+00AB
     "raquo" => "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK", # » U+00BB
      "lang" => "LEFT-POINTING ANGLE BRACKET",                # 〈 U+2329
      "rang" => "RIGHT-POINTING ANGLE BRACKET",               # 〉 U+232A
      "sect" => "SECTION SIGN",                               # § U+00A7
      "para" => "PILCROW SIGN",                               # ¶ U+00B6
      "copy" => "COPYRIGHT SIGN",                             # © U+00A9
       "reg" => "REGISTERED SIGN",                            # ® U+00AE
     "frasl" => "FRACTION SLASH",                             # ⁄ U+2044
       "amp" => "AMPERSAND",                                  # & U+0026
    "permil" => "PER MILLE SIGN",                             # ‰ U+2030
    "dagger" => "DAGGER",                                     # † U+2020
    "Dagger" => "DOUBLE DAGGER",                              # ‡ U+2021
      "bull" => "BULLET",                                     # • U+2022
     "prime" => "PRIME",                                      # ′ U+2032
     "Prime" => "DOUBLE PRIME",                               # ″ U+2033
      "circ" => "MODIFIER LETTER CIRCUMFLEX ACCENT",          # ˆ U+02C6
       "deg" => "DEGREE SIGN",                                # ° U+00B0
    "weierp" => "SCRIPT CAPITAL P",                           # ℘ U+2118
      "larr" => "LEFTWARDS ARROW",                            # ← U+2190
      "rarr" => "RIGHTWARDS ARROW",                           # → U+2192
      "uarr" => "UPWARDS ARROW",                              # ↑ U+2191
      "darr" => "DOWNWARDS ARROW",                            # ↓ U+2193
      "harr" => "LEFT RIGHT ARROW",                           # ↔ U+2194
     "crarr" => "DOWNWARDS ARROW WITH CORNER LEFTWARDS",      # ↵ U+21B5
      "lArr" => "LEFTWARDS DOUBLE ARROW",                     # ⇐ U+21D0
      "uArr" => "UPWARDS DOUBLE ARROW",                       # ⇑ U+21D1
      "rArr" => "RIGHTWARDS DOUBLE ARROW",                    # ⇒ U+21D2
      "dArr" => "DOWNWARDS DOUBLE ARROW",                     # ⇓ U+21D3
      "hArr" => "LEFT RIGHT DOUBLE ARROW",                    # ⇔ U+21D4
    "forall" => "FOR ALL",                                    # ∀ U+2200
      "part" => "PARTIAL DIFFERENTIAL",                       # ∂ U+2202
     "exist" => "THERE EXISTS",                               # ∃ U+2203
     "empty" => "EMPTY SET",                                  # ∅ U+2205
     "nabla" => "NABLA",                                      # ∇ U+2207
      "isin" => "ELEMENT OF",                                 # ∈ U+2208
     "notin" => "NOT AN ELEMENT OF",                          # ∉ U+2209
        "ni" => "CONTAINS AS MEMBER",                         # ∋ U+220B
      "prod" => "N-ARY PRODUCT",                              # ∏ U+220F
       "sum" => "N-ARY SUMMATION",                            # ∑ U+2211
    "plusmn" => "PLUS-MINUS SIGN",                            # ± U+00B1
    "divide" => "DIVISION SIGN",                              # ÷ U+00F7
     "times" => "MULTIPLICATION SIGN",                        # × U+00D7
        "lt" => "LESS-THAN SIGN",                             # < U+003C
        "ne" => "NOT EQUAL TO",                               # ≠ U+2260
        "gt" => "GREATER-THAN SIGN",                          # > U+003E
       "not" => "NOT SIGN",                                   # ¬ U+00AC
    "brvbar" => "BROKEN BAR",                                 # ¦ U+00A6
     "minus" => "MINUS SIGN",                                 # − U+2212
    "lowast" => "ASTERISK OPERATOR",                          # ∗ U+2217
     "radic" => "SQUARE ROOT",                                # √ U+221A
      "prop" => "PROPORTIONAL TO",                            # ∝ U+221D
     "infin" => "INFINITY",                                   # ∞ U+221E
       "ang" => "ANGLE",                                      # ∠ U+2220
       "and" => "LOGICAL AND",                                # ∧ U+2227
        "or" => "LOGICAL OR",                                 # ∨ U+2228
       "cap" => "INTERSECTION",                               # ∩ U+2229
       "cup" => "UNION",                                      # ∪ U+222A
       "int" => "INTEGRAL",                                   # ∫ U+222B
    "there4" => "THEREFORE",                                  # ∴ U+2234
       "sim" => "TILDE OPERATOR",                             # ∼ U+223C
      "cong" => "APPROXIMATELY EQUAL TO",                     # ≅ U+2245
     "asymp" => "ALMOST EQUAL TO",                            # ≈ U+2248
     "equiv" => "IDENTICAL TO",                               # ≡ U+2261
        "le" => "LESS-THAN OR EQUAL TO",                      # ≤ U+2264
        "ge" => "GREATER-THAN OR EQUAL TO",                   # ≥ U+2265
       "sub" => "SUBSET OF",                                  # ⊂ U+2282
      "nsub" => "NOT A SUBSET OF",                            # ⊄ U+2284
       "sup" => "SUPERSET OF",                                # ⊃ U+2283
      "sube" => "SUBSET OF OR EQUAL TO",                      # ⊆ U+2286
      "supe" => "SUPERSET OF OR EQUAL TO",                    # ⊇ U+2287
     "oplus" => "CIRCLED PLUS",                               # ⊕ U+2295
    "otimes" => "CIRCLED TIMES",                              # ⊗ U+2297
      "perp" => "UP TACK",                                    # ⊥ U+22A5
      "sdot" => "DOT OPERATOR",                               # ⋅ U+22C5
     "lceil" => "LEFT CEILING",                               # ⌈ U+2308
     "rceil" => "RIGHT CEILING",                              # ⌉ U+2309
    "lfloor" => "LEFT FLOOR",                                 # ⌊ U+230A
    "rfloor" => "RIGHT FLOOR",                                # ⌋ U+230B
       "loz" => "LOZENGE",                                    # ◊ U+25CA
    "spades" => "BLACK SPADE SUIT",                           # ♠ U+2660
     "clubs" => "BLACK CLUB SUIT",                            # ♣ U+2663
    "hearts" => "BLACK HEART SUIT",                           # ♥ U+2665
     "diams" => "BLACK DIAMOND SUIT",                         # ♦ U+2666

);

__END__

###################################################
#   alternate version, UCA-sorted left to right   #
###################################################

    "Aacute" => "LATIN CAPITAL LETTER A WITH ACUTE",          # Á U+00C1
    "aacute" => "LATIN SMALL LETTER A WITH ACUTE",            # á U+00E1
     "Acirc" => "LATIN CAPITAL LETTER A WITH CIRCUMFLEX",     # Â U+00C2
     "acirc" => "LATIN SMALL LETTER A WITH CIRCUMFLEX",       # â U+00E2
     "acute" => "ACUTE ACCENT",                               # ´ U+00B4
     "AElig" => "LATIN CAPITAL LETTER AE",                    # Æ U+00C6
     "aelig" => "LATIN SMALL LETTER AE",                      # æ U+00E6
    "Agrave" => "LATIN CAPITAL LETTER A WITH GRAVE",          # À U+00C0
    "agrave" => "LATIN SMALL LETTER A WITH GRAVE",            # à U+00E0
   "alefsym" => "ALEF SYMBOL",                                # ℵ U+2135
     "Alpha" => "GREEK CAPITAL LETTER ALPHA",                 # Α U+0391
     "alpha" => "GREEK SMALL LETTER ALPHA",                   # α U+03B1
       "amp" => "AMPERSAND",                                  # & U+0026
       "and" => "LOGICAL AND",                                # ∧ U+2227
       "ang" => "ANGLE",                                      # ∠ U+2220
      "apos" => "APOSTROPHE",                                 # ' U+0027
     "Aring" => "LATIN CAPITAL LETTER A WITH RING ABOVE",     # Å U+00C5
     "aring" => "LATIN SMALL LETTER A WITH RING ABOVE",       # å U+00E5
     "asymp" => "ALMOST EQUAL TO",                            # ≈ U+2248
    "Atilde" => "LATIN CAPITAL LETTER A WITH TILDE",          # Ã U+00C3
    "atilde" => "LATIN SMALL LETTER A WITH TILDE",            # ã U+00E3
      "Auml" => "LATIN CAPITAL LETTER A WITH DIAERESIS",      # Ä U+00C4
      "auml" => "LATIN SMALL LETTER A WITH DIAERESIS",        # ä U+00E4
     "bdquo" => "DOUBLE LOW-9 QUOTATION MARK",                # „ U+201E
      "Beta" => "GREEK CAPITAL LETTER BETA",                  # Β U+0392
      "beta" => "GREEK SMALL LETTER BETA",                    # β U+03B2
    "brvbar" => "BROKEN BAR",                                 # ¦ U+00A6
      "bull" => "BULLET",                                     # • U+2022
       "cap" => "INTERSECTION",                               # ∩ U+2229
    "Ccedil" => "LATIN CAPITAL LETTER C WITH CEDILLA",        # Ç U+00C7
    "ccedil" => "LATIN SMALL LETTER C WITH CEDILLA",          # ç U+00E7
     "cedil" => "CEDILLA",                                    # ¸ U+00B8
      "cent" => "CENT SIGN",                                  # ¢ U+00A2
       "Chi" => "GREEK CAPITAL LETTER CHI",                   # Χ U+03A7
       "chi" => "GREEK SMALL LETTER CHI",                     # χ U+03C7
      "circ" => "MODIFIER LETTER CIRCUMFLEX ACCENT",          # ˆ U+02C6
     "clubs" => "BLACK CLUB SUIT",                            # ♣ U+2663
      "cong" => "APPROXIMATELY EQUAL TO",                     # ≅ U+2245
      "copy" => "COPYRIGHT SIGN",                             # © U+00A9
     "crarr" => "DOWNWARDS ARROW WITH CORNER LEFTWARDS",      # ↵ U+21B5
       "cup" => "UNION",                                      # ∪ U+222A
    "curren" => "CURRENCY SIGN",                              # ¤ U+00A4
    "dagger" => "DAGGER",                                     # † U+2020
    "Dagger" => "DOUBLE DAGGER",                              # ‡ U+2021
      "darr" => "DOWNWARDS ARROW",                            # ↓ U+2193
      "dArr" => "DOWNWARDS DOUBLE ARROW",                     # ⇓ U+21D3
       "deg" => "DEGREE SIGN",                                # ° U+00B0
     "Delta" => "GREEK CAPITAL LETTER DELTA",                 # Δ U+0394
     "delta" => "GREEK SMALL LETTER DELTA",                   # δ U+03B4
     "diams" => "BLACK DIAMOND SUIT",                         # ♦ U+2666
    "divide" => "DIVISION SIGN",                              # ÷ U+00F7
    "Eacute" => "LATIN CAPITAL LETTER E WITH ACUTE",          # É U+00C9
    "eacute" => "LATIN SMALL LETTER E WITH ACUTE",            # é U+00E9
     "Ecirc" => "LATIN CAPITAL LETTER E WITH CIRCUMFLEX",     # Ê U+00CA
     "ecirc" => "LATIN SMALL LETTER E WITH CIRCUMFLEX",       # ê U+00EA
    "Egrave" => "LATIN CAPITAL LETTER E WITH GRAVE",          # È U+00C8
    "egrave" => "LATIN SMALL LETTER E WITH GRAVE",            # è U+00E8
     "empty" => "EMPTY SET",                                  # ∅ U+2205
      "emsp" => "EM SPACE",                                   #   U+2003
      "ensp" => "EN SPACE",                                   #   U+2002
   "Epsilon" => "GREEK CAPITAL LETTER EPSILON",               # Ε U+0395
   "epsilon" => "GREEK SMALL LETTER EPSILON",                 # ε U+03B5
     "equiv" => "IDENTICAL TO",                               # ≡ U+2261
       "Eta" => "GREEK CAPITAL LETTER ETA",                   # Η U+0397
       "eta" => "GREEK SMALL LETTER ETA",                     # η U+03B7
       "ETH" => "LATIN CAPITAL LETTER ETH",                   # Ð U+00D0
       "eth" => "LATIN SMALL LETTER ETH",                     # ð U+00F0
      "Euml" => "LATIN CAPITAL LETTER E WITH DIAERESIS",      # Ë U+00CB
      "euml" => "LATIN SMALL LETTER E WITH DIAERESIS",        # ë U+00EB
      "euro" => "EURO SIGN",                                  # € U+20AC
     "exist" => "THERE EXISTS",                               # ∃ U+2203
      "fnof" => "LATIN SMALL LETTER F WITH HOOK",             # ƒ U+0192
    "forall" => "FOR ALL",                                    # ∀ U+2200
    "frac12" => "VULGAR FRACTION ONE HALF",                   # ½ U+00BD
    "frac14" => "VULGAR FRACTION ONE QUARTER",                # ¼ U+00BC
    "frac34" => "VULGAR FRACTION THREE QUARTERS",             # ¾ U+00BE
     "frasl" => "FRACTION SLASH",                             # ⁄ U+2044
     "Gamma" => "GREEK CAPITAL LETTER GAMMA",                 # Γ U+0393
     "gamma" => "GREEK SMALL LETTER GAMMA",                   # γ U+03B3
        "ge" => "GREATER-THAN OR EQUAL TO",                   # ≥ U+2265
        "gt" => "GREATER-THAN SIGN",                          # > U+003E
      "harr" => "LEFT RIGHT ARROW",                           # ↔ U+2194
      "hArr" => "LEFT RIGHT DOUBLE ARROW",                    # ⇔ U+21D4
    "hearts" => "BLACK HEART SUIT",                           # ♥ U+2665
    "hellip" => "HORIZONTAL ELLIPSIS",                        # … U+2026
    "Iacute" => "LATIN CAPITAL LETTER I WITH ACUTE",          # Í U+00CD
    "iacute" => "LATIN SMALL LETTER I WITH ACUTE",            # í U+00ED
     "Icirc" => "LATIN CAPITAL LETTER I WITH CIRCUMFLEX",     # Î U+00CE
     "icirc" => "LATIN SMALL LETTER I WITH CIRCUMFLEX",       # î U+00EE
     "iexcl" => "INVERTED EXCLAMATION MARK",                  # ¡ U+00A1
    "Igrave" => "LATIN CAPITAL LETTER I WITH GRAVE",          # Ì U+00CC
    "igrave" => "LATIN SMALL LETTER I WITH GRAVE",            # ì U+00EC
     "image" => "BLACK-LETTER CAPITAL I",                     # ℑ U+2111
     "infin" => "INFINITY",                                   # ∞ U+221E
       "int" => "INTEGRAL",                                   # ∫ U+222B
      "Iota" => "GREEK CAPITAL LETTER IOTA",                  # Ι U+0399
      "iota" => "GREEK SMALL LETTER IOTA",                    # ι U+03B9
    "iquest" => "INVERTED QUESTION MARK",                     # ¿ U+00BF
      "isin" => "ELEMENT OF",                                 # ∈ U+2208
      "Iuml" => "LATIN CAPITAL LETTER I WITH DIAERESIS",      # Ï U+00CF
      "iuml" => "LATIN SMALL LETTER I WITH DIAERESIS",        # ï U+00EF
     "Kappa" => "GREEK CAPITAL LETTER KAPPA",                 # Κ U+039A
     "kappa" => "GREEK SMALL LETTER KAPPA",                   # κ U+03BA
    "Lambda" => "GREEK CAPITAL LETTER LAMDA",                 # Λ U+039B
    "lambda" => "GREEK SMALL LETTER LAMDA",                   # λ U+03BB
      "lang" => "LEFT-POINTING ANGLE BRACKET",                # 〈 U+2329
     "laquo" => "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",  # « U+00AB
      "larr" => "LEFTWARDS ARROW",                            # ← U+2190
      "lArr" => "LEFTWARDS DOUBLE ARROW",                     # ⇐ U+21D0
     "lceil" => "LEFT CEILING",                               # ⌈ U+2308
     "ldquo" => "LEFT DOUBLE QUOTATION MARK",                 # “ U+201C
        "le" => "LESS-THAN OR EQUAL TO",                      # ≤ U+2264
    "lfloor" => "LEFT FLOOR",                                 # ⌊ U+230A
    "lowast" => "ASTERISK OPERATOR",                          # ∗ U+2217
       "loz" => "LOZENGE",                                    # ◊ U+25CA
       "lrm" => "LEFT-TO-RIGHT MARK",                         # ‎ U+200E
    "lsaquo" => "SINGLE LEFT-POINTING ANGLE QUOTATION MARK",  # ‹ U+2039
     "lsquo" => "LEFT SINGLE QUOTATION MARK",                 # ‘ U+2018
        "lt" => "LESS-THAN SIGN",                             # < U+003C
      "macr" => "MACRON",                                     # ¯ U+00AF
     "mdash" => "EM DASH",                                    # — U+2014
     "micro" => "MICRO SIGN",                                 # µ U+00B5
    "middot" => "MIDDLE DOT",                                 # · U+00B7
     "minus" => "MINUS SIGN",                                 # − U+2212
        "Mu" => "GREEK CAPITAL LETTER MU",                    # Μ U+039C
        "mu" => "GREEK SMALL LETTER MU",                      # μ U+03BC
     "nabla" => "NABLA",                                      # ∇ U+2207
      "nbsp" => "NO-BREAK SPACE",                             #   U+00A0
     "ndash" => "EN DASH",                                    # – U+2013
        "ne" => "NOT EQUAL TO",                               # ≠ U+2260
        "ni" => "CONTAINS AS MEMBER",                         # ∋ U+220B
     "notin" => "NOT AN ELEMENT OF",                          # ∉ U+2209
       "not" => "NOT SIGN",                                   # ¬ U+00AC
      "nsub" => "NOT A SUBSET OF",                            # ⊄ U+2284
    "Ntilde" => "LATIN CAPITAL LETTER N WITH TILDE",          # Ñ U+00D1
    "ntilde" => "LATIN SMALL LETTER N WITH TILDE",            # ñ U+00F1
        "Nu" => "GREEK CAPITAL LETTER NU",                    # Ν U+039D
        "nu" => "GREEK SMALL LETTER NU",                      # ν U+03BD
    "Oacute" => "LATIN CAPITAL LETTER O WITH ACUTE",          # Ó U+00D3
    "oacute" => "LATIN SMALL LETTER O WITH ACUTE",            # ó U+00F3
     "Ocirc" => "LATIN CAPITAL LETTER O WITH CIRCUMFLEX",     # Ô U+00D4
     "ocirc" => "LATIN SMALL LETTER O WITH CIRCUMFLEX",       # ô U+00F4
     "OElig" => "LATIN CAPITAL LIGATURE OE",                  # Œ U+0152
     "oelig" => "LATIN SMALL LIGATURE OE",                    # œ U+0153
    "Ograve" => "LATIN CAPITAL LETTER O WITH GRAVE",          # Ò U+00D2
    "ograve" => "LATIN SMALL LETTER O WITH GRAVE",            # ò U+00F2
     "oline" => "OVERLINE",                                   # ‾ U+203E
     "Omega" => "GREEK CAPITAL LETTER OMEGA",                 # Ω U+03A9
     "omega" => "GREEK SMALL LETTER OMEGA",                   # ω U+03C9
   "Omicron" => "GREEK CAPITAL LETTER OMICRON",               # Ο U+039F
   "omicron" => "GREEK SMALL LETTER OMICRON",                 # ο U+03BF
     "oplus" => "CIRCLED PLUS",                               # ⊕ U+2295
      "ordf" => "FEMININE ORDINAL INDICATOR",                 # ª U+00AA
      "ordm" => "MASCULINE ORDINAL INDICATOR",                # º U+00BA
        "or" => "LOGICAL OR",                                 # ∨ U+2228
    "Oslash" => "LATIN CAPITAL LETTER O WITH STROKE",         # Ø U+00D8
    "oslash" => "LATIN SMALL LETTER O WITH STROKE",           # ø U+00F8
    "Otilde" => "LATIN CAPITAL LETTER O WITH TILDE",          # Õ U+00D5
    "otilde" => "LATIN SMALL LETTER O WITH TILDE",            # õ U+00F5
    "otimes" => "CIRCLED TIMES",                              # ⊗ U+2297
      "Ouml" => "LATIN CAPITAL LETTER O WITH DIAERESIS",      # Ö U+00D6
      "ouml" => "LATIN SMALL LETTER O WITH DIAERESIS",        # ö U+00F6
      "para" => "PILCROW SIGN",                               # ¶ U+00B6
      "part" => "PARTIAL DIFFERENTIAL",                       # ∂ U+2202
    "permil" => "PER MILLE SIGN",                             # ‰ U+2030
      "perp" => "UP TACK",                                    # ⊥ U+22A5
       "Phi" => "GREEK CAPITAL LETTER PHI",                   # Φ U+03A6
       "phi" => "GREEK SMALL LETTER PHI",                     # φ U+03C6
        "Pi" => "GREEK CAPITAL LETTER PI",                    # Π U+03A0
        "pi" => "GREEK SMALL LETTER PI",                      # π U+03C0
       "piv" => "GREEK PI SYMBOL",                            # ϖ U+03D6
    "plusmn" => "PLUS-MINUS SIGN",                            # ± U+00B1
     "pound" => "POUND SIGN",                                 # £ U+00A3
     "Prime" => "DOUBLE PRIME",                               # ″ U+2033
     "prime" => "PRIME",                                      # ′ U+2032
      "prod" => "N-ARY PRODUCT",                              # ∏ U+220F
      "prop" => "PROPORTIONAL TO",                            # ∝ U+221D
       "Psi" => "GREEK CAPITAL LETTER PSI",                   # Ψ U+03A8
       "psi" => "GREEK SMALL LETTER PSI",                     # ψ U+03C8
      "quot" => "QUOTATION MARK",                             # " U+0022
     "radic" => "SQUARE ROOT",                                # √ U+221A
      "rang" => "RIGHT-POINTING ANGLE BRACKET",               # 〉 U+232A
     "raquo" => "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK", # » U+00BB
      "rarr" => "RIGHTWARDS ARROW",                           # → U+2192
      "rArr" => "RIGHTWARDS DOUBLE ARROW",                    # ⇒ U+21D2
     "rceil" => "RIGHT CEILING",                              # ⌉ U+2309
     "rdquo" => "RIGHT DOUBLE QUOTATION MARK",                # ” U+201D
      "real" => "BLACK-LETTER CAPITAL R",                     # ℜ U+211C
       "reg" => "REGISTERED SIGN",                            # ® U+00AE
    "rfloor" => "RIGHT FLOOR",                                # ⌋ U+230B
       "Rho" => "GREEK CAPITAL LETTER RHO",                   # Ρ U+03A1
       "rho" => "GREEK SMALL LETTER RHO",                     # ρ U+03C1
       "rlm" => "RIGHT-TO-LEFT MARK",                         # ‏ U+200F
    "rsaquo" => "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK", # › U+203A
     "rsquo" => "RIGHT SINGLE QUOTATION MARK",                # ’ U+2019
     "sbquo" => "SINGLE LOW-9 QUOTATION MARK",                # ‚ U+201A
    "Scaron" => "LATIN CAPITAL LETTER S WITH CARON",          # Š U+0160
    "scaron" => "LATIN SMALL LETTER S WITH CARON",            # š U+0161
      "sdot" => "DOT OPERATOR",                               # ⋅ U+22C5
      "sect" => "SECTION SIGN",                               # § U+00A7
       "shy" => "SOFT HYPHEN",                                # ­ U+00AD
    "sigmaf" => "GREEK SMALL LETTER FINAL SIGMA",             # ς U+03C2
     "Sigma" => "GREEK CAPITAL LETTER SIGMA",                 # Σ U+03A3
     "sigma" => "GREEK SMALL LETTER SIGMA",                   # σ U+03C3
       "sim" => "TILDE OPERATOR",                             # ∼ U+223C
    "spades" => "BLACK SPADE SUIT",                           # ♠ U+2660
      "sube" => "SUBSET OF OR EQUAL TO",                      # ⊆ U+2286
       "sub" => "SUBSET OF",                                  # ⊂ U+2282
       "sum" => "N-ARY SUMMATION",                            # ∑ U+2211
      "sup1" => "SUPERSCRIPT ONE",                            # ¹ U+00B9
      "sup2" => "SUPERSCRIPT TWO",                            # ² U+00B2
      "sup3" => "SUPERSCRIPT THREE",                          # ³ U+00B3
      "supe" => "SUPERSET OF OR EQUAL TO",                    # ⊇ U+2287
       "sup" => "SUPERSET OF",                                # ⊃ U+2283
     "szlig" => "LATIN SMALL LETTER SHARP S",                 # ß U+00DF
       "Tau" => "GREEK CAPITAL LETTER TAU",                   # Τ U+03A4
       "tau" => "GREEK SMALL LETTER TAU",                     # τ U+03C4
    "there4" => "THEREFORE",                                  # ∴ U+2234
     "Theta" => "GREEK CAPITAL LETTER THETA",                 # Θ U+0398
     "theta" => "GREEK SMALL LETTER THETA",                   # θ U+03B8
  "thetasym" => "GREEK THETA SYMBOL",                         # ϑ U+03D1
    "thinsp" => "THIN SPACE",                                 #   U+2009
     "THORN" => "LATIN CAPITAL LETTER THORN",                 # Þ U+00DE
     "thorn" => "LATIN SMALL LETTER THORN",                   # þ U+00FE
     "tilde" => "SMALL TILDE",                                # ˜ U+02DC
     "times" => "MULTIPLICATION SIGN",                        # × U+00D7
     "trade" => "TRADE MARK SIGN",                            # ™ U+2122
    "Uacute" => "LATIN CAPITAL LETTER U WITH ACUTE",          # Ú U+00DA
    "uacute" => "LATIN SMALL LETTER U WITH ACUTE",            # ú U+00FA
      "uarr" => "UPWARDS ARROW",                              # ↑ U+2191
      "uArr" => "UPWARDS DOUBLE ARROW",                       # ⇑ U+21D1
     "Ucirc" => "LATIN CAPITAL LETTER U WITH CIRCUMFLEX",     # Û U+00DB
     "ucirc" => "LATIN SMALL LETTER U WITH CIRCUMFLEX",       # û U+00FB
    "Ugrave" => "LATIN CAPITAL LETTER U WITH GRAVE",          # Ù U+00D9
    "ugrave" => "LATIN SMALL LETTER U WITH GRAVE",            # ù U+00F9
       "uml" => "DIAERESIS",                                  # ¨ U+00A8
     "upsih" => "GREEK UPSILON WITH HOOK SYMBOL",             # ϒ U+03D2
   "Upsilon" => "GREEK CAPITAL LETTER UPSILON",               # Υ U+03A5
   "upsilon" => "GREEK SMALL LETTER UPSILON",                 # υ U+03C5
      "Uuml" => "LATIN CAPITAL LETTER U WITH DIAERESIS",      # Ü U+00DC
      "uuml" => "LATIN SMALL LETTER U WITH DIAERESIS",        # ü U+00FC
    "weierp" => "SCRIPT CAPITAL P",                           # ℘ U+2118
        "Xi" => "GREEK CAPITAL LETTER XI",                    # Ξ U+039E
        "xi" => "GREEK SMALL LETTER XI",                      # ξ U+03BE
    "Yacute" => "LATIN CAPITAL LETTER Y WITH ACUTE",          # Ý U+00DD
    "yacute" => "LATIN SMALL LETTER Y WITH ACUTE",            # ý U+00FD
       "yen" => "YEN SIGN",                                   # ¥ U+00A5
      "Yuml" => "LATIN CAPITAL LETTER Y WITH DIAERESIS",      # Ÿ U+0178
      "yuml" => "LATIN SMALL LETTER Y WITH DIAERESIS",        # ÿ U+00FF
      "Zeta" => "GREEK CAPITAL LETTER ZETA",                  # Ζ U+0396
      "zeta" => "GREEK SMALL LETTER ZETA",                    # ζ U+03B6
       "zwj" => "ZERO WIDTH JOINER",                          # ‍ U+200D
      "zwnj" => "ZERO WIDTH NON-JOINER",                      # ‌ U+200C

######################################################
#   alternate version sorted by numeric code point   #
######################################################

      "quot" => "QUOTATION MARK",                             # " U+0022
       "amp" => "AMPERSAND",                                  # & U+0026
      "apos" => "APOSTROPHE",                                 # ' U+0027
        "lt" => "LESS-THAN SIGN",                             # < U+003C
        "gt" => "GREATER-THAN SIGN",                          # > U+003E
      "nbsp" => "NO-BREAK SPACE",                             #   U+00A0
     "iexcl" => "INVERTED EXCLAMATION MARK",                  # ¡ U+00A1
      "cent" => "CENT SIGN",                                  # ¢ U+00A2
     "pound" => "POUND SIGN",                                 # £ U+00A3
    "curren" => "CURRENCY SIGN",                              # ¤ U+00A4
       "yen" => "YEN SIGN",                                   # ¥ U+00A5
    "brvbar" => "BROKEN BAR",                                 # ¦ U+00A6
      "sect" => "SECTION SIGN",                               # § U+00A7
       "uml" => "DIAERESIS",                                  # ¨ U+00A8
      "copy" => "COPYRIGHT SIGN",                             # © U+00A9
      "ordf" => "FEMININE ORDINAL INDICATOR",                 # ª U+00AA
     "laquo" => "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",  # « U+00AB
       "not" => "NOT SIGN",                                   # ¬ U+00AC
       "shy" => "SOFT HYPHEN",                                # ­ U+00AD
       "reg" => "REGISTERED SIGN",                            # ® U+00AE
      "macr" => "MACRON",                                     # ¯ U+00AF
       "deg" => "DEGREE SIGN",                                # ° U+00B0
    "plusmn" => "PLUS-MINUS SIGN",                            # ± U+00B1
      "sup2" => "SUPERSCRIPT TWO",                            # ² U+00B2
      "sup3" => "SUPERSCRIPT THREE",                          # ³ U+00B3
     "acute" => "ACUTE ACCENT",                               # ´ U+00B4
     "micro" => "MICRO SIGN",                                 # µ U+00B5
      "para" => "PILCROW SIGN",                               # ¶ U+00B6
    "middot" => "MIDDLE DOT",                                 # · U+00B7
     "cedil" => "CEDILLA",                                    # ¸ U+00B8
      "sup1" => "SUPERSCRIPT ONE",                            # ¹ U+00B9
      "ordm" => "MASCULINE ORDINAL INDICATOR",                # º U+00BA
     "raquo" => "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK", # » U+00BB
    "frac14" => "VULGAR FRACTION ONE QUARTER",                # ¼ U+00BC
    "frac12" => "VULGAR FRACTION ONE HALF",                   # ½ U+00BD
    "frac34" => "VULGAR FRACTION THREE QUARTERS",             # ¾ U+00BE
    "iquest" => "INVERTED QUESTION MARK",                     # ¿ U+00BF
    "Agrave" => "LATIN CAPITAL LETTER A WITH GRAVE",          # À U+00C0
    "Aacute" => "LATIN CAPITAL LETTER A WITH ACUTE",          # Á U+00C1
     "Acirc" => "LATIN CAPITAL LETTER A WITH CIRCUMFLEX",     # Â U+00C2
    "Atilde" => "LATIN CAPITAL LETTER A WITH TILDE",          # Ã U+00C3
      "Auml" => "LATIN CAPITAL LETTER A WITH DIAERESIS",      # Ä U+00C4
     "Aring" => "LATIN CAPITAL LETTER A WITH RING ABOVE",     # Å U+00C5
     "AElig" => "LATIN CAPITAL LETTER AE",                    # Æ U+00C6
    "Ccedil" => "LATIN CAPITAL LETTER C WITH CEDILLA",        # Ç U+00C7
    "Egrave" => "LATIN CAPITAL LETTER E WITH GRAVE",          # È U+00C8
    "Eacute" => "LATIN CAPITAL LETTER E WITH ACUTE",          # É U+00C9
     "Ecirc" => "LATIN CAPITAL LETTER E WITH CIRCUMFLEX",     # Ê U+00CA
      "Euml" => "LATIN CAPITAL LETTER E WITH DIAERESIS",      # Ë U+00CB
    "Igrave" => "LATIN CAPITAL LETTER I WITH GRAVE",          # Ì U+00CC
    "Iacute" => "LATIN CAPITAL LETTER I WITH ACUTE",          # Í U+00CD
     "Icirc" => "LATIN CAPITAL LETTER I WITH CIRCUMFLEX",     # Î U+00CE
      "Iuml" => "LATIN CAPITAL LETTER I WITH DIAERESIS",      # Ï U+00CF
       "ETH" => "LATIN CAPITAL LETTER ETH",                   # Ð U+00D0
    "Ntilde" => "LATIN CAPITAL LETTER N WITH TILDE",          # Ñ U+00D1
    "Ograve" => "LATIN CAPITAL LETTER O WITH GRAVE",          # Ò U+00D2
    "Oacute" => "LATIN CAPITAL LETTER O WITH ACUTE",          # Ó U+00D3
     "Ocirc" => "LATIN CAPITAL LETTER O WITH CIRCUMFLEX",     # Ô U+00D4
    "Otilde" => "LATIN CAPITAL LETTER O WITH TILDE",          # Õ U+00D5
      "Ouml" => "LATIN CAPITAL LETTER O WITH DIAERESIS",      # Ö U+00D6
     "times" => "MULTIPLICATION SIGN",                        # × U+00D7
    "Oslash" => "LATIN CAPITAL LETTER O WITH STROKE",         # Ø U+00D8
    "Ugrave" => "LATIN CAPITAL LETTER U WITH GRAVE",          # Ù U+00D9
    "Uacute" => "LATIN CAPITAL LETTER U WITH ACUTE",          # Ú U+00DA
     "Ucirc" => "LATIN CAPITAL LETTER U WITH CIRCUMFLEX",     # Û U+00DB
      "Uuml" => "LATIN CAPITAL LETTER U WITH DIAERESIS",      # Ü U+00DC
    "Yacute" => "LATIN CAPITAL LETTER Y WITH ACUTE",          # Ý U+00DD
     "THORN" => "LATIN CAPITAL LETTER THORN",                 # Þ U+00DE
     "szlig" => "LATIN SMALL LETTER SHARP S",                 # ß U+00DF
    "agrave" => "LATIN SMALL LETTER A WITH GRAVE",            # à U+00E0
    "aacute" => "LATIN SMALL LETTER A WITH ACUTE",            # á U+00E1
     "acirc" => "LATIN SMALL LETTER A WITH CIRCUMFLEX",       # â U+00E2
    "atilde" => "LATIN SMALL LETTER A WITH TILDE",            # ã U+00E3
      "auml" => "LATIN SMALL LETTER A WITH DIAERESIS",        # ä U+00E4
     "aring" => "LATIN SMALL LETTER A WITH RING ABOVE",       # å U+00E5
     "aelig" => "LATIN SMALL LETTER AE",                      # æ U+00E6
    "ccedil" => "LATIN SMALL LETTER C WITH CEDILLA",          # ç U+00E7
    "egrave" => "LATIN SMALL LETTER E WITH GRAVE",            # è U+00E8
    "eacute" => "LATIN SMALL LETTER E WITH ACUTE",            # é U+00E9
     "ecirc" => "LATIN SMALL LETTER E WITH CIRCUMFLEX",       # ê U+00EA
      "euml" => "LATIN SMALL LETTER E WITH DIAERESIS",        # ë U+00EB
    "igrave" => "LATIN SMALL LETTER I WITH GRAVE",            # ì U+00EC
    "iacute" => "LATIN SMALL LETTER I WITH ACUTE",            # í U+00ED
     "icirc" => "LATIN SMALL LETTER I WITH CIRCUMFLEX",       # î U+00EE
      "iuml" => "LATIN SMALL LETTER I WITH DIAERESIS",        # ï U+00EF
       "eth" => "LATIN SMALL LETTER ETH",                     # ð U+00F0
    "ntilde" => "LATIN SMALL LETTER N WITH TILDE",            # ñ U+00F1
    "ograve" => "LATIN SMALL LETTER O WITH GRAVE",            # ò U+00F2
    "oacute" => "LATIN SMALL LETTER O WITH ACUTE",            # ó U+00F3
     "ocirc" => "LATIN SMALL LETTER O WITH CIRCUMFLEX",       # ô U+00F4
    "otilde" => "LATIN SMALL LETTER O WITH TILDE",            # õ U+00F5
      "ouml" => "LATIN SMALL LETTER O WITH DIAERESIS",        # ö U+00F6
    "divide" => "DIVISION SIGN",                              # ÷ U+00F7
    "oslash" => "LATIN SMALL LETTER O WITH STROKE",           # ø U+00F8
    "ugrave" => "LATIN SMALL LETTER U WITH GRAVE",            # ù U+00F9
    "uacute" => "LATIN SMALL LETTER U WITH ACUTE",            # ú U+00FA
     "ucirc" => "LATIN SMALL LETTER U WITH CIRCUMFLEX",       # û U+00FB
      "uuml" => "LATIN SMALL LETTER U WITH DIAERESIS",        # ü U+00FC
    "yacute" => "LATIN SMALL LETTER Y WITH ACUTE",            # ý U+00FD
     "thorn" => "LATIN SMALL LETTER THORN",                   # þ U+00FE
      "yuml" => "LATIN SMALL LETTER Y WITH DIAERESIS",        # ÿ U+00FF
     "OElig" => "LATIN CAPITAL LIGATURE OE",                  # Œ U+0152
     "oelig" => "LATIN SMALL LIGATURE OE",                    # œ U+0153
    "Scaron" => "LATIN CAPITAL LETTER S WITH CARON",          # Š U+0160
    "scaron" => "LATIN SMALL LETTER S WITH CARON",            # š U+0161
      "Yuml" => "LATIN CAPITAL LETTER Y WITH DIAERESIS",      # Ÿ U+0178
      "fnof" => "LATIN SMALL LETTER F WITH HOOK",             # ƒ U+0192
      "circ" => "MODIFIER LETTER CIRCUMFLEX ACCENT",          # ˆ U+02C6
     "tilde" => "SMALL TILDE",                                # ˜ U+02DC
     "Alpha" => "GREEK CAPITAL LETTER ALPHA",                 # Α U+0391
      "Beta" => "GREEK CAPITAL LETTER BETA",                  # Β U+0392
     "Gamma" => "GREEK CAPITAL LETTER GAMMA",                 # Γ U+0393
     "Delta" => "GREEK CAPITAL LETTER DELTA",                 # Δ U+0394
   "Epsilon" => "GREEK CAPITAL LETTER EPSILON",               # Ε U+0395
      "Zeta" => "GREEK CAPITAL LETTER ZETA",                  # Ζ U+0396
       "Eta" => "GREEK CAPITAL LETTER ETA",                   # Η U+0397
     "Theta" => "GREEK CAPITAL LETTER THETA",                 # Θ U+0398
      "Iota" => "GREEK CAPITAL LETTER IOTA",                  # Ι U+0399
     "Kappa" => "GREEK CAPITAL LETTER KAPPA",                 # Κ U+039A
    "Lambda" => "GREEK CAPITAL LETTER LAMDA",                 # Λ U+039B
        "Mu" => "GREEK CAPITAL LETTER MU",                    # Μ U+039C
        "Nu" => "GREEK CAPITAL LETTER NU",                    # Ν U+039D
        "Xi" => "GREEK CAPITAL LETTER XI",                    # Ξ U+039E
   "Omicron" => "GREEK CAPITAL LETTER OMICRON",               # Ο U+039F
        "Pi" => "GREEK CAPITAL LETTER PI",                    # Π U+03A0
       "Rho" => "GREEK CAPITAL LETTER RHO",                   # Ρ U+03A1
     "Sigma" => "GREEK CAPITAL LETTER SIGMA",                 # Σ U+03A3
       "Tau" => "GREEK CAPITAL LETTER TAU",                   # Τ U+03A4
   "Upsilon" => "GREEK CAPITAL LETTER UPSILON",               # Υ U+03A5
       "Phi" => "GREEK CAPITAL LETTER PHI",                   # Φ U+03A6
       "Chi" => "GREEK CAPITAL LETTER CHI",                   # Χ U+03A7
       "Psi" => "GREEK CAPITAL LETTER PSI",                   # Ψ U+03A8
     "Omega" => "GREEK CAPITAL LETTER OMEGA",                 # Ω U+03A9
     "alpha" => "GREEK SMALL LETTER ALPHA",                   # α U+03B1
      "beta" => "GREEK SMALL LETTER BETA",                    # β U+03B2
     "gamma" => "GREEK SMALL LETTER GAMMA",                   # γ U+03B3
     "delta" => "GREEK SMALL LETTER DELTA",                   # δ U+03B4
   "epsilon" => "GREEK SMALL LETTER EPSILON",                 # ε U+03B5
      "zeta" => "GREEK SMALL LETTER ZETA",                    # ζ U+03B6
       "eta" => "GREEK SMALL LETTER ETA",                     # η U+03B7
     "theta" => "GREEK SMALL LETTER THETA",                   # θ U+03B8
      "iota" => "GREEK SMALL LETTER IOTA",                    # ι U+03B9
     "kappa" => "GREEK SMALL LETTER KAPPA",                   # κ U+03BA
    "lambda" => "GREEK SMALL LETTER LAMDA",                   # λ U+03BB
        "mu" => "GREEK SMALL LETTER MU",                      # μ U+03BC
        "nu" => "GREEK SMALL LETTER NU",                      # ν U+03BD
        "xi" => "GREEK SMALL LETTER XI",                      # ξ U+03BE
   "omicron" => "GREEK SMALL LETTER OMICRON",                 # ο U+03BF
        "pi" => "GREEK SMALL LETTER PI",                      # π U+03C0
       "rho" => "GREEK SMALL LETTER RHO",                     # ρ U+03C1
    "sigmaf" => "GREEK SMALL LETTER FINAL SIGMA",             # ς U+03C2
     "sigma" => "GREEK SMALL LETTER SIGMA",                   # σ U+03C3
       "tau" => "GREEK SMALL LETTER TAU",                     # τ U+03C4
   "upsilon" => "GREEK SMALL LETTER UPSILON",                 # υ U+03C5
       "phi" => "GREEK SMALL LETTER PHI",                     # φ U+03C6
       "chi" => "GREEK SMALL LETTER CHI",                     # χ U+03C7
       "psi" => "GREEK SMALL LETTER PSI",                     # ψ U+03C8
     "omega" => "GREEK SMALL LETTER OMEGA",                   # ω U+03C9
  "thetasym" => "GREEK THETA SYMBOL",                         # ϑ U+03D1
     "upsih" => "GREEK UPSILON WITH HOOK SYMBOL",             # ϒ U+03D2
       "piv" => "GREEK PI SYMBOL",                            # ϖ U+03D6
      "ensp" => "EN SPACE",                                   #   U+2002
      "emsp" => "EM SPACE",                                   #   U+2003
    "thinsp" => "THIN SPACE",                                 #   U+2009
      "zwnj" => "ZERO WIDTH NON-JOINER",                      # ‌ U+200C
       "zwj" => "ZERO WIDTH JOINER",                          # ‍ U+200D
       "lrm" => "LEFT-TO-RIGHT MARK",                         # ‎ U+200E
       "rlm" => "RIGHT-TO-LEFT MARK",                         # ‏ U+200F
     "ndash" => "EN DASH",                                    # – U+2013
     "mdash" => "EM DASH",                                    # — U+2014
     "lsquo" => "LEFT SINGLE QUOTATION MARK",                 # ‘ U+2018
     "rsquo" => "RIGHT SINGLE QUOTATION MARK",                # ’ U+2019
     "sbquo" => "SINGLE LOW-9 QUOTATION MARK",                # ‚ U+201A
     "ldquo" => "LEFT DOUBLE QUOTATION MARK",                 # “ U+201C
     "rdquo" => "RIGHT DOUBLE QUOTATION MARK",                # ” U+201D
     "bdquo" => "DOUBLE LOW-9 QUOTATION MARK",                # „ U+201E
    "dagger" => "DAGGER",                                     # † U+2020
    "Dagger" => "DOUBLE DAGGER",                              # ‡ U+2021
      "bull" => "BULLET",                                     # • U+2022
    "hellip" => "HORIZONTAL ELLIPSIS",                        # … U+2026
    "permil" => "PER MILLE SIGN",                             # ‰ U+2030
     "prime" => "PRIME",                                      # ′ U+2032
     "Prime" => "DOUBLE PRIME",                               # ″ U+2033
    "lsaquo" => "SINGLE LEFT-POINTING ANGLE QUOTATION MARK",  # ‹ U+2039
    "rsaquo" => "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK", # › U+203A
     "oline" => "OVERLINE",                                   # ‾ U+203E
     "frasl" => "FRACTION SLASH",                             # ⁄ U+2044
      "euro" => "EURO SIGN",                                  # € U+20AC
     "image" => "BLACK-LETTER CAPITAL I",                     # ℑ U+2111
    "weierp" => "SCRIPT CAPITAL P",                           # ℘ U+2118
      "real" => "BLACK-LETTER CAPITAL R",                     # ℜ U+211C
     "trade" => "TRADE MARK SIGN",                            # ™ U+2122
   "alefsym" => "ALEF SYMBOL",                                # ℵ U+2135
      "larr" => "LEFTWARDS ARROW",                            # ← U+2190
      "uarr" => "UPWARDS ARROW",                              # ↑ U+2191
      "rarr" => "RIGHTWARDS ARROW",                           # → U+2192
      "darr" => "DOWNWARDS ARROW",                            # ↓ U+2193
      "harr" => "LEFT RIGHT ARROW",                           # ↔ U+2194
     "crarr" => "DOWNWARDS ARROW WITH CORNER LEFTWARDS",      # ↵ U+21B5
      "lArr" => "LEFTWARDS DOUBLE ARROW",                     # ⇐ U+21D0
      "uArr" => "UPWARDS DOUBLE ARROW",                       # ⇑ U+21D1
      "rArr" => "RIGHTWARDS DOUBLE ARROW",                    # ⇒ U+21D2
      "dArr" => "DOWNWARDS DOUBLE ARROW",                     # ⇓ U+21D3
      "hArr" => "LEFT RIGHT DOUBLE ARROW",                    # ⇔ U+21D4
    "forall" => "FOR ALL",                                    # ∀ U+2200
      "part" => "PARTIAL DIFFERENTIAL",                       # ∂ U+2202
     "exist" => "THERE EXISTS",                               # ∃ U+2203
     "empty" => "EMPTY SET",                                  # ∅ U+2205
     "nabla" => "NABLA",                                      # ∇ U+2207
      "isin" => "ELEMENT OF",                                 # ∈ U+2208
     "notin" => "NOT AN ELEMENT OF",                          # ∉ U+2209
        "ni" => "CONTAINS AS MEMBER",                         # ∋ U+220B
      "prod" => "N-ARY PRODUCT",                              # ∏ U+220F
       "sum" => "N-ARY SUMMATION",                            # ∑ U+2211
     "minus" => "MINUS SIGN",                                 # − U+2212
    "lowast" => "ASTERISK OPERATOR",                          # ∗ U+2217
     "radic" => "SQUARE ROOT",                                # √ U+221A
      "prop" => "PROPORTIONAL TO",                            # ∝ U+221D
     "infin" => "INFINITY",                                   # ∞ U+221E
       "ang" => "ANGLE",                                      # ∠ U+2220
       "and" => "LOGICAL AND",                                # ∧ U+2227
        "or" => "LOGICAL OR",                                 # ∨ U+2228
       "cap" => "INTERSECTION",                               # ∩ U+2229
       "cup" => "UNION",                                      # ∪ U+222A
       "int" => "INTEGRAL",                                   # ∫ U+222B
    "there4" => "THEREFORE",                                  # ∴ U+2234
       "sim" => "TILDE OPERATOR",                             # ∼ U+223C
      "cong" => "APPROXIMATELY EQUAL TO",                     # ≅ U+2245
     "asymp" => "ALMOST EQUAL TO",                            # ≈ U+2248
        "ne" => "NOT EQUAL TO",                               # ≠ U+2260
     "equiv" => "IDENTICAL TO",                               # ≡ U+2261
        "le" => "LESS-THAN OR EQUAL TO",                      # ≤ U+2264
        "ge" => "GREATER-THAN OR EQUAL TO",                   # ≥ U+2265
       "sub" => "SUBSET OF",                                  # ⊂ U+2282
       "sup" => "SUPERSET OF",                                # ⊃ U+2283
      "nsub" => "NOT A SUBSET OF",                            # ⊄ U+2284
      "sube" => "SUBSET OF OR EQUAL TO",                      # ⊆ U+2286
      "supe" => "SUPERSET OF OR EQUAL TO",                    # ⊇ U+2287
     "oplus" => "CIRCLED PLUS",                               # ⊕ U+2295
    "otimes" => "CIRCLED TIMES",                              # ⊗ U+2297
      "perp" => "UP TACK",                                    # ⊥ U+22A5
      "sdot" => "DOT OPERATOR",                               # ⋅ U+22C5
     "lceil" => "LEFT CEILING",                               # ⌈ U+2308
     "rceil" => "RIGHT CEILING",                              # ⌉ U+2309
    "lfloor" => "LEFT FLOOR",                                 # ⌊ U+230A
    "rfloor" => "RIGHT FLOOR",                                # ⌋ U+230B
      "lang" => "LEFT-POINTING ANGLE BRACKET",                # 〈 U+2329
      "rang" => "RIGHT-POINTING ANGLE BRACKET",               # 〉 U+232A
       "loz" => "LOZENGE",                                    # ◊ U+25CA
    "spades" => "BLACK SPADE SUIT",                           # ♠ U+2660
     "clubs" => "BLACK CLUB SUIT",                            # ♣ U+2663
    "hearts" => "BLACK HEART SUIT",                           # ♥ U+2665
     "diams" => "BLACK DIAMOND SUIT",                         # ♦ U+2666
