/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.inserter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import thredds.catalog.InvService;
import thredds.cataloggen.InvCrawlablePair;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class LatestCompleteProxyDsHandler
implements ProxyDatasetHandler {
    private final String latestName;
    private final boolean locateAtTopOrBottom;
    private final InvService service;
    private final boolean isResolver;
    private final long lastModifiedLimit;

    public LatestCompleteProxyDsHandler(String latestName, boolean locateAtTopOrBottom, InvService service, boolean isResolver, long lastModifiedLimit) {
        this.latestName = latestName;
        this.locateAtTopOrBottom = locateAtTopOrBottom;
        this.service = service;
        this.isResolver = isResolver;
        this.lastModifiedLimit = lastModifiedLimit;
    }

    public String getName() {
        return this.latestName;
    }

    public boolean isLocateAtTopOrBottom() {
        return this.locateAtTopOrBottom;
    }

    public String getServiceName() {
        return this.service.getName();
    }

    public long getLastModifiedLimit() {
        return this.lastModifiedLimit;
    }

    public String getProxyDatasetName() {
        return this.latestName;
    }

    public Object getConfigObject() {
        return null;
    }

    public CrawlableDataset createProxyDataset(CrawlableDataset parent) {
        return new MyCrawlableDataset(parent, this.latestName);
    }

    public InvService getProxyDatasetService(CrawlableDataset parent) {
        return this.service;
    }

    public int getProxyDatasetLocation(CrawlableDataset parent, int collectionDatasetSize) {
        if (this.locateAtTopOrBottom) {
            return 0;
        }
        return collectionDatasetSize;
    }

    public boolean isProxyDatasetResolver() {
        return this.isResolver;
    }

    public InvCrawlablePair getActualDataset(List atomicDsInfo) {
        if (atomicDsInfo == null || atomicDsInfo.isEmpty()) {
            return null;
        }
        long targetTime = System.currentTimeMillis() - this.lastModifiedLimit * 60L * 1000L;
        ArrayList tmpList = new ArrayList(atomicDsInfo);
        Iterator it = tmpList.iterator();
        while (it.hasNext()) {
            InvCrawlablePair curDsInfo = (InvCrawlablePair)it.next();
            CrawlableDataset curCrDs = curDsInfo.getCrawlableDataset();
            if (curCrDs.lastModified().getTime() <= targetTime) continue;
            it.remove();
        }
        return (InvCrawlablePair)Collections.max(tmpList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                InvCrawlablePair dsInfo1 = (InvCrawlablePair)obj1;
                InvCrawlablePair dsInfo2 = (InvCrawlablePair)obj2;
                return dsInfo1.getInvDataset().getName().compareTo(dsInfo2.getInvDataset().getName());
            }
        });
    }

    public String getActualDatasetName(InvCrawlablePair actualDataset, String baseName) {
        if (baseName == null) {
            baseName = "";
        }
        return baseName.equals("") ? "Latest" : "Latest " + baseName;
    }

    private static class MyCrawlableDataset
    implements CrawlableDataset {
        private CrawlableDataset parent;
        private String name;

        MyCrawlableDataset(CrawlableDataset parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Object getConfigObject() {
            return null;
        }

        public String getPath() {
            return this.parent.getPath() + "/" + this.name;
        }

        public String getName() {
            return this.name;
        }

        public boolean exists() {
            return true;
        }

        public boolean isCollection() {
            return false;
        }

        public CrawlableDataset getDescendant(String childPath) {
            return null;
        }

        public CrawlableDataset getParentDataset() {
            return this.parent;
        }

        public List listDatasets() {
            return null;
        }

        public List listDatasets(CrawlableDatasetFilter filter) {
            return null;
        }

        public long length() {
            return -1L;
        }

        public Date lastModified() {
            return null;
        }
    }
}

