#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Lingua::YI::Romanize';

use_ok($class);

my $text =<<TEXT;


אלווﬠלטלﬠכﬠ רﬠקלאראציﬠ פֿוו מﬠנטשנרﬠכט

גוטגﬠחייסו אוו פּראקלאמירט ווי רﬠואלוציﬠ 217 ^ )3( פֿון דﬠר אָלגﬠמיינﬠר
פֿאַרואמלונג פֿון די פֿאראייניקטﬠ פֿﬠלקﬠר, 10 דﬠצﬠמבﬠר, 1948.

הקדמה

היות ווי דﬠר סאַמﬠר גרובט פֿון פֿרײהייט, יושר, און שלום אויף דﬠר גאָרﬠר ווﬠלט באַשטייט פֿון אָבﬠרקﬠבﬠן רﬠם
תּוכיקן כּפֿור און רי גלײכﬠ און ביט-איבﬠרטראָגלﬠכﬠ רﬠכט פֿון אַלﬠ מיטגלירﬠר פֿון רﬠר מﬠבטשישﬠר משפחה,

היות ווי איגבאָרירן און ביטול צו רי מﬠבטשברﬠכט האָבן גורם גﬠווﬠן באַרבארישﬠ אַקטן וואס האָבן אָבגﬠוואָרפֿן א
גרויל אויף אָלﬠ מﬠבטשן, און היות ווי רי הﬠכסטﬠ האָפֿבובג פֿון רי אומות הﬠולם איו או רי צײט ואָל אָבקומﬠן ווﬠן
מﬠבטשן ואלן גﬠביסן פֿון פֿרײהייט, אי פֿון רﬠרן אי פֿון גלויבן, און קייבﬠר ואל ביט לײרן פֿון קיין מורא אָרﬠר בויט,

היות ווי גﬠוﬠץ און יושר מוון פֿאָרטייריקן מﬠבטשברﬠכט, טאָמﬠר מﬠן ווﬠט ויד אין בויט נﬠמﬠן רﬠבﬠלירן קﬠגן טיראָביﬠ
און באָרריקובג,

היות ווי רﬠרמוטיקן רי אַבטוויקלובג פֿון פֿרײבטלﬠכﬠ באציובגﬠן צווישן לﬠברﬠר איו אן ﬠיקר,

היות ווי רי פֿﬠלקﬠר פֿון רי פֿאַראייביקטﬠ פֿﬠלקﬠר האָבן אין וייﬠר טשאַרטﬠר אובטﬠרגﬠשטריכט וייﬠר גלויבן אין
גרובטלﬠכﬠ מﬠבטשברﬠכט, אין רﬠם כּפֿור און ווﬠרט פֿון יﬠרן מﬠבטש, און אין רי גלײכﬠ רﬠכט פֿון מﬠבﬠר און פֿרויﬠן,
און היות ווי ויי האָבן באשלאָסן רﬠרמוטיקן גﬠוﬠלשאַפֿטלﬠכﬠ פּראָגרﬠס און בﬠסﬠרﬠ לﬠבבס-שטייגﬠרס,

היות ווי רי פֿﬠלקﬠר מיטגלירﬠר האָבן גﬠטאָז אָ ברר מיטצואַרבﬠטן מיט רי פֿאראייביקטﬠ פֿﬠלקﬠר און ווײטﬠר צו
רﬠרמוטיקן אַלווﬠלטלﬠכﬠ דרך-ארץ און אָפּהיטן מﬠבטשברﬠכט און גרובטלﬠכﬠ פֿרײהייט,

היות ווי אָלﬠ ראַרפֿן פֿאַרשטיין רי-אָ רﬠכט און פֿרײהייטן כּרי רﬠר ברר ואל מקוים ווﬠרן,

אט דﬠרפֿאר
פּראָקלאַמירט רי אָלגﬠמייבﬠ פֿאַרואַמלובג

רי-אָ אלווﬠלטלﬠכﬠ דﬠקלאראציﬠ פֿון מﬠנטשנרﬠכט ווי א מאָס און אַ ציל פֿאַר אַלﬠ אומות און אָלﬠ פֿﬠלקﬠר, כּרי
יﬠרﬠר מﬠבטש און יﬠרﬠר איבסטאָבץ ואָל האָבן אַלﬠמאָל אין ויבﬠן רי-אָ רﬠקלאראַציﬠ, און ווﬠט ויד מיﬠן, דורך לﬠרבﬠן
און רﬠרציﬠן, צו רﬠרמוטיקן ראָס אָבﬠרקﬠבﬠן פֿון רי רﬠכט און רי פֿרײהייטן, און או ויי ואלן אָבבﬠמﬠן מיטלﬠן, סײ
באציאָבאַלﬠ סײ איבטﬠרבאַציאָבאלﬠ, צו פֿארויכﬠרן ראָס אַלווﬠלטלﬠכﬠ אָבﬠרקﬠבﬠן און אָפּהיטן, סײ צווישן רי פֿﬠלקﬠר
פֿון מיטגליר-לﬠברﬠר, סײ צווישן רי מﬠבטשן וואס אובטﬠר וייﬠר השפּﬠה.

ארטיקל 1

יﬠרﬠר מﬠבטש ווﬠרט גﬠבוירן פֿרײ און גלײך אין כּפֿור און רﬠכט. יﬠרﬠר ווﬠרט באַשאָבקן מיט פֿאַרשטאַבר און גﬠוויסן;
יﬠרﬠר ואל ויד פֿירן מיט אַ צווייטן אין אַ גﬠמיט פֿון ברורﬠרשאַפֿט.



TEXT

ok(Lingua::YI::Romanize->yivo2latn($text),'IPA');

done_testing;
