/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.http.BucketsStreamingHandler;
import org.couchbase.mock.http.StateGrabber;
import org.couchbase.mock.memcached.MemcachedServer;

public class PoolsHandler
implements HttpHandler {
    private final CouchbaseMock mock;

    public PoolsHandler(CouchbaseMock mock) {
        this.mock = mock;
    }

    private List<Bucket> getAllowedBuckets(HttpExchange exchange) {
        LinkedList<Bucket> bucketList = new LinkedList<Bucket>();
        String httpUser = exchange.getPrincipal().getUsername();
        String adminUser = this.mock.getAuthenticator().getAdminName();
        for (Bucket bucket : this.mock.getBuckets().values()) {
            if ((!httpUser.isEmpty() || !bucket.getPassword().isEmpty()) && !adminUser.equals(httpUser) && !bucket.getName().equals(httpUser)) continue;
            bucketList.add(bucket);
        }
        return bucketList;
    }

    private byte[] extractPayload(HttpExchange exchange, String path) throws ResourceNotFoundException, IOException {
        byte[] payload = null;
        if (path.matches("^/pools/?$")) {
            payload = StateGrabber.getAllPoolsJSON(this.mock).getBytes();
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "$/?")) {
            payload = StateGrabber.getPoolInfoJSON(this.mock).getBytes();
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "/buckets/?$")) {
            payload = StateGrabber.getAllBucketsJSON(this.getAllowedBuckets(exchange)).getBytes();
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "/buckets/[^/]+/?$")) {
            String[] tokens = path.split("/");
            Bucket bucket = this.mock.getBuckets().get(tokens[tokens.length - 1]);
            payload = StateGrabber.getBucketJSON(bucket).getBytes();
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "/bucketsStreaming/[^/]+/?$")) {
            String[] tokens = path.split("/");
            Bucket bucket = this.mock.getBuckets().get(tokens[tokens.length - 1]);
            if (bucket == null) {
                throw new ResourceNotFoundException();
            }
            exchange.getResponseHeaders().set("Transfer-Encoding", "chunked");
            exchange.sendResponseHeaders(200, 0L);
            BucketsStreamingHandler streamingHandler = new BucketsStreamingHandler(this.mock.getMonitor(), bucket, exchange.getResponseBody());
            try {
                streamingHandler.startStreaming();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PoolsHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            if (path.matches("^/pools/" + this.mock.getPoolName() + "/buckets/[\\w]+/controller/doFlush$")) {
                String[] tokens = path.split("/");
                Bucket bucket = this.mock.getBuckets().get(tokens[4]);
                if (bucket == null) {
                    throw new ResourceNotFoundException();
                }
                for (MemcachedServer server : bucket.getServers()) {
                    server.flushAll();
                }
                return new byte[0];
            }
            throw new ResourceNotFoundException();
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String path = exchange.getRequestURI().getPath();
        OutputStream body = exchange.getResponseBody();
        Headers responseHeaders = exchange.getResponseHeaders();
        responseHeaders.set("Server", "CouchbaseMock/1.0");
        try {
            byte[] payload = this.extractPayload(exchange, path);
            if (payload != null) {
                responseHeaders.set("Content-Type", "application/json");
                exchange.sendResponseHeaders(200, payload.length);
                body.write(payload);
            } else {
                exchange.sendResponseHeaders(500, -1L);
            }
        }
        catch (ResourceNotFoundException ex) {
            exchange.sendResponseHeaders(404, -1L);
        }
        finally {
            body.close();
        }
    }

    private class ResourceNotFoundException
    extends Throwable {
        private ResourceNotFoundException() {
        }
    }
}

