use 5.032001;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'DVD::Read::DVDCSS',
    VERSION_FROM      => 'lib/DVD/Read/DVDCSS.pm', # finds $VERSION, requires EU::MM from perl >= 5.5
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ABSTRACT_FROM     => 'lib/DVD/Read/DVDCSS.pm', # retrieve abstract from module
    AUTHOR            => 'Gergely Szasz <szaszg@hu.inter.net>',
    #LICENSE           => 'perl',
    #Value must be from legacy list of licenses here
    #https://metacpan.org/pod/Module::Build::API
    LIBS              => ['-ldvdcss'], # e.g., '-lm'
    DEFINE            => '-DLIBDVDCSS_EXPORT=extern', # e.g., '-DHAVE_SOMETHING'
    INC               => '-I.', # e.g., '-I. -I/usr/include/other'
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
);
    
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(DVDCSS_BLOCK_SIZE DVDCSS_NOFLAGS
		 DVDCSS_READ_DECRYPT DVDCSS_SEEK_KEY DVDCSS_SEEK_MPEG));
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'DVD::Read::DVDCSS',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
