#!perl -T

use warnings;
use strict;

use Test::More tests => 6;
use Test::Exception;

use Test::MockFile::Light module => 'main';

my $file_name = 'data.txt';
my $content = "1\n";
my $fh;

{
	open $fh, '>', $file_name;

	print $fh 'q';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, 'q', 'checking that > creates file');

	close $fh;

	undefine_file_mocker($file_name);
}

{
	define_file_mocker($file_name, $content);

	open $fh, '>', $file_name;

	print $fh 'q';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, 'q', 'checking that > overwrites existing file');

	close $fh;

	undefine_file_mocker($file_name);
}

{
	open $fh, '>', $file_name;

	print $fh 'q';
	print $fh 'w';
	print $fh 'e';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, "qwe", 'checking the use of $\ (1/2)');

	close $fh;

	undefine_file_mocker($file_name);
}

{
	local $\ = "\n";

	open $fh, '>', $file_name;

	print $fh 'q';
	print $fh 'w';
	print $fh 'e';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, "q\nw\ne\n", 'checking the use of $\ (2/2)');

	close $fh;

	undefine_file_mocker($file_name);
}

{
	local $\ = "\n";

	open $fh, '>', $file_name;

	print $fh 'q', 'w', 'e';
	print $fh 'r', 't', 'u';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, "qwe\nrtu\n", 'checking the use of $, (1/2)');

	close $fh;

	undefine_file_mocker($file_name);
}

{
	local $\ = "\n";
	local $, = ", ";

	open $fh, '>', $file_name;

	print $fh 'q', 'w', 'e';
	print $fh 'r', 't', 'u';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, "q, w, e\nr, t, u\n", 'checking the use of $, (2/2)');

	close $fh;

	undefine_file_mocker($file_name);
}
