case $CONFIG in
'')	 if test -r ../config.sh
	 then 
	    . ../config.sh ;
	 else 
	    spitshell=cat
	    package=IRC
	 fi
	 ;;
esac

echo "Extracting $package/ircd/version.c..."

if test -r version.c
then
   generation=`sed -n 's/^char \*generation = \"\(.*\)\";/\1/p' < version.c`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

creation=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/*
 *   IRC - Internet Relay Chat, ircd/version.c
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "struct.h"
#include "patchlevel.h"

char *generation = "$generation";
char *creation = "$creation";
char *version = BASE_VERSION PATCH1 PATCH2 PATCH3 PATCH4\
		PATCH5 PATCH6 PATCH7 PATCH8 PATCH9;

char *infotext[] =
    {
	"$package --",
	"Based on the original code written by Jarkko Oikarinen",
	"Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
	"",
	"This program is free software; you can redistribute it and/or",
	"modify it under the terms of the GNU General Public License as",
	"published by the Free Software Foundation; either version 1, or",
	"(at your option) any later version.",
	"",
	"The following people have helped in making the SorceryNet ircd",
	"that is based on dal4.4.10-11 :",
	"",
	"Mysidia      J. Hess                  mysidia-sorircd@flame.org",
	"some2        Greg Poma                -",
	"LvShadow     -                        -",
	"TazQ         -                        -",
	"Onno         -                        -",
	"Halcy0n      -                        -",
	"Milambar     -                        -",
	"",
	"The following people have helped in making the DALnet ircd",
	"that is based on irc2.8.21.mu3.2 :",
	"",
	"Russell      Russell Miller           russell@dal.net",
	"Donwulff     Jukka Santala            donwulff@dal.net",
	"Aetobatus    Michael Sawyer           aetobatus@dal.net",
	"Dalvenjah    Sven Nielsen             dalvenjah@dal.net",
	"Skandranon   Michael Graff            explorer@flame.org",
	"Barubary     -                        barubary@dal.net",
	"",
	"This product includes software developed by Colin Plumb.",
 	"This product includes software developed by Eric Young (eay@mincom.oz.au)",
	"",
	"The following persons have made many changes and enhancements to the",
	"code and still know how IRC really works if you have questions about it:",
	"",
	"Run          Carlo Kid                carlo@runaway.xs4all.nl",
	"Avalon       Darren Reed              avalon@coombs.anu.edu.au",
	"msa          Markku Savela            Markku.Savela@vtt.fi",
	"Wumpus       Greg Lindahl             gl8f@virginia.edu",
	"WiZ          Jarkko Oikarinen         jto@tolsun.oulu.fi",
	"Argv         Armin Gruner             Armin.Gruner@Informatik.TU-Muenchen.de",
	"",
	"Thanks to the following people for help with preparing 2.8",
	"",
	"phone        Matthew Green            phone@coombs.anu.edu.au",
	"Sodapop      Chuck Kane               ckane@ece.uiuc.edu",
	"Skygod       Matt Lyle                matt@oc.com",
	"Vesa         Vesa Ruokonen            ruokonen@lut.fi",
	"Nap          Nicolas PIOCH            pioch@poly.polytechnique.fr",
	"",
	"Those who helped in prior versions and continue to be helpful:",
	"",
 	"Stellan Klebom      Dan Goodwin         Mike Bolotski",
	"Ian Frechette       Markku Jarvinen     Kimmo Suominen",
	"Jeff Trim           Vijay Subramaniam   Karl Kleinpaste",
	"Bill Wisner         Tom Davis           Hugo Calendar",
	"Tom Hopkins         Stephen van den Berg",
	"Bo Adler            Michael Sandrof     Jon Solomon",
	"Jan Peterson        Helen Rose          Paul Graham",
	"",
	"Thanks also goes to those persons not mentioned here who have added",
	"their advice, opinions, and code to IRC.",
	"Thanks also to those who provide the kind sys admins who let me and",
	"others continue to develop IRC.",
	"",
	BASE_VERSION PATCH1 PATCH2 PATCH3 PATCH4 PATCH5 PATCH6 PATCH7
		PATCH8 PATCH9,
	0,
    };
!SUB!THIS!
