.\" $Id: dhcp-fwd.man,v 1.1 2002/06/14 17:36:09 ensc Exp $
.\" Copyright (C) 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
.\"  
.\" Permission is granted to make and distribute verbatim copies of
.\" this manual provided the copyright notice and this permission notice
.\" are preserved on all copies.
.\"  
.\" Permission is granted to process this file through TeX and print the
.\" results, provided the printed document carries copying permission
.\" notice identical to this one except for the removal of this paragraph
.\" (this paragraph not being relevant to the printed manual).
.\"  
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a 
.\" permission notice identical to this one.
.\"  
.\" Permission is granted to copy and distribute translations of this manual
.\" into another language, under the above conditions for modified versions,
.\" except that this permission notice may be stated in a translation
.\" approved by the Free Software Foundation
.\"  
.TH dhcp-fwd 1 "June 14 2002" "@PACKAGE@ 0.2"
.\"
.\" ====================
.\"
.SH NAME
.PP
dhcp-fwd \- starts the DHCP forwarding agent
.\"
.\" ====================
.\"
.SH SYNOPSIS
.B  dhcp-fwd
.RB [ \-d ]
.RB [ \-v ]
.RB [ \-h ]
.RB [ \-c
.IR config_file ]
.\"
.\" ====================
.\"
.SH DESCRIPTION
.B dhcp-fwd
starts a DHCP forwarding agents which relays DHCP messages between
subnets with different sublayer broadcast domains.

When called without arguments, it reads its configuration from
.BR @sysconfdir@/dhcp-fwd.cfg
and forks itself into background. An alternative configfile
can be given by the
.BR \-c
option; the forking can be prevented with
.BR \-d .

Although the program must be started as root, it will drop its
privileges and go into a chroot-jail after finishing the
initialization.
.\"
.\" ====================
.\"
.SH OPTIONS
.TP
.B \-d
Debug-mode; prevents daemon from going into background after
initialization
.TP
.B \-c \fI config_file
Specifies the configfile to use; the default is
.BR @sysconfdir@/dhcp-fwd.cfg .
.TP
.B \-v
Shows version
.TP
.B \-h
Shows help
.\"
.\" ====================
.\"
.SH "CONFIGURATION FILE"
The default location of the configfile is determined at
compilation-time and can be overridden by using the
.BR \-c
option. When an option needs a boolean parameter, the keywords true,
false, 0, 1, yes and no are possible values.

Within the configfile the following options MUST be set:
.\"
.TP
.B user \fIusername|uid
The program
.B setuid()\fR's
to the given user after finishing its initialization. The parameter
must be an alphanumeric username or a numeric uid.
.\"
.TP
.B group \fIgroupname|gid
The program
.B setgid()\fR's
to the given group after finishing its initialization. The parameter
must be an alphanumeric groupname or a numeric gid.
.\"
.TP
.B chroot \fIpath
The program goes into this directory and calls
.B chroot()
there after finishing its initialization.
.TP
.B pidfile \fIfilename
The file where the pid of the daemon will be written into.
.\"
.\" ----
.\"
.PP
Beside the mandatory options above, the following options are
possible:
.TP
.B if \fIifname has_clients has_servers allow_bcast
Declares an interface and sets parameter of the network topology. When
an interfacename is used in one of the other options, it must have
been declared by
.B if
already.

.I ifname
is the name of the interface as being used e.g. by
.B ifconfig
also (e.g. eth0).

.I has_clients \fRand \fIhas_servers
tell if messages from clients or servers can be expected on this interface.
.B BOOTREQUEST\fRs are assumed to be client- and
.B BOOTREPLY\fRs are assumed to be server-messages. Unexpected packages will
be dropped away.

.I allow_bcast
is/was an experimentell features and will be disappear probably. When not
set, the interface will not send packages to IP-broadcast addresses. This
affects messages to clients only; when specifying a bcast-server, this
option will be ignored.
.\"
.TP
.B name \fIifname agent-id
specifies the RFC 3046 agent-id for the given interface. When not used
explicitly, the interfacename will be assumed as the agent-id.
.\"
.TP
.B server \fItype address
Defines the DHCP server to be used. A server may be either an unicast
IP-address or a broadcast address. In the first case, use
.B ip
as the
.I type
parameter and a dotted IP-address as
.I address\fR;
in the second one use
.B bcast
and the interface name as parameters.
.PP
For an example see the contrib/dhcp-fwd.conf file in the
source-tarball.
.\"
.\" ====================
.\"
.SH FILES
.TP
.B @sysconfdir@/dhcp-fwd.conf
configuration file
.TP
.B @sbindir@/dhcp-fwd
executable
.\"
.\" ====================
.\"
.SH "SEE ALSO"
RFC 2131, 2132, 3046
.\"
.\" ====================
.\"
.SH AUTHOR
Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
