/* table-lookup.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from table-lookup.vala, do not modify */

/* table-lookup.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "zeitgeist-datamodel.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_SQ_LITE_TABLE_LOOKUP_0_PROPERTY,
	ZEITGEIST_SQ_LITE_TABLE_LOOKUP_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_sq_lite_table_lookup_properties[ZEITGEIST_SQ_LITE_TABLE_LOOKUP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ZeitgeistSQLiteTableLookupPrivate {
	ZeitgeistSQLiteDatabase* database;
	sqlite3* db;
	gchar* table;
	GHashTable* id_to_value;
	GHashTable* value_to_id;
	sqlite3_stmt* insertion_stmt;
	sqlite3_stmt* retrieval_stmt;
};

static gint ZeitgeistSQLiteTableLookup_private_offset;
static gpointer zeitgeist_sq_lite_table_lookup_parent_class = NULL;

static void _g_free0_ (gpointer var);
static gint __lambda7_ (ZeitgeistSQLiteTableLookup* self,
                 gint n_columns,
                 gchar** values,
                 gchar** column_names);
static gint ___lambda7__sqlite3_callback (gpointer self,
                                   gint n_columns,
                                   gchar** values,
                                   gchar** column_names);
static void zeitgeist_sq_lite_table_lookup_finalize (GObject * obj);
static GType zeitgeist_sq_lite_table_lookup_get_type_once (void);

static inline gpointer
zeitgeist_sq_lite_table_lookup_get_instance_private (ZeitgeistSQLiteTableLookup* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistSQLiteTableLookup_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static gint
__lambda7_ (ZeitgeistSQLiteTableLookup* self,
            gint n_columns,
            gchar** values,
            gchar** column_names)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint result;
	_tmp0_ = self->priv->id_to_value;
	_tmp1_ = values[0];
	_tmp2_ = values[1];
	_tmp3_ = g_strdup (_tmp2_);
	g_hash_table_insert (_tmp0_, (gpointer) ((gintptr) atoi (_tmp1_)), _tmp3_);
	_tmp4_ = self->priv->value_to_id;
	_tmp5_ = values[1];
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = values[0];
	g_hash_table_insert (_tmp4_, _tmp6_, (gpointer) ((gintptr) atoi (_tmp7_)));
	result = 0;
	return result;
}

static gint
___lambda7__sqlite3_callback (gpointer self,
                              gint n_columns,
                              gchar** values,
                              gchar** column_names)
{
	gint result;
	result = __lambda7_ ((ZeitgeistSQLiteTableLookup*) self, n_columns, values, column_names);
	return result;
}

ZeitgeistSQLiteTableLookup*
zeitgeist_sq_lite_table_lookup_construct (GType object_type,
                                          ZeitgeistSQLiteDatabase* database,
                                          const gchar* table_name,
                                          GError** error)
{
	ZeitgeistSQLiteTableLookup * self = NULL;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	gint rc = 0;
	gchar* sql = NULL;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	sqlite3* _tmp19_;
	const gchar* _tmp20_;
	sqlite3_stmt* _tmp21_ = NULL;
	gint _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	sqlite3* _tmp27_;
	const gchar* _tmp28_;
	sqlite3_stmt* _tmp29_ = NULL;
	gint _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	self = (ZeitgeistSQLiteTableLookup*) g_object_new (object_type, NULL);
	self->priv->database = database;
	_tmp0_ = database->database;
	self->priv->db = _tmp0_;
	_tmp1_ = g_strdup (table_name);
	_g_free0 (self->priv->table);
	self->priv->table = _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->id_to_value);
	self->priv->id_to_value = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->value_to_id);
	self->priv->value_to_id = _tmp7_;
	_tmp8_ = self->priv->db;
	_tmp9_ = self->priv->table;
	_tmp10_ = g_strconcat ("SELECT id, value FROM ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	rc = _sqlite3_exec (_tmp8_, _tmp11_, ___lambda7__sqlite3_callback, self, NULL);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->table;
	_tmp13_ = g_strdup_printf ("Can't init %s table", _tmp12_);
	_tmp14_ = _tmp13_;
	zeitgeist_sq_lite_database_assert_query_success (database, rc, _tmp14_, SQLITE_OK, &_inner_error0_);
	_g_free0 (_tmp14_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = self->priv->table;
	_tmp16_ = g_strconcat ("INSERT INTO ", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, " (value) VALUES (?)", NULL);
	_g_free0 (sql);
	sql = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = self->priv->db;
	_tmp20_ = sql;
	_tmp22_ = sqlite3_prepare_v2 (_tmp19_, _tmp20_, -1, &_tmp21_, NULL);
	_sqlite3_finalize0 (self->priv->insertion_stmt);
	self->priv->insertion_stmt = _tmp21_;
	rc = _tmp22_;
	zeitgeist_sq_lite_database_assert_query_success (database, rc, "table-lookup.vala:62: Error creating insertion_stmt", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp23_ = self->priv->table;
	_tmp24_ = g_strconcat ("SELECT value FROM ", _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, " WHERE id=?", NULL);
	_g_free0 (sql);
	sql = _tmp26_;
	_g_free0 (_tmp25_);
	_tmp27_ = self->priv->db;
	_tmp28_ = sql;
	_tmp30_ = sqlite3_prepare_v2 (_tmp27_, _tmp28_, -1, &_tmp29_, NULL);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	self->priv->retrieval_stmt = _tmp29_;
	rc = _tmp30_;
	zeitgeist_sq_lite_database_assert_query_success (database, rc, "table-lookup.vala:66: Error creating retrieval_stmt", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_free0 (sql);
	return self;
}

ZeitgeistSQLiteTableLookup*
zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database,
                                    const gchar* table_name,
                                    GError** error)
{
	return zeitgeist_sq_lite_table_lookup_construct (ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, database, table_name, error);
}

/**
         * Searches the table for the given ID, returns -1 if not found.
         *
         * @see id_for_string
         */
gint
zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self,
                                              const gchar* name)
{
	gint id = 0;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->value_to_id;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	id = (gint) ((gintptr) _tmp1_);
	if (id == 0) {
		result = -1;
		return result;
	}
	result = id;
	return result;
}

/**
         * Searches the table for the given ID, inserts a new one if not found.
         *
         * @see id_try_string
         *
         */
gint
zeitgeist_sq_lite_table_lookup_id_for_string (ZeitgeistSQLiteTableLookup* self,
                                              const gchar* name,
                                              GError** error)
{
	gint id = 0;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->value_to_id;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	id = (gint) ((gintptr) _tmp1_);
	if (id == 0) {
		gint rc = 0;
		sqlite3_stmt* _tmp2_;
		sqlite3_stmt* _tmp3_;
		gchar* _tmp4_;
		GDestroyNotify _tmp5_;
		sqlite3_stmt* _tmp6_;
		ZeitgeistSQLiteDatabase* _tmp7_;
		sqlite3* _tmp10_;
		GHashTable* _tmp11_;
		gchar* _tmp12_;
		GHashTable* _tmp13_;
		gchar* _tmp14_;
		_tmp2_ = self->priv->insertion_stmt;
		sqlite3_reset (_tmp2_);
		_tmp3_ = self->priv->insertion_stmt;
		_tmp4_ = g_strdup (name);
		_tmp5_ = g_free;
		sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
		_tmp6_ = self->priv->insertion_stmt;
		rc = sqlite3_step (_tmp6_);
		_tmp7_ = self->priv->database;
		zeitgeist_sq_lite_database_assert_query_success (_tmp7_, rc, "Error in id_for_string", SQLITE_DONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				gint _tmp8_ = -1;
				g_propagate_error (error, _inner_error0_);
				return _tmp8_;
			} else {
				gint _tmp9_ = -1;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp9_;
			}
		}
		_tmp10_ = self->priv->db;
		id = (gint) sqlite3_last_insert_rowid (_tmp10_);
		_tmp11_ = self->priv->id_to_value;
		_tmp12_ = g_strdup (name);
		g_hash_table_insert (_tmp11_, (gpointer) ((gintptr) id), _tmp12_);
		_tmp13_ = self->priv->value_to_id;
		_tmp14_ = g_strdup (name);
		g_hash_table_insert (_tmp13_, _tmp14_, (gpointer) ((gintptr) id));
	}
	result = id;
	return result;
}

const gchar*
zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self,
                                          gint id,
                                          GError** error)
{
	const gchar* val = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	gint rc = 0;
	gchar* text = NULL;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	ZeitgeistSQLiteDatabase* _tmp17_;
	const gchar* _tmp18_;
	GHashTable* _tmp21_;
	gconstpointer _tmp22_;
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (id == 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->id_to_value;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) id));
	val = (const gchar*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = val;
		result = _tmp3_;
		return result;
	}
	text = NULL;
	_tmp4_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp4_);
	_tmp5_ = self->priv->retrieval_stmt;
	sqlite3_bind_int64 (_tmp5_, 1, (gint64) id);
	_tmp6_ = self->priv->retrieval_stmt;
	rc = sqlite3_step (_tmp6_);
	if (rc == SQLITE_ROW) {
		sqlite3_stmt* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GHashTable* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		sqlite3_stmt* _tmp16_;
		_tmp7_ = self->priv->retrieval_stmt;
		_tmp8_ = (const gchar*) sqlite3_column_text (_tmp7_, 0);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (text);
		text = _tmp9_;
		_tmp10_ = self->priv->id_to_value;
		_tmp11_ = text;
		_tmp12_ = g_strdup (_tmp11_);
		g_hash_table_insert (_tmp10_, (gpointer) ((gintptr) id), _tmp12_);
		_tmp13_ = self->priv->value_to_id;
		_tmp14_ = text;
		_tmp15_ = g_strdup (_tmp14_);
		g_hash_table_insert (_tmp13_, _tmp15_, (gpointer) ((gintptr) id));
		_tmp16_ = self->priv->retrieval_stmt;
		rc = sqlite3_step (_tmp16_);
	}
	_tmp17_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp17_, rc, "Error in get_value", SQLITE_DONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (text);
			return NULL;
		} else {
			_g_free0 (text);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp18_ = text;
	if (_tmp18_ == NULL) {
		sqlite3* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = self->priv->db;
		_tmp20_ = sqlite3_errmsg (_tmp19_);
		g_critical ("table-lookup.vala:137: Error getting data from table: %d, %s\n", rc, _tmp20_);
	}
	_tmp21_ = self->priv->id_to_value;
	_tmp22_ = g_hash_table_lookup (_tmp21_, (gpointer) ((gintptr) id));
	result = (const gchar*) _tmp22_;
	_g_free0 (text);
	return result;
}

void
zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self,
                                       gint id)
{
	gchar* name = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->id_to_value;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) id));
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->id_to_value;
	g_hash_table_remove (_tmp3_, (gpointer) ((gintptr) id));
	_tmp4_ = self->priv->value_to_id;
	g_hash_table_remove (_tmp4_, name);
	_g_free0 (name);
}

static void
zeitgeist_sq_lite_table_lookup_class_init (ZeitgeistSQLiteTableLookupClass * klass,
                                           gpointer klass_data)
{
	zeitgeist_sq_lite_table_lookup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistSQLiteTableLookup_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_sq_lite_table_lookup_finalize;
}

static void
zeitgeist_sq_lite_table_lookup_instance_init (ZeitgeistSQLiteTableLookup * self,
                                              gpointer klass)
{
	self->priv = zeitgeist_sq_lite_table_lookup_get_instance_private (self);
}

static void
zeitgeist_sq_lite_table_lookup_finalize (GObject * obj)
{
	ZeitgeistSQLiteTableLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup);
	_g_free0 (self->priv->table);
	_g_hash_table_unref0 (self->priv->id_to_value);
	_g_hash_table_unref0 (self->priv->value_to_id);
	_sqlite3_finalize0 (self->priv->insertion_stmt);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	G_OBJECT_CLASS (zeitgeist_sq_lite_table_lookup_parent_class)->finalize (obj);
}

static GType
zeitgeist_sq_lite_table_lookup_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteTableLookupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_table_lookup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteTableLookup), 0, (GInstanceInitFunc) zeitgeist_sq_lite_table_lookup_instance_init, NULL };
	GType zeitgeist_sq_lite_table_lookup_type_id;
	zeitgeist_sq_lite_table_lookup_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteTableLookup", &g_define_type_info, 0);
	ZeitgeistSQLiteTableLookup_private_offset = g_type_add_instance_private (zeitgeist_sq_lite_table_lookup_type_id, sizeof (ZeitgeistSQLiteTableLookupPrivate));
	return zeitgeist_sq_lite_table_lookup_type_id;
}

GType
zeitgeist_sq_lite_table_lookup_get_type (void)
{
	static volatile gsize zeitgeist_sq_lite_table_lookup_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_table_lookup_type_id__once)) {
		GType zeitgeist_sq_lite_table_lookup_type_id;
		zeitgeist_sq_lite_table_lookup_type_id = zeitgeist_sq_lite_table_lookup_get_type_once ();
		g_once_init_leave (&zeitgeist_sq_lite_table_lookup_type_id__once, zeitgeist_sq_lite_table_lookup_type_id);
	}
	return zeitgeist_sq_lite_table_lookup_type_id__once;
}

