/* UserManager.c generated by valac 0.56.17, the Vala compiler
 * generated from UserManager.vala, do not modify */

/*
 * Copyright (c) 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#include "session.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <act/act.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

#define SESSION_SERVICES_USER_MANAGER_GUEST_USER_UID ((guint) 999)
#define SESSION_SERVICES_USER_MANAGER_NOBODY_USER_UID ((guint) 65534)
#define SESSION_SERVICES_USER_MANAGER_RESERVED_UID_RANGE_END ((guint) 1000)
#define SESSION_SERVICES_USER_MANAGER_DM_DBUS_ID "org.freedesktop.DisplayManager"
#define SESSION_SERVICES_USER_MANAGER_LOGIN_IFACE "org.freedesktop.login1"
#define SESSION_SERVICES_USER_MANAGER_LOGIN_PATH "/org/freedesktop/login1"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_SEAT_INTERFACE (seat_interface_get_type ())
#define SEAT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEAT_INTERFACE, SeatInterface))
#define IS_SEAT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEAT_INTERFACE))
#define SEAT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SEAT_INTERFACE, SeatInterfaceIface))

typedef struct _SeatInterface SeatInterface;
typedef struct _SeatInterfaceIface SeatInterfaceIface;

#define TYPE_SEAT_INTERFACE_PROXY (seat_interface_proxy_get_type ())
enum  {
	SESSION_SERVICES_USER_MANAGER_0_PROPERTY,
	SESSION_SERVICES_USER_MANAGER_USER_GRID_PROPERTY,
	SESSION_SERVICES_USER_MANAGER_NUM_PROPERTIES
};
static GParamSpec* session_services_user_manager_properties[SESSION_SERVICES_USER_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SYSTEM_INTERFACE (system_interface_get_type ())
#define SYSTEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_INTERFACE, SystemInterface))
#define IS_SYSTEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_INTERFACE))
#define SYSTEM_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SYSTEM_INTERFACE, SystemInterfaceIface))

typedef struct _SystemInterface SystemInterface;
typedef struct _SystemInterfaceIface SystemInterfaceIface;

#define TYPE_SYSTEM_INTERFACE_PROXY (system_interface_proxy_get_type ())

#define TYPE_USER_INFO (user_info_get_type ())
typedef struct _UserInfo UserInfo;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SessionServicesUserManagerInitLoginProxyData SessionServicesUserManagerInitLoginProxyData;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_USER_INTERFACE, UserInterfaceIface))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceIface UserInterfaceIface;

#define TYPE_USER_INTERFACE_PROXY (user_interface_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SessionServicesUserManagerGetUserStateData SessionServicesUserManagerGetUserStateData;
typedef struct _SessionServicesUserManagerGetGuestStateData SessionServicesUserManagerGetGuestStateData;
typedef struct _SessionServicesUserManagerGetNActiveAndOnlineUsersData SessionServicesUserManagerGetNActiveAndOnlineUsersData;
typedef struct _Block4Data Block4Data;
enum  {
	SESSION_SERVICES_USER_MANAGER_CLOSE_SIGNAL,
	SESSION_SERVICES_USER_MANAGER_CHANGED_SIGNAL,
	SESSION_SERVICES_USER_MANAGER_NUM_SIGNALS
};
static guint session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_NUM_SIGNALS] = {0};

struct _SeatInterfaceIface {
	GTypeInterface parent_iface;
	void (*switch_to_guest) (SeatInterface* self, const gchar* session_name, GError** error);
	void (*switch_to_user) (SeatInterface* self, const gchar* username, const gchar* session_name, GError** error);
	gboolean (*get_has_guest_account) (SeatInterface* self);
};

struct _SessionServicesUserManagerPrivate {
	SessionWidgetsUserListBox* _user_grid;
	ActUserManager* manager;
	GeeHashMap* user_boxes;
	SeatInterface* dm_proxy;
};

struct _UserInfo {
	guint32 uid;
	gchar* user_name;
	char* user_object;
};

struct _SystemInterfaceIface {
	GTypeInterface parent_iface;
	void (*suspend) (SystemInterface* self, gboolean interactive, GError** error);
	void (*reboot) (SystemInterface* self, gboolean interactive, GError** error);
	void (*power_off) (SystemInterface* self, gboolean interactive, GError** error);
	UserInfo* (*list_users) (SystemInterface* self, gint* result_length1, GError** error);
};

struct _SessionServicesUserManagerInitLoginProxyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SystemInterface* _tmp0_;
	SystemInterface* _tmp1_;
	SystemInterface* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _UserInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_state) (UserInterface* self);
};

struct _SessionServicesUserManagerGetUserStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	guint32 uuid;
	UserState result;
	SystemInterface* _tmp0_;
	UserInfo* users;
	SystemInterface* _tmp1_;
	gint _tmp2_;
	UserInfo* _tmp3_;
	gint users_length1;
	gint _users_size_;
	UserInfo* _tmp4_;
	gint _tmp4__length1;
	UserInfo* _tmp5_;
	gint _tmp5__length1;
	UserInfo* user_collection;
	gint user_collection_length1;
	gint _user_collection_size_;
	gint user_it;
	UserInfo _tmp6_;
	UserInfo _tmp7_;
	UserInfo user;
	UserInfo _tmp8_;
	UserInfo _tmp9_;
	const char* _tmp10_;
	UserInterface* user_interface;
	UserInfo _tmp11_;
	const char* _tmp12_;
	UserInterface* _tmp13_;
	UserInterface* _tmp14_;
	UserInterface* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	UserState _tmp19_;
	GError* e;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_;
};

struct _SessionServicesUserManagerGetGuestStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UserState result;
	SystemInterface* _tmp0_;
	UserInfo* users;
	SystemInterface* _tmp1_;
	gint _tmp2_;
	UserInfo* _tmp3_;
	gint users_length1;
	gint _users_size_;
	UserInfo* _tmp4_;
	gint _tmp4__length1;
	UserInfo* user_collection;
	gint user_collection_length1;
	gint _user_collection_size_;
	gint user_it;
	UserInfo _tmp5_;
	UserInfo _tmp6_;
	UserInfo user;
	UserState state;
	UserInfo _tmp7_;
	gboolean _tmp8_;
	UserInfo _tmp9_;
	const gchar* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _SessionServicesUserManagerGetNActiveAndOnlineUsersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SessionServicesUserManager* self;
	gint result;
	gint n_active_and_online_users;
	ActUserManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ActUserManager* _tmp3_;
	GSList* _tmp4_;
	GSList* user_collection;
	GSList* user_it;
	ActUser* user;
	gboolean _tmp5_;
	ActUser* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ActUser* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	UserState state;
	ActUser* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
};

struct _Block4Data {
	int _ref_count_;
	SessionServicesUserManager* self;
	gchar* session_path;
};

static gint SessionServicesUserManager_private_offset;
static gpointer session_services_user_manager_parent_class = NULL;
static SystemInterface* session_services_user_manager_login_proxy;
static SystemInterface* session_services_user_manager_login_proxy = NULL;

VALA_EXTERN GType seat_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint seat_interface_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN GType seat_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType system_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint system_interface_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType user_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UserInfo* user_info_dup (const UserInfo* self);
VALA_EXTERN void user_info_free (UserInfo* self);
VALA_EXTERN void user_info_copy (const UserInfo* self,
                     UserInfo* dest);
VALA_EXTERN void user_info_destroy (UserInfo* self);
VALA_EXTERN GType system_interface_get_type (void) G_GNUC_CONST ;
static void session_services_user_manager_init_login_proxy_data_free (gpointer _data);
static void session_services_user_manager_init_login_proxy (GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void session_services_user_manager_init_login_proxy_finish (GAsyncResult* _res_);
static gboolean session_services_user_manager_init_login_proxy_co (SessionServicesUserManagerInitLoginProxyData* _data_);
static void session_services_user_manager_init_login_proxy_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void session_services_user_manager_get_user_state_data_free (gpointer _data);
static gboolean session_services_user_manager_get_user_state_co (SessionServicesUserManagerGetUserStateData* _data_);
VALA_EXTERN UserInfo* system_interface_list_users (SystemInterface* self,
                                       gint* result_length1,
                                       GError** error);
static void _vala_UserInfo_array_free (UserInfo * array,
                                gssize array_length);
VALA_EXTERN GType user_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType user_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint user_interface_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
static void session_services_user_manager_get_user_state_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
VALA_EXTERN gchar* user_interface_get_state (UserInterface* self);
static void session_services_user_manager_get_guest_state_data_free (gpointer _data);
static gboolean session_services_user_manager_get_guest_state_co (SessionServicesUserManagerGetGuestStateData* _data_);
static void session_services_user_manager_get_guest_state_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void session_services_user_manager_init_users (SessionServicesUserManager* self);
static void session_services_user_manager_add_user (SessionServicesUserManager* self,
                                             ActUser* user);
static void session_services_user_manager_remove_user (SessionServicesUserManager* self,
                                                ActUser* user);
static void session_services_user_manager_update_user (SessionServicesUserManager* self,
                                                ActUser* user);
static void session_services_user_manager_add_guest (SessionServicesUserManager* self);
static void session_services_user_manager_get_n_active_and_online_users_data_free (gpointer _data);
static gboolean session_services_user_manager_get_n_active_and_online_users_co (SessionServicesUserManagerGetNActiveAndOnlineUsersData* _data_);
static void session_services_user_manager_get_n_active_and_online_users_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_);
static void session_services_user_manager_set_user_grid (SessionServicesUserManager* self,
                                                  SessionWidgetsUserListBox* value);
static GObject * session_services_user_manager_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _session_services_user_manager___lambda5_ (SessionServicesUserManager* self);
static void __session_services_user_manager___lambda5__session_widgets_user_list_box_close (SessionWidgetsUserListBox* _sender,
                                                                                     gpointer self);
static void _session_services_user_manager_add_user_act_user_manager_user_added (ActUserManager* _sender,
                                                                          ActUser* user,
                                                                          gpointer self);
static void _session_services_user_manager_remove_user_act_user_manager_user_removed (ActUserManager* _sender,
                                                                               ActUser* user,
                                                                               gpointer self);
static void _session_services_user_manager_update_user_act_user_manager_user_is_logged_in_changed (ActUserManager* _sender,
                                                                                            ActUser* user,
                                                                                            gpointer self);
static void _session_services_user_manager___lambda6_ (SessionServicesUserManager* self);
static void __session_services_user_manager___lambda6__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
VALA_EXTERN gboolean seat_interface_get_has_guest_account (SeatInterface* self);
static void _session_services_user_manager____lambda7_ (SessionServicesUserManager* self);
VALA_EXTERN void seat_interface_switch_to_guest (SeatInterface* self,
                                     const gchar* session_name,
                                     GError** error);
static void __session_services_user_manager____lambda7__session_widgets_user_list_box_switch_to_guest (SessionWidgetsUserListBox* _sender,
                                                                                                gpointer self);
static void _session_services_user_manager____lambda8_ (Block4Data* _data4_,
                                                 const gchar* username);
VALA_EXTERN void seat_interface_switch_to_user (SeatInterface* self,
                                    const gchar* username,
                                    const gchar* session_name,
                                    GError** error);
static void __session_services_user_manager____lambda8__session_widgets_user_list_box_switch_to_user (SessionWidgetsUserListBox* _sender,
                                                                                               const gchar* username,
                                                                                               gpointer self);
static void session_services_user_manager_finalize (GObject * obj);
static GType session_services_user_manager_get_type_once (void);
static void _vala_session_services_user_manager_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_session_services_user_manager_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

UserState
user_state_to_enum (const gchar* state)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	UserState result;
	g_return_val_if_fail (state != NULL, 0);
	_tmp0_ = state;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("active")))) {
		switch (0) {
			default:
			{
				result = USER_STATE_ACTIVE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("online")))) {
		switch (0) {
			default:
			{
				result = USER_STATE_ONLINE;
				return result;
			}
		}
	}
	result = USER_STATE_OFFLINE;
	return result;
}

static GType
user_state_get_type_once (void)
{
	static const GEnumValue values[] = {{USER_STATE_ACTIVE, "USER_STATE_ACTIVE", "active"}, {USER_STATE_ONLINE, "USER_STATE_ONLINE", "online"}, {USER_STATE_OFFLINE, "USER_STATE_OFFLINE", "offline"}, {0, NULL, NULL}};
	GType user_state_type_id;
	user_state_type_id = g_enum_register_static ("UserState", values);
	return user_state_type_id;
}

GType
user_state_get_type (void)
{
	static volatile gsize user_state_type_id__once = 0;
	if (g_once_init_enter (&user_state_type_id__once)) {
		GType user_state_type_id;
		user_state_type_id = user_state_get_type_once ();
		g_once_init_leave (&user_state_type_id__once, user_state_type_id);
	}
	return user_state_type_id__once;
}

static inline gpointer
session_services_user_manager_get_instance_private (SessionServicesUserManager* self)
{
	return G_STRUCT_MEMBER_P (self, SessionServicesUserManager_private_offset);
}

static void
session_services_user_manager_init_login_proxy_data_free (gpointer _data)
{
	SessionServicesUserManagerInitLoginProxyData* _data_;
	_data_ = _data;
	g_slice_free (SessionServicesUserManagerInitLoginProxyData, _data_);
}

static void
session_services_user_manager_init_login_proxy (GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SessionServicesUserManagerInitLoginProxyData* _data_;
	_data_ = g_slice_new0 (SessionServicesUserManagerInitLoginProxyData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_services_user_manager_init_login_proxy_data_free);
	session_services_user_manager_init_login_proxy_co (_data_);
}

static void
session_services_user_manager_init_login_proxy_finish (GAsyncResult* _res_)
{
	SessionServicesUserManagerInitLoginProxyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
session_services_user_manager_init_login_proxy_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SessionServicesUserManagerInitLoginProxyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_services_user_manager_init_login_proxy_co (_data_);
}

static gboolean
session_services_user_manager_init_login_proxy_co (SessionServicesUserManagerInitLoginProxyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_SYSTEM_INTERFACE_PROXY, 0, NULL, session_services_user_manager_init_login_proxy_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", SESSION_SERVICES_USER_MANAGER_LOGIN_IFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", SESSION_SERVICES_USER_MANAGER_LOGIN_PATH, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (SystemInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (SystemInterface*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (session_services_user_manager_login_proxy);
		session_services_user_manager_login_proxy = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_critical ("UserManager.vala:65: Failed to create login1 dbus proxy: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
session_services_user_manager_get_user_state_data_free (gpointer _data)
{
	SessionServicesUserManagerGetUserStateData* _data_;
	_data_ = _data;
	g_slice_free (SessionServicesUserManagerGetUserStateData, _data_);
}

void
session_services_user_manager_get_user_state (guint32 uuid,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SessionServicesUserManagerGetUserStateData* _data_;
	_data_ = g_slice_new0 (SessionServicesUserManagerGetUserStateData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_services_user_manager_get_user_state_data_free);
	_data_->uuid = uuid;
	session_services_user_manager_get_user_state_co (_data_);
}

UserState
session_services_user_manager_get_user_state_finish (GAsyncResult* _res_)
{
	UserState result;
	SessionServicesUserManagerGetUserStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
_vala_UserInfo_array_free (UserInfo * array,
                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			user_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
session_services_user_manager_get_user_state_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	SessionServicesUserManagerGetUserStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_services_user_manager_get_user_state_co (_data_);
}

static gboolean
session_services_user_manager_get_user_state_co (SessionServicesUserManagerGetUserStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = session_services_user_manager_login_proxy;
	if (_data_->_tmp0_ == NULL) {
		_data_->result = USER_STATE_OFFLINE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = session_services_user_manager_login_proxy;
		_data_->_tmp2_ = 0;
		_data_->_tmp3_ = system_interface_list_users (_data_->_tmp1_, &_data_->_tmp2_, &_data_->_inner_error0_);
		_data_->users = _data_->_tmp3_;
		_data_->users_length1 = _data_->_tmp2_;
		_data_->_users_size_ = _data_->users_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->users;
		_data_->_tmp4__length1 = _data_->users_length1;
		if (_data_->_tmp4_ == NULL) {
			_data_->result = USER_STATE_OFFLINE;
			_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->users;
		_data_->_tmp5__length1 = _data_->users_length1;
		{
			_data_->user_collection_length1 = 0;
			_data_->_user_collection_size_ = 0;
			_data_->user_collection = _data_->_tmp5_;
			_data_->user_collection_length1 = _data_->_tmp5__length1;
			for (_data_->user_it = 0; _data_->user_it < _data_->user_collection_length1; _data_->user_it = _data_->user_it + 1) {
				_data_->_tmp6_ = _data_->user_collection[_data_->user_it];
				memset (&_data_->_tmp7_, 0, sizeof (UserInfo));
				user_info_copy (&_data_->_tmp6_, &_data_->_tmp7_);
				_data_->user = _data_->_tmp7_;
				{
					_data_->_tmp8_ = _data_->user;
					if (_data_->_tmp8_.uid == _data_->uuid) {
						_data_->_tmp9_ = _data_->user;
						_data_->_tmp10_ = _data_->_tmp9_.user_object;
						if (_data_->_tmp10_ == NULL) {
							_data_->result = USER_STATE_OFFLINE;
							user_info_destroy (&_data_->user);
							_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
							if (_data_->_state_ != 0) {
								while (!g_task_get_completed (_data_->_async_result)) {
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
								}
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp11_ = _data_->user;
						_data_->_tmp12_ = _data_->_tmp11_.user_object;
						_data_->_state_ = 1;
						g_async_initable_new_async (TYPE_USER_INTERFACE_PROXY, 0, NULL, session_services_user_manager_get_user_state_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", SESSION_SERVICES_USER_MANAGER_LOGIN_IFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _data_->_tmp12_, "g-interface-name", "org.freedesktop.login1.User", NULL);
						return FALSE;
						_state_1:
						_data_->_tmp13_ = (UserInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
						_data_->user_interface = (UserInterface*) _data_->_tmp13_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							user_info_destroy (&_data_->user);
							_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
							goto __catch0_g_error;
						}
						_data_->_tmp14_ = _data_->user_interface;
						if (_data_->_tmp14_ == NULL) {
							_data_->result = USER_STATE_OFFLINE;
							_g_object_unref0 (_data_->user_interface);
							user_info_destroy (&_data_->user);
							_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
							if (_data_->_state_ != 0) {
								while (!g_task_get_completed (_data_->_async_result)) {
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
								}
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp15_ = _data_->user_interface;
						_data_->_tmp16_ = user_interface_get_state (_data_->_tmp15_);
						_data_->_tmp17_ = _data_->_tmp16_;
						_data_->_tmp18_ = _data_->_tmp17_;
						_data_->_tmp19_ = user_state_to_enum (_data_->_tmp18_);
						_g_free0 (_data_->_tmp18_);
						_data_->result = _data_->_tmp19_;
						_g_object_unref0 (_data_->user_interface);
						user_info_destroy (&_data_->user);
						_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
						g_task_return_pointer (_data_->_async_result, _data_, NULL);
						if (_data_->_state_ != 0) {
							while (!g_task_get_completed (_data_->_async_result)) {
								g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
							}
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					user_info_destroy (&_data_->user);
				}
			}
		}
		_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp20_ = _data_->e;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		g_critical ("UserManager.vala:94: Failed to get user state: %s", _data_->_tmp21_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = USER_STATE_OFFLINE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
session_services_user_manager_get_guest_state_data_free (gpointer _data)
{
	SessionServicesUserManagerGetGuestStateData* _data_;
	_data_ = _data;
	g_slice_free (SessionServicesUserManagerGetGuestStateData, _data_);
}

void
session_services_user_manager_get_guest_state (GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SessionServicesUserManagerGetGuestStateData* _data_;
	_data_ = g_slice_new0 (SessionServicesUserManagerGetGuestStateData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_services_user_manager_get_guest_state_data_free);
	session_services_user_manager_get_guest_state_co (_data_);
}

UserState
session_services_user_manager_get_guest_state_finish (GAsyncResult* _res_)
{
	UserState result;
	SessionServicesUserManagerGetGuestStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
session_services_user_manager_get_guest_state_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	SessionServicesUserManagerGetGuestStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_services_user_manager_get_guest_state_co (_data_);
}

static gboolean
session_services_user_manager_get_guest_state_co (SessionServicesUserManagerGetGuestStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = session_services_user_manager_login_proxy;
	if (_data_->_tmp0_ == NULL) {
		_data_->result = USER_STATE_OFFLINE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = session_services_user_manager_login_proxy;
		_data_->_tmp2_ = 0;
		_data_->_tmp3_ = system_interface_list_users (_data_->_tmp1_, &_data_->_tmp2_, &_data_->_inner_error0_);
		_data_->users = _data_->_tmp3_;
		_data_->users_length1 = _data_->_tmp2_;
		_data_->_users_size_ = _data_->users_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->users;
		_data_->_tmp4__length1 = _data_->users_length1;
		{
			_data_->user_collection_length1 = 0;
			_data_->_user_collection_size_ = 0;
			_data_->user_collection = _data_->_tmp4_;
			_data_->user_collection_length1 = _data_->_tmp4__length1;
			for (_data_->user_it = 0; _data_->user_it < _data_->user_collection_length1; _data_->user_it = _data_->user_it + 1) {
				_data_->_tmp5_ = _data_->user_collection[_data_->user_it];
				memset (&_data_->_tmp6_, 0, sizeof (UserInfo));
				user_info_copy (&_data_->_tmp5_, &_data_->_tmp6_);
				_data_->user = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->user;
					_data_->_state_ = 1;
					session_services_user_manager_get_user_state (_data_->_tmp7_.uid, session_services_user_manager_get_guest_state_ready, _data_);
					return FALSE;
					_state_1:
					_data_->state = session_services_user_manager_get_user_state_finish (_data_->_res_);
					_data_->_tmp9_ = _data_->user;
					_data_->_tmp10_ = _data_->_tmp9_.user_name;
					if (g_str_has_prefix (_data_->_tmp10_, "guest-")) {
						_data_->_tmp8_ = _data_->state == USER_STATE_ACTIVE;
					} else {
						_data_->_tmp8_ = FALSE;
					}
					if (_data_->_tmp8_) {
						_data_->result = USER_STATE_ACTIVE;
						user_info_destroy (&_data_->user);
						_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
						g_task_return_pointer (_data_->_async_result, _data_, NULL);
						if (_data_->_state_ != 0) {
							while (!g_task_get_completed (_data_->_async_result)) {
								g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
							}
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					user_info_destroy (&_data_->user);
				}
			}
		}
		_data_->users = (_vala_UserInfo_array_free (_data_->users, _data_->users_length1), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("UserManager.vala:115: Failed to get Guest state: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = USER_STATE_OFFLINE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
session_services_user_manager_init_users (SessionServicesUserManager* self)
{
	ActUserManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ActUserManager* _tmp3_;
	GSList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	g_object_get (_tmp0_, "is-loaded", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->manager;
	_tmp4_ = act_user_manager_list_users (_tmp3_);
	{
		GSList* user_collection = NULL;
		GSList* user_it = NULL;
		user_collection = _tmp4_;
		for (user_it = user_collection; user_it != NULL; user_it = user_it->next) {
			ActUser* _tmp5_;
			ActUser* user = NULL;
			_tmp5_ = _g_object_ref0 ((ActUser*) user_it->data);
			user = _tmp5_;
			{
				ActUser* _tmp6_;
				_tmp6_ = user;
				session_services_user_manager_add_user (self, _tmp6_);
				_g_object_unref0 (user);
			}
		}
		(user_collection == NULL) ? NULL : (user_collection = (g_slist_free (user_collection), NULL));
	}
}

static void
session_services_user_manager_add_user (SessionServicesUserManager* self,
                                        ActUser* user)
{
	guint uid = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeHashMap* _tmp3_;
	SessionWidgetsUserbox* _tmp4_;
	SessionWidgetsUserbox* _tmp5_;
	SessionWidgetsUserListBox* _tmp6_;
	GeeHashMap* _tmp7_;
	gpointer _tmp8_;
	SessionWidgetsUserbox* _tmp9_;
	g_return_if_fail (self != NULL);
	uid = act_user_get_uid (user);
	if (uid < SESSION_SERVICES_USER_MANAGER_RESERVED_UID_RANGE_END) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = uid == SESSION_SERVICES_USER_MANAGER_NOBODY_USER_UID;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GeeHashMap* _tmp2_;
		_tmp2_ = self->priv->user_boxes;
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((guintptr) uid));
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->user_boxes;
	_tmp4_ = session_widgets_userbox_new (user);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) uid), _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_user_grid;
	_tmp7_ = self->priv->user_boxes;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) uid));
	_tmp9_ = (SessionWidgetsUserbox*) _tmp8_;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	g_signal_emit (self, session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_CHANGED_SIGNAL], 0);
}

static void
session_services_user_manager_remove_user (SessionServicesUserManager* self,
                                           ActUser* user)
{
	guint uid = 0U;
	SessionWidgetsUserbox* userbox = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SessionWidgetsUserbox* _tmp2_;
	GeeHashMap* _tmp3_;
	SessionWidgetsUserListBox* _tmp4_;
	SessionWidgetsUserbox* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	uid = act_user_get_uid (user);
	_tmp0_ = self->priv->user_boxes;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) uid));
	userbox = (SessionWidgetsUserbox*) _tmp1_;
	_tmp2_ = userbox;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (userbox);
		return;
	}
	_tmp3_ = self->priv->user_boxes;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) uid), NULL);
	_tmp4_ = self->priv->_user_grid;
	_tmp5_ = userbox;
	gtk_container_remove ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	g_signal_emit (self, session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_CHANGED_SIGNAL], 0);
	_g_object_unref0 (userbox);
}

static void
session_services_user_manager_update_user (SessionServicesUserManager* self,
                                           ActUser* user)
{
	SessionWidgetsUserbox* userbox = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SessionWidgetsUserbox* _tmp2_;
	SessionWidgetsUserbox* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = self->priv->user_boxes;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) act_user_get_uid (user)));
	userbox = (SessionWidgetsUserbox*) _tmp1_;
	_tmp2_ = userbox;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (userbox);
		return;
	}
	_tmp3_ = userbox;
	session_widgets_userbox_update_state (_tmp3_, NULL, NULL);
	g_signal_emit (self, session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_CHANGED_SIGNAL], 0);
	_g_object_unref0 (userbox);
}

void
session_services_user_manager_update_all (SessionServicesUserManager* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _userbox_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->user_boxes;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_userbox_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			SessionWidgetsUserbox* userbox = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SessionWidgetsUserbox* _tmp9_;
			_tmp6_ = _userbox_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _userbox_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			userbox = (SessionWidgetsUserbox*) _tmp8_;
			_tmp9_ = userbox;
			session_widgets_userbox_update_state (_tmp9_, NULL, NULL);
			_g_object_unref0 (userbox);
		}
		_g_object_unref0 (_userbox_it);
	}
}

static void
session_services_user_manager_add_guest (SessionServicesUserManager* self)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SessionWidgetsUserbox* _tmp2_;
	gboolean _tmp3_;
	GeeHashMap* _tmp4_;
	SessionWidgetsUserbox* _tmp5_;
	SessionWidgetsUserbox* _tmp6_;
	GeeHashMap* _tmp7_;
	gpointer _tmp8_;
	SessionWidgetsUserbox* _tmp9_;
	SessionWidgetsUserListBox* _tmp10_;
	GeeHashMap* _tmp11_;
	gpointer _tmp12_;
	SessionWidgetsUserbox* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->user_boxes;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) SESSION_SERVICES_USER_MANAGER_GUEST_USER_UID));
	_tmp2_ = (SessionWidgetsUserbox*) _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->user_boxes;
	_tmp5_ = session_widgets_userbox_new_guest ();
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) SESSION_SERVICES_USER_MANAGER_GUEST_USER_UID), _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->user_boxes;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) SESSION_SERVICES_USER_MANAGER_GUEST_USER_UID));
	_tmp9_ = (SessionWidgetsUserbox*) _tmp8_;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_user_grid;
	_tmp11_ = self->priv->user_boxes;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) SESSION_SERVICES_USER_MANAGER_GUEST_USER_UID));
	_tmp13_ = (SessionWidgetsUserbox*) _tmp12_;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (_tmp13_);
}

static void
session_services_user_manager_get_n_active_and_online_users_data_free (gpointer _data)
{
	SessionServicesUserManagerGetNActiveAndOnlineUsersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SessionServicesUserManagerGetNActiveAndOnlineUsersData, _data_);
}

void
session_services_user_manager_get_n_active_and_online_users (SessionServicesUserManager* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	SessionServicesUserManagerGetNActiveAndOnlineUsersData* _data_;
	SessionServicesUserManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SessionServicesUserManagerGetNActiveAndOnlineUsersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_services_user_manager_get_n_active_and_online_users_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	session_services_user_manager_get_n_active_and_online_users_co (_data_);
}

gint
session_services_user_manager_get_n_active_and_online_users_finish (SessionServicesUserManager* self,
                                                                    GAsyncResult* _res_)
{
	gint result;
	SessionServicesUserManagerGetNActiveAndOnlineUsersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
session_services_user_manager_get_n_active_and_online_users_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_)
{
	SessionServicesUserManagerGetNActiveAndOnlineUsersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_services_user_manager_get_n_active_and_online_users_co (_data_);
}

static gboolean
session_services_user_manager_get_n_active_and_online_users_co (SessionServicesUserManagerGetNActiveAndOnlineUsersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->n_active_and_online_users = 0;
	_data_->_tmp0_ = _data_->self->priv->manager;
	g_object_get (_data_->_tmp0_, "is-loaded", &_data_->_tmp1_, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		g_critical ("UserManager.vala:238: UserManager not yet loaded");
		_data_->result = _data_->n_active_and_online_users;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->manager;
	_data_->_tmp4_ = act_user_manager_list_users (_data_->_tmp3_);
	{
		_data_->user_collection = _data_->_tmp4_;
		for (_data_->user_it = _data_->user_collection; _data_->user_it != NULL; _data_->user_it = _data_->user_it->next) {
			_data_->user = (ActUser*) _data_->user_it->data;
			{
				_data_->_tmp6_ = _data_->user;
				_data_->_tmp7_ = act_user_get_uid (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				if (((guint) _data_->_tmp8_) < SESSION_SERVICES_USER_MANAGER_RESERVED_UID_RANGE_END) {
					_data_->_tmp5_ = TRUE;
				} else {
					_data_->_tmp9_ = _data_->user;
					_data_->_tmp10_ = act_user_get_uid (_data_->_tmp9_);
					_data_->_tmp11_ = _data_->_tmp10_;
					_data_->_tmp5_ = ((guint) _data_->_tmp11_) == SESSION_SERVICES_USER_MANAGER_NOBODY_USER_UID;
				}
				if (_data_->_tmp5_) {
					continue;
				}
				_data_->_tmp12_ = _data_->user;
				_data_->_tmp13_ = act_user_get_uid (_data_->_tmp12_);
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_state_ = 1;
				session_services_user_manager_get_user_state ((guint32) _data_->_tmp14_, session_services_user_manager_get_n_active_and_online_users_ready, _data_);
				return FALSE;
				_state_1:
				_data_->state = session_services_user_manager_get_user_state_finish (_data_->_res_);
				if (_data_->state == USER_STATE_ACTIVE) {
					_data_->_tmp15_ = TRUE;
				} else {
					_data_->_tmp15_ = _data_->state == USER_STATE_ONLINE;
				}
				if (_data_->_tmp15_) {
					_data_->_tmp16_ = _data_->n_active_and_online_users;
					_data_->n_active_and_online_users = _data_->_tmp16_ + 1;
				}
			}
		}
		(_data_->user_collection == NULL) ? NULL : (_data_->user_collection = (g_slist_free (_data_->user_collection), NULL));
	}
	_data_->result = _data_->n_active_and_online_users;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SessionServicesUserManager*
session_services_user_manager_construct (GType object_type)
{
	SessionServicesUserManager * self = NULL;
	self = (SessionServicesUserManager*) g_object_new (object_type, NULL);
	return self;
}

SessionServicesUserManager*
session_services_user_manager_new (void)
{
	return session_services_user_manager_construct (SESSION_SERVICES_TYPE_USER_MANAGER);
}

SessionWidgetsUserListBox*
session_services_user_manager_get_user_grid (SessionServicesUserManager* self)
{
	SessionWidgetsUserListBox* result;
	SessionWidgetsUserListBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user_grid;
	result = _tmp0_;
	return result;
}

static void
session_services_user_manager_set_user_grid (SessionServicesUserManager* self,
                                             SessionWidgetsUserListBox* value)
{
	SessionWidgetsUserListBox* old_value;
	g_return_if_fail (self != NULL);
	old_value = session_services_user_manager_get_user_grid (self);
	if (old_value != value) {
		SessionWidgetsUserListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user_grid);
		self->priv->_user_grid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, session_services_user_manager_properties[SESSION_SERVICES_USER_MANAGER_USER_GRID_PROPERTY]);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SessionServicesUserManager* self;
		self = _data4_->self;
		_g_free0 (_data4_->session_path);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_session_services_user_manager___lambda5_ (SessionServicesUserManager* self)
{
	g_signal_emit (self, session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_CLOSE_SIGNAL], 0);
}

static void
__session_services_user_manager___lambda5__session_widgets_user_list_box_close (SessionWidgetsUserListBox* _sender,
                                                                                gpointer self)
{
	_session_services_user_manager___lambda5_ ((SessionServicesUserManager*) self);
}

static void
_session_services_user_manager_add_user_act_user_manager_user_added (ActUserManager* _sender,
                                                                     ActUser* user,
                                                                     gpointer self)
{
	session_services_user_manager_add_user ((SessionServicesUserManager*) self, user);
}

static void
_session_services_user_manager_remove_user_act_user_manager_user_removed (ActUserManager* _sender,
                                                                          ActUser* user,
                                                                          gpointer self)
{
	session_services_user_manager_remove_user ((SessionServicesUserManager*) self, user);
}

static void
_session_services_user_manager_update_user_act_user_manager_user_is_logged_in_changed (ActUserManager* _sender,
                                                                                       ActUser* user,
                                                                                       gpointer self)
{
	session_services_user_manager_update_user ((SessionServicesUserManager*) self, user);
}

static void
_session_services_user_manager___lambda6_ (SessionServicesUserManager* self)
{
	session_services_user_manager_init_users (self);
}

static void
__session_services_user_manager___lambda6__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_session_services_user_manager___lambda6_ ((SessionServicesUserManager*) self);
}

static void
_session_services_user_manager____lambda7_ (SessionServicesUserManager* self)
{
	GError* _inner_error0_ = NULL;
	{
		SeatInterface* _tmp0_;
		_tmp0_ = self->priv->dm_proxy;
		seat_interface_switch_to_guest (_tmp0_, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserManager.vala:157: Error switching to guest account: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__session_services_user_manager____lambda7__session_widgets_user_list_box_switch_to_guest (SessionWidgetsUserListBox* _sender,
                                                                                           gpointer self)
{
	_session_services_user_manager____lambda7_ ((SessionServicesUserManager*) self);
}

static void
_session_services_user_manager____lambda8_ (Block4Data* _data4_,
                                            const gchar* username)
{
	SessionServicesUserManager* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (username != NULL);
	{
		SeatInterface* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->dm_proxy;
		_tmp1_ = _data4_->session_path;
		seat_interface_switch_to_user (_tmp0_, username, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("UserManager.vala:165: Error switching to user '%s': %s", username, _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__session_services_user_manager____lambda8__session_widgets_user_list_box_switch_to_user (SessionWidgetsUserListBox* _sender,
                                                                                          const gchar* username,
                                                                                          gpointer self)
{
	_session_services_user_manager____lambda8_ (self, username);
}

static GObject *
session_services_user_manager_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SessionServicesUserManager * self;
	Block4Data* _data4_;
	GeeHashMap* _tmp0_;
	SessionWidgetsUserListBox* _tmp1_;
	SessionWidgetsUserListBox* _tmp2_;
	SessionWidgetsUserListBox* _tmp3_;
	ActUserManager* _tmp4_;
	ActUserManager* _tmp5_;
	ActUserManager* _tmp6_;
	ActUserManager* _tmp7_;
	ActUserManager* _tmp8_;
	ActUserManager* _tmp9_;
	gchar* seat_path = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	SeatInterface* _tmp24_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (session_services_user_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SESSION_SERVICES_TYPE_USER_MANAGER, SessionServicesUserManager);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, SESSION_WIDGETS_TYPE_USERBOX, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->user_boxes);
	self->priv->user_boxes = _tmp0_;
	_tmp1_ = session_widgets_user_list_box_new ();
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	session_services_user_manager_set_user_grid (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_user_grid;
	g_signal_connect_object (_tmp3_, "close", (GCallback) __session_services_user_manager___lambda5__session_widgets_user_list_box_close, self, 0);
	_tmp4_ = act_user_manager_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp5_;
	session_services_user_manager_init_users (self);
	_tmp6_ = self->priv->manager;
	g_signal_connect_object (_tmp6_, "user-added", (GCallback) _session_services_user_manager_add_user_act_user_manager_user_added, self, 0);
	_tmp7_ = self->priv->manager;
	g_signal_connect_object (_tmp7_, "user-removed", (GCallback) _session_services_user_manager_remove_user_act_user_manager_user_removed, self, 0);
	_tmp8_ = self->priv->manager;
	g_signal_connect_object (_tmp8_, "user-is-logged-in-changed", (GCallback) _session_services_user_manager_update_user_act_user_manager_user_is_logged_in_changed, self, 0);
	_tmp9_ = self->priv->manager;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::is-loaded", (GCallback) __session_services_user_manager___lambda6__g_object_notify, self, 0);
	_tmp10_ = g_getenv ("XDG_SEAT_PATH");
	_tmp11_ = g_strdup (_tmp10_);
	seat_path = _tmp11_;
	_tmp12_ = g_getenv ("XDG_SESSION_PATH");
	_tmp13_ = g_strdup (_tmp12_);
	_data4_->session_path = _tmp13_;
	_tmp14_ = seat_path;
	if (_tmp14_ != NULL) {
		{
			SeatInterface* _tmp15_ = NULL;
			const gchar* _tmp16_;
			SeatInterface* _tmp17_;
			SeatInterface* _tmp18_;
			SeatInterface* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = seat_path;
			_tmp17_ = (SeatInterface*) g_initable_new (TYPE_SEAT_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", SESSION_SERVICES_USER_MANAGER_DM_DBUS_ID, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp16_, "g-interface-name", "org.freedesktop.DisplayManager.Seat", NULL);
			_tmp15_ = (SeatInterface*) _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_free0 (seat_path);
				block4_data_unref (_data4_);
				_data4_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp18_ = _tmp15_;
			_tmp15_ = NULL;
			_g_object_unref0 (self->priv->dm_proxy);
			self->priv->dm_proxy = _tmp18_;
			_tmp19_ = self->priv->dm_proxy;
			_tmp20_ = seat_interface_get_has_guest_account (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				session_services_user_manager_add_guest (self);
			}
			_g_object_unref0 (_tmp15_);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_critical ("UserManager.vala:148: UserManager error: %s", _tmp23_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (seat_path);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_tmp24_ = self->priv->dm_proxy;
	if (_tmp24_ != NULL) {
		SessionWidgetsUserListBox* _tmp25_;
		SessionWidgetsUserListBox* _tmp26_;
		_tmp25_ = self->priv->_user_grid;
		g_signal_connect_object (_tmp25_, "switch-to-guest", (GCallback) __session_services_user_manager____lambda7__session_widgets_user_list_box_switch_to_guest, self, 0);
		_tmp26_ = self->priv->_user_grid;
		g_signal_connect_data (_tmp26_, "switch-to-user", (GCallback) __session_services_user_manager____lambda8__session_widgets_user_list_box_switch_to_user, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	}
	_g_free0 (seat_path);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
session_services_user_manager_class_init (SessionServicesUserManagerClass * klass,
                                          gpointer klass_data)
{
	session_services_user_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SessionServicesUserManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_session_services_user_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_session_services_user_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = session_services_user_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = session_services_user_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_SERVICES_USER_MANAGER_USER_GRID_PROPERTY, session_services_user_manager_properties[SESSION_SERVICES_USER_MANAGER_USER_GRID_PROPERTY] = g_param_spec_object ("user-grid", "user-grid", "user-grid", SESSION_WIDGETS_TYPE_USER_LIST_BOX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_CLOSE_SIGNAL] = g_signal_new ("close", SESSION_SERVICES_TYPE_USER_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	session_services_user_manager_signals[SESSION_SERVICES_USER_MANAGER_CHANGED_SIGNAL] = g_signal_new ("changed", SESSION_SERVICES_TYPE_USER_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	session_services_user_manager_init_login_proxy (NULL, NULL);
}

static void
session_services_user_manager_instance_init (SessionServicesUserManager * self,
                                             gpointer klass)
{
	self->priv = session_services_user_manager_get_instance_private (self);
	self->priv->dm_proxy = NULL;
}

static void
session_services_user_manager_finalize (GObject * obj)
{
	SessionServicesUserManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SESSION_SERVICES_TYPE_USER_MANAGER, SessionServicesUserManager);
	_g_object_unref0 (self->priv->_user_grid);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->user_boxes);
	_g_object_unref0 (self->priv->dm_proxy);
	G_OBJECT_CLASS (session_services_user_manager_parent_class)->finalize (obj);
}

static GType
session_services_user_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionServicesUserManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_services_user_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionServicesUserManager), 0, (GInstanceInitFunc) session_services_user_manager_instance_init, NULL };
	GType session_services_user_manager_type_id;
	session_services_user_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SessionServicesUserManager", &g_define_type_info, 0);
	SessionServicesUserManager_private_offset = g_type_add_instance_private (session_services_user_manager_type_id, sizeof (SessionServicesUserManagerPrivate));
	return session_services_user_manager_type_id;
}

GType
session_services_user_manager_get_type (void)
{
	static volatile gsize session_services_user_manager_type_id__once = 0;
	if (g_once_init_enter (&session_services_user_manager_type_id__once)) {
		GType session_services_user_manager_type_id;
		session_services_user_manager_type_id = session_services_user_manager_get_type_once ();
		g_once_init_leave (&session_services_user_manager_type_id__once, session_services_user_manager_type_id);
	}
	return session_services_user_manager_type_id__once;
}

static void
_vala_session_services_user_manager_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	SessionServicesUserManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SESSION_SERVICES_TYPE_USER_MANAGER, SessionServicesUserManager);
	switch (property_id) {
		case SESSION_SERVICES_USER_MANAGER_USER_GRID_PROPERTY:
		g_value_set_object (value, session_services_user_manager_get_user_grid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_session_services_user_manager_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	SessionServicesUserManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SESSION_SERVICES_TYPE_USER_MANAGER, SessionServicesUserManager);
	switch (property_id) {
		case SESSION_SERVICES_USER_MANAGER_USER_GRID_PROPERTY:
		session_services_user_manager_set_user_grid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

