// java wrapper for vtkVRModel object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVRModel.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVRModel_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVRModel",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRModel_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRModel_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRModel_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRModel_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRModel_Build_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Build(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_Render_15(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkOpenGLRenderWindow * temp0;
  vtkMatrix4x4 * temp1;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVRModel_GetName_16(JNIEnv* env, jobject obj)
{
  const std::string * temp20;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetName();
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_SetName_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_SetVisibility_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRModel_GetVisibility_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_SetShowRay_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowRay(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_SetRayLength_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRayLength(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_SetRayColor_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRayColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRModel_GetRay_113(JNIEnv* env, jobject obj)
{
  vtkVRRay * temp20;

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRay();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRModel_ReleaseGraphicsResources_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRModel* op = static_cast<vtkVRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}
