// java wrapper for vtkExternalOpenGLCamera object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkExternalOpenGLCamera.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkOpenGLCamera_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkExternalOpenGLCamera_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkExternalOpenGLCamera",dType)) { return me; }
  if ((res= vtkOpenGLCamera_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExternalOpenGLCamera_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExternalOpenGLCamera* op = static_cast<vtkExternalOpenGLCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExternalOpenGLCamera_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExternalOpenGLCamera* op = static_cast<vtkExternalOpenGLCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExternalOpenGLCamera_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExternalOpenGLCamera* op = static_cast<vtkExternalOpenGLCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExternalOpenGLCamera_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExternalOpenGLCamera* op = static_cast<vtkExternalOpenGLCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExternalOpenGLCamera_SetViewTransformMatrix_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkExternalOpenGLCamera* op = static_cast<vtkExternalOpenGLCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewTransformMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExternalOpenGLCamera_SetProjectionTransformMatrix_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkExternalOpenGLCamera* op = static_cast<vtkExternalOpenGLCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionTransformMatrix(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkExternalOpenGLCamera_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkExternalOpenGLCamera::New());
}
