// java wrapper for vtkTextActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkTexturedActor2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextActor",dType)) { return me; }
  if ((res= vtkTexturedActor2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_ShallowCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetInput_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextActor_GetInput_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetMinimumSize_17(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetMinimumSize_18(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkTextActor_GetMinimumSize_19(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetMaximumLineHeight_110(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumLineHeight(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTextActor_GetMaximumLineHeight_111(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumLineHeight();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetTextScaleMode_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextScaleMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_GetTextScaleModeMinValue_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextScaleModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_GetTextScaleModeMaxValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextScaleModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_GetTextScaleMode_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextScaleMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetTextScaleModeToNone_116(JNIEnv* env, jobject obj)
{

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextScaleModeToNone();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetTextScaleModeToProp_117(JNIEnv* env, jobject obj)
{

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextScaleModeToProp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetTextScaleModeToViewport_118(JNIEnv* env, jobject obj)
{

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextScaleModeToViewport();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetUseBorderAlign_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseBorderAlign(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_GetUseBorderAlign_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseBorderAlign();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_UseBorderAlignOn_121(JNIEnv* env, jobject obj)
{

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBorderAlignOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_UseBorderAlignOff_122(JNIEnv* env, jobject obj)
{

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBorderAlignOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetAlignmentPoint_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlignmentPoint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_GetAlignmentPoint_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlignmentPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetOrientation_125(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTextActor_GetOrientation_126(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetTextProperty_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor_GetTextProperty_128(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_GetBoundingBox_129(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkViewport * temp0;
  double temp1[4];
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBoundingBox(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_GetSize_130(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkViewport * temp0;
  double temp1[2];
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSize(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_SetConstrainedFontSize_131(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkViewport * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetConstrainedFontSize(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_SetConstrainedFontSize_132(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2,jint id3)
{
  vtkTextActor * temp0;
  vtkViewport * temp1;
  int   temp2;
  int   temp3;
  int   temp20;
  temp0 = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetConstrainedFontSize(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_SetNonLinearFontScale_133(JNIEnv* env, jobject obj,jdouble id0,jint id1)
{
  double   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNonLinearFontScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_ComputeScaledFont_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeScaledFont(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor_GetScaledTextProperty_135(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaledTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTextActor_GetFontScale_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  float   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontScale(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor_ReleaseGraphicsResources_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_RenderOpaqueGeometry_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_RenderTranslucentPolygonalGeometry_139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_RenderOverlay_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor_HasTranslucentPolygonalGeometry_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor* op = static_cast<vtkTextActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextActor::New());
}
