// java wrapper for vtkMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractMapper3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMapper",dType)) { return me; }
  if ((res= vtkAbstractMapper3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ShallowCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractMapper * temp0;
  temp0 = static_cast<vtkAbstractMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetMTime_15(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_Render_16(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ReleaseGraphicsResources_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetLookupTable_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetLookupTable_19(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_CreateDefaultLookupTable_110(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLookupTable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarVisibility_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetScalarVisibility_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ScalarVisibilityOn_113(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ScalarVisibilityOff_114(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetStatic_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStatic(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetStatic_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStatic();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_StaticOn_117(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->StaticOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_StaticOff_118(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->StaticOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetColorMode_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetColorMode_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetColorModeToDefault_121(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetColorModeToMapScalars_122(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToMapScalars();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetColorModeToDirectScalars_123(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDirectScalars();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMapper_GetColorModeAsString_124(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetInterpolateScalarsBeforeMapping_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolateScalarsBeforeMapping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetInterpolateScalarsBeforeMapping_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolateScalarsBeforeMapping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_InterpolateScalarsBeforeMappingOn_127(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateScalarsBeforeMappingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_InterpolateScalarsBeforeMappingOff_128(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateScalarsBeforeMappingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetUseLookupTableScalarRange_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseLookupTableScalarRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetUseLookupTableScalarRange_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseLookupTableScalarRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_UseLookupTableScalarRangeOn_131(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLookupTableScalarRangeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_UseLookupTableScalarRangeOff_132(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLookupTableScalarRangeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarRange_133(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarRange_134(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMapper_GetScalarRange_135(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarMode_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetScalarMode_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarModeToDefault_138(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarModeToUsePointData_139(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUsePointData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarModeToUseCellData_140(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUseCellData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarModeToUsePointFieldData_141(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUsePointFieldData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarModeToUseCellFieldData_142(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUseCellFieldData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetScalarModeToUseFieldData_143(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUseFieldData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SelectColorArray_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectColorArray(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SelectColorArray_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectColorArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetFieldDataTupleId_146(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDataTupleId(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetFieldDataTupleId_147(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataTupleId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ColorByArrayComponent_148(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorByArrayComponent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ColorByArrayComponent_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorByArrayComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMapper_GetArrayName_150(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetArrayName_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetArrayId_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetArrayId_153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayId(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetArrayAccessMode_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayAccessMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetArrayAccessMode_155(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayAccessMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetArrayComponent_156(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetArrayComponent_157(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayComponent(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMapper_GetScalarModeAsString_158(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopology_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopology(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetResolveCoincidentTopology_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolveCoincidentTopology();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyToDefault_161(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyToOff_162(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyToOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyToPolygonOffset_163(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyToPolygonOffset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyToShiftZBuffer_164(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyToShiftZBuffer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyPolygonOffsetParameters_165(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyPolygonOffsetParameters(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetRelativeCoincidentTopologyPolygonOffsetParameters_166(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRelativeCoincidentTopologyPolygonOffsetParameters(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyLineOffsetParameters_167(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyLineOffsetParameters(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetRelativeCoincidentTopologyLineOffsetParameters_168(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRelativeCoincidentTopologyLineOffsetParameters(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyPointOffsetParameter_169(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyPointOffsetParameter(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetRelativeCoincidentTopologyPointOffsetParameter_170(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRelativeCoincidentTopologyPointOffsetParameter(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyPolygonOffsetFaces_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyPolygonOffsetFaces(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_GetResolveCoincidentTopologyPolygonOffsetFaces_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolveCoincidentTopologyPolygonOffsetFaces();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetResolveCoincidentTopologyZShift_173(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolveCoincidentTopologyZShift(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMapper_GetResolveCoincidentTopologyZShift_174(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolveCoincidentTopologyZShift();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMapper_GetBounds_175(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_GetBounds_176(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetRenderTime_177(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderTime(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMapper_GetRenderTime_178(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetDataSetInput_179(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetInputAsDataSet_180(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputAsDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_MapScalars_181(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  vtkUnsignedCharArray * temp20;
  temp0 = id0;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MapScalars(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_MapScalars_182(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkDataSet * temp0;
  double   temp1;
  vtkUnsignedCharArray * temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MapScalars(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMapper_HasOpaqueGeometry_183(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOpaqueGeometry();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMapper_HasTranslucentPolygonalGeometry_184(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMapper_GetSupportsSelection_185(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsSelection();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMapper_CanUseTextureMapForColoring_186(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanUseTextureMapForColoring(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_ClearColorArrays_187(JNIEnv* env, jobject obj)
{

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearColorArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetColorMapColors_188(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMapColors();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetColorCoordinates_189(JNIEnv* env, jobject obj)
{
  vtkFloatArray * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetColorTextureMap_190(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorTextureMap();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMapper_GetSelection_191(JNIEnv* env, jobject obj)
{
  vtkSelection * temp20;

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMapper_SetSelection_192(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelection * temp0;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMapper* op = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelection(temp0);

}
