// java wrapper for vtkImageActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageSlice_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageActor",dType)) { return me; }
  if ((res= vtkImageSlice_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetInputData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageActor_GetInput_15(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetInterpolate_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolate(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetInterpolate_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_InterpolateOn_18(JNIEnv* env, jobject obj)
{

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_InterpolateOff_19(JNIEnv* env, jobject obj)
{

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetOpacity_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageActor_GetOpacity_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageActor_GetOpacityMinValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageActor_GetOpacityMaxValue_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetDisplayExtent_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayExtent(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetDisplayExtent_115(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_GetDisplayExtent_116(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDisplayExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageActor_GetDisplayExtent_117(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageActor_GetBounds_118(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_GetBounds_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageActor_GetDisplayBounds_120(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_GetDisplayBounds_121(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDisplayBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetSliceNumber_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceNumber();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetSliceNumberMax_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceNumberMax();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetSliceNumberMin_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceNumberMin();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetZSlice_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZSlice(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetZSlice_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZSlice();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetWholeZMin_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWholeZMin();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_GetWholeZMax_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWholeZMax();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageActor_HasTranslucentPolygonalGeometry_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageActor_GetForceOpaque_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceOpaque();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_SetForceOpaque_131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceOpaque(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_ForceOpaqueOn_132(JNIEnv* env, jobject obj)
{

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageActor_ForceOpaqueOff_133(JNIEnv* env, jobject obj)
{

  vtkImageActor* op = static_cast<vtkImageActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageActor::New());
}
