// java wrapper for vtkImageReslice object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageReslice.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkThreadedImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageReslice_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageReslice",dType)) { return me; }
  if ((res= vtkThreadedImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceAxes_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceAxes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetResliceAxes_15(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceAxes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceAxesDirectionCosines_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceAxesDirectionCosines(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceAxesDirectionCosines_17(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceAxesDirectionCosines(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceAxesDirectionCosines_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceAxesDirectionCosines(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_GetResliceAxesDirectionCosines_19(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetResliceAxesDirectionCosines(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_GetResliceAxesDirectionCosines_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetResliceAxesDirectionCosines(temp0);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReslice_GetResliceAxesDirectionCosines_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceAxesDirectionCosines();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceAxesOrigin_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceAxesOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceAxesOrigin_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceAxesOrigin(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_GetResliceAxesOrigin_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetResliceAxesOrigin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReslice_GetResliceAxesOrigin_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceAxesOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetResliceTransform_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetResliceTransform_117(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInformationInput_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformationInput(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetInformationInput_119(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformationInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetTransformInputSampling_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformInputSampling(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_TransformInputSamplingOn_121(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformInputSamplingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_TransformInputSamplingOff_122(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformInputSamplingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetTransformInputSampling_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformInputSampling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetAutoCropOutput_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoCropOutput(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_AutoCropOutputOn_125(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoCropOutputOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_AutoCropOutputOff_126(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoCropOutputOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetAutoCropOutput_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoCropOutput();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetWrap_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrap(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetWrap_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_WrapOn_130(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->WrapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_WrapOff_131(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->WrapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetMirror_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMirror(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetMirror_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMirror();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_MirrorOn_134(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->MirrorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_MirrorOff_135(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->MirrorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetBorder_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetBorder_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_BorderOn_138(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->BorderOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_BorderOff_139(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->BorderOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetBorderThickness_140(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageReslice_GetBorderThickness_141(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInterpolationMode_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetInterpolationModeMinValue_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetInterpolationModeMaxValue_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetInterpolationMode_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInterpolationModeToNearestNeighbor_146(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToNearestNeighbor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInterpolationModeToLinear_147(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInterpolationModeToCubic_148(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToCubic();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReslice_GetInterpolationModeAsString_149(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInterpolator_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractImageInterpolator * temp0;
  temp0 = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetInterpolator_151(JNIEnv* env, jobject obj)
{
  vtkAbstractImageInterpolator * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabMode_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetSlabModeMinValue_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetSlabModeMaxValue_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetSlabMode_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabModeToMin_156(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabModeToMin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabModeToMax_157(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabModeToMax();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabModeToMean_158(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabModeToMean();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabModeToSum_159(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabModeToSum();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReslice_GetSlabModeAsString_160(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabNumberOfSlices_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabNumberOfSlices(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetSlabNumberOfSlices_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabNumberOfSlices();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabTrapezoidIntegration_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabTrapezoidIntegration(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SlabTrapezoidIntegrationOn_164(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SlabTrapezoidIntegrationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SlabTrapezoidIntegrationOff_165(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SlabTrapezoidIntegrationOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetSlabTrapezoidIntegration_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabTrapezoidIntegration();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetSlabSliceSpacingFraction_167(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlabSliceSpacingFraction(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageReslice_GetSlabSliceSpacingFraction_168(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlabSliceSpacingFraction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOptimization_169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOptimization(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetOptimization_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOptimization();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_OptimizationOn_171(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->OptimizationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_OptimizationOff_172(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->OptimizationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetScalarShift_173(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarShift(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageReslice_GetScalarShift_174(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarShift();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetScalarScale_175(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageReslice_GetScalarScale_176(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputScalarType_177(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetOutputScalarType_178(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputScalarType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetBackgroundColor_179(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetBackgroundColor_180(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReslice_GetBackgroundColor_181(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetBackgroundLevel_182(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundLevel(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageReslice_GetBackgroundLevel_183(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputSpacing_184(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputSpacing_185(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReslice_GetOutputSpacing_186(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputSpacingToDefault_187(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacingToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputDirection_188(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDirection(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputDirection_189(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDirection(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReslice_GetOutputDirection_190(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputDirectionToDefault_191(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDirectionToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputOrigin_192(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputOrigin_193(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReslice_GetOutputOrigin_194(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputOriginToDefault_195(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputOriginToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputExtent_196(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputExtent_197(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageReslice_GetOutputExtent_198(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputExtentToDefault_199(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputExtentToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetOutputDimensionality_1100(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDimensionality(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetOutputDimensionality_1101(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputDimensionality();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetMTime_1102(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_ReportReferences_1103(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGarbageCollector * temp0;
  temp0 = static_cast<vtkGarbageCollector*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReportReferences(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetInterpolate_1104(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_InterpolateOn_1105(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_InterpolateOff_1106(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetInterpolate_1107(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetStencilData_1108(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageStencilData * temp0;
  temp0 = static_cast<vtkImageStencilData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetStencil_1109(JNIEnv* env, jobject obj)
{
  vtkImageStencilData * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencil();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetGenerateStencilOutput_1110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateStencilOutput(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReslice_GetGenerateStencilOutput_1111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateStencilOutput();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_GenerateStencilOutputOn_1112(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateStencilOutputOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_GenerateStencilOutputOff_1113(JNIEnv* env, jobject obj)
{

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateStencilOutputOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetStencilOutputPort_1114(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencilOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReslice_GetStencilOutput_1115(JNIEnv* env, jobject obj)
{
  vtkImageStencilData * temp20;

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencilOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReslice_SetStencilOutput_1116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageStencilData * temp0;
  temp0 = static_cast<vtkImageStencilData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReslice* op = static_cast<vtkImageReslice*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilOutput(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageReslice_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageReslice::New());
}
