// java wrapper for vtkImageChangeInformation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageChangeInformation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageChangeInformation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageChangeInformation",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageChangeInformation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageChangeInformation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageChangeInformation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageChangeInformation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetInformationInputData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformationInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageChangeInformation_GetInformationInput_15(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformationInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOutputExtentStart_16(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputExtentStart(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOutputExtentStart_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputExtentStart(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageChangeInformation_GetOutputExtentStart_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputExtentStart();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOutputSpacing_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOutputSpacing_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageChangeInformation_GetOutputSpacing_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageChangeInformation_GetOutputDirection_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOutputOrigin_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOutputOrigin_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageChangeInformation_GetOutputOrigin_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetCenterImage_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenterImage(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_CenterImageOn_117(JNIEnv* env, jobject obj)
{

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CenterImageOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_CenterImageOff_118(JNIEnv* env, jobject obj)
{

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CenterImageOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageChangeInformation_GetCenterImage_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenterImage();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetExtentTranslation_120(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtentTranslation(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetExtentTranslation_121(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtentTranslation(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageChangeInformation_GetExtentTranslation_122(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentTranslation();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetSpacingScale_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacingScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetSpacingScale_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacingScale(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageChangeInformation_GetSpacingScale_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpacingScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOriginTranslation_126(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginTranslation(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOriginTranslation_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginTranslation(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageChangeInformation_GetOriginTranslation_128(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOriginTranslation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOriginScale_129(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageChangeInformation_SetOriginScale_130(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginScale(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageChangeInformation_GetOriginScale_131(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageChangeInformation* op = static_cast<vtkImageChangeInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOriginScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageChangeInformation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageChangeInformation::New());
}
