// java wrapper for vtkHyperTreeGridSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHyperTreeGridSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHyperTreeGridAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHyperTreeGridSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHyperTreeGridSource",dType)) { return me; }
  if ((res= vtkHyperTreeGridAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_GetMaxDepth_14(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxDepth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetMaxDepth_15(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxDepth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetOrigin_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetOrigin_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkHyperTreeGridSource_GetOrigin_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetGridScale_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetGridScale_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScale(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkHyperTreeGridSource_GetGridScale_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetGridScale_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetDimensions_113(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetTransposedRootIndexing_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransposedRootIndexing(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGridSource_GetTransposedRootIndexing_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransposedRootIndexing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetIndexingModeToKJI_116(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexingModeToKJI();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetIndexingModeToIJK_117(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexingModeToIJK();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_GetOrientation_118(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetBranchFactor_119(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBranchFactor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_GetBranchFactorMinValue_120(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBranchFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_GetBranchFactorMaxValue_121(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBranchFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGridSource_GetBranchFactor_122(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBranchFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetUseDescriptor_123(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDescriptor(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGridSource_GetUseDescriptor_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDescriptor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_UseDescriptorOn_125(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDescriptorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_UseDescriptorOff_126(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDescriptorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetUseMask_127(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseMask(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGridSource_GetUseMask_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseMask();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_UseMaskOn_129(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseMaskOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_UseMaskOff_130(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseMaskOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetGenerateInterfaceFields_131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateInterfaceFields(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGridSource_GetGenerateInterfaceFields_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateInterfaceFields();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_GenerateInterfaceFieldsOn_133(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateInterfaceFieldsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_GenerateInterfaceFieldsOff_134(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateInterfaceFieldsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetDescriptor_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDescriptor(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHyperTreeGridSource_GetDescriptor_136(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptor();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetMask_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMask(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHyperTreeGridSource_GetMask_138(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMask();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetDescriptorBits_139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBitArray * temp0;
  temp0 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDescriptorBits(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_GetDescriptorBits_140(JNIEnv* env, jobject obj)
{
  vtkBitArray * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptorBits();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetLevelZeroMaterialIndex_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLevelZeroMaterialIndex(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetMaskBits_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBitArray * temp0;
  temp0 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaskBits(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_GetMaskBits_143(JNIEnv* env, jobject obj)
{
  vtkBitArray * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaskBits();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetQuadric_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkQuadric * temp0;
  temp0 = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQuadric(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_GetQuadric_145(JNIEnv* env, jobject obj)
{
  vtkQuadric * temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQuadric();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_SetQuadricCoefficients_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[10];
  env->GetDoubleArrayRegion(id0, 0, 10, &temp0[0]);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQuadricCoefficients(temp0);
  env->SetDoubleArrayRegion(id0, 0, 10, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGridSource_GetQuadricCoefficients_147(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[10];
  env->GetDoubleArrayRegion(id0, 0, 10, &temp0[0]);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetQuadricCoefficients(temp0);
  env->SetDoubleArrayRegion(id0, 0, 10, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_GetMTime_148(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_ConvertDescriptorStringToBitArray_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  vtkBitArray * temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertDescriptorStringToBitArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGridSource_ConvertMaskStringToBitArray_150(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  vtkBitArray * temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkHyperTreeGridSource* op = static_cast<vtkHyperTreeGridSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertMaskStringToBitArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHyperTreeGridSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHyperTreeGridSource::New());
}
