// java wrapper for vtkImplicitModeller object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImplicitModeller.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImplicitModeller_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImplicitModeller",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitModeller_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitModeller_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_ComputeModelBounds_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  double   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeModelBounds(temp0);
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImplicitModeller_GetSampleDimensions_15(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSampleDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetSampleDimensions_16(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetSampleDimensions_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetMaximumDistance_18(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetMaximumDistanceMinValue_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetMaximumDistanceMaxValue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetMaximumDistance_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetModelBounds_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetModelBounds_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImplicitModeller_GetModelBounds_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetAdjustBounds_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustBounds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetAdjustBounds_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_AdjustBoundsOn_117(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_AdjustBoundsOff_118(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetAdjustDistance_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetAdjustDistanceMinValue_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetAdjustDistanceMaxValue_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetAdjustDistance_122(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetCapping_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetCapping_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_CappingOn_125(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_CappingOff_126(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetCapValue_127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitModeller_GetCapValue_128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetScaleToMaximumDistance_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleToMaximumDistance(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetScaleToMaximumDistance_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleToMaximumDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_ScaleToMaximumDistanceOn_131(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScaleToMaximumDistanceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_ScaleToMaximumDistanceOff_132(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScaleToMaximumDistanceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetProcessMode_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProcessMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetProcessModeMinValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetProcessModeMaxValue_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetProcessMode_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetProcessModeToPerVoxel_137(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProcessModeToPerVoxel();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetProcessModeToPerCell_138(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProcessModeToPerCell();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImplicitModeller_GetProcessModeAsString_139(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetLocatorMaxLevel_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocatorMaxLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetLocatorMaxLevel_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocatorMaxLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetNumberOfThreads_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfThreads(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetNumberOfThreadsMinValue_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreadsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetNumberOfThreadsMaxValue_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreadsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetNumberOfThreads_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreads();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarType_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitModeller_GetOutputScalarType_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputScalarType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToFloat_148(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToDouble_149(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToInt_150(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToUnsignedInt_151(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToUnsignedInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToLong_152(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToUnsignedLong_153(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToUnsignedLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToShort_154(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToUnsignedShort_155(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToUnsignedChar_156(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_SetOutputScalarTypeToChar_157(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputScalarTypeToChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_StartAppend_158(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartAppend();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_Append_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitModeller_EndAppend_160(JNIEnv* env, jobject obj)
{

  vtkImplicitModeller* op = static_cast<vtkImplicitModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndAppend();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImplicitModeller_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImplicitModeller::New());
}
