// java wrapper for vtkQuaternionInterpolator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkQuaternionInterpolator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkQuaternionInterpolator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkQuaternionInterpolator",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuaternionInterpolator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuaternionInterpolator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_GetNumberOfQuaternions_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfQuaternions();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkQuaternionInterpolator_GetMinimumT_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumT();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkQuaternionInterpolator_GetMaximumT_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumT();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_AddQuaternion_18(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddQuaternion(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_RemoveQuaternion_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveQuaternion(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_InterpolateQuaternion_110(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateQuaternion(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_GetSearchMethod_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSearchMethod();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_SetSearchMethod_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSearchMethod(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_SetInterpolationType_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_GetInterpolationTypeMinValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_GetInterpolationTypeMaxValue_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuaternionInterpolator_GetInterpolationType_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_SetInterpolationTypeToLinear_117(JNIEnv* env, jobject obj)
{

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuaternionInterpolator_SetInterpolationTypeToSpline_118(JNIEnv* env, jobject obj)
{

  vtkQuaternionInterpolator* op = static_cast<vtkQuaternionInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToSpline();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkQuaternionInterpolator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkQuaternionInterpolator::New());
}
