// java wrapper for vtkHexagonalPrism object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHexagonalPrism.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHexagonalPrism_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHexagonalPrism",dType)) { return me; }
  if ((res= vtkCell3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexagonalPrism_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexagonalPrism_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHexagonalPrism_GetCentroid_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentroid(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHexagonalPrism_IsInsideOut_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsideOut();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_GetCellType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_GetCellDimension_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_GetNumberOfEdges_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_GetNumberOfFaces_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexagonalPrism_GetEdge_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexagonalPrism_GetFace_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_CellBoundary_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_TriangulateLocalIds_113(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexagonalPrism_GetParametricCenter_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexagonalPrism_InterpolationFunctions_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[12];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexagonalPrism_InterpolationDerivs_116(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[36];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 36, &temp1[0]);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 36, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexagonalPrism_InterpolateFunctions_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[12];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 12, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexagonalPrism_InterpolateDerivs_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[36];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 36, &temp1[0]);

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 36, &temp1[0]);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexagonalPrism_GetEdgeToAdjacentFacesArray_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexagonalPrism_GetFaceToAdjacentFacesArray_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 6);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexagonalPrism_GetPointToIncidentEdgesArray_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentEdgesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexagonalPrism_GetPointToIncidentFacesArray_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexagonalPrism_GetPointToOneRingPointsArray_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexagonalPrism* op = static_cast<vtkHexagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToOneRingPointsArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHexagonalPrism_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHexagonalPrism::New());
}
