// java wrapper for vtkCell3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCell3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCell3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCell3D",dType)) { return me; }
  if ((res= vtkCell_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCell3D_IsInsideOut_14(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsideOut();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCell3D_GetCentroid_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentroid(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell3D_Contour_16(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell3D_Clip_17(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell3D_GetCellDimension_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell3D_Inflate_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Inflate(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell3D_SetMergeTolerance_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMergeTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCell3D_GetMergeToleranceMinValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCell3D_GetMergeToleranceMaxValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCell3D_GetMergeTolerance_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCell3D* op = static_cast<vtkCell3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeTolerance();
  return temp20;

}
