// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "vtkRenderingFreeTypeFontConfigObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkFontConfigFreeTypeTools.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkRenderingFreeTypeFontConfigObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkFontConfigFreeTypeTools)


vtkRenderingFreeTypeFontConfigObjectFactory::vtkRenderingFreeTypeFontConfigObjectFactory()
{
this->RegisterOverride("vtkFreeTypeTools", "vtkFontConfigFreeTypeTools", "Override for VTK::RenderingFreeTypeFontConfig module", 1, vtkObjectFactoryCreatevtkFontConfigFreeTypeTools);

}

const char * vtkRenderingFreeTypeFontConfigObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void vtkRenderingFreeTypeFontConfigObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int vtkRenderingFreeTypeFontConfigCount = 0;

VTKRENDERINGFREETYPEFONTCONFIG_EXPORT void vtkRenderingFreeTypeFontConfig_AutoInit_Construct()
{
  if(++vtkRenderingFreeTypeFontConfigCount == 1)
  {


    vtkRenderingFreeTypeFontConfigObjectFactory* factory = vtkRenderingFreeTypeFontConfigObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
