// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_TetF2Gradient.h"

const char *Basis_HGrad_TetF2Gradient =
"RealT uu = 1. - rr - ss - tt;\n"
"RealT rs = rr * ss;\n"
"RealT rt = rr * tt;\n"
"RealT st = ss * tt;\n"
"RealT umr = uu - rr;\n"
"RealT ums = uu - ss;\n"
"RealT umt = uu - tt;\n"
"\n"
"basisGradient[0] = 1.0 - 4.0 * uu + 3.0 * ((ss + tt) * umr - st) - 4.0 * st * umr;\n"
"basisGradient[1] = 1.0 - 4.0 * uu + 3.0 * ((rr + tt) * ums - rt) - 4.0 * rt * ums;\n"
"basisGradient[2] = 1.0 - 4.0 * uu + 3.0 * ((rr + ss) * umt - rs) - 4.0 * rs * umt;\n"
"\n"
"basisGradient[3] = 1.0 - 2.0 * (umr + ss + tt) + 3.0 * ((ss + tt) * umr + st) - 4.0 * st * umr;\n"
"basisGradient[4] = 3.0 * rr * ums - 4.0 * rt * ums;\n"
"basisGradient[5] = 3.0 * rr * umt - 4.0 * rs * umt;\n"
"\n"
"basisGradient[6] = 3.0 * ss * umr - 4.0 * st * umr;\n"
"basisGradient[7] = 1 - 2.0 * (rr + ums + tt) + 3.0 * ((rr + tt) * ums + rt) - 4.0 * rt * ums;\n"
"basisGradient[8] = 3.0 * ss * umt - 4.0 * rs * umt;\n"
"\n"
"basisGradient[9] = 3.0 * tt * umr - 4.0 * st * umr;\n"
"basisGradient[10] = 3.0 * tt * ums - 4.0 * rt * ums;\n"
"basisGradient[11] = 1 - 2.0 * (umt + rr + ss) + 3.0 * ((rr + ss) * umt + rs) - 4.0 * rs * umt;\n"
"\n"
"basisGradient[12] = 4.0 * umr - 12.0 * umr * (ss + tt) + 32.0 * st * umr;\n"
"basisGradient[13] = -4.0 * rr - 12.0 * rr * (ums - tt) + 32.0 * rt * ums;\n"
"basisGradient[14] = -4.0 * rr - 12.0 * rr * (umt - ss) + 32.0 * rs * umt;\n"
"\n"
"basisGradient[15] = 4.0 * ss - 12.0 * ss * (umr + tt) + 32.0 * st * umr;\n"
"basisGradient[16] = 4.0 * rr - 12.0 * rr * (ums + tt) + 32.0 * rt * ums;\n"
"basisGradient[17] = 32.0 * rs * umt;\n"
"\n"
"basisGradient[18] = -4.0 * ss - 12.0 * ss * (umr - tt) + 32.0 * st * umr;\n"
"basisGradient[19] = 4.0 * ums - 12.0 * ums * (rr + tt) + 32.0 * rt * ums;\n"
"basisGradient[20] = -4.0 * ss - 12.0 * ss * (umt - rr) + 32.0 * rs * umt;\n"
"\n"
"basisGradient[21] = -4.0 * tt - 12.0 * tt * (umr - ss) + 32.0 * st * umr;\n"
"basisGradient[22] = -4.0 * tt - 12.0 * tt * (ums - rr) + 32.0 * rt * ums;\n"
"basisGradient[23] = 4.0 * umt - 12.0 * umt * (rr + ss) + 32.0 * rs * umt;\n"
"\n"
"basisGradient[24] = 4.0 * tt - 12.0 * tt * (umr + ss) + 32.0 * st * umr;\n"
"basisGradient[25] = 32.0 * rt * ums;\n"
"basisGradient[26] = 4.0 * rr - 12.0 * rr * (umt + ss) + 32.0 * rs * umt;\n"
"\n"
"basisGradient[27] = 32.0 * st * umr;\n"
"basisGradient[28] = 4.0 * tt - 12.0 * tt * (rr + ums) + 32.0 * rt * ums;\n"
"basisGradient[29] = 4.0 * ss - 12.0 * ss * (rr + umt) + 32.0 * rs * umt;\n"
"\n"
"basisGradient[30] = 27.0 * ss * umr - 108.0 * st * umr;\n"
"basisGradient[31] = 27.0 * rr * ums - 108.0 * rt * ums;\n"
"basisGradient[32] = -27.0 * rs - 108.0 * rs * umt;\n"
"\n"
"basisGradient[33] = 27.0 * tt * umr - 108.0 * st * umr;\n"
"basisGradient[34] = -27.0 * rt - 108.0 * rt * ums;\n"
"basisGradient[35] = 27.0 * rr * umt - 108.0 * rs * umt;\n"
"\n"
"basisGradient[36] = 27.0 * st - 108.0 * st * umr;\n"
"basisGradient[37] = 27.0 * rt - 108.0 * rt * ums;\n"
"basisGradient[38] = 27.0 * rs - 108.0 * rs * umt;\n"
"\n"
"basisGradient[39] = -27.0 * st - 108.0 * st * umr;\n"
"basisGradient[40] = 27.0 * tt * ums - 108.0 * rt * ums;\n"
"basisGradient[41] = 27.0 * ss * umt - 108.0 * rs * umt;\n"
"\n"
"basisGradient[42] = 256.0 * st * umr;\n"
"basisGradient[43] = 256.0 * rt * ums;\n"
"basisGradient[44] = 256.0 * rs * umt;\n"
"";
