// python wrapper for vtkParallelRenderManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkParallelRenderManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkParallelRenderManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkParallelRenderManager_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkParallelRenderManager_Tags_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallel.vtkParallelRenderManager.Tags", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkParallelRenderManager_Tags_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkParallelRenderManager_Tags_Type, static_cast<int>(val));
}


static PyObject *
PyvtkParallelRenderManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkParallelRenderManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkParallelRenderManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkParallelRenderManager *tempr = vtkParallelRenderManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkParallelRenderManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkParallelRenderManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkParallelRenderManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkParallelRenderManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MakeRenderWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeRenderWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindow *tempr = (ap.IsBound() ?
      op->MakeRenderWindow() :
      op->vtkParallelRenderManager::MakeRenderWindow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MakeRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->MakeRenderer() :
      op->vtkParallelRenderManager::MakeRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetRenderWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindow *tempr = (ap.IsBound() ?
      op->GetRenderWindow() :
      op->vtkParallelRenderManager::GetRenderWindow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetRenderWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkRenderWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindow"))
  {
    if (ap.IsBound())
    {
      op->SetRenderWindow(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetRenderWindow(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkParallelRenderManager::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_InitializePieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializePieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InitializePieces();
    }
    else
    {
      op->vtkParallelRenderManager::InitializePieces();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_InitializeOffScreen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeOffScreen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InitializeOffScreen();
    }
    else
    {
      op->vtkParallelRenderManager::InitializeOffScreen();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_StartInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StartInteractor();
    }
    else
    {
      op->vtkParallelRenderManager::StartInteractor();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_StartServices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartServices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StartServices();
    }
    else
    {
      op->vtkParallelRenderManager::StartServices();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_StopServices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StopServices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StopServices();
    }
    else
    {
      op->vtkParallelRenderManager::StopServices();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_StartRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StartRender();
    }
    else
    {
      op->vtkParallelRenderManager::StartRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_EndRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EndRender();
    }
    else
    {
      op->vtkParallelRenderManager::EndRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SatelliteStartRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SatelliteStartRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SatelliteStartRender();
    }
    else
    {
      op->vtkParallelRenderManager::SatelliteStartRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SatelliteEndRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SatelliteEndRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SatelliteEndRender();
    }
    else
    {
      op->vtkParallelRenderManager::SatelliteEndRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_RenderRMI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderRMI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RenderRMI();
    }
    else
    {
      op->vtkParallelRenderManager::RenderRMI();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ResetCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->ResetCamera(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::ResetCamera(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ResetCameraClippingRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraClippingRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->ResetCameraClippingRange(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::ResetCameraClippingRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ComputeVisiblePropBoundsRMI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeVisiblePropBoundsRMI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ComputeVisiblePropBoundsRMI(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::ComputeVisiblePropBoundsRMI(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_InitializeRMIs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeRMIs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InitializeRMIs();
    }
    else
    {
      op->vtkParallelRenderManager::InitializeRMIs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ResetAllCameras(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetAllCameras");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetAllCameras();
    }
    else
    {
      op->vtkParallelRenderManager::ResetAllCameras();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ComputeVisiblePropBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeVisiblePropBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkRenderer *temp0 = nullptr;
  const size_t size1 = 6;
  double temp1[6];
  double save1[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkRenderer") &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->ComputeVisiblePropBounds(temp0, temp1);
    }
    else
    {
      op->vtkParallelRenderManager::ComputeVisiblePropBounds(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetParallelRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParallelRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetParallelRendering(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetParallelRendering(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetParallelRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParallelRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetParallelRendering() :
      op->vtkParallelRenderManager::GetParallelRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ParallelRenderingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParallelRenderingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ParallelRenderingOn();
    }
    else
    {
      op->vtkParallelRenderManager::ParallelRenderingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_ParallelRenderingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParallelRenderingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ParallelRenderingOff();
    }
    else
    {
      op->vtkParallelRenderManager::ParallelRenderingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetRenderEventPropagation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderEventPropagation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderEventPropagation(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetRenderEventPropagation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetRenderEventPropagation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderEventPropagation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRenderEventPropagation() :
      op->vtkParallelRenderManager::GetRenderEventPropagation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_RenderEventPropagationOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderEventPropagationOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RenderEventPropagationOn();
    }
    else
    {
      op->vtkParallelRenderManager::RenderEventPropagationOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_RenderEventPropagationOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderEventPropagationOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RenderEventPropagationOff();
    }
    else
    {
      op->vtkParallelRenderManager::RenderEventPropagationOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetDefaultRenderEventPropagation(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDefaultRenderEventPropagation");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkParallelRenderManager::SetDefaultRenderEventPropagation(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetDefaultRenderEventPropagation(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDefaultRenderEventPropagation");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkParallelRenderManager::GetDefaultRenderEventPropagation();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetUseCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCompositing(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetUseCompositing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetUseCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUseCompositing() :
      op->vtkParallelRenderManager::GetUseCompositing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_UseCompositingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseCompositingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseCompositingOn();
    }
    else
    {
      op->vtkParallelRenderManager::UseCompositingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_UseCompositingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseCompositingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseCompositingOff();
    }
    else
    {
      op->vtkParallelRenderManager::UseCompositingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageReductionFactor(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImageReductionFactor() :
      op->vtkParallelRenderManager::GetImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetMaxImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxImageReductionFactor(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetMaxImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetMaxImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxImageReductionFactor() :
      op->vtkParallelRenderManager::GetMaxImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetImageReductionFactorForUpdateRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageReductionFactorForUpdateRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageReductionFactorForUpdateRate(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetImageReductionFactorForUpdateRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetAutoImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoImageReductionFactor(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetAutoImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetAutoImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAutoImageReductionFactor() :
      op->vtkParallelRenderManager::GetAutoImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_AutoImageReductionFactorOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutoImageReductionFactorOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutoImageReductionFactorOn();
    }
    else
    {
      op->vtkParallelRenderManager::AutoImageReductionFactorOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_AutoImageReductionFactorOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutoImageReductionFactorOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutoImageReductionFactorOff();
    }
    else
    {
      op->vtkParallelRenderManager::AutoImageReductionFactorOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetRenderTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRenderTime() :
      op->vtkParallelRenderManager::GetRenderTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetImageProcessingTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageProcessingTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImageProcessingTime() :
      op->vtkParallelRenderManager::GetImageProcessingTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetSyncRenderWindowRenderers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSyncRenderWindowRenderers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSyncRenderWindowRenderers() :
      op->vtkParallelRenderManager::GetSyncRenderWindowRenderers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetSyncRenderWindowRenderers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSyncRenderWindowRenderers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSyncRenderWindowRenderers(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetSyncRenderWindowRenderers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SyncRenderWindowRenderersOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SyncRenderWindowRenderersOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SyncRenderWindowRenderersOn();
    }
    else
    {
      op->vtkParallelRenderManager::SyncRenderWindowRenderersOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SyncRenderWindowRenderersOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SyncRenderWindowRenderersOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SyncRenderWindowRenderersOff();
    }
    else
    {
      op->vtkParallelRenderManager::SyncRenderWindowRenderersOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_AddRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->AddRenderer(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::AddRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_RemoveRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->RemoveRenderer(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::RemoveRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_RemoveAllRenderers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllRenderers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllRenderers();
    }
    else
    {
      op->vtkParallelRenderManager::RemoveAllRenderers();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetWriteBackImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteBackImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteBackImages(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetWriteBackImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetWriteBackImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteBackImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetWriteBackImages() :
      op->vtkParallelRenderManager::GetWriteBackImages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_WriteBackImagesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteBackImagesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteBackImagesOn();
    }
    else
    {
      op->vtkParallelRenderManager::WriteBackImagesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_WriteBackImagesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteBackImagesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteBackImagesOff();
    }
    else
    {
      op->vtkParallelRenderManager::WriteBackImagesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetMagnifyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMagnifyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMagnifyImages(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetMagnifyImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetMagnifyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMagnifyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMagnifyImages() :
      op->vtkParallelRenderManager::GetMagnifyImages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MagnifyImagesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MagnifyImagesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MagnifyImagesOn();
    }
    else
    {
      op->vtkParallelRenderManager::MagnifyImagesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MagnifyImagesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MagnifyImagesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MagnifyImagesOff();
    }
    else
    {
      op->vtkParallelRenderManager::MagnifyImagesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetMagnifyImageMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMagnifyImageMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMagnifyImageMethod(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetMagnifyImageMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetMagnifyImageMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMagnifyImageMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMagnifyImageMethod() :
      op->vtkParallelRenderManager::GetMagnifyImageMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetMagnifyImageMethodToNearest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMagnifyImageMethodToNearest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMagnifyImageMethodToNearest();
    }
    else
    {
      op->vtkParallelRenderManager::SetMagnifyImageMethodToNearest();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetMagnifyImageMethodToLinear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMagnifyImageMethodToLinear");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMagnifyImageMethodToLinear();
    }
    else
    {
      op->vtkParallelRenderManager::SetMagnifyImageMethodToLinear();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MagnifyImage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MagnifyImage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkUnsignedCharArray *temp0 = nullptr;
  const size_t size1 = 2;
  int temp1[2];
  vtkUnsignedCharArray *temp2 = nullptr;
  const size_t size3 = 2;
  int temp3[2];
  size_t size4 = 0;
  int store4[4];
  int *temp4 = nullptr;
  if (ap.GetArgSize(4) > 0)
  {
    size4 = 4;
    temp4 = store4;
  }
  size_t size5 = 0;
  int store5[4];
  int *temp5 = nullptr;
  if (ap.GetArgSize(5) > 0)
  {
    size5 = 4;
    temp5 = store5;
  }
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4, 6) &&
      ap.GetVTKObject(temp0, "vtkUnsignedCharArray") &&
      ap.GetArray(temp1, size1) &&
      ap.GetVTKObject(temp2, "vtkUnsignedCharArray") &&
      ap.GetArray(temp3, size3) &&
      (ap.NoArgsLeft() || ap.GetArray(temp4, size4)) &&
      (ap.NoArgsLeft() || ap.GetArray(temp5, size5)))
  {
    if (ap.IsBound())
    {
      op->MagnifyImage(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkParallelRenderManager::MagnifyImage(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MagnifyImageNearest(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MagnifyImageNearest");

  vtkUnsignedCharArray *temp0 = nullptr;
  const size_t size1 = 2;
  int temp1[2];
  vtkUnsignedCharArray *temp2 = nullptr;
  const size_t size3 = 2;
  int temp3[2];
  size_t size4 = 0;
  int store4[4];
  int *temp4 = nullptr;
  if (ap.GetArgSize(4) > 0)
  {
    size4 = 4;
    temp4 = store4;
  }
  size_t size5 = 0;
  int store5[4];
  int *temp5 = nullptr;
  if (ap.GetArgSize(5) > 0)
  {
    size5 = 4;
    temp5 = store5;
  }
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 6) &&
      ap.GetVTKObject(temp0, "vtkUnsignedCharArray") &&
      ap.GetArray(temp1, size1) &&
      ap.GetVTKObject(temp2, "vtkUnsignedCharArray") &&
      ap.GetArray(temp3, size3) &&
      (ap.NoArgsLeft() || ap.GetArray(temp4, size4)) &&
      (ap.NoArgsLeft() || ap.GetArray(temp5, size5)))
  {
    vtkParallelRenderManager::MagnifyImageNearest(temp0, temp1, temp2, temp3, temp4, temp5);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_MagnifyImageLinear(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MagnifyImageLinear");

  vtkUnsignedCharArray *temp0 = nullptr;
  const size_t size1 = 2;
  int temp1[2];
  vtkUnsignedCharArray *temp2 = nullptr;
  const size_t size3 = 2;
  int temp3[2];
  size_t size4 = 0;
  int store4[4];
  int *temp4 = nullptr;
  if (ap.GetArgSize(4) > 0)
  {
    size4 = 4;
    temp4 = store4;
  }
  size_t size5 = 0;
  int store5[4];
  int *temp5 = nullptr;
  if (ap.GetArgSize(5) > 0)
  {
    size5 = 4;
    temp5 = store5;
  }
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 6) &&
      ap.GetVTKObject(temp0, "vtkUnsignedCharArray") &&
      ap.GetArray(temp1, size1) &&
      ap.GetVTKObject(temp2, "vtkUnsignedCharArray") &&
      ap.GetArray(temp3, size3) &&
      (ap.NoArgsLeft() || ap.GetArray(temp4, size4)) &&
      (ap.NoArgsLeft() || ap.GetArray(temp5, size5)))
  {
    vtkParallelRenderManager::MagnifyImageLinear(temp0, temp1, temp2, temp3, temp4, temp5);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetPixelData_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPixelData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkUnsignedCharArray *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkUnsignedCharArray"))
  {
    if (ap.IsBound())
    {
      op->GetPixelData(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::GetPixelData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelRenderManager_GetPixelData_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPixelData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  vtkUnsignedCharArray *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkUnsignedCharArray"))
  {
    if (ap.IsBound())
    {
      op->GetPixelData(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkParallelRenderManager::GetPixelData(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelRenderManager_GetPixelData(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkParallelRenderManager_GetPixelData_s1(self, args);
    case 5:
      return PyvtkParallelRenderManager_GetPixelData_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetPixelData");
  return nullptr;
}


static PyObject *
PyvtkParallelRenderManager_GetReducedPixelData_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReducedPixelData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  vtkUnsignedCharArray *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkUnsignedCharArray"))
  {
    if (ap.IsBound())
    {
      op->GetReducedPixelData(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::GetReducedPixelData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelRenderManager_GetReducedPixelData_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReducedPixelData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  vtkUnsignedCharArray *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkUnsignedCharArray"))
  {
    if (ap.IsBound())
    {
      op->GetReducedPixelData(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkParallelRenderManager::GetReducedPixelData(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelRenderManager_GetReducedPixelData(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkParallelRenderManager_GetReducedPixelData_s1(self, args);
    case 5:
      return PyvtkParallelRenderManager_GetReducedPixelData_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetReducedPixelData");
  return nullptr;
}


static PyObject *
PyvtkParallelRenderManager_GetFullImageSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullImageSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetFullImageSize() :
      op->vtkParallelRenderManager::GetFullImageSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetReducedImageSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReducedImageSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetReducedImageSize() :
      op->vtkParallelRenderManager::GetReducedImageSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_TileWindows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TileWindows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->TileWindows(temp0, temp1, temp2);
    }
    else
    {
      op->vtkParallelRenderManager::TileWindows(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetUseRGBA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseRGBA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseRGBA(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetUseRGBA(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetUseRGBA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseRGBA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUseRGBA() :
      op->vtkParallelRenderManager::GetUseRGBA());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetForceRenderWindowSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceRenderWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceRenderWindowSize(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetForceRenderWindowSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetForceRenderWindowSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceRenderWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetForceRenderWindowSize() :
      op->vtkParallelRenderManager::GetForceRenderWindowSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetForcedRenderWindowSize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForcedRenderWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetForcedRenderWindowSize(temp0, temp1);
    }
    else
    {
      op->vtkParallelRenderManager::SetForcedRenderWindowSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelRenderManager_SetForcedRenderWindowSize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForcedRenderWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetForcedRenderWindowSize(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetForcedRenderWindowSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelRenderManager_SetForcedRenderWindowSize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkParallelRenderManager_SetForcedRenderWindowSize_s1(self, args);
    case 1:
      return PyvtkParallelRenderManager_SetForcedRenderWindowSize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetForcedRenderWindowSize");
  return nullptr;
}


static PyObject *
PyvtkParallelRenderManager_GetForcedRenderWindowSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForcedRenderWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetForcedRenderWindowSize() :
      op->vtkParallelRenderManager::GetForcedRenderWindowSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_CheckForAbortRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CheckForAbortRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CheckForAbortRender();
    }
    else
    {
      op->vtkParallelRenderManager::CheckForAbortRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_CheckForAbortComposite(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CheckForAbortComposite");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->CheckForAbortComposite() :
      op->vtkParallelRenderManager::CheckForAbortComposite());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetUseBackBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseBackBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseBackBuffer(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetUseBackBuffer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetUseBackBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseBackBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUseBackBuffer() :
      op->vtkParallelRenderManager::GetUseBackBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_UseBackBufferOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseBackBufferOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseBackBufferOn();
    }
    else
    {
      op->vtkParallelRenderManager::UseBackBufferOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_UseBackBufferOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseBackBufferOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseBackBufferOff();
    }
    else
    {
      op->vtkParallelRenderManager::UseBackBufferOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SetSynchronizeTileProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSynchronizeTileProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSynchronizeTileProperties(temp0);
    }
    else
    {
      op->vtkParallelRenderManager::SetSynchronizeTileProperties(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GetSynchronizeTileProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSynchronizeTileProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSynchronizeTileProperties() :
      op->vtkParallelRenderManager::GetSynchronizeTileProperties());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SynchronizeTilePropertiesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeTilePropertiesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeTilePropertiesOn();
    }
    else
    {
      op->vtkParallelRenderManager::SynchronizeTilePropertiesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_SynchronizeTilePropertiesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeTilePropertiesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeTilePropertiesOff();
    }
    else
    {
      op->vtkParallelRenderManager::SynchronizeTilePropertiesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GenericStartRenderCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenericStartRenderCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenericStartRenderCallback();
    }
    else
    {
      op->vtkParallelRenderManager::GenericStartRenderCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelRenderManager_GenericEndRenderCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenericEndRenderCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelRenderManager *op = static_cast<vtkParallelRenderManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenericEndRenderCallback();
    }
    else
    {
      op->vtkParallelRenderManager::GenericEndRenderCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkParallelRenderManager_Methods[] = {
  {"IsTypeOf", PyvtkParallelRenderManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkParallelRenderManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkParallelRenderManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkParallelRenderManager\nC++: static vtkParallelRenderManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkParallelRenderManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkParallelRenderManager\nC++: vtkParallelRenderManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkParallelRenderManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkParallelRenderManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"MakeRenderWindow", PyvtkParallelRenderManager_MakeRenderWindow, METH_VARARGS,
   "MakeRenderWindow(self) -> vtkRenderWindow\nC++: virtual vtkRenderWindow *MakeRenderWindow()\n\nBuilds a vtkRenderWindow compatible with this render manager. \nThe user program is responsible for registering the render window\nwith the SetRenderWindow method and calling Delete.  It is not\nadvisable to use a parallel render manager with a render window\nthat was not built with this method.\n"},
  {"MakeRenderer", PyvtkParallelRenderManager_MakeRenderer, METH_VARARGS,
   "MakeRenderer(self) -> vtkRenderer\nC++: virtual vtkRenderer *MakeRenderer()\n\nBuilds a vtkRenderer compatible with this render manager. \n(Should we also register it?)  The user program is responsible\nfor calling Delete.  It is not advisable to use a parallel render\nmanager with a renderer that was not built with this method.\n"},
  {"GetRenderWindow", PyvtkParallelRenderManager_GetRenderWindow, METH_VARARGS,
   "GetRenderWindow(self) -> vtkRenderWindow\nC++: virtual vtkRenderWindow *GetRenderWindow()\n\nSet/Get the RenderWindow to use for compositing. We add a start\nand end observer to the window.\n"},
  {"SetRenderWindow", PyvtkParallelRenderManager_SetRenderWindow, METH_VARARGS,
   "SetRenderWindow(self, renWin:vtkRenderWindow) -> None\nC++: virtual void SetRenderWindow(vtkRenderWindow *renWin)\n\n"},
  {"GetController", PyvtkParallelRenderManager_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\nSet/Get the vtkMultiProcessController which will handle\ncommunications for the parallel rendering.\n"},
  {"SetController", PyvtkParallelRenderManager_SetController, METH_VARARGS,
   "SetController(self, controller:vtkMultiProcessController) -> None\nC++: virtual void SetController(\n    vtkMultiProcessController *controller)\n\n"},
  {"InitializePieces", PyvtkParallelRenderManager_InitializePieces, METH_VARARGS,
   "InitializePieces(self) -> None\nC++: virtual void InitializePieces()\n\nThis method sets the piece and number of pieces for each actor\nwith a polydata mapper.\n"},
  {"InitializeOffScreen", PyvtkParallelRenderManager_InitializeOffScreen, METH_VARARGS,
   "InitializeOffScreen(self) -> None\nC++: virtual void InitializeOffScreen()\n\nMake all rendering windows not viewable set as off screen\nrendering. To make all renderwindows on screen rendering again,\ncall OffScreenRenderingOff on all the render windows.  This class\nassumes the window on root node is the only one viewable. \nSubclasses should change this as necessary.\n"},
  {"StartInteractor", PyvtkParallelRenderManager_StartInteractor, METH_VARARGS,
   "StartInteractor(self) -> None\nC++: virtual void StartInteractor()\n\nInitializes the RMIs and then, if on root node, starts the\ninteractor on the attached render window.  Otherwise, starts\nprocessing RMIs. When the interactor returns, it breaks the RMI\nlistening on all other processors.\n"},
  {"StartServices", PyvtkParallelRenderManager_StartServices, METH_VARARGS,
   "StartServices(self) -> None\nC++: virtual void StartServices()\n\nIf on node other than root, starts serving RMI requests for\nparallel renders.\n"},
  {"StopServices", PyvtkParallelRenderManager_StopServices, METH_VARARGS,
   "StopServices(self) -> None\nC++: virtual void StopServices()\n\nIf on root node, stops the RMI processing on all service nodes.\n"},
  {"StartRender", PyvtkParallelRenderManager_StartRender, METH_VARARGS,
   "StartRender(self) -> None\nC++: virtual void StartRender()\n\nCallbacks that initialize and finish rendering and other tasks.\n"},
  {"EndRender", PyvtkParallelRenderManager_EndRender, METH_VARARGS,
   "EndRender(self) -> None\nC++: virtual void EndRender()\n\n"},
  {"SatelliteStartRender", PyvtkParallelRenderManager_SatelliteStartRender, METH_VARARGS,
   "SatelliteStartRender(self) -> None\nC++: virtual void SatelliteStartRender()\n\n"},
  {"SatelliteEndRender", PyvtkParallelRenderManager_SatelliteEndRender, METH_VARARGS,
   "SatelliteEndRender(self) -> None\nC++: virtual void SatelliteEndRender()\n\n"},
  {"RenderRMI", PyvtkParallelRenderManager_RenderRMI, METH_VARARGS,
   "RenderRMI(self) -> None\nC++: virtual void RenderRMI()\n\n"},
  {"ResetCamera", PyvtkParallelRenderManager_ResetCamera, METH_VARARGS,
   "ResetCamera(self, ren:vtkRenderer) -> None\nC++: virtual void ResetCamera(vtkRenderer *ren)\n\n"},
  {"ResetCameraClippingRange", PyvtkParallelRenderManager_ResetCameraClippingRange, METH_VARARGS,
   "ResetCameraClippingRange(self, ren:vtkRenderer) -> None\nC++: virtual void ResetCameraClippingRange(vtkRenderer *ren)\n\n"},
  {"ComputeVisiblePropBoundsRMI", PyvtkParallelRenderManager_ComputeVisiblePropBoundsRMI, METH_VARARGS,
   "ComputeVisiblePropBoundsRMI(self, renderId:int) -> None\nC++: virtual void ComputeVisiblePropBoundsRMI(int renderId)\n\n"},
  {"InitializeRMIs", PyvtkParallelRenderManager_InitializeRMIs, METH_VARARGS,
   "InitializeRMIs(self) -> None\nC++: virtual void InitializeRMIs()\n\n"},
  {"ResetAllCameras", PyvtkParallelRenderManager_ResetAllCameras, METH_VARARGS,
   "ResetAllCameras(self) -> None\nC++: virtual void ResetAllCameras()\n\nResets the camera of each renderer contained in the RenderWindow.\nShould only be called in the \"root\" process, and all remote\nprocesses must be processing RMIs for this method to complete.\n"},
  {"ComputeVisiblePropBounds", PyvtkParallelRenderManager_ComputeVisiblePropBounds, METH_VARARGS,
   "ComputeVisiblePropBounds(self, ren:vtkRenderer, bounds:[float,\n    float, float, float, float, float]) -> None\nC++: virtual void ComputeVisiblePropBounds(vtkRenderer *ren,\n    double bounds[6])\n\nCalculates the bounds by gathering information from all\nprocesses.\n"},
  {"SetParallelRendering", PyvtkParallelRenderManager_SetParallelRendering, METH_VARARGS,
   "SetParallelRendering(self, _arg:int) -> None\nC++: virtual void SetParallelRendering(int _arg)\n\nTurns on/off parallel rendering.  When on (the default) the\nobject responds to render events of the attached window,\npropagates the render event to other processors, and otherwise\nenables the parallel rendering process.\n"},
  {"GetParallelRendering", PyvtkParallelRenderManager_GetParallelRendering, METH_VARARGS,
   "GetParallelRendering(self) -> int\nC++: virtual int GetParallelRendering()\n\n"},
  {"ParallelRenderingOn", PyvtkParallelRenderManager_ParallelRenderingOn, METH_VARARGS,
   "ParallelRenderingOn(self) -> None\nC++: virtual void ParallelRenderingOn()\n\n"},
  {"ParallelRenderingOff", PyvtkParallelRenderManager_ParallelRenderingOff, METH_VARARGS,
   "ParallelRenderingOff(self) -> None\nC++: virtual void ParallelRenderingOff()\n\n"},
  {"SetRenderEventPropagation", PyvtkParallelRenderManager_SetRenderEventPropagation, METH_VARARGS,
   "SetRenderEventPropagation(self, _arg:int) -> None\nC++: virtual void SetRenderEventPropagation(int _arg)\n\nTurns on/off render event propagation.  When on (the default) and\nParallelRendering is on, process 0 will send an RMI call to all\nremote processes to perform a synchronized render.  When off,\nrender must be manually called on each process.\n"},
  {"GetRenderEventPropagation", PyvtkParallelRenderManager_GetRenderEventPropagation, METH_VARARGS,
   "GetRenderEventPropagation(self) -> int\nC++: virtual int GetRenderEventPropagation()\n\n"},
  {"RenderEventPropagationOn", PyvtkParallelRenderManager_RenderEventPropagationOn, METH_VARARGS,
   "RenderEventPropagationOn(self) -> None\nC++: virtual void RenderEventPropagationOn()\n\n"},
  {"RenderEventPropagationOff", PyvtkParallelRenderManager_RenderEventPropagationOff, METH_VARARGS,
   "RenderEventPropagationOff(self) -> None\nC++: virtual void RenderEventPropagationOff()\n\n"},
  {"SetDefaultRenderEventPropagation", PyvtkParallelRenderManager_SetDefaultRenderEventPropagation, METH_VARARGS,
   "SetDefaultRenderEventPropagation(val:bool) -> None\nC++: static void SetDefaultRenderEventPropagation(bool val)\n\nGet/Set the default value used for RenderEventPropagation when a\nnew instance of vtkParallelRenderManager is created. Set to true\nby default.\n"},
  {"GetDefaultRenderEventPropagation", PyvtkParallelRenderManager_GetDefaultRenderEventPropagation, METH_VARARGS,
   "GetDefaultRenderEventPropagation() -> bool\nC++: static bool GetDefaultRenderEventPropagation()\n\n"},
  {"SetUseCompositing", PyvtkParallelRenderManager_SetUseCompositing, METH_VARARGS,
   "SetUseCompositing(self, _arg:int) -> None\nC++: virtual void SetUseCompositing(int _arg)\n\nThis is used for tiled display rendering.  When data has been\nduplicated on all processes, then we do not need to compositing.\nCameras and renders are still propagated though.\n"},
  {"GetUseCompositing", PyvtkParallelRenderManager_GetUseCompositing, METH_VARARGS,
   "GetUseCompositing(self) -> int\nC++: virtual int GetUseCompositing()\n\n"},
  {"UseCompositingOn", PyvtkParallelRenderManager_UseCompositingOn, METH_VARARGS,
   "UseCompositingOn(self) -> None\nC++: virtual void UseCompositingOn()\n\n"},
  {"UseCompositingOff", PyvtkParallelRenderManager_UseCompositingOff, METH_VARARGS,
   "UseCompositingOff(self) -> None\nC++: virtual void UseCompositingOff()\n\n"},
  {"SetImageReductionFactor", PyvtkParallelRenderManager_SetImageReductionFactor, METH_VARARGS,
   "SetImageReductionFactor(self, factor:float) -> None\nC++: virtual void SetImageReductionFactor(double factor)\n\nSet/Get the reduction factor (for sort-last based parallel\nrenderers). The size of rendered image is divided by the\nreduction factor and then is blown up to the size of the current\nvtkRenderWindow.  Setting higher reduction factors enables\nshorter image transfer times (which is often the bottleneck) but\nwill greatly reduce image quality.  A reduction factor of 2 or\ngreater should only be used for intermediate images in\ninteractive applications.  A reduction factor of 1 (or less) will\nresult in no change in image quality.  A parallel render manager\nmay ignore the image reduction factor if it will result in little\nor no performance enhancements (eg. it does not do image space\nmanipulations).\n"},
  {"GetImageReductionFactor", PyvtkParallelRenderManager_GetImageReductionFactor, METH_VARARGS,
   "GetImageReductionFactor(self) -> float\nC++: virtual double GetImageReductionFactor()\n\n"},
  {"SetMaxImageReductionFactor", PyvtkParallelRenderManager_SetMaxImageReductionFactor, METH_VARARGS,
   "SetMaxImageReductionFactor(self, _arg:float) -> None\nC++: virtual void SetMaxImageReductionFactor(double _arg)\n\n"},
  {"GetMaxImageReductionFactor", PyvtkParallelRenderManager_GetMaxImageReductionFactor, METH_VARARGS,
   "GetMaxImageReductionFactor(self) -> float\nC++: virtual double GetMaxImageReductionFactor()\n\n"},
  {"SetImageReductionFactorForUpdateRate", PyvtkParallelRenderManager_SetImageReductionFactorForUpdateRate, METH_VARARGS,
   "SetImageReductionFactorForUpdateRate(self,\n    DesiredUpdateRate:float) -> None\nC++: virtual void SetImageReductionFactorForUpdateRate(\n    double DesiredUpdateRate)\n\nSets the ReductionFactor based on the given desired update rate\nand the rendering metrics taken from the last time\nUpdateServerInfo was called.  Note that if AutoReductionFactor is\non, this function is called with the desired update rate of the\nrender window automatically.\n"},
  {"SetAutoImageReductionFactor", PyvtkParallelRenderManager_SetAutoImageReductionFactor, METH_VARARGS,
   "SetAutoImageReductionFactor(self, _arg:int) -> None\nC++: virtual void SetAutoImageReductionFactor(int _arg)\n\nIf on, the ReductionFactor is automatically adjusted to best meet\nthe the DesiredUpdateRate in the current RenderWindow based on\nmetrics from the last render.\n"},
  {"GetAutoImageReductionFactor", PyvtkParallelRenderManager_GetAutoImageReductionFactor, METH_VARARGS,
   "GetAutoImageReductionFactor(self) -> int\nC++: virtual int GetAutoImageReductionFactor()\n\n"},
  {"AutoImageReductionFactorOn", PyvtkParallelRenderManager_AutoImageReductionFactorOn, METH_VARARGS,
   "AutoImageReductionFactorOn(self) -> None\nC++: virtual void AutoImageReductionFactorOn()\n\n"},
  {"AutoImageReductionFactorOff", PyvtkParallelRenderManager_AutoImageReductionFactorOff, METH_VARARGS,
   "AutoImageReductionFactorOff(self) -> None\nC++: virtual void AutoImageReductionFactorOff()\n\n"},
  {"GetRenderTime", PyvtkParallelRenderManager_GetRenderTime, METH_VARARGS,
   "GetRenderTime(self) -> float\nC++: virtual double GetRenderTime()\n\nGet rendering metrics.\n"},
  {"GetImageProcessingTime", PyvtkParallelRenderManager_GetImageProcessingTime, METH_VARARGS,
   "GetImageProcessingTime(self) -> float\nC++: virtual double GetImageProcessingTime()\n\n"},
  {"GetSyncRenderWindowRenderers", PyvtkParallelRenderManager_GetSyncRenderWindowRenderers, METH_VARARGS,
   "GetSyncRenderWindowRenderers(self) -> int\nC++: virtual int GetSyncRenderWindowRenderers()\n\nBy default, the state of all renderers in the root's render\nwindow is propagated to the rest of the processes.  In order for\nthis to work, all render windows must have the same renderers in\nthe same order.  If this is not the case, you can turn off the\nSyncRenderWindowRenderers.  When this flag is off, the list of\nrenderers held by this parallel render manager (initially empty)\nis synced.  You can modify the list of renderers with the\nAddRenderer, RemoveRenderer, and RemoveAllRenderers methods.\n"},
  {"SetSyncRenderWindowRenderers", PyvtkParallelRenderManager_SetSyncRenderWindowRenderers, METH_VARARGS,
   "SetSyncRenderWindowRenderers(self, _arg:int) -> None\nC++: virtual void SetSyncRenderWindowRenderers(int _arg)\n\n"},
  {"SyncRenderWindowRenderersOn", PyvtkParallelRenderManager_SyncRenderWindowRenderersOn, METH_VARARGS,
   "SyncRenderWindowRenderersOn(self) -> None\nC++: virtual void SyncRenderWindowRenderersOn()\n\n"},
  {"SyncRenderWindowRenderersOff", PyvtkParallelRenderManager_SyncRenderWindowRenderersOff, METH_VARARGS,
   "SyncRenderWindowRenderersOff(self) -> None\nC++: virtual void SyncRenderWindowRenderersOff()\n\n"},
  {"AddRenderer", PyvtkParallelRenderManager_AddRenderer, METH_VARARGS,
   "AddRenderer(self, __a:vtkRenderer) -> None\nC++: virtual void AddRenderer(vtkRenderer *)\n\n"},
  {"RemoveRenderer", PyvtkParallelRenderManager_RemoveRenderer, METH_VARARGS,
   "RemoveRenderer(self, __a:vtkRenderer) -> None\nC++: virtual void RemoveRenderer(vtkRenderer *)\n\n"},
  {"RemoveAllRenderers", PyvtkParallelRenderManager_RemoveAllRenderers, METH_VARARGS,
   "RemoveAllRenderers(self) -> None\nC++: virtual void RemoveAllRenderers()\n\n"},
  {"SetWriteBackImages", PyvtkParallelRenderManager_SetWriteBackImages, METH_VARARGS,
   "SetWriteBackImages(self, _arg:int) -> None\nC++: virtual void SetWriteBackImages(int _arg)\n\nIf on (the default), the result of any image space manipulations\nare written back to the render window frame buffer.  If off, the\nimage stored in the frame buffer may not be correct.  Either way,\nthe correct frame buffer images may be read with\nvtkParallelRenderManager::GetPixelData.  Turning WriteBackImages\noff may result in a speedup if the render window is not visible\nto the user and images are read back for further processing or\ntransit.\n"},
  {"GetWriteBackImages", PyvtkParallelRenderManager_GetWriteBackImages, METH_VARARGS,
   "GetWriteBackImages(self) -> int\nC++: virtual int GetWriteBackImages()\n\n"},
  {"WriteBackImagesOn", PyvtkParallelRenderManager_WriteBackImagesOn, METH_VARARGS,
   "WriteBackImagesOn(self) -> None\nC++: virtual void WriteBackImagesOn()\n\n"},
  {"WriteBackImagesOff", PyvtkParallelRenderManager_WriteBackImagesOff, METH_VARARGS,
   "WriteBackImagesOff(self) -> None\nC++: virtual void WriteBackImagesOff()\n\n"},
  {"SetMagnifyImages", PyvtkParallelRenderManager_SetMagnifyImages, METH_VARARGS,
   "SetMagnifyImages(self, _arg:int) -> None\nC++: virtual void SetMagnifyImages(int _arg)\n\nIf on (the default), when the ImageReductionFactor is greater\nthan 1 and WriteBackImages is on, the image will be magnified to\nfill the entire render window.\n"},
  {"GetMagnifyImages", PyvtkParallelRenderManager_GetMagnifyImages, METH_VARARGS,
   "GetMagnifyImages(self) -> int\nC++: virtual int GetMagnifyImages()\n\n"},
  {"MagnifyImagesOn", PyvtkParallelRenderManager_MagnifyImagesOn, METH_VARARGS,
   "MagnifyImagesOn(self) -> None\nC++: virtual void MagnifyImagesOn()\n\n"},
  {"MagnifyImagesOff", PyvtkParallelRenderManager_MagnifyImagesOff, METH_VARARGS,
   "MagnifyImagesOff(self) -> None\nC++: virtual void MagnifyImagesOff()\n\n"},
  {"SetMagnifyImageMethod", PyvtkParallelRenderManager_SetMagnifyImageMethod, METH_VARARGS,
   "SetMagnifyImageMethod(self, method:int) -> None\nC++: virtual void SetMagnifyImageMethod(int method)\n\nSets the method used to magnify images.  Nearest simply\nreplicates each pixel enough times to fill the image.  Linear\nperforms linear interpolation between the pixels.\n"},
  {"GetMagnifyImageMethod", PyvtkParallelRenderManager_GetMagnifyImageMethod, METH_VARARGS,
   "GetMagnifyImageMethod(self) -> int\nC++: virtual int GetMagnifyImageMethod()\n\n"},
  {"SetMagnifyImageMethodToNearest", PyvtkParallelRenderManager_SetMagnifyImageMethodToNearest, METH_VARARGS,
   "SetMagnifyImageMethodToNearest(self) -> None\nC++: void SetMagnifyImageMethodToNearest()\n\n"},
  {"SetMagnifyImageMethodToLinear", PyvtkParallelRenderManager_SetMagnifyImageMethodToLinear, METH_VARARGS,
   "SetMagnifyImageMethodToLinear(self) -> None\nC++: void SetMagnifyImageMethodToLinear()\n\n"},
  {"MagnifyImage", PyvtkParallelRenderManager_MagnifyImage, METH_VARARGS,
   "MagnifyImage(self, fullImage:vtkUnsignedCharArray, fullImageSize:(\n    int, int), reducedImage:vtkUnsignedCharArray,\n    reducedImageSize:(int, int), fullImageViewport:(int, int, int,\n     int)=..., reducedImageViewport:(int, int, int, int)=...)\n    -> None\nC++: virtual void MagnifyImage(vtkUnsignedCharArray *fullImage,\n    const int fullImageSize[2],\n    vtkUnsignedCharArray *reducedImage,\n    const int reducedImageSize[2],\n    const int fullImageViewport[4]=nullptr,\n    const int reducedImageViewport[4]=nullptr)\n\nConvenience functions for magnifying images.\n"},
  {"MagnifyImageNearest", PyvtkParallelRenderManager_MagnifyImageNearest, METH_VARARGS,
   "MagnifyImageNearest(fullImage:vtkUnsignedCharArray,\n    fullImageSize:(int, int), reducedImage:vtkUnsignedCharArray,\n    reducedImageSize:(int, int), fullImageViewport:(int, int, int,\n     int)=..., reducedImageViewport:(int, int, int, int)=...)\n    -> None\nC++: static void MagnifyImageNearest(\n    vtkUnsignedCharArray *fullImage, const int fullImageSize[2],\n    vtkUnsignedCharArray *reducedImage,\n    const int reducedImageSize[2],\n    const int fullImageViewport[4]=nullptr,\n    const int reducedImageViewport[4]=nullptr)\n\n"},
  {"MagnifyImageLinear", PyvtkParallelRenderManager_MagnifyImageLinear, METH_VARARGS,
   "MagnifyImageLinear(fullImage:vtkUnsignedCharArray, fullImageSize:(\n    int, int), reducedImage:vtkUnsignedCharArray,\n    reducedImageSize:(int, int), fullImageViewport:(int, int, int,\n     int)=..., reducedImageViewport:(int, int, int, int)=...)\n    -> None\nC++: static void MagnifyImageLinear(\n    vtkUnsignedCharArray *fullImage, const int fullImageSize[2],\n    vtkUnsignedCharArray *reducedImage,\n    const int reducedImageSize[2],\n    const int fullImageViewport[4]=nullptr,\n    const int reducedImageViewport[4]=nullptr)\n\n"},
  {"GetPixelData", PyvtkParallelRenderManager_GetPixelData, METH_VARARGS,
   "GetPixelData(self, data:vtkUnsignedCharArray) -> None\nC++: virtual void GetPixelData(vtkUnsignedCharArray *data)\nGetPixelData(self, x1:int, y1:int, x2:int, y2:int,\n    data:vtkUnsignedCharArray) -> None\nC++: virtual void GetPixelData(int x1, int y1, int x2, int y2,\n    vtkUnsignedCharArray *data)\n\nThe most appropriate way to retrieve full size image data after a\nrender.  Will work regardless of whether WriteBackImages or\nMagnifyImage is on or off.  The data returned may be a shallow\ncopy of an internal array.  Therefore, the data may be invalid\nafter the next render or if the ParallelRenderManager is\ndestroyed.\n"},
  {"GetReducedPixelData", PyvtkParallelRenderManager_GetReducedPixelData, METH_VARARGS,
   "GetReducedPixelData(self, data:vtkUnsignedCharArray) -> None\nC++: virtual void GetReducedPixelData(vtkUnsignedCharArray *data)\nGetReducedPixelData(self, x1:int, y1:int, x2:int, y2:int,\n    data:vtkUnsignedCharArray) -> None\nC++: virtual void GetReducedPixelData(int x1, int y1, int x2,\n    int y2, vtkUnsignedCharArray *data)\n\nThe most appropriate way to retrieve reduced size image data\nafter a render.  Will work regardless of whether WriteBackImages\nor MagnifyImage is on or off.  The data returned may be a shallow\ncopy of an internal array.  Therefore, the data may be invalid\nafter the next render or if the ParallelRenderManager is\ndestroyed.\n"},
  {"GetFullImageSize", PyvtkParallelRenderManager_GetFullImageSize, METH_VARARGS,
   "GetFullImageSize(self) -> (int, int)\nC++: virtual int *GetFullImageSize()\n\nReturns the full image size calculated at the last render.\n"},
  {"GetReducedImageSize", PyvtkParallelRenderManager_GetReducedImageSize, METH_VARARGS,
   "GetReducedImageSize(self) -> (int, int)\nC++: virtual int *GetReducedImageSize()\n\nReturns the reduced image size calculated at the last render.\n"},
  {"TileWindows", PyvtkParallelRenderManager_TileWindows, METH_VARARGS,
   "TileWindows(self, xsize:int, ysize:int, nColumns:int) -> None\nC++: void TileWindows(int xsize, int ysize, int nColumns)\n\nGiven the x and y size of the render windows, reposition them in\na tile of n columns.\n"},
  {"SetUseRGBA", PyvtkParallelRenderManager_SetUseRGBA, METH_VARARGS,
   "SetUseRGBA(self, _arg:int) -> None\nC++: virtual void SetUseRGBA(int _arg)\n\nGet/Set if all Images must use RGBA instead of RGB. By default,\nthis flag is on.\n"},
  {"GetUseRGBA", PyvtkParallelRenderManager_GetUseRGBA, METH_VARARGS,
   "GetUseRGBA(self) -> int\nC++: virtual int GetUseRGBA()\n\n"},
  {"SetForceRenderWindowSize", PyvtkParallelRenderManager_SetForceRenderWindowSize, METH_VARARGS,
   "SetForceRenderWindowSize(self, _arg:int) -> None\nC++: virtual void SetForceRenderWindowSize(int _arg)\n\nIf ForceRenderWindowSize is set to true, the render manager will\nuse the RenderWindowSize ivar instead of getting the size from\nthe render window.\n"},
  {"GetForceRenderWindowSize", PyvtkParallelRenderManager_GetForceRenderWindowSize, METH_VARARGS,
   "GetForceRenderWindowSize(self) -> int\nC++: virtual int GetForceRenderWindowSize()\n\n"},
  {"SetForcedRenderWindowSize", PyvtkParallelRenderManager_SetForcedRenderWindowSize, METH_VARARGS,
   "SetForcedRenderWindowSize(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetForcedRenderWindowSize(int _arg1, int _arg2)\nSetForcedRenderWindowSize(self, _arg:(int, int)) -> None\nC++: void SetForcedRenderWindowSize(const int _arg[2])\n\nIf ForceRenderWindowSize is set to true, the render manager will\nuse the Size ivar instead of getting the size from the render\nwindow.\n"},
  {"GetForcedRenderWindowSize", PyvtkParallelRenderManager_GetForcedRenderWindowSize, METH_VARARGS,
   "GetForcedRenderWindowSize(self) -> (int, int)\nC++: virtual int *GetForcedRenderWindowSize()\n\n"},
  {"CheckForAbortRender", PyvtkParallelRenderManager_CheckForAbortRender, METH_VARARGS,
   "CheckForAbortRender(self) -> None\nC++: virtual void CheckForAbortRender()\n\n"},
  {"CheckForAbortComposite", PyvtkParallelRenderManager_CheckForAbortComposite, METH_VARARGS,
   "CheckForAbortComposite(self) -> int\nC++: virtual int CheckForAbortComposite()\n\n"},
  {"SetUseBackBuffer", PyvtkParallelRenderManager_SetUseBackBuffer, METH_VARARGS,
   "SetUseBackBuffer(self, _arg:int) -> None\nC++: virtual void SetUseBackBuffer(int _arg)\n\nThe default is to allow the use of the back buffer for\ncompositing. If set to false, this will prevent to manager from\nswapping buffers. This allows something else (for instance\nVisibleCellSelection) to control front/back buffer swapping.\n"},
  {"GetUseBackBuffer", PyvtkParallelRenderManager_GetUseBackBuffer, METH_VARARGS,
   "GetUseBackBuffer(self) -> int\nC++: virtual int GetUseBackBuffer()\n\n"},
  {"UseBackBufferOn", PyvtkParallelRenderManager_UseBackBufferOn, METH_VARARGS,
   "UseBackBufferOn(self) -> None\nC++: virtual void UseBackBufferOn()\n\n"},
  {"UseBackBufferOff", PyvtkParallelRenderManager_UseBackBufferOff, METH_VARARGS,
   "UseBackBufferOff(self) -> None\nC++: virtual void UseBackBufferOff()\n\n"},
  {"SetSynchronizeTileProperties", PyvtkParallelRenderManager_SetSynchronizeTileProperties, METH_VARARGS,
   "SetSynchronizeTileProperties(self, _arg:int) -> None\nC++: virtual void SetSynchronizeTileProperties(int _arg)\n\nWhen set the render manager will synchronize the TileViewport and\nTileScale properties. This may not be desirable in cases where\nthere's some other mechanism to set the tile dimensions eg. Tile\ndisplays.\n"},
  {"GetSynchronizeTileProperties", PyvtkParallelRenderManager_GetSynchronizeTileProperties, METH_VARARGS,
   "GetSynchronizeTileProperties(self) -> int\nC++: virtual int GetSynchronizeTileProperties()\n\n"},
  {"SynchronizeTilePropertiesOn", PyvtkParallelRenderManager_SynchronizeTilePropertiesOn, METH_VARARGS,
   "SynchronizeTilePropertiesOn(self) -> None\nC++: virtual void SynchronizeTilePropertiesOn()\n\n"},
  {"SynchronizeTilePropertiesOff", PyvtkParallelRenderManager_SynchronizeTilePropertiesOff, METH_VARARGS,
   "SynchronizeTilePropertiesOff(self) -> None\nC++: virtual void SynchronizeTilePropertiesOff()\n\n"},
  {"GenericStartRenderCallback", PyvtkParallelRenderManager_GenericStartRenderCallback, METH_VARARGS,
   "GenericStartRenderCallback(self) -> None\nC++: virtual void GenericStartRenderCallback()\n\nINTERNAL METHODS (DON NOT USE). There are internal methods made\npublic so that they can be called from callback functions.\n"},
  {"GenericEndRenderCallback", PyvtkParallelRenderManager_GenericEndRenderCallback, METH_VARARGS,
   "GenericEndRenderCallback(self) -> None\nC++: virtual void GenericEndRenderCallback()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkParallelRenderManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("render_window"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetRenderWindow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetRenderWindow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetRenderWindow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderWindow/SetRenderWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetParallelRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetParallelRendering(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetParallelRendering(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParallelRendering/SetParallelRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_event_propagation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetRenderEventPropagation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetRenderEventPropagation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetRenderEventPropagation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderEventPropagation/SetRenderEventPropagation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("default_render_event_propagation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetDefaultRenderEventPropagation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetDefaultRenderEventPropagation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetDefaultRenderEventPropagation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDefaultRenderEventPropagation/SetDefaultRenderEventPropagation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_compositing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetUseCompositing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetUseCompositing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetUseCompositing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCompositing/SetUseCompositing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageReductionFactor/SetImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetMaxImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetMaxImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetMaxImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxImageReductionFactor/SetMaxImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_reduction_factor_for_update_rate"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetImageReductionFactorForUpdateRate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetImageReductionFactorForUpdateRate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetImageReductionFactorForUpdateRate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetAutoImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetAutoImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetAutoImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoImageReductionFactor/SetAutoImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sync_render_window_renderers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetSyncRenderWindowRenderers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetSyncRenderWindowRenderers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetSyncRenderWindowRenderers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSyncRenderWindowRenderers/SetSyncRenderWindowRenderers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_back_images"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetWriteBackImages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetWriteBackImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetWriteBackImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteBackImages/SetWriteBackImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("magnify_images"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetMagnifyImages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetMagnifyImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetMagnifyImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMagnifyImages/SetMagnifyImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("magnify_image_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetMagnifyImageMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetMagnifyImageMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetMagnifyImageMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMagnifyImageMethod/SetMagnifyImageMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_rgba"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetUseRGBA(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetUseRGBA(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetUseRGBA(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseRGBA/SetUseRGBA\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_render_window_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetForceRenderWindowSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetForceRenderWindowSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetForceRenderWindowSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceRenderWindowSize/SetForceRenderWindowSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("forced_render_window_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetForcedRenderWindowSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetForcedRenderWindowSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetForcedRenderWindowSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForcedRenderWindowSize/SetForcedRenderWindowSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_back_buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetUseBackBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetUseBackBuffer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetUseBackBuffer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseBackBuffer/SetUseBackBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("synchronize_tile_properties"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetSynchronizeTileProperties(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelRenderManager_SetSynchronizeTileProperties(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelRenderManager_SetSynchronizeTileProperties(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSynchronizeTileProperties/SetSynchronizeTileProperties\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetRenderTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_processing_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetImageProcessingTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetImageProcessingTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_image_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetFullImageSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFullImageSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reduced_image_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelRenderManager_GetReducedImageSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetReducedImageSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkParallelRenderManager_Doc =
  "vtkParallelRenderManager - An object to control parallel rendering.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkParallelRenderManager operates in multiple processes.  It provides\n"
  "proper renderers and render windows for performing the parallel\n"
  "rendering correctly.  It can also attach itself to render windows and\n"
  "propagate rendering events and camera views.\n\n"
  "@attention Many parallel rendering schemes do not correctly handle\n"
  "transparency. Unless otherwise documented, assume a sub class does\n"
  "not.\n\n"
  "@todo Synchronization/barrier primitives.\n\n"
  "@todo Query ranges of scalar values of objects in addition to the\n"
  "boundary in three-space\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkParallelRenderManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallel.vtkParallelRenderManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkParallelRenderManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkParallelRenderManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkParallelRenderManager_Type, PyvtkParallelRenderManager_Methods,
    "vtkParallelRenderManager",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkParallelRenderManager_Tags_Type);
  PyVTKEnum_Add(&PyvtkParallelRenderManager_Tags_Type, "vtkParallelRenderManager.Tags");

  o = (PyObject *)&PyvtkParallelRenderManager_Tags_Type;
  if (PyDict_SetItemString(d, "Tags", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "NEAREST", vtkParallelRenderManager::NEAREST },
        { "LINEAR", vtkParallelRenderManager::LINEAR },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 7; c++)
  {
    typedef vtkParallelRenderManager::Tags cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[7] = {
        { "RENDER_RMI_TAG", vtkParallelRenderManager::RENDER_RMI_TAG },
        { "COMPUTE_VISIBLE_PROP_BOUNDS_RMI_TAG", vtkParallelRenderManager::COMPUTE_VISIBLE_PROP_BOUNDS_RMI_TAG },
        { "WIN_INFO_TAG", vtkParallelRenderManager::WIN_INFO_TAG },
        { "REN_INFO_TAG", vtkParallelRenderManager::REN_INFO_TAG },
        { "LIGHT_INFO_TAG", vtkParallelRenderManager::LIGHT_INFO_TAG },
        { "REN_ID_TAG", vtkParallelRenderManager::REN_ID_TAG },
        { "BOUNDS_TAG", vtkParallelRenderManager::BOUNDS_TAG },
      };

    o = PyvtkParallelRenderManager_Tags_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkParallelRenderManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkParallelRenderManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkParallelRenderManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkParallelRenderManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

