// python wrapper for vtkBoostBetweennessClustering
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkBoostBetweennessClustering.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBoostBetweennessClustering(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBoostBetweennessClustering_ClassNew(); }


static PyObject *
PyvtkBoostBetweennessClustering_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBoostBetweennessClustering::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBoostBetweennessClustering::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBoostBetweennessClustering *tempr = vtkBoostBetweennessClustering::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBoostBetweennessClustering *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBoostBetweennessClustering::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBoostBetweennessClustering::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBoostBetweennessClustering::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_SetThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreshold(temp0);
    }
    else
    {
      op->vtkBoostBetweennessClustering::SetThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_GetThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetThreshold() :
      op->vtkBoostBetweennessClustering::GetThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_SetUseEdgeWeightArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseEdgeWeightArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseEdgeWeightArray(temp0);
    }
    else
    {
      op->vtkBoostBetweennessClustering::SetUseEdgeWeightArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_UseEdgeWeightArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseEdgeWeightArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseEdgeWeightArrayOn();
    }
    else
    {
      op->vtkBoostBetweennessClustering::UseEdgeWeightArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_UseEdgeWeightArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseEdgeWeightArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseEdgeWeightArrayOff();
    }
    else
    {
      op->vtkBoostBetweennessClustering::UseEdgeWeightArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_SetInvertEdgeWeightArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInvertEdgeWeightArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInvertEdgeWeightArray(temp0);
    }
    else
    {
      op->vtkBoostBetweennessClustering::SetInvertEdgeWeightArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_InvertEdgeWeightArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvertEdgeWeightArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InvertEdgeWeightArrayOn();
    }
    else
    {
      op->vtkBoostBetweennessClustering::InvertEdgeWeightArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_InvertEdgeWeightArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvertEdgeWeightArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InvertEdgeWeightArrayOff();
    }
    else
    {
      op->vtkBoostBetweennessClustering::InvertEdgeWeightArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_GetEdgeWeightArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeWeightArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetEdgeWeightArrayName() :
      op->vtkBoostBetweennessClustering::GetEdgeWeightArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_SetEdgeWeightArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeWeightArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeWeightArrayName(temp0);
    }
    else
    {
      op->vtkBoostBetweennessClustering::SetEdgeWeightArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBetweennessClustering_SetEdgeCentralityArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeCentralityArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBetweennessClustering *op = static_cast<vtkBoostBetweennessClustering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeCentralityArrayName(temp0);
    }
    else
    {
      op->vtkBoostBetweennessClustering::SetEdgeCentralityArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkBoostBetweennessClustering_Methods[] = {
  {"IsTypeOf", PyvtkBoostBetweennessClustering_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBoostBetweennessClustering_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBoostBetweennessClustering_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBoostBetweennessClustering\nC++: static vtkBoostBetweennessClustering *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBoostBetweennessClustering_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBoostBetweennessClustering\nC++: vtkBoostBetweennessClustering *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBoostBetweennessClustering_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBoostBetweennessClustering_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetThreshold", PyvtkBoostBetweennessClustering_SetThreshold, METH_VARARGS,
   "SetThreshold(self, _arg:float) -> None\nC++: virtual void SetThreshold(double _arg)\n\nGet/Set the threshold value. Algorithm terminates when the\nmaximum edge centrality is below this threshold.\n"},
  {"GetThreshold", PyvtkBoostBetweennessClustering_GetThreshold, METH_VARARGS,
   "GetThreshold(self) -> float\nC++: virtual double GetThreshold()\n\n"},
  {"SetUseEdgeWeightArray", PyvtkBoostBetweennessClustering_SetUseEdgeWeightArray, METH_VARARGS,
   "SetUseEdgeWeightArray(self, _arg:bool) -> None\nC++: virtual void SetUseEdgeWeightArray(bool _arg)\n\nGet/Set the flag that sets the rule whether or not to use the\nedge weight array as set using SetEdgeWeightArrayName.\n"},
  {"UseEdgeWeightArrayOn", PyvtkBoostBetweennessClustering_UseEdgeWeightArrayOn, METH_VARARGS,
   "UseEdgeWeightArrayOn(self) -> None\nC++: virtual void UseEdgeWeightArrayOn()\n\n"},
  {"UseEdgeWeightArrayOff", PyvtkBoostBetweennessClustering_UseEdgeWeightArrayOff, METH_VARARGS,
   "UseEdgeWeightArrayOff(self) -> None\nC++: virtual void UseEdgeWeightArrayOff()\n\n"},
  {"SetInvertEdgeWeightArray", PyvtkBoostBetweennessClustering_SetInvertEdgeWeightArray, METH_VARARGS,
   "SetInvertEdgeWeightArray(self, _arg:bool) -> None\nC++: virtual void SetInvertEdgeWeightArray(bool _arg)\n\n"},
  {"InvertEdgeWeightArrayOn", PyvtkBoostBetweennessClustering_InvertEdgeWeightArrayOn, METH_VARARGS,
   "InvertEdgeWeightArrayOn(self) -> None\nC++: virtual void InvertEdgeWeightArrayOn()\n\n"},
  {"InvertEdgeWeightArrayOff", PyvtkBoostBetweennessClustering_InvertEdgeWeightArrayOff, METH_VARARGS,
   "InvertEdgeWeightArrayOff(self) -> None\nC++: virtual void InvertEdgeWeightArrayOff()\n\n"},
  {"GetEdgeWeightArrayName", PyvtkBoostBetweennessClustering_GetEdgeWeightArrayName, METH_VARARGS,
   "GetEdgeWeightArrayName(self) -> str\nC++: virtual char *GetEdgeWeightArrayName()\n\nGet/Set the name of the array that needs to be used as the edge\nweight. The array should be a vtkDataArray.\n"},
  {"SetEdgeWeightArrayName", PyvtkBoostBetweennessClustering_SetEdgeWeightArrayName, METH_VARARGS,
   "SetEdgeWeightArrayName(self, _arg:str) -> None\nC++: virtual void SetEdgeWeightArrayName(const char *_arg)\n\n"},
  {"SetEdgeCentralityArrayName", PyvtkBoostBetweennessClustering_SetEdgeCentralityArrayName, METH_VARARGS,
   "SetEdgeCentralityArrayName(self, _arg:str) -> None\nC++: virtual void SetEdgeCentralityArrayName(const char *_arg)\n\nSet the edge centrality array name. If no output array name is\nset then the name \"edge_centrality\" is used.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBoostBetweennessClustering_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostBetweennessClustering_GetThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBetweennessClustering_SetThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBetweennessClustering_SetThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreshold/SetThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_edge_weight_array"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBetweennessClustering_SetUseEdgeWeightArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBetweennessClustering_SetUseEdgeWeightArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseEdgeWeightArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("invert_edge_weight_array"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBetweennessClustering_SetInvertEdgeWeightArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBetweennessClustering_SetInvertEdgeWeightArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInvertEdgeWeightArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_weight_array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostBetweennessClustering_GetEdgeWeightArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBetweennessClustering_SetEdgeWeightArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBetweennessClustering_SetEdgeWeightArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEdgeWeightArrayName/SetEdgeWeightArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_centrality_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBetweennessClustering_SetEdgeCentralityArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBetweennessClustering_SetEdgeCentralityArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEdgeCentralityArrayName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBoostBetweennessClustering_Doc =
  "vtkBoostBetweennessClustering - Implements graph clustering based on\nedge betweenness centrality.\n\n"
  "Superclass: vtkGraphAlgorithm\n\n"
  "This vtk class uses the Boost centrality clustering generic algorithm\n"
  "to compute edge betweenness centrality on the input graph (a\n"
  "vtkGraph).\n\n"
  "@sa\n"
  "vtkGraph vtkBoostGraphAdapter\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBoostBetweennessClustering_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkInfovisBoostGraphAlgorithms.vtkBoostBetweennessClustering", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBoostBetweennessClustering_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBoostBetweennessClustering_StaticNew()
{
  return vtkBoostBetweennessClustering::New();
}

PyObject *PyvtkBoostBetweennessClustering_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBoostBetweennessClustering_Type, PyvtkBoostBetweennessClustering_Methods,
    "vtkBoostBetweennessClustering",
 &PyvtkBoostBetweennessClustering_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkGraphAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBoostBetweennessClustering_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBoostBetweennessClustering(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBoostBetweennessClustering_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBoostBetweennessClustering", o) != 0)
  {
    Py_DECREF(o);
  }

}

