
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack(1)
#endif
typedef struct RTMSGENTRYINT
{
    uint64_t offDefine   : 17; /* max 0x1c11b */
    uint64_t cchDefine   :  6; /* max 0x28 */
    uint64_t offMsgShort : 17; /* max 0x1c11f */
    uint64_t cchMsgShort :  8; /* max 0x8e */
    int64_t  iCode       : 16;
} RTMSGENTRYINT;
typedef RTMSGENTRYINT *PCRTMSGENTRYINT;
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack()
#endif

static const RTMSGENTRYINT g_aStatusMsgs[ /*2484*/ ] =
{
    { 0x0161a9,  18, 0x002813,  60,   -27018 }, /* VERR_FDT_AT_ROOT_LEVEL */
    { 0x00e391,  27, 0x0094dc,  36,   -27017 }, /* VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED */
    { 0x00fe28,  25, 0x005dca,  45,   -27016 }, /* VERR_FDT_DTB_PROP_SIZE_MALFORMED */
    { 0x00cc65,  29, 0x005cb6,  46,   -27015 }, /* VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE */
    { 0x0098cc,  36, 0x009091,  37,   -27014 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END */
    { 0x007fda,  40, 0x00523f,  48,   -27013 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING */
    { 0x009374,  36, 0x007877,  41,   -27012 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED */
    { 0x007dd2,  40, 0x00b044,  32,   -27011 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID */
    { 0x00956c,  36, 0x009f68,  35,   -27010 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID */
    { 0x00a5f4,  34, 0x0071db,  42,   -27009 }, /* VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED */
    { 0x009c43,  35, 0x000a6b,  84,   -27008 }, /* VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING */
    { 0x008d16,  38, 0x0071db,  42,   -27007 }, /* VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID */
    { 0x009272,  37, 0x00791b,  41,   -27006 }, /* VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID */
    { 0x008ca4,  38, 0x00550d,  47,   -27005 }, /* VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID */
    { 0x011f0b,  22, 0x00425d,  52,   -27004 }, /* VERR_FDT_DTB_HDR_SIZE_INVALID */
    { 0x00a726,  34, 0x007283,  42,   -27003 }, /* VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID */
    { 0x016aaf,  17, 0x00c2b7,  30,   -27002 }, /* VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED */
    { 0x00f3ff,  26, 0x00db92,  28,   -27001 }, /* VERR_FDT_DTB_HDR_MAGIC_INVALID */
    { 0x015ddd,  18, 0x00cc48,  29,   -27000 }, /* VERR_FDT_DTB_MALFORMED */
    { 0x01544d,  19, 0x01720a,  16,   -26820 }, /* VERR_HARDAVL_UNBALANCED */
    { 0x0171aa,  16, 0x01983c,  13,   -26819 }, /* VERR_HARDAVL_BAD_HEIGHT */
    { 0x0133b7,  21, 0x00da26,  28,   -26818 }, /* VERR_HARDAVL_LOOKUP_TOO_DEEP */
    { 0x00f03d,  26, 0x003c5d,  54,   -26817 }, /* VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES */
    { 0x0144a0,  20, 0x00d436,  29,   -26816 }, /* VERR_HARDAVL_UNEXPECTED_NULL_RIGHT */
    { 0x014d8c,  19, 0x00d68a,  28,   -26815 }, /* VERR_HARDAVL_UNEXPECTED_NULL_LEFT */
    { 0x0141d1,  20, 0x01688f,  17,   -26814 }, /* VERR_HARDAVL_BAD_NEW_HEIGHT */
    { 0x012593,  22, 0x014c95,  19,   -26813 }, /* VERR_HARDAVL_BAD_RIGHT_HEIGHT */
    { 0x012adb,  21, 0x015cf3,  18,   -26812 }, /* VERR_HARDAVL_BAD_LEFT_HEIGHT */
    { 0x00f639,  26, 0x009c89,  35,   -26811 }, /* VERR_HARDAVL_INSERT_INVALID_KEY_RANGE */
    { 0x0117ec,  23, 0x00b744,  32,   -26810 }, /* VERR_HARDAVL_STACK_OVERFLOW */
    { 0x0131d4,  21, 0x00dd8a,  28,   -26804 }, /* VERR_HARDAVL_NODE_IS_FREE */
    { 0x00e66a,  27, 0x008d88,  37,   -26803 }, /* VERR_HARDAVL_MISALIGNED_POINTER */
    { 0x00c5fe,  30, 0x007944,  41,   -26802 }, /* VERR_HARDAVL_POINTER_OUT_OF_BOUNDS */
    { 0x00e02a,  28, 0x0109a6,  24,   -26801 }, /* VERR_HARDAVL_INDEX_OUT_OF_BOUNDS */
    { 0x00d2a0,  29, 0x003e40,  53,   -26602 }, /* VERR_TRACELOG_READER_ITERATOR_END */
    { 0x00b6e4,  32, 0x017ff6,  15,   -26601 }, /* VERR_TRACELOG_READER_LOG_UNSUPPORTED */
    { 0x00c8ce,  30, 0x012869,  22,   -26600 }, /* VERR_TRACELOG_READER_MALFORMED_LOG */
    { 0x01041d,  25, 0x011c98,  23,   -26406 }, /* VERR_FTP_CLIENT_LIMIT_REACHED */
    { 0x018df4,  14, 0x01b50f,   9,   -26405 }, /* VERR_FTP_CLIENT_NOT_FOUND */
    { 0x00e046,  28, 0x00b004,  32,   -26404 }, /* VERR_FTP_DATA_CONN_LIMIT_REACHED */
    { 0x01694a,  17, 0x01579c,  18,   -26403 }, /* VERR_FTP_DATA_CONN_NOT_FOUND */
    { 0x012ea1,  21, 0x01579c,  18,   -26402 }, /* VERR_FTP_DATA_CONN_INIT_FAILED */
    { 0x01a595,  11, 0x014069,  20,   -26401 }, /* VERR_FTP_INIT_FAILED */
    { 0x013d35,  20, 0x015778,  18,   -26400 }, /* VERR_FTP_STATUS_SERVER_ERROR */
    { 0x0195e6,  13, 0x004b84,  50,   -26203 }, /* VERR_IOQUEUE_BUSY */
    { 0x01896a,  14, 0x0017a0,  68,   -26202 }, /* VERR_IOQUEUE_EMPTY */
    { 0x0199f6,  13, 0x00606d,  45,   -26201 }, /* VERR_IOQUEUE_FULL */
    { 0x00ecd9,  27, 0x008700,  38,   -26200 }, /* VERR_IOQUEUE_HANDLE_NOT_REGISTERED */
    { 0x00bc2e,  31, 0x00e2b9,  27,   -26000 }, /* VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED */
    { 0x011c3c,  23, 0x006961,  43,   -25811 }, /* VERR_CR_CIPHER_OSSL_SET_TAG_FAILED */
    { 0x011a59,  23, 0x006ab9,  43,   -25810 }, /* VERR_CR_CIPHER_OSSL_GET_TAG_FAILED */
    { 0x014220,  20, 0x019ed6,  12,   -25809 }, /* VERR_CR_CIPHER_INVALID_TAG_LENGTH */
    { 0x008a1e,  38, 0x00c54a,  30,   -25808 }, /* VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH */
    { 0x0140e1,  20, 0x01a0fe,  12,   -25807 }, /* VERR_CR_CIPHER_INVALID_KEY_LENGTH */
    { 0x00cec6,  29, 0x015d5f,  18,   -25806 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED */
    { 0x00c6b2,  30, 0x014847,  19,   -25805 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED */
    { 0x00dda6,  28, 0x01651b,  17,   -25804 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED */
    { 0x00cbd4,  29, 0x015be5,  18,   -25803 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED */
    { 0x00c7de,  30, 0x014918,  19,   -25802 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED */
    { 0x00d882,  28, 0x0169d2,  17,   -25801 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED */
    { 0x01a619,  11, 0x01b7b4,   8,   -25800 }, /* VERR_CR_CIPHER_NOT_SUPPORTED */
    { 0x01afeb,  10, 0x01c01a,   5,   -25799 }, /* VERR_REST_INTERNAL_ERROR_9 */
    { 0x01b095,  10, 0x01bfed,   5,   -25798 }, /* VERR_REST_INTERNAL_ERROR_8 */
    { 0x01aff5,  10, 0x01bf2a,   5,   -25797 }, /* VERR_REST_INTERNAL_ERROR_7 */
    { 0x01b013,  10, 0x01bf57,   5,   -25796 }, /* VERR_REST_INTERNAL_ERROR_6 */
    { 0x01b01d,  10, 0x01bed5,   5,   -25795 }, /* VERR_REST_INTERNAL_ERROR_5 */
    { 0x01b03b,  10, 0x01bff2,   5,   -25794 }, /* VERR_REST_INTERNAL_ERROR_4 */
    { 0x01b08b,  10, 0x01befd,   5,   -25793 }, /* VERR_REST_INTERNAL_ERROR_3 */
    { 0x01b06d,  10, 0x01bf48,   5,   -25792 }, /* VERR_REST_INTERNAL_ERROR_2 */
    { 0x01b077,  10, 0x01bf0c,   5,   -25791 }, /* VERR_REST_INTERNAL_ERROR_1 */
    { 0x009590,  36, 0x00de6a,  28,   -25713 }, /* VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET */
    { 0x009d38,  35, 0x00ade3,  33,   -25712 }, /* VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET */
    { 0x00fdc5,  25, 0x0154f8,  19,   -25711 }, /* VERR_REST_PATH_PARAMETER_NOT_SET */
    { 0x00ee6a,  26, 0x016c7a,  17,   -25710 }, /* VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL */
    { 0x00e1e1,  27, 0x0151b4,  19,   -25709 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DATE */
    { 0x010706,  24, 0x017f6f,  15,   -25708 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_STRING */
    { 0x00d388,  29, 0x01327c,  21,   -25707 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE */
    { 0x00c766,  30, 0x012475,  22,   -25706 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER */
    { 0x00ecbe,  27, 0x014e24,  19,   -25705 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_BOOL */
    { 0x00e24d,  27, 0x0183e3,  15,   -25704 }, /* VERR_REST_UNABLE_TO_DECODE_DATE */
    { 0x00a506,  34, 0x005a60,  46,   -25703 }, /* VERR_REST_RESPONSE_REPEAT_HEADER_FIELD */
    { 0x00aaaa,  33, 0x006392,  44,   -25702 }, /* VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR */
    { 0x012945,  22, 0x00e7ff,  27,   -25701 }, /* VERR_REST_RESPONSE_INVALID_UTF8_ENCODING */
    { 0x00ec01,  27, 0x00715d,  42,   -25700 }, /* VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED */
    { 0x012fc7,  21, 0x00459a,  51,   -25501 }, /* VERR_SERIALPORT_INVALID_BAUDRATE */
    { 0x00f59e,  26, 0x005c5a,  46,   -25500 }, /* VERR_SERIALPORT_BREAK_DETECTED */
    { 0x01c069,   4, 0x01ba36,   6,   -25395 }, /* VERR_ISOFS_IPE_5 */
    { 0x01c06d,   4, 0x01b93e,   6,   -25394 }, /* VERR_ISOFS_IPE_4 */
    { 0x01c071,   4, 0x01b886,   6,   -25393 }, /* VERR_ISOFS_IPE_3 */
    { 0x01c085,   4, 0x01b756,   6,   -25392 }, /* VERR_ISOFS_IPE_2 */
    { 0x01c075,   4, 0x01ba46,   6,   -25391 }, /* VERR_ISOFS_IPE_1 */
    { 0x01612b,  18, 0x013474,  21,   -25390 }, /* VERR_ISOFS_UDF_NOT_IMPLEMENTED */
    { 0x01323d,  21, 0x004501,  51,   -25352 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT */
    { 0x015ff9,  18, 0x008051,  39,   -25351 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_DIR */
    { 0x0165b4,  17, 0x01701a,  16,   -25350 }, /* VERR_ISOFS_BOGUS_UDF_DIR_SIZE */
    { 0x010404,  25, 0x00fcb2,  25,   -25349 }, /* VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD */
    { 0x019008,  14, 0x014607,  20,   -25348 }, /* VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS */
    { 0x00b2c4,  32, 0x002094,  63,   -25347 }, /* VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH */
    { 0x0121f7,  22, 0x004ff7,  49,   -25346 }, /* VERR_ISOFS_BOGUS_NEXT_AD_LENGTH */
    { 0x01bf16,   5, 0x0194ae,  13,   -25345 }, /* VERR_ISOFS_UNKNOWN_FILE_TYPE */
    { 0x01abdb,  10, 0x019fde,  12,   -25344 }, /* VERR_ISOFS_WRONG_FILE_TYPE */
    { 0x01b81c,   8, 0x0078f2,  41,   -25343 }, /* VERR_ISOFS_BAD_EXTAD */
    { 0x01a692,  11, 0x016077,  18,   -25342 }, /* VERR_ISO_FS_UNKNOWN_AD_TYPE */
    { 0x01b332,   9, 0x01b3f8,   9,   -25341 }, /* VERR_ISOFS_BAD_FILE_ENTRY */
    { 0x01be7d,   6, 0x01ab62,  11,   -25340 }, /* VERR_ISOFS_UNSUPPORTED_ICB */
    { 0x01578a,  18, 0x008dd2,  37,   -25339 }, /* VERR_ISOFS_ICB_ENTRY_TOO_SMALL */
    { 0x013267,  21, 0x011848,  23,   -25338 }, /* VERR_ISOFS_TOO_DEEP_ICB_RECURSION */
    { 0x013e4d,  20, 0x0083ab,  39,   -25337 }, /* VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS */
    { 0x012c40,  21, 0x012cbe,  21,   -25336 }, /* VERR_ISOFS_NO_DIRECT_ICB_ENTRIES */
    { 0x019f06,  12, 0x0189be,  14,   -25335 }, /* VERR_ISOFS_ICB_TOO_SMALL */
    { 0x01ad61,  10, 0x01a43a,  12,   -25334 }, /* VERR_ISOFS_ICB_TOO_BIG */
    { 0x016493,  17, 0x00b3a4,  32,   -25333 }, /* VERR_ISOFS_FSD_NEXT_EXTENT */
    { 0x014bc4,  19, 0x006f65,  42,   -25332 }, /* VERR_ISOFS_FSD_ZERO_ROOT_DIR */
    { 0x017c64,  15, 0x016dbd,  17,   -25331 }, /* VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET */
    { 0x0158f1,  18, 0x00d249,  29,   -25330 }, /* VERR_ISOFS_INVALID_PARTITION_INDEX */
    { 0x014041,  20, 0x004d46,  50,   -25329 }, /* VERR_ISOFS_BAD_LVD_DESC_CHAR_SET */
    { 0x00febe,  25, 0x00e4d5,  27,   -25327 }, /* VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION */
    { 0x016ecb,  16, 0x00b904,  32,   -25326 }, /* VERR_ISOFS_BAD_LVD_DOMAIN_ID */
    { 0x015afb,  18, 0x00ad5f,  33,   -25325 }, /* VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE */
    { 0x01b6ec,   8, 0x004be8,  50,   -25324 }, /* VERR_ISOFS_MPM_NOT_SUPPORTED */
    { 0x01b675,   8, 0x0048fa,  50,   -25323 }, /* VERR_ISOFS_SPM_NOT_SUPPORTED */
    { 0x01b8f4,   8, 0x004e0d,  49,   -25322 }, /* VERR_ISOFS_VPM_NOT_SUPPORTED */
    { 0x016eab,  16, 0x006cbd,  43,   -25321 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID */
    { 0x0151ed,  19, 0x013156,  21,   -25320 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE */
    { 0x00e592,  27, 0x0069e2,  43,   -25319 }, /* VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE */
    { 0x0191c8,  14, 0x007037,  42,   -25318 }, /* VERR_ISOFS_PARTITION_NOT_FOUND */
    { 0x00f85a,  26, 0x005770,  47,   -25317 }, /* VERR_ISOFS_MALFORMED_PART_MAP_TABLE */
    { 0x019974,  13, 0x007301,  42,   -25316 }, /* VERR_ISOFS_TOO_MANY_PART_MAPS */
    { 0x0183d4,  15, 0x0029f3,  59,   -25315 }, /* VERR_ISOFS_MULTIPLE_LVDS */
    { 0x0185e1,  15, 0x002d68,  59,   -25314 }, /* VERR_ISOFS_MULTIPLE_PVDS */
    { 0x01bf84,   5, 0x010d7e,  24,   -25313 }, /* VERR_ISOFS_NO_PD */
    { 0x01bdff,   6, 0x01164e,  23,   -25312 }, /* VERR_ISOFS_NO_LVD */
    { 0x01be53,   6, 0x011329,  23,   -25311 }, /* VERR_ISOFS_NO_PVD */
    { 0x012b6e,  21, 0x00aa47,  33,   -25310 }, /* VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD */
    { 0x01bb2e,   7, 0x00e8a1,  27,   -25309 }, /* VERR_ISOFS_TOO_MANY_PDS */
    { 0x01b8a4,   8, 0x00f2ad,  26,   -25308 }, /* VERR_ISOFS_TOO_MANY_LVDS */
    { 0x01b94c,   8, 0x00f363,  26,   -25307 }, /* VERR_ISOFS_TOO_MANY_PVDS */
    { 0x01a6d4,  11, 0x009a58,  36,   -25306 }, /* VERR_ISOFS_UNEXPECTED_VDS_DESC */
    { 0x00b284,  32, 0x00f071,  26,   -25305 }, /* VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC */
    { 0x01a572,  12, 0x010eb6,  24,   -25304 }, /* VERR_ISOFS_DESC_CRC_MISMATCH */
    { 0x01904e,  14, 0x00b4c4,  32,   -25303 }, /* VERR_ISOFS_TAG_SECTOR_MISMATCH */
    { 0x01855a,  15, 0x0182c6,  15,   -25302 }, /* VERR_ISOFS_BAD_TAG_CHECKSUM */
    { 0x01b7bc,   8, 0x018da0,  14,   -25301 }, /* VERR_ISOFS_UNSUPPORTED_TAG_VERSION */
    { 0x015eb5,  18, 0x00f536,  26,   -25300 }, /* VERR_ISOFS_TAG_IS_ALL_ZEROS */
    { 0x011762,  23, 0x007d0a,  40,   -25162 }, /* VERR_ISOMK_IMPORT_UDF_FILE_WITH_STREAM_DIR */
    { 0x01af05,  10, 0x00651e,  44,   -25161 }, /* VERR_ISOMK_IMPORT_UDF_UNSUPPORTED_FILE_TYPE */
    { 0x015baf,  18, 0x008642,  38,   -25160 }, /* VERR_ISOMK_IMPORT_UDF_SPARSE_FILE */
    { 0x010bb6,  24, 0x000f51,  74,   -25159 }, /* VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS */
    { 0x017c55,  15, 0x013b19,  20,   -25158 }, /* VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG */
    { 0x00a1d6,  34, 0x000bb4,  80,   -25157 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS */
    { 0x007ada,  40, 0x000911,  88,   -25156 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE */
    { 0x009d7e,  35, 0x000860,  89,   -25155 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR */
    { 0x008e41,  37, 0x002016,  63,   -25154 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS */
    { 0x00ff22,  25, 0x000cf2,  78,   -25153 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID */
    { 0x00bf72,  31, 0x0060f4,  45,   -25152 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND */
    { 0x00e13f,  27, 0x0017e4,  68,   -25151 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG */
    { 0x00f73c,  26, 0x0065ce,  44,   -25150 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE */
    { 0x0090b6,  37, 0x0025b4,  61,   -25149 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS */
    { 0x009b2b,  35, 0x00756c,  41,   -25148 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD */
    { 0x00c162,  31, 0x0083d2,  39,   -25147 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG */
    { 0x00d5aa,  28, 0x008447,  39,   -25146 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS */
    { 0x00ff6d,  25, 0x00835d,  39,   -25145 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE */
    { 0x01266f,  22, 0x009ccf,  35,   -25144 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID */
    { 0x00b924,  32, 0x0046cc,  51,   -25143 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM */
    { 0x00ddc2,  28, 0x005aea,  46,   -25142 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS */
    { 0x00a8dc,  33, 0x0047cb,  51,   -25141 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID */
    { 0x00f88e,  26, 0x009100,  37,   -25140 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS */
    { 0x00c568,  30, 0x002d2d,  59,   -25133 }, /* VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT */
    { 0x00f550,  26, 0x002538,  62,   -25132 }, /* VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT */
    { 0x00c181,  31, 0x001828,  68,   -25131 }, /* VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC */
    { 0x011156,  24, 0x004666,  51,   -25130 }, /* VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS */
    { 0x00ed96,  20, 0x01b9dc,   8,   -25129 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME */
    { 0x00ed96,  27, 0x01b9dc,   8,   -25128 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH */
    { 0x015e49,  18, 0x00def6,  28,   -25127 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH */
    { 0x00bef6,  31, 0x00c964,  30,   -25126 }, /* VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS */
    { 0x010b6e,  24, 0x005ba2,  46,   -25125 }, /* VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO */
    { 0x015e49,  11, 0x015d83,  18,   -25124 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC */
    { 0x016c36,  17, 0x012f49,  21,   -25123 }, /* VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE */
    { 0x00ed0f,  27, 0x00c9dc,  30,   -25122 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT */
    { 0x00e00e,  28, 0x00bfb0,  31,   -25121 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG */
    { 0x011706,  23, 0x00a8fd,  33,   -25120 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH */
    { 0x00b7e4,  32, 0x00a56c,  34,   -25119 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS */
    { 0x01312c,  21, 0x006786,  44,   -25118 }, /* VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO */
    { 0x012097,  22, 0x00b324,  32,   -25117 }, /* VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR */
    { 0x011706,  16, 0x0119fd,  23,   -25116 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC */
    { 0x01609b,  18, 0x002386,  62,   -25115 }, /* VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH */
    { 0x015590,  19, 0x001dd6,  64,   -25114 }, /* VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH */
    { 0x015f33,  18, 0x00f1f7,  26,   -25113 }, /* VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO */
    { 0x00c34d,  30, 0x012b44,  21,   -25112 }, /* VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET */
    { 0x011cc6,  23, 0x007b02,  40,   -25111 }, /* VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB */
    { 0x0197c7,  13, 0x0098a8,  36,   -25110 }, /* VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC */
    { 0x0137fb,  21, 0x0077fc,  41,   -25109 }, /* VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER */
    { 0x0147e7,  20, 0x00c52c,  30,   -25108 }, /* VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC */
    { 0x00e062,  28, 0x009da1,  35,   -25107 }, /* VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER */
    { 0x00c124,  31, 0x0046ff,  51,   -25106 }, /* VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY */
    { 0x00d573,  28, 0x009047,  37,   -25105 }, /* VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS */
    { 0x00e232,  27, 0x008225,  39,   -25104 }, /* VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS */
    { 0x00cc0e,  29, 0x008cca,  38,   -25103 }, /* VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS */
    { 0x01745a,  16, 0x014dfe,  19,   -25102 }, /* VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR */
    { 0x018e8e,  14, 0x00bd06,  31,   -25101 }, /* VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS */
    { 0x01adbb,  10, 0x0096b0,  36,   -25100 }, /* VERR_ISOMK_IMPORT_UNKNOWN_FORMAT */
    { 0x0170fa,  16, 0x00d03f,  29,   -25029 }, /* VERR_ISOMK_RR_SPILL_FILE_FULL */
    { 0x019897,  13, 0x00a45c,  34,   -25028 }, /* VERR_ISOMK_IPE_FINALIZE_1 */
    { 0x017f8d,  15, 0x00e526,  27,   -25027 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_3 */
    { 0x017f9c,  15, 0x00e190,  27,   -25026 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_2 */
    { 0x017fab,  15, 0x00eb44,  27,   -25025 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_1 */
    { 0x014590,  20, 0x0082e8,  39,   -25024 }, /* VERR_ISOMK_IPE_PRODUCE_TRANS_TBL */
    { 0x0176d9,  16, 0x00b424,  32,   -25023 }, /* VERR_ISOMK_IPE_BOOT_CAT_FILE */
    { 0x01a700,  11, 0x0127b9,  22,   -25022 }, /* VERR_ISOMK_IPE_BUFFER_SIZE */
    { 0x019a5e,  13, 0x00acfc,  33,   -25021 }, /* VERR_ISOMK_IPE_DESC_COUNT */
    { 0x0197d4,  13, 0x00bb17,  31,   -25020 }, /* VERR_ISOMK_IPE_ROOT_SLASH */
    { 0x015b67,  18, 0x00e64f,  27,   -25019 }, /* VERR_ISOMK_IPE_EMPTY_COMPONENT */
    { 0x019a6b,  13, 0x013729,  21,   -25018 }, /* VERR_ISOMK_IPE_EMPTY_PATH */
    { 0x018ac8,  14, 0x00bb93,  31,   -25017 }, /* VERR_ISOMK_IPE_NAMESPACE_6 */
    { 0x018ad6,  14, 0x00ba1f,  31,   -25016 }, /* VERR_ISOMK_IPE_NAMESPACE_5 */
    { 0x018ae4,  14, 0x00bfee,  31,   -25015 }, /* VERR_ISOMK_IPE_NAMESPACE_4 */
    { 0x018b62,  14, 0x00c0c7,  31,   -25014 }, /* VERR_ISOMK_IPE_NAMESPACE_3 */
    { 0x018af2,  14, 0x00baf8,  31,   -25013 }, /* VERR_ISOMK_IPE_NAMESPACE_2 */
    { 0x018be0,  14, 0x00b9a3,  31,   -25012 }, /* VERR_ISOMK_IPE_NAMESPACE_1 */
    { 0x01b96c,   8, 0x00af84,  32,   -25011 }, /* VERR_ISOMK_IPE_TABLE */
    { 0x01b206,  10, 0x00a3d4,  34,   -25010 }, /* VERR_ISOMK_IPE_RR_READ */
    { 0x0155ec,  18, 0x00a21a,  34,   -25009 }, /* VERR_ISOMK_RR_NO_SPACE_FOR_CE */
    { 0x00f175,  26, 0x003741,  56,   -25008 }, /* VERR_ISOMK_SYMLINK_SUPPORT_DISABLED */
    { 0x0106a6,  24, 0x002c7c,  59,   -25007 }, /* VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x012f73,  21, 0x001d96,  64,   -25006 }, /* VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3 */
    { 0x01110e,  24, 0x010736,  24,   -25005 }, /* VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY */
    { 0x012a5d,  21, 0x00acdb,  33,   -25004 }, /* VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE */
    { 0x01250f,  22, 0x0117a7,  23,   -25003 }, /* VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY */
    { 0x00a1b4,  34, 0x01b371,   9,   -25002 }, /* VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER */
    { 0x010323,  25, 0x010549,  25,   -25001 }, /* VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY */
    { 0x00d53b,  28, 0x00d6de,  28,   -25000 }, /* VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY */
    { 0x01a3c2,  12, 0x005b18,  46,   -24804 }, /* VERR_VFS_UNSUPPORTED_CREATE_TYPE */
    { 0x01afb9,  10, 0x0179a9,  16,   -24803 }, /* VERR_VFS_UNSUPPORTED_FORMAT */
    { 0x017e9d,  15, 0x00d2da,  29,   -24802 }, /* VERR_VFS_BOGUS_OFFSET */
    { 0x01815e,  15, 0x00d144,  29,   -24801 }, /* VERR_VFS_BOGUS_FORMAT */
    { 0x01ade3,  10, 0x017709,  16,   -24800 }, /* VERR_VFS_UNKNOWN_FORMAT */
    { 0x017759,  16, 0x01a947,  11,   -24707 }, /* VERR_JSON_INVALID_CODEPOINT */
    { 0x00c3e2,  30, 0x00b184,  32,   -24706 }, /* VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE */
    { 0x0129c9,  22, 0x00c3a6,  30,   -24705 }, /* VERR_JSON_MISSING_SURROGATE_PAIR */
    { 0x00dc56,  28, 0x010e56,  24,   -24704 }, /* VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE */
    { 0x019254,  14, 0x012d27,  21,   -24703 }, /* VERR_JSON_IS_EMPTY */
    { 0x0183f2,  15, 0x00ef05,  26,   -24702 }, /* VERR_JSON_MALFORMED */
    { 0x01596f,  18, 0x0113b3,  23,   -24701 }, /* VERR_JSON_ITERATOR_END */
    { 0x018836,  14, 0x007ec2,  40,   -24700 }, /* VERR_JSON_VALUE_INVALID_TYPE */
    { 0x01941f,  13, 0x00e30a,  27,   -24610 }, /* VERR_URI_NOT_FILE_SCHEME */
    { 0x00cc2b,  29, 0x00288b,  60,   -24609 }, /* VERR_URI_MISSING_UTF8_CONTINUATION_BYTE */
    { 0x0095fc,  36, 0x00305f,  58,   -24608 }, /* VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE */
    { 0x00d7a2,  28, 0x00538f,  48,   -24607 }, /* VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE */
    { 0x00c874,  30, 0x00622f,  45,   -24606 }, /* VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8 */
    { 0x016829,  17, 0x004291,  52,   -24605 }, /* VERR_URI_ESCAPED_ZERO */
    { 0x01719a,  16, 0x016807,  17,   -24604 }, /* VERR_URI_INVALID_ESCAPE_SEQ */
    { 0x016b9d,  17, 0x0198d8,  13,   -24603 }, /* VERR_URI_INVALID_PORT_NUMBER */
    { 0x01a356,  12, 0x01b8cc,   8,   -24602 }, /* VERR_URI_INVALID_SCHEME */
    { 0x01ab78,  11, 0x00e44e,  27,   -24601 }, /* VERR_URI_TOO_SHORT */
    { 0x01b0f9,  10, 0x01a4fa,  12,   -24600 }, /* VERR_URI_EMPTY */
    { 0x01262d,  22, 0x00bc8b,  31,   -24403 }, /* VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS */
    { 0x00af64,  32, 0x0053bf,  48,   -24402 }, /* VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED */
    { 0x012f1f,  21, 0x018677,  15,   -24400 }, /* VERR_PATH_MATCH_UNKNOWN_VARIABLE */
    { 0x011dd7,  22, 0x008bc0,  38,   -24399 }, /* VERR_CR_MALFORMED_PEM_HEADER */
    { 0x01ad1b,  10, 0x0057ce,  47,   -24398 }, /* VERR_CR_RANDOM_FAILED */
    { 0x0170ca,  16, 0x0057ce,  47,   -24397 }, /* VERR_CR_RANDOM_SETUP_FAILED */
    { 0x00c982,  30, 0x00cbf1,  29,   -24396 }, /* VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED */
    { 0x01718a,  16, 0x00d2bd,  29,   -24395 }, /* VERR_CR_OPENSSL_VERSION_TOO_OLD */
    { 0x01bf02,   5, 0x00983c,  36,   -24205 }, /* VERR_CR_DIGEST_NOT_SUPPORTED */
    { 0x011a70,  23, 0x00d58e,  28,   -24204 }, /* VERR_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x018a9e,  14, 0x014b78,  19,   -24203 }, /* VERR_CR_DIGEST_COMPROMISED */
    { 0x0194d5,  13, 0x015db9,  18,   -24202 }, /* VERR_CR_DIGEST_DEPRECATED */
    { 0x015427,  19, 0x00e5ad,  27,   -24201 }, /* VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR */
    { 0x01807d,  15, 0x00b264,  32,   -24200 }, /* VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR */
    { 0x010099,  25, 0x00559a,  47,   -24002 }, /* VERR_BIGNUM_NEGATIVE_EXPONENT */
    { 0x015356,  19, 0x0121cb,  22,   -24001 }, /* VERR_BIGNUM_DIV_BY_ZERO */
    { 0x011917,  23, 0x002055,  63,   -24000 }, /* VERR_BIGNUM_SENSITIVE_INPUT */
    { 0x017dcc,  15, 0x01be9b,   6,   -23900 }, /* VERR_CR_RSA_GENERIC_ERROR */
    { 0x014b9e,  19, 0x00a1f8,  34,   -23819 }, /* VERR_CR_KEY_ALGO_PARAMS_MISMATCH */
    { 0x00fc99,  25, 0x008f8e,  37,   -23818 }, /* VERR_CR_KEY_ALGO_PARAMS_UNKNOWN */
    { 0x014bb1,  19, 0x00768b,  41,   -23817 }, /* VERR_CR_KEY_ALGO_PARAMS_MISSING */
    { 0x00db3e,  28, 0x00f009,  26,   -23816 }, /* VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED */
    { 0x017d09,  15, 0x014f54,  19,   -23815 }, /* VERR_CR_KEY_GEN_FAILED_RSA */
    { 0x0161bb,  18, 0x003709,  56,   -23813 }, /* VERR_CR_KEY_DECRYPTION_FAILED */
    { 0x00ffea,  25, 0x0141f8,  20,   -23812 }, /* VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR */
    { 0x0172ca,  16, 0x0094b8,  36,   -23811 }, /* VERR_CR_KEY_PASSWORD_ENCODING */
    { 0x00fc35,  25, 0x003eaa,  53,   -23810 }, /* VERR_CR_KEY_MALFORMED_CIPHER_IV */
    { 0x011f79,  22, 0x004159,  52,   -23809 }, /* VERR_CR_KEY_TOO_SHORT_CIPHER_IV */
    { 0x0130ae,  21, 0x007c92,  40,   -23808 }, /* VERR_CR_KEY_MISSING_CIPHER_PARAMS */
    { 0x013b69,  20, 0x004aee,  50,   -23807 }, /* VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS */
    { 0x019641,  13, 0x011bc9,  23,   -23806 }, /* VERR_CR_KEY_UNSUPPORTED_CIPHER */
    { 0x014c23,  19, 0x015903,  18,   -23805 }, /* VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED */
    { 0x013d99,  20, 0x007639,  41,   -23804 }, /* VERR_CR_KEY_DEK_INFO_TOO_LONG */
    { 0x01846a,  15, 0x0012ba,  71,   -23803 }, /* VERR_CR_KEY_NO_DEK_INFO */
    { 0x017caf,  15, 0x008ffd,  37,   -23802 }, /* VERR_CR_KEY_ENCRYPTED */
    { 0x0187ee,  15, 0x019dda,  12,   -23801 }, /* VERR_CR_KEY_FORMAT_NOT_SUPPORTED */
    { 0x01b80c,   8, 0x00ebe6,  27,   -23800 }, /* VERR_CR_KEY_UNKNOWN_TYPE */
    { 0x01698e,  17, 0x01b7f4,   8,   -23700 }, /* VERR_CR_STORE_GENERIC_ERROR */
    { 0x00d8d6,  28, 0x00a960,  33,   -23527 }, /* VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED */
    { 0x011186,  24, 0x0160ad,  18,   -23526 }, /* VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY */
    { 0x0101f7,  25, 0x014aba,  19,   -23525 }, /* VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY */
    { 0x0121b5,  22, 0x017929,  16,   -23524 }, /* VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY */
    { 0x0112e4,  23, 0x01672a,  17,   -23523 }, /* VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY */
    { 0x00ba00,  29, 0x00924d,  37,   -23522 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE */
    { 0x00ba00,  31, 0x006f8f,  42,   -23521 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE */
    { 0x01095e,  24, 0x00dace,  28,   -23520 }, /* VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED */
    { 0x00c586,  30, 0x0062b6,  44,   -23519 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR */
    { 0x00cb43,  29, 0x00c72a,  30,   -23518 }, /* VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED */
    { 0x010e0e,  24, 0x00fe5a,  25,   -23517 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR */
    { 0x00dfba,  28, 0x00cb26,  29,   -23516 }, /* VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED */
    { 0x00f397,  26, 0x013810,  21,   -23515 }, /* VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED */
    { 0x00c7c0,  30, 0x0095b4,  36,   -23514 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED */
    { 0x00a36e,  34, 0x008b28,  38,   -23513 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP */
    { 0x00a36e,  30, 0x00c90a,  30,   -23512 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN */
    { 0x010067,  25, 0x013ca9,  20,   -23511 }, /* VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN */
    { 0x00bf34,  31, 0x007662,  41,   -23510 }, /* VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL */
    { 0x0155fe,  18, 0x0064f2,  44,   -23509 }, /* VERR_CR_PKIX_SIGNATURE_MISMATCH */
    { 0x0109be,  24, 0x015e7f,  18,   -23508 }, /* VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH */
    { 0x00fa0f,  25, 0x012cfd,  21,   -23507 }, /* VERR_CR_PKIX_SIGNATURE_NEGATIVE */
    { 0x0114de,  23, 0x008798,  38,   -23506 }, /* VERR_CR_PKIX_SIGNATURE_GE_KEY */
    { 0x012971,  22, 0x009edc,  35,   -23505 }, /* VERR_CR_PKIX_SIGNATURE_TOO_LONG */
    { 0x0104fe,  25, 0x00553c,  47,   -23504 }, /* VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY */
    { 0x01b23f,   9, 0x01c11f,   2,   -23503 }, /* VERR_CR_PKIX_INTERNAL_ERROR */
    { 0x01acd5,  10, 0x01a392,  12,   -23502 }, /* VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE */
    { 0x00a4a0,  34, 0x003a0b,  54,   -23501 }, /* VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS */
    { 0x016fba,  16, 0x01b17a,  10,   -23500 }, /* VERR_CR_PKIX_GENERIC_ERROR */
    { 0x01241d,  22, 0x009ac2,  35,   -23416 }, /* VERR_CR_SPC_PEIMAGE_NO_CONTENT */
    { 0x00d6a6,  28, 0x013ff1,  20,   -23415 }, /* VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED */
    { 0x010f46,  24, 0x014ee2,  19,   -23414 }, /* VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE */
    { 0x00b4a4,  32, 0x00f4e9,  26,   -23413 }, /* VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS */
    { 0x014a0f,  19, 0x00f9f6,  25,   -23412 }, /* VERR_CR_SPC_MONIKER_BAD_DATA */
    { 0x0138f7,  21, 0x010df6,  24,   -23411 }, /* VERR_CR_SPC_BAD_MONIKER_CHOICE */
    { 0x014b65,  19, 0x0150e3,  19,   -23410 }, /* VERR_CR_SPC_UNKNOWN_MONIKER_UUID */
    { 0x014cce,  19, 0x00fa28,  25,   -23409 }, /* VERR_CR_SPC_BAD_MONIKER_UUID */
    { 0x00e70c,  27, 0x0135af,  21,   -23408 }, /* VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT */
    { 0x00dff2,  28, 0x00c43c,  30,   -23407 }, /* VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA */
    { 0x015330,  19, 0x00a91e,  33,   -23406 }, /* VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH */
    { 0x01a002,  12, 0x018320,  15,   -23405 }, /* VERR_CR_SPC_UNKNOWN_DIGEST_ALGO */
    { 0x00c0e6,  31, 0x0022cb,  63,   -23404 }, /* VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS */
    { 0x00cf74,  29, 0x005f5f,  45,   -23403 }, /* VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH */
    { 0x010b56,  24, 0x001a87,  66,   -23402 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO */
    { 0x00bb55,  31, 0x004c1a,  50,   -23401 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS */
    { 0x01827b,  15, 0x01be95,   6,   -23400 }, /* VERR_CR_SPC_GENERIC_ERROR */
    { 0x00e778,  27, 0x01a0b6,  12,   -23310 }, /* VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED */
    { 0x014d1a,  19, 0x00322d,  57,   -23309 }, /* VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB */
    { 0x013b2d,  20, 0x003661,  56,   -23308 }, /* VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH */
    { 0x0139d9,  20, 0x001718,  68,   -23307 }, /* VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB */
    { 0x013b05,  20, 0x0031bb,  57,   -23306 }, /* VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB */
    { 0x012e8c,  21, 0x0032d8,  57,   -23305 }, /* VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH */
    { 0x012c55,  21, 0x00175c,  68,   -23304 }, /* VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB */
    { 0x018bb6,  14, 0x00b604,  32,   -23303 }, /* VERR_CR_PKCS7_KEY_USAGE_MISMATCH */
    { 0x012291,  22, 0x01aad3,  11,   -23302 }, /* VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND */
    { 0x017a49,  16, 0x008558,  39,   -23301 }, /* VERR_CR_PKCS7_NO_SIGNER_INFOS */
    { 0x019eb2,  12, 0x01b17a,  10,   -23300 }, /* VERR_CR_PKCS7_GENERIC_ERROR */
    { 0x00ff54,  25, 0x00ae6c,  24,   -23109 }, /* VERR_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x00a0c6,  34, 0x01b95c,   8,   -23108 }, /* VERR_X509_CERTIFICATE_VERIFICATION_FAILURE */
    { 0x0110de,  24, 0x01195c,  23,   -23107 }, /* VERR_X509_PRINT_EXTENSION_TO_BIO */
    { 0x00cdfb,  29, 0x00d5c6,  28,   -23106 }, /* VERR_X509_GETTING_DATA_FROM_EXTENSION */
    { 0x00cb60,  29, 0x0086da,  38,   -23105 }, /* VERR_X509_GETTING_EXTENSION_FROM_CERT */
    { 0x013489,  21, 0x0100b2,  25,   -23104 }, /* VERR_X509_NO_BASIC_CONSTARAINTS */
    { 0x00f293,  26, 0x01a0b6,  12,   -23103 }, /* VERR_X509_RSA_VERIFICATION_FUILURE */
    { 0x00d0ed,  29, 0x00ab0d,  33,   -23102 }, /* VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY */
    { 0x00ef1f,  26, 0x0068e0,  43,   -23101 }, /* VERR_X509_EXTRACT_PUBKEY_FROM_CERT */
    { 0x011596,  23, 0x00ac99,  33,   -23100 }, /* VERR_X509_READING_CERT_FROM_BIO */
    { 0x0199dc,  13, 0x016215,  18,   -23090 }, /* VERR_CR_X509_OSSL_D2I_FAILED */
    { 0x017aa9,  16, 0x01025b,  25,   -23037 }, /* VERR_CR_X509_CPB_BAD_CERT_CTX */
    { 0x00b524,  32, 0x003581,  56,   -23036 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX */
    { 0x00b164,  32, 0x0035b9,  56,   -23035 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN */
    { 0x009b4e,  35, 0x00399f,  54,   -23034 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE */
    { 0x013507,  21, 0x011a2b,  23,   -23033 }, /* VERR_CR_X509_CPV_NOT_VALID_AT_TIME */
    { 0x0182a8,  15, 0x0037e7,  55,   -23032 }, /* VERR_CR_X509_CPV_ISSUER_MISMATCH */
    { 0x00f1dd,  26, 0x004f33,  49,   -23031 }, /* VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED */
    { 0x012055,  22, 0x008ed5,  37,   -23030 }, /* VERR_CR_X509_CPV_NAME_NOT_PERMITTED */
    { 0x011a9e,  23, 0x008e8b,  37,   -23029 }, /* VERR_CR_X509_CPV_NO_PERMITTED_NAMES */
    { 0x0124a1,  22, 0x00809f,  39,   -23028 }, /* VERR_CR_X509_CPV_INVALID_POLICY_MAPPING */
    { 0x017f06,  15, 0x0093e0,  36,   -23027 }, /* VERR_CR_X509_CPV_NOT_V3_CERT */
    { 0x01836b,  15, 0x00588a,  47,   -23026 }, /* VERR_CR_X509_CPV_NOT_CA_CERT */
    { 0x011ffd,  22, 0x004a58,  50,   -23025 }, /* VERR_CR_X509_CPV_MAX_PATH_LENGTH */
    { 0x0123db,  22, 0x004990,  50,   -23024 }, /* VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN */
    { 0x00f433,  26, 0x010a06,  24,   -23023 }, /* VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION */
    { 0x0145a4,  20, 0x015d3b,  18,   -23022 }, /* VERR_CR_X509_CPV_NO_VALID_POLICY */
    { 0x01394b,  21, 0x0152ab,  19,   -23021 }, /* VERR_CR_X509_CPV_NO_TRUSTED_PATHS */
    { 0x0114f5,  23, 0x005a8e,  46,   -23020 }, /* VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY */
    { 0x00c5e0,  30, 0x01330f,  21,   -23019 }, /* VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION */
    { 0x014acd,  19, 0x00b304,  32,   -23018 }, /* VERR_CR_X509_VALIDITY_SWAPPED */
    { 0x013792,  21, 0x010a96,  24,   -23017 }, /* VERR_CR_X509_NAME_EMPTY_SUB_SET */
    { 0x016cbe,  17, 0x014dd8,  19,   -23016 }, /* VERR_CR_X509_NAME_EMPTY_SET */
    { 0x01ad89,  10, 0x0187fd,  15,   -23015 }, /* VERR_CR_X509_NAME_NOT_STRING */
    { 0x018212,  15, 0x01ae0b,  10,   -23014 }, /* VERR_CR_X509_NAME_EMPTY_STRING */
    { 0x018d84,  14, 0x01a9d6,  11,   -23013 }, /* VERR_CR_X509_INVALID_NAME_STRING_TAG */
    { 0x01471f,  20, 0x014fa0,  19,   -23012 }, /* VERR_CR_X509_PUBLIC_KEY_TOO_SMALL */
    { 0x0199c2,  13, 0x01c0ef,   3,   -23011 }, /* VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION */
    { 0x008a44,  38, 0x00cdc1,  29,   -23010 }, /* VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS */
    { 0x00debe,  28, 0x0084bc,  39,   -23009 }, /* VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2 */
    { 0x01211b,  22, 0x00b0c4,  32,   -23008 }, /* VERR_CR_X509_TBSCERT_EXTS_REQ_V3 */
    { 0x011bb2,  23, 0x001605,  69,   -23007 }, /* VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH */
    { 0x015473,  19, 0x012eb6,  21,   -23006 }, /* VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH */
    { 0x015993,  18, 0x01c0f2,   3,   -23005 }, /* VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO */
    { 0x01736a,  16, 0x013af1,  20,   -23004 }, /* VERR_CR_X509_NO_TRUST_ANCHOR */
    { 0x01a51e,  12, 0x01486d,  19,   -23003 }, /* VERR_CR_X509_NOT_VERIFIED */
    { 0x0184d3,  15, 0x01bd27,   6,   -23002 }, /* VERR_CR_X509_CERTPATHS_INTERNAL_ERROR */
    { 0x01bf6b,   5, 0x01bd27,   6,   -23001 }, /* VERR_CR_X509_INTERNAL_ERROR */
    { 0x01a536,  12, 0x01c0e9,   3,   -23000 }, /* VERR_CR_X509_GENERIC_ERROR */
    { 0x00d3df,  29, 0x00d51e,  29,   -22992 }, /* VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS */
    { 0x015fe7,  18, 0x00c3c4,  30,   -22991 }, /* VERR_LDRLX_NRICHAIN_NOT_SUPPORTED */
    { 0x01652c,  17, 0x0169b0,  17,   -22990 }, /* VERR_LDRLX_BAD_FORWARDER */
    { 0x018a20,  14, 0x01b6bc,   8,   -22989 }, /* VERR_LDRLX_BAD_SONAME */
    { 0x018d14,  14, 0x01b5dd,   8,   -22988 }, /* VERR_LDRLX_NO_SONAME */
    { 0x01913c,  14, 0x019b14,  13,   -22987 }, /* VERR_LDRLX_BAD_BUNDLE */
    { 0x016609,  17, 0x00e9ca,  27,   -22986 }, /* VERR_LDRLX_BAD_ITERDATA2 */
    { 0x016609,  16, 0x010643,  25,   -22985 }, /* VERR_LDRLX_BAD_ITERDATA */
    { 0x01a33e,  12, 0x01044f,  25,   -22984 }, /* VERR_LDRLX_BAD_PAGE_MAP */
    { 0x0140b9,  20, 0x014fd9,  19,   -22983 }, /* VERR_LDRLX_BAD_OBJECT_TABLE */
    { 0x013291,  21, 0x009228,  37,   -22982 }, /* VERR_LDRLX_BAD_FIXUP_SECTION */
    { 0x012357,  22, 0x00b704,  32,   -22981 }, /* VERR_LDRLX_BAD_LOADER_SECTION */
    { 0x019246,  14, 0x016708,  17,   -22980 }, /* VERR_LDRLX_BAD_HEADER */
    { 0x012a87,  21, 0x016482,  17,   -22979 }, /* VERR_LDR_ADDRESS_OVERFLOW */
    { 0x01abba,  11, 0x0195d9,  13,   -22978 }, /* VERR_LDR_BAD_FIXUP */
    { 0x017669,  16, 0x01bbff,   7,   -22977 }, /* VERR_LDR_NO_IMAGE_UUID */
    { 0x00e5fe,  27, 0x0119a1,  23,   -22976 }, /* VERR_LDR_DUPLICATE_SEGMENT_NAME */
    { 0x01a91b,  11, 0x010a66,  24,   -22975 }, /* VERR_LDRMACHO_BAD_SYMTAB_SIZE */
    { 0x01bd33,   6, 0x00e3fd,  27,   -22974 }, /* VERR_LDRMACHO_TODO */
    { 0x014fec,  19, 0x007b7a,  40,   -22973 }, /* VERR_LDRMACHO_NON_CONT_SEG_BITS */
    { 0x00e268,  27, 0x007f62,  40,   -22972 }, /* VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS */
    { 0x01b121,  10, 0x019c72,  12,   -22971 }, /* VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE */
    { 0x01b572,   9, 0x017fba,  15,   -22970 }, /* VERR_LDRMACHO_BAD_SYMBOL */
    { 0x018e64,  14, 0x01734a,  16,   -22969 }, /* VERR_LDRMACHO_BAD_OBJECT_FILE */
    { 0x01b518,   9, 0x006289,  45,   -22968 }, /* VERR_LDRMACHO_BIT_MIX */
    { 0x017be8,  16, 0x0058e8,  47,   -22967 }, /* VERR_LDRMACHO_BAD_SECTION_ORDER */
    { 0x01ac7b,  10, 0x00d90e,  28,   -22966 }, /* VERR_LDRMACHO_UNKNOWN_SECTION */
    { 0x01806e,  15, 0x0103a0,  25,   -22965 }, /* VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION */
    { 0x01870d,  15, 0x00fbd1,  25,   -22964 }, /* VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION */
    { 0x01b0a9,  10, 0x00fe73,  25,   -22963 }, /* VERR_LDRMACHO_UNSUPPORTED_SECTION */
    { 0x017be8,  10, 0x01b413,   9,   -22962 }, /* VERR_LDRMACHO_BAD_SECTION */
    { 0x017ee8,  15, 0x00944c,  36,   -22961 }, /* VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND */
    { 0x0180f5,  15, 0x01171d,  23,   -22960 }, /* VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND */
    { 0x01817c,  15, 0x016ddf,  17,   -22959 }, /* VERR_LDRMACHO_BAD_LOAD_COMMAND */
    { 0x01b059,  10, 0x004765,  51,   -22958 }, /* VERR_LDRMACHO_UNSUPPORTED_MACHINE */
    { 0x01bf2f,   5, 0x01af4b,  10,   -22957 }, /* VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE */
    { 0x01b596,   9, 0x006e69,  42,   -22956 }, /* VERR_LDRMACHO_BAD_HEADER */
    { 0x0168d3,  17, 0x00914a,  37,   -22955 }, /* VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED */
    { 0x015886,  18, 0x009b94,  35,   -22954 }, /* VERR_LDR_FORWARDERS_NOT_SUPPORTED */
    { 0x013864,  21, 0x009e2d,  35,   -22953 }, /* VERR_LDR_FORWARDER_CHAIN_TOO_LONG */
    { 0x018749,  15, 0x00f023,  26,   -22952 }, /* VERR_LDR_BAD_FORWARDER */
    { 0x0181e5,  15, 0x011f4d,  22,   -22951 }, /* VERR_LDR_NOT_FORWARDER */
    { 0x013864,  14, 0x007b52,  40,   -22950 }, /* VERR_LDR_FORWARDER */
    { 0x018e02,  14, 0x00abb2,  33,   -22930 }, /* VERR_LDRVI_BAD_CERT_FORMAT */
    { 0x018aba,  14, 0x013f15,  20,   -22929 }, /* VERR_LDRVI_IMAGE_HASH_MISMATCH */
    { 0x01b2cf,   9, 0x01538f,  19,   -22928 }, /* VERR_LDRVI_PAGE_HASH_MISMATCH */
    { 0x00a47e,  34, 0x004499,  52,   -22927 }, /* VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA */
    { 0x00d97e,  28, 0x009eff,  35,   -22926 }, /* VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED */
    { 0x016e34,  17, 0x0063ea,  44,   -22925 }, /* VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG */
    { 0x01257d,  22, 0x01355b,  21,   -22924 }, /* VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW */
    { 0x009914,  36, 0x001272,  72,   -22923 }, /* VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID */
    { 0x01b734,   8, 0x01a36e,  12,   -22922 }, /* VERR_LDRVI_PARSE_BER_ERROR */
    { 0x01be4d,   6, 0x00de86,  28,   -22921 }, /* VERR_LDRVI_PARSE_IPE */
    { 0x01bc76,   7, 0x012903,  22,   -22919 }, /* VERR_LDRVI_UNSUPPORTED_ARCH */
    { 0x01057b,  25, 0x007c1a,  40,   -22918 }, /* VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH */
    { 0x0102bf,  25, 0x006c3c,  43,   -22917 }, /* VERR_LDRVI_SECTION_RAW_DATA_VALUES */
    { 0x0174ca,  16, 0x01710a,  16,   -22916 }, /* VERR_LDRVI_INVALID_SECTION_COUNT */
    { 0x01a18e,  12, 0x01740a,  16,   -22915 }, /* VERR_LDRVI_BAD_MZ_OFFSET */
    { 0x017659,  16, 0x00c8b0,  30,   -22914 }, /* VERR_LDRVI_BAD_CERT_MULTIPLE */
    { 0x0197ad,  13, 0x01740a,  16,   -22913 }, /* VERR_LDRVI_BAD_CERT_HDR_TYPE */
    { 0x014747,  20, 0x01740a,  16,   -22912 }, /* VERR_LDRVI_BAD_CERT_HDR_REVISION */
    { 0x015b1f,  18, 0x01740a,  16,   -22911 }, /* VERR_LDRVI_BAD_CERT_HDR_LENGTH */
    { 0x0137a7,  21, 0x00fb6d,  25,   -22910 }, /* VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY */
    { 0x01a122,  12, 0x009404,  36,   -22909 }, /* VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT */
    { 0x01b081,  10, 0x00ba9b,  31,   -22908 }, /* VERR_LDRVI_NO_MEMORY_SHDRS */
    { 0x018fb4,  14, 0x004a8a,  50,   -22907 }, /* VERR_LDRVI_NO_MEMORY_SIGNATURE */
    { 0x01bd3f,   6, 0x00dc3a,  28,   -22906 }, /* VERR_LDRVI_NO_MEMORY_STATE */
    { 0x01ab6d,  11, 0x00c658,  30,   -22905 }, /* VERR_LDRVI_FILE_LENGTH_ERROR */
    { 0x0194e2,  13, 0x00ed2a,  27,   -22904 }, /* VERR_LDRVI_READ_ERROR_HASH */
    { 0x015874,  18, 0x005f32,  45,   -22903 }, /* VERR_LDRVI_READ_ERROR_SIGNATURE */
    { 0x018c96,  14, 0x00f0f3,  26,   -22902 }, /* VERR_LDRVI_READ_ERROR_SHDRS */
    { 0x01a176,  12, 0x00ee02,  26,   -22901 }, /* VERR_LDRVI_READ_ERROR_HDR */
    { 0x01b3c2,   9, 0x00b2e4,  32,   -22900 }, /* VERR_LDRVI_NOT_SIGNED */
    { 0x01bd9f,   6, 0x01c035,   4,   -22899 }, /* VERR_ASN1_INTERNAL_ERROR_5 */
    { 0x01bda5,   6, 0x01c035,   4,   -22898 }, /* VERR_ASN1_INTERNAL_ERROR_4 */
    { 0x01bdab,   6, 0x01c035,   4,   -22897 }, /* VERR_ASN1_INTERNAL_ERROR_3 */
    { 0x01bdb7,   6, 0x01c035,   4,   -22896 }, /* VERR_ASN1_INTERNAL_ERROR_2 */
    { 0x01bdb1,   6, 0x01c035,   4,   -22895 }, /* VERR_ASN1_INTERNAL_ERROR_1 */
    { 0x01a2de,  12, 0x01c11d,   2,   -22857 }, /* VERR_ASN1_INVALID_INTEGER_ENCODING */
    { 0x01b5b1,   9, 0x0168a0,  17,   -22856 }, /* VERR_ASN1_UNEXPECTED_OBJ_ID */
    { 0x01717a,  16, 0x01c113,   2,   -22855 }, /* VERR_ASN1_TOO_DEEPLY_NESTED */
    { 0x0187b2,  15, 0x015b9d,  18,   -22854 }, /* VERR_ASN1_INVALID_DATA_POINTER */
    { 0x013c45,  20, 0x01a2ea,  12,   -22853 }, /* VERR_ASN1_EXPECTED_PRIMITIVE */
    { 0x01bd02,   7, 0x006391,   1,   -22852 }, /* VERR_ASN1_TOO_LONG */
    { 0x019024,  14, 0x01c119,   2,   -22851 }, /* VERR_ASN1_DUMMY_OBJECT */
    { 0x0188a6,  14, 0x006391,   1,   -22850 }, /* VERR_ASN1_DYNTYPE_BAD_TAG */
    { 0x014bea,  19, 0x0184e2,  15,   -22849 }, /* VERR_ASN1_DYNTYPE_TAG_NOT_IMPL */
    { 0x0191d6,  14, 0x01c11d,   2,   -22848 }, /* VERR_ASN1_INVALID_BITSTRING_ENCODING */
    { 0x01b33b,   9, 0x01c11d,   2,   -22847 }, /* VERR_ASN1_INVALID_NULL_ENCODING */
    { 0x01a12e,  12, 0x01c11d,   2,   -22846 }, /* VERR_ASN1_INVALID_BOOLEAN_ENCODING */
    { 0x012d66,  21, 0x01c11d,   2,   -22845 }, /* VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING */
    { 0x0195a5,  13, 0x01c11d,   2,   -22844 }, /* VERR_ASN1_INVALID_UTC_TIME_ENCODING */
    { 0x016197,  18, 0x017ad9,  16,   -22843 }, /* VERR_ASN1_TIME_NORMALIZE_MISMATCH */
    { 0x0161df,  18, 0x019745,  13,   -22842 }, /* VERR_ASN1_TIME_NORMALIZE_ERROR */
    { 0x0114b0,  23, 0x01c115,   2,   -22841 }, /* VERR_ASN1_TIME_BAD_NORMALIZE_INPUT */
    { 0x00fd48,  25, 0x006391,   1,   -22840 }, /* VERR_ASN1_BITSTRING_OUT_OF_BOUNDS */
    { 0x00fd2f,  25, 0x01c119,   2,   -22839 }, /* VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH */
    { 0x018ec6,  14, 0x01c119,   2,   -22838 }, /* VERR_ASN1_CURSOR_TAG_MISMATCH */
    { 0x00c41e,  30, 0x007205,  42,   -22837 }, /* VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING */
    { 0x00f584,  26, 0x018c26,  14,   -22836 }, /* VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT */
    { 0x015038,  19, 0x01a452,  12,   -22835 }, /* VERR_ASN1_CURSOR_NO_MORE_DATA */
    { 0x015c51,  16, 0x006391,   1,   -22834 }, /* VERR_ASN1_CURSOR_BAD_LENGTH */
    { 0x00ec6d,  27, 0x00932b,  37,   -22833 }, /* VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH */
    { 0x00a5b0,  34, 0x0084e3,  39,   -22832 }, /* VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH */
    { 0x015c51,  18, 0x01c115,   2,   -22831 }, /* VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING */
    { 0x01663c,  17, 0x01bea1,   6,   -22830 }, /* VERR_ASN1_CURSOR_LONG_TAG */
    { 0x01724a,  16, 0x006366,  44,   -22829 }, /* VERR_ASN1_CURSOR_NOT_AT_END */
    { 0x01ac5d,  10, 0x006391,   1,   -22828 }, /* VERR_ASN1_NOT_PRESENT */
    { 0x01219f,  22, 0x006391,   1,   -22827 }, /* VERR_ASN1_NO_CHECK_SANITY_METHOD */
    { 0x01b4d0,   9, 0x006391,   1,   -22826 }, /* VERR_ASN1_NO_VTABLE */
    { 0x0158df,  18, 0x017ef7,  15,   -22825 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET */
    { 0x015b8b,  18, 0x00aaec,  33,   -22824 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ */
    { 0x015927,  18, 0x00a879,  33,   -22823 }, /* VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ */
    { 0x01a332,  12, 0x0126c7,  22,   -22820 }, /* VERR_ASN1_TIME_TAG_MISMATCH */
    { 0x01b35f,   9, 0x015c99,  18,   -22819 }, /* VERR_ASN1_STRING_TAG_MISMATCH */
    { 0x0133f6,  21, 0x00e6a0,  27,   -22818 }, /* VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL */
    { 0x016939,  17, 0x018410,  15,   -22817 }, /* VERR_ASN1_OBJID_INVALID_DOTTED_STRING */
    { 0x0144c8,  20, 0x00e619,  27,   -22816 }, /* VERR_ASN1_OBJID_TOO_LONG_STRING_FORM */
    { 0x013c09,  20, 0x014ce1,  19,   -22815 }, /* VERR_ASN1_OBJID_TOO_MANY_COMPONENTS */
    { 0x01295b,  22, 0x017819,  16,   -22814 }, /* VERR_ASN1_OBJID_COMPONENT_TOO_BIG */
    { 0x01b10d,  10, 0x01c11d,   2,   -22813 }, /* VERR_ASN1_INVALID_OBJID_ENCODING */
    { 0x01acfd,  10, 0x01c11d,   2,   -22812 }, /* VERR_ASN1_INVALID_BMP_STRING_ENCODING */
    { 0x017589,  16, 0x01c11d,   2,   -22811 }, /* VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING */
    { 0x0191ba,  14, 0x01c11d,   2,   -22810 }, /* VERR_ASN1_INVALID_GENERAL_STRING_ENCODING */
    { 0x018c0a,  14, 0x01c11d,   2,   -22809 }, /* VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING */
    { 0x01888a,  14, 0x01c11d,   2,   -22808 }, /* VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING */
    { 0x01af5f,  10, 0x01c11d,   2,   -22807 }, /* VERR_ASN1_INVALID_IA5_STRING_ENCODING */
    { 0x0181f4,  15, 0x01c11d,   2,   -22806 }, /* VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING */
    { 0x01b152,  10, 0x01c11d,   2,   -22805 }, /* VERR_ASN1_INVALID_T61_STRING_ENCODING */
    { 0x017559,  16, 0x01c11d,   2,   -22804 }, /* VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING */
    { 0x018cdc,  14, 0x01c11d,   2,   -22803 }, /* VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING */
    { 0x01a671,  11, 0x01c11d,   2,   -22802 }, /* VERR_ASN1_INVALID_UTF8_STRING_ENCODING */
    { 0x015766,  18, 0x01c10d,   3,   -22801 }, /* VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED */
    { 0x01c0f8,   3, 0x0118bb,  23,   -22800 }, /* VERR_ASN1_ERROR */
    { 0x00a05d,  35, 0x00275f,  60,   -22739 }, /* VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH */
    { 0x0105c6,  25, 0x0039d5,  54,   -22738 }, /* VERR_XAR_UNUSED_ARCHIVED_DATA */
    { 0x013d0d,  20, 0x00675a,  44,   -22737 }, /* VERR_XAR_ARCHIVED_HASH_MISMATCH */
    { 0x010562,  25, 0x00d2f7,  29,   -22736 }, /* VERR_XAR_EXTRACTED_SIZE_EXCEEDED */
    { 0x013420,  21, 0x005e51,  45,   -22735 }, /* VERR_XAR_EXTRACTED_HASH_MISMATCH */
    { 0x01a76e,  11, 0x016ffa,  16,   -22734 }, /* VERR_XAR_INVALID_FILE_NAME */
    { 0x01a30e,  12, 0x014c6f,  19,   -22733 }, /* VERR_XAR_BAD_FILE_INODE */
    { 0x0179f9,  16, 0x01462f,  20,   -22732 }, /* VERR_XAR_BAD_FILE_DEVICE_NO */
    { 0x01ae65,  10, 0x013084,  21,   -22731 }, /* VERR_XAR_BAD_FILE_GID */
    { 0x01b063,  10, 0x014554,  20,   -22730 }, /* VERR_XAR_BAD_FILE_UID */
    { 0x01a88c,  11, 0x016719,  17,   -22729 }, /* VERR_XAR_BAD_FILE_MODE */
    { 0x016edb,  16, 0x0136ab,  21,   -22728 }, /* VERR_XAR_BAD_FILE_TIMESTAMP */
    { 0x01bb7a,   7, 0x00c04b,  31,   -22727 }, /* VERR_XAR_NO_ENCODING */
    { 0x01b63d,   8, 0x01b635,   8,   -22726 }, /* VERR_XAR_UNKNOWN_FILE_TYPE */
    { 0x0148df,  19, 0x014643,  20,   -22725 }, /* VERR_XAR_MISSING_DATA_ELEMENT */
    { 0x0190e8,  14, 0x015d29,  18,   -22724 }, /* VERR_XAR_BAD_FILE_ELEMENT */
    { 0x0141a9,  20, 0x0101c5,  25,   -22723 }, /* VERR_XAR_BAD_LENGTH_ELEMENT */
    { 0x013252,  21, 0x00b244,  32,   -22722 }, /* VERR_XAR_MISSING_LENGTH_ELEMENT */
    { 0x018776,  15, 0x014821,  19,   -22721 }, /* VERR_XAR_BAD_SIZE_ELEMENT */
    { 0x0172fa,  16, 0x00f770,  26,   -22720 }, /* VERR_XAR_MISSING_SIZE_ELEMENT */
    { 0x01399d,  20, 0x010594,  25,   -22719 }, /* VERR_XAR_BAD_OFFSET_ELEMENT */
    { 0x013195,  21, 0x00b4e4,  32,   -22718 }, /* VERR_XAR_MISSING_OFFSET_ELEMENT */
    { 0x00d331,  29, 0x001348,  71,   -22717 }, /* VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER */
    { 0x019808,  13, 0x011ec9,  22,   -22716 }, /* VERR_XAR_BAD_DIGEST_LENGTH */
    { 0x013b41,  20, 0x0070df,  42,   -22715 }, /* VERR_XAR_HASH_FUNCTION_MISMATCH */
    { 0x012685,  22, 0x00be99,  31,   -22714 }, /* VERR_XAR_BAD_CHECKSUM_ELEMENT */
    { 0x01a86b,  11, 0x01728a,  16,   -22713 }, /* VERR_XAR_TOC_DIGEST_MISMATCH */
    { 0x00d3fc,  29, 0x002722,  61,   -22712 }, /* VERR_XML_TOC_ELEMENT_HAS_SIBLINGS */
    { 0x016203,  18, 0x008adc,  38,   -22711 }, /* VERR_XML_TOC_ELEMENT_MISSING */
    { 0x01833e,  15, 0x00c81a,  30,   -22710 }, /* VERR_XAR_TOC_XML_PARSE_ERROR */
    { 0x0187a3,  15, 0x012433,  22,   -22709 }, /* VERR_XAR_TOC_UTF8_ENCODING */
    { 0x01676e,  17, 0x009022,  37,   -22708 }, /* VERR_XAR_TOC_STRLEN_MISMATCH */
    { 0x015155,  19, 0x0040bc,  53,   -22707 }, /* VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH */
    { 0x010a36,  24, 0x012ca9,  21,   -22706 }, /* VERR_XAR_TOC_TOO_BIG_COMPRESSED */
    { 0x010a36,  13, 0x0179b9,  16,   -22705 }, /* VERR_XAR_TOC_TOO_BIG */
    { 0x017c82,  15, 0x006f3b,  42,   -22704 }, /* VERR_XAR_TOC_TOO_SMALL */
    { 0x01493e,  19, 0x015939,  18,   -22703 }, /* VERR_XAR_UNSUPPORTED_HASH_FUNCTION */
    { 0x01bae8,   7, 0x01b2d8,   9,   -22702 }, /* VERR_XAR_UNSUPPORTED_VERSION */
    { 0x01aa86,  11, 0x01bad3,   7,   -22701 }, /* VERR_XAR_BAD_HDR_SIZE */
    { 0x0177a9,  16, 0x019405,  13,   -22700 }, /* VERR_XAR_WRONG_MAGIC */
    { 0x01531d,  19, 0x0089d2,  38,   -22600 }, /* VERR_FILESYSTEM_CORRUPT */
    { 0x011b3f,  23, 0x015084,  19,   -22503 }, /* VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY */
    { 0x017d63,  15, 0x01b13e,  10,   -22502 }, /* VERR_SYS_SHUTDOWN_FAILED */
    { 0x01373e,  21, 0x008c58,  38,   -22500 }, /* VERR_SYS_CANNOT_POWER_OFF */
    { 0x00ee1c,  26, 0x0034a0,  57,   -22430 }, /* VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION */
    { 0x017f33,  15, 0x018311,  15,   -22429 }, /* VERR_INSTALLATION_FAILED */
    { 0x018924,  14, 0x016bf2,  17,   -22428 }, /* VERR_REBOOT_NEEDED */
    { 0x018230,  15, 0x00f978,  26,   -22427 }, /* VERR_FLOAT_OVERFLOW */
    { 0x017989,  16, 0x00e283,  27,   -22426 }, /* VERR_FLOAT_UNDERFLOW */
    { 0x011f63,  22, 0x002b90,  59,   -22425 }, /* VERR_PROC_NO_ARG_TRANSLATION */
    { 0x011ef5,  22, 0x012b1a,  21,   -22424 }, /* VERR_THREAD_IS_TERMINATING */
    { 0x0198f2,  13, 0x0100cb,  25,   -22423 }, /* VERR_TOO_MANY_REFERENCES */
    { 0x01b7dc,   8, 0x019460,  13,   -22422 }, /* VERR_EMPTY_STRING */
    { 0x018de6,  14, 0x006e93,  42,   -22421 }, /* VERR_NO_STRING_TERMINATOR */
    { 0x013add,  20, 0x008fb3,  37,   -22420 }, /* VERR_INCOMPATIBLE_CONFIG */
    { 0x010d4e,  24, 0x00ef87,  26,   -22419 }, /* VERR_PROC_ELEVATION_REQUIRED */
    { 0x01a266,  12, 0x019d02,  12,   -22418 }, /* VERR_INVALID_SESSION_ID */
    { 0x01a7d1,  11, 0x01a876,  11,   -22417 }, /* VERR_INVALID_CLIENT_ID */
    { 0x015aa1,  18, 0x012c16,  21,   -22416 }, /* VERR_WRONG_PARAMETER_TYPE */
    { 0x0120c3,  22, 0x0124cd,  22,   -22415 }, /* VERR_WRONG_PARAMETER_COUNT */
    { 0x01b103,  10, 0x0177f9,  16,   -22414 }, /* VERR_MP_TOO_MANY_CPUS */
    { 0x014d66,  19, 0x000e72,  75,   -22413 }, /* VERR_PROC_IQ_PRIV_NOT_HELD */
    { 0x0140f5,  20, 0x000c04,  80,   -22412 }, /* VERR_PROC_APT_PRIV_NOT_HELD */
    { 0x0144f0,  20, 0x0003ea, 104,   -22411 }, /* VERR_PROC_TCB_PRIV_NOT_HELD */
    { 0x0171da,  16, 0x00310d,  58,   -22410 }, /* VERR_PRIVILEGE_NOT_HELD */
    { 0x01b5e5,   8, 0x01a63a,  11,   -22409 }, /* VERR_WRONG_TYPE */
    { 0x01c11b,   2, 0x01b464,   9,   -22408 }, /* VERR_MISMATCH */
    { 0x017ba8,  16, 0x014db2,  19,   -22407 }, /* VERR_ALLOCATION_TOO_BIG */
    { 0x00bc0f,  31, 0x0060c7,  45,   -22406 }, /* VERR_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x014c82,  19, 0x008b9a,  38,   -22405 }, /* VERR_ACCOUNT_RESTRICTED */
    { 0x01808c,  15, 0x009f8b,  35,   -22404 }, /* VERR_PROC_DETACH_NOT_SUPPORTED */
    { 0x01aa0d,  11, 0x0074c8,  41,   -22403 }, /* VERR_NOT_AVAILABLE */
    { 0x019be4,  13, 0x019bfe,  13,   -22402 }, /* VERR_UNEVEN_INPUT */
    { 0x016cf1,  17, 0x01653d,  17,   -22401 }, /* VERR_BUFFER_UNDERFLOW */
    { 0x01aaa7,  11, 0x006936,  43,   -22400 }, /* VERR_UNEXPECTED_EXCEPTION */
    { 0x01b79c,   8, 0x01665e,  17,   -22360 }, /* VERR_CR_PKCS7_NOT_DATA */
    { 0x0101ac,  25, 0x007eea,  40,   -22359 }, /* VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH */
    { 0x01146b,  23, 0x008114,  39,   -22358 }, /* VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED */
    { 0x00b464,  32, 0x006013,  45,   -22357 }, /* VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO */
    { 0x017c08,  16, 0x00d4e4,  29,   -22356 }, /* VERR_CR_PKCS7_SIGNER_INFO_VERSION */
    { 0x00e1fc,  27, 0x00532f,  48,   -22355 }, /* VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO */
    { 0x01673b,  17, 0x00d127,  29,   -22354 }, /* VERR_CR_PKCS7_EXPECTED_NO_CRLS */
    { 0x0175d9,  16, 0x0076b4,  41,   -22353 }, /* VERR_CR_PKCS7_NO_CERTIFICATES */
    { 0x019166,  14, 0x0111e6,  24,   -22352 }, /* VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM */
    { 0x0126dd,  22, 0x00813b,  39,   -22351 }, /* VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS */
    { 0x0177e9,  16, 0x010468,  25,   -22350 }, /* VERR_CR_PKCS7_SIGNED_DATA_VERSION */
    { 0x01adc5,  10, 0x009c20,  35,   -22320 }, /* VERR_CR_PKCS7_DIGEST_CALC_ERROR */
    { 0x01a296,  12, 0x011c6a,  23,   -22319 }, /* VERR_CR_PKCS7_DIGEST_CREATE_ERROR */
    { 0x017869,  16, 0x0068b5,  43,   -22318 }, /* VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS */
    { 0x01818b,  15, 0x0073a9,  41,   -22317 }, /* VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS */
    { 0x01832f,  15, 0x010826,  24,   -22316 }, /* VERR_CR_PKCS7_NOT_SIGNED_DATA */
    { 0x0154ac,  19, 0x0026a8,  61,   -22315 }, /* VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST */
    { 0x0175e9,  16, 0x0061a8,  45,   -22314 }, /* VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL */
    { 0x01700a,  16, 0x015da7,  18,   -22313 }, /* VERR_CR_PKCS7_OSSL_VERIFY_FAILED */
    { 0x0193d1,  13, 0x0153c8,  19,   -22312 }, /* VERR_CR_PKCS7_OSSL_D2I_FAILED */
    { 0x01c001,   5, 0x01ac35,  10,   -22311 }, /* VERR_CR_PKCS7_INTERNAL_ERROR */
    { 0x018659,  15, 0x00d36b,  29,   -22300 }, /* VERR_LOG_REVISION_MISMATCH */
    { 0x017649,  16, 0x00bcc8,  31,   -22201 }, /* VERR_DVM_MAP_NO_VOLUME */
    { 0x018c34,  14, 0x00af24,  32,   -22200 }, /* VERR_DVM_MAP_EMPTY */
    { 0x0135c4,  21, 0x00334a,  57,   -22158 }, /* VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT */
    { 0x019094,  14, 0x00fea5,  25,   -22157 }, /* VERR_VFS_CHAIN_NOT_PATH_ONLY */
    { 0x016a7c,  17, 0x00197b,  67,   -22156 }, /* VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY */
    { 0x019b2e,  13, 0x000c54,  80,   -22155 }, /* VERR_VFS_CHAIN_PATH_ONLY */
    { 0x0157f6,  18, 0x0024bc,  62,   -22154 }, /* VERR_VFS_CHAIN_WRITE_ONLY_IOS */
    { 0x0168e4,  17, 0x001152,  72,   -22153 }, /* VERR_VFS_CHAIN_READ_ONLY_IOS */
    { 0x00fce4,  25, 0x001a44,  67,   -22152 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS */
    { 0x015f21,  18, 0x00630e,  44,   -22151 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_VFS */
    { 0x01a742,  11, 0x009884,  36,   -22150 }, /* VERR_VFS_CHAIN_TAKES_VFS */
    { 0x0198b1,  13, 0x006d94,  43,   -22149 }, /* VERR_VFS_CHAIN_TAKES_FSS */
    { 0x00fce4,  13, 0x00d19b,  29,   -22148 }, /* VERR_VFS_CHAIN_TAKES_DIR */
    { 0x016a5a,  17, 0x00784e,  41,   -22147 }, /* VERR_VFS_CHAIN_TAKES_FILE_OR_IOS */
    { 0x018efe,  14, 0x0117d5,  23,   -22146 }, /* VERR_VFS_CHAIN_TAKES_FILE */
    { 0x01699f,  17, 0x002e8f,  58,   -22145 }, /* VERR_VFS_CHAIN_ONLY_DIR_OR_VFS */
    { 0x0119cf,  23, 0x002e8f,  58,   -22144 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR */
    { 0x01ac8f,  10, 0x007a8a,  40,   -22143 }, /* VERR_VFS_CHAIN_ONLY_VFS */
    { 0x019f2a,  12, 0x00556b,  47,   -22142 }, /* VERR_VFS_CHAIN_ONLY_FSS */
    { 0x01699f,  12, 0x00adc2,  33,   -22141 }, /* VERR_VFS_CHAIN_ONLY_DIR */
    { 0x019fea,  12, 0x006d3e,  43,   -22140 }, /* VERR_VFS_CHAIN_ONLY_IOS */
    { 0x0119cf,  16, 0x006202,  45,   -22139 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS */
    { 0x01995a,  13, 0x011e9d,  22,   -22138 }, /* VERR_VFS_CHAIN_INVALID_ARGUMENT */
    { 0x0193f8,  13, 0x0108fe,  24,   -22137 }, /* VERR_VFS_CHAIN_EMPTY_ARG */
    { 0x01ad43,  10, 0x016280,  18,   -22136 }, /* VERR_VFS_CHAIN_TOO_MANY_ARGS */
    { 0x019a78,  13, 0x016280,  18,   -22135 }, /* VERR_VFS_CHAIN_TOO_FEW_ARGS */
    { 0x01461b,  20, 0x016280,  18,   -22134 }, /* VERR_VFS_CHAIN_AT_MOST_SIX_ARGS */
    { 0x013921,  21, 0x01485a,  19,   -22133 }, /* VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS */
    { 0x01a206,  12, 0x011b56,  23,   -22132 }, /* VERR_VFS_CHAIN_SIX_ARGS */
    { 0x012a33,  21, 0x0152be,  19,   -22131 }, /* VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS */
    { 0x012551,  22, 0x013e9d,  20,   -22130 }, /* VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS */
    { 0x019516,  13, 0x0110c6,  24,   -22129 }, /* VERR_VFS_CHAIN_FIVE_ARGS */
    { 0x01383a,  21, 0x01550b,  19,   -22128 }, /* VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS */
    { 0x01245f,  22, 0x013ab5,  20,   -22127 }, /* VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS */
    { 0x0199a8,  13, 0x01074e,  24,   -22126 }, /* VERR_VFS_CHAIN_FOUR_ARGS */
    { 0x011f37,  22, 0x013e75,  20,   -22125 }, /* VERR_VFS_CHAIN_AT_MOST_THREE_ARGS */
    { 0x01174b,  23, 0x0132a6,  21,   -22124 }, /* VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS */
    { 0x018b00,  14, 0x0103eb,  25,   -22123 }, /* VERR_VFS_CHAIN_THREE_ARGS */
    { 0x0142d4,  20, 0x01581a,  18,   -22122 }, /* VERR_VFS_CHAIN_AT_MOST_TWO_ARGS */
    { 0x012ecb,  21, 0x0150d0,  19,   -22121 }, /* VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS */
    { 0x01a24e,  12, 0x011790,  23,   -22120 }, /* VERR_VFS_CHAIN_TWO_ARGS */
    { 0x013b55,  20, 0x00eb0e,  27,   -22119 }, /* VERR_VFS_CHAIN_AT_LEAST_ONE_ARG */
    { 0x014c49,  19, 0x00f95e,  26,   -22118 }, /* VERR_VFS_CHAIN_AT_MOST_ONE_ARG */
    { 0x01ab99,  11, 0x00bdc0,  31,   -22117 }, /* VERR_VFS_CHAIN_ONE_ARG */
    { 0x01b42e,   9, 0x018f28,  14,   -22116 }, /* VERR_VFS_CHAIN_NO_ARGS */
    { 0x0196a9,  13, 0x00bd44,  31,   -22115 }, /* VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH */
    { 0x0187c1,  15, 0x018131,  15,   -22114 }, /* VERR_VFS_CHAIN_PROVIDER_NOT_FOUND */
    { 0x01bca7,   7, 0x01b7c4,   8,   -22113 }, /* VERR_VFS_CHAIN_IPE */
    { 0x01b1e8,  10, 0x01b545,   9,   -22112 }, /* VERR_VFS_CHAIN_CAST_FAILED */
    { 0x00e5c8,  27, 0x00e7ae,  27,   -22111 }, /* VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT */
    { 0x010229,  25, 0x00732b,  42,   -22110 }, /* VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT */
    { 0x0125bf,  22, 0x00c143,  31,   -22109 }, /* VERR_VFS_CHAIN_TRAILING_SEPARATOR */
    { 0x0132e5,  21, 0x00c388,  30,   -22108 }, /* VERR_VFS_CHAIN_LEADING_SEPARATOR */
    { 0x012131,  22, 0x014400,  20,   -22107 }, /* VERR_VFS_CHAIN_EXPECTED_SEPARATOR */
    { 0x00f6ef,  26, 0x016b37,  17,   -22106 }, /* VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME */
    { 0x00c892,  30, 0x01316b,  21,   -22105 }, /* VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES */
    { 0x00d022,  29, 0x013d49,  20,   -22104 }, /* VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES */
    { 0x01bdf9,   6, 0x019494,  13,   -22103 }, /* VERR_VFS_CHAIN_UNKNOWN_TYPE */
    { 0x0146a7,  20, 0x01b0b3,  10,   -22102 }, /* VERR_VFS_CHAIN_EXPECTED_ELEMENT */
    { 0x0193f8,   9, 0x010530,  25,   -22101 }, /* VERR_VFS_CHAIN_EMPTY */
    { 0x01a829,  11, 0x007daa,  40,   -22100 }, /* VERR_VFS_CHAIN_NO_PREFIX */
    { 0x019d0e,  12, 0x009fae,  35,   -22005 }, /* VERR_ZIP_BAD_HEADER */
    { 0x01a54e,  12, 0x00ab2e,  33,   -22004 }, /* VERR_ZIP_UNSUPPORTED_METHOD */
    { 0x01bce6,   7, 0x00a10a,  34,   -22003 }, /* VERR_ZIP_UNSUPPORTED_VERSION */
    { 0x01bb73,   7, 0x006b90,  43,   -22002 }, /* VERR_ZIP_NO_MEMORY */
    { 0x0189e8,  14, 0x010946,  24,   -22001 }, /* VERR_ZIP_CORRUPTED */
    { 0x01bd4b,   6, 0x01bd99,   6,   -22000 }, /* VERR_ZIP_ERROR */
    { 0x019933,  13, 0x005f05,  45,    -7602 }, /* VERR_GCM_NOT_HANDLED */
    { 0x01664d,  17, 0x00a0a3,  35,    -7400 }, /* VERR_PLATFORM_ARCH_NOT_SUPPORTED */
    { 0x01bf3e,   5, 0x01b9f4,   8,    -7399 }, /* VERR_IOMMU_IPE_9 */
    { 0x01bf5c,   5, 0x01b8c4,   8,    -7398 }, /* VERR_IOMMU_IPE_8 */
    { 0x01bf75,   5, 0x01b82c,   8,    -7397 }, /* VERR_IOMMU_IPE_7 */
    { 0x01bf7a,   5, 0x01b714,   8,    -7396 }, /* VERR_IOMMU_IPE_6 */
    { 0x01bf7f,   5, 0x01ba34,   8,    -7395 }, /* VERR_IOMMU_IPE_5 */
    { 0x01bf8e,   5, 0x01b93c,   8,    -7394 }, /* VERR_IOMMU_IPE_4 */
    { 0x01bf93,   5, 0x01b884,   8,    -7393 }, /* VERR_IOMMU_IPE_3 */
    { 0x01bfa7,   5, 0x01b754,   8,    -7392 }, /* VERR_IOMMU_IPE_2 */
    { 0x01bf98,   5, 0x01ba44,   8,    -7391 }, /* VERR_IOMMU_IPE_1 */
    { 0x01bfa2,   5, 0x01b98c,   8,    -7390 }, /* VERR_IOMMU_IPE_0 */
    { 0x014893,  19, 0x000f9b,  74,    -7310 }, /* VERR_IOMMU_CANNOT_CALL_SELF */
    { 0x01a779,  11, 0x019ad3,  13,    -7309 }, /* VERR_IOMMU_NOT_PRESENT */
    { 0x01aaff,  11, 0x0102d8,  25,    -7308 }, /* VERR_IOMMU_CMD_HW_ERROR */
    { 0x019104,  14, 0x007187,  42,    -7307 }, /* VERR_IOMMU_CMD_INVALID_FORMAT */
    { 0x01b3cb,   9, 0x01b0e5,  10,    -7306 }, /* VERR_IOMMU_CMD_NOT_SUPPORTED */
    { 0x01476f,  20, 0x0018b0,  68,    -7305 }, /* VERR_IOMMU_INTR_REMAP_DENIED */
    { 0x017d72,  15, 0x0116ef,  23,    -7304 }, /* VERR_IOMMU_INTR_REMAP_FAILED */
    { 0x0138cd,  21, 0x01089e,  24,    -7303 }, /* VERR_IOMMU_ADDR_ACCESS_DENIED */
    { 0x012fdc,  21, 0x012e23,  21,    -7302 }, /* VERR_IOMMU_ADDR_TRANSLATION_FAILED */
    { 0x018cb2,  14, 0x00ffb8,  25,    -7301 }, /* VERR_IOMMU_DTE_BAD_OFFSET */
    { 0x019634,  13, 0x010b0e,  24,    -7300 }, /* VERR_IOMMU_DTE_READ_FAILED */
    { 0x011876,  23, 0x0081d7,  39,    -7206 }, /* VERR_PDM_CRITSECTRW_MISALIGNED */
    { 0x017789,  16, 0x00c298,  31,    -7205 }, /* VERR_PDM_CRITSECTRW_IPE */
    { 0x010210,  25, 0x001cd3,  65,    -7204 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS */
    { 0x011dc1,  22, 0x006c67,  43,    -7203 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS */
    { 0x01274b,  22, 0x00633a,  44,    -7202 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_READERS */
    { 0x0156c4,  18, 0x008f1f,  37,    -7201 }, /* VERR_PDM_CRITSECT_ABORT_FAILED */
    { 0x0194c8,  13, 0x00bce7,  31,    -7153 }, /* VERR_SHCLPB_NO_DATA */
    { 0x0182e4,  15, 0x00f9dd,  25,    -7152 }, /* VERR_SHCLPB_EVENT_FAILED */
    { 0x018587,  15, 0x015486,  19,    -7151 }, /* VERR_SHCLPB_GUEST_ERROR */
    { 0x0121e1,  22, 0x00c00d,  31,    -7150 }, /* VERR_SHCLPB_TRANSFER_ID_NOT_FOUND */
    { 0x00f22b,  26, 0x002e54,  59,    -7106 }, /* VERR_SHCLPB_MAX_EVENTS_REACHED */
    { 0x015142,  19, 0x00dcfe,  28,    -7105 }, /* VERR_SHCLPB_EVENT_ID_NOT_FOUND */
    { 0x00f8dc,  26, 0x006b0f,  43,    -7104 }, /* VERR_SHCLPB_OBJ_HANDLE_INVALID */
    { 0x00ed7b,  27, 0x007ce2,  40,    -7103 }, /* VERR_SHCLPB_LIST_HANDLE_INVALID */
    { 0x010080,  25, 0x006ae4,  43,    -7102 }, /* VERR_SHCLPB_MAX_LISTS_REACHED */
    { 0x00e469,  27, 0x0061d5,  45,    -7101 }, /* VERR_SHCLPB_MAX_OBJECTS_REACHED */
    { 0x00d17e,  29, 0x004d14,  50,    -7100 }, /* VERR_SHCLPB_MAX_TRANSFERS_REACHED */
    { 0x0109d6,  24, 0x008002,  40,    -7000 }, /* VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT */
    { 0x018a4a,  14, 0x01a5a0,  11,    -6908 }, /* VERR_RECORDING_ENCODING_FAILED */
    { 0x0142c0,  20, 0x006416,  44,    -6907 }, /* VERR_RECORDING_THROTTLED */
    { 0x01077e,  24, 0x00b0a4,  32,    -6906 }, /* VERR_RECORDING_LIMIT_REACHED */
    { 0x01305a,  21, 0x0064c6,  44,    -6905 }, /* VERR_RECORDING_RESTRICTED */
    { 0x0147bf,  20, 0x00f057,  26,    -6904 }, /* VERR_RECORDING_FORMAT_NOT_SUPPORTED */
    { 0x014e70,  19, 0x01b236,   9,    -6903 }, /* VERR_RECORDING_CODEC_NOT_SUPPORTED */
    { 0x0114c7,  23, 0x0123c5,  22,    -6902 }, /* VERR_RECORDING_CODEC_INIT_FAILED */
    { 0x016c03,  17, 0x00f467,  26,    -6901 }, /* VERR_RECORDING_INIT_FAILED */
    { 0x014e4a,  19, 0x01b452,   9,    -6900 }, /* VERR_RECORDING_CODEC_NOT_FOUND */
    { 0x01beda,   5, 0x01b71c,   8,    -6899 }, /* VERR_NEM_IPE_9 */
    { 0x01bedf,   5, 0x01ba4c,   8,    -6898 }, /* VERR_NEM_IPE_8 */
    { 0x01bee4,   5, 0x01b934,   8,    -6897 }, /* VERR_NEM_IPE_7 */
    { 0x01bee9,   5, 0x01b88c,   8,    -6896 }, /* VERR_NEM_IPE_6 */
    { 0x01beee,   5, 0x01b764,   8,    -6895 }, /* VERR_NEM_IPE_5 */
    { 0x01bef3,   5, 0x01ba54,   8,    -6894 }, /* VERR_NEM_IPE_4 */
    { 0x01bef8,   5, 0x01b944,   8,    -6893 }, /* VERR_NEM_IPE_3 */
    { 0x01bfb6,   5, 0x01b8bc,   8,    -6892 }, /* VERR_NEM_IPE_2 */
    { 0x01bfbb,   5, 0x01b794,   8,    -6891 }, /* VERR_NEM_IPE_1 */
    { 0x01bfc0,   5, 0x01ba0c,   8,    -6890 }, /* VERR_NEM_IPE_0 */
    { 0x01a056,  12, 0x007d82,  40,    -6817 }, /* VERR_NEM_MISSING_FEATURE */
    { 0x0115db,  23, 0x0110f6,  24,    -6816 }, /* VERR_NEM_QUERY_DIRTY_BITMAP_FAILED */
    { 0x01666f,  17, 0x00a25e,  34,    -6815 }, /* VERR_NEM_MISSING_KERNEL_API_5 */
    { 0x0166f7,  17, 0x00a7ae,  34,    -6814 }, /* VERR_NEM_MISSING_KERNEL_API_4 */
    { 0x016b04,  17, 0x00a3b2,  34,    -6813 }, /* VERR_NEM_MISSING_KERNEL_API_3 */
    { 0x016ad1,  17, 0x00a6e2,  34,    -6812 }, /* VERR_NEM_MISSING_KERNEL_API_2 */
    { 0x01ac67,  10, 0x01a482,  12,    -6811 }, /* VERR_NEM_SET_TSC */
    { 0x019d6e,  12, 0x007781,  41,    -6810 }, /* VERR_NEM_FLUSH_TLB */
    { 0x015ad7,  18, 0x015730,  18,    -6809 }, /* VERR_NEM_SET_REGISTERS_FAILED */
    { 0x0156b2,  18, 0x015742,  18,    -6808 }, /* VERR_NEM_GET_REGISTERS_FAILED */
    { 0x01715a,  16, 0x00eb29,  27,    -6807 }, /* VERR_NEM_UNMAP_PAGES_FAILED */
    { 0x0189f6,  14, 0x00fabe,  25,    -6806 }, /* VERR_NEM_MAP_PAGES_FAILED */
    { 0x01957e,  13, 0x00bf91,  31,    -6805 }, /* VERR_NEM_VM_CREATE_FAILED */
    { 0x01988a,  13, 0x00c1fd,  31,    -6804 }, /* VERR_NEM_RING3_ONLY */
    { 0x016af3,  17, 0x00a65a,  34,    -6803 }, /* VERR_NEM_MISSING_KERNEL_API_1 */
    { 0x01b2e1,   9, 0x01b97c,   8,    -6802 }, /* VERR_NEM_INIT_FAILED */
    { 0x019b07,  13, 0x018eaa,  14,    -6801 }, /* VERR_NEM_NOT_AVAILABLE */
    { 0x01a905,  11, 0x01a13a,  12,    -6800 }, /* VERR_NEM_NOT_ENABLED */
    { 0x01ba84,   8, 0x01ae6f,  10,    -6707 }, /* VERR_APIC_IPE_2 */
    { 0x01ba8c,   8, 0x01abf9,  10,    -6706 }, /* VERR_APIC_IPE_1 */
    { 0x01ba9c,   8, 0x01b117,  10,    -6705 }, /* VERR_APIC_IPE_0 */
    { 0x015168,  19, 0x00b504,  32,    -6704 }, /* VERR_APIC_WRITE_INVALID */
    { 0x019e9a,  12, 0x0133a2,  21,    -6703 }, /* VERR_APIC_INIT_FAILED */
    { 0x01402d,  20, 0x00da5e,  28,    -6702 }, /* VERR_APIC_INTR_DISCARDED */
    { 0x010d1e,  24, 0x00c1a0,  31,    -6701 }, /* VERR_APIC_INTR_MASKED_BY_TPR */
    { 0x015544,  19, 0x0148b9,  19,    -6700 }, /* VERR_APIC_INTR_NOT_PENDING */
    { 0x00c838,  30, 0x004abc,  50,    -6608 }, /* VERR_AUDIO_STREAM_INIT_IN_PROGRESS */
    { 0x0139c5,  20, 0x01388e,  21,    -6607 }, /* VERR_AUDIO_ENUMERATION_FAILED */
    { 0x00e541,  27, 0x0118d2,  23,    -6606 }, /* VERR_AUDIO_STREAM_COULD_NOT_CREATE */
    { 0x014797,  20, 0x01566a,  18,    -6605 }, /* VERR_AUDIO_STREAM_NOT_READY */
    { 0x00d079,  29, 0x00a3f6,  34,    -6604 }, /* VERR_AUDIO_STREAM_PENDING_DISABLE */
    { 0x00e3c7,  27, 0x012e4d,  21,    -6603 }, /* VERR_AUDIO_NO_FREE_OUTPUT_STREAMS */
    { 0x00eeeb,  26, 0x013d21,  20,    -6602 }, /* VERR_AUDIO_NO_FREE_INPUT_STREAMS */
    { 0x01071e,  24, 0x009c66,  35,    -6601 }, /* VERR_AUDIO_BACKEND_NOT_ATTACHED */
    { 0x013603,  21, 0x009bb7,  35,    -6600 }, /* VERR_AUDIO_BACKEND_INIT_FAILED */
    { 0x019f96,  12, 0x011e5b,  22,    -6500 }, /* VERR_DND_GUEST_ERROR */
    { 0x00d962,  28, 0x003ae3,  54,    -6401 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_IPE */
    { 0x00cacc,  30, 0x005bd0,  46,    -6400 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR */
    { 0x012e77,  21, 0x003855,  55,    -6318 }, /* VERR_GIM_INVALID_HYPERCALL_INSTR */
    { 0x012265,  22, 0x00d48d,  29,    -6315 }, /* VERR_GIM_NO_DEBUG_CONNECTION */
    { 0x016fca,  16, 0x014131,  20,    -6314 }, /* VERR_GIM_HYPERCALL_FAILED */
    { 0x010fd6,  24, 0x0051df,  48,    -6313 }, /* VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED */
    { 0x0113e1,  23, 0x0055f8,  47,    -6312 }, /* VERR_GIM_HYPERCALL_MEMORY_READ_FAILED */
    { 0x00daea,  28, 0x003147,  58,    -6311 }, /* VERR_GIM_HYPERCALL_ACCESS_DENIED */
    { 0x011c25,  23, 0x006ebd,  42,    -6310 }, /* VERR_GIM_DEVICE_NOT_REGISTERED */
    { 0x010bce,  24, 0x00e376,  27,    -6309 }, /* VERR_GIM_HYPERCALLS_NOT_ENABLED */
    { 0x00f756,  26, 0x00b884,  32,    -6308 }, /* VERR_GIM_HYPERCALLS_NOT_AVAILABLE */
    { 0x0178b9,  16, 0x0190f6,  14,    -6307 }, /* VERR_GIM_OPERATION_FAILED */
    { 0x0192c4,  14, 0x0174e9,  16,    -6306 }, /* VERR_GIM_INVALID_PROVIDER */
    { 0x0153ee,  19, 0x009a10,  36,    -6305 }, /* VERR_GIM_PVTSC_NOT_ENABLED */
    { 0x013045,  21, 0x0076dd,  41,    -6304 }, /* VERR_GIM_PVTSC_NOT_AVAILABLE */
    { 0x01bbb2,   7, 0x01b0c7,  10,    -6303 }, /* VERR_GIM_IPE_3 */
    { 0x01bbb9,   7, 0x01adf7,  10,    -6302 }, /* VERR_GIM_IPE_2 */
    { 0x01bbc0,   7, 0x01ad39,  10,    -6301 }, /* VERR_GIM_IPE_1 */
    { 0x019849,  13, 0x009eb9,  35,    -6300 }, /* VERR_GIM_NOT_ENABLED */
    { 0x00ff3b,  25, 0x008b74,  38,    -6225 }, /* VERR_GSTCTL_PROCESS_EXIT_CODE */
    { 0x00d1f2,  29, 0x0065a2,  44,    -6224 }, /* VERR_GSTCTL_MAX_CID_COUNT_REACHED */
    { 0x00bc6c,  31, 0x006c11,  43,    -6223 }, /* VERR_GSTCTL_MAX_CID_OBJECTS_REACHED */
    { 0x00b204,  32, 0x00667e,  44,    -6222 }, /* VERR_GSTCTL_MAX_CID_SESSIONS_REACHED */
    { 0x011d22,  23, 0x01125a,  23,    -6221 }, /* VERR_GSTCTL_PROCESS_WRONG_STATE */
    { 0x018500,  15, 0x011e5b,  22,    -6200 }, /* VERR_GSTCTL_GUEST_ERROR */
    { 0x01661a,  17, 0x00535f,  48,    -6001 }, /* VERR_EXTPACK_VBOX_VERSION_MISMATCH */
    { 0x010dae,  24, 0x01b4a3,   9,    -6000 }, /* VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL */
    { 0x01a152,  12, 0x010fbe,  24,    -5699 }, /* VERR_SUP_DRIVERLESS */
    { 0x00893a,  38, 0x00063d,  95,    -5679 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT */
    { 0x01185f,  23, 0x00a390,  34,    -5678 }, /* VERR_SUP_VP_SET_HANDLE_NOINHERIT */
    { 0x016e01,  17, 0x013c6d,  20,    -5677 }, /* VERR_SUP_VP_QUERY_HANDLE_TYPE */
    { 0x012b59,  21, 0x014ea9,  19,    -5676 }, /* VERR_SUP_VP_UNDESIRABLE_MODULE */
    { 0x010b9e,  24, 0x003fe8,  53,    -5675 }, /* VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED */
    { 0x01b224,  10, 0x017b98,  16,    -5674 }, /* VERR_SUP_VP_FILE_MODE_ERROR */
    { 0x0122ff,  22, 0x00019d, 125,    -5673 }, /* VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED */
    { 0x012ce8,  21, 0x001464,  70,    -5672 }, /* VERR_SUP_VP_STUB_THREAD_OPEN_ERROR */
    { 0x0167c3,  17, 0x00102f,  73,    -5671 }, /* VERR_SUP_VP_STUB_THREAD_NOT_FOUND */
    { 0x018994,  14, 0x002112,  63,    -5670 }, /* VERR_SUP_VP_STUB_OPEN_ERROR */
    { 0x01ae51,  10, 0x001ac9,  66,    -5669 }, /* VERR_SUP_VP_STUB_NOT_FOUND */
    { 0x0197e1,  13, 0x015531,  19,    -5668 }, /* VERR_SUP_VP_IMAGE_TOO_BIG */
    { 0x00cb08,  30, 0x006a8e,  43,    -5667 }, /* VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER */
    { 0x01843d,  15, 0x009306,  37,    -5666 }, /* VERR_SUP_VP_UNKOWN_MEM_TYPE */
    { 0x011f8f,  22, 0x00037d, 109,    -5665 }, /* VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED */
    { 0x014a5b,  19, 0x000806,  90,    -5664 }, /* VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED */
    { 0x0147fb,  19, 0x011afa,  23,    -5663 }, /* VERR_SUP_VP_KERNEL32_ALREADY_MAPPED */
    { 0x01971e,  13, 0x00119a,  72,    -5662 }, /* VERR_SUP_VP_SYSFER_DLL */
    { 0x00cbb7,  29, 0x0096f8,  36,    -5661 }, /* VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED */
    { 0x014284,  20, 0x017ceb,  15,    -5660 }, /* VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT */
    { 0x00ba5d,  31, 0x00388c,  55,    -5659 }, /* VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE */
    { 0x0157c0,  18, 0x01001c,  25,    -5658 }, /* VERR_SUP_VP_NOT_BUILD_CERT_IPE */
    { 0x00f37d,  26, 0x0049f4,  50,    -5657 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT */
    { 0x011be0,  23, 0x0013d6,  71,    -5656 }, /* VERR_SUP_VP_WINTRUST_CAT_FAILURE */
    { 0x00eb5f,  27, 0x0106be,  24,    -5655 }, /* VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR */
    { 0x00e0ee,  27, 0x00f245,  26,    -5654 }, /* VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR */
    { 0x00f10d,  26, 0x003e0b,  53,    -5653 }, /* VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH */
    { 0x0108ce,  24, 0x002da3,  59,    -5652 }, /* VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH */
    { 0x015850,  18, 0x0080c6,  39,    -5651 }, /* VERR_SUP_VP_EXE_MISSING_NX_COMPAT */
    { 0x012f5e,  21, 0x00874c,  38,    -5650 }, /* VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE */
    { 0x016faa,  16, 0x000fe5,  74,    -5649 }, /* VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY */
    { 0x01686d,  17, 0x00ad1d,  33,    -5648 }, /* VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS */
    { 0x0163b6,  17, 0x007133,  42,    -5647 }, /* VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE */
    { 0x019793,  13, 0x01512f,  19,    -5646 }, /* VERR_SUP_VP_TOO_MANY_SECTIONS */
    { 0x0190be,  14, 0x01012f,  25,    -5645 }, /* VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS */
    { 0x0157d2,  18, 0x0160e3,  18,    -5644 }, /* VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS */
    { 0x0176f9,  16, 0x00e4ba,  27,    -5643 }, /* VERR_SUP_VP_TOO_MANY_DLLS_LOADED */
    { 0x017629,  16, 0x00d0b3,  29,    -5642 }, /* VERR_SUP_VP_TOO_LARGE_REGION */
    { 0x014a48,  19, 0x00c5c2,  30,    -5641 }, /* VERR_SUP_VP_TOO_HIGH_REGION_RVA */
    { 0x016f2a,  16, 0x00e15a,  27,    -5640 }, /* VERR_SUP_VP_THREAD_NOT_ALONE */
    { 0x01744a,  16, 0x00acba,  33,    -5639 }, /* VERR_SUP_VP_SYSTEM32_PATH */
    { 0x011d7e,  23, 0x00b404,  32,    -5638 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR */
    { 0x013dad,  20, 0x00bfcf,  31,    -5637 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR */
    { 0x016a27,  17, 0x00b8a4,  32,    -5636 }, /* VERR_SUP_VP_NT_QI_THREAD_ERROR */
    { 0x0133e1,  21, 0x014b3f,  19,    -5635 }, /* VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR */
    { 0x00f349,  26, 0x00625c,  45,    -5634 }, /* VERR_SUP_VP_NT_MAPPING_NAME_CHANGED */
    { 0x013cbd,  20, 0x003699,  56,    -5633 }, /* VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE */
    { 0x0149e9,  19, 0x0044cd,  52,    -5632 }, /* VERR_SUP_VP_NON_SYSTEM32_DLL */
    { 0x0162d9,  17, 0x01b009,  10,    -5631 }, /* VERR_SUP_VP_NO_NTDLL_MAPPING */
    { 0x01bb27,   7, 0x00737f,  42,    -5630 }, /* VERR_SUP_VP_NO_MEMORY_STATE */
    { 0x01bb27,   5, 0x012449,  22,    -5629 }, /* VERR_SUP_VP_NO_MEMORY */
    { 0x0144b4,  20, 0x01a1b2,  12,    -5628 }, /* VERR_SUP_VP_NO_KERNEL32_MAPPING */
    { 0x012567,  22, 0x00c279,  31,    -5627 }, /* VERR_SUP_VP_NO_IMAGE_MAPPING_NAME */
    { 0x015c75,  18, 0x004567,  51,    -5626 }, /* VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING */
    { 0x01a5e2,  11, 0x00971c,  36,    -5625 }, /* VERR_SUP_VP_MEMORY_READ_ERROR */
    { 0x011620,  23, 0x00008e, 138,    -5624 }, /* VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR */
    { 0x014d2d,  19, 0x013030,  21,    -5623 }, /* VERR_SUP_VP_IMAGE_HDR_READ_ERROR */
    { 0x017bb8,  16, 0x015f8d,  18,    -5622 }, /* VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR */
    { 0x016d02,  17, 0x0130c3,  21,    -5621 }, /* VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR */
    { 0x00c61c,  30, 0x002402,  62,    -5620 }, /* VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING */
    { 0x01a624,  11, 0x00772f,  41,    -5619 }, /* VERR_SUP_VP_FOUND_EXEC_MEMORY */
    { 0x01340b,  21, 0x0085a6,  39,    -5618 }, /* VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH */
    { 0x01269b,  22, 0x00faf0,  25,    -5617 }, /* VERR_SUP_VP_EMPTY_REGION_TOO_LARGE */
    { 0x010ac6,  24, 0x00bdfe,  31,    -5616 }, /* VERR_SUP_VP_DUPLICATE_DLL_MAPPING */
    { 0x01a6be,  11, 0x01306f,  21,    -5615 }, /* VERR_SUP_VP_DEBUGGED */
    { 0x0179e9,  16, 0x0192d2,  14,    -5614 }, /* VERR_SUP_VP_BAD_SIZE_OF_HEADERS */
    { 0x0131aa,  21, 0x01602f,  18,    -5613 }, /* VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE */
    { 0x01873a,  15, 0x012d12,  21,    -5612 }, /* VERR_SUP_VP_BAD_SECTION_RVA */
    { 0x018d06,  14, 0x0184b5,  15,    -5611 }, /* VERR_SUP_VP_BAD_SECTION_FILE_SIZE */
    { 0x00e2d4,  27, 0x010035,  25,    -5610 }, /* VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE */
    { 0x014d79,  19, 0x0147d3,  20,    -5609 }, /* VERR_SUP_VP_BAD_OPTIONAL_HEADER */
    { 0x019c59,  13, 0x00d61a,  28,    -5608 }, /* VERR_SUP_VP_BAD_MZ_OFFSET */
    { 0x01a721,  11, 0x01acdf,  10,    -5607 }, /* VERR_SUP_VP_BAD_IMAGE_SIZE */
    { 0x014c36,  19, 0x01834d,  15,    -5606 }, /* VERR_SUP_VP_BAD_IMAGE_SIGNATURE */
    { 0x01905c,  14, 0x015fc3,  18,    -5605 }, /* VERR_SUP_VP_BAD_IMAGE_BASE */
    { 0x01475b,  20, 0x00fb9f,  25,    -5604 }, /* VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE */
    { 0x01068e,  24, 0x007543,  41,    -5603 }, /* VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED */
    { 0x015cbd,  18, 0x009de7,  35,    -5602 }, /* VERR_SUP_VP_SECTION_NOT_MAPPED */
    { 0x011cdd,  23, 0x0050ec,  49,    -5601 }, /* VERR_SUP_VP_SECTION_PROTECTION_MISMATCH */
    { 0x01b0ef,  10, 0x012e0e,  21,    -5600 }, /* VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH */
    { 0x0166b3,  17, 0x01ad4d,  10,    -5499 }, /* VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS */
    { 0x01920e,  14, 0x01bbc7,   7,    -5498 }, /* VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS */
    { 0x014181,  20, 0x00aea4,  32,    -5497 }, /* VERR_DBGC_PARSE_ARGUMENT_OVERFLOW */
    { 0x013435,  21, 0x01301b,  21,    -5496 }, /* VERR_DBGC_PARSE_EXPECTED_BINARY_OP */
    { 0x016691,  17, 0x0070b5,  42,    -5494 }, /* VERR_DBGC_PARSE_NO_RANGE_ALLOWED */
    { 0x014cf4,  19, 0x0124f9,  22,    -5493 }, /* VERR_DBGC_PARSE_UNBALANCED_QUOTE */
    { 0x010148,  25, 0x00ebb0,  27,    -5492 }, /* VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS */
    { 0x0169c1,  17, 0x006a38,  43,    -5491 }, /* VERR_DBGC_PARSE_EMPTY_ARGUMENT */
    { 0x01a236,  12, 0x014657,  20,    -5490 }, /* VERR_DBGC_PARSE_UNEXPECTED_OPERATOR */
    { 0x01ae01,  10, 0x018a12,  14,    -5489 }, /* VERR_DBGC_PARSE_INVALID_NUMBER */
    { 0x018bee,  14, 0x0134b3,  21,    -5488 }, /* VERR_DBGC_PARSE_NUMBER_TOO_BIG */
    { 0x01947a,  13, 0x01748a,  16,    -5487 }, /* VERR_DBGC_PARSE_INVALID_OPERATION */
    { 0x018e2c,  14, 0x018023,  15,    -5486 }, /* VERR_DBGC_PARSE_FUNCTION_NOT_FOUND */
    { 0x018e72,  14, 0x00e07e,  28,    -5485 }, /* VERR_DBGC_PARSE_NOT_A_FUNCTION */
    { 0x01a60e,  11, 0x0107ae,  24,    -5484 }, /* VERR_DBGC_PARSE_NO_SCRATCH */
    { 0x01becb,   5, 0x00cfcb,  29,    -5483 }, /* VERR_DBGC_PARSE_NO_MEMORY */
    { 0x015e01,  18, 0x00df66,  28,    -5482 }, /* VERR_DBGC_PARSE_INCORRECT_ARG_TYPE */
    { 0x018916,  14, 0x009818,  36,    -5481 }, /* VERR_DBGC_PARSE_VARIABLE_NOT_FOUND */
    { 0x017c46,  15, 0x014f67,  19,    -5480 }, /* VERR_DBGC_PARSE_CONVERSION_FAILED */
    { 0x0181c7,  15, 0x003b4f,  54,    -5479 }, /* VERR_DBGC_PARSE_NOT_IMPLEMENTED */
    { 0x019d7a,  12, 0x00547f,  48,    -5478 }, /* VERR_DBGC_PARSE_BAD_RESULT_TYPE */
    { 0x015369,  19, 0x0042f9,  52,    -5477 }, /* VERR_DBGC_PARSE_WRITEONLY_SYMBOL */
    { 0x012919,  22, 0x015b79,  18,    -5476 }, /* VERR_DBGC_PARSE_INVALD_COMMAND_NAME */
    { 0x019a37,  13, 0x019112,  14,    -5475 }, /* VERR_DBGC_PARSE_COMMAND_NOT_FOUND */
    { 0x01be83,   6, 0x0167b2,  17,    -5474 }, /* VERR_DBGC_PARSE_BUG */
    { 0x01bed0,   5, 0x0156a0,  18,    -5408 }, /* VERR_DBGC_IPE */
    { 0x01aa44,  11, 0x00f0a5,  26,    -5407 }, /* VERR_DBGC_COMMAND_FAILED */
    { 0x01a5cc,  11, 0x01ad2f,  10,    -5405 }, /* VERR_DBGC_BP_EXISTS */
    { 0x01bca0,   7, 0x019f8a,  12,    -5404 }, /* VERR_DBGC_BP_NOT_FOUND */
    { 0x0128ed,  22, 0x008420,  39,    -5403 }, /* VERR_DBGC_COMMANDS_NOT_REGISTERED */
    { 0x01be8f,   6, 0x00f141,  26,    -5400 }, /* VERR_DBGC_QUIT */
    { 0x01c041,   4, 0x0193de,  13,    -5399 }, /* VERR_IEM_IPE_9 */
    { 0x01c045,   4, 0x019919,  13,    -5398 }, /* VERR_IEM_IPE_8 */
    { 0x01c049,   4, 0x019509,  13,    -5397 }, /* VERR_IEM_IPE_7 */
    { 0x01c04d,   4, 0x01960d,  13,    -5396 }, /* VERR_IEM_IPE_6 */
    { 0x01c051,   4, 0x019b7c,  13,    -5395 }, /* VERR_IEM_IPE_5 */
    { 0x01c055,   4, 0x019926,  13,    -5394 }, /* VERR_IEM_IPE_4 */
    { 0x01c089,   4, 0x0194fc,  13,    -5393 }, /* VERR_IEM_IPE_3 */
    { 0x01c091,   4, 0x019bf1,  13,    -5392 }, /* VERR_IEM_IPE_2 */
    { 0x01c095,   4, 0x019b89,  13,    -5391 }, /* VERR_IEM_IPE_1 */
    { 0x012bc2,  21, 0x004fc6,  49,    -5390 }, /* VERR_IEM_ASPECT_NOT_IMPLEMENTED */
    { 0x01344a,  21, 0x00cc82,  29,    -5389 }, /* VERR_IEM_RESTART_INSTRUCTION */
    { 0x01416d,  20, 0x018fde,  14,    -5384 }, /* VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER */
    { 0x00ca72,  30, 0x010b86,  24,    -5383 }, /* VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE */
    { 0x015f69,  18, 0x012c2b,  21,    -5382 }, /* VERR_IEM_EMIT_BAD_SEG_REG_NO */
    { 0x019b6f,  13, 0x00f8a8,  26,    -5381 }, /* VERR_IEM_EMIT_BAD_MEM_SIZE */
    { 0x00f25f,  26, 0x014360,  20,    -5380 }, /* VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1 */
    { 0x01b305,   9, 0x00dab2,  28,    -5377 }, /* VERR_IEM_VAR_IPE_13 */
    { 0x01b30e,   9, 0x00d7be,  28,    -5376 }, /* VERR_IEM_VAR_IPE_12 */
    { 0x01b317,   9, 0x00df12,  28,    -5375 }, /* VERR_IEM_VAR_IPE_11 */
    { 0x01b320,   9, 0x00dce2,  28,    -5374 }, /* VERR_IEM_VAR_IPE_10 */
    { 0x01b5fd,   8, 0x00e8d7,  27,    -5373 }, /* VERR_IEM_VAR_IPE_9 */
    { 0x01b605,   8, 0x00eaa2,  27,    -5372 }, /* VERR_IEM_VAR_IPE_8 */
    { 0x01ba64,   8, 0x00e8f2,  27,    -5371 }, /* VERR_IEM_VAR_IPE_7 */
    { 0x01ba94,   8, 0x00e5e3,  27,    -5370 }, /* VERR_IEM_VAR_IPE_6 */
    { 0x01baa4,   8, 0x00e109,  27,    -5369 }, /* VERR_IEM_VAR_IPE_5 */
    { 0x01baac,   8, 0x00e81a,  27,    -5368 }, /* VERR_IEM_VAR_IPE_4 */
    { 0x01bab4,   8, 0x00e7c9,  27,    -5367 }, /* VERR_IEM_VAR_IPE_3 */
    { 0x01babc,   8, 0x00e685,  27,    -5366 }, /* VERR_IEM_VAR_IPE_2 */
    { 0x01b305,   8, 0x00e418,  27,    -5365 }, /* VERR_IEM_VAR_IPE_1 */
    { 0x0157ae,  18, 0x01101e,  24,    -5364 }, /* VERR_IEM_VAR_NOT_INITIALIZED */
    { 0x01a6b3,  11, 0x016ccf,  17,    -5363 }, /* VERR_IEM_VAR_UNEXPECTED_KIND */
    { 0x010cee,  24, 0x015f0f,  18,    -5362 }, /* VERR_IEM_VAR_OUT_OF_STACK_SLOTS */
    { 0x017699,  16, 0x0099ec,  36,    -5361 }, /* VERR_IEM_VAR_DUP_ARG_NO */
    { 0x017e08,  15, 0x01742a,  16,    -5360 }, /* VERR_IEM_VAR_EXHAUSTED */
    { 0x01b521,   9, 0x00edcc,  27,    -5355 }, /* VERR_IEM_REG_IPE_13 */
    { 0x01b52a,   9, 0x00eaf3,  27,    -5354 }, /* VERR_IEM_REG_IPE_12 */
    { 0x01b533,   9, 0x00e217,  27,    -5353 }, /* VERR_IEM_REG_IPE_11 */
    { 0x01b263,   9, 0x00e55c,  27,    -5352 }, /* VERR_IEM_REG_IPE_10 */
    { 0x01b78c,   8, 0x00f1a9,  26,    -5351 }, /* VERR_IEM_REG_IPE_9 */
    { 0x01b6cc,   8, 0x00f3e5,  26,    -5350 }, /* VERR_IEM_REG_IPE_8 */
    { 0x01b6d4,   8, 0x00efa1,  26,    -5349 }, /* VERR_IEM_REG_IPE_7 */
    { 0x01b6dc,   8, 0x00f826,  26,    -5348 }, /* VERR_IEM_REG_IPE_6 */
    { 0x01b73c,   8, 0x00f687,  26,    -5347 }, /* VERR_IEM_REG_IPE_5 */
    { 0x01b744,   8, 0x00f56a,  26,    -5346 }, /* VERR_IEM_REG_IPE_4 */
    { 0x01b77c,   8, 0x00ef6d,  26,    -5345 }, /* VERR_IEM_REG_IPE_3 */
    { 0x01b784,   8, 0x00f910,  26,    -5344 }, /* VERR_IEM_REG_IPE_2 */
    { 0x01b263,   8, 0x00f6a1,  26,    -5343 }, /* VERR_IEM_REG_IPE_1 */
    { 0x00fd16,  25, 0x00cea9,  29,    -5341 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR */
    { 0x010003,  25, 0x00df4a,  28,    -5340 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP */
    { 0x01aeab,  10, 0x019bb0,  13,    -5339 }, /* VERR_IEM_LABEL_IPE_6 */
    { 0x01aeb5,  10, 0x019a51,  13,    -5338 }, /* VERR_IEM_LABEL_IPE_5 */
    { 0x01aebf,  10, 0x019822,  13,    -5337 }, /* VERR_IEM_LABEL_IPE_4 */
    { 0x01aec9,  10, 0x019738,  13,    -5336 }, /* VERR_IEM_LABEL_IPE_3 */
    { 0x01aed3,  10, 0x019bd7,  13,    -5335 }, /* VERR_IEM_LABEL_IPE_2 */
    { 0x01aedd,  10, 0x019a92,  13,    -5334 }, /* VERR_IEM_LABEL_IPE_1 */
    { 0x01704a,  16, 0x018221,  15,    -5333 }, /* VERR_IEM_LABEL_OUT_OF_MEMORY */
    { 0x0198be,  13, 0x0194a1,  13,    -5332 }, /* VERR_IEM_LABEL_TOO_MANY */
    { 0x013eb1,  20, 0x00b104,  32,    -5331 }, /* VERR_IEM_INSTR_BUF_OUT_OF_MEMORY */
    { 0x016119,  18, 0x013a15,  20,    -5330 }, /* VERR_IEM_INSTR_BUF_TOO_LARGE */
    { 0x00bd63,  31, 0x007bca,  40,    -5329 }, /* VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL */
    { 0x017a09,  16, 0x018401,  15,    -5328 }, /* VERR_IEM_FIXUP_OUT_OF_MEMORY */
    { 0x019786,  13, 0x01946d,  13,    -5327 }, /* VERR_IEM_FIXUP_TOO_MANY */
    { 0x01ac49,  10, 0x0199e9,  13,    -5326 }, /* VERR_IEM_FIXUP_IPE_1 */
    { 0x019d3e,  12, 0x0155da,  18,    -5325 }, /* VERR_IEM_DBGINFO_IPE_2 */
    { 0x019d32,  12, 0x016107,  18,    -5324 }, /* VERR_IEM_DBGINFO_IPE_1 */
    { 0x015d05,  18, 0x00ca18,  30,    -5323 }, /* VERR_IEM_DBGINFO_OUT_OF_MEMORY */
    { 0x00d283,  29, 0x006e3f,  42,    -5322 }, /* VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED */
    { 0x0135ee,  21, 0x00b564,  32,    -5321 }, /* VERR_IEM_COND_TOO_DEEPLY_NESTED */
    { 0x019e46,  12, 0x00c0a8,  31,    -5320 }, /* VERR_IEM_TB_ALLOC_FAILED */
    { 0x01809b,  15, 0x00be7a,  31,    -5304 }, /* VERR_IEM_INVALID_INSTR_LENGTH */
    { 0x01b1b6,  10, 0x006be6,  43,    -5303 }, /* VERR_IEM_INVALID_EFF_SEG */
    { 0x0186a4,  15, 0x009620,  36,    -5302 }, /* VERR_IEM_INVALID_ADDRESS_MODE */
    { 0x019d62,  12, 0x00b3c4,  32,    -5301 }, /* VERR_IEM_INVALID_OPERAND_SIZE */
    { 0x014091,  20, 0x00fc1c,  25,    -5300 }, /* VERR_IEM_INSTR_NOT_IMPLEMENTED */
    { 0x00d3a5,  29, 0x00749f,  41,    -5209 }, /* VERR_GVMM_GVMCPU_STRUCT_NOT_PAGE_ALIGNED */
    { 0x00f51d,  26, 0x008c32,  38,    -5208 }, /* VERR_GVMM_GVM_STRUCT_NOT_PAGE_ALIGNED */
    { 0x00db06,  28, 0x0074a0,  40,    -5207 }, /* VERR_GVMM_VMCPU_STRUCT_NOT_PAGE_ALIGNED */
    { 0x01107e,  24, 0x009470,  36,    -5206 }, /* VERR_GVMM_VM_STRUCT_NOT_PAGE_ALIGNED */
    { 0x00d557,  28, 0x004465,  52,    -5205 }, /* VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED */
    { 0x01ba04,   8, 0x018d3e,  14,    -5204 }, /* VERR_GVMM_IPE_2 */
    { 0x01ba14,   8, 0x018844,  14,    -5203 }, /* VERR_GVMM_IPE_1 */
    { 0x016ac0,  17, 0x00b964,  32,    -5202 }, /* VERR_GVMM_BROKEN_IPRT */
    { 0x013fa1,  20, 0x00582c,  47,    -5201 }, /* VERR_GVMM_HOST_CPU_RANGE */
    { 0x018c42,  14, 0x00e9e5,  27,    -5200 }, /* VERR_GVMM_INSTANCE */
    { 0x00c02c,  31, 0x011e03,  22,    -5102 }, /* VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING */
    { 0x013f3d,  20, 0x014a22,  19,    -5101 }, /* VERR_PCI_PASSTHROUGH_NO_HM */
    { 0x00caae,  30, 0x016906,  17,    -5100 }, /* VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC */
    { 0x013e25,  20, 0x00ba3e,  31,    -5003 }, /* VERR_FAM_CONNECTION_LOST */
    { 0x010ade,  24, 0x00b764,  32,    -5002 }, /* VERR_FAM_MONITOR_DIRECTORY_FAILED */
    { 0x01844c,  15, 0x00b384,  32,    -5001 }, /* VERR_FAM_MONITOR_FILE_FAILED */
    { 0x01aab2,  11, 0x01083e,  24,    -5000 }, /* VERR_FAM_OPEN_FAILED */
    { 0x017e35,  15, 0x016b8c,  17,    -4904 }, /* VERR_VSCSI_LUN_BUSY */
    { 0x01457c,  20, 0x00fdf6,  25,    -4903 }, /* VERR_VSCSI_LUN_NOT_ATTACHED */
    { 0x016053,  18, 0x0183c5,  15,    -4902 }, /* VERR_VSCSI_LUN_INVALID */
    { 0x00ce6f,  29, 0x00868e,  38,    -4901 }, /* VERR_VSCSI_LUN_ATTACHED_TO_DEVICE */
    { 0x0184f1,  15, 0x01b874,   8,    -4900 }, /* VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED */
    { 0x0085f4,  39, 0x003aad,  54,    -4700 }, /* VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST */
    { 0x019182,  14, 0x004a26,  50,    -4698 }, /* VERR_COM_OBJECT_NOT_FOUND */
    { 0x01b569,   9, 0x009860,  36,    -4697 }, /* VERR_COM_INVALID_VM_STATE */
    { 0x01b9b4,   8, 0x008336,  39,    -4696 }, /* VERR_COM_VM_ERROR */
    { 0x01bae1,   7, 0x008856,  38,    -4695 }, /* VERR_COM_FILE_ERROR */
    { 0x01a645,  11, 0x01be77,   6,    -4694 }, /* VERR_COM_IPRT_ERROR */
    { 0x01bc1b,   7, 0x00f5d2,  26,    -4693 }, /* VERR_COM_PDM_ERROR */
    { 0x018dca,  14, 0x012d51,  21,    -4692 }, /* VERR_COM_INVALID_OBJECT_STATE */
    { 0x01a8d9,  11, 0x00be3c,  31,    -4691 }, /* VERR_COM_HOST_ERROR */
    { 0x01baf6,   7, 0x019326,  14,    -4690 }, /* VERR_COM_NOT_SUPPORTED */
    { 0x01afe1,  10, 0x01be71,   6,    -4689 }, /* VERR_COM_XML_ERROR */
    { 0x0180aa,  15, 0x00da0a,  28,    -4688 }, /* VERR_COM_INVALID_SESSION_STATE */
    { 0x015634,  18, 0x00cfae,  29,    -4687 }, /* VERR_COM_OBJECT_IN_USE */
    { 0x014159,  20, 0x0009c1,  85,    -4686 }, /* VERR_COM_DONT_CALL_AGAIN */
    { 0x017ddb,  15, 0x0188de,  14,    -4600 }, /* VERR_COM_UNEXPECTED */
    { 0x017d36,  15, 0x00bd25,  31,    -4304 }, /* VERR_WEB_UNSUPPORTED_INTERFACE */
    { 0x017fe7,  15, 0x00fad7,  25,    -4303 }, /* VERR_WEB_INVALID_OBJECT_ID */
    { 0x017609,  16, 0x00ae44,  32,    -4302 }, /* VERR_WEB_INVALID_SESSION_ID */
    { 0x00c311,  30, 0x00dea2,  28,    -4301 }, /* VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE */
    { 0x0150aa,  19, 0x0069b7,  43,    -4300 }, /* VERR_WEB_NOT_AUTHENTICATED */
    { 0x017549,  16, 0x01b39e,   9,    -4206 }, /* VERR_DIS_TOO_LONG_INSTR */
    { 0x0186b3,  15, 0x016e67,  17,    -4204 }, /* VERR_DIS_INVALID_PARAMETER */
    { 0x01aa2e,  11, 0x01b92c,   8,    -4203 }, /* VERR_DIS_INVALID_MODRM */
    { 0x014d9f,  19, 0x0185d2,  15,    -4202 }, /* VERR_DIS_NO_READ_CALLBACK */
    { 0x017bf8,  16, 0x00dcaa,  28,    -4201 }, /* VERR_DIS_GEN_FAILURE */
    { 0x019de6,  12, 0x01709a,  16,    -4200 }, /* VERR_DIS_INVALID_OPCODE */
    { 0x017d18,  15, 0x01961a,  13,    -4116 }, /* VERR_HM_INVALID_HM64ON32OP */
    { 0x01bdf3,   6, 0x01a386,  12,    -4115 }, /* VERR_HM_IPE_5 */
    { 0x01be23,   6, 0x019cde,  12,    -4114 }, /* VERR_HM_IPE_4 */
    { 0x01be11,   6, 0x01a39e,  12,    -4113 }, /* VERR_HM_IPE_3 */
    { 0x0122d3,  22, 0x00fc67,  25,    -4112 }, /* VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO */
    { 0x015460,  19, 0x016c58,  17,    -4111 }, /* VERR_HM_UNKNOWN_IO_INSTRUCTION */
    { 0x015ec7,  18, 0x00fd7a,  25,    -4110 }, /* VERR_HM_WRONG_SWITCHER */
    { 0x01be17,   6, 0x019fae,  12,    -4109 }, /* VERR_HM_IPE_2 */
    { 0x01be1d,   6, 0x01a2f6,  12,    -4108 }, /* VERR_HM_IPE_1 */
    { 0x019b55,  13, 0x00b024,  32,    -4107 }, /* VERR_HM_WRONG_CPU */
    { 0x012659,  22, 0x00b8c4,  32,    -4106 }, /* VERR_HM_NO_32_TO_64_SWITCHER */
    { 0x018f98,  14, 0x00db5a,  28,    -4105 }, /* VERR_HM_UNEXPECTED_LD_ST_MSR */
    { 0x01729a,  16, 0x018860,  14,    -4104 }, /* VERR_HM_ALREADY_ENABLED_IPE */
    { 0x019ee2,  12, 0x01104e,  24,    -4103 }, /* VERR_HM_CONFIG_MISMATCH */
    { 0x014e5d,  19, 0x00a69e,  34,    -4100 }, /* VERR_HM_SUSPEND_PENDING */
    { 0x00da96,  28, 0x0043fd,  52,    -4075 }, /* VERR_SVM_HOST_VM_HSAVE_PA_INVALID */
    { 0x0116d8,  23, 0x008a90,  38,    -4074 }, /* VERR_SVM_HOST_SVME_NOT_ENABLED */
    { 0x013a65,  20, 0x00b864,  32,    -4073 }, /* VERR_SVM_VMRUN_PRECOND_3 */
    { 0x014270,  20, 0x00afc4,  32,    -4072 }, /* VERR_SVM_VMRUN_PRECOND_2 */
    { 0x014248,  20, 0x00ae24,  32,    -4071 }, /* VERR_SVM_VMRUN_PRECOND_1 */
    { 0x014234,  20, 0x00af44,  32,    -4070 }, /* VERR_SVM_VMRUN_PRECOND_0 */
    { 0x01964e,  13, 0x0066d6,  44,    -4066 }, /* VERR_SVM_VMEXIT_FAILED */
    { 0x01bb96,   7, 0x019f66,  12,    -4065 }, /* VERR_SVM_IPE_5 */
    { 0x01bb9d,   7, 0x01a3fe,  12,    -4064 }, /* VERR_SVM_IPE_4 */
    { 0x01bbea,   7, 0x01a34a,  12,    -4063 }, /* VERR_SVM_IPE_3 */
    { 0x01bc14,   7, 0x019e52,  12,    -4062 }, /* VERR_SVM_IPE_2 */
    { 0x01bc22,   7, 0x019f4e,  12,    -4061 }, /* VERR_SVM_IPE_1 */
    { 0x01afa5,  10, 0x0109ee,  24,    -4060 }, /* VERR_SVM_UNKNOWN_EXIT */
    { 0x0196dd,  13, 0x00a12c,  34,    -4059 }, /* VERR_SVM_INVALID_GUEST_STATE */
    { 0x019a03,  13, 0x01705a,  16,    -4058 }, /* VERR_SVM_UNEXPECTED_PATCH_TYPE */
    { 0x018389,  15, 0x013e89,  20,    -4057 }, /* VERR_SVM_UNEXPECTED_XCPT_EXIT */
    { 0x01b148,  10, 0x01b1ca,  10,    -4056 }, /* VERR_SVM_UNEXPECTED_EXIT */
    { 0x01a84a,  11, 0x01bada,   7,    -4055 }, /* VERR_SVM_INVALID_PVMCB */
    { 0x01a5ed,  11, 0x00e86b,  27,    -4054 }, /* VERR_SVM_IN_USE */
    { 0x019439,  13, 0x0082c1,  39,    -4053 }, /* VERR_SVM_DISABLED */
    { 0x01b2ea,   9, 0x00b9e1,  31,    -4052 }, /* VERR_SVM_NO_SVM */
    { 0x0135d9,  21, 0x00df2e,  28,    -4051 }, /* VERR_SVM_ILLEGAL_EFER_MSR */
    { 0x0122e9,  22, 0x013b7d,  20,    -4050 }, /* VERR_SVM_UNABLE_TO_START_VM */
    { 0x0148a6,  19, 0x00a7d0,  34,    -4042 }, /* VERR_VMX_STARTVM_PRECOND_3 */
    { 0x0149b0,  19, 0x00a32a,  34,    -4041 }, /* VERR_VMX_STARTVM_PRECOND_2 */
    { 0x0148cc,  19, 0x00a54a,  34,    -4040 }, /* VERR_VMX_STARTVM_PRECOND_1 */
    { 0x01498a,  19, 0x00a0e8,  34,    -4039 }, /* VERR_VMX_STARTVM_PRECOND_0 */
    { 0x017b09,  16, 0x00f7be,  26,    -4038 }, /* VERR_VMX_INVALID_VMCS_LAUNCH_STATE */
    { 0x01b12b,  10, 0x017b29,  16,    -4034 }, /* VERR_VMX_VMEXIT_FAILED */
    { 0x01a9cb,  11, 0x019e82,  12,    -4033 }, /* VERR_VMX_VMENTRY_FAILED */
    { 0x015414,  19, 0x002adf,  59,    -4032 }, /* VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED */
    { 0x0185f0,  15, 0x003511,  56,    -4031 }, /* VERR_VMX_MSR_VMX_ENABLE_FAILED */
    { 0x00f4cf,  26, 0x00c928,  30,    -4030 }, /* VERR_VMX_VMCS_FIELD_CACHE_INVALID */
    { 0x018758,  15, 0x00c9fa,  30,    -4029 }, /* VERR_VMX_MSR_VMX_DISABLED */
    { 0x01543a,  19, 0x0034d9,  56,    -4028 }, /* VERR_VMX_MSR_ALL_VMX_DISABLED */
    { 0x01c0b9,   4, 0x01a4ee,  12,    -4027 }, /* VERR_VMX_IPE_5 */
    { 0x01c0bd,   4, 0x019cc6,  12,    -4026 }, /* VERR_VMX_IPE_4 */
    { 0x01c0d1,   4, 0x01a026,  12,    -4025 }, /* VERR_VMX_IPE_3 */
    { 0x01c0c1,   4, 0x01a1ee,  12,    -4024 }, /* VERR_VMX_IPE_2 */
    { 0x01c0c5,   4, 0x01a42e,  12,    -4023 }, /* VERR_VMX_IPE_1 */
    { 0x0128ab,  22, 0x007f12,  40,    -4022 }, /* VERR_VMX_INVALID_VMCS_PTR_TO_START_VM */
    { 0x01a7a5,  11, 0x005d6e,  46,    -4021 }, /* VERR_VMX_VMPTRLD_FAILED */
    { 0x0137bc,  21, 0x016185,  18,    -4019 }, /* VERR_VMX_UNDEFINED_EXIT_CODE */
    { 0x017a79,  16, 0x003f49,  53,    -4018 }, /* VERR_VMX_NOT_IN_VMX_ROOT_MODE */
    { 0x012643,  22, 0x010f5e,  24,    -4017 }, /* VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE */
    { 0x01a3e6,  12, 0x019c25,  13,    -4016 }, /* VERR_VMX_UNEXPECTED_EXCEPTION */
    { 0x01bc0d,   7, 0x01b645,   8,    -4015 }, /* VERR_VMX_UNEXPECTED_EXIT */
    { 0x01afcd,  10, 0x01271f,  22,    -4014 }, /* VERR_VMX_INVALID_GUEST_STATE */
    { 0x0185a5,  15, 0x00d005,  29,    -4013 }, /* VERR_VMX_MSR_LOCKING_FAILED */
    { 0x0124b7,  22, 0x005fb9,  45,    -4012 }, /* VERR_VMX_X86_CR4_VMXE_CLEARED */
    { 0x017f15,  15, 0x002151,  63,    -4011 }, /* VERR_VMX_IN_VMX_ROOT_MODE */
    { 0x01be65,   6, 0x00846e,  39,    -4009 }, /* VERR_VMX_NO_VMX */
    { 0x01b4c7,   9, 0x00f2e1,  26,    -4006 }, /* VERR_VMX_INVALID_HOST_STATE */
    { 0x0151c7,  19, 0x013b7d,  20,    -4005 }, /* VERR_VMX_UNABLE_TO_START_VM */
    { 0x01a46a,  12, 0x0180e6,  15,    -4004 }, /* VERR_VMX_INVALID_VMXON_PTR */
    { 0x01acc1,  10, 0x0014aa,  70,    -4003 }, /* VERR_VMX_RESERVED */
    { 0x0014e2,  13, 0x0089f8,  38,    -4002 }, /* VERR_VMX_INVALID_VMCS_FIELD */
    { 0x0014d5,  11, 0x018ed4,  14,    -4001 }, /* VERR_VMX_INVALID_VMCS_PTR */
    { 0x01b329,   9, 0x007c6a,  40,    -4000 }, /* VERR_VMX_VMXON_FAILED */
    { 0x01922a,  14, 0x004e6f,  49,    -3907 }, /* VERR_GVM_MISMATCH_SVN_REV */
    { 0x014e96,  19, 0x008273,  39,    -3906 }, /* VERR_GVM_MISMATCH_VM_STRUCT_VER */
    { 0x0190a2,  14, 0x006b3a,  43,    -3905 }, /* VERR_GVM_MISMATCH_VMCPU_SIZE */
    { 0x01ac99,  10, 0x0081b0,  39,    -3904 }, /* VERR_GVM_MISMATCH_VM_SIZE */
    { 0x01aee7,  10, 0x00f481,  26,    -3900 }, /* VERR_GVM_TOO_MANY_VMS */
    { 0x00cda4,  29, 0x004864,  50,    -3831 }, /* VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE */
    { 0x01349e,  21, 0x00c6d0,  30,    -3830 }, /* VERR_GMM_BAD_SHARED_MODULE_SIZE */
    { 0x012cd3,  21, 0x015b43,  18,    -3829 }, /* VERR_GMM_SHARED_MODULE_NOT_FOUND */
    { 0x00b804,  32, 0x0016d4,  68,    -3828 }, /* VERR_GMM_SHARED_MODULE_ADDRESS_CLASH */
    { 0x012f34,  21, 0x0120ad,  22,    -3826 }, /* VERR_GMM_TOO_MANY_GLOBAL_MODULES */
    { 0x0142e8,  20, 0x0120ad,  22,    -3825 }, /* VERR_GMM_TOO_MANY_PER_VM_MODULES */
    { 0x018a2e,  14, 0x00ef53,  26,    -3824 }, /* VERR_GMM_TOO_MANY_REGIONS */
    { 0x014f1b,  19, 0x0106d6,  24,    -3823 }, /* VERR_GMM_MODULE_VERSION_TOO_LONG */
    { 0x012735,  22, 0x00e850,  27,    -3822 }, /* VERR_GMM_MODULE_NAME_TOO_LONG */
    { 0x01390c,  21, 0x008e1c,  37,    -3821 }, /* VERR_GMM_ACTUAL_PAGES_IPE */
    { 0x014504,  20, 0x01702a,  16,    -3820 }, /* VERR_GMM_ALLOC_PAGES_IPE */
    { 0x018e1e,  14, 0x0113ca,  23,    -3819 }, /* VERR_GMM_MTX_FLAGS */
    { 0x019377,  13, 0x011340,  23,    -3818 }, /* VERR_GMM_INSTANCE */
    { 0x01697d,  17, 0x01188d,  23,    -3817 }, /* VERR_GMM_CHUNK_INSERT */
    { 0x0197fb,  13, 0x0146f7,  20,    -3816 }, /* VERR_GMM_IS_NOT_SANE */
    { 0x00ed60,  27, 0x0004b9,  98,    -3815 }, /* VERR_GMM_MEMORY_RESERVATION_DECLINED */
    { 0x01338d,  21, 0x008cf0,  38,    -3814 }, /* VERR_GMM_TOO_MANY_CHUNK_MAPPINGS */
    { 0x015e91,  18, 0x003bf1,  54,    -3813 }, /* VERR_GMM_CHUNK_NOT_MAPPED */
    { 0x015610,  18, 0x00bb36,  31,    -3812 }, /* VERR_GMM_CHUNK_ALREADY_MAPPED */
    { 0x01976c,  13, 0x01a926,  11,    -3811 }, /* VERR_GMM_CHUNK_NOT_FOUND */
    { 0x019e16,  12, 0x007706,  41,    -3810 }, /* VERR_GMM_NOT_PAGE_OWNER */
    { 0x01a67c,  11, 0x015a8f,  18,    -3809 }, /* VERR_GMM_PAGE_ALREADY_FREE */
    { 0x019675,  13, 0x00de32,  28,    -3808 }, /* VERR_GMM_PAGE_NOT_SHARED */
    { 0x018d5a,  14, 0x00d10a,  29,    -3807 }, /* VERR_GMM_PAGE_NOT_PRIVATE */
    { 0x01ba3c,   8, 0x0125a9,  22,    -3806 }, /* VERR_GMM_PAGE_NOT_FOUND */
    { 0x00d470,  29, 0x0088c8,  38,    -3805 }, /* VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH */
    { 0x00ef39,  26, 0x004395,  52,    -3804 }, /* VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH */
    { 0x010be6,  24, 0x011ae3,  23,    -3803 }, /* VERR_GMM_HIT_VM_ACCOUNT_LIMIT */
    { 0x013825,  21, 0x00cd4d,  29,    -3802 }, /* VERR_GMM_HIT_GLOBAL_LIMIT */
    { 0x01987d,  13, 0x007a3a,  40,    -3801 }, /* VERR_GMM_OUT_OF_MEMORY */
    { 0x018978,  14, 0x00698c,  43,    -3778 }, /* VERR_SUPLIB_UNEXPECTED_INSTRUCTION */
    { 0x018b9a,  14, 0x004b52,  50,    -3777 }, /* VERR_SUPLIB_TEXT_NOT_SEALED */
    { 0x016d57,  17, 0x010efe,  24,    -3776 }, /* VERR_SUPLIB_TEXT_NOT_WRITEABLE */
    { 0x010c46,  24, 0x00d786,  28,    -3775 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5 */
    { 0x010cbe,  24, 0x00dd6e,  28,    -3774 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4 */
    { 0x010c8e,  24, 0x00dfd6,  28,    -3773 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3 */
    { 0x010ca6,  24, 0x00e0d2,  28,    -3772 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2 */
    { 0x010c5e,  24, 0x00d8f2,  28,    -3771 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1 */
    { 0x010c76,  24, 0x00df9e,  28,    -3770 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0 */
    { 0x01a7b0,  11, 0x007b2a,  40,    -3769 }, /* VERR_SUPLIB_INVALID_INTERNAL_APP_DIR */
    { 0x016d68,  17, 0x0059a4,  47,    -3768 }, /* VERR_SUPLIB_INVALID_ARGV0_INTERNAL */
    { 0x017729,  16, 0x0132d0,  21,    -3767 }, /* VERR_SUPLIB_WORLD_WRITABLE */
    { 0x013618,  21, 0x005b46,  46,    -3766 }, /* VERR_SUPLIB_WRITE_NON_SYS_GROUP */
    { 0x0198cb,  13, 0x018299,  15,    -3765 }, /* VERR_SUPLIB_OWNER_NOT_ROOT */
    { 0x0192a8,  14, 0x00caea,  30,    -3764 }, /* VERR_SUPLIB_NOT_SAME_OBJECT */
    { 0x01b41c,   9, 0x01998e,  13,    -3763 }, /* VERR_SUPLIB_IS_FILE */
    { 0x0192b6,  14, 0x019bca,  13,    -3762 }, /* VERR_SUPLIB_IS_DIRECTORY */
    { 0x019dfe,  12, 0x00a192,  34,    -3761 }, /* VERR_SUPLIB_NOT_DIR_NOT_FILE */
    { 0x00fd61,  25, 0x00c2f3,  30,    -3760 }, /* VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED */
    { 0x01b4eb,   9, 0x010611,  25,    -3759 }, /* VERR_SUPLIB_FSTAT_FAILED */
    { 0x01b854,   8, 0x0152e4,  19,    -3758 }, /* VERR_SUPLIB_STAT_FAILED */
    { 0x019863,  13, 0x008a6a,  38,    -3757 }, /* VERR_SUPLIB_STAT_ENUM_FAILED */
    { 0x01a212,  12, 0x018852,  14,    -3756 }, /* VERR_SUPLIB_DIR_ENUM_FAILED */
    { 0x018cce,  14, 0x019a85,  13,    -3755 }, /* VERR_SUPLIB_PATH_IS_ROOT */
    { 0x01524c,  19, 0x01600b,  18,    -3754 }, /* VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS */
    { 0x019711,  13, 0x01a1ca,  12,    -3753 }, /* VERR_SUPLIB_PATH_TOO_SHORT */
    { 0x01a0aa,  12, 0x01aac8,  11,    -3752 }, /* VERR_SUPLIB_PATH_TOO_LONG */
    { 0x019752,  13, 0x01a1a6,  12,    -3751 }, /* VERR_SUPLIB_PATH_NOT_CLEAN */
    { 0x01721a,  16, 0x018497,  15,    -3750 }, /* VERR_SUPLIB_PATH_NOT_ABSOLUTE */
    { 0x011fbb,  22, 0x0072ad,  42,    -3749 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2 */
    { 0x01232b,  22, 0x006fb9,  42,    -3748 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1 */
    { 0x00d82e,  28, 0x004633,  51,    -3747 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY */
    { 0x01a48e,  12, 0x00e6f1,  27,    -3745 }, /* VERR_SUPDRV_TSC_READ_FAILED */
    { 0x011126,  24, 0x00e4f0,  27,    -3744 }, /* VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED */
    { 0x010355,  25, 0x0088ee,  38,    -3743 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x0155c8,  18, 0x00a418,  34,    -3742 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE */
    { 0x01b166,  10, 0x003f7e,  53,    -3741 }, /* VERR_SUPDRV_CSRSS_NOT_FOUND */
    { 0x011006,  24, 0x00916f,  37,    -3740 }, /* VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR */
    { 0x0155c8,  16, 0x00cd13,  29,    -3739 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR */
    { 0x011b9b,  23, 0x00051b,  97,    -3738 }, /* VERR_SUPDRV_HARDENING_EVIL_HANDLE */
    { 0x00deda,  28, 0x005e7e,  45,    -3737 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD */
    { 0x010675,  25, 0x0079e8,  41,    -3736 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG */
    { 0x012811,  22, 0x0030d3,  58,    -3735 }, /* VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES */
    { 0x011973,  23, 0x002ec9,  58,    -3734 }, /* VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT */
    { 0x01862c,  15, 0x00c748,  30,    -3733 }, /* VERR_SUPDRV_TRACER_TOO_LARGE */
    { 0x01420c,  20, 0x0059d3,  47,    -3732 }, /* VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS */
    { 0x01517b,  19, 0x017809,  16,    -3731 }, /* VERR_SUPDRV_TRACER_BAD_ARG_FLAGS */
    { 0x010436,  25, 0x008efa,  37,    -3730 }, /* VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF */
    { 0x0137e6,  21, 0x006ce8,  43,    -3729 }, /* VERR_SUPDRV_TRACER_SESSION_BUSY */
    { 0x0162a4,  18, 0x0149c3,  19,    -3728 }, /* VERR_SUPDRV_TRACER_UNLOADING */
    { 0x0168c2,  17, 0x00fddd,  25,    -3727 }, /* VERR_SUPDRV_TRACER_NOT_PRESENT */
    { 0x017ab9,  16, 0x015c1b,  18,    -3726 }, /* VERR_SUPDRV_TRACER_NOT_OPENED */
    { 0x017999,  16, 0x00ad3e,  33,    -3725 }, /* VERR_SUPDRV_TRACER_ALREADY_OPENED */
    { 0x014450,  20, 0x00a03a,  35,    -3724 }, /* VERR_SUPDRV_TRACER_NOT_REGISTERED */
    { 0x013d5d,  20, 0x01136e,  23,    -3723 }, /* VERR_SUPDRV_TRACER_ALREADY_REGISTERED */
    { 0x00e3e2,  27, 0x00a14e,  34,    -3722 }, /* VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION */
    { 0x0166a2,  17, 0x00b624,  32,    -3721 }, /* VERR_SUPDRV_VTG_ALREADY_REGISTERED */
    { 0x017c18,  16, 0x00e727,  27,    -3720 }, /* VERR_SUPDRV_VTG_BAD_PROBE_LOC */
    { 0x0145e0,  20, 0x010a7e,  24,    -3719 }, /* VERR_SUPDRV_VTG_BAD_PROBE_ENABLED */
    { 0x019078,  14, 0x00c50e,  30,    -3718 }, /* VERR_SUPDRV_VTG_BAD_ARGLIST */
    { 0x0145e0,  12, 0x011d95,  22,    -3717 }, /* VERR_SUPDRV_VTG_BAD_PROBE */
    { 0x01835c,  15, 0x0102a6,  25,    -3716 }, /* VERR_SUPDRV_VTG_BAD_PROVIDER */
    { 0x01a5d7,  11, 0x0177c9,  16,    -3715 }, /* VERR_SUPDRV_VTG_BAD_ATTR */
    { 0x0194ef,  13, 0x01a09e,  12,    -3714 }, /* VERR_SUPDRV_VTG_STRING_TOO_LONG */
    { 0x01b9bc,   8, 0x019eca,  12,    -3713 }, /* VERR_SUPDRV_VTG_BAD_STRING */
    { 0x0176c9,  16, 0x01881a,  14,    -3712 }, /* VERR_SUPDRV_VTG_STRTAB_OFF */
    { 0x013989,  20, 0x00be1d,  31,    -3711 }, /* VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE */
    { 0x0170da,  16, 0x01852d,  15,    -3710 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH */
    { 0x018113,  15, 0x0192fc,  14,    -3709 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW */
    { 0x018f8a,  14, 0x018569,  15,    -3708 }, /* VERR_SUPDRV_VTG_BAD_HDR_PTR */
    { 0x018fd0,  14, 0x018569,  15,    -3707 }, /* VERR_SUPDRV_VTG_BAD_HDR_OFF */
    { 0x01841f,  15, 0x019a10,  13,    -3706 }, /* VERR_SUPDRV_VTG_BAD_HDR_MISC */
    { 0x01b027,  10, 0x0172ba,  16,    -3705 }, /* VERR_SUPDRV_VTG_BITS */
    { 0x01a93c,  11, 0x019c7e,  12,    -3704 }, /* VERR_SUPDRV_VTG_MAGIC */
    { 0x012d7b,  21, 0x01511c,  19,    -3703 }, /* VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX */
    { 0x019eee,  12, 0x014f7a,  19,    -3702 }, /* VERR_SUPDRV_SERVICE_NOT_FOUND */
    { 0x018ffa,  14, 0x008c7e,  38,    -3701 }, /* VERR_SUPDRV_INTERFACE_NOT_SUPPORTED */
    { 0x019016,  14, 0x012617,  22,    -3700 }, /* VERR_SUPDRV_COMPONENT_NOT_FOUND */
    { 0x00ddfa,  28, 0x010387,  25,    -3611 }, /* VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND */
    { 0x00d096,  29, 0x00b7c4,  32,    -3610 }, /* VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED */
    { 0x00c8ec,  30, 0x008531,  39,    -3609 }, /* VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND */
    { 0x011609,  23, 0x006652,  44,    -3608 }, /* VERR_INTNET_FLT_VNIC_OPEN_FAILED */
    { 0x011288,  23, 0x004daa,  50,    -3607 }, /* VERR_INTNET_FLT_VNIC_INIT_FAILED */
    { 0x00e433,  27, 0x0054af,  47,    -3606 }, /* VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND */
    { 0x0105f8,  25, 0x005d40,  46,    -3605 }, /* VERR_INTNET_FLT_VNIC_CREATE_FAILED */
    { 0x00f1c3,  26, 0x00157b,  69,    -3604 }, /* VERR_INTNET_INCOMPATIBLE_FLAGS */
    { 0x00efd5,  26, 0x004c4c,  50,    -3603 }, /* VERR_INTNET_INCOMPATIBLE_TRUNK */
    { 0x017a89,  16, 0x00508a,  49,    -3602 }, /* VERR_INTNET_FLT_IF_FAILED */
    { 0x014d07,  19, 0x00418d,  52,    -3601 }, /* VERR_INTNET_FLT_IF_BUSY */
    { 0x016e56,  17, 0x00abf4,  33,    -3600 }, /* VERR_INTNET_FLT_IF_NOT_FOUND */
    { 0x016818,  17, 0x00bed7,  31,    -3504 }, /* VERR_VGA_GL_SYMBOL_NOT_FOUND */
    { 0x013ed9,  20, 0x008d62,  38,    -3503 }, /* VERR_VGA_GL_LOAD_FAILURE */
    { 0x00d6c2,  28, 0x00609a,  45,    -3502 }, /* VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE */
    { 0x0169f4,  17, 0x00c7fc,  30,    -3500 }, /* VERR_VGA_INVALID_CUSTOM_MODE */
    { 0x00e484,  27, 0x00b484,  32,    -3408 }, /* VERR_VUSB_USB_DEVICE_PERMISSION */
    { 0x010481,  25, 0x00830f,  39,    -3407 }, /* VERR_VUSB_DEVICE_IS_SUSPENDED */
    { 0x00fb09,  25, 0x00744d,  41,    -3406 }, /* VERR_VUSB_DEVICE_IS_RESETTING */
    { 0x012341,  22, 0x00b484,  32,    -3405 }, /* VERR_VUSB_USBFS_PERMISSION */
    { 0x01425c,  20, 0x00b344,  32,    -3404 }, /* VERR_VUSB_DEVICE_NAME_NOT_FOUND */
    { 0x014055,  20, 0x009a9f,  35,    -3403 }, /* VERR_VUSB_FAILED_TO_QUEUE_URB */
    { 0x01a07a,  12, 0x014e11,  19,    -3402 }, /* VERR_VUSB_NO_URB_MEMORY */
    { 0x012777,  22, 0x007e22,  40,    -3401 }, /* VERR_VUSB_DEVICE_NOT_ATTACHED */
    { 0x019fc6,  12, 0x00fd93,  25,    -3400 }, /* VERR_VUSB_NO_PORTS */
    { 0x019530,  13, 0x014cbb,  19,    -3302 }, /* VERR_VBGL_IOCTL_FAILED */
    { 0x01a74d,  11, 0x008ab6,  38,    -3301 }, /* VERR_VBGL_INVALID_ADDR */
    { 0x01601d,  18, 0x01203f,  22,    -3300 }, /* VERR_VBGL_NOT_INITIALIZED */
    { 0x019564,  13, 0x01929a,  14,    -3290 }, /* VERR_VD_SHRINK_NOT_SUPPORTED */
    { 0x0134f2,  21, 0x00f279,  26,    -3289 }, /* VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG */
    { 0x010a4e,  24, 0x00a638,  34,    -3288 }, /* VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL */
    { 0x012a9c,  21, 0x00e95e,  27,    -3287 }, /* VERR_VD_RAW_SIZE_MODULO_2048 */
    { 0x0143d8,  20, 0x00eed1,  26,    -3286 }, /* VERR_VD_RAW_SIZE_MODULO_512 */
    { 0x013378,  21, 0x006d69,  43,    -3285 }, /* VERR_VD_DMG_NOT_FOUND_INSIDE_XAR */
    { 0x018b7e,  14, 0x0112cd,  23,    -3284 }, /* VERR_VD_DMG_XML_PARSE_ERROR */
    { 0x012f9d,  21, 0x004ed1,  49,    -3282 }, /* VERR_VD_READ_OUT_OF_RANGE */
    { 0x00e35b,  27, 0x006121,  45,    -3281 }, /* VERR_VD_IMAGE_REPAIR_IMPOSSIBLE */
    { 0x014c5c,  19, 0x017d54,  15,    -3280 }, /* VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED */
    { 0x014834,  19, 0x00a43a,  34,    -3279 }, /* VERR_VD_IMAGE_CORRUPTED */
    { 0x018c88,  14, 0x00a7f2,  34,    -3278 }, /* VERR_VD_DISCARD_NOT_SUPPORTED */
    { 0x00efbb,  26, 0x007bf2,  40,    -3277 }, /* VERR_VD_DISCARD_ALIGNMENT_NOT_MET */
    { 0x013936,  21, 0x00ee36,  26,    -3276 }, /* VERR_VD_CACHE_NOT_UP_TO_DATE */
    { 0x019cf6,  12, 0x00aee4,  32,    -3275 }, /* VERR_VD_CACHE_NOT_FOUND */
    { 0x01632e,  17, 0x00b5c4,  32,    -3274 }, /* VERR_VD_CACHE_ALREADY_EXISTS */
    { 0x0188ec,  14, 0x0019be,  67,    -3273 }, /* VERR_VD_IOCTX_HALT */
    { 0x013c95,  20, 0x0040f1,  52,    -3272 }, /* VERR_VD_NOT_ENOUGH_METADATA */
    { 0x01b210,  10, 0x01935d,  13,    -3271 }, /* VERR_VD_RAW_INVALID_TYPE */
    { 0x01872b,  15, 0x01816d,  15,    -3270 }, /* VERR_VD_RAW_INVALID_HEADER */
    { 0x017fd8,  15, 0x017e7f,  15,    -3267 }, /* VERR_VD_DMG_INVALID_HEADER */
    { 0x0130ed,  21, 0x00fdac,  25,    -3265 }, /* VERR_VD_PARALLELS_INVALID_HEADER */
    { 0x018596,  15, 0x01871c,  15,    -3260 }, /* VERR_VD_VHD_INVALID_HEADER */
    { 0x00f7f2,  26, 0x009fd1,  35,    -3253 }, /* VERR_VD_ISCSI_SECRET_ENCRYPTED */
    { 0x019cba,  12, 0x011cf4,  23,    -3252 }, /* VERR_VD_ISCSI_INVALID_TYPE */
    { 0x019e76,  12, 0x005eab,  45,    -3251 }, /* VERR_VD_ISCSI_INVALID_STATE */
    { 0x0165e7,  17, 0x015fd5,  18,    -3250 }, /* VERR_VD_ISCSI_INVALID_HEADER */
    { 0x017c73,  15, 0x012895,  22,    -3245 }, /* VERR_VD_VMDK_INVALID_WRITE */
    { 0x017689,  16, 0x009e73,  35,    -3244 }, /* VERR_VD_VMDK_INVALID_FORMAT */
    { 0x01abd0,  11, 0x0065fa,  44,    -3243 }, /* VERR_VD_VMDK_INVALID_STATE */
    { 0x01642d,  17, 0x011d0b,  23,    -3242 }, /* VERR_VD_VMDK_VALUE_NOT_FOUND */
    { 0x01a8ce,  11, 0x00f722,  26,    -3241 }, /* VERR_VD_VMDK_UNSUPPORTED_VERSION */
    { 0x017b69,  16, 0x0172da,  16,    -3240 }, /* VERR_VD_VMDK_INVALID_HEADER */
    { 0x013228,  21, 0x01731a,  16,    -3233 }, /* VERR_VD_VDI_COMMENT_TOO_LONG */
    { 0x01ae8d,  10, 0x01030a,  25,    -3232 }, /* VERR_VD_VDI_UNSUPPORTED_VERSION */
    { 0x015915,  18, 0x00e3ac,  27,    -3231 }, /* VERR_VD_VDI_INVALID_SIGNATURE */
    { 0x017df9,  15, 0x018398,  15,    -3230 }, /* VERR_VD_VDI_INVALID_HEADER */
    { 0x017dbd,  15, 0x014bfd,  19,    -3220 }, /* VERR_VD_GEN_INVALID_HEADER */
    { 0x01224f,  22, 0x006576,  44,    -3215 }, /* VERR_VD_PASSWORD_INCORRECT */
    { 0x01b506,   9, 0x00be5b,  31,    -3214 }, /* VERR_VD_DEK_MISSING */
    { 0x018cc0,  14, 0x014fc6,  19,    -3213 }, /* VERR_VD_UNKNOWN_INTERFACE */
    { 0x017ca0,  15, 0x01113e,  24,    -3212 }, /* VERR_VD_UNKNOWN_CFG_VALUES */
    { 0x01bd81,   6, 0x00bc4d,  31,    -3211 }, /* VERR_VD_INVALID_SIZE */
    { 0x010796,  24, 0x00b084,  32,    -3210 }, /* VERR_VD_ASYNC_IO_IN_PROGRESS */
    { 0x01b21a,  10, 0x002a69,  59,    -3208 }, /* VERR_VD_UUID_MISMATCH */
    { 0x018f36,  14, 0x0134c8,  21,    -3207 }, /* VERR_VD_BLOCK_FREE */
    { 0x016c25,  17, 0x012af0,  21,    -3206 }, /* VERR_VD_GEOMETRY_NOT_SET */
    { 0x014b2c,  19, 0x016592,  17,    -3205 }, /* VERR_VD_IMAGE_READ_ONLY */
    { 0x01a086,  12, 0x01452c,  20,    -3204 }, /* VERR_VD_IMAGE_NOT_FOUND */
    { 0x01ab15,  11, 0x012ac6,  21,    -3203 }, /* VERR_VD_NOT_OPENED */
    { 0x01a52a,  12, 0x016bae,  17,    -3202 }, /* VERR_VD_VALUE_NOT_FOUND */
    { 0x01bd87,   6, 0x004732,  51,    -3201 }, /* VERR_VD_INVALID_STATE */
    { 0x01bdbd,   6, 0x01bcdf,   7,    -3200 }, /* VERR_VD_INVALID_TYPE */
    { 0x01919e,  14, 0x005c88,  46,    -3105 }, /* VERR_HOSTIF_TERM_FAILED */
    { 0x010e3e,  24, 0x0008b9,  88,    -3104 }, /* VERR_HOSTIF_FD_AND_INIT_TERM */
    { 0x0174ba,  16, 0x003b19,  54,    -3103 }, /* VERR_HOSTIF_BLOCKING */
    { 0x019c0b,  13, 0x004600,  51,    -3102 }, /* VERR_HOSTIF_IOCTL */
    { 0x00fe0f,  25, 0x007ab2,  40,    -3101 }, /* VERR_HOSTIF_DEVICE_NAME_TOO_LONG */
    { 0x018a04,  14, 0x0075be,  41,    -3100 }, /* VERR_HOSTIF_INIT_FAILED */
    { 0x0173ea,  16, 0x009494,  36,    -3002 }, /* VERR_NAT_REDIR_SETUP */
    { 0x0149fc,  19, 0x0071b1,  42,    -3001 }, /* VERR_NAT_REDIR_GUEST_IP */
    { 0x01466b,  20, 0x009ae5,  35,    -2909 }, /* VERR_HGCM_TOO_MANY_CLIENT_CALLS */
    { 0x017e17,  15, 0x011523,  23,    -2908 }, /* VERR_HGCM_TOO_MANY_CLIENTS */
    { 0x0139ed,  20, 0x00f4b5,  26,    -2907 }, /* VERR_HGCM_SERVICE_EXISTS */
    { 0x017749,  16, 0x0176e9,  16,    -2905 }, /* VERR_HGCM_INVALID_CLIENT_ID */
    { 0x0191e4,  14, 0x00e50b,  27,    -2904 }, /* VERR_HGCM_INTERNAL */
    { 0x0156e8,  18, 0x00fa73,  25,    -2902 }, /* VERR_HGCM_INVALID_CMD_ADDRESS */
    { 0x0174aa,  16, 0x00ee9d,  26,    -2900 }, /* VERR_HGCM_SERVICE_NOT_FOUND */
    { 0x015754,  18, 0x0162b6,  18,    -2899 }, /* VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE */
    { 0x013b91,  20, 0x01a49a,  12,    -2897 }, /* VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND */
    { 0x00f2c7,  26, 0x01467f,  20,    -2896 }, /* VERR_PDM_MEDIAEX_IOREQID_CONFLICT */
    { 0x0111b6,  24, 0x00a170,  34,    -2895 }, /* VERR_PDM_MEDIAEX_IOBUF_UNDERRUN */
    { 0x010e86,  24, 0x00a9c3,  33,    -2894 }, /* VERR_PDM_MEDIAEX_IOBUF_OVERFLOW */
    { 0x010f16,  24, 0x01746a,  16,    -2893 }, /* VERR_PDM_MEDIAEX_IOREQ_CANCELED */
    { 0x01b665,   8, 0x002e19,  59,    -2892 }, /* VERR_PDM_HM_IPE */
    { 0x01631d,  17, 0x001d55,  65,    -2891 }, /* VERR_PDM_NOT_PCI_BUS_MASTER */
    { 0x00aacb,  33, 0x0031f4,  57,    -2890 }, /* VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER */
    { 0x00a836,  34, 0x00bda1,  31,    -2889 }, /* VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION */
    { 0x01b89c,   8, 0x01958b,  13,    -2888 }, /* VERR_PDM_DEV_IPE_1 */
    { 0x01942c,  13, 0x014ae0,  19,    -2887 }, /* VERR_PDM_BAD_PCI_CONFIG */
    { 0x00cf57,  29, 0x0052ff,  48,    -2886 }, /* VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE */
    { 0x01ab41,  11, 0x013f65,  20,    -2885 }, /* VERR_PDM_THREAD_IPE_2 */
    { 0x01ab57,  11, 0x013aa1,  20,    -2884 }, /* VERR_PDM_THREAD_IPE_1 */
    { 0x01707a,  16, 0x00802a,  39,    -2883 }, /* VERR_PDM_THREAD_INVALID_CALLER */
    { 0x019391,  13, 0x00d6fa,  28,    -2882 }, /* VERR_PDM_CRITSECT_NOT_FOUND */
    { 0x0188d0,  14, 0x01739a,  16,    -2881 }, /* VERR_PDM_CRITSECT_IPE */
    { 0x012525,  22, 0x003181,  58,    -2880 }, /* VERR_PDM_HPET_LEGACY_NOTIFY_MISSING */
    { 0x011831,  23, 0x00b3e4,  32,    -2879 }, /* VERR_PDM_DEV_HEAP_R3_TO_GCPHYS */
    { 0x01a0e6,  12, 0x01939e,  13,    -2878 }, /* VERR_PDM_DRIVER_VERSION_MISMATCH */
    { 0x019db6,  12, 0x016a6b,  17,    -2877 }, /* VERR_PDM_USBDEV_VERSION_MISMATCH */
    { 0x01a10a,  12, 0x019627,  13,    -2876 }, /* VERR_PDM_DEVICE_VERSION_MISMATCH */
    { 0x018c5e,  14, 0x013de9,  20,    -2875 }, /* VERR_PDM_DRVHLPR3_VERSION_MISMATCH */
    { 0x01a2d2,  12, 0x012827,  22,    -2874 }, /* VERR_PDM_DRVINS_VERSION_MISMATCH */
    { 0x018b54,  14, 0x010af6,  24,    -2873 }, /* VERR_PDM_USBHLPR3_VERSION_MISMATCH */
    { 0x01a512,  12, 0x00f08b,  26,    -2872 }, /* VERR_PDM_USBINS_VERSION_MISMATCH */
    { 0x019f12,  12, 0x014324,  20,    -2871 }, /* VERR_PDM_DEVHLP_VERSION_MISMATCH */
    { 0x019e6a,  12, 0x0127fb,  22,    -2870 }, /* VERR_PDM_DEVINS_VERSION_MISMATCH */
    { 0x010e9e,  24, 0x00d3c2,  29,    -2869 }, /* VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES */
    { 0x013cf9,  20, 0x010193,  25,    -2868 }, /* VERR_PDM_TOO_MANY_DRIVER_INSTANCES */
    { 0x0145b8,  20, 0x00fbb8,  25,    -2867 }, /* VERR_PDM_TOO_MANY_DEVICE_INSTANCES */
    { 0x014478,  20, 0x002bcb,  59,    -2866 }, /* VERR_PDM_DRIVER_INVALID_PROPERTIES */
    { 0x00cee3,  29, 0x009cf2,  35,    -2865 }, /* VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED */
    { 0x00cdde,  29, 0x009d5b,  35,    -2864 }, /* VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED */
    { 0x012e62,  21, 0x00857f,  39,    -2863 }, /* VERR_PDM_ASYNC_TEMPLATE_BUSY */
    { 0x01aa7b,  11, 0x00b1c4,  32,    -2862 }, /* VERR_PDM_NO_USBPROXY */
    { 0x01a2ba,  12, 0x005d9c,  46,    -2861 }, /* VERR_PDM_NO_USB_PORTS */
    { 0x01aa18,  11, 0x007f8a,  40,    -2860 }, /* VERR_PDM_NO_USB_HUBS */
    { 0x017a19,  16, 0x01283d,  22,    -2859 }, /* VERR_PDM_USB_HUB_EXISTS */
    { 0x0170aa,  16, 0x015ab3,  18,    -2858 }, /* VERR_PDM_USB_NAME_CLASH */
    { 0x015226,  19, 0x00dbae,  28,    -2857 }, /* VERR_PDM_INVALID_USB_REGISTRATION */
    { 0x01a897,  11, 0x004699,  51,    -2856 }, /* VERR_PDM_UNKNOWN_USBREG_VERSION */
    { 0x01b9ac,   8, 0x010c2e,  24,    -2855 }, /* VERR_PDM_HIF_INVALID_VERSION */
    { 0x01480e,  19, 0x0119e6,  23,    -2854 }, /* VERR_PDM_DRIVER_NO_RT_ATTACH */
    { 0x014dc5,  19, 0x011a42,  23,    -2853 }, /* VERR_PDM_DEVICE_NO_RT_ATTACH */
    { 0x019e3a,  12, 0x0112fb,  23,    -2852 }, /* VERR_PDM_HIF_OPEN_FAILED */
    { 0x0116aa,  23, 0x004f95,  49,    -2851 }, /* VERR_PDM_HIF_SHARING_VIOLATION */
    { 0x0180b9,  15, 0x00164a,  69,    -2850 }, /* VERR_PDM_NO_RTC_INSTANCE */
    { 0x01749a,  16, 0x001fd6,  64,    -2849 }, /* VERR_PDM_NO_DMAC_INSTANCE */
    { 0x017b49,  16, 0x001d14,  65,    -2848 }, /* VERR_PDM_NO_APIC_INSTANCE */
    { 0x0183b6,  15, 0x0021cf,  63,    -2847 }, /* VERR_PDM_NO_PIC_INSTANCE */
    { 0x00fe41,  25, 0x004896,  50,    -2846 }, /* VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01b87c,   8, 0x017bd8,  16,    -2845 }, /* VERR_PDM_LUN_NOT_FOUND */
    { 0x013f29,  20, 0x013dd5,  20,    -2844 }, /* VERR_PDM_DRIVER_INSTANCE_NOT_FOUND */
    { 0x010ee6,  24, 0x008eb0,  37,    -2843 }, /* VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND */
    { 0x010ece,  24, 0x00a308,  34,    -2842 }, /* VERR_PDM_DEVICE_INSTANCE_NO_IBASE */
    { 0x013c81,  20, 0x018dae,  14,    -2841 }, /* VERR_PDM_DEVICE_INSTANCE_NOT_FOUND */
    { 0x01aade,  11, 0x01b04f,  10,    -2840 }, /* VERR_PDM_DEVICE_NOT_FOUND */
    { 0x0153db,  19, 0x015d95,  18,    -2839 }, /* VERR_PDM_DEVICE_NAME_CLASH */
    { 0x01492b,  19, 0x00824c,  39,    -2838 }, /* VERR_PDM_INVALID_DEVICE_HOST_BITS */
    { 0x014428,  20, 0x01861d,  15,    -2837 }, /* VERR_PDM_INVALID_DEVICE_GUEST_BITS */
    { 0x011dab,  22, 0x00dbae,  28,    -2836 }, /* VERR_PDM_INVALID_DEVICE_REGISTRATION */
    { 0x01a881,  11, 0x0058b9,  47,    -2835 }, /* VERR_PDM_UNKNOWN_DEVREG_VERSION */
    { 0x01954a,  13, 0x003549,  56,    -2834 }, /* VERR_PDM_NOT_PCI_DEVICE */
    { 0x01aefb,  10, 0x00d501,  29,    -2833 }, /* VERR_PDM_NO_PCI_BUS */
    { 0x010242,  25, 0x004831,  51,    -2832 }, /* VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE */
    { 0x015097,  19, 0x01861d,  15,    -2831 }, /* VERR_PDM_INVALID_DRIVER_HOST_BITS */
    { 0x0122bd,  22, 0x00d652,  28,    -2830 }, /* VERR_PDM_INVALID_DRIVER_REGISTRATION */
    { 0x01a7fd,  11, 0x00579f,  47,    -2829 }, /* VERR_PDM_UNKNOWN_DRVREG_VERSION */
    { 0x014d53,  19, 0x015ab3,  18,    -2828 }, /* VERR_PDM_DRIVER_NAME_CLASH */
    { 0x014e37,  19, 0x012b05,  21,    -2827 }, /* VERR_PDM_MODULE_NAME_TOO_LONG */
    { 0x011e71,  22, 0x003629,  56,    -2826 }, /* VERR_PDM_NO_REGISTRATION_EXPORT */
    { 0x01505e,  19, 0x007825,  41,    -2825 }, /* VERR_PDM_MODULE_NAME_CLASH */
    { 0x01ab36,  11, 0x012bad,  21,    -2823 }, /* VERR_PDM_DRIVER_NOT_FOUND */
    { 0x0152d1,  19, 0x003a41,  54,    -2822 }, /* VERR_PDM_CFG_MISSING_DRIVER_NAME */
    { 0x00fe41,  18, 0x00030f, 110,    -2821 }, /* VERR_PDM_NO_DRIVER_ATTACHED */
    { 0x015a7d,  18, 0x004c7e,  50,    -2820 }, /* VERR_PDM_DRIVER_ALREADY_ATTACHED */
    { 0x01ac2b,  10, 0x0167f6,  17,    -2819 }, /* VERR_PDM_UNSUPPORTED_BLOCK_TYPE */
    { 0x01470b,  20, 0x001e16,  64,    -2818 }, /* VERR_PDM_BLOCK_UNKNOWN_TRANSLATION */
    { 0x01ac0d,  10, 0x0033f5,  57,    -2817 }, /* VERR_PDM_BLOCK_UNKNOWN_TYPE */
    { 0x01ad6b,  10, 0x006dbf,  43,    -2816 }, /* VERR_PDM_BLOCK_NO_TYPE */
    { 0x018f44,  14, 0x00ddde,  28,    -2815 }, /* VERR_PDM_MEDIA_LOCKED */
    { 0x017c28,  15, 0x00f5b8,  26,    -2814 }, /* VERR_PDM_MEDIA_MOUNTED */
    { 0x017a39,  16, 0x0063be,  44,    -2813 }, /* VERR_PDM_MEDIA_NOT_MOUNTED */
    { 0x015def,  18, 0x003dd6,  53,    -2812 }, /* VERR_PDM_TRANSLATION_NOT_SET */
    { 0x01823f,  15, 0x004b20,  50,    -2811 }, /* VERR_PDM_GEOMETRY_NOT_SET */
    { 0x0155b6,  18, 0x0164d7,  17,    -2810 }, /* VERR_PDM_NO_ATTACHED_DRIVER */
    { 0x01713a,  16, 0x008668,  38,    -2809 }, /* VERR_PDM_DEVINS_NO_ATTACH */
    { 0x0175c9,  16, 0x005b74,  46,    -2808 }, /* VERR_PDM_DRVINS_NO_ATTACH */
    { 0x018d22,  14, 0x0089ac,  38,    -2807 }, /* VERR_PDM_NO_QUEUE_ITEMS */
    { 0x017ebb,  15, 0x006834,  43,    -2806 }, /* VERR_PDM_TOO_PCI_MANY_DEVICES */
    { 0x014195,  20, 0x00d84a,  28,    -2805 }, /* VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES */
    { 0x014f41,  13, 0x003c27,  54,    -2804 }, /* VERR_PDM_MISSING_INTERFACE */
    { 0x01504b,  19, 0x001f56,  64,    -2803 }, /* VERR_PDM_MISSING_INTERFACE_BELOW */
    { 0x014f41,  19, 0x00279b,  60,    -2802 }, /* VERR_PDM_MISSING_INTERFACE_ABOVE */
    { 0x013fdd,  20, 0x00d636,  28,    -2801 }, /* VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES */
    { 0x01a9f7,  11, 0x00cb7d,  29,    -2800 }, /* VERR_PDM_NO_SUCH_LUN */
    { 0x011d67,  23, 0x00654a,  44,    -2721 }, /* VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET */
    { 0x016d24,  17, 0x0129df,  21,    -2720 }, /* VERR_VMM_CANNOT_BLOCK */
    { 0x00ba7c,  31, 0x001ed6,  64,    -2719 }, /* VERR_VMM_CONTEXT_HOOK_STILL_ENABLED */
    { 0x014338,  20, 0x01062a,  25,    -2718 }, /* VERR_VMM_WRONG_NEM_VMCPU_STATE */
    { 0x012399,  22, 0x00138f,  71,    -2717 }, /* VERR_VMM_SMAP_BUT_AC_CLEAR */
    { 0x0129f4,  21, 0x00f127,  26,    -2716 }, /* VERR_VMM_WRONG_HM_VMCPU_STATE */
    { 0x015d71,  18, 0x00ce35,  29,    -2715 }, /* VERR_VMM_SWITCHER_STUB */
    { 0x017679,  16, 0x015c63,  18,    -2713 }, /* VERR_VMM_SWITCHER_IPE_1 */
    { 0x017eac,  15, 0x017e53,  15,    -2709 }, /* VERR_VMM_LONG_JMP_ERROR */
    { 0x01a78f,  11, 0x01bbce,   7,    -2705 }, /* VERR_VMM_RC_VERSION_MISMATCH */
    { 0x01a8ad,  11, 0x01bb04,   7,    -2704 }, /* VERR_VMM_R0_VERSION_MISMATCH */
    { 0x010d36,  24, 0x00dd1a,  28,    -2703 }, /* VERR_VMM_RING3_CALL_DISABLED */
    { 0x016f4a,  16, 0x0091de,  37,    -2702 }, /* VERR_VMM_HYPER_CR3_MISMATCH */
    { 0x0143b0,  20, 0x0090db,  37,    -2701 }, /* VERR_VMM_RING0_ASSERTION */
    { 0x012a1e,  21, 0x0156d6,  18,    -2663 }, /* VERR_IOM_MMIO_REGION_NOT_MAPPED */
    { 0x013546,  21, 0x015ce1,  18,    -2662 }, /* VERR_IOM_MMIO_REGION_ALREADY_MAPPED */
    { 0x019120,  14, 0x01ac03,  10,    -2661 }, /* VERR_IOM_INVALID_MMIO_HANDLE */
    { 0x012853,  22, 0x013879,  21,    -2660 }, /* VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS */
    { 0x013bb9,  20, 0x0122a7,  22,    -2653 }, /* VERR_IOM_IOPORTS_NOT_MAPPED */
    { 0x014388,  20, 0x0125eb,  22,    -2652 }, /* VERR_IOM_IOPORTS_ALREADY_MAPPED */
    { 0x014f08,  19, 0x016e45,  17,    -2651 }, /* VERR_IOM_INVALID_IOPORT_HANDLE */
    { 0x00ed45,  27, 0x00dcc6,  28,    -2650 }, /* VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS */
    { 0x016041,  18, 0x00c946,  30,    -2638 }, /* VERR_IOM_FF_STATUS_IPE */
    { 0x01a9aa,  11, 0x002a2e,  59,    -2637 }, /* VERR_IOM_HM_IPE */
    { 0x01b488,   9, 0x01aa65,  11,    -2636 }, /* VERR_IOM_MMIO_IPE_3 */
    { 0x01b491,   9, 0x01a6df,  11,    -2635 }, /* VERR_IOM_MMIO_IPE_2 */
    { 0x01b49a,   9, 0x01aae9,  11,    -2634 }, /* VERR_IOM_MMIO_IPE_1 */
    { 0x019342,  14, 0x015fb1,  18,    -2633 }, /* VERR_IOM_IOPORT_IPE_3 */
    { 0x019318,  14, 0x016173,  18,    -2632 }, /* VERR_IOM_IOPORT_IPE_2 */
    { 0x0192ee,  14, 0x01567c,  18,    -2631 }, /* VERR_IOM_IOPORT_IPE_1 */
    { 0x0149d6,  19, 0x005fe6,  45,    -2630 }, /* VERR_IOM_IOPORT_UNKNOWN_OPCODE */
    { 0x015f7b,  18, 0x0010c1,  73,    -2614 }, /* VERR_IOM_IOPORT_UNUSED */
    { 0x0117be,  23, 0x0052cf,  48,    -2613 }, /* VERR_IOM_MMIO_HANDLER_DISASM_ERROR */
    { 0x010116,  25, 0x0097d0,  36,    -2612 }, /* VERR_IOM_MMIO_HANDLER_BOGUS_CALL */
    { 0x018f6e,  14, 0x00b6c4,  32,    -2611 }, /* VERR_IOM_INVALID_IOPORT_SIZE */
    { 0x0119b8,  23, 0x00d7f6,  28,    -2610 }, /* VERR_IOM_INCOMPLETE_MMIO_RANGE */
    { 0x017f60,  15, 0x011fd1,  22,    -2609 }, /* VERR_IOM_MMIO_RANGE_NOT_FOUND */
    { 0x013141,  21, 0x008830,  38,    -2608 }, /* VERR_IOM_MMIO_RANGE_CONFLICT */
    { 0x0152f7,  19, 0x0080ed,  39,    -2607 }, /* VERR_IOM_NOT_MMIO_RANGE_OWNER */
    { 0x017619,  16, 0x003a77,  54,    -2606 }, /* VERR_IOM_NO_R3_MMIO_RANGE */
    { 0x019bbd,  13, 0x015401,  19,    -2605 }, /* VERR_IOM_INVALID_MMIO_RANGE */
    { 0x01092e,  24, 0x005d12,  46,    -2604 }, /* VERR_IOM_NOT_IOPORT_RANGE_OWNER */
    { 0x013ba5,  20, 0x0026e5,  61,    -2603 }, /* VERR_IOM_IOPORT_RANGE_NOT_FOUND */
    { 0x00f2fb,  26, 0x00617b,  45,    -2602 }, /* VERR_IOM_IOPORT_RANGE_CONFLICT */
    { 0x013363,  21, 0x00262e,  61,    -2601 }, /* VERR_IOM_NO_R3_IOPORT_RANGE */
    { 0x0160d1,  18, 0x00f66d,  26,    -2600 }, /* VERR_IOM_INVALID_IOPORT_RANGE */
    { 0x019c96,  12, 0x002903,  60,    -2509 }, /* VERR_SELM_HM_IPE */
    { 0x01825d,  15, 0x003d6b,  54,    -2508 }, /* VERR_SELM_GDT_TOO_FULL */
    { 0x017a99,  16, 0x005ce4,  46,    -2507 }, /* VERR_SELM_GDT_READ_ERROR */
    { 0x011551,  23, 0x00d92a,  28,    -2506 }, /* VERR_SELM_LDT_OUT_OF_BOUNDS */
    { 0x01b031,  10, 0x01860e,  15,    -2505 }, /* VERR_SELM_INVALID_LDT */
    { 0x01b135,  10, 0x0150f6,  19,    -2504 }, /* VERR_SELM_NO_TSS */
    { 0x012987,  22, 0x006a63,  43,    -2502 }, /* VERR_SELM_SHADOW_TSS_WRITE */
    { 0x0120ef,  22, 0x0067de,  43,    -2501 }, /* VERR_SELM_SHADOW_LDT_WRITE */
    { 0x011edf,  22, 0x006d13,  43,    -2500 }, /* VERR_SELM_SHADOW_GDT_WRITE */
    { 0x01a1be,  12, 0x0027d7,  60,    -2409 }, /* VERR_TRPM_HM_IPE */
    { 0x01ba6c,   8, 0x019c66,  12,    -2408 }, /* VERR_TRPM_IPE_3 */
    { 0x01ba74,   8, 0x01a2ae,  12,    -2407 }, /* VERR_TRPM_IPE_2 */
    { 0x01ba7c,   8, 0x019ebe,  12,    -2406 }, /* VERR_TRPM_IPE_1 */
    { 0x016928,  17, 0x016bd0,  17,    -2405 }, /* VERR_TRPM_BAD_TRAP_IN_OP */
    { 0x01ab0a,  11, 0x0142ac,  20,    -2404 }, /* VERR_TRPM_PANIC */
    { 0x017539,  16, 0x00c4b4,  30,    -2403 }, /* VERR_TRPM_DONT_PANIC */
    { 0x011eb3,  22, 0x006c92,  43,    -2402 }, /* VERR_TRPM_SHADOW_IDT_WRITE */
    { 0x01696c,  17, 0x019e5e,  12,    -2401 }, /* VERR_TRPM_ACTIVE_TRAP */
    { 0x015d17,  18, 0x019b96,  13,    -2400 }, /* VERR_TRPM_NO_ACTIVE_TRAP */
    { 0x01bd51,   6, 0x01b3e6,   9,    -2299 }, /* VERR_TM_IPE_9 */
    { 0x01bea7,   6, 0x01b45b,   9,    -2298 }, /* VERR_TM_IPE_8 */
    { 0x01bead,   6, 0x01b3ef,   9,    -2297 }, /* VERR_TM_IPE_7 */
    { 0x01beb3,   6, 0x01b27e,   9,    -2296 }, /* VERR_TM_IPE_6 */
    { 0x01beb9,   6, 0x01b251,   9,    -2295 }, /* VERR_TM_IPE_5 */
    { 0x01bd21,   6, 0x01b40a,   9,    -2294 }, /* VERR_TM_IPE_4 */
    { 0x01bd09,   6, 0x01b2ab,   9,    -2293 }, /* VERR_TM_IPE_3 */
    { 0x01bd0f,   6, 0x01b344,   9,    -2292 }, /* VERR_TM_IPE_2 */
    { 0x01bd15,   6, 0x01b395,   9,    -2291 }, /* VERR_TM_IPE_1 */
    { 0x00e943,  27, 0x009788,  36,    -2214 }, /* VERR_TM_TIMER_QUEUE_CANNOT_GROW */
    { 0x017949,  16, 0x013f8d,  20,    -2213 }, /* VERR_TM_INVALID_TIMER_QUEUE */
    { 0x01a16a,  12, 0x0108e6,  24,    -2212 }, /* VERR_TM_TOO_MANY_TIMERS */
    { 0x011357,  23, 0x014f2e,  19,    -2211 }, /* VERR_TM_VIRTUAL_TICKING_IPE */
    { 0x017f24,  15, 0x00d716,  28,    -2210 }, /* VERR_TM_TSC_ALREADY_PAUSED */
    { 0x01708a,  16, 0x00c70c,  30,    -2209 }, /* VERR_TM_TSC_ALREADY_TICKING */
    { 0x014374,  20, 0x00c63a,  30,    -2208 }, /* VERR_TM_TIMER_UNSTABLE_STATE */
    { 0x017839,  16, 0x0043c9,  52,    -2207 }, /* VERR_TM_TIMER_BAD_CLOCK */
    { 0x00db76,  28, 0x00d1d5,  29,    -2206 }, /* VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG */
    { 0x01b3dd,   9, 0x015071,  19,    -2205 }, /* VERR_TM_GIP_VERSION */
    { 0x0171fa,  16, 0x017509,  16,    -2204 }, /* VERR_TM_GIP_REQUIRED */
    { 0x018cf8,  14, 0x00297b,  60,    -2203 }, /* VERR_TM_UNSTABLE_STATE */
    { 0x01bd7b,   6, 0x00f9ab,  25,    -2202 }, /* VERR_TM_UNKNOWN_STATE */
    { 0x01be35,   6, 0x011036,  24,    -2201 }, /* VERR_TM_INVALID_STATE */
    { 0x01acf3,  10, 0x00f3cb,  26,    -2200 }, /* VERR_TM_LOAD_STATE */
    { 0x01b9fc,   8, 0x01a3ce,  12,    -2165 }, /* VERR_CFGM_IPE_1 */
    { 0x015b55,  18, 0x007061,  42,    -2164 }, /* VERR_CFGM_CONFIG_UNKNOWN_NODE */
    { 0x015298,  19, 0x00af04,  32,    -2163 }, /* VERR_CFGM_CONFIG_UNKNOWN_VALUE */
    { 0x016b48,  17, 0x003b85,  54,    -2162 }, /* VERR_CFGM_LEAF_EXISTS */
    { 0x01641c,  17, 0x003cff,  54,    -2161 }, /* VERR_CFGM_NODE_EXISTS */
    { 0x016f9a,  16, 0x007d32,  40,    -2160 }, /* VERR_CFGM_INVALID_NODE_PATH */
    { 0x0186c2,  15, 0x00880a,  38,    -2110 }, /* VERR_CFGM_NOT_PASSWORD */
    { 0x015109,  19, 0x00f7d8,  26,    -2109 }, /* VERR_CFGM_NOT_ENOUGH_SPACE */
    { 0x019f5a,  12, 0x01570c,  18,    -2108 }, /* VERR_CFGM_NOT_BYTES */
    { 0x01b964,   8, 0x00829a,  39,    -2107 }, /* VERR_CFGM_NOT_STRING */
    { 0x018a90,  14, 0x019aac,  13,    -2106 }, /* VERR_CFGM_NOT_INTEGER */
    { 0x01a666,  11, 0x0164a4,  17,    -2105 }, /* VERR_CFGM_NO_NODE */
    { 0x01936a,  13, 0x011b28,  23,    -2104 }, /* VERR_CFGM_NO_PARENT */
    { 0x01895c,  14, 0x01b8fc,   8,    -2103 }, /* VERR_CFGM_VALUE_NOT_FOUND */
    { 0x016d46,  17, 0x01206b,  22,    -2102 }, /* VERR_CFGM_INVALID_CHILD_PATH */
    { 0x0188b4,  14, 0x018ba8,  14,    -2101 }, /* VERR_CFGM_CHILD_NOT_FOUND */
    { 0x0157e4,  18, 0x00a2a2,  34,    -2100 }, /* VERR_CFGM_INTEGER_TOO_BIG */
    { 0x015343,  19, 0x01595d,  18,    -2007 }, /* VERR_VRDP_ACCESS_DENIED */
    { 0x01b62d,   8, 0x014d40,  19,    -2006 }, /* VERR_VRDP_NO_MEMORY */
    { 0x01a716,  11, 0x00a34c,  34,    -2005 }, /* VERR_VRDP_INVALID_MODE */
    { 0x011bf7,  23, 0x002f77,  58,    -2004 }, /* VERR_VRDP_INSUFFICIENT_DATA */
    { 0x01b74c,   8, 0x0115ad,  23,    -2003 }, /* VERR_VRDP_NOT_SUPPORTED */
    { 0x017979,  16, 0x010d96,  24,    -2002 }, /* VERR_VRDP_PROTOCOL_ERROR */
    { 0x013180,  21, 0x00a981,  33,    -2001 }, /* VERR_VRDP_SEC_ENGINE_FAIL */
    { 0x014b8b,  19, 0x014005,  20,    -2000 }, /* VERR_VRDP_ISO_UNSUPPORTED */
    { 0x016471,  17, 0x00d4c7,  29,    -1919 }, /* VERR_VM_REQUEST_KILLED */
    { 0x018686,  15, 0x01716a,  16,    -1918 }, /* VERR_VM_FATAL_WAIT_ERROR */
    { 0x012d90,  21, 0x00708b,  42,    -1917 }, /* VERR_VM_REQUEST_TOO_MANY_ARGS_IPE */
    { 0x018f0c,  14, 0x01613d,  18,    -1916 }, /* VERR_VM_UNEXPECTED_UNSTABLE_STATE */
    { 0x01bc06,   7, 0x012da5,  21,    -1915 }, /* VERR_VM_UNEXPECTED_VM_STATE */
    { 0x0178f9,  16, 0x005bfe,  46,    -1914 }, /* VERR_VM_THREAD_IS_EMT */
    { 0x015f57,  18, 0x00ac78,  33,    -1913 }, /* VERR_VM_SAVE_STATE_NOT_ALLOWED */
    { 0x019384,  13, 0x00cb9a,  29,    -1912 }, /* VERR_VM_DRIVER_VERSION_MISMATCH */
    { 0x0173fa,  16, 0x00fc03,  25,    -1911 }, /* VERR_VM_DRIVER_OPEN_ERROR */
    { 0x017a59,  16, 0x01049a,  25,    -1910 }, /* VERR_VM_DRIVER_LOAD_ERROR */
    { 0x0133cc,  21, 0x017af9,  16,    -1909 }, /* VERR_VM_DRIVER_NOT_ACCESSIBLE */
    { 0x013dc1,  20, 0x017eca,  15,    -1908 }, /* VERR_VM_DRIVER_NOT_INSTALLED */
    { 0x01bb49,   7, 0x01b198,  10,    -1907 }, /* VERR_VM_INVALID_VM_STATE */
    { 0x018a3c,  14, 0x00495e,  50,    -1906 }, /* VERR_VM_THREAD_NOT_EMT */
    { 0x011454,  23, 0x00a67c,  34,    -1905 }, /* VERR_VM_REQUEST_STATUS_FREED */
    { 0x00c1de,  31, 0x00284f,  60,    -1904 }, /* VERR_VM_REQUEST_STATUS_STILL_PENDING */
    { 0x014b19,  19, 0x01a8c3,  11,    -1903 }, /* VERR_VM_REQUEST_INVALID_PACKAGE */
    { 0x01a1d6,  12, 0x01aea1,  10,    -1902 }, /* VERR_VM_REQUEST_STATE */
    { 0x01968f,  13, 0x01b383,   9,    -1901 }, /* VERR_VM_REQUEST_INVALID_TYPE */
    { 0x01972b,  13, 0x00ec1c,  27,    -1900 }, /* VERR_VM_ATRESET_NOT_FOUND */
    { 0x00ff09,  25, 0x016b7b,  17,    -1880 }, /* VERR_SSM_ENUM_VALUE_OUT_OF_RANGE */
    { 0x00b944,  32, 0x000d40,  77,    -1879 }, /* VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION */
    { 0x01c0c9,   4, 0x01a0f2,  12,    -1878 }, /* VERR_SSM_IPE_3 */
    { 0x01c02d,   4, 0x01a4b2,  12,    -1877 }, /* VERR_SSM_IPE_2 */
    { 0x01c031,   4, 0x019d1a,  12,    -1876 }, /* VERR_SSM_IPE_1 */
    { 0x01b924,   8, 0x00ccbc,  29,    -1875 }, /* VERR_SSM_BAD_REC_TYPE */
    { 0x01ae97,  10, 0x0056b4,  47,    -1874 }, /* VERR_SSM_MEM_TOO_BIG */
    { 0x016f6a,  16, 0x006dea,  43,    -1873 }, /* VERR_SSM_SKIP_BACKWARDS */
    { 0x01bb88,   7, 0x006702,  44,    -1872 }, /* VERR_SSM_UNEXPECTED_PASS */
    { 0x01ae47,  10, 0x01b2fc,   9,    -1871 }, /* VERR_SSM_STREAM_ERROR */
    { 0x01886e,  14, 0x010d06,  24,    -1870 }, /* VERR_SSM_FIELD_INVALID_VALUE */
    { 0x015a59,  18, 0x0118a4,  23,    -1869 }, /* VERR_SSM_FIELD_INVALID_PADDING_SIZE */
    { 0x0166e6,  17, 0x0077d3,  41,    -1868 }, /* VERR_SSM_FIELD_INVALID_CALLBACK */
    { 0x0139b1,  20, 0x007109,  42,    -1867 }, /* VERR_SSM_FIELD_NOT_CONSECUTIVE */
    { 0x012de4,  21, 0x00e0b6,  28,    -1866 }, /* VERR_SSM_FIELD_OUT_OF_BOUNDS */
    { 0x01ae33,  10, 0x00abd3,  33,    -1865 }, /* VERR_SSM_FIELD_INVALID_SIZE */
    { 0x0184a6,  15, 0x003cc9,  54,    -1864 }, /* VERR_SSM_FIELD_COMPLEX */
    { 0x018e56,  14, 0x002f3d,  58,    -1863 }, /* VERR_SSM_LIVE_FATAL_ERROR */
    { 0x011e87,  22, 0x002b55,  59,    -1862 }, /* VERR_SSM_LIVE_GURU_MEDITATION */
    { 0x015898,  18, 0x009b71,  35,    -1861 }, /* VERR_SSM_LIVE_POWERED_OFF */
    { 0x019fd2,  12, 0x0186fe,  15,    -1860 }, /* VERR_SSM_ALREADY_CANCELLED */
    { 0x01448c,  20, 0x0106ee,  24,    -1859 }, /* VERR_SSM_NO_PENDING_OPERATION */
    { 0x01a910,  11, 0x019a2a,  13,    -1858 }, /* VERR_SSM_CANCELLED */
    { 0x014af3,  19, 0x002b1a,  59,    -1857 }, /* VERR_SSM_LOW_ON_DISK_SPACE */
    { 0x0199cf,  13, 0x0025f1,  61,    -1856 }, /* VERR_SSM_STATE_GREW_TOO_BIG */
    { 0x01b0db,  10, 0x002c06,  59,    -1855 }, /* VERR_SSM_TOO_MANY_PASSES */
    { 0x014019,  20, 0x01743a,  16,    -1853 }, /* VERR_SSM_VOTE_FOR_GIVING_UP */
    { 0x01733a,  16, 0x00247e,  62,    -1850 }, /* VERR_SSM_GCPTR_OVERFLOW */
    { 0x016a38,  17, 0x0020d3,  63,    -1849 }, /* VERR_SSM_GCPHYS_OVERFLOW */
    { 0x01bbd5,   7, 0x00a78c,  34,    -1848 }, /* VERR_SSM_UNEXPECTED_DATA */
    { 0x01662b,  17, 0x0131e9,  21,    -1847 }, /* VERR_SSM_STRUCTURE_MAGIC */
    { 0x014ebc,  19, 0x002190,  63,    -1846 }, /* VERR_SSM_IDE_ASYNC_TIMEOUT */
    { 0x01614f,  18, 0x008384,  39,    -1845 }, /* VERR_SSM_VIRTUAL_CLOCK_HZ */
    { 0x018122,  15, 0x00672e,  44,    -1844 }, /* VERR_SSM_LOAD_CONFIG_MISMATCH */
    { 0x019e0a,  12, 0x007a11,  41,    -1843 }, /* VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH */
    { 0x0191f2,  14, 0x001a01,  67,    -1842 }, /* VERR_SSM_LOAD_CPUID_MISMATCH */
    { 0x00f874,  26, 0x00f49b,  26,    -1841 }, /* VERR_SSM_DATA_UNIT_FORMAT_CHANGED */
    { 0x018bfc,  14, 0x018104,  15,    -1840 }, /* VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION */
    { 0x017639,  16, 0x00d9ee,  28,    -1833 }, /* VERR_SSM_LOADED_TOO_LITTLE */
    { 0x01c07d,   4, 0x00d9ee,  28,    -1832 }, /* VERR_SSM_INVALID_STATE */
    { 0x01880c,  14, 0x00266b,  61,    -1831 }, /* VERR_SSM_LOADED_TOO_MUCH */
    { 0x01a19a,  12, 0x003779,  55,    -1830 }, /* VERR_SSM_NO_LOAD_EXEC */
    { 0x019600,  13, 0x0126b1,  22,    -1827 }, /* VERR_SSM_INTEGRITY_DIR_MAGIC */
    { 0x019600,   7, 0x013099,  21,    -1826 }, /* VERR_SSM_INTEGRITY_DIR */
    { 0x016c9c,  17, 0x00fb22,  25,    -1825 }, /* VERR_SSM_INTEGRITY_DECOMPRESSION */
    { 0x01711a,  16, 0x00b664,  32,    -1824 }, /* VERR_SSM_INTEGRITY_REC_TERM_CRC */
    { 0x01711a,  12, 0x00c676,  30,    -1823 }, /* VERR_SSM_INTEGRITY_REC_TERM */
    { 0x01aa39,  11, 0x014ef5,  19,    -1822 }, /* VERR_SSM_INTEGRITY_REC_HDR */
    { 0x01b1c0,  10, 0x0156fa,  18,    -1821 }, /* VERR_SSM_INTEGRITY_FOOTER */
    { 0x01af73,  10, 0x00da42,  28,    -1820 }, /* VERR_SSM_INTEGRITY_VBOX_VERSION */
    { 0x01a687,  11, 0x00a4c2,  34,    -1819 }, /* VERR_SSM_INTEGRITY_UNIT_NOT_FOUND */
    { 0x019262,  14, 0x00db22,  28,    -1818 }, /* VERR_SSM_INTEGRITY_UNIT_MAGIC */
    { 0x019262,   8, 0x016bbf,  17,    -1817 }, /* VERR_SSM_INTEGRITY_UNIT */
    { 0x01b0bd,  10, 0x014880,  19,    -1816 }, /* VERR_SSM_INTEGRITY_HEADER */
    { 0x019086,  14, 0x00b784,  32,    -1815 }, /* VERR_SMM_INTEGRITY_MACHINE */
    { 0x01bbe3,   7, 0x00f503,  26,    -1814 }, /* VERR_SSM_INTEGRITY_CRC */
    { 0x01bfd9,   5, 0x0091b9,  37,    -1813 }, /* VERR_SSM_INTEGRITY_SIZE */
    { 0x01bff7,   5, 0x019ab9,  13,    -1812 }, /* VERR_SSM_INTEGRITY_VERSION */
    { 0x01b22e,   9, 0x00dc8e,  28,    -1811 }, /* VERR_SSM_INTEGRITY_MAGIC */
    { 0x016c9c,   3, 0x00eb95,  27,    -1810 }, /* VERR_SSM_INTEGRITY */
    { 0x0194bb,  13, 0x00ccd9,  29,    -1802 }, /* VERR_SSM_UNIT_NOT_OWNER */
    { 0x01b53c,   9, 0x01727a,  16,    -1801 }, /* VERR_SSM_UNIT_NOT_FOUND */
    { 0x0193b8,  13, 0x017f51,  15,    -1800 }, /* VERR_SSM_UNIT_EXISTS */
    { 0x014a94,  19, 0x01af91,  10,    -1771 }, /* VERR_CPUM_UNSUPPORTED_ID_REG_VALUE */
    { 0x016065,  18, 0x0163fa,  17,    -1770 }, /* VERR_CPUM_UNSUPPORTED_ID_REGISTER */
    { 0x01098e,  24, 0x0042c5,  52,    -1768 }, /* VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO */
    { 0x013be1,  20, 0x001c92,  65,    -1767 }, /* VERR_CPUM_INVALID_HWVIRT_CONFIG */
    { 0x01a834,  11, 0x011d50,  23,    -1765 }, /* VERR_CPUM_INVALID_XCR0 */
    { 0x0172aa,  16, 0x011d39,  23,    -1764 }, /* VERR_CPUM_INVALID_XSAVE_HDR */
    { 0x01227b,  22, 0x0092bc,  37,    -1763 }, /* VERR_CPUM_INVALID_XSAVE_COMP_MASK */
    { 0x00a704,  34, 0x001536,  69,    -1762 }, /* VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK */
    { 0x01551e,  19, 0x01b3b9,   9,    -1761 }, /* VERR_CPUM_INVALID_CONFIG_VALUE */
    { 0x018302,  15, 0x01583e,  18,    -1760 }, /* VERR_TOO_MANY_CPUID_LEAVES */
    { 0x00ff9f,  25, 0x00e6bb,  27,    -1757 }, /* VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET */
    { 0x017cdc,  15, 0x00d161,  29,    -1756 }, /* VERR_CPUM_DB_CPU_NOT_FOUND */
    { 0x01b6f4,   8, 0x01a6ea,  11,    -1755 }, /* VERR_CPUM_IPE_2 */
    { 0x01b6fc,   8, 0x01a7bb,  11,    -1754 }, /* VERR_CPUM_IPE_1 */
    { 0x0111fe,  23, 0x008f44,  37,    -1753 }, /* VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES */
    { 0x011f21,  22, 0x000f07,  74,    -1752 }, /* VERR_CPUM_HIDDEN_CS_LOAD_ERROR */
    { 0x0103b9,  25, 0x00afe4,  32,    -1751 }, /* VERR_CPUM_INCOMPATIBLE_CONFIG */
    { 0x0175b9,  16, 0x008772,  38,    -1750 }, /* VERR_CPUM_RAISE_GP_0 */
    { 0x017dea,  15, 0x00690b,  43,    -1702 }, /* VERR_MM_BAD_TRAP_TYPE_IPE */
    { 0x019fa2,  12, 0x010766,  24,    -1701 }, /* VERR_MM_HYPER_NO_MEMORY */
    { 0x01723a,  16, 0x001f16,  64,    -1700 }, /* VERR_MM_RAM_CONFLICT */
    { 0x018f1a,  14, 0x0179d9,  16,    -1692 }, /* VERR_PGM_TOO_MANY_ROM_RANGES */
    { 0x0131bf,  21, 0x0093bc,  36,    -1691 }, /* VERR_PGM_PHYS_RAM_LOOKUP_IPE */
    { 0x0189a2,  14, 0x01747a,  16,    -1690 }, /* VERR_PGM_TOO_MANY_RAM_RANGES */
    { 0x018032,  15, 0x005712,  47,    -1689 }, /* VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE */
    { 0x017e71,  15, 0x003bbb,  54,    -1688 }, /* VERR_PGM_PAE_PDPE_RSVD */
    { 0x01928c,  14, 0x0136ff,  21,    -1687 }, /* VERR_PGM_SHW_NONE_IPE */
    { 0x01b1d4,  10, 0x01b86c,   8,    -1686 }, /* VERR_PGM_MODE_IPE */
    { 0x0185c3,  15, 0x004361,  52,    -1685 }, /* VERR_PGM_PHYS_MMIO_EX_IPE */
    { 0x0136c0,  21, 0x003f14,  53,    -1684 }, /* VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE */
    { 0x017579,  16, 0x015ac5,  18,    -1683 }, /* VERR_PGM_TOO_MANY_MMIO2_RANGES */
    { 0x0108b6,  24, 0x009125,  37,    -1682 }, /* VERR_PGM_PCI_PASSTHRU_MISCONFIG */
    { 0x0159db,  18, 0x008dad,  37,    -1681 }, /* VERR_PGM_PHYS_NULL_PAGE_PARAM */
    { 0x018785,  15, 0x01129f,  23,    -1680 }, /* VERR_PGM_PHYS_PAGE_GET_IPE */
    { 0x01122c,  23, 0x00faa5,  25,    -1679 }, /* VERR_PGM_WRITE_MONITOR_ENGAGED */
    { 0x01af19,  10, 0x01a062,  12,    -1678 }, /* VERR_PGM_POOL_IPE */
    { 0x010f2e,  24, 0x0075e7,  41,    -1677 }, /* VERR_PGM_POOL_MAXED_OUT_ALREADY */
    { 0x019c32,  13, 0x011fa5,  22,    -1676 }, /* VERR_PGM_MAPPING_IPE */
    { 0x018a58,  14, 0x00c36a,  30,    -1675 }, /* VERR_PGM_POOL_TOO_MANY_LOOPS */
    { 0x018b38,  14, 0x00c856,  30,    -1674 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_4 */
    { 0x018b0e,  14, 0x00c45a,  30,    -1673 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_3 */
    { 0x018b1c,  14, 0x00c478,  30,    -1672 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_2 */
    { 0x018b2a,  14, 0x00c7a2,  30,    -1671 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_1 */
    { 0x016292,  18, 0x00e175,  27,    -1670 }, /* VERR_PGM_PHYS_HANDLER_IPE */
    { 0x01a0ce,  12, 0x00a748,  34,    -1669 }, /* VERR_PGM_INVALID_PDPE_ADDR */
    { 0x01a8b8,  11, 0x009dc4,  35,    -1668 }, /* VERR_PGM_INVALID_CR3_ADDR */
    { 0x017fc9,  15, 0x0023c4,  62,    -1667 }, /* VERR_PGM_NOT_USED_IN_MODE */
    { 0x019453,  13, 0x0131fe,  21,    -1666 }, /* VERR_PGM_POOL_GET_PAGE_FAILED */
    { 0x01914a,  14, 0x01975f,  13,    -1665 }, /* VERR_PGM_PML4_MAPPING */
    { 0x019efa,  12, 0x00f5ec,  26,    -1664 }, /* VERR_PGM_HANDY_PAGE_IPE */
    { 0x01a302,  12, 0x010fee,  24,    -1663 }, /* VERR_PGM_DYNMAP_IPE */
    { 0x0193ab,  13, 0x0187d0,  15,    -1662 }, /* VERR_PGM_SAVED_REC_TYPE */
    { 0x016460,  17, 0x00a6c0,  34,    -1661 }, /* VERR_PGM_SAVED_ROM_PAGE_PROT */
    { 0x01837a,  15, 0x009500,  36,    -1660 }, /* VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND */
    { 0x0142fc,  20, 0x0073d2,  41,    -1659 }, /* VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND */
    { 0x016c47,  17, 0x008726,  38,    -1658 }, /* VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND */
    { 0x012761,  22, 0x006b65,  43,    -1657 }, /* VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND */
    { 0x01bfb1,   5, 0x00d453,  29,    -1656 }, /* VERR_PGM_UNEXPECTED_PAGE_STATE */
    { 0x01ae83,  10, 0x00cf00,  29,    -1655 }, /* VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE */
    { 0x01a72c,  11, 0x018e9c,  14,    -1654 }, /* VERR_PGM_INVALID_SAVED_PAGE_STATE */
    { 0x018932,  14, 0x00cf3a,  29,    -1653 }, /* VERR_PGM_MAPPINGS_SMP */
    { 0x015285,  19, 0x00dd52,  28,    -1652 }, /* VERR_PGM_MAPPINGS_DISABLED */
    { 0x0153a2,  19, 0x0047fe,  51,    -1651 }, /* VERR_PGM_MAP_MMIO2_ALIAS_MMIO */
    { 0x01a032,  12, 0x010b3e,  24,    -1647 }, /* VERR_PGM_HANDLER_IPE_1 */
    { 0x016a8d,  17, 0x009e0a,  35,    -1646 }, /* VERR_PGM_PHYS_PAGE_BALLOONED */
    { 0x017e26,  15, 0x00ea87,  27,    -1645 }, /* VERR_PGM_INVALID_LARGE_PAGE_RANGE */
    { 0x015a11,  18, 0x00a280,  34,    -1643 }, /* VERR_PGM_HANDLER_ALREADY_ALIASED */
    { 0x0195b2,  13, 0x01853c,  15,    -1642 }, /* VERR_PGM_PHYS_NOT_MMIO2 */
    { 0x01b2b4,   9, 0x01aa4f,  11,    -1641 }, /* VERR_PGM_PHYS_NOT_MMIO */
    { 0x01a83f,  11, 0x0195f3,  13,    -1640 }, /* VERR_PGM_PHYS_NOT_ROM */
    { 0x01a650,  11, 0x00ea1b,  27,    -1639 }, /* VERR_PGM_PHYS_NOT_RAM */
    { 0x013570,  21, 0x002feb,  58,    -1638 }, /* VERR_PGM_PHYS_WR_HIT_HANDLER */
    { 0x01aa02,  11, 0x00ec52,  27,    -1637 }, /* VERR_PGM_PHYS_INVALID_PAGE_ID */
    { 0x01624b,  18, 0x010c16,  24,    -1636 }, /* VERR_PGM_NO_CR3_SHADOW_ROOT */
    { 0x0123f1,  22, 0x008be6,  38,    -1635 }, /* VERR_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x014693,  20, 0x009668,  36,    -1634 }, /* VERR_PGM_PHYS_TLB_CATCH_ALL */
    { 0x012c94,  21, 0x006040,  45,    -1633 }, /* VERR_PGM_PHYS_TLB_UNASSIGNED */
    { 0x016d35,  17, 0x0096d4,  36,    -1632 }, /* VERR_PGM_DYNMAP_EXPAND_ERROR */
    { 0x017599,  16, 0x007476,  41,    -1631 }, /* VERR_PGM_DYNMAP_SETUP_ERROR */
    { 0x016a16,  17, 0x005abc,  46,    -1630 }, /* VERR_PGM_DYNMAP_FULL_SET */
    { 0x01afd7,  10, 0x009d15,  35,    -1629 }, /* VERR_PGM_DYNMAP_FAILED */
    { 0x012c01,  21, 0x009740,  36,    -1628 }, /* VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE */
    { 0x00c9be,  30, 0x001b4d,  65,    -1627 }, /* VERR_PGM_INTERMEDIATE_PAGING_CONFLICT */
    { 0x00c25a,  31, 0x000d8d,  77,    -1626 }, /* VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY */
    { 0x013642,  21, 0x00f8f6,  26,    -1619 }, /* VERR_PGM_NO_HYPERVISOR_ADDRESS */
    { 0x017739,  16, 0x0048c8,  50,    -1618 }, /* VERR_PGM_PHYS_PAGE_RESERVED */
    { 0x014977,  19, 0x009398,  36,    -1617 }, /* VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE */
    { 0x01359a,  21, 0x007e72,  40,    -1612 }, /* VERR_PGM_MAPPINGS_FIX_TOO_SMALL */
    { 0x011693,  23, 0x006626,  44,    -1611 }, /* VERR_PGM_MAPPINGS_FIX_REJECTED */
    { 0x011215,  23, 0x0067b2,  44,    -1610 }, /* VERR_PGM_MAPPINGS_FIX_CONFLICT */
    { 0x017719,  16, 0x00293f,  60,    -1609 }, /* VERR_PGM_MAPPINGS_FIXED */
    { 0x019270,  14, 0x001f16,  64,    -1608 }, /* VERR_PGM_RAM_CONFLICT */
    { 0x01a3aa,  12, 0x00de4e,  28,    -1607 }, /* VERR_PGM_HANDLER_NOT_FOUND */
    { 0x0141e5,  20, 0x015200,  19,    -1606 }, /* VERR_PGM_INVALID_GC_PHYSICAL_RANGE */
    { 0x006055,  22, 0x012ff1,  21,    -1605 }, /* VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS */
    { 0x019446,  13, 0x01b557,   9,    -1604 }, /* VERR_PGM_INVALID_PAGE_DIRECTORY */
    { 0x00e793,  27, 0x00228c,  63,    -1603 }, /* VERR_PGM_HANDLER_PHYSICAL_CONFLICT */
    { 0x00efef,  26, 0x002348,  62,    -1602 }, /* VERR_PGM_HANDLER_VIRTUAL_CONFLICT */
    { 0x00d34e,  29, 0x004229,  52,    -1601 }, /* VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE */
    { 0x015c87,  18, 0x002cf2,  59,    -1600 }, /* VERR_PGM_MAPPING_CONFLICT */
    { 0x019ca2,  12, 0x0073fb,  41,    -1504 }, /* VERR_CSAM_HM_IPE */
    { 0x0105df,  25, 0x0188fa,  14,    -1432 }, /* VERR_PATM_IPE_TRAP_IN_PATCH_CODE */
    { 0x01a4be,  12, 0x004bb6,  50,    -1431 }, /* VERR_PATM_HM_IPE */
    { 0x0192e0,  14, 0x0170ea,  16,    -1428 }, /* VERR_PATM_ALREADY_PATCHED */
    { 0x0167d4,  17, 0x00c23b,  31,    -1426 }, /* VERR_PATM_UNSAFE_CODE */
    { 0x017779,  16, 0x0147ab,  20,    -1425 }, /* VERR_PATCH_NO_CONFLICT */
    { 0x01851e,  15, 0x01726a,  16,    -1406 }, /* VERR_PATCH_ALREADY_ENABLED */
    { 0x01738a,  16, 0x016790,  17,    -1405 }, /* VERR_PATCH_ALREADY_DISABLED */
    { 0x018578,  15, 0x01850f,  15,    -1403 }, /* VERR_PATCH_DISABLED */
    { 0x01b54e,   9, 0x019b3b,  13,    -1402 }, /* VERR_PATCH_NOT_FOUND */
    { 0x0165a3,  17, 0x001301,  71,    -1401 }, /* VERR_PATCHING_REFUSED */
    { 0x019df2,  12, 0x019a2a,  13,    -1241 }, /* VERR_DBGF_CANCELLED */
    { 0x00ab91,  33, 0x0095d8,  36,    -1240 }, /* VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS */
    { 0x00fa41,  25, 0x00b144,  32,    -1238 }, /* VERR_DBGF_BP_OWNER_NO_MORE_HANDLES */
    { 0x016cad,  17, 0x007e4a,  40,    -1237 }, /* VERR_DBGF_BP_L2_LOOKUP_FAILED */
    { 0x0164f9,  17, 0x007ba2,  40,    -1236 }, /* VERR_DBGF_BP_L1_LOOKUP_FAILED */
    { 0x01b67d,   8, 0x014298,  20,    -1235 }, /* VERR_DBGF_BP_IPE_9 */
    { 0x01b685,   8, 0x0143ec,  20,    -1234 }, /* VERR_DBGF_BP_IPE_8 */
    { 0x01b68d,   8, 0x01407d,  20,    -1233 }, /* VERR_DBGF_BP_IPE_7 */
    { 0x01b824,   8, 0x0140cd,  20,    -1232 }, /* VERR_DBGF_BP_IPE_6 */
    { 0x01b7a4,   8, 0x013ce5,  20,    -1231 }, /* VERR_DBGF_BP_IPE_5 */
    { 0x01b7d4,   8, 0x013c31,  20,    -1230 }, /* VERR_DBGF_BP_IPE_4 */
    { 0x01b7e4,   8, 0x014518,  20,    -1229 }, /* VERR_DBGF_BP_IPE_3 */
    { 0x01b7fc,   8, 0x014109,  20,    -1228 }, /* VERR_DBGF_BP_IPE_2 */
    { 0x01b814,   8, 0x013eed,  20,    -1227 }, /* VERR_DBGF_BP_IPE_1 */
    { 0x00dbe6,  28, 0x004798,  51,    -1226 }, /* VERR_DBGF_BP_INT3_ADD_TRIES_REACHED */
    { 0x019571,  13, 0x00492c,  50,    -1225 }, /* VERR_DBGF_OWNER_BUSY */
    { 0x01bf4d,   5, 0x0178d9,  16,    -1223 }, /* VERR_DBGF_IPE_1 */
    { 0x01a763,  11, 0x007dfa,  40,    -1222 }, /* VWRN_DBGF_ALREADY_RUNNING */
    { 0x01a146,  12, 0x00fe8c,  25,    -1221 }, /* VERR_DBGF_TRACER_IPE_1 */
    { 0x01730a,  16, 0x004f64,  49,    -1220 }, /* VERR_DBGF_NO_TRACE_BUFFER */
    { 0x01a7f2,  11, 0x0165d6,  17,    -1219 }, /* VERR_DBGF_STACK_IPE_2 */
    { 0x01ab83,  11, 0x016b59,  17,    -1218 }, /* VERR_DBGF_STACK_IPE_1 */
    { 0x017ac9,  16, 0x00ede7,  27,    -1217 }, /* VERR_DBGF_HYPER_DB_XCPT */
    { 0x01b440,   9, 0x01a446,  12,    -1216 }, /* VERR_DBGF_REG_IPE_2 */
    { 0x01b449,   9, 0x01a03e,  12,    -1215 }, /* VERR_DBGF_REG_IPE_1 */
    { 0x012f0a,  21, 0x00fb3b,  25,    -1214 }, /* VERR_DBGF_READ_ONLY_REGISTER */
    { 0x01ba2c,   8, 0x016b26,  17,    -1213 }, /* VERR_DBGF_UNSUPPORTED_CAST */
    { 0x018c6c,  14, 0x01bd57,   6,    -1210 }, /* VERR_DBGF_REGISTER_NOT_FOUND */
    { 0x018d68,  14, 0x0185ff,  15,    -1209 }, /* VERR_DBGF_OS_NOT_DETCTED */
    { 0x01b4b5,   9, 0x01ad7f,  10,    -1208 }, /* VERR_DBGF_MEM_NOT_FOUND */
    { 0x01ba24,   8, 0x00c784,  30,    -1204 }, /* VERR_DBGF_BP_NOT_FOUND */
    { 0x016a05,  17, 0x010e26,  24,    -1203 }, /* VERR_DBGF_NO_MORE_BP_SLOTS */
    { 0x01a092,  12, 0x0035f1,  56,    -1201 }, /* VERR_DBGF_ALREADY_ATTACHED */
    { 0x01a06e,  12, 0x001f96,  64,    -1200 }, /* VERR_DBGF_NOT_ATTACHED */
    { 0x015f9f,  18, 0x00b064,  32,    -1158 }, /* VERR_EM_GUEST_CPU_HANG */
    { 0x0137d1,  21, 0x0049c2,  50,    -1156 }, /* VERR_EM_CANNOT_EXEC_GUEST */
    { 0x013324,  21, 0x00d5e2,  28,    -1154 }, /* VERR_EM_UNEXPECTED_MAPPING_CONFLICT */
    { 0x01be59,   6, 0x003e75,  53,    -1149 }, /* VERR_EM_INTERNAL_ERROR */
    { 0x017d90,  15, 0x008d3c,  38,    -1148 }, /* VERR_EM_INTERPRETER */
    { 0x012081,  22, 0x007fb2,  40,    -1133 }, /* VERR_EM_RAW_PATCH_CONFLICT */
    { 0x01bebf,   6, 0x00d812,  28,    -1114 }, /* VERR_EM_NO_MEMORY */
    { 0x013213,  21, 0x005946,  47,    -1028 }, /* VERR_DRIVER_REBOOT_NEEDED */
    { 0x0130d8,  21, 0x013bf5,  20,    -1027 }, /* VERR_RESERVED_PAGE_TABLE_BITS */
    { 0x01bcb5,   7, 0x00e75d,  27,    -1026 }, /* VERR_NOT_SUP_BY_NEM */
    { 0x01ab8e,  11, 0x018bc4,  14,    -1025 }, /* VERR_VM_RESTORED */
    { 0x011e19,  22, 0x00520f,  48,    -1024 }, /* VERR_INCONSISTENT_VM_HANDLE */
    { 0x01a04a,  12, 0x00a616,  34,    -1023 }, /* VERR_RAW_MODE_NOT_SUPPORTED */
    { 0x01aa70,  11, 0x01a860,  11,    -1022 }, /* VERR_INVALID_CPU_INDEX */
    { 0x0189da,  14, 0x00b844,  32,    -1021 }, /* VERR_NOT_SUP_IN_RAW_MODE */
    { 0x01675d,  17, 0x00de16,  28,    -1020 }, /* VERR_SERVICE_DISABLED */
    { 0x01bba4,   7, 0x01aba4,  11,    -1019 }, /* VERR_TOO_MANY_CPUS */
    { 0x01b984,   8, 0x017829,  16,    -1018 }, /* VERR_INVALID_CPU_ID */
    { 0x019190,  14, 0x01ad11,  10,    -1017 }, /* VERR_INVALID_VMCPU_HANDLE */
    { 0x01aca3,  10, 0x01ad11,  10,    -1016 }, /* VERR_INVALID_VM_HANDLE */
    { 0x018940,  14, 0x0184c4,  15,    -1015 }, /* VERR_RAW_MODE_INVALID_SMP */
    { 0x011096,  24, 0x0116c1,  23,    -1014 }, /* VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT */
    { 0x013531,  21, 0x0185b4,  15,    -1013 }, /* VERR_PAGE_MAP_LEVEL4_NOT_PRESENT */
    { 0x01c015,   5, 0x0159c9,  18,    -1012 }, /* VERR_INVALID_RPL */
    { 0x01b09f,  10, 0x01af7d,  10,    -1011 }, /* VERR_INVALID_SELECTOR */
    { 0x011b11,  23, 0x012dba,  21,    -1010 }, /* VERR_OUT_OF_SELECTOR_BOUNDS */
    { 0x0186ef,  15, 0x018f60,  14,    -1009 }, /* VERR_NOT_DATA_SELECTOR */
    { 0x017cbe,  15, 0x01582c,  18,    -1008 }, /* VERR_NOT_CODE_SELECTOR */
    { 0x015c2d,  18, 0x015a35,  18,    -1007 }, /* VERR_SELECTOR_NOT_PRESENT */
    { 0x01a5b6,  11, 0x011568,  23,    -1006 }, /* VERR_CFG_NO_VALUE */
    { 0x019d56,  12, 0x009194,  37,    -1005 }, /* VERR_CFG_INVALID_FORMAT */
    { 0x01b1fc,  10, 0x018b70,  14,    -1004 }, /* VERR_PAGE_NOT_PRESENT */
    { 0x01ad9d,  10, 0x01ae29,  10,    -1003 }, /* VERR_UNSUPPORTED_CPU_MODE */
    { 0x01ad9d,   5, 0x01bf25,   5,    -1002 }, /* VERR_UNSUPPORTED_CPU */
    { 0x01a855,  11, 0x000ca4,  78,    -1001 }, /* VERR_DONT_PANIC */
    { 0x01bfe3,   5, 0x013ec5,  20,    -1000 }, /* VERR_NO_VM_MEMORY */
    { 0x0112b6,  23, 0x004431,  52,     -965 }, /* VERR_PKZIP_ZIP64EX_IN_ZIP32 */
    { 0x018d76,  14, 0x017909,  16,     -964 }, /* VERR_PKZIP_UNKNOWN_TYPE_FLAG */
    { 0x0161f1,  18, 0x015499,  19,     -963 }, /* VERR_PKZIP_BAD_CDF_HEADER */
    { 0x01644f,  17, 0x017959,  16,     -962 }, /* VERR_PKZIP_BAD_LF_HEADER */
    { 0x0162c8,  17, 0x012ef5,  21,     -961 }, /* VERR_PKZIP_NAME_TOO_LONG */
    { 0x01a57e,  12, 0x011c0e,  23,     -960 }, /* VERR_PKZIP_NO_EOCB */
    { 0x016372,  17, 0x017769,  16,     -953 }, /* VERR_POLL_SET_IS_FULL */
    { 0x0159ed,  18, 0x00fccb,  25,     -952 }, /* VERR_POLL_HANDLE_ID_NOT_FOUND */
    { 0x012383,  22, 0x00aec4,  32,     -951 }, /* VERR_POLL_HANDLE_ID_EXISTS */
    { 0x012105,  22, 0x014ca8,  19,     -950 }, /* VERR_POLL_HANDLE_NOT_POLLABLE */
    { 0x018140,  15, 0x00e29e,  27,     -947 }, /* VERR_TAR_NAME_TOO_LONG */
    { 0x00ec88,  27, 0x008960,  38,     -946 }, /* VERR_TAR_MALFORMED_GNU_LONGXXXX */
    { 0x015981,  18, 0x008960,  38,     -945 }, /* VERR_TAR_BAD_CHKSUM_FIELD */
    { 0x017cfa,  15, 0x00b544,  32,     -944 }, /* VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE */
    { 0x014ecf,  19, 0x0099c8,  36,     -943 }, /* VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE */
    { 0x01a65b,  11, 0x003edf,  53,     -942 }, /* VERR_TAR_UNSUPPORTED_PAX_TYPE */
    { 0x00dd36,  28, 0x00b5e4,  32,     -941 }, /* VERR_TAR_NON_DIR_ENDS_WITH_SLASH */
    { 0x018014,  15, 0x0199b5,  13,     -940 }, /* VERR_TAR_EMPTY_NAME */
    { 0x01845b,  15, 0x00c1bf,  31,     -939 }, /* VERR_TAR_NOT_USTAR_V00 */
    { 0x017b19,  16, 0x016e23,  17,     -938 }, /* VERR_TAR_ZERO_HEADER */
    { 0x01a31a,  12, 0x017909,  16,     -937 }, /* VERR_TAR_UNKNOWN_TYPE_FLAG */
    { 0x019cea,  12, 0x0087e4,  38,     -936 }, /* VERR_TAR_SIZE_NOT_ZERO */
    { 0x0177b9,  16, 0x00a58e,  34,     -935 }, /* VERR_TAR_MODE_WITH_TYPE */
    { 0x017ae9,  16, 0x00ffd1,  25,     -934 }, /* VERR_TAR_BAD_MODE_FIELD */
    { 0x01377d,  21, 0x0024fa,  62,     -933 }, /* VERR_TAR_DEV_VALUE_TOO_LARGE */
    { 0x01334e,  21, 0x00230a,  62,     -932 }, /* VERR_TAR_NUM_VALUE_TOO_LARGE */
    { 0x017b88,  16, 0x000abf,  83,     -931 }, /* VERR_TAR_BASE_256_NOT_SUPPORTED */
    { 0x013cd1,  20, 0x0062e2,  44,     -930 }, /* VERR_TAR_BAD_NUM_FIELD_TERM */
    { 0x013cd1,  15, 0x00fb54,  25,     -929 }, /* VERR_TAR_BAD_NUM_FIELD */
    { 0x015239,  19, 0x001e56,  64,     -928 }, /* VERR_TAR_EOS_MORE_INPUT */
    { 0x01b34d,   9, 0x010161,  25,     -927 }, /* VERR_TAR_UNEXPECTED_EOS */
    { 0x016efb,  16, 0x010886,  24,     -926 }, /* VERR_TAR_END_OF_FILE */
    { 0x019523,  13, 0x00ae04,  32,     -925 }, /* VERR_TAR_CHKSUM_MISMATCH */
    { 0x014951,  19, 0x01292f,  22,     -906 }, /* VERR_MANIFEST_ATTR_TYPE_NOT_FOUND */
    { 0x015646,  18, 0x01181a,  23,     -905 }, /* VERR_MANIFEST_ATTR_TYPE_MISMATCH */
    { 0x01633f,  17, 0x00887c,  38,     -904 }, /* VERR_MANIFEST_ATTR_NOT_FOUND */
    { 0x019d4a,  12, 0x00aa26,  33,     -903 }, /* VERR_MANIFEST_FILE_MISMATCH */
    { 0x019d9e,  12, 0x00c4f0,  30,     -902 }, /* VERR_MANIFEST_DIGEST_MISMATCH */
    { 0x011a87,  23, 0x00544f,  48,     -901 }, /* VERR_MANIFEST_WRONG_FILE_FORMAT */
    { 0x0195cc,  13, 0x00dbca,  28,     -900 }, /* VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE */
    { 0x01a15e,  12, 0x01bc99,   7,     -899 }, /* VERR_HTTP_CURL_ERROR */
    { 0x01b85c,   8, 0x01236d,  22,     -898 }, /* VERR_HTTP_NOT_SUPPORTED */
    { 0x01167c,  23, 0x010e6e,  24,     -897 }, /* VERR_HTTP_CURL_PROXY_CONFIG */
    { 0x019aed,  13, 0x00b224,  32,     -896 }, /* VERR_HTTP_HOST_NOT_FOUND */
    { 0x018c18,  14, 0x00fa8c,  25,     -895 }, /* VERR_HTTP_PROXY_NOT_FOUND */
    { 0x01735a,  16, 0x013ac9,  20,     -894 }, /* VERR_HTTP_REDIRECTED */
    { 0x019856,  13, 0x009bfd,  35,     -893 }, /* VERR_HTTP_ABORTED */
    { 0x00b1a4,  32, 0x00796d,  41,     -892 }, /* VERR_HTTP_CACERT_CANNOT_AUTHENTICATE */
    { 0x00fb86,  25, 0x00b644,  32,     -891 }, /* VERR_HTTP_CACERT_WRONG_FORMAT */
    { 0x014f8d,  19, 0x016ebb,  16,     -890 }, /* VERR_HTTP_SSL_CONNECT_ERROR */
    { 0x013753,  21, 0x00a858,  33,     -889 }, /* VERR_HTTP_COULDNT_CONNECT */
    { 0x019334,  14, 0x00700d,  42,     -888 }, /* VERR_HTTP_BAD_REQUEST */
    { 0x014fb3,  19, 0x011066,  24,     -887 }, /* VERR_HTTP_ACCESS_DENIED */
    { 0x01b615,   8, 0x005e24,  45,     -886 }, /* VERR_HTTP_NOT_FOUND */
    { 0x019d26,  12, 0x013006,  21,     -885 }, /* VERR_HTTP_INIT_FAILED */
    { 0x013960,  21, 0x01530a,  19,     -884 }, /* VERR_HTTP_STATUS_SERVER_ERROR */
    { 0x01a506,  12, 0x013e39,  20,     -879 }, /* VERR_S3_CANCELED */
    { 0x016e9a,  17, 0x00f61f,  26,     -878 }, /* VERR_S3_BUCKET_NOT_EMPTY */
    { 0x0158bb,  18, 0x0181a9,  15,     -877 }, /* VERR_S3_BUCKET_ALREADY_EXISTS */
    { 0x01bdc9,   6, 0x0143c4,  20,     -876 }, /* VERR_S3_NOT_FOUND */
    { 0x0165f8,  17, 0x0182b7,  15,     -875 }, /* VERR_S3_ACCESS_DENIED */
    { 0x0174f9,  16, 0x010f76,  24,     -855 }, /* VERR_MEM_CACHE_MAX_SIZE */
    { 0x019cd2,  12, 0x012013,  22,     -851 }, /* VERR_CACHE_EMPTY */
    { 0x01a5ab,  11, 0x0138b8,  21,     -850 }, /* VERR_CACHE_FULL */
    { 0x0186e0,  15, 0x006bbb,  43,     -829 }, /* VERR_GETOPT_INDEX_MISSING */
    { 0x010916,  24, 0x004125,  52,     -827 }, /* VERR_GETOPT_INVALID_ARGUMENT_FORMAT */
    { 0x00e49f,  27, 0x005df7,  45,     -826 }, /* VERR_GETOPT_REQUIRED_ARGUMENT_MISSING */
    { 0x01842e,  15, 0x006f11,  42,     -825 }, /* VERR_GETOPT_UNKNOWN_OPTION */
    { 0x01bc45,   7, 0x01a813,  11,     -803 }, /* VERR_CPU_IPE_1 */
    { 0x016350,  17, 0x006e15,  42,     -802 }, /* VERR_NOT_ALL_CPUS_SHOWED */
    { 0x01bc30,   7, 0x01b5cc,   9,     -801 }, /* VERR_CPU_NOT_FOUND */
    { 0x019dc2,  12, 0x017f42,  15,     -800 }, /* VERR_CPU_OFFLINE */
    { 0x018f7c,  14, 0x0053ef,  48,     -753 }, /* VERR_ENV_VAR_UNSET */
    { 0x019238,  14, 0x00e2ef,  27,     -752 }, /* VERR_ENV_INVALID_VAR_NAME */
    { 0x01a8ef,  11, 0x00f18f,  26,     -750 }, /* VERR_ENV_VAR_NOT_FOUND */
    { 0x0110ae,  24, 0x00a67c,  34,     -704 }, /* VERR_RT_REQUEST_STATUS_FREED */
    { 0x00b5a4,  32, 0x00284f,  60,     -703 }, /* VERR_RT_REQUEST_STATUS_STILL_PENDING */
    { 0x0141bd,  20, 0x01a1fa,  12,     -702 }, /* VERR_RT_REQUEST_INVALID_PACKAGE */
    { 0x01999b,  13, 0x01a5c1,  11,     -701 }, /* VERR_RT_REQUEST_STATE */
    { 0x018ca4,  14, 0x01afff,  10,     -700 }, /* VERR_RT_REQUEST_INVALID_TYPE */
    { 0x00f3b1,  26, 0x00d1b8,  29,     -696 }, /* VERR_DBG_MALFORMED_UNWIND_INFO */
    { 0x014e83,  19, 0x00b7a4,  32,     -695 }, /* VERR_DBG_UNWIND_INFO_NOT_FOUND */
    { 0x0167a1,  17, 0x0123af,  22,     -694 }, /* VERR_DBG_NO_UNWIND_INFO */
    { 0x01bc5a,   7, 0x008986,  38,     -693 }, /* VERR_CV_IPE */
    { 0x01b6e4,   8, 0x005c2c,  46,     -692 }, /* VERR_CV_TODO */
    { 0x01a62f,  11, 0x009548,  36,     -691 }, /* VERR_CV_BAD_FORMAT */
    { 0x01a27e,  12, 0x00f0d9,  26,     -689 }, /* VERR_DBG_MOD_IPE */
    { 0x01bb12,   7, 0x004ea0,  49,     -688 }, /* VERR_DBG_FILE_MISMATCH */
    { 0x01b4f4,   9, 0x00c32f,  30,     -687 }, /* VERR_DBG_TODO */
    { 0x013f51,  20, 0x00beb8,  31,     -686 }, /* VERR_DBG_DEFERRED_LOAD_FAILED */
    { 0x014fff,  19, 0x0120d9,  22,     -685 }, /* VERR_DBG_CFG_NOT_UINT_PROP */
    { 0x0180d7,  15, 0x01004e,  25,     -684 }, /* VERR_DBG_CFG_INVALID_VALUE */
    { 0x01af41,  10, 0x019f7e,  12,     -683 }, /* VERR_DWARF_IPE */
    { 0x0127a3,  22, 0x00e577,  27,     -682 }, /* VERR_DWARF_STACK_UNDERFLOW */
    { 0x012fb2,  21, 0x00f708,  26,     -681 }, /* VERR_DWARF_STACK_OVERFLOW */
    { 0x015c09,  18, 0x016e78,  17,     -680 }, /* VERR_DWARF_UNKNOWN_LOC_OPCODE */
    { 0x01a7e7,  11, 0x019e8e,  12,     -679 }, /* VERR_DWARF_TODO */
    { 0x019e2e,  12, 0x00d99a,  28,     -678 }, /* VERR_DWARF_UNEXPECTED_FORM */
    { 0x01a45e,  12, 0x00fa5a,  25,     -677 }, /* VERR_DWARF_UNKNOWN_FORM */
    { 0x0175f9,  16, 0x01116e,  24,     -676 }, /* VERR_DWARF_ABBREV_NOT_FOUND */
    { 0x018aac,  14, 0x00fbea,  25,     -675 }, /* VERR_DWARF_BAD_ABBREV */
    { 0x019c8a,  12, 0x01a21e,  12,     -674 }, /* VERR_DWARF_BAD_INFO */
    { 0x01a952,  11, 0x0178c9,  16,     -673 }, /* VERR_DWARF_BAD_POS */
    { 0x01b5a8,   9, 0x018fc2,  14,     -672 }, /* VERR_DWARF_BAD_STRING */
    { 0x01abc5,  11, 0x00d22c,  29,     -671 }, /* VERR_DWARF_BAD_LNE */
    { 0x0154d2,  19, 0x009b08,  35,     -670 }, /* VERR_DWARF_LEB_OVERFLOW */
    { 0x01a603,  11, 0x0163a5,  17,     -669 }, /* VERR_DWARF_UNEXPECTED_END */
    { 0x00f32f,  26, 0x014414,  20,     -668 }, /* VERR_DWARF_BAD_LINE_NUMBER_HEADER */
    { 0x00ee84,  26, 0x005975,  47,     -667 }, /* VERR_DBG_NO_MATCHING_INTERPRETER */
    { 0x014464,  20, 0x00ae84,  32,     -666 }, /* VERR_DBG_NOT_LINUX_KALLSYMS */
    { 0x016394,  17, 0x010fa6,  24,     -665 }, /* VERR_DBG_NOT_NM_MAP_FILE */
    { 0x016d8a,  17, 0x00cd87,  29,     -664 }, /* VERR_DBG_ADDRESS_WRAP */
    { 0x00c9a0,  30, 0x009f45,  35,     -663 }, /* VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE */
    { 0x011b6d,  23, 0x00d946,  28,     -662 }, /* VERR_DBG_FILE_NAME_OUT_OF_RANGE */
    { 0x00ccf6,  29, 0x00a528,  34,     -661 }, /* VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE */
    { 0x019e22,  12, 0x007355,  42,     -660 }, /* VERR_DBG_LINE_NOT_FOUND */
    { 0x00e1c6,  27, 0x005059,  49,     -659 }, /* VERR_DBG_SEGMENT_INDEX_CONFLICT */
    { 0x013696,  21, 0x00b684,  32,     -658 }, /* VERR_DBG_DUPLICATE_SYMBOL */
    { 0x0134dd,  21, 0x0078c9,  41,     -657 }, /* VERR_DBG_ADDRESS_CONFLICT */
    { 0x013d85,  20, 0x00e835,  27,     -656 }, /* VERR_DBG_SPECIAL_SEGMENT */
    { 0x01b356,   9, 0x00e835,  27,     -655 }, /* VERR_DBG_INVALID_RVA */
    { 0x014145,  20, 0x017859,  16,     -654 }, /* VERR_DBG_INVALID_SEGMENT_OFFSET */
    { 0x014a35,  19, 0x0182f3,  15,     -653 }, /* VERR_DBG_INVALID_SEGMENT_INDEX */
    { 0x019870,  13, 0x00a76a,  34,     -652 }, /* VERR_DBG_INVALID_ADDRESS */
    { 0x019b48,  13, 0x00bbb2,  31,     -651 }, /* VERR_DBG_NO_SYMBOLS */
    { 0x015bf7,  18, 0x00c4d2,  30,     -650 }, /* VERR_DBG_NO_LINE_NUMBERS */
    { 0x01722a,  16, 0x010bfe,  24,     -649 }, /* VERR_LDR_INVALID_SEG_OFFSET */
    { 0x01b425,   9, 0x00e835,  27,     -648 }, /* VERR_LDR_INVALID_RVA */
    { 0x015cab,  18, 0x018bd2,  14,     -647 }, /* VERR_LDR_INVALID_LINK_ADDRESS */
    { 0x00f840,  26, 0x00d9d2,  28,     -641 }, /* VERR_LDRELF_UNTERMINATED_STRING_TAB */
    { 0x00f78a,  26, 0x006ee7,  42,     -640 }, /* VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS */
    { 0x00eeb7,  26, 0x00e340,  27,     -639 }, /* VERR_LDRELF_INVALID_RELOCATION_OFFSET */
    { 0x00e7e4,  27, 0x00da7a,  28,     -638 }, /* VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET */
    { 0x012b98,  21, 0x00f8c2,  26,     -637 }, /* VERR_LDRELF_INVALID_SYMBOL_INDEX */
    { 0x012b2f,  21, 0x00968c,  36,     -636 }, /* VERR_LDRELF_RELOCATION_NOT_SUPPORTED */
    { 0x010a1e,  24, 0x008495,  39,     -635 }, /* VERR_LDRELF_MULTIPLE_SYMTABS */
    { 0x01b38c,   9, 0x01b5c3,   9,     -634 }, /* VERR_LDRELF_VERSION */
    { 0x018203,  15, 0x004ddc,  49,     -633 }, /* VERR_LDRELF_MACHINE */
    { 0x01a4d6,  12, 0x000ebd,  74,     -632 }, /* VERR_LDRELF_EXEC */
    { 0x01aa23,  11, 0x00141d,  71,     -631 }, /* VERR_LDRELF_DYN */
    { 0x015e37,  18, 0x00ab70,  33,     -630 }, /* VERR_LDRELF_ODD_ENDIAN */
    { 0x012ee0,  21, 0x007c42,  40,     -628 }, /* VERR_LDRPE_GUARD_CF_STUFF */
    { 0x01086e,  24, 0x002440,  62,     -627 }, /* VERR_LDRPE_LOCK_PREFIX_TABLE */
    { 0x01411d,  20, 0x00514e,  49,     -626 }, /* VERR_LDRPE_LOAD_CONFIG_SIZE */
    { 0x012b83,  21, 0x010517,  25,     -625 }, /* VERR_LDRPE_COM_DESCRIPTOR */
    { 0x01ac17,  10, 0x0160bf,  18,     -624 }, /* VERR_LDRPE_TLS */
    { 0x016f0b,  16, 0x00614e,  45,     -623 }, /* VERR_LDRPE_GLOBALPTR */
    { 0x011c81,  23, 0x009bda,  35,     -622 }, /* VERR_LDRPE_CERT_UNSUPPORTED */
    { 0x012d3c,  21, 0x00c2d5,  30,     -621 }, /* VERR_LDRPE_CERT_MALFORMED */
    { 0x01556a,  19, 0x002fb1,  58,     -620 }, /* VERR_LDRPE_DELAY_IMPORT */
    { 0x017dae,  15, 0x0189b0,  14,     -619 }, /* VERR_LDR_IMAGE_HASH */
    { 0x0146cf,  20, 0x01b1a2,  10,     -618 }, /* VERR_LDR_GENERAL_FAILURE */
    { 0x011385,  23, 0x008b02,  38,     -617 }, /* VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND */
    { 0x0197a0,  13, 0x009297,  37,     -616 }, /* VERR_LDR_MISMATCH_NATIVE */
    { 0x01a973,  11, 0x0101de,  25,     -615 }, /* VERR_LDR_ARCH_MISMATCH */
    { 0x0162ea,  17, 0x00a814,  34,     -614 }, /* VERR_IMAGE_BASE_TOO_HIGH */
    { 0x01a8a2,  11, 0x01b90c,   8,     -612 }, /* VERR_IMAGE_TOO_BIG */
    { 0x015e25,  18, 0x003fb3,  53,     -611 }, /* VERR_SYMBOL_VALUE_TOO_BIG */
    { 0x01ace9,  10, 0x01b368,   9,     -610 }, /* VERR_MODULE_NOT_FOUND */
    { 0x01ad25,  10, 0x015dcb,  18,     -609 }, /* VERR_SYMBOL_NOT_FOUND */
    { 0x01a566,  12, 0x019daa,  12,     -608 }, /* VERR_BAD_EXE_FORMAT */
    { 0x01a25a,  12, 0x012a72,  21,     -607 }, /* VERR_AOUT_EXE_NOT_SUPPORTED */
    { 0x01ac85,  10, 0x005685,  47,     -606 }, /* VERR_MZ_EXE_NOT_SUPPORTED */
    { 0x01ac53,  10, 0x00585b,  47,     -605 }, /* VERR_NE_EXE_NOT_SUPPORTED */
    { 0x01aded,  10, 0x005656,  47,     -604 }, /* VERR_LE_EXE_NOT_SUPPORTED */
    { 0x01af2d,  10, 0x0054de,  47,     -603 }, /* VERR_LX_EXE_NOT_SUPPORTED */
    { 0x01b1de,  10, 0x005a31,  47,     -602 }, /* VERR_PE_EXE_NOT_SUPPORTED */
    { 0x01aaf4,  11, 0x0051af,  48,     -601 }, /* VERR_ELF_EXE_NOT_SUPPORTED */
    { 0x017d27,  15, 0x011e2f,  22,     -600 }, /* VERR_INVALID_EXE_SIGNATURE */
    { 0x01685c,  17, 0x00eca3,  27,     -566 }, /* VERR_L4_DS_MANAGER_NOT_FOUND */
    { 0x0105ad,  25, 0x00cf91,  29,     -563 }, /* VERR_IPC_SEND_SEND_PF_TIMEOUT */
    { 0x00d732,  28, 0x00b0e4,  32,     -562 }, /* VERR_IPC_RECEIVE_SEND_PF_TIMEOUT */
    { 0x01814f,  15, 0x00b984,  31,     -561 }, /* VERR_IPC_SEND_MAP_FAILED */
    { 0x016161,  18, 0x00a23c,  34,     -560 }, /* VERR_IPC_RECEIVE_MAP_FAILED */
    { 0x01674c,  17, 0x0193c4,  13,     -559 }, /* VERR_IPC_SEND_ABORTED */
    { 0x01443c,  20, 0x016f1a,  16,     -558 }, /* VERR_IPC_RECEIVE_ABORTED */
    { 0x015025,  19, 0x018767,  15,     -557 }, /* VERR_IPC_SEND_CANCELLED */
    { 0x011e45,  22, 0x016227,  18,     -556 }, /* VERR_IPC_RECEIVE_CANCELLED */
    { 0x0164e8,  17, 0x019b21,  13,     -555 }, /* VERR_IPC_SEND_TIMEOUT */
    { 0x013a29,  20, 0x017b78,  16,     -554 }, /* VERR_IPC_RECEIVE_TIMEOUT */
    { 0x017e44,  15, 0x0138e2,  21,     -553 }, /* VERR_IPC_PROCESS_NOT_FOUND */
    { 0x016fda,  16, 0x01a9e1,  11,     -552 }, /* VERR_RESOURCE_IN_USE */
    { 0x00d732,   4, 0x01bf39,   5,     -551 }, /* VERR_IPC */
    { 0x018898,  14, 0x01198a,  23,     -550 }, /* VERR_L4_INVALID_DS_OFFSET */
    { 0x012e38,  21, 0x01143d,  23,     -522 }, /* VERR_UDP_SERVER_DESTROYED */
    { 0x0140a5,  20, 0x00511d,  49,     -521 }, /* VERR_UDP_SERVER_SHUTDOWN */
    { 0x01712a,  16, 0x016581,  17,     -520 }, /* VERR_UDP_SERVER_STOP */
    { 0x012c7f,  21, 0x01140f,  23,     -502 }, /* VERR_TCP_SERVER_DESTROYED */
    { 0x013d71,  20, 0x0050bb,  49,     -501 }, /* VERR_TCP_SERVER_SHUTDOWN */
    { 0x017879,  16, 0x01684b,  17,     -500 }, /* VERR_TCP_SERVER_STOP */
    { 0x0163e9,  17, 0x00cc9f,  29,     -469 }, /* VERR_NET_NOT_UNSUPPORTED */
    { 0x01a9b5,  11, 0x01927e,  14,     -468 }, /* VERR_NET_INIT_FAILED */
    { 0x00f9c4,  25, 0x009938,  36,     -467 }, /* VERR_NET_INCOMPLETE_TX_PACKET */
    { 0x018479,  15, 0x01af37,  10,     -466 }, /* VERR_NET_PROTOCOL_ERROR */
    { 0x013102,  21, 0x019ae0,  13,     -465 }, /* VERR_NET_HOST_UNREACHABLE */
    { 0x01912e,  14, 0x01a70b,  11,     -464 }, /* VERR_NET_HOST_DOWN */
    { 0x011c53,  23, 0x015012,  19,     -461 }, /* VERR_NET_CONNECTION_REFUSED */
    { 0x00fc4e,  25, 0x00c400,  30,     -460 }, /* VERR_NET_CONNECTION_TIMED_OUT */
    { 0x016917,  17, 0x00c400,  30,     -459 }, /* VERR_NET_TOO_MANY_REFERENCES */
    { 0x019a9f,  13, 0x00a8bb,  33,     -458 }, /* VERR_NET_SHUTDOWN */
    { 0x018695,  15, 0x01499d,  19,     -457 }, /* VERR_NET_NOT_CONNECTED */
    { 0x01805f,  15, 0x014905,  19,     -456 }, /* VERR_NET_ALREADY_CONNECTED */
    { 0x015b31,  18, 0x010d66,  24,     -455 }, /* VERR_NET_NO_BUFFER_SPACE */
    { 0x00d0d0,  29, 0x01150c,  23,     -454 }, /* VERR_NET_CONNECTION_RESET_BY_PEER */
    { 0x011243,  23, 0x00a9e4,  33,     -453 }, /* VERR_NET_CONNECTION_ABORTED */
    { 0x00d0d0,  21, 0x0098f0,  36,     -452 }, /* VERR_NET_CONNECTION_RESET */
    { 0x017a29,  16, 0x013585,  21,     -451 }, /* VERR_NET_UNREACHABLE */
    { 0x01b275,   9, 0x018e3a,  14,     -450 }, /* VERR_NET_DOWN */
    { 0x011a14,  23, 0x012147,  22,     -449 }, /* VERR_NET_ADDRESS_NOT_AVAILABLE */
    { 0x014deb,  19, 0x018e10,  14,     -448 }, /* VERR_NET_ADDRESS_IN_USE */
    { 0x01253b,  22, 0x006a0d,  43,     -447 }, /* VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED */
    { 0x0113f8,  23, 0x0159a5,  18,     -446 }, /* VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED */
    { 0x01630c,  17, 0x01a362,  12,     -445 }, /* VERR_NET_OPERATION_NOT_SUPPORTED */
    { 0x0175a9,  16, 0x01ada7,  10,     -444 }, /* VERR_NET_SOCKET_TYPE_NOT_SUPPORTED */
    { 0x017899,  16, 0x01ab4c,  11,     -443 }, /* VERR_NET_PROTOCOL_NOT_SUPPORTED */
    { 0x010b26,  24, 0x013dfd,  20,     -442 }, /* VERR_NET_PROTOCOL_NOT_AVAILABLE */
    { 0x01824e,  15, 0x0111ce,  24,     -441 }, /* VERR_NET_PROTOCOL_TYPE */
    { 0x01ad57,  10, 0x018dbc,  14,     -440 }, /* VERR_NET_MSG_SIZE */
    { 0x00f15b,  26, 0x00cd30,  29,     -439 }, /* VERR_NET_DEST_ADDRESS_REQUIRED */
    { 0x019d86,  12, 0x008078,  39,     -438 }, /* VERR_NET_NOT_SOCKET */
    { 0x016d9b,  17, 0x012bec,  21,     -437 }, /* VERR_NET_ALREADY_IN_PROGRESS */
    { 0x016f3a,  16, 0x013a79,  20,     -436 }, /* VERR_NET_IN_PROGRESS */
    { 0x0162fb,  17, 0x00f0bf,  26,     -406 }, /* VERR_NET_NOT_UNIQUE_NAME */
    { 0x019b62,  13, 0x011ab5,  23,     -405 }, /* VERR_NET_NO_NETWORK */
    { 0x01a2a2,  12, 0x00f92a,  26,     -404 }, /* VERR_NET_PRINT_ERROR */
    { 0x01a416,  12, 0x01a968,  11,     -403 }, /* VERR_NET_PATH_NOT_FOUND */
    { 0x01a3b6,  12, 0x0171ca,  16,     -402 }, /* VERR_NET_HOST_NOT_FOUND */
    { 0x0132bb,  21, 0x00b2a4,  32,     -401 }, /* VERR_NET_OUT_OF_RESOURCES */
    { 0x01b3b0,   9, 0x00ca36,  30,     -400 }, /* VERR_NET_IO_ERROR */
    { 0x01accb,  10, 0x0081fe,  39,     -377 }, /* VERR_SEM_LV_INTERNAL_ERROR */
    { 0x0160f5,  18, 0x0097f4,  36,     -376 }, /* VERR_SEM_LV_NOT_SIGNALLER */
    { 0x0115c4,  23, 0x009ff4,  35,     -375 }, /* VERR_SEM_LV_ILLEGAL_UPGRADE */
    { 0x019174,  14, 0x0087be,  38,     -374 }, /* VERR_SEM_LV_NOT_OWNER */
    { 0x01033c,  25, 0x0066aa,  44,     -373 }, /* VERR_SEM_LV_EXISTING_DEADLOCK */
    { 0x016f7a,  16, 0x00995c,  36,     -372 }, /* VERR_SEM_LV_DEADLOCK */
    { 0x015ea3,  18, 0x0099a4,  36,     -371 }, /* VERR_SEM_LV_INVALID_PARAMETER */
    { 0x01887c,  14, 0x00529f,  48,     -370 }, /* VERR_SEM_LV_NESTED */
    { 0x00e124,  27, 0x00d419,  29,     -369 }, /* VERR_SEM_LV_WRONG_RELEASE_ORDER */
    { 0x0155a3,  19, 0x00cd6a,  29,     -368 }, /* VERR_SEM_LV_WRONG_ORDER */
    { 0x019ac6,  13, 0x00850a,  39,     -367 }, /* VERR_SEM_BAD_CONTEXT */
    { 0x01741a,  16, 0x00a080,  35,     -366 }, /* VERR_SEM_OUT_OF_TURN */
    { 0x01b2bd,   9, 0x01626e,  18,     -365 }, /* VERR_DEADLOCK */
    { 0x01a99f,  11, 0x002576,  62,     -364 }, /* VERR_SEM_NESTED */
    { 0x0191ac,  14, 0x00a5d2,  34,     -363 }, /* VERR_SEM_DESTROYED */
    { 0x01bbf1,   7, 0x00e9af,  27,     -362 }, /* VERR_SEM_NOT_FOUND */
    { 0x01828a,  15, 0x00685f,  43,     -361 }, /* VERR_SEM_OWNER_DIED */
    { 0x01b57b,   9, 0x016be1,  17,     -360 }, /* VERR_SEM_BUSY */
    { 0x01bb57,   7, 0x00f6d5,  26,     -359 }, /* VERR_ALREADY_RESET */
    { 0x01b9e4,   8, 0x00ead8,  27,     -358 }, /* VERR_ALREADY_POSTED */
    { 0x01bac4,   8, 0x00688a,  43,     -357 }, /* VERR_TOO_MANY_POSTS */
    { 0x01b7ac,   8, 0x00e09a,  28,     -356 }, /* VERR_TOO_MANY_OPENS */
    { 0x01bc3e,   7, 0x008c0c,  38,     -355 }, /* VERR_NOT_OWNER */
    { 0x017ccd,  15, 0x011312,  23,     -354 }, /* VERR_TOO_MANY_SEM_REQUESTS */
    { 0x01abaf,  11, 0x00f7a4,  26,     -353 }, /* VERR_SEM_IS_SET */
    { 0x017519,  16, 0x00646e,  44,     -352 }, /* VERR_EXCL_SEM_ALREADY_OWNED */
    { 0x01969c,  13, 0x0174d9,  16,     -351 }, /* VERR_TOO_MANY_SEMAPHORES */
    { 0x01bdd5,   6, 0x00b584,  32,     -350 }, /* VERR_SEM_ERROR */
    { 0x01a01a,  12, 0x008df7,  37,     -308 }, /* VERR_PIPE_NOT_WRITE */
    { 0x01a95d,  11, 0x008f69,  37,     -307 }, /* VERR_PIPE_NOT_READ */
    { 0x01ae15,  10, 0x0127cf,  22,     -306 }, /* VERR_MORE_DATA */
    { 0x01714a,  16, 0x01677f,  17,     -305 }, /* VERR_PIPE_NOT_CONNECTED */
    { 0x01bd5d,   6, 0x01b704,   8,     -304 }, /* VERR_NO_DATA */
    { 0x01afc3,  10, 0x01a6a8,  11,     -303 }, /* VERR_PIPE_BUSY */
    { 0x01bd75,   6, 0x01be05,   6,     -302 }, /* VERR_BAD_PIPE */
    { 0x01a4e2,  12, 0x01a4ca,  12,     -301 }, /* VERR_BROKEN_PIPE */
    { 0x01ac71,  10, 0x00c21c,  31,     -300 }, /* VERR_PIPE_IO_ERROR */
    { 0x0186d1,  15, 0x00d8ba,  28,     -257 }, /* VERR_IO_GEN_FAILURE */
    { 0x019940,  13, 0x01345f,  21,     -256 }, /* VERR_IO_SECTOR_NOT_FOUND */
    { 0x01a97e,  11, 0x0145f3,  20,     -255 }, /* VERR_IO_BAD_LENGTH */
    { 0x01bacc,   7, 0x01687e,  17,     -254 }, /* VERR_IO_CRC */
    { 0x01a3da,  12, 0x01384f,  21,     -253 }, /* VERR_IO_BAD_COMMAND */
    { 0x01b0d1,  10, 0x0129b3,  22,     -252 }, /* VERR_IO_NOT_READY */
    { 0x01b476,   9, 0x015a47,  18,     -251 }, /* VERR_IO_BAD_UNIT */
    { 0x01b4ac,   9, 0x00e90d,  27,     -250 }, /* VERR_DEV_IO_ERROR */
    { 0x011426,  23, 0x00517f,  48,     -234 }, /* VERR_IPE_NOT_REACHED_DEFAULT_CASE */
    { 0x0124e3,  22, 0x010dde,  24,     -233 }, /* VERR_IPE_UNINITIALIZED_STATUS */
    { 0x01a69d,  11, 0x01aa5a,  11,     -232 }, /* VERR_IPE_UNEXPECTED_ERROR_STATUS */
    { 0x018d4c,  14, 0x01aa5a,  11,     -231 }, /* VERR_IPE_UNEXPECTED_INFO_STATUS */
    { 0x01b4fd,   9, 0x01aa5a,  11,     -230 }, /* VERR_IPE_UNEXPECTED_STATUS */
    { 0x01bfc5,   5, 0x01bf66,   5,     -229 }, /* VERR_INTERNAL_ERROR_5 */
    { 0x01bfca,   5, 0x01bf66,   5,     -228 }, /* VERR_INTERNAL_ERROR_4 */
    { 0x01bfcf,   5, 0x01bf66,   5,     -227 }, /* VERR_INTERNAL_ERROR_3 */
    { 0x01c006,   5, 0x01bf66,   5,     -226 }, /* VERR_INTERNAL_ERROR_2 */
    { 0x01bfc5,   3, 0x00d20f,  29,     -225 }, /* VERR_INTERNAL_ERROR */
    { 0x013657,  21, 0x00bf53,  31,     -202 }, /* VERR_NO_MORE_SEARCH_HANDLES */
    { 0x01a1e2,  12, 0x019350,  13,     -201 }, /* VERR_NO_MORE_FILES */
    { 0x01b26c,   9, 0x00d266,  29,     -200 }, /* VERR_SEARCH_ERROR */
    { 0x0187df,  15, 0x019200,  14,     -165 }, /* VERR_DRIVE_IS_EMPTY */
    { 0x016e89,  17, 0x0126f3,  22,     -164 }, /* VERR_IS_A_CHAR_DEVICE */
    { 0x015e6d,  18, 0x01594b,  18,     -163 }, /* VERR_IS_A_BLOCK_DEVICE */
    { 0x019f36,  12, 0x01a00e,  12,     -162 }, /* VERR_IS_A_SOCKET */
    { 0x01acad,  10, 0x01b1ac,  10,     -161 }, /* VERR_IS_A_FIFO */
    { 0x0197ba,  13, 0x014c10,  19,     -160 }, /* VERR_IS_A_SYMLINK */
    { 0x016ce0,  17, 0x011482,  23,     -159 }, /* VERR_SYMLINK_NOT_ALLOWED */
    { 0x0107f6,  24, 0x007cba,  40,     -158 }, /* VERR_NS_SYMLINK_CHANGE_OWNER */
    { 0x01434c,  20, 0x005917,  47,     -157 }, /* VERR_NS_SYMLINK_SET_TIME */
    { 0x01a758,  11, 0x013c59,  20,     -156 }, /* VERR_TOO_MANY_SYMLINKS */
    { 0x019557,  13, 0x00d7da,  28,     -155 }, /* VERR_DISK_INVALID_FORMAT */
    { 0x019c4c,  13, 0x018fec,  14,     -154 }, /* VERR_DRIVE_LOCKED */
    { 0x01a28a,  12, 0x018986,  14,     -153 }, /* VERR_DISK_CHANGE */
    { 0x01b1f2,  10, 0x01a58a,  11,     -152 }, /* VERR_DISK_FULL */
    { 0x01bcca,   7, 0x018e80,  14,     -151 }, /* VERR_INVALID_DRIVE */
    { 0x01b18e,  10, 0x00bb74,  31,     -150 }, /* VERR_DISK_IO_ERROR */
    { 0x0189cc,  14, 0x007595,  41,     -147 }, /* VERR_STALE_FILE_HANDLE */
    { 0x0103d2,  25, 0x001c51,  65,     -146 }, /* VERR_FILE_AIO_INSUFFICIENT_EVENTS */
    { 0x0163d8,  17, 0x016dce,  17,     -145 }, /* VERR_PATH_ZERO_LENGTH */
    { 0x015f45,  18, 0x005f8c,  45,     -144 }, /* VERR_PATH_IS_NOT_RELATIVE */
    { 0x016680,  17, 0x00c5a4,  30,     -143 }, /* VERR_PATH_IS_RELATIVE */
    { 0x00ecf4,  27, 0x00a93f,  33,     -142 }, /* VERR_PATH_DOES_NOT_START_WITH_ROOT */
    { 0x01abe5,  10, 0x015622,  18,     -141 }, /* VERR_UNEXPECTED_FS_OBJ_TYPE */
    { 0x01b045,  10, 0x00b364,  32,     -140 }, /* VERR_IS_A_FILE */
    { 0x01b7ec,   8, 0x00b8e4,  32,     -139 }, /* VERR_NOT_A_FILE */
    { 0x018d92,  14, 0x011b84,  23,     -138 }, /* VERR_RESOURCE_BUSY */
    { 0x00d4aa,  29, 0x003266,  57,     -137 }, /* VERR_FILE_AIO_INSUFFICIENT_RESSOURCES */
    { 0x018050,  15, 0x0086b4,  38,     -136 }, /* VERR_FILE_AIO_NOT_PREPARED */
    { 0x0176b9,  16, 0x0078a0,  41,     -135 }, /* VERR_FILE_AIO_NOT_SUBMITTED */
    { 0x018dd8,  14, 0x019ff6,  12,     -134 }, /* VERR_FILE_AIO_CANCELED */
    { 0x013fc9,  20, 0x001bcf,  65,     -133 }, /* VERR_FILE_AIO_LIMIT_EXCEEDED */
    { 0x01ad07,  10, 0x001938,  67,     -132 }, /* VERR_FILE_AIO_BUSY */
    { 0x0181d6,  15, 0x00a2e6,  34,     -131 }, /* VERR_FILE_AIO_COMPLETED */
    { 0x01655f,  17, 0x00186c,  68,     -130 }, /* VERR_FILE_AIO_IN_PROGRESS */
    { 0x018ee2,  14, 0x006fe3,  42,     -129 }, /* VERR_FILE_AIO_NO_REQUEST */
    { 0x01bd2d,   6, 0x003da1,  53,     -128 }, /* VERR_FILE_TOO_BIG */
    { 0x0180c8,  15, 0x00b1e4,  32,     -127 }, /* VERR_IS_A_DIRECTORY */
    { 0x019704,  13, 0x00b6a4,  32,     -126 }, /* VERR_NOT_A_DIRECTORY */
    { 0x01a5f8,  11, 0x0138a3,  21,     -125 }, /* VERR_DIR_NOT_EMPTY */
    { 0x01a994,  11, 0x00f6bb,  26,     -124 }, /* VERR_FILE_LOCK_LOST */
    { 0x01b560,   9, 0x00c089,  31,     -123 }, /* VERR_FILE_NOT_LOCKED */
    { 0x015bd3,  18, 0x01299d,  22,     -122 }, /* VERR_MEDIA_NOT_RECOGNIZED */
    { 0x017d45,  15, 0x0128d7,  22,     -121 }, /* VERR_MEDIA_NOT_PRESENT */
    { 0x017d9f,  15, 0x00dc72,  28,     -120 }, /* VERR_FILENAME_TOO_LONG */
    { 0x0198ff,  13, 0x00ee50,  26,     -119 }, /* VERR_NOT_SAME_DEVICE */
    { 0x012189,  22, 0x01017a,  25,     -118 }, /* VERR_CANT_DELETE_DIRECTORY */
    { 0x01a40a,  12, 0x012029,  22,     -117 }, /* VERR_CANT_CREATE */
    { 0x017a69,  16, 0x00401d,  53,     -116 }, /* VERR_FILE_LOCK_VIOLATION */
    { 0x01b72c,   8, 0x010856,  24,     -115 }, /* VERR_FILE_LOCK_FAILED */
    { 0x015a23,  18, 0x005028,  49,     -114 }, /* VERR_SHARING_VIOLATION */
    { 0x0188c2,  14, 0x018488,  15,     -113 }, /* VERR_WRITE_PROTECT */
    { 0x01b83c,   8, 0x01b287,   9,     -112 }, /* VERR_WRITE_ERROR */
    { 0x01bb0b,   7, 0x01b9cc,   8,     -111 }, /* VERR_READ_ERROR */
    { 0x01c09d,   4, 0x013a51,  20,     -110 }, /* VERR_EOF */
    { 0x018041,  15, 0x011637,  23,     -109 }, /* VERR_SEEK_ON_DEVICE */
    { 0x018d30,  14, 0x01571e,  18,     -108 }, /* VERR_NEGATIVE_SEEK */
    { 0x018041,   5, 0x01bd6f,   6,     -107 }, /* VERR_SEEK */
    { 0x019ba3,  13, 0x0172ea,  16,     -106 }, /* VERR_TOO_MANY_OPEN_FILES */
    { 0x01b804,   8, 0x014733,  20,     -105 }, /* VERR_ALREADY_EXISTS */
    { 0x01bde1,   6, 0x00dc1e,  28,     -104 }, /* VERR_INVALID_NAME */
    { 0x01b9c4,   8, 0x01bbdc,   7,     -103 }, /* VERR_PATH_NOT_FOUND */
    { 0x01c0cd,   4, 0x01bcbc,   7,     -102 }, /* VERR_FILE_NOT_FOUND */
    { 0x01bb50,   7, 0x0158a9,  18,     -101 }, /* VERR_OPEN_FAILED */
    { 0x01be6b,   6, 0x00e994,  27,     -100 }, /* VERR_FILE_IO_ERROR */
    { 0x01c117,   2, 0x0151da,  19,      -99 }, /* VERR_MISSING */
    { 0x01af9b,  10, 0x0146e3,  20,      -98 }, /* VERR_DUPLICATE */
    { 0x01ab20,  11, 0x018cea,  14,      -97 }, /* VERR_UNSUPPORTED_ALIGNMENT */
    { 0x01b65d,   8, 0x004cb0,  50,      -96 }, /* VERR_NO_EXEC_MEMORY */
    { 0x01b864,   8, 0x01a2c6,  12,      -95 }, /* VERR_NO_CHANGE */
    { 0x015ed9,  18, 0x009644,  36,      -93 }, /* VERR_CALLER_NO_REFERENCE */
    { 0x015e13,  18, 0x00bd82,  31,      -92 }, /* VERR_CONCURRENT_ACCESS */
    { 0x01b994,   8, 0x0018f4,  68,      -91 }, /* VERR_IGNORED */
    { 0x018a66,  14, 0x016e12,  17,      -90 }, /* VERR_NOT_POWER_OF_TWO */
    { 0x011665,  23, 0x011caf,  23,      -89 }, /* VERR_AUTHENTICATION_FAILURE */
    { 0x0178e9,  16, 0x0083f9,  39,      -88 }, /* VERR_CALLBACK_RETURN */
    { 0x01ae3d,  10, 0x016dac,  17,      -87 }, /* VERR_INVALID_BASE64_ENCODING */
    { 0x016b15,  17, 0x00fc80,  25,      -86 }, /* VERR_DANGLING_OBJECTS */
    { 0x0166d5,  17, 0x014964,  19,      -85 }, /* VERR_OBJECT_DESTROYED */
    { 0x013f01,  20, 0x013768,  21,      -84 }, /* VERR_PAGE_COUNT_OUT_OF_RANGE */
    { 0x01b25a,   9, 0x01a22a,  12,      -83 }, /* VERR_END_OF_STRING */
    { 0x016c8b,  17, 0x012a09,  21,      -82 }, /* VERR_PREEMPT_DISABLED */
    { 0x018a82,  14, 0x007a62,  40,      -81 }, /* VERR_NO_MORE_HANDLES */
    { 0x016d79,  17, 0x0166c4,  17,      -80 }, /* VERR_OUT_OF_RESOURCES */
    { 0x01c0e0,   3, 0x01c029,   4,      -79 }, /* VERR_INVALID_STATE */
    { 0x01c0fe,   3, 0x01b2f3,   9,      -78 }, /* VERR_NOT_FOUND */
    { 0x0179c9,  16, 0x016f8a,  16,      -77 }, /* VERR_TRAILING_SPACES */
    { 0x017e62,  15, 0x014310,  20,      -76 }, /* VERR_TRAILING_CHARS */
    { 0x01bded,   6, 0x01725a,  16,      -75 }, /* VERR_MAP_FAILED */
    { 0x0196ea,  13, 0x009f22,  35,      -74 }, /* VERR_ADDRESS_TOO_BIG */
    { 0x01b99c,   8, 0x0029b7,  60,      -73 }, /* VERR_NO_PHYS_MEMORY */
    { 0x01bb3b,   7, 0x003968,  55,      -72 }, /* VERR_NO_LOW_MEMORY */
    { 0x01906a,  14, 0x01153a,  23,      -71 }, /* VERR_MEMOBJ_INIT_FAILED */
    { 0x01adcf,  10, 0x003931,  55,      -70 }, /* VERR_CANCELLED */
    { 0x017799,  16, 0x008189,  39,      -69 }, /* VERR_TIMER_SUSPENDED */
    { 0x019afa,  13, 0x0097ac,  36,      -68 }, /* VERR_TIMER_ACTIVE */
    { 0x01bc61,   7, 0x00ada1,  33,      -67 }, /* VERR_MEMORY_BUSY */
    { 0x018e48,  14, 0x0033bc,  57,      -66 }, /* VERR_NO_CODE_POINT_MEMORY */
    { 0x01b2c6,   9, 0x00224d,  63,      -65 }, /* VERR_NO_UTF16_MEMORY */
    { 0x01bcd8,   7, 0x005a02,  47,      -64 }, /* VERR_NO_STR_MEMORY */
    { 0x0132fa,  21, 0x0057fd,  47,      -63 }, /* VERR_CANT_RECODE_AS_UTF16 */
    { 0x01b58d,   9, 0x006809,  43,      -62 }, /* VERR_INVALID_UTF16_ENCODING */
    { 0x01b774,   8, 0x007996,  41,      -61 }, /* VERR_INVALID_UTF8_ENCODING */
    { 0x012c6a,  21, 0x0038c3,  55,      -60 }, /* VERR_CODE_POINT_SURROGATE */
    { 0x00d5fe,  28, 0x001078,  73,      -59 }, /* VERR_CODE_POINT_ENDIAN_INDICATOR */
    { 0x0198e5,  13, 0x006442,  44,      -58 }, /* VERR_NO_TRANSLATION */
    { 0x016239,  18, 0x008fd8,  37,      -57 }, /* VERR_NEGATIVE_UNSIGNED */
    { 0x01b695,   8, 0x005627,  47,      -56 }, /* VERR_NO_DIGITS */
    { 0x01a3f2,  12, 0x007758,  41,      -55 }, /* VERR_NUMBER_TOO_BIG */
    { 0x0196f7,  13, 0x01695b,  17,      -54 }, /* VERR_OUT_OF_RANGE */
    { 0x01c0e3,   3, 0x01b8ec,   8,      -53 }, /* VERR_PARSE_ERROR */
    { 0x01ae1f,  10, 0x01b76c,   8,      -52 }, /* VERR_TRY_AGAIN */
    { 0x017939,  16, 0x00ad80,  33,      -51 }, /* VERR_PROCESS_RUNNING */
    { 0x01a79a,  11, 0x01bdc3,   6,      -50 }, /* VERR_PROCESS_NOT_FOUND */
    { 0x01982f,  13, 0x00ebcb,  27,      -49 }, /* VERR_INVALID_UUID_FORMAT */
    { 0x01b15c,  10, 0x01adb1,  10,      -48 }, /* VERR_STATE_CHANGED */
    { 0x0181b8,  15, 0x00baba,  31,      -47 }, /* VERR_SIGNAL_INVALID */
    { 0x017c91,  15, 0x015557,  19,      -46 }, /* VERR_SIGNAL_PENDING */
    { 0x018668,  15, 0x00d314,  29,      -45 }, /* VERR_SIGNAL_REFUSED */
    { 0x015658,  18, 0x018a74,  14,      -44 }, /* VERR_MAX_PROCS_REACHED */
    { 0x01625d,  18, 0x012df9,  21,      -43 }, /* VERR_MAX_THRDS_REACHED */
    { 0x01a6c9,  11, 0x01819a,  15,      -42 }, /* VERR_TOO_MUCH_DATA */
    { 0x016eeb,  16, 0x00e979,  27,      -41 }, /* VERR_BUFFER_OVERFLOW */
    { 0x01b6b4,   8, 0x01b6a4,   8,      -40 }, /* VERR_TIMEOUT */
    { 0x019d92,  12, 0x01683a,  17,      -39 }, /* VERR_INTERRUPTED */
    { 0x018ef0,  14, 0x01921c,  14,      -38 }, /* VERR_ACCESS_DENIED */
    { 0x01c0f5,   3, 0x01bf61,   5,      -37 }, /* VERR_NOT_SUPPORTED */
    { 0x01ac3f,  10, 0x01af69,  10,      -36 }, /* VERR_INVALID_FUNCTION */
    { 0x01994d,  13, 0x009350,  36,      -35 }, /* VERR_UNRESOLVED_ERROR */
    { 0x0168b1,  17, 0x01640b,  17,      -34 }, /* VERR_ADDRESS_CONFLICT */
    { 0x01a784,  11, 0x01568e,  18,      -33 }, /* VERR_TIMER_BUSY */
    { 0x01b3a7,   9, 0x01b2a2,   9,      -32 }, /* VERR_INVALID_CONTEXT */
    { 0x0171ea,  16, 0x0150bd,  19,      -31 }, /* VERR_PAGE_TABLE_NOT_PRESENT */
    { 0x0164c6,  17, 0x014540,  20,      -30 }, /* VERR_THREAD_NOT_WAITABLE */
    { 0x017c37,  15, 0x017ed9,  15,      -29 }, /* VERR_THREAD_IS_DEAD */
    { 0x019487,  13, 0x0144dc,  20,      -28 }, /* VERR_ALREADY_INITIALIZED */
    { 0x01c061,   4, 0x00ea6c,  27,      -27 }, /* VERR_NO_PAGE_MEMORY */
    { 0x01b844,   8, 0x009203,  37,      -26 }, /* VERR_NO_CONT_MEMORY */
    { 0x0161cd,  18, 0x001c10,  65,      -24 }, /* VERR_FAILED_TO_SET_SELF_TLS */
    { 0x019032,  14, 0x0011e2,  72,      -23 }, /* VERR_NO_TLS_FOR_SELF */
    { 0x01a476,  12, 0x01362d,  21,      -22 }, /* VERR_WRONG_ORDER */
    { 0x01bc92,   7, 0x012407,  22,      -21 }, /* VERR_INVALID_FMODE */
    { 0x01bafd,   7, 0x00d74e,  28,      -20 }, /* VERR_NO_TMP_MEMORY */
    { 0x01b46d,   9, 0x00ca90,  30,      -19 }, /* VERR_NOT_SYMLINK */
    { 0x01bc7d,   7, 0x01af87,  10,      -18 }, /* VERR_NOT_EQUAL */
    { 0x01bcc3,   7, 0x018828,  14,      -13 }, /* VERR_INVALID_FLAGS */
    { 0x019a1d,  13, 0x00fef0,  25,      -12 }, /* VERR_NOT_IMPLEMENTED */
    { 0x01c065,   4, 0x01650a,  17,      -11 }, /* VERR_VERSION_MISMATCH */
    { 0x015bc1,  18, 0x015efd,  18,      -10 }, /* VERR_PERMISSION_DENIED */
    { 0x01b8dc,   8, 0x0183a7,  15,       -9 }, /* VERR_ALREADY_LOADED */
    { 0x01c104,   3, 0x014d40,  19,       -8 }, /* VERR_NO_MEMORY */
    { 0x01bd69,   6, 0x01990c,  13,       -7 }, /* VERR_IDT_FAILED */
    { 0x01b401,   9, 0x01b184,  10,       -6 }, /* VERR_INVALID_POINTER */
    { 0x01bb42,   7, 0x01278d,  22,       -5 }, /* VERR_LOCK_FAILED */
    { 0x01b6ac,   8, 0x01b894,   8,       -4 }, /* VERR_INVALID_HANDLE */
    { 0x01bcfb,   7, 0x01864a,  15,       -3 }, /* VERR_INVALID_MAGIC */
    { 0x01a8fa,  11, 0x01a931,  11,       -2 }, /* VERR_INVALID_PARAMETER */
    { 0x0173da,  16, 0x009a34,  36,       -1 }, /* VERR_GENERAL_FAILURE */
    { 0x01b8b4,   8, 0x01b84c,   8,        0 }, /* VINF_SUCCESS */
    { 0x01aabd,  11, 0x01a931,  11,        2 }, /* VWRN_INVALID_PARAMETER */
    { 0x01bbf8,   7, 0x01864a,  15,        3 }, /* VWRN_INVALID_MAGIC */
    { 0x01b6c4,   8, 0x01b894,   8,        4 }, /* VWRN_INVALID_HANDLE */
    { 0x015b0d,  18, 0x015efd,  18,       10 }, /* VINF_PERMISSION_DENIED */
    { 0x019a44,  13, 0x00fef0,  25,       12 }, /* VINF_NOT_IMPLEMENTED */
    { 0x019779,  13, 0x0144dc,  20,       28 }, /* VINF_ALREADY_INITIALIZED */
    { 0x01c0ec,   3, 0x01bf61,   5,       37 }, /* VINF_NOT_SUPPORTED */
    { 0x019cae,  12, 0x01683a,  17,       39 }, /* VINF_INTERRUPTED */
    { 0x01b625,   8, 0x01b6a4,   8,       40 }, /* VINF_TIMEOUT */
    { 0x017919,  16, 0x00e979,  27,       41 }, /* VINF_BUFFER_OVERFLOW */
    { 0x01af0f,  10, 0x01537c,  19,       48 }, /* VWRN_STATE_CHANGED */
    { 0x01add9,  10, 0x01b76c,   8,       52 }, /* VINF_TRY_AGAIN */
    { 0x01a422,  12, 0x007758,  41,       55 }, /* VWRN_NUMBER_TOO_BIG */
    { 0x01b7cc,   8, 0x005627,  47,       56 }, /* VWRN_NO_DIGITS */
    { 0x015ccf,  18, 0x008fd8,  37,       57 }, /* VWRN_NEGATIVE_UNSIGNED */
    { 0x0196b6,  13, 0x006442,  44,       58 }, /* VWRN_NO_TRANSLATION */
    { 0x01826c,  15, 0x014310,  20,       76 }, /* VWRN_TRAILING_CHARS */
    { 0x0171ba,  16, 0x016f8a,  16,       77 }, /* VWRN_TRAILING_SPACES */
    { 0x01c0fb,   3, 0x016fea,  16,       78 }, /* VWRN_NOT_FOUND */
    { 0x01c107,   3, 0x01a7c6,  11,       79 }, /* VWRN_INVALID_STATE */
    { 0x016ae2,  17, 0x01119e,  24,       80 }, /* VWRN_OUT_OF_RESOURCES */
    { 0x01b5ba,   9, 0x01a22a,  12,       83 }, /* VINF_END_OF_STRING */
    { 0x016570,  17, 0x00e886,  27,       85 }, /* VINF_OBJECT_DESTROYED */
    { 0x0167e5,  17, 0x00fc80,  25,       86 }, /* VWRN_DANGLING_OBJECTS */
    { 0x01703a,  16, 0x0083f9,  39,       88 }, /* VINF_CALLBACK_RETURN */
    { 0x01b8d4,   8, 0x0170ba,  16,       95 }, /* VINF_NO_CHANGE */
    { 0x01a737,  11, 0x00168f,  69,       97 }, /* VINF_UNSUPPORTED_ALIGNMENT */
    { 0x01b724,   8, 0x014733,  20,      105 }, /* VWRN_ALREADY_EXISTS */
    { 0x01c05d,   4, 0x013a51,  20,      110 }, /* VINF_EOF */
    { 0x019682,  13, 0x005ed8,  45,      203 }, /* VWRN_NO_DIRENT_INFO */
    { 0x01b834,   8, 0x00ead8,  27,      358 }, /* VINF_ALREADY_POSTED */
    { 0x01a989,  11, 0x004ce2,  50,      364 }, /* VINF_SEM_NESTED */
    { 0x019981,  13, 0x004d78,  50,      367 }, /* VINF_SEM_BAD_CONTEXT */
    { 0x017569,  16, 0x0168f5,  17,      500 }, /* VINF_TCP_SERVER_STOP */
    { 0x014b06,  19, 0x008914,  38,      503 }, /* VINF_TCP_SERVER_NO_CLIENT */
    { 0x0173aa,  16, 0x0168f5,  17,      520 }, /* VINF_UDP_SERVER_STOP */
    { 0x014aa7,  19, 0x008b4e,  38,      523 }, /* VINF_UDP_SERVER_NO_CLIENT */
    { 0x013975,  20, 0x00649a,  44,      564 }, /* VINF_IPC_RECEIVE_MSG_CUT */
    { 0x016d13,  17, 0x0077aa,  41,      565 }, /* VINF_IPC_SEND_MSG_CUT */
    { 0x015213,  19, 0x009e96,  35,      690 }, /* VINF_DBG_ADJUSTED_SYM_SIZE */
    { 0x01a6f5,  11, 0x00f18f,  26,      750 }, /* VINF_ENV_VAR_NOT_FOUND */
    { 0x0127e5,  22, 0x0005dd,  96,      751 }, /* VWRN_ENV_NOT_FULLY_TRANSLATED */
    { 0x018c50,  14, 0x0092e1,  37,      753 }, /* VINF_ENV_VAR_UNSET */
    { 0x017e8e,  15, 0x01220d,  22,      828 }, /* VINF_GETOPT_NOT_OPTION */
    { 0x019c3f,  13, 0x01894e,  14,      948 }, /* VINF_TAR_DIR_PATH */
    { 0x01bffc,   5, 0x01bf25,   5,     1002 }, /* VWRN_UNSUPPORTED_CPU */
    { 0x012bd7,  21, 0x005946,  47,     1028 }, /* VINF_DRIVER_REBOOT_NEEDED */
    { 0x0197ee,  13, 0x00329f,  57,     1100 }, /* VINF_EM_TERMINATE */
    { 0x013714,  21, 0x00fcfd,  25,     1101 }, /* VINF_EM_DBG_HYPER_STEPPED */
    { 0x010cd6,  24, 0x00021a, 124,     1102 }, /* VINF_EM_DBG_HYPER_BREAKPOINT */
    { 0x011acc,  23, 00000000, 142,     1103 }, /* VINF_EM_DBG_HYPER_ASSERTION */
    { 0x019598,  13, 0x009524,  36,     1104 }, /* VINF_EM_DBG_EVENT */
    { 0x019f1e,  12, 0x000b64,  80,     1105 }, /* VINF_EM_DBG_STOP */
    { 0x01863b,  15, 0x00122a,  72,     1106 }, /* VINF_EM_DBG_STEPPED */
    { 0x015808,  18, 0x000752,  90,     1107 }, /* VINF_EM_DBG_BREAKPOINT */
    { 0x01863b,  12, 0x005741,  47,     1108 }, /* VINF_EM_DBG_STEP */
    { 0x01bc84,   7, 0x000a16,  85,     1109 }, /* VINF_EM_OFF */
    { 0x01a8e4,  11, 0x000dda,  76,     1110 }, /* VINF_EM_SUSPEND */
    { 0x01b3d4,   9, 0x001e96,  64,     1111 }, /* VINF_EM_RESET */
    { 0x01ba5c,   8, 0x000452, 103,     1112 }, /* VINF_EM_HALT */
    { 0x00f606,  10, 0x002f03,  58,     1113 }, /* VINF_EM_RESUME */
    { 0x01bd39,   6, 0x0007ac,  90,     1114 }, /* VINF_EM_NO_MEMORY */
    { 0x0159b7,  18, 0x00381e,  55,     1115 }, /* VINF_EM_RESCHEDULE_REM */
    { 0x00f944,  26, 0x003383,  57,     1116 }, /* VINF_EM_RESCHEDULE_EXEC_ENGINE */
    { 0x00f944,  14, 0x00751a,  41,     1118 }, /* VINF_EM_RESCHEDULE */
    { 0x0193eb,  13, 0x00ce52,  29,     1120 }, /* VINF_EM_WAIT_SIPI */
    { 0x0158cd,  18, 0x007610,  41,     1121 }, /* VINF_EM_RAW_GUEST_TRAP */
    { 0x01028d,  17, 0x008162,  39,     1122 }, /* VINF_EM_RAW_INTERRUPT */
    { 0x011803,  23, 0x003025,  58,     1123 }, /* VINF_EM_RAW_INTERRUPT_HYPER */
    { 0x011779,  19, 0x00afa4,  32,     1124 }, /* VINF_EM_RAW_RING_SWITCH */
    { 0x011779,  23, 0x00342e,  57,     1125 }, /* VINF_EM_RAW_RING_SWITCH_INT */
    { 0x00dc02,  28, 0x0074f1,  41,     1126 }, /* VINF_EM_RAW_EXCEPTION_PRIVILEGED */
    { 0x00b9c2,  21, 0x00ec37,  27,     1127 }, /* VINF_EM_RAW_EMULATE_INSTR */
    { 0x00bcaa,  31, 0x00e742,  27,     1128 }, /* VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT */
    { 0x00bad9,  31, 0x00e634,  27,     1129 }, /* VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT */
    { 0x00c105,  31, 0x00e1ab,  27,     1130 }, /* VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT */
    { 0x00b9c2,  31, 0x00b824,  32,     1131 }, /* VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT */
    { 0x019668,  13, 0x01139c,  23,     1135 }, /* VINF_EM_RAW_TO_R3 */
    { 0x012a48,  21, 0x012f88,  21,     1136 }, /* VINF_EM_RAW_TIMER_PENDING */
    { 0x01028d,  25, 0x00ac36,  33,     1137 }, /* VINF_EM_RAW_INTERRUPT_PENDING */
    { 0x012173,  22, 0x0100e4,  25,     1138 }, /* VINF_EM_RAW_STALE_SELECTOR */
    { 0x01643e,  17, 0x009980,  36,     1139 }, /* VINF_EM_RAW_IRET_TRAP */
    { 0x01518e,  19, 0x015eeb,  18,     1150 }, /* VINF_EM_PENDING_REQUEST */
    { 0x01080e,  24, 0x00ce8c,  29,     1151 }, /* VINF_EM_RAW_EMULATE_DBG_STEP */
    { 0x012601,  22, 0x00d05c,  29,     1152 }, /* VINF_EM_HM_PATCH_TPR_INSTR */
    { 0x0178a9,  16, 0x00b444,  32,     1155 }, /* VINF_EM_TRIPLE_FAULT */
    { 0x01065c,  25, 0x00e8bc,  27,     1157 }, /* VINF_EM_RAW_INJECT_TRPM_EVENT */
    { 0x00f80c,  26, 0x00906c,  37,     1159 }, /* VINF_EM_PENDING_R3_IOPORT_READ */
    { 0x00e325,  27, 0x0088a2,  38,     1160 }, /* VINF_EM_PENDING_R3_IOPORT_WRITE */
    { 0x00f606,  26, 0x0028c7,  60,     1161 }, /* VINF_EM_RESUME_R3_HISTORY_EXEC */
    { 0x01287f,  22, 0x00ab4f,  33,     1162 }, /* VINF_EM_EMULATE_SPLIT_LOCK */
    { 0x01ac21,  10, 0x00c06a,  31,     1202 }, /* VWRN_DBGF_ALREADY_HALTED */
    { 0x018f52,  14, 0x00aa89,  33,     1205 }, /* VINF_DBGF_BP_ALREADY_ENABLED */
    { 0x01854b,  15, 0x00a017,  35,     1206 }, /* VINF_DBGF_BP_ALREADY_DISABLED */
    { 0x01a272,  12, 0x01ad2f,  10,     1207 }, /* VINF_DBGF_BP_ALREADY_EXIST */
    { 0x018908,  14, 0x0185ff,  15,     1209 }, /* VINF_DBGF_OS_NOT_DETCTED */
    { 0x012dcf,  21, 0x015d4d,  18,     1211 }, /* VINF_DBGF_TRUNCATED_REGISTER */
    { 0x00fed7,  25, 0x0125d5,  22,     1212 }, /* VINF_DBGF_ZERO_EXTENDED_REGISTER */
    { 0x01ad75,  10, 0x00069c,  91,     1224 }, /* VINF_DBGF_BP_HALT */
    { 0x013e11,  20, 0x00526f,  48,     1239 }, /* VINF_DBGF_R3_BP_OWNER_DEFER */
    { 0x015a6b,  18, 0x0056e3,  47,     1400 }, /* VWRN_CONTINUE_ANALYSIS */
    { 0x018fa6,  14, 0x01930a,  14,     1404 }, /* VWRN_PATCH_ENABLED */
    { 0x018b8c,  14, 0x0182d5,  15,     1407 }, /* VWRN_PATCH_REMOVED */
    { 0x015272,  19, 0x00a9a2,  33,     1408 }, /* VINF_PATM_PATCH_TRAP_GP */
    { 0x0151a1,  19, 0x00aa68,  33,     1409 }, /* VINF_PATM_PATCH_TRAP_PF */
    { 0x01706a,  16, 0x00a4e4,  34,     1410 }, /* VINF_PATM_PATCH_INT3 */
    { 0x011fe7,  22, 0x00ac57,  33,     1411 }, /* VINF_PATM_CHECK_PATCH_PAGE */
    { 0x010dc6,  24, 0x007d5a,  40,     1412 }, /* VINF_PATM_DUPLICATE_FUNCTION */
    { 0x01439c,  20, 0x00f419,  26,     1413 }, /* VINF_PATCH_EMULATE_INSTR */
    { 0x012315,  22, 0x00ca54,  30,     1414 }, /* VINF_PATM_HC_MMIO_PATCH_WRITE */
    { 0x013339,  21, 0x00ce18,  29,     1415 }, /* VINF_PATM_HC_MMIO_PATCH_READ */
    { 0x00d89e,  28, 0x0085cd,  39,     1416 }, /* VINF_PATM_PENDING_IRQ_AFTER_IRET */
    { 0x016361,  17, 0x010aae,  24,     1427 }, /* VWRN_PATCH_END_BRANCH */
    { 0x0176a9,  16, 0x013a3d,  20,     1429 }, /* VINF_PATM_SPINLOCK_FAILED */
    { 0x018794,  15, 0x009428,  36,     1430 }, /* VINF_PATCH_CONTINUE */
    { 0x014a81,  19, 0x0190b0,  14,     1500 }, /* VWRN_CSAM_TRAP_NOT_HANDLED */
    { 0x0104b3,  25, 0x0177d9,  16,     1501 }, /* VWRN_CSAM_INSTRUCTION_PATCHED */
    { 0x01b37a,   9, 0x019040,  14,     1502 }, /* VWRN_CSAM_PAGE_NOT_FOUND */
    { 0x013bcd,  20, 0x007424,  41,     1503 }, /* VINF_CSAM_PENDING_ACTION */
    { 0x01ae79,  10, 0x00f211,  26,     1613 }, /* VINF_PGM_SYNC_CR3 */
    { 0x013117,  21, 0x00ac15,  33,     1614 }, /* VINF_PGM_NO_DIRTY_BIT_TRACKING */
    { 0x010274,  25, 0x004f02,  49,     1615 }, /* VINF_PGM_HANDLED_DIRTY_BIT_FAULT */
    { 0x014783,  20, 0x00bddf,  31,     1616 }, /* VINF_PGM_HANDLER_DO_DEFAULT */
    { 0x0198a4,  13, 0x00f315,  26,     1622 }, /* VINF_PGM_CACHED_PAGE */
    { 0x017529,  16, 0x000118, 133,     1623 }, /* VINF_PGM_GCPHYS_ALIASED */
    { 0x0118e9,  23, 0x011499,  23,     1625 }, /* VINF_PGM_SYNCPAGE_MODIFIED_PDE */
    { 0x011ded,  22, 0x008be6,  38,     1635 }, /* VINF_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x0159ff,  18, 0x00d9b6,  28,     1643 }, /* VINF_PGM_HANDLER_ALREADY_ALIASED */
    { 0x013a8d,  20, 0x007e9a,  40,     1644 }, /* VINF_PGM_POOL_FLUSH_PENDING */
    { 0x0164b5,  17, 0x00b724,  32,     1758 }, /* VINF_CPUM_R3_MSR_READ */
    { 0x016089,  18, 0x00aa05,  33,     1759 }, /* VINF_CPUM_R3_MSR_WRITE */
    { 0x01157f,  23, 0x0055c9,  47,     1766 }, /* VINF_CPUM_HOST_CR0_MODIFIED */
    { 0x012ab1,  21, 0x009a7c,  35,     1769 }, /* VINF_CPUM_MATCHED_BY_NAME */
    { 0x01192e,  23, 0x01557d,  19,     1851 }, /* VINF_SSM_VOTE_FOR_ANOTHER_PASS */
    { 0x00edb1,  27, 0x0045cd,  51,     1852 }, /* VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN */
    { 0x016a9e,  17, 0x009e50,  35,     1854 }, /* VINF_SSM_DONT_CALL_AGAIN */
    { 0x017b59,  16, 0x002cb7,  59,     1864 }, /* VINF_SSM_LIVE_SUSPENDED */
    { 0x01a116,  12, 0x00ea51,  27,     2008 }, /* VWRN_VRDP_PDU_NOT_SUPPORTED */
    { 0x016c69,  17, 0x00541f,  48,     2009 }, /* VINF_VRDP_PROCESS_PDU */
    { 0x0104cc,  25, 0x00b124,  32,     2010 }, /* VINF_VRDP_OPERATION_COMPLETED */
    { 0x013a01,  20, 0x00a2c4,  34,     2011 }, /* VINF_VRDP_THREAD_STARTED */
    { 0x012709,  22, 0x003d35,  54,     2012 }, /* VINF_VRDP_RESIZE_REQUESTED */
    { 0x014bd7,  19, 0x00cf1d,  29,     2013 }, /* VINF_VRDP_OUTPUT_ENABLE */
    { 0x019158,  14, 0x009764,  36,     2503 }, /* VINF_SELM_SYNC_GDT */
    { 0x017849,  16, 0x0102f1,  25,     2615 }, /* VINF_IOM_MMIO_UNUSED_00 */
    { 0x017889,  16, 0x01036e,  25,     2616 }, /* VINF_IOM_MMIO_UNUSED_FF */
    { 0x014a6e,  19, 0x01351c,  21,     2620 }, /* VINF_IOM_R3_IOPORT_READ */
    { 0x014568,  20, 0x01215d,  22,     2621 }, /* VINF_IOM_R3_IOPORT_WRITE */
    { 0x00ea36,  27, 0x00c6ee,  30,     2622 }, /* VINF_IOM_R3_IOPORT_COMMIT_WRITE */
    { 0x013c1d,  14, 0x0190da,  14,     2623 }, /* VINF_IOM_R3_MMIO_READ */
    { 0x017f7e,  15, 0x018005,  15,     2624 }, /* VINF_IOM_R3_MMIO_WRITE */
    { 0x013c1d,  20, 0x0145cc,  20,     2625 }, /* VINF_IOM_R3_MMIO_READ_WRITE */
    { 0x01248b,  22, 0x011945,  23,     2626 }, /* VINF_IOM_R3_MMIO_COMMIT_WRITE */
    { 0x016f5a,  16, 0x00c694,  30,     2712 }, /* VINF_VMM_CALL_TRACER */
    { 0x01737a,  16, 0x0136ea,  21,     2714 }, /* VINF_VMM_UNKNOWN_RING3_CALL */
    { 0x01b299,   9, 0x0107c6,  24,     2824 }, /* VINF_PDM_ALREADY_LOADED */
    { 0x00f992,  25, 0x004896,  50,     2846 }, /* VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x00e928,  27, 0x016a49,  17,     2898 }, /* VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS */
    { 0x013681,  21, 0x009cac,  35,     2901 }, /* VINF_HGCM_CLIENT_REJECTED */
    { 0x0148f2,  19, 0x0072d7,  42,     2903 }, /* VINF_HGCM_ASYNC_EXECUTE */
    { 0x01a4a6,  12, 0x013f79,  20,     2906 }, /* VINF_HGCM_SAVE_STATE */
    { 0x01366c,  21, 0x00e6d6,  27,     3209 }, /* VINF_VD_ASYNC_IO_FINISHED */
    { 0x0146bb,  20, 0x0036d1,  56,     3283 }, /* VINF_VD_NEW_ZEROED_BLOCK */
    { 0x0115f2,  23, 0x00cfe8,  29,     3501 }, /* VINF_VGA_RESIZE_IN_PROGRESS */
    { 0x00ff86,  25, 0x0014f0,  70,     3746 }, /* VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x00c496,  30, 0x00d866,  28,     3827 }, /* VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED */
    { 0x0196c3,  13, 0x00bbf0,  31,     3901 }, /* VINF_GVM_NOT_BLOCKED */
    { 0x0173ca,  16, 0x00722f,  42,     3902 }, /* VINF_GVM_NOT_BUSY_IN_GC */
    { 0x01a37a,  12, 0x00432d,  52,     3903 }, /* VINF_GVM_YIELDED */
    { 0x01b69d,   8, 0x00df82,  28,     4033 }, /* VINF_VMX_VMEXIT */
    { 0x014b52,  19, 0x002c41,  59,     4035 }, /* VINF_VMX_INTERCEPT_NOT_ACTIVE */
    { 0x0153b5,  19, 0x000b12,  82,     4036 }, /* VINF_VMX_MODIFIES_BEHAVIOR */
    { 0x0154bf,  19, 0x003467,  57,     4037 }, /* VINF_VMX_VMLAUNCH_VMRESUME */
    { 0x01aa9c,  11, 0x00a89a,  33,     4067 }, /* VINF_SVM_VMEXIT */
    { 0x01b170,  10, 0x001b0b,  66,     4068 }, /* VINF_SVM_VMRUN */
    { 0x0128c1,  22, 0x002dde,  59,     4069 }, /* VINF_SVM_INTERCEPT_NOT_ACTIVE */
    { 0x01732a,  16, 0x004e3e,  49,     4117 }, /* VINF_HM_DOUBLE_FAULT */
    { 0x017bc8,  16, 0x00861b,  39,     4118 }, /* VINF_HM_PENDING_XCPT */
    { 0x0136d5,  21, 0x015862,  18,     4400 }, /* VINF_PARAV_SWITCH_TO_HOST */
    { 0x0169e3,  17, 0x004052,  53,     4500 }, /* VINF_VHWA_CMD_PENDING */
    { 0x016c14,  17, 0x002aa4,  59,     4800 }, /* VINF_AIO_TASK_PENDING */
    { 0x016b6a,  17, 0x00057c,  97,     5150 }, /* VINF_PCI_MAPPING_DONE */
    { 0x018eb8,  14, 0x00110a,  72,     5305 }, /* VINF_IEM_SELECTOR_NOT_OK */
    { 0x015e5b,  18, 0x0041f5,  52,     5306 }, /* VINF_IEM_YIELD_PENDING_FF */
    { 0x0165c5,  14, 0x003c93,  54,     5310 }, /* VINF_IEM_REEXEC_BREAK */
    { 0x0165c5,  17, 0x004087,  53,     5311 }, /* VINF_IEM_REEXEC_BREAK_FF */
    { 0x00f653,  26, 0x000e26,  76,     5312 }, /* VINF_IEM_REEXEC_FINISH_WITH_FLAGS */
    { 0x019c18,  13, 0x007259,  42,     5313 }, /* VINF_IEM_REEXEC_JUMP */
    { 0x015ae9,  18, 0x008e66,  37,     5319 }, /* VINF_IEM_RECOMPILE_END_TB */
    { 0x01965b,  13, 0x012223,  22,     5401 }, /* VWRN_DBGC_CMD_PENDING */
    { 0x019815,  13, 0x011900,  23,     5402 }, /* VWRN_DBGC_ALREADY_REGISTERED */
    { 0x019412,  13, 0x018b46,  14,     5406 }, /* VINF_DBGC_BP_NO_COMMAND */
    { 0x019f42,  12, 0x010fbe,  24,     5699 }, /* VINF_SUP_DRIVERLESS */
    { 0x00ea00,  27, 0x007f3a,  40,     6220 }, /* VWRN_GSTCTL_OBJECTSTATE_CHANGED */
    { 0x016383,  17, 0x0079bf,  41,     6316 }, /* VINF_GIM_R3_HYPERCALL */
    { 0x0100fd,  25, 0x0037b0,  55,     6317 }, /* VINF_GIM_HYPERCALL_CONTINUING */
    { 0x00f44d,  26, 0x011734,  23,     6605 }, /* VINF_AUDIO_MORE_DATA_AVAILABLE */
    { 0x00bbd1,  31, 0x000296, 121,     6609 }, /* VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED */
    { 0x019f72,  12, 0x00d76a,  28,     6810 }, /* VINF_NEM_FLUSH_TLB */
    { 0x010f8e,  24, 0x00b0a4,  32,     6906 }, /* VINF_RECORDING_LIMIT_REACHED */
    { 0x013e61,  20, 0x006416,  44,     6907 }, /* VINF_RECORDING_THROTTLED */
    { 0x013fb5,  20, 0x01654e,  17,     6908 }, /* VWRN_RECORDING_ENCODING_SKIPPED */
    { 0x017969,  16, 0x0015c0,  69,     7200 }, /* VINF_PDM_PCI_DO_DEFAULT */
    { 0x00d66e,  28, 0x003311,  57,     7311 }, /* VINF_IOMMU_ADDR_TRANSLATION_DISABLED */
    { 0x010976,  12, 0x00220e,  63,     7600 }, /* VINF_GCM_HANDLED */
    { 0x010976,  24, 0x0038fa,  55,     7601 }, /* VINF_GCM_HANDLED_ADVANCE_RIP */
    { 0x019967,  13, 0x004534,  51,    22301 }, /* VINF_LOG_DISABLED */
    { 0x01a0da,  12, 0x016df0,  17,    22302 }, /* VINF_LOG_NO_LOGGER */
    { 0x0163c7,  17, 0x01653d,  17,    22401 }, /* VINF_BUFFER_UNDERFLOW */
    { 0x0154e5,  19, 0x008b9a,  38,    22405 }, /* VINF_ACCOUNT_RESTRICTED */
    { 0x00bf15,  31, 0x0060c7,  45,    22406 }, /* VWRN_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x01ba1c,   8, 0x01a63a,  11,    22409 }, /* VWRN_WRONG_TYPE */
    { 0x012239,  22, 0x000969,  88,    22424 }, /* VINF_THREAD_IS_TERMINATING */
    { 0x0173ba,  16, 0x00e283,  27,    22426 }, /* VWRN_FLOAT_UNDERFLOW */
    { 0x017d81,  15, 0x00f978,  26,    22427 }, /* VWRN_FLOAT_OVERFLOW */
    { 0x0190cc,  14, 0x016bf2,  17,    22428 }, /* VINF_REBOOT_NEEDED */
    { 0x015c3f,  18, 0x001b8e,  65,    22501 }, /* VINF_SYS_MAY_POWER_OFF */
    { 0x01a7dc,  11, 0x00eabd,  27,    22821 }, /* VINF_ASN1_MORE_DATA */
    { 0x01ad93,  10, 0x0006f7,  91,    22822 }, /* VINF_ASN1_NOT_ENCODED */
    { 0x01b290,   9, 0x003099,  58,    22900 }, /* VINF_LDRVI_NOT_SIGNED */
    { 0x0104e5,  25, 0x00ae64,  32,    23109 }, /* VINF_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x01525f,  19, 0x017b39,  16,    23814 }, /* VINF_CR_KEY_WAS_DECRYPTED */
    { 0x0196d0,  13, 0x015db9,  18,    24202 }, /* VINF_CR_DIGEST_DEPRECATED */
    { 0x018c7a,  14, 0x014b78,  19,    24203 }, /* VINF_CR_DIGEST_COMPROMISED */
    { 0x011271,  23, 0x00d58e,  28,    24204 }, /* VINF_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x0107de,  24, 0x0041c1,  52,    25007 }, /* VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x00eb7a,  27, 0x0183e3,  15,    25704 }, /* VWRN_REST_UNABLE_TO_DECODE_DATE */
};

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStatusMsgStrTab[] =
{
/* 0x00000 = "Hit a possible assertion in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','p','o','s','s','i','b','l','e',' ','a','s','s','e','r','t','i','o','n',' ','\x0f','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','t','h','i','s',' ','\x0a','\x02','d','e','b','u','g','g','e','r',',',' ','\x9a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x0008e = "Process Verification Failure: Image mapping is bogus as the first region has different AllocationBase and BaseAddress values, indicating that a section was unmapped or otherwise tampered with." */
    '\x1e','\x0d','\x12','I','m','a','g','e',' ','m','a','p','p','i','n','g',' ','\x0b','b','o','g','u','s',' ','a','s',' ','\x02','f','i','r','s','t',' ','r','e','g','i','o','n',' ','\x5c','d','i','f','f','e','r','e','n','t',' ','A','l','l','o','c','a','t','i','o','n','B','a','s','e',' ','\x9a','B','a','s','e','A','d','d','r','e','s','s',' ','v','a','l','u','e','s',',',' ','i','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','\xdd','\x11','u','n','m','a','p','p','e','d',' ','\xa9','o','t','h','e','r','w','i','s','e',' ','t','a','m','p','e','r','e','d',' ','w','i','t','h','.',
/* 0x00118 = "Returned by handler registration, modification and deregistration when the shadow PTs could be updated because the guest page aliased or/and mapped by multiple PTs." */
    'R','e','t','u','r','n','e','d',' ','\xdb','h','a','n','d','l','e','r',' ','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x9a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',' ','w','h','e','n',' ','\x02','s','h','a','d','o','w',' ','P','T','s',' ','c','o','u','l','d',' ','\xa4','u','p','d','a','t','e','d',' ','\x2a','\x02','\xbb','\xbe','a','l','i','a','s','e','d',' ','o','r','/','a','n','d',' ','m','a','p','p','e','d',' ','\xdb','m','u','l','t','i','p','l','e',' ','P','T','s','.',
/* 0x0019d = "Process Purification Failure: NtAllocateVirtualMemory failed to get us suitable replacement memory for a chunk of executable memory that shouldn\'t be present in our process." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','A','l','l','o','c','a','t','e','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x99','\x0a','g','e','t',' ','u','s',' ','s','u','i','t','a','b','l','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','\x86','\x10','a',' ','c','h','u','n','k',' ','\x15','e','x','e','c','u','t','a','b','l','e',' ','\x86','\xad','s','h','o','u','l','d','n','\'','t',' ','\xa4','p','r','e','s','e','n','t',' ','\x0f','o','u','r',' ','p','r','o','c','e','s','s','.',
/* 0x0021a = "Hit a breakpoint in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','\xc0','\x0f','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','t','h','i','s',' ','\x0a','\x02','d','e','b','u','g','g','e','r',',',' ','\x9a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x00296 = "Special PDMIHOSTAUDIO::pfnStreamCreate return value for triggering calling of PDMIHOSTAUDIO::pfnStreamInitAsync on a worker thread." */
    'S','p','e','c','i','a','l',' ','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','C','r','e','a','t','e',' ','r','e','t','u','r','n',' ','\xf5','\x10','t','r','i','g','g','e','r','i','n','g',' ','c','a','l','l','i','n','g',' ','\x15','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','I','n','i','t','A','s','y','n','c',' ','o','n',' ','a',' ','w','o','r','k','e','r',' ','t','h','r','e','a','d','.',
/* 0x0030f = "An attempt on detaching a driver without anyone actually being attached, or performing any other operation on an attached driver." */
    'A','n',' ','a','t','t','e','m','p','t',' ','o','n',' ','d','e','t','a','c','h','i','n','g',' ','a',' ','\xc7','w','i','t','h','o','u','t',' ','a','n','y','o','n','e',' ','a','c','t','u','a','l','l','y',' ','b','e','i','n','g',' ','a','t','t','a','c','h','e','d',',',' ','\xa9','p','e','r','f','o','r','m','i','n','g',' ','a','n','y',' ','o','t','h','e','r',' ','\x96','o','n',' ','\x87','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x0037d = "Process Purification Failure: Both NtUnmapViewOfSetion and NtProtectVirtualMemory failed to get rid of or passify an non-image executable mapping." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','B','o','t','h',' ','N','t','U','n','m','a','p','V','i','e','w','O','f','S','e','t','i','o','n',' ','\x9a','N','t','P','r','o','t','e','c','t','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x99','\x0a','g','e','t',' ','r','i','d',' ','\x15','\xa9','p','a','s','s','i','f','y',' ','\x87','n','o','n','-','\x26','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','i','n','g','.',
/* 0x003ea = "Process does not have the trusted code base (TCB) privilege needed for user authentication or/and process creation as a given user." */
    '\x1e','\xb2','\x07','h','a','v','e',' ','\x02','t','r','u','s','t','e','d',' ','c','o','d','e',' ','b','a','s','e',' ','(','T','C','B',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','u','s','e','r',' ','a','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','o','r','/','a','n','d',' ','\x92','c','r','e','a','t','i','o','n',' ','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00452 = "Indicating that the VM has executed a halt instruction and that the emulation thread should wait for an interrupt before resuming execution." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','\x5c','e','x','e','c','u','t','e','d',' ','a',' ','h','a','l','t',' ','\xdc','\x9a','\xad','\x02','e','m','u','l','a','t','i','o','n',' ','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','w','a','i','t',' ','\x10','\x87','i','n','t','e','r','r','u','p','t',' ','b','e','f','o','r','e',' ','r','e','s','u','m','i','n','g',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x004b9 = "The reservation or reservation update was declined - too many VMs, too little memory, and/or too low GMM configuration." */
    '\x03','r','e','s','e','r','v','a','t','i','o','n',' ','\xa9','r','e','s','e','r','v','a','t','i','o','n',' ','u','p','d','a','t','e',' ','\x11','d','e','c','l','i','n','e','d',' ','-',' ','\x9e','\xb5','V','M','s',',',' ','\x9e','l','i','t','t','l','e',' ','m','e','m','o','r','y',',',' ','a','n','d','/','o','r',' ','\x9e','l','o','w',' ','G','M','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0051b = "The VM process was denied access to vboxdrv because someone have managed to open the process or its main thread with too broad access rights." */
    '\x03','\xc6',' ','\x92','\x11','d','e','n','i','e','d',' ','a','c','c','e','s','s',' ','\x0a','v','b','o','x','d','r','v',' ','\x2a','s','o','m','e','o','n','e',' ','h','a','v','e',' ','m','a','n','a','g','e','d',' ','\x0a','o','p','e','n',' ','\x02','\x92','\xa9','i','t','s',' ','m','a','i','n',' ','t','h','r','e','a','d',' ','\x7f','\x9e','b','r','o','a','d',' ','a','c','c','e','s','s',' ','r','i','g','h','t','s','.',
/* 0x0057c = "Special return code from a PCI I/O region mapping handler that tells the BUS that it has done the mapping already." */
    'S','p','e','c','i','a','l',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','f','r','o','m',' ','a',' ','P','C','I',' ','I','/','O',' ','r','e','g','i','o','n',' ','m','a','p','p','i','n','g',' ','h','a','n','d','l','e','r',' ','\xad','t','e','l','l','s',' ','\x02','B','U','S',' ','\xad','i','t',' ','\x5c','d','o','n','e',' ','\x02','m','a','p','p','i','n','g',' ','a','l','r','e','a','d','y','.',
/* 0x005dd = "Unable to translate all the variables in the default environment due to codeset issues (LANG / LC_ALL / LC_CTYPE)." */
    '\xe1','\x0a','t','r','a','n','s','l','a','t','e',' ','a','l','l',' ','\x02','v','a','r','i','a','b','l','e','s',' ','\x0f','\x02','d','e','f','a','u','l','t',' ','e','n','v','i','r','o','n','m','e','n','t',' ','d','u','e',' ','\x0a','c','o','d','e','s','e','t',' ','i','s','s','u','e','s',' ','(','L','A','N','G',' ','/',' ','L','C','_','A','L','L',' ','/',' ','L','C','_','C','T','Y','P','E',')','.',
/* 0x0063d = "The image is required to be signed with the same certificate as the rest of VirtualBox or one of the special trusted (Oracle) certificates." */
    '\x03','\x26','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','\xa4','s','i','g','n','e','d',' ','\x7f','\x02','s','a','m','e',' ','\xa0','a','s',' ','\x02','r','e','s','t',' ','\x15','V','i','r','t','u','a','l','B','o','x',' ','\xa9','o','n','e',' ','\x15','\x02','s','p','e','c','i','a','l',' ','t','r','u','s','t','e','d',' ','(','O','r','a','c','l','e',')',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0069c = "Returned by a breakpoint callback when guest execution should be suspended and the VM should be dropped into the debugger." */
    'R','e','t','u','r','n','e','d',' ','\xdb','a',' ','\xc0','c','a','l','l','b','a','c','k',' ','w','h','e','n',' ','\xbb','e','x','e','c','u','t','i','o','n',' ','s','h','o','u','l','d',' ','\xa4','s','u','s','p','e','n','d','e','d',' ','\x9a','\x02','\xc6',' ','s','h','o','u','l','d',' ','\xa4','d','r','o','p','p','e','d',' ','i','n','t','o',' ','\x02','d','e','b','u','g','g','e','r','.',
/* 0x006f7 = "RTAsnEncodeWriteHeader return code indicating that nothing was written and the content should be skipped as well." */
    'R','T','A','s','n','E','n','c','o','d','e','W','r','i','t','e','H','e','a','d','e','r',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','i','n','d','i','c','a','t','i','n','g',' ','\xad','n','o','t','h','i','n','g',' ','\x11','w','r','i','t','t','e','n',' ','\x9a','\x02','\xf0','s','h','o','u','l','d',' ','\xa4','s','k','i','p','p','e','d',' ','a','s',' ','w','e','l','l','.',
/* 0x00752 = "Indicating that a breakpoint was hit and that EM should notify the debugger and in the event there is no debugger fail fatally." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','\xc0','\x11','h','i','t',' ','\x9a','\xad','E','M',' ','s','h','o','u','l','d',' ','n','o','t','i','f','y',' ','\x02','d','e','b','u','g','g','e','r',' ','\x9a','\x0f','\x02','e','v','e','n','t',' ','t','h','e','r','e',' ','\x0b','n','o',' ','d','e','b','u','g','g','e','r',' ','f','a','i','l',' ','f','a','t','a','l','l','y','.',
/* 0x007ac = "Indicating that we\'ve got an out-of-memory condition and that we need to take the appropriate actions to deal with this." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','w','e','\'','v','e',' ','g','o','t',' ','\x87','o','u','t','-','o','f','-','\x86','c','o','n','d','i','t','i','o','n',' ','\x9a','\xad','w','e',' ','n','e','e','d',' ','\x0a','t','a','k','e',' ','\x02','a','p','p','r','o','p','r','i','a','t','e',' ','a','c','t','i','o','n','s',' ','\x0a','d','e','a','l',' ','\x7f','t','h','i','s','.',
/* 0x00806 = "Process Purification Failure: NtFreeVirtualMemory failed on a chunk of executable memory which shouldn\'t be present in the process." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','F','r','e','e','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x99','o','n',' ','a',' ','c','h','u','n','k',' ','\x15','e','x','e','c','u','t','a','b','l','e',' ','\x86','\xed','s','h','o','u','l','d','n','\'','t',' ','\xa4','p','r','e','s','e','n','t',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x00860 = "A boot catalog extension entry in the import ISO indicates more entries when we reached the end of the boot catalog sector." */
    'A',' ','b','o','o','t',' ','\xe7','e','x','t','e','n','s','i','o','n',' ','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','i','n','d','i','c','a','t','e','s',' ','m','o','r','e',' ','e','n','t','r','i','e','s',' ','w','h','e','n',' ','w','e',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','b','o','o','t',' ','\xe7','s','e','c','t','o','r','.',
/* 0x008b9 = "If a Host Interface Networking filehandle was specified it\'s not allowed to have any init or term programs." */
    'I','f',' ','a',' ','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','f','i','l','e','h','a','n','d','l','e',' ','\x11','\x18','i','t','\'','s',' ','\x07','a','l','l','o','w','e','d',' ','\x0a','h','a','v','e',' ','a','n','y',' ','i','n','i','t',' ','\xa9','t','e','r','m',' ','p','r','o','g','r','a','m','s','.',
/* 0x00911 = "A boot catalog entry in the import ISO sets the continuation flag when using NONE as the selection criteria type." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','w','h','e','n',' ','u','s','i','n','g',' ','N','O','N','E',' ','a','s',' ','\x02','s','e','l','e','c','t','i','o','n',' ','c','r','i','t','e','r','i','a',' ','t','y','p','e','.',
/* 0x00969 = "Returned by RTThreadQueryTerminationStatus to indicate that the thread is (or should be) terminating." */
    'R','e','t','u','r','n','e','d',' ','\xdb','R','T','T','h','r','e','a','d','Q','u','e','r','y','T','e','r','m','i','n','a','t','i','o','n','S','t','a','t','u','s',' ','\x0a','i','n','d','i','c','a','t','e',' ','\xad','\x02','t','h','r','e','a','d',' ','\x0b','(','o','r',' ','s','h','o','u','l','d',' ','b','e',')',' ','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x009c1 = "Returned by callback methods which does not need to be called again because the client does not actually make use of them." */
    'R','e','t','u','r','n','e','d',' ','\xdb','c','a','l','l','b','a','c','k',' ','m','e','t','h','o','d','s',' ','\xed','\xb2','\x07','n','e','e','d',' ','\x0a','\xa4','c','a','l','l','e','d',' ','a','g','a','i','n',' ','\x2a','\x02','c','l','i','e','n','t',' ','\xb2','\x07','a','c','t','u','a','l','l','y',' ','m','a','k','e',' ','u','s','e',' ','\x15','t','h','e','m','.',
/* 0x00a16 = "Indicating that the VM is being turned off and that the EM should exit to the VM awaiting the destruction request." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','\x0b','b','e','i','n','g',' ','t','u','r','n','e','d',' ','o','f','f',' ','\x9a','\xad','\x02','E','M',' ','s','h','o','u','l','d',' ','e','x','i','t',' ','\x0a','\x02','\xc6',' ','a','w','a','i','t','i','n','g',' ','\x02','d','e','s','t','r','u','c','t','i','o','n',' ','r','e','q','u','e','s','t','.',
/* 0x00a6b = "The DTB being parsed has no terminating memory reservation block entry before the start of the structs block." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','n','o',' ','t','e','r','m','i','n','a','t','i','n','g',' ','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','\xca','b','e','f','o','r','e',' ','\x02','s','t','a','r','t',' ','\x15','\x02','s','t','r','u','c','t','s',' ','b','l','o','c','k','.',
/* 0x00abf = "A number tar header field was encoded using base-256 which this tar implementation currently does not support." */
    'A',' ','\xfc','t','a','r',' ','\xb4','f','i','e','l','d',' ','\x11','e','n','c','o','d','e','d',' ','u','s','i','n','g',' ','b','a','s','e','-','2','5','6',' ','\xed','t','h','i','s',' ','t','a','r',' ','i','m','p','l','e','m','e','n','t','a','t','i','o','n',' ','c','u','r','r','e','n','t','l','y',' ','\xb2','\x07','s','u','p','p','o','r','t','.',
/* 0x00b12 = "The behavior of the instruction/operation is modified/needs modification in VMX non-root mode." */
    '\x03','b','e','h','a','v','i','o','r',' ','\x15','\x02','i','n','s','t','r','u','c','t','i','o','n','/','o','p','e','r','a','t','i','o','n',' ','\x0b','m','o','d','i','f','i','e','d','/','n','e','e','d','s',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x0f','V','M','X',' ','n','o','n','-','r','o','o','t',' ','m','o','d','e','.',
/* 0x00b64 = "Indicating that the VM should be suspended for debugging because the developer wants to inspect the VM state." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','s','h','o','u','l','d',' ','\xa4','s','u','s','p','e','n','d','e','d',' ','\x10','d','e','b','u','g','g','i','n','g',' ','\x2a','\x02','d','e','v','e','l','o','p','e','r',' ','w','a','n','t','s',' ','\x0a','i','n','s','p','e','c','t',' ','\x02','\xc6',' ','s','t','a','t','e','.',
/* 0x00bb4 = "A boot catalog entry in the import ISO sets the continuation flag when we reached the ned of the boot catalog secotr." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','w','h','e','n',' ','w','e',' ','r','e','a','c','h','e','d',' ','\x02','n','e','d',' ','\x15','\x02','b','o','o','t',' ','\xe7','s','e','c','o','t','r','.',
/* 0x00c04 = "Process does not have the assign primary token (APT) privilege needed for creating process as a given user." */
    '\x1e','\xb2','\x07','h','a','v','e',' ','\x02','a','s','s','i','g','n',' ','p','r','i','m','a','r','y',' ','t','o','k','e','n',' ','(','A','P','T',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','c','r','e','a','t','i','n','g',' ','\x92','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00c54 = "VFS chain only has a single element and it is just a path, need to be treated as a normal file system request." */
    '\x8d',' ','\xa1','o','n','l','y',' ','\x5c','a',' ','s','i','n','g','l','e',' ','\x5e','\x9a','i','t',' ','\x0b','j','u','s','t',' ','a',' ','p','a','t','h',',',' ','n','e','e','d',' ','\x0a','\xa4','t','r','e','a','t','e','d',' ','a','s',' ','a',' ','n','o','r','m','a','l',' ','\x22','s','y','s','t','e','m',' ','r','e','q','u','e','s','t','.',
/* 0x00ca4 = "RC is toasted and the VMM should be terminated at once, but no need to panic about it :-)." */
    'R','C',' ','\x0b','t','o','a','s','t','e','d',' ','\x9a','\x02','V','M','M',' ','s','h','o','u','l','d',' ','\xa4','t','e','r','m','i','n','a','t','e','d',' ','a','t',' ','o','n','c','e',',',' ','b','u','t',' ','n','o',' ','n','e','e','d',' ','\x0a','p','a','n','i','c',' ','a','b','o','u','t',' ','i','t',' ',':','-',')','.',
/* 0x00cf2 = "A boot catalog extension entry in the import ISO was either flagged incorrectly in the previous entry or has an invalid header ID." */
    'A',' ','b','o','o','t',' ','\xe7','e','x','t','e','n','s','i','o','n',' ','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x11','e','i','t','h','e','r',' ','f','l','a','g','g','e','d',' ','i','n','c','o','r','r','e','c','t','l','y',' ','\x0f','\x02','p','r','e','v','i','o','u','s',' ','\xca','\xa9','\x5c','\x87','\x8f','\xb4','I','D','.',
/* 0x00d40 = "A field contained an transformation that should only be used when loading old states." */
    'A',' ','f','i','e','l','d',' ','c','o','n','t','a','i','n','e','d',' ','\x87','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','\xad','s','h','o','u','l','d',' ','o','n','l','y',' ','\xa4','u','s','e','d',' ','w','h','e','n',' ','l','o','a','d','i','n','g',' ','o','l','d',' ','s','t','a','t','e','s','.',
/* 0x00d8d = "Physical range crosses dynamic ram chunk boundary; translation to HC ptr not safe." */
    'P','h','y','s','i','c','a','l',' ','r','a','n','g','e',' ','c','r','o','s','s','e','s',' ','d','y','n','a','m','i','c',' ','r','a','m',' ','c','h','u','n','k',' ','b','o','u','n','d','a','r','y',';',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x0a','H','C',' ','p','t','r',' ','\x07','s','a','f','e','.',
/* 0x00dda = "Indicating that the VM has been suspended and that the thread should wait for request telling it what to do next." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','\x5c','\xcd','s','u','s','p','e','n','d','e','d',' ','\x9a','\xad','\x02','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','w','a','i','t',' ','\x10','\xab','t','e','l','l','i','n','g',' ','i','t',' ','w','h','a','t',' ','\x0a','d','o',' ','n','e','x','t','.',
/* 0x00e26 = "Recompiled execution: Debug related (hidden) EFLAGS are set and needs handling." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','D','e','b','u','g',' ','r','e','l','a','t','e','d',' ','(','h','i','d','d','e','n',')',' ','E','F','L','A','G','S',' ','a','r','e',' ','s','e','t',' ','\x9a','n','e','e','d','s',' ','h','a','n','d','l','i','n','g','.',
/* 0x00e72 = "Process does not have the increase quota (IQ) privilege needed for creating a process as a given user." */
    '\x1e','\xb2','\x07','h','a','v','e',' ','\x02','i','n','c','r','e','a','s','e',' ','q','u','o','t','a',' ','(','I','Q',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','c','r','e','a','t','i','n','g',' ','a',' ','\x92','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00ebd = "The ELF image is \'executable\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x26','\x0b','\'','e','x','e','c','u','t','a','b','l','e','\'',',',' ','\x02','E','L','F',' ','\xda','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x7f','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x00f07 = "CPUMR3DisasmInstrCPU unexpectedly failed to determine the hidden parts of the CS register." */
    'C','P','U','M','R','3','D','i','s','a','s','m','I','n','s','t','r','C','P','U',' ','u','n','e','x','p','e','c','t','e','d','l','y',' ','\x99','\x0a','d','e','t','e','r','m','i','n','e',' ','\x02','h','i','d','d','e','n',' ','p','a','r','t','s',' ','\x15','\x02','C','S',' ','r','e','g','i','s','t','e','r','.',
/* 0x00f51 = "UDF file cannot be import as it has discontiguous allocation descriptors or is a sparse file." */
    'U','D','F',' ','\x22','\xcf','\xa4','i','m','p','o','r','t',' ','a','s',' ','i','t',' ','\x5c','d','i','s','c','o','n','t','i','g','u','o','u','s',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\xa9','\x0b','a',' ','s','p','a','r','s','e',' ','f','i','l','e','.',
/* 0x00f9b = "IOMMU instance cannot call itself (for remapping interrupts or translating addresses)." */
    '\xfe',' ','i','n','s','t','a','n','c','e',' ','\xcf','c','a','l','l',' ','i','t','s','e','l','f',' ','(','f','o','r',' ','r','e','m','a','p','p','i','n','g',' ','i','n','t','e','r','r','u','p','t','s',' ','\xa9','t','r','a','n','s','l','a','t','i','n','g',' ','a','d','d','r','e','s','s','e','s',')','.',
/* 0x00fe5 = "Process Verification Failure: Expected the process and exe to have forced integrity checking enabled (verifying signatures)." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x9a','e','x','e',' ','\x0a','h','a','v','e',' ','f','o','r','c','e','d',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','i','n','g',' ','e','n','a','b','l','e','d',' ','(','v','e','r','i','f','y','i','n','g',' ','s','i','g','n','a','t','u','r','e','s',')','.',
/* 0x0102f = "Stub process thread not found during revalidation upon vboxdrv opening by the VM process." */
    'S','t','u','b',' ','\x92','t','h','r','e','a','d',' ','\x07','f','o','u','n','d',' ','d','u','r','i','n','g',' ','r','e','v','a','l','i','d','a','t','i','o','n',' ','u','p','o','n',' ','v','b','o','x','d','r','v',' ','o','p','e','n','i','n','g',' ','\xdb','\x02','\xc6',' ','p','r','o','c','e','s','s','.',
/* 0x01078 = "Encountered unicode code point which is reserved for use as endian indicator (0xffff or 0xfffe)." */
    '\xa6','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xed','\x0b','r','e','s','e','r','v','e','d',' ','\x10','u','s','e',' ','a','s',' ','e','n','d','i','a','n',' ','i','n','d','i','c','a','t','o','r',' ','(','0','x','f','f','f','f',' ','\xa9','0','x','f','f','f','e',')','.',
/* 0x010c1 = "The port being read was not present(/unused) and IOM shall return ~0 according to size." */
    '\x03','p','o','r','t',' ','b','e','i','n','g',' ','r','e','a','d',' ','\x11','\x07','p','r','e','s','e','n','t','(','/','u','n','u','s','e','d',')',' ','\x9a','I','O','M',' ','s','h','a','l','l',' ','r','e','t','u','r','n',' ','~','0',' ','a','c','c','o','r','d','i','n','g',' ','\x0a','s','i','z','e','.',
/* 0x0110a = "Internal status code for indicating that a selector isn\'t valid (LAR, LSL, VERR, VERW)." */
    '\x08','s','t','a','t','u','s',' ','c','o','d','e',' ','\x10','i','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','s','e','l','e','c','t','o','r',' ','i','s','n','\'','t',' ','v','a','l','i','d',' ','(','L','A','R',',',' ','L','S','L',',',' ','V','E','R','R',',',' ','V','E','R','W',')','.',
/* 0x01152 = "VFS chain element only provides a read-only I/O stream, while the chain requires write access." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','o','n','l','y',' ','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\xa1','r','e','q','u','i','r','e','s',' ','w','r','i','t','e',' ','a','c','c','e','s','s','.',
/* 0x0119a = "Process Verification Failure: Symantec Endpoint Protection must be disabled for the VirtualBox VM processes." */
    '\x1e','\x0d','\x12','S','y','m','a','n','t','e','c',' ','E','n','d','p','o','i','n','t',' ','P','r','o','t','e','c','t','i','o','n',' ','m','u','s','t',' ','\xa4','d','i','s','a','b','l','e','d',' ','\x10','\x02','V','i','r','t','u','a','l','B','o','x',' ','\xc6',' ','p','r','o','c','e','s','s','e','s','.',
/* 0x011e2 = "There is no TLS (thread local storage) available for storing the current thread." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','a','v','a','i','l','a','b','l','e',' ','\x10','s','t','o','r','i','n','g',' ','\x02','c','u','r','r','e','n','t',' ','t','h','r','e','a','d','.',
/* 0x0122a = "Indicating success single stepping and that EM should report that event to the debugger." */
    'I','n','d','i','c','a','t','i','n','g',' ','s','u','c','c','e','s','s',' ','s','i','n','g','l','e',' ','s','t','e','p','p','i','n','g',' ','\x9a','\xad','E','M',' ','s','h','o','u','l','d',' ','r','e','p','o','r','t',' ','\xad','e','v','e','n','t',' ','\x0a','\x02','d','e','b','u','g','g','e','r','.',
/* 0x01272 = "Expected the signed data content to be the object ID of SpcIndirectDataContent, found something else instead." */
    '\xb8','\x02','s','i','g','n','e','d',' ','\x9d','\xf0','\x0a','\xa4','\x02','\xa8','I','D',' ','\x15','S','p','c','I','n','d','i','r','e','c','t','D','a','t','a','C','o','n','t','e','n','t',',',' ','f','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','e','l','s','e',' ','i','n','s','t','e','a','d','.',
/* 0x012ba = "The key was marked as encrypted by no DEK-Info field with the encryption algortihms was found." */
    '\x03','k','e','y',' ','\x11','m','a','r','k','e','d',' ','a','s',' ','e','n','c','r','y','p','t','e','d',' ','\xdb','n','o',' ','D','E','K','-','I','n','f','o',' ','f','i','e','l','d',' ','\x7f','\x02','e','n','c','r','y','p','t','i','o','n',' ','a','l','g','o','r','t','i','h','m','s',' ','\x11','\x89',
/* 0x01301 = "Patch installation refused (patch too complex or unsupported instructions )." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','a','t','i','o','n',' ','r','e','f','u','s','e','d',' ','(','p','a','t','c','h',' ','\x9e','c','o','m','p','l','e','x',' ','\xa9','u','n','s','u','p','p','o','r','t','e','d',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ',')','.',
/* 0x01348 = "The order of elements in the XAR file does not lend it self to expansion from via an I/O stream." */
    '\x03','o','r','d','e','r',' ','\x15','e','l','e','m','e','n','t','s',' ','\x0f','\x02','X','A','R',' ','\x22','\xb2','\x07','l','e','n','d',' ','i','t',' ','s','e','l','f',' ','\x0a','e','x','p','a','n','s','i','o','n',' ','f','r','o','m',' ','v','i','a',' ','\x87','I','/','O',' ','s','t','r','e','a','m','.',
/* 0x0138f = "SMAP enabled, but the AC flag was found to be clear - check the kernel log for details." */
    'S','M','A','P',' ','e','n','a','b','l','e','d',',',' ','b','u','t',' ','\x02','A','C',' ','f','l','a','g',' ','\x11','f','o','u','n','d',' ','\x0a','\xa4','c','l','e','a','r',' ','-',' ','c','h','e','c','k',' ','\x02','k','e','r','n','e','l',' ','l','o','g',' ','\x10','d','e','t','a','i','l','s','.',
/* 0x013d6 = "WinVerifyTrust failed with an unexpected status code when using the catalog-file approach." */
    'W','i','n','V','e','r','i','f','y','T','r','u','s','t',' ','\x99','\x7f','\x87','u','n','e','x','p','e','c','t','e','d',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','w','h','e','n',' ','u','s','i','n','g',' ','\x02','c','a','t','a','l','o','g','-','\x22','a','p','p','r','o','a','c','h','.',
/* 0x0141d = "The ELF image is \'dynamic\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x26','\x0b','\'','d','y','n','a','m','i','c','\'',',',' ','\x02','E','L','F',' ','\xda','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x7f','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x01464 = "Error opening the stub process thread for revalidation when vboxdrv is opened by the VM process." */
    '\xc1','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x92','t','h','r','e','a','d',' ','\x10','r','e','v','a','l','i','d','a','t','i','o','n',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xdb','\x02','\xc6',' ','p','r','o','c','e','s','s','.',
/* 0x014aa = "Reserved for future status code that we wish to OR with VERR_VMX_INVALID_VMCS_PTR and VERR_VMX_INVALID_VMCS_FIELD." */
    'R','e','s','e','r','v','e','d',' ','\x10','f','u','t','u','r','e',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\xad','w','e',' ','w','i','s','h',' ','\x0a','O','R',' ','\x7f','\x01','\xe2','\x05','V','M','C','S','_','P','T','R',' ','\x9a','\x01','\xe2','\x05','V','M','C','S','_','F','I','E','L','D','.',
/* 0x014f0 = "Failed to measure the TSC delta between two CPUs, continue without any TSC-delta." */
    '\x8b','\x0a','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s',',',' ','c','o','n','t','i','n','u','e',' ','w','i','t','h','o','u','t',' ','a','n','y',' ','T','S','C','-','d','e','l','t','a','.',
/* 0x01536 = "The loaded XSAVE component mask is not compatible with the host CPU or/and VM config." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x0b','\x07','c','o','m','p','a','t','i','b','l','e',' ','\x7f','\x02','h','o','s','t',' ','C','P','U',' ','o','r','/','a','n','d',' ','\xc6',' ','c','o','n','f','i','g','.',
/* 0x0157b = "The network already exists with a different security profile (restricted / public)." */
    '\x03','n','e','t','w','o','r','k',' ','\x80','e','x','i','s','t','s',' ','\x7f','a',' ','d','i','f','f','e','r','e','n','t',' ','s','e','c','u','r','i','t','y',' ','p','r','o','f','i','l','e',' ','(','r','e','s','t','r','i','c','t','e','d',' ','/',' ','p','u','b','l','i','c',')','.',
/* 0x015c0 = "Returned by PCI config space callbacks to indicate taking default action." */
    'R','e','t','u','r','n','e','d',' ','\xdb','P','C','I',' ','c','o','n','f','i','g',' ','s','p','a','c','e',' ','c','a','l','l','b','a','c','k','s',' ','\x0a','i','n','d','i','c','a','t','e',' ','t','a','k','i','n','g',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x01605 = "The signature algorithm in the to-be-signed certificate part does not match the one associated with the signature." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\xd5','\x0f','\x02','t','o','-','b','e','-','s','i','g','n','e','d',' ','\xa0','p','a','r','t',' ','\xb2','\x07','m','a','t','c','h',' ','\x02','o','n','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x7f','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0164a = "No RTC device instance is registered with the current VM and thus the RTC or CMOS operation cannot be performed." */
    '\xe0','R','T','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x7f','\x02','c','u','r','r','e','n','t',' ','\xc6',' ','\x9a','t','h','u','s',' ','\x02','R','T','C',' ','\xa9','C','M','O','S',' ','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d','.',
/* 0x0168f = "The alignment is not really supported, however we got lucky with this allocation." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x0b','\x07','r','e','a','l','l','y',' ','s','u','p','p','o','r','t','e','d',',',' ','h','o','w','e','v','e','r',' ','w','e',' ','g','o','t',' ','l','u','c','k','y',' ','\x7f','t','h','i','s',' ','a','l','l','o','c','a','t','i','o','n','.',
/* 0x016d4 = "The shared module clashed address wise with a previously registered module." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','a','d','d','r','e','s','s',' ','w','i','s','e',' ','\x7f','a',' ','p','r','e','v','i','o','u','s','l','y',' ','r','e','g','i','s','t','e','r','e','d',' ','m','o','d','u','l','e','.',
/* 0x01718 = "Signed data verification failed because of missing (or duplicate) authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd8','a','t','t','r','i','b','u','t','e','.',
/* 0x0175c = "Signed data verification failed because of missing (or duplicate) authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf3','a','t','t','r','i','b','u','t','e','.',
/* 0x017a0 = "The I/O queue doesn't contain any prepared requests to commit or wait for completion." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\xc9','c','o','n','t','a','i','n',' ','a','n','y',' ','p','r','e','p','a','r','e','d',' ','r','e','q','u','e','s','t','s',' ','\x0a','c','o','m','m','i','t',' ','\xa9','w','a','i','t',' ','\x10','c','o','m','p','l','e','t','i','o','n','.',
/* 0x017e4 = "The boot catalog in the import ISO is larger than a sector or it is missing the final section header entry." */
    '\x03','b','o','o','t',' ','\xe7','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x0b','l','a','r','g','e','r',' ','t','h','a','n',' ','a',' ','s','e','c','t','o','r',' ','\xa9','i','t',' ','\x0b','m','i','s','s','i','n','g',' ','\x02','f','i','n','a','l',' ','\xdd','\xb4','e','n','t','r','y','.',
/* 0x01828 = "Import ISO contains a multi-extent directory record that differs significantly from first record." */
    '\xc4','\xc2',' ','\x8a','a',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x25','r','e','c','o','r','d',' ','\xad','d','i','f','f','e','r','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','f','r','o','m',' ','f','i','r','s','t',' ','r','e','c','o','r','d','.',
/* 0x0186c = "The request could not be canceled or prepared for another transfer because it is still in progress." */
    '\x03','\xab','c','o','u','l','d',' ','\x07','\xa4','c','a','n','c','e','l','e','d',' ','\xa9','p','r','e','p','a','r','e','d',' ','\x10','a','n','o','t','h','e','r',' ','t','r','a','n','s','f','e','r',' ','\x2a','i','t',' ','\x0b','s','t','i','l','l',' ','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x018b0 = "Remapping denied for the interrupt (might have caused a PCI target abort)." */
    'R','e','m','a','p','p','i','n','g',' ','d','e','n','i','e','d',' ','\x10','\x02','i','n','t','e','r','r','u','p','t',' ','(','m','i','g','h','t',' ','h','a','v','e',' ','c','a','u','s','e','d',' ','a',' ','P','C','I',' ','t','a','r','g','e','t',' ','a','b','o','r','t',')','.',
/* 0x018f4 = "Status code, typically given as a parameter, that isn\'t supposed to be used." */
    'S','t','a','t','u','s',' ','c','o','d','e',',',' ','t','y','p','i','c','a','l','l','y',' ','g','i','v','e','n',' ','a','s',' ','a',' ','p','a','r','a','m','e','t','e','r',',',' ','\xad','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x0a','\xa4','u','s','e','d','.',
/* 0x01938 = "The I/O context couldn\'t be destroyed because there are still pending requests." */
    '\x03','I','/','O',' ','c','o','n','t','e','x','t',' ','c','o','u','l','d','n','\'','t',' ','\xa4','d','e','s','t','r','o','y','e','d',' ','\x2a','t','h','e','r','e',' ','a','r','e',' ','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','r','e','q','u','e','s','t','s','.',
/* 0x0197b = "VFS chain element preceding the final path needs to be a directory, file system or file system stream." */
    '\x8d',' ','\xa1','\x5e','p','r','e','c','e','d','i','n','g',' ','\x02','f','i','n','a','l',' ','\xd2','n','e','e','d','s',' ','\x0a','\xa4','a',' ','d','i','r','e','c','t','o','r','y',',',' ','\x22','s','y','s','t','e','m',' ','\xa9','\x22','s','y','s','t','e','m',' ','s','t','r','e','a','m','.',
/* 0x019be = "Halt the current I/O context until further notification from the backend." */
    'H','a','l','t',' ','\x02','c','u','r','r','e','n','t',' ','I','/','O',' ','c','o','n','t','e','x','t',' ','u','n','t','i','l',' ','f','u','r','t','h','e','r',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','f','r','o','m',' ','\x02','b','a','c','k','e','n','d','.',
/* 0x01a01 = "The CPUID instruction returns different information when loading than when saved." */
    '\x03','C','P','U','I','D',' ','\xdc','r','e','t','u','r','n','s',' ','d','i','f','f','e','r','e','n','t',' ','i','n','f','o','r','m','a','t','i','o','n',' ','w','h','e','n',' ','l','o','a','d','i','n','g',' ','t','h','a','n',' ','w','h','e','n',' ','s','a','v','e','d','.',
/* 0x01a44 = "VFS chain element takes a directory (dir), file system stream (fss), or file system (vfs) object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x25','(','d','i','r',')',',',' ','\x22','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',',',' ','\xa9','\x22','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x01a87 = "There shall be exactly one digest algorithm to go with the single SingerInfo entry required by SPC." */
    'T','h','e','r','e',' ','s','h','a','l','l',' ','\xa4','e','x','a','c','t','l','y',' ','o','n','e',' ','\xd8','\xd5','\x0a','g','o',' ','\x7f','\x02','s','i','n','g','l','e',' ','S','i','n','g','e','r','I','n','f','o',' ','\xca','r','e','q','u','i','r','e','d',' ','\xdb','S','P','C','.',
/* 0x01ac9 = "Stub process not found so it cannot be revalidated when vboxdrv is opened by the VM process." */
    'S','t','u','b',' ','\x92','\x07','f','o','u','n','d',' ','s','o',' ','i','t',' ','\xcf','\xa4','r','e','v','a','l','i','d','a','t','e','d',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xdb','\x02','\xc6',' ','p','r','o','c','e','s','s','.',
/* 0x01b0b = "VMRUN emulation succeeded, ready to immediately enter the nested-guest." */
    'V','M','R','U','N',' ','e','m','u','l','a','t','i','o','n',' ','s','u','c','c','e','e','d','e','d',',',' ','r','e','a','d','y',' ','\x0a','i','m','m','e','d','i','a','t','e','l','y',' ','e','n','t','e','r',' ','\x02','n','e','s','t','e','d','-','g','u','e','s','t','.',
/* 0x01b4d = "Conflict between the core memory and the intermediate paging context, try again." */
    'C','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','c','o','r','e',' ','\x86','\x9a','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',',',' ','t','r','y',' ','a','g','a','i','n','.',
/* 0x01b8e = "The halt action was requested, but the OS may actually power off the machine." */
    '\x03','h','a','l','t',' ','a','c','t','i','o','n',' ','\x11','r','e','q','u','e','s','t','e','d',',',' ','b','u','t',' ','\x02','O','S',' ','m','a','y',' ','a','c','t','u','a','l','l','y',' ','p','o','w','e','r',' ','o','f','f',' ','\x02','m','a','c','h','i','n','e','.',
/* 0x01bcf = "The requests couldn\'t be submitted because that would exceed the capacity of the context." */
    '\x03','r','e','q','u','e','s','t','s',' ','c','o','u','l','d','n','\'','t',' ','\xa4','s','u','b','m','i','t','t','e','d',' ','\x2a','\xad','w','o','u','l','d',' ','e','x','c','e','e','d',' ','\x02','c','a','p','a','c','i','t','y',' ','\x15','\x02','c','o','n','t','e','x','t','.',
/* 0x01c10 = "Failed to set the TLS (thread local storage) entry which points to our thread structure." */
    '\x8b','\x0a','s','e','t',' ','\x02','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','\xca','\xed','p','o','i','n','t','s',' ','\x0a','o','u','r',' ','t','h','r','e','a','d',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x01c51 = "There are not enough events available on the host to create the I/O context." */
    'T','h','e','r','e',' ','a','r','e',' ','\x07','e','n','o','u','g','h',' ','e','v','e','n','t','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','\x02','h','o','s','t',' ','\x0a','c','r','e','a','t','e',' ','\x02','I','/','O',' ','c','o','n','t','e','x','t','.',
/* 0x01c92 = "Invalid/unsupported nested hardware virtualization configuration." */
    'I','n','v','a','l','i','d','/','u','n','s','u','p','p','o','r','t','e','d',' ','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x01cd3 = "Too many write or write/read recursions on read/write critical section." */
    'T','o','o',' ','\xb5','w','r','i','t','e',' ','\xa9','w','r','i','t','e','/','r','e','a','d',' ','r','e','c','u','r','s','i','o','n','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x01d14 = "No APIC device instance is registered with the current VM and thus the APIC operation cannot be performed." */
    '\xe0','A','P','I','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x7f','\x02','c','u','r','r','e','n','t',' ','\xc6',' ','\x9a','t','h','u','s',' ','\x02','A','P','I','C',' ','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d','.',
/* 0x01d55 = "The PCI device isn\'t configured as a busmaster, physical memory access rejected." */
    '\x03','P','C','I',' ','\xa3','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','a','s',' ','a',' ','b','u','s','m','a','s','t','e','r',',',' ','p','h','y','s','i','c','a','l',' ','\x86','a','c','c','e','s','s',' ','r','e','j','e','c','t','e','d','.',
/* 0x01d96 = "The file is too big for the current ISO level (4GB+ sized files requires ISO level 3)." */
    '\x03','\x22','\x0b','\x9e','b','i','g',' ','\x10','\x02','c','u','r','r','e','n','t',' ','\xc2',' ','l','e','v','e','l',' ','(','4','G','B','+',' ','s','i','z','e','d',' ','f','i','l','e','s',' ','r','e','q','u','i','r','e','s',' ','\xc2',' ','l','e','v','e','l',' ','3',')','.',
/* 0x01dd6 = "Import ISO has different volume space sizes of primary and supplementary volume descriptors." */
    '\xc4','\xc2',' ','\x5c','d','i','f','f','e','r','e','n','t',' ','\xd3','s','p','a','c','e',' ','s','i','z','e','s',' ','\x15','p','r','i','m','a','r','y',' ','\x9a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x01e16 = "The \'Translation\' attribute in the DrvBlock configuration had an unknown value." */
    '\x03','\'','T','r','a','n','s','l','a','t','i','o','n','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','h','a','d',' ','\x87','u','n','k','n','o','w','n',' ','\xe8',
/* 0x01e56 = "The tar termination records was encountered without reaching the end of the input stream." */
    '\x03','t','a','r',' ','t','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d','s',' ','\x11','\xaf','w','i','t','h','o','u','t',' ','r','e','a','c','h','i','n','g',' ','\x02','e','n','d',' ','\x15','\x02','i','n','p','u','t',' ','s','t','r','e','a','m','.',
/* 0x01e96 = "Indicating that the VM has been reset and that scheduling goes back to startup defaults." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','\x5c','\xcd','r','e','s','e','t',' ','\x9a','\xad','s','c','h','e','d','u','l','i','n','g',' ','g','o','e','s',' ','b','a','c','k',' ','\x0a','s','t','a','r','t','u','p',' ','d','e','f','a','u','l','t','s','.',
/* 0x01ed6 = "Got back from vmmR0CallRing3SetJmp with the context hook still enabled." */
    'G','o','t',' ','b','a','c','k',' ','f','r','o','m',' ','v','m','m','R','0','C','a','l','l','R','i','n','g','3','S','e','t','J','m','p',' ','\x7f','\x02','c','o','n','t','e','x','t',' ','h','o','o','k',' ','s','t','i','l','l',' ','e','n','a','b','l','e','d','.',
/* 0x01f16 = "Attempt to register a RAM range of which parts are already covered by existing RAM ranges." */
    'A','t','t','e','m','p','t',' ','\x0a','\xeb','a',' ','R','A','M',' ','r','a','n','g','e',' ','\x15','\xed','p','a','r','t','s',' ','a','r','e',' ','\x80','c','o','v','e','r','e','d',' ','\xdb','e','x','i','s','t','i','n','g',' ','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x01f56 = "The below driver doesn't export a interface required by the drive having attached it." */
    '\x03','b','e','l','o','w',' ','\xc7','\xc9','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xdb','\x02','d','r','i','v','e',' ','h','a','v','i','n','g',' ','a','t','t','a','c','h','e','d',' ','i','t','.',
/* 0x01f96 = "The function called requires the caller to be attached as a debugger to the VM." */
    '\x03','f','u','n','c','t','i','o','n',' ','c','a','l','l','e','d',' ','r','e','q','u','i','r','e','s',' ','\x02','c','a','l','l','e','r',' ','\x0a','\xa4','a','t','t','a','c','h','e','d',' ','a','s',' ','a',' ','d','e','b','u','g','g','e','r',' ','\x0a','\x02','V','M','.',
/* 0x01fd6 = "No DMAC device instance is registered with the current VM and thus the DMA operation cannot be performed." */
    '\xe0','D','M','A','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x7f','\x02','c','u','r','r','e','n','t',' ','\xc6',' ','\x9a','t','h','u','s',' ','\x02','D','M','A',' ','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d','.',
/* 0x02016 = "A boot catalog extension entry in the import ISO uses undefined flags which will be lost." */
    'A',' ','b','o','o','t',' ','\xe7','e','x','t','e','n','s','i','o','n',' ','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','u','s','e','s',' ','u','n','d','e','f','i','n','e','d',' ','f','l','a','g','s',' ','\xed','w','i','l','l',' ','\xa4','l','o','s','t','.',
/* 0x02055 = "Sensitive input requires the result(s) to be initialized as sensitive." */
    'S','e','n','s','i','t','i','v','e',' ','i','n','p','u','t',' ','r','e','q','u','i','r','e','s',' ','\x02','r','e','s','u','l','t','(','s',')',' ','\x0a','\xa4','i','n','i','t','i','a','l','i','z','e','d',' ','a','s',' ','s','e','n','s','i','t','i','v','e','.',
/* 0x02094 = "Bogus allocation descriptor length field value in an allocation extent descriptor." */
    'B','o','g','u','s',' ','a','l','l','o','c','a','t','i','o','n',' ','\xe3','l','e','n','g','t','h',' ','f','i','e','l','d',' ','\xf5','\x0f','\x87','a','l','l','o','c','a','t','i','o','n',' ','e','x','t','e','n','t',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x020d3 = "Trying to read a 64-bit guest physical address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x0a','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xbb','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x02112 = "Error opening the stub process for revalidation when vboxdrv is opened by the VM process." */
    '\xc1','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x92','\x10','r','e','v','a','l','i','d','a','t','i','o','n',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xdb','\x02','\xc6',' ','p','r','o','c','e','s','s','.',
/* 0x02151 = "CPU was incorrectly left in VMX root mode; incompatible with VirtualBox." */
    'C','P','U',' ','\x11','i','n','c','o','r','r','e','c','t','l','y',' ','l','e','f','t',' ','\x0f','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','\x7f','V','i','r','t','u','a','l','B','o','x','.',
/* 0x02190 = "A timeout occurred while waiting for async IDE operations to finish." */
    'A',' ','t','i','m','e','o','u','t',' ','o','c','c','u','r','r','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g',' ','\x10','a','s','y','n','c',' ','I','D','E',' ','o','p','e','r','a','t','i','o','n','s',' ','\x0a','f','i','n','i','s','h','.',
/* 0x021cf = "No PIC device instance is registered with the current VM and thus the PIC operation cannot be performed." */
    '\xe0','P','I','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x7f','\x02','c','u','r','r','e','n','t',' ','\xc6',' ','\x9a','t','h','u','s',' ','\x02','P','I','C',' ','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d','.',
/* 0x0220e = "The intercepted situation was completely handled, continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','s','i','t','u','a','t','i','o','n',' ','\x11','c','o','m','p','l','e','t','e','l','y',' ','h','a','n','d','l','e','d',',',' ','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x0224d = "Got an out of memory condition trying to allocate a UTF-16 (/UCS-2) string." */
    'G','o','t',' ','\x87','o','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','U','T','F','-','1','6',' ','(','/','U','C','S','-','2',')',' ','s','t','r','i','n','g','.',
/* 0x0228c = "Attempt to register an access handler for a physical range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x0a','\xeb','\x87','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','a',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e',' ','\x15','\xed','a',' ','p','a','r','t',' ','\x11','\x80','h','a','n','d','l','e','d','.',
/* 0x022cb = "The digest algorithm in the indirect data was not found in the list of digest algorithms in the signed data structure." */
    '\x03','\xd8','\xd5','\x0f','\x02','i','n','d','i','r','e','c','t',' ','\x9d','\x11','\x07','f','o','u','n','d',' ','\x0f','\x02','l','i','s','t',' ','\x15','\xd8','a','l','g','o','r','i','t','h','m','s',' ','\x0f','\x02','s','i','g','n','e','d',' ','\x9d','s','t','r','u','c','t','u','r','e','.',
/* 0x0230a = "A number tar header field yielded a value too large for the internal variable of the tar interpreter." */
    'A',' ','\xfc','t','a','r',' ','\xb4','f','i','e','l','d',' ','y','i','e','l','d','e','d',' ','a',' ','\xf5','\x9e','l','a','r','g','e',' ','\x10','\x02','\x16','v','a','r','i','a','b','l','e',' ','\x15','\x02','t','a','r',' ','i','n','t','e','r','p','r','e','t','e','r','.',
/* 0x02348 = "Attempt to register an access handler for a virtual range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x0a','\xeb','\x87','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','a',' ','v','i','r','t','u','a','l',' ','r','a','n','g','e',' ','\x15','\xed','a',' ','p','a','r','t',' ','\x11','\x80','h','a','n','d','l','e','d','.',
/* 0x02386 = "Import ISO has different volume set sizes of primary and supplementary volume descriptors." */
    '\xc4','\xc2',' ','\x5c','d','i','f','f','e','r','e','n','t',' ','\xd3','s','e','t',' ','s','i','z','e','s',' ','\x15','p','r','i','m','a','r','y',' ','\x9a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x023c4 = "A PGM function was called in a mode where it isn\'t supposed to be used." */
    'A',' ','P','G','M',' ','f','u','n','c','t','i','o','n',' ','\x11','c','a','l','l','e','d',' ','\x0f','a',' ','m','o','d','e',' ','w','h','e','r','e',' ','i','t',' ','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x0a','\xa4','u','s','e','d','.',
/* 0x02402 = "Process Verification Failure: There is more than one known executable mapped into the process." */
    '\x1e','\x0d','\x12','T','h','e','r','e',' ','\x0b','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','k','n','o','w','n',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x02440 = "The PE loader encountered a lock prefix table, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xda','\xaf','a',' ','l','o','c','k',' ','p','r','e','f','i','x',' ','t','a','b','l','e',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xed','h','a','s','n','\'','t',' ','\xcd','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0247e = "Trying to read a 64-bit guest virtual address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x0a','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xbb','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x024bc = "VFS chain element only provides a read-only I/O stream, while the chain read access." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','o','n','l','y',' ','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\xa1','r','e','a','d',' ','a','c','c','e','s','s','.',
/* 0x024fa = "The combined minor and major device number type is too small to hold the value stored in the tar header." */
    '\x03','c','o','m','b','i','n','e','d',' ','m','i','n','o','r',' ','\x9a','m','a','j','o','r',' ','\xa3','\xfc','\xf3','\x0b','\x9e','s','m','a','l','l',' ','\x0a','h','o','l','d',' ','\x02','\xf5','s','t','o','r','e','d',' ','\x0f','\x02','t','a','r',' ','h','e','a','d','e','r','.',
/* 0x02538 = "Import ISO contains a non-final multi-extent directory record with a size that isn\'t block aligned." */
    '\xc4','\xc2',' ','\x8a','a',' ','n','o','n','-','f','i','n','a','l',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x25','r','e','c','o','r','d',' ','\x7f','a',' ','\xf8','\xad','i','s','n','\'','t',' ','b','l','o','c','k',' ','a','l','i','g','n','e','d','.',
/* 0x02576 = "Nested ownership requests are not permitted for this semaphore type." */
    'N','e','s','t','e','d',' ','o','w','n','e','r','s','h','i','p',' ','r','e','q','u','e','s','t','s',' ','a','r','e',' ','\x07','p','e','r','m','i','t','t','e','d',' ','\x10','t','h','i','s',' ','s','e','m','a','p','h','o','r','e',' ','t','y','p','e','.',
/* 0x025b4 = "A boot catalog entry in the import ISO points to a block after the end of the image input file." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','p','o','i','n','t','s',' ','\x0a','a',' ','b','l','o','c','k',' ','a','f','t','e','r',' ','\x02','e','n','d',' ','\x15','\x02','\x26','i','n','p','u','t',' ','f','i','l','e','.',
/* 0x025f1 = "Giving up a live snapshot/teleportation attempt because the state grew to big." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x2a','\x02','\xcc','g','r','e','w',' ','\x0a','b','i','g','.',
/* 0x0262e = "The specified R0 or RC I/O port range didn\'t have a corresponding R3 range." */
    '\x03','\x18','R','0',' ','\xa9','R','C',' ','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','d','i','d','n','\'','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',
/* 0x0266b = "A restore routine attempted to load more data then the unit contained." */
    'A',' ','r','e','s','t','o','r','e',' ','r','o','u','t','i','n','e',' ','a','t','t','e','m','p','t','e','d',' ','\x0a','l','o','a','d',' ','m','o','r','e',' ','\x9d','t','h','e','n',' ','\x02','u','n','i','t',' ','c','o','n','t','a','i','n','e','d','.',
/* 0x026a8 = "The digest algorithm of a signer info entry was not found in the list of digest algorithms in the signed data." */
    '\x03','\xd8','\xd5','\x15','a',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','\xca','\x11','\x07','f','o','u','n','d',' ','\x0f','\x02','l','i','s','t',' ','\x15','\xd8','a','l','g','o','r','i','t','h','m','s',' ','\x0f','\x02','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x026e5 = "The I/O port range specified for removal wasn\'t found or it wasn\'t contiguous." */
    '\x03','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','w','a','s','n','\'','t',' ','f','o','u','n','d',' ','\xa9','i','t',' ','w','a','s','n','\'','t',' ','c','o','n','t','i','g','u','o','u','s','.',
/* 0x02722 = "The table of content XML element (toc) has siblings, we expected it to be an only child or the root element (xar)." */
    '\x03','\xb1','\x15','\xf0','X','M','L',' ','\x5e','(','t','o','c',')',' ','\x5c','s','i','b','l','i','n','g','s',',',' ','w','e',' ','\xcb','i','t',' ','\x0a','\xa4','\x87','o','n','l','y',' ','c','h','i','l','d',' ','\xa9','\x02','r','o','o','t',' ','\x5e','(','x','a','r',')','.',
/* 0x0275f = "Expected the archived and extracted XAR data sizes to be the same for uncompressed data." */
    '\xb8','\x02','a','r','c','h','i','v','e','d',' ','\x9a','e','x','t','r','a','c','t','e','d',' ','X','A','R',' ','\x9d','s','i','z','e','s',' ','\x0a','\xa4','\x02','s','a','m','e',' ','\x10','u','n','c','o','m','p','r','e','s','s','e','d',' ','d','a','t','a','.',
/* 0x0279b = "The above driver doesn't export a interface required by a driver being attached to it." */
    '\x03','a','b','o','v','e',' ','\xc7','\xc9','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xdb','a',' ','\xc7','b','e','i','n','g',' ','a','t','t','a','c','h','e','d',' ','\x0a','i','t','.',
/* 0x027d7 = "Got into a part of TRPM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','T','R','P','M',' ','\xad','\x0b','\x07','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02813 = "Can\'t finalize the node as the FDT cursor is at the root level already." */
    'C','a','n','\'','t',' ','f','i','n','a','l','i','z','e',' ','\x02','n','o','d','e',' ','a','s',' ','\x02','F','D','T',' ','c','u','r','s','o','r',' ','\x0b','a','t',' ','\x02','r','o','o','t',' ','l','e','v','e','l',' ','a','l','r','e','a','d','y','.',
/* 0x0284f = "The status field has not been updated yet as the request is still pending completion." */
    '\x03','s','t','a','t','u','s',' ','f','i','e','l','d',' ','\x5c','\x07','\xcd','u','p','d','a','t','e','d',' ','y','e','t',' ','a','s',' ','\x02','\xab','\x0b','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','c','o','m','p','l','e','t','i','o','n','.',
/* 0x0288b = "Missing UTF-8 continutation in escaped URI character sequence." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','\x0f','e','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x028c7 = "Trick for resuming EMHistoryExec after a VMCPU_FF_IOM is handled." */
    'T','r','i','c','k',' ','\x10','r','e','s','u','m','i','n','g',' ','E','M','H','i','s','t','o','r','y','E','x','e','c',' ','a','f','t','e','r',' ','a',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0b','h','a','n','d','l','e','d','.',
/* 0x02903 = "Got into a part of SELM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','S','E','L','M',' ','\xad','\x0b','\x07','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x0293f = "Failed to add new mappings because the current mappings are fixed in guest os memory." */
    '\x8b','\x0a','a','d','d',' ','n','e','w',' ','m','a','p','p','i','n','g','s',' ','\x2a','\x02','c','u','r','r','e','n','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','f','i','x','e','d',' ','\x0f','\xbb','o','s',' ','m','e','m','o','r','y','.',
/* 0x0297b = "The timer was stuck in an unstable state until we grew impatient and returned." */
    '\x03','t','i','m','e','r',' ','\x11','s','t','u','c','k',' ','\x0f','\x87','u','n','s','t','a','b','l','e',' ','\xcc','u','n','t','i','l',' ','w','e',' ','g','r','e','w',' ','i','m','p','a','t','i','e','n','t',' ','\x9a','r','e','t','u','r','n','e','d','.',
/* 0x029b7 = "Out of memory condition when allocating physical memory (without mapping)." */
    'O','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','p','h','y','s','i','c','a','l',' ','\x86','(','w','i','t','h','o','u','t',' ','m','a','p','p','i','n','g',')','.',
/* 0x029f3 = "Multiple logical volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x7f','o','n','e','.',
/* 0x02a2e = "Got into a part of IOM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','I','O','M',' ','\xad','\x0b','\x07','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02a69 = "Differencing and parent images can\'t be used together due to UUID." */
    'D','i','f','f','e','r','e','n','c','i','n','g',' ','\x9a','p','a','r','e','n','t',' ','i','m','a','g','e','s',' ','c','a','n','\'','t',' ','\xa4','u','s','e','d',' ','t','o','g','e','t','h','e','r',' ','d','u','e',' ','\x0a','U','U','I','D','.',
/* 0x02aa4 = "Async I/O task is pending, a completion handler will be called." */
    'A','s','y','n','c',' ','I','/','O',' ','t','a','s','k',' ','\x0b','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\xa4','c','a','l','l','e','d','.',
/* 0x02adf = "Failed to enable VMXON-in-SMX bit while enabling VT-x through the MSR." */
    '\x8b','\x0a','e','n','a','b','l','e',' ','V','M','X','O','N','-','i','n','-','S','M','X',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x02b1a = "Giving up a live snapshot attempt because we\'re low on disk space." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t',' ','a','t','t','e','m','p','t',' ','\x2a','w','e','\'','r','e',' ','l','o','w',' ','o','n',' ','d','i','s','k',' ','s','p','a','c','e','.',
/* 0x02b55 = "The live snapshot/teleportation operation was aborted because of a guru meditation." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x96','\x11','a','b','o','r','t','e','d',' ','\x2a','\x15','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x02b90 = "Unable to translate one or more of the arguments to the codeset the child process is expected to use." */
    '\xe1','\x0a','t','r','a','n','s','l','a','t','e',' ','o','n','e',' ','\xa9','m','o','r','e',' ','\x15','\x02','a','r','g','u','m','e','n','t','s',' ','\x0a','\x02','c','o','d','e','s','e','t',' ','\x02','c','h','i','l','d',' ','\x92','\x0b','\xcb','\x0a','u','s','e','.',
/* 0x02bcb = "The driver properties were invalid, and as a consequence construction failed." */
    '\x03','\xc7','p','r','o','p','e','r','t','i','e','s',' ','w','e','r','e',' ','i','n','v','a','l','i','d',',',' ','\x9a','a','s',' ','a',' ','c','o','n','s','e','q','u','e','n','c','e',' ','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x7b',
/* 0x02c06 = "Giving up a live snapshot/teleportation attempt because of too many passes." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x2a','\x15','\x9e','\xb5','p','a','s','s','e','s','.',
/* 0x02c41 = "The requested nested-guest VMX intercept is not active or not in nested-guest execution mode." */
    '\x03','\xdf','n','e','s','t','e','d','-','\xbb','V','M','X',' ','i','n','t','e','r','c','e','p','t',' ','\x0b','\x07','a','c','t','i','v','e',' ','\xa9','\x07','\x0f','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x02c7c = "Cannot add symbolic link to namespace which isn\'t configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x0a','n','a','m','e','s','p','a','c','e',' ','\xed','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','\x0a','\xd0','i','t','.',
/* 0x02cb7 = "The VM was suspended before or while saving, don\'t resume execution." */
    '\x03','\xc6',' ','\x11','s','u','s','p','e','n','d','e','d',' ','b','e','f','o','r','e',' ','\xa9','w','h','i','l','e',' ','s','a','v','i','n','g',',',' ','d','o','n','\'','t',' ','r','e','s','u','m','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x02cf2 = "Attempt to create a GC mapping which conflicts with an existing mapping." */
    'A','t','t','e','m','p','t',' ','\x0a','c','r','e','a','t','e',' ','a',' ','G','C',' ','m','a','p','p','i','n','g',' ','\xed','c','o','n','f','l','i','c','t','s',' ','\x7f','\x87','e','x','i','s','t','i','n','g',' ','m','a','p','p','i','n','g','.',
/* 0x02d2d = "Import ISO contains a non-contigiuous multi-extent data, this is currently not supported." */
    '\xc4','\xc2',' ','\x8a','a',' ','n','o','n','-','c','o','n','t','i','g','i','u','o','u','s',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','d','a','t','a',',',' ','t','h','i','s',' ','\x0b','c','u','r','r','e','n','t','l','y',' ','\x07','\xa5',
/* 0x02d68 = "Multiple primary volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','p','r','i','m','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x7f','o','n','e','.',
/* 0x02da3 = "Process Verification Failure: The DllCharacteristics of the process does not match the value in the optional header in the exe file." */
    '\x1e','\x0d','\x12','\x03','D','l','l','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x15','\x02','\x92','\xb2','\x07','m','a','t','c','h',' ','\x02','\xf5','\x0f','\x02','o','p','t','i','o','n','a','l',' ','\xb4','\x0f','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x02dde = "The requested nested-guest SVM intercept is not active or not in nested-guest execution mode." */
    '\x03','\xdf','n','e','s','t','e','d','-','\xbb','S','V','M',' ','i','n','t','e','r','c','e','p','t',' ','\x0b','\x07','a','c','t','i','v','e',' ','\xa9','\x07','\x0f','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x02e19 = "Got into a part of PDM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','P','D','M',' ','\xad','\x0b','\x07','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02e54 = "Maximum number of Shared Clipboard events for an event source has been reached." */
    'M','a','x','i','m','u','m',' ','\xfc','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t','s',' ','\x10','\x87','e','v','e','n','t',' ','s','o','u','r','c','e',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x02e8f = "VFS chain element only provides file, I/O stream (ios), or directory (dir) objects." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','f','i','l','e',',',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',',',' ','\xa9','\x25','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x02ec9 = "The probe location array isn\'t adjacent to the probe enable array." */
    '\x03','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','a','r','r','a','y',' ','i','s','n','\'','t',' ','a','d','j','a','c','e','n','t',' ','\x0a','\x02','p','r','o','b','e',' ','e','n','a','b','l','e',' ','a','r','r','a','y','.',
/* 0x02f03 = "Indicating that the VM has been resumed and that the thread should start executing." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','\x5c','\xcd','r','e','s','u','m','e','d',' ','\x9a','\xad','\x02','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','s','t','a','r','t',' ','e','x','e','c','u','t','i','n','g','.',
/* 0x02f3d = "The live snapshot/teleportation operation was aborted because of a fatal runtime error." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x96','\x11','a','b','o','r','t','e','d',' ','\x2a','\x15','a',' ','f','a','t','a','l',' ','r','u','n','t','i','m','e',' ','\x85',
/* 0x02f77 = "VRDP protocol violation, client sends less data than expected." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n',',',' ','c','l','i','e','n','t',' ','s','e','n','d','s',' ','l','e','s','s',' ','\x9d','t','h','a','n',' ','e','x','p','e','c','t','e','d','.',
/* 0x02fb1 = "The PE loader encountered delayed imports, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xda','\xaf','d','e','l','a','y','e','d',' ','i','m','p','o','r','t','s',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xed','h','a','s','n','\'','t',' ','\xcd','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x02feb = "PGMPhysWrite/Read hit a handler in Ring-0 or raw-mode context." */
    'P','G','M','P','h','y','s','W','r','i','t','e','/','R','e','a','d',' ','h','i','t',' ','a',' ','h','a','n','d','l','e','r',' ','\x0f','R','i','n','g','-','0',' ','\xa9','r','a','w','-','m','o','d','e',' ','c','o','n','t','e','x','t','.',
/* 0x03025 = "Reason for leaving RC: Interrupted by external interrupt while in hypervisor code." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xdb','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t',' ','w','h','i','l','e',' ','\x0f','h','y','p','e','r','v','i','s','o','r',' ','\x84',
/* 0x0305f = "Escaped URI character sequence with invalid UTF-8 continutation byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e',' ','\x7f','\x8f','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','b','y','t','e','.',
/* 0x03099 = "Image Verification Warning: No Authenticode Signature, but on whitelist." */
    'I','m','a','g','e',' ','\x0d','W','a','r','n','i','n','g',':',' ','\xe0','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e',',',' ','b','u','t',' ','o','n',' ','w','h','i','t','e','l','i','s','t','.',
/* 0x030d3 = "The user mode tracepoint provider has too many probe locations and probes." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x5c','\x9e','\xb5','p','r','o','b','e',' ','l','o','c','a','t','i','o','n','s',' ','\x9a','p','r','o','b','e','s','.',
/* 0x0310d = "This indicates that the process does not have sufficient privileges to perform the operation." */
    'T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','\xad','\x02','\x92','\xb2','\x07','h','a','v','e',' ','s','u','f','f','i','c','i','e','n','t',' ','p','r','i','v','i','l','e','g','e','s',' ','\x0a','p','e','r','f','o','r','m',' ','\x02','\xea',
/* 0x03147 = "Hypercall cannot be enabled/performed due to access/permissions/CPL." */
    'H','y','p','e','r','c','a','l','l',' ','\xcf','\xa4','e','n','a','b','l','e','d','/','p','e','r','f','o','r','m','e','d',' ','d','u','e',' ','\x0a','a','c','c','e','s','s','/','p','e','r','m','i','s','s','i','o','n','s','/','C','P','L','.',
/* 0x03181 = "A legacy device isn\'t implementing the HPET notification interface." */
    'A',' ','l','e','g','a','c','y',' ','\xa3','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','i','n','g',' ','\x02','H','P','E','T',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x031bb = "Signed data verification failed because of a malformed authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','\x15','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf3','a','t','t','r','i','b','u','t','e','.',
/* 0x031f4 = "The driver is already removed, not more transformations possible (at present)." */
    '\x03','\xc7','\x0b','\x80','r','e','m','o','v','e','d',',',' ','\x07','m','o','r','e',' ','t','r','a','n','s','f','o','r','m','a','t','i','o','n','s',' ','p','o','s','s','i','b','l','e',' ','(','a','t',' ','p','r','e','s','e','n','t',')','.',
/* 0x0322d = "Signed data verification failed because of a malformed authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','\x15','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd8','a','t','t','r','i','b','u','t','e','.',
/* 0x03266 = "Not all requests could be submitted due to resource shortage." */
    'N','o','t',' ','a','l','l',' ','r','e','q','u','e','s','t','s',' ','c','o','u','l','d',' ','\xa4','s','u','b','m','i','t','t','e','d',' ','d','u','e',' ','\x0a','r','e','s','o','u','r','c','e',' ','s','h','o','r','t','a','g','e','.',
/* 0x0329f = "Indicating that the VM is being terminated and that the execution shall stop." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xc6',' ','\x0b','b','e','i','n','g',' ','t','e','r','m','i','n','a','t','e','d',' ','\x9a','\xad','\x02','e','x','e','c','u','t','i','o','n',' ','s','h','a','l','l',' ','s','t','o','p','.',
/* 0x032d8 = "Signed data verification failed because of the authenticated content-type attribute did not match." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','\x15','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf3','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x07','m','a','t','c','h','.',
/* 0x03311 = "Address translation disabled (but permission bits apply)." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','u','t',' ','p','e','r','m','i','s','s','i','o','n',' ','b','i','t','s',' ','a','p','p','l','y',')','.',
/* 0x0334a = "The path only element at the end of the VFS chain is too short to make out the parent directory." */
    '\x03','\xd2','o','n','l','y',' ','\x5e','a','t',' ','\x02','e','n','d',' ','\x15','\x02','\x8d',' ','\xa1','\x0b','\x9e','s','h','o','r','t',' ','\x0a','m','a','k','e',' ','o','u','t',' ','\x02','p','a','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x03383 = "Indicating that we should reschedule to the main execution engine." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','w','e',' ','s','h','o','u','l','d',' ','r','e','s','c','h','e','d','u','l','e',' ','\x0a','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e','.',
/* 0x033bc = "Get an out of memory condition trying to allocate a code point array." */
    'G','e','t',' ','\x87','o','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','c','o','d','e',' ','p','o','i','n','t',' ','a','r','r','a','y','.',
/* 0x033f5 = "The \'Type\' attribute in the DrvBlock configuration had an unknown value." */
    '\x03','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','h','a','d',' ','\x87','u','n','k','n','o','w','n',' ','\xe8',
/* 0x0342e = "Reason for leaving RC: A Ring switch was attempted using software interrupt." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x11','a','t','t','e','m','p','t','e','d',' ','u','s','i','n','g',' ','s','o','f','t','w','a','r','e',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x03467 = "VMLAUNCH/VMRESUME succeeded, can enter nested-guest execution." */
    'V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E',' ','s','u','c','c','e','e','d','e','d',',',' ','c','a','n',' ','e','n','t','e','r',' ','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x034a0 = "Windows system integrity policy violation (device guard)." */
    'W','i','n','d','o','w','s',' ','s','y','s','t','e','m',' ','i','n','t','e','g','r','i','t','y',' ','p','o','l','i','c','y',' ','v','i','o','l','a','t','i','o','n',' ','(','d','e','v','i','c','e',' ','g','u','a','r','d',')','.',
/* 0x034d9 = "VT-x features for all modes (SMX and non-SMX) disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','\x10','a','l','l',' ','m','o','d','e','s',' ','(','S','M','X',' ','\x9a','n','o','n','-','S','M','X',')',' ','d','i','s','a','b','l','e','d',' ','\xdb','\x02','B','I','O','S','.',
/* 0x03511 = "Failed to set VMXON enable bit while enabling VT-x through the MSR." */
    '\x8b','\x0a','s','e','t',' ','V','M','X','O','N',' ','e','n','a','b','l','e',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x03549 = "The device is not a registered PCI device and thus cannot perform any PCI operations." */
    '\x03','\xa3','\x0b','\x07','a',' ','r','e','g','i','s','t','e','r','e','d',' ','P','C','I',' ','\xa3','\x9a','t','h','u','s',' ','\xcf','p','e','r','f','o','r','m',' ','a','n','y',' ','P','C','I',' ','o','p','e','r','a','t','i','o','n','s','.',
/* 0x03581 = "Certificate path validator: Unexpected maximum value found in general subtree object (name constraints)." */
    '\xba','\xd2','\xff','\x94','m','a','x','i','m','u','m',' ','\xf5','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa8','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x035b9 = "Certificate path validator: Unexpected minimum value found in general subtree object (name constraints)." */
    '\xba','\xd2','\xff','\x94','m','i','n','i','m','u','m',' ','\xf5','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa8','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x035f1 = "Someone (including the caller) was already attached as debugger to the VM." */
    'S','o','m','e','o','n','e',' ','(','i','n','c','l','u','d','i','n','g',' ','\x02','c','a','l','l','e','r',')',' ','\x11','\x80','a','t','t','a','c','h','e','d',' ','a','s',' ','d','e','b','u','g','g','e','r',' ','\x0a','\x02','V','M','.',
/* 0x03629 = "Couldn\'t find any export for registration of drivers/devices." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','e','x','p','o','r','t',' ','\x10','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x15','d','r','i','v','e','r','s','/','d','e','v','i','c','e','s','.',
/* 0x03661 = "Signed data verification failed because the authenticated message-digest attribute did not match." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd8','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x07','m','a','t','c','h','.',
/* 0x03699 = "Process Verification Failure: An unknown and unwanted DLL was found loaded into the process." */
    '\x1e','\x0d','\x12','A','n',' ','u','n','k','n','o','w','n',' ','\x9a','u','n','w','a','n','t','e','d',' ','D','L','L',' ','\x11','f','o','u','n','d',' ','l','o','a','d','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x036d1 = "Block read was marked as free in the image and returned as a zero block." */
    'B','l','o','c','k',' ','r','e','a','d',' ','\x11','m','a','r','k','e','d',' ','a','s',' ','f','r','e','e',' ','\x0f','\x02','\x26','\x9a','r','e','t','u','r','n','e','d',' ','a','s',' ','a',' ','z','e','r','o',' ','b','l','o','c','k','.',
/* 0x03709 = "Key decryption failed, perhaps due to an incorrect password." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','f','a','i','l','e','d',',',' ','p','e','r','h','a','p','s',' ','d','u','e',' ','\x0a','\x87','i','n','c','o','r','r','e','c','t',' ','p','a','s','s','w','o','r','d','.',
/* 0x03741 = "Cannot add symbolic link because no namespace is configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x2a','n','o',' ','n','a','m','e','s','p','a','c','e',' ','\x0b','c','o','n','f','i','g','u','r','e','d',' ','\x0a','\xd0','i','t','.',
/* 0x03779 = "A data unit in the saved state file was defined but didn\'t any routine for processing it." */
    'A',' ','\x9d','u','n','i','t',' ','\x0f','\x02','s','a','v','e','d',' ','\xcc','\x22','\x11','d','e','f','i','n','e','d',' ','b','u','t',' ','d','i','d','n','\'','t',' ','a','n','y',' ','r','o','u','t','i','n','e',' ','\x10','\x04','i','t','.',
/* 0x037b0 = "Continuing hypercall at the same RIP, continue guest execution." */
    'C','o','n','t','i','n','u','i','n','g',' ','h','y','p','e','r','c','a','l','l',' ','a','t',' ','\x02','s','a','m','e',' ','R','I','P',',',' ','c','o','n','t','i','n','u','e',' ','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x037e7 = "Certificate path validator: Intermediate certificate subject does not match child issuer property." */
    '\xba','\xd2','\xff','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','s','u','b','j','e','c','t',' ','\xb2','\x07','m','a','t','c','h',' ','c','h','i','l','d',' ','i','s','s','u','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x0381e = "Indicating that we should reschedule to recompiled execution." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','w','e',' ','s','h','o','u','l','d',' ','r','e','s','c','h','e','d','u','l','e',' ','\x0a','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03855 = "Instruction that triggers the hypercall is invalid/unrecognized." */
    'I','n','s','t','r','u','c','t','i','o','n',' ','\xad','t','r','i','g','g','e','r','s',' ','\x02','h','y','p','e','r','c','a','l','l',' ','\x0b','i','n','v','a','l','i','d','/','u','n','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0388c = "The image requires to be signed using the kernel-code signing process." */
    '\x03','\x26','r','e','q','u','i','r','e','s',' ','\x0a','\xa4','s','i','g','n','e','d',' ','u','s','i','n','g',' ','\x02','k','e','r','n','e','l','-','c','o','d','e',' ','s','i','g','n','i','n','g',' ','p','r','o','c','e','s','s','.',
/* 0x038c3 = "Encountered unicode code point in the surrogate range (0xd800 to 0xdfff)." */
    '\xa6','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\x0f','\x02','s','u','r','r','o','g','a','t','e',' ','r','a','n','g','e',' ','(','0','x','d','8','0','0',' ','\x0a','0','x','d','f','f','f',')','.',
/* 0x038fa = "The intercepted instruction handled, advance RIP and continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\xdc','h','a','n','d','l','e','d',',',' ','a','d','v','a','n','c','e',' ','R','I','P',' ','\x9a','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03931 = "The operation was cancelled by the user (copy) or another thread (local ipc)." */
    '\x03','\x96','\x11','c','a','n','c','e','l','l','e','d',' ','\xdb','\x02','u','s','e','r',' ','(','c','o','p','y',')',' ','\xa9','a','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','(','l','o','c','a','l',' ','i','p','c',')','.',
/* 0x03968 = "Out of memory condition when allocating memory with low physical backing." */
    'O','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x7f','l','o','w',' ','p','h','y','s','i','c','a','l',' ','b','a','c','k','i','n','g','.',
/* 0x0399f = "Certificate path validator: Unexpected choice found in general subtree object (name constraints)." */
    '\xba','\xd2','\xff','\x94','c','h','o','i','c','e',' ','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa8','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x039d5 = "The decompressor completed without using all the input data." */
    '\x03','d','e','c','o','m','p','r','e','s','s','o','r',' ','c','o','m','p','l','e','t','e','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','a','l','l',' ','\x02','i','n','p','u','t',' ','d','a','t','a','.',
/* 0x03a0b = "Parameters was presented to a signature schema that does not take any." */
    'P','a','r','a','m','e','t','e','r','s',' ','\x11','p','r','e','s','e','n','t','e','d',' ','\x0a','a',' ','s','i','g','n','a','t','u','r','e',' ','s','c','h','e','m','a',' ','\xad','\xb2','\x07','t','a','k','e',' ','a','n','y','.',
/* 0x03a41 = "The attached driver configuration is missing the \'Driver\' attribute." */
    '\x03','a','t','t','a','c','h','e','d',' ','\xc7','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x0b','m','i','s','s','i','n','g',' ','\x02','\'','D','r','i','v','e','r','\'',' ','a','t','t','r','i','b','u','t','e','.',
/* 0x03a77 = "The specified R0 or RC MMIO range didn\'t have a corresponding R3 range." */
    '\x03','\x18','R','0',' ','\xa9','R','C',' ','\xd4',' ','r','a','n','g','e',' ','d','i','d','n','\'','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',
/* 0x03aad = "CPU hotplug events from VMMDev are not monitored by the guest." */
    'C','P','U',' ','h','o','t','p','l','u','g',' ','e','v','e','n','t','s',' ','f','r','o','m',' ','V','M','M','D','e','v',' ','a','r','e',' ','\x07','m','o','n','i','t','o','r','e','d',' ','\xdb','\x02','g','u','e','s','t','.',
/* 0x03ae3 = "The configuration constructor in main failed due to an internal consistency error." */
    '\x03','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','c','o','n','s','t','r','u','c','t','o','r',' ','\x0f','m','a','i','n',' ','\x99','d','u','e',' ','\x0a','\x87','\x16','c','o','n','s','i','s','t','e','n','c','y',' ','\x85',
/* 0x03b19 = "Failed to make the Host Interface Networking handle non-blocking." */
    '\x8b','\x0a','m','a','k','e',' ','\x02','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','h','a','n','d','l','e',' ','n','o','n','-','b','l','o','c','k','i','n','g','.',
/* 0x03b4f = "Syntax error - you hit a debugger feature which isn\'t implemented yet." */
    '\xfb','\x09','-',' ','y','o','u',' ','h','i','t',' ','a',' ','d','e','b','u','g','g','e','r',' ','f','e','a','t','u','r','e',' ','\xed','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x03b85 = "A new leaf couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','l','e','a','f',' ','c','o','u','l','d','n','\'','t',' ','\xa4','i','n','s','e','r','t','e','d',' ','\x2a','o','n','e',' ','\x7f','\x02','s','a','m','e',' ','n','a','m','e',' ','e','x','i','s','t','s','.',
/* 0x03bbb = "One or more PAE PDPEs are invalid due to reserved bits being set." */
    'O','n','e',' ','\xa9','m','o','r','e',' ','P','A','E',' ','P','D','P','E','s',' ','a','r','e',' ','\x8f','d','u','e',' ','\x0a','r','e','s','e','r','v','e','d',' ','b','i','t','s',' ','b','e','i','n','g',' ','s','e','t','.',
/* 0x03bf1 = "The chunk to be unmapped isn\'t actually mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x0a','\xa4','u','n','m','a','p','p','e','d',' ','i','s','n','\'','t',' ','a','c','t','u','a','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x03c27 = "A device didn\'t find a required interface with an attached driver." */
    'A',' ','\xa3','d','i','d','n','\'','t',' ','f','i','n','d',' ','a',' ','r','e','q','u','i','r','e','d',' ','i','n','t','e','r','f','a','c','e',' ','\x7f','\x87','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x03c5d = "Tree traversal encountered more nodes than available in the allocator." */
    'T','r','e','e',' ','t','r','a','v','e','r','s','a','l',' ','\xaf','m','o','r','e',' ','n','o','d','e','s',' ','t','h','a','n',' ','a','v','a','i','l','a','b','l','e',' ','\x0f','\x02','a','l','l','o','c','a','t','o','r','.',
/* 0x03c93 = "Recompiled execution: Break out of current TB execution." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k',' ','o','u','t',' ','\x15','c','u','r','r','e','n','t',' ','T','B',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03cc9 = "Complex SSM field fed to SSMR3PutStruct or SSMR3GetStruct." */
    'C','o','m','p','l','e','x',' ','S','S','M',' ','f','i','e','l','d',' ','f','e','d',' ','\x0a','S','S','M','R','3','P','u','t','S','t','r','u','c','t',' ','\xa9','S','S','M','R','3','G','e','t','S','t','r','u','c','t','.',
/* 0x03cff = "A new node couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','n','o','d','e',' ','c','o','u','l','d','n','\'','t',' ','\xa4','i','n','s','e','r','t','e','d',' ','\x2a','o','n','e',' ','\x7f','\x02','s','a','m','e',' ','n','a','m','e',' ','e','x','i','s','t','s','.',
/* 0x03d35 = "Framebuffer is resized, terminate send bitmap procedure." */
    'F','r','a','m','e','b','u','f','f','e','r',' ','\x0b','r','e','s','i','z','e','d',',',' ','t','e','r','m','i','n','a','t','e',' ','s','e','n','d',' ','b','i','t','m','a','p',' ','p','r','o','c','e','d','u','r','e','.',
/* 0x03d6b = "The guest GDT so full that we cannot find free space for our own selectors." */
    '\x03','\xbb','G','D','T',' ','s','o',' ','f','u','l','l',' ','\xad','w','e',' ','\xcf','f','i','n','d',' ','f','r','e','e',' ','s','p','a','c','e',' ','\x10','o','u','r',' ','o','w','n',' ','s','e','l','e','c','t','o','r','s','.',
/* 0x03da1 = "Tried to grow a file beyond the limit imposed by the process or the filesystem." */
    'T','r','i','e','d',' ','\x0a','g','r','o','w',' ','a',' ','\x22','b','e','y','o','n','d',' ','\x02','l','i','m','i','t',' ','i','m','p','o','s','e','d',' ','\xdb','\x02','\x92','\xa9','\x02','f','i','l','e','s','y','s','t','e','m','.',
/* 0x03dd6 = "The media translation hasn\'t been set yet, so it cannot be obtained." */
    '\x03','m','e','d','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','h','a','s','n','\'','t',' ','\xcd','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xcf','\xa4','o','b','t','a','i','n','e','d','.',
/* 0x03e0b = "Process Verification Failure: The ImageCharacteristics of the process does not match the value in the file header in the exe file." */
    '\x1e','\x0d','\x12','\x03','I','m','a','g','e','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x15','\x02','\x92','\xb2','\x07','m','a','t','c','h',' ','\x02','\xf5','\x0f','\x02','\x22','\xb4','\x0f','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x03e40 = "The trace log reader iterator reached the end of the event list." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','r','e','a','d','e','r',' ','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','e','v','e','n','t',' ','l','i','s','t','.',
/* 0x03e75 = "Internal EM error caused by an unknown warning or informational status code." */
    '\x08','E','M',' ','\x09','c','a','u','s','e','d',' ','\xdb','\x87','u','n','k','n','o','w','n',' ','w','a','r','n','i','n','g',' ','\xa9','i','n','f','o','r','m','a','t','i','o','n','a','l',' ','s','t','a','t','u','s',' ','\x84',
/* 0x03eaa = "Malformed initialization vector for encrypted key ciper." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x03edf = "Encountered an unsupported portable archive exchange (pax) header." */
    '\xa6','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','p','o','r','t','a','b','l','e',' ','a','r','c','h','i','v','e',' ','e','x','c','h','a','n','g','e',' ','(','p','a','x',')',' ','h','e','a','d','e','r','.',
/* 0x03f14 = "Internal processing error in the PGM physical page mapping code dealing with MMIO2 pages." */
    '\x08','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','\xbe','m','a','p','p','i','n','g',' ','c','o','d','e',' ','d','e','a','l','i','n','g',' ','\x7f','M','M','I','O','2',' ','p','a','g','e','s','.',
/* 0x03f49 = "CPU is not in VMX root mode; unexpected when leaving VMX root mode." */
    'C','P','U',' ','\x0b','\x07','\x0f','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','u','n','e','x','p','e','c','t','e','d',' ','w','h','e','n',' ','\x81','V','M','X',' ','r','o','o','t',' ','m','o','d','e','.',
/* 0x03f7e = "The CSRSS instance associated with the client process could not be located." */
    '\x03','C','S','R','S','S',' ','i','n','s','t','a','n','c','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x7f','\x02','c','l','i','e','n','t',' ','\x92','c','o','u','l','d',' ','\x07','\xa4','l','o','c','a','t','e','d','.',
/* 0x03fb3 = "The loader resolved an external symbol to an address to big for the image format." */
    '\x03','\xda','r','e','s','o','l','v','e','d',' ','\x87','e','x','t','e','r','n','a','l',' ','s','y','m','b','o','l',' ','\x0a','\x87','a','d','d','r','e','s','s',' ','\x0a','b','i','g',' ','\x10','\x02','\x26','f','o','r','m','a','t','.',
/* 0x03fe8 = "Error creating an event semaphore for used with asynchronous reads." */
    '\xc1','c','r','e','a','t','i','n','g',' ','\x87','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x10','u','s','e','d',' ','\x7f','a','s','y','n','c','h','r','o','n','o','u','s',' ','r','e','a','d','s','.',
/* 0x0401d = "File access error, another process has locked a portion of the file." */
    'F','i','l','e',' ','a','c','c','e','s','s',' ','e','r','r','o','r',',',' ','a','n','o','t','h','e','r',' ','\x92','\x5c','l','o','c','k','e','d',' ','a',' ','p','o','r','t','i','o','n',' ','\x15','\x02','f','i','l','e','.',
/* 0x04052 = "command processing is pending, a completion handler will be called." */
    'c','o','m','m','a','n','d',' ','\x04','\x0b','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\xa4','c','a','l','l','e','d','.',
/* 0x04087 = "Recompiled execution: Breaking out because of FFs or/and IRQs." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k','i','n','g',' ','o','u','t',' ','\x2a','\x15','F','F','s',' ','o','r','/','a','n','d',' ','I','R','Q','s','.',
/* 0x040bc = "The uncompressed table of content size in the header didn\'t match what ZLib returned." */
    '\x03','u','n','c','o','m','p','r','e','s','s','e','d',' ','\xb1','\x15','\xf0','\xf8','\x0f','\x02','\xb4','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','w','h','a','t',' ','Z','L','i','b',' ','r','e','t','u','r','n','e','d','.',
/* 0x040f1 = "The backend needs more metadata before it can continue." */
    '\x03','b','a','c','k','e','n','d',' ','n','e','e','d','s',' ','m','o','r','e',' ','m','e','t','a','d','a','t','a',' ','b','e','f','o','r','e',' ','i','t',' ','c','a','n',' ','c','o','n','t','i','n','u','e','.',
/* 0x04125 = "RTGetOpt: Command line option has argument with bad format." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x5c','a','r','g','u','m','e','n','t',' ','\x7f','b','a','d',' ','f','o','r','m','a','t','.',
/* 0x04159 = "To short initialization vector for encrypted key ciper." */
    'T','o',' ','s','h','o','r','t',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x0418d = "The networking interface to filter was busy (used by someone)." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x0a','f','i','l','t','e','r',' ','\x11','b','u','s','y',' ','(','u','s','e','d',' ','\xdb','s','o','m','e','o','n','e',')','.',
/* 0x041c1 = "Cannot add symbolic link to one of the selected namespaces." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x0a','o','n','e',' ','\x15','\x02','s','e','l','e','c','t','e','d',' ','n','a','m','e','s','p','a','c','e','s','.',
/* 0x041f5 = "Returns by rep-prefixed string instruction if they yield because of pending FFs." */
    'R','e','t','u','r','n','s',' ','\xdb','r','e','p','-','p','r','e','f','i','x','e','d',' ','\xf2','\xdc','i','f',' ','t','h','e','y',' ','y','i','e','l','d',' ','\x2a','\x15','p','e','n','d','i','n','g',' ','F','F','s','.',
/* 0x04229 = "The physical handler range has no corresponding RAM range." */
    '\x03','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','r','a','n','g','e',' ','\x5c','n','o',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','A','M',' ','r','a','n','g','e','.',
/* 0x0425d = "The DTB being parsed has an invalid size set in the header compared to the actual size." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','\x87','\x8f','\xf8','s','e','t',' ','\x0f','\x02','\xb4','c','o','m','p','a','r','e','d',' ','\x0a','\x02','a','c','t','u','a','l',' ','s','i','z','e','.',
/* 0x04291 = "Escape URI char decodes as zero (the C string terminator)." */
    'E','s','c','a','p','e',' ','U','R','I',' ','c','h','a','r',' ','d','e','c','o','d','e','s',' ','a','s',' ','z','e','r','o',' ','(','t','h','e',' ','C',' ','\xf2','t','e','r','m','i','n','a','t','o','r',')','.',
/* 0x042c5 = "Invalid nested hardware virtualization feature combination." */
    '\x0c','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x042f9 = "Syntax error - Cannot read symbol value, it is a set-only symbol." */
    '\xfb','\x09','-',' ','C','a','n','n','o','t',' ','r','e','a','d',' ','s','y','m','b','o','l',' ','v','a','l','u','e',',',' ','i','t',' ','\x0b','a',' ','s','e','t','-','o','n','l','y',' ','s','y','m','b','o','l','.',
/* 0x0432d = "RTThreadYield was called during a GVMMR0SchedPoll call." */
    'R','T','T','h','r','e','a','d','Y','i','e','l','d',' ','\x11','c','a','l','l','e','d',' ','d','u','r','i','n','g',' ','a',' ','G','V','M','M','R','0','S','c','h','e','d','P','o','l','l',' ','c','a','l','l','.',
/* 0x04361 = "Internal processing error in the PGM physcal page handling code related to MMIO/MMIO2." */
    '\x08','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','c','a','l',' ','\xbe','h','a','n','d','l','i','n','g',' ','c','o','d','e',' ','r','e','l','a','t','e','d',' ','\x0a','M','M','I','O','/','M','M','I','O','2','.',
/* 0x04395 = "Attempt to free more memory than what was previously allocated." */
    'A','t','t','e','m','p','t',' ','\x0a','f','r','e','e',' ','m','o','r','e',' ','\x86','t','h','a','n',' ','w','h','a','t',' ','\x11','p','r','e','v','i','o','u','s','l','y',' ','a','l','l','o','c','a','t','e','d','.',
/* 0x043c9 = "The timer has a bad clock enum value, probably corruption." */
    '\x03','t','i','m','e','r',' ','\x5c','a',' ','b','a','d',' ','c','l','o','c','k',' ','e','n','u','m',' ','v','a','l','u','e',',',' ','p','r','o','b','a','b','l','y',' ','c','o','r','r','u','p','t','i','o','n','.',
/* 0x043fd = "Host API has not set a valid physical address of host-state area." */
    'H','o','s','t',' ','A','P','I',' ','\x5c','\x07','s','e','t',' ','a',' ','v','a','l','i','d',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','\x15','h','o','s','t','-','\xcc','a','r','e','a','.',
/* 0x04431 = "Found a ZIP64 Extra Information Field in a ZIP32 file." */
    'F','o','u','n','d',' ','a',' ','Z','I','P','6','4',' ','E','x','t','r','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','F','i','e','l','d',' ','\x0f','a',' ','Z','I','P','3','2',' ','f','i','l','e','.',
/* 0x04465 = "Cannot destroy VM because not all other EMTs have deregistered." */
    'C','a','n','n','o','t',' ','d','e','s','t','r','o','y',' ','\xc6',' ','\x2a','\x07','a','l','l',' ','o','t','h','e','r',' ','E','M','T','s',' ','h','a','v','e',' ','d','e','r','e','g','i','s','t','e','r','e','d','.',
/* 0x04499 = "The page hash table hashes data outside the defined and implicit sections." */
    '\x03','\xbe','h','a','s','h',' ','\xb1','h','a','s','h','e','s',' ','\x9d','o','u','t','s','i','d','e',' ','\x02','d','e','f','i','n','e','d',' ','\x9a','i','m','p','l','i','c','i','t',' ','s','e','c','t','i','o','n','s','.',
/* 0x044cd = "Process Verification Failure: A DLL residing outside System32 was found in the process." */
    '\x1e','\x0d','\x12','A',' ','D','L','L',' ','r','e','s','i','d','i','n','g',' ','o','u','t','s','i','d','e',' ','S','y','s','t','e','m','3','2',' ','\x11','f','o','u','n','d',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x04501 = "No allocation descriptors for non-zero sized UDF object." */
    '\xe0','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x10','n','o','n','-','z','e','r','o',' ','s','i','z','e','d',' ','U','D','F',' ','o','b','j','e','c','t','.',
/* 0x04534 = "Logging is disabled or logger instance could not be created." */
    'L','o','g','g','i','n','g',' ','\x0b','d','i','s','a','b','l','e','d',' ','\xa9','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x07','\xa4','c','r','e','a','t','e','d','.',
/* 0x04567 = "Process Verification Failure: Found no executable mapped into the process address space." */
    '\x1e','\x0d','\x12','F','o','u','n','d',' ','n','o',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','\x92','a','d','d','r','e','s','s',' ','s','p','a','c','e','.',
/* 0x0459a = "The chosen baudrate is invalid or not supported by the given serial port." */
    '\x03','c','h','o','s','e','n',' ','b','a','u','d','r','a','t','e',' ','\x0b','\x8f','\xa9','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','\x02','g','i','v','e','n',' ','s','e','r','i','a','l',' ','p','o','r','t','.',
/* 0x045cd = "Vote for done tell SSM not to call again until the final pass." */
    'V','o','t','e',' ','\x10','d','o','n','e',' ','t','e','l','l',' ','S','S','M',' ','\x07','\x0a','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x04600 = "The Host Interface Networking name config IOCTL call failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','n','a','m','e',' ','c','o','n','f','i','g',' ','I','O','C','T','L',' ','c','a','l','l',' ','\x7b',
/* 0x04633 = "A TSC-delta measurement request is currently being serviced." */
    'A',' ','T','S','C','-','d','e','l','t','a',' ','m','e','a','s','u','r','e','m','e','n','t',' ','\xab','\x0b','c','u','r','r','e','n','t','l','y',' ','b','e','i','n','g',' ','s','e','r','v','i','c','e','d','.',
/* 0x04666 = "Import ISO contains a directory with a more than one extent, that\'s currently not supported." */
    '\xc4','\xc2',' ','\x8a','a',' ','\x25','\x7f','a',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','e','x','t','e','n','t',',',' ','t','h','a','t','\'','s',' ','c','u','r','r','e','n','t','l','y',' ','\x07','\xa5',
/* 0x04699 = "The version of the USB device registration structure is unknown to this VBox version." */
    '\x03','\xd1','\x15','\x02','U','S','B',' ','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xec','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x046cc = "The boot catalog validation entry in the import ISO has an incorrect checksum." */
    '\x03','b','o','o','t',' ','\xe7','v','a','l','i','d','a','t','i','o','n',' ','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','\x87','i','n','c','o','r','r','e','c','t',' ','c','h','e','c','k','s','u','m','.',
/* 0x046ff = "Import ISO starts with supplementary volume descriptor before any primary ones." */
    '\xc4','\xc2',' ','s','t','a','r','t','s',' ','\x7f','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd3','\xe3','b','e','f','o','r','e',' ','a','n','y',' ','p','r','i','m','a','r','y',' ','o','n','e','s','.',
/* 0x04732 = "Operation can\'t be done in current HDD container state." */
    'O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa4','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','H','D','D',' ','c','o','n','t','a','i','n','e','r',' ','s','t','a','t','e','.',
/* 0x04765 = "The machine (cputype / cpusubtype combination) isn\'t supported." */
    '\x03','m','a','c','h','i','n','e',' ','(','c','p','u','t','y','p','e',' ','/',' ','c','p','u','s','u','b','t','y','p','e',' ','c','o','m','b','i','n','a','t','i','o','n',')',' ','i','s','n','\'','t',' ','\xa5',
/* 0x04798 = "Number of tries to add an int3 breakpoint table to the lookup tables reached." */
    'N','u','m','b','e','r',' ','\x15','t','r','i','e','s',' ','\x0a','a','d','d',' ','\x87','i','n','t','3',' ','\xc0','\xb1','\x0a','\x02','l','o','o','k','u','p',' ','t','a','b','l','e','s',' ','r','e','a','c','h','e','d','.',
/* 0x047cb = "The boot catalog block in the import ISO has an incorrect validation header ID." */
    '\x03','b','o','o','t',' ','\xe7','b','l','o','c','k',' ','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','\x87','i','n','c','o','r','r','e','c','t',' ','v','a','l','i','d','a','t','i','o','n',' ','\xb4','I','D','.',
/* 0x047fe = "pgmPhysPageMapCommon encountered PGMPAGETYPE_MMIO2_ALIAS_MMIO." */
    'p','g','m','P','h','y','s','P','a','g','e','M','a','p','C','o','m','m','o','n',' ','\xaf','P','G','M','P','A','G','E','T','Y','P','E','_','M','M','I','O','2','_','A','L','I','A','S','_','M','M','I','O','.',
/* 0x04831 = "Not possible to detach a driver because the above driver/device doesn't support it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','d','e','t','a','c','h',' ','a',' ','\xc7','\x2a','\x02','a','b','o','v','e',' ','d','r','i','v','e','r','/','d','e','v','i','c','e',' ','\xc9','\xd0','i','t','.',
/* 0x04864 = "The size of the one or more regions in the shared module was out of range." */
    '\x03','\xf8','\x15','\x02','o','n','e',' ','\xa9','m','o','r','e',' ','r','e','g','i','o','n','s',' ','\x0f','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x04896 = "The Logical Unit was found, but it had no driver attached to it." */
    '\x03','L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x11','f','o','u','n','d',',',' ','b','u','t',' ','i','t',' ','h','a','d',' ','n','o',' ','\xc7','a','t','t','a','c','h','e','d',' ','\x0a','i','t','.',
/* 0x048c8 = "The physical guest page is a reserved/MMIO page and does not have any HC address." */
    '\x03','p','h','y','s','i','c','a','l',' ','\xbb','\xbe','\x0b','a',' ','r','e','s','e','r','v','e','d','/','\xd4',' ','\xbe','\x9a','\xb2','\x07','h','a','v','e',' ','a','n','y',' ','H','C',' ','a','d','d','r','e','s','s','.',
/* 0x048fa = "Support for sparable partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','s','p','a','r','a','b','l','e',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x07','y','e','t',' ','\xcd','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0492c = "The breakpoint owner handle is still used by one or more breakpoints." */
    '\x03','\xc0','o','w','n','e','r',' ','h','a','n','d','l','e',' ','\x0b','s','t','i','l','l',' ','u','s','e','d',' ','\xdb','o','n','e',' ','\xa9','m','o','r','e',' ','b','r','e','a','k','p','o','i','n','t','s','.',
/* 0x0495e = "A VM api requiring EMT was called from another thread." */
    'A',' ','\xc6',' ','a','p','i',' ','r','e','q','u','i','r','i','n','g',' ','E','M','T',' ','\x11','c','a','l','l','e','d',' ','f','r','o','m',' ','a','n','o','t','h','e','r',' ','t','h','r','e','a','d','.',
/* 0x04990 = "Certificate path validator: Intermediate certificate is missing the KeyCertSign usage flag." */
    '\xba','\xd2','\xff','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','\x0b','m','i','s','s','i','n','g',' ','\x02','K','e','y','C','e','r','t','S','i','g','n',' ','u','s','a','g','e',' ','f','l','a','g','.',
/* 0x049c2 = "The specified execution engine cannot execute guest code in the current state." */
    '\x03','\x18','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xcf','e','x','e','c','u','t','e',' ','\xbb','c','o','d','e',' ','\x0f','\x02','c','u','r','r','e','n','t',' ','s','t','a','t','e','.',
/* 0x049f4 = "The image is required to be signed with the same certificate as the rest of VirtualBox." */
    '\x03','\x26','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','\xa4','s','i','g','n','e','d',' ','\x7f','\x02','s','a','m','e',' ','\xa0','a','s',' ','\x02','r','e','s','t',' ','\x15','V','i','r','t','u','a','l','B','o','x','.',
/* 0x04a26 = "Object corresponding to the supplied arguments does not exist." */
    'O','b','j','e','c','t',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','\x0a','\x02','s','u','p','p','l','i','e','d',' ','a','r','g','u','m','e','n','t','s',' ','\xb2','\x07','e','x','i','s','t','.',
/* 0x04a58 = "Certificate path validator: Hit the max certificate path length before reaching trust anchor." */
    '\xba','\xd2','\xff','H','i','t',' ','\x02','m','a','x',' ','\xa0','\xd2','l','e','n','g','t','h',' ','b','e','f','o','r','e',' ','r','e','a','c','h','i','n','g',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x04a8a = "Image Verification Failure: Error allocating memory for authenticode signature data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x10','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x04abc = "Asynchronous stream initialization still on-going." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','s','t','r','e','a','m',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','i','l','l',' ','o','n','-','g','o','i','n','g','.',
/* 0x04aee = "Found unexpected cipher parameters for encrypted key." */
    'F','o','u','n','d',' ','u','n','e','x','p','e','c','t','e','d',' ','c','i','p','h','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x04b20 = "The media geometry hasn\'t been set yet, so it cannot be obtained." */
    '\x03','m','e','d','i','a',' ','g','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xcd','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xcf','\xa4','o','b','t','a','i','n','e','d','.',
/* 0x04b52 = "Unable to seal text memory again to protect against write access (hardening)." */
    '\xe1','\x0a','s','e','a','l',' ','t','e','x','t',' ','\x86','a','g','a','i','n',' ','\x0a','p','r','o','t','e','c','t',' ','a','g','a','i','n','s','t',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\xae',
/* 0x04b84 = "The I/O queue has requests pending which need complete first." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x5c','r','e','q','u','e','s','t','s',' ','p','e','n','d','i','n','g',' ','\xed','n','e','e','d',' ','c','o','m','p','l','e','t','e',' ','f','i','r','s','t','.',
/* 0x04bb6 = "The patch manager is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','p','a','t','c','h',' ','m','a','n','a','g','e','r',' ','\x0b','\x07','u','s','e','d',' ','\x2a','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x9a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x04be8 = "Support for metadata partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','m','e','t','a','d','a','t','a',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x07','y','e','t',' ','\xcd','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04c1a = "SPC requires there to be exactly one SignerInfo entry." */
    'S','P','C',' ','r','e','q','u','i','r','e','s',' ','t','h','e','r','e',' ','\x0a','\xa4','e','x','a','c','t','l','y',' ','o','n','e',' ','S','i','g','n','e','r','I','n','f','o',' ','e','n','t','r','y','.',
/* 0x04c4c = "The network already exists with a different trunk configuration." */
    '\x03','n','e','t','w','o','r','k',' ','\x80','e','x','i','s','t','s',' ','\x7f','a',' ','d','i','f','f','e','r','e','n','t',' ','t','r','u','n','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x04c7e = "A attach or prepare mount call failed because the driver already had a driver attached." */
    'A',' ','a','t','t','a','c','h',' ','\xa9','p','r','e','p','a','r','e',' ','m','o','u','n','t',' ','c','a','l','l',' ','\x99','\x2a','\x02','\xc7','\x80','h','a','d',' ','a',' ','\xc7','a','t','t','a','c','h','e','d','.',
/* 0x04cb0 = "Out of memory condition when allocating executable memory." */
    'O','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x04ce2 = "The release call only release a semaphore nesting, i." */
    '\x03','r','e','l','e','a','s','e',' ','c','a','l','l',' ','o','n','l','y',' ','r','e','l','e','a','s','e',' ','a',' ','s','e','m','a','p','h','o','r','e',' ','n','e','s','t','i','n','g',',',' ','i','.',
/* 0x04d14 = "Maximum of concurrent clipboard transfers has been reached." */
    'M','a','x','i','m','u','m',' ','\x15','c','o','n','c','u','r','r','e','n','t',' ','c','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r','s',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x04d46 = "Non-standard descriptor character set in the logical volume descriptor." */
    'N','o','n','-','s','t','a','n','d','a','r','d',' ','\xe3','c','h','a','r','a','c','t','e','r',' ','s','e','t',' ','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x04d78 = "Don\'t spin for the semaphore, but it is safe to try grab it." */
    'D','o','n','\'','t',' ','s','p','i','n',' ','\x10','\x02','s','e','m','a','p','h','o','r','e',',',' ','b','u','t',' ','i','t',' ','\x0b','s','a','f','e',' ','\x0a','t','r','y',' ','g','r','a','b',' ','i','t','.',
/* 0x04daa = "Failed to initialize a virtual network interface instance." */
    '\x8b','\x0a','i','n','i','t','i','a','l','i','z','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x04ddc = "The ELF image was created for an unsupported target machine type." */
    '\x03','E','L','F',' ','\x26','\x11','c','r','e','a','t','e','d',' ','\x10','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','t','y','p','e','.',
/* 0x04e0d = "Support for virtual partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','v','i','r','t','u','a','l',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x07','y','e','t',' ','\xcd','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04e3e = "Resume guest execution after injecting a double-fault." */
    'R','e','s','u','m','e',' ','\xbb','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','i','n','j','e','c','t','i','n','g',' ','a',' ','d','o','u','b','l','e','-','f','a','u','l','t','.',
/* 0x04e6f = "Mismatching SVN revision number between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','S','V','N',' ','r','e','v','i','s','i','o','n',' ','\xfc','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x04ea0 = "Found file, but it didn\'t match the search criteria." */
    'F','o','u','n','d',' ','f','i','l','e',',',' ','b','u','t',' ','i','t',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','s','e','a','r','c','h',' ','c','r','i','t','e','r','i','a','.',
/* 0x04ed1 = "Reading from the image was not possible because the offset is out of the image range." */
    'R','e','a','d','i','n','g',' ','f','r','o','m',' ','\x02','\x26','\x11','\x07','p','o','s','s','i','b','l','e',' ','\x2a','\x02','o','f','f','s','e','t',' ','\x0b','o','u','t',' ','\x15','\x02','\x26','r','a','n','g','e','.',
/* 0x04f02 = "Page fault caused by dirty bit tracking; corrected." */
    'P','a','g','e',' ','f','a','u','l','t',' ','c','a','u','s','e','d',' ','\xdb','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g',';',' ','c','o','r','r','e','c','t','e','d','.',
/* 0x04f33 = "Certificate path validator: Name constraints does not permits the alternative certificate name." */
    '\xba','\xd2','\xff','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\xb2','\x07','p','e','r','m','i','t','s',' ','\x02','a','l','t','e','r','n','a','t','i','v','e',' ','\xa0','n','a','m','e','.',
/* 0x04f64 = "No trace buffer available, please change the VM config." */
    '\xe0','t','r','a','c','e',' ','b','u','f','f','e','r',' ','a','v','a','i','l','a','b','l','e',',',' ','p','l','e','a','s','e',' ','c','h','a','n','g','e',' ','\x02','\xc6',' ','c','o','n','f','i','g','.',
/* 0x04f95 = "Unable to open the host interface due to a sharing violation ." */
    '\xe1','\x0a','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','d','u','e',' ','\x0a','a',' ','s','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',' ','.',
/* 0x04fc6 = "This particular aspect of the instruction is not yet implemented by IEM." */
    'T','h','i','s',' ','p','a','r','t','i','c','u','l','a','r',' ','a','s','p','e','c','t',' ','\x15','\x02','\xdc','\x0b','\x07','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xdb','I','E','M','.',
/* 0x04ff7 = "Bogus length for continuation allocation descriptor." */
    'B','o','g','u','s',' ','l','e','n','g','t','h',' ','\x10','c','o','n','t','i','n','u','a','t','i','o','n',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x05028 = "Sharing violation, file is being used by another process." */
    'S','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',',',' ','\x22','\x0b','b','e','i','n','g',' ','u','s','e','d',' ','\xdb','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x05059 = "The segment index specified when adding a new segment is already in use." */
    '\x03','s','e','g','m','e','n','t',' ','i','n','d','e','x',' ','\x18','w','h','e','n',' ','a','d','d','i','n','g',' ','a',' ','n','e','w',' ','s','e','g','m','e','n','t',' ','\x0b','\x80','\x0f','u','s','e','.',
/* 0x0508a = "Failed to create or connect to a networking interface filter." */
    '\x8b','\x0a','c','r','e','a','t','e',' ','\xa9','c','o','n','n','e','c','t',' ','\x0a','a',' ','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','f','i','l','t','e','r','.',
/* 0x050bb = "The TCP server was shut down using RTTcpServerShutdown." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x11','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','T','c','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x050ec = "Process Verification Failure: The memory protection of a image file section does not match what the section header prescribes." */
    '\x1e','\x0d','\x12','\x03','\x86','p','r','o','t','e','c','t','i','o','n',' ','\x15','a',' ','\x26','\x22','\xdd','\xb2','\x07','m','a','t','c','h',' ','w','h','a','t',' ','\x02','\xdd','\xb4','p','r','e','s','c','r','i','b','e','s','.',
/* 0x0511d = "The UDP server was shut down using RTUdpServerShutdown." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x11','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','U','d','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x0514e = "The PE loader encountered an unknown load config directory/header size." */
    '\x03','P','E',' ','\xda','\xaf','\x87','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','n','f','i','g',' ','d','i','r','e','c','t','o','r','y','/','h','e','a','d','e','r',' ','s','i','z','e','.',
/* 0x0517f = "Internal error: Supposedly unreachable default case in a switch." */
    '\x08','\xd9','S','u','p','p','o','s','e','d','l','y',' ','u','n','r','e','a','c','h','a','b','l','e',' ','d','e','f','a','u','l','t',' ','c','a','s','e',' ','\x0f','a',' ','s','w','i','t','c','h','.',
/* 0x051af = "The iprt loader recognized a ELF image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','a',' ','E','L','F',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc9','\xd0','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x051df = "Failed to write to a memory region while performing a hypercall." */
    '\x8b','\x0a','w','r','i','t','e',' ','\x0a','a',' ','\x86','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x0520f = "Essential fields in the shared VM structure doesn't match the global one." */
    'E','s','s','e','n','t','i','a','l',' ','f','i','e','l','d','s',' ','\x0f','\x02','s','h','a','r','e','d',' ','\xc6',' ','\xec','\xc9','m','a','t','c','h',' ','\x02','g','l','o','b','a','l',' ','o','n','e','.',
/* 0x0523f = "The DTB structs block contains a malformed padding at the end." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','a',' ','m','a','l','f','o','r','m','e','d',' ','p','a','d','d','i','n','g',' ','a','t',' ','\x02','e','n','d','.',
/* 0x0526f = "Reason for leaving RZ: Defer the owner callback invocation to Ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','D','e','f','e','r',' ','\x02','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','i','n','v','o','c','a','t','i','o','n',' ','\x0a','R','i','n','g','-','3','.',
/* 0x0529f = "Attempt to recursively enter a non-recursive lock." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','c','u','r','s','i','v','e','l','y',' ','e','n','t','e','r',' ','a',' ','n','o','n','-','r','e','c','u','r','s','i','v','e',' ','l','o','c','k','.',
/* 0x052cf = "The MMIO handler experienced a problem with the disassembler." */
    '\x03','\xd4',' ','h','a','n','d','l','e','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','a',' ','p','r','o','b','l','e','m',' ','\x7f','\x02','d','i','s','a','s','s','e','m','b','l','e','r','.',
/* 0x052ff = "Only one PCI function is supported per PDM device." */
    'O','n','l','y',' ','o','n','e',' ','P','C','I',' ','f','u','n','c','t','i','o','n',' ','\x0b','s','u','p','p','o','r','t','e','d',' ','p','e','r',' ','P','D','M',' ','d','e','v','i','c','e','.',
/* 0x0532f = "Expected PKCS #7 object to contain exactly on signer info entry." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','c','o','n','t','a','i','n',' ','e','x','a','c','t','l','y',' ','o','n',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','e','n','t','r','y','.',
/* 0x0535f = "The VirtualBox version is not supported by one of the extension packs." */
    '\x03','V','i','r','t','u','a','l','B','o','x',' ','\xd1','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','o','n','e',' ','\x15','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',
/* 0x0538f = "Escaped URI character is not a valid UTF-8 lead byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','\x0b','\x07','a',' ','v','a','l','i','d',' ','U','T','F','-','8',' ','l','e','a','d',' ','b','y','t','e','.',
/* 0x053bf = "Hit unimplemented glob pattern matching feature." */
    'H','i','t',' ','u','n','i','m','p','l','e','m','e','n','t','e','d',' ','g','l','o','b',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','e','a','t','u','r','e','.',
/* 0x053ef = "The environment variable has been recorded as being unset." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x5c','\xcd','r','e','c','o','r','d','e','d',' ','a','s',' ','b','e','i','n','g',' ','u','n','s','e','t','.',
/* 0x0541f = "VRDP script allowed the packet to be processed further." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','a','l','l','o','w','e','d',' ','\x02','p','a','c','k','e','t',' ','\x0a','\xa4','p','r','o','c','e','s','s','e','d',' ','f','u','r','t','h','e','r','.',
/* 0x0544f = "An entry in the manifest file couldn\'t be interpreted correctly." */
    'A','n',' ','\xca','\x0f','\x02','m','a','n','i','f','e','s','t',' ','\x22','c','o','u','l','d','n','\'','t',' ','\xa4','i','n','t','e','r','p','r','e','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x0547f = "Syntax error - Couldn\'t satisfy a request for a specific result type." */
    '\xfb','\x09','-',' ','C','o','u','l','d','n','\'','t',' ','s','a','t','i','s','f','y',' ','a',' ','\xab','\x10','a',' ','s','p','e','c','i','f','i','c',' ','r','e','s','u','l','t',' ','t','y','p','e','.',
/* 0x054af = "Failed to retrieve a virtual network interface link ID." */
    '\x8b','\x0a','r','e','t','r','i','e','v','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','l','i','n','k',' ','I','D','.',
/* 0x054de = "The iprt loader recognized a LX image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','X',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc9','\xd0','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0550d = "The DTB being parsed has an invalid memory reservation block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','\x87','\x8f','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0553c = "The hash is too long for the key used when signing/verifying." */
    '\x03','h','a','s','h',' ','\x0b','\x9e','l','o','n','g',' ','\x10','\x02','k','e','y',' ','u','s','e','d',' ','w','h','e','n',' ','s','i','g','n','i','n','g','/','v','e','r','i','f','y','i','n','g','.',
/* 0x0556b = "VFS chain element only provides file system stream (fss) objects." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x22','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0559a = "Negative exponent makes no sense to integer math." */
    'N','e','g','a','t','i','v','e',' ','e','x','p','o','n','e','n','t',' ','m','a','k','e','s',' ','n','o',' ','s','e','n','s','e',' ','\x0a','i','n','t','e','g','e','r',' ','m','a','t','h','.',
/* 0x055c9 = "Indicates that we modified the host CR0 (FPU related)." */
    'I','n','d','i','c','a','t','e','s',' ','\xad','w','e',' ','m','o','d','i','f','i','e','d',' ','\x02','h','o','s','t',' ','C','R','0',' ','(','F','P','U',' ','r','e','l','a','t','e','d',')','.',
/* 0x055f8 = "Failed to read to a memory region while performing a hypercall." */
    '\x8b','\x0a','r','e','a','d',' ','\x0a','a',' ','\x86','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x05627 = "The number being converted (string) contained no digits." */
    '\x03','\xfc','b','e','i','n','g',' ','c','o','n','v','e','r','t','e','d',' ','(','s','t','r','i','n','g',')',' ','c','o','n','t','a','i','n','e','d',' ','n','o',' ','d','i','g','i','t','s','.',
/* 0x05656 = "The iprt loader recognized a LE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc9','\xd0','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05685 = "The iprt loader recognized a MZ image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','a',' ','M','Z',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc9','\xd0','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x056b4 = "Someone is trying to write a memory block which is too big to encode." */
    'S','o','m','e','o','n','e',' ','\x0b','t','r','y','i','n','g',' ','\x0a','w','r','i','t','e',' ','a',' ','\x86','b','l','o','c','k',' ','\xed','\x0b','\x9e','b','i','g',' ','\x0a','e','n','c','o','d','e','.',
/* 0x056e3 = "Non fatal Patch Manager analysis phase warning." */
    'N','o','n',' ','f','a','t','a','l',' ','P','a','t','c','h',' ','M','a','n','a','g','e','r',' ','a','n','a','l','y','s','i','s',' ','p','h','a','s','e',' ','w','a','r','n','i','n','g','.',
/* 0x05712 = "Attemted illegal operation in simplified memory management mode." */
    'A','t','t','e','m','t','e','d',' ','i','l','l','e','g','a','l',' ','\x96','\x0f','s','i','m','p','l','i','f','i','e','d',' ','\x86','m','a','n','a','g','e','m','e','n','t',' ','m','o','d','e','.',
/* 0x05741 = "Indicating that EM should single step an instruction." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','E','M',' ','s','h','o','u','l','d',' ','s','i','n','g','l','e',' ','s','t','e','p',' ','\x87','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x05770 = "Malformed partition map table in the logical volume descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb1','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0579f = "The version of the driver registration structure is unknown to this VBox version." */
    '\x03','\xd1','\x15','\x02','\xc7','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xec','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x057ce = "Failed getting cryptographically strong random bytes." */
    '\x8b','g','e','t','t','i','n','g',' ','c','r','y','p','t','o','g','r','a','p','h','i','c','a','l','l','y',' ','s','t','r','o','n','g',' ','r','a','n','d','o','m',' ','b','y','t','e','s','.',
/* 0x057fd = "Encountered a unicode code point which cannot be represented as UTF-16." */
    '\xa6','a',' ','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xed','\xcf','\xa4','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','U','T','F','-','1','6','.',
/* 0x0582c = "GVMM does not support the range of CPUs present/possible on the host." */
    'G','V','M','M',' ','\xb2','\x07','\xd0','\x02','r','a','n','g','e',' ','\x15','C','P','U','s',' ','p','r','e','s','e','n','t','/','p','o','s','s','i','b','l','e',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x0585b = "The iprt loader recognized a NE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','a',' ','N','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc9','\xd0','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0588a = "Certificate path validator: Intermediate certificate is not marked as a certificate authority (CA)." */
    '\xba','\xd2','\xff','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','\x0b','\x07','m','a','r','k','e','d',' ','a','s',' ','a',' ','\xa0','a','u','t','h','o','r','i','t','y',' ','(','C','A',')','.',
/* 0x058b9 = "The version of the device registration structure is unknown to this VBox version." */
    '\x03','\xd1','\x15','\x02','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xec','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x058e8 = "The sections aren\'t ordered by segment as expected by the loader." */
    '\x03','s','e','c','t','i','o','n','s',' ','a','r','e','n','\'','t',' ','o','r','d','e','r','e','d',' ','\xdb','s','e','g','m','e','n','t',' ','a','s',' ','\xcb','\xdb','\x02','l','o','a','d','e','r','.',
/* 0x05917 = "The OS does not support setting the time stamps on a symbolic link." */
    '\x03','O','S',' ','\xb2','\x07','\xd0','s','e','t','t','i','n','g',' ','\x02','t','i','m','e',' ','s','t','a','m','p','s',' ','o','n',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x05946 = "A reboot is needed for completing driver (un)installation." */
    'A',' ','r','e','b','o','o','t',' ','\x0b','n','e','e','d','e','d',' ','\x10','c','o','m','p','l','e','t','i','n','g',' ','\xc7','(','u','n',')','i','n','s','t','a','l','l','a','t','i','o','n','.',
/* 0x05975 = "No debug module interpreter matching the debug info." */
    '\xe0','d','e','b','u','g',' ','m','o','d','u','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','m','a','t','c','h','i','n','g',' ','\x02','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x059a4 = "The argv[0] of an internal application does not match the executable image path (hardening)." */
    '\x03','a','r','g','v','[','0',']',' ','\x15','\x87','\x16','a','p','p','l','i','c','a','t','i','o','n',' ','\xb2','\x07','m','a','t','c','h',' ','\x02','e','x','e','c','u','t','a','b','l','e',' ','\x26','\xd2','\xae',
/* 0x059d3 = "The session has reached the max number of (user mode) providers." */
    '\x03','s','e','s','s','i','o','n',' ','\x5c','r','e','a','c','h','e','d',' ','\x02','m','a','x',' ','\xfc','\x15','(','u','s','e','r',' ','m','o','d','e',')',' ','p','r','o','v','i','d','e','r','s','.',
/* 0x05a02 = "Got an out of memory condition trying to allocate a string." */
    'G','o','t',' ','\x87','o','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','s','t','r','i','n','g','.',
/* 0x05a31 = "The iprt loader recognized a PE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','a',' ','P','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc9','\xd0','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05a60 = "Server response contains unexpected repetitive header field." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x8a','u','n','e','x','p','e','c','t','e','d',' ','r','e','p','e','t','i','t','i','v','e',' ','\xb4','f','i','e','l','d','.',
/* 0x05a8e = "Missing relative distinguished name map entry." */
    'M','i','s','s','i','n','g',' ','r','e','l','a','t','i','v','e',' ','d','i','s','t','i','n','g','u','i','s','h','e','d',' ','n','a','m','e',' ','m','a','p',' ','e','n','t','r','y','.',
/* 0x05abc = "The auto usage cache for the dynamic mapping set is full." */
    '\x03','a','u','t','o',' ','u','s','a','g','e',' ','c','a','c','h','e',' ','\x10','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','s','e','t',' ','\x0b','f','u','l','l','.',
/* 0x05aea = "The boot catalog validation entry in the import ISO has incorrect keys." */
    '\x03','b','o','o','t',' ','\xe7','v','a','l','i','d','a','t','i','o','n',' ','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','i','n','c','o','r','r','e','c','t',' ','k','e','y','s','.',
/* 0x05b18 = "Unsupported create type in an RTVfsObjOpen or RTVfsDirOpenObj call." */
    '\x98','c','r','e','a','t','e',' ','\xf3','\x0f','\x87','R','T','V','f','s','O','b','j','O','p','e','n',' ','\xa9','R','T','V','f','s','D','i','r','O','p','e','n','O','b','j',' ','c','a','l','l','.',
/* 0x05b46 = "The group is a non-system group and it has write access (hardening)." */
    '\x03','g','r','o','u','p',' ','\x0b','a',' ','n','o','n','-','s','y','s','t','e','m',' ','g','r','o','u','p',' ','\x9a','i','t',' ','\x5c','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\xae',
/* 0x05b74 = "Not possible to attach further drivers to the driver." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','a','t','t','a','c','h',' ','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','\x0a','\x02','d','r','i','v','e','r','.',
/* 0x05ba2 = "Import ISO contains a directory record with a mismatching volume sequence number." */
    '\xc4','\xc2',' ','\x8a','a',' ','\x25','r','e','c','o','r','d',' ','\x7f','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xd3','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x05bd0 = "The configuration constructor in main failed due to a COM error." */
    '\x03','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','c','o','n','s','t','r','u','c','t','o','r',' ','\x0f','m','a','i','n',' ','\x99','d','u','e',' ','\x0a','a',' ','C','O','M',' ','\x85',
/* 0x05bfe = "An EMT called an API which cannot be called on such a thread." */
    'A','n',' ','E','M','T',' ','c','a','l','l','e','d',' ','\x87','A','P','I',' ','\xed','\xcf','\xa4','c','a','l','l','e','d',' ','o','n',' ','s','u','c','h',' ','a',' ','t','h','r','e','a','d','.',
/* 0x05c2c = "Unfinished CodeView debug information feature." */
    'U','n','f','i','n','i','s','h','e','d',' ','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','e','a','t','u','r','e','.',
/* 0x05c5a = "A break was detected until all requested data could be received." */
    'A',' ','b','r','e','a','k',' ','\x11','d','e','t','e','c','t','e','d',' ','u','n','t','i','l',' ','a','l','l',' ','\xdf','\x9d','c','o','u','l','d',' ','\xa4','r','e','c','e','i','v','e','d','.',
/* 0x05c88 = "The Host Interface Networking terminate program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','t','e','r','m','i','n','a','t','e',' ','p','r','o','g','r','a','m',' ','\x7b',
/* 0x05cb6 = "The DTB property name offset points past the string block." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','n','a','m','e',' ','o','f','f','s','e','t',' ','p','o','i','n','t','s',' ','p','a','s','t',' ','\x02','\xf2','b','l','o','c','k','.',
/* 0x05ce4 = "Unknown error while reading the guest GDT during shadow table updating." */
    '\xef','\x09','w','h','i','l','e',' ','r','e','a','d','i','n','g',' ','\x02','\xbb','G','D','T',' ','d','u','r','i','n','g',' ','s','h','a','d','o','w',' ','\xb1','u','p','d','a','t','i','n','g','.',
/* 0x05d12 = "The specified I/O port range was owned by some other device(s)." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x11','o','w','n','e','d',' ','\xdb','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',
/* 0x05d40 = "Failed to create a virtual network interface instance." */
    '\x8b','\x0a','c','r','e','a','t','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x05d6e = "VMPTRLD failed; possibly because of invalid VMCS launch-state." */
    'V','M','P','T','R','L','D',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x2a','\x15','\x8f','V','M','C','S',' ','l','a','u','n','c','h','-','s','t','a','t','e','.',
/* 0x05d9c = "Couldn\'t find any free USB ports to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','f','r','e','e',' ','U','S','B',' ','p','o','r','t','s',' ','\x0a','a','t','t','a','c','h',' ','\x02','\xa3','t','o','.',
/* 0x05dca = "The DTB property payload size does not match the expectations." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xf8','\xb2','\x07','m','a','t','c','h',' ','\x02','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x05df7 = "RTGetOpt: Command line option needs argument." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','a','r','g','u','m','e','n','t','.',
/* 0x05e24 = "The server has not found anything matching the URI given." */
    '\x03','s','e','r','v','e','r',' ','\x5c','\x07','f','o','u','n','d',' ','a','n','y','t','h','i','n','g',' ','m','a','t','c','h','i','n','g',' ','\x02','U','R','I',' ','g','i','v','e','n','.',
/* 0x05e51 = "The message digest of the extracted data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xd8','\x15','\x02','e','x','t','r','a','c','t','e','d',' ','\x9d','\xb2','\x07','m','a','t','c','h',' ','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x05e7e = "The user mode tracepoint provider string table offset is bad." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xf2','\xb1','o','f','f','s','e','t',' ','\x0b','b','a','d','.',
/* 0x05eab = "iSCSI: Operation can\'t be done in current image state." */
    'i','S','C','S','I',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa4','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','\x26','s','t','a','t','e','.',
/* 0x05ed8 = "RTDirReadEx() failed to retrieve the extra data which was requested." */
    'R','T','D','i','r','R','e','a','d','E','x','(',')',' ','\x99','\x0a','r','e','t','r','i','e','v','e',' ','\x02','e','x','t','r','a',' ','\x9d','\xed','\x11','r','e','q','u','e','s','t','e','d','.',
/* 0x05f05 = "The intercepted operation was not handled, take default action." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\x96','\x11','\x07','h','a','n','d','l','e','d',',',' ','t','a','k','e',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x05f32 = "Image Verification Failure: Error reading authenticode signature data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','r','e','a','d','i','n','g',' ','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x05f5f = "The digest algorithm in the SignerInfo does not match the one in the indirect data." */
    '\x03','\xd8','\xd5','\x0f','\x02','S','i','g','n','e','r','I','n','f','o',' ','\xb2','\x07','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','i','n','d','i','r','e','c','t',' ','d','a','t','a','.',
/* 0x05f8c = "A path is not relative (start with root), expected an relative path." */
    'A',' ','\xd2','\x0b','\x07','r','e','l','a','t','i','v','e',' ','(','s','t','a','r','t',' ','\x7f','r','o','o','t',')',',',' ','\xcb','\x87','r','e','l','a','t','i','v','e',' ','p','a','t','h','.',
/* 0x05fb9 = "Somebody cleared X86_CR4_VMXE in the CR4 register." */
    'S','o','m','e','b','o','d','y',' ','c','l','e','a','r','e','d',' ','X','8','6','_','C','R','4','_','V','M','X','E',' ','\x0f','\x02','C','R','4',' ','r','e','g','i','s','t','e','r','.',
/* 0x05fe6 = "IOMGCIOPortHandler was given an unexpected opcode." */
    'I','O','M','G','C','I','O','P','o','r','t','H','a','n','d','l','e','r',' ','\x11','g','i','v','e','n',' ','\x87','u','n','e','x','p','e','c','t','e','d',' ','o','p','c','o','d','e','.',
/* 0x06013 = "PKCS #7 singer info contains no issuer serial number." */
    'P','K','C','S',' ','#','7',' ','s','i','n','g','e','r',' ','i','n','f','o',' ','\x8a','n','o',' ','i','s','s','u','e','r',' ','s','e','r','i','a','l',' ','n','u','m','b','e','r','.',
/* 0x06040 = "The page is unassigned (akin to VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS)." */
    '\x03','\xbe','\x0b','u','n','a','s','s','i','g','n','e','d',' ','(','a','k','i','n',' ','\x0a','\x01','\x8c','\x05','G','C','_','P','H','Y','S','I','C','A','L','_','A','D','D','R','E','S','S',')','.',
/* 0x0606d = "The I/O queue is full and can\'t accept more requests." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x0b','f','u','l','l',' ','\x9a','c','a','n','\'','t',' ','a','c','c','e','p','t',' ','m','o','r','e',' ','r','e','q','u','e','s','t','s','.',
/* 0x0609a = "Unexpected PCI region change during VGA saved state loading." */
    '\x94','P','C','I',' ','r','e','g','i','o','n',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','V','G','A',' ','s','a','v','e','d',' ','\xcc','l','o','a','d','i','n','g','.',
/* 0x060c7 = "Not able satisfy all the requirements of the request." */
    'N','o','t',' ','a','b','l','e',' ','s','a','t','i','s','f','y',' ','a','l','l',' ','\x02','r','e','q','u','i','r','e','m','e','n','t','s',' ','\x15','\x02','r','e','q','u','e','s','t','.',
/* 0x060f4 = "The default boot catalog entry in the import ISO an invalid boot indicator value." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x87','\x8f','b','o','o','t',' ','i','n','d','i','c','a','t','o','r',' ','\xe8',
/* 0x06121 = "Repairing the image is not possible because the corruption is to severe." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x26','\x0b','\x07','p','o','s','s','i','b','l','e',' ','\x2a','\x02','c','o','r','r','u','p','t','i','o','n',' ','\x0b','\x0a','s','e','v','e','r','e','.',
/* 0x0614e = "The PE loader doesn't know how to deal with the global pointer data directory entry yet." */
    '\x03','P','E',' ','\xda','\xc9','k','n','o','w',' ','h','o','w',' ','\x0a','d','e','a','l',' ','\x7f','\x02','g','l','o','b','a','l',' ','p','o','i','n','t','e','r',' ','\x9d','\x25','\xca','y','e','t','.',
/* 0x0617b = "The specified I/O port range intruded on an existing range." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','i','n','t','r','u','d','e','d',' ','o','n',' ','\x87','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',
/* 0x061a8 = "Digest algorithm parameters are not supported by the PKCS #7 code." */
    'D','i','g','e','s','t',' ','\xd5','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','\x02','P','K','C','S',' ','#','7',' ','\x84',
/* 0x061d5 = "Maximum number of Shared Clipboard objects has been reached." */
    'M','a','x','i','m','u','m',' ','\xfc','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x06202 = "VFS chain element only provides file and I/O stream (ios) objects." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x22','\x9a','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0622f = "Escaped URI characters does not decode to valid UTF-8." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r','s',' ','\xb2','\x07','d','e','c','o','d','e',' ','\x0a','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x0625c = "Process Verification Failure: The name of an image file changes between mapping regions." */
    '\x1e','\x0d','\x12','\x03','n','a','m','e',' ','\x15','\x87','\x26','\x22','c','h','a','n','g','e','s',' ','b','e','t','w','e','e','n',' ','m','a','p','p','i','n','g',' ','r','e','g','i','o','n','s','.',
/* 0x06289 = "The image is 32-bit and contains 64-bit load commands or vise versa." */
    '\x03','\x26','\x0b','3','2','-','b','i','t',' ','\x9a','\x8a','6','4','-','b','i','t',' ','l','o','a','d',' ','c','o','m','m','a','n','d','s',' ','\xa9','v','i','s','e',' ','v','e','r','s','a','.',
/* 0x062b6 = "The EVP_PKEY_CTX_set_rsa_padding API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','C','T','X','_','s','e','t','_','r','s','a','_','p','a','d','d','i','n','g',' ','A','P','I',' ','\x0f','O','p','e','n','S','S','L',' ','\x7b',
/* 0x062e2 = "A numeric tar header field was not terminated correctly." */
    'A',' ','n','u','m','e','r','i','c',' ','t','a','r',' ','\xb4','f','i','e','l','d',' ','\x11','\x07','t','e','r','m','i','n','a','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x0630e = "VFS chain element takes a directory (dir) or file system (vfs) object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x25','(','d','i','r',')',' ','\xa9','\x22','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x0633a = "Too many readers on read/write critical section." */
    'T','o','o',' ','\xb5','r','e','a','d','e','r','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x06366 = "There are unconsumed bytes after decoding an ASN." */
    'T','h','e','r','e',' ','a','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','b','y','t','e','s',' ','a','f','t','e','r',' ','d','e','c','o','d','i','n','g',' ','\x87','\xf6',
/* 0x06392 = "Server response contains embedded zero character(s)." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x8a','e','m','b','e','d','d','e','d',' ','z','e','r','o',' ','c','h','a','r','a','c','t','e','r','(','s',')','.',
/* 0x063be = "The media is not mounted, operation requires a mounted media." */
    '\x03','m','e','d','i','a',' ','\x0b','\x07','m','o','u','n','t','e','d',',',' ','\x96','r','e','q','u','i','r','e','s',' ','a',' ','m','o','u','n','t','e','d',' ','m','e','d','i','a','.',
/* 0x063ea = "Page hash table is too long (covers signature data, i." */
    'P','a','g','e',' ','h','a','s','h',' ','\xb1','\x0b','\x9e','l','o','n','g',' ','(','c','o','v','e','r','s',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a',',',' ','i','.',
/* 0x06416 = "Recording has been throttled due to current settings." */
    'R','e','c','o','r','d','i','n','g',' ','\x5c','\xcd','t','h','r','o','t','t','l','e','d',' ','d','u','e',' ','\x0a','c','u','r','r','e','n','t',' ','s','e','t','t','i','n','g','s','.',
/* 0x06442 = "Error while characters translation (unicode and so)." */
    '\xc1','w','h','i','l','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','(','u','n','i','c','o','d','e',' ','\x9a','s','o',')','.',
/* 0x0646e = "Exclusive semaphore is owned by another process." */
    'E','x','c','l','u','s','i','v','e',' ','s','e','m','a','p','h','o','r','e',' ','\x0b','o','w','n','e','d',' ','\xdb','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0649a = "(One) receive buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','r','e','c','e','i','v','e',' ','b','u','f','f','e','r',' ','\x11','\x9e','s','m','a','l','l',',',' ','\xa9','\x9e','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x064c6 = "Recording is not possible due to a set restriction." */
    'R','e','c','o','r','d','i','n','g',' ','\x0b','\x07','p','o','s','s','i','b','l','e',' ','d','u','e',' ','\x0a','a',' ','s','e','t',' ','r','e','s','t','r','i','c','t','i','o','n','.',
/* 0x064f2 = "PKIX signature no does not match up to the current data." */
    'P','K','I','X',' ','s','i','g','n','a','t','u','r','e',' ','n','o',' ','\xb2','\x07','m','a','t','c','h',' ','u','p',' ','\x0a','\x02','c','u','r','r','e','n','t',' ','d','a','t','a','.',
/* 0x0651e = "Only regular files supported by the UDF importer." */
    'O','n','l','y',' ','r','e','g','u','l','a','r',' ','f','i','l','e','s',' ','s','u','p','p','o','r','t','e','d',' ','\xdb','\x02','U','D','F',' ','i','m','p','o','r','t','e','r','.',
/* 0x0654a = "The ring-0 function is not supported for this VM target." */
    '\x03','r','i','n','g','-','0',' ','f','u','n','c','t','i','o','n',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\x10','t','h','i','s',' ','\xc6',' ','t','a','r','g','e','t','.',
/* 0x06576 = "The provided password to decrypt the DEK was incorrect." */
    '\x03','p','r','o','v','i','d','e','d',' ','p','a','s','s','w','o','r','d',' ','\x0a','d','e','c','r','y','p','t',' ','\x02','D','E','K',' ','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x065a2 = "Maximum (context ID object) count has been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',' ','o','b','j','e','c','t',')',' ','c','o','u','n','t',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x065ce = "A boot catalog entry in the import ISO has an image with an indeterminate size." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','\x87','\x26','\x7f','\x87','i','n','d','e','t','e','r','m','i','n','a','t','e',' ','s','i','z','e','.',
/* 0x065fa = "VMDK: Operation can\'t be done in current image state." */
    'V','M','D','K',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa4','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','\x26','s','t','a','t','e','.',
/* 0x06626 = "Failed to fix mappings because a mapping rejected the address." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x2a','a',' ','m','a','p','p','i','n','g',' ','r','e','j','e','c','t','e','d',' ','\x02','a','d','d','r','e','s','s','.',
/* 0x06652 = "Failed to open a virtual network interface instance." */
    '\x8b','\x0a','o','p','e','n',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x0667e = "Maximum (context ID) sessions have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','s','e','s','s','i','o','n','s',' ','h','a','v','e',' ','\xcd','r','e','a','c','h','e','d','.',
/* 0x066aa = "The lock validator detected an existing deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','\x87','e','x','i','s','t','i','n','g',' ','d','e','a','d','l','o','c','k','.',
/* 0x066d6 = "The nested-guest #VMEXIT processing failed, initiate shutdown." */
    '\x03','n','e','s','t','e','d','-','\xbb','#','V','M','E','X','I','T',' ','\x04','f','a','i','l','e','d',',',' ','i','n','i','t','i','a','t','e',' ','s','h','u','t','d','o','w','n','.',
/* 0x06702 = "SSM did a callback for a pass we didn\'t expect." */
    'S','S','M',' ','d','i','d',' ','a',' ','c','a','l','l','b','a','c','k',' ','\x10','a',' ','p','a','s','s',' ','w','e',' ','d','i','d','n','\'','t',' ','e','x','p','e','c','t','.',
/* 0x0672e = "The state doesn't match the VM configuration in one or another way." */
    '\x03','\xcc','\xc9','m','a','t','c','h',' ','\x02','\xc6',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x0f','o','n','e',' ','\xa9','a','n','o','t','h','e','r',' ','w','a','y','.',
/* 0x0675a = "The message digest of the archived data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xd8','\x15','\x02','a','r','c','h','i','v','e','d',' ','\x9d','\xb2','\x07','m','a','t','c','h',' ','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x06786 = "Import ISO contains a root directory with a mismatching volume sequence number." */
    '\xc4','\xc2',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x7f','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xd3','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x067b2 = "Failed to fix mappings because of a conflict with the intermediate code." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x2a','\x15','a',' ','c','o','n','f','l','i','c','t',' ','\x7f','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','\x84',
/* 0x067de = "Reason for leaving RC: Guest tried to write to our LDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','L','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06809 = "A string claiming to be in UTF-16 is incorrectly encoded." */
    'A',' ','\xf2','c','l','a','i','m','i','n','g',' ','\x0a','\xa4','\x0f','U','T','F','-','1','6',' ','\x0b','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x06834 = "The PCI bus assigned to a device didn\'t have room for it." */
    '\x03','P','C','I',' ','b','u','s',' ','a','s','s','i','g','n','e','d',' ','\x0a','a',' ','\xa3','d','i','d','n','\'','t',' ','h','a','v','e',' ','r','o','o','m',' ','\x10','i','t','.',
/* 0x0685f = "The previous ownership of this semaphore has ended." */
    '\x03','p','r','e','v','i','o','u','s',' ','o','w','n','e','r','s','h','i','p',' ','\x15','t','h','i','s',' ','s','e','m','a','p','h','o','r','e',' ','\x5c','e','n','d','e','d','.',
/* 0x0688a = "The maximum posts for the event semaphore has been reached." */
    '\x03','m','a','x','i','m','u','m',' ','p','o','s','t','s',' ','\x10','\x02','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x068b5 = "Too many digest algorithms used by PKCS #7 signed data." */
    'T','o','o',' ','\xb5','\xd8','a','l','g','o','r','i','t','h','m','s',' ','u','s','e','d',' ','\xdb','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x068e0 = "Error extracting a public key from the certificate." */
    '\xc1','e','x','t','r','a','c','t','i','n','g',' ','a',' ','p','u','b','l','i','c',' ','k','e','y',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0690b = "A bad trap type ended up in mmGCRamTrap0eHandler." */
    'A',' ','b','a','d',' ','t','r','a','p',' ','\xf3','e','n','d','e','d',' ','u','p',' ','\x0f','m','m','G','C','R','a','m','T','r','a','p','0','e','H','a','n','d','l','e','r','.',
/* 0x06936 = "An unexpected (/unknown) exception was caught." */
    'A','n',' ','u','n','e','x','p','e','c','t','e','d',' ','(','/','u','n','k','n','o','w','n',')',' ','e','x','c','e','p','t','i','o','n',' ','\x11','c','a','u','g','h','t','.',
/* 0x06961 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_SET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','S','E','T','_','T','A','G',' ','\x7b',
/* 0x0698c = "Unexpected instruction encountered for which there is no patch strategy implemented (hardening)." */
    '\x94','\xdc','\xaf','\x10','\xed','t','h','e','r','e',' ','\x0b','n','o',' ','p','a','t','c','h',' ','s','t','r','a','t','e','g','y',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xae',
/* 0x069b7 = "Authentication failed (ISessionManager::logon())." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\x99','(','I','S','e','s','s','i','o','n','M','a','n','a','g','e','r',':',':','l','o','g','o','n','(',')',')','.',
/* 0x069e2 = "Partition mapping table is shorted than described." */
    'P','a','r','t','i','t','i','o','n',' ','m','a','p','p','i','n','g',' ','\xb1','\x0b','s','h','o','r','t','e','d',' ','t','h','a','n',' ','d','e','s','c','r','i','b','e','d','.',
/* 0x06a0d = "Address family not supported by protocol family." */
    'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','.',
/* 0x06a38 = "Syntax error - an argument or subargument contains nothing useful." */
    '\xfb','\x09','-',' ','\x87','a','r','g','u','m','e','n','t',' ','\xa9','s','u','b','a','r','g','u','m','e','n','t',' ','\x8a','n','o','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x06a63 = "Reason for leaving RC: Guest tried to write to our TSS - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','T','S','S',' ','-',' ','f','a','t','a','l','.',
/* 0x06a8e = "The image file is not owned by TrustedInstaller is it should be." */
    '\x03','\x26','\x22','\x0b','\x07','o','w','n','e','d',' ','\xdb','T','r','u','s','t','e','d','I','n','s','t','a','l','l','e','r',' ','\x0b','i','t',' ','s','h','o','u','l','d',' ','b','e','.',
/* 0x06ab9 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_GET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','G','E','T','_','T','A','G',' ','\x7b',
/* 0x06ae4 = "Maximum number of Shared Clipboard lists has been reached." */
    'M','a','x','i','m','u','m',' ','\xfc','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t','s',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x06b0f = "A Shared Clipboard objects handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','h','a','n','d','l','e',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x06b3a = "Mismatching VMCPU structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','V','M','C','P','U',' ','\xec','\xf8','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x06b65 = "Couldn\'t find MMIO2 range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','r','a','n','g','e',' ','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x06b90 = "Ran out of memory while compressing or uncompressing." */
    'R','a','n',' ','o','u','t',' ','\x15','\x86','w','h','i','l','e',' ','c','o','m','p','r','e','s','s','i','n','g',' ','\xa9','u','n','c','o','m','p','r','e','s','s','i','n','g','.',
/* 0x06bbb = "RTGetOpt: Command line option needs an index." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','\x87','i','n','d','e','x','.',
/* 0x06be6 = "Invalid effective segment register number passed to an IEM function." */
    '\x0c','e','f','f','e','c','t','i','v','e',' ','s','e','g','m','e','n','t',' ','\xeb','\xfc','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x06c11 = "Maximum (context ID) objects have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','o','b','j','e','c','t','s',' ','h','a','v','e',' ','\xcd','r','e','a','c','h','e','d','.',
/* 0x06c3c = "Image Verification Failure: Raw data offsets and sizes are out of range." */
    'I','m','a','g','e',' ','\x0d','\x12','R','a','w',' ','\x9d','o','f','f','s','e','t','s',' ','\x9a','s','i','z','e','s',' ','a','r','e',' ','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x06c67 = "Too many writes on read/write critical section." */
    'T','o','o',' ','\xb5','w','r','i','t','e','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x06c92 = "Reason for leaving RC: Guest tried to write to our IDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','I','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06cbd = "Unknown paritition ID found in the partition map table." */
    '\xef','p','a','r','i','t','i','t','i','o','n',' ','I','D',' ','f','o','u','n','d',' ','\x0f','\x02','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','t','a','b','l','e','.',
/* 0x06ce8 = "Another thread in the session is talking to the tracer." */
    'A','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','\x0f','\x02','s','e','s','s','i','o','n',' ','\x0b','t','a','l','k','i','n','g',' ','\x0a','\x02','t','r','a','c','e','r','.',
/* 0x06d13 = "Reason for leaving RC: Guest tried to write to our GDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','G','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06d3e = "VFS chain element only provides I/O stream (ios) objects." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x06d69 = "Unable to locate a usable DMG file within the XAR archive." */
    '\xe1','\x0a','l','o','c','a','t','e',' ','a',' ','u','s','a','b','l','e',' ','D','M','G',' ','\x22','w','i','t','h','i','n',' ','\x02','X','A','R',' ','a','r','c','h','i','v','e','.',
/* 0x06d94 = "VFS chain element takes a file system stream (fss) object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x22','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x06dbf = "No \'Type\' attribute in the DrvBlock configuration." */
    '\xe0','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x06dea = "Someone is trying to skip backwards in the stream..." */
    'S','o','m','e','o','n','e',' ','\x0b','t','r','y','i','n','g',' ','\x0a','s','k','i','p',' ','b','a','c','k','w','a','r','d','s',' ','\x0f','\x02','s','t','r','e','a','m','.','.','.',
/* 0x06e15 = "Not all of the requested CPUs showed up in the PFNRTMPWORKER." */
    'N','o','t',' ','a','l','l',' ','\x15','\x02','\xdf','C','P','U','s',' ','s','h','o','w','e','d',' ','u','p',' ','\x0f','\x02','P','F','N','R','T','M','P','W','O','R','K','E','R','.',
/* 0x06e3f = "Recompiler: Failed to reconcile the register/variable state on endif." */
    '\x13','\x8b','\x0a','r','e','c','o','n','c','i','l','e',' ','\x02','r','e','g','i','s','t','e','r','/','v','a','r','i','a','b','l','e',' ','\xcc','o','n',' ','e','n','d','i','f','.',
/* 0x06e69 = "The Mach-O header is bad or contains new and unsupported features." */
    '\x03','M','a','c','h','-','O',' ','\xb4','\x0b','b','a','d',' ','\xa9','\x8a','n','e','w',' ','\x9a','u','n','s','u','p','p','o','r','t','e','d',' ','f','e','a','t','u','r','e','s','.',
/* 0x06e93 = "String is not terminated within the buffer bounds." */
    'S','t','r','i','n','g',' ','\x0b','\x07','t','e','r','m','i','n','a','t','e','d',' ','w','i','t','h','i','n',' ','\x02','b','u','f','f','e','r',' ','b','o','u','n','d','s','.',
/* 0x06ebd = "The GIM device is not registered with GIM when it ought to be." */
    '\x03','G','I','M',' ','\xa3','\x0b','\x07','r','e','g','i','s','t','e','r','e','d',' ','\x7f','G','I','M',' ','w','h','e','n',' ','i','t',' ','o','u','g','h','t',' ','\x0a','b','e','.',
/* 0x06ee7 = "The ELF loader didn\'t find the symbol/string table for the image." */
    '\x03','E','L','F',' ','\xda','d','i','d','n','\'','t',' ','f','i','n','d',' ','\x02','s','y','m','b','o','l','/','s','t','r','i','n','g',' ','\xb1','\x10','\x02','i','m','a','g','e','.',
/* 0x06f11 = "RTGetOpt: Command line option not recognized." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x07','r','e','c','o','g','n','i','z','e','d','.',
/* 0x06f3b = "The table of content (TOC) is too small and therefore can\'t be valid." */
    '\x03','\xb1','\x15','\xf0','(','T','O','C',')',' ','\x0b','\x9e','s','m','a','l','l',' ','\x9a','t','h','e','r','e','f','o','r','e',' ','c','a','n','\'','t',' ','\xa4','v','a','l','i','d','.',
/* 0x06f65 = "File set descriptor has an zero length or invalid root dir extent." */
    'F','i','l','e',' ','s','e','t',' ','\xe3','\x5c','\x87','z','e','r','o',' ','l','e','n','g','t','h',' ','\xa9','\x8f','r','o','o','t',' ','d','i','r',' ','e','x','t','e','n','t','.',
/* 0x06f8f = "OpenSSL and IPRT disagree on the signature size." */
    'O','p','e','n','S','S','L',' ','\x9a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e',' ','s','i','z','e','.',
/* 0x06fb9 = "The process trying to open VBoxDrv is not a budding VM process (1)." */
    '\x03','\x92','t','r','y','i','n','g',' ','\x0a','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x0b','\x07','a',' ','b','u','d','d','i','n','g',' ','\xc6',' ','\x92','(','1',')','.',
/* 0x06fe3 = "No pending request the aio context has to wait for completion." */
    '\xe0','p','e','n','d','i','n','g',' ','\xab','\x02','a','i','o',' ','c','o','n','t','e','x','t',' ','\x5c','\x0a','w','a','i','t',' ','\x10','c','o','m','p','l','e','t','i','o','n','.',
/* 0x0700d = "The server did not understand the request due to bad syntax." */
    '\x03','s','e','r','v','e','r',' ','d','i','d',' ','\x07','u','n','d','e','r','s','t','a','n','d',' ','\x02','\xab','d','u','e',' ','\x0a','b','a','d',' ','s','y','n','t','a','x','.',
/* 0x07037 = "Unable to find partition descriptor for a partition map table entry." */
    '\xe1','\x0a','f','i','n','d',' ','p','a','r','t','i','t','i','o','n',' ','\xe3','\x10','a',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb1','e','n','t','r','y','.',
/* 0x07061 = "An unknown config node (key) was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','n','o','d','e',' ','(','k','e','y',')',' ','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0708b = "Too many arguments passed to a VM request / request corruption." */
    'T','o','o',' ','\xb5','a','r','g','u','m','e','n','t','s',' ','p','a','s','s','e','d',' ','\x0a','a',' ','\xc6',' ','\xab','/',' ','\xab','c','o','r','r','u','p','t','i','o','n','.',
/* 0x070b5 = "Syntax error - the argument does not allow a range to be specified." */
    '\xfb','\x09','-',' ','\x02','a','r','g','u','m','e','n','t',' ','\xb2','\x07','a','l','l','o','w',' ','a',' ','r','a','n','g','e',' ','\x0a','\xa4','s','p','e','c','i','f','i','e','d','.',
/* 0x070df = "The hash function in the header doesn't match the one in the table of content." */
    '\x03','h','a','s','h',' ','f','u','n','c','t','i','o','n',' ','\x0f','\x02','\xb4','\xc9','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x07109 = "The field does not follow immediately the previous one." */
    '\x03','f','i','e','l','d',' ','\xb2','\x07','f','o','l','l','o','w',' ','i','m','m','e','d','i','a','t','e','l','y',' ','\x02','p','r','e','v','i','o','u','s',' ','o','n','e','.',
/* 0x07133 = "Process Verification Failure: An image is targeting an unexpected machine/CPU." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','\x0b','t','a','r','g','e','t','i','n','g',' ','\x87','u','n','e','x','p','e','c','t','e','d',' ','m','a','c','h','i','n','e','/','C','P','U','.',
/* 0x0715d = "Do not know how to handle the content type in the server response." */
    'D','o',' ','\x07','k','n','o','w',' ','h','o','w',' ','\x0a','h','a','n','d','l','e',' ','\x02','\xf0','\xf3','\x0f','\x02','s','e','r','v','e','r',' ','r','e','s','p','o','n','s','e','.',
/* 0x07187 = "Command format (or reserved bits) invalid." */
    'C','o','m','m','a','n','d',' ','f','o','r','m','a','t',' ','(','o','r',' ','r','e','s','e','r','v','e','d',' ','b','i','t','s',')',' ','i','n','v','a','l','i','d','.',
/* 0x071b1 = "Failed to convert the specified Guest IP to a binary IP address." */
    '\x8b','\x0a','c','o','n','v','e','r','t',' ','\x02','\x18','G','u','e','s','t',' ','I','P',' ','\x0a','a',' ','b','i','n','a','r','y',' ','I','P',' ','a','d','d','r','e','s','s','.',
/* 0x071db = "The DTB being parsed has an invalid strings block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','\x87','\x8f','s','t','r','i','n','g','s',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x07205 = "Constructed string is not according to the encoding rules." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xf2','\x0b','\x07','a','c','c','o','r','d','i','n','g',' ','\x0a','\x02','e','n','c','o','d','i','n','g',' ','r','u','l','e','s','.',
/* 0x0722f = "The EMT was not busy running guest code at the time of the call." */
    '\x03','E','M','T',' ','\x11','\x07','b','u','s','y',' ','r','u','n','n','i','n','g',' ','\xbb','c','o','d','e',' ','a','t',' ','\x02','t','i','m','e',' ','\x15','\x02','c','a','l','l','.',
/* 0x07259 = "Recompiled execution: Jump back in the same TB." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','J','u','m','p',' ','b','a','c','k',' ','\x0f','\x02','s','a','m','e',' ','T','B','.',
/* 0x07283 = "The DTB being parsed has an invalid last compatible version set." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','\x87','\x8f','l','a','s','t',' ','c','o','m','p','a','t','i','b','l','e',' ','\xd1','s','e','t','.',
/* 0x072ad = "The process trying to open VBoxDrv is not a budding VM process (2)." */
    '\x03','\x92','t','r','y','i','n','g',' ','\x0a','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x0b','\x07','a',' ','b','u','d','d','i','n','g',' ','\xc6',' ','\x92','(','2',')','.',
/* 0x072d7 = "Service will execute the command in background." */
    'S','e','r','v','i','c','e',' ','w','i','l','l',' ','e','x','e','c','u','t','e',' ','\x02','c','o','m','m','a','n','d',' ','\x0f','b','a','c','k','g','r','o','u','n','d','.',
/* 0x07301 = "Too many partition maps in the logical volume descriptor." */
    'T','o','o',' ','\xb5','p','a','r','t','i','t','i','o','n',' ','m','a','p','s',' ','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0732b = "The provider is only allowed as the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\x0b','o','n','l','y',' ','a','l','l','o','w','e','d',' ','a','s',' ','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x07355 = "No line number was found for the specified address/ordinal/whatever." */
    '\xe0','l','i','n','e',' ','\xfc','\x11','f','o','u','n','d',' ','\x10','\x02','\x18','a','d','d','r','e','s','s','/','o','r','d','i','n','a','l','/','w','h','a','t','e','v','e','r','.',
/* 0x0737f = "Process Verification Failure: Error allocating state memory or querying the system32 path." */
    '\x1e','\x0d','\x12','\xc1','a','l','l','o','c','a','t','i','n','g',' ','\xcc','\x86','\xa9','q','u','e','r','y','i','n','g',' ','\x02','s','y','s','t','e','m','3','2',' ','p','a','t','h','.',
/* 0x073a9 = "No digest algorithms listed in PKCS #7 signed data." */
    '\xe0','\xd8','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d',' ','\x0f','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x073d2 = "Couldn\'t find ROM range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','r','a','n','g','e',' ','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x073fb = "The CSAM is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','C','S','A','M',' ','\x0b','\x07','u','s','e','d',' ','\x2a','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x9a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x07424 = "Reason for leaving RC: CSAM wants perform a task in ring-3." */
    '\x93','\x10','\x81','R','C',':',' ','C','S','A','M',' ','w','a','n','t','s',' ','p','e','r','f','o','r','m',' ','a',' ','t','a','s','k',' ','\x0f','r','i','n','g','-','3','.',
/* 0x0744d = "The requested operation cannot be performed because the device is currently being reset." */
    '\x03','\xdf','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d',' ','\x2a','\x02','\xa3','\x0b','c','u','r','r','e','n','t','l','y',' ','b','e','i','n','g',' ','r','e','s','e','t','.',
/* 0x07476 = "The initialization of the dynamic mapping cache failed." */
    '\x03','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x15','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x7b',
/* 0x0749f = "GVMCPU struct size is not compatible with the host page size." */
    'G','V','M','C','P','U',' ','s','t','r','u','c','t',' ','\xf8','\x0b','\x07','c','o','m','p','a','t','i','b','l','e',' ','\x7f','\x02','h','o','s','t',' ','\xbe','s','i','z','e','.',
/* 0x074c8 = "Something is not available or not working properly." */
    'S','o','m','e','t','h','i','n','g',' ','\x0b','\x07','a','v','a','i','l','a','b','l','e',' ','\xa9','\x07','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y','.',
/* 0x074f1 = "Reason for leaving RC: A privileged instruction was attempted executed." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','p','r','i','v','i','l','e','g','e','d',' ','\xdc','\x11','a','t','t','e','m','p','t','e','d',' ','e','x','e','c','u','t','e','d','.',
/* 0x0751a = "Indicating that a rescheduling now is required." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','n','o','w',' ','\x0b','r','e','q','u','i','r','e','d','.',
/* 0x07543 = "Process Verification Failure: One of the section in the image file is not fully mapped into memory." */
    '\x1e','\x0d','\x12','O','n','e',' ','\x15','\x02','\xdd','\x0f','\x02','\x26','\x22','\x0b','\x07','f','u','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0756c = "A boot catalog entry in the import ISO is using the unused field." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x0b','u','s','i','n','g',' ','\x02','u','n','u','s','e','d',' ','f','i','e','l','d','.',
/* 0x07595 = "The native file handle got stale while it was open." */
    '\x03','n','a','t','i','v','e',' ','\x22','h','a','n','d','l','e',' ','g','o','t',' ','s','t','a','l','e',' ','w','h','i','l','e',' ','i','t',' ','\x11','o','p','e','n','.',
/* 0x075be = "The Host Interface Networking init program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','i','n','i','t',' ','p','r','o','g','r','a','m',' ','\x7b',
/* 0x075e7 = "An attempt was made to grow an already maxed out page pool." */
    'A','n',' ','a','t','t','e','m','p','t',' ','\x11','m','a','d','e',' ','\x0a','g','r','o','w',' ','\x87','\x80','m','a','x','e','d',' ','o','u','t',' ','\xbe','p','o','o','l','.',
/* 0x07610 = "Reason for leaving RC: Guest trap which couldn\'t be handled in RC." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','a','p',' ','\xed','c','o','u','l','d','n','\'','t',' ','\xa4','h','a','n','d','l','e','d',' ','\x0f','R','C','.',
/* 0x07639 = "The algorithms part of the DEK-Info field is too long." */
    '\x03','a','l','g','o','r','i','t','h','m','s',' ','p','a','r','t',' ','\x15','\x02','D','E','K','-','I','n','f','o',' ','f','i','e','l','d',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x07662 = "PKIX cipher algorithm parameters are not implemented." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd5','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x07','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0768b = "Key algorithm parameters are required but missing." */
    'K','e','y',' ','\xd5','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','m','i','s','s','i','n','g','.',
/* 0x076b4 = "Expected PKCS #7 object to ship at least one certificate." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','s','h','i','p',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x076dd = "The GIM provider does not support any paravirtualized TSC." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\xb2','\x07','\xd0','a','n','y',' ','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x07706 = "The page to be updated or freed was noted owned by the caller." */
    '\x03','\xbe','\x0a','\xa4','u','p','d','a','t','e','d',' ','\xa9','f','r','e','e','d',' ','\x11','n','o','t','e','d',' ','o','w','n','e','d',' ','\xdb','\x02','c','a','l','l','e','r','.',
/* 0x0772f = "Process Verification Failure: Found executable memory allocated in the process." */
    '\x1e','\x0d','\x12','F','o','u','n','d',' ','e','x','e','c','u','t','a','b','l','e',' ','\x86','a','l','l','o','c','a','t','e','d',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x07758 = "A numeric conversion encountered a value which was too big for the target." */
    'A',' ','n','u','m','e','r','i','c',' ','c','o','n','v','e','r','s','i','o','n',' ','\xaf','a',' ','\xf5','\xed','\x11','\x9e','b','i','g',' ','\x10','\x02','t','a','r','g','e','t','.',
/* 0x07781 = "Get register caller must flush the TLB (not an error)." */
    'G','e','t',' ','\xeb','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B',' ','(','n','o','t',' ','\x87','e','r','r','o','r',')','.',
/* 0x077aa = "(One) send buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','s','e','n','d',' ','b','u','f','f','e','r',' ','\x11','\x9e','s','m','a','l','l',',',' ','\xa9','\x9e','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x077d3 = "The field contains an invalid callback or transformation index." */
    '\x03','f','i','e','l','d',' ','\x8a','\x87','\x8f','c','a','l','l','b','a','c','k',' ','\xa9','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','i','n','d','e','x','.',
/* 0x077fc = "Import ISO contains an unsupported supplementary volume descriptor version." */
    '\xc4','\xc2',' ','\x8a','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd3','\xe3','v','e','r','s','i','o','n','.',
/* 0x07825 = "The name of the module clashed with an existing module." */
    '\x03','n','a','m','e',' ','\x15','\x02','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','\x7f','\x87','e','x','i','s','t','i','n','g',' ','m','o','d','u','l','e','.',
/* 0x0784e = "VFS chain element takes a file or I/O stream (ios) object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x22','\xa9','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x07877 = "The DTB structs block contains an unterminated string." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','\x87','u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x078a0 = "The request wasn\'t submitted so it can\'t be canceled." */
    '\x03','\xab','w','a','s','n','\'','t',' ','s','u','b','m','i','t','t','e','d',' ','s','o',' ','i','t',' ','c','a','n','\'','t',' ','\xa4','c','a','n','c','e','l','e','d','.',
/* 0x078c9 = "Address conflict within a module/segment." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t',' ','w','i','t','h','i','n',' ','a',' ','m','o','d','u','l','e','/','s','e','g','m','e','n','t','.',
/* 0x078f2 = "Malformed extended allocation descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','e','x','t','e','n','d','e','d',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0791b = "The DTB being parsed has an invalid struct block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','\x87','\x8f','s','t','r','u','c','t',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x07944 = "Node pointer is not within the memory allocated for nodes." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x0b','\x07','w','i','t','h','i','n',' ','\x02','\x86','a','l','l','o','c','a','t','e','d',' ','\x10','n','o','d','e','s','.',
/* 0x0796d = "Certificate cannot be authenticated with the given CA certificates." */
    '\xba','\xcf','\xa4','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','\x7f','\x02','g','i','v','e','n',' ','C','A',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x07996 = "A string claiming to be UTF-8 is incorrectly encoded." */
    'A',' ','\xf2','c','l','a','i','m','i','n','g',' ','\x0a','\xa4','U','T','F','-','8',' ','\x0b','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x079bf = "Return to ring-3 to perform the hypercall there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','p','e','r','f','o','r','m',' ','\x02','h','y','p','e','r','c','a','l','l',' ','t','h','e','r','e','.',
/* 0x079e8 = "The user mode tracepoint provider string table is too large." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xf2','\xb1','\x0b','\x9e','l','a','r','g','e','.',
/* 0x07a11 = "The RAM size differs between the saved state and the VM config." */
    '\x03','R','A','M',' ','\xf8','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','\x02','s','a','v','e','d',' ','\xcc','\x9a','\x02','\xc6',' ','c','o','n','f','i','g','.',
/* 0x07a3a = "Unable to allocate more pages from the host system." */
    '\xe1','\x0a','a','l','l','o','c','a','t','e',' ','m','o','r','e',' ','p','a','g','e','s',' ','f','r','o','m',' ','\x02','h','o','s','t',' ','s','y','s','t','e','m','.',
/* 0x07a62 = "No more handles available, too many open handles." */
    '\xe0','m','o','r','e',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e',',',' ','\x9e','\xb5','o','p','e','n',' ','h','a','n','d','l','e','s','.',
/* 0x07a8a = "VFS chain element only provides file system (vfs) objects." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x22','s','y','s','t','e','m',' ','(','v','f','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x07ab2 = "The Host Interface Networking device name is too long." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\xa3','n','a','m','e',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x07ada = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','W','I','T','H','_','N','O','N','E',
/* 0x07b02 = "Import ISO uses a logical block size other than 2KB." */
    '\xc4','\xc2',' ','u','s','e','s',' ','a',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','\xf8','o','t','h','e','r',' ','t','h','a','n',' ','2','K','B','.',
/* 0x07b2a = "The internal application does not reside in the correct place (hardening)." */
    '\x03','\x16','a','p','p','l','i','c','a','t','i','o','n',' ','\xb2','\x07','r','e','s','i','d','e',' ','\x0f','\x02','c','o','r','r','e','c','t',' ','p','l','a','c','e',' ','\xae',
/* 0x07b52 = "Cannot resolve symbol because it\'s a forwarder." */
    'C','a','n','n','o','t',' ','r','e','s','o','l','v','e',' ','s','y','m','b','o','l',' ','\x2a','i','t','\'','s',' ','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x07b7a = "The segment bits are non-contiguous in the file." */
    '\x03','s','e','g','m','e','n','t',' ','b','i','t','s',' ','a','r','e',' ','n','o','n','-','c','o','n','t','i','g','u','o','u','s',' ','\x0f','\x02','f','i','l','e','.',
/* 0x07ba2 = "Level 2 lookup failed because the L1 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x99','\x2a','\x02','L','1',' ','l','o','o','k','u','p',' ','\xb1','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x07bca = "Recompiler: Wrong jump instruction targeting label at end of TB." */
    '\x13','W','r','o','n','g',' ','j','u','m','p',' ','\xdc','t','a','r','g','e','t','i','n','g',' ','l','a','b','e','l',' ','a','t',' ','e','n','d',' ','\x15','T','B','.',
/* 0x07bf2 = "The given range does not meet the required alignment." */
    '\x03','g','i','v','e','n',' ','r','a','n','g','e',' ','\xb2','\x07','m','e','e','t',' ','\x02','r','e','q','u','i','r','e','d',' ','a','l','i','g','n','m','e','n','t','.',
/* 0x07c1a = "Optional header magic and target machine does not match." */
    'O','p','t','i','o','n','a','l',' ','\xb4','m','a','g','i','c',' ','\x9a','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','\xb2','\x07','m','a','t','c','h','.',
/* 0x07c42 = "The PE loader encountered some Guard CF stuff in the load config." */
    '\x03','P','E',' ','\xda','\xaf','s','o','m','e',' ','G','u','a','r','d',' ','C','F',' ','s','t','u','f','f',' ','\x0f','\x02','l','o','a','d',' ','c','o','n','f','i','g','.',
/* 0x07c6a = "VMXON failed; possibly because it was already run before." */
    'V','M','X','O','N',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x2a','i','t',' ','\x11','\x80','r','u','n',' ','b','e','f','o','r','e','.',
/* 0x07c92 = "Missing ciper parameters for encrypted key." */
    'M','i','s','s','i','n','g',' ','c','i','p','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x07cba = "The OS does not support changing the owner of a symbolic link." */
    '\x03','O','S',' ','\xb2','\x07','\xd0','c','h','a','n','g','i','n','g',' ','\x02','o','w','n','e','r',' ','\x15','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x07ce2 = "A Shared Clipboard list handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t',' ','h','a','n','d','l','e',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x07d0a = "UDF file cannot be imported because it has a stream directory." */
    'U','D','F',' ','\x22','\xcf','\xa4','i','m','p','o','r','t','e','d',' ','\x2a','i','t',' ','\x5c','a',' ','s','t','r','e','a','m',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x07d32 = "The path of a new node contained slashes or was empty." */
    '\x03','\xd2','\x15','a',' ','n','e','w',' ','n','o','d','e',' ','c','o','n','t','a','i','n','e','d',' ','s','l','a','s','h','e','s',' ','\xa9','\x11','e','m','p','t','y','.',
/* 0x07d5a = "Reason for leaving RC: duplicate instruction called at current eip." */
    '\x93','\x10','\x81','R','C',':',' ','d','u','p','l','i','c','a','t','e',' ','\xdc','c','a','l','l','e','d',' ','a','t',' ','c','u','r','r','e','n','t',' ','e','i','p','.',
/* 0x07d82 = "NEM is missing a require feature in the host API." */
    '\xee',' ','\x0b','m','i','s','s','i','n','g',' ','a',' ','r','e','q','u','i','r','e',' ','f','e','a','t','u','r','e',' ','\x0f','\x02','h','o','s','t',' ','A','P','I','.',
/* 0x07daa = "The VFS chain specification does not have a valid prefix." */
    '\x03','\x8d',' ','\xa1','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\xb2','\x07','h','a','v','e',' ','a',' ','v','a','l','i','d',' ','p','r','e','f','i','x','.',
/* 0x07dd2 = "VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','N','O','D','E','_','N','A','M','E','_','I','N','V','A','L','I','D',
/* 0x07dfa = "Tried to resume a VM or CPU that is already fully running." */
    'T','r','i','e','d',' ','\x0a','r','e','s','u','m','e',' ','a',' ','\xc6',' ','\xa9','C','P','U',' ','\xad','\x0b','\x80','f','u','l','l','y',' ','r','u','n','n','i','n','g','.',
/* 0x07e22 = "The requested operation cannot be performed on a detached USB device." */
    '\x03','\xdf','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d',' ','o','n',' ','a',' ','d','e','t','a','c','h','e','d',' ','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x07e4a = "Level 2 lookup failed because the L2 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x99','\x2a','\x02','L','2',' ','l','o','o','k','u','p',' ','\xb1','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x07e72 = "Failed to fix mappings because the proposed memory area was to small." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x2a','\x02','p','r','o','p','o','s','e','d',' ','\x86','a','r','e','a',' ','\x11','\x0a','s','m','a','l','l','.',
/* 0x07e9a = "PGM pool flush pending - return to ring 3." */
    'P','G','M',' ','p','o','o','l',' ','f','l','u','s','h',' ','p','e','n','d','i','n','g',' ','-',' ','r','e','t','u','r','n',' ','\x0a','r','i','n','g',' ','3','.',
/* 0x07ec2 = "The called method does not work with the value type of the given JSON value." */
    '\x03','c','a','l','l','e','d',' ','m','e','t','h','o','d',' ','\xb2','\x07','w','o','r','k',' ','\x7f','\x02','\xf5','\xf3','\x15','\x02','g','i','v','e','n',' ','J','S','O','N',' ','\xe8',
/* 0x07eea = "The encrypted digest algorithm does not match the one in the certificate." */
    '\x03','e','n','c','r','y','p','t','e','d',' ','\xd8','\xd5','\xb2','\x07','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x07f12 = "Invalid VMCS pointer passed to VMLAUNCH/VMRESUME." */
    '\x0c','V','M','C','S',' ','p','o','i','n','t','e','r',' ','p','a','s','s','e','d',' ','\x0a','V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E','.',
/* 0x07f3a = "A guest control object has changed its overall status." */
    'A',' ','\xbb','c','o','n','t','r','o','l',' ','\xa8','\x5c','c','h','a','n','g','e','d',' ','i','t','s',' ','o','v','e','r','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x07f62 = "Both debug and non-debug sections in segment." */
    'B','o','t','h',' ','d','e','b','u','g',' ','\x9a','n','o','n','-','d','e','b','u','g',' ','s','e','c','t','i','o','n','s',' ','\x0f','s','e','g','m','e','n','t','.',
/* 0x07f8a = "Couldn\'t find any USB hubs to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','U','S','B',' ','h','u','b','s',' ','\x0a','a','t','t','a','c','h',' ','\x02','\xa3','t','o','.',
/* 0x07fb2 = "Reason for leaving RC: jump inside generated patch jump." */
    '\x93','\x10','\x81','R','C',':',' ','j','u','m','p',' ','i','n','s','i','d','e',' ','g','e','n','e','r','a','t','e','d',' ','p','a','t','c','h',' ','j','u','m','p','.',
/* 0x07fda = "VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','M','A','L','F','O','R','M','E','D','_','P','A','D','D','I','N','G',
/* 0x08002 = "Raw-mode is unavailable courtesy of Hyper-V." */
    'R','a','w','-','m','o','d','e',' ','\x0b','u','n','a','v','a','i','l','a','b','l','e',' ','c','o','u','r','t','e','s','y',' ','\x15','H','y','p','e','r','-','V','.',
/* 0x0802a = "A PDMThread API was called by the wrong thread." */
    'A',' ','P','D','M','T','h','r','e','a','d',' ','A','P','I',' ','\x11','c','a','l','l','e','d',' ','\xdb','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x08051 = "No allocation descriptors for UDF directory." */
    '\xe0','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x10','U','D','F',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x08078 = "Attempted socket operation with a non-socket handle." */
    'A','t','t','e','m','p','t','e','d',' ','s','o','c','k','e','t',' ','\x96','\x7f','a',' ','n','o','n','-','s','o','c','k','e','t',' ','h','a','n','d','l','e','.',
/* 0x0809f = "Certificate path validator: Invalid policy mapping (to/from anyPolicy)." */
    '\xba','\xd2','\xff','\x0c','p','o','l','i','c','y',' ','m','a','p','p','i','n','g',' ','(','t','o','/','f','r','o','m',' ','a','n','y','P','o','l','i','c','y',')','.',
/* 0x080c6 = "Process Verification Failure: Expected the process and exe to advertise NX compatibility." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x9a','e','x','e',' ','\x0a','a','d','v','e','r','t','i','s','e',' ','N','X',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','.',
/* 0x080ed = "The specified MMIO range was owned by some other device(s)." */
    '\x03','\x18','\xd4',' ','r','a','n','g','e',' ','\x11','o','w','n','e','d',' ','\xdb','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',
/* 0x08114 = "Expected PKCS #7 object to ship the signer certificate(s)." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','s','h','i','p',' ','\x02','s','i','g','n','e','r',' ','c','e','r','t','i','f','i','c','a','t','e','(','s',')','.',
/* 0x0813b = "PKCS #7 signed data has no digest algorithms listed." */
    'P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x9d','\x5c','n','o',' ','\xd8','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d','.',
/* 0x08162 = "Reason for leaving RC: Interrupted by external interrupt." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xdb','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x08189 = "The timer can\'t be stopped because it\'s already suspended." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\xa4','s','t','o','p','p','e','d',' ','\x2a','i','t','\'','s',' ','\x80','s','u','s','p','e','n','d','e','d','.',
/* 0x081b0 = "Mismatching VM structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xc6',' ','\xec','\xf8','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x081d7 = "Misaligned read/write critical section." */
    'M','i','s','a','l','i','g','n','e','d',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x081fe = "Internal error in the lock validator or related components." */
    '\x08','\x09','\x0f','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','\xa9','r','e','l','a','t','e','d',' ','c','o','m','p','o','n','e','n','t','s','.',
/* 0x08225 = "Import ISO contains more than one el torito descriptor." */
    '\xc4','\xc2',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','e','l',' ','t','o','r','i','t','o',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0824c = "The guest bit mask didn\'t match the guest being loaded." */
    '\x03','\xbb','b','i','t',' ','m','a','s','k',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','\xbb','b','e','i','n','g',' ','l','o','a','d','e','d','.',
/* 0x08273 = "Mismatching VM structure version between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xc6',' ','\xec','\xd1','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x0829a = "The value is not a zero terminated character string." */
    '\x03','\xf5','\x0b','\x07','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','.',
/* 0x082c1 = "AMD-V CPU extension disabled (by BIOS)." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','y',' ','B','I','O','S',')','.',
/* 0x082e8 = "Internal ISO maker error: Inconsistency produing trans." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','I','n','c','o','n','s','i','s','t','e','n','c','y',' ','p','r','o','d','u','i','n','g',' ','t','r','a','n','s','.',
/* 0x0830f = "The requested operation cannot be performed because the device is currently suspended." */
    '\x03','\xdf','\x96','\xcf','\xa4','p','e','r','f','o','r','m','e','d',' ','\x2a','\x02','\xa3','\x0b','c','u','r','r','e','n','t','l','y',' ','s','u','s','p','e','n','d','e','d','.',
/* 0x08336 = "Virtual machine error occurred attempting the operation." */
    'V','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\x09','o','c','c','u','r','r','e','d',' ','a','t','t','e','m','p','t','i','n','g',' ','\x02','\xea',
/* 0x0835d = "A boot catalog entry in the import ISO has an invalid boot media type." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','\x87','\x8f','b','o','o','t',' ','m','e','d','i','a',' ','t','y','p','e','.',
/* 0x08384 = "The virtual clock frequency differs too much." */
    '\x03','v','i','r','t','u','a','l',' ','c','l','o','c','k',' ','f','r','e','q','u','e','n','c','y',' ','d','i','f','f','e','r','s',' ','\x9e','m','u','c','h','.',
/* 0x083ab = "Too many ICB indirections, possibly a loop." */
    'T','o','o',' ','\xb5','I','C','B',' ','i','n','d','i','r','e','c','t','i','o','n','s',',',' ','p','o','s','s','i','b','l','y',' ','a',' ','l','o','o','p','.',
/* 0x083d2 = "A boot catalog entry in the import ISO has reserved flag set." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','r','e','s','e','r','v','e','d',' ','f','l','a','g',' ','s','e','t','.',
/* 0x083f9 = "Return instigated by a callback or similar." */
    'R','e','t','u','r','n',' ','i','n','s','t','i','g','a','t','e','d',' ','\xdb','a',' ','c','a','l','l','b','a','c','k',' ','\xa9','s','i','m','i','l','a','r','.',
/* 0x08420 = "The command cannot be deregistered because has not been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\xcf','\xa4','d','e','r','e','g','i','s','t','e','r','e','d',' ','\x2a','\x5c','\x07','\xcd','r','e','g','i','s','t','e','r','e','d','.',
/* 0x08447 = "The default boot catalog entry in the import ISO has invalid flags set." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','\x8f','f','l','a','g','s',' ','s','e','t','.',
/* 0x0846e = "VMX CPU extension not available in hardware." */
    'V','M','X',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x07','a','v','a','i','l','a','b','l','e',' ','\x0f','h','a','r','d','w','a','r','e','.',
/* 0x08495 = "The ELF loader cannot handle multiple SYMTAB sections." */
    '\x03','E','L','F',' ','\xda','\xcf','h','a','n','d','l','e',' ','m','u','l','t','i','p','l','e',' ','S','Y','M','T','A','B',' ','s','e','c','t','i','o','n','s','.',
/* 0x084bc = "Unique issuer and subject IDs require version certificate 2." */
    'U','n','i','q','u','e',' ','i','s','s','u','e','r',' ','\x9a','s','u','b','j','e','c','t',' ','I','D','s',' ','r','e','q','u','i','r','e',' ','\xd1','\xa0','2','.',
/* 0x084e3 = "Indefinite length form is against the rules." */
    'I','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','f','o','r','m',' ','\x0b','a','g','a','i','n','s','t',' ','\x02','r','u','l','e','s','.',
/* 0x0850a = "Tried to take a semaphore in a bad context." */
    'T','r','i','e','d',' ','\x0a','t','a','k','e',' ','a',' ','s','e','m','a','p','h','o','r','e',' ','\x0f','a',' ','b','a','d',' ','c','o','n','t','e','x','t','.',
/* 0x08531 = "Failed to retrieve underlying (lower mac) link." */
    '\x8b','\x0a','r','e','t','r','i','e','v','e',' ','u','n','d','e','r','l','y','i','n','g',' ','(','l','o','w','e','r',' ','m','a','c',')',' ','l','i','n','k','.',
/* 0x08558 = "Signed data verification failed because there are zero signer infos." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','\x2a','t','h','e','r','e',' ','a','r','e',' ','z','e','r','o',' ','s','i','g','n','e','r',' ','i','n','f','o','s','.',
/* 0x0857f = "The async completion template is still used." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','e','m','p','l','a','t','e',' ','\x0b','s','t','i','l','l',' ','u','s','e','d','.',
/* 0x085a6 = "Process Verification Failure: Executable file name and process image name does not match up." */
    '\x1e','\x0d','\x12','E','x','e','c','u','t','a','b','l','e',' ','\x22','n','a','m','e',' ','\x9a','\x92','\x26','n','a','m','e',' ','\xb2','\x07','m','a','t','c','h',' ','u','p','.',
/* 0x085cd = "Reason for leaving RC: pending irq after iret that sets IF." */
    '\x93','\x10','\x81','R','C',':',' ','p','e','n','d','i','n','g',' ','i','r','q',' ','a','f','t','e','r',' ','i','r','e','t',' ','\xad','s','e','t','s',' ','I','F','.',
/* 0x085f4 = "VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST" */
    '\x01','V','M','M','D','E','V','_','C','P','U','_','H','O','T','P','L','U','G','_','\x06','M','O','N','I','T','O','R','E','D','_','B','Y','_','G','U','E','S','T',
/* 0x0861b = "Pending exception; continue guest execution." */
    'P','e','n','d','i','n','g',' ','e','x','c','e','p','t','i','o','n',';',' ','c','o','n','t','i','n','u','e',' ','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x08642 = "UDF file cannot be import sparse files at present." */
    'U','D','F',' ','\x22','\xcf','\xa4','i','m','p','o','r','t',' ','s','p','a','r','s','e',' ','f','i','l','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x08668 = "Not possible to attach drivers to the device." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','a','t','t','a','c','h',' ','d','r','i','v','e','r','s',' ','\x0a','\x02','d','e','v','i','c','e','.',
/* 0x0868e = "LUN is already/still attached to a device." */
    'L','U','N',' ','\x0b','a','l','r','e','a','d','y','/','s','t','i','l','l',' ','a','t','t','a','c','h','e','d',' ','\x0a','a',' ','d','e','v','i','c','e','.',
/* 0x086b4 = "A request was not prepared and thus could not be submitted." */
    'A',' ','\xab','\x11','\x07','p','r','e','p','a','r','e','d',' ','\x9a','t','h','u','s',' ','c','o','u','l','d',' ','\x07','\xa4','s','u','b','m','i','t','t','e','d','.',
/* 0x086da = "Error getting extensions from the certificate." */
    '\xc1','g','e','t','t','i','n','g',' ','e','x','t','e','n','s','i','o','n','s',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x08700 = "The handle was not registered for use with the I/O queue." */
    '\x03','h','a','n','d','l','e',' ','\x11','\x07','r','e','g','i','s','t','e','r','e','d',' ','\x10','u','s','e',' ','\x7f','\x02','I','/','O',' ','q','u','e','u','e','.',
/* 0x08726 = "Couldn\'t find MMIO2 page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xbe','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0874c = "Process Verification Failure: Expected the process and exe to have dynamic base enabled." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x9a','e','x','e',' ','\x0a','h','a','v','e',' ','d','y','n','a','m','i','c',' ','b','a','s','e',' ','e','n','a','b','l','e','d','.',
/* 0x08772 = "The caller shall raise an #GP(0) exception." */
    '\x03','c','a','l','l','e','r',' ','s','h','a','l','l',' ','r','a','i','s','e',' ','\x87','#','G','P','(','0',')',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x08798 = "The signature is greater than or equal to the key." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','g','r','e','a','t','e','r',' ','t','h','a','n',' ','\xa9','e','q','u','a','l',' ','\x0a','\x02','k','e','y','.',
/* 0x087be = "Not the lock owner according our records." */
    'N','o','t',' ','\x02','l','o','c','k',' ','o','w','n','e','r',' ','a','c','c','o','r','d','i','n','g',' ','o','u','r',' ','r','e','c','o','r','d','s','.',
/* 0x087e4 = "The size field should be zero for links and symlinks." */
    '\x03','\xf8','f','i','e','l','d',' ','s','h','o','u','l','d',' ','\xa4','z','e','r','o',' ','\x10','l','i','n','k','s',' ','\x9a','s','y','m','l','i','n','k','s','.',
/* 0x0880a = "The value is not a zero terminated password string." */
    '\x03','\xf5','\x0b','\x07','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','p','a','s','s','w','o','r','d',' ','s','t','r','i','n','g','.',
/* 0x08830 = "The specified MMIO range intruded on an existing range." */
    '\x03','\x18','\xd4',' ','r','a','n','g','e',' ','i','n','t','r','u','d','e','d',' ','o','n',' ','\x87','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',
/* 0x08856 = "File not accessible or erroneous file contents." */
    'F','i','l','e',' ','\x07','a','c','c','e','s','s','i','b','l','e',' ','\xa9','e','r','r','o','n','e','o','u','s',' ','\x22','c','o','n','t','e','n','t','s','.',
/* 0x0887c = "The specified attribute (name) was not found in the manifest." */
    '\x03','\x18','a','t','t','r','i','b','u','t','e',' ','(','n','a','m','e',')',' ','\x11','\x07','f','o','u','n','d',' ','\x0f','\x02','m','a','n','i','f','e','s','t','.',
/* 0x088a2 = "Reason for leaving RZ: Pending ring-3 OUT instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','O','U','T',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x088c8 = "Attempted to report too many pages as deflated." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','r','e','p','o','r','t',' ','\x9e','\xb5','p','a','g','e','s',' ','a','s',' ','d','e','f','l','a','t','e','d','.',
/* 0x088ee = "Failed to measure the TSC delta between two CPUs." */
    '\x8b','\x0a','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s','.',
/* 0x08914 = "The TCP server has no client associated with it." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x5c','n','o',' ','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x7f','i','t','.',
/* 0x0893a = "VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT" */
    '\x01','\x95','\xbd','\x06','S','I','G','N','E','D','_','W','I','T','H','_','S','P','E','C','I','A','L','L','Y','_','T','R','U','S','T','E','D','_','C','E','R','T',
/* 0x08960 = "Malformed checksum field in the tar header." */
    'M','a','l','f','o','r','m','e','d',' ','c','h','e','c','k','s','u','m',' ','f','i','e','l','d',' ','\x0f','\x02','t','a','r',' ','h','e','a','d','e','r','.',
/* 0x08986 = "Internal processing error the CodeView debug information reader." */
    '\x08','\x04','\x09','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','r','e','a','d','e','r','.',
/* 0x089ac = "A queue is out of free items, the queueing operation failed." */
    'A',' ','q','u','e','u','e',' ','\x0b','o','u','t',' ','\x15','f','r','e','e',' ','i','t','e','m','s',',',' ','\x02','q','u','e','u','e','i','n','g',' ','\x96','\x7b',
/* 0x089d2 = "Filesystem can\'t be opened because it is corrupt." */
    'F','i','l','e','s','y','s','t','e','m',' ','c','a','n','\'','t',' ','\xa4','o','p','e','n','e','d',' ','\x2a','i','t',' ','\x0b','c','o','r','r','u','p','t','.',
/* 0x089f8 = "Invalid VMCS index or write to read-only element." */
    '\x0c','V','M','C','S',' ','i','n','d','e','x',' ','\xa9','w','r','i','t','e',' ','\x0a','r','e','a','d','-','o','n','l','y',' ','e','l','e','m','e','n','t','.',
/* 0x08a1e = "VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH" */
    '\x01','\x24','C','I','P','H','E','R','_','\x05','I','N','I','T','I','A','L','I','Z','A','T','I','O','N','_','V','E','C','T','O','R','_','L','E','N','G','T','H',
/* 0x08a44 = "VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','S','E','R','I','A','L','_','N','U','M','B','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x08a6a = "Failed to stat a file/dir during enumeration (hardening)." */
    '\x8b','\x0a','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','d','u','r','i','n','g',' ','e','n','u','m','e','r','a','t','i','o','n',' ','\xae',
/* 0x08a90 = "Host API has not enabled SVME bit in EFER MSR." */
    'H','o','s','t',' ','A','P','I',' ','\x5c','\x07','e','n','a','b','l','e','d',' ','S','V','M','E',' ','b','i','t',' ','\x0f','E','F','E','R',' ','M','S','R','.',
/* 0x08ab6 = "Virtual address was not allocated by the library." */
    'V','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','\x11','\x07','a','l','l','o','c','a','t','e','d',' ','\xdb','\x02','l','i','b','r','a','r','y','.',
/* 0x08adc = "The table of content XML document does not have a toc element." */
    '\x03','\xb1','\x15','\xf0','X','M','L',' ','d','o','c','u','m','e','n','t',' ','\xb2','\x07','h','a','v','e',' ','a',' ','t','o','c',' ','e','l','e','m','e','n','t','.',
/* 0x08b02 = "Failed to resolve an imported (external) symbol." */
    '\x8b','\x0a','r','e','s','o','l','v','e',' ','\x87','i','m','p','o','r','t','e','d',' ','(','e','x','t','e','r','n','a','l',')',' ','s','y','m','b','o','l','.',
/* 0x08b28 = "PKIX cipher algorithm is not known to OpenSSL EVP API." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd5','\x0b','\x07','k','n','o','w','n',' ','\x0a','O','p','e','n','S','S','L',' ','E','V','P',' ','A','P','I','.',
/* 0x08b4e = "The UDP server has no client associated with it." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x5c','n','o',' ','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x7f','i','t','.',
/* 0x08b74 = "Started guest process terminated with an exit code <> 0." */
    'S','t','a','r','t','e','d',' ','\xbb','\x92','t','e','r','m','i','n','a','t','e','d',' ','\x7f','\x87','e','x','i','t',' ','c','o','d','e',' ','<','>',' ','0','.',
/* 0x08b9a = "An account is restricted in a certain way." */
    'A','n',' ','a','c','c','o','u','n','t',' ','\x0b','r','e','s','t','r','i','c','t','e','d',' ','\x0f','a',' ','c','e','r','t','a','i','n',' ','w','a','y','.',
/* 0x08bc0 = "Malformed or failed to parse PEM formatted data." */
    'M','a','l','f','o','r','m','e','d',' ','\xa9','\x99','\x0a','p','a','r','s','e',' ','P','E','M',' ','f','o','r','m','a','t','t','e','d',' ','d','a','t','a','.',
/* 0x08be6 = "Catch write access and route it thru PGM." */
    'C','a','t','c','h',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x08c0c = "Attempt to release mutex not owned by caller." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','l','e','a','s','e',' ','m','u','t','e','x',' ','\x07','o','w','n','e','d',' ','\xdb','c','a','l','l','e','r','.',
/* 0x08c32 = "GVM struct size is not compatible with the host page size." */
    'G','V','M',' ','s','t','r','u','c','t',' ','\xf8','\x0b','\x07','c','o','m','p','a','t','i','b','l','e',' ','\x7f','\x02','h','o','s','t',' ','\xbe','s','i','z','e','.',
/* 0x08c58 = "Power off is not supported by the hardware or the OS." */
    'P','o','w','e','r',' ','o','f','f',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','\x02','h','a','r','d','w','a','r','e',' ','\xa9','\x02','O','S','.',
/* 0x08c7e = "The component factories do not support the requested interface." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','i','e','s',' ','d','o',' ','\x07','\xd0','\x02','\xdf','i','n','t','e','r','f','a','c','e','.',
/* 0x08ca4 = "VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08cca = "Import ISO contains more than one primary volume descriptor." */
    '\xc4','\xc2',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','p','r','i','m','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x08cf0 = "The chunk has been mapped too many times already (impossible)." */
    '\x03','c','h','u','n','k',' ','\x5c','\xcd','m','a','p','p','e','d',' ','\x9e','\xb5','t','i','m','e','s',' ','\x80','(','i','m','p','o','s','s','i','b','l','e',')','.',
/* 0x08d16 = "VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08d3c = "The interpreter was unable to deal with the instruction at hand." */
    '\x03','i','n','t','e','r','p','r','e','t','e','r',' ','\x11','u','n','a','b','l','e',' ','\x0a','d','e','a','l',' ','\x7f','\x02','\xdc','a','t',' ','h','a','n','d','.',
/* 0x08d62 = "Unabled to locate or load the OpenGL library." */
    'U','n','a','b','l','e','d',' ','\x0a','l','o','c','a','t','e',' ','\xa9','l','o','a','d',' ','\x02','O','p','e','n','G','L',' ','l','i','b','r','a','r','y','.',
/* 0x08d88 = "Node pointer does not point to the start of a node." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\xb2','\x07','p','o','i','n','t',' ','\x0a','\x02','s','t','a','r','t',' ','\x15','a',' ','n','o','d','e','.',
/* 0x08dad = "We were given a NULL pPage parameter." */
    'W','e',' ','w','e','r','e',' ','g','i','v','e','n',' ','a',' ','N','U','L','L',' ','p','P','a','g','e',' ','p','a','r','a','m','e','t','e','r','.',
/* 0x08dd2 = "ICB is too small to contain anything useful." */
    'I','C','B',' ','\x0b','\x9e','s','m','a','l','l',' ','\x0a','c','o','n','t','a','i','n',' ','a','n','y','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x08df7 = "Expected write pipe, got a read pipe instead." */
    '\xb8','w','r','i','t','e',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','r','e','a','d',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x08e1c = "Invalid page count given to GMMR3FreePagesPerform." */
    '\x0c','\xbe','c','o','u','n','t',' ','g','i','v','e','n',' ','\x0a','G','M','M','R','3','F','r','e','e','P','a','g','e','s','P','e','r','f','o','r','m','.',
/* 0x08e41 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','U','N','D','E','F','I','N','E','D','_','F','L','A','G','S',
/* 0x08e66 = "Recompilation: End translation block." */
    'R','e','c','o','m','p','i','l','a','t','i','o','n',':',' ','E','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k','.',
/* 0x08e8b = "Certificate path validator: Name constraints permits no names." */
    '\xba','\xd2','\xff','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','p','e','r','m','i','t','s',' ','n','o',' ','n','a','m','e','s','.',
/* 0x08eb0 = "The device instance have no such logical unit." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','h','a','v','e',' ','n','o',' ','s','u','c','h',' ','l','o','g','i','c','a','l',' ','u','n','i','t','.',
/* 0x08ed5 = "Certificate path validator: Name constraints does not permits the certificate name." */
    '\xba','\xd2','\xff','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\xb2','\x07','p','e','r','m','i','t','s',' ','\x02','\xa0','n','a','m','e','.',
/* 0x08efa = "The tracer cannot open it self in the same session." */
    '\x03','t','r','a','c','e','r',' ','\xcf','o','p','e','n',' ','i','t',' ','s','e','l','f',' ','\x0f','\x02','s','a','m','e',' ','s','e','s','s','i','o','n','.',
/* 0x08f1f = "Failed to abort entering a critical section in ring-0." */
    '\x8b','\x0a','a','b','o','r','t',' ','e','n','t','e','r','i','n','g',' ','a',' ','c','r','i','t','i','c','a','l',' ','\xdd','\x0f','r','i','n','g','-','0','.',
/* 0x08f44 = "Couldn\'t find the end of CPUID sub-leaves." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','e','n','d',' ','\x15','C','P','U','I','D',' ','s','u','b','-','l','e','a','v','e','s','.',
/* 0x08f69 = "Expected read pipe, got a write pipe instead." */
    '\xb8','r','e','a','d',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','w','r','i','t','e',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x08f8e = "Key algorithm parameters are not known/supported." */
    'K','e','y',' ','\xd5','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x07','k','n','o','w','n','/','s','u','p','p','o','r','t','e','d','.',
/* 0x08fb3 = "Incompatible configuration requested." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','r','e','q','u','e','s','t','e','d','.',
/* 0x08fd8 = "Encountered a \'-\' during conversion to an unsigned value." */
    '\xa6','a',' ','\'','-','\'',' ','d','u','r','i','n','g',' ','c','o','n','v','e','r','s','i','o','n',' ','\x0a','\x87','u','n','s','i','g','n','e','d',' ','\xe8',
/* 0x08ffd = "Key encrypted but no password was given." */
    'K','e','y',' ','e','n','c','r','y','p','t','e','d',' ','b','u','t',' ','n','o',' ','p','a','s','s','w','o','r','d',' ','\x11','g','i','v','e','n','.',
/* 0x09022 = "The table of content string length didn\'t match the size specified in the header." */
    '\x03','\xb1','\x15','\xf0','\xf2','l','e','n','g','t','h',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','\xf8','\x18','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x09047 = "Import ISO contains more than one joliet volume descriptor." */
    '\xc4','\xc2',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','j','o','l','i','e','t',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0906c = "Reason for leaving RZ: Pending ring-3 IN instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','I','N',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x09091 = "The DTB structs block ended prematurely." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','e','n','d','e','d',' ','p','r','e','m','a','t','u','r','e','l','y','.',
/* 0x090b6 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','I','M','A','G','E','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x090db = "Reason for leaving R0: Hit a ring-0 assertion on EMT." */
    '\x93','\x10','\x81','R','0',':',' ','H','i','t',' ','a',' ','r','i','n','g','-','0',' ','a','s','s','e','r','t','i','o','n',' ','o','n',' ','E','M','T','.',
/* 0x09100 = "The boot catalog block in the import ISO is out of bounds." */
    '\x03','b','o','o','t',' ','\xe7','b','l','o','c','k',' ','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x09125 = "PCI passthru is not supported by this build." */
    'P','C','I',' ','p','a','s','s','t','h','r','u',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','t','h','i','s',' ','b','u','i','l','d','.',
/* 0x0914a = "Only native endian Mach-O files are supported." */
    'O','n','l','y',' ','n','a','t','i','v','e',' ','e','n','d','i','a','n',' ','M','a','c','h','-','O',' ','f','i','l','e','s',' ','a','r','e',' ','\xa5',
/* 0x0916f = "Error enumerating all processes in the session." */
    '\xc1','e','n','u','m','e','r','a','t','i','n','g',' ','a','l','l',' ','p','r','o','c','e','s','s','e','s',' ','\x0f','\x02','s','e','s','s','i','o','n','.',
/* 0x09194 = "Invalid/Corrupted configuration file." */
    'I','n','v','a','l','i','d','/','C','o','r','r','u','p','t','e','d',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','f','i','l','e','.',
/* 0x091b9 = "The saved state file size didn\'t match the one in the header." */
    '\x03','s','a','v','e','d',' ','\xcc','\x22','\xf8','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x091de = "The hyper CR3 differs between PGM and CPUM." */
    '\x03','h','y','p','e','r',' ','C','R','3',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','P','G','M',' ','\x9a','C','P','U','M','.',
/* 0x09203 = "Not able to allocate contiguous memory." */
    'N','o','t',' ','a','b','l','e',' ','\x0a','a','l','l','o','c','a','t','e',' ','c','o','n','t','i','g','u','o','u','s',' ','m','e','m','o','r','y','.',
/* 0x09228 = "validation of the fixup section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','f','i','x','u','p',' ','\xdd','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x7b',
/* 0x0924d = "OpenSSL and IPRT disagree on the signature." */
    'O','p','e','n','S','S','L',' ','\x9a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x09272 = "VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','U','C','T','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x09297 = "Mismatch between IPRT and native loader." */
    'M','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','I','P','R','T',' ','\x9a','n','a','t','i','v','e',' ','l','o','a','d','e','r','.',
/* 0x092bc = "The loaded XSAVE component mask is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x0b','\x07','v','a','l','i','d','.',
/* 0x092e1 = "The environment variable is an unset record." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x0b','\x87','u','n','s','e','t',' ','r','e','c','o','r','d','.',
/* 0x09306 = "Process Purification Failure: Unknown memory type of executable memory." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','\xef','\x86','\xf3','\x15','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x0932b = "Malformed indefinite length encoding." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x09350 = "Unresolved (unknown) host platform error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','\x85',
/* 0x09374 = "VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','\xd6','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x09398 = "The paging mode of the host is not supported yet." */
    '\x03','p','a','g','i','n','g',' ','m','o','d','e',' ','\x15','\x02','h','o','s','t',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','y','e','t','.',
/* 0x093bc = "Internal processing error in the PGM physical RAM range lookup code." */
    '\x08','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','R','A','M',' ','r','a','n','g','e',' ','l','o','o','k','u','p',' ','\x84',
/* 0x093e0 = "Certificate path validator: Intermediate certificate is not a version 3 certificate." */
    '\xba','\xd2','\xff','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','\x0b','\x07','a',' ','\xd1','3',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x09404 = "Image Verification Failure: Authenticode parsing output." */
    'I','m','a','g','e',' ','\x0d','\x12','A','u','t','h','e','n','t','i','c','o','d','e',' ','p','a','r','s','i','n','g',' ','o','u','t','p','u','t','.',
/* 0x09428 = "Continue execution after patch trap." */
    'C','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','p','a','t','c','h',' ','t','r','a','p','.',
/* 0x0944c = "Encountered a load command that\'s not implemented." */
    '\xa6','a',' ','l','o','a','d',' ','c','o','m','m','a','n','d',' ','t','h','a','t','\'','s',' ','\x07','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x09470 = "VM struct size is not compatible with the host page size." */
    '\xc6',' ','s','t','r','u','c','t',' ','\xf8','\x0b','\x07','c','o','m','p','a','t','i','b','l','e',' ','\x7f','\x02','h','o','s','t',' ','\xbe','s','i','z','e','.',
/* 0x09494 = "Failed while setting up a redirector rule." */
    '\x8b','w','h','i','l','e',' ','s','e','t','t','i','n','g',' ','u','p',' ','a',' ','r','e','d','i','r','e','c','t','o','r',' ','r','u','l','e','.',
/* 0x094b8 = "Error encoding the password for key decryption." */
    '\xc1','e','n','c','o','d','i','n','g',' ','\x02','p','a','s','s','w','o','r','d',' ','\x10','k','e','y',' ','d','e','c','r','y','p','t','i','o','n','.',
/* 0x094dc = "The DTB property payload string is not terminated." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xf2','\x0b','\x07','t','e','r','m','i','n','a','t','e','d','.',
/* 0x09500 = "Couldn\'t find ROM page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xbe','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x09524 = "Generic debug event, suspend the VM for debugging." */
    '\xa7','d','e','b','u','g',' ','e','v','e','n','t',',',' ','s','u','s','p','e','n','d',' ','\x02','\xc6',' ','\x10','d','e','b','u','g','g','i','n','g','.',
/* 0x09548 = "Unable to parse the CodeView debug information." */
    '\xe1','\x0a','p','a','r','s','e',' ','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0956c = "VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','T','O','K','E','N','_','I','N','V','A','L','I','D',
/* 0x09590 = "VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','H','E','A','D','E','R','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x095b4 = "OpenSSL failed to init PKIX cipher algorithm context." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','i','n','i','t',' ','P','K','I','X',' ','c','i','p','h','e','r',' ','\xd5','c','o','n','t','e','x','t','.',
/* 0x095d8 = "The breakpoint owner callback returned an invalid status code." */
    '\x03','\xc0','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','r','e','t','u','r','n','e','d',' ','\x87','\x8f','s','t','a','t','u','s',' ','\x84',
/* 0x095fc = "VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','D','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x09620 = "Invalid address mode passed to an IEM function." */
    '\x0c','a','d','d','r','e','s','s',' ','m','o','d','e',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x09644 = "The caller does not have a reference to the object." */
    '\x03','c','a','l','l','e','r',' ','\xb2','\x07','h','a','v','e',' ','a',' ','r','e','f','e','r','e','n','c','e',' ','\x0a','\x02','o','b','j','e','c','t','.',
/* 0x09668 = "Catch any access and route it thru PGM." */
    'C','a','t','c','h',' ','a','n','y',' ','a','c','c','e','s','s',' ','\x9a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0968c = "The ELF loader encountered a relocation type which is not implemented." */
    '\x03','E','L','F',' ','\xda','\xaf','a',' ','r','e','l','o','c','a','t','i','o','n',' ','\xf3','\xed','\x0b','\x07','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x096b0 = "Requested to import an unknown ISO format." */
    'R','e','q','u','e','s','t','e','d',' ','\x0a','i','m','p','o','r','t',' ','\x87','u','n','k','n','o','w','n',' ','\xc2',' ','f','o','r','m','a','t','.',
/* 0x096d4 = "The expanding of the dynamic mapping cache failed." */
    '\x03','e','x','p','a','n','d','i','n','g',' ','\x15','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x7b',
/* 0x096f8 = "The image is required to force integrity checks." */
    '\x03','\x26','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','f','o','r','c','e',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','s','.',
/* 0x0971c = "Process Verification Failure: Error reading process memory for comparing with disk data." */
    '\x1e','\x0d','\x12','\xc1','r','e','a','d','i','n','g',' ','\x92','\x86','\x10','c','o','m','p','a','r','i','n','g',' ','\x7f','d','i','s','k',' ','d','a','t','a','.',
/* 0x09740 = "The shadow paging mode is not supported yet." */
    '\x03','s','h','a','d','o','w',' ','p','a','g','i','n','g',' ','m','o','d','e',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','y','e','t','.',
/* 0x09764 = "Reason for leaving RC: Sync the GDT table to solve a conflict." */
    '\x93','\x10','\x81','R','C',':',' ','S','y','n','c',' ','\x02','G','D','T',' ','\xb1','\x0a','s','o','l','v','e',' ','a',' ','c','o','n','f','l','i','c','t','.',
/* 0x09788 = "The timer queue is not longer allowed to grow." */
    '\x03','t','i','m','e','r',' ','q','u','e','u','e',' ','\x0b','\x07','l','o','n','g','e','r',' ','a','l','l','o','w','e','d',' ','\x0a','g','r','o','w','.',
/* 0x097ac = "The timer can\'t be started because it\'s already active." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\xa4','s','t','a','r','t','e','d',' ','\x2a','i','t','\'','s',' ','\x80','a','c','t','i','v','e','.',
/* 0x097d0 = "The MMIO handler was called for a bogus address!" */
    '\x03','\xd4',' ','h','a','n','d','l','e','r',' ','\x11','c','a','l','l','e','d',' ','\x10','a',' ','b','o','g','u','s',' ','a','d','d','r','e','s','s','!',
/* 0x097f4 = "The thread is not a valid signaller of the event." */
    '\x03','t','h','r','e','a','d',' ','\x0b','\x07','a',' ','v','a','l','i','d',' ','s','i','g','n','a','l','l','e','r',' ','\x15','\x02','e','v','e','n','t','.',
/* 0x09818 = "Syntax error - an undefined variable was referenced." */
    '\xfb','\x09','-',' ','\x87','u','n','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e',' ','\x11','r','e','f','e','r','e','n','c','e','d','.',
/* 0x0983c = "Specified digest not supported in this context." */
    'S','p','e','c','i','f','i','e','d',' ','\xd8','\x07','s','u','p','p','o','r','t','e','d',' ','\x0f','t','h','i','s',' ','c','o','n','t','e','x','t','.',
/* 0x09860 = "Current virtual machine state prevents the operation." */
    'C','u','r','r','e','n','t',' ','v','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\xcc','p','r','e','v','e','n','t','s',' ','\x02','\xea',
/* 0x09884 = "VFS chain element takes a file system (vfs) object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x22','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x098a8 = "Import ISO contains a bad supplementary volume descriptor." */
    '\xc4','\xc2',' ','\x8a','a',' ','b','a','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x098cc = "VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','P','R','E','M','A','T','U','R','E','_','E','N','D',
/* 0x098f0 = "Network dropped connection on reset." */
    'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','.',
/* 0x09914 = "VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID" */
    '\x01','\xf4','E','X','P','E','C','T','E','D','_','I','N','D','I','R','E','C','T','_','D','A','T','A','_','C','O','N','T','E','N','T','_','O','I','D',
/* 0x09938 = "Incomplete packet was submitted by guest." */
    'I','n','c','o','m','p','l','e','t','e',' ','p','a','c','k','e','t',' ','\x11','s','u','b','m','i','t','t','e','d',' ','\xdb','g','u','e','s','t','.',
/* 0x0995c = "The lock validator detected a deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','a',' ','d','e','a','d','l','o','c','k','.',
/* 0x09980 = "Reason for leaving RC: The IRET resuming guest code trapped." */
    '\x93','\x10','\x81','R','C',':',' ','\x03','I','R','E','T',' ','r','e','s','u','m','i','n','g',' ','\xbb','c','o','d','e',' ','t','r','a','p','p','e','d','.',
/* 0x099a4 = "Invalid parameters passed to the lock validator." */
    '\x0c','p','a','r','a','m','e','t','e','r','s',' ','p','a','s','s','e','d',' ','\x0a','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r','.',
/* 0x099c8 = "Encountered an unsupported Solaris Tar extension." */
    '\xa6','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','S','o','l','a','r','i','s',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x099ec = "Recompiler: Duplicate argument variable number." */
    '\x13','D','u','p','l','i','c','a','t','e',' ','a','r','g','u','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','u','m','b','e','r','.',
/* 0x09a10 = "The guest has not setup use of the paravirtualized TSC." */
    '\x03','\xbb','\x5c','\x07','s','e','t','u','p',' ','u','s','e',' ','\x15','\x02','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x09a34 = "General failure - DON\'T USE THIS!!!." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','-',' ','D','O','N','\'','T',' ','U','S','E',' ','T','H','I','S','!','!','!','.',
/* 0x09a58 = "Unexpected/unknown/bad descriptor in volume descriptor sequence." */
    'U','n','e','x','p','e','c','t','e','d','/','u','n','k','n','o','w','n','/','b','a','d',' ','\xe3','\x0f','\xd3','\xe3','s','e','q','u','e','n','c','e','.',
/* 0x09a7c = "CPU microarch lookup matched by name." */
    'C','P','U',' ','m','i','c','r','o','a','r','c','h',' ','l','o','o','k','u','p',' ','m','a','t','c','h','e','d',' ','\xdb','n','a','m','e','.',
/* 0x09a9f = "General failure during URB queuing." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','U','R','B',' ','q','u','e','u','i','n','g','.',
/* 0x09ac2 = "PE image data without any valid content was not expected." */
    'P','E',' ','\x26','\x9d','w','i','t','h','o','u','t',' ','a','n','y',' ','v','a','l','i','d',' ','\xf0','\x11','\x07','e','x','p','e','c','t','e','d','.',
/* 0x09ae5 = "Too many calls to the service from a client." */
    'T','o','o',' ','\xb5','c','a','l','l','s',' ','\x0a','\x02','s','e','r','v','i','c','e',' ','f','r','o','m',' ','a',' ','c','l','i','e','n','t','.',
/* 0x09b08 = "DWARF LEB value overflows the decoder type." */
    'D','W','A','R','F',' ','L','E','B',' ','\xf5','o','v','e','r','f','l','o','w','s',' ','\x02','d','e','c','o','d','e','r',' ','t','y','p','e','.',
/* 0x09b2b = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','U','S','E','S','_','U','N','U','S','E','D','_','F','I','E','L','D',
/* 0x09b4e = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE" */
    '\x01','\x24','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','C','H','O','I','C','E',
/* 0x09b71 = "The machine was powered off while saving." */
    '\x03','m','a','c','h','i','n','e',' ','\x11','p','o','w','e','r','e','d',' ','o','f','f',' ','w','h','i','l','e',' ','s','a','v','i','n','g','.',
/* 0x09b94 = "Support for forwarders has not been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','f','o','r','w','a','r','d','e','r','s',' ','\x5c','\x07','\xcd','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x09bb7 = "Host backend couldn\'t be initialized." */
    'H','o','s','t',' ','b','a','c','k','e','n','d',' ','c','o','u','l','d','n','\'','t',' ','\xa4','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x09bda = "The PE loader encountered a certificate with an unsupported type or structure revision." */
    '\x03','P','E',' ','\xda','\xaf','a',' ','\xa0','\x7f','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','\xf3','\xa9','\xec','r','e','v','i','s','i','o','n','.',
/* 0x09bfd = "The current HTTP request was forcefully aborted." */
    '\x03','c','u','r','r','e','n','t',' ','H','T','T','P',' ','\xab','\x11','f','o','r','c','e','f','u','l','l','y',' ','a','b','o','r','t','e','d','.',
/* 0x09c20 = "Error while calculating a digest for a PKCS #7 verification operation." */
    '\xc1','w','h','i','l','e',' ','c','a','l','c','u','l','a','t','i','n','g',' ','a',' ','\xd8','\x10','a',' ','P','K','C','S',' ','#','7',' ','\xf9','\xea',
/* 0x09c43 = "VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING" */
    '\x01','F','D','T','_','D','T','B','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','T','E','R','M','I','N','A','T','O','R','_','\xc5',
/* 0x09c66 = "No host backend attached / available." */
    '\xe0','h','o','s','t',' ','b','a','c','k','e','n','d',' ','a','t','t','a','c','h','e','d',' ','/',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x09c89 = "Attempted to insert mode with invalid key range." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','i','n','s','e','r','t',' ','m','o','d','e',' ','\x7f','\x8f','k','e','y',' ','r','a','n','g','e','.',
/* 0x09cac = "Service rejected client connection." */
    'S','e','r','v','i','c','e',' ','r','e','j','e','c','t','e','d',' ','c','l','i','e','n','t',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x09ccf = "A boot catalog entry in the import ISO has an unknown type." */
    'A',' ','b','o','o','t',' ','\xe7','\xca','\x0f','\x02','i','m','p','o','r','t',' ','\xc2',' ','\x5c','\x87','u','n','k','n','o','w','n',' ','t','y','p','e','.',
/* 0x09cf2 = "The async completion task is not suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x0b','\x07','s','u','s','p','e','n','d','e','d','.',
/* 0x09d15 = "The dynamic mapping cache for physical memory failed." */
    '\x03','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x10','p','h','y','s','i','c','a','l',' ','\x86','\x7b',
/* 0x09d38 = "VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','Q','U','E','R','Y','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x09d5b = "The async completion task is already suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x0b','\x80','s','u','s','p','e','n','d','e','d','.',
/* 0x09d7e = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','E','N','D','_','O','F','_','S','E','C','T','O','R',
/* 0x09da1 = "Import ISO contains an unsupported primary volume descriptor version." */
    '\xc4','\xc2',' ','\x8a','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','p','r','i','m','a','r','y',' ','\xd3','\xe3','v','e','r','s','i','o','n','.',
/* 0x09dc4 = "The CR3 address specified memory we don\'t know about." */
    '\x03','C','R','3',' ','a','d','d','r','e','s','s',' ','\x18','\x86','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x09de7 = "Process Verification Failure: One of the section in the image file is not mapped into memory." */
    '\x1e','\x0d','\x12','O','n','e',' ','\x15','\x02','\xdd','\x0f','\x02','\x26','\x22','\x0b','\x07','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x09e0a = "Don\'t mess around with ballooned pages." */
    'D','o','n','\'','t',' ','m','e','s','s',' ','a','r','o','u','n','d',' ','\x7f','b','a','l','l','o','o','n','e','d',' ','p','a','g','e','s','.',
/* 0x09e2d = "Too long forwarder chain or there is a loop." */
    'T','o','o',' ','l','o','n','g',' ','f','o','r','w','a','r','d','e','r',' ','\xa1','\xa9','t','h','e','r','e',' ','\x0b','a',' ','l','o','o','p','.',
/* 0x09e50 = "Don\'t call again until the final pass." */
    'D','o','n','\'','t',' ','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x09e73 = "VMDK: Format is invalid/inconsistent." */
    'V','M','D','K',':',' ','F','o','r','m','a','t',' ','\x0b','i','n','v','a','l','i','d','/','i','n','c','o','n','s','i','s','t','e','n','t','.',
/* 0x09e96 = "The symbol size was adjusted while adding it." */
    '\x03','s','y','m','b','o','l',' ','\xf8','\x11','a','d','j','u','s','t','e','d',' ','w','h','i','l','e',' ','a','d','d','i','n','g',' ','i','t','.',
/* 0x09eb9 = "No GIM provider is configured for this VM." */
    '\xe0','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x0b','c','o','n','f','i','g','u','r','e','d',' ','\x10','t','h','i','s',' ','V','M','.',
/* 0x09edc = "The signature is too long for the scratch buffer." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','\x9e','l','o','n','g',' ','\x10','\x02','s','c','r','a','t','c','h',' ','b','u','f','f','e','r','.',
/* 0x09eff = "The page hash table is not strictly ordered by offset." */
    '\x03','\xbe','h','a','s','h',' ','\xb1','\x0b','\x07','s','t','r','i','c','t','l','y',' ','o','r','d','e','r','e','d',' ','\xdb','o','f','f','s','e','t','.',
/* 0x09f22 = "The address (virtual or physical) is too big." */
    '\x03','a','d','d','r','e','s','s',' ','(','v','i','r','t','u','a','l',' ','\xa9','p','h','y','s','i','c','a','l',')',' ','\x0b','\x9e','b','i','g','.',
/* 0x09f45 = "The length of the segment name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','s','e','g','m','e','n','t',' ','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x09f68 = "The DTB structs block starts with an invalid token." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','s','t','a','r','t','s',' ','\x7f','\x87','\x8f','t','o','k','e','n','.',
/* 0x09f8b = "The RTPROC_FLAGS_DETACHED flag isn\'t supported." */
    '\x03','R','T','P','R','O','C','_','F','L','A','G','S','_','D','E','T','A','C','H','E','D',' ','f','l','a','g',' ','i','s','n','\'','t',' ','\xa5',
/* 0x09fae = "The compressed data started with a bad header." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9d','s','t','a','r','t','e','d',' ','\x7f','a',' ','b','a','d',' ','h','e','a','d','e','r','.',
/* 0x09fd1 = "iSCSI: Initiator secret not decrypted." */
    'i','S','C','S','I',':',' ','I','n','i','t','i','a','t','o','r',' ','s','e','c','r','e','t',' ','\x07','d','e','c','r','y','p','t','e','d','.',
/* 0x09ff4 = "An illegal lock upgrade was attempted." */
    'A','n',' ','i','l','l','e','g','a','l',' ','l','o','c','k',' ','u','p','g','r','a','d','e',' ','\x11','a','t','t','e','m','p','t','e','d','.',
/* 0x0a017 = "Attempted to disabled a breakpoint which was already disabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','d','i','s','a','b','l','e','d',' ','a',' ','\xc0','\xed','\x11','\x80','d','i','s','a','b','l','e','d','.',
/* 0x0a03a = "The session has no tracer associated with it." */
    '\x03','s','e','s','s','i','o','n',' ','\x5c','n','o',' ','t','r','a','c','e','r',' ','a','s','s','o','c','i','a','t','e','d',' ','\x7f','i','t','.',
/* 0x0a05d = "VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','A','N','D','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','S','_','\x19',
/* 0x0a080 = "Ping-Pong listen or speak out of turn error." */
    'P','i','n','g','-','P','o','n','g',' ','l','i','s','t','e','n',' ','\xa9','s','p','e','a','k',' ','o','u','t',' ','\x15','t','u','r','n',' ','\x85',
/* 0x0a0a3 = "The selected platform architecture is not supported." */
    '\x03','s','e','l','e','c','t','e','d',' ','p','l','a','t','f','o','r','m',' ','a','r','c','h','i','t','e','c','t','u','r','e',' ','\x0b','\x07','\xa5',
/* 0x0a0c6 = "VERR_X509_CERTIFICATE_VERIFICATION_FAILURE" */
    '\x01','\xb7','C','E','R','T','I','F','I','C','A','T','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x0a0e8 = "Precodition no 0 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','0',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a10a = "The compression format version is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','f','o','r','m','a','t',' ','\xd1','\x0b','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0a12c = "Unable to start VM execution due to an invalid guest state." */
    '\xe1','\x0a','s','t','a','r','t',' ','\xc6',' ','e','x','e','c','u','t','i','o','n',' ','d','u','e',' ','\x0a','\x87','\x8f','\xbb','s','t','a','t','e','.',
/* 0x0a14e = "A driver may only register one VTG object per session." */
    'A',' ','\xc7','m','a','y',' ','o','n','l','y',' ','\xeb','o','n','e',' ','V','T','G',' ','\xa8','p','e','r',' ','s','e','s','s','i','o','n','.',
/* 0x0a170 = "There is not enough data to satisfy the request." */
    'T','h','e','r','e',' ','\x0b','\x07','e','n','o','u','g','h',' ','\x9d','\x0a','s','a','t','i','s','f','y',' ','\x02','r','e','q','u','e','s','t','.',
/* 0x0a192 = "Found something which isn\'t a file nor a directory (hardening)." */
    'F','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','\xed','i','s','n','\'','t',' ','a',' ','\x22','n','o','r',' ','a',' ','\x25','\xae',
/* 0x0a1b4 = "VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER" */
    '\x01','\x1f','B','O','O','T','_','C','A','T','_','E','X','P','E','C','T','E','D','_','S','E','C','T','I','O','N','_','H','E','A','D','E','R',
/* 0x0a1d6 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','E','O','S',
/* 0x0a1f8 = "Algorithm parameters does not match the key." */
    'A','l','g','o','r','i','t','h','m',' ','p','a','r','a','m','e','t','e','r','s',' ','\xb2','\x07','m','a','t','c','h',' ','\x02','k','e','y','.',
/* 0x0a21a = "No space for rock ridge \'CE\' entry in directory record." */
    '\xe0','s','p','a','c','e',' ','\x10','r','o','c','k',' ','r','i','d','g','e',' ','\'','C','E','\'',' ','\xca','\x0f','\x25','r','e','c','o','r','d','.',
/* 0x0a23c = "Couldn\'t map pages during receive." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','r','e','c','e','i','v','e','.',
/* 0x0a25e = "NEM init failed because of missing kernel API (#5)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','5',')','.',
/* 0x0a280 = "Already aliased to a different page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x0a','a',' ','d','i','f','f','e','r','e','n','t',' ','p','a','g','e','.',
/* 0x0a2a2 = "The integer value was too big for the requested representation." */
    '\x03','i','n','t','e','g','e','r',' ','\xf5','\x11','\x9e','b','i','g',' ','\x10','\x02','\xdf','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0a2c4 = "VRDP thread has started OK and will run." */
    'V','R','D','P',' ','t','h','r','e','a','d',' ','\x5c','s','t','a','r','t','e','d',' ','O','K',' ','\x9a','w','i','l','l',' ','r','u','n','.',
/* 0x0a2e6 = "The request could not be canceled because it already completed." */
    '\x03','\xab','c','o','u','l','d',' ','\x07','\xa4','c','a','n','c','e','l','e','d',' ','\x2a','i','t',' ','\x80','c','o','m','p','l','e','t','e','d','.',
/* 0x0a308 = "The device instance have no base interface." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','h','a','v','e',' ','n','o',' ','b','a','s','e',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x0a32a = "Precodition no 2 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','2',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a34c = "Internal error, VRDP packet is in wrong operation mode." */
    '\x08','e','r','r','o','r',',',' ','V','R','D','P',' ','p','a','c','k','e','t',' ','\x0b','\x0f','w','r','o','n','g',' ','\x96','m','o','d','e','.',
/* 0x0a36e = "VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','G','O','_','\x06','K','N','O','W','N','_','E','V','P',
/* 0x0a390 = "NtSetInformationObject/NoInherit failed." */
    'N','t','S','e','t','I','n','f','o','r','m','a','t','i','o','n','O','b','j','e','c','t','/','N','o','I','n','h','e','r','i','t',' ','\x7b',
/* 0x0a3b2 = "NEM init failed because of missing kernel API (#3)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','3',')','.',
/* 0x0a3d4 = "Internal ISO maker error: Rock ridge read problem." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','R','o','c','k',' ','r','i','d','g','e',' ','r','e','a','d',' ','p','r','o','b','l','e','m','.',
/* 0x0a3f6 = "Pending stream disable operation in progress." */
    'P','e','n','d','i','n','g',' ','s','t','r','e','a','m',' ','d','i','s','a','b','l','e',' ','\x96','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x0a418 = "Type error opening the ApiPort LPC object." */
    'T','y','p','e',' ','\x09','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0a43a = "The image is the correct format but is corrupted." */
    '\x03','\x26','\x0b','\x02','c','o','r','r','e','c','t',' ','f','o','r','m','a','t',' ','b','u','t',' ','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x0a45c = "Internal ISO maker error: Finalization problem #1." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','F','i','n','a','l','i','z','a','t','i','o','n',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0a47e = "VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA" */
    '\x01','\xce','H','A','S','H','_','T','A','B','_','H','A','S','H','E','S','_','N','O','N','_','S','E','C','T','I','O','N','_','D','A','T','A',
/* 0x0a4a0 = "VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','T','A','K','E','S','_','\x60','P','A','R','A','M','E','T','E','R','S',
/* 0x0a4c2 = "The file contained a data unit which no-one wants." */
    '\x03','\x22','c','o','n','t','a','i','n','e','d',' ','a',' ','\x9d','u','n','i','t',' ','\xed','n','o','-','o','n','e',' ','w','a','n','t','s','.',
/* 0x0a4e4 = "Reason for leaving RC: int3 with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','i','n','t','3',' ','\x7f','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x84',
/* 0x0a506 = "VERR_REST_RESPONSE_REPEAT_HEADER_FIELD" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','R','E','P','E','A','T','_','H','E','A','D','E','R','_','F','I','E','L','D',
/* 0x0a528 = "The length of the symbol name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','s','y','m','b','o','l',' ','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0a54a = "Precodition no 1 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','1',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a56c = "Import ISO contains a root directory with an out of bounds data extent." */
    '\xc4','\xc2',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x7f','\x87','o','u','t',' ','\x15','b','o','u','n','d','s',' ','\x9d','e','x','t','e','n','t','.',
/* 0x0a58e = "The mode field should not include the type." */
    '\x03','m','o','d','e',' ','f','i','e','l','d',' ','s','h','o','u','l','d',' ','\x07','i','n','c','l','u','d','e',' ','\x02','t','y','p','e','.',
/* 0x0a5b0 = "VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH" */
    '\x01','\xa2','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0a5d2 = "Semaphore destroyed while waiting." */
    'S','e','m','a','p','h','o','r','e',' ','d','e','s','t','r','o','y','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g','.',
/* 0x0a5f4 = "VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x0a616 = "This VirtualBox build does not support raw-mode." */
    'T','h','i','s',' ','V','i','r','t','u','a','l','B','o','x',' ','b','u','i','l','d',' ','\xb2','\x07','\xd0','r','a','w','-','m','o','d','e','.',
/* 0x0a638 = "The size of the raw optical image is too small (<= 32K)." */
    '\x03','\xf8','\x15','\x02','r','a','w',' ','o','p','t','i','c','a','l',' ','\x26','\x0b','\x9e','s','m','a','l','l',' ','(','<','=',' ','3','2','K',')','.',
/* 0x0a65a = "NEM init failed because of missing kernel API (#1)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','1',')','.',
/* 0x0a67c = "The request has been freed, don\'t read the status now." */
    '\x03','\xab','\x5c','\xcd','f','r','e','e','d',',',' ','d','o','n','\'','t',' ','r','e','a','d',' ','\x02','s','t','a','t','u','s',' ','n','o','w','.',
/* 0x0a69e = "Host is about to go into suspend mode." */
    'H','o','s','t',' ','\x0b','a','b','o','u','t',' ','\x0a','g','o',' ','i','n','t','o',' ','s','u','s','p','e','n','d',' ','m','o','d','e','.',
/* 0x0a6c0 = "ROM page mismatch between saved state and the VM." */
    'R','O','M',' ','\xbe','m','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','s','a','v','e','d',' ','\xcc','\x9a','\x02','V','M','.',
/* 0x0a6e2 = "NEM init failed because of missing kernel API (#2)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','2',')','.',
/* 0x0a704 = "VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x0a726 = "VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','L','A','S','T','_','C','O','M','P','A','T','_','\xbc','_','I','N','V','A','L','I','D',
/* 0x0a748 = "One or the PDPEs specified memory we don\'t know about." */
    'O','n','e',' ','\xa9','\x02','P','D','P','E','s',' ','\x18','\x86','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0a76a = "The specified segment:offset address was invalid." */
    '\x03','\x18','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0a78c = "The data in the saved state doesn't conform to expectations." */
    '\x03','\x9d','\x0f','\x02','s','a','v','e','d',' ','\xcc','\xc9','c','o','n','f','o','r','m',' ','\x0a','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0a7ae = "NEM init failed because of missing kernel API (#4)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x2a','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','4',')','.',
/* 0x0a7d0 = "Precodition no 3 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','3',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a7f2 = "The discard operation is not supported for this image." */
    '\x03','d','i','s','c','a','r','d',' ','\x96','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\x10','t','h','i','s',' ','i','m','a','g','e','.',
/* 0x0a814 = "The image base address is to high for this image type." */
    '\x03','\x26','b','a','s','e',' ','a','d','d','r','e','s','s',' ','\x0b','\x0a','h','i','g','h',' ','\x10','t','h','i','s',' ','\x26','t','y','p','e','.',
/* 0x0a836 = "VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION" */
    '\x01','\x7d','M','I','S','C','O','N','F','I','G','U','R','E','D','_','D','R','V','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0a858 = "Couldn\'t connect to the server (proxy?" */
    'C','o','u','l','d','n','\'','t',' ','c','o','n','n','e','c','t',' ','\x0a','\x02','s','e','r','v','e','r',' ','(','p','r','o','x','y','?',
/* 0x0a879 = "Unknown escape sequence encountered in TeletexString." */
    '\xef','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\xaf','\x0f','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0a89a = "An operation caused a nested-guest SVM #VMEXIT." */
    'A','n',' ','\x96','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xbb','S','V','M',' ','#','V','M','E','X','I','T','.',
/* 0x0a8bb = "Can\'t send after socket shutdown." */
    'C','a','n','\'','t',' ','s','e','n','d',' ','a','f','t','e','r',' ','s','o','c','k','e','t',' ','s','h','u','t','d','o','w','n','.',
/* 0x0a8dc = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','H','E','A','D','E','R','_','I','D',
/* 0x0a8fd = "Import ISO contains a root directory with a bad record length." */
    '\xc4','\xc2',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x7f','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0a91e = "The indirect data digest size does not match the digest algorithm." */
    '\x03','i','n','d','i','r','e','c','t',' ','\x9d','\xd8','\xf8','\xb2','\x07','m','a','t','c','h',' ','\x02','\xd8','a','l','g','o','r','i','t','h','m','.',
/* 0x0a93f = "A path does not start with a root specification." */
    'A',' ','\xd2','\xb2','\x07','s','t','a','r','t',' ','\x7f','a',' ','r','o','o','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',
/* 0x0a960 = "OpenSSL failed to decode the key parameters." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','d','e','c','o','d','e',' ','\x02','k','e','y',' ','p','a','r','a','m','e','t','e','r','s','.',
/* 0x0a981 = "Security (en/decryption) engine error." */
    'S','e','c','u','r','i','t','y',' ','(','e','n','/','d','e','c','r','y','p','t','i','o','n',')',' ','e','n','g','i','n','e',' ','\x85',
/* 0x0a9a2 = "Reason for leaving RC: #GP with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','#','G','P',' ','\x7f','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x84',
/* 0x0a9c3 = "There is not enough room to store the data." */
    'T','h','e','r','e',' ','\x0b','\x07','e','n','o','u','g','h',' ','r','o','o','m',' ','\x0a','s','t','o','r','e',' ','\x02','d','a','t','a','.',
/* 0x0a9e4 = "Software caused connection abort." */
    'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','.',
/* 0x0aa05 = "Return to ring-3 to write the MSR there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','w','r','i','t','e',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0aa26 = "The file list doesn't match to the content of the manifest file." */
    '\x03','\x22','l','i','s','t',' ','\xc9','m','a','t','c','h',' ','\x0a','\x02','\xf0','\x15','\x02','m','a','n','i','f','e','s','t',' ','f','i','l','e','.',
/* 0x0aa47 = "The logical volume descriptor has a too big partition map." */
    '\x03','l','o','g','i','c','a','l',' ','\xd3','\xe3','\x5c','a',' ','\x9e','b','i','g',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p','.',
/* 0x0aa68 = "Reason for leaving RC: #PF with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','#','P','F',' ','\x7f','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x84',
/* 0x0aa89 = "Attempted to enabled a breakpoint which was already enabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','e','n','a','b','l','e','d',' ','a',' ','\xc0','\xed','\x11','\x80','e','n','a','b','l','e','d','.',
/* 0x0aaaa = "VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','E','M','B','E','D','D','E','D','_','Z','E','R','O','_','C','H','A','R',
/* 0x0aacb = "VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER" */
    '\x01','\x7d','C','A','N','N','O','T','_','T','R','A','N','S','F','O','R','M','_','R','E','M','O','V','E','D','_','D','R','I','V','E','R',
/* 0x0aaec = "Unsupported escape sequence encountered in TeletexString." */
    '\x98','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\xaf','\x0f','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0ab0d = "Error extracting RSA from the public key." */
    '\xc1','e','x','t','r','a','c','t','i','n','g',' ','R','S','A',' ','f','r','o','m',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0ab2e = "The compression method is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','m','e','t','h','o','d',' ','\x0b','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0ab4f = "Emulate split-lock access on SMP." */
    'E','m','u','l','a','t','e',' ','s','p','l','i','t','-','l','o','c','k',' ','a','c','c','e','s','s',' ','o','n',' ','S','M','P','.',
/* 0x0ab70 = "The ELF loader doesn't handle foreign endianness." */
    '\x03','E','L','F',' ','\xda','\xc9','h','a','n','d','l','e',' ','f','o','r','e','i','g','n',' ','e','n','d','i','a','n','n','e','s','s','.',
/* 0x0ab91 = "VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS" */
    '\x01','\xb9','_','B','P','_','O','W','N','E','R','_','C','A','L','L','B','A','C','K','_','W','R','O','N','G','_','S','T','A','T','U','S',
/* 0x0abb2 = "Malformed code signing structure." */
    'M','a','l','f','o','r','m','e','d',' ','c','o','d','e',' ','s','i','g','n','i','n','g',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0abd3 = "Invalid size of a SSM field with the specified transformation." */
    '\x0c','\xf8','\x15','a',' ','S','S','M',' ','f','i','e','l','d',' ','\x7f','\x02','\x18','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0abf4 = "The networking interface to filter was not found." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x0a','f','i','l','t','e','r',' ','\x11','\x07','\x89',
/* 0x0ac15 = "Page not marked for dirty bit tracking." */
    'P','a','g','e',' ','\x07','m','a','r','k','e','d',' ','\x10','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g','.',
/* 0x0ac36 = "Reason for leaving RC: Interrupt pending (guest)." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t',' ','p','e','n','d','i','n','g',' ','(','g','u','e','s','t',')','.',
/* 0x0ac57 = "Reason for leaving RC: #PF for monitored patch page." */
    '\x93','\x10','\x81','R','C',':',' ','#','P','F',' ','\x10','m','o','n','i','t','o','r','e','d',' ','p','a','t','c','h',' ','p','a','g','e','.',
/* 0x0ac78 = "Saving the VM state is temporarily not allowed." */
    'S','a','v','i','n','g',' ','\x02','\xc6',' ','\xcc','\x0b','t','e','m','p','o','r','a','r','i','l','y',' ','\x07','a','l','l','o','w','e','d','.',
/* 0x0ac99 = "Error reading a certificate in PEM format from BIO." */
    '\xc1','r','e','a','d','i','n','g',' ','a',' ','\xa0','\x0f','P','E','M',' ','f','o','r','m','a','t',' ','f','r','o','m',' ','B','I','O','.',
/* 0x0acba = "Process Verification Failure: Error determining the full path of System32." */
    '\x1e','\x0d','\x12','\xc1','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','f','u','l','l',' ','\xd2','\x15','S','y','s','t','e','m','3','2','.',
/* 0x0acdb = "Entry in a boot catalog section is another section." */
    'E','n','t','r','y',' ','\x0f','a',' ','b','o','o','t',' ','\xe7','\xdd','\x0b','a','n','o','t','h','e','r',' ','s','e','c','t','i','o','n','.',
/* 0x0acfc = "Internal ISO maker error: Descriptor miscounting." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','D','e','s','c','r','i','p','t','o','r',' ','m','i','s','c','o','u','n','t','i','n','g','.',
/* 0x0ad1d = "Process Verification Failure: Unexpected section protection flag combination." */
    '\x1e','\x0d','\x12','\x94','\xdd','p','r','o','t','e','c','t','i','o','n',' ','f','l','a','g',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0ad3e = "The tracer has already been opened in this sesssion." */
    '\x03','t','r','a','c','e','r',' ','\x5c','\x80','\xcd','o','p','e','n','e','d',' ','\x0f','t','h','i','s',' ','s','e','s','s','s','i','o','n','.',
/* 0x0ad5f = "Invalid or unsupported logical block size." */
    '\x0c','\xa9','u','n','s','u','p','p','o','r','t','e','d',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e','.',
/* 0x0ad80 = "The process specified to a non-block wait had not exited." */
    '\x03','\x92','\x18','\x0a','a',' ','n','o','n','-','b','l','o','c','k',' ','w','a','i','t',' ','h','a','d',' ','\x07','e','x','i','t','e','d','.',
/* 0x0ada1 = "Can\'t free the memory because it\'s used in mapping." */
    'C','a','n','\'','t',' ','f','r','e','e',' ','\x02','\x86','\x2a','i','t','\'','s',' ','u','s','e','d',' ','\x0f','m','a','p','p','i','n','g','.',
/* 0x0adc2 = "VFS chain element only provides directory (dir) objects." */
    '\x8d',' ','\xa1','\x5e','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x25','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x0ade3 = "A required query parameter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','q','u','e','r','y',' ','p','a','r','a','m','e','t','e','r',' ','\x11','\x07','s','e','t','.',
/* 0x0ae04 = "The checksum of a tar header record doesn't match." */
    '\x03','c','h','e','c','k','s','u','m',' ','\x15','a',' ','t','a','r',' ','\xb4','r','e','c','o','r','d',' ','\xc9','m','a','t','c','h','.',
/* 0x0ae24 = "Precodition no 1 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','1',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0ae44 = "Invalid session ID in managed object reference." */
    '\x0c','s','e','s','s','i','o','n',' ','I','D',' ','\x0f','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0ae64 = "Warning X509 certificate isn\'t self signed." */
    'W','a','r','n','i','n','g',' ','X','5','0','9',' ','\xa0','i','s','n','\'','t',' ','s','e','l','f',' ','s','i','g','n','e','d','.',
/* 0x0ae84 = "The file is not a valid /proc/kallsyms file." */
    '\x03','\x22','\x0b','\x07','a',' ','v','a','l','i','d',' ','/','p','r','o','c','/','k','a','l','l','s','y','m','s',' ','f','i','l','e','.',
/* 0x0aea4 = "Syntax error - too many arguments for static storage." */
    '\xfb','\x09','-',' ','\x9e','\xb5','a','r','g','u','m','e','n','t','s',' ','\x10','s','t','a','t','i','c',' ','s','t','o','r','a','g','e','.',
/* 0x0aec4 = "The handle ID is already present in the poll set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x0b','\x80','p','r','e','s','e','n','t',' ','\x0f','\x02','p','o','l','l',' ','s','e','t','.',
/* 0x0aee4 = "There is no cache attached to the disk." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','\x0a','\x02','d','i','s','k','.',
/* 0x0af04 = "An unknown config value was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','\xf5','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0af24 = "The volume map doesn't contain any valid volume." */
    '\x03','\xd3','m','a','p',' ','\xc9','c','o','n','t','a','i','n',' ','a','n','y',' ','v','a','l','i','d',' ','v','o','l','u','m','e','.',
/* 0x0af44 = "Precodition no 0 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','0',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0af64 = "VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','F','E','A','T','U','R','E','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x0af84 = "Internal ISO maker error: Buggy namespace table." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','B','u','g','g','y',' ','n','a','m','e','s','p','a','c','e',' ','t','a','b','l','e','.',
/* 0x0afa4 = "Reason for leaving RC: A Ring switch was attempted." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x11','a','t','t','e','m','p','t','e','d','.',
/* 0x0afc4 = "Precodition no 2 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','2',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0afe4 = "Incompatible CPUM configuration." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','C','P','U','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0b004 = "Data connection limit has been reached." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','l','i','m','i','t',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x0b024 = "HMR0Leave was called on the wrong CPU." */
    'H','M','R','0','L','e','a','v','e',' ','\x11','c','a','l','l','e','d',' ','o','n',' ','\x02','w','r','o','n','g',' ','C','P','U','.',
/* 0x0b044 = "The DTB structs block contains an invalid node name." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','\x87','\x8f','n','o','d','e',' ','n','a','m','e','.',
/* 0x0b064 = "Guest tried to trigger a CPU hang." */
    'G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','t','r','i','g','g','e','r',' ','a',' ','C','P','U',' ','h','a','n','g','.',
/* 0x0b084 = "Asynchronous I/O is not finished yet." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x0b','\x07','f','i','n','i','s','h','e','d',' ','y','e','t','.',
/* 0x0b0a4 = "Recording limit (time, size, ..." */
    'R','e','c','o','r','d','i','n','g',' ','l','i','m','i','t',' ','(','t','i','m','e',',',' ','s','i','z','e',',',' ','.','.','.',
/* 0x0b0c4 = "Certificate extensions requires certificate version 3 or later." */
    '\xba','e','x','t','e','n','s','i','o','n','s',' ','r','e','q','u','i','r','e','s',' ','\xa0','\xd1','3',' ','\xa9','l','a','t','e','r','.',
/* 0x0b0e4 = "Send pagefault timeout in receive." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0f','r','e','c','e','i','v','e','.',
/* 0x0b104 = "Recompiler: Out of memory for the instruction buffer (regular heap)." */
    '\x13','O','u','t',' ','\x15','\x86','\x10','\x02','\xdc','b','u','f','f','e','r',' ','(','r','e','g','u','l','a','r',' ','h','e','a','p',')','.',
/* 0x0b124 = "VRDP script has completed its task." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','\x5c','c','o','m','p','l','e','t','e','d',' ','i','t','s',' ','t','a','s','k','.',
/* 0x0b144 = "The DBGF has no more free breakpoint owner handles." */
    '\x03','\xb9',' ','\x5c','n','o',' ','m','o','r','e',' ','f','r','e','e',' ','\xc0','o','w','n','e','r',' ','h','a','n','d','l','e','s','.',
/* 0x0b164 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN" */
    '\x01','\x24','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','I','N',
/* 0x0b184 = "Bad UTF-16 surrogate pair sequence." */
    '\x9f','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0b1a4 = "VERR_HTTP_CACERT_CANNOT_AUTHENTICATE" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','C','A','N','N','O','T','_','A','U','T','H','E','N','T','I','C','A','T','E',
/* 0x0b1c4 = "Couldn\'t find the USB Proxy device." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','U','S','B',' ','P','r','o','x','y',' ','d','e','v','i','c','e','.',
/* 0x0b1e4 = "A non-directory operation was attempted on a directory object." */
    'A',' ','n','o','n','-','\x25','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x25','o','b','j','e','c','t','.',
/* 0x0b204 = "VERR_GSTCTL_MAX_CID_SESSIONS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','S','E','S','S','I','O','N','S','_','R','E','A','C','H','E','D',
/* 0x0b224 = "The remote host couldn\'t be resolved." */
    '\x03','r','e','m','o','t','e',' ','h','o','s','t',' ','c','o','u','l','d','n','\'','t',' ','\xa4','r','e','s','o','l','v','e','d','.',
/* 0x0b244 = "Missing length element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','l','e','n','g','t','h',' ','\x5e','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0b264 = "OpenSSL failed to initialize the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','i','n','i','t','i','a','l','i','z','e',' ','\x02','\xd8','\xd5','c','o','n','t','e','x','t','.',
/* 0x0b284 = "VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC" */
    '\x01','\x97','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A','_','F','O','R','_','D','E','S','C','_','C','R','C',
/* 0x0b2a4 = "The network is busy or is out of resources." */
    '\x03','n','e','t','w','o','r','k',' ','\x0b','b','u','s','y',' ','\xa9','\x0b','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s','.',
/* 0x0b2c4 = "VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH" */
    '\x01','\x97','B','O','G','U','S','_','A','L','L','O','C','A','T','I','O','N','_','E','X','T','E','N','T','_','L','E','N','G','T','H',
/* 0x0b2e4 = "Image Verification Failure: No Authenticode Signature." */
    'I','m','a','g','e',' ','\x0d','\x12','\xe0','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e','.',
/* 0x0b304 = "The NotBefore and NotAfter values of an X." */
    '\x03','N','o','t','B','e','f','o','r','e',' ','\x9a','N','o','t','A','f','t','e','r',' ','v','a','l','u','e','s',' ','\x15','\x87','X','.',
/* 0x0b324 = "Import ISO contains a zero sized root directory." */
    '\xc4','\xc2',' ','\x8a','a',' ','z','e','r','o',' ','s','i','z','e','d',' ','r','o','o','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0b344 = "Device creation failed because the USB device name was not found." */
    'D','e','v','i','c','e',' ','c','r','e','a','t','i','o','n',' ','\x99','\x2a','\x02','U','S','B',' ','\xa3','n','a','m','e',' ','\x11','\x07','\x89',
/* 0x0b364 = "A non-file operation was attempted on a file object." */
    'A',' ','n','o','n','-','\x22','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x22','o','b','j','e','c','t','.',
/* 0x0b384 = "FAM failed to add a file to the list to be monitored." */
    'F','A','M',' ','\x99','\x0a','a','d','d',' ','a',' ','\x22','\x0a','\x02','l','i','s','t',' ','\x0a','\xa4','m','o','n','i','t','o','r','e','d','.',
/* 0x0b3a4 = "File set descriptor has a next extent member." */
    'F','i','l','e',' ','s','e','t',' ','\xe3','\x5c','a',' ','n','e','x','t',' ','e','x','t','e','n','t',' ','m','e','m','b','e','r','.',
/* 0x0b3c4 = "Invalid operand size passed to an IEM function." */
    '\x0c','o','p','e','r','a','n','d',' ','\xf8','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0b3e4 = "PDMVMMDevHeapR3ToGCPhys failure." */
    'P','D','M','V','M','M','D','e','v','H','e','a','p','R','3','T','o','G','C','P','h','y','s',' ','f','a','i','l','u','r','e','.',
/* 0x0b404 = "Process Verification Failure: Error query virtual memory mapping name." */
    '\x1e','\x0d','\x12','\xc1','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x86','m','a','p','p','i','n','g',' ','n','a','m','e','.',
/* 0x0b424 = "Internal ISO maker error: Boot catalog file handle problem." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','B','o','o','t',' ','\xe7','\x22','h','a','n','d','l','e',' ','p','r','o','b','l','e','m','.',
/* 0x0b444 = "Reason for leaving RC: A triple-fault condition." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','t','r','i','p','l','e','-','f','a','u','l','t',' ','c','o','n','d','i','t','i','o','n','.',
/* 0x0b464 = "VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','I','N','F','O','_','\x60','I','S','S','U','E','R','_','S','E','R','I','A','L','_','N','O',
/* 0x0b484 = "Not permitted to open the USB device." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x0a','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x0b4a4 = "VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','M','U','L','T','I','P','L','E','_','H','A','S','H','_','T','A','B','S',
/* 0x0b4c4 = "Descriptor tag sector number mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','s','e','c','t','o','r',' ','\xfc','m','i','s','m','a','t','c','h','.',
/* 0x0b4e4 = "Missing offset element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','o','f','f','s','e','t',' ','\x5e','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0b504 = "APIC register/MSR write invalid." */
    'A','P','I','C',' ','r','e','g','i','s','t','e','r','/','M','S','R',' ','w','r','i','t','e',' ','i','n','v','a','l','i','d','.',
/* 0x0b524 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX" */
    '\x01','\x24','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','A','X',
/* 0x0b544 = "Encountered an unsupported GNU Tar extension." */
    '\xa6','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','G','N','U',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0b564 = "Recompiler: Too deeply nested conditionals." */
    '\x13','T','o','o',' ','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','c','o','n','d','i','t','i','o','n','a','l','s','.',
/* 0x0b584 = "Unresolved (unknown) semaphore error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','m','a','p','h','o','r','e',' ','\x85',
/* 0x0b5a4 = "VERR_RT_REQUEST_STATUS_STILL_PENDING" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0b5c4 = "The disk has a cache attached already." */
    '\x03','d','i','s','k',' ','\x5c','a',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x0b5e4 = "A non-directory entry has a name ending with a slash." */
    'A',' ','n','o','n','-','\x25','\xca','\x5c','a',' ','n','a','m','e',' ','e','n','d','i','n','g',' ','\x7f','a',' ','s','l','a','s','h','.',
/* 0x0b604 = "Signed data verification failed due to key usage issues." */
    'S','i','g','n','e','d',' ','\x9d','\xf9','\x99','d','u','e',' ','\x0a','k','e','y',' ','u','s','a','g','e',' ','i','s','s','u','e','s','.',
/* 0x0b624 = "The VTG object for the session or image has already been registered." */
    '\x03','V','T','G',' ','\xa8','\x10','\x02','s','e','s','s','i','o','n',' ','\xa9','\x26','\x5c','\x80','\xcd','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0b644 = "CAcert is missing or has the wrong format." */
    'C','A','c','e','r','t',' ','\x0b','m','i','s','s','i','n','g',' ','\xa9','\x5c','\x02','w','r','o','n','g',' ','f','o','r','m','a','t','.',
/* 0x0b664 = "Termination record CRC mismatch." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x0b684 = "Duplicate symbol within the module." */
    'D','u','p','l','i','c','a','t','e',' ','s','y','m','b','o','l',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',
/* 0x0b6a4 = "A directory operation was attempted on a non-directory object." */
    'A',' ','\x25','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x25','o','b','j','e','c','t','.',
/* 0x0b6c4 = "An invalid I/O port size was specified for a read or write operation." */
    'A','n',' ','\x8f','I','/','O',' ','p','o','r','t',' ','\xf8','\x11','\x18','\x10','a',' ','r','e','a','d',' ','\xa9','w','r','i','t','e',' ','\xea',
/* 0x0b6e4 = "VERR_TRACELOG_READER_LOG_UNSUPPORTED" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','L','O','G','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x0b704 = "validation of the loader section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','\xda','\xdd','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x7b',
/* 0x0b724 = "Return to ring-3 to read the MSR there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','r','e','a','d',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0b744 = "Stack overflow during AVL tree operation." */
    'S','t','a','c','k',' ','o','v','e','r','f','l','o','w',' ','d','u','r','i','n','g',' ','A','V','L',' ','t','r','e','e',' ','\xea',
/* 0x0b764 = "FAM failed to add a directory to the list to be monitored." */
    'F','A','M',' ','\x99','\x0a','a','d','d',' ','a',' ','\x25','\x0a','\x02','l','i','s','t',' ','\x0a','\xa4','m','o','n','i','t','o','r','e','d','.',
/* 0x0b784 = "The machine uuid field wasn\'t null." */
    '\x03','m','a','c','h','i','n','e',' ','u','u','i','d',' ','f','i','e','l','d',' ','w','a','s','n','\'','t',' ','n','u','l','l','.',
/* 0x0b7a4 = "No unwind information for the specified location." */
    '\xe0','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x10','\x02','\x18','l','o','c','a','t','i','o','n','.',
/* 0x0b7c4 = "Failed to open underlying link instance." */
    '\x8b','\x0a','o','p','e','n',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','i','n','s','t','a','n','c','e','.',
/* 0x0b7e4 = "VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\x1f','\x82','R','O','O','T','_','D','I','R','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0b804 = "VERR_GMM_SHARED_MODULE_ADDRESS_CLASH" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','A','D','D','R','E','S','S','_','C','L','A','S','H',
/* 0x0b824 = "Reason for leaving RC: Partly handled GDT write." */
    '\x93','\x10','\x81','R','C',':',' ','P','a','r','t','l','y',' ','h','a','n','d','l','e','d',' ','G','D','T',' ','w','r','i','t','e','.',
/* 0x0b844 = "The requested feature is not supported in raw-mode." */
    '\x03','\xdf','f','e','a','t','u','r','e',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\x0f','r','a','w','-','m','o','d','e','.',
/* 0x0b864 = "Precodition no 3 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','3',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0b884 = "The GIM provider does not support any hypercalls." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\xb2','\x07','\xd0','a','n','y',' ','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0b8a4 = "Process Verification Failure: Error querying thread information." */
    '\x1e','\x0d','\x12','\xc1','q','u','e','r','y','i','n','g',' ','t','h','r','e','a','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0b8c4 = "No 32-bit to 64-bit switcher in place." */
    '\xe0','3','2','-','b','i','t',' ','\x0a','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r',' ','\x0f','p','l','a','c','e','.',
/* 0x0b8e4 = "A file operation was attempted on a non-file object." */
    'A',' ','\x22','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x22','o','b','j','e','c','t','.',
/* 0x0b904 = "Unsupported domain ID in logical volume descriptor." */
    '\x98','d','o','m','a','i','n',' ','I','D',' ','\x0f','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0b924 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','C','H','E','C','K','S','U','M',
/* 0x0b944 = "VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION" */
    '\x01','\xb0','F','I','E','L','D','_','L','O','A','D','_','O','N','L','Y','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0b964 = "GVMM ran into some broken IPRT code." */
    'G','V','M','M',' ','r','a','n',' ','i','n','t','o',' ','s','o','m','e',' ','b','r','o','k','e','n',' ','I','P','R','T',' ','\x84',
/* 0x0b984 = "Couldn\'t map pages during send." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','s','e','n','d','.',
/* 0x0b9a3 = "Internal ISO maker error: Namespace problem #1." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0b9c2 = "VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','G','D','T','_','F','A','U','L','T',
/* 0x0b9e1 = "AMD-V CPU extension not available." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x07','a','v','a','i','l','a','b','l','e','.',
/* 0x0ba00 = "VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','V','S','_','I','P','R','T','_','S','I','G','N','A','T','U','R','E','_','\xfa',
/* 0x0ba1f = "Internal ISO maker error: Namespace problem #5." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','5','.',
/* 0x0ba3e = "The connection to the FAM daemon was lost." */
    '\x03','c','o','n','n','e','c','t','i','o','n',' ','\x0a','\x02','F','A','M',' ','d','a','e','m','o','n',' ','\x11','l','o','s','t','.',
/* 0x0ba5d = "VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE" */
    '\x01','\x95','\xbd','\x06','V','A','L','I','D','_','K','E','R','N','E','L','_','C','O','D','E','_','S','I','G','N','A','T','U','R','E',
/* 0x0ba7c = "VERR_VMM_CONTEXT_HOOK_STILL_ENABLED" */
    '\x01','V','M','M','_','C','O','N','T','E','X','T','_','H','O','O','K','_','S','T','I','L','L','_','E','N','A','B','L','E','D',
/* 0x0ba9b = "Image Verification Failure: Error allocating memory for section headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x10','\xdd','h','e','a','d','e','r','s','.',
/* 0x0baba = "The signal being posted is not correct." */
    '\x03','s','i','g','n','a','l',' ','b','e','i','n','g',' ','p','o','s','t','e','d',' ','\x0b','\x07','c','o','r','r','e','c','t','.',
/* 0x0bad9 = "VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','L','D','T','_','F','A','U','L','T',
/* 0x0baf8 = "Internal ISO maker error: Namespace problem #2." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','2','.',
/* 0x0bb17 = "Internal ISO maker error: Expected path to start with root slash." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','\xb8','\xd2','\x0a','s','t','a','r','t',' ','\x7f','r','o','o','t',' ','s','l','a','s','h','.',
/* 0x0bb36 = "The chunk has already been mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x5c','\x80','\xcd','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0bb55 = "VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS" */
    '\x01','\x24','S','P','C','_','\x06','E','X','A','C','T','L','Y','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x0bb74 = "Unresolved (unknown) disk i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','d','i','s','k',' ','i','/','o',' ','\x85',
/* 0x0bb93 = "Internal ISO maker error: Namespace problem #6." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','6','.',
/* 0x0bbb2 = "The module contains no symbol information." */
    '\x03','m','o','d','u','l','e',' ','\x8a','n','o',' ','s','y','m','b','o','l',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0bbd1 = "VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED" */
    '\x0e','A','U','D','I','O','_','S','T','R','E','A','M','_','A','S','Y','N','C','_','I','N','I','T','_','N','E','E','D','E','D',
/* 0x0bbf0 = "The EMT was not blocked at the time of the call." */
    '\x03','E','M','T',' ','\x11','\x07','b','l','o','c','k','e','d',' ','a','t',' ','\x02','t','i','m','e',' ','\x15','\x02','c','a','l','l','.',
/* 0x0bc0f = "VERR_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\x01','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0bc2e = "VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED" */
    '\x01','S','H','M','E','M','_','M','A','X','I','M','U','M','_','M','A','P','P','I','N','G','S','_','R','E','A','C','H','E','D',
/* 0x0bc4d = "The image is too small or too large for this format." */
    '\x03','\x26','\x0b','\x9e','s','m','a','l','l',' ','\xa9','\x9e','l','a','r','g','e',' ','\x10','t','h','i','s',' ','f','o','r','m','a','t','.',
/* 0x0bc6c = "VERR_GSTCTL_MAX_CID_OBJECTS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0bc8b = "Unknown character class in glob pattern." */
    '\xef','c','h','a','r','a','c','t','e','r',' ','c','l','a','s','s',' ','\x0f','g','l','o','b',' ','p','a','t','t','e','r','n','.',
/* 0x0bcaa = "VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','T','S','S','_','F','A','U','L','T',
/* 0X0bcc9 = "There is no volume behind the current one." */
    'h','e','r','e',' ','\x0b','n','o',' ','\xd3','b','e','h','i','n','d',' ','\x02','c','u','r','r','e','n','t',' ','o','n','e','.',
/* 0x0bce7 = "No clipboard data available for requested format." */
    '\xe0','c','l','i','p','b','o','a','r','d',' ','\x9d','a','v','a','i','l','a','b','l','e',' ','\x10','\xdf','f','o','r','m','a','t','.',
/* 0x0bd06 = "Too many volume descriptors in the import ISO." */
    'T','o','o',' ','\xb5','\xd3','d','e','s','c','r','i','p','t','o','r','s',' ','\x0f','\x02','i','m','p','o','r','t',' ','I','S','O','.',
/* 0x0bd25 = "Unsupported interface for managed object reference." */
    '\x98','i','n','t','e','r','f','a','c','e',' ','\x10','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0bd44 = "VFS chain does not terminate with the desired object type." */
    '\x8d',' ','\xa1','\xb2','\x07','t','e','r','m','i','n','a','t','e',' ','\x7f','\x02','d','e','s','i','r','e','d',' ','\xa8','t','y','p','e','.',
/* 0x0bd63 = "VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL" */
    '\x01','\x9c','F','I','X','U','P','_','S','H','O','R','T','_','J','M','P','_','T','O','_','T','A','I','L','_','L','A','B','E','L',
/* 0x0bd82 = "Concurrent access to the object is not allowed." */
    'C','o','n','c','u','r','r','e','n','t',' ','a','c','c','e','s','s',' ','\x0a','\x02','\xa8','\x0b','\x07','a','l','l','o','w','e','d','.',
/* 0x0bda1 = "Misconfigured driver chain transformation." */
    'M','i','s','c','o','n','f','i','g','u','r','e','d',' ','\xc7','\xa1','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0bdc0 = "VFS chain element takes exactly one argument." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0bddf = "Go ahead with the default Read/Write operation." */
    'G','o',' ','a','h','e','a','d',' ','\x7f','\x02','d','e','f','a','u','l','t',' ','R','e','a','d','/','W','r','i','t','e',' ','\xea',
/* 0x0bdfe = "Process Verification Failure: A DLL was found more than once." */
    '\x1e','\x0d','\x12','A',' ','D','L','L',' ','\x11','f','o','u','n','d',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','c','e','.',
/* 0x0be1d = "Bad VTG header - size value is not a multiple of the structure size." */
    '\x9f','V','T','G',' ','\xb4','-',' ','\xf8','\xf5','\x0b','\x07','a',' ','m','u','l','t','i','p','l','e',' ','\x15','\x02','\xec','s','i','z','e','.',
/* 0x0be3c = "Host operating system related error." */
    'H','o','s','t',' ','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m',' ','r','e','l','a','t','e','d',' ','\x85',
/* 0x0be5b = "The DEK for disk encryption is missing." */
    '\x03','D','E','K',' ','\x10','d','i','s','k',' ','e','n','c','r','y','p','t','i','o','n',' ','\x0b','m','i','s','s','i','n','g','.',
/* 0x0be7a = "Invalid instruction length passed to an IEM function." */
    '\x0c','\xdc','l','e','n','g','t','h',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0be99 = "Bad or missing XAR checksum element." */
    '\x9f','\xa9','m','i','s','s','i','n','g',' ','X','A','R',' ','c','h','e','c','k','s','u','m',' ','e','l','e','m','e','n','t','.',
/* 0x0beb8 = "Deferred loading of information failed." */
    'D','e','f','e','r','r','e','d',' ','l','o','a','d','i','n','g',' ','\x15','i','n','f','o','r','m','a','t','i','o','n',' ','\x7b',
/* 0x0bed7 = "Unabled to locate an OpenGL symbol." */
    'U','n','a','b','l','e','d',' ','\x0a','l','o','c','a','t','e',' ','\x87','O','p','e','n','G','L',' ','s','y','m','b','o','l','.',
/* 0x0bef6 = "VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\x1f','\x82','D','I','R','_','R','E','C','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0bf15 = "VWRN_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\xe6','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0bf34 = "VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL" */
    '\x01','\x24','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','P','A','R','A','M','S','_','\x06','I','M','P','L',
/* 0x0bf53 = "No more search handles available." */
    '\xe0','m','o','r','e',' ','s','e','a','r','c','h',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x0bf72 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x05','B','O','O','T','_','I','N','D',
/* 0x0bf91 = "NEM failed to create a native VM instance." */
    '\xee',' ','\x99','\x0a','c','r','e','a','t','e',' ','a',' ','n','a','t','i','v','e',' ','\xc6',' ','i','n','s','t','a','n','c','e','.',
/* 0x0bfb0 = "Import ISO contains a root directory without the directory flag set." */
    '\xc4','\xc2',' ','\x8a','a',' ','r','o','o','t',' ','\x25','w','i','t','h','o','u','t',' ','\x02','\x25','f','l','a','g',' ','s','e','t','.',
/* 0x0bfcf = "Process Verification Failure: Error query virtual memory information." */
    '\x1e','\x0d','\x12','\xc1','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x86','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0bfee = "Internal ISO maker error: Namespace problem #4." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','4','.',
/* 0x0c00d = "Shared Clipboard transfer ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r',' ','I','D',' ','\x07','\x89',
/* 0x0c02c = "VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','N','E','S','T','E','D','_','P','A','G','I','N','G',
/* 0x0c04b = "Missing encoding element for XAR data stream." */
    'M','i','s','s','i','n','g',' ','e','n','c','o','d','i','n','g',' ','\x5e','\x10','X','A','R',' ','\x9d','s','t','r','e','a','m','.',
/* 0x0c06a = "Tried to halt a VM or CPU that was already halted." */
    'T','r','i','e','d',' ','\x0a','h','a','l','t',' ','a',' ','\xc6',' ','\xa9','C','P','U',' ','\xad','\x11','\x80','h','a','l','t','e','d','.',
/* 0x0c089 = "Can\'t unlock - region was not locked." */
    'C','a','n','\'','t',' ','u','n','l','o','c','k',' ','-',' ','r','e','g','i','o','n',' ','\x11','\x07','l','o','c','k','e','d','.',
/* 0x0c0a8 = "Recompiler: Translation block allocation failed." */
    '\x13','T','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k',' ','a','l','l','o','c','a','t','i','o','n',' ','\x7b',
/* 0x0c0c7 = "Internal ISO maker error: Namespace problem #3." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','3','.',
/* 0x0c0e6 = "VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS" */
    '\x01','\x24','S','P','C','_','I','N','D','_','D','A','T','A','_','\xbf','A','L','G','O','_','\x06','I','N','_','\xbf','A','L','G','O','S',
/* 0x0c105 = "VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','I','D','T','_','F','A','U','L','T',
/* 0x0c124 = "VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY" */
    '\x01','\x1f','\x82','S','U','P','P','L','E','M','E','N','T','A','R','Y','_','B','E','F','O','R','E','_','P','R','I','M','A','R','Y',
/* 0x0c143 = "Trailing element separator not permitted." */
    'T','r','a','i','l','i','n','g',' ','\x5e','s','e','p','a','r','a','t','o','r',' ','\x07','p','e','r','m','i','t','t','e','d','.',
/* 0x0c162 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','R','E','S','E','R','V','E','D','_','F','L','A','G',
/* 0x0c181 = "VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC" */
    '\x01','\x1f','\x82','M','I','S','M','A','T','C','H','I','N','G','_','M','U','L','T','I','_','E','X','T','E','N','T','_','R','E','C',
/* 0x0c1a0 = "Pending interrupt is masked by TPR." */
    'P','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t',' ','\x0b','m','a','s','k','e','d',' ','\xdb','T','P','R','.',
/* 0x0c1bf = "Not a uniform standard tape v0." */
    'N','o','t',' ','a',' ','u','n','i','f','o','r','m',' ','s','t','a','n','d','a','r','d',' ','t','a','p','e',' ','v','0','.',
/* 0x0c1de = "VERR_VM_REQUEST_STATUS_STILL_PENDING" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0c1fd = "NEM can only operate from ring-3." */
    '\xee',' ','c','a','n',' ','o','n','l','y',' ','o','p','e','r','a','t','e',' ','f','r','o','m',' ','r','i','n','g','-','3','.',
/* 0x0c21c = "Unresolved (unknown) pipe i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','p','i','p','e',' ','i','/','o',' ','\x85',
/* 0x0c23b = "Detected unsafe code for patching." */
    'D','e','t','e','c','t','e','d',' ','u','n','s','a','f','e',' ','c','o','d','e',' ','\x10','p','a','t','c','h','i','n','g','.',
/* 0x0c25a = "VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY" */
    '\x01','\x8c','G','C','P','H','Y','S','_','R','A','N','G','E','_','C','R','O','S','S','E','S','_','B','O','U','N','D','A','R','Y',
/* 0x0c279 = "Process Verification Failure: An image mapping failed to report a name." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','m','a','p','p','i','n','g',' ','\x99','\x0a','r','e','p','o','r','t',' ','a',' ','n','a','m','e','.',
/* 0x0c298 = "Internal error in read-write critical section." */
    '\x08','\x09','\x0f','r','e','a','d','-','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0c2b7 = "The DTB being parsed has a version set which is not supported." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','a',' ','\xd1','s','e','t',' ','\xed','\x0b','\x07','\xa5',
/* 0x0c2d5 = "The PE loader encountered a malformed certificate." */
    '\x03','P','E',' ','\xda','\xaf','a',' ','m','a','l','f','o','r','m','e','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c2f3 = "Found an illegal symbolic link (hardening)." */
    'F','o','u','n','d',' ','\x87','i','l','l','e','g','a','l',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\xae',
/* 0x0c311 = "VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE" */
    '\x01','W','E','B','_','\x05','M','A','N','A','G','E','D','_','O','B','J','E','C','T','_','R','E','F','E','R','E','N','C','E',
/* 0x0c32f = "Unfinished debug info reader code." */
    'U','n','f','i','n','i','s','h','e','d',' ','d','e','b','u','g',' ','i','n','f','o',' ','r','e','a','d','e','r',' ','\x84',
/* 0x0c34d = "VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET" */
    '\x01','\x1f','\x82','M','O','R','E','_','T','H','A','N','_','O','N','E','_','V','O','L','U','M','E','_','I','N','_','S','E','T',
/* 0X0c36b = "Too many loops looking for a page to reuse." */
    'o','o',' ','\xb5','l','o','o','p','s',' ','l','o','o','k','i','n','g',' ','\x10','a',' ','\xbe','\x0a','r','e','u','s','e','.',
/* 0x0c388 = "Leading element separator not permitted." */
    'L','e','a','d','i','n','g',' ','\x5e','s','e','p','a','r','a','t','o','r',' ','\x07','p','e','r','m','i','t','t','e','d','.',
/* 0x0c3a6 = "Missing UTF-16 surrogate pair." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r','.',
/* 0x0c3c4 = "internal fixup chain isn\'t implemented yet." */
    '\x16','f','i','x','u','p',' ','\xa1','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0c3e2 = "VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE" */
    '\x01','J','S','O','N','_','\x1d','S','U','R','R','O','G','A','T','E','_','P','A','I','R','_','S','E','Q','U','E','N','C','E',
/* 0x0c400 = "Too many references: can\'t splice." */
    'T','o','o',' ','\xb5','r','e','f','e','r','e','n','c','e','s',':',' ','c','a','n','\'','t',' ','s','p','l','i','c','e','.',
/* 0x0c41e = "VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING" */
    '\x01','\xa2','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','C','O','N','S','T','R','U','C','T','E','D','_','\xd6',
/* 0x0c43c = "Expected PE image data inside indirect data object." */
    '\xb8','P','E',' ','\x26','\x9d','i','n','s','i','d','e',' ','i','n','d','i','r','e','c','t',' ','\x9d','o','b','j','e','c','t','.',
/* 0x0c45a = "Internal processing error #3 in the PGM physial page mapping code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xbe','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c478 = "Internal processing error #2 in the PGM physial page mapping code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xbe','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c496 = "VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED" */
    '\x0e','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x0c4b4 = "Reason for leaving RC: Fatal trap in hypervisor." */
    '\x93','\x10','\x81','R','C',':',' ','F','a','t','a','l',' ','t','r','a','p',' ','\x0f','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0c4d2 = "The module contains no line number information." */
    '\x03','m','o','d','u','l','e',' ','\x8a','n','o',' ','l','i','n','e',' ','\xfc','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0c4f0 = "A digest doesn't match the corresponding file." */
    'A',' ','\xd8','\xc9','m','a','t','c','h',' ','\x02','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e','.',
/* 0x0c50e = "Bad VTG argument list descriptor." */
    '\x9f','V','T','G',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c52c = "Import ISO contains a bad primary volume descriptor." */
    '\xc4','\xc2',' ','\x8a','a',' ','b','a','d',' ','p','r','i','m','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c54a = "Invalid initialization vector length." */
    '\x0c','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','l','e','n','g','t','h','.',
/* 0x0c568 = "VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT" */
    '\x01','\x1f','\x82','N','O','N','_','C','O','N','T','I','G','U','O','U','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0c586 = "VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','R','S','A','_','P','A','D','_','\x1c',
/* 0x0c5a4 = "A path is relative, expected an absolute path." */
    'A',' ','\xd2','\x0b','r','e','l','a','t','i','v','e',',',' ','\xcb','\x87','a','b','s','o','l','u','t','e',' ','p','a','t','h','.',
/* 0x0c5c2 = "Process Verification Failure: The image mapping is too large (>= 2GB)." */
    '\x1e','\x0d','\x12','\x03','\x26','m','a','p','p','i','n','g',' ','\x0b','\x9e','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0c5e0 = "VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','D','U','P','L','I','C','A','T','E','_','E','X','T','E','N','S','I','O','N',
/* 0x0c5fe = "VERR_HARDAVL_POINTER_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','P','O','I','N','T','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0c61c = "VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING" */
    '\x01','\x95','\xbd','\x40','_','M','O','R','E','_','T','H','A','N','_','O','N','E','_','E','X','E','_','M','A','P','P','I','N','G',
/* 0x0c63a = "The timer failed to reach a stable state." */
    '\x03','t','i','m','e','r',' ','\x99','\x0a','r','e','a','c','h',' ','a',' ','s','t','a','b','l','e',' ','s','t','a','t','e','.',
/* 0x0c658 = "Image Verification Failure: Error determining the file length." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','\x22','l','e','n','g','t','h','.',
/* 0x0c676 = "Termination record integrity error." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x0c694 = "Reason for leaving RC: Caller the tracer in ring-0." */
    '\x93','\x10','\x81','R','C',':',' ','C','a','l','l','e','r',' ','\x02','t','r','a','c','e','r',' ','\x0f','r','i','n','g','-','0','.',
/* 0x0c6b2 = "VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x17',
/* 0x0c6d0 = "The size of the shared module was out of range." */
    '\x03','\xf8','\x15','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0c6ee = "Reason for leaving RZ: Pending I/O port write." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x0c70c = "Attempt to resume a running TSC." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','s','u','m','e',' ','a',' ','r','u','n','n','i','n','g',' ','T','S','C','.',
/* 0x0c72a = "OpenSSL failed to decode the private key." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','d','e','c','o','d','e',' ','\x02','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x0c748 = "The tracepoint provider object is too large." */
    '\x03','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xa8','\x0b','\x9e','l','a','r','g','e','.',
/* 0x0c766 = "VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb3','_','F','O','R','_','I','N','T','E','G','E','R',
/* 0x0c784 = "The DBGF couldn\'t find the specified breakpoint." */
    '\x03','\xb9',' ','c','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','\x18','b','r','e','a','k','p','o','i','n','t','.',
/* 0x0c7a2 = "Internal processing error #1 in the PGM physial page mapping code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xbe','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c7c0 = "VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','O','G','_','I','N','I','T','_','\x17',
/* 0x0c7de = "VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x17',
/* 0x0c7fc = "One of the custom modes was incorrect." */
    'O','n','e',' ','\x15','\x02','c','u','s','t','o','m',' ','m','o','d','e','s',' ','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0c81a = "XML error while parsing the table of content." */
    'X','M','L',' ','\x09','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x0c838 = "VERR_AUDIO_STREAM_INIT_IN_PROGRESS" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','I','N','I','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0c856 = "Internal processing error #4 in the PGM physial page mapping code." */
    '\x08','\x04','\x09','#','4',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xbe','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c874 = "VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','C','H','A','R','S','_','\x06','V','A','L','I','D','_','U','T','F','8',
/* 0x0c892 = "VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','R','I','G','H','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0c8b0 = "Image Verification Failure: More than one certificate table entry." */
    'I','m','a','g','e',' ','\x0d','\x12','M','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','\xa0','\xb1','e','n','t','r','y','.',
/* 0x0c8ce = "VERR_TRACELOG_READER_MALFORMED_LOG" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','M','A','L','F','O','R','M','E','D','_','L','O','G',
/* 0x0c8ec = "VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','N','F','O','_','\x06','\x40',
/* 0x0c90a = "PKIX cipher algorithm is not known to OpenSSL." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd5','\x0b','\x07','k','n','o','w','n',' ','\x0a','O','p','e','n','S','S','L','.',
/* 0x0c928 = "VT-x VMCS field cache invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','f','i','e','l','d',' ','c','a','c','h','e',' ','i','n','v','a','l','i','d','.',
/* 0x0c946 = "Internal processing error while merging status codes." */
    '\x08','\x04','\x09','w','h','i','l','e',' ','m','e','r','g','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x0c964 = "Import ISO contains a directory with an extent that is out of bounds." */
    '\xc4','\xc2',' ','\x8a','a',' ','\x25','\x7f','\x87','e','x','t','e','n','t',' ','\xad','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0c982 = "VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED" */
    '\x01','\x24','P','A','S','S','W','O','R','D','_','2','_','K','E','Y','_','D','E','R','I','V','I','A','T','I','O','N','_','\x17',
/* 0x0c9a0 = "VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0c9be = "VERR_PGM_INTERMEDIATE_PAGING_CONFLICT" */
    '\x01','\x8c','I','N','T','E','R','M','E','D','I','A','T','E','_','P','A','G','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x0c9dc = "Import ISO contains a root directory with multiple extents." */
    '\xc4','\xc2',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x7f','m','u','l','t','i','p','l','e',' ','e','x','t','e','n','t','s','.',
/* 0x0c9fa = "VT-x features disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','d','i','s','a','b','l','e','d',' ','\xdb','\x02','B','I','O','S','.',
/* 0x0ca18 = "Recompiler: Failed to allocate more memory for debug info." */
    '\x13','\x8b','\x0a','a','l','l','o','c','a','t','e',' ','m','o','r','e',' ','\x86','\x10','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x0ca36 = "Unresolved (unknown) network error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','n','e','t','w','o','r','k',' ','\x85',
/* 0x0ca54 = "Reason for leaving RC: attempt to patch MMIO write." */
    '\x93','\x10','\x81','R','C',':',' ','a','t','t','e','m','p','t',' ','\x0a','p','a','t','c','h',' ','\xd4',' ','w','r','i','t','e','.',
/* 0x0ca72 = "VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE" */
    '\x01','\x9c','E','M','I','T','_','F','I','X','E','D','_','J','U','M','P','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0ca90 = "The specified path does not point at a symbolic link." */
    '\x03','\x18','\xd2','\xb2','\x07','p','o','i','n','t',' ','a','t',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0caae = "VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','R','A','M','_','P','R','E','A','L','L','O','C',
/* 0x0cacc = "VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','C','O','M','_','\x1c',
/* 0x0caea = "The path is not the same object as the native handle (hardening)." */
    '\x03','\xd2','\x0b','\x07','\x02','s','a','m','e',' ','\xa8','a','s',' ','\x02','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\xae',
/* 0x0cb08 = "VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER" */
    '\x01','\x95','\xbd','\x06','O','W','N','E','D','_','B','Y','_','T','R','U','S','T','E','D','_','I','N','S','T','A','L','L','E','R',
/* 0x0cb26 = "OpenSSL failed to decode the public key." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','d','e','c','o','d','e',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0cb43 = "VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','R','I','V','A','T','E','_','K','E','Y','_','\x17',
/* 0x0cb60 = "VERR_X509_GETTING_EXTENSION_FROM_CERT" */
    '\x01','\xb7','G','E','T','T','I','N','G','_','E','X','T','E','N','S','I','O','N','_','F','R','O','M','_','C','E','R','T',
/* 0x0cb7d = "An invalid LUN specification was given." */
    'A','n',' ','\x8f','L','U','N',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x11','g','i','v','e','n','.',
/* 0x0cb9a = "The installed support driver doesn't match the version of the user." */
    '\x03','i','n','s','t','a','l','l','e','d',' ','\xd0','\xc7','\xc9','m','a','t','c','h',' ','\x02','\xd1','\x15','\x02','u','s','e','r','.',
/* 0x0cbb7 = "VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED" */
    '\x01','\x95','\xbd','S','I','G','N','A','T','U','R','E','_','C','H','E','C','K','S','_','\x06','E','N','F','O','R','C','E','D',
/* 0x0cbd4 = "VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','F','I','N','A','L','_','\x17',
/* 0x0cbf1 = "Failed to derivate key from password." */
    '\x8b','\x0a','d','e','r','i','v','a','t','e',' ','k','e','y',' ','f','r','o','m',' ','p','a','s','s','w','o','r','d','.',
/* 0x0cc0e = "VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS" */
    '\x01','\x1f','\x82','M','U','L','T','I','P','L','E','_','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x0cc2b = "VERR_URI_MISSING_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\xc5','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0cc48 = "The DTB being parsed is malformed." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x0cc65 = "VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','N','A','M','E','_','O','F','F','_','\x1b','L','A','R','G','E',
/* 0x0cc82 = "Restart the current instruction." */
    'R','e','s','t','a','r','t',' ','\x02','c','u','r','r','e','n','t',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0cc9f = "Trying to use too new winsock API." */
    'T','r','y','i','n','g',' ','\x0a','u','s','e',' ','\x9e','n','e','w',' ','w','i','n','s','o','c','k',' ','A','P','I','.',
/* 0x0ccbc = "Encountered an bad (/unknown) record type." */
    '\xa6','\x87','b','a','d',' ','(','/','u','n','k','n','o','w','n',')',' ','r','e','c','o','r','d',' ','t','y','p','e','.',
/* 0x0ccd9 = "The specified data unit wasn\'t owned by caller." */
    '\x03','\x18','\x9d','u','n','i','t',' ','w','a','s','n','\'','t',' ','o','w','n','e','d',' ','\xdb','c','a','l','l','e','r','.',
/* 0x0ccf6 = "VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0cd13 = "Error opening the ApiPort LPC object." */
    '\xc1','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0cd30 = "Destination address required." */
    'D','e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','.',
/* 0x0cd4d = "Hit the global allocation limit." */
    'H','i','t',' ','\x02','g','l','o','b','a','l',' ','a','l','l','o','c','a','t','i','o','n',' ','l','i','m','i','t','.',
/* 0x0cd6a = "Wrong locking order detected." */
    'W','r','o','n','g',' ','l','o','c','k','i','n','g',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0cd87 = "The specified address range wraps around." */
    '\x03','\x18','a','d','d','r','e','s','s',' ','r','a','n','g','e',' ','w','r','a','p','s',' ','a','r','o','u','n','d','.',
/* 0x0cda4 = "VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x1d','R','E','G','I','O','N','S','_','\xfa',
/* 0x0cdc1 = "Certificate serial number length is out of bounds." */
    '\xba','s','e','r','i','a','l',' ','\xfc','l','e','n','g','t','h',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0cdde = "VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED" */
    '\x01','\x7d','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x9b','S','U','S','P','E','N','D','E','D',
/* 0x0cdfb = "VERR_X509_GETTING_DATA_FROM_EXTENSION" */
    '\x01','\xb7','G','E','T','T','I','N','G','_','D','A','T','A','_','F','R','O','M','_','E','X','T','E','N','S','I','O','N',
/* 0x0ce18 = "Reason for leaving RC: attempt to patch MMIO read." */
    '\x93','\x10','\x81','R','C',':',' ','a','t','t','e','m','p','t',' ','\x0a','p','a','t','c','h',' ','\xd4',' ','r','e','a','d','.',
/* 0x0ce35 = "Attempted to use stub switcher." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','u','s','e',' ','s','t','u','b',' ','s','w','i','t','c','h','e','r','.',
/* 0x0ce52 = "Go back into wait for SIPI mode." */
    'G','o',' ','b','a','c','k',' ','i','n','t','o',' ','w','a','i','t',' ','\x10','S','I','P','I',' ','m','o','d','e','.',
/* 0x0ce6f = "VERR_VSCSI_LUN_ATTACHED_TO_DEVICE" */
    '\x01','V','S','C','S','I','_','L','U','N','_','A','T','T','A','C','H','E','D','_','T','O','_','D','E','V','I','C','E',
/* 0x0ce8c = "Start instruction stepping (debug only)." */
    'S','t','a','r','t',' ','\xdc','s','t','e','p','p','i','n','g',' ','(','d','e','b','u','g',' ','o','n','l','y',')','.',
/* 0x0cea9 = "Recompiler: No host register available for variables." */
    '\x13','\xe0','h','o','s','t',' ','\xeb','a','v','a','i','l','a','b','l','e',' ','\x10','v','a','r','i','a','b','l','e','s','.',
/* 0x0cec6 = "VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','F','I','N','A','L','_','\x17',
/* 0x0cee3 = "VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED" */
    '\x01','\x7d','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x06','S','U','S','P','E','N','D','E','D',
/* 0x0cf00 = "Encountered an unexpected page type in the saved state." */
    '\xa6','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xbe','\xf3','\x0f','\x02','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0cf1d = "Output can be enabled for the client." */
    'O','u','t','p','u','t',' ','c','a','n',' ','\xa4','e','n','a','b','l','e','d',' ','\x10','\x02','c','l','i','e','n','t','.',
/* 0x0cf3a = "No guest mappings when SMP is enabled." */
    '\xe0','\xbb','m','a','p','p','i','n','g','s',' ','w','h','e','n',' ','S','M','P',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x0cf57 = "VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE" */
    '\x01','\x7d','O','N','E','_','P','C','I','_','F','U','N','C','T','I','O','N','_','P','E','R','_','D','E','V','I','C','E',
/* 0x0cf74 = "VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH" */
    '\x01','\x24','S','P','C','_','S','I','G','N','E','D','_','I','N','D','_','D','A','T','A','_','\xbf','A','L','G','O','_','\x19',
/* 0x0cf91 = "Send pagefault timeout in send." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0f','s','e','n','d','.',
/* 0x0cfae = "Object being in use prohibits operation." */
    'O','b','j','e','c','t',' ','b','e','i','n','g',' ','\x0f','u','s','e',' ','p','r','o','h','i','b','i','t','s',' ','\xea',
/* 0x0cfcb = "Syntax error - out of regular heap memory." */
    '\xfb','\x09','-',' ','o','u','t',' ','\x15','r','e','g','u','l','a','r',' ','h','e','a','p',' ','m','e','m','o','r','y','.',
/* 0x0cfe8 = "The display connector is resizing." */
    '\x03','d','i','s','p','l','a','y',' ','c','o','n','n','e','c','t','o','r',' ','\x0b','r','e','s','i','z','i','n','g','.',
/* 0x0d005 = "Failed to enable and lock VT-x features." */
    '\x8b','\x0a','e','n','a','b','l','e',' ','\x9a','l','o','c','k',' ','V','T','-','x',' ','f','e','a','t','u','r','e','s','.',
/* 0x0d022 = "VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','L','E','F','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0d03f = "The spill file grew larger than 4GB." */
    '\x03','s','p','i','l','l',' ','\x22','g','r','e','w',' ','l','a','r','g','e','r',' ','t','h','a','n',' ','4','G','B','.',
/* 0x0d05c = "Patch TPR access instruction." */
    'P','a','t','c','h',' ','T','P','R',' ','a','c','c','e','s','s',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0d079 = "VERR_AUDIO_STREAM_PENDING_DISABLE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','P','E','N','D','I','N','G','_','D','I','S','A','B','L','E',
/* 0x0d096 = "VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','O','P','E','N','_','\x17',
/* 0x0d0b3 = "Process Verification Failure: The memory region is too large (>= 2GB)." */
    '\x1e','\x0d','\x12','\x03','\x86','r','e','g','i','o','n',' ','\x0b','\x9e','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0d0d0 = "VERR_NET_CONNECTION_RESET_BY_PEER" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','S','E','T','_','B','Y','_','P','E','E','R',
/* 0x0d0ed = "VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY" */
    '\x01','\xb7','E','X','T','R','A','C','T','_','R','S','A','_','F','R','O','M','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x0d10a = "The specified shared page was not actually private." */
    '\x03','\x18','s','h','a','r','e','d',' ','\xbe','\x11','\x07','a','c','t','u','a','l','l','y',' ','p','r','i','v','a','t','e','.',
/* 0x0d127 = "Expected PKCS #7 object to not contain any CRLs." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','\x07','c','o','n','t','a','i','n',' ','a','n','y',' ','C','R','L','s','.',
/* 0x0d144 = "Found bogus values in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','v','a','l','u','e','s',' ','\x0f','\x02','\x22','s','y','s','t','e','m','.',
/* 0x0d161 = "The specified CPU cannot be found in the CPU database." */
    '\x03','\x18','C','P','U',' ','\xcf','\xa4','f','o','u','n','d',' ','\x0f','\x02','C','P','U',' ','d','a','t','a','b','a','s','e','.',
/* 0x0d17e = "VERR_SHCLPB_MAX_TRANSFERS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','T','R','A','N','S','F','E','R','S','_','R','E','A','C','H','E','D',
/* 0x0d19b = "VFS chain element takes a directory (dir) object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x25','(','d','i','r',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x0d1b8 = "Malformed unwind information." */
    'M','a','l','f','o','r','m','e','d',' ','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0d1d5 = "The GIP update interval is too large." */
    '\x03','G','I','P',' ','u','p','d','a','t','e',' ','i','n','t','e','r','v','a','l',' ','\x0b','\x9e','l','a','r','g','e','.',
/* 0x0d1f2 = "VERR_GSTCTL_MAX_CID_COUNT_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','C','O','U','N','T','_','R','E','A','C','H','E','D',
/* 0x0d20f = "Internal error - this should never happen." */
    '\x08','\x09','-',' ','t','h','i','s',' ','s','h','o','u','l','d',' ','n','e','v','e','r',' ','h','a','p','p','e','n','.',
/* 0x0d22c = "Bad DWARF extended line number opcode." */
    '\x9f','D','W','A','R','F',' ','e','x','t','e','n','d','e','d',' ','l','i','n','e',' ','\xfc','o','p','c','o','d','e','.',
/* 0x0d249 = "Invalid partition index in a location." */
    '\x0c','p','a','r','t','i','t','i','o','n',' ','i','n','d','e','x',' ','\x0f','a',' ','l','o','c','a','t','i','o','n','.',
/* 0x0d266 = "Unresolved (unknown) search error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','a','r','c','h',' ','\x85',
/* 0x0d283 = "VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED" */
    '\x01','\x9c','C','O','N','D','_','E','N','D','I','F','_','R','E','C','O','N','C','I','L','I','A','T','I','O','N','_','\x17',
/* 0x0d2a0 = "VERR_TRACELOG_READER_ITERATOR_END" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x0d2bd = "The OpenSSL version is too old for the attempted operation." */
    '\x03','O','p','e','n','S','S','L',' ','\xd1','\x0b','\x9e','o','l','d',' ','\x10','\x02','a','t','t','e','m','p','t','e','d',' ','\xea',
/* 0x0d2da = "Found bogus offset in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','o','f','f','s','e','t',' ','\x0f','\x02','\x22','s','y','s','t','e','m','.',
/* 0x0d2f7 = "The extracted data has exceeded the expected size." */
    '\x03','e','x','t','r','a','c','t','e','d',' ','\x9d','\x5c','e','x','c','e','e','d','e','d',' ','\x02','\xcb','s','i','z','e','.',
/* 0x0d314 = "The recipient process has refused the signal." */
    '\x03','r','e','c','i','p','i','e','n','t',' ','\x92','\x5c','r','e','f','u','s','e','d',' ','\x02','s','i','g','n','a','l','.',
/* 0x0d331 = "VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER" */
    '\x01','X','A','R','_','\x06','S','T','R','E','A','M','B','L','E','_','E','L','E','M','E','N','T','_','O','R','D','E','R',
/* 0x0d34e = "VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','\x60','R','A','M','_','R','A','N','G','E',
/* 0x0d36b = "The internal logger revision did not match." */
    '\x03','\x16','l','o','g','g','e','r',' ','r','e','v','i','s','i','o','n',' ','d','i','d',' ','\x07','m','a','t','c','h','.',
/* 0x0d388 = "VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb3','_','F','O','R','_','D','O','U','B','L','E',
/* 0x0d3a5 = "VERR_GVMM_GVMCPU_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','G','V','M','C','P','U','_','S','T','R','U','C','T','_','\x06','\xce','A','L','I','G','N','E','D',
/* 0x0d3c2 = "Too many instances of a usb device." */
    'T','o','o',' ','\xb5','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','u','s','b',' ','d','e','v','i','c','e','.',
/* 0x0d3df = "VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS" */
    '\x01','L','D','R','L','X','_','\x82','O','R','D','I','N','A','L','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0d3fc = "VERR_XML_TOC_ELEMENT_HAS_SIBLINGS" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','H','A','S','_','S','I','B','L','I','N','G','S',
/* 0x0d419 = "Wrong release order detected." */
    'W','r','o','n','g',' ','r','e','l','e','a','s','e',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0d436 = "Unexpected NULL pointer to right subtree." */
    '\x94','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x0a','r','i','g','h','t',' ','s','u','b','t','r','e','e','.',
/* 0x0d453 = "Encountered an unexpected page state in the saved state." */
    '\xa6','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xbe','\xcc','\x0f','\x02','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0d470 = "VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','D','E','F','L','A','T','E','_','\x1b','M','U','C','H',
/* 0x0d48d = "No debug connection configured." */
    '\xe0','d','e','b','u','g',' ','c','o','n','n','e','c','t','i','o','n',' ','c','o','n','f','i','g','u','r','e','d','.',
/* 0x0d4aa = "VERR_FILE_AIO_INSUFFICIENT_RESSOURCES" */
    '\x01','\xaa','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','R','E','S','S','O','U','R','C','E','S',
/* 0x0d4c7 = "The VM request was killed at VM termination." */
    '\x03','\xc6',' ','\xab','\x11','k','i','l','l','e','d',' ','a','t',' ','\xc6',' ','t','e','r','m','i','n','a','t','i','o','n','.',
/* 0x0d4e4 = "Unsupported PKCS #7 signer info version." */
    '\x98','P','K','C','S',' ','#','7',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','v','e','r','s','i','o','n','.',
/* 0x0d501 = "No PCI Bus is available to register the device with." */
    '\xe0','P','C','I',' ','B','u','s',' ','\x0b','a','v','a','i','l','a','b','l','e',' ','\x0a','\xeb','\x02','\xa3','w','i','t','h','.',
/* 0x0d51e = "Import module ordinal is out of bounds." */
    '\xc4','m','o','d','u','l','e',' ','o','r','d','i','n','a','l',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d53b = "VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY" */
    '\x01','\x1f','B','O','O','T','_','C','A','T','_','\x60','V','A','L','I','D','A','T','I','O','N','_','E','N','T','R','Y',
/* 0x0d557 = "VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED" */
    '\x01','G','V','M','M','_','\x06','A','L','L','_','E','M','T','S','_','D','E','R','E','G','I','S','T','E','R','E','D',
/* 0x0d573 = "VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS" */
    '\x01','\x1f','\x82','M','U','L','T','I','P','L','E','_','J','O','L','I','E','T','_','V','O','L','_','D','E','S','C','S',
/* 0X0d58f = "Severely compromised digest." */
    'e','v','e','r','e','l','y',' ','c','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x0d5aa = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x05','F','L','A','G','S',
/* 0x0d5c6 = "Error getting a data from the extension." */
    '\xc1','g','e','t','t','i','n','g',' ','a',' ','\x9d','f','r','o','m',' ','\x02','e','x','t','e','n','s','i','o','n','.',
/* 0x0d5e2 = "Unexpected guest mapping conflict detected." */
    '\x94','\xbb','m','a','p','p','i','n','g',' ','c','o','n','f','l','i','c','t',' ','d','e','t','e','c','t','e','d','.',
/* 0x0d5fe = "VERR_CODE_POINT_ENDIAN_INDICATOR" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','E','N','D','I','A','N','_','I','N','D','I','C','A','T','O','R',
/* 0x0d61a = "Process Verification Failure: Bad new-header offset in the MZ header." */
    '\x1e','\x0d','\x12','\x9f','n','e','w','-','\xb4','o','f','f','s','e','t',' ','\x0f','\x02','M','Z',' ','h','e','a','d','e','r','.',
/* 0x0d636 = "A device encountered an unknown configuration value." */
    'A',' ','\xa3','\xaf','\x87','u','n','k','n','o','w','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xe8',
/* 0x0d652 = "Invalid entry in the driver registration structure." */
    '\x0c','\xca','\x0f','\x02','\xc7','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d66e = "VINF_IOMMU_ADDR_TRANSLATION_DISABLED" */
    '\x0e','\xfe','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','D','I','S','A','B','L','E','D',
/* 0x0d68a = "Unexpected NULL pointer to left subtree." */
    '\x94','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x0a','l','e','f','t',' ','s','u','b','t','r','e','e','.',
/* 0x0d6a6 = "VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','U','R','L','_','U','N','E','X','P','E','C','T','E','D',
/* 0x0d6c2 = "VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE" */
    '\x01','V','G','A','_','\x88','P','C','I','_','R','E','G','I','O','N','_','L','O','A','D','_','C','H','A','N','G','E',
/* 0x0d6de = "No validation entry in the boot catalog." */
    '\xe0','v','a','l','i','d','a','t','i','o','n',' ','\xca','\x0f','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x0d6fa = "The critical section being deleted was not found." */
    '\x03','c','r','i','t','i','c','a','l',' ','\xdd','b','e','i','n','g',' ','d','e','l','e','t','e','d',' ','\x11','\x07','\x89',
/* 0x0d716 = "Attempt to pause a paused TSC." */
    'A','t','t','e','m','p','t',' ','\x0a','p','a','u','s','e',' ','a',' ','p','a','u','s','e','d',' ','T','S','C','.',
/* 0x0d732 = "VERR_IPC_RECEIVE_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x0d74e = "Failed to allocate temporary memory." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','t','e','m','p','o','r','a','r','y',' ','m','e','m','o','r','y','.',
/* 0x0d76a = "Get register caller must flush the TLB." */
    'G','e','t',' ','\xeb','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B','.',
/* 0x0d786 = "Unable to establish trusted of VM process (5)." */
    '\xe1','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xc6',' ','\x92','(','5',')','.',
/* 0x0d7a2 = "VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','D','_','U','T','F','8','_','L','E','A','D','_','B','Y','T','E',
/* 0x0d7be = "Recompiler: Variable management internal processing error #12." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','2','.',
/* 0x0d7da = "The specified disk or diskette cannot be accessed." */
    '\x03','\x18','d','i','s','k',' ','\xa9','d','i','s','k','e','t','t','e',' ','\xcf','\xa4','a','c','c','e','s','s','e','d','.',
/* 0x0d7f6 = "The MMIO range specified for removal was invalid." */
    '\x03','\xd4',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0d812 = "The fatal variant of VINF_EM_NO_MEMORY." */
    '\x03','f','a','t','a','l',' ','v','a','r','i','a','n','t',' ','\x15','\x0e','E','M','_','\x60','M','E','M','O','R','Y','.',
/* 0x0d82e = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY" */
    '\x01','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','B','U','S','Y',
/* 0x0d84a = "A driver encountered an unknown configuration value." */
    'A',' ','\xc7','\xaf','\x87','u','n','k','n','o','w','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xe8',
/* 0x0d866 = "The shared module is already registered." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x0b','\x80','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0d882 = "VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','I','N','I','T','_','\x17',
/* 0x0d89e = "VINF_PATM_PENDING_IRQ_AFTER_IRET" */
    '\x0e','P','A','T','M','_','P','E','N','D','I','N','G','_','I','R','Q','_','A','F','T','E','R','_','I','R','E','T',
/* 0x0d8ba = "Device i/o: General failure." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e','.',
/* 0x0d8d6 = "VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','D','2','I','_','K','E','Y','_','P','A','R','A','M','S','_','\x17',
/* 0x0d8f2 = "Unable to establish trusted of VM process (1)." */
    '\xe1','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xc6',' ','\x92','(','1',')','.',
/* 0x0d90e = "Encountered a section type that\'s not known to the loader." */
    '\xa6','a',' ','\xdd','\xf3','t','h','a','t','\'','s',' ','\x07','k','n','o','w','n',' ','\x0a','\x02','l','o','a','d','e','r','.',
/* 0x0d92a = "The guest LDT selector is out of bounds." */
    '\x03','\xbb','L','D','T',' ','s','e','l','e','c','t','o','r',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d946 = "The length of the file name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','\x22','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0d962 = "VERR_MAIN_CONFIG_CONSTRUCTOR_IPE" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','I','P','E',
/* 0x0d97e = "VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED" */
    '\x01','\xf4','\xce','H','A','S','H','_','T','A','B','_','\x06','S','T','R','I','C','T','L','Y','_','S','O','R','T','E','D',
/* 0x0d99a = "Encountered an unexpected attribute form." */
    '\xa6','\x87','u','n','e','x','p','e','c','t','e','d',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x0d9b6 = "Already aliased to the same page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x0a','\x02','s','a','m','e',' ','p','a','g','e','.',
/* 0x0d9d2 = "The ELF loader encountered an unterminated string table." */
    '\x03','E','L','F',' ','\xda','\xaf','\x87','u','n','t','e','r','m','i','n','a','t','e','d',' ','\xf2','t','a','b','l','e','.',
/* 0x0d9ee = "Not in the correct state for the attempted operation." */
    'N','o','t',' ','\x0f','\x02','c','o','r','r','e','c','t',' ','\xcc','\x10','\x02','a','t','t','e','m','p','t','e','d',' ','\xea',
/* 0x0da0a = "Current session state prohibits operation." */
    'C','u','r','r','e','n','t',' ','s','e','s','s','i','o','n',' ','\xcc','p','r','o','h','i','b','i','t','s',' ','\xea',
/* 0x0da26 = "Too deep walk during lookup." */
    'T','o','o',' ','d','e','e','p',' ','w','a','l','k',' ','d','u','r','i','n','g',' ','l','o','o','k','u','p','.',
/* 0x0da42 = "Incorrect version numbers in the header." */
    'I','n','c','o','r','r','e','c','t',' ','\xd1','n','u','m','b','e','r','s',' ','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x0da5e = "APIC did not accept the interrupt." */
    'A','P','I','C',' ','d','i','d',' ','\x07','a','c','c','e','p','t',' ','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x0da7a = "The ELF loader encountered an invalid symbol name offset." */
    '\x03','E','L','F',' ','\xda','\xaf','\x87','\x8f','s','y','m','b','o','l',' ','n','a','m','e',' ','o','f','f','s','e','t','.',
/* 0x0da96 = "VERR_SVM_HOST_VM_HSAVE_PA_INVALID" */
    '\x01','S','V','M','_','H','O','S','T','_','\xc6','_','H','S','A','V','E','_','P','A','_','I','N','V','A','L','I','D',
/* 0x0dab2 = "Recompiler: Variable management internal processing error #13." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','3','.',
/* 0x0dace = "Final OpenSSL PKIX signing failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','s','i','g','n','i','n','g',' ','\x7b',
/* 0x0daea = "VERR_GIM_HYPERCALL_ACCESS_DENIED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x0db06 = "VERR_GVMM_VMCPU_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','V','M','C','P','U','_','S','T','R','U','C','T','_','\x06','\xce','A','L','I','G','N','E','D',
/* 0x0db22 = "Invalid unit magic (internal data tag)." */
    '\x0c','u','n','i','t',' ','m','a','g','i','c',' ','(','i','n','t','e','r','n','a','l',' ','\x9d','t','a','g',')','.',
/* 0x0db3e = "VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','E','X','P','E','C','T','E','D',
/* 0x0db5a = "Unexpected MSR in the auto-load/store area." */
    '\x94','M','S','R',' ','\x0f','\x02','a','u','t','o','-','l','o','a','d','/','s','t','o','r','e',' ','a','r','e','a','.',
/* 0x0db76 = "VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG" */
    '\x01','T','M','_','G','I','P','_','U','P','D','A','T','E','_','I','N','T','E','R','V','A','L','_','\x1b','B','I','G',
/* 0x0db92 = "The DTB being parsed has an invalid header magic." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5c','\x87','\x8f','\xb4','m','a','g','i','c','.',
/* 0x0dbae = "Invalid entry in the device registration structure." */
    '\x0c','\xca','\x0f','\x02','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0dbca = "A digest type used in the manifest file isn\'t supported." */
    'A',' ','\xd8','\xf3','u','s','e','d',' ','\x0f','\x02','m','a','n','i','f','e','s','t',' ','\x22','i','s','n','\'','t',' ','\xa5',
/* 0x0dbe6 = "VERR_DBGF_BP_INT3_ADD_TRIES_REACHED" */
    '\x01','\xb9','_','B','P','_','I','N','T','3','_','A','D','D','_','T','R','I','E','S','_','R','E','A','C','H','E','D',
/* 0x0dc02 = "VINF_EM_RAW_EXCEPTION_PRIVILEGED" */
    '\x0e','E','M','_','R','A','W','_','E','X','C','E','P','T','I','O','N','_','P','R','I','V','I','L','E','G','E','D',
/* 0x0dc1e = "Invalid (malformed) file/path name." */
    '\x0c','(','m','a','l','f','o','r','m','e','d',')',' ','f','i','l','e','/','p','a','t','h',' ','n','a','m','e','.',
/* 0x0dc3a = "Image Verification Failure: Error allocating memory for state data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x10','\xcc','d','a','t','a','.',
/* 0x0dc56 = "VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE" */
    '\x01','J','S','O','N','_','\x05','U','T','F','1','6','_','E','S','C','A','P','E','_','S','E','Q','U','E','N','C','E',
/* 0x0dc72 = "The filename or extension is too long." */
    '\x03','f','i','l','e','n','a','m','e',' ','\xa9','e','x','t','e','n','s','i','o','n',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x0dc8e = "The saved state file magic was not recognized." */
    '\x03','s','a','v','e','d',' ','\xcc','\x22','m','a','g','i','c',' ','\x11','\x07','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0dcaa = "Generic failure during disassembly." */
    '\xa7','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','d','i','s','a','s','s','e','m','b','l','y','.',
/* 0x0dcc6 = "Too many I/O port registrations." */
    'T','o','o',' ','\xb5','I','/','O',' ','p','o','r','t',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x0dce2 = "Recompiler: Variable management internal processing error #10." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','0','.',
/* 0x0dcfe = "Shared Clipboard event ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','I','D',' ','\x07','\x89',
/* 0x0dd1a = "Reason for leaving RZ: Illegal call to ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','I','l','l','e','g','a','l',' ','c','a','l','l',' ','\x0a','r','i','n','g','-','3','.',
/* 0x0dd36 = "VERR_TAR_NON_DIR_ENDS_WITH_SLASH" */
    '\x01','T','A','R','_','N','O','N','_','D','I','R','_','E','N','D','S','_','W','I','T','H','_','S','L','A','S','H',
/* 0x0dd52 = "Guest mappings are disabled." */
    'G','u','e','s','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','d','i','s','a','b','l','e','d','.',
/* 0x0dd6e = "Unable to establish trusted of VM process (4)." */
    '\xe1','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xc6',' ','\x92','(','4',')','.',
/* 0x0dd8a = "Bogus reference to freed node." */
    'B','o','g','u','s',' ','r','e','f','e','r','e','n','c','e',' ','\x0a','f','r','e','e','d',' ','n','o','d','e','.',
/* 0x0dda6 = "VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x17',
/* 0x0ddc2 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','K','E','Y','S',
/* 0x0ddde = "The media is locked and cannot be unmounted." */
    '\x03','m','e','d','i','a',' ','\x0b','l','o','c','k','e','d',' ','\x9a','\xcf','\xa4','u','n','m','o','u','n','t','e','d','.',
/* 0x0ddfa = "VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','D','_','\x06','\x40',
/* 0x0de16 = "The service was disabled on the host." */
    '\x03','s','e','r','v','i','c','e',' ','\x11','d','i','s','a','b','l','e','d',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x0de32 = "The specified shared page was not actually shared." */
    '\x03','\x18','s','h','a','r','e','d',' ','\xbe','\x11','\x07','a','c','t','u','a','l','l','y',' ','s','h','a','r','e','d','.',
/* 0x0de4e = "Specified access handler was not found." */
    'S','p','e','c','i','f','i','e','d',' ','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x11','\x07','\x89',
/* 0x0de6a = "A required header parmaeter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','\xb4','p','a','r','m','a','e','t','e','r',' ','\x11','\x07','s','e','t','.',
/* 0x0de86 = "Image Verification Failure: Internal error in signature parser." */
    'I','m','a','g','e',' ','\x0d','\x12','\x08','\x09','\x0f','s','i','g','n','a','t','u','r','e',' ','p','a','r','s','e','r','.',
/* 0x0dea2 = "Invalid format of managed object reference." */
    '\x0c','f','o','r','m','a','t',' ','\x15','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0debe = "VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','U','N','I','Q','U','E','_','I','D','S','_','R','E','Q','_','V','2',
/* 0x0deda = "VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','O','F','F','_','B','A','D',
/* 0x0def6 = "Import ISO contains a directory with a bad record length." */
    '\xc4','\xc2',' ','\x8a','a',' ','\x25','\x7f','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0df12 = "Recompiler: Variable management internal processing error #11." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','1','.',
/* 0x0df2e = "AMD-V bit not set in K6_EFER MSR." */
    'A','M','D','-','V',' ','b','i','t',' ','\x07','s','e','t',' ','\x0f','K','6','_','E','F','E','R',' ','M','S','R','.',
/* 0x0df4a = "Recompiler: No temporary host register available." */
    '\x13','\xe0','t','e','m','p','o','r','a','r','y',' ','h','o','s','t',' ','\xeb','a','v','a','i','l','a','b','l','e','.',
/* 0x0df66 = "Syntax error - incorrect argument type." */
    '\xfb','\x09','-',' ','i','n','c','o','r','r','e','c','t',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','.',
/* 0x0df82 = "An operation caused a nested-guest VM-exit." */
    'A','n',' ','\x96','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xbb','\xc6','-','e','x','i','t','.',
/* 0x0df9e = "Unable to establish trusted of VM process (0)." */
    '\xe1','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xc6',' ','\x92','(','0',')','.',
/* 0x0dfba = "VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','U','B','L','I','C','_','K','E','Y','_','\x17',
/* 0x0dfd6 = "Unable to establish trusted of VM process (3)." */
    '\xe1','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xc6',' ','\x92','(','3',')','.',
/* 0x0dff2 = "VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA" */
    '\x01','\x24','S','P','C','_','E','X','P','E','C','T','E','D','_','P','E','_','I','M','A','G','E','_','D','A','T','A',
/* 0x0e00e = "VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG" */
    '\x01','\x1f','\x82','R','O','O','T','_','D','I','R','_','W','I','T','H','O','U','T','_','D','I','R','_','F','L','A','G',
/* 0x0e02a = "VERR_HARDAVL_INDEX_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','I','N','D','E','X','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0e046 = "VERR_FTP_DATA_CONN_LIMIT_REACHED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x0e062 = "VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\x82','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x0e07e = "Syntax error - the specified function is not a function." */
    '\xfb','\x09','-',' ','\x02','\x18','f','u','n','c','t','i','o','n',' ','\x0b','\x07','a',' ','f','u','n','c','t','i','o','n','.',
/* 0x0e09a = "The semaphore has been opened too many times." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x5c','\xcd','o','p','e','n','e','d',' ','\x9e','\xb5','t','i','m','e','s','.',
/* 0x0e0b6 = "The specified field is outside the structure." */
    '\x03','\x18','f','i','e','l','d',' ','\x0b','o','u','t','s','i','d','e',' ','\x02','s','t','r','u','c','t','u','r','e','.',
/* 0x0e0d2 = "Unable to establish trusted of VM process (2)." */
    '\xe1','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xc6',' ','\x92','(','2',')','.',
/* 0x0e0ee = "VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','I','M','G','_','I','N','F','O','_','\x1c',
/* 0x0e109 = "Recompiler: Variable management internal processing error #5." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','5','.',
/* 0x0e124 = "VERR_SEM_LV_WRONG_RELEASE_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','R','E','L','E','A','S','E','_','O','R','D','E','R',
/* 0x0e13f = "VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\xc5','_','F','I','N','A','L','_','O','R','_','\x1b','B','I','G',
/* 0x0e15a = "Process Verification Failure: The process has more than one thread." */
    '\x1e','\x0d','\x12','\x03','\x92','\x5c','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','t','h','r','e','a','d','.',
/* 0x0e175 = "Internal processing error in the PGM physical handler code." */
    '\x08','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\x84',
/* 0x0e190 = "Internal ISO maker error: Read file data probem #2." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','R','e','a','d',' ','\x22','\x9d','p','r','o','b','e','m',' ','#','2','.',
/* 0x0e1ab = "Reason for leaving RC: Unhandled IDT write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','I','D','T',' ','w','r','i','t','e','.',
/* 0x0e1c6 = "VERR_DBG_SEGMENT_INDEX_CONFLICT" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','I','N','D','E','X','_','C','O','N','F','L','I','C','T',
/* 0x0e1e1 = "VERR_REST_WRONG_JSON_TYPE_FOR_DATE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb3','_','F','O','R','_','D','A','T','E',
/* 0x0e1fc = "VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO" */
    '\x01','\x24','\xe5','E','X','P','E','C','T','E','D','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O',
/* 0x0e217 = "Recompiler: Register allocator internal processing error #11." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','1','.',
/* 0x0e232 = "VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS" */
    '\x01','\x1f','\x82','M','U','L','T','I','P','L','E','_','E','L','_','T','O','R','I','T','O','_','D','E','S','C','S',
/* 0x0e24d = "VERR_REST_UNABLE_TO_DECODE_DATE" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e268 = "VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS" */
    '\x01','\xe9','M','I','X','E','D','_','D','E','B','U','G','_','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x0e283 = "Floating pointer underflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x0e29e = "Too long name or link string." */
    'T','o','o',' ','l','o','n','g',' ','n','a','m','e',' ','\xa9','l','i','n','k',' ','s','t','r','i','n','g','.',
/* 0x0e2b9 = "Maximum number of mappings reached." */
    'M','a','x','i','m','u','m',' ','\xfc','\x15','m','a','p','p','i','n','g','s',' ','r','e','a','c','h','e','d','.',
/* 0x0e2d4 = "VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x0e2ef = "Invalid environment variable name." */
    '\x0c','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','a','m','e','.',
/* 0x0e30a = "Expected URI using the \'file:\' scheme." */
    '\xb8','U','R','I',' ','u','s','i','n','g',' ','\x02','\'','f','i','l','e',':','\'',' ','s','c','h','e','m','e','.',
/* 0x0e325 = "VINF_EM_PENDING_R3_IOPORT_WRITE" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x0e340 = "The ELF loader encountered an invalid relocation offset." */
    '\x03','E','L','F',' ','\xda','\xaf','\x87','\x8f','r','e','l','o','c','a','t','i','o','n',' ','o','f','f','s','e','t','.',
/* 0x0e35b = "VERR_VD_IMAGE_REPAIR_IMPOSSIBLE" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','I','M','P','O','S','S','I','B','L','E',
/* 0x0e376 = "The guest has not setup use of the hypercalls." */
    '\x03','\xbb','\x5c','\x07','s','e','t','u','p',' ','u','s','e',' ','\x15','\x02','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0e391 = "VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','\xd6','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x0e3ac = "VDI: Invalid image file header: invalid signature." */
    'V','D','I',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r',':',' ','\x8f','s','i','g','n','a','t','u','r','e','.',
/* 0x0e3c7 = "VERR_AUDIO_NO_FREE_OUTPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\x60','F','R','E','E','_','O','U','T','P','U','T','_','S','T','R','E','A','M','S',
/* 0x0e3e2 = "VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION" */
    '\x01','\x90','V','T','G','_','O','N','L','Y','_','O','N','C','E','_','P','E','R','_','S','E','S','S','I','O','N',
/* 0x0e3fd = "Hit a todo in the mach-o loader." */
    'H','i','t',' ','a',' ','t','o','d','o',' ','\x0f','\x02','m','a','c','h','-','o',' ','l','o','a','d','e','r','.',
/* 0x0e418 = "Recompiler: Variable management internal processing error #1." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','.',
/* 0x0e433 = "VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','L','I','N','K','_','I','D','_','\x06','\x40',
/* 0x0e44e = "The URI is too short to be a valid URI." */
    '\x03','U','R','I',' ','\x0b','\x9e','s','h','o','r','t',' ','\x0a','\xa4','a',' ','v','a','l','i','d',' ','U','R','I','.',
/* 0x0e469 = "VERR_SHCLPB_MAX_OBJECTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0e484 = "VERR_VUSB_USB_DEVICE_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','_','D','E','V','I','C','E','_','P','E','R','M','I','S','S','I','O','N',
/* 0x0e49f = "VERR_GETOPT_REQUIRED_ARGUMENT_MISSING" */
    '\x01','G','E','T','O','P','T','_','R','E','Q','U','I','R','E','D','_','A','R','G','U','M','E','N','T','_','\xc5',
/* 0x0e4ba = "Process Verification Failure: There are too many DLLs loaded." */
    '\x1e','\x0d','\x12','T','h','e','r','e',' ','a','r','e',' ','\x9e','\xb5','D','L','L','s',' ','l','o','a','d','e','d','.',
/* 0x0e4d5 = "Malformed or invalid file set descriptor location." */
    'M','a','l','f','o','r','m','e','d',' ','\xa9','\x8f','\x22','s','e','t',' ','\xe3','l','o','c','a','t','i','o','n','.',
/* 0x0e4f0 = "Failed to calculate the TSC frequency." */
    '\x8b','\x0a','c','a','l','c','u','l','a','t','e',' ','\x02','T','S','C',' ','f','r','e','q','u','e','n','c','y','.',
/* 0x0e50b = "HGCM could not perform requested operation because of an internal error." */
    'H','G','C','M',' ','c','o','u','l','d',' ','\x07','p','e','r','f','o','r','m',' ','\xdf','\x96','\x2a','\x15','\x87','\x16','\x85',
/* 0x0e526 = "Internal ISO maker error: Read file data probem #3." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','R','e','a','d',' ','\x22','\x9d','p','r','o','b','e','m',' ','#','3','.',
/* 0x0e541 = "VERR_AUDIO_STREAM_COULD_NOT_CREATE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','C','O','U','L','D','_','\x06','C','R','E','A','T','E',
/* 0x0e55c = "Recompiler: Register allocator internal processing error #10." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','0','.',
/* 0x0e577 = "Expression stack underflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x0e592 = "VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE" */
    '\x01','\x97','I','N','C','O','M','P','L','E','T','E','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x0e5ad = "OpenSSL failed to clone the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','c','l','o','n','e',' ','\x02','\xd8','\xd5','c','o','n','t','e','x','t','.',
/* 0x0e5c8 = "VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT" */
    '\x01','\x8d','_','\x8e','C','A','N','N','O','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x0e5e3 = "Recompiler: Variable management internal processing error #6." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','6','.',
/* 0x0e5fe = "VERR_LDR_DUPLICATE_SEGMENT_NAME" */
    '\x01','L','D','R','_','D','U','P','L','I','C','A','T','E','_','S','E','G','M','E','N','T','_','N','A','M','E',
/* 0x0e619 = "The dotted-string representation of an ASN." */
    '\x03','d','o','t','t','e','d','-','\xf2','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','\x15','\x87','\xf6',
/* 0x0e634 = "Reason for leaving RC: Unhandled LDT write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','L','D','T',' ','w','r','i','t','e','.',
/* 0x0e64f = "Internal ISO maker error: Unexpected empty component." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','\x94','e','m','p','t','y',' ','c','o','m','p','o','n','e','n','t','.',
/* 0x0e66a = "VERR_HARDAVL_MISALIGNED_POINTER" */
    '\x01','H','A','R','D','A','V','L','_','M','I','S','A','L','I','G','N','E','D','_','P','O','I','N','T','E','R',
/* 0x0e685 = "Recompiler: Variable management internal processing error #2." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','2','.',
/* 0x0e6a0 = "Constructed string type not implemented." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xf2','\xf3','\x07','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0e6bb = "Invalid CPUMCPU offset in MSR range." */
    '\x0c','C','P','U','M','C','P','U',' ','o','f','f','s','e','t',' ','\x0f','M','S','R',' ','r','a','n','g','e','.',
/* 0x0e6d6 = "Asynchronous I/O request finished." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\xab','f','i','n','i','s','h','e','d','.',
/* 0x0e6f1 = "Failed to get the delta-adjusted TSC value." */
    '\x8b','\x0a','g','e','t',' ','\x02','d','e','l','t','a','-','a','d','j','u','s','t','e','d',' ','T','S','C',' ','\xe8',
/* 0x0e70c = "VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','D','A','T','A','_','\x06','P','R','E','S','E','N','T',
/* 0x0e727 = "Bad VTG probe location record." */
    '\x9f','V','T','G',' ','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','r','e','c','o','r','d','.',
/* 0x0e742 = "Reason for leaving RC: Unhandled TSS write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','T','S','S',' ','w','r','i','t','e','.',
/* 0x0e75d = "The requested feature is not supported by NEM." */
    '\x03','\xdf','f','e','a','t','u','r','e',' ','\x0b','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','N','E','M','.',
/* 0x0e778 = "VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED" */
    '\x01','\x24','\xe5','S','I','G','N','A','T','U','R','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','\x17',
/* 0x0e793 = "VERR_PGM_HANDLER_PHYSICAL_CONFLICT" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','C','O','N','F','L','I','C','T',
/* 0x0e7ae = "The provider cannot be the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\xcf','\xa4','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x0e7c9 = "Recompiler: Variable management internal processing error #3." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','3','.',
/* 0x0e7e4 = "VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x05','S','Y','M','B','O','L','_','N','A','M','E','_','O','F','F','S','E','T',
/* 0x0e7ff = "Invalid UTF-8 encoding in the response." */
    '\x0c','U','T','F','-','8',' ','e','n','c','o','d','i','n','g',' ','\x0f','\x02','r','e','s','p','o','n','s','e','.',
/* 0x0e81a = "Recompiler: Variable management internal processing error #4." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','4','.',
/* 0x0e835 = "Invalid image relative virtual address." */
    '\x0c','\x26','r','e','l','a','t','i','v','e',' ','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x0e850 = "The shared module name is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','n','a','m','e',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x0e86b = "AMD-V CPU extension in-use." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','i','n','-','u','s','e','.',
/* 0x0e886 = "Generic object was destroyed by the call status." */
    '\xa7','\xa8','\x11','d','e','s','t','r','o','y','e','d',' ','\xdb','\x02','c','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x0e8a1 = "Too many partition descriptors." */
    'T','o','o',' ','\xb5','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0e8bc = "Reason for leaving RC: Inject a TRPM event." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','j','e','c','t',' ','a',' ','T','R','P','M',' ','e','v','e','n','t','.',
/* 0x0e8d7 = "Recompiler: Variable management internal processing error #9." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','9','.',
/* 0x0e8f2 = "Recompiler: Variable management internal processing error #7." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','7','.',
/* 0x0e90d = "Unresolved (unknown) device i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\xa3','i','/','o',' ','\x85',
/* 0x0e928 = "VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS" */
    '\x0e','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0e943 = "VERR_TM_TIMER_QUEUE_CANNOT_GROW" */
    '\x01','T','M','_','T','I','M','E','R','_','Q','U','E','U','E','_','C','A','N','N','O','T','_','G','R','O','W',
/* 0x0e95e = "The size of the raw image is not dividable by 2048." */
    '\x03','\xf8','\x15','\x02','r','a','w',' ','\x26','\x0b','\x07','d','i','v','i','d','a','b','l','e',' ','\xdb','2','0','4','8','.',
/* 0x0e979 = "Buffer too small to save result." */
    'B','u','f','f','e','r',' ','\x9e','s','m','a','l','l',' ','\x0a','s','a','v','e',' ','r','e','s','u','l','t','.',
/* 0x0e994 = "Unresolved (unknown) file i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x22','i','/','o',' ','\x85',
/* 0x0e9af = "Failed to open semaphore by name - not found." */
    '\x8b','\x0a','o','p','e','n',' ','s','e','m','a','p','h','o','r','e',' ','\xdb','n','a','m','e',' ','-',' ','\x07','\x89',
/* 0x0e9ca = "Bad iterdata2 (EXEPACK2) data." */
    '\x9f','i','t','e','r','d','a','t','a','2',' ','(','E','X','E','P','A','C','K','2',')',' ','d','a','t','a','.',
/* 0x0e9e5 = "Internal error obtaining the GVMM instance." */
    '\x08','\x09','o','b','t','a','i','n','i','n','g',' ','\x02','G','V','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x0ea00 = "VWRN_GSTCTL_OBJECTSTATE_CHANGED" */
    '\xe6','G','S','T','C','T','L','_','O','B','J','E','C','T','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x0ea1b = "Trying to free a page that isn\'t RAM." */
    'T','r','y','i','n','g',' ','\x0a','f','r','e','e',' ','a',' ','\xbe','\xad','i','s','n','\'','t',' ','R','A','M','.',
/* 0x0ea36 = "VINF_IOM_R3_IOPORT_COMMIT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x0ea51 = "VRPD receives a packet that is not supported." */
    'V','R','P','D',' ','r','e','c','e','i','v','e','s',' ','a',' ','p','a','c','k','e','t',' ','\xad','\x0b','\x07','\xa5',
/* 0x0ea6c = "No memory available for page table or page directory." */
    '\xe0','\x86','a','v','a','i','l','a','b','l','e',' ','\x10','\xbe','\xb1','\xa9','\xbe','d','i','r','e','c','t','o','r','y','.',
/* 0x0ea87 = "Unable to use the range for a large page." */
    '\xe1','\x0a','u','s','e',' ','\x02','r','a','n','g','e',' ','\x10','a',' ','l','a','r','g','e',' ','p','a','g','e','.',
/* 0x0eaa2 = "Recompiler: Variable management internal processing error #8." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','8','.',
/* 0x0eabd = "More unconsumed data available." */
    'M','o','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','\x9d','a','v','a','i','l','a','b','l','e','.',
/* 0x0ead8 = "The event semaphore has already been posted." */
    '\x03','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x5c','\x80','\xcd','p','o','s','t','e','d','.',
/* 0x0eaf3 = "Recompiler: Register allocator internal processing error #12." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','2','.',
/* 0x0eb0e = "VFS chain element expected at least one argument." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0eb29 = "NEM failed to unmap page(s) into the VM." */
    '\xee',' ','\x99','\x0a','u','n','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x0eb44 = "Internal ISO maker error: Read file data probem #1." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','R','e','a','d',' ','\x22','\x9d','p','r','o','b','e','m',' ','#','1','.',
/* 0x0eb5f = "VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','D','B','G','_','P','O','R','T','_','\x1c',
/* 0x0eb7a = "VWRN_REST_UNABLE_TO_DECODE_DATE" */
    '\xe6','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0eb95 = "General saved state file integrity error." */
    'G','e','n','e','r','a','l',' ','s','a','v','e','d',' ','\xcc','\x22','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x0ebb0 = "Syntax error - unbalanced parenthesis." */
    '\xfb','\x09','-',' ','u','n','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s','.',
/* 0x0ebcb = "Error while parsing UUID string." */
    '\xc1','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','U','U','I','D',' ','s','t','r','i','n','g','.',
/* 0x0ebe6 = "Could not recognize the key type." */
    'C','o','u','l','d',' ','\x07','r','e','c','o','g','n','i','z','e',' ','\x02','k','e','y',' ','t','y','p','e','.',
/* 0x0ec01 = "VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','C','O','N','T','E','N','T','_','\xb3','_','\x06','\x83',
/* 0x0ec1c = "The specified at reset handler wasn\'t found." */
    '\x03','\x18','a','t',' ','r','e','s','e','t',' ','h','a','n','d','l','e','r',' ','w','a','s','n','\'','t',' ','\x89',
/* 0x0ec37 = "Reason for leaving RZ: Emulate instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','E','m','u','l','a','t','e',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0ec52 = "Trying to free a page with an invalid Page ID." */
    'T','r','y','i','n','g',' ','\x0a','f','r','e','e',' ','a',' ','\xbe','\x7f','\x87','\x8f','P','a','g','e',' ','I','D','.',
/* 0x0ec6d = "VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x1d','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0ec88 = "VERR_TAR_MALFORMED_GNU_LONGXXXX" */
    '\x01','T','A','R','_','M','A','L','F','O','R','M','E','D','_','G','N','U','_','L','O','N','G','X','X','X','X',
/* 0x0eca3 = "Dataspace manager server not found." */
    'D','a','t','a','s','p','a','c','e',' ','m','a','n','a','g','e','r',' ','s','e','r','v','e','r',' ','\x07','\x89',
/* 0x0ecbe = "VERR_REST_WRONG_JSON_TYPE_FOR_BOOL" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb3','_','F','O','R','_','B','O','O','L',
/* 0x0ecd9 = "VERR_IOQUEUE_HANDLE_NOT_REGISTERED" */
    '\x01','I','O','Q','U','E','U','E','_','H','A','N','D','L','E','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x0ecf4 = "VERR_PATH_DOES_NOT_START_WITH_ROOT" */
    '\x01','P','A','T','H','_','D','O','E','S','_','\x06','S','T','A','R','T','_','W','I','T','H','_','R','O','O','T',
/* 0x0ed0f = "VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT" */
    '\x01','\x1f','\x82','R','O','O','T','_','D','I','R','_','I','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0ed2a = "Image Verification Failure: Error reading file for hashing." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','r','e','a','d','i','n','g',' ','\x22','\x10','h','a','s','h','i','n','g','.',
/* 0x0ed45 = "VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS" */
    '\x01','I','O','M','_','\x1b','\xac','I','O','P','O','R','T','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x0ed60 = "VERR_GMM_MEMORY_RESERVATION_DECLINED" */
    '\x01','G','M','M','_','\xb6','_','R','E','S','E','R','V','A','T','I','O','N','_','D','E','C','L','I','N','E','D',
/* 0x0ed7b = "VERR_SHCLPB_LIST_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','L','I','S','T','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x0ed96 = "VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH" */
    '\x01','\x1f','\x82','D','O','T','_','D','I','R','_','R','E','C','_','\x1d','N','A','M','E','_','L','E','N','G','T','H',
/* 0x0edb1 = "VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN" */
    '\x0e','\xb0','V','O','T','E','_','D','O','N','E','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x0edcc = "Recompiler: Register allocator internal processing error #13." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','3','.',
/* 0x0ede7 = "Unhandled #DB in hypervisor code." */
    'U','n','h','a','n','d','l','e','d',' ','#','D','B',' ','\x0f','h','y','p','e','r','v','i','s','o','r',' ','\x84',
/* 0x0ee02 = "Image Verification Failure: Error reading image headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','r','e','a','d','i','n','g',' ','\x26','h','e','a','d','e','r','s','.',
/* 0x0ee1c = "VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION" */
    '\x01','S','Y','S','T','E','M','_','\xf7','_','P','O','L','I','C','Y','_','V','I','O','L','A','T','I','O','N',
/* 0x0ee36 = "The cache is not up to date with the image." */
    '\x03','c','a','c','h','e',' ','\x0b','\x07','u','p',' ','\x0a','d','a','t','e',' ','\x7f','\x02','i','m','a','g','e','.',
/* 0x0ee50 = "Can\'t move file to another disk." */
    'C','a','n','\'','t',' ','m','o','v','e',' ','\x22','\x0a','a','n','o','t','h','e','r',' ','d','i','s','k','.',
/* 0x0ee6a = "VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','\xe4','\xd6','_','A','S','_','B','O','O','L',
/* 0x0ee84 = "VERR_DBG_NO_MATCHING_INTERPRETER" */
    '\x01','D','B','G','_','\x60','M','A','T','C','H','I','N','G','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0X0ee9e = "Requested service does not exist." */
    'e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\xb2','\x07','e','x','i','s','t','.',
/* 0x0eeb7 = "VERR_LDRELF_INVALID_RELOCATION_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x05','R','E','L','O','C','A','T','I','O','N','_','O','F','F','S','E','T',
/* 0x0eed1 = "The size of the raw image is not dividable by 512." */
    '\x03','\xf8','\x15','\x02','r','a','w',' ','\x26','\x0b','\x07','d','i','v','i','d','a','b','l','e',' ','\xdb','5','1','2','.',
/* 0x0eeeb = "VERR_AUDIO_NO_FREE_INPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\x60','F','R','E','E','_','I','N','P','U','T','_','S','T','R','E','A','M','S',
/* 0x0ef05 = "The JSON document is malformed." */
    '\x03','J','S','O','N',' ','d','o','c','u','m','e','n','t',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x0ef1f = "VERR_X509_EXTRACT_PUBKEY_FROM_CERT" */
    '\x01','\xb7','E','X','T','R','A','C','T','_','P','U','B','K','E','Y','_','F','R','O','M','_','C','E','R','T',
/* 0x0ef39 = "VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','F','R','E','E','_','\x1b','M','U','C','H',
/* 0x0ef53 = "The shared module has too many regions." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x5c','\x9e','\xb5','r','e','g','i','o','n','s','.',
/* 0x0ef6d = "Recompiler: Register allocator internal processing error #3." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','3','.',
/* 0x0ef87 = "Requires process elevation (UAC)." */
    'R','e','q','u','i','r','e','s',' ','\x92','e','l','e','v','a','t','i','o','n',' ','(','U','A','C',')','.',
/* 0x0efa1 = "Recompiler: Register allocator internal processing error #7." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','7','.',
/* 0x0efbb = "VERR_VD_DISCARD_ALIGNMENT_NOT_MET" */
    '\x01','V','D','_','D','I','S','C','A','R','D','_','A','L','I','G','N','M','E','N','T','_','\x06','M','E','T',
/* 0x0efd5 = "VERR_INTNET_INCOMPATIBLE_TRUNK" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','T','R','U','N','K',
/* 0x0efef = "VERR_PGM_HANDLER_VIRTUAL_CONFLICT" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','V','I','R','T','U','A','L','_','C','O','N','F','L','I','C','T',
/* 0x0f009 = "Key algorithm parameters not expected." */
    'K','e','y',' ','\xd5','p','a','r','a','m','e','t','e','r','s',' ','\x07','e','x','p','e','c','t','e','d','.',
/* 0x0f023 = "Malformed forwarder entry." */
    'M','a','l','f','o','r','m','e','d',' ','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x0f03d = "VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES" */
    '\x01','H','A','R','D','A','V','L','_','T','R','A','V','E','R','S','E','D','_','\x1b','\xac','N','O','D','E','S',
/* 0x0f057 = "Format not supported by the codec." */
    'F','o','r','m','a','t',' ','\x07','s','u','p','p','o','r','t','e','d',' ','\xdb','\x02','c','o','d','e','c','.',
/* 0x0f071 = "Insufficient data to check descriptor CRC." */
    'I','n','s','u','f','f','i','c','i','e','n','t',' ','\x9d','\x0a','c','h','e','c','k',' ','\xe3','C','R','C','.',
/* 0x0f08b = "The USB device instance structure version has changed." */
    '\x03','U','S','B',' ','\xa3','i','n','s','t','a','n','c','e',' ','\xec','\xd1','\x5c','c','h','a','n','g','e','d','.',
/* 0x0f0a5 = "Generic debugger command failure." */
    '\xa7','d','e','b','u','g','g','e','r',' ','c','o','m','m','a','n','d',' ','f','a','i','l','u','r','e','.',
/* 0x0f0bf = "Name is not unique on the network." */
    'N','a','m','e',' ','\x0b','\x07','u','n','i','q','u','e',' ','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x0f0d9 = "Internal processing error in the debug module reader code." */
    '\x08','\x04','\x09','\x0f','\x02','d','e','b','u','g',' ','m','o','d','u','l','e',' ','r','e','a','d','e','r',' ','\x84',
/* 0x0f0f3 = "Image Verification Failure: Error reading section headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc1','r','e','a','d','i','n','g',' ','\xdd','h','e','a','d','e','r','s','.',
/* 0x0f10d = "VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x19',
/* 0x0f127 = "HM returned in the wrong state." */
    'H','M',' ','r','e','t','u','r','n','e','d',' ','\x0f','\x02','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x0f141 = "Status that causes DBGC to quit." */
    'S','t','a','t','u','s',' ','\xad','c','a','u','s','e','s',' ','D','B','G','C',' ','\x0a','q','u','i','t','.',
/* 0x0f15b = "VERR_NET_DEST_ADDRESS_REQUIRED" */
    '\x01','N','E','T','_','D','E','S','T','_','A','D','D','R','E','S','S','_','R','E','Q','U','I','R','E','D',
/* 0x0f175 = "VERR_ISOMK_SYMLINK_SUPPORT_DISABLED" */
    '\x01','\x1f','S','Y','M','L','I','N','K','_','S','U','P','P','O','R','T','_','D','I','S','A','B','L','E','D',
/* 0x0f18f = "The specified environment variable was not found." */
    '\x03','\x18','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x11','\x07','\x89',
/* 0x0f1a9 = "Recompiler: Register allocator internal processing error #9." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','9','.',
/* 0x0f1c3 = "VERR_INTNET_INCOMPATIBLE_FLAGS" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','F','L','A','G','S',
/* 0x0f1dd = "VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED" */
    '\x01','\x24','\xb7','C','P','V','_','A','L','T','_','N','A','M','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x0f1f7 = "Import ISO uses invalid volume sequence number." */
    '\xc4','\xc2',' ','u','s','e','s',' ','\x8f','\xd3','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x0f211 = "Reason for leaving RZ: The urge to syncing CR3." */
    '\x93','\x10','\x81','R','Z',':',' ','\x03','u','r','g','e',' ','\x0a','s','y','n','c','i','n','g',' ','C','R','3','.',
/* 0x0f22b = "VERR_SHCLPB_MAX_EVENTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','E','V','E','N','T','S','_','R','E','A','C','H','E','D',
/* 0x0f245 = "Process Verification Failure: Error querying image information." */
    '\x1e','\x0d','\x12','\xc1','q','u','e','r','y','i','n','g',' ','\x26','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0f25f = "VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1" */
    '\x01','\x9c','E','M','I','T','_','C','A','S','E','_','\x06','I','M','P','L','E','M','E','N','T','E','D','_','1',
/* 0x0f279 = "The size of the raw floppy image is too big (>2." */
    '\x03','\xf8','\x15','\x02','r','a','w',' ','f','l','o','p','p','y',' ','\x26','\x0b','\x9e','b','i','g',' ','(','>','2','.',
/* 0x0f293 = "VERR_X509_RSA_VERIFICATION_FUILURE" */
    '\x01','\xb7','R','S','A','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','U','I','L','U','R','E',
/* 0x0f2ad = "Too many logical volume descriptors." */
    'T','o','o',' ','\xb5','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0f2c7 = "VERR_PDM_MEDIAEX_IOREQID_CONFLICT" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','C','O','N','F','L','I','C','T',
/* 0x0f2e1 = "Unable to switch due to invalid host state." */
    '\xe1','\x0a','s','w','i','t','c','h',' ','d','u','e',' ','\x0a','\x8f','h','o','s','t',' ','s','t','a','t','e','.',
/* 0x0f2fb = "VERR_IOM_IOPORT_RANGE_CONFLICT" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x0f315 = "The returned shadow page is cached." */
    '\x03','r','e','t','u','r','n','e','d',' ','s','h','a','d','o','w',' ','\xbe','\x0b','c','a','c','h','e','d','.',
/* 0x0f32f = "VERR_DWARF_BAD_LINE_NUMBER_HEADER" */
    '\x01','D','W','A','R','F','_','\x1d','L','I','N','E','_','N','U','M','B','E','R','_','H','E','A','D','E','R',
/* 0x0f349 = "VERR_SUP_VP_NT_MAPPING_NAME_CHANGED" */
    '\x01','\x95','\xbd','N','T','_','M','A','P','P','I','N','G','_','N','A','M','E','_','C','H','A','N','G','E','D',
/* 0x0f363 = "Too many primary volume descriptors." */
    'T','o','o',' ','\xb5','p','r','i','m','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0f37d = "VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT" */
    '\x01','\x95','\xbd','\x06','S','I','G','N','E','D','_','W','I','T','H','_','B','U','I','L','D','_','C','E','R','T',
/* 0x0f397 = "VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','V','E','R','I','F','Y','_','F','I','N','A','L','_','\x17',
/* 0x0f3b1 = "VERR_DBG_MALFORMED_UNWIND_INFO" */
    '\x01','D','B','G','_','M','A','L','F','O','R','M','E','D','_','U','N','W','I','N','D','_','I','N','F','O',
/* 0x0f3cb = "The loaded timer state was incorrect." */
    '\x03','l','o','a','d','e','d',' ','t','i','m','e','r',' ','\xcc','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0f3e5 = "Recompiler: Register allocator internal processing error #8." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','8','.',
/* 0x0f3ff = "VERR_FDT_DTB_HDR_MAGIC_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','A','G','I','C','_','I','N','V','A','L','I','D',
/* 0x0f419 = "Execute one instruction with the recompiler." */
    'E','x','e','c','u','t','e',' ','o','n','e',' ','\xdc','\x7f','\x02','r','e','c','o','m','p','i','l','e','r','.',
/* 0x0f433 = "VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION" */
    '\x01','\x24','\xb7','C','P','V','_','\x91','C','R','I','T','I','C','A','L','_','E','X','T','E','N','S','I','O','N',
/* 0x0f44d = "VINF_AUDIO_MORE_DATA_AVAILABLE" */
    '\x0e','A','U','D','I','O','_','M','O','R','E','_','D','A','T','A','_','A','V','A','I','L','A','B','L','E',
/* 0x0f467 = "Recording initialization failed." */
    'R','e','c','o','r','d','i','n','g',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x0f481 = "The GVM is out of VM handle space." */
    '\x03','G','V','M',' ','\x0b','o','u','t',' ','\x15','\xc6',' ','h','a','n','d','l','e',' ','s','p','a','c','e','.',
/* 0x0f49b = "The format of a data unit has changed." */
    '\x03','f','o','r','m','a','t',' ','\x15','a',' ','\x9d','u','n','i','t',' ','\x5c','c','h','a','n','g','e','d','.',
/* 0x0f4b5 = "Requested service already exists." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x80','e','x','i','s','t','s','.',
/* 0x0f4cf = "VERR_VMX_VMCS_FIELD_CACHE_INVALID" */
    '\x01','\xe2','V','M','C','S','_','F','I','E','L','D','_','C','A','C','H','E','_','I','N','V','A','L','I','D',
/* 0x0f4e9 = "Multiple PE image page hash tables." */
    'M','u','l','t','i','p','l','e',' ','P','E',' ','\x26','\xbe','h','a','s','h',' ','t','a','b','l','e','s','.',
/* 0x0f503 = "The CRC of the saved state file did not match." */
    '\x03','C','R','C',' ','\x15','\x02','s','a','v','e','d',' ','\xcc','\x22','d','i','d',' ','\x07','m','a','t','c','h','.',
/* 0x0f51d = "VERR_GVMM_GVM_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','G','V','M','_','S','T','R','U','C','T','_','\x06','\xce','A','L','I','G','N','E','D',
/* 0X0f537 = "Descriptor tag is all zeros." */
    'e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','\x0b','a','l','l',' ','z','e','r','o','s','.',
/* 0x0f550 = "VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT" */
    '\x01','\x1f','\x82','M','I','S','A','L','I','G','N','E','D','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0f56a = "Recompiler: Register allocator internal processing error #4." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','4','.',
/* 0x0f584 = "VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x1b','L','I','T','T','L','E','_','D','A','T','A','_','L','E','F','T',
/* 0x0f59e = "VERR_SERIALPORT_BREAK_DETECTED" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','B','R','E','A','K','_','D','E','T','E','C','T','E','D',
/* 0x0f5b8 = "Mount failed because a media was already mounted." */
    'M','o','u','n','t',' ','\x99','\x2a','a',' ','m','e','d','i','a',' ','\x11','\x80','m','o','u','n','t','e','d','.',
/* 0x0f5d2 = "Pluggable Device Manager error." */
    'P','l','u','g','g','a','b','l','e',' ','D','e','v','i','c','e',' ','M','a','n','a','g','e','r',' ','\x85',
/* 0x0f5ec = "Internal processing error in the PGM handy page allocator." */
    '\x08','\x04','\x09','\x0f','\x02','P','G','M',' ','h','a','n','d','y',' ','\xbe','a','l','l','o','c','a','t','o','r','.',
/* 0x0f606 = "VINF_EM_RESUME_R3_HISTORY_EXEC" */
    '\x0e','E','M','_','R','E','S','U','M','E','_','R','3','_','H','I','S','T','O','R','Y','_','E','X','E','C',
/* 0X0f620 = "Can\'t delete bucket with keys." */
    'a','n','\'','t',' ','d','e','l','e','t','e',' ','b','u','c','k','e','t',' ','\x7f','k','e','y','s','.',
/* 0x0f639 = "VERR_HARDAVL_INSERT_INVALID_KEY_RANGE" */
    '\x01','H','A','R','D','A','V','L','_','I','N','S','E','R','T','_','\x05','K','E','Y','_','R','A','N','G','E',
/* 0x0f653 = "VINF_IEM_REEXEC_FINISH_WITH_FLAGS" */
    '\x0e','\x9c','R','E','E','X','E','C','_','F','I','N','I','S','H','_','W','I','T','H','_','F','L','A','G','S',
/* 0x0f66d = "The specified I/O port range was invalid." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0f687 = "Recompiler: Register allocator internal processing error #5." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','5','.',
/* 0x0f6a1 = "Recompiler: Register allocator internal processing error #1." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','.',
/* 0x0f6bb = "Unrecoverable error: lock was lost." */
    'U','n','r','e','c','o','v','e','r','a','b','l','e',' ','\xd9','l','o','c','k',' ','\x11','l','o','s','t','.',
/* 0x0f6d5 = "The event semaphore has already been reset." */
    '\x03','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x5c','\x80','\xcd','r','e','s','e','t','.',
/* 0x0f6ef = "VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','P','R','O','V','I','D','E','R','_','N','A','M','E',
/* 0X0f709 = "Expression stack overflow." */
    'x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','o','v','e','r','f','l','o','w','.',
/* 0x0f722 = "VMDK: Invalid image file header: invalid version." */
    'V','M','D','K',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r',':',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x0f73c = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','\x91','I','M','A','G','E','_','\xfa',
/* 0x0f756 = "VERR_GIM_HYPERCALLS_NOT_AVAILABLE" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x0f770 = "Missing size element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','\xf8','\x5e','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0f78a = "VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS" */
    '\x01','L','D','R','E','L','F','_','\x60','S','Y','M','B','O','L','_','O','R','_','\x60','\xd6','_','T','A','B','S',
/* 0x0f7a4 = "The semaphore is set and cannot be closed." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x0b','s','e','t',' ','\x9a','\xcf','\xa4','c','l','o','s','e','d','.',
/* 0x0f7be = "VT-x VMCS launch state invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','l','a','u','n','c','h',' ','\xcc','i','n','v','a','l','i','d','.',
/* 0x0f7d8 = "The specified string / bytes buffer was to small." */
    '\x03','\x18','\xf2','/',' ','b','y','t','e','s',' ','b','u','f','f','e','r',' ','\x11','\x0a','s','m','a','l','l','.',
/* 0x0f7f2 = "VERR_VD_ISCSI_SECRET_ENCRYPTED" */
    '\x01','V','D','_','I','S','C','S','I','_','S','E','C','R','E','T','_','E','N','C','R','Y','P','T','E','D',
/* 0x0f80c = "VINF_EM_PENDING_R3_IOPORT_READ" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x0f826 = "Recompiler: Register allocator internal processing error #6." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','6','.',
/* 0x0f840 = "VERR_LDRELF_UNTERMINATED_STRING_TAB" */
    '\x01','L','D','R','E','L','F','_','U','N','T','E','R','M','I','N','A','T','E','D','_','\xd6','_','T','A','B',
/* 0x0f85a = "VERR_ISOFS_MALFORMED_PART_MAP_TABLE" */
    '\x01','\x97','M','A','L','F','O','R','M','E','D','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x0f874 = "VERR_SSM_DATA_UNIT_FORMAT_CHANGED" */
    '\x01','\xb0','D','A','T','A','_','U','N','I','T','_','F','O','R','M','A','T','_','C','H','A','N','G','E','D',
/* 0x0f88e = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\x1d','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0f8a8 = "Recompiler: Totally unexpected memory size." */
    '\x13','T','o','t','a','l','l','y',' ','u','n','e','x','p','e','c','t','e','d',' ','\x86','s','i','z','e','.',
/* 0x0f8c2 = "The ELF loader encountered a bad symbol index." */
    '\x03','E','L','F',' ','\xda','\xaf','a',' ','b','a','d',' ','s','y','m','b','o','l',' ','i','n','d','e','x','.',
/* 0x0f8dc = "VERR_SHCLPB_OBJ_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','O','B','J','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x0f8f6 = "No page directory available for the hypervisor." */
    '\xe0','\xbe','\x25','a','v','a','i','l','a','b','l','e',' ','\x10','\x02','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0f910 = "Recompiler: Register allocator internal processing error #2." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','2','.',
/* 0x0f92a = "General network printing error." */
    'G','e','n','e','r','a','l',' ','n','e','t','w','o','r','k',' ','p','r','i','n','t','i','n','g',' ','\x85',
/* 0x0f944 = "VINF_EM_RESCHEDULE_EXEC_ENGINE" */
    '\x0e','E','M','_','R','E','S','C','H','E','D','U','L','E','_','E','X','E','C','_','E','N','G','I','N','E',
/* 0x0f95e = "VFS chain element expected at most one argument." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','m','o','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0f978 = "Floating pointer overflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','o','v','e','r','f','l','o','w','.',
/* 0x0f992 = "VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x0e','\x7d','\x60','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x0f9ab = "The timer was in a unknown state." */
    '\x03','t','i','m','e','r',' ','\x11','\x0f','a',' ','u','n','k','n','o','w','n',' ','s','t','a','t','e','.',
/* 0x0f9c4 = "VERR_NET_INCOMPLETE_TX_PACKET" */
    '\x01','N','E','T','_','I','N','C','O','M','P','L','E','T','E','_','T','X','_','P','A','C','K','E','T',
/* 0x0f9dd = "Shared Clipboard event failed error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','\x99','\x85',
/* 0x0f9f6 = "Internal SPC error: Bad object moniker data pointer." */
    '\x08','S','P','C',' ','\xd9','\x9f','\xa8','m','o','n','i','k','e','r',' ','\x9d','p','o','i','n','t','e','r','.',
/* 0x0fa0f = "VERR_CR_PKIX_SIGNATURE_NEGATIVE" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','N','E','G','A','T','I','V','E',
/* 0x0fa28 = "Bad SPC object moniker UUID field." */
    '\x9f','S','P','C',' ','\xa8','m','o','n','i','k','e','r',' ','U','U','I','D',' ','f','i','e','l','d','.',
/* 0x0fa41 = "VERR_DBGF_BP_OWNER_NO_MORE_HANDLES" */
    '\x01','\xb9','_','B','P','_','O','W','N','E','R','_','\x60','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x0fa5a = "Encountered an unknown attribute form." */
    '\xa6','\x87','u','n','k','n','o','w','n',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x0fa73 = "Command address is invalid." */
    'C','o','m','m','a','n','d',' ','a','d','d','r','e','s','s',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x0fa8c = "Proxy couldn\'t be resolved." */
    'P','r','o','x','y',' ','c','o','u','l','d','n','\'','t',' ','\xa4','r','e','s','o','l','v','e','d','.',
/* 0x0faa5 = "The write monitor is already engaged." */
    '\x03','w','r','i','t','e',' ','m','o','n','i','t','o','r',' ','\x0b','\x80','e','n','g','a','g','e','d','.',
/* 0x0fabe = "NEM failed to map page(s) into the VM." */
    '\xee',' ','\x99','\x0a','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x0fad7 = "Invalid object ID in managed object reference." */
    '\x0c','\xa8','I','D',' ','\x0f','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0faf0 = "Process Verification Failure: Image section region is too large." */
    '\x1e','\x0d','\x12','I','m','a','g','e',' ','\xdd','r','e','g','i','o','n',' ','\x0b','\x9e','l','a','r','g','e','.',
/* 0x0fb09 = "VERR_VUSB_DEVICE_IS_RESETTING" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','R','E','S','E','T','T','I','N','G',
/* 0x0fb22 = "Decompression integrity error." */
    'D','e','c','o','m','p','r','e','s','s','i','o','n',' ','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x0fb3b = "The register is read-only and cannot be modified." */
    '\x03','\xeb','\x0b','r','e','a','d','-','o','n','l','y',' ','\x9a','\xcf','\xa4','m','o','d','i','f','i','e','d','.',
/* 0x0fb54 = "A number tar header field was malformed." */
    'A',' ','\xfc','t','a','r',' ','\xb4','f','i','e','l','d',' ','\x11','m','a','l','f','o','r','m','e','d','.',
/* 0x0fb6d = "Image Verification Failure: Invalid security directory entry." */
    'I','m','a','g','e',' ','\x0d','\x12','\x0c','s','e','c','u','r','i','t','y',' ','\x25','e','n','t','r','y','.',
/* 0x0fb86 = "VERR_HTTP_CACERT_WRONG_FORMAT" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','W','R','O','N','G','_','F','O','R','M','A','T',
/* 0x0fb9f = "Process Verification Failure: Bad file alignment value in image header." */
    '\x1e','\x0d','\x12','\x9f','\x22','a','l','i','g','n','m','e','n','t',' ','\xf5','\x0f','\x26','h','e','a','d','e','r','.',
/* 0x0fbb8 = "Too many instances of a device." */
    'T','o','o',' ','\xb5','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','d','e','v','i','c','e','.',
/* 0x0fbd1 = "Encountered a init function section." */
    '\xa6','a',' ','i','n','i','t',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x0fbea = "Bad DWARF abbreviation data." */
    '\x9f','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','d','a','t','a','.',
/* 0x0fc03 = "Was not able to open the support driver." */
    'W','a','s',' ','\x07','a','b','l','e',' ','\x0a','o','p','e','n',' ','\x02','\xd0','d','r','i','v','e','r','.',
/* 0x0fc1c = "The instruction is not yet implemented by IEM." */
    '\x03','\xdc','\x0b','\x07','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xdb','I','E','M','.',
/* 0x0fc35 = "VERR_CR_KEY_MALFORMED_CIPHER_IV" */
    '\x01','\x24','K','E','Y','_','M','A','L','F','O','R','M','E','D','_','C','I','P','H','E','R','_','I','V',
/* 0x0fc4e = "VERR_NET_CONNECTION_TIMED_OUT" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','T','I','M','E','D','_','O','U','T',
/* 0x0fc67 = "Unsupported CPU feature combination." */
    '\x98','C','P','U',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0fc80 = "Generic dangling objects status." */
    '\xa7','d','a','n','g','l','i','n','g',' ','o','b','j','e','c','t','s',' ','s','t','a','t','u','s','.',
/* 0x0fc99 = "VERR_CR_KEY_ALGO_PARAMS_UNKNOWN" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','K','N','O','W','N',
/* 0x0fcb2 = "Bogus UDF dstring field value." */
    'B','o','g','u','s',' ','U','D','F',' ','d','s','t','r','i','n','g',' ','f','i','e','l','d',' ','\xe8',
/* 0x0fccb = "The handle ID was not found in the set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x11','\x07','f','o','u','n','d',' ','\x0f','\x02','s','e','t','.',
/* 0x0fce4 = "VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','D','I','R','_','O','R','_','F','S','S','_','O','R','_','\x8d',
/* 0x0fcfd = "Hypervisor code was stepped." */
    'H','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',' ','\x11','s','t','e','p','p','e','d','.',
/* 0x0fd16 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR" */
    '\x01','\x9c','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\x60','F','R','E','E','_','V','A','R',
/* 0x0fd2f = "VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH" */
    '\x01','\xa2','C','U','R','S','O','R','_','T','A','G','_','F','L','A','G','_','C','L','A','S','S','_','\x19',
/* 0x0fd48 = "VERR_ASN1_BITSTRING_OUT_OF_BOUNDS" */
    '\x01','\xa2','B','I','T','S','T','R','I','N','G','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0fd61 = "VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED" */
    '\x01','\xd7','S','Y','M','L','I','N','K','S','_','A','R','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x0fd7a = "Wrong 32/64-bit switcher." */
    'W','r','o','n','g',' ','3','2','/','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r','.',
/* 0x0fd93 = "No available ports on the hub." */
    '\xe0','a','v','a','i','l','a','b','l','e',' ','p','o','r','t','s',' ','o','n',' ','\x02','h','u','b','.',
/* 0x0fdac = "Parallels HDD: Invalid image file header." */
    'P','a','r','a','l','l','e','l','s',' ','H','D','D',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x0fdc5 = "VERR_REST_PATH_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','P','A','T','H','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0X0fdde = "There is no tracer present." */
    'h','e','r','e',' ','\x0b','n','o',' ','t','r','a','c','e','r',' ','p','r','e','s','e','n','t','.',
/* 0x0fdf6 = "The LUN is not attached to the device." */
    '\x03','L','U','N',' ','\x0b','\x07','a','t','t','a','c','h','e','d',' ','\x0a','\x02','d','e','v','i','c','e','.',
/* 0x0fe0f = "VERR_HOSTIF_DEVICE_NAME_TOO_LONG" */
    '\x01','H','O','S','T','I','F','_','D','E','V','I','C','E','_','N','A','M','E','_','\x1b','L','O','N','G',
/* 0x0fe28 = "VERR_FDT_DTB_PROP_SIZE_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','\xfa','_','M','A','L','F','O','R','M','E','D',
/* 0x0fe41 = "VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x01','\x7d','\x60','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x0fe5a = "The EVP_PKEY_type API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','\xf3','A','P','I',' ','\x0f','O','p','e','n','S','S','L',' ','\x7b',
/* 0x0fe73 = "Encountered a section type that\'s not implemented." */
    '\xa6','a',' ','\xdd','\xf3','t','h','a','t','\'','s',' ','\x07','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0fe8c = "Internal processing error #1 in the DBGF event tracing code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','e','v','e','n','t',' ','t','r','a','c','i','n','g',' ','\x84',
/* 0x0fea5 = "VFS chain doesn't end with a path only element." */
    '\x8d',' ','\xa1','\xc9','e','n','d',' ','\x7f','a',' ','\xd2','o','n','l','y',' ','e','l','e','m','e','n','t','.',
/* 0x0febe = "VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION" */
    '\x01','\x97','\x1d','L','V','D','_','\xaa','S','E','T','_','D','E','S','C','_','L','O','C','A','T','I','O','N',
/* 0x0fed7 = "VINF_DBGF_ZERO_EXTENDED_REGISTER" */
    '\x0e','\xb9','_','Z','E','R','O','_','E','X','T','E','N','D','E','D','_','R','E','G','I','S','T','E','R',
/* 0x0fef0 = "The request function is not implemented." */
    '\x03','\xab','f','u','n','c','t','i','o','n',' ','\x0b','\x07','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0ff09 = "VERR_SSM_ENUM_VALUE_OUT_OF_RANGE" */
    '\x01','\xb0','E','N','U','M','_','V','A','L','U','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0ff22 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','\x05','I','D',
/* 0x0ff3b = "VERR_GSTCTL_PROCESS_EXIT_CODE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','E','X','I','T','_','C','O','D','E',
/* 0x0ff54 = "VERR_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x01','\xb7','\x06','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0ff6d = "VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\x05','B','O','O','T','_','M','E','D','I','A','_','\xb3',
/* 0x0ff86 = "VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\xe6','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x17',
/* 0x0ff9f = "VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET" */
    '\x01','C','P','U','M','_','M','S','R','_','\x1d','C','P','U','M','C','P','U','_','O','F','F','S','E','T',
/* 0x0ffb8 = "Failed to read the device table entry due to an invalid offset." */
    '\x8b','\x0a','r','e','a','d',' ','\x02','\xa3','\xb1','\xca','d','u','e',' ','\x0a','\x87','\x8f','o','f','f','s','e','t','.',
/* 0x0ffd1 = "The mode field in a tar header is bad." */
    '\x03','m','o','d','e',' ','f','i','e','l','d',' ','\x0f','a',' ','t','a','r',' ','\xb4','\x0b','b','a','d','.',
/* 0x0ffea = "VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR" */
    '\x01','\x24','K','E','Y','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x1c',
/* 0x10003 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP" */
    '\x01','\x9c','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\x60','F','R','E','E','_','T','M','P',
/* 0x1001c = "Internal processing error: Not build certificate." */
    '\x08','\x04','\xd9','N','o','t',' ','b','u','i','l','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x10035 = "Process Verification Failure: Bad section alignment value in image header." */
    '\x1e','\x0d','\x12','\x9f','\xdd','a','l','i','g','n','m','e','n','t',' ','\xf5','\x0f','\x26','h','e','a','d','e','r','.',
/* 0x1004e = "Invalid configuration property value." */
    '\x0c','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','p','e','r','t','y',' ','\xe8',
/* 0x10067 = "VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN" */
    '\x01','\x24','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','\x06','K','N','O','W','N',
/* 0x10080 = "VERR_SHCLPB_MAX_LISTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','L','I','S','T','S','_','R','E','A','C','H','E','D',
/* 0x10099 = "VERR_BIGNUM_NEGATIVE_EXPONENT" */
    '\x01','B','I','G','N','U','M','_','N','E','G','A','T','I','V','E','_','E','X','P','O','N','E','N','T',
/* 0x100b2 = "Basic constraints were not found." */
    'B','a','s','i','c',' ','c','o','n','s','t','r','a','i','n','t','s',' ','w','e','r','e',' ','\x07','\x89',
/* 0x100cb = "Too many references to an object." */
    'T','o','o',' ','\xb5','r','e','f','e','r','e','n','c','e','s',' ','\x0a','\x87','o','b','j','e','c','t','.',
/* 0x100e4 = "Reason for leaving RC: Encountered a stale selector." */
    '\x93','\x10','\x81','R','C',':',' ','\xa6','a',' ','s','t','a','l','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x100fd = "VINF_GIM_HYPERCALL_CONTINUING" */
    '\x0e','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','C','O','N','T','I','N','U','I','N','G',
/* 0x10116 = "VERR_IOM_MMIO_HANDLER_BOGUS_CALL" */
    '\x01','I','O','M','_','\xd4','_','H','A','N','D','L','E','R','_','B','O','G','U','S','_','C','A','L','L',
/* 0x1012f = "Process Verification Failure: The process has too many virtual memory regions." */
    '\x1e','\x0d','\x12','\x03','\x92','\x5c','\x9e','\xb5','v','i','r','t','u','a','l',' ','\x86','r','e','g','i','o','n','s','.',
/* 0x10148 = "VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS" */
    '\x01','\xfd','\xe4','U','N','B','A','L','A','N','C','E','D','_','P','A','R','E','N','T','H','E','S','I','S',
/* 0x10161 = "The tar file ended unexpectedly." */
    '\x03','t','a','r',' ','\x22','e','n','d','e','d',' ','u','n','e','x','p','e','c','t','e','d','l','y','.',
/* 0x1017a = "Directory can\'t be deleted." */
    'D','i','r','e','c','t','o','r','y',' ','c','a','n','\'','t',' ','\xa4','d','e','l','e','t','e','d','.',
/* 0x10193 = "Too many instances of a driver." */
    'T','o','o',' ','\xb5','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','d','r','i','v','e','r','.',
/* 0x101ac = "VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','I','N','F','O','_','\xbf','E','N','C','R','Y','P','T','_','\x19',
/* 0x101c5 = "Bad length element in table of content sub-element." */
    '\x9f','l','e','n','g','t','h',' ','\x5e','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x101de = "Mismatching architecture." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x101f7 = "VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','E','C','D','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x10210 = "VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','\x1b','\xac','R','E','C','U','R','S','I','O','N','S',
/* 0x10229 = "VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT" */
    '\x01','\x8d','_','\x8e','M','U','S','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x10242 = "VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE" */
    '\x01','\x7d','D','R','I','V','E','R','_','D','E','T','A','C','H','_','\x06','P','O','S','S','I','B','L','E',
/* 0x1025b = "Certificate path builder: Encountered bad certificate context." */
    '\xba','\xd2','b','u','i','l','d','e','r',':',' ','\xa6','b','a','d',' ','\xa0','c','o','n','t','e','x','t','.',
/* 0x10274 = "VINF_PGM_HANDLED_DIRTY_BIT_FAULT" */
    '\x0e','\x8c','H','A','N','D','L','E','D','_','D','I','R','T','Y','_','B','I','T','_','F','A','U','L','T',
/* 0x1028d = "VINF_EM_RAW_INTERRUPT_PENDING" */
    '\x0e','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','P','E','N','D','I','N','G',
/* 0x102a6 = "Bad VTG provider descriptor." */
    '\x9f','V','T','G',' ','p','r','o','v','i','d','e','r',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x102bf = "VERR_LDRVI_SECTION_RAW_DATA_VALUES" */
    '\x01','\xf4','S','E','C','T','I','O','N','_','R','A','W','_','D','A','T','A','_','V','A','L','U','E','S',
/* 0x102d8 = "Command hardware failure." */
    'C','o','m','m','a','n','d',' ','h','a','r','d','w','a','r','e',' ','f','a','i','l','u','r','e','.',
/* 0x102f1 = "Unused MMIO register read, fill with 00." */
    'U','n','u','s','e','d',' ','\xd4',' ','\xeb','r','e','a','d',',',' ','f','i','l','l',' ','\x7f','0','0','.',
/* 0x1030a = "VDI: Invalid image file header: invalid version." */
    'V','D','I',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r',':',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x10323 = "VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY" */
    '\x01','\x1f','B','O','O','T','_','C','A','T','_','\x60','D','E','F','A','U','L','T','_','E','N','T','R','Y',
/* 0x1033c = "VERR_SEM_LV_EXISTING_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','E','X','I','S','T','I','N','G','_','D','E','A','D','L','O','C','K',
/* 0x10355 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\x01','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x17',
/* 0x1036e = "Unused MMIO register read, fill with FF." */
    'U','n','u','s','e','d',' ','\xd4',' ','\xeb','r','e','a','d',',',' ','f','i','l','l',' ','\x7f','F','F','.',
/* 0x10387 = "Failed to get underlying link ID." */
    '\x8b','\x0a','g','e','t',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','I','D','.',
/* 0x103a0 = "Encountered a term function section." */
    '\xa6','a',' ','t','e','r','m',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x103b9 = "VERR_CPUM_INCOMPATIBLE_CONFIG" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x103d2 = "VERR_FILE_AIO_INSUFFICIENT_EVENTS" */
    '\x01','\xaa','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','E','V','E','N','T','S',
/* 0x103eb = "VFS chain element takes exactly three arguments." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','h','r','e','e',' ','\xde',
/* 0x10404 = "VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD" */
    '\x01','\x97','B','O','G','U','S','_','U','D','F','_','D','S','T','R','I','N','G','_','F','I','E','L','D',
/* 0x1041d = "VERR_FTP_CLIENT_LIMIT_REACHED" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10436 = "VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF" */
    '\x01','\x90','T','R','A','C','E','R','_','C','A','N','N','O','T','_','O','P','E','N','_','S','E','L','F',
/* 0x1044f = "A bad page map entry was encountered." */
    'A',' ','b','a','d',' ','\xbe','m','a','p',' ','\xca','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x10468 = "Unsupported PKCS #7 signed data version." */
    '\x98','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x9d','v','e','r','s','i','o','n','.',
/* 0x10481 = "VERR_VUSB_DEVICE_IS_SUSPENDED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','S','U','S','P','E','N','D','E','D',
/* 0x1049a = "Was not able to load the support driver." */
    'W','a','s',' ','\x07','a','b','l','e',' ','\x0a','l','o','a','d',' ','\x02','\xd0','d','r','i','v','e','r','.',
/* 0x104b3 = "VWRN_CSAM_INSTRUCTION_PATCHED" */
    '\xe6','C','S','A','M','_','I','N','S','T','R','U','C','T','I','O','N','_','P','A','T','C','H','E','D',
/* 0x104cc = "VINF_VRDP_OPERATION_COMPLETED" */
    '\x0e','V','R','D','P','_','O','P','E','R','A','T','I','O','N','_','C','O','M','P','L','E','T','E','D',
/* 0x104e5 = "VINF_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x0e','\xb7','\x06','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x104fe = "VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY" */
    '\x01','\x24','P','K','I','X','_','H','A','S','H','_','\x1b','L','O','N','G','_','F','O','R','_','K','E','Y',
/* 0x10517 = "The PE loader doesn't grok the COM descriptor data directory entry." */
    '\x03','P','E',' ','\xda','\xc9','g','r','o','k',' ','\x02','C','O','M',' ','\xe3','\x9d','\x25','e','n','t','r','y','.',
/* 0x10530 = "The VFS chain specification is empty." */
    '\x03','\x8d',' ','\xa1','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x0b','e','m','p','t','y','.',
/* 0x10549 = "No default entry in the boot catalog." */
    '\xe0','d','e','f','a','u','l','t',' ','\xca','\x0f','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x10562 = "VERR_XAR_EXTRACTED_SIZE_EXCEEDED" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','\xfa','_','E','X','C','E','E','D','E','D',
/* 0x1057b = "VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH" */
    '\x01','\xf4','M','A','C','H','I','N','E','_','O','P','T','_','H','D','R','_','M','A','G','I','C','_','\x19',
/* 0x10594 = "Bad offset element in table of content sub-element." */
    '\x9f','o','f','f','s','e','t',' ','\x5e','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x105ad = "VERR_IPC_SEND_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x105c6 = "VERR_XAR_UNUSED_ARCHIVED_DATA" */
    '\x01','X','A','R','_','U','N','U','S','E','D','_','A','R','C','H','I','V','E','D','_','D','A','T','A',
/* 0x105df = "VERR_PATM_IPE_TRAP_IN_PATCH_CODE" */
    '\x01','P','A','T','M','_','\x14','T','R','A','P','_','I','N','_','P','A','T','C','H','_','C','O','D','E',
/* 0x105f8 = "VERR_INTNET_FLT_VNIC_CREATE_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','C','R','E','A','T','E','_','\x17',
/* 0x10611 = "Failed to fstat a native handle (hardening)." */
    '\x8b','\x0a','f','s','t','a','t',' ','a',' ','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\xae',
/* 0x1062a = "NEM returned in the wrong state." */
    '\xee',' ','r','e','t','u','r','n','e','d',' ','\x0f','\x02','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x10643 = "Bad iterdata (EXEPACK) data." */
    '\x9f','i','t','e','r','d','a','t','a',' ','(','E','X','E','P','A','C','K',')',' ','d','a','t','a','.',
/* 0x1065c = "VINF_EM_RAW_INJECT_TRPM_EVENT" */
    '\x0e','E','M','_','R','A','W','_','I','N','J','E','C','T','_','T','R','P','M','_','E','V','E','N','T',
/* 0x10675 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','\x1b','B','I','G',
/* 0x1068e = "VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','\x06','F','U','L','L','Y','_','M','A','P','P','E','D',
/* 0x106a6 = "VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x01','\x1f','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x106be = "Process Verification Failure: Error querying debug port." */
    '\x1e','\x0d','\x12','\xc1','q','u','e','r','y','i','n','g',' ','d','e','b','u','g',' ','p','o','r','t','.',
/* 0x106d6 = "The shared module version string is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xd1','\xf2','\x0b','\x9e','l','o','n','g','.',
/* 0x106ee = "Nothing that can be cancelled." */
    'N','o','t','h','i','n','g',' ','\xad','c','a','n',' ','\xa4','c','a','n','c','e','l','l','e','d','.',
/* 0x10706 = "VERR_REST_WRONG_JSON_TYPE_FOR_STRING" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb3','_','F','O','R','_','\xd6',
/* 0x1071e = "VERR_AUDIO_BACKEND_NOT_ATTACHED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','\x06','A','T','T','A','C','H','E','D',
/* 0x10736 = "Unsectioned boot catalog entry." */
    'U','n','s','e','c','t','i','o','n','e','d',' ','b','o','o','t',' ','\xe7','e','n','t','r','y','.',
/* 0x1074e = "VFS chain element takes exactly four arguments." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','o','u','r',' ','\xde',
/* 0x10766 = "Hypervisor memory allocation failed." */
    'H','y','p','e','r','v','i','s','o','r',' ','\x86','a','l','l','o','c','a','t','i','o','n',' ','\x7b',
/* 0x1077e = "VERR_RECORDING_LIMIT_REACHED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10796 = "VERR_VD_ASYNC_IO_IN_PROGRESS" */
    '\x01','V','D','_','A','S','Y','N','C','_','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x107ae = "Syntax error - out of scratch memory." */
    '\xfb','\x09','-',' ','o','u','t',' ','\x15','s','c','r','a','t','c','h',' ','m','e','m','o','r','y','.',
/* 0x107c6 = "The Ring-3 module was already loaded." */
    '\x03','R','i','n','g','-','3',' ','m','o','d','u','l','e',' ','\x11','\x80','l','o','a','d','e','d','.',
/* 0x107de = "VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x0e','\x1f','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x107f6 = "VERR_NS_SYMLINK_CHANGE_OWNER" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','C','H','A','N','G','E','_','O','W','N','E','R',
/* 0x1080e = "VINF_EM_RAW_EMULATE_DBG_STEP" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','D','B','G','_','S','T','E','P',
/* 0x10826 = "The PKCS #7 content is not signed data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xf0','\x0b','\x07','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x1083e = "FAM failed to open a connection." */
    'F','A','M',' ','\x99','\x0a','o','p','e','n',' ','a',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x10856 = "Unable to lock a region of a file." */
    '\xe1','\x0a','l','o','c','k',' ','a',' ','r','e','g','i','o','n',' ','\x15','a',' ','f','i','l','e','.',
/* 0x1086e = "VERR_LDRPE_LOCK_PREFIX_TABLE" */
    '\x01','L','D','R','P','E','_','L','O','C','K','_','P','R','E','F','I','X','_','T','A','B','L','E',
/* 0x10886 = "The tar end of file record was read." */
    '\x03','t','a','r',' ','e','n','d',' ','\x15','\x22','r','e','c','o','r','d',' ','\x11','r','e','a','d','.',
/* 0x1089e = "Access denied for the address." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x10','\x02','a','d','d','r','e','s','s','.',
/* 0x108b6 = "VERR_PGM_PCI_PASSTHRU_MISCONFIG" */
    '\x01','\x8c','P','C','I','_','P','A','S','S','T','H','R','U','_','M','I','S','C','O','N','F','I','G',
/* 0x108ce = "VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH" */
    '\x01','\x95','\xbd','D','L','L','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x19',
/* 0x108e6 = "Max timer limit reached." */
    'M','a','x',' ','t','i','m','e','r',' ','l','i','m','i','t',' ','r','e','a','c','h','e','d','.',
/* 0x108fe = "VFS chain element expected non-empty argument." */
    '\x8d',' ','\xa1','\x5e','\xcb','n','o','n','-','e','m','p','t','y',' ','a','r','g','u','m','e','n','t','.',
/* 0x10916 = "VERR_GETOPT_INVALID_ARGUMENT_FORMAT" */
    '\x01','G','E','T','O','P','T','_','\x05','A','R','G','U','M','E','N','T','_','F','O','R','M','A','T',
/* 0x1092e = "VERR_IOM_NOT_IOPORT_RANGE_OWNER" */
    '\x01','I','O','M','_','\x06','I','O','P','O','R','T','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x10946 = "The compressed data was corrupted." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9d','\x11','c','o','r','r','u','p','t','e','d','.',
/* 0x1095e = "VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','S','I','G','N','_','F','I','N','A','L','_','\x17',
/* 0x10976 = "VINF_GCM_HANDLED_ADVANCE_RIP" */
    '\x0e','G','C','M','_','H','A','N','D','L','E','D','_','A','D','V','A','N','C','E','_','R','I','P',
/* 0x1098e = "VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO" */
    '\x01','C','P','U','M','_','\x05','H','W','V','I','R','T','_','F','E','A','T','_','C','O','M','B','O',
/* 0x109a6 = "Node index is out of bounds." */
    'N','o','d','e',' ','i','n','d','e','x',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x109be = "VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH" */
    '\x01','\x24','P','K','I','X','_','\x05','S','I','G','N','A','T','U','R','E','_','L','E','N','G','T','H',
/* 0x109d6 = "VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT" */
    '\x01','\x90','\x60','R','A','W','_','M','O','D','E','_','H','Y','P','E','R','_','V','_','R','O','O','T',
/* 0x109ee = "Unknown or unrecognized SVM exit." */
    '\xef','\xa9','u','n','r','e','c','o','g','n','i','z','e','d',' ','S','V','M',' ','e','x','i','t','.',
/* 0x10a06 = "Certificate path validator: Unknown critical certificate extension." */
    '\xba','\xd2','\xff','\xef','c','r','i','t','i','c','a','l',' ','\xa0','e','x','t','e','n','s','i','o','n','.',
/* 0x10a1e = "VERR_LDRELF_MULTIPLE_SYMTABS" */
    '\x01','L','D','R','E','L','F','_','M','U','L','T','I','P','L','E','_','S','Y','M','T','A','B','S',
/* 0x10a36 = "VERR_XAR_TOC_TOO_BIG_COMPRESSED" */
    '\x01','X','A','R','_','T','O','C','_','\x1b','B','I','G','_','C','O','M','P','R','E','S','S','E','D',
/* 0x10a4e = "VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL" */
    '\x01','V','D','_','R','A','W','_','\xfa','_','O','P','T','I','C','A','L','_','\x1b','S','M','A','L','L',
/* 0x10a66 = "Bad symbol table size in Mach-O image." */
    '\x9f','s','y','m','b','o','l',' ','\xb1','\xf8','\x0f','M','a','c','h','-','O',' ','i','m','a','g','e','.',
/* 0x10a7e = "Bad VTG probe enabled data." */
    '\x9f','V','T','G',' ','p','r','o','b','e',' ','e','n','a','b','l','e','d',' ','d','a','t','a','.',
/* 0x10a96 = "Empty sub-string set inside X." */
    'E','m','p','t','y',' ','s','u','b','-','\xf2','s','e','t',' ','i','n','s','i','d','e',' ','X','.',
/* 0x10aae = "Terminate search branch." */
    'T','e','r','m','i','n','a','t','e',' ','s','e','a','r','c','h',' ','b','r','a','n','c','h','.',
/* 0x10ac6 = "VERR_SUP_VP_DUPLICATE_DLL_MAPPING" */
    '\x01','\x95','\xbd','D','U','P','L','I','C','A','T','E','_','D','L','L','_','M','A','P','P','I','N','G',
/* 0x10ade = "VERR_FAM_MONITOR_DIRECTORY_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','D','I','R','E','C','T','O','R','Y','_','\x17',
/* 0x10af6 = "The USB device helper structure version has changed." */
    '\x03','U','S','B',' ','\xa3','h','e','l','p','e','r',' ','\xec','\xd1','\x5c','c','h','a','n','g','e','d','.',
/* 0x10b0e = "Failed to read the device table entry from guest memory." */
    '\x8b','\x0a','r','e','a','d',' ','\x02','\xa3','\xb1','\xca','f','r','o','m',' ','\xbb','m','e','m','o','r','y','.',
/* 0x10b26 = "VERR_NET_PROTOCOL_NOT_AVAILABLE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x10b3e = "Internal processing error #1 in page access handler code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\xbe','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x84',
/* 0x10b56 = "VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO" */
    '\x01','\x24','S','P','C','_','\x06','E','X','A','C','T','L','Y','_','O','N','E','_','\xbf','A','L','G','O',
/* 0x10b6e = "VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO" */
    '\x01','\x1f','\x82','D','I','R','_','R','E','C','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x10b86 = "Recompiler: Fixed jump is out of range." */
    '\x13','F','i','x','e','d',' ','j','u','m','p',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x10b9e = "VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED" */
    '\x01','\x95','\xbd','C','R','E','A','T','E','_','R','E','A','D','_','E','V','T','_','S','E','M','_','\x17',
/* 0x10bb6 = "VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS" */
    '\x01','\x1f','\x82','U','D','F','_','D','I','S','C','O','N','T','I','G','U','O','U','S','_','A','D','S',
/* 0x10bce = "VERR_GIM_HYPERCALLS_NOT_ENABLED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x06','E','N','A','B','L','E','D',
/* 0x10be6 = "VERR_GMM_HIT_VM_ACCOUNT_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','\xc6','_','A','C','C','O','U','N','T','_','L','I','M','I','T',
/* 0x10bfe = "Invalid segment:offset address." */
    '\x0c','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s','.',
/* 0x10c16 = "No CR3 root shadow page table." */
    '\xe0','C','R','3',' ','r','o','o','t',' ','s','h','a','d','o','w',' ','\xbe','t','a','b','l','e','.',
/* 0x10c2e = "Invalid host interface version." */
    '\x0c','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','v','e','r','s','i','o','n','.',
/* 0x10c46 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5" */
    '\x01','\xd7','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','5',
/* 0x10c5e = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1" */
    '\x01','\xd7','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','1',
/* 0x10c76 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0" */
    '\x01','\xd7','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','0',
/* 0x10c8e = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3" */
    '\x01','\xd7','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','3',
/* 0x10ca6 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2" */
    '\x01','\xd7','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','2',
/* 0x10cbe = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4" */
    '\x01','\xd7','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','4',
/* 0x10cd6 = "VINF_EM_DBG_HYPER_BREAKPOINT" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','B','R','E','A','K','P','O','I','N','T',
/* 0x10cee = "VERR_IEM_VAR_OUT_OF_STACK_SLOTS" */
    '\x01','\x9c','V','A','R','_','O','U','T','_','O','F','_','S','T','A','C','K','_','S','L','O','T','S',
/* 0x10d06 = "The field contains a value that is out of range." */
    '\x03','f','i','e','l','d',' ','\x8a','a',' ','\xf5','\xad','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x10d1e = "VERR_APIC_INTR_MASKED_BY_TPR" */
    '\x01','A','P','I','C','_','I','N','T','R','_','M','A','S','K','E','D','_','B','Y','_','T','P','R',
/* 0x10d36 = "VERR_VMM_RING3_CALL_DISABLED" */
    '\x01','V','M','M','_','R','I','N','G','3','_','C','A','L','L','_','D','I','S','A','B','L','E','D',
/* 0x10d4e = "VERR_PROC_ELEVATION_REQUIRED" */
    '\x01','P','R','O','C','_','E','L','E','V','A','T','I','O','N','_','R','E','Q','U','I','R','E','D',
/* 0x10d66 = "No buffer space available." */
    '\xe0','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x10d7e = "No partition descriptors found." */
    '\xe0','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x89',
/* 0x10d96 = "VRDP protocol violation." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n','.',
/* 0x10dae = "VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL" */
    '\x01','E','X','T','P','A','C','K','_','\x1a','H','O','S','T','_','U','N','I','N','S','T','A','L','L',
/* 0x10dc6 = "VINF_PATM_DUPLICATE_FUNCTION" */
    '\x0e','P','A','T','M','_','D','U','P','L','I','C','A','T','E','_','F','U','N','C','T','I','O','N',
/* 0x10dde = "Internal error: Uninitialized status code." */
    '\x08','\xd9','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','s','t','a','t','u','s',' ','\x84',
/* 0x10df6 = "Internal SPC error: Bad object moniker choice value." */
    '\x08','S','P','C',' ','\xd9','\x9f','\xa8','m','o','n','i','k','e','r',' ','c','h','o','i','c','e',' ','\xe8',
/* 0x10e0e = "VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','\xb3','_','\x1c',
/* 0x10e26 = "The DBGF has no more free breakpoint slots." */
    '\x03','\xb9',' ','\x5c','n','o',' ','m','o','r','e',' ','f','r','e','e',' ','\xc0','s','l','o','t','s','.',
/* 0x10e3e = "VERR_HOSTIF_FD_AND_INIT_TERM" */
    '\x01','H','O','S','T','I','F','_','F','D','_','A','N','D','_','I','N','I','T','_','T','E','R','M',
/* 0x10e56 = "Invalid UTF-16 escape sequence." */
    '\x0c','U','T','F','-','1','6',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x10e6e = "Unexpected cURL error configure the proxy." */
    '\x94','c','U','R','L',' ','\x09','c','o','n','f','i','g','u','r','e',' ','\x02','p','r','o','x','y','.',
/* 0x10e86 = "VERR_PDM_MEDIAEX_IOBUF_OVERFLOW" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','B','U','F','_','O','V','E','R','F','L','O','W',
/* 0x10e9e = "VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES" */
    '\x01','\x7d','\x1b','\xac','U','S','B','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x10eb6 = "Descriptor CRC mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x10ece = "VERR_PDM_DEVICE_INSTANCE_NO_IBASE" */
    '\x01','\x7d','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x60','I','B','A','S','E',
/* 0x10ee6 = "VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND" */
    '\x01','\x7d','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','L','U','N','_','\x06','\x40',
/* 0x10efe = "Unable to make text memory writeable (hardening)." */
    '\xe1','\x0a','m','a','k','e',' ','t','e','x','t',' ','\x86','w','r','i','t','e','a','b','l','e',' ','\xae',
/* 0x10f16 = "VERR_PDM_MEDIAEX_IOREQ_CANCELED" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','C','A','N','C','E','L','E','D',
/* 0x10f2e = "VERR_PGM_POOL_MAXED_OUT_ALREADY" */
    '\x01','\x8c','P','O','O','L','_','M','A','X','E','D','_','O','U','T','_','A','L','R','E','A','D','Y',
/* 0x10f46 = "VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','\x91','A','T','T','R','I','B','U','T','E',
/* 0x10f5e = "Unexpected interruption exit type." */
    '\x94','i','n','t','e','r','r','u','p','t','i','o','n',' ','e','x','i','t',' ','t','y','p','e','.',
/* 0x10f76 = "Reached the max cache size." */
    'R','e','a','c','h','e','d',' ','\x02','m','a','x',' ','c','a','c','h','e',' ','s','i','z','e','.',
/* 0x10f8e = "VINF_RECORDING_LIMIT_REACHED" */
    '\x0e','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10fa6 = "The file is not a valid NM map file." */
    '\x03','\x22','\x0b','\x07','a',' ','v','a','l','i','d',' ','N','M',' ','m','a','p',' ','f','i','l','e','.',
/* 0x10fbe = "We are in driverless mode." */
    'W','e',' ','a','r','e',' ','\x0f','d','r','i','v','e','r','l','e','s','s',' ','m','o','d','e','.',
/* 0x10fd6 = "VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\xb6','_','W','R','I','T','E','_','\x17',
/* 0x10fee = "Internal processing error in the PGM dynmap (r0/rc)." */
    '\x08','\x04','\x09','\x0f','\x02','P','G','M',' ','d','y','n','m','a','p',' ','(','r','0','/','r','c',')','.',
/* 0x11006 = "VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR" */
    '\x01','\x90','S','E','S','S','I','O','N','_','P','R','O','C','E','S','S','_','E','N','U','M','_','\x1c',
/* 0x1101e = "Recompiler: Uninitialized variable." */
    '\x13','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','v','a','r','i','a','b','l','e','.',
/* 0x11036 = "The timer was not in the correct state for the request operation." */
    '\x03','t','i','m','e','r',' ','\x11','\x07','\x0f','\x02','c','o','r','r','e','c','t',' ','\xcc','\x10','\x02','\xab','\xea',
/* 0x1104e = "Conflicting CFGM values." */
    'C','o','n','f','l','i','c','t','i','n','g',' ','C','F','G','M',' ','v','a','l','u','e','s','.',
/* 0x11066 = "The request is for something forbidden." */
    '\x03','\xab','\x0b','\x10','s','o','m','e','t','h','i','n','g',' ','f','o','r','b','i','d','d','e','n','.',
/* 0x1107e = "VERR_GVMM_VM_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','\xc6','_','S','T','R','U','C','T','_','\x06','\xce','A','L','I','G','N','E','D',
/* 0x11096 = "VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT" */
    '\x01','\xce','D','I','R','E','C','T','O','R','Y','_','P','T','R','_','\x06','P','R','E','S','E','N','T',
/* 0x110ae = "VERR_RT_REQUEST_STATUS_FREED" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x110c6 = "VFS chain element takes exactly five arguments." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','i','v','e',' ','\xde',
/* 0x110de = "VERR_X509_PRINT_EXTENSION_TO_BIO" */
    '\x01','\xb7','P','R','I','N','T','_','E','X','T','E','N','S','I','O','N','_','T','O','_','B','I','O',
/* 0x110f6 = "NEM failed to query dirty page bitmap." */
    '\xee',' ','\x99','\x0a','q','u','e','r','y',' ','d','i','r','t','y',' ','\xbe','b','i','t','m','a','p','.',
/* 0x1110e = "VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY" */
    '\x01','\x1f','B','O','O','T','_','C','A','T','_','E','R','R','A','T','I','C','_','E','N','T','R','Y',
/* 0x11126 = "VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED" */
    '\x01','\x90','T','S','C','_','F','R','E','Q','_','M','E','A','S','U','R','E','M','E','N','T','_','\x17',
/* 0x1113e = "Configuration value is unknown." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf5','\x0b','u','n','k','n','o','w','n','.',
/* 0x11156 = "VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS" */
    '\x01','\x1f','\x82','D','I','R','_','W','I','T','H','_','M','O','R','E','_','E','X','T','E','N','T','S',
/* 0x1116e = "A DWARF abbreviation was not found." */
    'A',' ','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','\x11','\x07','\x89',
/* 0x11186 = "VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','E','C','D','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x1119e = "Generic out of resources warning." */
    '\xa7','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s',' ','w','a','r','n','i','n','g','.',
/* 0x111b6 = "VERR_PDM_MEDIAEX_IOBUF_UNDERRUN" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','B','U','F','_','U','N','D','E','R','R','U','N',
/* 0x111ce = "Protocol wrong type for socket." */
    'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','\xf3','\x10','s','o','c','k','e','t','.',
/* 0x111e6 = "Unknown digest algorithm used by PKCS #7 object." */
    '\xef','\xd8','\xd5','u','s','e','d',' ','\xdb','P','K','C','S',' ','#','7',' ','o','b','j','e','c','t','.',
/* 0x111fe = "VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES" */
    '\x01','C','P','U','M','_','\x1b','\xac','C','P','U','I','D','_','S','U','B','L','E','A','V','E','S',
/* 0x11215 = "VERR_PGM_MAPPINGS_FIX_CONFLICT" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','C','O','N','F','L','I','C','T',
/* 0x1122c = "VERR_PGM_WRITE_MONITOR_ENGAGED" */
    '\x01','\x8c','W','R','I','T','E','_','M','O','N','I','T','O','R','_','E','N','G','A','G','E','D',
/* 0x11243 = "VERR_NET_CONNECTION_ABORTED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','A','B','O','R','T','E','D',
/* 0x1125a = "Guest process is in a wrong state." */
    'G','u','e','s','t',' ','\x92','\x0b','\x0f','a',' ','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x11271 = "VINF_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x0e','\x24','\xbf','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x11288 = "VERR_INTNET_FLT_VNIC_INIT_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','I','N','I','T','_','\x17',
/* 0x1129f = "Failed to get a guest page which is expected to be present." */
    '\x8b','\x0a','g','e','t',' ','a',' ','\xbb','\xbe','\xed','\x0b','\xcb','\x0a','\xa4','p','r','e','s','e','n','t','.',
/* 0x112b6 = "VERR_PKZIP_ZIP64EX_IN_ZIP32" */
    '\x01','P','K','Z','I','P','_','Z','I','P','6','4','E','X','_','I','N','_','Z','I','P','3','2',
/* 0x112cd = "Unable to parse the XML in DMG file." */
    '\xe1','\x0a','p','a','r','s','e',' ','\x02','X','M','L',' ','\x0f','D','M','G',' ','f','i','l','e','.',
/* 0x112e4 = "VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','R','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x112fb = "Unable to open the host interface." */
    '\xe1','\x0a','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x11312 = "The semaphore cannot be set again." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\xcf','\xa4','s','e','t',' ','a','g','a','i','n','.',
/* 0x11329 = "No primary volume descriptors found." */
    '\xe0','p','r','i','m','a','r','y',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s',' ','\x89',
/* 0x11340 = "Failed to obtain the GMM instance." */
    '\x8b','\x0a','o','b','t','a','i','n',' ','\x02','G','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x11357 = "VERR_TM_VIRTUAL_TICKING_IPE" */
    '\x01','T','M','_','V','I','R','T','U','A','L','_','T','I','C','K','I','N','G','_','I','P','E',
/* 0x1136e = "A tracer has already been registered." */
    'A',' ','t','r','a','c','e','r',' ','\x5c','\x80','\xcd','r','e','g','i','s','t','e','r','e','d','.',
/* 0x11385 = "VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND" */
    '\x01','L','D','R','_','I','M','P','O','R','T','E','D','_','S','Y','M','B','O','L','_','\x06','\x40',
/* 0x1139c = "Reason for leaving RZ: Ring-3 operation pending." */
    '\x93','\x10','\x81','R','Z',':',' ','R','i','n','g','-','3',' ','\x96','p','e','n','d','i','n','g','.',
/* 0x113b3 = "The iterator reached the end." */
    '\x03','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d','.',
/* 0x113ca = "Bad mutex semaphore flags." */
    '\x9f','m','u','t','e','x',' ','s','e','m','a','p','h','o','r','e',' ','f','l','a','g','s','.',
/* 0x113e1 = "VERR_GIM_HYPERCALL_MEMORY_READ_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\xb6','_','R','E','A','D','_','\x17',
/* 0x113f8 = "VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','F','A','M','I','L','Y','_','\x06','\x83',
/* 0x1140f = "The TCP server was destroyed." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x11','d','e','s','t','r','o','y','e','d','.',
/* 0x11426 = "VERR_IPE_NOT_REACHED_DEFAULT_CASE" */
    '\x01','\x14','\x06','R','E','A','C','H','E','D','_','D','E','F','A','U','L','T','_','C','A','S','E',
/* 0x1143d = "The UDP server was destroyed." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x11','d','e','s','t','r','o','y','e','d','.',
/* 0x11454 = "VERR_VM_REQUEST_STATUS_FREED" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x1146b = "VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','C','E','R','T','_','\x06','S','H','I','P','P','E','D',
/* 0x11482 = "Symbolic link not allowed." */
    'S','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x07','a','l','l','o','w','e','d','.',
/* 0x11499 = "SyncPage modified the PDE." */
    'S','y','n','c','P','a','g','e',' ','m','o','d','i','f','i','e','d',' ','\x02','P','D','E','.',
/* 0x114b0 = "VERR_ASN1_TIME_BAD_NORMALIZE_INPUT" */
    '\x01','\xa2','T','I','M','E','_','\x1d','N','O','R','M','A','L','I','Z','E','_','I','N','P','U','T',
/* 0x114c7 = "VERR_RECORDING_CODEC_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','I','N','I','T','_','\x17',
/* 0x114de = "VERR_CR_PKIX_SIGNATURE_GE_KEY" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','G','E','_','K','E','Y',
/* 0x114f5 = "VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY" */
    '\x01','\x24','\xb7','N','A','M','E','_','\xc5','_','R','D','N','_','M','A','P','_','E','N','T','R','Y',
/* 0x1150c = "Connection reset by peer." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','\xdb','p','e','e','r','.',
/* 0x11523 = "Too many clients for the service." */
    'T','o','o',' ','\xb5','c','l','i','e','n','t','s',' ','\x10','\x02','s','e','r','v','i','c','e','.',
/* 0x1153a = "Failed to initialize a memory object." */
    '\x8b','\x0a','i','n','i','t','i','a','l','i','z','e',' ','a',' ','\x86','o','b','j','e','c','t','.',
/* 0x11551 = "VERR_SELM_LDT_OUT_OF_BOUNDS" */
    '\x01','S','E','L','M','_','L','D','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x11568 = "No configuration value exists." */
    '\xe0','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf5','e','x','i','s','t','s','.',
/* 0x1157f = "VINF_CPUM_HOST_CR0_MODIFIED" */
    '\x0e','C','P','U','M','_','H','O','S','T','_','C','R','0','_','M','O','D','I','F','I','E','D',
/* 0x11596 = "VERR_X509_READING_CERT_FROM_BIO" */
    '\x01','\xb7','R','E','A','D','I','N','G','_','C','E','R','T','_','F','R','O','M','_','B','I','O',
/* 0x115ad = "Unsupported VRDP protocol feature." */
    '\x98','V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x115c4 = "VERR_SEM_LV_ILLEGAL_UPGRADE" */
    '\x01','S','E','M','_','L','V','_','I','L','L','E','G','A','L','_','U','P','G','R','A','D','E',
/* 0x115db = "VERR_NEM_QUERY_DIRTY_BITMAP_FAILED" */
    '\x01','\xee','_','Q','U','E','R','Y','_','D','I','R','T','Y','_','B','I','T','M','A','P','_','\x17',
/* 0x115f2 = "VINF_VGA_RESIZE_IN_PROGRESS" */
    '\x0e','V','G','A','_','R','E','S','I','Z','E','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x11609 = "VERR_INTNET_FLT_VNIC_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','O','P','E','N','_','\x17',
/* 0x11620 = "VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','M','A','P','P','I','N','G','_','B','A','S','E','_','\x1c',
/* 0x11637 = "Trying to seek on device." */
    'T','r','y','i','n','g',' ','\x0a','s','e','e','k',' ','o','n',' ','d','e','v','i','c','e','.',
/* 0x1164e = "No logical volume descriptors found." */
    '\xe0','l','o','g','i','c','a','l',' ','\xd3','d','e','s','c','r','i','p','t','o','r','s',' ','\x89',
/* 0x11665 = "VERR_AUTHENTICATION_FAILURE" */
    '\x01','A','U','T','H','E','N','T','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x1167c = "VERR_HTTP_CURL_PROXY_CONFIG" */
    '\x01','H','T','T','P','_','C','U','R','L','_','P','R','O','X','Y','_','C','O','N','F','I','G',
/* 0x11693 = "VERR_PGM_MAPPINGS_FIX_REJECTED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','R','E','J','E','C','T','E','D',
/* 0x116aa = "VERR_PDM_HIF_SHARING_VIOLATION" */
    '\x01','\x7d','H','I','F','_','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x116c1 = "Page directory pointer not present." */
    'P','a','g','e',' ','\x25','p','o','i','n','t','e','r',' ','\x07','p','r','e','s','e','n','t','.',
/* 0x116d8 = "VERR_SVM_HOST_SVME_NOT_ENABLED" */
    '\x01','S','V','M','_','H','O','S','T','_','S','V','M','E','_','\x06','E','N','A','B','L','E','D',
/* 0x116ef = "Remapping failed for the interrupt." */
    'R','e','m','a','p','p','i','n','g',' ','\x99','\x10','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x11706 = "VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH" */
    '\x01','\x1f','\x82','\x1d','R','O','O','T','_','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x1171d = "Encountered an unknown load command." */
    '\xa6','\x87','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','m','m','a','n','d','.',
/* 0x11734 = "There is more data available." */
    'T','h','e','r','e',' ','\x0b','m','o','r','e',' ','\x9d','a','v','a','i','l','a','b','l','e','.',
/* 0x1174b = "VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x11762 = "VERR_ISOMK_IMPORT_UDF_FILE_WITH_STREAM_DIR" */
    '\x01','\x1f','\x82','U','D','F','_','\xaa','W','I','T','H','_','S','T','R','E','A','M','_','D','I','R',
/* 0x11779 = "VINF_EM_RAW_RING_SWITCH_INT" */
    '\x0e','E','M','_','R','A','W','_','R','I','N','G','_','S','W','I','T','C','H','_','I','N','T',
/* 0x11790 = "VFS chain element takes exactly two arguments." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','w','o',' ','\xde',
/* 0x117a7 = "Entry in a boot catalog section is empty." */
    'E','n','t','r','y',' ','\x0f','a',' ','b','o','o','t',' ','\xe7','\xdd','\x0b','e','m','p','t','y','.',
/* 0x117be = "VERR_IOM_MMIO_HANDLER_DISASM_ERROR" */
    '\x01','I','O','M','_','\xd4','_','H','A','N','D','L','E','R','_','D','I','S','A','S','M','_','\x1c',
/* 0x117d5 = "VFS chain element takes a file object as input." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','a',' ','\x22','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x117ec = "VERR_HARDAVL_STACK_OVERFLOW" */
    '\x01','H','A','R','D','A','V','L','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x11803 = "VINF_EM_RAW_INTERRUPT_HYPER" */
    '\x0e','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','H','Y','P','E','R',
/* 0x1181a = "The attribute type did not match." */
    '\x03','a','t','t','r','i','b','u','t','e',' ','\xf3','d','i','d',' ','\x07','m','a','t','c','h','.',
/* 0x11831 = "VERR_PDM_DEV_HEAP_R3_TO_GCPHYS" */
    '\x01','\x7d','D','E','V','_','H','E','A','P','_','R','3','_','T','O','_','G','C','P','H','Y','S',
/* 0x11848 = "Too deep ICB recursion." */
    'T','o','o',' ','d','e','e','p',' ','I','C','B',' ','r','e','c','u','r','s','i','o','n','.',
/* 0x1185f = "VERR_SUP_VP_SET_HANDLE_NOINHERIT" */
    '\x01','\x95','\xbd','S','E','T','_','H','A','N','D','L','E','_','N','O','I','N','H','E','R','I','T',
/* 0x11876 = "VERR_PDM_CRITSECTRW_MISALIGNED" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','M','I','S','A','L','I','G','N','E','D',
/* 0x1188d = "Inserting a new chunk failed." */
    'I','n','s','e','r','t','i','n','g',' ','a',' ','n','e','w',' ','c','h','u','n','k',' ','\x7b',
/* 0x118a4 = "The field contains an invalid padding size." */
    '\x03','f','i','e','l','d',' ','\x8a','\x87','\x8f','p','a','d','d','i','n','g',' ','s','i','z','e','.',
/* 0x118bb = "Temporary place holder." */
    'T','e','m','p','o','r','a','r','y',' ','p','l','a','c','e',' ','h','o','l','d','e','r','.',
/* 0x118d2 = "Stream could not be created." */
    'S','t','r','e','a','m',' ','c','o','u','l','d',' ','\x07','\xa4','c','r','e','a','t','e','d','.',
/* 0x118e9 = "VINF_PGM_SYNCPAGE_MODIFIED_PDE" */
    '\x0e','\x8c','S','Y','N','C','P','A','G','E','_','M','O','D','I','F','I','E','D','_','P','D','E',
/* 0x11900 = "The command has already been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\x5c','\x80','\xcd','r','e','g','i','s','t','e','r','e','d','.',
/* 0x11917 = "VERR_BIGNUM_SENSITIVE_INPUT" */
    '\x01','B','I','G','N','U','M','_','S','E','N','S','I','T','I','V','E','_','I','N','P','U','T',
/* 0x1192e = "VINF_SSM_VOTE_FOR_ANOTHER_PASS" */
    '\x0e','\xb0','V','O','T','E','_','F','O','R','_','A','N','O','T','H','E','R','_','P','A','S','S',
/* 0x11945 = "Reason for leaving RZ: Pending MMIO write." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','\xd4',' ','w','r','i','t','e','.',
/* 0x1195c = "Error formatting an extension." */
    '\xc1','f','o','r','m','a','t','t','i','n','g',' ','\x87','e','x','t','e','n','s','i','o','n','.',
/* 0x11973 = "VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','\x06','A','D','J','A','C','E','N','T',
/* 0x1198a = "Invalid offset in an L4 dataspace." */
    '\x0c','o','f','f','s','e','t',' ','\x0f','\x87','L','4',' ','d','a','t','a','s','p','a','c','e','.',
/* 0x119a1 = "Duplicate segment name." */
    'D','u','p','l','i','c','a','t','e',' ','s','e','g','m','e','n','t',' ','n','a','m','e','.',
/* 0x119b8 = "VERR_IOM_INCOMPLETE_MMIO_RANGE" */
    '\x01','I','O','M','_','I','N','C','O','M','P','L','E','T','E','_','\xd4','_','R','A','N','G','E',
/* 0x119cf = "VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','\xaa','O','R','_','I','O','S','_','O','R','_','D','I','R',
/* 0x119e6 = "The driver doesn't support runtime driver attaching." */
    '\x03','\xc7','\xc9','\xd0','r','u','n','t','i','m','e',' ','\xc7','a','t','t','a','c','h','i','n','g','.',
/* 0x119fd = "Import ISO contains a bad root directory record." */
    '\xc4','\xc2',' ','\x8a','a',' ','b','a','d',' ','r','o','o','t',' ','\x25','r','e','c','o','r','d','.',
/* 0x11a14 = "VERR_NET_ADDRESS_NOT_AVAILABLE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x11a2b = "Certificate path validator: The certificate is not valid at the specified time." */
    '\xba','\xd2','\xff','\x03','\xa0','\x0b','\x07','v','a','l','i','d',' ','a','t',' ','\x02','\x18','t','i','m','e','.',
/* 0x11a42 = "The device doesn't support runtime driver attaching." */
    '\x03','\xa3','\xc9','\xd0','r','u','n','t','i','m','e',' ','\xc7','a','t','t','a','c','h','i','n','g','.',
/* 0x11a59 = "VERR_CR_CIPHER_OSSL_GET_TAG_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','G','E','T','_','T','A','G','_','\x17',
/* 0x11a70 = "VERR_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x01','\x24','\xbf','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x11a87 = "VERR_MANIFEST_WRONG_FILE_FORMAT" */
    '\x01','M','A','N','I','F','E','S','T','_','W','R','O','N','G','_','\xaa','F','O','R','M','A','T',
/* 0x11a9e = "VERR_CR_X509_CPV_NO_PERMITTED_NAMES" */
    '\x01','\x24','\xb7','C','P','V','_','\x60','P','E','R','M','I','T','T','E','D','_','N','A','M','E','S',
/* 0x11ab5 = "The machine is not on the network." */
    '\x03','m','a','c','h','i','n','e',' ','\x0b','\x07','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x11acc = "VINF_EM_DBG_HYPER_ASSERTION" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','A','S','S','E','R','T','I','O','N',
/* 0x11ae3 = "Hit the a VM account limit." */
    'H','i','t',' ','\x02','a',' ','\xc6',' ','a','c','c','o','u','n','t',' ','l','i','m','i','t','.',
/* 0x11afa = "Process Purification Failure: KERNE32." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','K','E','R','N','E','3','2','.',
/* 0x11b11 = "VERR_OUT_OF_SELECTOR_BOUNDS" */
    '\x01','O','U','T','_','O','F','_','S','E','L','E','C','T','O','R','_','B','O','U','N','D','S',
/* 0x11b28 = "No parent node specified." */
    '\xe0','p','a','r','e','n','t',' ','n','o','d','e',' ','s','p','e','c','i','f','i','e','d','.',
/* 0x11b3f = "VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY" */
    '\x01','S','Y','S','_','\x1a','F','I','R','M','W','A','R','E','_','P','R','O','P','E','R','T','Y',
/* 0x11b56 = "VFS chain element takes exactly six arguments." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','s','i','x',' ','\xde',
/* 0x11b6d = "VERR_DBG_FILE_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','\xaa','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x11b84 = "Device or resource is busy." */
    'D','e','v','i','c','e',' ','\xa9','r','e','s','o','u','r','c','e',' ','\x0b','b','u','s','y','.',
/* 0x11b9b = "VERR_SUPDRV_HARDENING_EVIL_HANDLE" */
    '\x01','\x90','H','A','R','D','E','N','I','N','G','_','E','V','I','L','_','H','A','N','D','L','E',
/* 0x11bb2 = "VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH" */
    '\x01','\x24','\xb7','C','E','R','T','_','T','B','S','_','S','I','G','N','_','A','L','G','O','_','\x19',
/* 0x11bc9 = "Unsupported key encryption cipher." */
    '\x98','k','e','y',' ','e','n','c','r','y','p','t','i','o','n',' ','c','i','p','h','e','r','.',
/* 0x11be0 = "VERR_SUP_VP_WINTRUST_CAT_FAILURE" */
    '\x01','\x95','\xbd','W','I','N','T','R','U','S','T','_','C','A','T','_','F','A','I','L','U','R','E',
/* 0x11bf7 = "VERR_VRDP_INSUFFICIENT_DATA" */
    '\x01','V','R','D','P','_','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A',
/* 0x11c0e = "No end of central directory record found." */
    '\xe0','e','n','d',' ','\x15','c','e','n','t','r','a','l',' ','\x25','r','e','c','o','r','d',' ','\x89',
/* 0x11c25 = "VERR_GIM_DEVICE_NOT_REGISTERED" */
    '\x01','G','I','M','_','D','E','V','I','C','E','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x11c3c = "VERR_CR_CIPHER_OSSL_SET_TAG_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','S','E','T','_','T','A','G','_','\x17',
/* 0x11c53 = "VERR_NET_CONNECTION_REFUSED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','F','U','S','E','D',
/* 0x11c6a = "Error creating digest algorithm calculator." */
    '\xc1','c','r','e','a','t','i','n','g',' ','\xd8','\xd5','c','a','l','c','u','l','a','t','o','r','.',
/* 0x11c81 = "VERR_LDRPE_CERT_UNSUPPORTED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x11c98 = "Client limit has been reached." */
    'C','l','i','e','n','t',' ','l','i','m','i','t',' ','\x5c','\xcd','r','e','a','c','h','e','d','.',
/* 0x11caf = "Authentication failure." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','f','a','i','l','u','r','e','.',
/* 0x11cc6 = "VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB" */
    '\x01','\x1f','\x82','L','O','G','I','C','A','L','_','B','L','O','C','K','_','\xfa','_','\x06','2','K','B',
/* 0x11cdd = "VERR_SUP_VP_SECTION_PROTECTION_MISMATCH" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','P','R','O','T','E','C','T','I','O','N','_','\x19',
/* 0x11cf4 = "iSCSI: Invalid device type (not a disk)." */
    'i','S','C','S','I',':',' ','\x0c','\xa3','\xf3','(','n','o','t',' ','a',' ','d','i','s','k',')','.',
/* 0x11d0b = "VMDK: Image property not found." */
    'V','M','D','K',':',' ','I','m','a','g','e',' ','p','r','o','p','e','r','t','y',' ','\x07','\x89',
/* 0x11d22 = "VERR_GSTCTL_PROCESS_WRONG_STATE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','W','R','O','N','G','_','\xf1',
/* 0x11d39 = "The loaded XSAVE header is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','\xb4','\x0b','\x07','v','a','l','i','d','.',
/* 0x11d50 = "The loaded XCR0 register value is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','C','R','0',' ','\xeb','\xf5','\x0b','\x07','v','a','l','i','d','.',
/* 0x11d67 = "VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET" */
    '\x01','V','M','M','_','F','N','_','\x06','\x83','_','F','O','R','_','V','M','T','A','R','G','E','T',
/* 0x11d7e = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','\xb6','_','N','M','_','\x1c',
/* 0x11d95 = "Bad VTG probe descriptor." */
    '\x9f','V','T','G',' ','p','r','o','b','e',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x11dab = "VERR_PDM_INVALID_DEVICE_REGISTRATION" */
    '\x01','\x7d','\x05','D','E','V','I','C','E','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x11dc1 = "VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','\x1b','\xac','W','R','I','T','E','R','S',
/* 0x11dd7 = "VERR_CR_MALFORMED_PEM_HEADER" */
    '\x01','\x24','M','A','L','F','O','R','M','E','D','_','P','E','M','_','H','E','A','D','E','R',
/* 0x11ded = "VINF_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x0e','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x11e03 = "Nested paging not active." */
    'N','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x07','a','c','t','i','v','e','.',
/* 0x11e19 = "VERR_INCONSISTENT_VM_HANDLE" */
    '\x01','I','N','C','O','N','S','I','S','T','E','N','T','_','\xc6','_','H','A','N','D','L','E',
/* 0x11e2f = "Invalid executable signature." */
    '\x0c','e','x','e','c','u','t','a','b','l','e',' ','s','i','g','n','a','t','u','r','e','.',
/* 0x11e45 = "VERR_IPC_RECEIVE_CANCELLED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','C','A','N','C','E','L','L','E','D',
/* 0x11e5b = "Guest side reported an error." */
    'G','u','e','s','t',' ','s','i','d','e',' ','r','e','p','o','r','t','e','d',' ','\x87','\x85',
/* 0x11e71 = "VERR_PDM_NO_REGISTRATION_EXPORT" */
    '\x01','\x7d','\x60','R','E','G','I','S','T','R','A','T','I','O','N','_','E','X','P','O','R','T',
/* 0x11e87 = "VERR_SSM_LIVE_GURU_MEDITATION" */
    '\x01','\xb0','L','I','V','E','_','G','U','R','U','_','M','E','D','I','T','A','T','I','O','N',
/* 0x11e9d = "Invalid argument to VFS chain element." */
    '\x0c','a','r','g','u','m','e','n','t',' ','\x0a','\x8d',' ','\xa1','e','l','e','m','e','n','t','.',
/* 0x11eb3 = "VERR_TRPM_SHADOW_IDT_WRITE" */
    '\x01','T','R','P','M','_','S','H','A','D','O','W','_','I','D','T','_','W','R','I','T','E',
/* 0x11ec9 = "Bad digest length encountered in the table of content." */
    '\x9f','\xd8','l','e','n','g','t','h',' ','\xaf','\x0f','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x11edf = "VERR_SELM_SHADOW_GDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','G','D','T','_','W','R','I','T','E',
/* 0x11ef5 = "VERR_THREAD_IS_TERMINATING" */
    '\x01','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x11f0b = "VERR_FDT_DTB_HDR_SIZE_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','\xfa','_','I','N','V','A','L','I','D',
/* 0x11f21 = "VERR_CPUM_HIDDEN_CS_LOAD_ERROR" */
    '\x01','C','P','U','M','_','H','I','D','D','E','N','_','C','S','_','L','O','A','D','_','\x1c',
/* 0x11f37 = "VERR_VFS_CHAIN_AT_MOST_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x11f4d = "The symbol is not a forwarder." */
    '\x03','s','y','m','b','o','l',' ','\x0b','\x07','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x11f63 = "VERR_PROC_NO_ARG_TRANSLATION" */
    '\x01','P','R','O','C','_','\x60','A','R','G','_','T','R','A','N','S','L','A','T','I','O','N',
/* 0x11f79 = "VERR_CR_KEY_TOO_SHORT_CIPHER_IV" */
    '\x01','\x24','K','E','Y','_','\x1b','S','H','O','R','T','_','C','I','P','H','E','R','_','I','V',
/* 0x11f8f = "VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED" */
    '\x01','\x95','\xbd','U','N','M','A','P','_','A','N','D','_','P','R','O','T','E','C','T','_','\x17',
/* 0x11fa5 = "Internal processing error related to guest mappings." */
    '\x08','\x04','\x09','r','e','l','a','t','e','d',' ','\x0a','\xbb','m','a','p','p','i','n','g','s','.',
/* 0x11fbb = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2" */
    '\x01','\x90','\x06','B','U','D','D','I','N','G','_','\xc6','_','P','R','O','C','E','S','S','_','2',
/* 0x11fd1 = "The MMIO range specified for removal was not found." */
    '\x03','\xd4',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','\x11','\x07','\x89',
/* 0x11fe7 = "VINF_PATM_CHECK_PATCH_PAGE" */
    '\x0e','P','A','T','M','_','C','H','E','C','K','_','P','A','T','C','H','_','P','A','G','E',
/* 0x11ffd = "VERR_CR_X509_CPV_MAX_PATH_LENGTH" */
    '\x01','\x24','\xb7','C','P','V','_','M','A','X','_','P','A','T','H','_','L','E','N','G','T','H',
/* 0x12013 = "RTCache: cache is empty." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x0b','e','m','p','t','y','.',
/* 0x12029 = "File or directory can\'t be created." */
    'F','i','l','e',' ','\xa9','\x25','c','a','n','\'','t',' ','\xa4','c','r','e','a','t','e','d','.',
/* 0x1203f = "Library was not initialized." */
    'L','i','b','r','a','r','y',' ','\x11','\x07','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x12055 = "VERR_CR_X509_CPV_NAME_NOT_PERMITTED" */
    '\x01','\x24','\xb7','C','P','V','_','N','A','M','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x1206b = "Path to child node was invalid (i." */
    'P','a','t','h',' ','\x0a','c','h','i','l','d',' ','n','o','d','e',' ','\x11','\x8f','(','i','.',
/* 0x12081 = "VERR_EM_RAW_PATCH_CONFLICT" */
    '\x01','E','M','_','R','A','W','_','P','A','T','C','H','_','C','O','N','F','L','I','C','T',
/* 0x12097 = "VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR" */
    '\x01','\x1f','\x82','Z','E','R','O','_','S','I','Z','E','D','_','R','O','O','T','_','D','I','R',
/* 0x120ad = "The guest has reported too many modules." */
    '\x03','\xbb','\x5c','r','e','p','o','r','t','e','d',' ','\x9e','\xb5','m','o','d','u','l','e','s','.',
/* 0x120c3 = "VERR_WRONG_PARAMETER_COUNT" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','C','O','U','N','T',
/* 0x120d9 = "Not an integer property." */
    'N','o','t',' ','\x87','i','n','t','e','g','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x120ef = "VERR_SELM_SHADOW_LDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','L','D','T','_','W','R','I','T','E',
/* 0x12105 = "VERR_POLL_HANDLE_NOT_POLLABLE" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','\x06','P','O','L','L','A','B','L','E',
/* 0x1211b = "VERR_CR_X509_TBSCERT_EXTS_REQ_V3" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','E','X','T','S','_','R','E','Q','_','V','3',
/* 0x12131 = "VERR_VFS_CHAIN_EXPECTED_SEPARATOR" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','S','E','P','A','R','A','T','O','R',
/* 0x12147 = "Can\'t assign requested address." */
    'C','a','n','\'','t',' ','a','s','s','i','g','n',' ','\xdf','a','d','d','r','e','s','s','.',
/* 0x1215d = "Reason for leaving RZ: I/O port write." */
    '\x93','\x10','\x81','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x12173 = "VINF_EM_RAW_STALE_SELECTOR" */
    '\x0e','E','M','_','R','A','W','_','S','T','A','L','E','_','S','E','L','E','C','T','O','R',
/* 0x12189 = "VERR_CANT_DELETE_DIRECTORY" */
    '\x01','C','A','N','T','_','D','E','L','E','T','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x1219f = "VERR_ASN1_NO_CHECK_SANITY_METHOD" */
    '\x01','\xa2','\x60','C','H','E','C','K','_','S','A','N','I','T','Y','_','M','E','T','H','O','D',
/* 0x121b5 = "VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','R','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x121cb = "Attempt to divide by zero." */
    'A','t','t','e','m','p','t',' ','\x0a','d','i','v','i','d','e',' ','\xdb','z','e','r','o','.',
/* 0x121e1 = "VERR_SHCLPB_TRANSFER_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','T','R','A','N','S','F','E','R','_','I','D','_','\x06','\x40',
/* 0x121f7 = "VERR_ISOFS_BOGUS_NEXT_AD_LENGTH" */
    '\x01','\x97','B','O','G','U','S','_','N','E','X','T','_','A','D','_','L','E','N','G','T','H',
/* 0x1220d = "RTGetOpt: Not an option." */
    'R','T','G','e','t','O','p','t',':',' ','N','o','t',' ','\x87','o','p','t','i','o','n','.',
/* 0x12223 = "Async command pending." */
    'A','s','y','n','c',' ','c','o','m','m','a','n','d',' ','p','e','n','d','i','n','g','.',
/* 0x12239 = "VINF_THREAD_IS_TERMINATING" */
    '\x0e','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x1224f = "VERR_VD_PASSWORD_INCORRECT" */
    '\x01','V','D','_','P','A','S','S','W','O','R','D','_','I','N','C','O','R','R','E','C','T',
/* 0x12265 = "VERR_GIM_NO_DEBUG_CONNECTION" */
    '\x01','G','I','M','_','\x60','D','E','B','U','G','_','C','O','N','N','E','C','T','I','O','N',
/* 0x1227b = "VERR_CPUM_INVALID_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','\x05','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x12291 = "VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND" */
    '\x01','\x24','\xe5','S','I','G','N','E','D','_','D','A','T','A','_','C','E','R','T','_','\x06','\x40',
/* 0x122a7 = "I/O ports are not mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x07','m','a','p','p','e','d','.',
/* 0x122bd = "VERR_PDM_INVALID_DRIVER_REGISTRATION" */
    '\x01','\x7d','\x05','D','R','I','V','E','R','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x122d3 = "VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO" */
    '\x01','H','M','_','\x1a','C','P','U','_','F','E','A','T','U','R','E','_','C','O','M','B','O',
/* 0x122e9 = "VERR_SVM_UNABLE_TO_START_VM" */
    '\x01','S','V','M','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xc6',
/* 0x122ff = "VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\x95','\xbd','R','E','P','L','A','C','E','_','V','I','R','T','U','A','L','_','\xb6','_','\x17',
/* 0x12315 = "VINF_PATM_HC_MMIO_PATCH_WRITE" */
    '\x0e','P','A','T','M','_','H','C','_','\xd4','_','P','A','T','C','H','_','W','R','I','T','E',
/* 0x1232b = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1" */
    '\x01','\x90','\x06','B','U','D','D','I','N','G','_','\xc6','_','P','R','O','C','E','S','S','_','1',
/* 0x12341 = "VERR_VUSB_USBFS_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','F','S','_','P','E','R','M','I','S','S','I','O','N',
/* 0x12357 = "VERR_LDRLX_BAD_LOADER_SECTION" */
    '\x01','L','D','R','L','X','_','\x1d','L','O','A','D','E','R','_','S','E','C','T','I','O','N',
/* 0x1236d = "The server does not support the requested function." */
    '\x03','s','e','r','v','e','r',' ','\xb2','\x07','\xd0','\x02','\xdf','f','u','n','c','t','i','o','n','.',
/* 0x12383 = "VERR_POLL_HANDLE_ID_EXISTS" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','E','X','I','S','T','S',
/* 0x12399 = "VERR_VMM_SMAP_BUT_AC_CLEAR" */
    '\x01','V','M','M','_','S','M','A','P','_','B','U','T','_','A','C','_','C','L','E','A','R',
/* 0x123af = "No unwind information was found." */
    '\xe0','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x11','\x89',
/* 0x123c5 = "Codec initialization failed." */
    'C','o','d','e','c',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x123db = "VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN" */
    '\x01','\x24','\xb7','C','P','V','_','\xc5','_','K','E','Y','_','C','E','R','T','_','S','I','G','N',
/* 0x123f1 = "VERR_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x12407 = "Invalid file mode mask (RTFMODE)." */
    '\x0c','\x22','m','o','d','e',' ','m','a','s','k',' ','(','R','T','F','M','O','D','E',')','.',
/* 0x1241d = "VERR_CR_SPC_PEIMAGE_NO_CONTENT" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','\x60','C','O','N','T','E','N','T',
/* 0x12433 = "The table of content isn\'t valid UTF-8." */
    '\x03','\xb1','\x15','\xf0','i','s','n','\'','t',' ','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x12449 = "Process Verification Failure: Error allocating memory." */
    '\x1e','\x0d','\x12','\xc1','a','l','l','o','c','a','t','i','n','g',' ','m','e','m','o','r','y','.',
/* 0x1245f = "VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x12475 = "Wrong JSON type for integer value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','i','n','t','e','g','e','r',' ','\xe8',
/* 0x1248b = "VINF_IOM_R3_MMIO_COMMIT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd4','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x124a1 = "VERR_CR_X509_CPV_INVALID_POLICY_MAPPING" */
    '\x01','\x24','\xb7','C','P','V','_','\x05','P','O','L','I','C','Y','_','M','A','P','P','I','N','G',
/* 0x124b7 = "VERR_VMX_X86_CR4_VMXE_CLEARED" */
    '\x01','\xe2','X','8','6','_','C','R','4','_','V','M','X','E','_','C','L','E','A','R','E','D',
/* 0x124cd = "Wrong parameter count." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','c','o','u','n','t','.',
/* 0x124e3 = "VERR_IPE_UNINITIALIZED_STATUS" */
    '\x01','\x14','U','N','I','N','I','T','I','A','L','I','Z','E','D','_','S','T','A','T','U','S',
/* 0x124f9 = "Syntax error - unbalanced quotes." */
    '\xfb','\x09','-',' ','u','n','b','a','l','a','n','c','e','d',' ','q','u','o','t','e','s','.',
/* 0x1250f = "VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY" */
    '\x01','\x1f','B','O','O','T','_','C','A','T','_','E','M','P','T','Y','_','E','N','T','R','Y',
/* 0x12525 = "VERR_PDM_HPET_LEGACY_NOTIFY_MISSING" */
    '\x01','\x7d','H','P','E','T','_','L','E','G','A','C','Y','_','N','O','T','I','F','Y','_','\xc5',
/* 0x1253b = "VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','F','A','M','I','L','Y','_','\x06','\x83',
/* 0x12551 = "VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x12567 = "VERR_SUP_VP_NO_IMAGE_MAPPING_NAME" */
    '\x01','\x95','\xbd','\x60','I','M','A','G','E','_','M','A','P','P','I','N','G','_','N','A','M','E',
/* 0x1257d = "VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW" */
    '\x01','\xf4','\xce','H','A','S','H','_','T','A','B','_','\xfa','_','O','V','E','R','F','L','O','W',
/* 0x12593 = "VERR_HARDAVL_BAD_RIGHT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','R','I','G','H','T','_','H','E','I','G','H','T',
/* 0x125a9 = "The page to be freed or updated was not found." */
    '\x03','\xbe','\x0a','\xa4','f','r','e','e','d',' ','\xa9','u','p','d','a','t','e','d',' ','\x11','\x07','\x89',
/* 0x125bf = "VERR_VFS_CHAIN_TRAILING_SEPARATOR" */
    '\x01','\x8d','_','\x8e','T','R','A','I','L','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x125d5 = "The value was zero extended to fit." */
    '\x03','\xf5','\x11','z','e','r','o',' ','e','x','t','e','n','d','e','d',' ','\x0a','f','i','t','.',
/* 0x125eb = "I/O ports are already mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x80','m','a','p','p','e','d','.',
/* 0x12601 = "VINF_EM_HM_PATCH_TPR_INSTR" */
    '\x0e','E','M','_','H','M','_','P','A','T','C','H','_','T','P','R','_','I','N','S','T','R',
/* 0x12617 = "The component factory was not found." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','y',' ','\x11','\x07','\x89',
/* 0x1262d = "VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS" */
    '\x01','P','A','T','H','_','G','L','O','B','_','\x91','C','H','A','R','_','C','L','A','S','S',
/* 0x12643 = "VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE" */
    '\x01','\xe2','\x88','I','N','T','E','R','R','U','P','T','I','O','N','_','E','X','I','T','_','\xb3',
/* 0x12659 = "VERR_HM_NO_32_TO_64_SWITCHER" */
    '\x01','H','M','_','\x60','3','2','_','T','O','_','6','4','_','S','W','I','T','C','H','E','R',
/* 0x1266f = "VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID" */
    '\x01','\x1f','\x82','B','O','O','T','_','C','A','T','_','\x91','H','E','A','D','E','R','_','I','D',
/* 0x12685 = "VERR_XAR_BAD_CHECKSUM_ELEMENT" */
    '\x01','X','A','R','_','\x1d','C','H','E','C','K','S','U','M','_','E','L','E','M','E','N','T',
/* 0x1269b = "VERR_SUP_VP_EMPTY_REGION_TOO_LARGE" */
    '\x01','\x95','\xbd','E','M','P','T','Y','_','R','E','G','I','O','N','_','\x1b','L','A','R','G','E',
/* 0x126b1 = "The saved state directory magic is wrong." */
    '\x03','s','a','v','e','d',' ','\xcc','\x25','m','a','g','i','c',' ','\x0b','w','r','o','n','g','.',
/* 0x126c7 = "Expected a different time tag." */
    '\xb8','a',' ','d','i','f','f','e','r','e','n','t',' ','t','i','m','e',' ','t','a','g','.',
/* 0x126dd = "VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS" */
    '\x01','\x24','\xe5','S','I','G','N','E','D','_','D','A','T','A','_','\x60','\xbf','A','L','G','O','S',
/* 0x126f3 = "Is a character device." */
    'I','s',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','d','e','v','i','c','e','.',
/* 0x12709 = "VINF_VRDP_RESIZE_REQUESTED" */
    '\x0e','V','R','D','P','_','R','E','S','I','Z','E','_','R','E','Q','U','E','S','T','E','D',
/* 0x1271f = "Unable to switch due to invalid guest state." */
    '\xe1','\x0a','s','w','i','t','c','h',' ','d','u','e',' ','\x0a','\x8f','\xbb','s','t','a','t','e','.',
/* 0x12735 = "VERR_GMM_MODULE_NAME_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','N','A','M','E','_','\x1b','L','O','N','G',
/* 0x1274b = "VERR_PDM_CRITSECTRW_TOO_MANY_READERS" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','\x1b','\xac','R','E','A','D','E','R','S',
/* 0x12761 = "VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','M','M','I','O','2','_','R','A','N','G','E','_','\x06','\x40',
/* 0x12777 = "VERR_VUSB_DEVICE_NOT_ATTACHED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','\x06','A','T','T','A','C','H','E','D',
/* 0x1278d = "Failed to lock the address range." */
    '\x8b','\x0a','l','o','c','k',' ','\x02','a','d','d','r','e','s','s',' ','r','a','n','g','e','.',
/* 0x127a3 = "VERR_DWARF_STACK_UNDERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','U','N','D','E','R','F','L','O','W',
/* 0x127b9 = "Internal ISO maker error: Buffer size." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','B','u','f','f','e','r',' ','s','i','z','e','.',
/* 0x127cf = "More data available in pipe." */
    'M','o','r','e',' ','\x9d','a','v','a','i','l','a','b','l','e',' ','\x0f','p','i','p','e','.',
/* 0x127e5 = "VWRN_ENV_NOT_FULLY_TRANSLATED" */
    '\xe6','E','N','V','_','\x06','F','U','L','L','Y','_','T','R','A','N','S','L','A','T','E','D',
/* 0x127fb = "The device instance structure version has changed." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','\xec','\xd1','\x5c','c','h','a','n','g','e','d','.',
/* 0x12811 = "VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','\x1b','\xac','P','R','O','B','E','S',
/* 0x12827 = "The driver instance structure version has changed." */
    '\x03','\xc7','i','n','s','t','a','n','c','e',' ','\xec','\xd1','\x5c','c','h','a','n','g','e','d','.',
/* 0x1283d = "The USB hub is already registered." */
    '\x03','U','S','B',' ','h','u','b',' ','\x0b','\x80','r','e','g','i','s','t','e','r','e','d','.',
/* 0x12853 = "VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS" */
    '\x01','I','O','M','_','\x1b','\xac','\xd4','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x12869 = "The trace log is malformed." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x1287f = "VINF_EM_EMULATE_SPLIT_LOCK" */
    '\x0e','E','M','_','E','M','U','L','A','T','E','_','S','P','L','I','T','_','L','O','C','K',
/* 0x12895 = "VMDK: Invalid write position." */
    'V','M','D','K',':',' ','\x0c','w','r','i','t','e',' ','p','o','s','i','t','i','o','n','.',
/* 0x128ab = "VERR_VMX_INVALID_VMCS_PTR_TO_START_VM" */
    '\x01','\xe2','\x05','V','M','C','S','_','P','T','R','_','T','O','_','S','T','A','R','T','_','\xc6',
/* 0x128c1 = "VINF_SVM_INTERCEPT_NOT_ACTIVE" */
    '\x0e','S','V','M','_','I','N','T','E','R','C','E','P','T','_','\x06','A','C','T','I','V','E',
/* 0x128d7 = "Media not present in drive." */
    'M','e','d','i','a',' ','\x07','p','r','e','s','e','n','t',' ','\x0f','d','r','i','v','e','.',
/* 0x128ed = "VERR_DBGC_COMMANDS_NOT_REGISTERED" */
    '\x01','\xfd','C','O','M','M','A','N','D','S','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x12903 = "Unsupported image target architecture." */
    '\x98','\x26','t','a','r','g','e','t',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x12919 = "VERR_DBGC_PARSE_INVALD_COMMAND_NAME" */
    '\x01','\xfd','\xe4','I','N','V','A','L','D','_','C','O','M','M','A','N','D','_','N','A','M','E',
/* 0x1292f = "No attribute of the specified types was found." */
    '\xe0','a','t','t','r','i','b','u','t','e',' ','\x15','\x02','\x18','t','y','p','e','s',' ','\x11','\x89',
/* 0x12945 = "VERR_REST_RESPONSE_INVALID_UTF8_ENCODING" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','\x05','U','T','F','8','_','\xc8',
/* 0x1295b = "VERR_ASN1_OBJID_COMPONENT_TOO_BIG" */
    '\x01','\xa2','O','B','J','I','D','_','C','O','M','P','O','N','E','N','T','_','\x1b','B','I','G',
/* 0x12971 = "VERR_CR_PKIX_SIGNATURE_TOO_LONG" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x1b','L','O','N','G',
/* 0x12987 = "VERR_SELM_SHADOW_TSS_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','T','S','S','_','W','R','I','T','E',
/* 0x1299d = "The type of media was not recognized." */
    '\x03','\xf3','\x15','m','e','d','i','a',' ','\x11','\x07','r','e','c','o','g','n','i','z','e','d','.',
/* 0x129b3 = "Device i/o: Not ready." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','N','o','t',' ','r','e','a','d','y','.',
/* 0x129c9 = "VERR_JSON_MISSING_SURROGATE_PAIR" */
    '\x01','J','S','O','N','_','\xc5','_','S','U','R','R','O','G','A','T','E','_','P','A','I','R',
/* 0x129df = "Cannot block in ring-0." */
    'C','a','n','n','o','t',' ','b','l','o','c','k',' ','\x0f','r','i','n','g','-','0','.',
/* 0x129f4 = "VERR_VMM_WRONG_HM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','H','M','_','V','M','C','P','U','_','\xf1',
/* 0x12a09 = "Preemption is disabled." */
    'P','r','e','e','m','p','t','i','o','n',' ','\x0b','d','i','s','a','b','l','e','d','.',
/* 0x12a1e = "VERR_IOM_MMIO_REGION_NOT_MAPPED" */
    '\x01','I','O','M','_','\xd4','_','R','E','G','I','O','N','_','\x06','M','A','P','P','E','D',
/* 0x12a33 = "VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x12a48 = "VINF_EM_RAW_TIMER_PENDING" */
    '\x0e','E','M','_','R','A','W','_','T','I','M','E','R','_','P','E','N','D','I','N','G',
/* 0x12a5d = "VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE" */
    '\x01','\x1f','B','O','O','T','_','C','A','T','_','\x05','S','E','C','T','I','O','N','_','\xfa',
/* 0x12a72 = "The iprt loader recognized an a." */
    '\x03','i','p','r','t',' ','\xda','r','e','c','o','g','n','i','z','e','d',' ','\x87','a','.',
/* 0x12a87 = "VERR_LDR_ADDRESS_OVERFLOW" */
    '\x01','L','D','R','_','A','D','D','R','E','S','S','_','O','V','E','R','F','L','O','W',
/* 0x12a9c = "VERR_VD_RAW_SIZE_MODULO_2048" */
    '\x01','V','D','_','R','A','W','_','\xfa','_','M','O','D','U','L','O','_','2','0','4','8',
/* 0x12ab1 = "VINF_CPUM_MATCHED_BY_NAME" */
    '\x0e','C','P','U','M','_','M','A','T','C','H','E','D','_','B','Y','_','N','A','M','E',
/* 0x12ac6 = "Virtual HDD is not opened." */
    'V','i','r','t','u','a','l',' ','H','D','D',' ','\x0b','\x07','o','p','e','n','e','d','.',
/* 0x12adb = "VERR_HARDAVL_BAD_LEFT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','L','E','F','T','_','H','E','I','G','H','T',
/* 0x12af0 = "Geometry hasn\'t been set." */
    'G','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xcd','s','e','t','.',
/* 0x12b05 = "A module name is too long." */
    'A',' ','m','o','d','u','l','e',' ','n','a','m','e',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x12b1a = "The thread is terminating." */
    '\x03','t','h','r','e','a','d',' ','\x0b','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x12b2f = "VERR_LDRELF_RELOCATION_NOT_SUPPORTED" */
    '\x01','L','D','R','E','L','F','_','R','E','L','O','C','A','T','I','O','N','_','\x06','\x83',
/* 0x12b44 = "Import ISO contains more than volume." */
    '\xc4','\xc2',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','v','o','l','u','m','e','.',
/* 0x12b59 = "VERR_SUP_VP_UNDESIRABLE_MODULE" */
    '\x01','\x95','\xbd','U','N','D','E','S','I','R','A','B','L','E','_','M','O','D','U','L','E',
/* 0x12b6e = "VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD" */
    '\x01','\x97','\x1b','B','I','G','_','P','A','R','T','M','A','P','_','I','N','_','L','V','D',
/* 0x12b83 = "VERR_LDRPE_COM_DESCRIPTOR" */
    '\x01','L','D','R','P','E','_','C','O','M','_','D','E','S','C','R','I','P','T','O','R',
/* 0x12b98 = "VERR_LDRELF_INVALID_SYMBOL_INDEX" */
    '\x01','L','D','R','E','L','F','_','\x05','S','Y','M','B','O','L','_','I','N','D','E','X',
/* 0x12bad = "The configured driver wasn\'t found." */
    '\x03','c','o','n','f','i','g','u','r','e','d',' ','\xc7','w','a','s','n','\'','t',' ','\x89',
/* 0x12bc2 = "VERR_IEM_ASPECT_NOT_IMPLEMENTED" */
    '\x01','\x9c','A','S','P','E','C','T','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x12bd7 = "VINF_DRIVER_REBOOT_NEEDED" */
    '\x0e','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x12bec = "Operation already in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x80','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x12c01 = "VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE" */
    '\x01','\x8c','\x1a','S','H','A','D','O','W','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x12c16 = "Wrong parameter type." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','t','y','p','e','.',
/* 0x12c2b = "Recompiler: Bad segment register number for memory access." */
    '\x13','\x9f','s','e','g','m','e','n','t',' ','\xeb','\xfc','\x10','\x86','a','c','c','e','s','s','.',
/* 0x12c40 = "VERR_ISOFS_NO_DIRECT_ICB_ENTRIES" */
    '\x01','\x97','\x60','D','I','R','E','C','T','_','I','C','B','_','E','N','T','R','I','E','S',
/* 0x12c55 = "VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB" */
    '\x01','\x24','\xe5','\xc5','_','C','O','N','T','E','N','T','_','\xb3','_','A','T','T','R','I','B',
/* 0x12c6a = "VERR_CODE_POINT_SURROGATE" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','S','U','R','R','O','G','A','T','E',
/* 0x12c7f = "VERR_TCP_SERVER_DESTROYED" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x12c94 = "VERR_PGM_PHYS_TLB_UNASSIGNED" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','U','N','A','S','S','I','G','N','E','D',
/* 0x12ca9 = "The compressed table of content is too big." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\xb1','\x15','\xf0','\x0b','\x9e','b','i','g','.',
/* 0x12cbe = "No direct ICB entries found." */
    '\xe0','d','i','r','e','c','t',' ','I','C','B',' ','e','n','t','r','i','e','s',' ','\x89',
/* 0x12cd3 = "VERR_GMM_SHARED_MODULE_NOT_FOUND" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x06','\x40',
/* 0x12ce8 = "VERR_SUP_VP_STUB_THREAD_OPEN_ERROR" */
    '\x01','\x95','\xbd','S','T','U','B','_','T','H','R','E','A','D','_','O','P','E','N','_','\x1c',
/* 0x12cfd = "The signature is negative." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','n','e','g','a','t','i','v','e','.',
/* 0x12d12 = "Process Verification Failure: Bad virtual section address." */
    '\x1e','\x0d','\x12','\x9f','v','i','r','t','u','a','l',' ','\xdd','a','d','d','r','e','s','s','.',
/* 0x12d27 = "Object or array is empty." */
    'O','b','j','e','c','t',' ','\xa9','a','r','r','a','y',' ','\x0b','e','m','p','t','y','.',
/* 0x12d3c = "VERR_LDRPE_CERT_MALFORMED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','M','A','L','F','O','R','M','E','D',
/* 0x12d51 = "Current object state prohibits operation." */
    'C','u','r','r','e','n','t',' ','\xa8','\xcc','p','r','o','h','i','b','i','t','s',' ','\xea',
/* 0x12d66 = "VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING" */
    '\x01','\xa2','\x05','G','E','N','E','R','A','L','I','Z','E','D','_','T','I','M','E','_','\xc8',
/* 0x12d7b = "VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX" */
    '\x01','\x90','K','E','R','N','E','L','_','\x1b','O','L','D','_','F','O','R','_','V','T','X',
/* 0x12d90 = "VERR_VM_REQUEST_TOO_MANY_ARGS_IPE" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','\x1b','\xac','A','R','G','S','_','I','P','E',
/* 0x12da5 = "Encountered an unexpected VM state." */
    '\xa6','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xc6',' ','s','t','a','t','e','.',
/* 0x12dba = "Out of selector bounds." */
    'O','u','t',' ','\x15','s','e','l','e','c','t','o','r',' ','b','o','u','n','d','s','.',
/* 0x12dcf = "VINF_DBGF_TRUNCATED_REGISTER" */
    '\x0e','\xb9','_','T','R','U','N','C','A','T','E','D','_','R','E','G','I','S','T','E','R',
/* 0x12de4 = "VERR_SSM_FIELD_OUT_OF_BOUNDS" */
    '\x01','\xb0','F','I','E','L','D','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x12df9 = "Max threads number reached." */
    'M','a','x',' ','t','h','r','e','a','d','s',' ','\xfc','r','e','a','c','h','e','d','.',
/* 0x12e0e = "Process Verification Failure: The memory content does not match the image file." */
    '\x1e','\x0d','\x12','\x03','\x86','\xf0','\xb2','\x07','m','a','t','c','h',' ','\x02','\x26','f','i','l','e','.',
/* 0x12e23 = "Address translation failed." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x7b',
/* 0x12e38 = "VERR_UDP_SERVER_DESTROYED" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x12e4d = "No free output streams." */
    '\xe0','f','r','e','e',' ','o','u','t','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x12e62 = "VERR_PDM_ASYNC_TEMPLATE_BUSY" */
    '\x01','\x7d','A','S','Y','N','C','_','T','E','M','P','L','A','T','E','_','B','U','S','Y',
/* 0x12e77 = "VERR_GIM_INVALID_HYPERCALL_INSTR" */
    '\x01','G','I','M','_','\x05','H','Y','P','E','R','C','A','L','L','_','I','N','S','T','R',
/* 0x12e8c = "VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH" */
    '\x01','\x24','\xe5','C','O','N','T','E','N','T','_','\xb3','_','A','T','T','R','I','B','_','\x19',
/* 0x12ea1 = "VERR_FTP_DATA_CONN_INIT_FAILED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','I','N','I','T','_','\x17',
/* 0x12eb6 = "Certificate signature algorithm mismatch." */
    '\xba','s','i','g','n','a','t','u','r','e',' ','\xd5','m','i','s','m','a','t','c','h','.',
/* 0x12ecb = "VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','T','W','O','_','A','R','G','S',
/* 0x12ee0 = "VERR_LDRPE_GUARD_CF_STUFF" */
    '\x01','L','D','R','P','E','_','G','U','A','R','D','_','C','F','_','S','T','U','F','F',
/* 0x12ef5 = "Too long name string." */
    'T','o','o',' ','l','o','n','g',' ','n','a','m','e',' ','s','t','r','i','n','g','.',
/* 0x12f0a = "VERR_DBGF_READ_ONLY_REGISTER" */
    '\x01','\xb9','_','R','E','A','D','_','O','N','L','Y','_','R','E','G','I','S','T','E','R',
/* 0x12f1f = "VERR_PATH_MATCH_UNKNOWN_VARIABLE" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','\x91','V','A','R','I','A','B','L','E',
/* 0x12f34 = "VERR_GMM_TOO_MANY_GLOBAL_MODULES" */
    '\x01','G','M','M','_','\x1b','\xac','G','L','O','B','A','L','_','M','O','D','U','L','E','S',
/* 0x12f49 = "Import ISO contains a too deep directory subtree." */
    '\xc4','\xc2',' ','\x8a','a',' ','\x9e','d','e','e','p',' ','\x25','s','u','b','t','r','e','e','.',
/* 0x12f5e = "VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE" */
    '\x01','\x95','\xbd','E','X','E','_','\xc5','_','D','Y','N','A','M','I','C','_','B','A','S','E',
/* 0x12f73 = "VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3" */
    '\x01','\x1f','\xaa','\x1b','B','I','G','_','R','E','Q','_','\xc2','_','L','E','V','E','L','_','3',
/* 0x12f88 = "Reason for leaving RZ: Timer pending." */
    '\x93','\x10','\x81','R','Z',':',' ','T','i','m','e','r',' ','p','e','n','d','i','n','g','.',
/* 0x12f9d = "VERR_VD_READ_OUT_OF_RANGE" */
    '\x01','V','D','_','R','E','A','D','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x12fb2 = "VERR_DWARF_STACK_OVERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x12fc7 = "VERR_SERIALPORT_INVALID_BAUDRATE" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','\x05','B','A','U','D','R','A','T','E',
/* 0x12fdc = "VERR_IOMMU_ADDR_TRANSLATION_FAILED" */
    '\x01','\xfe','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','\x17',
/* 0x12ff1 = "Invalid GC physical address." */
    '\x0c','G','C',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x13006 = "HTTP initialization failed." */
    'H','T','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x1301b = "Syntax error - expected binary operator." */
    '\xfb','\x09','-',' ','\xcb','b','i','n','a','r','y',' ','o','p','e','r','a','t','o','r','.',
/* 0x13030 = "Process Verification Failure: Error reading image file header." */
    '\x1e','\x0d','\x12','\xc1','r','e','a','d','i','n','g',' ','\x26','\x22','h','e','a','d','e','r','.',
/* 0x13045 = "VERR_GIM_PVTSC_NOT_AVAILABLE" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1305a = "VERR_RECORDING_RESTRICTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','R','E','S','T','R','I','C','T','E','D',
/* 0x1306f = "Process Verification Failure: The process is being debugged." */
    '\x1e','\x0d','\x12','\x03','\x92','\x0b','b','e','i','n','g',' ','d','e','b','u','g','g','e','d','.',
/* 0x13084 = "Bad file group id for XAR file." */
    '\x9f','\x22','g','r','o','u','p',' ','i','d',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x13099 = "Saved state directory wintertides error." */
    'S','a','v','e','d',' ','\xcc','\x25','w','i','n','t','e','r','t','i','d','e','s',' ','\x85',
/* 0x130ae = "VERR_CR_KEY_MISSING_CIPHER_PARAMS" */
    '\x01','\x24','K','E','Y','_','\xc5','_','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x130c3 = "Process Verification Failure: Error closing image file handle." */
    '\x1e','\x0d','\x12','\xc1','c','l','o','s','i','n','g',' ','\x26','\x22','h','a','n','d','l','e','.',
/* 0x130d8 = "VERR_RESERVED_PAGE_TABLE_BITS" */
    '\x01','R','E','S','E','R','V','E','D','_','\xce','T','A','B','L','E','_','B','I','T','S',
/* 0x130ed = "VERR_VD_PARALLELS_INVALID_HEADER" */
    '\x01','V','D','_','P','A','R','A','L','L','E','L','S','_','\x05','H','E','A','D','E','R',
/* 0x13102 = "VERR_NET_HOST_UNREACHABLE" */
    '\x01','N','E','T','_','H','O','S','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x13117 = "VINF_PGM_NO_DIRTY_BIT_TRACKING" */
    '\x0e','\x8c','\x60','D','I','R','T','Y','_','B','I','T','_','T','R','A','C','K','I','N','G',
/* 0x1312c = "VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO" */
    '\x01','\x1f','\x82','R','O','O','T','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x13141 = "VERR_IOM_MMIO_RANGE_CONFLICT" */
    '\x01','I','O','M','_','\xd4','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x13156 = "Unknown partition map entry type." */
    '\xef','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xca','t','y','p','e','.',
/* 0x1316b = "Expected a right parentheses." */
    '\xb8','a',' ','r','i','g','h','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x13180 = "VERR_VRDP_SEC_ENGINE_FAIL" */
    '\x01','V','R','D','P','_','S','E','C','_','E','N','G','I','N','E','_','F','A','I','L',
/* 0x13195 = "VERR_XAR_MISSING_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\xc5','_','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x131aa = "VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','V','I','R','T','U','A','L','_','\xfa',
/* 0x131bf = "VERR_PGM_PHYS_RAM_LOOKUP_IPE" */
    '\x01','\x8c','P','H','Y','S','_','R','A','M','_','L','O','O','K','U','P','_','I','P','E',
/* 0x131d4 = "VERR_HARDAVL_NODE_IS_FREE" */
    '\x01','H','A','R','D','A','V','L','_','N','O','D','E','_','I','S','_','F','R','E','E',
/* 0x131e9 = "One of the structure magics was wrong." */
    'O','n','e',' ','\x15','\x02','\xec','m','a','g','i','c','s',' ','\x11','w','r','o','n','g','.',
/* 0x131fe = "Failed to obtain a pool page." */
    '\x8b','\x0a','o','b','t','a','i','n',' ','a',' ','p','o','o','l',' ','p','a','g','e','.',
/* 0x13213 = "VERR_DRIVER_REBOOT_NEEDED" */
    '\x01','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x13228 = "VERR_VD_VDI_COMMENT_TOO_LONG" */
    '\x01','V','D','_','V','D','I','_','C','O','M','M','E','N','T','_','\x1b','L','O','N','G',
/* 0x1323d = "VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT" */
    '\x01','\x97','\x60','A','D','S','_','F','O','R','_','U','D','F','_','O','B','J','E','C','T',
/* 0x13252 = "VERR_XAR_MISSING_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\xc5','_','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x13267 = "VERR_ISOFS_TOO_DEEP_ICB_RECURSION" */
    '\x01','\x97','\x1b','D','E','E','P','_','I','C','B','_','R','E','C','U','R','S','I','O','N',
/* 0x1327c = "Wrong JSON type for double value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','d','o','u','b','l','e',' ','\xe8',
/* 0x13291 = "VERR_LDRLX_BAD_FIXUP_SECTION" */
    '\x01','L','D','R','L','X','_','\x1d','F','I','X','U','P','_','S','E','C','T','I','O','N',
/* 0x132a6 = "VFS chain element expected at least three arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','l','e','a','s','t',' ','t','h','r','e','e',' ','\xde',
/* 0x132bb = "VERR_NET_OUT_OF_RESOURCES" */
    '\x01','N','E','T','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x132d0 = "The file or directory is world writable (hardening)." */
    '\x03','\x22','\xa9','\x25','\x0b','w','o','r','l','d',' ','w','r','i','t','a','b','l','e',' ','\xae',
/* 0x132e5 = "VERR_VFS_CHAIN_LEADING_SEPARATOR" */
    '\x01','\x8d','_','\x8e','L','E','A','D','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x132fa = "VERR_CANT_RECODE_AS_UTF16" */
    '\x01','C','A','N','T','_','R','E','C','O','D','E','_','A','S','_','U','T','F','1','6',
/* 0x1330f = "Duplicate certificate extension." */
    'D','u','p','l','i','c','a','t','e',' ','\xa0','e','x','t','e','n','s','i','o','n','.',
/* 0x13324 = "VERR_EM_UNEXPECTED_MAPPING_CONFLICT" */
    '\x01','E','M','_','\x88','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x13339 = "VINF_PATM_HC_MMIO_PATCH_READ" */
    '\x0e','P','A','T','M','_','H','C','_','\xd4','_','P','A','T','C','H','_','R','E','A','D',
/* 0x1334e = "VERR_TAR_NUM_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','N','U','M','_','V','A','L','U','E','_','\x1b','L','A','R','G','E',
/* 0x13363 = "VERR_IOM_NO_R3_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x60','R','3','_','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x13378 = "VERR_VD_DMG_NOT_FOUND_INSIDE_XAR" */
    '\x01','V','D','_','D','M','G','_','\x06','\x40','_','I','N','S','I','D','E','_','X','A','R',
/* 0x1338d = "VERR_GMM_TOO_MANY_CHUNK_MAPPINGS" */
    '\x01','G','M','M','_','\x1b','\xac','C','H','U','N','K','_','M','A','P','P','I','N','G','S',
/* 0x133a2 = "APIC initialization failed." */
    'A','P','I','C',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x133b7 = "VERR_HARDAVL_LOOKUP_TOO_DEEP" */
    '\x01','H','A','R','D','A','V','L','_','L','O','O','K','U','P','_','\x1b','D','E','E','P',
/* 0x133cc = "VERR_VM_DRIVER_NOT_ACCESSIBLE" */
    '\x01','\xc6','_','D','R','I','V','E','R','_','\x06','A','C','C','E','S','S','I','B','L','E',
/* 0x133e1 = "VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','N','M','_','\x1c',
/* 0x133f6 = "VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL" */
    '\x01','\xa2','C','O','N','S','T','R','U','C','T','E','D','_','\xd6','_','\x06','I','M','P','L',
/* 0x1340b = "VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH" */
    '\x01','\x95','\xbd','E','X','E','_','V','S','_','P','R','O','C','_','N','A','M','E','_','\x19',
/* 0x13420 = "VERR_XAR_EXTRACTED_HASH_MISMATCH" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','H','A','S','H','_','\x19',
/* 0x13435 = "VERR_DBGC_PARSE_EXPECTED_BINARY_OP" */
    '\x01','\xfd','\xe4','E','X','P','E','C','T','E','D','_','B','I','N','A','R','Y','_','O','P',
/* 0x1344a = "VERR_IEM_RESTART_INSTRUCTION" */
    '\x01','\x9c','R','E','S','T','A','R','T','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x1345f = "Device i/o: Sector not found." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','S','e','c','t','o','r',' ','\x07','\x89',
/* 0x13474 = "Not implemented for UDF." */
    'N','o','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x10','U','D','F','.',
/* 0x13489 = "VERR_X509_NO_BASIC_CONSTARAINTS" */
    '\x01','\xb7','\x60','B','A','S','I','C','_','C','O','N','S','T','A','R','A','I','N','T','S',
/* 0x1349e = "VERR_GMM_BAD_SHARED_MODULE_SIZE" */
    '\x01','G','M','M','_','\x1d','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xfa',
/* 0x134b3 = "Syntax error - numeric overflow." */
    '\xfb','\x09','-',' ','n','u','m','e','r','i','c',' ','o','v','e','r','f','l','o','w','.',
/* 0x134c8 = "No data for this block in image." */
    '\xe0','\x9d','\x10','t','h','i','s',' ','b','l','o','c','k',' ','\x0f','i','m','a','g','e','.',
/* 0x134dd = "VERR_DBG_ADDRESS_CONFLICT" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x134f2 = "VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG" */
    '\x01','V','D','_','R','A','W','_','\xfa','_','F','L','O','P','P','Y','_','\x1b','B','I','G',
/* 0x13507 = "VERR_CR_X509_CPV_NOT_VALID_AT_TIME" */
    '\x01','\x24','\xb7','C','P','V','_','\x06','V','A','L','I','D','_','A','T','_','T','I','M','E',
/* 0x1351c = "Reason for leaving RZ: I/O port read." */
    '\x93','\x10','\x81','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','r','e','a','d','.',
/* 0x13531 = "VERR_PAGE_MAP_LEVEL4_NOT_PRESENT" */
    '\x01','\xce','M','A','P','_','L','E','V','E','L','4','_','\x06','P','R','E','S','E','N','T',
/* 0x13546 = "VERR_IOM_MMIO_REGION_ALREADY_MAPPED" */
    '\x01','I','O','M','_','\xd4','_','R','E','G','I','O','N','_','\x9b','M','A','P','P','E','D',
/* 0x1355b = "Page hash table size overflow." */
    'P','a','g','e',' ','h','a','s','h',' ','\xb1','\xf8','o','v','e','r','f','l','o','w','.',
/* 0x13570 = "VERR_PGM_PHYS_WR_HIT_HANDLER" */
    '\x01','\x8c','P','H','Y','S','_','W','R','_','H','I','T','_','H','A','N','D','L','E','R',
/* 0x13585 = "Network is unreachable." */
    'N','e','t','w','o','r','k',' ','\x0b','u','n','r','e','a','c','h','a','b','l','e','.',
/* 0x1359a = "VERR_PGM_MAPPINGS_FIX_TOO_SMALL" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','\x1b','S','M','A','L','L',
/* 0x135af = "Internal SPC error: The PE image data is missing." */
    '\x08','S','P','C',' ','\xd9','\x03','P','E',' ','\x26','\x9d','\x0b','m','i','s','s','i','n','g','.',
/* 0x135c4 = "VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT" */
    '\x01','\x8d','_','\x8e','\x1b','S','H','O','R','T','_','F','O','R','_','P','A','R','E','N','T',
/* 0x135d9 = "VERR_SVM_ILLEGAL_EFER_MSR" */
    '\x01','S','V','M','_','I','L','L','E','G','A','L','_','E','F','E','R','_','M','S','R',
/* 0x135ee = "VERR_IEM_COND_TOO_DEEPLY_NESTED" */
    '\x01','\x9c','C','O','N','D','_','\x1b','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x13603 = "VERR_AUDIO_BACKEND_INIT_FAILED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','I','N','I','T','_','\x17',
/* 0x13618 = "VERR_SUPLIB_WRITE_NON_SYS_GROUP" */
    '\x01','\xd7','W','R','I','T','E','_','N','O','N','_','S','Y','S','_','G','R','O','U','P',
/* 0x1362d = "Incorrect call order." */
    'I','n','c','o','r','r','e','c','t',' ','c','a','l','l',' ','o','r','d','e','r','.',
/* 0x13642 = "VERR_PGM_NO_HYPERVISOR_ADDRESS" */
    '\x01','\x8c','\x60','H','Y','P','E','R','V','I','S','O','R','_','A','D','D','R','E','S','S',
/* 0x13657 = "VERR_NO_MORE_SEARCH_HANDLES" */
    '\x01','\x60','M','O','R','E','_','S','E','A','R','C','H','_','H','A','N','D','L','E','S',
/* 0x1366c = "VINF_VD_ASYNC_IO_FINISHED" */
    '\x0e','V','D','_','A','S','Y','N','C','_','I','O','_','F','I','N','I','S','H','E','D',
/* 0x13681 = "VINF_HGCM_CLIENT_REJECTED" */
    '\x0e','H','G','C','M','_','C','L','I','E','N','T','_','R','E','J','E','C','T','E','D',
/* 0x13696 = "VERR_DBG_DUPLICATE_SYMBOL" */
    '\x01','D','B','G','_','D','U','P','L','I','C','A','T','E','_','S','Y','M','B','O','L',
/* 0x136ab = "Bad timestamp for XAR file." */
    '\x9f','t','i','m','e','s','t','a','m','p',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x136c0 = "VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xce','M','A','P','_','M','M','I','O','2','_','I','P','E',
/* 0x136d5 = "VINF_PARAV_SWITCH_TO_HOST" */
    '\x0e','P','A','R','A','V','_','S','W','I','T','C','H','_','T','O','_','H','O','S','T',
/* 0x136ea = "Reason for leaving RZ: Unknown call to ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','\xef','c','a','l','l',' ','\x0a','r','i','n','g','-','3','.',
/* 0x136ff = "Shadow mode \'none\' internal error." */
    'S','h','a','d','o','w',' ','m','o','d','e',' ','\'','n','o','n','e','\'',' ','\x16','\x85',
/* 0x13714 = "VINF_EM_DBG_HYPER_STEPPED" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','S','T','E','P','P','E','D',
/* 0x13729 = "Internal ISO maker error: Empty path." */
    '\x08','\xc2',' ','m','a','k','e','r',' ','\xd9','E','m','p','t','y',' ','p','a','t','h','.',
/* 0x1373e = "VERR_SYS_CANNOT_POWER_OFF" */
    '\x01','S','Y','S','_','C','A','N','N','O','T','_','P','O','W','E','R','_','O','F','F',
/* 0x13753 = "VERR_HTTP_COULDNT_CONNECT" */
    '\x01','H','T','T','P','_','C','O','U','L','D','N','T','_','C','O','N','N','E','C','T',
/* 0x13768 = "A page count is out of range." */
    'A',' ','\xbe','c','o','u','n','t',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x1377d = "VERR_TAR_DEV_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','D','E','V','_','V','A','L','U','E','_','\x1b','L','A','R','G','E',
/* 0x13792 = "VERR_CR_X509_NAME_EMPTY_SUB_SET" */
    '\x01','\x24','\xb7','N','A','M','E','_','E','M','P','T','Y','_','S','U','B','_','S','E','T',
/* 0x137a7 = "VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY" */
    '\x01','\xf4','\x05','S','E','C','U','R','I','T','Y','_','D','I','R','_','E','N','T','R','Y',
/* 0x137bc = "VERR_VMX_UNDEFINED_EXIT_CODE" */
    '\x01','\xe2','U','N','D','E','F','I','N','E','D','_','E','X','I','T','_','C','O','D','E',
/* 0x137d1 = "VERR_EM_CANNOT_EXEC_GUEST" */
    '\x01','E','M','_','C','A','N','N','O','T','_','E','X','E','C','_','G','U','E','S','T',
/* 0x137e6 = "VERR_SUPDRV_TRACER_SESSION_BUSY" */
    '\x01','\x90','T','R','A','C','E','R','_','S','E','S','S','I','O','N','_','B','U','S','Y',
/* 0x137fb = "VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\x82','\x95','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x13810 = "Final OpenSSL PKIX verification failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','\xf9','\x7b',
/* 0x13825 = "VERR_GMM_HIT_GLOBAL_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','G','L','O','B','A','L','_','L','I','M','I','T',
/* 0x1383a = "VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x1384f = "Device i/o: Bad command." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9f','c','o','m','m','a','n','d','.',
/* 0x13864 = "VERR_LDR_FORWARDER_CHAIN_TOO_LONG" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','_','\x8e','\x1b','L','O','N','G',
/* 0x13879 = "Too many MMIO registrations." */
    'T','o','o',' ','\xb5','\xd4',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x1388e = "Generic audio device enumeration error." */
    '\xa7','a','u','d','i','o',' ','\xa3','e','n','u','m','e','r','a','t','i','o','n',' ','\x85',
/* 0x138a3 = "Can\'t delete directory with files." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','\x25','\x7f','f','i','l','e','s','.',
/* 0x138b8 = "RTCache: cache is full." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x0b','f','u','l','l','.',
/* 0x138cd = "VERR_IOMMU_ADDR_ACCESS_DENIED" */
    '\x01','\xfe','_','A','D','D','R','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x138e2 = "Source/destination not found." */
    'S','o','u','r','c','e','/','d','e','s','t','i','n','a','t','i','o','n',' ','\x07','\x89',
/* 0x138f7 = "VERR_CR_SPC_BAD_MONIKER_CHOICE" */
    '\x01','\x24','S','P','C','_','\x1d','M','O','N','I','K','E','R','_','C','H','O','I','C','E',
/* 0x1390c = "VERR_GMM_ACTUAL_PAGES_IPE" */
    '\x01','G','M','M','_','A','C','T','U','A','L','_','P','A','G','E','S','_','I','P','E',
/* 0x13921 = "VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','S','I','X','_','A','R','G','S',
/* 0x13936 = "VERR_VD_CACHE_NOT_UP_TO_DATE" */
    '\x01','V','D','_','C','A','C','H','E','_','\x06','U','P','_','T','O','_','D','A','T','E',
/* 0x1394b = "VERR_CR_X509_CPV_NO_TRUSTED_PATHS" */
    '\x01','\x24','\xb7','C','P','V','_','\x60','T','R','U','S','T','E','D','_','P','A','T','H','S',
/* 0x13960 = "VERR_HTTP_STATUS_SERVER_ERROR" */
    '\x01','H','T','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x1c',
/* 0x13975 = "VINF_IPC_RECEIVE_MSG_CUT" */
    '\x0e','I','P','C','_','R','E','C','E','I','V','E','_','M','S','G','_','C','U','T',
/* 0x13989 = "VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x06','M','U','L','T','I','P','L','E',
/* 0x1399d = "VERR_XAR_BAD_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\x1d','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x139b1 = "VERR_SSM_FIELD_NOT_CONSECUTIVE" */
    '\x01','\xb0','F','I','E','L','D','_','\x06','C','O','N','S','E','C','U','T','I','V','E',
/* 0x139c5 = "VERR_AUDIO_ENUMERATION_FAILED" */
    '\x01','A','U','D','I','O','_','E','N','U','M','E','R','A','T','I','O','N','_','\x17',
/* 0x139d9 = "VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\x24','\xe5','\xc5','_','M','E','S','S','A','G','E','_','\xbf','A','T','T','R','I','B',
/* 0x139ed = "VERR_HGCM_SERVICE_EXISTS" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','E','X','I','S','T','S',
/* 0x13a01 = "VINF_VRDP_THREAD_STARTED" */
    '\x0e','V','R','D','P','_','T','H','R','E','A','D','_','S','T','A','R','T','E','D',
/* 0x13a15 = "Recompiler: Hit instruction buffer size limit." */
    '\x13','H','i','t',' ','\xdc','b','u','f','f','e','r',' ','\xf8','l','i','m','i','t','.',
/* 0x13a29 = "VERR_IPC_RECEIVE_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','T','I','M','E','O','U','T',
/* 0x13a3d = "Spinlock detection failed." */
    'S','p','i','n','l','o','c','k',' ','d','e','t','e','c','t','i','o','n',' ','\x7b',
/* 0x13a51 = "Reached the end of the file." */
    'R','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','f','i','l','e','.',
/* 0x13a65 = "VERR_SVM_VMRUN_PRECOND_3" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','3',
/* 0x13a79 = "Operation in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x13a8d = "VINF_PGM_POOL_FLUSH_PENDING" */
    '\x0e','\x8c','P','O','O','L','_','F','L','U','S','H','_','P','E','N','D','I','N','G',
/* 0x13aa1 = "Internal processing error #1 in the PDM Thread code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x84',
/* 0x13ab5 = "VFS chain element expected at least four arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','l','e','a','s','t',' ','f','o','u','r',' ','\xde',
/* 0x13ac9 = "Request was redirected." */
    'R','e','q','u','e','s','t',' ','\x11','r','e','d','i','r','e','c','t','e','d','.',
/* 0x13add = "VERR_INCOMPATIBLE_CONFIG" */
    '\x01','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x13af1 = "The certificate path has no trust anchor." */
    '\x03','\xa0','\xd2','\x5c','n','o',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x13b05 = "VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB" */
    '\x01','\x24','\xe5','\x1d','C','O','N','T','E','N','T','_','\xb3','_','A','T','T','R','I','B',
/* 0x13b19 = "UDF directory too large for import." */
    'U','D','F',' ','\x25','\x9e','l','a','r','g','e',' ','\x10','i','m','p','o','r','t','.',
/* 0x13b2d = "VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH" */
    '\x01','\x24','\xe5','M','E','S','S','A','G','E','_','\xbf','A','T','T','R','I','B','_','\x19',
/* 0x13b41 = "VERR_XAR_HASH_FUNCTION_MISMATCH" */
    '\x01','X','A','R','_','H','A','S','H','_','F','U','N','C','T','I','O','N','_','\x19',
/* 0x13b55 = "VERR_VFS_CHAIN_AT_LEAST_ONE_ARG" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','O','N','E','_','A','R','G',
/* 0x13b69 = "VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS" */
    '\x01','\x24','K','E','Y','_','\x88','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x13b7d = "Unable to start VM execution." */
    '\xe1','\x0a','s','t','a','r','t',' ','\xc6',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x13b91 = "VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','\x06','\x40',
/* 0x13ba5 = "VERR_IOM_IOPORT_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','\x06','\x40',
/* 0x13bb9 = "VERR_IOM_IOPORTS_NOT_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x06','M','A','P','P','E','D',
/* 0x13bcd = "VINF_CSAM_PENDING_ACTION" */
    '\x0e','C','S','A','M','_','P','E','N','D','I','N','G','_','A','C','T','I','O','N',
/* 0x13be1 = "VERR_CPUM_INVALID_HWVIRT_CONFIG" */
    '\x01','C','P','U','M','_','\x05','H','W','V','I','R','T','_','C','O','N','F','I','G',
/* 0x13bf5 = "Reserved page table bits set." */
    'R','e','s','e','r','v','e','d',' ','\xbe','\xb1','b','i','t','s',' ','s','e','t','.',
/* 0x13c09 = "VERR_ASN1_OBJID_TOO_MANY_COMPONENTS" */
    '\x01','\xa2','O','B','J','I','D','_','\x1b','\xac','C','O','M','P','O','N','E','N','T','S',
/* 0x13c1d = "VINF_IOM_R3_MMIO_READ_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd4','_','R','E','A','D','_','W','R','I','T','E',
/* 0x13c31 = "Internal processing error #4 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','4',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x13c45 = "VERR_ASN1_EXPECTED_PRIMITIVE" */
    '\x01','\xa2','E','X','P','E','C','T','E','D','_','P','R','I','M','I','T','I','V','E',
/* 0x13c59 = "Too many symbolic links." */
    'T','o','o',' ','\xb5','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','.',
/* 0x13c6d = "NtQueryObject/Type failed." */
    'N','t','Q','u','e','r','y','O','b','j','e','c','t','/','T','y','p','e',' ','\x7b',
/* 0x13c81 = "VERR_PDM_DEVICE_INSTANCE_NOT_FOUND" */
    '\x01','\x7d','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x06','\x40',
/* 0x13c95 = "VERR_VD_NOT_ENOUGH_METADATA" */
    '\x01','V','D','_','\x06','E','N','O','U','G','H','_','M','E','T','A','D','A','T','A',
/* 0x13ca9 = "Cipher algorithm is not known to us." */
    'C','i','p','h','e','r',' ','\xd5','\x0b','\x07','k','n','o','w','n',' ','\x0a','u','s','.',
/* 0x13cbd = "VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE" */
    '\x01','\x95','\xbd','\x06','K','N','O','W','N','_','D','L','L','_','O','R','_','E','X','E',
/* 0x13cd1 = "VERR_TAR_BAD_NUM_FIELD_TERM" */
    '\x01','T','A','R','_','\x1d','N','U','M','_','F','I','E','L','D','_','T','E','R','M',
/* 0x13ce5 = "Internal processing error #5 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','5',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x13cf9 = "VERR_PDM_TOO_MANY_DRIVER_INSTANCES" */
    '\x01','\x7d','\x1b','\xac','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','S',
/* 0x13d0d = "VERR_XAR_ARCHIVED_HASH_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','H','A','S','H','_','\x19',
/* 0x13d21 = "No free input streams." */
    '\xe0','f','r','e','e',' ','i','n','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x13d35 = "VERR_FTP_STATUS_SERVER_ERROR" */
    '\x01','F','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x1c',
/* 0x13d49 = "Expected a left parentheses." */
    '\xb8','a',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x13d5d = "VERR_SUPDRV_TRACER_ALREADY_REGISTERED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x13d71 = "VERR_TCP_SERVER_SHUTDOWN" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x13d85 = "VERR_DBG_SPECIAL_SEGMENT" */
    '\x01','D','B','G','_','S','P','E','C','I','A','L','_','S','E','G','M','E','N','T',
/* 0x13d99 = "VERR_CR_KEY_DEK_INFO_TOO_LONG" */
    '\x01','\x24','K','E','Y','_','D','E','K','_','I','N','F','O','_','\x1b','L','O','N','G',
/* 0x13dad = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','\xb6','_','\x1c',
/* 0x13dc1 = "VERR_VM_DRIVER_NOT_INSTALLED" */
    '\x01','\xc6','_','D','R','I','V','E','R','_','\x06','I','N','S','T','A','L','L','E','D',
/* 0x13dd5 = "The driver instance could not be found." */
    '\x03','\xc7','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x07','\xa4','\x89',
/* 0x13de9 = "The driver helper structure version has changed." */
    '\x03','\xc7','h','e','l','p','e','r',' ','\xec','\xd1','\x5c','c','h','a','n','g','e','d','.',
/* 0x13dfd = "Protocol not available." */
    'P','r','o','t','o','c','o','l',' ','\x07','a','v','a','i','l','a','b','l','e','.',
/* 0x13e11 = "VINF_DBGF_R3_BP_OWNER_DEFER" */
    '\x0e','\xb9','_','R','3','_','B','P','_','O','W','N','E','R','_','D','E','F','E','R',
/* 0x13e25 = "VERR_FAM_CONNECTION_LOST" */
    '\x01','F','A','M','_','C','O','N','N','E','C','T','I','O','N','_','L','O','S','T',
/* 0x13e39 = "The current operation was canceled." */
    '\x03','c','u','r','r','e','n','t',' ','\x96','\x11','c','a','n','c','e','l','e','d','.',
/* 0x13e4d = "VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS" */
    '\x01','\x97','\x1b','\xac','I','C','B','_','I','N','D','I','R','E','C','T','I','O','N','S',
/* 0x13e61 = "VINF_RECORDING_THROTTLED" */
    '\x0e','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x13e75 = "VFS chain element expected at most three arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','m','o','s','t',' ','t','h','r','e','e',' ','\xde',
/* 0x13e89 = "Unexpected SVM exception exit." */
    '\x94','S','V','M',' ','e','x','c','e','p','t','i','o','n',' ','e','x','i','t','.',
/* 0x13e9d = "VFS chain element expected at least five arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','l','e','a','s','t',' ','f','i','v','e',' ','\xde',
/* 0x13eb1 = "VERR_IEM_INSTR_BUF_OUT_OF_MEMORY" */
    '\x01','\x9c','I','N','S','T','R','_','B','U','F','_','O','U','T','_','O','F','_','\xb6',
/* 0x13ec5 = "Failed to allocate VM memory." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','\xc6',' ','m','e','m','o','r','y','.',
/* 0x13ed9 = "VERR_VGA_GL_LOAD_FAILURE" */
    '\x01','V','G','A','_','G','L','_','L','O','A','D','_','F','A','I','L','U','R','E',
/* 0x13eed = "Internal processing error #1 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x13f01 = "VERR_PAGE_COUNT_OUT_OF_RANGE" */
    '\x01','\xce','C','O','U','N','T','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x13f15 = "Image hash mismatch." */
    'I','m','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x13f29 = "VERR_PDM_DRIVER_INSTANCE_NOT_FOUND" */
    '\x01','\x7d','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','_','\x06','\x40',
/* 0x13f3d = "VERR_PCI_PASSTHROUGH_NO_HM" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','H','M',
/* 0x13f51 = "VERR_DBG_DEFERRED_LOAD_FAILED" */
    '\x01','D','B','G','_','D','E','F','E','R','R','E','D','_','L','O','A','D','_','\x17',
/* 0x13f65 = "Internal processing error #2 in the PDM Thread code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x84',
/* 0x13f79 = "The HGCM is saving state." */
    '\x03','H','G','C','M',' ','\x0b','s','a','v','i','n','g',' ','s','t','a','t','e','.',
/* 0x13f8d = "Invalid timer queue number." */
    '\x0c','t','i','m','e','r',' ','q','u','e','u','e',' ','n','u','m','b','e','r','.',
/* 0x13fa1 = "VERR_GVMM_HOST_CPU_RANGE" */
    '\x01','G','V','M','M','_','H','O','S','T','_','C','P','U','_','R','A','N','G','E',
/* 0x13fb5 = "VWRN_RECORDING_ENCODING_SKIPPED" */
    '\xe6','R','E','C','O','R','D','I','N','G','_','\xc8','_','S','K','I','P','P','E','D',
/* 0x13fc9 = "VERR_FILE_AIO_LIMIT_EXCEEDED" */
    '\x01','\xaa','A','I','O','_','L','I','M','I','T','_','E','X','C','E','E','D','E','D',
/* 0x13fdd = "VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\x7d','D','E','V','I','N','S','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x13ff1 = "URL not expected in SPC PE image data." */
    'U','R','L',' ','\x07','\xcb','\x0f','S','P','C',' ','P','E',' ','\x26','d','a','t','a','.',
/* 0x14005 = "Unsupported ISO protocol feature." */
    '\x98','\xc2',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x14019 = "VERR_SSM_VOTE_FOR_GIVING_UP" */
    '\x01','\xb0','V','O','T','E','_','F','O','R','_','G','I','V','I','N','G','_','U','P',
/* 0x1402d = "VERR_APIC_INTR_DISCARDED" */
    '\x01','A','P','I','C','_','I','N','T','R','_','D','I','S','C','A','R','D','E','D',
/* 0x14041 = "VERR_ISOFS_BAD_LVD_DESC_CHAR_SET" */
    '\x01','\x97','\x1d','L','V','D','_','D','E','S','C','_','C','H','A','R','_','S','E','T',
/* 0x14055 = "VERR_VUSB_FAILED_TO_QUEUE_URB" */
    '\x01','V','U','S','B','_','\x17','_','T','O','_','Q','U','E','U','E','_','U','R','B',
/* 0x14069 = "FTP initialization failed." */
    'F','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x1407d = "Internal processing error #7 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','7',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x14091 = "VERR_IEM_INSTR_NOT_IMPLEMENTED" */
    '\x01','\x9c','I','N','S','T','R','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x140a5 = "VERR_UDP_SERVER_SHUTDOWN" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x140b9 = "VERR_LDRLX_BAD_OBJECT_TABLE" */
    '\x01','L','D','R','L','X','_','\x1d','O','B','J','E','C','T','_','T','A','B','L','E',
/* 0x140cd = "Internal processing error #6 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','6',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x140e1 = "VERR_CR_CIPHER_INVALID_KEY_LENGTH" */
    '\x01','\x24','C','I','P','H','E','R','_','\x05','K','E','Y','_','L','E','N','G','T','H',
/* 0x140f5 = "VERR_PROC_APT_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','A','P','T','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x14109 = "Internal processing error #2 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x1411d = "VERR_LDRPE_LOAD_CONFIG_SIZE" */
    '\x01','L','D','R','P','E','_','L','O','A','D','_','C','O','N','F','I','G','_','\xfa',
/* 0x14131 = "Generic hypercall operation failure." */
    '\xa7','h','y','p','e','r','c','a','l','l',' ','\x96','f','a','i','l','u','r','e','.',
/* 0x14145 = "VERR_DBG_INVALID_SEGMENT_OFFSET" */
    '\x01','D','B','G','_','\x05','S','E','G','M','E','N','T','_','O','F','F','S','E','T',
/* 0x14159 = "VERR_COM_DONT_CALL_AGAIN" */
    '\x01','C','O','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x1416d = "VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER" */
    '\x01','\x9c','E','M','I','T','_','\x88','V','A','R','_','R','E','G','I','S','T','E','R',
/* 0x14181 = "VERR_DBGC_PARSE_ARGUMENT_OVERFLOW" */
    '\x01','\xfd','\xe4','A','R','G','U','M','E','N','T','_','O','V','E','R','F','L','O','W',
/* 0x14195 = "VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\x7d','D','R','V','I','N','S','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x141a9 = "VERR_XAR_BAD_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\x1d','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x141bd = "VERR_RT_REQUEST_INVALID_PACKAGE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x05','P','A','C','K','A','G','E',
/* 0x141d1 = "VERR_HARDAVL_BAD_NEW_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','N','E','W','_','H','E','I','G','H','T',
/* 0x141e5 = "VERR_PGM_INVALID_GC_PHYSICAL_RANGE" */
    '\x01','\x8c','\x05','G','C','_','P','H','Y','S','I','C','A','L','_','R','A','N','G','E',
/* 0X141f9 = "EVP_DecryptInit_ex failed." */
    'V','P','_','D','e','c','r','y','p','t','I','n','i','t','_','e','x',' ','\x7b',
/* 0x1420c = "VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1b','\xac','P','R','O','V','I','D','E','R','S',
/* 0x14220 = "VERR_CR_CIPHER_INVALID_TAG_LENGTH" */
    '\x01','\x24','C','I','P','H','E','R','_','\x05','T','A','G','_','L','E','N','G','T','H',
/* 0x14234 = "VERR_SVM_VMRUN_PRECOND_0" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','0',
/* 0x14248 = "VERR_SVM_VMRUN_PRECOND_1" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','1',
/* 0x1425c = "VERR_VUSB_DEVICE_NAME_NOT_FOUND" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','N','A','M','E','_','\x06','\x40',
/* 0x14270 = "VERR_SVM_VMRUN_PRECOND_2" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','2',
/* 0x14284 = "VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT" */
    '\x01','\x95','\xbd','\x88','V','A','L','I','D','_','P','A','T','H','_','C','O','U','N','T',
/* 0x14298 = "Internal processing error #9 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','9',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x142ac = "Reason for leaving RC: Double Fault." */
    '\x93','\x10','\x81','R','C',':',' ','D','o','u','b','l','e',' ','F','a','u','l','t','.',
/* 0x142c0 = "VERR_RECORDING_THROTTLED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x142d4 = "VERR_VFS_CHAIN_AT_MOST_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','T','W','O','_','A','R','G','S',
/* 0x142e8 = "VERR_GMM_TOO_MANY_PER_VM_MODULES" */
    '\x01','G','M','M','_','\x1b','\xac','P','E','R','_','\xc6','_','M','O','D','U','L','E','S',
/* 0x142fc = "VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','R','A','N','G','E','_','\x06','\x40',
/* 0x14310 = "Trailing characters." */
    'T','r','a','i','l','i','n','g',' ','c','h','a','r','a','c','t','e','r','s','.',
/* 0x14324 = "The device helper structure version has changed." */
    '\x03','\xa3','h','e','l','p','e','r',' ','\xec','\xd1','\x5c','c','h','a','n','g','e','d','.',
/* 0x14338 = "VERR_VMM_WRONG_NEM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','\xee','_','V','M','C','P','U','_','\xf1',
/* 0x1434c = "VERR_NS_SYMLINK_SET_TIME" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','S','E','T','_','T','I','M','E',
/* 0x14360 = "Recompiler: Unimplemented case." */
    '\x13','U','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','a','s','e','.',
/* 0x14374 = "VERR_TM_TIMER_UNSTABLE_STATE" */
    '\x01','T','M','_','T','I','M','E','R','_','U','N','S','T','A','B','L','E','_','\xf1',
/* 0x14388 = "VERR_IOM_IOPORTS_ALREADY_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x9b','M','A','P','P','E','D',
/* 0x1439c = "VINF_PATCH_EMULATE_INSTR" */
    '\x0e','P','A','T','C','H','_','E','M','U','L','A','T','E','_','I','N','S','T','R',
/* 0x143b0 = "VERR_VMM_RING0_ASSERTION" */
    '\x01','V','M','M','_','R','I','N','G','0','_','A','S','S','E','R','T','I','O','N',
/* 0x143c4 = "The bucket/key wasn\'t found." */
    '\x03','b','u','c','k','e','t','/','k','e','y',' ','w','a','s','n','\'','t',' ','\x89',
/* 0x143d8 = "VERR_VD_RAW_SIZE_MODULO_512" */
    '\x01','V','D','_','R','A','W','_','\xfa','_','M','O','D','U','L','O','_','5','1','2',
/* 0x143ec = "Internal processing error #8 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','8',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x14400 = "Expected an element separator (| or :)." */
    '\xb8','\x87','\x5e','s','e','p','a','r','a','t','o','r',' ','(','|',' ','\xa9',':',')','.',
/* 0x14414 = "Bad DWARF line number header." */
    '\x9f','D','W','A','R','F',' ','l','i','n','e',' ','\xfc','h','e','a','d','e','r','.',
/* 0x14428 = "VERR_PDM_INVALID_DEVICE_GUEST_BITS" */
    '\x01','\x7d','\x05','D','E','V','I','C','E','_','G','U','E','S','T','_','B','I','T','S',
/* 0x1443c = "VERR_IPC_RECEIVE_ABORTED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','A','B','O','R','T','E','D',
/* 0x14450 = "VERR_SUPDRV_TRACER_NOT_REGISTERED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x14464 = "VERR_DBG_NOT_LINUX_KALLSYMS" */
    '\x01','D','B','G','_','\x06','L','I','N','U','X','_','K','A','L','L','S','Y','M','S',
/* 0x14478 = "VERR_PDM_DRIVER_INVALID_PROPERTIES" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x05','P','R','O','P','E','R','T','I','E','S',
/* 0x1448c = "VERR_SSM_NO_PENDING_OPERATION" */
    '\x01','\xb0','\x60','P','E','N','D','I','N','G','_','O','P','E','R','A','T','I','O','N',
/* 0x144a0 = "VERR_HARDAVL_UNEXPECTED_NULL_RIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x88','N','U','L','L','_','R','I','G','H','T',
/* 0x144b4 = "VERR_SUP_VP_NO_KERNEL32_MAPPING" */
    '\x01','\x95','\xbd','\x60','K','E','R','N','E','L','3','2','_','M','A','P','P','I','N','G',
/* 0x144c8 = "VERR_ASN1_OBJID_TOO_LONG_STRING_FORM" */
    '\x01','\xa2','O','B','J','I','D','_','\x1b','L','O','N','G','_','\xd6','_','F','O','R','M',
/* 0x144dc = "Already initialized." */
    'A','l','r','e','a','d','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x144f0 = "VERR_PROC_TCB_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','T','C','B','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x14504 = "VERR_GMM_ALLOC_PAGES_IPE" */
    '\x01','G','M','M','_','A','L','L','O','C','_','P','A','G','E','S','_','I','P','E',
/* 0x14518 = "Internal processing error #3 in the DBGF breakpoint manager code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','\x02','\xb9',' ','\xc0','m','a','n','a','g','e','r',' ','\x84',
/* 0x1452c = "Requested image is not opened." */
    'R','e','q','u','e','s','t','e','d',' ','\x26','\x0b','\x07','o','p','e','n','e','d','.',
/* 0x14540 = "The specified thread is not waitable." */
    '\x03','\x18','t','h','r','e','a','d',' ','\x0b','\x07','w','a','i','t','a','b','l','e','.',
/* 0x14554 = "Bad file user id for XAR file." */
    '\x9f','\x22','u','s','e','r',' ','i','d',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14568 = "VINF_IOM_R3_IOPORT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x1457c = "VERR_VSCSI_LUN_NOT_ATTACHED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\x06','A','T','T','A','C','H','E','D',
/* 0x14590 = "VERR_ISOMK_IPE_PRODUCE_TRANS_TBL" */
    '\x01','\x1f','\x14','P','R','O','D','U','C','E','_','T','R','A','N','S','_','T','B','L',
/* 0x145a4 = "VERR_CR_X509_CPV_NO_VALID_POLICY" */
    '\x01','\x24','\xb7','C','P','V','_','\x60','V','A','L','I','D','_','P','O','L','I','C','Y',
/* 0x145b8 = "VERR_PDM_TOO_MANY_DEVICE_INSTANCES" */
    '\x01','\x7d','\x1b','\xac','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x145cc = "Reason for leaving RZ: MMIO read/write." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd4',' ','r','e','a','d','/','w','r','i','t','e','.',
/* 0x145e0 = "VERR_SUPDRV_VTG_BAD_PROBE_ENABLED" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','B','E','_','E','N','A','B','L','E','D',
/* 0X145f4 = "Device i/o: Bad length." */
    'e','v','i','c','e',' ','i','/','o',':',' ','\x9f','l','e','n','g','t','h','.',
/* 0x14607 = "Too fragmented file." */
    'T','o','o',' ','f','r','a','g','m','e','n','t','e','d',' ','f','i','l','e','.',
/* 0x1461b = "VERR_VFS_CHAIN_AT_MOST_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','S','I','X','_','A','R','G','S',
/* 0x1462f = "Bad file inode device number for XAR file." */
    '\x9f','\x22','i','n','o','d','e',' ','\xa3','\xfc','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14643 = "Missing data element for XAR file." */
    'M','i','s','s','i','n','g',' ','\x9d','\x5e','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14657 = "Syntax error - invalid operator usage." */
    '\xfb','\x09','-',' ','\x8f','o','p','e','r','a','t','o','r',' ','u','s','a','g','e','.',
/* 0x1466b = "VERR_HGCM_TOO_MANY_CLIENT_CALLS" */
    '\x01','H','G','C','M','_','\x1b','\xac','C','L','I','E','N','T','_','C','A','L','L','S',
/* 0x1467f = "The I/O request ID is already existing." */
    '\x03','I','/','O',' ','\xab','I','D',' ','\x0b','\x80','e','x','i','s','t','i','n','g','.',
/* 0x14693 = "VERR_PGM_PHYS_TLB_CATCH_ALL" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','A','L','L',
/* 0x146a7 = "VERR_VFS_CHAIN_EXPECTED_ELEMENT" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','E','L','E','M','E','N','T',
/* 0x146bb = "VINF_VD_NEW_ZEROED_BLOCK" */
    '\x0e','V','D','_','N','E','W','_','Z','E','R','O','E','D','_','B','L','O','C','K',
/* 0x146cf = "VERR_LDR_GENERAL_FAILURE" */
    '\x01','L','D','R','_','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x146e3 = "Duplicate something." */
    'D','u','p','l','i','c','a','t','e',' ','s','o','m','e','t','h','i','n','g','.',
/* 0x146f7 = "A GMM sanity check failed." */
    'A',' ','G','M','M',' ','s','a','n','i','t','y',' ','c','h','e','c','k',' ','\x7b',
/* 0x1470b = "VERR_PDM_BLOCK_UNKNOWN_TRANSLATION" */
    '\x01','\x7d','B','L','O','C','K','_','\x91','T','R','A','N','S','L','A','T','I','O','N',
/* 0x1471f = "VERR_CR_X509_PUBLIC_KEY_TOO_SMALL" */
    '\x01','\x24','\xb7','P','U','B','L','I','C','_','K','E','Y','_','\x1b','S','M','A','L','L',
/* 0x14733 = "The object in question already exists." */
    '\x03','\xa8','\x0f','q','u','e','s','t','i','o','n',' ','\x80','e','x','i','s','t','s','.',
/* 0x14747 = "VERR_LDRVI_BAD_CERT_HDR_REVISION" */
    '\x01','\xf4','\x1d','C','E','R','T','_','H','D','R','_','R','E','V','I','S','I','O','N',
/* 0x1475b = "VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE" */
    '\x01','\x95','\xbd','\x1d','\xaa','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x1476f = "VERR_IOMMU_INTR_REMAP_DENIED" */
    '\x01','\xfe','_','I','N','T','R','_','R','E','M','A','P','_','D','E','N','I','E','D',
/* 0x14783 = "VINF_PGM_HANDLER_DO_DEFAULT" */
    '\x0e','\x8c','H','A','N','D','L','E','R','_','D','O','_','D','E','F','A','U','L','T',
/* 0x14797 = "VERR_AUDIO_STREAM_NOT_READY" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','\x06','R','E','A','D','Y',
/* 0x147ab = "No conflicts to resolve." */
    '\xe0','c','o','n','f','l','i','c','t','s',' ','\x0a','r','e','s','o','l','v','e','.',
/* 0x147bf = "VERR_RECORDING_FORMAT_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','F','O','R','M','A','T','_','\x06','\x83',
/* 0x147d3 = "Process Verification Failure: Bad optional header field." */
    '\x1e','\x0d','\x12','\x9f','o','p','t','i','o','n','a','l',' ','\xb4','f','i','e','l','d','.',
/* 0x147e7 = "VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC" */
    '\x01','\x1f','\x82','\x1d','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C',
/* 0x147fb = "VERR_SUP_VP_KERNEL32_ALREADY_MAPPED" */
    '\x01','\x95','\xbd','K','E','R','N','E','L','3','2','_','\x9b','M','A','P','P','E','D',
/* 0x1480e = "VERR_PDM_DRIVER_NO_RT_ATTACH" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x60','R','T','_','A','T','T','A','C','H',
/* 0x14821 = "Bad size element in table of content sub-element." */
    '\x9f','\xf8','\x5e','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x14834 = "VERR_VD_IMAGE_CORRUPTED" */
    '\x01','V','D','_','I','M','A','G','E','_','C','O','R','R','U','P','T','E','D',
/* 0x14847 = "EVP_DecryptUpdate failed." */
    'E','V','P','_','D','e','c','r','y','p','t','U','p','d','a','t','e',' ','\x7b',
/* 0x1485a = "VFS chain element expected at least six arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','l','e','a','s','t',' ','s','i','x',' ','\xde',
/* 0x1486d = "Path not verified yet." */
    'P','a','t','h',' ','\x07','v','e','r','i','f','i','e','d',' ','y','e','t','.',
/* 0x14880 = "Saved state header integrity error." */
    'S','a','v','e','d',' ','\xcc','\xb4','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x14893 = "VERR_IOMMU_CANNOT_CALL_SELF" */
    '\x01','\xfe','_','C','A','N','N','O','T','_','C','A','L','L','_','S','E','L','F',
/* 0x148a6 = "VERR_VMX_STARTVM_PRECOND_3" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','3',
/* 0x148b9 = "No pending interrupt." */
    '\xe0','p','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x148cc = "VERR_VMX_STARTVM_PRECOND_1" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','1',
/* 0x148df = "VERR_XAR_MISSING_DATA_ELEMENT" */
    '\x01','X','A','R','_','\xc5','_','D','A','T','A','_','E','L','E','M','E','N','T',
/* 0x148f2 = "VINF_HGCM_ASYNC_EXECUTE" */
    '\x0e','H','G','C','M','_','A','S','Y','N','C','_','E','X','E','C','U','T','E',
/* 0x14905 = "Socket is already connected." */
    'S','o','c','k','e','t',' ','\x0b','\x80','c','o','n','n','e','c','t','e','d','.',
/* 0x14918 = "EVP_EncryptUpdate failed." */
    'E','V','P','_','E','n','c','r','y','p','t','U','p','d','a','t','e',' ','\x7b',
/* 0x1492b = "VERR_PDM_INVALID_DEVICE_HOST_BITS" */
    '\x01','\x7d','\x05','D','E','V','I','C','E','_','H','O','S','T','_','B','I','T','S',
/* 0x1493e = "VERR_XAR_UNSUPPORTED_HASH_FUNCTION" */
    '\x01','X','A','R','_','\x1a','H','A','S','H','_','F','U','N','C','T','I','O','N',
/* 0x14951 = "VERR_MANIFEST_ATTR_TYPE_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\xb3','_','\x06','\x40',
/* 0x14964 = "Generic object destroyed status." */
    '\xa7','\xa8','d','e','s','t','r','o','y','e','d',' ','s','t','a','t','u','s','.',
/* 0x14977 = "VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE" */
    '\x01','\x8c','\x1a','H','O','S','T','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x1498a = "VERR_VMX_STARTVM_PRECOND_0" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','0',
/* 0x1499d = "Socket is not connected." */
    'S','o','c','k','e','t',' ','\x0b','\x07','c','o','n','n','e','c','t','e','d','.',
/* 0x149b0 = "VERR_VMX_STARTVM_PRECOND_2" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','2',
/* 0x149c3 = "The tracer is unloading." */
    '\x03','t','r','a','c','e','r',' ','\x0b','u','n','l','o','a','d','i','n','g','.',
/* 0x149d6 = "VERR_IOM_IOPORT_UNKNOWN_OPCODE" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x91','O','P','C','O','D','E',
/* 0x149e9 = "VERR_SUP_VP_NON_SYSTEM32_DLL" */
    '\x01','\x95','\xbd','N','O','N','_','S','Y','S','T','E','M','3','2','_','D','L','L',
/* 0x149fc = "VERR_NAT_REDIR_GUEST_IP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','G','U','E','S','T','_','I','P',
/* 0x14a0f = "VERR_CR_SPC_MONIKER_BAD_DATA" */
    '\x01','\x24','S','P','C','_','M','O','N','I','K','E','R','_','\x1d','D','A','T','A',
/* 0x14a22 = "VT-x/AMD-V not active." */
    'V','T','-','x','/','A','M','D','-','V',' ','\x07','a','c','t','i','v','e','.',
/* 0x14a35 = "VERR_DBG_INVALID_SEGMENT_INDEX" */
    '\x01','D','B','G','_','\x05','S','E','G','M','E','N','T','_','I','N','D','E','X',
/* 0x14a48 = "VERR_SUP_VP_TOO_HIGH_REGION_RVA" */
    '\x01','\x95','\xbd','\x1b','H','I','G','H','_','R','E','G','I','O','N','_','R','V','A',
/* 0x14a5b = "VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\x95','\xbd','F','R','E','E','_','V','I','R','T','U','A','L','_','\xb6','_','\x17',
/* 0x14a6e = "VINF_IOM_R3_IOPORT_READ" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x14a81 = "VWRN_CSAM_TRAP_NOT_HANDLED" */
    '\xe6','C','S','A','M','_','T','R','A','P','_','\x06','H','A','N','D','L','E','D',
/* 0x14a94 = "VERR_CPUM_UNSUPPORTED_ID_REG_VALUE" */
    '\x01','C','P','U','M','_','\x1a','I','D','_','R','E','G','_','V','A','L','U','E',
/* 0x14aa7 = "VINF_UDP_SERVER_NO_CLIENT" */
    '\x0e','U','D','P','_','S','E','R','V','E','R','_','\x60','C','L','I','E','N','T',
/* 0x14aba = "Expected ECDSA private key." */
    '\xb8','E','C','D','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x14acd = "VERR_CR_X509_VALIDITY_SWAPPED" */
    '\x01','\x24','\xb7','V','A','L','I','D','I','T','Y','_','S','W','A','P','P','E','D',
/* 0x14ae0 = "Bad PCI configuration." */
    '\x9f','P','C','I',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x14af3 = "VERR_SSM_LOW_ON_DISK_SPACE" */
    '\x01','\xb0','L','O','W','_','O','N','_','D','I','S','K','_','S','P','A','C','E',
/* 0x14b06 = "VINF_TCP_SERVER_NO_CLIENT" */
    '\x0e','T','C','P','_','S','E','R','V','E','R','_','\x60','C','L','I','E','N','T',
/* 0x14b19 = "VERR_VM_REQUEST_INVALID_PACKAGE" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','\x05','P','A','C','K','A','G','E',
/* 0x14b2c = "VERR_VD_IMAGE_READ_ONLY" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','A','D','_','O','N','L','Y',
/* 0x14b3f = "Process Verification Failure: Error querying process name." */
    '\x1e','\x0d','\x12','\xc1','q','u','e','r','y','i','n','g',' ','\x92','n','a','m','e','.',
/* 0x14b52 = "VINF_VMX_INTERCEPT_NOT_ACTIVE" */
    '\x0e','\xe2','I','N','T','E','R','C','E','P','T','_','\x06','A','C','T','I','V','E',
/* 0x14b65 = "VERR_CR_SPC_UNKNOWN_MONIKER_UUID" */
    '\x01','\x24','S','P','C','_','\x91','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x14b78 = "Compromised digest." */
    'C','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x14b8b = "VERR_VRDP_ISO_UNSUPPORTED" */
    '\x01','V','R','D','P','_','\xc2','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x14b9e = "VERR_CR_KEY_ALGO_PARAMS_MISMATCH" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\x19',
/* 0x14bb1 = "VERR_CR_KEY_ALGO_PARAMS_MISSING" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\xc5',
/* 0x14bc4 = "VERR_ISOFS_FSD_ZERO_ROOT_DIR" */
    '\x01','\x97','F','S','D','_','Z','E','R','O','_','R','O','O','T','_','D','I','R',
/* 0x14bd7 = "VINF_VRDP_OUTPUT_ENABLE" */
    '\x0e','V','R','D','P','_','O','U','T','P','U','T','_','E','N','A','B','L','E',
/* 0x14bea = "VERR_ASN1_DYNTYPE_TAG_NOT_IMPL" */
    '\x01','\xa2','D','Y','N','T','Y','P','E','_','T','A','G','_','\x06','I','M','P','L',
/* 0x14bfd = "Generic: Invalid image file header." */
    'G','e','n','e','r','i','c',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x14c10 = "Is a symbolic link." */
    'I','s',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x14c23 = "VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED" */
    '\x01','\x24','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x06','\x83',
/* 0x14c36 = "VERR_SUP_VP_BAD_IMAGE_SIGNATURE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','S','I','G','N','A','T','U','R','E',
/* 0x14c49 = "VERR_VFS_CHAIN_AT_MOST_ONE_ARG" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','O','N','E','_','A','R','G',
/* 0x14c5c = "VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','\x06','\x83',
/* 0x14c6f = "Bad file inode number for XAR file." */
    '\x9f','\x22','i','n','o','d','e',' ','\xfc','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14c82 = "VERR_ACCOUNT_RESTRICTED" */
    '\x01','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x14c95 = "Bad left right height." */
    '\x9f','l','e','f','t',' ','r','i','g','h','t',' ','h','e','i','g','h','t','.',
/* 0x14ca8 = "The handle is not pollable." */
    '\x03','h','a','n','d','l','e',' ','\x0b','\x07','p','o','l','l','a','b','l','e','.',
/* 0x14cbb = "IOCtl to VBoxGuest driver failed." */
    'I','O','C','t','l',' ','\x0a','V','B','o','x','G','u','e','s','t',' ','\xc7','\x7b',
/* 0x14cce = "VERR_CR_SPC_BAD_MONIKER_UUID" */
    '\x01','\x24','S','P','C','_','\x1d','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x14ce1 = "Too many components in an ASN." */
    'T','o','o',' ','\xb5','c','o','m','p','o','n','e','n','t','s',' ','\x0f','\x87','\xf6',
/* 0x14cf4 = "VERR_DBGC_PARSE_UNBALANCED_QUOTE" */
    '\x01','\xfd','\xe4','U','N','B','A','L','A','N','C','E','D','_','Q','U','O','T','E',
/* 0x14d07 = "VERR_INTNET_FLT_IF_BUSY" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','B','U','S','Y',
/* 0x14d1a = "VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\x24','\xe5','\x1d','M','E','S','S','A','G','E','_','\xbf','A','T','T','R','I','B',
/* 0x14d2d = "VERR_SUP_VP_IMAGE_HDR_READ_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','H','D','R','_','R','E','A','D','_','\x1c',
/* 0x14d40 = "Memory allocation failed." */
    'M','e','m','o','r','y',' ','a','l','l','o','c','a','t','i','o','n',' ','\x7b',
/* 0x14d53 = "VERR_PDM_DRIVER_NAME_CLASH" */
    '\x01','\x7d','D','R','I','V','E','R','_','N','A','M','E','_','C','L','A','S','H',
/* 0x14d66 = "VERR_PROC_IQ_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','I','Q','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x14d79 = "VERR_SUP_VP_BAD_OPTIONAL_HEADER" */
    '\x01','\x95','\xbd','\x1d','O','P','T','I','O','N','A','L','_','H','E','A','D','E','R',
/* 0x14d8c = "VERR_HARDAVL_UNEXPECTED_NULL_LEFT" */
    '\x01','H','A','R','D','A','V','L','_','\x88','N','U','L','L','_','L','E','F','T',
/* 0x14d9f = "VERR_DIS_NO_READ_CALLBACK" */
    '\x01','D','I','S','_','\x60','R','E','A','D','_','C','A','L','L','B','A','C','K',
/* 0x14db2 = "The requested allocation is too big." */
    '\x03','\xdf','a','l','l','o','c','a','t','i','o','n',' ','\x0b','\x9e','b','i','g','.',
/* 0x14dc5 = "VERR_PDM_DEVICE_NO_RT_ATTACH" */
    '\x01','\x7d','D','E','V','I','C','E','_','\x60','R','T','_','A','T','T','A','C','H',
/* 0x14dd8 = "Empty set inside X." */
    'E','m','p','t','y',' ','s','e','t',' ','i','n','s','i','d','e',' ','X','.',
/* 0x14deb = "VERR_NET_ADDRESS_IN_USE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','I','N','_','U','S','E',
/* 0x14dfe = "Import ISO contains a bad volume descriptor header." */
    '\xc4','\xc2',' ','\x8a','a',' ','b','a','d',' ','\xd3','\xe3','h','e','a','d','e','r','.',
/* 0x14e11 = "Failed to allocate memory for a URB." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','\x86','\x10','a',' ','U','R','B','.',
/* 0x14e24 = "Wrong JSON type for bool value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','b','o','o','l',' ','\xe8',
/* 0x14e37 = "VERR_PDM_MODULE_NAME_TOO_LONG" */
    '\x01','\x7d','M','O','D','U','L','E','_','N','A','M','E','_','\x1b','L','O','N','G',
/* 0x14e4a = "VERR_RECORDING_CODEC_NOT_FOUND" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x06','\x40',
/* 0x14e5d = "VERR_HM_SUSPEND_PENDING" */
    '\x01','H','M','_','S','U','S','P','E','N','D','_','P','E','N','D','I','N','G',
/* 0x14e70 = "VERR_RECORDING_CODEC_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x06','\x83',
/* 0x14e83 = "VERR_DBG_UNWIND_INFO_NOT_FOUND" */
    '\x01','D','B','G','_','U','N','W','I','N','D','_','I','N','F','O','_','\x06','\x40',
/* 0x14e96 = "VERR_GVM_MISMATCH_VM_STRUCT_VER" */
    '\x01','G','V','M','_','\x19','_','\xc6','_','S','T','R','U','C','T','_','V','E','R',
/* 0x14ea9 = "Undesirable module." */
    'U','n','d','e','s','i','r','a','b','l','e',' ','m','o','d','u','l','e','.',
/* 0x14ebc = "VERR_SSM_IDE_ASYNC_TIMEOUT" */
    '\x01','\xb0','I','D','E','_','A','S','Y','N','C','_','T','I','M','E','O','U','T',
/* 0x14ecf = "VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE" */
    '\x01','T','A','R','_','\x1a','S','O','L','A','R','I','S','_','H','D','R','_','\xb3',
/* 0x14ee2 = "Unknown SPC PE image attribute." */
    '\xef','S','P','C',' ','P','E',' ','\x26','a','t','t','r','i','b','u','t','e','.',
/* 0x14ef5 = "Record header integrity error." */
    'R','e','c','o','r','d',' ','\xb4','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x14f08 = "VERR_IOM_INVALID_IOPORT_HANDLE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','H','A','N','D','L','E',
/* 0x14f1b = "VERR_GMM_MODULE_VERSION_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','\xbc','_','\x1b','L','O','N','G',
/* 0x14f2e = "Invalid value for cVirtualTicking." */
    '\x0c','\xf5','\x10','c','V','i','r','t','u','a','l','T','i','c','k','i','n','g','.',
/* 0x14f41 = "VERR_PDM_MISSING_INTERFACE_ABOVE" */
    '\x01','\x7d','\xc5','_','I','N','T','E','R','F','A','C','E','_','A','B','O','V','E',
/* 0x14f54 = "Failed to generate RSA key." */
    '\x8b','\x0a','g','e','n','e','r','a','t','e',' ','R','S','A',' ','k','e','y','.',
/* 0x14f67 = "Syntax error - a type conversion failed." */
    '\xfb','\x09','-',' ','a',' ','\xf3','c','o','n','v','e','r','s','i','o','n',' ','\x7b',
/* 0x14f7a = "The service module was not found." */
    '\x03','s','e','r','v','i','c','e',' ','m','o','d','u','l','e',' ','\x11','\x07','\x89',
/* 0x14f8d = "VERR_HTTP_SSL_CONNECT_ERROR" */
    '\x01','H','T','T','P','_','S','S','L','_','C','O','N','N','E','C','T','_','\x1c',
/* 0x14fa0 = "Public key is too small." */
    'P','u','b','l','i','c',' ','k','e','y',' ','\x0b','\x9e','s','m','a','l','l','.',
/* 0x14fb3 = "VERR_HTTP_ACCESS_DENIED" */
    '\x01','H','T','T','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x14fc6 = "Interface is unknown." */
    'I','n','t','e','r','f','a','c','e',' ','\x0b','u','n','k','n','o','w','n','.',
/* 0x14fd9 = "validation of the LX object table failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','L','X',' ','\xa8','\xb1','\x7b',
/* 0x14fec = "VERR_LDRMACHO_NON_CONT_SEG_BITS" */
    '\x01','\xe9','N','O','N','_','C','O','N','T','_','S','E','G','_','B','I','T','S',
/* 0x14fff = "VERR_DBG_CFG_NOT_UINT_PROP" */
    '\x01','D','B','G','_','C','F','G','_','\x06','U','I','N','T','_','P','R','O','P',
/* 0x15012 = "Connection refused." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','.',
/* 0x15025 = "VERR_IPC_SEND_CANCELLED" */
    '\x01','I','P','C','_','S','E','N','D','_','C','A','N','C','E','L','L','E','D',
/* 0x15038 = "VERR_ASN1_CURSOR_NO_MORE_DATA" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x60','M','O','R','E','_','D','A','T','A',
/* 0x1504b = "VERR_PDM_MISSING_INTERFACE_BELOW" */
    '\x01','\x7d','\xc5','_','I','N','T','E','R','F','A','C','E','_','B','E','L','O','W',
/* 0x1505e = "VERR_PDM_MODULE_NAME_CLASH" */
    '\x01','\x7d','M','O','D','U','L','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x15071 = "TM does not support the GIP version." */
    'T','M',' ','\xb2','\x07','\xd0','\x02','G','I','P',' ','v','e','r','s','i','o','n','.',
/* 0x15084 = "Unsupported firmware property." */
    '\x98','f','i','r','m','w','a','r','e',' ','p','r','o','p','e','r','t','y','.',
/* 0x15097 = "VERR_PDM_INVALID_DRIVER_HOST_BITS" */
    '\x01','\x7d','\x05','D','R','I','V','E','R','_','H','O','S','T','_','B','I','T','S',
/* 0x150aa = "VERR_WEB_NOT_AUTHENTICATED" */
    '\x01','W','E','B','_','\x06','A','U','T','H','E','N','T','I','C','A','T','E','D',
/* 0x150bd = "Pagetable not present." */
    'P','a','g','e','t','a','b','l','e',' ','\x07','p','r','e','s','e','n','t','.',
/* 0x150d0 = "VFS chain element expected at least two arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','l','e','a','s','t',' ','t','w','o',' ','\xde',
/* 0x150e3 = "Unknown SPC object moniker UUID." */
    '\xef','S','P','C',' ','\xa8','m','o','n','i','k','e','r',' ','U','U','I','D','.',
/* 0x150f6 = "No valid TSS present." */
    '\xe0','v','a','l','i','d',' ','T','S','S',' ','p','r','e','s','e','n','t','.',
/* 0x15109 = "VERR_CFGM_NOT_ENOUGH_SPACE" */
    '\x01','C','F','G','M','_','\x06','E','N','O','U','G','H','_','S','P','A','C','E',
/* 0x1511c = "The host kernel is too old." */
    '\x03','h','o','s','t',' ','k','e','r','n','e','l',' ','\x0b','\x9e','o','l','d','.',
/* 0x1512f = "Process Verification Failure: An image has too many sections." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','\x5c','\x9e','\xb5','s','e','c','t','i','o','n','s','.',
/* 0x15142 = "VERR_SHCLPB_EVENT_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','I','D','_','\x06','\x40',
/* 0x15155 = "VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','U','N','C','O','M','P','_','\xfa','_','\x19',
/* 0x15168 = "VERR_APIC_WRITE_INVALID" */
    '\x01','A','P','I','C','_','W','R','I','T','E','_','I','N','V','A','L','I','D',
/* 0x1517b = "VERR_SUPDRV_TRACER_BAD_ARG_FLAGS" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1d','A','R','G','_','F','L','A','G','S',
/* 0x1518e = "VINF_EM_PENDING_REQUEST" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','E','Q','U','E','S','T',
/* 0x151a1 = "VINF_PATM_PATCH_TRAP_PF" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','P','F',
/* 0x151b4 = "Wrong JSON type for date value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','d','a','t','e',' ','\xe8',
/* 0x151c7 = "VERR_VMX_UNABLE_TO_START_VM" */
    '\x01','\xe2','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xc6',
/* 0x151da = "Something is missing." */
    'S','o','m','e','t','h','i','n','g',' ','\x0b','m','i','s','s','i','n','g','.',
/* 0x151ed = "VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE" */
    '\x01','\x97','\x91','P','A','R','T','_','M','A','P','_','E','N','T','R','Y','_','\xb3',
/* 0x15200 = "Invalid GC physical range." */
    '\x0c','G','C',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e','.',
/* 0x15213 = "VINF_DBG_ADJUSTED_SYM_SIZE" */
    '\x0e','D','B','G','_','A','D','J','U','S','T','E','D','_','S','Y','M','_','\xfa',
/* 0x15226 = "VERR_PDM_INVALID_USB_REGISTRATION" */
    '\x01','\x7d','\x05','U','S','B','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x15239 = "VERR_TAR_EOS_MORE_INPUT" */
    '\x01','T','A','R','_','E','O','S','_','M','O','R','E','_','I','N','P','U','T',
/* 0x1524c = "VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS" */
    '\x01','\xd7','P','A','T','H','_','\x1b','\xac','C','O','M','P','O','N','E','N','T','S',
/* 0x1525f = "VINF_CR_KEY_WAS_DECRYPTED" */
    '\x0e','\x24','K','E','Y','_','W','A','S','_','D','E','C','R','Y','P','T','E','D',
/* 0x15272 = "VINF_PATM_PATCH_TRAP_GP" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','G','P',
/* 0x15285 = "VERR_PGM_MAPPINGS_DISABLED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','D','I','S','A','B','L','E','D',
/* 0x15298 = "VERR_CFGM_CONFIG_UNKNOWN_VALUE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\x91','V','A','L','U','E',
/* 0x152ab = "Certificate path validator: No trusted certificate paths." */
    '\xba','\xd2','\xff','\xe0','t','r','u','s','t','e','d',' ','\xa0','p','a','t','h','s','.',
/* 0x152be = "VFS chain element expected at most five arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','m','o','s','t',' ','f','i','v','e',' ','\xde',
/* 0x152d1 = "VERR_PDM_CFG_MISSING_DRIVER_NAME" */
    '\x01','\x7d','C','F','G','_','\xc5','_','D','R','I','V','E','R','_','N','A','M','E',
/* 0x152e4 = "Failed to stat a file/dir (hardening)." */
    '\x8b','\x0a','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','\xae',
/* 0x152f7 = "VERR_IOM_NOT_MMIO_RANGE_OWNER" */
    '\x01','I','O','M','_','\x06','\xd4','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x1530a = "HTTP Internal Server Error." */
    'H','T','T','P',' ','\x08','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x1531d = "VERR_FILESYSTEM_CORRUPT" */
    '\x01','F','I','L','E','S','Y','S','T','E','M','_','C','O','R','R','U','P','T',
/* 0x15330 = "VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH" */
    '\x01','\x24','S','P','C','_','I','N','D','_','D','A','T','A','_','\xbf','\xfa','_','\x19',
/* 0x15343 = "VERR_VRDP_ACCESS_DENIED" */
    '\x01','V','R','D','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x15356 = "VERR_BIGNUM_DIV_BY_ZERO" */
    '\x01','B','I','G','N','U','M','_','D','I','V','_','B','Y','_','Z','E','R','O',
/* 0x15369 = "VERR_DBGC_PARSE_WRITEONLY_SYMBOL" */
    '\x01','\xfd','\xe4','W','R','I','T','E','O','N','L','Y','_','S','Y','M','B','O','L',
/* 0x1537c = "Warning, the state changed." */
    'W','a','r','n','i','n','g',',',' ','\x02','\xcc','c','h','a','n','g','e','d','.',
/* 0x1538f = "Page hash mismatch." */
    'P','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x153a2 = "VERR_PGM_MAP_MMIO2_ALIAS_MMIO" */
    '\x01','\x8c','M','A','P','_','M','M','I','O','2','_','A','L','I','A','S','_','\xd4',
/* 0x153b5 = "VINF_VMX_MODIFIES_BEHAVIOR" */
    '\x0e','\xe2','M','O','D','I','F','I','E','S','_','B','E','H','A','V','I','O','R',
/* 0x153c8 = "OpenSSL d2i_PKCS7 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','P','K','C','S','7',' ','\x7b',
/* 0x153db = "VERR_PDM_DEVICE_NAME_CLASH" */
    '\x01','\x7d','D','E','V','I','C','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x153ee = "VERR_GIM_PVTSC_NOT_ENABLED" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x06','E','N','A','B','L','E','D',
/* 0x15401 = "The specified MMIO range was invalid." */
    '\x03','\x18','\xd4',' ','r','a','n','g','e',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x15414 = "VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED" */
    '\x01','\xe2','M','S','R','_','S','M','X','_','\xe2','E','N','A','B','L','E','_','\x17',
/* 0x15427 = "VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR" */
    '\x01','\x24','\xbf','O','S','S','L','_','\xbf','C','T','X','_','C','O','P','Y','_','\x1c',
/* 0x1543a = "VERR_VMX_MSR_ALL_VMX_DISABLED" */
    '\x01','\xe2','M','S','R','_','A','L','L','_','\xe2','D','I','S','A','B','L','E','D',
/* 0x1544d = "VERR_HARDAVL_UNBALANCED" */
    '\x01','H','A','R','D','A','V','L','_','U','N','B','A','L','A','N','C','E','D',
/* 0x15460 = "VERR_HM_UNKNOWN_IO_INSTRUCTION" */
    '\x01','H','M','_','\x91','I','O','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x15473 = "VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH" */
    '\x01','\x24','\xb7','C','E','R','T','_','S','I','G','N','_','A','L','G','O','_','\x19',
/* 0x15486 = "Shared Clipboard guest error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','\xbb','\x85',
/* 0x15499 = "Central directory file header corrupt." */
    'C','e','n','t','r','a','l',' ','\x25','\x22','\xb4','c','o','r','r','u','p','t','.',
/* 0x154ac = "VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST" */
    '\x01','\x24','\xe5','\xbf','A','L','G','O','_','\x06','\x40','_','I','N','_','L','I','S','T',
/* 0x154bf = "VINF_VMX_VMLAUNCH_VMRESUME" */
    '\x0e','\xe2','V','M','L','A','U','N','C','H','_','V','M','R','E','S','U','M','E',
/* 0x154d2 = "VERR_DWARF_LEB_OVERFLOW" */
    '\x01','D','W','A','R','F','_','L','E','B','_','O','V','E','R','F','L','O','W',
/* 0x154e5 = "VINF_ACCOUNT_RESTRICTED" */
    '\x0e','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x154f8 = "A path parameter was not set." */
    'A',' ','\xd2','p','a','r','a','m','e','t','e','r',' ','\x11','\x07','s','e','t','.',
/* 0x1550b = "VFS chain element expected at most four arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','m','o','s','t',' ','f','o','u','r',' ','\xde',
/* 0x1551e = "VERR_CPUM_INVALID_CONFIG_VALUE" */
    '\x01','C','P','U','M','_','\x05','C','O','N','F','I','G','_','V','A','L','U','E',
/* 0x15531 = "The image is outside the expected range." */
    '\x03','\x26','\x0b','o','u','t','s','i','d','e',' ','\x02','\xcb','r','a','n','g','e','.',
/* 0x15544 = "VERR_APIC_INTR_NOT_PENDING" */
    '\x01','A','P','I','C','_','I','N','T','R','_','\x06','P','E','N','D','I','N','G',
/* 0x15557 = "A signal is already pending." */
    'A',' ','s','i','g','n','a','l',' ','\x0b','\x80','p','e','n','d','i','n','g','.',
/* 0x1556a = "VERR_LDRPE_DELAY_IMPORT" */
    '\x01','L','D','R','P','E','_','D','E','L','A','Y','_','I','M','P','O','R','T',
/* 0x1557d = "Vote for another pass." */
    'V','o','t','e',' ','\x10','a','n','o','t','h','e','r',' ','p','a','s','s','.',
/* 0x15590 = "VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH" */
    '\x01','\x1f','\x82','V','O','L','U','M','E','_','S','P','A','C','E','_','\xfa','_','\x19',
/* 0x155a3 = "VERR_SEM_LV_WRONG_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','O','R','D','E','R',
/* 0x155b6 = "VERR_PDM_NO_ATTACHED_DRIVER" */
    '\x01','\x7d','\x60','A','T','T','A','C','H','E','D','_','D','R','I','V','E','R',
/* 0x155c8 = "VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE" */
    '\x01','\x90','A','P','I','P','O','R','T','_','O','P','E','N','_','\x1c','_','\xb3',
/* 0x155da = "Recompiler: Debug info internal processing error #2." */
    '\x13','D','e','b','u','g',' ','i','n','f','o',' ','\x16','\x04','\x09','#','2','.',
/* 0x155ec = "VERR_ISOMK_RR_NO_SPACE_FOR_CE" */
    '\x01','\x1f','R','R','_','\x60','S','P','A','C','E','_','F','O','R','_','C','E',
/* 0x155fe = "VERR_CR_PKIX_SIGNATURE_MISMATCH" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x19',
/* 0x15610 = "VERR_GMM_CHUNK_ALREADY_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x9b','M','A','P','P','E','D',
/* 0x15622 = "Unexpected filesystem object type." */
    '\x94','f','i','l','e','s','y','s','t','e','m',' ','\xa8','t','y','p','e','.',
/* 0x15634 = "VERR_COM_OBJECT_IN_USE" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','I','N','_','U','S','E',
/* 0x15646 = "VERR_MANIFEST_ATTR_TYPE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\xb3','_','\x19',
/* 0x15658 = "VERR_MAX_PROCS_REACHED" */
    '\x01','M','A','X','_','P','R','O','C','S','_','R','E','A','C','H','E','D',
/* 0x1566a = "Stream is not ready for requested operation." */
    'S','t','r','e','a','m',' ','\x0b','\x07','r','e','a','d','y',' ','\x10','\xdf','\xea',
/* 0x1567c = "Internal processing error #1 in the I/O port code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x84',
/* 0x1568e = "The per process timer is busy." */
    '\x03','p','e','r',' ','\x92','t','i','m','e','r',' ','\x0b','b','u','s','y','.',
/* 0x156a0 = "Logic bug in the DBGC code." */
    'L','o','g','i','c',' ','b','u','g',' ','\x0f','\x02','D','B','G','C',' ','\x84',
/* 0x156b2 = "VERR_NEM_GET_REGISTERS_FAILED" */
    '\x01','\xee','_','G','E','T','_','R','E','G','I','S','T','E','R','S','_','\x17',
/* 0x156c4 = "VERR_PDM_CRITSECT_ABORT_FAILED" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','_','A','B','O','R','T','_','\x17',
/* 0x156d6 = "MMIO region is not mapped." */
    '\xd4',' ','r','e','g','i','o','n',' ','\x0b','\x07','m','a','p','p','e','d','.',
/* 0x156e8 = "VERR_HGCM_INVALID_CMD_ADDRESS" */
    '\x01','H','G','C','M','_','\x05','C','M','D','_','A','D','D','R','E','S','S',
/* 0x156fa = "Footer integrity error." */
    'F','o','o','t','e','r',' ','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x1570c = "The value is not a byte string." */
    '\x03','\xf5','\x0b','\x07','a',' ','b','y','t','e',' ','s','t','r','i','n','g','.',
/* 0x1571e = "Seek below file start." */
    'S','e','e','k',' ','b','e','l','o','w',' ','\x22','s','t','a','r','t','.',
/* 0x15730 = "NEM failed to set registers." */
    '\xee',' ','\x99','\x0a','s','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x15742 = "NEM failed to get registers." */
    '\xee',' ','\x99','\x0a','g','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x15754 = "VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','\x05','\xf1',
/* 0x15766 = "VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED" */
    '\x01','\xa2','\xd6','_','\xb3','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x15778 = "FTP Internal Server Error." */
    'F','T','P',' ','\x08','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x1578a = "VERR_ISOFS_ICB_ENTRY_TOO_SMALL" */
    '\x01','\x97','I','C','B','_','E','N','T','R','Y','_','\x1b','S','M','A','L','L',
/* 0x1579c = "Data connection not found." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','\x07','\x89',
/* 0x157ae = "VERR_IEM_VAR_NOT_INITIALIZED" */
    '\x01','\x9c','V','A','R','_','\x06','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x157c0 = "VERR_SUP_VP_NOT_BUILD_CERT_IPE" */
    '\x01','\x95','\xbd','\x06','B','U','I','L','D','_','C','E','R','T','_','I','P','E',
/* 0x157d2 = "VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS" */
    '\x01','\x95','\xbd','\x1b','\xac','I','M','A','G','E','_','R','E','G','I','O','N','S',
/* 0x157e4 = "VERR_CFGM_INTEGER_TOO_BIG" */
    '\x01','C','F','G','M','_','I','N','T','E','G','E','R','_','\x1b','B','I','G',
/* 0x157f6 = "VERR_VFS_CHAIN_WRITE_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','W','R','I','T','E','_','O','N','L','Y','_','I','O','S',
/* 0x15808 = "VINF_EM_DBG_BREAKPOINT" */
    '\x0e','E','M','_','D','B','G','_','B','R','E','A','K','P','O','I','N','T',
/* 0x1581a = "VFS chain element expected at most two arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','m','o','s','t',' ','t','w','o',' ','\xde',
/* 0x1582c = "Not code selector." */
    'N','o','t',' ','c','o','d','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x1583e = "Too many CPUID leaves." */
    'T','o','o',' ','\xb5','C','P','U','I','D',' ','l','e','a','v','e','s','.',
/* 0x15850 = "VERR_SUP_VP_EXE_MISSING_NX_COMPAT" */
    '\x01','\x95','\xbd','E','X','E','_','\xc5','_','N','X','_','C','O','M','P','A','T',
/* 0x15862 = "Switch back to host." */
    'S','w','i','t','c','h',' ','b','a','c','k',' ','\x0a','h','o','s','t','.',
/* 0x15874 = "VERR_LDRVI_READ_ERROR_SIGNATURE" */
    '\x01','\xf4','R','E','A','D','_','\x1c','_','S','I','G','N','A','T','U','R','E',
/* 0x15886 = "VERR_LDR_FORWARDERS_NOT_SUPPORTED" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','S','_','\x06','\x83',
/* 0x15898 = "VERR_SSM_LIVE_POWERED_OFF" */
    '\x01','\xb0','L','I','V','E','_','P','O','W','E','R','E','D','_','O','F','F',
/* 0X158aa = "File/Device open failed." */
    'i','l','e','/','D','e','v','i','c','e',' ','o','p','e','n',' ','\x7b',
/* 0x158bb = "VERR_S3_BUCKET_ALREADY_EXISTS" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x9b','E','X','I','S','T','S',
/* 0x158cd = "VINF_EM_RAW_GUEST_TRAP" */
    '\x0e','E','M','_','R','A','W','_','G','U','E','S','T','_','T','R','A','P',
/* 0x158df = "VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET" */
    '\x01','\xa2','T','E','L','E','T','E','X','_','\x1a','C','H','A','R','S','E','T',
/* 0x158f1 = "VERR_ISOFS_INVALID_PARTITION_INDEX" */
    '\x01','\x97','\x05','P','A','R','T','I','T','I','O','N','_','I','N','D','E','X',
/* 0x15903 = "Key decryption is not supported." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','\x0b','\x07','\xa5',
/* 0x15915 = "VERR_VD_VDI_INVALID_SIGNATURE" */
    '\x01','V','D','_','V','D','I','_','\x05','S','I','G','N','A','T','U','R','E',
/* 0x15927 = "VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ" */
    '\x01','\xa2','T','E','L','E','T','E','X','_','\x91','E','S','C','_','S','E','Q',
/* 0x15939 = "Unsupported hashing function." */
    '\x98','h','a','s','h','i','n','g',' ','f','u','n','c','t','i','o','n','.',
/* 0x1594b = "Is a block device." */
    'I','s',' ','a',' ','b','l','o','c','k',' ','d','e','v','i','c','e','.',
/* 0x1595d = "Client has been rejected." */
    'C','l','i','e','n','t',' ','\x5c','\xcd','r','e','j','e','c','t','e','d','.',
/* 0x1596f = "VERR_JSON_ITERATOR_END" */
    '\x01','J','S','O','N','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x15981 = "VERR_TAR_BAD_CHKSUM_FIELD" */
    '\x01','T','A','R','_','\x1d','C','H','K','S','U','M','_','F','I','E','L','D',
/* 0x15993 = "VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO" */
    '\x01','\x24','\xb7','\x91','C','E','R','T','_','S','I','G','N','_','A','L','G','O',
/* 0x159a5 = "Protocol family not supported." */
    'P','r','o','t','o','c','o','l',' ','f','a','m','i','l','y',' ','\x07','\xa5',
/* 0x159b7 = "VINF_EM_RESCHEDULE_REM" */
    '\x0e','E','M','_','R','E','S','C','H','E','D','U','L','E','_','R','E','M',
/* 0x159c9 = "Invalid requested privilege level." */
    '\x0c','\xdf','p','r','i','v','i','l','e','g','e',' ','l','e','v','e','l','.',
/* 0x159db = "VERR_PGM_PHYS_NULL_PAGE_PARAM" */
    '\x01','\x8c','P','H','Y','S','_','N','U','L','L','_','\xce','P','A','R','A','M',
/* 0x159ed = "VERR_POLL_HANDLE_ID_NOT_FOUND" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','\x06','\x40',
/* 0x159ff = "VINF_PGM_HANDLER_ALREADY_ALIASED" */
    '\x0e','\x8c','H','A','N','D','L','E','R','_','\x9b','A','L','I','A','S','E','D',
/* 0x15a11 = "VERR_PGM_HANDLER_ALREADY_ALIASED" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x9b','A','L','I','A','S','E','D',
/* 0x15a23 = "VERR_SHARING_VIOLATION" */
    '\x01','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x15a35 = "Selector not present." */
    'S','e','l','e','c','t','o','r',' ','\x07','p','r','e','s','e','n','t','.',
/* 0x15a47 = "Device i/o: Bad unit." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9f','u','n','i','t','.',
/* 0x15a59 = "VERR_SSM_FIELD_INVALID_PADDING_SIZE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','P','A','D','D','I','N','G','_','\xfa',
/* 0x15a6b = "VWRN_CONTINUE_ANALYSIS" */
    '\xe6','C','O','N','T','I','N','U','E','_','A','N','A','L','Y','S','I','S',
/* 0x15a7d = "VERR_PDM_DRIVER_ALREADY_ATTACHED" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x9b','A','T','T','A','C','H','E','D',
/* 0x15a8f = "The page to be freed was already freed." */
    '\x03','\xbe','\x0a','\xa4','f','r','e','e','d',' ','\x11','\x80','f','r','e','e','d','.',
/* 0x15aa1 = "VERR_WRONG_PARAMETER_TYPE" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','\xb3',
/* 0x15ab3 = "Driver name clash." */
    'D','r','i','v','e','r',' ','n','a','m','e',' ','c','l','a','s','h','.',
/* 0x15ac5 = "Too many MMIO2 ranges." */
    'T','o','o',' ','\xb5','M','M','I','O','2',' ','r','a','n','g','e','s','.',
/* 0x15ad7 = "VERR_NEM_SET_REGISTERS_FAILED" */
    '\x01','\xee','_','S','E','T','_','R','E','G','I','S','T','E','R','S','_','\x17',
/* 0x15ae9 = "VINF_IEM_RECOMPILE_END_TB" */
    '\x0e','\x9c','R','E','C','O','M','P','I','L','E','_','E','N','D','_','T','B',
/* 0x15afb = "VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE" */
    '\x01','\x97','\x1a','L','O','G','I','C','A','L','_','B','L','O','C','K','_','\xfa',
/* 0x15b0d = "VINF_PERMISSION_DENIED" */
    '\x0e','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x15b1f = "VERR_LDRVI_BAD_CERT_HDR_LENGTH" */
    '\x01','\xf4','\x1d','C','E','R','T','_','H','D','R','_','L','E','N','G','T','H',
/* 0x15b31 = "VERR_NET_NO_BUFFER_SPACE" */
    '\x01','N','E','T','_','\x60','B','U','F','F','E','R','_','S','P','A','C','E',
/* 0x15b43 = "The shared module was not found." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','\x07','\x89',
/* 0x15b55 = "VERR_CFGM_CONFIG_UNKNOWN_NODE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\x91','N','O','D','E',
/* 0x15b67 = "VERR_ISOMK_IPE_EMPTY_COMPONENT" */
    '\x01','\x1f','\x14','E','M','P','T','Y','_','C','O','M','P','O','N','E','N','T',
/* 0x15b79 = "Syntax error - Invalid command name." */
    '\xfb','\x09','-',' ','\x0c','c','o','m','m','a','n','d',' ','n','a','m','e','.',
/* 0x15b8b = "VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ" */
    '\x01','\xa2','T','E','L','E','T','E','X','_','\x1a','E','S','C','_','S','E','Q',
/* 0x15b9d = "Expected valid data pointer for ASN." */
    '\xb8','v','a','l','i','d',' ','\x9d','p','o','i','n','t','e','r',' ','\x10','\xf6',
/* 0x15baf = "VERR_ISOMK_IMPORT_UDF_SPARSE_FILE" */
    '\x01','\x1f','\x82','U','D','F','_','S','P','A','R','S','E','_','F','I','L','E',
/* 0x15bc1 = "VERR_PERMISSION_DENIED" */
    '\x01','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x15bd3 = "VERR_MEDIA_NOT_RECOGNIZED" */
    '\x01','M','E','D','I','A','_','\x06','R','E','C','O','G','N','I','Z','E','D',
/* 0x15be5 = "EVP_EncryptFinal failed." */
    'E','V','P','_','E','n','c','r','y','p','t','F','i','n','a','l',' ','\x7b',
/* 0x15bf7 = "VERR_DBG_NO_LINE_NUMBERS" */
    '\x01','D','B','G','_','\x60','L','I','N','E','_','N','U','M','B','E','R','S',
/* 0x15c09 = "VERR_DWARF_UNKNOWN_LOC_OPCODE" */
    '\x01','D','W','A','R','F','_','\x91','L','O','C','_','O','P','C','O','D','E',
/* 0x15c1b = "The tracer has not been opened." */
    '\x03','t','r','a','c','e','r',' ','\x5c','\x07','\xcd','o','p','e','n','e','d','.',
/* 0x15c2d = "VERR_SELECTOR_NOT_PRESENT" */
    '\x01','S','E','L','E','C','T','O','R','_','\x06','P','R','E','S','E','N','T',
/* 0x15c3f = "VINF_SYS_MAY_POWER_OFF" */
    '\x0e','S','Y','S','_','M','A','Y','_','P','O','W','E','R','_','O','F','F',
/* 0x15c51 = "VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x1d','L','E','N','G','T','H','_','\xc8',
/* 0x15c63 = "Internal processing error #1 in the switcher code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','s','w','i','t','c','h','e','r',' ','\x84',
/* 0x15c75 = "VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING" */
    '\x01','\x95','\xbd','\x60','\x40','_','\x60','E','X','E','_','M','A','P','P','I','N','G',
/* 0x15c87 = "VERR_PGM_MAPPING_CONFLICT" */
    '\x01','\x8c','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x15c99 = "Expected a different string tag." */
    '\xb8','a',' ','d','i','f','f','e','r','e','n','t',' ','\xf2','t','a','g','.',
/* 0x15cab = "VERR_LDR_INVALID_LINK_ADDRESS" */
    '\x01','L','D','R','_','\x05','L','I','N','K','_','A','D','D','R','E','S','S',
/* 0x15cbd = "VERR_SUP_VP_SECTION_NOT_MAPPED" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','\x06','M','A','P','P','E','D',
/* 0x15ccf = "VWRN_NEGATIVE_UNSIGNED" */
    '\xe6','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x15ce1 = "MMIO region is already mapped." */
    '\xd4',' ','r','e','g','i','o','n',' ','\x0b','\x80','m','a','p','p','e','d','.',
/* 0x15cf3 = "Bad left tree height." */
    '\x9f','l','e','f','t',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x15d05 = "VERR_IEM_DBGINFO_OUT_OF_MEMORY" */
    '\x01','\x9c','D','B','G','I','N','F','O','_','O','U','T','_','O','F','_','\xb6',
/* 0x15d17 = "VERR_TRPM_NO_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','\x60','A','C','T','I','V','E','_','T','R','A','P',
/* 0x15d29 = "Bad file element in XAR table of content." */
    '\x9f','\x22','\x5e','\x0f','X','A','R',' ','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x15d3b = "Certificate path validator: No valid certificate policy." */
    '\xba','\xd2','\xff','\xe0','v','a','l','i','d',' ','\xa0','p','o','l','i','c','y','.',
/* 0x15d4d = "The value was truncated to fit." */
    '\x03','\xf5','\x11','t','r','u','n','c','a','t','e','d',' ','\x0a','f','i','t','.',
/* 0x15d5f = "EVP_DecryptFinal failed." */
    'E','V','P','_','D','e','c','r','y','p','t','F','i','n','a','l',' ','\x7b',
/* 0x15d71 = "VERR_VMM_SWITCHER_STUB" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','S','T','U','B',
/* 0x15d83 = "Import ISO contains a bad directory record." */
    '\xc4','\xc2',' ','\x8a','a',' ','b','a','d',' ','\x25','r','e','c','o','r','d','.',
/* 0x15d95 = "Device name clash." */
    'D','e','v','i','c','e',' ','n','a','m','e',' ','c','l','a','s','h','.',
/* 0x15da7 = "OpenSSL PKCS #7 verification failed." */
    'O','p','e','n','S','S','L',' ','P','K','C','S',' ','#','7',' ','\xf9','\x7b',
/* 0x15db9 = "Deprecated digest." */
    'D','e','p','r','e','c','a','t','e','d',' ','d','i','g','e','s','t','.',
/* 0x15dcb = "Symbol (export) not found." */
    'S','y','m','b','o','l',' ','(','e','x','p','o','r','t',')',' ','\x07','\x89',
/* 0x15ddd = "VERR_FDT_DTB_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','M','A','L','F','O','R','M','E','D',
/* 0x15def = "VERR_PDM_TRANSLATION_NOT_SET" */
    '\x01','\x7d','T','R','A','N','S','L','A','T','I','O','N','_','\x06','S','E','T',
/* 0x15e01 = "VERR_DBGC_PARSE_INCORRECT_ARG_TYPE" */
    '\x01','\xfd','\xe4','I','N','C','O','R','R','E','C','T','_','A','R','G','_','\xb3',
/* 0x15e13 = "VERR_CONCURRENT_ACCESS" */
    '\x01','C','O','N','C','U','R','R','E','N','T','_','A','C','C','E','S','S',
/* 0x15e25 = "VERR_SYMBOL_VALUE_TOO_BIG" */
    '\x01','S','Y','M','B','O','L','_','V','A','L','U','E','_','\x1b','B','I','G',
/* 0x15e37 = "VERR_LDRELF_ODD_ENDIAN" */
    '\x01','L','D','R','E','L','F','_','O','D','D','_','E','N','D','I','A','N',
/* 0x15e49 = "VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH" */
    '\x01','\x1f','\x82','\x1d','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x15e5b = "VINF_IEM_YIELD_PENDING_FF" */
    '\x0e','\x9c','Y','I','E','L','D','_','P','E','N','D','I','N','G','_','F','F',
/* 0x15e6d = "VERR_IS_A_BLOCK_DEVICE" */
    '\x01','I','S','_','A','_','B','L','O','C','K','_','D','E','V','I','C','E',
/* 0x15e7f = "Invalid signature length." */
    '\x0c','s','i','g','n','a','t','u','r','e',' ','l','e','n','g','t','h','.',
/* 0x15e91 = "VERR_GMM_CHUNK_NOT_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x06','M','A','P','P','E','D',
/* 0x15ea3 = "VERR_SEM_LV_INVALID_PARAMETER" */
    '\x01','S','E','M','_','L','V','_','\x05','P','A','R','A','M','E','T','E','R',
/* 0x15eb5 = "VERR_ISOFS_TAG_IS_ALL_ZEROS" */
    '\x01','\x97','T','A','G','_','I','S','_','A','L','L','_','Z','E','R','O','S',
/* 0x15ec7 = "VERR_HM_WRONG_SWITCHER" */
    '\x01','H','M','_','W','R','O','N','G','_','S','W','I','T','C','H','E','R',
/* 0x15ed9 = "VERR_CALLER_NO_REFERENCE" */
    '\x01','C','A','L','L','E','R','_','\x60','R','E','F','E','R','E','N','C','E',
/* 0x15eeb = "Pending VM request packet." */
    'P','e','n','d','i','n','g',' ','\xc6',' ','\xab','p','a','c','k','e','t','.',
/* 0x15efd = "Permission denied." */
    'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','.',
/* 0x15f0f = "Recompiler: Out of stack slots." */
    '\x13','O','u','t',' ','\x15','s','t','a','c','k',' ','s','l','o','t','s','.',
/* 0x15f21 = "VERR_VFS_CHAIN_TAKES_DIR_OR_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','D','I','R','_','O','R','_','\x8d',
/* 0x15f33 = "VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO" */
    '\x01','\x1f','\x82','\x05','V','O','L','U','M','N','E','_','S','E','Q','_','N','O',
/* 0x15f45 = "VERR_PATH_IS_NOT_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','\x06','R','E','L','A','T','I','V','E',
/* 0x15f57 = "VERR_VM_SAVE_STATE_NOT_ALLOWED" */
    '\x01','\xc6','_','S','A','V','E','_','\xf1','_','\x06','A','L','L','O','W','E','D',
/* 0x15f69 = "VERR_IEM_EMIT_BAD_SEG_REG_NO" */
    '\x01','\x9c','E','M','I','T','_','\x1d','S','E','G','_','R','E','G','_','N','O',
/* 0x15f7b = "VERR_IOM_IOPORT_UNUSED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','U','N','U','S','E','D',
/* 0x15f8d = "Process Verification Failure: Error opening image file." */
    '\x1e','\x0d','\x12','\xc1','o','p','e','n','i','n','g',' ','\x26','f','i','l','e','.',
/* 0x15f9f = "VERR_EM_GUEST_CPU_HANG" */
    '\x01','E','M','_','G','U','E','S','T','_','C','P','U','_','H','A','N','G',
/* 0x15fb1 = "Internal processing error #3 in the I/O port code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x84',
/* 0x15fc3 = "Process Verification Failure: Bad image base in header." */
    '\x1e','\x0d','\x12','\x9f','\x26','b','a','s','e',' ','\x0f','h','e','a','d','e','r','.',
/* 0x15fd5 = "iSCSI: Invalid header, i." */
    'i','S','C','S','I',':',' ','\x0c','h','e','a','d','e','r',',',' ','i','.',
/* 0x15fe7 = "VERR_LDRLX_NRICHAIN_NOT_SUPPORTED" */
    '\x01','L','D','R','L','X','_','N','R','I','C','H','A','I','N','_','\x06','\x83',
/* 0x15ff9 = "VERR_ISOFS_NO_ADS_FOR_UDF_DIR" */
    '\x01','\x97','\x60','A','D','S','_','F','O','R','_','U','D','F','_','D','I','R',
/* 0x1600b = "The specified path has too many components (hardening)." */
    '\x03','\x18','\xd2','\x5c','\x9e','\xb5','c','o','m','p','o','n','e','n','t','s',' ','\xae',
/* 0x1601d = "VERR_VBGL_NOT_INITIALIZED" */
    '\x01','V','B','G','L','_','\x06','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x1602f = "Process Verification Failure: Bad virtual section size." */
    '\x1e','\x0d','\x12','\x9f','v','i','r','t','u','a','l',' ','\xdd','s','i','z','e','.',
/* 0x16041 = "VERR_IOM_FF_STATUS_IPE" */
    '\x01','I','O','M','_','F','F','_','S','T','A','T','U','S','_','I','P','E',
/* 0x16053 = "VERR_VSCSI_LUN_INVALID" */
    '\x01','V','S','C','S','I','_','L','U','N','_','I','N','V','A','L','I','D',
/* 0x16065 = "VERR_CPUM_UNSUPPORTED_ID_REGISTER" */
    '\x01','C','P','U','M','_','\x1a','I','D','_','R','E','G','I','S','T','E','R',
/* 0x16077 = "Unknown allocation descriptor type." */
    '\xef','a','l','l','o','c','a','t','i','o','n',' ','\xe3','t','y','p','e','.',
/* 0x16089 = "VINF_CPUM_R3_MSR_WRITE" */
    '\x0e','C','P','U','M','_','R','3','_','M','S','R','_','W','R','I','T','E',
/* 0x1609b = "VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH" */
    '\x01','\x1f','\x82','V','O','L','U','M','E','_','I','N','_','S','E','T','_','\x19',
/* 0x160ad = "Expected ECDSA public key." */
    '\xb8','E','C','D','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x160bf = "The PE loader doesn't support the TLS data directory yet." */
    '\x03','P','E',' ','\xda','\xc9','\xd0','\x02','T','L','S',' ','\x9d','\x25','y','e','t','.',
/* 0x160d1 = "VERR_IOM_INVALID_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x160e3 = "Process Verification Failure: An image has too many regions." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','\x5c','\x9e','\xb5','r','e','g','i','o','n','s','.',
/* 0x160f5 = "VERR_SEM_LV_NOT_SIGNALLER" */
    '\x01','S','E','M','_','L','V','_','\x06','S','I','G','N','A','L','L','E','R',
/* 0x16107 = "Recompiler: Debug info internal processing error #1." */
    '\x13','D','e','b','u','g',' ','i','n','f','o',' ','\x16','\x04','\x09','#','1','.',
/* 0x16119 = "VERR_IEM_INSTR_BUF_TOO_LARGE" */
    '\x01','\x9c','I','N','S','T','R','_','B','U','F','_','\x1b','L','A','R','G','E',
/* 0x1612b = "VERR_ISOFS_UDF_NOT_IMPLEMENTED" */
    '\x01','\x97','U','D','F','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1613d = "Unexpected unstable VM state." */
    '\x94','u','n','s','t','a','b','l','e',' ','\xc6',' ','s','t','a','t','e','.',
/* 0x1614f = "VERR_SSM_VIRTUAL_CLOCK_HZ" */
    '\x01','\xb0','V','I','R','T','U','A','L','_','C','L','O','C','K','_','H','Z',
/* 0x16161 = "VERR_IPC_RECEIVE_MAP_FAILED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','M','A','P','_','\x17',
/* 0x16173 = "Internal processing error #2 in the I/O port code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x84',
/* 0x16185 = "Undefined VM exit code." */
    'U','n','d','e','f','i','n','e','d',' ','\xc6',' ','e','x','i','t',' ','\x84',
/* 0x16197 = "VERR_ASN1_TIME_NORMALIZE_MISMATCH" */
    '\x01','\xa2','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x19',
/* 0x161a9 = "VERR_FDT_AT_ROOT_LEVEL" */
    '\x01','F','D','T','_','A','T','_','R','O','O','T','_','L','E','V','E','L',
/* 0x161bb = "VERR_CR_KEY_DECRYPTION_FAILED" */
    '\x01','\x24','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x17',
/* 0x161cd = "VERR_FAILED_TO_SET_SELF_TLS" */
    '\x01','\x17','_','T','O','_','S','E','T','_','S','E','L','F','_','T','L','S',
/* 0x161df = "VERR_ASN1_TIME_NORMALIZE_ERROR" */
    '\x01','\xa2','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x1c',
/* 0x161f1 = "VERR_PKZIP_BAD_CDF_HEADER" */
    '\x01','P','K','Z','I','P','_','\x1d','C','D','F','_','H','E','A','D','E','R',
/* 0x16203 = "VERR_XML_TOC_ELEMENT_MISSING" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','\xc5',
/* 0x16215 = "OpenSSL d2i_X509 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','X','5','0','9',' ','\x7b',
/* 0x16227 = "Receive cancelled." */
    'R','e','c','e','i','v','e',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x16239 = "VERR_NEGATIVE_UNSIGNED" */
    '\x01','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x1624b = "VERR_PGM_NO_CR3_SHADOW_ROOT" */
    '\x01','\x8c','\x60','C','R','3','_','S','H','A','D','O','W','_','R','O','O','T',
/* 0x1625d = "VERR_MAX_THRDS_REACHED" */
    '\x01','M','A','X','_','T','H','R','D','S','_','R','E','A','C','H','E','D',
/* 0X1626f = "Deadlock detected." */
    'e','a','d','l','o','c','k',' ','d','e','t','e','c','t','e','d','.',
/* 0x16280 = "VFS chain element expected at most six arguments." */
    '\x8d',' ','\xa1','\x5e','\xcb','a','t',' ','m','o','s','t',' ','s','i','x',' ','\xde',
/* 0x16292 = "VERR_PGM_PHYS_HANDLER_IPE" */
    '\x01','\x8c','P','H','Y','S','_','H','A','N','D','L','E','R','_','I','P','E',
/* 0x162a4 = "VERR_SUPDRV_TRACER_UNLOADING" */
    '\x01','\x90','T','R','A','C','E','R','_','U','N','L','O','A','D','I','N','G',
/* 0x162b6 = "The I/O request is in an invalid state for this operation." */
    '\x03','I','/','O',' ','\xab','\x0b','\x0f','\x87','\x8f','\xcc','\x10','t','h','i','s',' ','\xea',
/* 0x162c8 = "VERR_PKZIP_NAME_TOO_LONG" */
    '\x01','P','K','Z','I','P','_','N','A','M','E','_','\x1b','L','O','N','G',
/* 0x162d9 = "VERR_SUP_VP_NO_NTDLL_MAPPING" */
    '\x01','\x95','\xbd','\x60','N','T','D','L','L','_','M','A','P','P','I','N','G',
/* 0x162ea = "VERR_IMAGE_BASE_TOO_HIGH" */
    '\x01','I','M','A','G','E','_','B','A','S','E','_','\x1b','H','I','G','H',
/* 0x162fb = "VERR_NET_NOT_UNIQUE_NAME" */
    '\x01','N','E','T','_','\x06','U','N','I','Q','U','E','_','N','A','M','E',
/* 0x1630c = "VERR_NET_OPERATION_NOT_SUPPORTED" */
    '\x01','N','E','T','_','O','P','E','R','A','T','I','O','N','_','\x06','\x83',
/* 0x1631d = "VERR_PDM_NOT_PCI_BUS_MASTER" */
    '\x01','\x7d','\x06','P','C','I','_','B','U','S','_','M','A','S','T','E','R',
/* 0x1632e = "VERR_VD_CACHE_ALREADY_EXISTS" */
    '\x01','V','D','_','C','A','C','H','E','_','\x9b','E','X','I','S','T','S',
/* 0x1633f = "VERR_MANIFEST_ATTR_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\x06','\x40',
/* 0x16350 = "VERR_NOT_ALL_CPUS_SHOWED" */
    '\x01','\x06','A','L','L','_','C','P','U','S','_','S','H','O','W','E','D',
/* 0x16361 = "VWRN_PATCH_END_BRANCH" */
    '\xe6','P','A','T','C','H','_','E','N','D','_','B','R','A','N','C','H',
/* 0x16372 = "VERR_POLL_SET_IS_FULL" */
    '\x01','P','O','L','L','_','S','E','T','_','I','S','_','F','U','L','L',
/* 0x16383 = "VINF_GIM_R3_HYPERCALL" */
    '\x0e','G','I','M','_','R','3','_','H','Y','P','E','R','C','A','L','L',
/* 0x16394 = "VERR_DBG_NOT_NM_MAP_FILE" */
    '\x01','D','B','G','_','\x06','N','M','_','M','A','P','_','F','I','L','E',
/* 0x163a5 = "Unexpected end of DWARF unit." */
    '\x94','e','n','d',' ','\x15','D','W','A','R','F',' ','u','n','i','t','.',
/* 0x163b6 = "VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE" */
    '\x01','\x95','\xbd','\x88','I','M','A','G','E','_','M','A','C','H','I','N','E',
/* 0x163c7 = "VINF_BUFFER_UNDERFLOW" */
    '\x0e','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x163d8 = "VERR_PATH_ZERO_LENGTH" */
    '\x01','P','A','T','H','_','Z','E','R','O','_','L','E','N','G','T','H',
/* 0x163e9 = "VERR_NET_NOT_UNSUPPORTED" */
    '\x01','N','E','T','_','\x06','U','N','S','U','P','P','O','R','T','E','D',
/* 0x163fa = "Unsupported CPU ID register." */
    '\x98','C','P','U',' ','I','D',' ','r','e','g','i','s','t','e','r','.',
/* 0x1640b = "Address conflict." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t','.',
/* 0x1641c = "VERR_CFGM_NODE_EXISTS" */
    '\x01','C','F','G','M','_','N','O','D','E','_','E','X','I','S','T','S',
/* 0x1642d = "VERR_VD_VMDK_VALUE_NOT_FOUND" */
    '\x01','V','D','_','V','M','D','K','_','V','A','L','U','E','_','\x06','\x40',
/* 0x1643e = "VINF_EM_RAW_IRET_TRAP" */
    '\x0e','E','M','_','R','A','W','_','I','R','E','T','_','T','R','A','P',
/* 0x1644f = "VERR_PKZIP_BAD_LF_HEADER" */
    '\x01','P','K','Z','I','P','_','\x1d','L','F','_','H','E','A','D','E','R',
/* 0x16460 = "VERR_PGM_SAVED_ROM_PAGE_PROT" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','\xce','P','R','O','T',
/* 0x16471 = "VERR_VM_REQUEST_KILLED" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','K','I','L','L','E','D',
/* 0x16482 = "Address overflow." */
    'A','d','d','r','e','s','s',' ','o','v','e','r','f','l','o','w','.',
/* 0x16493 = "VERR_ISOFS_FSD_NEXT_EXTENT" */
    '\x01','\x97','F','S','D','_','N','E','X','T','_','E','X','T','E','N','T',
/* 0x164a4 = "No node was specified." */
    '\xe0','n','o','d','e',' ','\x11','s','p','e','c','i','f','i','e','d','.',
/* 0x164b5 = "VINF_CPUM_R3_MSR_READ" */
    '\x0e','C','P','U','M','_','R','3','_','M','S','R','_','R','E','A','D',
/* 0x164c6 = "VERR_THREAD_NOT_WAITABLE" */
    '\x01','T','H','R','E','A','D','_','\x06','W','A','I','T','A','B','L','E',
/* 0x164d7 = "No attached driver." */
    '\xe0','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x164e8 = "VERR_IPC_SEND_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','T','I','M','E','O','U','T',
/* 0x164f9 = "VERR_DBGF_BP_L1_LOOKUP_FAILED" */
    '\x01','\xb9','_','B','P','_','L','1','_','L','O','O','K','U','P','_','\x17',
/* 0x1650a = "Version mismatch." */
    'V','e','r','s','i','o','n',' ','m','i','s','m','a','t','c','h','.',
/* 0x1651b = "EVP_DecryptInit failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t',' ','\x7b',
/* 0x1652c = "VERR_LDRLX_BAD_FORWARDER" */
    '\x01','L','D','R','L','X','_','\x1d','F','O','R','W','A','R','D','E','R',
/* 0x1653d = "Buffer underflow." */
    'B','u','f','f','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x1654e = "Encoding skipped." */
    'E','n','c','o','d','i','n','g',' ','s','k','i','p','p','e','d','.',
/* 0x1655f = "VERR_FILE_AIO_IN_PROGRESS" */
    '\x01','\xaa','A','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x16570 = "VINF_OBJECT_DESTROYED" */
    '\x0e','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x16581 = "Stop the UDP server." */
    'S','t','o','p',' ','\x02','U','D','P',' ','s','e','r','v','e','r','.',
/* 0x16592 = "Image is read-only." */
    'I','m','a','g','e',' ','\x0b','r','e','a','d','-','o','n','l','y','.',
/* 0x165a3 = "VERR_PATCHING_REFUSED" */
    '\x01','P','A','T','C','H','I','N','G','_','R','E','F','U','S','E','D',
/* 0x165b4 = "VERR_ISOFS_BOGUS_UDF_DIR_SIZE" */
    '\x01','\x97','B','O','G','U','S','_','U','D','F','_','D','I','R','_','\xfa',
/* 0x165c5 = "VINF_IEM_REEXEC_BREAK_FF" */
    '\x0e','\x9c','R','E','E','X','E','C','_','B','R','E','A','K','_','F','F',
/* 0x165d6 = "Internal processing error #2 in the DBGF stack code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','s','t','a','c','k',' ','\x84',
/* 0x165e7 = "VERR_VD_ISCSI_INVALID_HEADER" */
    '\x01','V','D','_','I','S','C','S','I','_','\x05','H','E','A','D','E','R',
/* 0x165f8 = "VERR_S3_ACCESS_DENIED" */
    '\x01','S','3','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x16609 = "VERR_LDRLX_BAD_ITERDATA2" */
    '\x01','L','D','R','L','X','_','\x1d','I','T','E','R','D','A','T','A','2',
/* 0x1661a = "VERR_EXTPACK_VBOX_VERSION_MISMATCH" */
    '\x01','E','X','T','P','A','C','K','_','V','B','O','X','_','\xbc','_','\x19',
/* 0x1662b = "VERR_SSM_STRUCTURE_MAGIC" */
    '\x01','\xb0','S','T','R','U','C','T','U','R','E','_','M','A','G','I','C',
/* 0x1663c = "VERR_ASN1_CURSOR_LONG_TAG" */
    '\x01','\xa2','C','U','R','S','O','R','_','L','O','N','G','_','T','A','G',
/* 0x1664d = "VERR_PLATFORM_ARCH_NOT_SUPPORTED" */
    '\x01','P','L','A','T','F','O','R','M','_','A','R','C','H','_','\x06','\x83',
/* 0x1665e = "The PKCS #7 content is not data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xf0','\x0b','\x07','d','a','t','a','.',
/* 0x1666f = "VERR_NEM_MISSING_KERNEL_API_5" */
    '\x01','\xee','_','\xc5','_','K','E','R','N','E','L','_','A','P','I','_','5',
/* 0x16680 = "VERR_PATH_IS_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','R','E','L','A','T','I','V','E',
/* 0x16691 = "VERR_DBGC_PARSE_NO_RANGE_ALLOWED" */
    '\x01','\xfd','\xe4','\x60','R','A','N','G','E','_','A','L','L','O','W','E','D',
/* 0x166a2 = "VERR_SUPDRV_VTG_ALREADY_REGISTERED" */
    '\x01','\x90','V','T','G','_','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x166b3 = "VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS" */
    '\x01','\xfd','\xe4','\x1b','F','E','W','_','A','R','G','U','M','E','N','T','S',
/* 0x166c4 = "Generic out of resources error." */
    '\xa7','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s',' ','\x85',
/* 0x166d5 = "VERR_OBJECT_DESTROYED" */
    '\x01','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x166e6 = "VERR_SSM_FIELD_INVALID_CALLBACK" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','C','A','L','L','B','A','C','K',
/* 0x166f7 = "VERR_NEM_MISSING_KERNEL_API_4" */
    '\x01','\xee','_','\xc5','_','K','E','R','N','E','L','_','A','P','I','_','4',
/* 0x16708 = "validation of LX header failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','L','X',' ','\xb4','\x7b',
/* 0x16719 = "Bad file mode for XAR file." */
    '\x9f','\x22','m','o','d','e',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x1672a = "Expected RSA private key." */
    '\xb8','R','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x1673b = "VERR_CR_PKCS7_EXPECTED_NO_CRLS" */
    '\x01','\x24','\xe5','E','X','P','E','C','T','E','D','_','\x60','C','R','L','S',
/* 0x1674c = "VERR_IPC_SEND_ABORTED" */
    '\x01','I','P','C','_','S','E','N','D','_','A','B','O','R','T','E','D',
/* 0x1675d = "VERR_SERVICE_DISABLED" */
    '\x01','S','E','R','V','I','C','E','_','D','I','S','A','B','L','E','D',
/* 0x1676e = "VERR_XAR_TOC_STRLEN_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','S','T','R','L','E','N','_','\x19',
/* 0x1677f = "Pipe is not connected." */
    'P','i','p','e',' ','\x0b','\x07','c','o','n','n','e','c','t','e','d','.',
/* 0x16790 = "Patch was already disabled." */
    'P','a','t','c','h',' ','\x11','\x80','d','i','s','a','b','l','e','d','.',
/* 0x167a1 = "VERR_DBG_NO_UNWIND_INFO" */
    '\x01','D','B','G','_','\x60','U','N','W','I','N','D','_','I','N','F','O',
/* 0x167b2 = "Syntax error - buggy parser." */
    '\xfb','\x09','-',' ','b','u','g','g','y',' ','p','a','r','s','e','r','.',
/* 0x167c3 = "VERR_SUP_VP_STUB_THREAD_NOT_FOUND" */
    '\x01','\x95','\xbd','S','T','U','B','_','T','H','R','E','A','D','_','\x06','\x40',
/* 0x167d4 = "VERR_PATM_UNSAFE_CODE" */
    '\x01','P','A','T','M','_','U','N','S','A','F','E','_','C','O','D','E',
/* 0x167e5 = "VWRN_DANGLING_OBJECTS" */
    '\xe6','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x167f6 = "The block driver type wasn\'t supported." */
    '\x03','b','l','o','c','k',' ','\xc7','\xf3','w','a','s','n','\'','t',' ','\xa5',
/* 0x16807 = "Invalid escape sequence." */
    '\x0c','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x16818 = "VERR_VGA_GL_SYMBOL_NOT_FOUND" */
    '\x01','V','G','A','_','G','L','_','S','Y','M','B','O','L','_','\x06','\x40',
/* 0x16829 = "VERR_URI_ESCAPED_ZERO" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','Z','E','R','O',
/* 0x1683a = "Call interrupted." */
    'C','a','l','l',' ','i','n','t','e','r','r','u','p','t','e','d','.',
/* 0x1684b = "Stop the TCP server." */
    'S','t','o','p',' ','\x02','T','C','P',' ','s','e','r','v','e','r','.',
/* 0x1685c = "VERR_L4_DS_MANAGER_NOT_FOUND" */
    '\x01','L','4','_','D','S','_','M','A','N','A','G','E','R','_','\x06','\x40',
/* 0x1686d = "VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS" */
    '\x01','\x95','\xbd','\x88','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x1687e = "Device i/o: CRC error." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','C','R','C',' ','\x85',
/* 0x1688f = "Bad new tree height." */
    '\x9f','n','e','w',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x168a0 = "Generic unexpected object ID error." */
    '\xa7','u','n','e','x','p','e','c','t','e','d',' ','\xa8','I','D',' ','\x85',
/* 0x168b1 = "VERR_ADDRESS_CONFLICT" */
    '\x01','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x168c2 = "VERR_SUPDRV_TRACER_NOT_PRESENT" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','P','R','E','S','E','N','T',
/* 0x168d3 = "VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED" */
    '\x01','\xe9','O','T','H','E','R','_','E','N','D','I','A','N','_','\x06','\x83',
/* 0x168e4 = "VERR_VFS_CHAIN_READ_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','R','E','A','D','_','O','N','L','Y','_','I','O','S',
/* 0x168f5 = "The server was stopped." */
    '\x03','s','e','r','v','e','r',' ','\x11','s','t','o','p','p','e','d','.',
/* 0x16906 = "RamPreAlloc not set." */
    'R','a','m','P','r','e','A','l','l','o','c',' ','\x07','s','e','t','.',
/* 0x16917 = "VERR_NET_TOO_MANY_REFERENCES" */
    '\x01','N','E','T','_','\x1b','\xac','R','E','F','E','R','E','N','C','E','S',
/* 0x16928 = "VERR_TRPM_BAD_TRAP_IN_OP" */
    '\x01','T','R','P','M','_','\x1d','T','R','A','P','_','I','N','_','O','P',
/* 0x16939 = "VERR_ASN1_OBJID_INVALID_DOTTED_STRING" */
    '\x01','\xa2','O','B','J','I','D','_','\x05','D','O','T','T','E','D','_','\xd6',
/* 0x1694a = "VERR_FTP_DATA_CONN_NOT_FOUND" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','\x06','\x40',
/* 0x1695b = "Value out of range." */
    'V','a','l','u','e',' ','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x1696c = "VERR_TRPM_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','A','C','T','I','V','E','_','T','R','A','P',
/* 0x1697d = "VERR_GMM_CHUNK_INSERT" */
    '\x01','G','M','M','_','C','H','U','N','K','_','I','N','S','E','R','T',
/* 0x1698e = "VERR_CR_STORE_GENERIC_ERROR" */
    '\x01','\x24','S','T','O','R','E','_','G','E','N','E','R','I','C','_','\x1c',
/* 0x1699f = "VERR_VFS_CHAIN_ONLY_DIR_OR_VFS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','D','I','R','_','O','R','_','\x8d',
/* 0x169b0 = "Bad forwarder entry." */
    '\x9f','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x169c1 = "VERR_DBGC_PARSE_EMPTY_ARGUMENT" */
    '\x01','\xfd','\xe4','E','M','P','T','Y','_','A','R','G','U','M','E','N','T',
/* 0x169d2 = "EVP_EncryptInit failed." */
    'E','V','P','_','E','n','c','r','y','p','t','I','n','i','t',' ','\x7b',
/* 0x169e3 = "VINF_VHWA_CMD_PENDING" */
    '\x0e','V','H','W','A','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x169f4 = "VERR_VGA_INVALID_CUSTOM_MODE" */
    '\x01','V','G','A','_','\x05','C','U','S','T','O','M','_','M','O','D','E',
/* 0x16a05 = "VERR_DBGF_NO_MORE_BP_SLOTS" */
    '\x01','\xb9','_','\x60','M','O','R','E','_','B','P','_','S','L','O','T','S',
/* 0x16a16 = "VERR_PGM_DYNMAP_FULL_SET" */
    '\x01','\x8c','D','Y','N','M','A','P','_','F','U','L','L','_','S','E','T',
/* 0x16a27 = "VERR_SUP_VP_NT_QI_THREAD_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','T','H','R','E','A','D','_','\x1c',
/* 0x16a38 = "VERR_SSM_GCPHYS_OVERFLOW" */
    '\x01','\xb0','G','C','P','H','Y','S','_','O','V','E','R','F','L','O','W',
/* 0x16a49 = "The I/O request is in progress." */
    '\x03','I','/','O',' ','\xab','\x0b','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x16a5a = "VERR_VFS_CHAIN_TAKES_FILE_OR_IOS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','\xaa','O','R','_','I','O','S',
/* 0x16a6b = "Generic USB device structure version mismatch." */
    '\xa7','U','S','B',' ','\xa3','\xec','\xd1','m','i','s','m','a','t','c','h','.',
/* 0x16a7c = "VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','\xb3','_','\x19','_','P','A','T','H','_','O','N','L','Y',
/* 0x16a8d = "VERR_PGM_PHYS_PAGE_BALLOONED" */
    '\x01','\x8c','P','H','Y','S','_','\xce','B','A','L','L','O','O','N','E','D',
/* 0x16a9e = "VINF_SSM_DONT_CALL_AGAIN" */
    '\x0e','\xb0','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x16aaf = "VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','\xbc','_','\x06','\x83',
/* 0x16ac0 = "VERR_GVMM_BROKEN_IPRT" */
    '\x01','G','V','M','M','_','B','R','O','K','E','N','_','I','P','R','T',
/* 0x16ad1 = "VERR_NEM_MISSING_KERNEL_API_2" */
    '\x01','\xee','_','\xc5','_','K','E','R','N','E','L','_','A','P','I','_','2',
/* 0x16ae2 = "VWRN_OUT_OF_RESOURCES" */
    '\xe6','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x16af3 = "VERR_NEM_MISSING_KERNEL_API_1" */
    '\x01','\xee','_','\xc5','_','K','E','R','N','E','L','_','A','P','I','_','1',
/* 0x16b04 = "VERR_NEM_MISSING_KERNEL_API_3" */
    '\x01','\xee','_','\xc5','_','K','E','R','N','E','L','_','A','P','I','_','3',
/* 0x16b15 = "VERR_DANGLING_OBJECTS" */
    '\x01','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x16b26 = "The requested type conversion was not supported." */
    '\x03','\xdf','\xf3','c','o','n','v','e','r','s','i','o','n',' ','\x11','\x07','\xa5',
/* 0x16b37 = "Expected a provider name." */
    '\xb8','a',' ','p','r','o','v','i','d','e','r',' ','n','a','m','e','.',
/* 0x16b48 = "VERR_CFGM_LEAF_EXISTS" */
    '\x01','C','F','G','M','_','L','E','A','F','_','E','X','I','S','T','S',
/* 0x16b59 = "Internal processing error #1 in the DBGF stack code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','s','t','a','c','k',' ','\x84',
/* 0x16b6a = "VINF_PCI_MAPPING_DONE" */
    '\x0e','P','C','I','_','M','A','P','P','I','N','G','_','D','O','N','E',
/* 0x16b7b = "Out of range enum value." */
    'O','u','t',' ','\x15','r','a','n','g','e',' ','e','n','u','m',' ','\xe8',
/* 0x16b8c = "The LUN is still busy." */
    '\x03','L','U','N',' ','\x0b','s','t','i','l','l',' ','b','u','s','y','.',
/* 0x16b9d = "VERR_URI_INVALID_PORT_NUMBER" */
    '\x01','U','R','I','_','\x05','P','O','R','T','_','N','U','M','B','E','R',
/* 0x16bae = "Configuration value not found." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf5','\x07','\x89',
/* 0x16bbf = "Unit header integrity error." */
    'U','n','i','t',' ','\xb4','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x16bd0 = "Bad TRPM_TRAP_IN_OP." */
    '\x9f','T','R','P','M','_','T','R','A','P','_','I','N','_','O','P','.',
/* 0x16be1 = "The semaphore is in use." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x0b','\x0f','u','s','e','.',
/* 0x16bf2 = "A reboot is needed." */
    'A',' ','r','e','b','o','o','t',' ','\x0b','n','e','e','d','e','d','.',
/* 0x16c03 = "VERR_RECORDING_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','I','N','I','T','_','\x17',
/* 0x16c14 = "VINF_AIO_TASK_PENDING" */
    '\x0e','A','I','O','_','T','A','S','K','_','P','E','N','D','I','N','G',
/* 0x16c25 = "VERR_VD_GEOMETRY_NOT_SET" */
    '\x01','V','D','_','G','E','O','M','E','T','R','Y','_','\x06','S','E','T',
/* 0x16c36 = "VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE" */
    '\x01','\x1f','\x82','\x1b','D','E','E','P','_','D','I','R','_','T','R','E','E',
/* 0x16c47 = "VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','M','M','I','O','2','_','\xce','\x06','\x40',
/* 0x16c58 = "Unknown I/O instruction." */
    '\xef','I','/','O',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x16c69 = "VINF_VRDP_PROCESS_PDU" */
    '\x0e','V','R','D','P','_','P','R','O','C','E','S','S','_','P','D','U',
/* 0x16c7a = "Unable to parse string as bool." */
    '\xe1','\x0a','p','a','r','s','e',' ','\xf2','a','s',' ','b','o','o','l','.',
/* 0x16c8b = "VERR_PREEMPT_DISABLED" */
    '\x01','P','R','E','E','M','P','T','_','D','I','S','A','B','L','E','D',
/* 0x16c9c = "VERR_SSM_INTEGRITY_DECOMPRESSION" */
    '\x01','\xb0','\xf7','_','D','E','C','O','M','P','R','E','S','S','I','O','N',
/* 0x16cad = "VERR_DBGF_BP_L2_LOOKUP_FAILED" */
    '\x01','\xb9','_','B','P','_','L','2','_','L','O','O','K','U','P','_','\x17',
/* 0x16cbe = "VERR_CR_X509_NAME_EMPTY_SET" */
    '\x01','\x24','\xb7','N','A','M','E','_','E','M','P','T','Y','_','S','E','T',
/* 0x16ccf = "Recompiler: Unexpected kind of variable." */
    '\x13','\x94','k','i','n','d',' ','\x15','v','a','r','i','a','b','l','e','.',
/* 0x16ce0 = "VERR_SYMLINK_NOT_ALLOWED" */
    '\x01','S','Y','M','L','I','N','K','_','\x06','A','L','L','O','W','E','D',
/* 0x16cf1 = "VERR_BUFFER_UNDERFLOW" */
    '\x01','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x16d02 = "VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\xaa','C','L','O','S','E','_','\x1c',
/* 0x16d13 = "VINF_IPC_SEND_MSG_CUT" */
    '\x0e','I','P','C','_','S','E','N','D','_','M','S','G','_','C','U','T',
/* 0x16d24 = "VERR_VMM_CANNOT_BLOCK" */
    '\x01','V','M','M','_','C','A','N','N','O','T','_','B','L','O','C','K',
/* 0x16d35 = "VERR_PGM_DYNMAP_EXPAND_ERROR" */
    '\x01','\x8c','D','Y','N','M','A','P','_','E','X','P','A','N','D','_','\x1c',
/* 0x16d46 = "VERR_CFGM_INVALID_CHILD_PATH" */
    '\x01','C','F','G','M','_','\x05','C','H','I','L','D','_','P','A','T','H',
/* 0x16d57 = "VERR_SUPLIB_TEXT_NOT_WRITEABLE" */
    '\x01','\xd7','T','E','X','T','_','\x06','W','R','I','T','E','A','B','L','E',
/* 0x16d68 = "VERR_SUPLIB_INVALID_ARGV0_INTERNAL" */
    '\x01','\xd7','\x05','A','R','G','V','0','_','I','N','T','E','R','N','A','L',
/* 0x16d79 = "VERR_OUT_OF_RESOURCES" */
    '\x01','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x16d8a = "VERR_DBG_ADDRESS_WRAP" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','W','R','A','P',
/* 0x16d9b = "VERR_NET_ALREADY_IN_PROGRESS" */
    '\x01','N','E','T','_','\x9b','I','N','_','P','R','O','G','R','E','S','S',
/* 0x16dac = "Invalid Base64 encoding." */
    '\x0c','B','a','s','e','6','4',' ','e','n','c','o','d','i','n','g','.',
/* 0x16dbd = "Unsupported file system charset." */
    '\x98','\x22','s','y','s','t','e','m',' ','c','h','a','r','s','e','t','.',
/* 0x16dce = "Zero length path." */
    'Z','e','r','o',' ','l','e','n','g','t','h',' ','p','a','t','h','.',
/* 0x16ddf = "Bad load command(s)." */
    '\x9f','l','o','a','d',' ','c','o','m','m','a','n','d','(','s',')','.',
/* 0x16df0 = "No logger instance." */
    '\xe0','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e','.',
/* 0x16e01 = "VERR_SUP_VP_QUERY_HANDLE_TYPE" */
    '\x01','\x95','\xbd','Q','U','E','R','Y','_','H','A','N','D','L','E','_','\xb3',
/* 0x16e12 = "Not a power of two." */
    'N','o','t',' ','a',' ','p','o','w','e','r',' ','\x15','t','w','o','.',
/* 0x16e23 = "The tar header is all zeros." */
    '\x03','t','a','r',' ','\xb4','\x0b','a','l','l',' ','z','e','r','o','s','.',
/* 0x16e34 = "VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG" */
    '\x01','\xf4','\xce','H','A','S','H','_','T','A','B','_','\x1b','L','O','N','G',
/* 0x16e45 = "Invalid I/O port handle." */
    '\x0c','I','/','O',' ','p','o','r','t',' ','h','a','n','d','l','e','.',
/* 0x16e56 = "VERR_INTNET_FLT_IF_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x06','\x40',
/* 0x16e67 = "Invalid parameter index." */
    '\x0c','p','a','r','a','m','e','t','e','r',' ','i','n','d','e','x','.',
/* 0x16e78 = "Unknown location opcode." */
    '\xef','l','o','c','a','t','i','o','n',' ','o','p','c','o','d','e','.',
/* 0x16e89 = "VERR_IS_A_CHAR_DEVICE" */
    '\x01','I','S','_','A','_','C','H','A','R','_','D','E','V','I','C','E',
/* 0x16e9a = "VERR_S3_BUCKET_NOT_EMPTY" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x06','E','M','P','T','Y',
/* 0x16eab = "VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID" */
    '\x01','\x97','\x91','P','A','R','T','_','M','A','P','_','\xb3','_','I','D',
/* 0x16ebb = "SSL connection error." */
    'S','S','L',' ','c','o','n','n','e','c','t','i','o','n',' ','\x85',
/* 0x16ecb = "VERR_ISOFS_BAD_LVD_DOMAIN_ID" */
    '\x01','\x97','\x1d','L','V','D','_','D','O','M','A','I','N','_','I','D',
/* 0x16edb = "VERR_XAR_BAD_FILE_TIMESTAMP" */
    '\x01','X','A','R','_','\x1d','\xaa','T','I','M','E','S','T','A','M','P',
/* 0x16eeb = "VERR_BUFFER_OVERFLOW" */
    '\x01','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x16efb = "VERR_TAR_END_OF_FILE" */
    '\x01','T','A','R','_','E','N','D','_','O','F','_','F','I','L','E',
/* 0x16f0b = "VERR_LDRPE_GLOBALPTR" */
    '\x01','L','D','R','P','E','_','G','L','O','B','A','L','P','T','R',
/* 0X16f1b = "Receive aborted." */
    'e','c','e','i','v','e',' ','a','b','o','r','t','e','d','.',
/* 0x16f2a = "VERR_SUP_VP_THREAD_NOT_ALONE" */
    '\x01','\x95','\xbd','T','H','R','E','A','D','_','\x06','A','L','O','N','E',
/* 0x16f3a = "VERR_NET_IN_PROGRESS" */
    '\x01','N','E','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x16f4a = "VERR_VMM_HYPER_CR3_MISMATCH" */
    '\x01','V','M','M','_','H','Y','P','E','R','_','C','R','3','_','\x19',
/* 0x16f5a = "VINF_VMM_CALL_TRACER" */
    '\x0e','V','M','M','_','C','A','L','L','_','T','R','A','C','E','R',
/* 0x16f6a = "VERR_SSM_SKIP_BACKWARDS" */
    '\x01','\xb0','S','K','I','P','_','B','A','C','K','W','A','R','D','S',
/* 0x16f7a = "VERR_SEM_LV_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','D','E','A','D','L','O','C','K',
/* 0x16f8a = "Trailing spaces." */
    'T','r','a','i','l','i','n','g',' ','s','p','a','c','e','s','.',
/* 0x16f9a = "VERR_CFGM_INVALID_NODE_PATH" */
    '\x01','C','F','G','M','_','\x05','N','O','D','E','_','P','A','T','H',
/* 0x16faa = "VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY" */
    '\x01','\x95','\xbd','E','X','E','_','\xc5','_','F','O','R','C','E','_','\xf7',
/* 0x16fba = "VERR_CR_PKIX_GENERIC_ERROR" */
    '\x01','\x24','P','K','I','X','_','G','E','N','E','R','I','C','_','\x1c',
/* 0x16fca = "VERR_GIM_HYPERCALL_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\x17',
/* 0x16fda = "VERR_RESOURCE_IN_USE" */
    '\x01','R','E','S','O','U','R','C','E','_','I','N','_','U','S','E',
/* 0x16fea = "Generic not found warning." */
    '\xa7','\x07','f','o','u','n','d',' ','w','a','r','n','i','n','g','.',
/* 0x16ffa = "Invalid name for XAR file." */
    '\x0c','n','a','m','e',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x1700a = "VERR_CR_PKCS7_OSSL_VERIFY_FAILED" */
    '\x01','\x24','\xe5','O','S','S','L','_','V','E','R','I','F','Y','_','\x17',
/* 0x1701a = "Bogus UDF directory size." */
    'B','o','g','u','s',' ','U','D','F',' ','\x25','s','i','z','e','.',
/* 0x1702a = "Internal processing error in the page allocator." */
    '\x08','\x04','\x09','\x0f','\x02','\xbe','a','l','l','o','c','a','t','o','r','.',
/* 0x1703a = "VINF_CALLBACK_RETURN" */
    '\x0e','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1704a = "VERR_IEM_LABEL_OUT_OF_MEMORY" */
    '\x01','\x9c','L','A','B','E','L','_','O','U','T','_','O','F','_','\xb6',
/* 0x1705a = "Unexpected SVM patch type." */
    '\x94','S','V','M',' ','p','a','t','c','h',' ','t','y','p','e','.',
/* 0x1706a = "VINF_PATM_PATCH_INT3" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','I','N','T','3',
/* 0x1707a = "VERR_PDM_THREAD_INVALID_CALLER" */
    '\x01','\x7d','T','H','R','E','A','D','_','\x05','C','A','L','L','E','R',
/* 0x1708a = "VERR_TM_TSC_ALREADY_TICKING" */
    '\x01','T','M','_','T','S','C','_','\x9b','T','I','C','K','I','N','G',
/* 0x1709a = "Invalid opcode byte(s)." */
    '\x0c','o','p','c','o','d','e',' ','b','y','t','e','(','s',')','.',
/* 0x170aa = "VERR_PDM_USB_NAME_CLASH" */
    '\x01','\x7d','U','S','B','_','N','A','M','E','_','C','L','A','S','H',
/* 0x170ba = "Generic no change info." */
    '\xa7','n','o',' ','c','h','a','n','g','e',' ','i','n','f','o','.',
/* 0x170ca = "VERR_CR_RANDOM_SETUP_FAILED" */
    '\x01','\x24','R','A','N','D','O','M','_','S','E','T','U','P','_','\x17',
/* 0x170da = "VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x1b','M','U','C','H',
/* 0x170ea = "Already patched." */
    'A','l','r','e','a','d','y',' ','p','a','t','c','h','e','d','.',
/* 0x170fa = "VERR_ISOMK_RR_SPILL_FILE_FULL" */
    '\x01','\x1f','R','R','_','S','P','I','L','L','_','\xaa','F','U','L','L',
/* 0x1710a = "Image Verification Failure: Invalid section count." */
    'I','m','a','g','e',' ','\x0d','\x12','\x0c','\xdd','c','o','u','n','t','.',
/* 0x1711a = "VERR_SSM_INTEGRITY_REC_TERM_CRC" */
    '\x01','\xb0','\xf7','_','R','E','C','_','T','E','R','M','_','C','R','C',
/* 0x1712a = "VERR_UDP_SERVER_STOP" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1713a = "VERR_PDM_DEVINS_NO_ATTACH" */
    '\x01','\x7d','D','E','V','I','N','S','_','\x60','A','T','T','A','C','H',
/* 0x1714a = "VERR_PIPE_NOT_CONNECTED" */
    '\x01','P','I','P','E','_','\x06','C','O','N','N','E','C','T','E','D',
/* 0x1715a = "VERR_NEM_UNMAP_PAGES_FAILED" */
    '\x01','\xee','_','U','N','M','A','P','_','P','A','G','E','S','_','\x17',
/* 0x1716a = "Fatal EMT wait error." */
    'F','a','t','a','l',' ','E','M','T',' ','w','a','i','t',' ','\x85',
/* 0x1717a = "VERR_ASN1_TOO_DEEPLY_NESTED" */
    '\x01','\xa2','\x1b','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x1718a = "VERR_CR_OPENSSL_VERSION_TOO_OLD" */
    '\x01','\x24','O','P','E','N','S','S','L','_','\xbc','_','\x1b','O','L','D',
/* 0x1719a = "VERR_URI_INVALID_ESCAPE_SEQ" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','_','S','E','Q',
/* 0x171aa = "VERR_HARDAVL_BAD_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','H','E','I','G','H','T',
/* 0x171ba = "VWRN_TRAILING_SPACES" */
    '\xe6','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x171ca = "Net host name not found." */
    'N','e','t',' ','h','o','s','t',' ','n','a','m','e',' ','\x07','\x89',
/* 0x171da = "VERR_PRIVILEGE_NOT_HELD" */
    '\x01','P','R','I','V','I','L','E','G','E','_','\x06','H','E','L','D',
/* 0x171ea = "VERR_PAGE_TABLE_NOT_PRESENT" */
    '\x01','\xce','T','A','B','L','E','_','\x06','P','R','E','S','E','N','T',
/* 0x171fa = "VERR_TM_GIP_REQUIRED" */
    '\x01','T','M','_','G','I','P','_','R','E','Q','U','I','R','E','D',
/* 0x1720a = "Unbalanced tree." */
    'U','n','b','a','l','a','n','c','e','d',' ','t','r','e','e','.',
/* 0x1721a = "VERR_SUPLIB_PATH_NOT_ABSOLUTE" */
    '\x01','\xd7','P','A','T','H','_','\x06','A','B','S','O','L','U','T','E',
/* 0x1722a = "VERR_LDR_INVALID_SEG_OFFSET" */
    '\x01','L','D','R','_','\x05','S','E','G','_','O','F','F','S','E','T',
/* 0x1723a = "VERR_MM_RAM_CONFLICT" */
    '\x01','M','M','_','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x1724a = "VERR_ASN1_CURSOR_NOT_AT_END" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x06','A','T','_','E','N','D',
/* 0x1725a = "Failed to map a memory object." */
    '\x8b','\x0a','m','a','p',' ','a',' ','\x86','o','b','j','e','c','t','.',
/* 0x1726a = "Patch was already enabled." */
    'P','a','t','c','h',' ','\x11','\x80','e','n','a','b','l','e','d','.',
/* 0x1727a = "The specified data unit wasn\'t found." */
    '\x03','\x18','\x9d','u','n','i','t',' ','w','a','s','n','\'','t',' ','\x89',
/* 0x1728a = "The XAR table of content digest doesn't match." */
    '\x03','X','A','R',' ','\xb1','\x15','\xf0','\xd8','\xc9','m','a','t','c','h','.',
/* 0x1729a = "VERR_HM_ALREADY_ENABLED_IPE" */
    '\x01','H','M','_','\x9b','E','N','A','B','L','E','D','_','I','P','E',
/* 0x172aa = "VERR_CPUM_INVALID_XSAVE_HDR" */
    '\x01','C','P','U','M','_','\x05','X','S','A','V','E','_','H','D','R',
/* 0x172ba = "Bad VTG bit count value." */
    '\x9f','V','T','G',' ','b','i','t',' ','c','o','u','n','t',' ','\xe8',
/* 0x172ca = "VERR_CR_KEY_PASSWORD_ENCODING" */
    '\x01','\x24','K','E','Y','_','P','A','S','S','W','O','R','D','_','\xc8',
/* 0x172da = "VMDK: Invalid image file header." */
    'V','M','D','K',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x172ea = "Too many open files." */
    'T','o','o',' ','\xb5','o','p','e','n',' ','f','i','l','e','s','.',
/* 0x172fa = "VERR_XAR_MISSING_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\xc5','_','\xfa','_','E','L','E','M','E','N','T',
/* 0x1730a = "VERR_DBGF_NO_TRACE_BUFFER" */
    '\x01','\xb9','_','\x60','T','R','A','C','E','_','B','U','F','F','E','R',
/* 0x1731a = "Comment string is too long." */
    'C','o','m','m','e','n','t',' ','\xf2','\x0b','\x9e','l','o','n','g','.',
/* 0x1732a = "VINF_HM_DOUBLE_FAULT" */
    '\x0e','H','M','_','D','O','U','B','L','E','_','F','A','U','L','T',
/* 0x1733a = "VERR_SSM_GCPTR_OVERFLOW" */
    '\x01','\xb0','G','C','P','T','R','_','O','V','E','R','F','L','O','W',
/* 0x1734a = "Bad MH_OBJECT file." */
    '\x9f','M','H','_','O','B','J','E','C','T',' ','f','i','l','e','.',
/* 0x1735a = "VERR_HTTP_REDIRECTED" */
    '\x01','H','T','T','P','_','R','E','D','I','R','E','C','T','E','D',
/* 0x1736a = "VERR_CR_X509_NO_TRUST_ANCHOR" */
    '\x01','\x24','\xb7','\x60','T','R','U','S','T','_','A','N','C','H','O','R',
/* 0x1737a = "VINF_VMM_UNKNOWN_RING3_CALL" */
    '\x0e','V','M','M','_','\x91','R','I','N','G','3','_','C','A','L','L',
/* 0x1738a = "VERR_PATCH_ALREADY_DISABLED" */
    '\x01','P','A','T','C','H','_','\x9b','D','I','S','A','B','L','E','D',
/* 0x1739a = "Internal processing error in the critical section code." */
    '\x08','\x04','\x09','\x0f','\x02','c','r','i','t','i','c','a','l',' ','\xdd','\x84',
/* 0x173aa = "VINF_UDP_SERVER_STOP" */
    '\x0e','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x173ba = "VWRN_FLOAT_UNDERFLOW" */
    '\xe6','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x173ca = "VINF_GVM_NOT_BUSY_IN_GC" */
    '\x0e','G','V','M','_','\x06','B','U','S','Y','_','I','N','_','G','C',
/* 0x173da = "VERR_GENERAL_FAILURE" */
    '\x01','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x173ea = "VERR_NAT_REDIR_SETUP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','S','E','T','U','P',
/* 0x173fa = "VERR_VM_DRIVER_OPEN_ERROR" */
    '\x01','\xc6','_','D','R','I','V','E','R','_','O','P','E','N','_','\x1c',
/* 0x1740a = "Image Verification Failure:." */
    'I','m','a','g','e',' ','\x0d','F','a','i','l','u','r','e',':','.',
/* 0x1741a = "VERR_SEM_OUT_OF_TURN" */
    '\x01','S','E','M','_','O','U','T','_','O','F','_','T','U','R','N',
/* 0x1742a = "Recompiler: Out of variables." */
    '\x13','O','u','t',' ','\x15','v','a','r','i','a','b','l','e','s','.',
/* 0x1743a = "Vote for giving up." */
    'V','o','t','e',' ','\x10','g','i','v','i','n','g',' ','u','p','.',
/* 0x1744a = "VERR_SUP_VP_SYSTEM32_PATH" */
    '\x01','\x95','\xbd','S','Y','S','T','E','M','3','2','_','P','A','T','H',
/* 0x1745a = "VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR" */
    '\x01','\x1f','\x82','\x05','V','O','L','_','D','E','S','C','_','H','D','R',
/* 0x1746a = "The I/O request was canceled." */
    '\x03','I','/','O',' ','\xab','\x11','c','a','n','c','e','l','e','d','.',
/* 0x1747a = "Too many RAM ranges." */
    'T','o','o',' ','\xb5','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x1748a = "Syntax error - invalid operation attempted." */
    '\xfb','\x09','-',' ','\x8f','\x96','a','t','t','e','m','p','t','e','d','.',
/* 0x1749a = "VERR_PDM_NO_DMAC_INSTANCE" */
    '\x01','\x7d','\x60','D','M','A','C','_','I','N','S','T','A','N','C','E',
/* 0x174aa = "VERR_HGCM_SERVICE_NOT_FOUND" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','\x06','\x40',
/* 0x174ba = "VERR_HOSTIF_BLOCKING" */
    '\x01','H','O','S','T','I','F','_','B','L','O','C','K','I','N','G',
/* 0x174ca = "VERR_LDRVI_INVALID_SECTION_COUNT" */
    '\x01','\xf4','\x05','S','E','C','T','I','O','N','_','C','O','U','N','T',
/* 0X174da = "Too many semaphores." */
    'o','o',' ','\xb5','s','e','m','a','p','h','o','r','e','s','.',
/* 0x174e9 = "Unknown or invalid GIM provider." */
    '\xef','\xa9','\x8f','G','I','M',' ','p','r','o','v','i','d','e','r','.',
/* 0x174f9 = "VERR_MEM_CACHE_MAX_SIZE" */
    '\x01','M','E','M','_','C','A','C','H','E','_','M','A','X','_','\xfa',
/* 0x17509 = "TM requires GIP." */
    'T','M',' ','r','e','q','u','i','r','e','s',' ','G','I','P','.',
/* 0x17519 = "VERR_EXCL_SEM_ALREADY_OWNED" */
    '\x01','E','X','C','L','_','S','E','M','_','\x9b','O','W','N','E','D',
/* 0x17529 = "VINF_PGM_GCPHYS_ALIASED" */
    '\x0e','\x8c','G','C','P','H','Y','S','_','A','L','I','A','S','E','D',
/* 0x17539 = "VERR_TRPM_DONT_PANIC" */
    '\x01','T','R','P','M','_','D','O','N','T','_','P','A','N','I','C',
/* 0x17549 = "VERR_DIS_TOO_LONG_INSTR" */
    '\x01','D','I','S','_','\x1b','L','O','N','G','_','I','N','S','T','R',
/* 0x17559 = "VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING" */
    '\x01','\xa2','\x05','P','R','I','N','T','A','B','L','E','_','\xd6','_','\xc8',
/* 0x17569 = "VINF_TCP_SERVER_STOP" */
    '\x0e','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x17579 = "VERR_PGM_TOO_MANY_MMIO2_RANGES" */
    '\x01','\x8c','\x1b','\xac','M','M','I','O','2','_','R','A','N','G','E','S',
/* 0x17589 = "VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING" */
    '\x01','\xa2','\x05','U','N','I','V','E','R','S','A','L','_','\xd6','_','\xc8',
/* 0x17599 = "VERR_PGM_DYNMAP_SETUP_ERROR" */
    '\x01','\x8c','D','Y','N','M','A','P','_','S','E','T','U','P','_','\x1c',
/* 0x175a9 = "VERR_NET_SOCKET_TYPE_NOT_SUPPORTED" */
    '\x01','N','E','T','_','S','O','C','K','E','T','_','\xb3','_','\x06','\x83',
/* 0x175b9 = "VERR_CPUM_RAISE_GP_0" */
    '\x01','C','P','U','M','_','R','A','I','S','E','_','G','P','_','0',
/* 0x175c9 = "VERR_PDM_DRVINS_NO_ATTACH" */
    '\x01','\x7d','D','R','V','I','N','S','_','\x60','A','T','T','A','C','H',
/* 0x175d9 = "VERR_CR_PKCS7_NO_CERTIFICATES" */
    '\x01','\x24','\xe5','\x60','C','E','R','T','I','F','I','C','A','T','E','S',
/* 0x175e9 = "VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL" */
    '\x01','\x24','\xe5','\xbf','P','A','R','A','M','S','_','\x06','I','M','P','L',
/* 0x175f9 = "VERR_DWARF_ABBREV_NOT_FOUND" */
    '\x01','D','W','A','R','F','_','A','B','B','R','E','V','_','\x06','\x40',
/* 0x17609 = "VERR_WEB_INVALID_SESSION_ID" */
    '\x01','W','E','B','_','\x05','S','E','S','S','I','O','N','_','I','D',
/* 0x17619 = "VERR_IOM_NO_R3_MMIO_RANGE" */
    '\x01','I','O','M','_','\x60','R','3','_','\xd4','_','R','A','N','G','E',
/* 0x17629 = "VERR_SUP_VP_TOO_LARGE_REGION" */
    '\x01','\x95','\xbd','\x1b','L','A','R','G','E','_','R','E','G','I','O','N',
/* 0x17639 = "VERR_SSM_LOADED_TOO_LITTLE" */
    '\x01','\xb0','L','O','A','D','E','D','_','\x1b','L','I','T','T','L','E',
/* 0x17649 = "VERR_DVM_MAP_NO_VOLUME" */
    '\x01','D','V','M','_','M','A','P','_','\x60','V','O','L','U','M','E',
/* 0x17659 = "VERR_LDRVI_BAD_CERT_MULTIPLE" */
    '\x01','\xf4','\x1d','C','E','R','T','_','M','U','L','T','I','P','L','E',
/* 0x17669 = "VERR_LDR_NO_IMAGE_UUID" */
    '\x01','L','D','R','_','\x60','I','M','A','G','E','_','U','U','I','D',
/* 0x17679 = "VERR_VMM_SWITCHER_IPE_1" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','\x14','1',
/* 0x17689 = "VERR_VD_VMDK_INVALID_FORMAT" */
    '\x01','V','D','_','V','M','D','K','_','\x05','F','O','R','M','A','T',
/* 0x17699 = "VERR_IEM_VAR_DUP_ARG_NO" */
    '\x01','\x9c','V','A','R','_','D','U','P','_','A','R','G','_','N','O',
/* 0x176a9 = "VINF_PATM_SPINLOCK_FAILED" */
    '\x0e','P','A','T','M','_','S','P','I','N','L','O','C','K','_','\x17',
/* 0x176b9 = "VERR_FILE_AIO_NOT_SUBMITTED" */
    '\x01','\xaa','A','I','O','_','\x06','S','U','B','M','I','T','T','E','D',
/* 0x176c9 = "VERR_SUPDRV_VTG_STRTAB_OFF" */
    '\x01','\x90','V','T','G','_','S','T','R','T','A','B','_','O','F','F',
/* 0x176d9 = "VERR_ISOMK_IPE_BOOT_CAT_FILE" */
    '\x01','\x1f','\x14','B','O','O','T','_','C','A','T','_','F','I','L','E',
/* 0x176e9 = "Invalid HGCM client id." */
    '\x0c','H','G','C','M',' ','c','l','i','e','n','t',' ','i','d','.',
/* 0x176f9 = "VERR_SUP_VP_TOO_MANY_DLLS_LOADED" */
    '\x01','\x95','\xbd','\x1b','\xac','D','L','L','S','_','L','O','A','D','E','D',
/* 0x17709 = "Unknown file system format." */
    '\xef','\x22','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x17719 = "VERR_PGM_MAPPINGS_FIXED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','E','D',
/* 0x17729 = "VERR_SUPLIB_WORLD_WRITABLE" */
    '\x01','\xd7','W','O','R','L','D','_','W','R','I','T','A','B','L','E',
/* 0x17739 = "VERR_PGM_PHYS_PAGE_RESERVED" */
    '\x01','\x8c','P','H','Y','S','_','\xce','R','E','S','E','R','V','E','D',
/* 0x17749 = "VERR_HGCM_INVALID_CLIENT_ID" */
    '\x01','H','G','C','M','_','\x05','C','L','I','E','N','T','_','I','D',
/* 0x17759 = "VERR_JSON_INVALID_CODEPOINT" */
    '\x01','J','S','O','N','_','\x05','C','O','D','E','P','O','I','N','T',
/* 0x17769 = "The poll set is full." */
    '\x03','p','o','l','l',' ','s','e','t',' ','\x0b','f','u','l','l','.',
/* 0x17779 = "VERR_PATCH_NO_CONFLICT" */
    '\x01','P','A','T','C','H','_','\x60','C','O','N','F','L','I','C','T',
/* 0x17789 = "VERR_PDM_CRITSECTRW_IPE" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','I','P','E',
/* 0x17799 = "VERR_TIMER_SUSPENDED" */
    '\x01','T','I','M','E','R','_','S','U','S','P','E','N','D','E','D',
/* 0x177a9 = "VERR_XAR_WRONG_MAGIC" */
    '\x01','X','A','R','_','W','R','O','N','G','_','M','A','G','I','C',
/* 0x177b9 = "VERR_TAR_MODE_WITH_TYPE" */
    '\x01','T','A','R','_','M','O','D','E','_','W','I','T','H','_','\xb3',
/* 0x177c9 = "Bad VTG attribute value." */
    '\x9f','V','T','G',' ','a','t','t','r','i','b','u','t','e',' ','\xe8',
/* 0x177d9 = "Patch installed." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','e','d','.',
/* 0x177e9 = "VERR_CR_PKCS7_SIGNED_DATA_VERSION" */
    '\x01','\x24','\xe5','S','I','G','N','E','D','_','D','A','T','A','_','\xbc',
/* 0x177f9 = "The system has too many CPUs." */
    '\x03','s','y','s','t','e','m',' ','\x5c','\x9e','\xb5','C','P','U','s','.',
/* 0x17809 = "Bad argument flags." */
    '\x9f','a','r','g','u','m','e','n','t',' ','f','l','a','g','s','.',
/* 0x17819 = "A component value of an ASN." */
    'A',' ','c','o','m','p','o','n','e','n','t',' ','\xf5','\x15','\x87','\xf6',
/* 0x17829 = "Invalid Virtual CPU ID." */
    '\x0c','V','i','r','t','u','a','l',' ','C','P','U',' ','I','D','.',
/* 0x17839 = "VERR_TM_TIMER_BAD_CLOCK" */
    '\x01','T','M','_','T','I','M','E','R','_','\x1d','C','L','O','C','K',
/* 0x17849 = "VINF_IOM_MMIO_UNUSED_00" */
    '\x0e','I','O','M','_','\xd4','_','U','N','U','S','E','D','_','0','0',
/* 0x17859 = "Invalid segment offset." */
    '\x0c','s','e','g','m','e','n','t',' ','o','f','f','s','e','t','.',
/* 0x17869 = "VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS" */
    '\x01','\x24','\xe5','\x1b','\xac','\xbf','A','L','G','O','R','I','T','H','M','S',
/* 0x17879 = "VERR_TCP_SERVER_STOP" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x17889 = "VINF_IOM_MMIO_UNUSED_FF" */
    '\x0e','I','O','M','_','\xd4','_','U','N','U','S','E','D','_','F','F',
/* 0x17899 = "VERR_NET_PROTOCOL_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x06','\x83',
/* 0x178a9 = "VINF_EM_TRIPLE_FAULT" */
    '\x0e','E','M','_','T','R','I','P','L','E','_','F','A','U','L','T',
/* 0x178b9 = "VERR_GIM_OPERATION_FAILED" */
    '\x01','G','I','M','_','O','P','E','R','A','T','I','O','N','_','\x17',
/* 0x178c9 = "Bad DWARF position." */
    '\x9f','D','W','A','R','F',' ','p','o','s','i','t','i','o','n','.',
/* 0x178d9 = "Internal processing error #1 in the DBGF core code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','c','o','r','e',' ','\x84',
/* 0x178e9 = "VERR_CALLBACK_RETURN" */
    '\x01','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x178f9 = "VERR_VM_THREAD_IS_EMT" */
    '\x01','\xc6','_','T','H','R','E','A','D','_','I','S','_','E','M','T',
/* 0x17909 = "Encountered an unknown type flag." */
    '\xa6','\x87','u','n','k','n','o','w','n',' ','\xf3','f','l','a','g','.',
/* 0x17919 = "VINF_BUFFER_OVERFLOW" */
    '\x0e','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x17929 = "Expected RSA public key." */
    '\xb8','R','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x17939 = "VERR_PROCESS_RUNNING" */
    '\x01','P','R','O','C','E','S','S','_','R','U','N','N','I','N','G',
/* 0x17949 = "VERR_TM_INVALID_TIMER_QUEUE" */
    '\x01','T','M','_','\x05','T','I','M','E','R','_','Q','U','E','U','E',
/* 0x17959 = "Local file header corrupt." */
    'L','o','c','a','l',' ','\x22','\xb4','c','o','r','r','u','p','t','.',
/* 0x17969 = "VINF_PDM_PCI_DO_DEFAULT" */
    '\x0e','\x7d','P','C','I','_','D','O','_','D','E','F','A','U','L','T',
/* 0x17979 = "VERR_VRDP_PROTOCOL_ERROR" */
    '\x01','V','R','D','P','_','P','R','O','T','O','C','O','L','_','\x1c',
/* 0x17989 = "VERR_FLOAT_UNDERFLOW" */
    '\x01','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x17999 = "VERR_SUPDRV_TRACER_ALREADY_OPENED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x9b','O','P','E','N','E','D',
/* 0x179a9 = "Unsupported file system format." */
    '\x98','\x22','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x179b9 = "The table of content (TOC) is too big." */
    '\x03','\xb1','\x15','\xf0','(','T','O','C',')',' ','\x0b','\x9e','b','i','g','.',
/* 0x179c9 = "VERR_TRAILING_SPACES" */
    '\x01','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x179d9 = "Too many ROM ranges." */
    'T','o','o',' ','\xb5','R','O','M',' ','r','a','n','g','e','s','.',
/* 0x179e9 = "VERR_SUP_VP_BAD_SIZE_OF_HEADERS" */
    '\x01','\x95','\xbd','\x1d','\xfa','_','O','F','_','H','E','A','D','E','R','S',
/* 0x179f9 = "VERR_XAR_BAD_FILE_DEVICE_NO" */
    '\x01','X','A','R','_','\x1d','\xaa','D','E','V','I','C','E','_','N','O',
/* 0x17a09 = "VERR_IEM_FIXUP_OUT_OF_MEMORY" */
    '\x01','\x9c','F','I','X','U','P','_','O','U','T','_','O','F','_','\xb6',
/* 0x17a19 = "VERR_PDM_USB_HUB_EXISTS" */
    '\x01','\x7d','U','S','B','_','H','U','B','_','E','X','I','S','T','S',
/* 0x17a29 = "VERR_NET_UNREACHABLE" */
    '\x01','N','E','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x17a39 = "VERR_PDM_MEDIA_NOT_MOUNTED" */
    '\x01','\x7d','M','E','D','I','A','_','\x06','M','O','U','N','T','E','D',
/* 0x17a49 = "VERR_CR_PKCS7_NO_SIGNER_INFOS" */
    '\x01','\x24','\xe5','\x60','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x17a59 = "VERR_VM_DRIVER_LOAD_ERROR" */
    '\x01','\xc6','_','D','R','I','V','E','R','_','L','O','A','D','_','\x1c',
/* 0x17a69 = "VERR_FILE_LOCK_VIOLATION" */
    '\x01','\xaa','L','O','C','K','_','V','I','O','L','A','T','I','O','N',
/* 0x17a79 = "VERR_VMX_NOT_IN_VMX_ROOT_MODE" */
    '\x01','\xe2','\x06','I','N','_','\xe2','R','O','O','T','_','M','O','D','E',
/* 0x17a89 = "VERR_INTNET_FLT_IF_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x17',
/* 0x17a99 = "VERR_SELM_GDT_READ_ERROR" */
    '\x01','S','E','L','M','_','G','D','T','_','R','E','A','D','_','\x1c',
/* 0x17aa9 = "VERR_CR_X509_CPB_BAD_CERT_CTX" */
    '\x01','\x24','\xb7','C','P','B','_','\x1d','C','E','R','T','_','C','T','X',
/* 0x17ab9 = "VERR_SUPDRV_TRACER_NOT_OPENED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','O','P','E','N','E','D',
/* 0x17ac9 = "VERR_DBGF_HYPER_DB_XCPT" */
    '\x01','\xb9','_','H','Y','P','E','R','_','D','B','_','X','C','P','T',
/* 0x17ad9 = "Normalization of ASN." */
    'N','o','r','m','a','l','i','z','a','t','i','o','n',' ','\x15','\xf6',
/* 0x17ae9 = "VERR_TAR_BAD_MODE_FIELD" */
    '\x01','T','A','R','_','\x1d','M','O','D','E','_','F','I','E','L','D',
/* 0x17af9 = "The support driver is not accessible." */
    '\x03','\xd0','\xc7','\x0b','\x07','a','c','c','e','s','s','i','b','l','e','.',
/* 0x17b09 = "VERR_VMX_INVALID_VMCS_LAUNCH_STATE" */
    '\x01','\xe2','\x05','V','M','C','S','_','L','A','U','N','C','H','_','\xf1',
/* 0x17b19 = "VERR_TAR_ZERO_HEADER" */
    '\x01','T','A','R','_','Z','E','R','O','_','H','E','A','D','E','R',
/* 0x17b29 = "Generic VM-exit failure." */
    '\xa7','\xc6','-','e','x','i','t',' ','f','a','i','l','u','r','e','.',
/* 0x17b39 = "The key was decrypted." */
    '\x03','k','e','y',' ','\x11','d','e','c','r','y','p','t','e','d','.',
/* 0x17b49 = "VERR_PDM_NO_APIC_INSTANCE" */
    '\x01','\x7d','\x60','A','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x17b59 = "VINF_SSM_LIVE_SUSPENDED" */
    '\x0e','\xb0','L','I','V','E','_','S','U','S','P','E','N','D','E','D',
/* 0x17b69 = "VERR_VD_VMDK_INVALID_HEADER" */
    '\x01','V','D','_','V','M','D','K','_','\x05','H','E','A','D','E','R',
/* 0X17b79 = "Receive timeout." */
    'e','c','e','i','v','e',' ','t','i','m','e','o','u','t','.',
/* 0x17b88 = "VERR_TAR_BASE_256_NOT_SUPPORTED" */
    '\x01','T','A','R','_','B','A','S','E','_','2','5','6','_','\x06','\x83',
/* 0x17b98 = "Error getting the file mode." */
    '\xc1','g','e','t','t','i','n','g',' ','\x02','\x22','m','o','d','e','.',
/* 0x17ba8 = "VERR_ALLOCATION_TOO_BIG" */
    '\x01','A','L','L','O','C','A','T','I','O','N','_','\x1b','B','I','G',
/* 0x17bb8 = "VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\xaa','O','P','E','N','_','\x1c',
/* 0x17bc8 = "VINF_HM_PENDING_XCPT" */
    '\x0e','H','M','_','P','E','N','D','I','N','G','_','X','C','P','T',
/* 0x17bd8 = "Logical Unit was not found." */
    'L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x11','\x07','\x89',
/* 0x17be8 = "VERR_LDRMACHO_BAD_SECTION_ORDER" */
    '\x01','\xe9','\x1d','S','E','C','T','I','O','N','_','O','R','D','E','R',
/* 0x17bf8 = "VERR_DIS_GEN_FAILURE" */
    '\x01','D','I','S','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x17c08 = "VERR_CR_PKCS7_SIGNER_INFO_VERSION" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','I','N','F','O','_','\xbc',
/* 0x17c18 = "VERR_SUPDRV_VTG_BAD_PROBE_LOC" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','B','E','_','L','O','C',
/* 0x17c28 = "VERR_PDM_MEDIA_MOUNTED" */
    '\x01','\x7d','M','E','D','I','A','_','M','O','U','N','T','E','D',
/* 0x17c37 = "VERR_THREAD_IS_DEAD" */
    '\x01','T','H','R','E','A','D','_','I','S','_','D','E','A','D',
/* 0x17c46 = "VERR_DBGC_PARSE_CONVERSION_FAILED" */
    '\x01','\xfd','\xe4','C','O','N','V','E','R','S','I','O','N','_','\x17',
/* 0x17c55 = "VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG" */
    '\x01','\x1f','\x82','U','D','F','_','D','I','R','_','\x1b','B','I','G',
/* 0x17c64 = "VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET" */
    '\x01','\x97','F','S','D','_','\x1a','C','H','A','R','_','S','E','T',
/* 0x17c73 = "VERR_VD_VMDK_INVALID_WRITE" */
    '\x01','V','D','_','V','M','D','K','_','\x05','W','R','I','T','E',
/* 0x17c82 = "VERR_XAR_TOC_TOO_SMALL" */
    '\x01','X','A','R','_','T','O','C','_','\x1b','S','M','A','L','L',
/* 0x17c91 = "VERR_SIGNAL_PENDING" */
    '\x01','S','I','G','N','A','L','_','P','E','N','D','I','N','G',
/* 0x17ca0 = "VERR_VD_UNKNOWN_CFG_VALUES" */
    '\x01','V','D','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x17caf = "VERR_CR_KEY_ENCRYPTED" */
    '\x01','\x24','K','E','Y','_','E','N','C','R','Y','P','T','E','D',
/* 0x17cbe = "VERR_NOT_CODE_SELECTOR" */
    '\x01','\x06','C','O','D','E','_','S','E','L','E','C','T','O','R',
/* 0x17ccd = "VERR_TOO_MANY_SEM_REQUESTS" */
    '\x01','\x1b','\xac','S','E','M','_','R','E','Q','U','E','S','T','S',
/* 0x17cdc = "VERR_CPUM_DB_CPU_NOT_FOUND" */
    '\x01','C','P','U','M','_','D','B','_','C','P','U','_','\x06','\x40',
/* 0x17ceb = "Unexpected number of valid paths." */
    '\x94','\xfc','\x15','v','a','l','i','d',' ','p','a','t','h','s','.',
/* 0x17cfa = "VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE" */
    '\x01','T','A','R','_','\x1a','G','N','U','_','H','D','R','_','\xb3',
/* 0x17d09 = "VERR_CR_KEY_GEN_FAILED_RSA" */
    '\x01','\x24','K','E','Y','_','G','E','N','_','\x17','_','R','S','A',
/* 0x17d18 = "VERR_HM_INVALID_HM64ON32OP" */
    '\x01','H','M','_','\x05','H','M','6','4','O','N','3','2','O','P',
/* 0x17d27 = "VERR_INVALID_EXE_SIGNATURE" */
    '\x01','\x05','E','X','E','_','S','I','G','N','A','T','U','R','E',
/* 0x17d36 = "VERR_WEB_UNSUPPORTED_INTERFACE" */
    '\x01','W','E','B','_','\x1a','I','N','T','E','R','F','A','C','E',
/* 0x17d45 = "VERR_MEDIA_NOT_PRESENT" */
    '\x01','M','E','D','I','A','_','\x06','P','R','E','S','E','N','T',
/* 0x17d54 = "Repairing the image is not supported." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x26','\x0b','\x07','\xa5',
/* 0x17d63 = "VERR_SYS_SHUTDOWN_FAILED" */
    '\x01','S','Y','S','_','S','H','U','T','D','O','W','N','_','\x17',
/* 0x17d72 = "VERR_IOMMU_INTR_REMAP_FAILED" */
    '\x01','\xfe','_','I','N','T','R','_','R','E','M','A','P','_','\x17',
/* 0x17d81 = "VWRN_FLOAT_OVERFLOW" */
    '\xe6','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x17d90 = "VERR_EM_INTERPRETER" */
    '\x01','E','M','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x17d9f = "VERR_FILENAME_TOO_LONG" */
    '\x01','F','I','L','E','N','A','M','E','_','\x1b','L','O','N','G',
/* 0x17dae = "VERR_LDR_IMAGE_HASH" */
    '\x01','L','D','R','_','I','M','A','G','E','_','H','A','S','H',
/* 0x17dbd = "VERR_VD_GEN_INVALID_HEADER" */
    '\x01','V','D','_','G','E','N','_','\x05','H','E','A','D','E','R',
/* 0x17dcc = "VERR_CR_RSA_GENERIC_ERROR" */
    '\x01','\x24','R','S','A','_','G','E','N','E','R','I','C','_','\x1c',
/* 0x17ddb = "VERR_COM_UNEXPECTED" */
    '\x01','C','O','M','_','U','N','E','X','P','E','C','T','E','D',
/* 0x17dea = "VERR_MM_BAD_TRAP_TYPE_IPE" */
    '\x01','M','M','_','\x1d','T','R','A','P','_','\xb3','_','I','P','E',
/* 0x17df9 = "VERR_VD_VDI_INVALID_HEADER" */
    '\x01','V','D','_','V','D','I','_','\x05','H','E','A','D','E','R',
/* 0x17e08 = "VERR_IEM_VAR_EXHAUSTED" */
    '\x01','\x9c','V','A','R','_','E','X','H','A','U','S','T','E','D',
/* 0x17e17 = "VERR_HGCM_TOO_MANY_CLIENTS" */
    '\x01','H','G','C','M','_','\x1b','\xac','C','L','I','E','N','T','S',
/* 0x17e26 = "VERR_PGM_INVALID_LARGE_PAGE_RANGE" */
    '\x01','\x8c','\x05','L','A','R','G','E','_','\xce','R','A','N','G','E',
/* 0x17e35 = "VERR_VSCSI_LUN_BUSY" */
    '\x01','V','S','C','S','I','_','L','U','N','_','B','U','S','Y',
/* 0x17e44 = "VERR_IPC_PROCESS_NOT_FOUND" */
    '\x01','I','P','C','_','P','R','O','C','E','S','S','_','\x06','\x40',
/* 0x17e53 = "VMM long jump error." */
    'V','M','M',' ','l','o','n','g',' ','j','u','m','p',' ','\x85',
/* 0x17e62 = "VERR_TRAILING_CHARS" */
    '\x01','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x17e71 = "VERR_PGM_PAE_PDPE_RSVD" */
    '\x01','\x8c','P','A','E','_','P','D','P','E','_','R','S','V','D',
/* 0X17e80 = "DMG: Invalid image file header." */
    'M','G',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x17e8e = "VINF_GETOPT_NOT_OPTION" */
    '\x0e','G','E','T','O','P','T','_','\x06','O','P','T','I','O','N',
/* 0x17e9d = "VERR_VFS_BOGUS_OFFSET" */
    '\x01','\x8d','_','B','O','G','U','S','_','O','F','F','S','E','T',
/* 0x17eac = "VERR_VMM_LONG_JMP_ERROR" */
    '\x01','V','M','M','_','L','O','N','G','_','J','M','P','_','\x1c',
/* 0x17ebb = "VERR_PDM_TOO_PCI_MANY_DEVICES" */
    '\x01','\x7d','\x1b','P','C','I','_','\xac','D','E','V','I','C','E','S',
/* 0x17eca = "The support driver is not installed." */
    '\x03','\xd0','\xc7','\x0b','\x07','i','n','s','t','a','l','l','e','d','.',
/* 0x17ed9 = "The specified thread is dead." */
    '\x03','\x18','t','h','r','e','a','d',' ','\x0b','d','e','a','d','.',
/* 0x17ee8 = "VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND" */
    '\x01','\xe9','\x1a','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x17ef7 = "Unsupported character set." */
    '\x98','c','h','a','r','a','c','t','e','r',' ','s','e','t','.',
/* 0x17f06 = "VERR_CR_X509_CPV_NOT_V3_CERT" */
    '\x01','\x24','\xb7','C','P','V','_','\x06','V','3','_','C','E','R','T',
/* 0x17f15 = "VERR_VMX_IN_VMX_ROOT_MODE" */
    '\x01','\xe2','I','N','_','\xe2','R','O','O','T','_','M','O','D','E',
/* 0x17f24 = "VERR_TM_TSC_ALREADY_PAUSED" */
    '\x01','T','M','_','T','S','C','_','\x9b','P','A','U','S','E','D',
/* 0x17f33 = "VERR_INSTALLATION_FAILED" */
    '\x01','I','N','S','T','A','L','L','A','T','I','O','N','_','\x17',
/* 0x17f42 = "The specified cpu is offline." */
    '\x03','\x18','c','p','u',' ','\x0b','o','f','f','l','i','n','e','.',
/* 0x17f51 = "The specified data unit already exist." */
    '\x03','\x18','\x9d','u','n','i','t',' ','\x80','e','x','i','s','t','.',
/* 0x17f60 = "VERR_IOM_MMIO_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','\xd4','_','R','A','N','G','E','_','\x06','\x40',
/* 0x17f6f = "Wrong JSON type for string value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','\xf2','\xe8',
/* 0x17f7e = "VINF_IOM_R3_MMIO_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd4','_','W','R','I','T','E',
/* 0x17f8d = "VERR_ISOMK_IPE_READ_FILE_DATA_3" */
    '\x01','\x1f','\x14','R','E','A','D','_','\xaa','D','A','T','A','_','3',
/* 0x17f9c = "VERR_ISOMK_IPE_READ_FILE_DATA_2" */
    '\x01','\x1f','\x14','R','E','A','D','_','\xaa','D','A','T','A','_','2',
/* 0x17fab = "VERR_ISOMK_IPE_READ_FILE_DATA_1" */
    '\x01','\x1f','\x14','R','E','A','D','_','\xaa','D','A','T','A','_','1',
/* 0x17fba = "Bad symbol table entry." */
    '\x9f','s','y','m','b','o','l',' ','\xb1','e','n','t','r','y','.',
/* 0x17fc9 = "VERR_PGM_NOT_USED_IN_MODE" */
    '\x01','\x8c','\x06','U','S','E','D','_','I','N','_','M','O','D','E',
/* 0x17fd8 = "VERR_VD_DMG_INVALID_HEADER" */
    '\x01','V','D','_','D','M','G','_','\x05','H','E','A','D','E','R',
/* 0x17fe7 = "VERR_WEB_INVALID_OBJECT_ID" */
    '\x01','W','E','B','_','\x05','O','B','J','E','C','T','_','I','D',
/* 0x17ff6 = "The trace log version is not supported." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\xd1','\x0b','\x07','\xa5',
/* 0x18005 = "Reason for leaving RZ: MMIO write." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd4',' ','w','r','i','t','e','.',
/* 0x18014 = "VERR_TAR_EMPTY_NAME" */
    '\x01','T','A','R','_','E','M','P','T','Y','_','N','A','M','E',
/* 0x18023 = "Syntax error - function not found." */
    '\xfb','\x09','-',' ','f','u','n','c','t','i','o','n',' ','\x07','\x89',
/* 0x18032 = "VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE" */
    '\x01','\x8c','\x06','\x83','_','F','O','R','_','\xee','_','M','O','D','E',
/* 0x18041 = "VERR_SEEK_ON_DEVICE" */
    '\x01','S','E','E','K','_','O','N','_','D','E','V','I','C','E',
/* 0x18050 = "VERR_FILE_AIO_NOT_PREPARED" */
    '\x01','\xaa','A','I','O','_','\x06','P','R','E','P','A','R','E','D',
/* 0x1805f = "VERR_NET_ALREADY_CONNECTED" */
    '\x01','N','E','T','_','\x9b','C','O','N','N','E','C','T','E','D',
/* 0x1806e = "VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION" */
    '\x01','\xe9','\x1a','T','E','R','M','_','S','E','C','T','I','O','N',
/* 0x1807d = "VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR" */
    '\x01','\x24','\xbf','O','S','S','L','_','\xbf','I','N','I','T','_','\x1c',
/* 0x1808c = "VERR_PROC_DETACH_NOT_SUPPORTED" */
    '\x01','P','R','O','C','_','D','E','T','A','C','H','_','\x06','\x83',
/* 0x1809b = "VERR_IEM_INVALID_INSTR_LENGTH" */
    '\x01','\x9c','\x05','I','N','S','T','R','_','L','E','N','G','T','H',
/* 0x180aa = "VERR_COM_INVALID_SESSION_STATE" */
    '\x01','C','O','M','_','\x05','S','E','S','S','I','O','N','_','\xf1',
/* 0x180b9 = "VERR_PDM_NO_RTC_INSTANCE" */
    '\x01','\x7d','\x60','R','T','C','_','I','N','S','T','A','N','C','E',
/* 0x180c8 = "VERR_IS_A_DIRECTORY" */
    '\x01','I','S','_','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x180d7 = "VERR_DBG_CFG_INVALID_VALUE" */
    '\x01','D','B','G','_','C','F','G','_','\x05','V','A','L','U','E',
/* 0x180e6 = "Invalid VMXON pointer." */
    '\x0c','V','M','X','O','N',' ','p','o','i','n','t','e','r','.',
/* 0x180f5 = "VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND" */
    '\x01','\xe9','\x91','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x18104 = "Unsupported data unit version." */
    '\x98','\x9d','u','n','i','t',' ','v','e','r','s','i','o','n','.',
/* 0x18113 = "VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x1b','F','E','W',
/* 0x18122 = "VERR_SSM_LOAD_CONFIG_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','C','O','N','F','I','G','_','\x19',
/* 0x18131 = "VFS chain element provider not found." */
    '\x8d',' ','\xa1','\x5e','p','r','o','v','i','d','e','r',' ','\x07','\x89',
/* 0x18140 = "VERR_TAR_NAME_TOO_LONG" */
    '\x01','T','A','R','_','N','A','M','E','_','\x1b','L','O','N','G',
/* 0x1814f = "VERR_IPC_SEND_MAP_FAILED" */
    '\x01','I','P','C','_','S','E','N','D','_','M','A','P','_','\x17',
/* 0x1815e = "VERR_VFS_BOGUS_FORMAT" */
    '\x01','\x8d','_','B','O','G','U','S','_','F','O','R','M','A','T',
/* 0x1816d = "Raw: Invalid image file header." */
    'R','a','w',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x1817c = "VERR_LDRMACHO_BAD_LOAD_COMMAND" */
    '\x01','\xe9','\x1d','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x1818b = "VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS" */
    '\x01','\x24','\xe5','\x60','\xbf','A','L','G','O','R','I','T','H','M','S',
/* 0x1819a = "Data size overflow." */
    'D','a','t','a',' ','\xf8','o','v','e','r','f','l','o','w','.',
/* 0x181a9 = "Bucket already exists." */
    'B','u','c','k','e','t',' ','\x80','e','x','i','s','t','s','.',
/* 0x181b8 = "VERR_SIGNAL_INVALID" */
    '\x01','S','I','G','N','A','L','_','I','N','V','A','L','I','D',
/* 0x181c7 = "VERR_DBGC_PARSE_NOT_IMPLEMENTED" */
    '\x01','\xfd','\xe4','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x181d6 = "VERR_FILE_AIO_COMPLETED" */
    '\x01','\xaa','A','I','O','_','C','O','M','P','L','E','T','E','D',
/* 0x181e5 = "VERR_LDR_NOT_FORWARDER" */
    '\x01','L','D','R','_','\x06','F','O','R','W','A','R','D','E','R',
/* 0x181f4 = "VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING" */
    '\x01','\xa2','\x05','V','I','D','E','O','T','E','X','_','\xd6','_','\xc8',
/* 0x18203 = "VERR_LDRELF_MACHINE" */
    '\x01','L','D','R','E','L','F','_','M','A','C','H','I','N','E',
/* 0x18212 = "VERR_CR_X509_NAME_EMPTY_STRING" */
    '\x01','\x24','\xb7','N','A','M','E','_','E','M','P','T','Y','_','\xd6',
/* 0x18221 = "Recompiler: Out of memory for labels." */
    '\x13','O','u','t',' ','\x15','\x86','\x10','l','a','b','e','l','s','.',
/* 0x18230 = "VERR_FLOAT_OVERFLOW" */
    '\x01','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x1823f = "VERR_PDM_GEOMETRY_NOT_SET" */
    '\x01','\x7d','G','E','O','M','E','T','R','Y','_','\x06','S','E','T',
/* 0x1824e = "VERR_NET_PROTOCOL_TYPE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\xb3',
/* 0x1825d = "VERR_SELM_GDT_TOO_FULL" */
    '\x01','S','E','L','M','_','G','D','T','_','\x1b','F','U','L','L',
/* 0x1826c = "VWRN_TRAILING_CHARS" */
    '\xe6','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x1827b = "VERR_CR_SPC_GENERIC_ERROR" */
    '\x01','\x24','S','P','C','_','G','E','N','E','R','I','C','_','\x1c',
/* 0x1828a = "VERR_SEM_OWNER_DIED" */
    '\x01','S','E','M','_','O','W','N','E','R','_','D','I','E','D',
/* 0x18299 = "The owner is not root (hardening)." */
    '\x03','o','w','n','e','r',' ','\x0b','\x07','r','o','o','t',' ','\xae',
/* 0x182a8 = "VERR_CR_X509_CPV_ISSUER_MISMATCH" */
    '\x01','\x24','\xb7','C','P','V','_','I','S','S','U','E','R','_','\x19',
/* 0x182b7 = "Access denied error." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x85',
/* 0x182c6 = "Bad descriptor tag checksum." */
    '\x9f','\xe3','t','a','g',' ','c','h','e','c','k','s','u','m','.',
/* 0x182d5 = "Patch was removed." */
    'P','a','t','c','h',' ','\x11','r','e','m','o','v','e','d','.',
/* 0x182e4 = "VERR_SHCLPB_EVENT_FAILED" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','\x17',
/* 0x182f3 = "Invalid segment index." */
    '\x0c','s','e','g','m','e','n','t',' ','i','n','d','e','x','.',
/* 0x18302 = "VERR_TOO_MANY_CPUID_LEAVES" */
    '\x01','\x1b','\xac','C','P','U','I','D','_','L','E','A','V','E','S',
/* 0x18311 = "Installation has failed." */
    'I','n','s','t','a','l','l','a','t','i','o','n',' ','\x5c','\x7b',
/* 0x18320 = "The digest algorithm is not known to us." */
    '\x03','\xd8','\xd5','\x0b','\x07','k','n','o','w','n',' ','\x0a','u','s','.',
/* 0x1832f = "VERR_CR_PKCS7_NOT_SIGNED_DATA" */
    '\x01','\x24','\xe5','\x06','S','I','G','N','E','D','_','D','A','T','A',
/* 0x1833e = "VERR_XAR_TOC_XML_PARSE_ERROR" */
    '\x01','X','A','R','_','T','O','C','_','X','M','L','_','\xe4','\x1c',
/* 0x1834d = "Process Verification Failure: Bad image signature." */
    '\x1e','\x0d','\x12','\x9f','\x26','s','i','g','n','a','t','u','r','e','.',
/* 0x1835c = "VERR_SUPDRV_VTG_BAD_PROVIDER" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','V','I','D','E','R',
/* 0x1836b = "VERR_CR_X509_CPV_NOT_CA_CERT" */
    '\x01','\x24','\xb7','C','P','V','_','\x06','C','A','_','C','E','R','T',
/* 0x1837a = "VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','\xce','\x06','\x40',
/* 0x18389 = "VERR_SVM_UNEXPECTED_XCPT_EXIT" */
    '\x01','S','V','M','_','\x88','X','C','P','T','_','E','X','I','T',
/* 0x18398 = "VDI: Invalid image file header." */
    'V','D','I',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x183a7 = "Already loaded." */
    'A','l','r','e','a','d','y',' ','l','o','a','d','e','d','.',
/* 0x183b6 = "VERR_PDM_NO_PIC_INSTANCE" */
    '\x01','\x7d','\x60','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x183c5 = "The specified LUN is invalid." */
    '\x03','\x18','L','U','N',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x183d4 = "VERR_ISOFS_MULTIPLE_LVDS" */
    '\x01','\x97','M','U','L','T','I','P','L','E','_','L','V','D','S',
/* 0x183e3 = "Unable to decode date value." */
    '\xe1','\x0a','d','e','c','o','d','e',' ','d','a','t','e',' ','\xe8',
/* 0x183f2 = "VERR_JSON_MALFORMED" */
    '\x01','J','S','O','N','_','M','A','L','F','O','R','M','E','D',
/* 0x18401 = "Recompiler: Out of memory for fixups." */
    '\x13','O','u','t',' ','\x15','\x86','\x10','f','i','x','u','p','s','.',
/* 0x18410 = "Invalid dotted string." */
    '\x0c','d','o','t','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x1841f = "VERR_SUPDRV_VTG_BAD_HDR_MISC" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','M','I','S','C',
/* 0x1842e = "VERR_GETOPT_UNKNOWN_OPTION" */
    '\x01','G','E','T','O','P','T','_','\x91','O','P','T','I','O','N',
/* 0x1843d = "VERR_SUP_VP_UNKOWN_MEM_TYPE" */
    '\x01','\x95','\xbd','U','N','K','O','W','N','_','M','E','M','_','\xb3',
/* 0x1844c = "VERR_FAM_MONITOR_FILE_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','\xaa','\x17',
/* 0x1845b = "VERR_TAR_NOT_USTAR_V00" */
    '\x01','T','A','R','_','\x06','U','S','T','A','R','_','V','0','0',
/* 0x1846a = "VERR_CR_KEY_NO_DEK_INFO" */
    '\x01','\x24','K','E','Y','_','\x60','D','E','K','_','I','N','F','O',
/* 0x18479 = "VERR_NET_PROTOCOL_ERROR" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x1c',
/* 0x18488 = "Write protect error." */
    'W','r','i','t','e',' ','p','r','o','t','e','c','t',' ','\x85',
/* 0x18497 = "The specified path was not absolute (hardening)." */
    '\x03','\x18','\xd2','\x11','\x07','a','b','s','o','l','u','t','e',' ','\xae',
/* 0x184a6 = "VERR_SSM_FIELD_COMPLEX" */
    '\x01','\xb0','F','I','E','L','D','_','C','O','M','P','L','E','X',
/* 0x184b5 = "Process Verification Failure: Bad section raw data size." */
    '\x1e','\x0d','\x12','\x9f','\xdd','r','a','w',' ','\x9d','s','i','z','e','.',
/* 0x184c4 = "Raw mode doesn't support SMP." */
    'R','a','w',' ','m','o','d','e',' ','\xc9','\xd0','S','M','P','.',
/* 0x184d3 = "VERR_CR_X509_CERTPATHS_INTERNAL_ERROR" */
    '\x01','\x24','\xb7','C','E','R','T','P','A','T','H','S','_','\xc3','\x1c',
/* 0x184e2 = "Unimplemented ASN." */
    'U','n','i','m','p','l','e','m','e','n','t','e','d',' ','\xf6',
/* 0x184f1 = "VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\xb3','_','\x06','\x83',
/* 0x18500 = "VERR_GSTCTL_GUEST_ERROR" */
    '\x01','G','S','T','C','T','L','_','G','U','E','S','T','_','\x1c',
/* 0x1850f = "Patch disabled." */
    'P','a','t','c','h',' ','d','i','s','a','b','l','e','d','.',
/* 0x1851e = "VERR_PATCH_ALREADY_ENABLED" */
    '\x01','P','A','T','C','H','_','\x9b','E','N','A','B','L','E','D',
/* 0x1852d = "Bad VTG header - to high value." */
    '\x9f','V','T','G',' ','\xb4','-',' ','\x0a','h','i','g','h',' ','\xe8',
/* 0x1853c = "Not MMIO2 page." */
    'N','o','t',' ','M','M','I','O','2',' ','p','a','g','e','.',
/* 0x1854b = "VINF_DBGF_BP_ALREADY_DISABLED" */
    '\x0e','\xb9','_','B','P','_','\x9b','D','I','S','A','B','L','E','D',
/* 0x1855a = "VERR_ISOFS_BAD_TAG_CHECKSUM" */
    '\x01','\x97','\x1d','T','A','G','_','C','H','E','C','K','S','U','M',
/* 0x18569 = "Bad VTG header - offset." */
    '\x9f','V','T','G',' ','\xb4','-',' ','o','f','f','s','e','t','.',
/* 0x18578 = "VERR_PATCH_DISABLED" */
    '\x01','P','A','T','C','H','_','D','I','S','A','B','L','E','D',
/* 0x18587 = "VERR_SHCLPB_GUEST_ERROR" */
    '\x01','S','H','C','L','P','B','_','G','U','E','S','T','_','\x1c',
/* 0x18596 = "VERR_VD_VHD_INVALID_HEADER" */
    '\x01','V','D','_','V','H','D','_','\x05','H','E','A','D','E','R',
/* 0x185a5 = "VERR_VMX_MSR_LOCKING_FAILED" */
    '\x01','\xe2','M','S','R','_','L','O','C','K','I','N','G','_','\x17',
/* 0x185b4 = "PML4 entry not present." */
    'P','M','L','4',' ','\xca','\x07','p','r','e','s','e','n','t','.',
/* 0x185c3 = "VERR_PGM_PHYS_MMIO_EX_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xd4','_','E','X','_','I','P','E',
/* 0x185d2 = "No read callback." */
    '\xe0','r','e','a','d',' ','c','a','l','l','b','a','c','k','.',
/* 0x185e1 = "VERR_ISOFS_MULTIPLE_PVDS" */
    '\x01','\x97','M','U','L','T','I','P','L','E','_','P','V','D','S',
/* 0x185f0 = "VERR_VMX_MSR_VMX_ENABLE_FAILED" */
    '\x01','\xe2','M','S','R','_','\xe2','E','N','A','B','L','E','_','\x17',
/* 0x185ff = "The OS was not detected." */
    '\x03','O','S',' ','\x11','\x07','d','e','t','e','c','t','e','d','.',
/* 0x1860e = "Invalid guest LDT selector." */
    '\x0c','\xbb','L','D','T',' ','s','e','l','e','c','t','o','r','.',
/* 0x1861d = "Invalid host bit mask." */
    '\x0c','h','o','s','t',' ','b','i','t',' ','m','a','s','k','.',
/* 0x1862c = "VERR_SUPDRV_TRACER_TOO_LARGE" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1b','L','A','R','G','E',
/* 0x1863b = "VINF_EM_DBG_STEPPED" */
    '\x0e','E','M','_','D','B','G','_','S','T','E','P','P','E','D',
/* 0x1864a = "Invalid magic or cookie." */
    '\x0c','m','a','g','i','c',' ','\xa9','c','o','o','k','i','e','.',
/* 0x18659 = "VERR_LOG_REVISION_MISMATCH" */
    '\x01','L','O','G','_','R','E','V','I','S','I','O','N','_','\x19',
/* 0x18668 = "VERR_SIGNAL_REFUSED" */
    '\x01','S','I','G','N','A','L','_','R','E','F','U','S','E','D',
/* 0x18677 = "Unknown glob variable." */
    '\xef','g','l','o','b',' ','v','a','r','i','a','b','l','e','.',
/* 0x18686 = "VERR_VM_FATAL_WAIT_ERROR" */
    '\x01','\xc6','_','F','A','T','A','L','_','W','A','I','T','_','\x1c',
/* 0x18695 = "VERR_NET_NOT_CONNECTED" */
    '\x01','N','E','T','_','\x06','C','O','N','N','E','C','T','E','D',
/* 0x186a4 = "VERR_IEM_INVALID_ADDRESS_MODE" */
    '\x01','\x9c','\x05','A','D','D','R','E','S','S','_','M','O','D','E',
/* 0x186b3 = "VERR_DIS_INVALID_PARAMETER" */
    '\x01','D','I','S','_','\x05','P','A','R','A','M','E','T','E','R',
/* 0x186c2 = "VERR_CFGM_NOT_PASSWORD" */
    '\x01','C','F','G','M','_','\x06','P','A','S','S','W','O','R','D',
/* 0x186d1 = "VERR_IO_GEN_FAILURE" */
    '\x01','I','O','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x186e0 = "VERR_GETOPT_INDEX_MISSING" */
    '\x01','G','E','T','O','P','T','_','I','N','D','E','X','_','\xc5',
/* 0x186ef = "VERR_NOT_DATA_SELECTOR" */
    '\x01','\x06','D','A','T','A','_','S','E','L','E','C','T','O','R',
/* 0x186fe = "The operation has already been cancelled." */
    '\x03','\x96','\x5c','\x80','\xcd','c','a','n','c','e','l','l','e','d','.',
/* 0x1870d = "VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION" */
    '\x01','\xe9','\x1a','I','N','I','T','_','S','E','C','T','I','O','N',
/* 0x1871c = "VHD: Invalid image file header." */
    'V','H','D',':',' ','\x0c','\x26','\x22','h','e','a','d','e','r','.',
/* 0x1872b = "VERR_VD_RAW_INVALID_HEADER" */
    '\x01','V','D','_','R','A','W','_','\x05','H','E','A','D','E','R',
/* 0x1873a = "VERR_SUP_VP_BAD_SECTION_RVA" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','R','V','A',
/* 0x18749 = "VERR_LDR_BAD_FORWARDER" */
    '\x01','L','D','R','_','\x1d','F','O','R','W','A','R','D','E','R',
/* 0x18758 = "VERR_VMX_MSR_VMX_DISABLED" */
    '\x01','\xe2','M','S','R','_','\xe2','D','I','S','A','B','L','E','D',
/* 0x18767 = "Send cancelled." */
    'S','e','n','d',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x18776 = "VERR_XAR_BAD_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\x1d','\xfa','_','E','L','E','M','E','N','T',
/* 0x18785 = "VERR_PGM_PHYS_PAGE_GET_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xce','G','E','T','_','I','P','E',
/* 0x18794 = "VINF_PATCH_CONTINUE" */
    '\x0e','P','A','T','C','H','_','C','O','N','T','I','N','U','E',
/* 0x187a3 = "VERR_XAR_TOC_UTF8_ENCODING" */
    '\x01','X','A','R','_','T','O','C','_','U','T','F','8','_','\xc8',
/* 0x187b2 = "VERR_ASN1_INVALID_DATA_POINTER" */
    '\x01','\xa2','\x05','D','A','T','A','_','P','O','I','N','T','E','R',
/* 0x187c1 = "VERR_VFS_CHAIN_PROVIDER_NOT_FOUND" */
    '\x01','\x8d','_','\x8e','P','R','O','V','I','D','E','R','_','\x06','\x40',
/* 0x187d0 = "Unknown saved state record." */
    '\xef','s','a','v','e','d',' ','\xcc','r','e','c','o','r','d','.',
/* 0x187df = "VERR_DRIVE_IS_EMPTY" */
    '\x01','D','R','I','V','E','_','I','S','_','E','M','P','T','Y',
/* 0x187ee = "VERR_CR_KEY_FORMAT_NOT_SUPPORTED" */
    '\x01','\x24','K','E','Y','_','F','O','R','M','A','T','_','\x06','\x83',
/* 0x187fd = "Non-string object inside X." */
    'N','o','n','-','\xf2','\xa8','i','n','s','i','d','e',' ','X','.',
/* 0x1880c = "VERR_SSM_LOADED_TOO_MUCH" */
    '\x01','\xb0','L','O','A','D','E','D','_','\x1b','M','U','C','H',
/* 0x1881a = "Bad VTG string table offset." */
    '\x9f','V','T','G',' ','\xf2','\xb1','o','f','f','s','e','t','.',
/* 0x18828 = "Invalid flags was given." */
    '\x0c','f','l','a','g','s',' ','\x11','g','i','v','e','n','.',
/* 0x18836 = "VERR_JSON_VALUE_INVALID_TYPE" */
    '\x01','J','S','O','N','_','V','A','L','U','E','_','\x05','\xb3',
/* 0x18844 = "Internal processing error #1 in the GVMM code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','G','V','M','M',' ','\x84',
/* 0x18852 = "Failed to enumerate directory (hardening)." */
    '\x8b','\x0a','e','n','u','m','e','r','a','t','e',' ','\x25','\xae',
/* 0x18860 = "Internal processing error in the HM init code." */
    '\x08','\x04','\x09','\x0f','\x02','H','M',' ','i','n','i','t',' ','\x84',
/* 0x1886e = "VERR_SSM_FIELD_INVALID_VALUE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','V','A','L','U','E',
/* 0x1887c = "VERR_SEM_LV_NESTED" */
    '\x01','S','E','M','_','L','V','_','N','E','S','T','E','D',
/* 0x1888a = "VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING" */
    '\x01','\xa2','\x05','G','R','A','P','H','I','C','_','\xd6','_','\xc8',
/* 0x18898 = "VERR_L4_INVALID_DS_OFFSET" */
    '\x01','L','4','_','\x05','D','S','_','O','F','F','S','E','T',
/* 0x188a6 = "VERR_ASN1_DYNTYPE_BAD_TAG" */
    '\x01','\xa2','D','Y','N','T','Y','P','E','_','\x1d','T','A','G',
/* 0x188b4 = "VERR_CFGM_CHILD_NOT_FOUND" */
    '\x01','C','F','G','M','_','C','H','I','L','D','_','\x06','\x40',
/* 0x188c2 = "VERR_WRITE_PROTECT" */
    '\x01','W','R','I','T','E','_','P','R','O','T','E','C','T',
/* 0x188d0 = "VERR_PDM_CRITSECT_IPE" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','_','I','P','E',
/* 0x188de = "Unexpected turn of events." */
    '\x94','t','u','r','n',' ','\x15','e','v','e','n','t','s','.',
/* 0x188ec = "VERR_VD_IOCTX_HALT" */
    '\x01','V','D','_','I','O','C','T','X','_','H','A','L','T',
/* 0x188fa = "Unexpected trap in patch code." */
    '\x94','t','r','a','p',' ','\x0f','p','a','t','c','h',' ','\x84',
/* 0x18908 = "VINF_DBGF_OS_NOT_DETCTED" */
    '\x0e','\xb9','_','O','S','_','\x06','D','E','T','C','T','E','D',
/* 0x18916 = "VERR_DBGC_PARSE_VARIABLE_NOT_FOUND" */
    '\x01','\xfd','\xe4','V','A','R','I','A','B','L','E','_','\x06','\x40',
/* 0x18924 = "VERR_REBOOT_NEEDED" */
    '\x01','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x18932 = "VERR_PGM_MAPPINGS_SMP" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','S','M','P',
/* 0x18940 = "VERR_RAW_MODE_INVALID_SMP" */
    '\x01','R','A','W','_','M','O','D','E','_','\x05','S','M','P',
/* 0x1894e = "A directory entry in the archive." */
    'A',' ','\x25','\xca','\x0f','\x02','a','r','c','h','i','v','e','.',
/* 0x1895c = "VERR_CFGM_VALUE_NOT_FOUND" */
    '\x01','C','F','G','M','_','V','A','L','U','E','_','\x06','\x40',
/* 0x1896a = "VERR_IOQUEUE_EMPTY" */
    '\x01','I','O','Q','U','E','U','E','_','E','M','P','T','Y',
/* 0x18978 = "VERR_SUPLIB_UNEXPECTED_INSTRUCTION" */
    '\x01','\xd7','\x88','I','N','S','T','R','U','C','T','I','O','N',
/* 0x18986 = "Disk was changed." */
    'D','i','s','k',' ','\x11','c','h','a','n','g','e','d','.',
/* 0x18994 = "VERR_SUP_VP_STUB_OPEN_ERROR" */
    '\x01','\x95','\xbd','S','T','U','B','_','O','P','E','N','_','\x1c',
/* 0x189a2 = "VERR_PGM_TOO_MANY_RAM_RANGES" */
    '\x01','\x8c','\x1b','\xac','R','A','M','_','R','A','N','G','E','S',
/* 0x189b0 = "Code signing error." */
    'C','o','d','e',' ','s','i','g','n','i','n','g',' ','\x85',
/* 0x189be = "The ICB for is too small." */
    '\x03','I','C','B',' ','\x10','\x0b','\x9e','s','m','a','l','l','.',
/* 0x189cc = "VERR_STALE_FILE_HANDLE" */
    '\x01','S','T','A','L','E','_','\xaa','H','A','N','D','L','E',
/* 0x189da = "VERR_NOT_SUP_IN_RAW_MODE" */
    '\x01','\x06','\x95','I','N','_','R','A','W','_','M','O','D','E',
/* 0x189e8 = "VERR_ZIP_CORRUPTED" */
    '\x01','Z','I','P','_','C','O','R','R','U','P','T','E','D',
/* 0x189f6 = "VERR_NEM_MAP_PAGES_FAILED" */
    '\x01','\xee','_','M','A','P','_','P','A','G','E','S','_','\x17',
/* 0x18a04 = "VERR_HOSTIF_INIT_FAILED" */
    '\x01','H','O','S','T','I','F','_','I','N','I','T','_','\x17',
/* 0x18a12 = "Syntax error - invalid numeric value." */
    '\xfb','\x09','-',' ','\x8f','n','u','m','e','r','i','c',' ','\xe8',
/* 0x18a20 = "VERR_LDRLX_BAD_SONAME" */
    '\x01','L','D','R','L','X','_','\x1d','S','O','N','A','M','E',
/* 0x18a2e = "VERR_GMM_TOO_MANY_REGIONS" */
    '\x01','G','M','M','_','\x1b','\xac','R','E','G','I','O','N','S',
/* 0x18a3c = "VERR_VM_THREAD_NOT_EMT" */
    '\x01','\xc6','_','T','H','R','E','A','D','_','\x06','E','M','T',
/* 0x18a4a = "VERR_RECORDING_ENCODING_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','\xc8','_','\x17',
/* 0x18a58 = "VERR_PGM_POOL_TOO_MANY_LOOPS" */
    '\x01','\x8c','P','O','O','L','_','\x1b','\xac','L','O','O','P','S',
/* 0x18a66 = "VERR_NOT_POWER_OF_TWO" */
    '\x01','\x06','P','O','W','E','R','_','O','F','_','T','W','O',
/* 0x18a74 = "Max process number reached." */
    'M','a','x',' ','\x92','\xfc','r','e','a','c','h','e','d','.',
/* 0x18a82 = "VERR_NO_MORE_HANDLES" */
    '\x01','\x60','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x18a90 = "VERR_CFGM_NOT_INTEGER" */
    '\x01','C','F','G','M','_','\x06','I','N','T','E','G','E','R',
/* 0x18a9e = "VERR_CR_DIGEST_COMPROMISED" */
    '\x01','\x24','\xbf','C','O','M','P','R','O','M','I','S','E','D',
/* 0x18aac = "VERR_DWARF_BAD_ABBREV" */
    '\x01','D','W','A','R','F','_','\x1d','A','B','B','R','E','V',
/* 0x18aba = "VERR_LDRVI_IMAGE_HASH_MISMATCH" */
    '\x01','\xf4','I','M','A','G','E','_','H','A','S','H','_','\x19',
/* 0x18ac8 = "VERR_ISOMK_IPE_NAMESPACE_6" */
    '\x01','\x1f','\x14','N','A','M','E','S','P','A','C','E','_','6',
/* 0x18ad6 = "VERR_ISOMK_IPE_NAMESPACE_5" */
    '\x01','\x1f','\x14','N','A','M','E','S','P','A','C','E','_','5',
/* 0x18ae4 = "VERR_ISOMK_IPE_NAMESPACE_4" */
    '\x01','\x1f','\x14','N','A','M','E','S','P','A','C','E','_','4',
/* 0x18af2 = "VERR_ISOMK_IPE_NAMESPACE_2" */
    '\x01','\x1f','\x14','N','A','M','E','S','P','A','C','E','_','2',
/* 0x18b00 = "VERR_VFS_CHAIN_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','T','H','R','E','E','_','A','R','G','S',
/* 0x18b0e = "VERR_PGM_PHYS_PAGE_MAP_IPE_3" */
    '\x01','\x8c','P','H','Y','S','_','\xce','M','A','P','_','\x14','3',
/* 0x18b1c = "VERR_PGM_PHYS_PAGE_MAP_IPE_2" */
    '\x01','\x8c','P','H','Y','S','_','\xce','M','A','P','_','\x14','2',
/* 0x18b2a = "VERR_PGM_PHYS_PAGE_MAP_IPE_1" */
    '\x01','\x8c','P','H','Y','S','_','\xce','M','A','P','_','\x14','1',
/* 0x18b38 = "VERR_PGM_PHYS_PAGE_MAP_IPE_4" */
    '\x01','\x8c','P','H','Y','S','_','\xce','M','A','P','_','\x14','4',
/* 0x18b46 = "The breakpoint has no command." */
    '\x03','\xc0','\x5c','n','o',' ','c','o','m','m','a','n','d','.',
/* 0x18b54 = "VERR_PDM_USBHLPR3_VERSION_MISMATCH" */
    '\x01','\x7d','U','S','B','H','L','P','R','3','_','\xbc','_','\x19',
/* 0x18b62 = "VERR_ISOMK_IPE_NAMESPACE_3" */
    '\x01','\x1f','\x14','N','A','M','E','S','P','A','C','E','_','3',
/* 0x18b70 = "Page not present." */
    'P','a','g','e',' ','\x07','p','r','e','s','e','n','t','.',
/* 0x18b7e = "VERR_VD_DMG_XML_PARSE_ERROR" */
    '\x01','V','D','_','D','M','G','_','X','M','L','_','\xe4','\x1c',
/* 0x18b8c = "VWRN_PATCH_REMOVED" */
    '\xe6','P','A','T','C','H','_','R','E','M','O','V','E','D',
/* 0x18b9a = "VERR_SUPLIB_TEXT_NOT_SEALED" */
    '\x01','\xd7','T','E','X','T','_','\x06','S','E','A','L','E','D',
/* 0x18ba8 = "Child node was not found." */
    'C','h','i','l','d',' ','n','o','d','e',' ','\x11','\x07','\x89',
/* 0x18bb6 = "VERR_CR_PKCS7_KEY_USAGE_MISMATCH" */
    '\x01','\x24','\xe5','K','E','Y','_','U','S','A','G','E','_','\x19',
/* 0x18bc4 = "The VM has been restored." */
    '\x03','\xc6',' ','\x5c','\xcd','r','e','s','t','o','r','e','d','.',
/* 0x18bd2 = "Invalid link address." */
    '\x0c','l','i','n','k',' ','a','d','d','r','e','s','s','.',
/* 0x18be0 = "VERR_ISOMK_IPE_NAMESPACE_1" */
    '\x01','\x1f','\x14','N','A','M','E','S','P','A','C','E','_','1',
/* 0x18bee = "VERR_DBGC_PARSE_NUMBER_TOO_BIG" */
    '\x01','\xfd','\xe4','N','U','M','B','E','R','_','\x1b','B','I','G',
/* 0x18bfc = "VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION" */
    '\x01','\xb0','\x1a','D','A','T','A','_','U','N','I','T','_','\xbc',
/* 0x18c0a = "VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING" */
    '\x01','\xa2','\x05','V','I','S','I','B','L','E','_','\xd6','_','\xc8',
/* 0x18c18 = "VERR_HTTP_PROXY_NOT_FOUND" */
    '\x01','H','T','T','P','_','P','R','O','X','Y','_','\x06','\x40',
/* 0x18c26 = "Too little data in ASN." */
    'T','o','o',' ','l','i','t','t','l','e',' ','\x9d','\x0f','\xf6',
/* 0x18c34 = "VERR_DVM_MAP_EMPTY" */
    '\x01','D','V','M','_','M','A','P','_','E','M','P','T','Y',
/* 0x18c42 = "VERR_GVMM_INSTANCE" */
    '\x01','G','V','M','M','_','I','N','S','T','A','N','C','E',
/* 0x18c50 = "VINF_ENV_VAR_UNSET" */
    '\x0e','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x18c5e = "VERR_PDM_DRVHLPR3_VERSION_MISMATCH" */
    '\x01','\x7d','D','R','V','H','L','P','R','3','_','\xbc','_','\x19',
/* 0x18c6c = "VERR_DBGF_REGISTER_NOT_FOUND" */
    '\x01','\xb9','_','R','E','G','I','S','T','E','R','_','\x06','\x40',
/* 0x18c7a = "VINF_CR_DIGEST_COMPROMISED" */
    '\x0e','\x24','\xbf','C','O','M','P','R','O','M','I','S','E','D',
/* 0x18c88 = "VERR_VD_DISCARD_NOT_SUPPORTED" */
    '\x01','V','D','_','D','I','S','C','A','R','D','_','\x06','\x83',
/* 0x18c96 = "VERR_LDRVI_READ_ERROR_SHDRS" */
    '\x01','\xf4','R','E','A','D','_','\x1c','_','S','H','D','R','S',
/* 0x18ca4 = "VERR_RT_REQUEST_INVALID_TYPE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x05','\xb3',
/* 0x18cb2 = "VERR_IOMMU_DTE_BAD_OFFSET" */
    '\x01','\xfe','_','D','T','E','_','\x1d','O','F','F','S','E','T',
/* 0x18cc0 = "VERR_VD_UNKNOWN_INTERFACE" */
    '\x01','V','D','_','\x91','I','N','T','E','R','F','A','C','E',
/* 0x18cce = "VERR_SUPLIB_PATH_IS_ROOT" */
    '\x01','\xd7','P','A','T','H','_','I','S','_','R','O','O','T',
/* 0x18cdc = "VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING" */
    '\x01','\xa2','\x05','N','U','M','E','R','I','C','_','\xd6','_','\xc8',
/* 0x18cea = "The alignment is not supported." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x0b','\x07','\xa5',
/* 0x18cf8 = "VERR_TM_UNSTABLE_STATE" */
    '\x01','T','M','_','U','N','S','T','A','B','L','E','_','\xf1',
/* 0x18d06 = "VERR_SUP_VP_BAD_SECTION_FILE_SIZE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','\xaa','\xfa',
/* 0x18d14 = "VERR_LDRLX_NO_SONAME" */
    '\x01','L','D','R','L','X','_','\x60','S','O','N','A','M','E',
/* 0x18d22 = "VERR_PDM_NO_QUEUE_ITEMS" */
    '\x01','\x7d','\x60','Q','U','E','U','E','_','I','T','E','M','S',
/* 0x18d30 = "VERR_NEGATIVE_SEEK" */
    '\x01','N','E','G','A','T','I','V','E','_','S','E','E','K',
/* 0x18d3e = "Internal processing error #2 in the GVMM code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','G','V','M','M',' ','\x84',
/* 0x18d4c = "VERR_IPE_UNEXPECTED_INFO_STATUS" */
    '\x01','\x14','\x88','I','N','F','O','_','S','T','A','T','U','S',
/* 0x18d5a = "VERR_GMM_PAGE_NOT_PRIVATE" */
    '\x01','G','M','M','_','\xce','\x06','P','R','I','V','A','T','E',
/* 0x18d68 = "VERR_DBGF_OS_NOT_DETCTED" */
    '\x01','\xb9','_','O','S','_','\x06','D','E','T','C','T','E','D',
/* 0x18d76 = "VERR_PKZIP_UNKNOWN_TYPE_FLAG" */
    '\x01','P','K','Z','I','P','_','\x91','\xb3','_','F','L','A','G',
/* 0x18d84 = "VERR_CR_X509_INVALID_NAME_STRING_TAG" */
    '\x01','\x24','\xb7','\x05','N','A','M','E','_','\xd6','_','T','A','G',
/* 0x18d92 = "VERR_RESOURCE_BUSY" */
    '\x01','R','E','S','O','U','R','C','E','_','B','U','S','Y',
/* 0x18da0 = "Unsupported descriptor tag version." */
    '\x98','\xe3','t','a','g',' ','v','e','r','s','i','o','n','.',
/* 0x18dae = "The device instance was not found." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','\x11','\x07','\x89',
/* 0x18dbc = "Message too long." */
    'M','e','s','s','a','g','e',' ','\x9e','l','o','n','g','.',
/* 0x18dca = "VERR_COM_INVALID_OBJECT_STATE" */
    '\x01','C','O','M','_','\x05','O','B','J','E','C','T','_','\xf1',
/* 0x18dd8 = "VERR_FILE_AIO_CANCELED" */
    '\x01','\xaa','A','I','O','_','C','A','N','C','E','L','E','D',
/* 0x18de6 = "VERR_NO_STRING_TERMINATOR" */
    '\x01','\x60','\xd6','_','T','E','R','M','I','N','A','T','O','R',
/* 0x18df4 = "VERR_FTP_CLIENT_NOT_FOUND" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','\x06','\x40',
/* 0x18e02 = "VERR_LDRVI_BAD_CERT_FORMAT" */
    '\x01','\xf4','\x1d','C','E','R','T','_','F','O','R','M','A','T',
/* 0x18e10 = "Address already in use." */
    'A','d','d','r','e','s','s',' ','\x80','\x0f','u','s','e','.',
/* 0x18e1e = "VERR_GMM_MTX_FLAGS" */
    '\x01','G','M','M','_','M','T','X','_','F','L','A','G','S',
/* 0x18e2c = "VERR_DBGC_PARSE_FUNCTION_NOT_FOUND" */
    '\x01','\xfd','\xe4','F','U','N','C','T','I','O','N','_','\x06','\x40',
/* 0x18e3a = "Network is down." */
    'N','e','t','w','o','r','k',' ','\x0b','d','o','w','n','.',
/* 0x18e48 = "VERR_NO_CODE_POINT_MEMORY" */
    '\x01','\x60','C','O','D','E','_','P','O','I','N','T','_','\xb6',
/* 0x18e56 = "VERR_SSM_LIVE_FATAL_ERROR" */
    '\x01','\xb0','L','I','V','E','_','F','A','T','A','L','_','\x1c',
/* 0x18e64 = "VERR_LDRMACHO_BAD_OBJECT_FILE" */
    '\x01','\xe9','\x1d','O','B','J','E','C','T','_','F','I','L','E',
/* 0x18e72 = "VERR_DBGC_PARSE_NOT_A_FUNCTION" */
    '\x01','\xfd','\xe4','\x06','A','_','F','U','N','C','T','I','O','N',
/* 0x18e80 = "Invalid drive number." */
    '\x0c','d','r','i','v','e',' ','n','u','m','b','e','r','.',
/* 0x18e8e = "VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS" */
    '\x01','\x1f','\x82','\x1b','\xac','V','O','L','_','D','E','S','C','S',
/* 0x18e9c = "Invalid saved page state." */
    '\x0c','s','a','v','e','d',' ','\xbe','s','t','a','t','e','.',
/* 0x18eaa = "NEM is not available." */
    '\xee',' ','\x0b','\x07','a','v','a','i','l','a','b','l','e','.',
/* 0x18eb8 = "VINF_IEM_SELECTOR_NOT_OK" */
    '\x0e','\x9c','S','E','L','E','C','T','O','R','_','\x06','O','K',
/* 0x18ec6 = "VERR_ASN1_CURSOR_TAG_MISMATCH" */
    '\x01','\xa2','C','U','R','S','O','R','_','T','A','G','_','\x19',
/* 0x18ed4 = "Invalid VMCS pointer." */
    '\x0c','V','M','C','S',' ','p','o','i','n','t','e','r','.',
/* 0x18ee2 = "VERR_FILE_AIO_NO_REQUEST" */
    '\x01','\xaa','A','I','O','_','\x60','R','E','Q','U','E','S','T',
/* 0x18ef0 = "VERR_ACCESS_DENIED" */
    '\x01','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x18efe = "VERR_VFS_CHAIN_TAKES_FILE" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','F','I','L','E',
/* 0x18f0c = "VERR_VM_UNEXPECTED_UNSTABLE_STATE" */
    '\x01','\xc6','_','\x88','U','N','S','T','A','B','L','E','_','\xf1',
/* 0x18f1a = "VERR_PGM_TOO_MANY_ROM_RANGES" */
    '\x01','\x8c','\x1b','\xac','R','O','M','_','R','A','N','G','E','S',
/* 0x18f28 = "VFS chain element takes no arguments." */
    '\x8d',' ','\xa1','\x5e','t','a','k','e','s',' ','n','o',' ','\xde',
/* 0x18f36 = "VERR_VD_BLOCK_FREE" */
    '\x01','V','D','_','B','L','O','C','K','_','F','R','E','E',
/* 0x18f44 = "VERR_PDM_MEDIA_LOCKED" */
    '\x01','\x7d','M','E','D','I','A','_','L','O','C','K','E','D',
/* 0x18f52 = "VINF_DBGF_BP_ALREADY_ENABLED" */
    '\x0e','\xb9','_','B','P','_','\x9b','E','N','A','B','L','E','D',
/* 0x18f60 = "Not data selector." */
    'N','o','t',' ','\x9d','s','e','l','e','c','t','o','r','.',
/* 0x18f6e = "VERR_IOM_INVALID_IOPORT_SIZE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','\xfa',
/* 0x18f7c = "VERR_ENV_VAR_UNSET" */
    '\x01','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x18f8a = "VERR_SUPDRV_VTG_BAD_HDR_PTR" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','P','T','R',
/* 0x18f98 = "VERR_HM_UNEXPECTED_LD_ST_MSR" */
    '\x01','H','M','_','\x88','L','D','_','S','T','_','M','S','R',
/* 0x18fa6 = "VWRN_PATCH_ENABLED" */
    '\xe6','P','A','T','C','H','_','E','N','A','B','L','E','D',
/* 0x18fb4 = "VERR_LDRVI_NO_MEMORY_SIGNATURE" */
    '\x01','\xf4','\x60','\xb6','_','S','I','G','N','A','T','U','R','E',
/* 0x18fc2 = "Bad DWARF string." */
    '\x9f','D','W','A','R','F',' ','s','t','r','i','n','g','.',
/* 0x18fd0 = "VERR_SUPDRV_VTG_BAD_HDR_OFF" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','O','F','F',
/* 0x18fde = "Recompiler: Unexpected register assignment." */
    '\x13','\x94','\xeb','a','s','s','i','g','n','m','e','n','t','.',
/* 0x18fec = "Drive is locked." */
    'D','r','i','v','e',' ','\x0b','l','o','c','k','e','d','.',
/* 0x18ffa = "VERR_SUPDRV_INTERFACE_NOT_SUPPORTED" */
    '\x01','\x90','I','N','T','E','R','F','A','C','E','_','\x06','\x83',
/* 0x19008 = "VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS" */
    '\x01','\x97','\x1b','\xac','\xaa','F','R','A','G','M','E','N','T','S',
/* 0x19016 = "VERR_SUPDRV_COMPONENT_NOT_FOUND" */
    '\x01','\x90','C','O','M','P','O','N','E','N','T','_','\x06','\x40',
/* 0x19024 = "VERR_ASN1_DUMMY_OBJECT" */
    '\x01','\xa2','D','U','M','M','Y','_','O','B','J','E','C','T',
/* 0x19032 = "VERR_NO_TLS_FOR_SELF" */
    '\x01','\x60','T','L','S','_','F','O','R','_','S','E','L','F',
/* 0x19040 = "Page record not found." */
    'P','a','g','e',' ','r','e','c','o','r','d',' ','\x07','\x89',
/* 0x1904e = "VERR_ISOFS_TAG_SECTOR_MISMATCH" */
    '\x01','\x97','T','A','G','_','S','E','C','T','O','R','_','\x19',
/* 0x1905c = "VERR_SUP_VP_BAD_IMAGE_BASE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','B','A','S','E',
/* 0x1906a = "VERR_MEMOBJ_INIT_FAILED" */
    '\x01','M','E','M','O','B','J','_','I','N','I','T','_','\x17',
/* 0x19078 = "VERR_SUPDRV_VTG_BAD_ARGLIST" */
    '\x01','\x90','V','T','G','_','\x1d','A','R','G','L','I','S','T',
/* 0x19086 = "VERR_SMM_INTEGRITY_MACHINE" */
    '\x01','S','M','M','_','\xf7','_','M','A','C','H','I','N','E',
/* 0x19094 = "VERR_VFS_CHAIN_NOT_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','\x06','P','A','T','H','_','O','N','L','Y',
/* 0x190a2 = "VERR_GVM_MISMATCH_VMCPU_SIZE" */
    '\x01','G','V','M','_','\x19','_','V','M','C','P','U','_','\xfa',
/* 0x190b0 = "Trap not handled." */
    'T','r','a','p',' ','\x07','h','a','n','d','l','e','d','.',
/* 0x190be = "VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS" */
    '\x01','\x95','\xbd','\x1b','\xac','\xb6','_','R','E','G','I','O','N','S',
/* 0x190cc = "VINF_REBOOT_NEEDED" */
    '\x0e','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x190da = "Reason for leaving RZ: MMIO read." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd4',' ','r','e','a','d','.',
/* 0x190e8 = "VERR_XAR_BAD_FILE_ELEMENT" */
    '\x01','X','A','R','_','\x1d','\xaa','E','L','E','M','E','N','T',
/* 0x190f6 = "GIM generic operation failed." */
    'G','I','M',' ','g','e','n','e','r','i','c',' ','\x96','\x7b',
/* 0x19104 = "VERR_IOMMU_CMD_INVALID_FORMAT" */
    '\x01','\xfe','_','C','M','D','_','\x05','F','O','R','M','A','T',
/* 0x19112 = "Syntax error - Command not found." */
    '\xfb','\x09','-',' ','C','o','m','m','a','n','d',' ','\x07','\x89',
/* 0x19120 = "VERR_IOM_INVALID_MMIO_HANDLE" */
    '\x01','I','O','M','_','\x05','\xd4','_','H','A','N','D','L','E',
/* 0x1912e = "VERR_NET_HOST_DOWN" */
    '\x01','N','E','T','_','H','O','S','T','_','D','O','W','N',
/* 0x1913c = "VERR_LDRLX_BAD_BUNDLE" */
    '\x01','L','D','R','L','X','_','\x1d','B','U','N','D','L','E',
/* 0x1914a = "VERR_PGM_PML4_MAPPING" */
    '\x01','\x8c','P','M','L','4','_','M','A','P','P','I','N','G',
/* 0x19158 = "VINF_SELM_SYNC_GDT" */
    '\x0e','S','E','L','M','_','S','Y','N','C','_','G','D','T',
/* 0x19166 = "VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM" */
    '\x01','\x24','\xe5','\x91','\xbf','A','L','G','O','R','I','T','H','M',
/* 0x19174 = "VERR_SEM_LV_NOT_OWNER" */
    '\x01','S','E','M','_','L','V','_','\x06','O','W','N','E','R',
/* 0x19182 = "VERR_COM_OBJECT_NOT_FOUND" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','\x06','\x40',
/* 0x19190 = "VERR_INVALID_VMCPU_HANDLE" */
    '\x01','\x05','V','M','C','P','U','_','H','A','N','D','L','E',
/* 0x1919e = "VERR_HOSTIF_TERM_FAILED" */
    '\x01','H','O','S','T','I','F','_','T','E','R','M','_','\x17',
/* 0x191ac = "VERR_SEM_DESTROYED" */
    '\x01','S','E','M','_','D','E','S','T','R','O','Y','E','D',
/* 0x191ba = "VERR_ASN1_INVALID_GENERAL_STRING_ENCODING" */
    '\x01','\xa2','\x05','G','E','N','E','R','A','L','_','\xd6','_','\xc8',
/* 0x191c8 = "VERR_ISOFS_PARTITION_NOT_FOUND" */
    '\x01','\x97','P','A','R','T','I','T','I','O','N','_','\x06','\x40',
/* 0x191d6 = "VERR_ASN1_INVALID_BITSTRING_ENCODING" */
    '\x01','\xa2','\x05','B','I','T','S','T','R','I','N','G','_','\xc8',
/* 0x191e4 = "VERR_HGCM_INTERNAL" */
    '\x01','H','G','C','M','_','I','N','T','E','R','N','A','L',
/* 0x191f2 = "VERR_SSM_LOAD_CPUID_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','C','P','U','I','D','_','\x19',
/* 0x19200 = "No media in drive." */
    '\xe0','m','e','d','i','a',' ','\x0f','d','r','i','v','e','.',
/* 0x1920e = "VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS" */
    '\x01','\xfd','\xe4','\x1b','\xac','A','R','G','U','M','E','N','T','S',
/* 0x1921c = "Access denied." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d','.',
/* 0x1922a = "VERR_GVM_MISMATCH_SVN_REV" */
    '\x01','G','V','M','_','\x19','_','S','V','N','_','R','E','V',
/* 0x19238 = "VERR_ENV_INVALID_VAR_NAME" */
    '\x01','E','N','V','_','\x05','V','A','R','_','N','A','M','E',
/* 0x19246 = "VERR_LDRLX_BAD_HEADER" */
    '\x01','L','D','R','L','X','_','\x1d','H','E','A','D','E','R',
/* 0x19254 = "VERR_JSON_IS_EMPTY" */
    '\x01','J','S','O','N','_','I','S','_','E','M','P','T','Y',
/* 0x19262 = "VERR_SSM_INTEGRITY_UNIT_MAGIC" */
    '\x01','\xb0','\xf7','_','U','N','I','T','_','M','A','G','I','C',
/* 0x19270 = "VERR_PGM_RAM_CONFLICT" */
    '\x01','\x8c','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x1927e = "Winsock init error." */
    'W','i','n','s','o','c','k',' ','i','n','i','t',' ','\x85',
/* 0x1928c = "VERR_PGM_SHW_NONE_IPE" */
    '\x01','\x8c','S','H','W','_','N','O','N','E','_','I','P','E',
/* 0x1929a = "Reducing the size is not supported." */
    'R','e','d','u','c','i','n','g',' ','\x02','\xf8','\x0b','\x07','\xa5',
/* 0x192a8 = "VERR_SUPLIB_NOT_SAME_OBJECT" */
    '\x01','\xd7','\x06','S','A','M','E','_','O','B','J','E','C','T',
/* 0x192b6 = "VERR_SUPLIB_IS_DIRECTORY" */
    '\x01','\xd7','I','S','_','D','I','R','E','C','T','O','R','Y',
/* 0x192c4 = "VERR_GIM_INVALID_PROVIDER" */
    '\x01','G','I','M','_','\x05','P','R','O','V','I','D','E','R',
/* 0x192d2 = "Process Verification Failure: Bad size of image header." */
    '\x1e','\x0d','\x12','\x9f','\xf8','\x15','\x26','h','e','a','d','e','r','.',
/* 0x192e0 = "VERR_PATM_ALREADY_PATCHED" */
    '\x01','P','A','T','M','_','\x9b','P','A','T','C','H','E','D',
/* 0x192ee = "VERR_IOM_IOPORT_IPE_1" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','1',
/* 0x192fc = "Bad VTG header - to low value." */
    '\x9f','V','T','G',' ','\xb4','-',' ','\x0a','l','o','w',' ','\xe8',
/* 0x1930a = "Patch enabled." */
    'P','a','t','c','h',' ','e','n','a','b','l','e','d','.',
/* 0x19318 = "VERR_IOM_IOPORT_IPE_2" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','2',
/* 0x19326 = "Requested operation is not supported." */
    'R','e','q','u','e','s','t','e','d',' ','\x96','\x0b','\x07','\xa5',
/* 0x19334 = "VERR_HTTP_BAD_REQUEST" */
    '\x01','H','T','T','P','_','\x1d','R','E','Q','U','E','S','T',
/* 0x19342 = "VERR_IOM_IOPORT_IPE_3" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','3',
/* 0x19350 = "No more files found." */
    '\xe0','m','o','r','e',' ','f','i','l','e','s',' ','\x89',
/* 0x1935d = "Raw: Invalid image file type." */
    'R','a','w',':',' ','\x0c','\x26','\x22','t','y','p','e','.',
/* 0x1936a = "VERR_CFGM_NO_PARENT" */
    '\x01','C','F','G','M','_','\x60','P','A','R','E','N','T',
/* 0x19377 = "VERR_GMM_INSTANCE" */
    '\x01','G','M','M','_','I','N','S','T','A','N','C','E',
/* 0x19384 = "VERR_VM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xc6','_','D','R','I','V','E','R','_','\xbc','_','\x19',
/* 0x19391 = "VERR_PDM_CRITSECT_NOT_FOUND" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','_','\x06','\x40',
/* 0x1939e = "Generic driver structure version mismatch." */
    '\xa7','\xc7','\xec','\xd1','m','i','s','m','a','t','c','h','.',
/* 0x193ab = "VERR_PGM_SAVED_REC_TYPE" */
    '\x01','\x8c','S','A','V','E','D','_','R','E','C','_','\xb3',
/* 0x193b8 = "VERR_SSM_UNIT_EXISTS" */
    '\x01','\xb0','U','N','I','T','_','E','X','I','S','T','S',
/* 0X193c5 = "Send aborted." */
    'e','n','d',' ','a','b','o','r','t','e','d','.',
/* 0x193d1 = "VERR_CR_PKCS7_OSSL_D2I_FAILED" */
    '\x01','\x24','\xe5','O','S','S','L','_','D','2','I','_','\x17',
/* 0x193de = "Internal processing error #9 in the IEM code." */
    '\x08','\x04','\x09','#','9',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x193eb = "VINF_EM_WAIT_SIPI" */
    '\x0e','E','M','_','W','A','I','T','_','S','I','P','I',
/* 0x193f8 = "VERR_VFS_CHAIN_EMPTY_ARG" */
    '\x01','\x8d','_','\x8e','E','M','P','T','Y','_','A','R','G',
/* 0x19405 = "Wrong magic value." */
    'W','r','o','n','g',' ','m','a','g','i','c',' ','\xe8',
/* 0x19412 = "VINF_DBGC_BP_NO_COMMAND" */
    '\x0e','\xfd','B','P','_','\x60','C','O','M','M','A','N','D',
/* 0x1941f = "VERR_URI_NOT_FILE_SCHEME" */
    '\x01','U','R','I','_','\x06','\xaa','S','C','H','E','M','E',
/* 0x1942c = "VERR_PDM_BAD_PCI_CONFIG" */
    '\x01','\x7d','\x1d','P','C','I','_','C','O','N','F','I','G',
/* 0x19439 = "VERR_SVM_DISABLED" */
    '\x01','S','V','M','_','D','I','S','A','B','L','E','D',
/* 0x19446 = "VERR_PGM_INVALID_PAGE_DIRECTORY" */
    '\x01','\x8c','\x05','\xce','D','I','R','E','C','T','O','R','Y',
/* 0x19453 = "VERR_PGM_POOL_GET_PAGE_FAILED" */
    '\x01','\x8c','P','O','O','L','_','G','E','T','_','\xce','\x17',
/* 0x19460 = "Empty string." */
    'E','m','p','t','y',' ','s','t','r','i','n','g','.',
/* 0x1946d = "Recompiler: Too many fixups." */
    '\x13','T','o','o',' ','\xb5','f','i','x','u','p','s','.',
/* 0x1947a = "VERR_DBGC_PARSE_INVALID_OPERATION" */
    '\x01','\xfd','\xe4','\x05','O','P','E','R','A','T','I','O','N',
/* 0x19487 = "VERR_ALREADY_INITIALIZED" */
    '\x01','\x9b','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19494 = "The VFS object type is not known." */
    '\x03','\x8d',' ','\xa8','\xf3','\x0b','\x07','k','n','o','w','n','.',
/* 0x194a1 = "Recompiler: Too many labels." */
    '\x13','T','o','o',' ','\xb5','l','a','b','e','l','s','.',
/* 0x194ae = "Unknow file type." */
    'U','n','k','n','o','w',' ','\x22','t','y','p','e','.',
/* 0x194bb = "VERR_SSM_UNIT_NOT_OWNER" */
    '\x01','\xb0','U','N','I','T','_','\x06','O','W','N','E','R',
/* 0x194c8 = "VERR_SHCLPB_NO_DATA" */
    '\x01','S','H','C','L','P','B','_','\x60','D','A','T','A',
/* 0x194d5 = "VERR_CR_DIGEST_DEPRECATED" */
    '\x01','\x24','\xbf','D','E','P','R','E','C','A','T','E','D',
/* 0x194e2 = "VERR_LDRVI_READ_ERROR_HASH" */
    '\x01','\xf4','R','E','A','D','_','\x1c','_','H','A','S','H',
/* 0x194ef = "VERR_SUPDRV_VTG_STRING_TOO_LONG" */
    '\x01','\x90','V','T','G','_','\xd6','_','\x1b','L','O','N','G',
/* 0x194fc = "Internal processing error #3 in the IEM code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19509 = "Internal processing error #7 in the IEM code." */
    '\x08','\x04','\x09','#','7',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19516 = "VERR_VFS_CHAIN_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','F','I','V','E','_','A','R','G','S',
/* 0x19523 = "VERR_TAR_CHKSUM_MISMATCH" */
    '\x01','T','A','R','_','C','H','K','S','U','M','_','\x19',
/* 0x19530 = "VERR_VBGL_IOCTL_FAILED" */
    '\x01','V','B','G','L','_','I','O','C','T','L','_','\x17',
/* 0x1953d = "verification " */
    'v','e','r','i','f','i','c','a','t','i','o','n',' ',
/* 0x1954a = "VERR_PDM_NOT_PCI_DEVICE" */
    '\x01','\x7d','\x06','P','C','I','_','D','E','V','I','C','E',
/* 0x19557 = "VERR_DISK_INVALID_FORMAT" */
    '\x01','D','I','S','K','_','\x05','F','O','R','M','A','T',
/* 0x19564 = "VERR_VD_SHRINK_NOT_SUPPORTED" */
    '\x01','V','D','_','S','H','R','I','N','K','_','\x06','\x83',
/* 0x19571 = "VERR_DBGF_OWNER_BUSY" */
    '\x01','\xb9','_','O','W','N','E','R','_','B','U','S','Y',
/* 0x1957e = "VERR_NEM_VM_CREATE_FAILED" */
    '\x01','\xee','_','\xc6','_','C','R','E','A','T','E','_','\x17',
/* 0x1958b = "Internal processing error # in the PDM device code." */
    '\x08','\x04','\x09','#',' ','\x0f','\x02','P','D','M',' ','\xa3','\x84',
/* 0x19598 = "VINF_EM_DBG_EVENT" */
    '\x0e','E','M','_','D','B','G','_','E','V','E','N','T',
/* 0x195a5 = "VERR_ASN1_INVALID_UTC_TIME_ENCODING" */
    '\x01','\xa2','\x05','U','T','C','_','T','I','M','E','_','\xc8',
/* 0x195b2 = "VERR_PGM_PHYS_NOT_MMIO2" */
    '\x01','\x8c','P','H','Y','S','_','\x06','M','M','I','O','2',
/* 0x195bf = "Verification " */
    'V','e','r','i','f','i','c','a','t','i','o','n',' ',
/* 0x195cc = "VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE" */
    '\x01','M','A','N','I','F','E','S','T','_','\x1a','\xbf','\xb3',
/* 0x195d9 = "Bad image relocation." */
    '\x9f','\x26','r','e','l','o','c','a','t','i','o','n','.',
/* 0x195e6 = "VERR_IOQUEUE_BUSY" */
    '\x01','I','O','Q','U','E','U','E','_','B','U','S','Y',
/* 0x195f3 = "Not ROM page." */
    'N','o','t',' ','R','O','M',' ','p','a','g','e','.',
/* 0x19600 = "VERR_SSM_INTEGRITY_DIR_MAGIC" */
    '\x01','\xb0','\xf7','_','D','I','R','_','M','A','G','I','C',
/* 0x1960d = "Internal processing error #6 in the IEM code." */
    '\x08','\x04','\x09','#','6',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x1961a = "Invalid HM64ON32OP value." */
    '\x0c','H','M','6','4','O','N','3','2','O','P',' ','\xe8',
/* 0x19627 = "Generic device structure version mismatch." */
    '\xa7','\xa3','\xec','\xd1','m','i','s','m','a','t','c','h','.',
/* 0x19634 = "VERR_IOMMU_DTE_READ_FAILED" */
    '\x01','\xfe','_','D','T','E','_','R','E','A','D','_','\x17',
/* 0x19641 = "VERR_CR_KEY_UNSUPPORTED_CIPHER" */
    '\x01','\x24','K','E','Y','_','\x1a','C','I','P','H','E','R',
/* 0x1964e = "VERR_SVM_VMEXIT_FAILED" */
    '\x01','S','V','M','_','V','M','E','X','I','T','_','\x17',
/* 0x1965b = "VWRN_DBGC_CMD_PENDING" */
    '\xe6','\xfd','C','M','D','_','P','E','N','D','I','N','G',
/* 0x19668 = "VINF_EM_RAW_TO_R3" */
    '\x0e','E','M','_','R','A','W','_','T','O','_','R','3',
/* 0x19675 = "VERR_GMM_PAGE_NOT_SHARED" */
    '\x01','G','M','M','_','\xce','\x06','S','H','A','R','E','D',
/* 0x19682 = "VWRN_NO_DIRENT_INFO" */
    '\xe6','\x60','D','I','R','E','N','T','_','I','N','F','O',
/* 0x1968f = "VERR_VM_REQUEST_INVALID_TYPE" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','\x05','\xb3',
/* 0x1969c = "VERR_TOO_MANY_SEMAPHORES" */
    '\x01','\x1b','\xac','S','E','M','A','P','H','O','R','E','S',
/* 0x196a9 = "VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH" */
    '\x01','\x8d','_','\x8e','F','I','N','A','L','_','\xb3','_','\x19',
/* 0x196b6 = "VWRN_NO_TRANSLATION" */
    '\xe6','\x60','T','R','A','N','S','L','A','T','I','O','N',
/* 0x196c3 = "VINF_GVM_NOT_BLOCKED" */
    '\x0e','G','V','M','_','\x06','B','L','O','C','K','E','D',
/* 0x196d0 = "VINF_CR_DIGEST_DEPRECATED" */
    '\x0e','\x24','\xbf','D','E','P','R','E','C','A','T','E','D',
/* 0x196dd = "VERR_SVM_INVALID_GUEST_STATE" */
    '\x01','S','V','M','_','\x05','G','U','E','S','T','_','\xf1',
/* 0x196ea = "VERR_ADDRESS_TOO_BIG" */
    '\x01','A','D','D','R','E','S','S','_','\x1b','B','I','G',
/* 0x196f7 = "VERR_OUT_OF_RANGE" */
    '\x01','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x19704 = "VERR_NOT_A_DIRECTORY" */
    '\x01','\x06','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x19711 = "VERR_SUPLIB_PATH_TOO_SHORT" */
    '\x01','\xd7','P','A','T','H','_','\x1b','S','H','O','R','T',
/* 0x1971e = "VERR_SUP_VP_SYSFER_DLL" */
    '\x01','\x95','\xbd','S','Y','S','F','E','R','_','D','L','L',
/* 0x1972b = "VERR_VM_ATRESET_NOT_FOUND" */
    '\x01','\xc6','_','A','T','R','E','S','E','T','_','\x06','\x40',
/* 0x19738 = "Recompiler: Label internal processing error #3." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','3','.',
/* 0x19745 = "Failed to normalize ASN." */
    '\x8b','\x0a','n','o','r','m','a','l','i','z','e',' ','\xf6',
/* 0x19752 = "VERR_SUPLIB_PATH_NOT_CLEAN" */
    '\x01','\xd7','P','A','T','H','_','\x06','C','L','E','A','N',
/* 0x1975f = "Failed to map the guest PML4." */
    '\x8b','\x0a','m','a','p',' ','\x02','\xbb','P','M','L','4','.',
/* 0x1976c = "VERR_GMM_CHUNK_NOT_FOUND" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x06','\x40',
/* 0x19779 = "VINF_ALREADY_INITIALIZED" */
    '\x0e','\x9b','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19786 = "VERR_IEM_FIXUP_TOO_MANY" */
    '\x01','\x9c','F','I','X','U','P','_','\x1b','M','A','N','Y',
/* 0x19793 = "VERR_SUP_VP_TOO_MANY_SECTIONS" */
    '\x01','\x95','\xbd','\x1b','\xac','S','E','C','T','I','O','N','S',
/* 0x197a0 = "VERR_LDR_MISMATCH_NATIVE" */
    '\x01','L','D','R','_','\x19','_','N','A','T','I','V','E',
/* 0x197ad = "VERR_LDRVI_BAD_CERT_HDR_TYPE" */
    '\x01','\xf4','\x1d','C','E','R','T','_','H','D','R','_','\xb3',
/* 0x197ba = "VERR_IS_A_SYMLINK" */
    '\x01','I','S','_','A','_','S','Y','M','L','I','N','K',
/* 0x197c7 = "VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC" */
    '\x01','\x1f','\x82','\x1d','\x95','V','O','L','_','D','E','S','C',
/* 0x197d4 = "VERR_ISOMK_IPE_ROOT_SLASH" */
    '\x01','\x1f','\x14','R','O','O','T','_','S','L','A','S','H',
/* 0x197e1 = "VERR_SUP_VP_IMAGE_TOO_BIG" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\x1b','B','I','G',
/* 0x197ee = "VINF_EM_TERMINATE" */
    '\x0e','E','M','_','T','E','R','M','I','N','A','T','E',
/* 0x197fb = "VERR_GMM_IS_NOT_SANE" */
    '\x01','G','M','M','_','I','S','_','\x06','S','A','N','E',
/* 0x19808 = "VERR_XAR_BAD_DIGEST_LENGTH" */
    '\x01','X','A','R','_','\x1d','\xbf','L','E','N','G','T','H',
/* 0x19815 = "VWRN_DBGC_ALREADY_REGISTERED" */
    '\xe6','\xfd','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x19822 = "Recompiler: Label internal processing error #4." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','4','.',
/* 0x1982f = "VERR_INVALID_UUID_FORMAT" */
    '\x01','\x05','U','U','I','D','_','F','O','R','M','A','T',
/* 0x1983c = "Bad tree height." */
    '\x9f','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x19849 = "VERR_GIM_NOT_ENABLED" */
    '\x01','G','I','M','_','\x06','E','N','A','B','L','E','D',
/* 0x19856 = "VERR_HTTP_ABORTED" */
    '\x01','H','T','T','P','_','A','B','O','R','T','E','D',
/* 0x19863 = "VERR_SUPLIB_STAT_ENUM_FAILED" */
    '\x01','\xd7','S','T','A','T','_','E','N','U','M','_','\x17',
/* 0x19870 = "VERR_DBG_INVALID_ADDRESS" */
    '\x01','D','B','G','_','\x05','A','D','D','R','E','S','S',
/* 0x1987d = "VERR_GMM_OUT_OF_MEMORY" */
    '\x01','G','M','M','_','O','U','T','_','O','F','_','\xb6',
/* 0x1988a = "VERR_NEM_RING3_ONLY" */
    '\x01','\xee','_','R','I','N','G','3','_','O','N','L','Y',
/* 0x19897 = "VERR_ISOMK_IPE_FINALIZE_1" */
    '\x01','\x1f','\x14','F','I','N','A','L','I','Z','E','_','1',
/* 0x198a4 = "VINF_PGM_CACHED_PAGE" */
    '\x0e','\x8c','C','A','C','H','E','D','_','P','A','G','E',
/* 0x198b1 = "VERR_VFS_CHAIN_TAKES_FSS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','F','S','S',
/* 0x198be = "VERR_IEM_LABEL_TOO_MANY" */
    '\x01','\x9c','L','A','B','E','L','_','\x1b','M','A','N','Y',
/* 0x198cb = "VERR_SUPLIB_OWNER_NOT_ROOT" */
    '\x01','\xd7','O','W','N','E','R','_','\x06','R','O','O','T',
/* 0x198d8 = "Invalid port number." */
    '\x0c','p','o','r','t',' ','n','u','m','b','e','r','.',
/* 0x198e5 = "VERR_NO_TRANSLATION" */
    '\x01','\x60','T','R','A','N','S','L','A','T','I','O','N',
/* 0x198f2 = "VERR_TOO_MANY_REFERENCES" */
    '\x01','\x1b','\xac','R','E','F','E','R','E','N','C','E','S',
/* 0x198ff = "VERR_NOT_SAME_DEVICE" */
    '\x01','\x06','S','A','M','E','_','D','E','V','I','C','E',
/* 0x1990c = "Failed to patch the IDT." */
    '\x8b','\x0a','p','a','t','c','h',' ','\x02','I','D','T','.',
/* 0x19919 = "Internal processing error #8 in the IEM code." */
    '\x08','\x04','\x09','#','8',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19926 = "Internal processing error #4 in the IEM code." */
    '\x08','\x04','\x09','#','4',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19933 = "VERR_GCM_NOT_HANDLED" */
    '\x01','G','C','M','_','\x06','H','A','N','D','L','E','D',
/* 0x19940 = "VERR_IO_SECTOR_NOT_FOUND" */
    '\x01','I','O','_','S','E','C','T','O','R','_','\x06','\x40',
/* 0x1994d = "VERR_UNRESOLVED_ERROR" */
    '\x01','U','N','R','E','S','O','L','V','E','D','_','\x1c',
/* 0x1995a = "VERR_VFS_CHAIN_INVALID_ARGUMENT" */
    '\x01','\x8d','_','\x8e','\x05','A','R','G','U','M','E','N','T',
/* 0x19967 = "VINF_LOG_DISABLED" */
    '\x0e','L','O','G','_','D','I','S','A','B','L','E','D',
/* 0x19974 = "VERR_ISOFS_TOO_MANY_PART_MAPS" */
    '\x01','\x97','\x1b','\xac','P','A','R','T','_','M','A','P','S',
/* 0x19981 = "VINF_SEM_BAD_CONTEXT" */
    '\x0e','S','E','M','_','\x1d','C','O','N','T','E','X','T',
/* 0x1998e = "The specified path is a file and not a directory (hardening)." */
    '\x03','\x18','\xd2','\x0b','a',' ','\x22','\x9a','\x07','a',' ','\x25','\xae',
/* 0x1999b = "VERR_RT_REQUEST_STATE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\xf1',
/* 0x199a8 = "VERR_VFS_CHAIN_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','F','O','U','R','_','A','R','G','S',
/* 0x199b5 = "The name is empty." */
    '\x03','n','a','m','e',' ','\x0b','e','m','p','t','y','.',
/* 0x199c2 = "VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','\x1a','\xbc',
/* 0x199cf = "VERR_SSM_STATE_GREW_TOO_BIG" */
    '\x01','\xb0','\xf1','_','G','R','E','W','_','\x1b','B','I','G',
/* 0x199dc = "VERR_CR_X509_OSSL_D2I_FAILED" */
    '\x01','\x24','\xb7','O','S','S','L','_','D','2','I','_','\x17',
/* 0x199e9 = "Recompiler: Fixup internal processing error #1." */
    '\x13','F','i','x','u','p',' ','\x16','\x04','\x09','#','1','.',
/* 0x199f6 = "VERR_IOQUEUE_FULL" */
    '\x01','I','O','Q','U','E','U','E','_','F','U','L','L',
/* 0x19a03 = "VERR_SVM_UNEXPECTED_PATCH_TYPE" */
    '\x01','S','V','M','_','\x88','P','A','T','C','H','_','\xb3',
/* 0x19a10 = "Bad VTG header - misc." */
    '\x9f','V','T','G',' ','\xb4','-',' ','m','i','s','c','.',
/* 0x19a1d = "VERR_NOT_IMPLEMENTED" */
    '\x01','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x19a2a = "The operation was cancelled." */
    '\x03','\x96','\x11','c','a','n','c','e','l','l','e','d','.',
/* 0x19a37 = "VERR_DBGC_PARSE_COMMAND_NOT_FOUND" */
    '\x01','\xfd','\xe4','C','O','M','M','A','N','D','_','\x06','\x40',
/* 0x19a44 = "VINF_NOT_IMPLEMENTED" */
    '\x0e','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x19a51 = "Recompiler: Label internal processing error #5." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','5','.',
/* 0x19a5e = "VERR_ISOMK_IPE_DESC_COUNT" */
    '\x01','\x1f','\x14','D','E','S','C','_','C','O','U','N','T',
/* 0x19a6b = "VERR_ISOMK_IPE_EMPTY_PATH" */
    '\x01','\x1f','\x14','E','M','P','T','Y','_','P','A','T','H',
/* 0x19a78 = "VERR_VFS_CHAIN_TOO_FEW_ARGS" */
    '\x01','\x8d','_','\x8e','\x1b','F','E','W','_','A','R','G','S',
/* 0x19a85 = "The specified path is a root path (hardening)." */
    '\x03','\x18','\xd2','\x0b','a',' ','r','o','o','t',' ','\xd2','\xae',
/* 0x19a92 = "Recompiler: Label internal processing error #1." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','1','.',
/* 0x19a9f = "VERR_NET_SHUTDOWN" */
    '\x01','N','E','T','_','S','H','U','T','D','O','W','N',
/* 0x19aac = "The value is not an integer." */
    '\x03','\xf5','\x0b','\x07','\x87','i','n','t','e','g','e','r','.',
/* 0x19ab9 = "The saved state file version is not supported." */
    '\x03','s','a','v','e','d',' ','\xcc','\x22','\xd1','\x0b','\x07','\xa5',
/* 0x19ac6 = "VERR_SEM_BAD_CONTEXT" */
    '\x01','S','E','M','_','\x1d','C','O','N','T','E','X','T',
/* 0x19ad3 = "IOMMU device is not present." */
    '\xfe',' ','\xa3','\x0b','\x07','p','r','e','s','e','n','t','.',
/* 0x19ae0 = "No route to host." */
    '\xe0','r','o','u','t','e',' ','\x0a','h','o','s','t','.',
/* 0x19aed = "VERR_HTTP_HOST_NOT_FOUND" */
    '\x01','H','T','T','P','_','H','O','S','T','_','\x06','\x40',
/* 0x19afa = "VERR_TIMER_ACTIVE" */
    '\x01','T','I','M','E','R','_','A','C','T','I','V','E',
/* 0x19b07 = "VERR_NEM_NOT_AVAILABLE" */
    '\x01','\xee','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x19b14 = "Bad bundle data." */
    '\x9f','b','u','n','d','l','e',' ','d','a','t','a','.',
/* 0x19b21 = "Send timeout." */
    'S','e','n','d',' ','t','i','m','e','o','u','t','.',
/* 0x19b2e = "VERR_VFS_CHAIN_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','P','A','T','H','_','O','N','L','Y',
/* 0x19b3b = "Unable to find patch." */
    '\xe1','\x0a','f','i','n','d',' ','p','a','t','c','h','.',
/* 0x19b48 = "VERR_DBG_NO_SYMBOLS" */
    '\x01','D','B','G','_','\x60','S','Y','M','B','O','L','S',
/* 0x19b55 = "VERR_HM_WRONG_CPU" */
    '\x01','H','M','_','W','R','O','N','G','_','C','P','U',
/* 0x19b62 = "VERR_NET_NO_NETWORK" */
    '\x01','N','E','T','_','\x60','N','E','T','W','O','R','K',
/* 0x19b6f = "VERR_IEM_EMIT_BAD_MEM_SIZE" */
    '\x01','\x9c','E','M','I','T','_','\x1d','M','E','M','_','\xfa',
/* 0x19b7c = "Internal processing error #5 in the IEM code." */
    '\x08','\x04','\x09','#','5',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19b89 = "Internal processing error #1 in the IEM code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19b96 = "No active trap." */
    '\xe0','a','c','t','i','v','e',' ','t','r','a','p','.',
/* 0x19ba3 = "VERR_TOO_MANY_OPEN_FILES" */
    '\x01','\x1b','\xac','O','P','E','N','_','F','I','L','E','S',
/* 0x19bb0 = "Recompiler: Label internal processing error #6." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','6','.',
/* 0x19bbd = "VERR_IOM_INVALID_MMIO_RANGE" */
    '\x01','I','O','M','_','\x05','\xd4','_','R','A','N','G','E',
/* 0x19bca = "The specified path is a directory and not a file (hardening)." */
    '\x03','\x18','\xd2','\x0b','a',' ','\x25','\x9a','\x07','a',' ','\x22','\xae',
/* 0x19bd7 = "Recompiler: Label internal processing error #2." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','2','.',
/* 0x19be4 = "VERR_UNEVEN_INPUT" */
    '\x01','U','N','E','V','E','N','_','I','N','P','U','T',
/* 0x19bf1 = "Internal processing error #2 in the IEM code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19bfe = "Uneven input." */
    'U','n','e','v','e','n',' ','i','n','p','u','t','.',
/* 0x19c0b = "VERR_HOSTIF_IOCTL" */
    '\x01','H','O','S','T','I','F','_','I','O','C','T','L',
/* 0x19c18 = "VINF_IEM_REEXEC_JUMP" */
    '\x0e','\x9c','R','E','E','X','E','C','_','J','U','M','P',
/* 0x19c25 = "Unexpected VM exception." */
    '\x94','\xc6',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x19c32 = "VERR_PGM_MAPPING_IPE" */
    '\x01','\x8c','M','A','P','P','I','N','G','_','I','P','E',
/* 0x19c3f = "VINF_TAR_DIR_PATH" */
    '\x0e','T','A','R','_','D','I','R','_','P','A','T','H',
/* 0x19c4c = "VERR_DRIVE_LOCKED" */
    '\x01','D','R','I','V','E','_','L','O','C','K','E','D',
/* 0x19c59 = "VERR_SUP_VP_BAD_MZ_OFFSET" */
    '\x01','\x95','\xbd','\x1d','M','Z','_','O','F','F','S','E','T',
/* 0x19c66 = "Internal processing error #3 in TRPM." */
    '\x08','\x04','\x09','#','3',' ','\x0f','T','R','P','M','.',
/* 0x19c72 = "Unsupported fixup type." */
    '\x98','f','i','x','u','p',' ','t','y','p','e','.',
/* 0x19c7e = "Bad VTG magic value." */
    '\x9f','V','T','G',' ','m','a','g','i','c',' ','\xe8',
/* 0x19c8a = "VERR_DWARF_BAD_INFO" */
    '\x01','D','W','A','R','F','_','\x1d','I','N','F','O',
/* 0x19c96 = "VERR_SELM_HM_IPE" */
    '\x01','S','E','L','M','_','H','M','_','I','P','E',
/* 0x19ca2 = "VERR_CSAM_HM_IPE" */
    '\x01','C','S','A','M','_','H','M','_','I','P','E',
/* 0x19cae = "VINF_INTERRUPTED" */
    '\x0e','I','N','T','E','R','R','U','P','T','E','D',
/* 0x19cba = "VERR_VD_ISCSI_INVALID_TYPE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x05','\xb3',
/* 0x19cc6 = "Internal VMX processing error no 4." */
    '\x08','V','M','X',' ','\x04','\x09','n','o',' ','4','.',
/* 0x19cd2 = "VERR_CACHE_EMPTY" */
    '\x01','C','A','C','H','E','_','E','M','P','T','Y',
/* 0x19cde = "Internal processing error #4 in the HM code." */
    '\x08','\x04','\x09','#','4',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19cea = "VERR_TAR_SIZE_NOT_ZERO" */
    '\x01','T','A','R','_','\xfa','_','\x06','Z','E','R','O',
/* 0x19cf6 = "VERR_VD_CACHE_NOT_FOUND" */
    '\x01','V','D','_','C','A','C','H','E','_','\x06','\x40',
/* 0x19d02 = "Invalid session ID." */
    '\x0c','s','e','s','s','i','o','n',' ','I','D','.',
/* 0x19d0e = "VERR_ZIP_BAD_HEADER" */
    '\x01','Z','I','P','_','\x1d','H','E','A','D','E','R',
/* 0x19d1a = "Internal processing error #1 in SSM code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','S','S','M',' ','\x84',
/* 0x19d26 = "VERR_HTTP_INIT_FAILED" */
    '\x01','H','T','T','P','_','I','N','I','T','_','\x17',
/* 0x19d32 = "VERR_IEM_DBGINFO_IPE_1" */
    '\x01','\x9c','D','B','G','I','N','F','O','_','\x14','1',
/* 0x19d3e = "VERR_IEM_DBGINFO_IPE_2" */
    '\x01','\x9c','D','B','G','I','N','F','O','_','\x14','2',
/* 0x19d4a = "VERR_MANIFEST_FILE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','\xaa','\x19',
/* 0x19d56 = "VERR_CFG_INVALID_FORMAT" */
    '\x01','C','F','G','_','\x05','F','O','R','M','A','T',
/* 0x19d62 = "VERR_IEM_INVALID_OPERAND_SIZE" */
    '\x01','\x9c','\x05','O','P','E','R','A','N','D','_','\xfa',
/* 0x19d6e = "VERR_NEM_FLUSH_TLB" */
    '\x01','\xee','_','F','L','U','S','H','_','T','L','B',
/* 0x19d7a = "VERR_DBGC_PARSE_BAD_RESULT_TYPE" */
    '\x01','\xfd','\xe4','\x1d','R','E','S','U','L','T','_','\xb3',
/* 0x19d86 = "VERR_NET_NOT_SOCKET" */
    '\x01','N','E','T','_','\x06','S','O','C','K','E','T',
/* 0x19d92 = "VERR_INTERRUPTED" */
    '\x01','I','N','T','E','R','R','U','P','T','E','D',
/* 0x19d9e = "VERR_MANIFEST_DIGEST_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','\xbf','\x19',
/* 0x19daa = "Bad executable." */
    '\x9f','e','x','e','c','u','t','a','b','l','e','.',
/* 0x19db6 = "VERR_PDM_USBDEV_VERSION_MISMATCH" */
    '\x01','\x7d','U','S','B','D','E','V','_','\xbc','_','\x19',
/* 0x19dc2 = "VERR_CPU_OFFLINE" */
    '\x01','C','P','U','_','O','F','F','L','I','N','E',
/* 0x19dce = "instruction " */
    'i','n','s','t','r','u','c','t','i','o','n',' ',
/* 0x19dda = "Unsupported key format." */
    '\x98','k','e','y',' ','f','o','r','m','a','t','.',
/* 0x19de6 = "VERR_DIS_INVALID_OPCODE" */
    '\x01','D','I','S','_','\x05','O','P','C','O','D','E',
/* 0x19df2 = "VERR_DBGF_CANCELLED" */
    '\x01','\xb9','_','C','A','N','C','E','L','L','E','D',
/* 0x19dfe = "VERR_SUPLIB_NOT_DIR_NOT_FILE" */
    '\x01','\xd7','\x06','D','I','R','_','\x06','F','I','L','E',
/* 0x19e0a = "VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','\xb6','_','\xfa','_','\x19',
/* 0x19e16 = "VERR_GMM_NOT_PAGE_OWNER" */
    '\x01','G','M','M','_','\x06','\xce','O','W','N','E','R',
/* 0x19e22 = "VERR_DBG_LINE_NOT_FOUND" */
    '\x01','D','B','G','_','L','I','N','E','_','\x06','\x40',
/* 0x19e2e = "VERR_DWARF_UNEXPECTED_FORM" */
    '\x01','D','W','A','R','F','_','\x88','F','O','R','M',
/* 0x19e3a = "VERR_PDM_HIF_OPEN_FAILED" */
    '\x01','\x7d','H','I','F','_','O','P','E','N','_','\x17',
/* 0x19e46 = "VERR_IEM_TB_ALLOC_FAILED" */
    '\x01','\x9c','T','B','_','A','L','L','O','C','_','\x17',
/* 0x19e52 = "Internal SVM processing error no 2." */
    '\x08','S','V','M',' ','\x04','\x09','n','o',' ','2','.',
/* 0x19e5e = "Active trap." */
    'A','c','t','i','v','e',' ','t','r','a','p','.',
/* 0x19e6a = "VERR_PDM_DEVINS_VERSION_MISMATCH" */
    '\x01','\x7d','D','E','V','I','N','S','_','\xbc','_','\x19',
/* 0x19e76 = "VERR_VD_ISCSI_INVALID_STATE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x05','\xf1',
/* 0x19e82 = "Generic VM-entry failure." */
    '\xa7','\xc6','-','\xca','f','a','i','l','u','r','e','.',
/* 0x19e8e = "Unfinished code." */
    'U','n','f','i','n','i','s','h','e','d',' ','\x84',
/* 0x19e9a = "VERR_APIC_INIT_FAILED" */
    '\x01','A','P','I','C','_','I','N','I','T','_','\x17',
/* 0x19ea6 = "encountered " */
    'e','n','c','o','u','n','t','e','r','e','d',' ',
/* 0x19eb2 = "VERR_CR_PKCS7_GENERIC_ERROR" */
    '\x01','\x24','\xe5','G','E','N','E','R','I','C','_','\x1c',
/* 0x19ebe = "Internal processing error #1 in TRPM." */
    '\x08','\x04','\x09','#','1',' ','\x0f','T','R','P','M','.',
/* 0x19eca = "Bad VTG string." */
    '\x9f','V','T','G',' ','s','t','r','i','n','g','.',
/* 0x19ed6 = "Invalid tag length." */
    '\x0c','t','a','g',' ','l','e','n','g','t','h','.',
/* 0x19ee2 = "VERR_HM_CONFIG_MISMATCH" */
    '\x01','H','M','_','C','O','N','F','I','G','_','\x19',
/* 0x19eee = "VERR_SUPDRV_SERVICE_NOT_FOUND" */
    '\x01','\x90','S','E','R','V','I','C','E','_','\x06','\x40',
/* 0x19efa = "VERR_PGM_HANDY_PAGE_IPE" */
    '\x01','\x8c','H','A','N','D','Y','_','\xce','I','P','E',
/* 0x19f06 = "VERR_ISOFS_ICB_TOO_SMALL" */
    '\x01','\x97','I','C','B','_','\x1b','S','M','A','L','L',
/* 0x19f12 = "VERR_PDM_DEVHLP_VERSION_MISMATCH" */
    '\x01','\x7d','D','E','V','H','L','P','_','\xbc','_','\x19',
/* 0x19f1e = "VINF_EM_DBG_STOP" */
    '\x0e','E','M','_','D','B','G','_','S','T','O','P',
/* 0x19f2a = "VERR_VFS_CHAIN_ONLY_FSS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','F','S','S',
/* 0x19f36 = "VERR_IS_A_SOCKET" */
    '\x01','I','S','_','A','_','S','O','C','K','E','T',
/* 0x19f42 = "VINF_SUP_DRIVERLESS" */
    '\x0e','\x95','D','R','I','V','E','R','L','E','S','S',
/* 0x19f4e = "Internal SVM processing error no 1." */
    '\x08','S','V','M',' ','\x04','\x09','n','o',' ','1','.',
/* 0x19f5a = "VERR_CFGM_NOT_BYTES" */
    '\x01','C','F','G','M','_','\x06','B','Y','T','E','S',
/* 0x19f66 = "Internal SVM processing error no 5." */
    '\x08','S','V','M',' ','\x04','\x09','n','o',' ','5','.',
/* 0x19f72 = "VINF_NEM_FLUSH_TLB" */
    '\x0e','\xee','_','F','L','U','S','H','_','T','L','B',
/* 0x19f7e = "Internal processing error in the DWARF code." */
    '\x08','\x04','\x09','\x0f','\x02','D','W','A','R','F',' ','\x84',
/* 0x19f8a = "Unknown breakpoint." */
    '\xef','b','r','e','a','k','p','o','i','n','t','.',
/* 0x19f96 = "VERR_DND_GUEST_ERROR" */
    '\x01','D','N','D','_','G','U','E','S','T','_','\x1c',
/* 0x19fa2 = "VERR_MM_HYPER_NO_MEMORY" */
    '\x01','M','M','_','H','Y','P','E','R','_','\x60','\xb6',
/* 0x19fae = "Internal processing error #2 in the HM code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19fba = "Certificate " */
    'C','e','r','t','i','f','i','c','a','t','e',' ',
/* 0x19fc6 = "VERR_VUSB_NO_PORTS" */
    '\x01','V','U','S','B','_','\x60','P','O','R','T','S',
/* 0x19fd2 = "VERR_SSM_ALREADY_CANCELLED" */
    '\x01','\xb0','\x9b','C','A','N','C','E','L','L','E','D',
/* 0x19fde = "Wrong file type." */
    'W','r','o','n','g',' ','\x22','t','y','p','e','.',
/* 0x19fea = "VERR_VFS_CHAIN_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','I','O','S',
/* 0x19ff6 = "The request was canceled." */
    '\x03','\xab','\x11','c','a','n','c','e','l','e','d','.',
/* 0x1a002 = "VERR_CR_SPC_UNKNOWN_DIGEST_ALGO" */
    '\x01','\x24','S','P','C','_','\x91','\xbf','A','L','G','O',
/* 0x1a00e = "Is a socket." */
    'I','s',' ','a',' ','s','o','c','k','e','t','.',
/* 0x1a01a = "VERR_PIPE_NOT_WRITE" */
    '\x01','P','I','P','E','_','\x06','W','R','I','T','E',
/* 0x1a026 = "Internal VMX processing error no 3." */
    '\x08','V','M','X',' ','\x04','\x09','n','o',' ','3','.',
/* 0x1a032 = "VERR_PGM_HANDLER_IPE_1" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x14','1',
/* 0x1a03e = "Internal processing error #1 in the DBGF register code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','\xeb','\x84',
/* 0x1a04a = "VERR_RAW_MODE_NOT_SUPPORTED" */
    '\x01','R','A','W','_','M','O','D','E','_','\x06','\x83',
/* 0x1a056 = "VERR_NEM_MISSING_FEATURE" */
    '\x01','\xee','_','\xc5','_','F','E','A','T','U','R','E',
/* 0x1a062 = "Internal processing error in the page pool code." */
    '\x08','\x04','\x09','\x0f','\x02','\xbe','p','o','o','l',' ','\x84',
/* 0x1a06e = "VERR_DBGF_NOT_ATTACHED" */
    '\x01','\xb9','_','\x06','A','T','T','A','C','H','E','D',
/* 0x1a07a = "VERR_VUSB_NO_URB_MEMORY" */
    '\x01','V','U','S','B','_','\x60','U','R','B','_','\xb6',
/* 0x1a086 = "VERR_VD_IMAGE_NOT_FOUND" */
    '\x01','V','D','_','I','M','A','G','E','_','\x06','\x40',
/* 0x1a092 = "VERR_DBGF_ALREADY_ATTACHED" */
    '\x01','\xb9','_','\x9b','A','T','T','A','C','H','E','D',
/* 0x1a09e = "VTG string is too long." */
    'V','T','G',' ','\xf2','\x0b','\x9e','l','o','n','g','.',
/* 0x1a0aa = "VERR_SUPLIB_PATH_TOO_LONG" */
    '\x01','\xd7','P','A','T','H','_','\x1b','L','O','N','G',
/* 0x1a0b6 = "Signature verification failed." */
    'S','i','g','n','a','t','u','r','e',' ','\xf9','\x7b',
/* 0x1a0c2 = "Recompiler: " */
    'R','e','c','o','m','p','i','l','e','r',':',' ',
/* 0x1a0ce = "VERR_PGM_INVALID_PDPE_ADDR" */
    '\x01','\x8c','\x05','P','D','P','E','_','A','D','D','R',
/* 0x1a0da = "VINF_LOG_NO_LOGGER" */
    '\x0e','L','O','G','_','\x60','L','O','G','G','E','R',
/* 0x1a0e6 = "VERR_PDM_DRIVER_VERSION_MISMATCH" */
    '\x01','\x7d','D','R','I','V','E','R','_','\xbc','_','\x19',
/* 0x1a0f2 = "Internal processing error #3 in SSM code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','S','S','M',' ','\x84',
/* 0x1a0fe = "Invalid key length." */
    '\x0c','k','e','y',' ','l','e','n','g','t','h','.',
/* 0x1a10a = "VERR_PDM_DEVICE_VERSION_MISMATCH" */
    '\x01','\x7d','D','E','V','I','C','E','_','\xbc','_','\x19',
/* 0x1a116 = "VWRN_VRDP_PDU_NOT_SUPPORTED" */
    '\xe6','V','R','D','P','_','P','D','U','_','\x06','\x83',
/* 0x1a122 = "VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT" */
    '\x01','\xf4','\x60','\xb6','_','\xe4','O','U','T','P','U','T',
/* 0x1a12e = "VERR_ASN1_INVALID_BOOLEAN_ENCODING" */
    '\x01','\xa2','\x05','B','O','O','L','E','A','N','_','\xc8',
/* 0x1a13a = "NEM is not enabled." */
    '\xee',' ','\x0b','\x07','e','n','a','b','l','e','d','.',
/* 0x1a146 = "VERR_DBGF_TRACER_IPE_1" */
    '\x01','\xb9','_','T','R','A','C','E','R','_','\x14','1',
/* 0x1a152 = "VERR_SUP_DRIVERLESS" */
    '\x01','\x95','D','R','I','V','E','R','L','E','S','S',
/* 0x1a15e = "VERR_HTTP_CURL_ERROR" */
    '\x01','H','T','T','P','_','C','U','R','L','_','\x1c',
/* 0x1a16a = "VERR_TM_TOO_MANY_TIMERS" */
    '\x01','T','M','_','\x1b','\xac','T','I','M','E','R','S',
/* 0x1a176 = "VERR_LDRVI_READ_ERROR_HDR" */
    '\x01','\xf4','R','E','A','D','_','\x1c','_','H','D','R',
/* 0x1a182 = "certificate " */
    'c','e','r','t','i','f','i','c','a','t','e',' ',
/* 0x1a18e = "VERR_LDRVI_BAD_MZ_OFFSET" */
    '\x01','\xf4','\x1d','M','Z','_','O','F','F','S','E','T',
/* 0x1a19a = "VERR_SSM_NO_LOAD_EXEC" */
    '\x01','\xb0','\x60','L','O','A','D','_','E','X','E','C',
/* 0x1a1a6 = "The specified path was not clean (hardening)." */
    '\x03','\x18','\xd2','\x11','\x07','c','l','e','a','n',' ','\xae',
/* 0x1a1b2 = "Process Verification Failure: No KERNE32." */
    '\x1e','\x0d','\x12','\xe0','K','E','R','N','E','3','2','.',
/* 0x1a1be = "VERR_TRPM_HM_IPE" */
    '\x01','T','R','P','M','_','H','M','_','I','P','E',
/* 0x1a1ca = "The specified path is too short (hardening)." */
    '\x03','\x18','\xd2','\x0b','\x9e','s','h','o','r','t',' ','\xae',
/* 0x1a1d6 = "VERR_VM_REQUEST_STATE" */
    '\x01','\xc6','_','R','E','Q','U','E','S','T','_','\xf1',
/* 0x1a1e2 = "VERR_NO_MORE_FILES" */
    '\x01','\x60','M','O','R','E','_','F','I','L','E','S',
/* 0x1a1ee = "Internal VMX processing error no 2." */
    '\x08','V','M','X',' ','\x04','\x09','n','o',' ','2','.',
/* 0x1a1fa = "Invalid RT request packet." */
    '\x0c','R','T',' ','\xab','p','a','c','k','e','t','.',
/* 0x1a206 = "VERR_VFS_CHAIN_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','S','I','X','_','A','R','G','S',
/* 0x1a212 = "VERR_SUPLIB_DIR_ENUM_FAILED" */
    '\x01','\xd7','D','I','R','_','E','N','U','M','_','\x17',
/* 0x1a21e = "Bad DWARF info." */
    '\x9f','D','W','A','R','F',' ','i','n','f','o','.',
/* 0x1a22a = "End of string." */
    'E','n','d',' ','\x15','s','t','r','i','n','g','.',
/* 0x1a236 = "VERR_DBGC_PARSE_UNEXPECTED_OPERATOR" */
    '\x01','\xfd','\xe4','\x88','O','P','E','R','A','T','O','R',
/* 0x1a242 = "(hardening)." */
    '(','h','a','r','d','e','n','i','n','g',')','.',
/* 0x1a24e = "VERR_VFS_CHAIN_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','T','W','O','_','A','R','G','S',
/* 0x1a25a = "VERR_AOUT_EXE_NOT_SUPPORTED" */
    '\x01','A','O','U','T','_','E','X','E','_','\x06','\x83',
/* 0x1a266 = "VERR_INVALID_SESSION_ID" */
    '\x01','\x05','S','E','S','S','I','O','N','_','I','D',
/* 0x1a272 = "VINF_DBGF_BP_ALREADY_EXIST" */
    '\x0e','\xb9','_','B','P','_','\x9b','E','X','I','S','T',
/* 0x1a27e = "VERR_DBG_MOD_IPE" */
    '\x01','D','B','G','_','M','O','D','_','I','P','E',
/* 0x1a28a = "VERR_DISK_CHANGE" */
    '\x01','D','I','S','K','_','C','H','A','N','G','E',
/* 0x1a296 = "VERR_CR_PKCS7_DIGEST_CREATE_ERROR" */
    '\x01','\x24','\xe5','\xbf','C','R','E','A','T','E','_','\x1c',
/* 0x1a2a2 = "VERR_NET_PRINT_ERROR" */
    '\x01','N','E','T','_','P','R','I','N','T','_','\x1c',
/* 0x1a2ae = "Internal processing error #2 in TRPM." */
    '\x08','\x04','\x09','#','2',' ','\x0f','T','R','P','M','.',
/* 0x1a2ba = "VERR_PDM_NO_USB_PORTS" */
    '\x01','\x7d','\x60','U','S','B','_','P','O','R','T','S',
/* 0x1a2c6 = "Generic no change error." */
    '\xa7','n','o',' ','c','h','a','n','g','e',' ','\x85',
/* 0x1a2d2 = "VERR_PDM_DRVINS_VERSION_MISMATCH" */
    '\x01','\x7d','D','R','V','I','N','S','_','\xbc','_','\x19',
/* 0x1a2de = "VERR_ASN1_INVALID_INTEGER_ENCODING" */
    '\x01','\xa2','\x05','I','N','T','E','G','E','R','_','\xc8',
/* 0x1a2ea = "Expected primitive ASN." */
    '\xb8','p','r','i','m','i','t','i','v','e',' ','\xf6',
/* 0x1a2f6 = "Internal processing error #1 in the HM code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x1a302 = "VERR_PGM_DYNMAP_IPE" */
    '\x01','\x8c','D','Y','N','M','A','P','_','I','P','E',
/* 0x1a30e = "VERR_XAR_BAD_FILE_INODE" */
    '\x01','X','A','R','_','\x1d','\xaa','I','N','O','D','E',
/* 0x1a31a = "VERR_TAR_UNKNOWN_TYPE_FLAG" */
    '\x01','T','A','R','_','\x91','\xb3','_','F','L','A','G',
/* 0x1a326 = "Unsupported " */
    'U','n','s','u','p','p','o','r','t','e','d',' ',
/* 0x1a332 = "VERR_ASN1_TIME_TAG_MISMATCH" */
    '\x01','\xa2','T','I','M','E','_','T','A','G','_','\x19',
/* 0x1a33e = "VERR_LDRLX_BAD_PAGE_MAP" */
    '\x01','L','D','R','L','X','_','\x1d','\xce','M','A','P',
/* 0x1a34a = "Internal SVM processing error no 3." */
    '\x08','S','V','M',' ','\x04','\x09','n','o',' ','3','.',
/* 0x1a356 = "VERR_URI_INVALID_SCHEME" */
    '\x01','U','R','I','_','\x05','S','C','H','E','M','E',
/* 0x1a362 = "Operation not supported." */
    'O','p','e','r','a','t','i','o','n',' ','\x07','\xa5',
/* 0x1a36e = "Generic BER parse error." */
    '\xa7','B','E','R',' ','p','a','r','s','e',' ','\x85',
/* 0x1a37a = "VINF_GVM_YIELDED" */
    '\x0e','G','V','M','_','Y','I','E','L','D','E','D',
/* 0x1a386 = "Internal processing error #5 in the HM code." */
    '\x08','\x04','\x09','#','5',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x1a392 = "Unknown hash digest type." */
    '\xef','h','a','s','h',' ','\xd8','t','y','p','e','.',
/* 0x1a39e = "Internal processing error #3 in the HM code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x1a3aa = "VERR_PGM_HANDLER_NOT_FOUND" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x06','\x40',
/* 0x1a3b6 = "VERR_NET_HOST_NOT_FOUND" */
    '\x01','N','E','T','_','H','O','S','T','_','\x06','\x40',
/* 0x1a3c2 = "VERR_VFS_UNSUPPORTED_CREATE_TYPE" */
    '\x01','\x8d','_','\x1a','C','R','E','A','T','E','_','\xb3',
/* 0x1a3ce = "Internal processing error #1 in CFGM." */
    '\x08','\x04','\x09','#','1',' ','\x0f','C','F','G','M','.',
/* 0x1a3da = "VERR_IO_BAD_COMMAND" */
    '\x01','I','O','_','\x1d','C','O','M','M','A','N','D',
/* 0x1a3e6 = "VERR_VMX_UNEXPECTED_EXCEPTION" */
    '\x01','\xe2','\x88','E','X','C','E','P','T','I','O','N',
/* 0x1a3f2 = "VERR_NUMBER_TOO_BIG" */
    '\x01','N','U','M','B','E','R','_','\x1b','B','I','G',
/* 0x1a3fe = "Internal SVM processing error no 4." */
    '\x08','S','V','M',' ','\x04','\x09','n','o',' ','4','.',
/* 0x1a40a = "VERR_CANT_CREATE" */
    '\x01','C','A','N','T','_','C','R','E','A','T','E',
/* 0x1a416 = "VERR_NET_PATH_NOT_FOUND" */
    '\x01','N','E','T','_','P','A','T','H','_','\x06','\x40',
/* 0x1a422 = "VWRN_NUMBER_TOO_BIG" */
    '\xe6','N','U','M','B','E','R','_','\x1b','B','I','G',
/* 0x1a42e = "Internal VMX processing error no 1." */
    '\x08','V','M','X',' ','\x04','\x09','n','o',' ','1','.',
/* 0x1a43a = "The ICB for is too big." */
    '\x03','I','C','B',' ','\x10','\x0b','\x9e','b','i','g','.',
/* 0x1a446 = "Internal processing error #2 in the DBGF register code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','\xeb','\x84',
/* 0x1a452 = "Not more data in ASN." */
    'N','o','t',' ','m','o','r','e',' ','\x9d','\x0f','\xf6',
/* 0x1a45e = "VERR_DWARF_UNKNOWN_FORM" */
    '\x01','D','W','A','R','F','_','\x91','F','O','R','M',
/* 0x1a46a = "VERR_VMX_INVALID_VMXON_PTR" */
    '\x01','\xe2','\x05','V','M','X','O','N','_','P','T','R',
/* 0x1a476 = "VERR_WRONG_ORDER" */
    '\x01','W','R','O','N','G','_','O','R','D','E','R',
/* 0x1a482 = "NEM failed to set TSC." */
    '\xee',' ','\x99','\x0a','s','e','t',' ','T','S','C','.',
/* 0x1a48e = "VERR_SUPDRV_TSC_READ_FAILED" */
    '\x01','\x90','T','S','C','_','R','E','A','D','_','\x17',
/* 0x1a49a = "The I/O request ID was not found." */
    '\x03','I','/','O',' ','\xab','I','D',' ','\x11','\x07','\x89',
/* 0x1a4a6 = "VINF_HGCM_SAVE_STATE" */
    '\x0e','H','G','C','M','_','S','A','V','E','_','\xf1',
/* 0x1a4b2 = "Internal processing error #2 in SSM code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','S','S','M',' ','\x84',
/* 0x1a4be = "VERR_PATM_HM_IPE" */
    '\x01','P','A','T','M','_','H','M','_','I','P','E',
/* 0x1a4ca = "Broken pipe." */
    'B','r','o','k','e','n',' ','p','i','p','e','.',
/* 0x1a4d6 = "VERR_LDRELF_EXEC" */
    '\x01','L','D','R','E','L','F','_','E','X','E','C',
/* 0x1a4e2 = "VERR_BROKEN_PIPE" */
    '\x01','B','R','O','K','E','N','_','P','I','P','E',
/* 0x1a4ee = "Internal VMX processing error no 5." */
    '\x08','V','M','X',' ','\x04','\x09','n','o',' ','5','.',
/* 0x1a4fa = "The URI is empty." */
    '\x03','U','R','I',' ','\x0b','e','m','p','t','y','.',
/* 0x1a506 = "VERR_S3_CANCELED" */
    '\x01','S','3','_','C','A','N','C','E','L','E','D',
/* 0x1a512 = "VERR_PDM_USBINS_VERSION_MISMATCH" */
    '\x01','\x7d','U','S','B','I','N','S','_','\xbc','_','\x19',
/* 0x1a51e = "VERR_CR_X509_NOT_VERIFIED" */
    '\x01','\x24','\xb7','\x06','V','E','R','I','F','I','E','D',
/* 0x1a52a = "VERR_VD_VALUE_NOT_FOUND" */
    '\x01','V','D','_','V','A','L','U','E','_','\x06','\x40',
/* 0x1a536 = "VERR_CR_X509_GENERIC_ERROR" */
    '\x01','\x24','\xb7','G','E','N','E','R','I','C','_','\x1c',
/* 0x1a542 = "Encountered " */
    'E','n','c','o','u','n','t','e','r','e','d',' ',
/* 0x1a54e = "VERR_ZIP_UNSUPPORTED_METHOD" */
    '\x01','Z','I','P','_','\x1a','M','E','T','H','O','D',
/* 0x1a55a = "UNSUPPORTED_" */
    'U','N','S','U','P','P','O','R','T','E','D','_',
/* 0x1a566 = "VERR_BAD_EXE_FORMAT" */
    '\x01','\x1d','E','X','E','_','F','O','R','M','A','T',
/* 0x1a572 = "VERR_ISOFS_DESC_CRC_MISMATCH" */
    '\x01','\x97','D','E','S','C','_','C','R','C','_','\x19',
/* 0x1a57e = "VERR_PKZIP_NO_EOCB" */
    '\x01','P','K','Z','I','P','_','\x60','E','O','C','B',
/* 0x1a58a = "Disk is full." */
    'D','i','s','k',' ','\x0b','f','u','l','l','.',
/* 0x1a595 = "VERR_FTP_INIT_FAILED" */
    '\x01','F','T','P','_','I','N','I','T','_','\x17',
/* 0x1a5a0 = "Encoding data failed." */
    'E','n','c','o','d','i','n','g',' ','\x9d','\x7b',
/* 0x1a5ab = "VERR_CACHE_FULL" */
    '\x01','C','A','C','H','E','_','F','U','L','L',
/* 0x1a5b6 = "VERR_CFG_NO_VALUE" */
    '\x01','C','F','G','_','\x60','V','A','L','U','E',
/* 0x1a5c1 = "Invalid RT request state." */
    '\x0c','R','T',' ','\xab','s','t','a','t','e','.',
/* 0x1a5cc = "VERR_DBGC_BP_EXISTS" */
    '\x01','\xfd','B','P','_','E','X','I','S','T','S',
/* 0x1a5d7 = "VERR_SUPDRV_VTG_BAD_ATTR" */
    '\x01','\x90','V','T','G','_','\x1d','A','T','T','R',
/* 0x1a5e2 = "VERR_SUP_VP_MEMORY_READ_ERROR" */
    '\x01','\x95','\xbd','\xb6','_','R','E','A','D','_','\x1c',
/* 0x1a5ed = "VERR_SVM_IN_USE" */
    '\x01','S','V','M','_','I','N','_','U','S','E',
/* 0x1a5f8 = "VERR_DIR_NOT_EMPTY" */
    '\x01','D','I','R','_','\x06','E','M','P','T','Y',
/* 0x1a603 = "VERR_DWARF_UNEXPECTED_END" */
    '\x01','D','W','A','R','F','_','\x88','E','N','D',
/* 0x1a60e = "VERR_DBGC_PARSE_NO_SCRATCH" */
    '\x01','\xfd','\xe4','\x60','S','C','R','A','T','C','H',
/* 0x1a619 = "VERR_CR_CIPHER_NOT_SUPPORTED" */
    '\x01','\x24','C','I','P','H','E','R','_','\x06','\x83',
/* 0x1a624 = "VERR_SUP_VP_FOUND_EXEC_MEMORY" */
    '\x01','\x95','\xbd','\x40','_','E','X','E','C','_','\xb6',
/* 0x1a62f = "VERR_CV_BAD_FORMAT" */
    '\x01','C','V','_','\x1d','F','O','R','M','A','T',
/* 0x1a63a = "Wrong type." */
    'W','r','o','n','g',' ','t','y','p','e','.',
/* 0x1a645 = "VERR_COM_IPRT_ERROR" */
    '\x01','C','O','M','_','I','P','R','T','_','\x1c',
/* 0x1a650 = "VERR_PGM_PHYS_NOT_RAM" */
    '\x01','\x8c','P','H','Y','S','_','\x06','R','A','M',
/* 0x1a65b = "VERR_TAR_UNSUPPORTED_PAX_TYPE" */
    '\x01','T','A','R','_','\x1a','P','A','X','_','\xb3',
/* 0x1a666 = "VERR_CFGM_NO_NODE" */
    '\x01','C','F','G','M','_','\x60','N','O','D','E',
/* 0x1a671 = "VERR_ASN1_INVALID_UTF8_STRING_ENCODING" */
    '\x01','\xa2','\x05','U','T','F','8','_','\xd6','_','\xc8',
/* 0x1a67c = "VERR_GMM_PAGE_ALREADY_FREE" */
    '\x01','G','M','M','_','\xce','\x9b','F','R','E','E',
/* 0x1a687 = "VERR_SSM_INTEGRITY_UNIT_NOT_FOUND" */
    '\x01','\xb0','\xf7','_','U','N','I','T','_','\x06','\x40',
/* 0x1a692 = "VERR_ISO_FS_UNKNOWN_AD_TYPE" */
    '\x01','\xc2','_','F','S','_','\x91','A','D','_','\xb3',
/* 0x1a69d = "VERR_IPE_UNEXPECTED_ERROR_STATUS" */
    '\x01','\x14','\x88','\x1c','_','S','T','A','T','U','S',
/* 0x1a6a8 = "Pipe is busy." */
    'P','i','p','e',' ','\x0b','b','u','s','y','.',
/* 0x1a6b3 = "VERR_IEM_VAR_UNEXPECTED_KIND" */
    '\x01','\x9c','V','A','R','_','\x88','K','I','N','D',
/* 0x1a6be = "VERR_SUP_VP_DEBUGGED" */
    '\x01','\x95','\xbd','D','E','B','U','G','G','E','D',
/* 0x1a6c9 = "VERR_TOO_MUCH_DATA" */
    '\x01','\x1b','M','U','C','H','_','D','A','T','A',
/* 0x1a6d4 = "VERR_ISOFS_UNEXPECTED_VDS_DESC" */
    '\x01','\x97','\x88','V','D','S','_','D','E','S','C',
/* 0x1a6df = "Internal processing error #2 in the MMIO code." */
    '\x08','\x04','\x09','#','2',' ','\x0f','\x02','\xd4',' ','\x84',
/* 0x1a6ea = "CPUM internal processing error #2." */
    'C','P','U','M',' ','\x16','\x04','\x09','#','2','.',
/* 0x1a6f5 = "VINF_ENV_VAR_NOT_FOUND" */
    '\x0e','E','N','V','_','V','A','R','_','\x06','\x40',
/* 0x1a700 = "VERR_ISOMK_IPE_BUFFER_SIZE" */
    '\x01','\x1f','\x14','B','U','F','F','E','R','_','\xfa',
/* 0x1a70b = "Host is down." */
    'H','o','s','t',' ','\x0b','d','o','w','n','.',
/* 0x1a716 = "VERR_VRDP_INVALID_MODE" */
    '\x01','V','R','D','P','_','\x05','M','O','D','E',
/* 0x1a721 = "VERR_SUP_VP_BAD_IMAGE_SIZE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','\xfa',
/* 0x1a72c = "VERR_PGM_INVALID_SAVED_PAGE_STATE" */
    '\x01','\x8c','\x05','S','A','V','E','D','_','\xce','\xf1',
/* 0x1a737 = "VINF_UNSUPPORTED_ALIGNMENT" */
    '\x0e','\x1a','A','L','I','G','N','M','E','N','T',
/* 0x1a742 = "VERR_VFS_CHAIN_TAKES_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','\x8d',
/* 0x1a74d = "VERR_VBGL_INVALID_ADDR" */
    '\x01','V','B','G','L','_','\x05','A','D','D','R',
/* 0x1a758 = "VERR_TOO_MANY_SYMLINKS" */
    '\x01','\x1b','\xac','S','Y','M','L','I','N','K','S',
/* 0x1a763 = "VWRN_DBGF_ALREADY_RUNNING" */
    '\xe6','\xb9','_','\x9b','R','U','N','N','I','N','G',
/* 0x1a76e = "VERR_XAR_INVALID_FILE_NAME" */
    '\x01','X','A','R','_','\x05','\xaa','N','A','M','E',
/* 0x1a779 = "VERR_IOMMU_NOT_PRESENT" */
    '\x01','\xfe','_','\x06','P','R','E','S','E','N','T',
/* 0x1a784 = "VERR_TIMER_BUSY" */
    '\x01','T','I','M','E','R','_','B','U','S','Y',
/* 0x1a78f = "VERR_VMM_RC_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','C','_','\xbc','_','\x19',
/* 0x1a79a = "VERR_PROCESS_NOT_FOUND" */
    '\x01','P','R','O','C','E','S','S','_','\x06','\x40',
/* 0x1a7a5 = "VERR_VMX_VMPTRLD_FAILED" */
    '\x01','\xe2','V','M','P','T','R','L','D','_','\x17',
/* 0x1a7b0 = "VERR_SUPLIB_INVALID_INTERNAL_APP_DIR" */
    '\x01','\xd7','\x05','\xc3','A','P','P','_','D','I','R',
/* 0x1a7bb = "CPUM internal processing error #1." */
    'C','P','U','M',' ','\x16','\x04','\x09','#','1','.',
/* 0x1a7c6 = "Generic invalid state warning." */
    '\xa7','\x8f','\xcc','w','a','r','n','i','n','g','.',
/* 0x1a7d1 = "VERR_INVALID_CLIENT_ID" */
    '\x01','\x05','C','L','I','E','N','T','_','I','D',
/* 0x1a7dc = "VINF_ASN1_MORE_DATA" */
    '\x0e','\xa2','M','O','R','E','_','D','A','T','A',
/* 0x1a7e7 = "VERR_DWARF_TODO" */
    '\x01','D','W','A','R','F','_','T','O','D','O',
/* 0x1a7f2 = "VERR_DBGF_STACK_IPE_2" */
    '\x01','\xb9','_','S','T','A','C','K','_','\x14','2',
/* 0x1a7fd = "VERR_PDM_UNKNOWN_DRVREG_VERSION" */
    '\x01','\x7d','\x91','D','R','V','R','E','G','_','\xbc',
/* 0x1a808 = "descriptor " */
    'd','e','s','c','r','i','p','t','o','r',' ',
/* 0x1a813 = "Internal processing error in the RTMp code." */
    '\x08','\x04','\x09','\x0f','\x02','R','T','M','p',' ','\x84',
/* 0x1a81e = "validator: " */
    'v','a','l','i','d','a','t','o','r',':',' ',
/* 0x1a829 = "VERR_VFS_CHAIN_NO_PREFIX" */
    '\x01','\x8d','_','\x8e','\x60','P','R','E','F','I','X',
/* 0x1a834 = "VERR_CPUM_INVALID_XCR0" */
    '\x01','C','P','U','M','_','\x05','X','C','R','0',
/* 0x1a83f = "VERR_PGM_PHYS_NOT_ROM" */
    '\x01','\x8c','P','H','Y','S','_','\x06','R','O','M',
/* 0x1a84a = "VERR_SVM_INVALID_PVMCB" */
    '\x01','S','V','M','_','\x05','P','V','M','C','B',
/* 0x1a855 = "VERR_DONT_PANIC" */
    '\x01','D','O','N','T','_','P','A','N','I','C',
/* 0x1a860 = "Invalid CPU index." */
    '\x0c','C','P','U',' ','i','n','d','e','x','.',
/* 0x1a86b = "VERR_XAR_TOC_DIGEST_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','\xbf','\x19',
/* 0x1a876 = "Invalid client ID." */
    '\x0c','c','l','i','e','n','t',' ','I','D','.',
/* 0x1a881 = "VERR_PDM_UNKNOWN_DEVREG_VERSION" */
    '\x01','\x7d','\x91','D','E','V','R','E','G','_','\xbc',
/* 0x1a88c = "VERR_XAR_BAD_FILE_MODE" */
    '\x01','X','A','R','_','\x1d','\xaa','M','O','D','E',
/* 0x1a897 = "VERR_PDM_UNKNOWN_USBREG_VERSION" */
    '\x01','\x7d','\x91','U','S','B','R','E','G','_','\xbc',
/* 0x1a8a2 = "VERR_IMAGE_TOO_BIG" */
    '\x01','I','M','A','G','E','_','\x1b','B','I','G',
/* 0x1a8ad = "VERR_VMM_R0_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','0','_','\xbc','_','\x19',
/* 0x1a8b8 = "VERR_PGM_INVALID_CR3_ADDR" */
    '\x01','\x8c','\x05','C','R','3','_','A','D','D','R',
/* 0x1a8c3 = "Invalid VM request packet." */
    '\x0c','\xc6',' ','\xab','p','a','c','k','e','t','.',
/* 0x1a8ce = "VERR_VD_VMDK_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','M','D','K','_','\x1a','\xbc',
/* 0x1a8d9 = "VERR_COM_HOST_ERROR" */
    '\x01','C','O','M','_','H','O','S','T','_','\x1c',
/* 0x1a8e4 = "VINF_EM_SUSPEND" */
    '\x0e','E','M','_','S','U','S','P','E','N','D',
/* 0x1a8ef = "VERR_ENV_VAR_NOT_FOUND" */
    '\x01','E','N','V','_','V','A','R','_','\x06','\x40',
/* 0x1a8fa = "VERR_INVALID_PARAMETER" */
    '\x01','\x05','P','A','R','A','M','E','T','E','R',
/* 0x1a905 = "VERR_NEM_NOT_ENABLED" */
    '\x01','\xee','_','\x06','E','N','A','B','L','E','D',
/* 0x1a910 = "VERR_SSM_CANCELLED" */
    '\x01','\xb0','C','A','N','C','E','L','L','E','D',
/* 0x1a91b = "VERR_LDRMACHO_BAD_SYMTAB_SIZE" */
    '\x01','\xe9','\x1d','S','Y','M','T','A','B','_','\xfa',
/* 0x1a926 = "The specified chunk was not found." */
    '\x03','\x18','c','h','u','n','k',' ','\x11','\x07','\x89',
/* 0x1a931 = "Invalid parameter." */
    '\x0c','p','a','r','a','m','e','t','e','r','.',
/* 0x1a93c = "VERR_SUPDRV_VTG_MAGIC" */
    '\x01','\x90','V','T','G','_','M','A','G','I','C',
/* 0x1a947 = "Invalid codepoint." */
    '\x0c','c','o','d','e','p','o','i','n','t','.',
/* 0x1a952 = "VERR_DWARF_BAD_POS" */
    '\x01','D','W','A','R','F','_','\x1d','P','O','S',
/* 0x1a95d = "VERR_PIPE_NOT_READ" */
    '\x01','P','I','P','E','_','\x06','R','E','A','D',
/* 0x1a968 = "Network path not found." */
    'N','e','t','w','o','r','k',' ','\xd2','\x07','\x89',
/* 0x1a973 = "VERR_LDR_ARCH_MISMATCH" */
    '\x01','L','D','R','_','A','R','C','H','_','\x19',
/* 0x1a97e = "VERR_IO_BAD_LENGTH" */
    '\x01','I','O','_','\x1d','L','E','N','G','T','H',
/* 0x1a989 = "VINF_SEM_NESTED" */
    '\x0e','S','E','M','_','N','E','S','T','E','D',
/* 0x1a994 = "VERR_FILE_LOCK_LOST" */
    '\x01','\xaa','L','O','C','K','_','L','O','S','T',
/* 0x1a99f = "VERR_SEM_NESTED" */
    '\x01','S','E','M','_','N','E','S','T','E','D',
/* 0x1a9aa = "VERR_IOM_HM_IPE" */
    '\x01','I','O','M','_','H','M','_','I','P','E',
/* 0x1a9b5 = "VERR_NET_INIT_FAILED" */
    '\x01','N','E','T','_','I','N','I','T','_','\x17',
/* 0x1a9c0 = "processing " */
    'p','r','o','c','e','s','s','i','n','g',' ',
/* 0x1a9cb = "VERR_VMX_VMENTRY_FAILED" */
    '\x01','\xe2','V','M','E','N','T','R','Y','_','\x17',
/* 0x1a9d6 = "Invalid string tag for a X." */
    '\x0c','\xf2','t','a','g',' ','\x10','a',' ','X','.',
/* 0x1a9e1 = "Item already used." */
    'I','t','e','m',' ','\x80','u','s','e','d','.',
/* 0x1a9ec = "breakpoint " */
    'b','r','e','a','k','p','o','i','n','t',' ',
/* 0x1a9f7 = "VERR_PDM_NO_SUCH_LUN" */
    '\x01','\x7d','\x60','S','U','C','H','_','L','U','N',
/* 0x1aa02 = "VERR_PGM_PHYS_INVALID_PAGE_ID" */
    '\x01','\x8c','P','H','Y','S','_','\x05','\xce','I','D',
/* 0x1aa0d = "VERR_NOT_AVAILABLE" */
    '\x01','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1aa18 = "VERR_PDM_NO_USB_HUBS" */
    '\x01','\x7d','\x60','U','S','B','_','H','U','B','S',
/* 0x1aa23 = "VERR_LDRELF_DYN" */
    '\x01','L','D','R','E','L','F','_','D','Y','N',
/* 0x1aa2e = "VERR_DIS_INVALID_MODRM" */
    '\x01','D','I','S','_','\x05','M','O','D','R','M',
/* 0x1aa39 = "VERR_SSM_INTEGRITY_REC_HDR" */
    '\x01','\xb0','\xf7','_','R','E','C','_','H','D','R',
/* 0x1aa44 = "VERR_DBGC_COMMAND_FAILED" */
    '\x01','\xfd','C','O','M','M','A','N','D','_','\x17',
/* 0x1aa4f = "Not MMIO page." */
    'N','o','t',' ','\xd4',' ','p','a','g','e','.',
/* 0x1aa5a = "Internal error: Unexpected status code." */
    '\x08','\xd9','\x94','s','t','a','t','u','s',' ','\x84',
/* 0x1aa65 = "Internal processing error #3 in the MMIO code." */
    '\x08','\x04','\x09','#','3',' ','\x0f','\x02','\xd4',' ','\x84',
/* 0x1aa70 = "VERR_INVALID_CPU_INDEX" */
    '\x01','\x05','C','P','U','_','I','N','D','E','X',
/* 0x1aa7b = "VERR_PDM_NO_USBPROXY" */
    '\x01','\x7d','\x60','U','S','B','P','R','O','X','Y',
/* 0x1aa86 = "VERR_XAR_BAD_HDR_SIZE" */
    '\x01','X','A','R','_','\x1d','H','D','R','_','\xfa',
/* 0x1aa91 = "UNEXPECTED_" */
    'U','N','E','X','P','E','C','T','E','D','_',
/* 0x1aa9c = "VINF_SVM_VMEXIT" */
    '\x0e','S','V','M','_','V','M','E','X','I','T',
/* 0x1aaa7 = "VERR_UNEXPECTED_EXCEPTION" */
    '\x01','\x88','E','X','C','E','P','T','I','O','N',
/* 0x1aab2 = "VERR_FAM_OPEN_FAILED" */
    '\x01','F','A','M','_','O','P','E','N','_','\x17',
/* 0x1aabd = "VWRN_INVALID_PARAMETER" */
    '\xe6','\x05','P','A','R','A','M','E','T','E','R',
/* 0x1aac8 = "The specified path is too long (hardening)." */
    '\x03','\x18','\xd2','\x0b','\x9e','l','o','n','g',' ','\xae',
/* 0x1aad3 = "Signed data certificate not found." */
    'S','i','g','n','e','d',' ','\x9d','\xa0','\x07','\x89',
/* 0x1aade = "VERR_PDM_DEVICE_NOT_FOUND" */
    '\x01','\x7d','D','E','V','I','C','E','_','\x06','\x40',
/* 0x1aae9 = "Internal processing error #1 in the MMIO code." */
    '\x08','\x04','\x09','#','1',' ','\x0f','\x02','\xd4',' ','\x84',
/* 0x1aaf4 = "VERR_ELF_EXE_NOT_SUPPORTED" */
    '\x01','E','L','F','_','E','X','E','_','\x06','\x83',
/* 0x1aaff = "VERR_IOMMU_CMD_HW_ERROR" */
    '\x01','\xfe','_','C','M','D','_','H','W','_','\x1c',
/* 0x1ab0a = "VERR_TRPM_PANIC" */
    '\x01','T','R','P','M','_','P','A','N','I','C',
/* 0x1ab15 = "VERR_VD_NOT_OPENED" */
    '\x01','V','D','_','\x06','O','P','E','N','E','D',
/* 0x1ab20 = "VERR_UNSUPPORTED_ALIGNMENT" */
    '\x01','\x1a','A','L','I','G','N','M','E','N','T',
/* 0x1ab2b = "Unexpected " */
    'U','n','e','x','p','e','c','t','e','d',' ',
/* 0x1ab36 = "VERR_PDM_DRIVER_NOT_FOUND" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x06','\x40',
/* 0x1ab41 = "VERR_PDM_THREAD_IPE_2" */
    '\x01','\x7d','T','H','R','E','A','D','_','\x14','2',
/* 0x1ab4c = "Protocol not supported." */
    'P','r','o','t','o','c','o','l',' ','\x07','\xa5',
/* 0x1ab57 = "VERR_PDM_THREAD_IPE_1" */
    '\x01','\x7d','T','H','R','E','A','D','_','\x14','1',
/* 0x1ab62 = "Unsupported tag encountered in ICB." */
    '\x98','t','a','g',' ','\xaf','\x0f','I','C','B','.',
/* 0x1ab6d = "VERR_LDRVI_FILE_LENGTH_ERROR" */
    '\x01','\xf4','\xaa','L','E','N','G','T','H','_','\x1c',
/* 0x1ab78 = "VERR_URI_TOO_SHORT" */
    '\x01','U','R','I','_','\x1b','S','H','O','R','T',
/* 0x1ab83 = "VERR_DBGF_STACK_IPE_1" */
    '\x01','\xb9','_','S','T','A','C','K','_','\x14','1',
/* 0x1ab8e = "VERR_VM_RESTORED" */
    '\x01','\xc6','_','R','E','S','T','O','R','E','D',
/* 0x1ab99 = "VERR_VFS_CHAIN_ONE_ARG" */
    '\x01','\x8d','_','\x8e','O','N','E','_','A','R','G',
/* 0x1aba4 = "Too many VCPUs." */
    'T','o','o',' ','\xb5','V','C','P','U','s','.',
/* 0x1abaf = "VERR_SEM_IS_SET" */
    '\x01','S','E','M','_','I','S','_','S','E','T',
/* 0x1abba = "VERR_LDR_BAD_FIXUP" */
    '\x01','L','D','R','_','\x1d','F','I','X','U','P',
/* 0x1abc5 = "VERR_DWARF_BAD_LNE" */
    '\x01','D','W','A','R','F','_','\x1d','L','N','E',
/* 0x1abd0 = "VERR_VD_VMDK_INVALID_STATE" */
    '\x01','V','D','_','V','M','D','K','_','\x05','\xf1',
/* 0x1abdb = "VERR_ISOFS_WRONG_FILE_TYPE" */
    '\x01','\x97','W','R','O','N','G','_','\xaa','\xb3',
/* 0x1abe5 = "VERR_UNEXPECTED_FS_OBJ_TYPE" */
    '\x01','\x88','F','S','_','O','B','J','_','\xb3',
/* 0x1abef = "operation." */
    'o','p','e','r','a','t','i','o','n','.',
/* 0x1abf9 = "APIC internal error #1." */
    'A','P','I','C',' ','\x16','\x09','#','1','.',
/* 0x1ac03 = "Invalid MMIO handle." */
    '\x0c','\xd4',' ','h','a','n','d','l','e','.',
/* 0x1ac0d = "VERR_PDM_BLOCK_UNKNOWN_TYPE" */
    '\x01','\x7d','B','L','O','C','K','_','\x91','\xb3',
/* 0x1ac17 = "VERR_LDRPE_TLS" */
    '\x01','L','D','R','P','E','_','T','L','S',
/* 0x1ac21 = "VWRN_DBGF_ALREADY_HALTED" */
    '\xe6','\xb9','_','\x9b','H','A','L','T','E','D',
/* 0x1ac2b = "VERR_PDM_UNSUPPORTED_BLOCK_TYPE" */
    '\x01','\x7d','\x1a','B','L','O','C','K','_','\xb3',
/* 0x1ac35 = "Internal PKCS #7 error." */
    '\x08','P','K','C','S',' ','#','7',' ','\x85',
/* 0x1ac3f = "VERR_INVALID_FUNCTION" */
    '\x01','\x05','F','U','N','C','T','I','O','N',
/* 0x1ac49 = "VERR_IEM_FIXUP_IPE_1" */
    '\x01','\x9c','F','I','X','U','P','_','\x14','1',
/* 0x1ac53 = "VERR_NE_EXE_NOT_SUPPORTED" */
    '\x01','N','E','_','E','X','E','_','\x06','\x83',
/* 0x1ac5d = "VERR_ASN1_NOT_PRESENT" */
    '\x01','\xa2','\x06','P','R','E','S','E','N','T',
/* 0x1ac67 = "VERR_NEM_SET_TSC" */
    '\x01','\xee','_','S','E','T','_','T','S','C',
/* 0x1ac71 = "VERR_PIPE_IO_ERROR" */
    '\x01','P','I','P','E','_','I','O','_','\x1c',
/* 0x1ac7b = "VERR_LDRMACHO_UNKNOWN_SECTION" */
    '\x01','\xe9','\x91','S','E','C','T','I','O','N',
/* 0x1ac85 = "VERR_MZ_EXE_NOT_SUPPORTED" */
    '\x01','M','Z','_','E','X','E','_','\x06','\x83',
/* 0x1ac8f = "VERR_VFS_CHAIN_ONLY_VFS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','\x8d',
/* 0x1ac99 = "VERR_GVM_MISMATCH_VM_SIZE" */
    '\x01','G','V','M','_','\x19','_','\xc6','_','\xfa',
/* 0x1aca3 = "VERR_INVALID_VM_HANDLE" */
    '\x01','\x05','\xc6','_','H','A','N','D','L','E',
/* 0x1acad = "VERR_IS_A_FIFO" */
    '\x01','I','S','_','A','_','F','I','F','O',
/* 0x1acb7 = "specified " */
    's','p','e','c','i','f','i','e','d',' ',
/* 0x1acc1 = "VERR_VMX_RESERVED" */
    '\x01','\xe2','R','E','S','E','R','V','E','D',
/* 0x1accb = "VERR_SEM_LV_INTERNAL_ERROR" */
    '\x01','S','E','M','_','L','V','_','\xc3','\x1c',
/* 0x1acd5 = "VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE" */
    '\x01','\x24','P','K','I','X','_','\x91','\xbf','\xb3',
/* 0x1acdf = "Process Verification Failure: Bad image size." */
    '\x1e','\x0d','\x12','\x9f','\x26','s','i','z','e','.',
/* 0x1ace9 = "VERR_MODULE_NOT_FOUND" */
    '\x01','M','O','D','U','L','E','_','\x06','\x40',
/* 0x1acf3 = "VERR_TM_LOAD_STATE" */
    '\x01','T','M','_','L','O','A','D','_','\xf1',
/* 0x1acfd = "VERR_ASN1_INVALID_BMP_STRING_ENCODING" */
    '\x01','\xa2','\x05','B','M','P','_','\xd6','_','\xc8',
/* 0x1ad07 = "VERR_FILE_AIO_BUSY" */
    '\x01','\xaa','A','I','O','_','B','U','S','Y',
/* 0x1ad11 = "Invalid VM handle." */
    '\x0c','\xc6',' ','h','a','n','d','l','e','.',
/* 0x1ad1b = "VERR_CR_RANDOM_FAILED" */
    '\x01','\x24','R','A','N','D','O','M','_','\x17',
/* 0x1ad25 = "VERR_SYMBOL_NOT_FOUND" */
    '\x01','S','Y','M','B','O','L','_','\x06','\x40',
/* 0x1ad2f = "The breakpoint already exists." */
    '\x03','\xc0','\x80','e','x','i','s','t','s','.',
/* 0x1ad39 = "GIM internal processing error #1." */
    'G','I','M',' ','\x16','\x04','\x09','#','1','.',
/* 0x1ad43 = "VERR_VFS_CHAIN_TOO_MANY_ARGS" */
    '\x01','\x8d','_','\x8e','\x1b','\xac','A','R','G','S',
/* 0x1ad4d = "Syntax error - too few arguments." */
    '\xfb','\x09','-',' ','\x9e','f','e','w',' ','\xde',
/* 0x1ad57 = "VERR_NET_MSG_SIZE" */
    '\x01','N','E','T','_','M','S','G','_','\xfa',
/* 0x1ad61 = "VERR_ISOFS_ICB_TOO_BIG" */
    '\x01','\x97','I','C','B','_','\x1b','B','I','G',
/* 0x1ad6b = "VERR_PDM_BLOCK_NO_TYPE" */
    '\x01','\x7d','B','L','O','C','K','_','\x60','\xb3',
/* 0x1ad75 = "VINF_DBGF_BP_HALT" */
    '\x0e','\xb9','_','B','P','_','H','A','L','T',
/* 0x1ad7f = "The byte string was not found." */
    '\x03','b','y','t','e',' ','\xf2','\x11','\x07','\x89',
/* 0x1ad89 = "VERR_CR_X509_NAME_NOT_STRING" */
    '\x01','\x24','\xb7','N','A','M','E','_','\x06','\xd6',
/* 0x1ad93 = "VINF_ASN1_NOT_ENCODED" */
    '\x0e','\xa2','\x06','E','N','C','O','D','E','D',
/* 0x1ad9d = "VERR_UNSUPPORTED_CPU_MODE" */
    '\x01','\x1a','C','P','U','_','M','O','D','E',
/* 0x1ada7 = "Socket type not supported." */
    'S','o','c','k','e','t',' ','\xf3','\x07','\xa5',
/* 0x1adb1 = "The state changed." */
    '\x03','\xcc','c','h','a','n','g','e','d','.',
/* 0x1adbb = "VERR_ISOMK_IMPORT_UNKNOWN_FORMAT" */
    '\x01','\x1f','\x82','\x91','F','O','R','M','A','T',
/* 0x1adc5 = "VERR_CR_PKCS7_DIGEST_CALC_ERROR" */
    '\x01','\x24','\xe5','\xbf','C','A','L','C','_','\x1c',
/* 0x1adcf = "VERR_CANCELLED" */
    '\x01','C','A','N','C','E','L','L','E','D',
/* 0x1add9 = "VINF_TRY_AGAIN" */
    '\x0e','T','R','Y','_','A','G','A','I','N',
/* 0x1ade3 = "VERR_VFS_UNKNOWN_FORMAT" */
    '\x01','\x8d','_','\x91','F','O','R','M','A','T',
/* 0x1aded = "VERR_LE_EXE_NOT_SUPPORTED" */
    '\x01','L','E','_','E','X','E','_','\x06','\x83',
/* 0x1adf7 = "GIM internal processing error #2." */
    'G','I','M',' ','\x16','\x04','\x09','#','2','.',
/* 0x1ae01 = "VERR_DBGC_PARSE_INVALID_NUMBER" */
    '\x01','\xfd','\xe4','\x05','N','U','M','B','E','R',
/* 0x1ae0b = "Empty string in X." */
    'E','m','p','t','y',' ','\xf2','\x0f','X','.',
/* 0x1ae15 = "VERR_MORE_DATA" */
    '\x01','M','O','R','E','_','D','A','T','A',
/* 0x1ae1f = "VERR_TRY_AGAIN" */
    '\x01','T','R','Y','_','A','G','A','I','N',
/* 0x1ae29 = "Unsupported CPU mode." */
    '\x98','C','P','U',' ','m','o','d','e','.',
/* 0x1ae33 = "VERR_SSM_FIELD_INVALID_SIZE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','\xfa',
/* 0x1ae3d = "VERR_INVALID_BASE64_ENCODING" */
    '\x01','\x05','B','A','S','E','6','4','_','\xc8',
/* 0x1ae47 = "VERR_SSM_STREAM_ERROR" */
    '\x01','\xb0','S','T','R','E','A','M','_','\x1c',
/* 0x1ae51 = "VERR_SUP_VP_STUB_NOT_FOUND" */
    '\x01','\x95','\xbd','S','T','U','B','_','\x06','\x40',
/* 0x1ae5b = "arguments." */
    'a','r','g','u','m','e','n','t','s','.',
/* 0x1ae65 = "VERR_XAR_BAD_FILE_GID" */
    '\x01','X','A','R','_','\x1d','\xaa','G','I','D',
/* 0x1ae6f = "APIC internal error #2." */
    'A','P','I','C',' ','\x16','\x09','#','2','.',
/* 0x1ae79 = "VINF_PGM_SYNC_CR3" */
    '\x0e','\x8c','S','Y','N','C','_','C','R','3',
/* 0x1ae83 = "VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE" */
    '\x01','\x8c','L','O','A','D','_','\x88','\xce','\xb3',
/* 0x1ae8d = "VERR_VD_VDI_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','D','I','_','\x1a','\xbc',
/* 0x1ae97 = "VERR_SSM_MEM_TOO_BIG" */
    '\x01','\xb0','M','E','M','_','\x1b','B','I','G',
/* 0x1aea1 = "Invalid VM request state." */
    '\x0c','\xc6',' ','\xab','s','t','a','t','e','.',
/* 0x1aeab = "VERR_IEM_LABEL_IPE_6" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','6',
/* 0x1aeb5 = "VERR_IEM_LABEL_IPE_5" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','5',
/* 0x1aebf = "VERR_IEM_LABEL_IPE_4" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','4',
/* 0x1aec9 = "VERR_IEM_LABEL_IPE_3" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','3',
/* 0x1aed3 = "VERR_IEM_LABEL_IPE_2" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','2',
/* 0x1aedd = "VERR_IEM_LABEL_IPE_1" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','1',
/* 0x1aee7 = "VERR_GVM_TOO_MANY_VMS" */
    '\x01','G','V','M','_','\x1b','\xac','V','M','S',
/* 0x1aef1 = "requested " */
    'r','e','q','u','e','s','t','e','d',' ',
/* 0x1aefb = "VERR_PDM_NO_PCI_BUS" */
    '\x01','\x7d','\x60','P','C','I','_','B','U','S',
/* 0x1af05 = "VERR_ISOMK_IMPORT_UDF_UNSUPPORTED_FILE_TYPE" */
    '\x01','\x1f','\x82','U','D','F','_','\x1a','\xaa','\xb3',
/* 0x1af0f = "VWRN_STATE_CHANGED" */
    '\xe6','\xf1','_','C','H','A','N','G','E','D',
/* 0x1af19 = "VERR_PGM_POOL_IPE" */
    '\x01','\x8c','P','O','O','L','_','I','P','E',
/* 0x1af23 = "algorithm " */
    'a','l','g','o','r','i','t','h','m',' ',
/* 0x1af2d = "VERR_LX_EXE_NOT_SUPPORTED" */
    '\x01','L','X','_','E','X','E','_','\x06','\x83',
/* 0x1af37 = "Protocol error." */
    'P','r','o','t','o','c','o','l',' ','\x85',
/* 0x1af41 = "VERR_DWARF_IPE" */
    '\x01','D','W','A','R','F','_','I','P','E',
/* 0x1af4b = "The file type isn\'t supported." */
    '\x03','\x22','\xf3','i','s','n','\'','t',' ','\xa5',
/* 0x1af55 = "structure " */
    's','t','r','u','c','t','u','r','e',' ',
/* 0x1af5f = "VERR_ASN1_INVALID_IA5_STRING_ENCODING" */
    '\x01','\xa2','\x05','I','A','5','_','\xd6','_','\xc8',
/* 0x1af69 = "Invalid function." */
    '\x0c','f','u','n','c','t','i','o','n','.',
/* 0x1af73 = "VERR_SSM_INTEGRITY_VBOX_VERSION" */
    '\x01','\xb0','\xf7','_','V','B','O','X','_','\xbc',
/* 0x1af7d = "Invalid selector." */
    '\x0c','s','e','l','e','c','t','o','r','.',
/* 0x1af87 = "Not equal." */
    'N','o','t',' ','e','q','u','a','l','.',
/* 0x1af91 = "Unsupported CPU ID register value." */
    '\x98','C','P','U',' ','I','D',' ','\xeb','\xe8',
/* 0x1af9b = "VERR_DUPLICATE" */
    '\x01','D','U','P','L','I','C','A','T','E',
/* 0x1afa5 = "VERR_SVM_UNKNOWN_EXIT" */
    '\x01','S','V','M','_','\x91','E','X','I','T',
/* 0x1afaf = "directory " */
    'd','i','r','e','c','t','o','r','y',' ',
/* 0x1afb9 = "VERR_VFS_UNSUPPORTED_FORMAT" */
    '\x01','\x8d','_','\x1a','F','O','R','M','A','T',
/* 0x1afc3 = "VERR_PIPE_BUSY" */
    '\x01','P','I','P','E','_','B','U','S','Y',
/* 0x1afcd = "VERR_VMX_INVALID_GUEST_STATE" */
    '\x01','\xe2','\x05','G','U','E','S','T','_','\xf1',
/* 0x1afd7 = "VERR_PGM_DYNMAP_FAILED" */
    '\x01','\x8c','D','Y','N','M','A','P','_','\x17',
/* 0x1afe1 = "VERR_COM_XML_ERROR" */
    '\x01','C','O','M','_','X','M','L','_','\x1c',
/* 0x1afeb = "VERR_REST_INTERNAL_ERROR_9" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','9',
/* 0x1aff5 = "VERR_REST_INTERNAL_ERROR_7" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','7',
/* 0x1afff = "Invalid RT request type." */
    '\x0c','R','T',' ','\xab','t','y','p','e','.',
/* 0x1b009 = "Process Verification Failure: No NTDLL." */
    '\x1e','\x0d','\x12','\xe0','N','T','D','L','L','.',
/* 0x1b013 = "VERR_REST_INTERNAL_ERROR_6" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','6',
/* 0x1b01d = "VERR_REST_INTERNAL_ERROR_5" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','5',
/* 0x1b027 = "VERR_SUPDRV_VTG_BITS" */
    '\x01','\x90','V','T','G','_','B','I','T','S',
/* 0x1b031 = "VERR_SELM_INVALID_LDT" */
    '\x01','S','E','L','M','_','\x05','L','D','T',
/* 0x1b03b = "VERR_REST_INTERNAL_ERROR_4" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','4',
/* 0x1b045 = "VERR_IS_A_FILE" */
    '\x01','I','S','_','A','_','F','I','L','E',
/* 0x1b04f = "The device wasn\'t found." */
    '\x03','\xa3','w','a','s','n','\'','t',' ','\x89',
/* 0x1b059 = "VERR_LDRMACHO_UNSUPPORTED_MACHINE" */
    '\x01','\xe9','\x1a','M','A','C','H','I','N','E',
/* 0x1b063 = "VERR_XAR_BAD_FILE_UID" */
    '\x01','X','A','R','_','\x1d','\xaa','U','I','D',
/* 0x1b06d = "VERR_REST_INTERNAL_ERROR_2" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','2',
/* 0x1b077 = "VERR_REST_INTERNAL_ERROR_1" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','1',
/* 0x1b081 = "VERR_LDRVI_NO_MEMORY_SHDRS" */
    '\x01','\xf4','\x60','\xb6','_','S','H','D','R','S',
/* 0x1b08b = "VERR_REST_INTERNAL_ERROR_3" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','3',
/* 0x1b095 = "VERR_REST_INTERNAL_ERROR_8" */
    '\x01','R','E','S','T','_','\xc3','\x1c','_','8',
/* 0x1b09f = "VERR_INVALID_SELECTOR" */
    '\x01','\x05','S','E','L','E','C','T','O','R',
/* 0x1b0a9 = "VERR_LDRMACHO_UNSUPPORTED_SECTION" */
    '\x01','\xe9','\x1a','S','E','C','T','I','O','N',
/* 0x1b0b3 = "Expected an element." */
    '\xb8','\x87','e','l','e','m','e','n','t','.',
/* 0x1b0bd = "VERR_SSM_INTEGRITY_HEADER" */
    '\x01','\xb0','\xf7','_','H','E','A','D','E','R',
/* 0x1b0c7 = "GIM internal processing error #3." */
    'G','I','M',' ','\x16','\x04','\x09','#','3','.',
/* 0x1b0d1 = "VERR_IO_NOT_READY" */
    '\x01','I','O','_','\x06','R','E','A','D','Y',
/* 0x1b0db = "VERR_SSM_TOO_MANY_PASSES" */
    '\x01','\xb0','\x1b','\xac','P','A','S','S','E','S',
/* 0x1b0e5 = "Command not supported." */
    'C','o','m','m','a','n','d',' ','\x07','\xa5',
/* 0x1b0ef = "VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH" */
    '\x01','\x95','\xbd','\xb6','_','V','S','_','\xaa','\x19',
/* 0x1b0f9 = "VERR_URI_EMPTY" */
    '\x01','U','R','I','_','E','M','P','T','Y',
/* 0x1b103 = "VERR_MP_TOO_MANY_CPUS" */
    '\x01','M','P','_','\x1b','\xac','C','P','U','S',
/* 0x1b10d = "VERR_ASN1_INVALID_OBJID_ENCODING" */
    '\x01','\xa2','\x05','O','B','J','I','D','_','\xc8',
/* 0x1b117 = "APIC internal error #0." */
    'A','P','I','C',' ','\x16','\x09','#','0','.',
/* 0x1b121 = "VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE" */
    '\x01','\xe9','\x1a','F','I','X','U','P','_','\xb3',
/* 0x1b12b = "VERR_VMX_VMEXIT_FAILED" */
    '\x01','\xe2','V','M','E','X','I','T','_','\x17',
/* 0x1b135 = "VERR_SELM_NO_TSS" */
    '\x01','S','E','L','M','_','\x60','T','S','S',
/* 0X1b13f = "Shutdown failed." */
    'h','u','t','d','o','w','n',' ','\x7b',
/* 0x1b148 = "VERR_SVM_UNEXPECTED_EXIT" */
    '\x01','S','V','M','_','\x88','E','X','I','T',
/* 0x1b152 = "VERR_ASN1_INVALID_T61_STRING_ENCODING" */
    '\x01','\xa2','\x05','T','6','1','_','\xd6','_','\xc8',
/* 0x1b15c = "VERR_STATE_CHANGED" */
    '\x01','\xf1','_','C','H','A','N','G','E','D',
/* 0x1b166 = "VERR_SUPDRV_CSRSS_NOT_FOUND" */
    '\x01','\x90','C','S','R','S','S','_','\x06','\x40',
/* 0x1b170 = "VINF_SVM_VMRUN" */
    '\x0e','S','V','M','_','V','M','R','U','N',
/* 0x1b17a = "Generic PKCS #7 error." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x85',
/* 0x1b184 = "Invalid memory pointer." */
    '\x0c','\x86','p','o','i','n','t','e','r','.',
/* 0x1b18e = "VERR_DISK_IO_ERROR" */
    '\x01','D','I','S','K','_','I','O','_','\x1c',
/* 0x1b198 = "The VM state was invalid for the requested operation." */
    '\x03','\xc6',' ','\xcc','\x11','\x8f','\x10','\x02','\xdf','\xea',
/* 0x1b1a2 = "Generic loader failure." */
    '\xa7','\xda','f','a','i','l','u','r','e','.',
/* 0x1b1ac = "Is a FIFO." */
    'I','s',' ','a',' ','F','I','F','O','.',
/* 0x1b1b6 = "VERR_IEM_INVALID_EFF_SEG" */
    '\x01','\x9c','\x05','E','F','F','_','S','E','G',
/* 0x1b1c0 = "VERR_SSM_INTEGRITY_FOOTER" */
    '\x01','\xb0','\xf7','_','F','O','O','T','E','R',
/* 0x1b1ca = "Unexpected SVM exit." */
    '\x94','S','V','M',' ','e','x','i','t','.',
/* 0x1b1d4 = "VERR_PGM_MODE_IPE" */
    '\x01','\x8c','M','O','D','E','_','I','P','E',
/* 0x1b1de = "VERR_PE_EXE_NOT_SUPPORTED" */
    '\x01','P','E','_','E','X','E','_','\x06','\x83',
/* 0x1b1e8 = "VERR_VFS_CHAIN_CAST_FAILED" */
    '\x01','\x8d','_','\x8e','C','A','S','T','_','\x17',
/* 0x1b1f2 = "VERR_DISK_FULL" */
    '\x01','D','I','S','K','_','F','U','L','L',
/* 0x1b1fc = "VERR_PAGE_NOT_PRESENT" */
    '\x01','\xce','\x06','P','R','E','S','E','N','T',
/* 0x1b206 = "VERR_ISOMK_IPE_RR_READ" */
    '\x01','\x1f','\x14','R','R','_','R','E','A','D',
/* 0x1b210 = "VERR_VD_RAW_INVALID_TYPE" */
    '\x01','V','D','_','R','A','W','_','\x05','\xb3',
/* 0x1b21a = "VERR_VD_UUID_MISMATCH" */
    '\x01','V','D','_','U','U','I','D','_','\x19',
/* 0x1b224 = "VERR_SUP_VP_FILE_MODE_ERROR" */
    '\x01','\x95','\xbd','\xaa','M','O','D','E','_','\x1c',
/* 0x1b22e = "VERR_SSM_INTEGRITY_MAGIC" */
    '\x01','\xb0','\xf7','_','M','A','G','I','C',
/* 0X1b237 = "Codec is not supported." */
    'o','d','e','c',' ','\x0b','\x07','\xa5',
/* 0x1b23f = "VERR_CR_PKIX_INTERNAL_ERROR" */
    '\x01','\x24','P','K','I','X','_','\xc3','\x1c',
/* 0x1b248 = "Expected " */
    'E','x','p','e','c','t','e','d',' ',
/* 0x1b251 = "TM internal processing error #5." */
    'T','M',' ','\x16','\x04','\x09','#','5','.',
/* 0x1b25a = "VERR_END_OF_STRING" */
    '\x01','E','N','D','_','O','F','_','\xd6',
/* 0x1b263 = "VERR_IEM_REG_IPE_10" */
    '\x01','\x9c','R','E','G','_','\x14','1','0',
/* 0x1b26c = "VERR_SEARCH_ERROR" */
    '\x01','S','E','A','R','C','H','_','\x1c',
/* 0x1b275 = "VERR_NET_DOWN" */
    '\x01','N','E','T','_','D','O','W','N',
/* 0x1b27e = "TM internal processing error #6." */
    'T','M',' ','\x16','\x04','\x09','#','6','.',
/* 0x1b287 = "Generic file write error." */
    '\xa7','\x22','w','r','i','t','e',' ','\x85',
/* 0x1b290 = "VINF_LDRVI_NOT_SIGNED" */
    '\x0e','\xf4','\x06','S','I','G','N','E','D',
/* 0x1b299 = "VINF_PDM_ALREADY_LOADED" */
    '\x0e','\x7d','\x9b','L','O','A','D','E','D',
/* 0x1b2a2 = "Invalid context." */
    '\x0c','c','o','n','t','e','x','t','.',
/* 0x1b2ab = "TM internal processing error #3." */
    'T','M',' ','\x16','\x04','\x09','#','3','.',
/* 0x1b2b4 = "VERR_PGM_PHYS_NOT_MMIO" */
    '\x01','\x8c','P','H','Y','S','_','\x06','\xd4',
/* 0x1b2bd = "VERR_DEADLOCK" */
    '\x01','D','E','A','D','L','O','C','K',
/* 0x1b2c6 = "VERR_NO_UTF16_MEMORY" */
    '\x01','\x60','U','T','F','1','6','_','\xb6',
/* 0x1b2cf = "VERR_LDRVI_PAGE_HASH_MISMATCH" */
    '\x01','\xf4','\xce','H','A','S','H','_','\x19',
/* 0x1b2d8 = "Unsupported version." */
    '\x98','v','e','r','s','i','o','n','.',
/* 0x1b2e1 = "VERR_NEM_INIT_FAILED" */
    '\x01','\xee','_','I','N','I','T','_','\x17',
/* 0x1b2ea = "VERR_SVM_NO_SVM" */
    '\x01','S','V','M','_','\x60','S','V','M',
/* 0x1b2f3 = "Generic not found error." */
    '\xa7','\x07','f','o','u','n','d',' ','\x85',
/* 0x1b2fc = "Generic stream error." */
    '\xa7','s','t','r','e','a','m',' ','\x85',
/* 0x1b305 = "VERR_IEM_VAR_IPE_13" */
    '\x01','\x9c','V','A','R','_','\x14','1','3',
/* 0x1b30e = "VERR_IEM_VAR_IPE_12" */
    '\x01','\x9c','V','A','R','_','\x14','1','2',
/* 0x1b317 = "VERR_IEM_VAR_IPE_11" */
    '\x01','\x9c','V','A','R','_','\x14','1','1',
/* 0x1b320 = "VERR_IEM_VAR_IPE_10" */
    '\x01','\x9c','V','A','R','_','\x14','1','0',
/* 0x1b329 = "VERR_VMX_VMXON_FAILED" */
    '\x01','\xe2','V','M','X','O','N','_','\x17',
/* 0x1b332 = "VERR_ISOFS_BAD_FILE_ENTRY" */
    '\x01','\x97','\x1d','\xaa','E','N','T','R','Y',
/* 0x1b33b = "VERR_ASN1_INVALID_NULL_ENCODING" */
    '\x01','\xa2','\x05','N','U','L','L','_','\xc8',
/* 0x1b344 = "TM internal processing error #2." */
    'T','M',' ','\x16','\x04','\x09','#','2','.',
/* 0x1b34d = "VERR_TAR_UNEXPECTED_EOS" */
    '\x01','T','A','R','_','\x88','E','O','S',
/* 0x1b356 = "VERR_DBG_INVALID_RVA" */
    '\x01','D','B','G','_','\x05','R','V','A',
/* 0x1b35f = "VERR_ASN1_STRING_TAG_MISMATCH" */
    '\x01','\xa2','\xd6','_','T','A','G','_','\x19',
/* 0x1b368 = "Module not found." */
    'M','o','d','u','l','e',' ','\x07','\x89',
/* 0x1b371 = "Expected section header." */
    '\xb8','\xdd','h','e','a','d','e','r','.',
/* 0x1b37a = "VWRN_CSAM_PAGE_NOT_FOUND" */
    '\xe6','C','S','A','M','_','\xce','\x06','\x40',
/* 0x1b383 = "Invalid VM request type." */
    '\x0c','\xc6',' ','\xab','t','y','p','e','.',
/* 0x1b38c = "VERR_LDRELF_VERSION" */
    '\x01','L','D','R','E','L','F','_','\xbc',
/* 0x1b395 = "TM internal processing error #1." */
    'T','M',' ','\x16','\x04','\x09','#','1','.',
/* 0x1b39e = "The instruction is too long." */
    '\x03','\xdc','\x0b','\x9e','l','o','n','g','.',
/* 0x1b3a7 = "VERR_INVALID_CONTEXT" */
    '\x01','\x05','C','O','N','T','E','X','T',
/* 0x1b3b0 = "VERR_NET_IO_ERROR" */
    '\x01','N','E','T','_','I','O','_','\x1c',
/* 0x1b3b9 = "Invalid config value." */
    '\x0c','c','o','n','f','i','g',' ','\xe8',
/* 0x1b3c2 = "VERR_LDRVI_NOT_SIGNED" */
    '\x01','\xf4','\x06','S','I','G','N','E','D',
/* 0x1b3cb = "VERR_IOMMU_CMD_NOT_SUPPORTED" */
    '\x01','\xfe','_','C','M','D','_','\x06','\x83',
/* 0x1b3d4 = "VINF_EM_RESET" */
    '\x0e','E','M','_','R','E','S','E','T',
/* 0x1b3dd = "VERR_TM_GIP_VERSION" */
    '\x01','T','M','_','G','I','P','_','\xbc',
/* 0x1b3e6 = "TM internal processing error #9." */
    'T','M',' ','\x16','\x04','\x09','#','9','.',
/* 0x1b3ef = "TM internal processing error #7." */
    'T','M',' ','\x16','\x04','\x09','#','7','.',
/* 0x1b3f8 = "Bad file entry (ICB)." */
    '\x9f','\x22','\xca','(','I','C','B',')','.',
/* 0x1b401 = "VERR_INVALID_POINTER" */
    '\x01','\x05','P','O','I','N','T','E','R',
/* 0x1b40a = "TM internal processing error #4." */
    'T','M',' ','\x16','\x04','\x09','#','4','.',
/* 0x1b413 = "Bad section." */
    '\x9f','s','e','c','t','i','o','n','.',
/* 0x1b41c = "VERR_SUPLIB_IS_FILE" */
    '\x01','\xd7','I','S','_','F','I','L','E',
/* 0x1b425 = "VERR_LDR_INVALID_RVA" */
    '\x01','L','D','R','_','\x05','R','V','A',
/* 0x1b42e = "VERR_VFS_CHAIN_NO_ARGS" */
    '\x01','\x8d','_','\x8e','\x60','A','R','G','S',
/* 0x1b437 = "Internal " */
    'I','n','t','e','r','n','a','l',' ',
/* 0x1b440 = "VERR_DBGF_REG_IPE_2" */
    '\x01','\xb9','_','R','E','G','_','\x14','2',
/* 0x1b449 = "VERR_DBGF_REG_IPE_1" */
    '\x01','\xb9','_','R','E','G','_','\x14','1',
/* 0x1b452 = "Codec was not found." */
    'C','o','d','e','c',' ','\x11','\x07','\x89',
/* 0x1b45b = "TM internal processing error #8." */
    'T','M',' ','\x16','\x04','\x09','#','8','.',
/* 0x1b464 = "Mismatch." */
    'M','i','s','m','a','t','c','h','.',
/* 0x1b46d = "VERR_NOT_SYMLINK" */
    '\x01','\x06','S','Y','M','L','I','N','K',
/* 0x1b476 = "VERR_IO_BAD_UNIT" */
    '\x01','I','O','_','\x1d','U','N','I','T',
/* 0x1b47f = "register " */
    'r','e','g','i','s','t','e','r',' ',
/* 0x1b488 = "VERR_IOM_MMIO_IPE_3" */
    '\x01','I','O','M','_','\xd4','_','\x14','3',
/* 0x1b491 = "VERR_IOM_MMIO_IPE_2" */
    '\x01','I','O','M','_','\xd4','_','\x14','2',
/* 0x1b49a = "VERR_IOM_MMIO_IPE_1" */
    '\x01','I','O','M','_','\xd4','_','\x14','1',
/* 0x1b4a3 = "The host is not supported." */
    '\x03','h','o','s','t',' ','\x0b','\x07','\xa5',
/* 0x1b4ac = "VERR_DEV_IO_ERROR" */
    '\x01','D','E','V','_','I','O','_','\x1c',
/* 0x1b4b5 = "VERR_DBGF_MEM_NOT_FOUND" */
    '\x01','\xb9','_','M','E','M','_','\x06','\x40',
/* 0x1b4be = "INTERNAL_" */
    'I','N','T','E','R','N','A','L','_',
/* 0x1b4c7 = "VERR_VMX_INVALID_HOST_STATE" */
    '\x01','\xe2','\x05','H','O','S','T','_','\xf1',
/* 0x1b4d0 = "VERR_ASN1_NO_VTABLE" */
    '\x01','\xa2','\x60','V','T','A','B','L','E',
/* 0x1b4d9 = "INTEGRITY" */
    'I','N','T','E','G','R','I','T','Y',
/* 0x1b4e2 = "contains " */
    'c','o','n','t','a','i','n','s',' ',
/* 0x1b4eb = "VERR_SUPLIB_FSTAT_FAILED" */
    '\x01','\xd7','F','S','T','A','T','_','\x17',
/* 0x1b4f4 = "VERR_DBG_TODO" */
    '\x01','D','B','G','_','T','O','D','O',
/* 0x1b4fd = "VERR_IPE_UNEXPECTED_STATUS" */
    '\x01','\x14','\x88','S','T','A','T','U','S',
/* 0x1b506 = "VERR_VD_DEK_MISSING" */
    '\x01','V','D','_','D','E','K','_','\xc5',
/* 0x1b50f = "Client not found." */
    'C','l','i','e','n','t',' ','\x07','\x89',
/* 0x1b518 = "VERR_LDRMACHO_BIT_MIX" */
    '\x01','\xe9','B','I','T','_','M','I','X',
/* 0x1b521 = "VERR_IEM_REG_IPE_13" */
    '\x01','\x9c','R','E','G','_','\x14','1','3',
/* 0x1b52a = "VERR_IEM_REG_IPE_12" */
    '\x01','\x9c','R','E','G','_','\x14','1','2',
/* 0x1b533 = "VERR_IEM_REG_IPE_11" */
    '\x01','\x9c','R','E','G','_','\x14','1','1',
/* 0x1b53c = "VERR_SSM_UNIT_NOT_FOUND" */
    '\x01','\xb0','U','N','I','T','_','\x06','\x40',
/* 0x1b545 = "VFS object cast failed." */
    '\x8d',' ','\xa8','c','a','s','t',' ','\x7b',
/* 0x1b54e = "VERR_PATCH_NOT_FOUND" */
    '\x01','P','A','T','C','H','_','\x06','\x40',
/* 0x1b557 = "Invalid page directory specified to PGM." */
    '\x0c','\xbe','\x25','\x18','\x0a','P','G','M','.',
/* 0x1b560 = "VERR_FILE_NOT_LOCKED" */
    '\x01','\xaa','\x06','L','O','C','K','E','D',
/* 0x1b569 = "VERR_COM_INVALID_VM_STATE" */
    '\x01','C','O','M','_','\x05','\xc6','_','\xf1',
/* 0x1b572 = "VERR_LDRMACHO_BAD_SYMBOL" */
    '\x01','\xe9','\x1d','S','Y','M','B','O','L',
/* 0x1b57b = "VERR_SEM_BUSY" */
    '\x01','S','E','M','_','B','U','S','Y',
/* 0x1b584 = "LDRMACHO_" */
    'L','D','R','M','A','C','H','O','_',
/* 0x1b58d = "VERR_INVALID_UTF16_ENCODING" */
    '\x01','\x05','U','T','F','1','6','_','\xc8',
/* 0x1b596 = "VERR_LDRMACHO_BAD_HEADER" */
    '\x01','\xe9','\x1d','H','E','A','D','E','R',
/* 0x1b59f = "Failure: " */
    'F','a','i','l','u','r','e',':',' ',
/* 0x1b5a8 = "VERR_DWARF_BAD_STRING" */
    '\x01','D','W','A','R','F','_','\x1d','\xd6',
/* 0x1b5b1 = "VERR_ASN1_UNEXPECTED_OBJ_ID" */
    '\x01','\xa2','\x88','O','B','J','_','I','D',
/* 0x1b5ba = "VINF_END_OF_STRING" */
    '\x0e','E','N','D','_','O','F','_','\xd6',
/* 0x1b5c3 = "The ELF version is not supported." */
    '\x03','E','L','F',' ','\xd1','\x0b','\x07','\xa5',
/* 0x1b5cc = "The specified cpu was not found." */
    '\x03','\x18','c','p','u',' ','\x11','\x07','\x89',
/* 0x1b5d5 = "UNKNOWN_" */
    'U','N','K','N','O','W','N','_',
/* 0x1b5dd = "No soname." */
    '\xe0','s','o','n','a','m','e','.',
/* 0x1b5e5 = "VERR_WRONG_TYPE" */
    '\x01','W','R','O','N','G','_','\xb3',
/* 0x1b5ed = "support " */
    's','u','p','p','o','r','t',' ',
/* 0x1b5f5 = "doesn\'t " */
    'd','o','e','s','n','\'','t',' ',
/* 0x1b5fd = "VERR_IEM_VAR_IPE_9" */
    '\x01','\x9c','V','A','R','_','\x14','9',
/* 0x1b605 = "VERR_IEM_VAR_IPE_8" */
    '\x01','\x9c','V','A','R','_','\x14','8',
/* 0x1b60d = "section " */
    's','e','c','t','i','o','n',' ',
/* 0x1b615 = "VERR_HTTP_NOT_FOUND" */
    '\x01','H','T','T','P','_','\x06','\x40',
/* 0x1b61d = "leaving " */
    'l','e','a','v','i','n','g',' ',
/* 0x1b625 = "VINF_TIMEOUT" */
    '\x0e','T','I','M','E','O','U','T',
/* 0x1b62d = "VERR_VRDP_NO_MEMORY" */
    '\x01','V','R','D','P','_','\x60','\xb6',
/* 0x1b635 = "Unknown XAR file type value." */
    '\xef','X','A','R',' ','\x22','\xf3','\xe8',
/* 0x1b63d = "VERR_XAR_UNKNOWN_FILE_TYPE" */
    '\x01','X','A','R','_','\x91','\xaa','\xb3',
/* 0x1b645 = "Unexpected VM exit." */
    '\x94','\xc6',' ','e','x','i','t','.',
/* 0x1b64d = "Process " */
    'P','r','o','c','e','s','s',' ',
/* 0x1b655 = "catalog " */
    'c','a','t','a','l','o','g',' ',
/* 0x1b65d = "VERR_NO_EXEC_MEMORY" */
    '\x01','\x60','E','X','E','C','_','\xb6',
/* 0x1b665 = "VERR_PDM_HM_IPE" */
    '\x01','\x7d','H','M','_','I','P','E',
/* 0x1b66d = "element " */
    'e','l','e','m','e','n','t',' ',
/* 0x1b675 = "VERR_ISOFS_SPM_NOT_SUPPORTED" */
    '\x01','\x97','S','P','M','_','\x06','\x83',
/* 0x1b67d = "VERR_DBGF_BP_IPE_9" */
    '\x01','\xb9','_','B','P','_','\x14','9',
/* 0x1b685 = "VERR_DBGF_BP_IPE_8" */
    '\x01','\xb9','_','B','P','_','\x14','8',
/* 0x1b68d = "VERR_DBGF_BP_IPE_7" */
    '\x01','\xb9','_','B','P','_','\x14','7',
/* 0x1b695 = "VERR_NO_DIGITS" */
    '\x01','\x60','D','I','G','I','T','S',
/* 0x1b69d = "VINF_VMX_VMEXIT" */
    '\x0e','\xe2','V','M','E','X','I','T',
/* 0X1b6a5 = "Timeout." */
    'i','m','e','o','u','t','.',
/* 0x1b6ac = "VERR_INVALID_HANDLE" */
    '\x01','\x05','H','A','N','D','L','E',
/* 0x1b6b4 = "VERR_TIMEOUT" */
    '\x01','T','I','M','E','O','U','T',
/* 0x1b6bc = "Bad soname." */
    '\x9f','s','o','n','a','m','e','.',
/* 0x1b6c4 = "VWRN_INVALID_HANDLE" */
    '\xe6','\x05','H','A','N','D','L','E',
/* 0x1b6cc = "VERR_IEM_REG_IPE_8" */
    '\x01','\x9c','R','E','G','_','\x14','8',
/* 0x1b6d4 = "VERR_IEM_REG_IPE_7" */
    '\x01','\x9c','R','E','G','_','\x14','7',
/* 0x1b6dc = "VERR_IEM_REG_IPE_6" */
    '\x01','\x9c','R','E','G','_','\x14','6',
/* 0x1b6e4 = "VERR_CV_TODO" */
    '\x01','C','V','_','T','O','D','O',
/* 0x1b6ec = "VERR_ISOFS_MPM_NOT_SUPPORTED" */
    '\x01','\x97','M','P','M','_','\x06','\x83',
/* 0x1b6f4 = "VERR_CPUM_IPE_2" */
    '\x01','C','P','U','M','_','\x14','2',
/* 0x1b6fc = "VERR_CPUM_IPE_1" */
    '\x01','C','P','U','M','_','\x14','1',
/* 0x1b704 = "No data in pipe." */
    '\xe0','\x9d','\x0f','p','i','p','e','.',
/* 0x1b70c = "request " */
    'r','e','q','u','e','s','t',' ',
/* 0x1b714 = "IOMMU Internal processing error #6." */
    '\xfe',' ','\x08','\x04','\x09','#','6','.',
/* 0x1b71c = "NEM internal processing error #9." */
    '\xee',' ','\x16','\x04','\x09','#','9','.',
/* 0x1b724 = "VWRN_ALREADY_EXISTS" */
    '\xe6','\x9b','E','X','I','S','T','S',
/* 0x1b72c = "VERR_FILE_LOCK_FAILED" */
    '\x01','\xaa','L','O','C','K','_','\x17',
/* 0x1b734 = "VERR_LDRVI_PARSE_BER_ERROR" */
    '\x01','\xf4','\xe4','B','E','R','_','\x1c',
/* 0x1b73c = "VERR_IEM_REG_IPE_5" */
    '\x01','\x9c','R','E','G','_','\x14','5',
/* 0x1b744 = "VERR_IEM_REG_IPE_4" */
    '\x01','\x9c','R','E','G','_','\x14','4',
/* 0x1b74c = "VERR_VRDP_NOT_SUPPORTED" */
    '\x01','V','R','D','P','_','\x06','\x83',
/* 0x1b754 = "IOMMU Internal processing error #2." */
    '\xfe',' ','\x08','\x04','\x09','#','2','.',
/* 0x1b75c = "Unknown " */
    'U','n','k','n','o','w','n',' ',
/* 0x1b764 = "NEM internal processing error #5." */
    '\xee',' ','\x16','\x04','\x09','#','5','.',
/* 0x1b76c = "Retry the operation." */
    'R','e','t','r','y',' ','\x02','\xea',
/* 0x1b774 = "VERR_INVALID_UTF8_ENCODING" */
    '\x01','\x05','U','T','F','8','_','\xc8',
/* 0x1b77c = "VERR_IEM_REG_IPE_3" */
    '\x01','\x9c','R','E','G','_','\x14','3',
/* 0x1b784 = "VERR_IEM_REG_IPE_2" */
    '\x01','\x9c','R','E','G','_','\x14','2',
/* 0x1b78c = "VERR_IEM_REG_IPE_9" */
    '\x01','\x9c','R','E','G','_','\x14','9',
/* 0x1b794 = "NEM internal processing error #1." */
    '\xee',' ','\x16','\x04','\x09','#','1','.',
/* 0x1b79c = "VERR_CR_PKCS7_NOT_DATA" */
    '\x01','\x24','\xe5','\x06','D','A','T','A',
/* 0x1b7a4 = "VERR_DBGF_BP_IPE_5" */
    '\x01','\xb9','_','B','P','_','\x14','5',
/* 0x1b7ac = "VERR_TOO_MANY_OPENS" */
    '\x01','\x1b','\xac','O','P','E','N','S',
/* 0x1b7b4 = "Unsupported cipher." */
    '\x98','c','i','p','h','e','r','.',
/* 0x1b7bc = "VERR_ISOFS_UNSUPPORTED_TAG_VERSION" */
    '\x01','\x97','\x1a','T','A','G','_','\xbc',
/* 0x1b7c4 = "Internal error in the VFS chain code." */
    '\x08','\x09','\x0f','\x02','\x8d',' ','\xa1','\x84',
/* 0x1b7cc = "VWRN_NO_DIGITS" */
    '\xe6','\x60','D','I','G','I','T','S',
/* 0x1b7d4 = "VERR_DBGF_BP_IPE_4" */
    '\x01','\xb9','_','B','P','_','\x14','4',
/* 0x1b7dc = "VERR_EMPTY_STRING" */
    '\x01','E','M','P','T','Y','_','\xd6',
/* 0x1b7e4 = "VERR_DBGF_BP_IPE_3" */
    '\x01','\xb9','_','B','P','_','\x14','3',
/* 0x1b7ec = "VERR_NOT_A_FILE" */
    '\x01','\x06','A','_','F','I','L','E',
/* 0x1b7f4 = "Generic store error." */
    '\xa7','s','t','o','r','e',' ','\x85',
/* 0x1b7fc = "VERR_DBGF_BP_IPE_2" */
    '\x01','\xb9','_','B','P','_','\x14','2',
/* 0x1b804 = "VERR_ALREADY_EXISTS" */
    '\x01','\x9b','E','X','I','S','T','S',
/* 0x1b80c = "VERR_CR_KEY_UNKNOWN_TYPE" */
    '\x01','\x24','K','E','Y','_','\x91','\xb3',
/* 0x1b814 = "VERR_DBGF_BP_IPE_1" */
    '\x01','\xb9','_','B','P','_','\x14','1',
/* 0x1b81c = "VERR_ISOFS_BAD_EXTAD" */
    '\x01','\x97','\x1d','E','X','T','A','D',
/* 0x1b824 = "VERR_DBGF_BP_IPE_6" */
    '\x01','\xb9','_','B','P','_','\x14','6',
/* 0x1b82c = "IOMMU Internal processing error #7." */
    '\xfe',' ','\x08','\x04','\x09','#','7','.',
/* 0x1b834 = "VINF_ALREADY_POSTED" */
    '\x0e','\x9b','P','O','S','T','E','D',
/* 0x1b83c = "VERR_WRITE_ERROR" */
    '\x01','W','R','I','T','E','_','\x1c',
/* 0x1b844 = "VERR_NO_CONT_MEMORY" */
    '\x01','\x60','C','O','N','T','_','\xb6',
/* 0x1b84c = "Success." */
    'S','u','c','c','e','s','s','.',
/* 0x1b854 = "VERR_SUPLIB_STAT_FAILED" */
    '\x01','\xd7','S','T','A','T','_','\x17',
/* 0x1b85c = "VERR_HTTP_NOT_SUPPORTED" */
    '\x01','H','T','T','P','_','\x06','\x83',
/* 0x1b864 = "VERR_NO_CHANGE" */
    '\x01','\x60','C','H','A','N','G','E',
/* 0x1b86c = "Mode table internal error." */
    'M','o','d','e',' ','\xb1','\x16','\x85',
/* 0x1b874 = "LUN type is not supported." */
    'L','U','N',' ','\xf3','\x0b','\x07','\xa5',
/* 0x1b87c = "VERR_PDM_LUN_NOT_FOUND" */
    '\x01','\x7d','L','U','N','_','\x06','\x40',
/* 0x1b884 = "IOMMU Internal processing error #3." */
    '\xfe',' ','\x08','\x04','\x09','#','3','.',
/* 0x1b88c = "NEM internal processing error #6." */
    '\xee',' ','\x16','\x04','\x09','#','6','.',
/* 0x1b894 = "Invalid handle." */
    '\x0c','h','a','n','d','l','e','.',
/* 0x1b89c = "VERR_PDM_DEV_IPE_1" */
    '\x01','\x7d','D','E','V','_','\x14','1',
/* 0x1b8a4 = "VERR_ISOFS_TOO_MANY_LVDS" */
    '\x01','\x97','\x1b','\xac','L','V','D','S',
/* 0x1b8ac = "already " */
    'a','l','r','e','a','d','y',' ',
/* 0x1b8b4 = "VINF_SUCCESS" */
    '\x0e','S','U','C','C','E','S','S',
/* 0x1b8bc = "NEM internal processing error #2." */
    '\xee',' ','\x16','\x04','\x09','#','2','.',
/* 0x1b8c4 = "IOMMU Internal processing error #8." */
    '\xfe',' ','\x08','\x04','\x09','#','8','.',
/* 0x1b8cc = "Invalid scheme." */
    '\x0c','s','c','h','e','m','e','.',
/* 0x1b8d4 = "VINF_NO_CHANGE" */
    '\x0e','\x60','C','H','A','N','G','E',
/* 0x1b8dc = "VERR_ALREADY_LOADED" */
    '\x01','\x9b','L','O','A','D','E','D',
/* 0x1b8e4 = "ENCODING" */
    'E','N','C','O','D','I','N','G',
/* 0x1b8ec = "Generic parse error." */
    '\xa7','p','a','r','s','e',' ','\x85',
/* 0x1b8f4 = "VERR_ISOFS_VPM_NOT_SUPPORTED" */
    '\x01','\x97','V','P','M','_','\x06','\x83',
/* 0x1b8fc = "Value not found." */
    'V','a','l','u','e',' ','\x07','\x89',
/* 0x1b904 = "content " */
    'c','o','n','t','e','n','t',' ',
/* 0x1b90c = "The image is too big." */
    '\x03','\x26','\x0b','\x9e','b','i','g','.',
/* 0x1b914 = "INVALID_" */
    'I','N','V','A','L','I','D','_',
/* 0x1b91c = "ALREADY_" */
    'A','L','R','E','A','D','Y','_',
/* 0x1b924 = "VERR_SSM_BAD_REC_TYPE" */
    '\x01','\xb0','\x1d','R','E','C','_','\xb3',
/* 0x1b92c = "Invalid Mod/RM." */
    '\x0c','M','o','d','/','R','M','.',
/* 0x1b934 = "NEM internal processing error #7." */
    '\xee',' ','\x16','\x04','\x09','#','7','.',
/* 0x1b93c = "IOMMU Internal processing error #4." */
    '\xfe',' ','\x08','\x04','\x09','#','4','.',
/* 0x1b944 = "NEM internal processing error #3." */
    '\xee',' ','\x16','\x04','\x09','#','3','.',
/* 0x1b94c = "VERR_ISOFS_TOO_MANY_PVDS" */
    '\x01','\x97','\x1b','\xac','P','V','D','S',
/* 0x1b954 = "Invalid " */
    'I','n','v','a','l','i','d',' ',
/* 0x1b95c = "X509 certificate verification error." */
    'X','5','0','9',' ','\xa0','\xf9','\x85',
/* 0x1b964 = "VERR_CFGM_NOT_STRING" */
    '\x01','C','F','G','M','_','\x06','\xd6',
/* 0x1b96c = "VERR_ISOMK_IPE_TABLE" */
    '\x01','\x1f','\x14','T','A','B','L','E',
/* 0x1b974 = "Generic " */
    'G','e','n','e','r','i','c',' ',
/* 0x1b97c = "NEM init failed." */
    '\xee',' ','i','n','i','t',' ','\x7b',
/* 0x1b984 = "VERR_INVALID_CPU_ID" */
    '\x01','\x05','C','P','U','_','I','D',
/* 0x1b98c = "IOMMU Internal processing error #0." */
    '\xfe',' ','\x08','\x04','\x09','#','0','.',
/* 0x1b994 = "VERR_IGNORED" */
    '\x01','I','G','N','O','R','E','D',
/* 0x1b99c = "VERR_NO_PHYS_MEMORY" */
    '\x01','\x60','P','H','Y','S','_','\xb6',
/* 0x1b9a4 = "because " */
    'b','e','c','a','u','s','e',' ',
/* 0x1b9ac = "VERR_PDM_HIF_INVALID_VERSION" */
    '\x01','\x7d','H','I','F','_','\x05','\xbc',
/* 0x1b9b4 = "VERR_COM_VM_ERROR" */
    '\x01','C','O','M','_','\xc6','_','\x1c',
/* 0x1b9bc = "VERR_SUPDRV_VTG_BAD_STRING" */
    '\x01','\x90','V','T','G','_','\x1d','\xd6',
/* 0x1b9c4 = "VERR_PATH_NOT_FOUND" */
    '\x01','P','A','T','H','_','\x06','\x40',
/* 0x1b9cc = "Generic file read error." */
    '\xa7','\x22','r','e','a','d',' ','\x85',
/* 0x1b9d4 = "process " */
    'p','r','o','c','e','s','s',' ',
/* 0x1b9dc = "Import ISO contains a \'." */
    '\xc4','\xc2',' ','\x8a','a',' ','\'','.',
/* 0x1b9e4 = "VERR_ALREADY_POSTED" */
    '\x01','\x9b','P','O','S','T','E','D',
/* 0x1b9ec = "invalid " */
    'i','n','v','a','l','i','d',' ',
/* 0x1b9f4 = "IOMMU Internal processing error #9." */
    '\xfe',' ','\x08','\x04','\x09','#','9','.',
/* 0x1b9fc = "VERR_CFGM_IPE_1" */
    '\x01','C','F','G','M','_','\x14','1',
/* 0x1ba04 = "VERR_GVMM_IPE_2" */
    '\x01','G','V','M','M','_','\x14','2',
/* 0x1ba0c = "NEM internal processing error #0." */
    '\xee',' ','\x16','\x04','\x09','#','0','.',
/* 0x1ba14 = "VERR_GVMM_IPE_1" */
    '\x01','G','V','M','M','_','\x14','1',
/* 0x1ba1c = "VWRN_WRONG_TYPE" */
    '\xe6','W','R','O','N','G','_','\xb3',
/* 0x1ba24 = "VERR_DBGF_BP_NOT_FOUND" */
    '\x01','\xb9','_','B','P','_','\x06','\x40',
/* 0x1ba2c = "VERR_DBGF_UNSUPPORTED_CAST" */
    '\x01','\xb9','_','\x1a','C','A','S','T',
/* 0x1ba34 = "IOMMU Internal processing error #5." */
    '\xfe',' ','\x08','\x04','\x09','#','5','.',
/* 0x1ba3c = "VERR_GMM_PAGE_NOT_FOUND" */
    '\x01','G','M','M','_','\xce','\x06','\x40',
/* 0x1ba44 = "IOMMU Internal processing error #1." */
    '\xfe',' ','\x08','\x04','\x09','#','1','.',
/* 0x1ba4c = "NEM internal processing error #8." */
    '\xee',' ','\x16','\x04','\x09','#','8','.',
/* 0x1ba54 = "NEM internal processing error #4." */
    '\xee',' ','\x16','\x04','\x09','#','4','.',
/* 0x1ba5c = "VINF_EM_HALT" */
    '\x0e','E','M','_','H','A','L','T',
/* 0x1ba64 = "VERR_IEM_VAR_IPE_7" */
    '\x01','\x9c','V','A','R','_','\x14','7',
/* 0x1ba6c = "VERR_TRPM_IPE_3" */
    '\x01','T','R','P','M','_','\x14','3',
/* 0x1ba74 = "VERR_TRPM_IPE_2" */
    '\x01','T','R','P','M','_','\x14','2',
/* 0x1ba7c = "VERR_TRPM_IPE_1" */
    '\x01','T','R','P','M','_','\x14','1',
/* 0x1ba84 = "VERR_APIC_IPE_2" */
    '\x01','A','P','I','C','_','\x14','2',
/* 0x1ba8c = "VERR_APIC_IPE_1" */
    '\x01','A','P','I','C','_','\x14','1',
/* 0x1ba94 = "VERR_IEM_VAR_IPE_6" */
    '\x01','\x9c','V','A','R','_','\x14','6',
/* 0x1ba9c = "VERR_APIC_IPE_0" */
    '\x01','A','P','I','C','_','\x14','0',
/* 0x1baa4 = "VERR_IEM_VAR_IPE_5" */
    '\x01','\x9c','V','A','R','_','\x14','5',
/* 0x1baac = "VERR_IEM_VAR_IPE_4" */
    '\x01','\x9c','V','A','R','_','\x14','4',
/* 0x1bab4 = "VERR_IEM_VAR_IPE_3" */
    '\x01','\x9c','V','A','R','_','\x14','3',
/* 0x1babc = "VERR_IEM_VAR_IPE_2" */
    '\x01','\x9c','V','A','R','_','\x14','2',
/* 0x1bac4 = "VERR_TOO_MANY_POSTS" */
    '\x01','\x1b','\xac','P','O','S','T','S',
/* 0x1bacc = "VERR_IO_CRC" */
    '\x01','I','O','_','C','R','C',
/* 0x1bad3 = "Bad header size." */
    '\x9f','\xb4','s','i','z','e','.',
/* 0x1bada = "Invalid pVMCB." */
    '\x0c','p','V','M','C','B','.',
/* 0x1bae1 = "VERR_COM_FILE_ERROR" */
    '\x01','C','O','M','_','\xaa','\x1c',
/* 0x1bae8 = "VERR_XAR_UNSUPPORTED_VERSION" */
    '\x01','X','A','R','_','\x1a','\xbc',
/* 0x1baef = "digest " */
    'd','i','g','e','s','t',' ',
/* 0x1baf6 = "VERR_COM_NOT_SUPPORTED" */
    '\x01','C','O','M','_','\x06','\x83',
/* 0x1bafd = "VERR_NO_TMP_MEMORY" */
    '\x01','\x60','T','M','P','_','\xb6',
/* 0x1bb04 = "The VMMR0." */
    '\x03','V','M','M','R','0','.',
/* 0x1bb0b = "VERR_READ_ERROR" */
    '\x01','R','E','A','D','_','\x1c',
/* 0x1bb12 = "VERR_DBG_FILE_MISMATCH" */
    '\x01','D','B','G','_','\xaa','\x19',
/* 0x1bb19 = "SUPLIB_" */
    'S','U','P','L','I','B','_',
/* 0x1bb20 = "volume " */
    'v','o','l','u','m','e',' ',
/* 0x1bb27 = "VERR_SUP_VP_NO_MEMORY_STATE" */
    '\x01','\x95','\xbd','\x60','\xb6','_','\xf1',
/* 0x1bb2e = "VERR_ISOFS_TOO_MANY_PDS" */
    '\x01','\x97','\x1b','\xac','P','D','S',
/* 0X1bb35 = "SUPDRV_" */
    'U','P','D','R','V','_',
/* 0x1bb3b = "VERR_NO_LOW_MEMORY" */
    '\x01','\x60','L','O','W','_','\xb6',
/* 0x1bb42 = "VERR_LOCK_FAILED" */
    '\x01','L','O','C','K','_','\x17',
/* 0x1bb49 = "VERR_VM_INVALID_VM_STATE" */
    '\x01','\xc6','_','\x05','\xc6','_','\xf1',
/* 0x1bb50 = "VERR_OPEN_FAILED" */
    '\x01','O','P','E','N','_','\x17',
/* 0x1bb57 = "VERR_ALREADY_RESET" */
    '\x01','\x9b','R','E','S','E','T',
/* 0x1bb5e = "MISSING" */
    'M','I','S','S','I','N','G',
/* 0x1bb65 = "failed " */
    'f','a','i','l','e','d',' ',
/* 0x1bb6c = "failed." */
    'f','a','i','l','e','d','.',
/* 0x1bb73 = "VERR_ZIP_NO_MEMORY" */
    '\x01','Z','I','P','_','\x60','\xb6',
/* 0x1bb7a = "VERR_XAR_NO_ENCODING" */
    '\x01','X','A','R','_','\x60','\xc8',
/* 0x1bb81 = "loader " */
    'l','o','a','d','e','r',' ',
/* 0x1bb88 = "VERR_SSM_UNEXPECTED_PASS" */
    '\x01','\xb0','\x88','P','A','S','S',
/* 0x1bb8f = "memory " */
    'm','e','m','o','r','y',' ',
/* 0x1bb96 = "VERR_SVM_IPE_5" */
    '\x01','S','V','M','_','\x14','5',
/* 0x1bb9d = "VERR_SVM_IPE_4" */
    '\x01','S','V','M','_','\x14','4',
/* 0x1bba4 = "VERR_TOO_MANY_CPUS" */
    '\x01','\x1b','\xac','C','P','U','S',
/* 0x1bbab = "Unable " */
    'U','n','a','b','l','e',' ',
/* 0x1bbb2 = "VERR_GIM_IPE_3" */
    '\x01','G','I','M','_','\x14','3',
/* 0x1bbb9 = "VERR_GIM_IPE_2" */
    '\x01','G','I','M','_','\x14','2',
/* 0x1bbc0 = "VERR_GIM_IPE_1" */
    '\x01','G','I','M','_','\x14','1',
/* 0x1bbc7 = "Syntax error - too many arguments." */
    '\xfb','\x09','-',' ','\x9e','\xb5','\xde',
/* 0x1bbce = "The VMMRC." */
    '\x03','V','M','M','R','C','.',
/* 0x1bbd5 = "VERR_SSM_UNEXPECTED_DATA" */
    '\x01','\xb0','\x88','D','A','T','A',
/* 0x1bbdc = "Path not found." */
    'P','a','t','h',' ','\x07','\x89',
/* 0x1bbe3 = "VERR_SSM_INTEGRITY_CRC" */
    '\x01','\xb0','\xf7','_','C','R','C',
/* 0x1bbea = "VERR_SVM_IPE_3" */
    '\x01','S','V','M','_','\x14','3',
/* 0x1bbf1 = "VERR_SEM_NOT_FOUND" */
    '\x01','S','E','M','_','\x06','\x40',
/* 0x1bbf8 = "VWRN_INVALID_MAGIC" */
    '\xe6','\x05','M','A','G','I','C',
/* 0x1bbff = "No image UUID." */
    '\xe0','\x26','U','U','I','D','.',
/* 0x1bc06 = "VERR_VM_UNEXPECTED_VM_STATE" */
    '\x01','\xc6','_','\x88','\xc6','_','\xf1',
/* 0x1bc0d = "VERR_VMX_UNEXPECTED_EXIT" */
    '\x01','\xe2','\x88','E','X','I','T',
/* 0x1bc14 = "VERR_SVM_IPE_2" */
    '\x01','S','V','M','_','\x14','2',
/* 0x1bc1b = "VERR_COM_PDM_ERROR" */
    '\x01','C','O','M','_','\x7d','\x1c',
/* 0x1bc22 = "VERR_SVM_IPE_1" */
    '\x01','S','V','M','_','\x14','1',
/* 0x1bc29 = "Syntax " */
    'S','y','n','t','a','x',' ',
/* 0x1bc30 = "VERR_CPU_NOT_FOUND" */
    '\x01','C','P','U','_','\x06','\x40',
/* 0x1bc37 = "Failed " */
    'F','a','i','l','e','d',' ',
/* 0x1bc3e = "VERR_NOT_OWNER" */
    '\x01','\x06','O','W','N','E','R',
/* 0x1bc45 = "VERR_CPU_IPE_1" */
    '\x01','C','P','U','_','\x14','1',
/* 0x1bc4c = "number " */
    'n','u','m','b','e','r',' ',
/* 0x1bc53 = "IMPORT_" */
    'I','M','P','O','R','T','_',
/* 0x1bc5a = "VERR_CV_IPE" */
    '\x01','C','V','_','I','P','E',
/* 0x1bc61 = "VERR_MEMORY_BUSY" */
    '\x01','\xb6','_','B','U','S','Y',
/* 0x1bc68 = "cannot " */
    'c','a','n','n','o','t',' ',
/* 0x1bc6f = "Import " */
    'I','m','p','o','r','t',' ',
/* 0x1bc76 = "VERR_LDRVI_UNSUPPORTED_ARCH" */
    '\x01','\xf4','\x1a','A','R','C','H',
/* 0x1bc7d = "VERR_NOT_EQUAL" */
    '\x01','\x06','E','Q','U','A','L',
/* 0x1bc84 = "VINF_EM_OFF" */
    '\x0e','E','M','_','O','F','F',
/* 0x1bc8b = "error: " */
    'e','r','r','o','r',':',' ',
/* 0x1bc92 = "VERR_INVALID_FMODE" */
    '\x01','\x05','F','M','O','D','E',
/* 0x1bc99 = "Generic CURL error." */
    '\xa7','C','U','R','L',' ','\x85',
/* 0x1bca0 = "VERR_DBGC_BP_NOT_FOUND" */
    '\x01','\xfd','B','P','_','\x06','\x40',
/* 0x1bca7 = "VERR_VFS_CHAIN_IPE" */
    '\x01','\x8d','_','\x8e','I','P','E',
/* 0x1bcae = "Reason " */
    'R','e','a','s','o','n',' ',
/* 0x1bcb5 = "VERR_NOT_SUP_BY_NEM" */
    '\x01','\x06','\x95','B','Y','_','\xee',
/* 0x1bcbc = "File not found." */
    'F','i','l','e',' ','\x07','\x89',
/* 0x1bcc3 = "VERR_INVALID_FLAGS" */
    '\x01','\x05','F','L','A','G','S',
/* 0x1bcca = "VERR_INVALID_DRIVE" */
    '\x01','\x05','D','R','I','V','E',
/* 0x1bcd1 = "DIGEST_" */
    'D','I','G','E','S','T','_',
/* 0x1bcd8 = "VERR_NO_STR_MEMORY" */
    '\x01','\x60','S','T','R','_','\xb6',
/* 0x1bcdf = "Invalid image type." */
    '\x0c','\x26','t','y','p','e','.',
/* 0x1bce6 = "VERR_ZIP_UNSUPPORTED_VERSION" */
    '\x01','Z','I','P','_','\x1a','\xbc',
/* 0x1bced = "object " */
    'o','b','j','e','c','t',' ',
/* 0x1bcf4 = "driver " */
    'd','r','i','v','e','r',' ',
/* 0x1bcfb = "VERR_INVALID_MAGIC" */
    '\x01','\x05','M','A','G','I','C',
/* 0x1bd02 = "VERR_ASN1_TOO_LONG" */
    '\x01','\xa2','\x1b','L','O','N','G',
/* 0x1bd09 = "VERR_TM_IPE_3" */
    '\x01','T','M','_','\x14','3',
/* 0x1bd0f = "VERR_TM_IPE_2" */
    '\x01','T','M','_','\x14','2',
/* 0x1bd15 = "VERR_TM_IPE_1" */
    '\x01','T','M','_','\x14','1',
/* 0x1bd1b = "entry " */
    'e','n','t','r','y',' ',
/* 0x1bd21 = "VERR_TM_IPE_4" */
    '\x01','T','M','_','\x14','4',
/* 0x1bd27 = "Internal error in the X." */
    '\x08','\x09','\x0f','\x02','X','.',
/* 0x1bd2d = "VERR_FILE_TOO_BIG" */
    '\x01','\xaa','\x1b','B','I','G',
/* 0x1bd33 = "VERR_LDRMACHO_TODO" */
    '\x01','\xe9','T','O','D','O',
/* 0x1bd39 = "VINF_EM_NO_MEMORY" */
    '\x0e','E','M','_','\x60','\xb6',
/* 0x1bd3f = "VERR_LDRVI_NO_MEMORY_STATE" */
    '\x01','\xf4','\x60','\xb6','_','\xf1',
/* 0x1bd45 = "FAILED" */
    'F','A','I','L','E','D',
/* 0x1bd4b = "VERR_ZIP_ERROR" */
    '\x01','Z','I','P','_','\x1c',
/* 0x1bd51 = "VERR_TM_IPE_9" */
    '\x01','T','M','_','\x14','9',
/* 0x1bd57 = "The specified register was not found." */
    '\x03','\x18','\xeb','\x11','\x07','\x89',
/* 0x1bd5d = "VERR_NO_DATA" */
    '\x01','\x60','D','A','T','A',
/* 0x1bd63 = "value." */
    'v','a','l','u','e','.',
/* 0x1bd69 = "VERR_IDT_FAILED" */
    '\x01','I','D','T','_','\x17',
/* 0x1bd6f = "Seek error." */
    'S','e','e','k',' ','\x85',
/* 0x1bd75 = "VERR_BAD_PIPE" */
    '\x01','\x1d','P','I','P','E',
/* 0x1bd7b = "VERR_TM_UNKNOWN_STATE" */
    '\x01','T','M','_','\x91','\xf1',
/* 0x1bd81 = "VERR_VD_INVALID_SIZE" */
    '\x01','V','D','_','\x05','\xfa',
/* 0x1bd87 = "VERR_VD_INVALID_STATE" */
    '\x01','V','D','_','\x05','\xf1',
/* 0x1bd8d = "image " */
    'i','m','a','g','e',' ',
/* 0x1bd93 = "Error " */
    'E','r','r','o','r',' ',
/* 0x1bd99 = "Generic zip error." */
    '\xa7','z','i','p',' ','\x85',
/* 0x1bd9f = "VERR_ASN1_INTERNAL_ERROR_5" */
    '\x01','\xa2','\xc3','\x1c','_','5',
/* 0x1bda5 = "VERR_ASN1_INTERNAL_ERROR_4" */
    '\x01','\xa2','\xc3','\x1c','_','4',
/* 0x1bdab = "VERR_ASN1_INTERNAL_ERROR_3" */
    '\x01','\xa2','\xc3','\x1c','_','3',
/* 0x1bdb1 = "VERR_ASN1_INTERNAL_ERROR_1" */
    '\x01','\xa2','\xc3','\x1c','_','1',
/* 0x1bdb7 = "VERR_ASN1_INTERNAL_ERROR_2" */
    '\x01','\xa2','\xc3','\x1c','_','2',
/* 0x1bdbd = "VERR_VD_INVALID_TYPE" */
    '\x01','V','D','_','\x05','\xb3',
/* 0x1bdc3 = "The specified process was not found." */
    '\x03','\x18','\x92','\x11','\x07','\x89',
/* 0x1bdc9 = "VERR_S3_NOT_FOUND" */
    '\x01','S','3','_','\x06','\x40',
/* 0x1bdcf = "which " */
    'w','h','i','c','h',' ',
/* 0x1bdd5 = "VERR_SEM_ERROR" */
    '\x01','S','E','M','_','\x1c',
/* 0x1bddb = "LDRVI_" */
    'L','D','R','V','I','_',
/* 0x1bde1 = "VERR_INVALID_NAME" */
    '\x01','\x05','N','A','M','E',
/* 0x1bde7 = "found." */
    'f','o','u','n','d','.',
/* 0x1bded = "VERR_MAP_FAILED" */
    '\x01','M','A','P','_','\x17',
/* 0x1bdf3 = "VERR_HM_IPE_5" */
    '\x01','H','M','_','\x14','5',
/* 0x1bdf9 = "VERR_VFS_CHAIN_UNKNOWN_TYPE" */
    '\x01','\x8d','_','\x8e','\x91','\xb3',
/* 0x1bdff = "VERR_ISOFS_NO_LVD" */
    '\x01','\x97','\x60','L','V','D',
/* 0x1be05 = "Bad pipe." */
    '\x9f','p','i','p','e','.',
/* 0x1be0b = "chain " */
    'c','h','a','i','n',' ',
/* 0x1be11 = "VERR_HM_IPE_3" */
    '\x01','H','M','_','\x14','3',
/* 0x1be17 = "VERR_HM_IPE_2" */
    '\x01','H','M','_','\x14','2',
/* 0x1be1d = "VERR_HM_IPE_1" */
    '\x01','H','M','_','\x14','1',
/* 0x1be23 = "VERR_HM_IPE_4" */
    '\x01','H','M','_','\x14','4',
/* 0x1be29 = "ISOFS_" */
    'I','S','O','F','S','_',
/* 0x1be2f = "PKCS7_" */
    'P','K','C','S','7','_',
/* 0x1be35 = "VERR_TM_INVALID_STATE" */
    '\x01','T','M','_','\x05','\xf1',
/* 0x1be3b = "error." */
    'e','r','r','o','r','.',
/* 0x1be41 = "error " */
    'e','r','r','o','r',' ',
/* 0x1be47 = "value " */
    'v','a','l','u','e',' ',
/* 0x1be4d = "VERR_LDRVI_PARSE_IPE" */
    '\x01','\xf4','\xe4','I','P','E',
/* 0x1be53 = "VERR_ISOFS_NO_PVD" */
    '\x01','\x97','\x60','P','V','D',
/* 0x1be59 = "VERR_EM_INTERNAL_ERROR" */
    '\x01','E','M','_','\xc3','\x1c',
/* 0x1be5f = "state " */
    's','t','a','t','e',' ',
/* 0x1be65 = "VERR_VMX_NO_VMX" */
    '\x01','\xe2','\x60','V','M','X',
/* 0x1be6b = "VERR_FILE_IO_ERROR" */
    '\x01','\xaa','I','O','_','\x1c',
/* 0x1be71 = "Invalid XML found." */
    '\x0c','X','M','L',' ','\x89',
/* 0x1be77 = "IPRT error." */
    'I','P','R','T',' ','\x85',
/* 0x1be7d = "VERR_ISOFS_UNSUPPORTED_ICB" */
    '\x01','\x97','\x1a','I','C','B',
/* 0x1be83 = "VERR_DBGC_PARSE_BUG" */
    '\x01','\xfd','\xe4','B','U','G',
/* 0x1be89 = "ISOMK_" */
    'I','S','O','M','K','_',
/* 0x1be8f = "VERR_DBGC_QUIT" */
    '\x01','\xfd','Q','U','I','T',
/* 0x1be95 = "Generic SPC error." */
    '\xa7','S','P','C',' ','\x85',
/* 0x1be9b = "Generic RSA error." */
    '\xa7','R','S','A',' ','\x85',
/* 0x1bea1 = "Long ASN." */
    'L','o','n','g',' ','\xf6',
/* 0x1bea7 = "VERR_TM_IPE_8" */
    '\x01','T','M','_','\x14','8',
/* 0x1bead = "VERR_TM_IPE_7" */
    '\x01','T','M','_','\x14','7',
/* 0x1beb3 = "VERR_TM_IPE_6" */
    '\x01','T','M','_','\x14','6',
/* 0x1beb9 = "VERR_TM_IPE_5" */
    '\x01','T','M','_','\x14','5',
/* 0x1bebf = "VERR_EM_NO_MEMORY" */
    '\x01','E','M','_','\x60','\xb6',
/* 0x1bec5 = "guest " */
    'g','u','e','s','t',' ',
/* 0x1becb = "VERR_DBGC_PARSE_NO_MEMORY" */
    '\x01','\xfd','\xe4','\x60','\xb6',
/* 0x1bed0 = "VERR_DBGC_IPE" */
    '\x01','\xfd','I','P','E',
/* 0x1bed5 = "Internal error #5." */
    '\x08','\x09','#','5','.',
/* 0x1beda = "VERR_NEM_IPE_9" */
    '\x01','\xee','_','\x14','9',
/* 0x1bedf = "VERR_NEM_IPE_8" */
    '\x01','\xee','_','\x14','8',
/* 0x1bee4 = "VERR_NEM_IPE_7" */
    '\x01','\xee','_','\x14','7',
/* 0x1bee9 = "VERR_NEM_IPE_6" */
    '\x01','\xee','_','\x14','6',
/* 0x1beee = "VERR_NEM_IPE_5" */
    '\x01','\xee','_','\x14','5',
/* 0x1bef3 = "VERR_NEM_IPE_4" */
    '\x01','\xee','_','\x14','4',
/* 0x1bef8 = "VERR_NEM_IPE_3" */
    '\x01','\xee','_','\x14','3',
/* 0x1befd = "Internal error #3." */
    '\x08','\x09','#','3','.',
/* 0x1bf02 = "VERR_CR_DIGEST_NOT_SUPPORTED" */
    '\x01','\x24','\xbf','\x06','\x83',
/* 0x1bf07 = "IOMMU" */
    'I','O','M','M','U',
/* 0x1bf0c = "Internal error #1." */
    '\x08','\x09','#','1','.',
/* 0x1bf11 = "page " */
    'p','a','g','e',' ',
/* 0x1bf16 = "VERR_ISOFS_UNKNOWN_FILE_TYPE" */
    '\x01','\x97','\x91','\xaa','\xb3',
/* 0x1bf1b = "does " */
    'd','o','e','s',' ',
/* 0x1bf20 = "size " */
    's','i','z','e',' ',
/* 0x1bf25 = "Unsupported CPU." */
    '\x98','C','P','U','.',
/* 0x1bf2a = "Internal error #7." */
    '\x08','\x09','#','7','.',
/* 0x1bf2f = "VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE" */
    '\x01','\xe9','\x1a','\xaa','\xb3',
/* 0x1bf34 = "MANY_" */
    'M','A','N','Y','_',
/* 0x1bf39 = "IPC error." */
    'I','P','C',' ','\x85',
/* 0x1bf3e = "VERR_IOMMU_IPE_9" */
    '\x01','\xfe','_','\x14','9',
/* 0x1bf43 = "VINF_" */
    'V','I','N','F','_',
/* 0x1bf48 = "Internal error #2." */
    '\x08','\x09','#','2','.',
/* 0x1bf4d = "VERR_DBGF_IPE_1" */
    '\x01','\xb9','_','\x14','1',
/* 0x1bf52 = "VWRN_" */
    'V','W','R','N','_',
/* 0x1bf57 = "Internal error #6." */
    '\x08','\x09','#','6','.',
/* 0x1bf5c = "VERR_IOMMU_IPE_8" */
    '\x01','\xfe','_','\x14','8',
/* 0x1bf61 = "Not supported." */
    'N','o','t',' ','\xa5',
/* 0x1bf66 = "Internal error no." */
    '\x08','\x09','n','o','.',
/* 0x1bf6b = "VERR_CR_X509_INTERNAL_ERROR" */
    '\x01','\x24','\xb7','\xc3','\x1c',
/* 0x1bf70 = "X509_" */
    'X','5','0','9','_',
/* 0x1bf75 = "VERR_IOMMU_IPE_7" */
    '\x01','\xfe','_','\x14','7',
/* 0x1bf7a = "VERR_IOMMU_IPE_6" */
    '\x01','\xfe','_','\x14','6',
/* 0x1bf7f = "VERR_IOMMU_IPE_5" */
    '\x01','\xfe','_','\x14','5',
/* 0x1bf84 = "VERR_ISOFS_NO_PD" */
    '\x01','\x97','\x60','P','D',
/* 0x1bf89 = "that " */
    't','h','a','t',' ',
/* 0x1bf8e = "VERR_IOMMU_IPE_4" */
    '\x01','\xfe','_','\x14','4',
/* 0x1bf93 = "VERR_IOMMU_IPE_3" */
    '\x01','\xfe','_','\x14','3',
/* 0x1bf98 = "VERR_IOMMU_IPE_1" */
    '\x01','\xfe','_','\x14','1',
/* 0x1bf9d = "VERR_" */
    'V','E','R','R','_',
/* 0x1bfa2 = "VERR_IOMMU_IPE_0" */
    '\x01','\xfe','_','\x14','0',
/* 0x1bfa7 = "VERR_IOMMU_IPE_2" */
    '\x01','\xfe','_','\x14','2',
/* 0x1bfac = "DBGC_" */
    'D','B','G','C','_',
/* 0x1bfb1 = "VERR_PGM_UNEXPECTED_PAGE_STATE" */
    '\x01','\x8c','\x88','\xce','\xf1',
/* 0x1bfb6 = "VERR_NEM_IPE_2" */
    '\x01','\xee','_','\x14','2',
/* 0x1bfbb = "VERR_NEM_IPE_1" */
    '\x01','\xee','_','\x14','1',
/* 0x1bfc0 = "VERR_NEM_IPE_0" */
    '\x01','\xee','_','\x14','0',
/* 0x1bfc5 = "VERR_INTERNAL_ERROR_5" */
    '\x01','\xc3','\x1c','_','5',
/* 0x1bfca = "VERR_INTERNAL_ERROR_4" */
    '\x01','\xc3','\x1c','_','4',
/* 0x1bfcf = "VERR_INTERNAL_ERROR_3" */
    '\x01','\xc3','\x1c','_','3',
/* 0x1bfd4 = "many " */
    'm','a','n','y',' ',
/* 0x1bfd9 = "VERR_SSM_INTEGRITY_SIZE" */
    '\x01','\xb0','\xf7','_','\xfa',
/* 0x1bfde = "ERROR" */
    'E','R','R','O','R',
/* 0x1bfe3 = "VERR_NO_VM_MEMORY" */
    '\x01','\x60','\xc6','_','\xb6',
/* 0x1bfe8 = "with " */
    'w','i','t','h',' ',
/* 0x1bfed = "Internal error #8." */
    '\x08','\x09','#','8','.',
/* 0x1bff2 = "Internal error #4." */
    '\x08','\x09','#','4','.',
/* 0x1bff7 = "VERR_SSM_INTEGRITY_VERSION" */
    '\x01','\xb0','\xf7','_','\xbc',
/* 0x1bffc = "VWRN_UNSUPPORTED_CPU" */
    '\xe6','\x1a','C','P','U',
/* 0x1c001 = "VERR_CR_PKCS7_INTERNAL_ERROR" */
    '\x01','\x24','\xe5','\xc3','\x1c',
/* 0x1c006 = "VERR_INTERNAL_ERROR_2" */
    '\x01','\xc3','\x1c','_','2',
/* 0x1c00b = "been " */
    'b','e','e','n',' ',
/* 0x1c010 = "ASN1_" */
    'A','S','N','1','_',
/* 0x1c015 = "VERR_INVALID_RPL" */
    '\x01','\x05','R','P','L',
/* 0x1c01a = "Internal error #9." */
    '\x08','\x09','#','9','.',
/* 0x1c01f = "FILE_" */
    'F','I','L','E','_',
/* 0x1c024 = "FOUND" */
    'F','O','U','N','D',
/* 0x1c029 = "Generic invalid state error." */
    '\xa7','\x8f','\xcc','\x85',
/* 0x1c02d = "VERR_SSM_IPE_2" */
    '\x01','\xb0','\x14','2',
/* 0x1c031 = "VERR_SSM_IPE_1" */
    '\x01','\xb0','\x14','1',
/* 0x1c035 = "ANS." 